$(document).ready(function() {
    selectbox();
    calendarbox();
});

function maxLengthCheck(object){
    if (object.value.length > object.maxLength){
      //object.maxLength : 매게변수 오브젝트의 maxlength 속성 값입니다.
      object.value = object.value.slice(0, object.maxLength);
    }    
  }

function calendarbox() {
    if(typeof $.datepicker != "undefined"){
		$.datepicker.regional['ko'] = {
	         closeText: '닫기',
	         prevText: '이전달',
	         nextText: '다음달',
	         currentText: '오늘',
	         monthNames: ['1','2','3','4','5','6', '7','8','9','10','11','12'],
	         monthNamesShort: ['1','2','3','4','5','6', '7','8','9','10','11','12'],
	         dayNamesShort: ['일','월','화','수','목','금','토'],
	         dayNamesMin: ['일','월','화','수','목','금','토'],
	         weekHeader: 'Wk',
	         dateFormat: 'yy-mm-dd',
              yearSuffix: '.',
	         firstDay: 0,
	         isRTL: false,
	         showMonthAfterYear: true};
	    $.datepicker.setDefaults($.datepicker.regional['ko']);
	    	
		$( ".datepicker" ).datepicker({
			showOn: "button",
	        buttonImage:  "img/ico_calendar.png",
	        buttonImageOnly:true,
	        changeMonth: true,
	        changeYear: true,
	        dateFormat:"yy-mm-dd"
		});
	}
}

function selectbox() {
    $(".select_box").click(function() {
        var select = $(this);
        
        //드롭다운 열기
        select.addClass("open").next('.select_box_dropDown').slideDown(100).addClass("open");
        
        //다른영역 클릭 시 닫기
        $(document).mouseup(function(e) {
            var seting = $(".select_box_dropDown");
            if (seting.has(e.target).length === 0) {
                seting.removeClass("open").slideUp(100);
                select.removeClass("open");
            }
        });
    
        $(".select_box_dropDown a").click(function() {
            var option = $(this).text();
            
            //클릭 시 드롭다운 닫기
            $(".select_box_dropDown a").removeClass('selected');
            $(".select_box_dropDown").removeClass("open").slideUp(100);
            select.removeClass("open");
            $(this).addClass('selected');
            
            //select에  text 넣기
            select.text(option);
        });
    });
}