
var fMarkingCardNum = "";
var businessNumber;
var productNumber;
var referenceNo;
var useType = '';
var supplyAmount;
var vatAmount;
var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function() {
        $(document).on("keyup", ".uPayN", function() {
            $(this).number(true);
        });
        if ($(".uPayN").length > 0) {
            $(".uPayN").number(true);
        }
        app.setSignButton(false);
        //상단 표기 상태 변경
        cordova.plugins.finPlugin.getUseType("", function(res){
            if(0 < res.length){
                if('연동형' == res){
                    useType = '연동형';
                    $("#hd_title").html("<a href='#' onclick='app.backbuttonAction();'><h3 class='btnPre'><span class='blind'>이전</span></h3></a><h3 class='title'>신용카드 결제 취소</h3><h3 id='battery' class='battery'><span></span></h3>");
                    //연동형 인경우 스키마 값 체크
                    cordova.plugins.finPlugin.checkScheme("", function(isScheme){
                        //스키마 값이 있는 경우 해당 번호 기반으로 인증 정보를 가져와야 한다
                        app.getSchemeData();
                    }, function(error){
                        //스키마 값이 없는 경우 해당 앱에 정보 없음 Callback 을 한다.
                    });
                }else {
                    useType = '통합형';
                    //통합형 인 경우 연결된 모든 사업장을 가져온다
                    app.getCancelData();
                }
            }
        }, null);
    },
    eventInit:function(){

    },
    otherInit:function(){
        if(isIphone()){

        }else {
            document.addEventListener("backbutton", app.backbuttonAction, false);
        }
        UPDATE_CHECK();
    },
    backbuttonAction:function(){
        var isPopupClose = false;
        if ($("#layerPopup.Popup12").is(':visible')){
            isPopupClose = true;
            app.hideWarnningPopup();
        }
        if(!isPopupClose){
            cordova.plugins.finPlugin.backButton("", null, null);
        }
    },
    setBattery:function(battery){
        $('#battery').html(battery);
    },
    getSchemeData:function(){
        //스키마 값 가져오기
        cordova.plugins.finPlugin.getSchemeData("", function(schemeData){
            app.setSchemeData(schemeData);
        },function(error){
            if(isIphone()) cordova.plugins.finPlugin.moveStack(SET01.DATA,null, null);
        });
    },
    setSchemeData:function(data){
        //스키마 값 셋팅 하기 (취소 데이터와 동일하게 한다)
        
        var cancelData = JSON.parse(data);
        //console.log('}}}}}}}}}}}}} setSchemeData :: cancelData = ' + cancelData);
       if(isIphone())
       {
           $('#approvalNumber').val(cancelData.srcConfmNo);
           $('#tradeDate').val(cancelData.srcConfmDe);
           $('#uSum').val(cancelData.totalAmount);
           $('#uInstPlan').val(cancelData.instlmtMonth);
           $('#companyName').val(cancelData.businessName);
           $('#catId').val(cancelData.readerNumber);
           businessNumber = cancelData.businessNumber;
           productNumber = cancelData.productNumber;
           if(cancelData.referenceNo){
                referenceNo = cancelData.referenceNo;
                app.setReferenceNo(referenceNo);
           }else {
               //값 체크 로직 추가 필요
               setTimeout(function(){
                   app.requestReadCard();
               },500);
           }
       }else
       {
           $('#approvalNumber').val(cancelData.approvalNumber);
           $('#tradeDate').val(cancelData.tradeDate);
           $('#uSum').val(cancelData.totalAmount);
           $('#uInstPlan').val(cancelData.instPlan);
           $('#companyName').val(cancelData.companyName);
           $('#catId').val(cancelData.catId);
           if(cancelData.referenceNo){
                referenceNo = cancelData.referenceNo;
                app.setReferenceNo(referenceNo);
           }else {
               //값 체크 로직 추가 필요
               setTimeout(function(){
                   app.requestReadCard();
               },500);
           }
       }
    },
    getCancelData:function(){
        var successCallback = function(res){
            //성공 하고 나면 01_02_2.html 화면으로 이동
            //화면 이동 후 사업장 리로드
            //cordova.plugins.finPlugin.moveStack(SET02_1.DATA,null, null);
            
            app.setCancelData(res);
        };
        var failureCallback = function(error){
            //실패 시 실패 팝업 발생
            open_PopupError(error);
        };
        //취소 데이터 가져오기 (통합형에 사용)
        if(isIphone())
        {
            var dt = {"TYPE":"COMMON_CARD"};
            cordova.plugins.finPlugin.getCancelData(dt, successCallback, failureCallback);
        }else
        {
           
            cordova.plugins.finPlugin.getCancelData("", successCallback, failureCallback);
        }
        
    },
    setCancelData:function(data){
        //취소 데이터 화면에 셋팅 하기
        var cancelData = JSON.parse(data);
        if(isIphone())
        {
            $('#approvalNumber').val(cancelData['approvalNumber']);
            $('#tradeDate').val(cancelData['dateOfApproval']);
            $('#uSum').val(cancelData['totalAmount']);
            $('#uInstPlan').val(cancelData['installment']);
            $('#companyName').val(cancelData['businessName']);
            $('#catId').val(cancelData['readerNumber']);
            businessNumber = cancelData['businessNumber'];
            productNumber = cancelData['productNumber'];
            if(cancelData.referenceNo){
                referenceNo = cancelData.referenceNo;
                app.setReferenceNo(cancelData.referenceNo);
            }else {
                //값 체크 로직 추가 필요
                setTimeout(function(){
                    app.requestReadCard();
                },500);
            }
        }else
        {
            $('#approvalNumber').val(cancelData.approvalNumber);
            $('#tradeDate').val(cancelData.tradeDate);
            $('#uSum').val(cancelData.totalAmount);

            supplyAmount = cancelData.supplyAmount;
            vatAmount = cancelData.vatAmount;

            $('#uInstPlan').val(cancelData.instPlan);
            $('#companyName').val(cancelData.companyName);
            $('#catId').val(cancelData.catId);
            if(cancelData.referenceNo){
                referenceNo = cancelData.referenceNo;
                app.setReferenceNo(cancelData.referenceNo);
            }else {
                //값 체크 로직 추가 필요
                setTimeout(function(){
                    app.requestReadCard();
                },500);
            }
        }
    },
    changeAmount:function(_val){
        //가격 변동 시 계속 갱신
    },
    changeInst:function(_val){
        //할부 개월 변동 시 계속 갱신
    },
    setCardInfo:function(_val){

        fMarkingCardNum = _val;
        var nums = replaceAll(_val,'F','*');
        if($.isNumeric(nums)){
            nums = maskAsterisk(_val);
        }
        $("#uCardN").val(nums);
        if(-1 != nums.indexOf('*')){
            close_Progress();
            close_Fallback();
            app.setSignButton(true);
        }
    },
    setReferenceNo:function(_val){
        close_Progress();
        $("#uCardN").val(_val);
        close_Fallback();
        app.setSignButton(true);
    },
    setCardNum:function(res){
        app.setCardInfo(res);
    },
    requestReadCard:function(){
        var price = $("#uSum").val(); // 판매금액 입력값
        var instPlan = $("#uInstPlan").val(); // 할부개월 입력값
        var catId = $('#catId').val(); // 상호 선택값
        if(price == "" || catId == ""){
            app.showWarnningPopup();
        }else{
            app.setCardInfo('카드 읽기를 시작 합니다.');
            showToastMessage('카드 읽기를 시작 합니다.', 10000);
            var sendData = {
                "price":replaceAll(price, ",", ""),
                "instPlan":instPlan,
                "catId":catId,
                "sepa":"cancel_common_card"
            };
            cordova.plugins.finPlugin.requestReadCard(sendData, function(res){
                app.setCardInfo(res);
            }, function(error){
                close_Progress();
                showToastMessage(error);
            });
        }
    },
    requestSign:function(){
        var price = $("#uSum").val(); // 판매금액 입력값
        var month = $("#uInstPlan").val(); // 할부개월 입력값
        var company = $('#catId').val(); // 상호 선택값
        var cardnum = $("#uCardN").val(); // 카드번호 입력값

        if(price == "" || company == "" || cardnum == ""){
            app.showWarnningPopup();
        }else{
            var sendData = {
                "catId":$('#catId').val(),
                "price":replaceAll($("#uSum").val(), ",", ""),
                "sepa":"cancel_common_card"
            };
            if(referenceNo){
                app.requestPayment("");
            }else {
                cordova.plugins.finPlugin.checkNoCVMValue(sendData, function(res){
                    if(1 > res){
                        app.requestPayment("");
                    }else {
                        SIGN.DATA.SUBTITLE = $('.title').html();
                        SIGN.DATA.CARDINFO = fMarkingCardNum;
                        SIGN.DATA.SEPA = "CANCEL_COMMON_CARD";
                        
                        if(isIphone())
                        {
                              var sendData = {
                                  "SUBTITLE":$('.title').html(),
                                  "CARDINFO":fMarkingCardNum,
                                  "STACK_ID":"SIGN",
                                  "STACK_URL":"04_01_2.html",
                                  "SEPA":"CANCEL_COMMON_CARD",
                                  "merchant":productNumber+"|"+businessNumber+"|"+$('#catId').val(),
                                  "price":$("#uSum").val(),
                                  "installment":$("#uInstPlan").val(),
                                  "approvalNumber":$('#approvalNumber').val(),
                                  "dateOfApproval":$('#tradeDate').val()
                              };
                              cordova.plugins.finPlugin.moveStack(sendData,null, null);
                        }else
                        {
                              cordova.plugins.finPlugin.requestSignData(SIGN.DATA,function(signData){
                                                     app.requestPayment(signData);
                                                 }, function(error){
                                                     showToastMessage(error);
                                                 });
                        }
                        
                       
                    }
                }, function(error){
                    showToastMessage(error);
                });
            }
            
        }
    },
    requestPayment:function(signData){
        open_PopupError('결제 취소 요청 중 입니다.');
        var sendData = {
            "catId":$('#catId').val(),
            "price":replaceAll($("#uSum").val(), ",", ""),
            "month":$("#uInstPlan").val(),
            "sign":signData,
            "approvalNumber":$("#approvalNumber").val(),
            "approvalDate":$("#tradeDate").val(),
            "sepa":"cancel_common_card",
            "businessNumber":businessNumber,
            "productNumber":productNumber,
            "installment":$("#uInstPlan").val(),
            "referenceNo":referenceNo
        };
        
//        if(isIphone())
//        {
            cordova.plugins.finPlugin.requestPayment(sendData, function(res){
                if(isIphone()){
                    close_PopupError();
                }else {
                    open_PopupError('취소가 완료 되었습니다.');
                    RECEIPT_CARD.DATA.RECEIPT_ID = res;
                    cordova.plugins.finPlugin.moveStack(RECEIPT_CARD.DATA,null, null);
                }
            }, function(error){
                if(error) open_PopupError(error);
                else open_PopupError('취소 요청에 실패 하였습니다.');
                if('통합형' == useType){
                    cordova.plugins.finPlugin.backButton("", null, null);
                }
            });
//        }else
//        {
//            cordova.plugins.finPlugin.requestPayment(sendData, function(res){
//                open_PopupError('취소가 완료 되었습니다.');
//                RECEIPT_CARD.DATA.RECEIPT_ID = res;
//                cordova.plugins.finPlugin.moveStack(RECEIPT_CARD.DATA,null, null);
//            }, function(error){
//                if(error) open_PopupError(error);
//                else open_PopupError('취소 요청에 실패 하였습니다.');
//
//            });
//        }
        
        
    },
    setSignButton:function(isSign){
        if(isSign == true) {
            var sendData = {
                "catId":$('#catId').val(),
                "price":replaceAll($("#uSum").val(), ",", ""),
                "sepa":"cancel_common_card"
            };
            if(referenceNo){
                $(".SaveBtnWrap02").html( "<a href='javascript:app.requestSign();' class=''>승인요청(무서명)</a>");
            }else {
                cordova.plugins.finPlugin.checkNoCVMValue(sendData, function(res){
                    if(1 > res){
                        $(".SaveBtnWrap02").html( "<a href='javascript:app.requestSign();' class=''>승인요청(무서명)</a>");
                    }else {
                        $(".SaveBtnWrap02").html( "<a href='javascript:app.requestSign();' class=''>서명요청</a>");
                    }
                }, function(error){
                    showToastMessage(error);
                });
            }
        }else {
            $(".SaveBtnWrap02").html( "<a href='javascript:app.requestReadCard();' class=''>카드읽기</a>");
        }
    },
    showWarnningPopup:function(){
        close_Progress();
        $('#layerPopup.Popup12').show();
    },
    hideWarnningPopup:function(){
        $('#layerPopup.Popup12').hide();
    },errorOfPaymentByNetwork:function()
    {
        close_PopupError();
        open_PopupError('네트워크 문제로 인하여 결제 요청에 실패 하였습니다.');
        cordova.plugins.finPlugin.backButton("", null, null);
    }
};

app.initialize();