var catId = "";
var useType = '';
var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function(){
        $(document).on("keyup", ".uPayN", function() {
            $(this).number(true);
        });
        if ($(".uPayN").length > 0) {
            $(".uPayN").number(true);
        }
        //상단 표기 상태 변경
        cordova.plugins.finPlugin.getUseType("", function(res){

            if(0 < res.length){
                if('연동형' == res){
                    useType = '연동형';
                    $("#hd_title").html("<a id='backBtn' onclick='app.backbuttonAction();'><h3 class='btnPre'><span class='blind'>이전</span></h3></a><h3 class='title'>카카오페이 결제</h3><h3 id='battery' class='battery'><span></span></h3>");
                }else {
                    useType = '통합형';
                }
            }
        }, null);
//        if(isIphone()){
//          cordova.plugins.finPlugin.getAliCost("", function(res){
//              $("#uSum").val(res);
//          }, function(error){
//              alert(error);
//          });
//        }else {
          app.setKakaoManualData();
//        }
    },
    eventInit:function(){
       
    },
    otherInit:function(){
        document.addEventListener("backbutton", app.backbuttonAction, false);
    },
    backbuttonAction:function(){
        var isPopupClose = false;
        if ($("#layerPopup.Popup12").is(':visible')){
            isPopupClose = true;
            app.hideWarnningPopup();
        }
        if(!isPopupClose){
            cordova.plugins.finPlugin.backButton("", null, null);
        }
    },
    setKakaoManualData:function(){
        cordova.plugins.finPlugin.getKakaoManualAmount("", function(manualData){
            var dataObject = JSON.parse(manualData);
            $("#uSum").val(dataObject.price);
            catId = dataObject.catId;
        }, function(error){
            showToastMessage(error);
        });
    },
    changeKakaoPayNum:function(uniqNum){
        if(!isIphone()){
            cordova.plugins.finPlugin.changeKakaoPayNum(uniqNum, null, null);
        }
    },
    hideWarnningPopup:function(){
        $('#layerPopup.Popup12').hide();
    },
    requestPayment:function(){
        if (isClickedButton()) {
            return;
        }
        var price = replaceAll($("#uSum").val(),",",""); // 판매금액 입력값
        var uniqNum = $("#uniqueNumber").val();
        if(price == "" || uniqNum == ""){
            $("#layerPopup.Popup12").show();
        }else{
            var sendData = {
                "price":price,
                "catId":catId,
                "kakaoUniqNum":uniqNum
            };
            cordova.plugins.finPlugin.requestKakaoInquiry(sendData,
            function(res){
                close_PopupError();
                if(isIphone()){
                    var dataObject = JSON.parse(res);
                    if("C" == dataObject.kakaoPayType){
                        KAKAO_PAY.DATA.SUBTITLE = "카카오페이 승인결제";
                    }else {
                        KAKAO_PAY.DATA.SUBTITLE = "카카오머니 승인결제";
                    }
                    KAKAO_PAY.DATA.catId = dataObject.catId;
                    KAKAO_PAY.DATA.storeName = dataObject.storeName;
                    KAKAO_PAY.DATA.companyNumber = dataObject.companyNumber;
                    KAKAO_PAY.DATA.kakaoPayType = dataObject.kakaoPayType;
                    KAKAO_PAY.DATA.discount = dataObject.discount;
                    KAKAO_PAY.DATA.price = dataObject.price;
                    KAKAO_PAY.DATA.referenceNo = dataObject.referenceNo;
                    cordova.plugins.finPlugin.moveStack(KAKAO_PAY.DATA,null, null);
                }else {
                    if("C" == res){
                        KAKAO_PAY.DATA.SUBTITLE = "카카오페이 승인결제";
                    }else {
                        KAKAO_PAY.DATA.SUBTITLE = "카카오머니 승인결제";
                    }
                    cordova.plugins.finPlugin.moveStack(KAKAO_PAY.DATA,null, null);
                }
            },
            function(error){
                if(error) open_PopupError(error);
                else open_PopupError('결제 요청에 실패 하였습니다.');
                if('통합형' == useType){
                    cordova.plugins.finPlugin.backButton("", null, null);
                }
            });
        }
    }
};

app.initialize();

