var peristalsis = false;
var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();

    },
    itemInit:function() {
        //상단 표기 상태 변경
        cordova.plugins.finPlugin.getUseType("", function(res){
            if(0 < res.length){
                if('연동형' == res){
                    peristalsis = true;
                    app.initSegmentForPeristalsis();
                    if(isIphone()){
                      $("#hd_title").html("<a href='#' onclick='app.backbuttonAction();' ><h3 class='btnPre'><span class='blind'>이전</span></h3></a><h3 class='title'>부가세 설정</h3><h3 id='battery' class='battery'><span></span></h3>");
                      cordova.plugins.finPlugin.checkBattery("", function(battery){
                          updateBattery(true, battery)
                      },function(error){
                          updateBattery(false, '')
                      });
                    }else {
                      $("#hd_title").html("<h3 class='title'>부가세 설정</h3><h3 id='battery' class='battery'><span></span></h3>");
                    }
                }else {
                    app.initSegmentForIntegrated();
                }
            }
        }, null);

        cordova.plugins.finPlugin.getTaxData("", function(taxData){

            var responseData = JSON.parse(taxData);
            var isTax =  responseData.isTax;
            var isInclude = responseData.isInclude;
            var taxRate = responseData.taxRate;

            app.taxFree(isTax);
            $("#slt_tax").val(isTax).prop("selected", true);
            $("#slt_tax_set").val(isInclude).prop("selected", true);
            $("#vat_rate").val(taxRate);
        }, null);
    },
    eventInit:function(){
        $("#slt_tax").change(function(){
            app.taxFree($("#slt_tax option:selected").val());
        });
        $('#taxSave').on('click',function(){
            //Scan Stop
            app.taxSave();
        });
    },
    otherInit:function(){
        if(isIphone()){

        }else {
            document.addEventListener("backbutton", app.backbuttonAction, false);
        }
        UPDATE_CHECK();
    },
    backbuttonAction:function(){
        var isPopupClose = false;
        if(!isPopupClose){
            cordova.plugins.finPlugin.backButton("", null, null);
        }
    },
    setBattery:function(battery){
        $('#battery').html(battery);
    },
    taxSave:function(){
        if(peristalsis)
        {
            //연동형
            var rate = $("#vat_rate").val();
            if(rate){
                if(0 == Number(rate)){ $("#vat_rate").val(10); }
            }else $("#vat_rate").val(10);

            if(isIphone())
            {
                var taxData = {
                    "isTax":$("#slt_tax option:selected").val(),
                    "isInclude":$("#slt_tax_set option:selected").val(),
                    "tax_rate":$("#vat_rate").val()
                };
//                cordova.plugins.finPlugin.setTaxData(taxData, null, null);
                
                cordova.plugins.finPlugin.setTaxData(taxData, function(res){
                    open_PopupError('저장되었습니다.');
                    setOptions(res);
                }, null);
            }else
            {
                var taxData = {
                    "isTax":$("#slt_tax option:selected").val() == 'taxation',
                    "isInclude":$("#slt_tax_set option:selected").val() == 'include',
                    "tax_rate":$("#vat_rate").val()
                };
                cordova.plugins.finPlugin.setTaxData(taxData, function(res){
                    open_PopupError('저장되었습니다.');
                    setOptions(res);
                }, null);
            }
        }else {
            //통합형
            var rate = $("#vat_rate").val();
            if(rate){
                if(0 == Number(rate)){
                    open_PopupError('부가세율을 0으로 설정 할 수 없습니다. 부가세율을 입력 해 주시기 바랍니다.');
                }else {
                    if(isIphone())
                    {
                        var taxData = {
                            "isTax":$("#slt_tax option:selected").val(),
                            "isInclude":$("#slt_tax_set option:selected").val(),
                            "tax_rate":$("#vat_rate").val()
                        };
//                        cordova.plugins.finPlugin.setTaxData(taxData, null, null);
                        cordova.plugins.finPlugin.setTaxData(taxData, function(res){
                            open_PopupError('저장되었습니다.');
                            setOptions(res);
                        }, null);
                    }else
                    {
                        var taxData = {
                            "isTax":$("#slt_tax option:selected").val() == 'taxation',
                            "isInclude":$("#slt_tax_set option:selected").val() == 'include',
                            "tax_rate":$("#vat_rate").val()
                        };
                        cordova.plugins.finPlugin.setTaxData(taxData, function(res){
                            open_PopupError('저장되었습니다.');
                            setOptions(res);
                        }, null);
                    }
                }
            }else {
                open_PopupError('부가세율이 입력되지 않았습니다. 부가세율을 입력 해 주시기 바랍니다.');
            }
        }
    },
    mobileIntegrity:function(){
        var data = SET03.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },
    mobileSetting:function(){
        var data = SET01.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },mobileCert:function(){
        var data = SET02.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },mobileUserSet:function(){
        var data = SET05.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },
    taxFree:function(_val){
        var isDisabled = true;
        if("taxation" == _val){
            isDisabled = false;
        }
        $("#slt_tax_set").attr("disabled",isDisabled);
        $("#vat_rate").attr("disabled",isDisabled);
    },
    initSegmentForPeristalsis:function(){
        //연동형 전용 옵션
        $('#tax_include_wrap').hide();
        $('#tax_rate_wrap').hide();
    },
    initSegmentForIntegrated:function(){
        //통합형 전용 옵션
        $('#tax_include_wrap').show();
        $('#tax_rate_wrap').show();
    }
};

app.initialize();
