var startDate;
var endDate;
var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function() {
        startDate = app.getToday();
        endDate = app.getToday();
        $("#datepickerSt").val(startDate);
        $("#datepickerEd").val(endDate);
        app.searchReceipt();
    },
    eventInit:function(){
        //검색버튼
        /*
        $('#searchReceipt').on('click',function(){
            app.searchReceipt();
        });
         */
    },
    otherInit:function(){
        
        document.addEventListener("backbutton", app.backbuttonAction, false);
    },
    backbuttonAction:function(){
        

        if(isIphone())
        {
           var isPopupClose = false;
            if ($("#layerPopup.Popup12").is(':visible')){
                isPopupClose = true;
                app.hideWarnningPopup();
            }
            if(!isPopupClose){
                cordova.plugins.finPlugin.backButton("", null, null);
            }
        }else
        {
            cordova.plugins.finPlugin.moveStack(MAIN.DATA, null, null);
        }
        
        
    },
    getToday:function(){
        var today = new Date();
        var yyyy = today.getFullYear();
        var mm = today.getMonth()+1; // getMonth() is zero-based
        var dd  = today.getDate();
        var month = '';
        var days = '';
        if(10 > mm) month = '0' + mm;
        else month = '' + mm;
        if(10 > dd) days = '0' + dd;
        else days = '' + dd;
        return yyyy + "-" + month + "-" + days;
    },
    searchReceipt:function(){
        var receipData = {
            "payKind":$("#kind option:selected").val(),
            "authType":$("#payKind option:selected").val(),
            "startDate":$("#datepickerSt").val(),
            "endDate":$("#datepickerEd").val(),
            "approvalNum":$("#uSum").val()
        };
        cordova.plugins.finPlugin.searchReceipt(receipData, function(res){
            app.searchReceiptList(res);
        }, function(error){

        });
    },
    searchReceiptList:function(res){

        if(isIphone())
        {
            var dataArray = res['receiptList'];
             
             if(dataArray.length == 0) {
                 $("#receipt_list").html('');
                 return;
             }
            
             var data = "";
             while (dataArray.length > 0)
             {
                 var dataObject = JSON.parse(dataArray.pop());
                 
                 var receiptTxt = dataObject['text'];
                 var receiptAmt = dataObject['amount'];
                 var receiptID = dataObject['receiptNumber'];
                 var receiptDate = dataObject['date'];
                 var receiptTime = dataObject['time'];
                 
                 
                 if (receiptTxt.indexOf("취소") != -1) {
                     data = data + "<div class='result_Wrap'> <span> <ul class='resultTxtWrap'><li> " + receiptTxt
                             + "</li><li>" + receiptDate + "</li><li>" + receiptTime
                             + "</li></ul></span><a href='#' onclick='app.gotoReceipt(\""+ receiptTxt + "\" , \"" + receiptID + "\");'><ul class='CheckAm'><li style='color:orange;text-decoration:line-through;'>"
                             + receiptAmt + "</li></ul><span></a></div> ";
                 } else {
                     data = data + "<div class='result_Wrap'> <span> <ul class='resultTxtWrap'><li> " + receiptTxt
                             + "</li><li>" + receiptDate + "</li><li>" + receiptTime
                             + "</li></ul></span><a href='#' onclick='app.gotoReceipt(\""+ receiptTxt + "\" , \"" + receiptID + "\");'><ul class='CheckAm'><li>"
                             + receiptAmt + "</li></ul></a></div> ";
                 }
                 
             }
            
        }else
        {
            var jsonarray_receiptItems = res;
            if(jsonarray_receiptItems == null) return;

            var dataArray = JSON.parse(jsonarray_receiptItems);
            if(dataArray.length == null) return;

            var data = "";
            while (dataArray.length > 0) {
                var dataObject = dataArray.pop();
                if (dataObject.kind.indexOf("취소") != -1) {
                    data = data + "<div class='result_Wrap'> <span> <ul class='resultTxtWrap'><li> " + dataObject.kind
                            + "</li><li>" + dataObject.date + "</li><li>" + dataObject.time
                            + "</li></ul></span><a href='#' onclick='app.gotoReceipt(\""+ dataObject.kind + "\" , \"" + dataObject.id + "\")'><ul class='CheckAm'><li style='color:orange;text-decoration:line-through;'>"
                            + dataObject.amount + "</li></ul><span></a></div> ";
                } else {
                    data = data + "<div class='result_Wrap'> <span> <ul class='resultTxtWrap'><li> " + dataObject.kind
                            + "</li><li>" + dataObject.date + "</li><li>" + dataObject.time
                            + "</li></ul></span><a href='#' onclick='app.gotoReceipt(\""+ dataObject.kind + "\" , \"" + dataObject.id + "\");'><ul class='CheckAm'><li>"
                            + dataObject.amount + "</li></ul></a></div> ";
                }
            }
        }
        $("#receipt_list").html(data);
    },
    gotoReceipt:function(authType, receiptId){
        
        var receiptStack;
        var type = authType.split(" ")[0];
        
        if(isIphone())
        {
            if("신용카드" == type){
                
                if(-1 != authType.indexOf("취소"))
                {
                    RECEIPT_CARD_CAN.DATA.RECEIPT_ID = receiptId;
                    receiptStack = RECEIPT_CARD_CAN.DATA;
                }else
                {
                    RECEIPT_CARD.DATA.RECEIPT_ID = receiptId;
                    receiptStack = RECEIPT_CARD.DATA;
                }
                
            }else if("은련카드" == type){
                if(-1 != authType.indexOf("취소"))
                {
                    RECEIPT_UNION_CAN.DATA.RECEIPT_ID = receiptId;
                    receiptStack = RECEIPT_UNION_CAN.DATA;
                }else
                {
                    RECEIPT_UNION.DATA.RECEIPT_ID = receiptId;
                    receiptStack = RECEIPT_UNION.DATA;
                }
                
            }
            else if("현금영수증" == type || -1 != type.indexOf("현금")){
                if(-1 != authType.indexOf("취소"))
                {
                    RECEIPT_CASH_CAN.DATA.RECEIPT_ID = receiptId;
                    receiptStack = RECEIPT_CASH_CAN.DATA;
                }else
                {
                    RECEIPT_CASH.DATA.RECEIPT_ID = receiptId;
                    receiptStack = RECEIPT_CASH.DATA;
                }
            }else if("알리페이" == type){
                if(-1 != authType.indexOf("취소"))
                {
                    RECEIPT_ALI_CAN.DATA.RECEIPT_ID = receiptId;
                    receiptStack = RECEIPT_ALI_CAN.DATA;
                }else
                {
                    RECEIPT_ALI.DATA.RECEIPT_ID = receiptId;
                    receiptStack = RECEIPT_ALI.DATA;
                }
            }else if("위챗페이" == type){
                if(-1 != authType.indexOf("취소"))
                {
                    RECEIPT_WECHAT_CAN.DATA.RECEIPT_ID = receiptId;
                    receiptStack = RECEIPT_WECHAT_CAN.DATA;
                }else
                {
                    RECEIPT_WECHAT.DATA.RECEIPT_ID = receiptId;
                    receiptStack = RECEIPT_WECHAT.DATA;
                }
            } else if("카카오페이"==type){
                RECEIPT_KAKAO_PAY.DATA.RECEIPT_ID = receiptId;
                receiptStack = RECEIPT_KAKAO_PAY.DATA;
            }else  if("카카오머니"==type){
               RECEIPT_KAKAO_MONEY.DATA.RECEIPT_ID = receiptId;
               receiptStack = RECEIPT_KAKAO_MONEY.DATA;
           }
        }else
        {
            if("신용카드" == type || "은련카드" == type){
                RECEIPT_CARD.DATA.RECEIPT_ID = receiptId;
                receiptStack = RECEIPT_CARD.DATA;
            }else if("현금영수증" == type || -1 != type.indexOf("현금")){
                RECEIPT_CASH.DATA.RECEIPT_ID = receiptId;
                receiptStack = RECEIPT_CASH.DATA;
            }else if("알리페이" == type){
                RECEIPT_ALI.DATA.RECEIPT_ID = receiptId;
                receiptStack = RECEIPT_ALI.DATA;
            }else if("위챗페이" == type){
                RECEIPT_WECHAT.DATA.RECEIPT_ID = receiptId;
                receiptStack = RECEIPT_WECHAT.DATA;
            }else if("카카오페이" == type){
                RECEIPT_KAKAO_PAY.DATA.RECEIPT_ID = receiptId;
                receiptStack = RECEIPT_KAKAO_PAY.DATA;
            }else if("카카오머니" == type){
                RECEIPT_KAKAO_MONEY.DATA.RECEIPT_ID = receiptId;
                receiptStack = RECEIPT_KAKAO_MONEY.DATA;
            }else if("제로페이" == type){
                RECEIPT_ZERO.DATA.RECEIPT_ID = receiptId;
                receiptStack = RECEIPT_ZERO.DATA;
            }
        }
        cordova.plugins.finPlugin.moveStack(receiptStack, null, null);
    }
};

app.initialize();