var useType = '';
var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function(){
        $(document).on("keyup", ".uPayN", function() {
           $(this).number(true);
       });
       if ($(".uPayN").length > 0) {
           $(".uPayN").number(true);
       }
        //상단 표기 상태 변경
        cordova.plugins.finPlugin.getUseType("", function(res){
                                             
            if(0 < res.length){
                if('연동형' == res){
                    useType = '연동형';
                    $("#hd_title").html("<a id='backBtn' onclick='app.backbuttonAction();'><h3 class='btnPre'><span class='blind'>이전</span></h3></a><h3 class='title'>위챗페이 결제</h3><h3 id='battery' class='battery'><span></span></h3>");
                    //연동형 인경우 스키마 값 체크
                    cordova.plugins.finPlugin.checkScheme("", function(isScheme){
                        //스키마 값이 있는 경우 해당 번호 기반으로 인증 정보를 가져와야 한다
                        app.getSchemeData();
                    }, function(error){
                        //스키마 값이 없는 경우 해당 앱에 정보 없음 Callback 을 한다.
                    });
                }else {
                    //통합형 인 경우 연결된 모든 사업장을 가져온다
                    useType = '통합형';
                    app.getAllBizData();
                }
            }
        }, null);
    },
    eventInit:function(){
       
    },
    otherInit:function(){
        document.addEventListener("backbutton", app.backbuttonAction, false);
        UPDATE_CHECK();
    },
    backbuttonAction:function(){
        var isPopupClose = false;
        if ($("#layerPopup.Popup12").is(':visible')){
            isPopupClose = true;
            app.hideWarnningPopup();
        }
        if(!isPopupClose){
            cordova.plugins.finPlugin.backButton("", null, null);
        }
    },
    getSchemeData:function(){
        cordova.plugins.finPlugin.getSchemeData("", function(schemeData){
            app.setSchemeData(schemeData);
        },function(error){
            if(isIphone()) cordova.plugins.finPlugin.moveStack(SET01.DATA,null, null);
        });
    },
    setSchemeData:function(schemeData){
        var dataObject = JSON.parse(schemeData);
        
        if(isIphone())
        {
            $("#uSum").val(dataObject['totalAmount']);
            app.setDisableAmount(true);
            $("#slt_company").html('');
            var valuer = dataObject['productNumber'] + "|" + dataObject['businessNumber'] + "|" + dataObject['readerNumber'];
             
            var data = "<option value='" + valuer + "'>" + dataObject['businessName'] + "(" + dataObject['businessNumber'] + ")</option>";
            $("#slt_company").html(data);
            $("#slt_company").val(valuer).prop("selected", true);
            app.setDisableMerchant(true);

        }else
        {
            $("#uSum").val(dataObject.totalAmount);
            app.setDisableAmount(true);
            $("#slt_company").html('');
            var data = "<option value='" + dataObject.catId + "'>" + dataObject.storeName + "(" + dataObject.companyNumber + ")</option>";
            $("#slt_company").html(data);
            $("#slt_company").val(dataObject.catId).prop("selected", true);
            app.setDisableMerchant(true);
        }
    },
    getAllBizData:function(){
        var successCallback = function(res){
            //성공 하고 나면 01_02_2.html 화면으로 이동
            //화면 이동 후 사업장 리로드
            //cordova.plugins.finPlugin.moveStack(SET02_1.DATA,null, null);
            app.setCompanyList(res);
        };
        var failureCallback = function(error){
            //실패 시 실패 팝업 발생
            open_PopupError(error);
        };
        var sendData = {
            "sepa":"wechatpay"
        };
        cordova.plugins.finPlugin.getAllBizData(sendData, successCallback, failureCallback);
    },
    setCompanyList:function(data){
         var html = "";
         var isOneCompany = false;
         if(isIphone())
         {
             var dataArray = data['merchantsList'];
             
//             if(dataArray.length == 1) {
//                var dataObject = JSON.parse(dataArray.pop());
//                 app.changeCompany(dataObject['readerNumber']);
//                 $("#bizInfo.inputWrap").html('');
//                 return;
//             }
             if(dataArray.length == 1) isOneCompany = true;
             var dataObj = "";
             var tmpCnt = 0;
             while (dataArray.length > 0)
             {
                //if(0 == tmpCnt) app.changeCompany(dataObject['readerNumber']);
                 var dataObject = JSON.parse(dataArray.pop());
                 var bizName = dataObject['storeName'];
                 var bizNumber = dataObject['businessNumber'];
                 var proNumber = dataObject['productNumber'];
                 var redNumber = dataObject['readerNumber'];
                 var valuer = proNumber + "|" + bizNumber + "|" + redNumber;
                 if(0 == tmpCnt) app.changeCompany(valuer);
                 html = html + "<option value='" + valuer + "'>" + bizName + "(" + bizNumber + ")</option>";
                 tmpCnt++;
             }
         }else
         {
             var dataArray = JSON.parse(data);
//             if(dataArray.length == 1) {
//                 $("#bizInfo.inputWrap").html('');
//                 var dataObject = dataArray.pop();
//                  app.changeCompany(dataObject.cat_id);
//                 return;
//             }
             if(dataArray.length == 1) isOneCompany = true;
             var tmpCnt = 0;
             while (dataArray.length > 0) {
                 var dataObject = dataArray.pop();
                 if(0 == tmpCnt) app.changeCompany(dataObject.cat_id);
                 html = html + "<option value='" + dataObject.cat_id + "'>" + dataObject.biz_name + "(" + dataObject.biz_number + ")</option>";
                 tmpCnt++;
             }

         }
         $("#slt_company").html(html);
         //사업장이 하나라면 화면에 표기 하지 않는다
         if(isOneCompany) $("#bizInfo").hide();
         else $("#bizInfo").show();
    },
     changeAmount:function(_val){
         //가격 변동 시 계속 갱신
         cordova.plugins.finPlugin.changePrice(replaceAll(_val,",",""), null, null);
     },
     changeCompany:function(_val){
         cordova.plugins.finPlugin.changeCompany(_val, null, null);
     },
    reqConfirm:function() {
        if (isClickedButton()) {
            return;
        }
        var price = replaceAll($("#uSum").val(),",",""); // 판매금액 입력값
        var company = $(".company").val(); // 상호 선택값
    
        if(price == "" || company == ""){
            $("#layerPopup.Popup12").show();
        }else{
            //window.AndroidInterface.onClickSign($("#uSum").val(), $("#uInstPlan").val(), $("#slt_company option:selected").val());
            if(isIphone()){
              var data = {
                  "STACK_ID":"ALI_BAR",
                  "STACK_URL":"02_04_2.html",
                  "PRICE":$("#uSum").val(),
                  "MERCHANTS":$("#slt_company option:selected").val()
              };
              cordova.plugins.finPlugin.moveStack(data, null,null);
            }else {
              var sendData = {
                    "price":price,
                    "catId":company
                };
               cordova.plugins.finPlugin.requestPayment(sendData,function(dbId){
                    close_PopupError();
                    
                    open_PopupError('결제가 완료 되었습니다.');
                    RECEIPT_WECHAT.DATA.RECEIPT_ID = dbId;
                    cordova.plugins.finPlugin.moveStack(RECEIPT_WECHAT.DATA,null, null);
               }, function(error){
                    if(error) open_PopupError(error);
                    else open_PopupError('결제 요청에 실패 하였습니다.');
                    if('통합형' == useType){
                        cordova.plugins.finPlugin.backButton("", null, null);
                    }
               });
            }        
        }
    },
    changeCompany:function(_val){
        cordova.plugins.finPlugin.changeCompany(_val, null, null);
    },
    setDisableAmount:function(_state) {
        $("#uSum").prop("disabled", _state);
    },
    setDisableMerchant:function(_state) {
        $("#slt_company").prop("disabled", _state);
    },
    showWarnningPopup:function(){
        $("#layerPopup.Popup12").show();
    },
    hideWarnningPopup:function(){
        $("#layerPopup.Popup12").hide();
    },errorOfPaymentByNetwork:function()
    {
        close_PopupError();
        open_PopupError('네트워크 문제로 인하여 결제 요청에 실패 하였습니다.');
        cordova.plugins.finPlugin.backButton("", null, null);
    }
   
};

app.initialize();
