var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function() {
        //상단 표기 상태 변경
        cordova.plugins.finPlugin.getUseType("", function(res){
            if(0 < res.length){
                if('연동형' == res){
                    if(isIphone()){
                      $("#hd_title").html("<a href='#' onclick='app.backbuttonAction();' ><h3 class='btnPre'><span class='blind'>이전</span></h3></a><h3 class='title'>사용설정</h3><h3 id='battery' class='battery'><span></span></h3>");
                      cordova.plugins.finPlugin.checkBattery("", function(battery){
                          updateBattery(true, battery)
                      },function(error){
                          updateBattery(false, '')
                      });
                    }else {
                      $("#hd_title").html("<h3 class='title'>사용설정</h3><h3 id='battery' class='battery'><span></span></h3>");
                    }
                    
                }
            }
        }, null);
        cordova.plugins.finPlugin.getUserData("", function(res){
                                              
          if(isIphone())
          {
              var setData = JSON.parse(res);
              app.setUse(setData['usedType'], setData['isMultiBiz'], setData['isCredit'], setData['isCash'], setData['isUnion'], setData['isAli'], setData['isKakao']);
              if(setData['appVersion']){
                  $("#label_app_version").text(setData['appVersion']);
              }
          }else
          {
              app.setUse(res.usedType, res.isMultiBiz, res.isCredit, res.isCash ,res.isUnion, res.isAli, res.isKakao, res.isWechat, res.isZero);
              if(res.appVersion){
                  $("#label_app_version").text(res.appVersion);
              }
              
          }
          app.setSelectUsedType();
        }, function(error){
            app.setSelectUsedType();
        });
    },
    eventInit:function(){
        //사용 형태에 따라 비활성화
        $("#slt_used_type").change(function(){
            app.setSelectUsedType();
        });
        //데이터 저장
        $('#userDataSave').on('click',function(){
            app.useSave();
        });
        //개인정보 처리방침 보기
        $('#label_privacy_view').on('click',function(){
            app.showPrivacyPopup();
        });
        //파일 로그 수동 전달
        $('#label_send_log').on('click',function(){
            app.sendLogFile();
        });
    },
    otherInit:function(){
        if(isIphone()){

        }else {
            document.addEventListener("backbutton", app.backbuttonAction, false);
        }
        UPDATE_CHECK();
    },
    backbuttonAction:function(){
        var isPopupClose = false;
        if(!isPopupClose){
            cordova.plugins.finPlugin.backButton("", null, null);
        }
    },
    setBattery:function(battery){
        $('#battery').html(battery);
    },
    setUse:function(usedType, isMultiBiz, isCredit, isCash,  isUnion, isAli, isKakao, isWechat, isZero){
        if(isIphone())
        {
             $("#slt_multi_biz").val(isMultiBiz).prop("selected", true);
            
             $("#slt_use_card").val(isCredit).prop("selected", true);
             $("#slt_use_cash").val(isCash).prop("selected", true);
            
             $("#slt_use_union").val(isUnion).prop("selected", true);
             $("#slt_use_ali").val(isAli).prop("selected", true);
             $("#slt_use_kakao").val(isKakao).prop("selected", true);
        }else
        {
            if(isMultiBiz)  $("#slt_multi_biz").val("use").prop("selected", true);
            else $("#slt_multi_biz").val("not_use").prop("selected", true);

            if(isCredit)  $("#slt_use_card").val("use").prop("selected", true);
            else $("#slt_use_card").val("not_use").prop("selected", true);

            if(isCash)  $("#slt_use_cash").val("use").prop("selected", true);
            else $("#slt_use_cash").val("not_use").prop("selected", true);


            if(isUnion)  $("#slt_use_union").val("use").prop("selected", true);
            else $("#slt_use_union").val("not_use").prop("selected", true);

            if(isAli)  $("#slt_use_ali").val("use").prop("selected", true);
            else $("#slt_use_ali").val("not_use").prop("selected", true);

            if(isKakao)  $("#slt_use_kakao").val("use").prop("selected", true);
            else $("#slt_use_kakao").val("not_use").prop("selected", true);

            if(isWechat)  $("#slt_use_wechat").val("use").prop("selected", true);
            else $("#slt_use_wechat").val("not_use").prop("selected", true);

            if(isZero)  $("#slt_use_zero").val("use").prop("selected", true);
            else $("#slt_use_zero").val("not_use").prop("selected", true);

        }
        $("#slt_used_type").val(usedType).prop("selected", true);
    },
    useSave:function(){
        if(isIphone())
        {
            var usedType = $("#slt_used_type option:selected").val();
            var userData = {
                "usedType":usedType,
                "isMultiBiz":$("#slt_multi_biz option:selected").val() ,
                "isCredit":$("#slt_use_card option:selected").val(),
                "isCash":$("#slt_use_cash option:selected").val(),
                "isUnion":$("#slt_use_union option:selected").val() ,
                "isAli":$("#slt_use_ali option:selected").val(),
                "isKakao":$("#slt_use_kakao option:selected").val()
            };
            cordova.plugins.finPlugin.setUserData(userData, function(success){
                if('연동형'==success){
                    cordova.plugins.finPlugin.moveStack(SET01.DATA, null, null);
                }else if('통합형'==success){
                    if(isIphone()) cordova.plugins.finPlugin.moveStack(MAIN.DATA, null, null);
                }
            }, null);
        }else
        {
            var usedType = $("#slt_used_type option:selected").val();
            var userData = {
                "usedType":usedType,
                "isCredit":$("#slt_use_card option:selected").val() == 'use',
                "isCash":$("#slt_use_cash option:selected").val() == 'use',
                "isMultiBiz":$("#slt_multi_biz option:selected").val() == 'use',
                "isUnion":$("#slt_use_union option:selected").val() == 'use',
                "isAli":$("#slt_use_ali option:selected").val() == 'use',
                "isKakao":$("#slt_use_kakao option:selected").val() == 'use',
                "isWechat":$("#slt_use_wechat option:selected").val() == 'use',
                "isZero":$("#slt_use_zero option:selected").val() == 'use'

            };
            cordova.plugins.finPlugin.setUserData(userData, function(success){
                setOptions(success);
                setTimeout(function() {
                     var useType = JSON.parse(success).useType;
                     if("G" == useType){
                         cordova.plugins.finPlugin.moveStack(SET01.DATA, null, null);
                     }
                }, 1000);
            }, null);
        }
    },
    setSelectUsedType:function() {

    	if ( $("#slt_used_type option:selected").val()=="통합형"){
    		$("#slt_use_union").attr("disabled",false);
            $("#slt_use_ali").attr("disabled",false);
            $("#slt_use_kakao").attr("disabled",false);
            $("#slt_use_wechat").attr("disabled",false);
            $("#slt_use_zero").attr("disabled",false);
    		$("#slt_use_ali").css('background-color', 'white');
            $("#slt_use_union").css('background-color', 'white');
            $("#slt_use_kakao").css('background-color', 'white');
            $("#slt_use_wechat").css('background-color', 'white');
            $("#slt_use_zero").css('background-color', 'white');
    	}else{
    	    $("#slt_use_union").attr("disabled",true);
            $("#slt_use_ali").attr("disabled",true);
            $("#slt_use_kakao").attr("disabled",true);
            $("#slt_use_wechat").attr("disabled",true);
            $("#slt_use_zero").attr("disabled",true);
    	    $("#slt_use_ali").css('background-color', 'LightGrey');
            $("#slt_use_union").css('background-color', 'LightGrey');
            $("#slt_use_kakao").css('background-color', 'LightGrey');
            $("#slt_use_wechat").css('background-color', 'LightGrey');
            $("#slt_use_zero").css('background-color', 'LightGrey');
    	}
    },mobileIntegrity:function(){
        var data = SET03.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },
    mobileSetting:function(){
        var data = SET01.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },mobileCert:function(){
        var data = SET02.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },mobileVatSet:function(){
        var data = SET04.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },showPrivacyPopup:function(){
        var data = PRIVACY_POLICY.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },sendLogFile:function(){
        cordova.plugins.finPlugin.saveFileTest("", null,null);
    }
};
app.initialize();