var startDate;
var endDate;
var util = new PageUtil();
var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },
    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function() {
        //상단 표기 상태 변경
        cordova.plugins.finPlugin.getUseType("", function(res){
            if(0 < res.length){
                if('연동형' == res){
                    if(isIphone()){
                      $("#hd_title").html("<a href='#' onclick='app.backbuttonAction();' ><h3 class='btnPre'><span class='blind'>이전</span></h3></a><h3 class='title'>무결성 검사</h3><h3 id='battery' class='battery'><span></span></h3>");
                      cordova.plugins.finPlugin.checkBattery("", function(battery){
                          updateBattery(true, battery)
                      },function(error){
                          updateBattery(false, '')
                      });
                    }else {
                      $("#hd_title").html("<h3 class='title'>무결성 검사</h3><h3 id='battery' class='battery'><span></span></h3>");
                    }
                    
                }
            }
        }, null);
        //PageUtil 초기 설정
        util.pageRows = 3; // 한번에 출력될 게시물 수
        util.disPagepCnt= 5; //화면 출력 페이지 수
        util.curPage = 1;
        //초기 날짜 설정
        startDate = app.getToday();
        endDate = app.getToday();
        $("#datepickerSt").val(startDate);
        $("#datepickerEd").val(endDate);
        //초기 날짜 설정에 따른 조회 값 게시
        app.searchVerifyList();
    },
    eventInit:function(){
        /**무결성 검사 실행 화면으로 이동 */
        $('#operateVerify').on('click',function(){
            cordova.plugins.finPlugin.moveStack(SET03.DATA, null, null);
        });
        /** 시작 날짜 설정*/
        $("#datepickerSt").on("change", function() {
            var changeVal = $(this).val();
            if(app.checkLimitDate(changeVal)){
                if(app.checkStartDate(changeVal)){
                    startDate = changeVal;
                } else {
                    showToastMessage("잘못된 날짜 입력입니다.");
                    $(this).val(startDate);
                }
            }else {
                showToastMessage("최근 1개월 까지만 조회가 가능 합니다.");
                $(this).val(startDate);
            }
        });
        /** 종료 날짜 설정*/
        $("#datepickerEd").on("change", function() {
            if(app.checkEndDate($(this).val())){
                endDate = $(this).val();
            } else {
                showToastMessage("잘못된 날짜 입력입니다.");
                $(this).val(endDate);
            }
        });
        /** 조회*/
        $('#searchVerify').on('click',function(){
            showToastMessage("조회를 시작 합니다.");
            util.curPage = 1;
            app.searchVerifyList();
        });
    },
    otherInit:function(){
        if(isIphone()){

        }else {
            document.addEventListener("backbutton", app.backbuttonAction, false);
        }
    },
    backbuttonAction:function(){
        var isPopupClose = false;
        if ($("#layerPopup.Popup05").is(':visible')){
            isPopupClose = true;
            app.hideInputPinPopup();
        }
        if ($("#layerPopup.Popup07").is(':visible')){
            isPopupClose = true;
            app.hideSaveCompletedPopup();
        }
        if ($("#layerPopup.Popup08").is(':visible')){
            isPopupClose = true;
            app.hideDeviceListPopup();
        }
        if ($("#layerPopup.Popup10").is(':visible')){
            isPopupClose = true;
            app.hideDeletePopup();
        }
        if(!isPopupClose){
            cordova.plugins.finPlugin.backButton("", null, null);
        }
    },
    setBattery:function(battery){
        $('#battery').html(battery);
    },
    getToday:function(){
        var today = new Date();
        var yyyy = today.getFullYear();
        var mm = today.getMonth()+1; // getMonth() is zero-based
        var dd  = today.getDate();

        return yyyy + "-" + String(mm).padStart(2,'0') + "-" + String(dd).padStart(2,'0');
    },
    getLimitDay:function(){
        var limitDate = new Date();
        limitDate.setMonth(limitDate.getMonth()-1);
        var yyyy = limitDate.getFullYear();
        var mm = limitDate.getMonth()+1; // getMonth() is zero-based
        var dd  = limitDate.getDate();
        return yyyy + "-" + String(mm).padStart(2,'0') + "-" + String(dd).padStart(2,'0');
    },
    checkLimitDate:function(val){
        //최근 1개월 까지만 조회가 가능하기 때문에 금일 기준
        //한달 이전 날짜는 사용이 불가
        var result = val.localeCompare(app.getLimitDay());
        if(0 <= result) return true;
        else return false;
    },
    checkStartDate:function(val){
        //endDate보다 넘어선 날짜인지 조회
        var result = val.localeCompare(endDate);
        //val 값이 endDate 보다 작을때는 -1
        //val 값이 endDate 와 같을때는  0
        //val 값이 endDate 보다 높을때는 1
        if(0 >= result) return true;
        else return false;
    },
    checkEndDate:function(val){
        //startDate보다 이전 날짜인지 조회
        var result = val.localeCompare(startDate);
        //val 값이 startDate 보다 작을때는 -1
        //val 값이 startDate 와 같을때는  0
        //val 값이 startDate 보다 높을때는 1

        //종료 날짜가 오늘을 넘어가면 안됨
        var result2 = val.localeCompare(app.getToday());

        if(0 <= result && 0 >= result2) return true;
        else return false;
    },
    goPage:function(pageNo){
        util.curPage = pageNo;
        util.setTotalPage();
        app.searchVerifyList();
    },
    next_page:function(){
        util.curPage    = util.getNextPage();
        util.setTotalPage();
        app.searchVerifyList();
    },
    next:function(){
        util.curPage    = util.getNext();
        util.setTotalPage();
        app.searchVerifyList();
    },
    prev_page:function(){
        util.curPage    = util.getPrevPage();
        util.setTotalPage();
        app.searchVerifyList();
    },
    prev:function(){
        util.curPage    = util.getPrev();
        util.setTotalPage();
        app.searchVerifyList();
    },
    searchVerifyList:function(){
        open_Progress("무결성 검사 결과를 가져오고 있습니다.");
        var searchData = {
            "pageNum":util.curPage,
            "startDate":startDate,
            "endDate":endDate
        };
        var successCallback = function(res){
            close_Progress();
            app.showVerifyList(res);
        };
        var failureCallback = function(error){
            //실패 시 실패 팝업 발생
            close_Progress();
            open_PopupError(error);
        };
        cordova.plugins.finPlugin.searchVerifyList(searchData, successCallback, failureCallback);
    },
    showVerifyList:function(res){
        
        if(isIphone())
        {
            close_Progress();
            
            util.totalCnt = res['totalCnt'];
            util.setTotalPage();
            dataArray = res['verifyList'];
            if(dataArray == null) return;
            if(dataArray.length == null) return;

            var data = "";
            while (dataArray.length > 0) {
                var dataObject = JSON.parse(dataArray.pop());
                
                var result = "이상있음";
                if(dataObject['_result'] == 'Y') {
                    result = "이상없음";
                }
                data = data + " <div class='result_Wrap'> <span><ul class='resultTxtWrap'><li>무결성 검사 실행</li><li>"
                        +dataObject['_date'] + "</li><li>" + dataObject['_time'] + "</li></ul></span>  <span class='btnResult'>" + result + "</span> </div>";
            }
            $('#no_search.ResultWrap03').removeClass('ResultWrap03');
            $("#no_search").html(data);

             //var test = "<a href='#' class='first on'><li><span class='blind'> << </span></li></a>";
             //$("#page").html(test);
            //$("#page").html(util.Drow());
            
            
            
        }else
        {
            util.totalCnt = res.totalCnt;
            util.setTotalPage();
            dataArray = res.verifyList;
            if(dataArray == null) return;
            if(dataArray.length == null) return;

            var data = "";
            while (dataArray.length > 0) {
                var dataObject = dataArray.pop();
                var result = "이상있음";
                if(dataObject._result == 'Y') {
                    result = "이상없음";
                }
                data = data + " <div class='result_Wrap'> <span><ul class='resultTxtWrap'><li>무결성 검사 실행</li><li>"
                        +dataObject._date + "</li><li>" + dataObject._time + "</li></ul></span>  <span class='btnResult'>" + result + "</span> </div>";
            }
            $('#no_search.ResultWrap03').removeClass('ResultWrap03');
            $("#no_search").html(data);

             //var test = "<a href='#' class='first on'><li><span class='blind'> << </span></li></a>";
             //$("#page").html(test);
            $("#page").html(util.Drow());
        }
        
        
        
        
    },
    mobileIntegrity:function(){
        var data = SET03.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },
    mobileSetting:function(){
        var data = SET01.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },
    mobileVatSet:function(){
        var data = SET04.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },
    
    mobileUserSet:function(){
        var data = SET05.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    }
    
};

app.initialize();