var PaymentChoiceView = function(){
	let sto1, sto2 ;//서명관련 변수.
	let gnPrintIdx = 0; // 프린트 5회 재시도를 위한 변수
	let listenerId;
	
	// 2021.02.18 approveOnsuccessCallbackExe로 분리함. server Ip/Port변경 기능이 비동기이기 때문에 callback함수에서 결제를 수행해야 하기 때문에
	this.approveOnsuccessCallback = function(data, creditData , appType , reCallFn ) {		
		if ( util.isTizen() == false || ipPortChgYn =="N" ) { 
			paymentChoiceView.approveOnsuccessCallbackExe(data, creditData , appType , reCallFn); // 성공 시 결제수행
		}else{
			util.logInfo("*****approveOnsuccessCallback appType.trTypeVal == > " + appType.trTypeVal);
			// 제로 페이나 카카오 페이인 경우에는 디폴트 IP/PORT로 결제를 했기 때문에, 다시 원래 매장 결제서버로 원복한다
			if(appType.trTypeVal == "1" || appType.trTypeVal == "2"){ // 1: 카카오, 2: 제로
				// IP,PORT 변경 공통함수 호출
				util.fnServerIpPortChange("1", function(result){
					util.logInfo("*****approveOnsuccessCallback CALLBACK START*****");
					var vsCode = result.Code;
					if(vsCode == "0"){ // 성공
						util.logInfo("*****approveOnsuccessCallback CALLBACK SERVER IP/PORT CALLBACK success*****");
						paymentChoiceView.approveOnsuccessCallbackExe(data, creditData , appType , reCallFn); // 성공 시 결제수행
					}else{ // 실패
						util.logInfo("*****approveOnsuccessCallback CALLBACK SERVER IP/PORT CALLBACK fail*****");
						paymentChoiceView.approveOnsuccessCallbackExe(data, creditData , appType , reCallFn); // 성공 시 결제수행
					}
				});
				
				// 결제서버 정보가 있으면 서버 IP/PORT 변경 수행.
//				listenerId = nativeApp.functionCallASync(["FDK_Config_Host_Address", vsIp, vsPort], paymentChoiceView.fnCreditApproveRequestCallback);
			}else{ // 기타 결제인 경웨 바로 결제 수행.
				util.logInfo("*****기타결제 바로 수행!!!****");
				paymentChoiceView.approveOnsuccessCallbackExe(data, creditData , appType , reCallFn);
			}
		}
	}
	
	/**************************************************************
	 * 카드 승인/승인거절에 대한 Callback 처리
	 **************************************************************/
	this.approveOnsuccessCallbackExe = function(data, creditData , appType , reCallFn ) {
		// $(".newUserPayIng").hide();
		util.logInfo("______________ (상품결제) PAYMENT APP RESPONSE(approveOnsuccessCallbackExe!!!!) _______________");
		util.logInfo("<<<===== CARD PAYMENT RESULT DATA =====>>>\n " + JSON.stringify(data));
		// util.logInfo("<<<===== creditData =====>>>\n " + JSON.stringify(creditData));
		// util.logInfo("<<<===== appType =====>>>\n " + JSON.stringify(appType));
		waitingService.ResetLogOutTimer(); // 대기화면으로 돌아가는 타이머 초기화. ( 결제 도중에 대기화면으로 돌아가지 않기 위해)
		
		util.logInfo(" ***** approveOnsuccessCallbackExe fnNetCancelCommand 시작 전 *****");
		util.fnNetCancelCommand(0, 10); // NetCancel 데몬 제어. @param1 = 0 : 데몬중지, 1 : 데몬 재실행 / @param2 = 데몬 재실행되는 타임 카운트 ( 1에 30초씩 계산됨 )
		util.Delay(1000);
		util.logInfo(" ***** approveOnsuccessCallbackExe fnNetCancelCommand 완료!!! *****");

		// let payResult = data[0].value[0];
		// util.logDebug("<<<===== payResult =====>>> "+ payResult);
		let resultParse = ""
		if( util.isTizen() == true) {
			resultParse = JSON.parse(data);	

		} else {
			resultParse = JSON.parse(data[0].value[0]);
		}
		
		//util.logInfo("<<<===== resultParse =====>>> "+ resultParse);
		util.logInfo("<<<===== resultParse =====>>> add Info ");
		// alert($("#myVideoSrc").attr("src"));
		
		gPaymentStatus = resultParse["Status"];
		
		/* 2020-11-27 백종기
		 * 임우성 부장님과 협의 결과 return의 메시지 종류는, 
		 * 1. 결제 BACK했을 때 payResult = "CANCEL"이 리턴됨
		 * 2. 카드 결제시에 승인거절 및 통신장애등의 오류형태는 JSON형태의 메시지로 리턴됨
		 * 따라서 취소일 때만 그대로 CANCEL 자체로 리턴되고, 나머지는 JSON형태이기 때문에 아래와 같이 분기함.
		 */
		if(resultParse["Status"] == "APPROVE" ){
			util.logInfo("***** approveOnsuccessCallback status :: APPROVE ***** ");			
			if ( util.byteLen( creditData.CardNo ) != 0 )  {
				try {
					b2bbarcode.stopScanBarcode();
				} catch (e) {
					util.logError('## error barcode camera 바코드 승인났는데 카메라 안꺼짐.');
					util.logError(e);
				}
			}

		   /*********************************************************
		    * 신용카드 결제 후, 매핑 값 넘긴다.
		    *********************************************************/
		   paymentChoiceService.returnPaymentInfo( resultParse , creditData , appType );

		 //단독 사업자.
		   if(  BIZ_CLS_TYPE == '0' ){
			   // 매핑된 값을 DB저장
//				   orderPayRegService.orderPayReg();//차후 CAT_ID 가 복수개일 경우 처리방식 수정.
//				   this.soundPayed();  //사운드 처리.			   
			   util.logInfo("approveOnsuccessCallback if(BIZ_CLS_TYPE == 0) IN");
			   this.fnCardReaderStatus(resultParse["카드종류"]);  // 파라미터가 C일 때만(IC카드) 카드제거해주세요 로직을 수행하도록함.
		   } else  {
			   util.logInfo("______________ (상품결제) 카드승인 콜백에서 복수사업자 분기문으로 진입 _______________");
			   //복수사업자.
			   ++orderInfo.BMC_WORKING;
			   if ( orderInfo.BMC_WORKING  == orderInfo.CORNER_LIST.length ) {
				   util.logInfo("______________ (상품결제) 카드승인 콜백에서 복수사업자 분기문-> BMC_WORKING과  CORNER_LIST.length가 같을 때의 분기문 진입 _______________");
//					   orderPayRegService.orderPayReg();
//					   this.soundPayed();  //사운드 처리.
				   util.logInfo("approveOnsuccessCallback (BIZ_CLS_TYPE == 0) else IN");
				   this.fnCardReaderStatus(resultParse["카드종류"]); // 파라미터가 C일 때만(IC카드) 카드제거해주세요 로직을 수행하도록함.

			   } else {
				   util.logInfo("______________ (상품결제) 카드승인 콜백에서 복수사업자 분기문 -> BMC_WORKING과  CORNER_LIST.length가 다를 때의 분기문 진입 _______________");
				   paymentChoiceService.multiBizAppr( orderInfo.BMC_WORKING );

			   }
		   }
		   return;
		} else{
   			util.logInfo("<<<===== PAYMENT STATUS ETC =====>>>");
			// TODO 복수사업자의 경우 1건이 아닐경우 망취소 처리한다. 2020.11.09
   			// util.fnUpdatePayInfoFile 망취소
			let dataObj = {};
			dataObj.button2Show = true;
			dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
//			dataObj.button2Func = function(){
//				router.push({ path : '/paymentChoiceView' });
//			};
			if ( util.byteLen( creditData.CardNo ) != 0 )  { // 카드 번호가 없으면 신용카드, 있으면 간편결제
				$("#barCodePop").show(); // 에러시에는 바토드 직접입력 버튼 보이게한다.
			}
			
			if(resultParse["Status"] == "CANCEL"){
				dataObj.message = util.languageObjReturn(langCode, 'noticeCanceled') + "\n [" + resultParse["응답메세지2"] + "]"; // 취소되었습니다.
				
				// payment 호출 전에 결제수단 버튼을 안보이게한다.
				$(".mileage").show(); // 마일리지
				$(".creditcard").show(); // 신용카드
				$(".simplepay").show(); // 간편결제
				
				// 뒤로가기(cancel의 에러가 나면 메뉴선택 화면으로 이동한다)
				dataObj.button2Func = function(){
					router.push({path: '/paymentChoiceView'});
				};								
			}else{
				var vsMsg1 = "";
				var vsMsg2 = "";
				if(!!resultParse["응답메세지1"]){
					vsMsg1 = resultParse["응답메세지1"];
				}
				if(!!resultParse["응답메세지2"]){
					vsMsg2 = resultParse["응답메세지2"];
				}
				var returnMsg = "";
				if(!!vsMsg1 || !!vsMsg2){
					returnMsg = " [" + vsMsg1 + vsMsg2 + "]";
				}
				
				dataObj.message = util.languageObjReturn(langCode, 'failMsg') + returnMsg; // 정상처리 되지 않았습니다. + 리턴 메시지
				
				
				if(  BIZ_CLS_TYPE == '0'){ // 단독사업자
					//제휴할인이 존재할 때.결제 실패가 되면 제휴할인 승인을 취소해야한다.
					if(orderInfo.POS_ODJCD_T != undefined) {
						util.logInfo("***** approveOnsuccessCallbackExe fnUpdatePayInfoFile CALL POINT CANCEL*****");
						var fileNameAlli = orderInfo.POS_ODJCD_T.TRADE_SERIAL_NUM +"_"+ orderInfo.POS_ODJCD_T.APPR_FULL_TIME + ".tr";
						util.logInfo("***** approveOnsuccessCallbackExe fnUpdatePayInfoFile CALL POINT CANCEL fileNameAlli == > "+fileNameAlli);
						util.fnUpdatePayInfoFile(fileNameAlli); // 제휴할인 승인파일 업데이트 (취소)
						
						util.logInfo(" ***** approveOnsuccessCallbackExe 결제 승인 실패시 제휴할인이 존해한다면 파일 sendOk 2로 바꾼 후 fnNetCancelCommand 시작 *****");
						// 결제 승인 실패시 제휴할인이 존해한다면 파일 sendOk 2로 바꾼 후, NetCancel 재실행이 되도록 함수를 수행한다.
						util.fnNetCancelCommand(1, 0);
					}
				}else{ // 복수사업자인경우
					this.multiBizNetCancel(); // 복수사업자 멀티취소를 한다.
				}
				
				// 뒤로가기(cancel이 아닌경우의 에러가 나면 메뉴선택 화면으로 이동한다)
				dataObj.button2Func = function(){
					router.push({path: '/menu'});
				};
			}										
			eventBus.$emit('alertPopupIndex', dataObj);
						
			if(resultParse["Status"] == "CANCEL"){
				/*****************************************************************
				 * 단독사업자는 망취소할 할 필요없다.
				 * 복수사업자일 경우 CORNER_LIST 가 1개가 아닐경우 할 필요가 없다.
				 * 복수사업자의 경우 1건이 아닐경우 망취소 처리한다. 2020.11.09
				 *****************************************************************/
				if(  BIZ_CLS_TYPE == '0' || orderInfo.CORNER_LIST.length == 1 ){
					return;
				}
			}
		}
		
	}

	this.paymentErrAllianceCancel = function(callbackName, result){
    	nativeApp.removeASyncApiListener(callbackName, this.listenerId);
		router.push({path: '/menu'});
	}
	
	this.multiBizNetCancel = function() {
		util.logInfo("*** multiBizNetCancel START ***");
		//망취소시 최초 시작이면 할 필요없다.
		if ( orderInfo.BMC_WORKING == undefined || orderInfo.BMC_WORKING == 0 ){ // 복수사업자가 아니면 return
			util.logInfo(" *** multiBizNetCancel NO Multiple operators *** ");
			return;
		}
			
		// 코너별 메뉴들을 for문돌아서 파일에 update처리.
		orderInfo.CORNER_LIST.forEach(e => {
			if ( util.byteLen( e.TRADE_SERIAL_NUM ) == 0 )
				return true;

			let fileName = e.TRADE_SERIAL_NUM +"_"+ e.APPR_FULL_TIME + ".tr";
			util.fnUpdatePayInfoFile(fileName);
		});
	}

	this.soundPayed = function() {
		//string으로 보내면 해당 src한건 수행, 배열로 보내면 배열만큼 연속적으로 음성안내 수행  (한글src만 보내면됨)
		let arrSrc = new Array();
		if(gsSpecialShopFlag == "9"){
			//레인보우 로보틱스에서 요청한 개발리스트 중 하나인 [주문, 결제 시 음성안내] 파일
			//향후 3자리 버전으로 음성을 제공할 예정 1.바코드, 2.QR, 3.바코드 or QR
			arrSrc[0]= "./audio/14_barcode.mp3";
			//arrSrc[0]= "./audio/15_qr.mp3";
			//arrSrc[0]= "./audio/16_qr_barcode.mp3";
		} else {
			arrSrc[0]= "./audio/13.mp3";
		}
		arrSrc[1]= "./audio/30.mp3";
		util.fnAudioPlay(arrSrc); // 음성안내 공통함수 호출
	}

	// 2021.02.18 fnCreditApproveRequestExe로 분리함. server Ip/Port변경 기능이 비동기로 callback함수에서 결제를 수행해야 하기 때문에
	this.fnCreditApproveRequest = function(pay, appType = {} , strBarcode, reCallFn){
		util.logInfo("______________fnCreditApproveRequest 함수 시작______________");
		if ( util.isTizen() == false || ipPortChgYn == "N") {
			paymentChoiceView.fnCreditApproveRequestExe(pay, appType , strBarcode, reCallFn); // 성공 시 결제수행
		}else{
			// 제로 페이나 카카오 페이인 경우에는 디폴트 IP/PORT로 결제를 해야함.
			if(appType.trTypeVal == "1" || appType.trTypeVal == "2"){ // 1: 카카오, 2: 제로			
				util.logInfo("*****fnCreditApproveRequest IF START*****");
				// IP,PORT 변경 공통함수 호출
				util.fnServerIpPortChange("0", function(result){
					util.logInfo("*****fnCreditApproveRequest IF CALLBACK START*****");
					var vsCode = result.Code;
					if(vsCode == "0"){ // 성공
						util.logInfo("*****fnCreditApproveRequest IF CALLBACK SERVER IP/PORT CALLBACK success*****");
						paymentChoiceView.fnCreditApproveRequestExe(pay, appType , strBarcode, reCallFn); // 성공 시 결제수행
					}else{ // 실패
						util.logInfo("*****fnCreditApproveRequest IF CALLBACK SERVER IP/PORT CALLBACK fail*****");
						let dataObj = {};
						dataObj.button2Show = true;
						dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
						
						dataObj.message = util.languageObjReturn(langCode, 'serverIpPort'); // 결제 서버 정보 셋팅 중에 문제가 발생했습니다.

						// 뒤로가기(cancel이 아닌경우의 에러가 나면 메뉴선택 화면으로 이동한다)
						dataObj.button2Func = function(){
							router.push({path: '/menu'});
						};
						return;
					}
				});
				
				// 결제서버 정보가 있으면 서버 IP/PORT 변경 수행.
//				listenerId = nativeApp.functionCallASync(["FDK_Config_Host_Address", vsIp, vsPort], paymentChoiceView.fnCreditApproveRequestCallback);
			}else{ // 기타 결제인 경우 바로 결제 수행.			
				util.logInfo("*****fnCreditApproveRequest ELSE START*****");
				// 현재 설정되어있는 ip/port와 해당 매장의 ip/port 값이 같다면 바로 결제 수행
				var SERVER_IP_NOW = sessionStorage.getItem("SERVER_IP_NOW"); // 현재 설정된 IP
				var SERVER_PORT_NOW = sessionStorage.getItem("SERVER_PORT_NOW"); // 현재 설정된 IP
				if(SERVER_IP_NOW == SERVER_IP && SERVER_PORT_NOW == SERVER_PORT){
					util.logInfo("*****fnCreditApproveRequest ELSE SAME NOW*****");
					paymentChoiceView.fnCreditApproveRequestExe(pay, appType , strBarcode, reCallFn);				
				}else{ // ip/port가 다르다면 해당 매장의 ip/port로 변경
					util.logInfo("*****fnCreditApproveRequest ELSE DIFF NOW*****");
					// IP,PORT 변경 공통함수 호출 (해당 매장의 값으로 변경)
					util.fnServerIpPortChange("1", function(result){
						util.logInfo("*****fnCreditApproveRequest ELSE CALLBACK START*****");
						var vsCode = result.Code;
						if(vsCode == "0"){ // 성공
							util.logInfo("*****fnCreditApproveRequest ELSE CALLBACK SERVER IP/PORT CALLBACK success*****");
							paymentChoiceView.fnCreditApproveRequestExe(pay, appType , strBarcode, reCallFn); // 성공 시 결제수행
						}else{ // 실패
							util.logInfo("*****fnCreditApproveRequest ELSE CALLBACK SERVER IP/PORT CALLBACK fail*****");
							let dataObj = {};
							dataObj.button2Show = true;
							dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
							
							dataObj.message = util.languageObjReturn(langCode, 'serverIpPort'); // 결제 서버 정보 셋팅 중에 문제가 발생했습니다.

							// 뒤로가기(cancel이 아닌경우의 에러가 나면 메뉴선택 화면으로 이동한다)
							dataObj.button2Func = function(){
								router.push({path: '/menu'});
							};
							return;
						}
					});
				}
				
			}
		}
		
	}
	
	// fnCreditApproveRequest의 콜백함수
	
		
	// 카드 결제 승인
	this.fnCreditApproveRequestExe = function(pay, appType = {} , strBarcode = "", reCallFn){		
		util.logInfo("______________ (상품결제) 카드 승인정보 세팅 START _______________");
		//console.log("카드 승인 요청...!!!");
		//console.log('카드 승인 요청 pay >> ' + pay);

		let appControl = null;
		let successCallback = null;
		let errorCallback = null;
		let appControlReplyCallback = null;
		let odh = orderInfo.POS_ODHDR_T;// 주문 HEADER 정보
		let catid= "";
		let creditData = {};

		if ( BIZ_CLS_TYPE == '0') {
			// 단독사업자
			catid = BIZ_CLS_SINGLE_CAT_ID ;
        	creditData = {
      			  "CatId"             : catid  //"10069371"
      			, "Pay"               : pay.pay    +""           /** 거래 금액         **/
      			, "Tax"               : pay.tax    +""           /** 부가세            **/
      			, "InstallmentMonths" : "00"                     /** 할부 거래         **/
      			, "ApproveNo"         : ""                       /** 원거래 승인번호   **/
      			, "ApproveDate"       : ""                       /** 원거래 일자       **/
      			, "CardNo"            : strBarcode               /** 카드번호          **/
      			, "Type"              : appType.trTypeVal        /** 결재 구분 (BC-QR : 0, 카카오 : 1, 제로페이 : 2) **/
      			, "MechantTempInfo"   : ""                       /** 가맹점 임의정보   **/
      			, "TaxSaleAmt"        : pay.VatSaleAmt       +"" /** 과세 대상금액     **/
      			, "NonTaxSaleAmt"     : pay.NonTaxSaleAmt     +"" /** 비과세 대상금액   **/
      			, "UserServiceCode"   : ""                       /** 사용자 코드       **/
      			, "UserServiceData"   : ""                        /** 사용자 데이터     **/
      			, "serviceAmt"        : 0 + "" // 봉사료
      			, "totalCupAmt"       : pay.totalCupAmt + "" // 컵보증금 총금액
			};

		} else {			
			// 복수사업자
			util.logInfo('복수사업자...');
			catid = pay.catId;
        	creditData = {
        			  "CatId"             : catid  //"10069371"
        			, "Pay"               : pay.pay    +""           /** 거래 금액         **/
        			, "Tax"               : pay.tax    +""           /** 부가세            **/
        			, "InstallmentMonths" : "00"                     /** 할부 거래         **/
        			, "ApproveNo"         : ""                       /** 원거래 승인번호   **/
        			, "ApproveDate"       : ""                       /** 원거래 일자       **/
        			, "CardNo"            : strBarcode               /** 카드번호          **/
        			, "Type"              : appType.trTypeVal        /** 결재 구분 (BC-QR : 0, 카카오 : 1, 제로페이 : 2) **/
        			, "MechantTempInfo"   : ""                       /** 가맹점 임의정보   **/
        			, "TaxSaleAmt"        : pay.VatSaleAmt       +"" /** 과세 대상금액     **/
        			, "NonTaxSaleAmt"     : pay.NonTaxSaleAmt     +"" /** 비과세 대상금액   **/
        			, "UserServiceCode"   : ""                       /** 사용자 코드       **/
        			, "UserServiceData"   : ""                       /** 사용자 데이터     **/
        			, "cornerCd"          : pay.cornerCd             /** 코너번호     **/
        			, "cornerNm"          : pay.cornerNm             /** 코너명     **/
        			, "cornerCnt"         : pay.cornerCnt            /** 전체코너수     **/
        			, "cornerCntCur"      : pay.cornerCntCur         /** 현재처리중인 코너 순번     **/
        			, "serviceAmt"        : 0 + "" // 봉사료
          			, "totalCupAmt"       : pay.totalCupAmt + "" // 컵보증금 총금액
  			};
		}

        try {        	
        	if ( util.byteLen( creditData.CardNo ) != 0 )  { // 카드 번호가 없으면 신용카드. 있으면 간편결제
        		$("#barCodePop").hide();
        	}
        	// payment 호출 전에 결제수단 버튼을 안보이게한다.
			$(".mileage").hide(); // 마일리지
			$(".creditcard").hide(); // 신용카드
			$(".simplepay").hide(); // 간편결제

        	// 거래금액, 부가세, 할부 개월, 원거래 승인번호, 원거래 일자, 카드번호
        	// - '카드번호' 는 카카오등 간편 결재시 사용...
		    creditData["SignTimeout1" ] =  sto1     ;                /** 서명 패드 표시 Timeout (초)  **/
		    creditData["SignTimeout2" ] =  sto2     ;                /** 서명 패드 서명 후 "확인" 버튼을 누를때까지의 Timeout (초)  **/		    
		    creditData["Language"     ] =  langCode ;
		    var vsAutioUseYn = util.GetEnvXmlPosENV(706); // 음성안내 사용여부 (0:미사용, 1:사용)
		    creditData["AudioUseYn"     ] =  vsAutioUseYn ; // payment app쪽에 음성안내 사용여부를
		    
		    // 임시 로직 (메모리 이슈로 인한 임시 처리로 추후 삭제 필요)
//		    // if(TEST_REAL_FLAG == "real"){
//		    	TempApproveCnt++;
//		    // }
//		    util.logInfo("===========================TempApproveCnt Before == >>>>>> " + TempApproveCnt);
//		    if(20<TempApproveCnt){
//		    	TempApproveCnt = 1;
//		    }
//		    util.logInfo("===========================TempApproveCnt == >>>>>> " + TempApproveCnt);
//		    creditData["TempApprovCnt"] =  ""+TempApproveCnt;
		    // 임시 로직 끝
		    
        	util.logInfo('카드 승인요청 데이터 : ' + JSON.stringify(creditData));
        	
        	util.logInfo("______________ (상품결제) 카드 승인정보 세팅 END _______________");
        	
        	
//        	if(!!orderInfo.BMC_WORKING && orderInfo.BMC_WORKING  > 0){ // 복수사업자로 첫번째가 아닌 두번째부터의 결제는 바로 결제가 되도록 호출을 한다.
//        		debugger;
//        		eventBus.$emit('creditApproveRequest', paramObj);
//        	}else{ // 첫번째 결제는 결제 화면을 호출한다.
//        		window.parent.router.push({ name : 'paymentExe' , params : {paramObj} });
//        	}
//        	
        	
        	if( util.isTizen() == true) {
        		
        		util.logInfo('card pay :' + JSON.stringify( creditData) )
        		if(!reCallFn){
        			reCallFn = "";
        		}
		        var paramObj = {
        			            creditData: creditData,
        			            appType : appType,
        			            reCallFn : reCallFn
        					  };        		
        		// this.$router.push({ name : 'addPointAction' , params : {obj :
				// obj } });
        		// routes.push({name : 'paymentExe' , params: {paramObj}})
        		// eventBus.$emit('paymentExe', paramObj);		       
		        
		        if(SHOP_INFO.SHOP_TYPE == "0" && (gvOrderOnly == "0" || gvOrderOnly == "2") ) { // 주문전용 키오스크 여부 ( 0:미사용, 1:사용), 포스설정용 주문전용 키오스크 여부 ( 0:미사용, 1:사용, 2:결제+주문전용)
		        	util.logInfo("***** orderInfo.BMC_WORKING == >>  " + orderInfo.BMC_WORKING);
		        	if(!!orderInfo.BMC_WORKING && orderInfo.BMC_WORKING  > 0){ // 복수사업자로 첫번째가 아닌 두번째부터의 결제는 바로 결제가 되도록 호출을 한다.
		        		util.logInfo("______________ (상품결제) 복수사업자로 인해 결제 다시 호출 ______________ 호출 횟수 =>> " + (Number(orderInfo.BMC_WORKING) + 1));
		        		eventBus.$emit('creditApproveRequest', paramObj);
		        	}else{ // 첫번째 결제는 결제 화면을 호출한다.
		        		window.parent.router.push({ name : 'paymentExe' , params : {paramObj} });
		        	}
		        } else { // 주문전용일 때 로컬 결제 바로 진행.
		        	windowDummyService.dummySinglePaymentApprove2( creditData , appType , reCallFn );        	
		        }
		        // 경고메세지 팝업
		        
        		/*
				 * appControl = new
				 * tizen.ApplicationControl("http://skiosk/payment/appcontrol/orderCreditControl",
				 * null, null, null, //[new tizen.ApplicationControlData("text",
				 * [pay])]); [new tizen.ApplicationControlData("text",
				 * [JSON.stringify( creditData)] ) ] );
				 * 
				 * successCallback = function() { util.logInfo("launch
				 * application control succeed"); };
				 * 
				 * errorCallback = function(e) { //TODO 어떻게????
				 * util.logInfo("launch application control failed. reason: " +
				 * e.message); };
				 * 
				 * appControlReplyCallback = { onsuccess: function(data) {
				 * paymentChoiceView.approveOnsuccessCallback(data, creditData ,
				 * appType , reCallFn); }, onfailure: function() { //TODO
				 * onfailure 어떻게 처리??? util.logInfo("Failed to get a reply \n
				 * from the Payment"); } };
				 * 
				 * util.logInfo("______________ (상품결제) PAYMENT APP CALL START
				 * _______________");
				 * tizen.application.launchAppControl(appControl, null,
				 * successCallback, errorCallback, appControlReplyCallback );
				 */
        	
        	} else  {
        		 if(SHOP_INFO.SHOP_TYPE == "0" && gvOrderOnly == "0") {
 		        	windowDummyService.dummySinglePaymentApprove( creditData , appType , reCallFn );        	
 		        } else {
 		        	windowDummyService.dummySinglePaymentApprove2( creditData , appType , reCallFn );        	
 		        }
        	}
        } catch (error)  {
        	// TODO 어떻게...???
        	console.error(error);
        }

    }

	this.creditApprRequest = function() {
//		waitingService.timeoutHnd = window.clearTimeout(waitingService.timeoutHnd);  // 대기화면으로 돌아가기를 중단한다.
		//메인포스에서 주문번호를 받아오는 경우에는 db저장전에 한번더  채번을 해준다. 중복금지!!
	    //util.getOrderNoAspNoCallBack();
	    
		util.logInfo("______________ (상품결제) 결제 START _______________");
		if(  BIZ_CLS_TYPE == '0' ){
			paymentChoiceService.singleBizAppr();
		} else {
			paymentChoiceService.multiBizAppr(0);
		}
	}


    // 결제수단선택화면
    this.fnGetPaymentChoiceView = function(){
    	let easyPayUseYn = "";
        var returnTemplate = { template: '#paymentChoiceView'
        	, created : function() {
        		util.logInfo('결제 수단 선택 화면 시작  PaymentChoiceView ====>' );
            	util.logInfo('결제 수단 선택 화면  (created)====> SHOP_INFO.PNT_ACMT_STATUS_VAL >>' +SHOP_INFO.PNT_ACMT_STATUS_VAL );            	
            	util.logInfo("_langCode" , langCode);
            	if ( orderInfo.addPoint == undefined) {
            		orderInfo.addPoint = {};
            	}
            	this.paymentAmount  = util.languageObjReturn(langCode , 'paymentAmount');
            	// 모바일 교환권이 있는경우에 할인금액 -> 모바일 교환권/금액권 으로 변경
            	if(orderInfo.SUPERCON_INFO !== undefined ) {
            		this.discountAmount = util.languageObjReturn(langCode , 'superConBarcodeMsg7');
            	} else {
            		this.discountAmount = util.languageObjReturn(langCode , 'discountAmount');
            	}
            	
            	// NFC 단말기 여부 판단 0 : 미사용, 1 : 사용
            	if(gNfcShopVal == "1") this.cardType = util.languageObjReturn(langCode , 'cardTypeNfc'); 
            	else this.cardType = util.languageObjReturn(langCode , 'cardType');
	        	
	        	this.easyPay        = util.languageObjReturn(langCode , 'easyPay');
	        	this.totalQuantity  = util.languageObjReturn(langCode , 'totalQuantity');
	        	this.orderConfirm   = util.languageObjReturn(langCode , 'orderConfirm');
	        	this.orderUnit      = util.languageObjReturn(langCode , 'orderUnit');
	        	this.orderComplete  = util.languageObjReturn(langCode , 'orderComplete');
	        	this.cupDepositTxt  = util.languageObjReturn(langCode , 'cupDeposit'); // 컵 보증금
	        	this.tollgate 		= util.languageObjReturn(langCode , 'tollgate');
	        	this.superCon 		= util.languageObjReturn(langCode , 'superCon');
            	
//            	if(SHOP_INFO.POINT_FG == "M") {
//            		this.rmType = util.languageObjReturn(langCode , 'rmTypeMile');
//                } else {
//                	this.rmType = util.languageObjReturn(langCode , 'rmTypeStamp');
//                }

            	// BJK GetEnvXmlPosENV의 값이 없는 경우 디폴트로 선언한 0이 분기 되도록 try catch 적용.
            	try {
            		this.payViewDivCd = util.GetEnvXmlPosENV(708); // 결제창 위쪽영역에 금액대신 상품목록을 보여줄지 여부(결제화면주문상세 0:미사용 1:사용) 2020-10-22 BJK
            		easyPayUseYn = util.GetEnvXmlPosENV(700);// 간편결제 사용여부.
            		this.vsAllianceVal = util.GetEnvXmlPosENV( 717 ); // 이통사 제휴할인 사용여부
            		util.logInfo("easyPayUseYn========> : " + easyPayUseYn );
            		util.logInfo("vsAllianceVal========> : " + this.vsAllianceVal );
            	} catch (error) {
            		util.logError("_______PaymentChoiceView ===> : " + error);
        		}
            	
            	if (easyPayUseYn == '0') {
            		this.useEasypayDisable = "display:none;"; 
            	} else {
            		this.useEasypayDisable = "";
            	}
            	
            	//톨게이트 바코드 스캔 타입, 적립시 바코드 스캔이 필요함
            	gPayBarcodeType = "";
            	
            	// 결제화면 선택시 가격정보를 전달받아야한다.
            	// 일단 하드코딩
            	// this.menuPrice = "11250";
            	
            }
	    	, data : function() {
	    		return {
	    			  rmType            : ""
	    		    , rmType2           : util.languageObjReturn(langCode , 'rmTypeAlliance') /** 제휴할인 다국어 처리용 **/
	    		    , mpPointBtnTxt     : util.languageObjReturn(langCode , 'mpPointBtnTxt') /** MP포인트 사용/적립 다국어 처리용 **/
	    		    , notUsed           : util.languageObjReturn(langCode , 'notUsed') /** 사용안함 다국어 처리용 **/
	    		    , alliPickBtnUse    : util.languageObjReturn(langCode , 'alliPickBtnUse') /** 할인 여부를 선택해야 결제 버튼이 활성화 됩니다. **/
	    			, getTotalAmtView   : "0"
	    			, totalPrice        : ""
	    			, getVatSaleAmtView : "0"
	    			, payTotalAmtView   : "0"
	    			, totalPrice        : ""
	    			, menuPrice         : ""
	    			, payViewDivCd      : "0"
	    			, orderList         : []  /** 주문상품 정보   **/
	    		    , menuTotalCnt      : 0
	    		    , kitchenMemo       : ""
	    		    , accCreditType     : ""
	    		    , accEasyType       : ""
	    		    , shopType       	: ""
	    		    , mileageYn         : ""  /** 마일리지 사용여부   **/
	    		    , allianceYn        : ""  /** 이통사 사용여부   **/
	    		    , vsAllianceVal     : ""
	    		    , listenerId        : ""
	    		    , stampAvailable	: "Y"
	    		    , dropTopFlag       : gsSpecialShopFlag /**gsSpecialShopFlag**/
	    		    , payBtnDisableYn   : "Y" /** this.dropTopFlag == "6"일 때만 사용 **/
	    		    , saleBtnDisableYn  : "N" /** this.dropTopFlag == "6"일 때만 사용 **/
	    		    , shopVatCd			: SHOP_INFO.VAT_CD
	    		    , payTotalVatView   : 0
	    		    , couponPayType   	: ""
	    		    , cashReceiptVal    : gvCashReceiptVal /** 현금영수증 사용여부 값 0: 미사용, 1: 사용 **/
	    		    , cupDeposit        : 0
	    		    , tgShopVal		    : "N"
    		    	, tgRemainPayVal	: "N"
		    		, combinePayVal		: "N" //톨게이트 선불카드 복합결제유무 T:선불카드로만, C:복합결제 
	    			, scShopVal			: "N" //슈퍼콘 쿠폰결제 사용 여부 
    				, scRemainPayVal	: "N" 
					, combineScPayVal	: "N" //슈퍼콘 쿠폰결제 복합결제유무 S:슈퍼콘 쿠폰으로만, C:복합결제
					, couponDcYn : "N" // 쿠폰할인여부
					, kerbanDiscountRateYn : "N" // 고객등급할인여부
	    		} 
	    	}
	        , mounted : function() {   	        	
                //util.logInfo("***** waitDiv display ***** === >> "+$("#waitDiv").attr("display"));
            	//서명 관련 timeout 설정. 2020.11.11 추가.
	        	util.logInfo("_____fnGetPaymentChoiceView mount Start_____");
	        	
	        	util.logInfo("_____fnGetPaymentChoiceView orderInfo ===> : " + JSON.stringify(orderInfo));
	        	
            	paymentChoiceView.init();
            	util.logInfo("payViewDivCd========> : " + this.payViewDivCd );
//	        	if(SHOP_INFO.POINT_FG=="M"){
//	        		this.rmType        = util.languageObjReturn(langCode,  'rmTypeMile');
//	        	}else if(SHOP_INFO.POINT_FG=="S"){
//	        		this.rmType        = util.languageObjReturn(langCode,  'rmTypeStamp');
//	        	}else{
//	        		//this.$router.push({ path : '/mileage' });
//	        	}
            	this.accCreditType = this.$route.params.accCreditType;
            	util.logInfo("_____this.accCreditType ===> : " + this.accCreditType);
            	this.accEasyType = this.$route.params.accEasyType;
            	util.logInfo("_____this.accEasyType ===> : " + this.accEasyType);
            	util.logInfo("_____gCombinePayVal ===> : " + gCombinePayVal);
            	this.combinePayVal = gCombinePayVal;
            	util.logInfo("_____gCombineScPayVal ===> : " + gCombineScPayVal);
            	this.combineScPayVal = gCombineScPayVal;
            	
	        	/* ksh
	        	 * 0 : 미사용	, 1 : 사용	, 2 : 사용+적립팝업
	        	 * */
            	
            	// payViewDivCd = 0이면 상단에 금액관련 레이아웃 표시, 1이면 선택한 메뉴리스트 표시 BJK
            	if(this.payViewDivCd=="1"){ // menuList
            		this.fnMenuScroll();
            		// setTimeout( this.menuScroll ,1000); // 스크롤 및 클릭 이벤트
            		this.fnMenuTotalCount(); // 총 수량 계산
            		$('#payDetail').hide();
            		$('#menuDetail').show();
            	}else{ // 총금액
            		$('#menuDetail').hide();
            		$('#payDetail').show();
            	}
            	
            	util.logInfo("_____fnGetPaymentChoiceView SHOP_INFO.PNT_ACMT_STATUS_VAL ===> : " + SHOP_INFO.PNT_ACMT_STATUS_VAL);
            	util.logInfo("_____fnGetPaymentChoiceView SHOP_INFO.POINT_FG ===> : " + SHOP_INFO.POINT_FG);
            	
	        	if(SHOP_INFO.PNT_ACMT_STATUS_VAL == "0") {
	        		//console.log("마일리지 미사용")
	        		//$( '.mileage.white' ).hide();
	        		this.mileageYn        = "N"
	        	} else if(SHOP_INFO.PNT_ACMT_STATUS_VAL == "1" || SHOP_INFO.PNT_ACMT_STATUS_VAL == "2" ) {
	        		//$( '.mileage.white' ).show();
	        		//this.rmType        = util.languageObjReturn(langCode,  'rmTypeMile');
	        		if(SHOP_INFO.POINT_FG=="M") {
	        			if(SHOP_INFO.POINT_CO_VAL == "2") {
	        				this.rmType        = util.languageObjReturn(langCode,  'rmTypeDodo');
	        			} else {
	        				this.rmType        = util.languageObjReturn(langCode,  'rmTypeMile');
	        			}
		        	} else if(SHOP_INFO.POINT_FG=="S") {
		        		this.rmType        = util.languageObjReturn(langCode,  'rmTypeStamp');
		        	}
	        		this.mileageYn        = "Y"
	        	}
	        	
	        	util.logInfo("_____fnGetPaymentChoiceView SHOP_INFO.SHOP_TYPE ===> : " + SHOP_INFO.SHOP_TYPE);
	        	util.logInfo("_____fnGetPaymentChoiceView gvOrderOnly ===> : " + gvOrderOnly);
	        	if(SHOP_INFO.SHOP_TYPE == "1" || gvOrderOnly == "1"){
	        		//메인포스에서만 결제가능한 매장일경우
	        		this.shopType = "A"
	        	} else {
	        		//키오스크에서 결제가능 매장
	        		this.shopType = "N"
	        	}
	        	
	        	// 이통사 사용여부 체크 (allianceYn 변수값에 따라 화면 div가 동적으로 변경됨)
	        	if(this.vsAllianceVal == "1") { // 사용
	        		this.allianceYn = "Y";
	        	} else { // 미사용
	        		this.allianceYn = "N";
	        	}
	        	
	        	//톨게이트 사용 여부
	        	if(gsMobileCouponTg == "Y" && util.isEmpty(gBarodaInfo)) {
	        		this.tgShopVal = "Y"; 
	        	}
	        	
	        	//슈퍼콘 쿠폰 사용 여부
	        	if(gsMobileCouponSc == "Y" && util.isEmpty(gBarodaInfo)) {
	        		this.scShopVal = "Y"; 
	        	}
	        	
            	if ( orderInfo.POS_ODJCD_T !== undefined) {
            		if(SHOP_INFO.POINT_FG=="S") {
            			//이미 제휴할인을 받을경우 스탬프를 사용할수없음
            			this.stampAvailable = "N";
            		}
            	}
	        	
            	if ( orderInfo.POS_ODHDR_T == undefined ) return;

//            	var getTotalSaleAmt = 0;
//            	
//            	if(SHOP_INFO.VAT_CD == "0") {
//            		getTotalSaleAmt  = orderInfo.POS_ODHDR_T.TOT_SALE_AMT + orderInfo.POS_ODHDR_T.VAT_AMT;	
//            		//this.menuPrice = orderInfo.POS_ODHDR_T.TOT_SALE_AMT + orderInfo.POS_ODHDR_T.VAT_AMT;
//            	} else {
//            		getTotalSaleAmt  = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;			// 총 금액
//            		//this.menuPrice = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;
//            	}

            	var getTotalSaleAmt = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;
            	var getNoTotalSaleAmt = orderInfo.POS_ODHDR_T.NO_TOT_SALE_AMT;
            	//var getTotalSaleUprcOrgAmt = orderInfo.POS_ODHDR_T.TOT_SALE_UPRC_ORG;
            	
            	if(this.shopVatCd == "1") {
            		this.getTotalAmtView  = util.numberWithCommas(getTotalSaleAmt);
            		//this.payTotalAmtView  = util.numberWithCommas(getTotalSaleAmt);
            	} else {
            		this.getTotalAmtView  = util.numberWithCommas(getNoTotalSaleAmt);
            		//this.payTotalAmtView  = util.numberWithCommas(getTotalSaleUprcOrgAmt);
            		this.payTotalVatView  = util.numberWithCommas(orderInfo.POS_ODHDR_T.VAT_AMT);  
            	}
	        	//var getVatSaleAmtView = orderInfo.POS_ODHDR_T.TOT_SALE_AMT ;		// 결재금액 => 총 금액으로 대체(test)

	        	//this.getTotalAmtView  = util.numberWithCommas(getTotalSaleAmt);
            	this.cupDeposit = orderInfo.POS_ODHDR_T.CUP_DEPOSIT_AMT; // 1회용 컵 보증금
            	this.payTotalAmtView  = util.numberWithCommas(getTotalSaleAmt + this.cupDeposit); // 1회용 보증금 컵을 더해서 보여준다.
	        	this.totalPrice       = util.languageObjReturn(langCode,  'totalPrice');
	        	this.menuPrice = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;
            	this.orderList = orderInfo.POS_ODDTL_T; //BJK 메뉴리스트 레이아웃일 때 메뉴리스트 표시를 위해 선언
            	
            	util.logInfo("orderInfo.POS_ODHDR_T.KITCHEN_MEMO ============= >>>>  " + orderInfo.POS_ODHDR_T.KITCHEN_MEMO);
            	var vsTakeOutYn = orderInfo.POS_ODHDR_T.KITCHEN_MEMO; // 먹고가기, 포장하기 구분
            	util.logInfo("vsTakeOutYn ============= >>>>  " + vsTakeOutYn);

                var selectTableYn = util.GetEnvXmlPosENV(712);

                //selectTableYn = 1;

            	if(gOrderType == "meal"
                    && (gvEatTakeOutVal == "0" || gvEatTakeOutVal == "1" || gvEatTakeOutVal == "2" )
                    && selectTableYn == "1"
                    && !util.isEmptyStr(basicOrderInfo.tableNm)){
                    this.kitchenMemo = basicOrderInfo.tableNm;

                }else if(vsTakeOutYn == "meal"){ // 먹고가기
            		this.kitchenMemo = util.languageObjReturn(langCode, 'eating');
            	}else if(vsTakeOutYn == "takeout"){ // 포장하기
            		this.kitchenMemo = util.languageObjReturn(langCode, 'takeOut');
            	}else if(vsTakeOutYn == "start"){ // 시작하기
            		this.kitchenMemo = util.languageObjReturn(langCode, 'start');
            	}else if(vsTakeOutYn == "calculate"){ // 계산하기
            		this.kitchenMemo = util.languageObjReturn(langCode, 'calculate');
            	}else if(vsTakeOutYn == "voucher"){ // 상품권
            		this.kitchenMemo = util.languageObjReturn(langCode, 'voucher');
            	}else if(vsTakeOutYn == "doOrder"){ // 주문하기
            		this.kitchenMemo = util.languageObjReturn(langCode, 'doOrder');
            	}else if(vsTakeOutYn == "nOrder"){ // 일반주문
            		this.kitchenMemo = util.languageObjReturn(langCode, 'nOrder');
            	}else if(vsTakeOutYn == "mOrder"){ // 회원주문
            		this.kitchenMemo = util.languageObjReturn(langCode, 'mOrder');
            	}else{ // 사용자인 경우에 넘어온 파라미터 그대로 넣어준다.
            		this.kitchenMemo = vsTakeOutYn;
            	}
            	
            	//포장상품 할인금액의 총합
            	var togoChargeAmt = 0;
  
            	if(gvEatTakeOutVal == "0" || gvEatTakeOutVal == "1" || gvEatTakeOutVal == "2"){
                	//포장하기인 경우에만 금액변동 - TOGO_CHARGE < 0
                	if(gOrderType == "takeout"){
                		util.logInfo("typeof getVatSaleAmtView >>> " + typeof this.getVatSaleAmtView);
                		util.logInfo("typeof payTotalAmtView >>> " + typeof this.payTotalAmtView);
                		
                		var getVatSaleAmtViewTemp = Number(this.getVatSaleAmtView.replace(/,/gi, ""));
                		var payTotalAmtViewTemp = Number(this.payTotalAmtView.replace(/,/gi, ""));
                		
                		this.getVatSaleAmtView = util.numberWithCommas(orderInfo.POS_ODHDR_T.DC_PACK_AMT);
                		if(this.shopVatCd == "1") {
                    		this.payTotalAmtView = util.numberWithCommas(payTotalAmtViewTemp);
                    		this.menuPrice = this.menuPrice;
                    	} else {
                    		this.payTotalAmtView = util.numberWithCommas(payTotalAmtViewTemp);
                    		this.menuPrice = this.menuPrice;
                    	}
                		
                		//this.menuPrice = this.menuPrice - orderInfo.POS_ODHDR_T.DC_PACK_AMT;
                		
                		togoChargeAmt = orderInfo.POS_ODHDR_T.DC_PACK_AMT;
                		this.payTotalAmtView = util.numberWithCommas(Number(this.getTotalAmtView.replace(/,/gi, "")) - Number(togoChargeAmt));
                	}
            	}
            	
            	// if(this.$route.params.price !== undefined ) {
            	if(orderInfo.POS_ODHDR_T.CST_USE_POINT !== undefined ) {
            		util.logInfo("this.$route.params.price : " + this.$route.params.price );

            		var tAmtView = 0;
            		// this.getVatSaleAmtView = this.$route.params.price;
            		if(SHOP_INFO.POINT_FG=="M"){
            			//마일리지 매장일경우 사용포인트가 할인 금액과 동일
            			this.getVatSaleAmtView = util.numberWithCommas(orderInfo.POS_ODHDR_T.CST_USE_POINT);
            			if(this.shopVatCd == "1") {
            				tAmtView = orderInfo.POS_ODHDR_T.TOT_SALE_AMT - orderInfo.POS_ODHDR_T.CST_USE_POINT;
                    	} else {
                    		tAmtView = orderInfo.POS_ODHDR_T.TOT_SALE_AMT - orderInfo.POS_ODHDR_T.CST_USE_POINT;
                    	}
            		} else {
            			//스탬프 매장일경우 사용스탬프에 따라서 실제 할인 금액이 달라진다.
            			this.getVatSaleAmtView = util.numberWithCommas(orderInfo.POS_ODHDR_T.CST_POINT_AMT);
            			if(this.shopVatCd == "1") {
            				tAmtView = orderInfo.POS_ODHDR_T.TOT_SALE_AMT - orderInfo.POS_ODHDR_T.CST_POINT_AMT;
                    	} else {
                    		tAmtView = orderInfo.POS_ODHDR_T.TOT_SALE_AMT - orderInfo.POS_ODHDR_T.CST_POINT_AMT;
                    	}
            		}


					

            		//var tAmtView = orderInfo.POS_ODHDR_T.TOT_SALE_AMT - orderInfo.POS_ODHDR_T.CST_USE_POINT;
            		util.logInfo("payTotalAmtView : " + tAmtView );
            		this.payTotalAmtView = util.numberWithCommas(tAmtView);
            		// 사용자가 마일리지 조회 후, 총결제금액이 0원일때 자동으로 결제 (총구매 금액 - 할인금액 = 0)
            		if(this.payTotalAmtView == "0"){
            			this.fn_pay();
            		}

            	}
            	
            	if(orderInfo.DODO_POINT_INFO !== undefined ) {
            		util.logInfo("this.$route.params.price : " + this.$route.params.price );

            		var tAmtView = 0;
            		// this.getVatSaleAmtView = this.$route.params.price;
            		if(SHOP_INFO.POINT_FG=="M"){
            			//마일리지 매장일경우 사용포인트가 할인 금액과 동일
            			this.getVatSaleAmtView = util.numberWithCommas(orderInfo.DODO_POINT_INFO.USE_POINT);
            			if(this.shopVatCd == "1") {
            				tAmtView = orderInfo.POS_ODHDR_T.TOT_SALE_AMT - orderInfo.DODO_POINT_INFO.USE_POINT;
                    	} else {
                    		tAmtView = orderInfo.POS_ODHDR_T.TOT_SALE_AMT - orderInfo.DODO_POINT_INFO.USE_POINT;
                    	}
            		} 
            		util.logInfo("payTotalAmtView : " + tAmtView );
            		this.payTotalAmtView = util.numberWithCommas(tAmtView);
            		// 사용자가 마일리지 조회 후, 총결제금액이 0원일때 자동으로 결제 (총구매 금액 - 할인금액 = 0)
            		if(this.payTotalAmtView == "0"){
            			this.fn_pay();
            		}
            	}
            	
            	if(orderInfo.DODO_POINT_INFO == undefined && SHOP_INFO.POINT_CO_VAL == "2") {
            		orderInfo.POS_ODHDR_T.CST_NO = "";
            	}   
            	
            	//톨게이트 요청 정보가 있을때, 톨게이트 선불 금액이 부족한 경우 복합결제
            	if(orderInfo.TOLLGATE_INFO !== undefined ) {
					util.logInfo("this.$route.params.price : " + this.$route.params.price );

					var tAmtView = 0;
					// this.getVatSaleAmtView = this.$route.params.price;
					//마일리지 매장일경우 사용포인트가 할인 금액과 동일
					this.getVatSaleAmtView = util.numberWithCommas(orderInfo.TOLLGATE_INFO.amount);
					tAmtView = orderInfo.POS_ODHDR_T.TOT_SALE_AMT - orderInfo.TOLLGATE_INFO.amount;
					util.logInfo("payTotalAmtView : " + tAmtView );
					this.payTotalAmtView = util.numberWithCommas(tAmtView);
					//톨게이트, 슈퍼콘 복합결제 X
					this.tgRemainPayVal = "Y";
					this.scRemainPayVal = "Y";
            	}else if(orderInfo.TOLLGATE_DC_INFO !== undefined ) { // 쿠폰할인..
					this.couponDcYn = "Y";
					this.getVatSaleAmtView = util.numberWithCommas(orderInfo.TOLLGATE_DC_INFO.discountAmount);
					var tAmtView = 0;
					tAmtView = orderInfo.POS_ODHDR_T.TOT_SALE_AMT - orderInfo.TOLLGATE_DC_INFO.discountAmount;
					this.payTotalAmtView = util.numberWithCommas(tAmtView);
				}
				if(kerbanDiscountRateYn == "Y"){ // 고객등급할인여부..
					this.kerbanDiscountRateYn = "Y";
				}
            	
            	//슈퍼콘 요청 정보가 있을때, 슈퍼콘 선불 금액이 부족한 경우 복합결제
            	if(orderInfo.SUPERCON_INFO !== undefined ) {
            		util.logInfo("this.$route.params.price : " + this.$route.params.price );

            		var tAmtView = 0;
        			this.getVatSaleAmtView = util.numberWithCommas(orderInfo.SUPERCON_INFO.useAmount);
    				tAmtView = orderInfo.POS_ODHDR_T.TOT_SALE_AMT - orderInfo.SUPERCON_INFO.useAmount;
            		util.logInfo("payTotalAmtView : " + tAmtView );
            		this.payTotalAmtView = util.numberWithCommas(tAmtView);
            		//톨게이트, 슈퍼콘 복합결제 X
            		this.scRemainPayVal = "Y";
            		this.tgRemainPayVal = "Y";
            	}
            	
            	// 이통사/MP 할인금액을 계산하여 셋팅한다.
            	if(orderInfo.POS_ODJCD_T !== undefined){
            		if(orderInfo.POS_ODJCD_T.JCD_TYPE_FG == "M"){ // MP포인트인 경우
            			var vsSaleAmt = 0;
                		if(!!this.getVatSaleAmtView && this.getVatSaleAmtView != "0"){
                			vsSaleAmt = this.getVatSaleAmtView.replace(/,/gi, "");
                		}
 
                		this.getVatSaleAmtView = util.numberWithCommas(Number(vsSaleAmt) + Number(orderInfo.POS_ODHDR_T.JCD_CARD_AMT)); // 현재 할인 금액에 MP포인트 차감금액을 더한다.
                		var vsTotAmt = this.payTotalAmtView.replace(/,/gi, "");
            			this.payTotalAmtView = util.numberWithCommas(Number(vsTotAmt) - Number(orderInfo.POS_ODHDR_T.JCD_CARD_AMT)); // 현재 결제 금액에 MP포인트 차감금액을 뺀다.
            		}else{ // 이통사 제휴할인 인 경우
            			var vsSaleAmt = 0;
                		if(!!this.getVatSaleAmtView && this.getVatSaleAmtView != "0"){
                			vsSaleAmt = this.getVatSaleAmtView.replace(/,/gi, "");
                		}
                		this.getVatSaleAmtView = util.numberWithCommas(Number(vsSaleAmt) + Number(orderInfo.POS_ODJCD_T.JCD_DC_AMT)); // 현재 할인 금액에 이통사 할인금액을 더한다.
                		var vsTotAmt = this.payTotalAmtView.replace(/,/gi, "");
            			
//                		this.payTotalAmtView = util.numberWithCommas(Number(vsTotAmt) - Number(orderInfo.POS_ODJCD_T.JCD_DC_AMT)); // 현재 결제 금액에 이통사 할인금액을 뺀다.
                		
                    	var vsGetTotalAmtView = this.getTotalAmtView.replace(/,/gi, ""); // 화면의 총 금액
                    	if(this.shopVatCd == "0") { // 부가세 별도일 때
	                    	// 총금액 - (총할인금액) + 부가세
	                		this.payTotalAmtView = util.numberWithCommas(Number(vsGetTotalAmtView) - (Number(vsSaleAmt) + Number(orderInfo.POS_ODJCD_T.JCD_DC_AMT)) + Number(orderInfo.POS_ODHDR_T.VAT_AMT)); // 현재 결제 금액에 이통사 할인금액을 뺀다.
                    	}else{ // 부가세 포함일 때
                    		this.payTotalAmtView = util.numberWithCommas(Number(vsGetTotalAmtView) - (Number(vsSaleAmt) + Number(orderInfo.POS_ODJCD_T.JCD_DC_AMT)) ); // 현재 결제 금액에 이통사 할인금액을 뺀다.
                    	}
            		}
            		             
            	}         
            	
            	if(!util.isEmpty(gBarodaInfo)) { //구독권 회원정보가 있는경우 실상품가격에서 현재 공급가 합계를 뺀 금액으로 표시!! 할인금액을 보여주기위해
            		this.getVatSaleAmtView = util.numberWithCommas(Number(orderInfo.POS_ODHDR_T.TOT_SALE_UPRC_ORG_CB) - Number(this.payTotalAmtView.replace(/,/gi, "")));
            		this.getTotalAmtView = util.numberWithCommas(Number(orderInfo.POS_ODHDR_T.TOT_SALE_UPRC_ORG_CB));
            	}
            	// 마일리지와 제휴할인 계산 후 총결제금액이 0원일때 자동으로 결제 (총구매 금액 - 할인금액 = 0)
        		if(this.payTotalAmtView == "0") {
        			this.fn_pay();
        		}
        		
        		
//            	// payViewDivCd = 0이면 상단에 금액관련 레이아웃 표시, 1이면 선택한 메뉴리스트 표시 BJK
//            	if(this.payViewDivCd=="1"){ // menuList
//            		this.fnMenuScroll();
//            		// setTimeout( this.menuScroll ,1000); // 스크롤 및 클릭 이벤트
//            		this.fnMenuTotalCount(); // 총 수량 계산
//            		$('#payDetail').hide();
//            		$('#menuDetail').show();
//            	}else{ // 총금액
//            		$('#menuDetail').hide();
//            		$('#payDetail').show();
//            	}

            	if (util.byteLen ( orderInfo.POS_ODHDR_T.CST_NO ) == 0 )
            		orderInfo.POS_ODHDR_T.CST_NO = "";//고객번호 초기화 2020.11.11 추가.
            	
            	// CREDIT_PAY action
            	if ( this.$route.params.action == 'CREDIT_PAY' ) {
            		// setTimeout(()=> {
            			this.fn_pay();
            		// }, 500);
            	} else {
            		// 주문전용 키오스크가 아닐 때만 음성이 나와야한다.
            		if(this.shopType != "A"){
                		// 결제 수단을 선택해 주세요. 음성추가            			
            			var paramSrc = "./audio/55.mp3";
                		// string으로 보내면 해당 src한건 수행, 배열로 보내면 배열만큼 연속적으로 음성안내 수행 (한글src만 보내면됨)
                		util.fnAudioPlay(paramSrc); // 음성안내 공통함수 호출
            		}
            	}
            	
            	if(this.dropTopFlag == "6"){  // 드롭탑의 경우에 최초에 신용카드/간편결제 비활성화, 제휴할인/mp포인트/사용안함 눌렀을 때 신용카드, 간편결제 활성화 이벤트
                    if(orderInfo.POS_ODJCD_T !== undefined){ // 할인을 하고 해당 화면으로 돌아왔다면
                    	this.alliPickBtnUse = util.languageObjReturn(langCode , 'payMethodChoice') /** 결제 수단을 선택해 주세요. **/ 
                    	this.payBtnDisableYn = "N"; // 결제 버튼들 활성화
                        this.saleBtnDisableYn = "Y"; // 할인 버튼들 비활성화                    	
                        $('.creditcard').addClass('b_org');
                        $('.simplepay').addClass('b_black');
                        
                        $('.alliance').addClass("g_white");
                        $('.mileage').addClass("g_white");
                        $('.notused').addClass("g_white");
                	}
            	}
            	
            	if ( orderInfo.couponPayType == undefined) {
            		orderInfo.couponPayType = "D";
            	}
            	
            	this.couponPayType = orderInfo.couponPayType;
            	
            	util.logInfo("_____fnGetPaymentChoiceView couponPayType_____" + this.couponPayType);
            	util.logInfo("_____fnGetPaymentChoiceView mount 12_____");
	        }
	        ,beforeDestroy () {	        	
	        	util.logInfo("paymentChoiceView beforeDestroy");
	    		this.$root.$off('Todo' );
	    	}
	        , methods : {
	        	mileageView:function(event){
	        		this.$router.push({ path : '/mileage' });
	        	}

	        	, fn_pay : function(){
	        		util.logInfo("*****#paymentChoiceView fn_pay START*****");
	        		paymentChoiceView.creditApprRequest();
	        	}
	        	, fnAllianceGo : function(){
	        		util.logInfo("*****#paymentChoiceView fnAllianceGo START*****");
	        		if(orderInfo.POS_ODJCD_T != undefined) {
	        			var vsType = orderInfo.POS_ODJCD_T.JCD_TYPE_FG;
	        			var messageObj = "";
	        			if(vsType == "MP"){
	        				messageObj = util.languageObjReturn(langCode,  'mpCompl'); // "이미 MP 포인트가 적용되었습니다."
	        			}else{
	        				messageObj = util.languageObjReturn(langCode,  'alliCompl'); // "이미 제휴할인이 적용되었습니다."
	        			}
	        					    					
    					var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
    			        var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj };

    			        // 경고메세지 팝업
    			        eventBus.$emit('alertPopupIndex', dataObj);
    			        return;
	        		}
	        		this.$router.push({name: 'allianceDiscount', params: { price: this.menuPrice }}); //제휴할인 화면으로 이동
	        	}, fnMpPointGo : function(){
	        		util.logInfo("*****#paymentChoiceView fnMpPointGo START*****");
	        		if(orderInfo.POS_ODJCD_T != undefined) {
	        			var messageObj = util.languageObjReturn(langCode,  'alliCompl'); // "이미 제휴할인이 적용되었습니다."		    					
    					var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
    			        var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj };

    			        // 경고메세지 팝업
    			        eventBus.$emit('alertPopupIndex', dataObj);
    			        return;
	        		}
	        		this.$router.push({name: 'mpPoint', params: { price: this.menuPrice }}); // mp포인트 화면으로 이동
	        	}
	        	, fnMpPointNot : function(){
	        		util.logInfo("*****#paymentChoiceView fnMpPointNot START*****");
                	this.payBtnDisableYn = "N"; // 결제 버튼들 활성화
                	this.alliPickBtnUse = util.languageObjReturn(langCode , 'payMethodChoice') /** 결제 수단을 선택해 주세요. **/ 
                	//$('#textDivAlli').css("color", "#000000");                    	
                    $('.creditcard').addClass('b_org');
                    $('.simplepay').addClass('b_black');	     
	        	}
	        	,fn_accPoint_Popup : function(btnType) {

	        		util.logInfo('fn_accPoint_Popup btnType  >>' + btnType);
	        		
	        		var result = util.fnNetWorkCheck();
	        		
	        		// 결제직전에 네트워크의 상태를 체크한다. 결제 중간에 네트워크가 끊어지면 멈충 현상이 발생하여 추가함 
	        		if(result.ResultCode != "0" ) {
	        			//네트워크 비정상
	        			var messageObj = "";
	        			
        				messageObj = util.languageObjReturn(langCode,  'timeoutMsg'); // "서버와의 통신이 원활하지 않습니다. 인터넷을 확인해 주세요."
    					var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
    			        var dataObj = {"button2Show" : true, "button2Name" : button2Name, "button2Func": this.goToMainPage, message: messageObj };
    			        
    			        // 경고메세지 팝업
    			        eventBus.$emit('alertPopupIndex', dataObj);
    			        return false;
	        		} 
	        		
	        		if(btnType == "CREDIT") {
	        			util.logInfo("______________ (상품결제)신용카드결제 버튼 선택 _______________" )
	        			
	        			if(gsSpecialShopFlag == "5"){ // 매장 판단 - 값이 5인 경우 커반 매장(이퀴닉스 서버로 전송할지 여부판단),
                    		var deviceCheckResult = "";
                    		deviceCheckResult = util.ajaxCallKerbanDeviceCheck();
                    		if(deviceCheckResult != "true") {
                    			let dataObj2 = {};
                    			dataObj2.button2Show = true;
                    			dataObj2.button2Func = this.goToMainPage
                    			dataObj2.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
    							if(deviceCheckResult == "false"){
    								dataObj2.message = util.languageObjReturn(langCode,  'kerbanDeviceFalse');
    							} else {
    								dataObj2.message = util.languageObjReturn(langCode,  'kerbanDeviceError');
    							}
        						eventBus.$emit('alertPopupIndex', dataObj2);
                    			return;
                    		}
                    		
                    	}else if(gsSpecialShopFlag == "7" || gsSpecialShopFlag == "9"){ // 알다방인 경우 or 레인보우 로보틱스                  		
                    		var vsParam = {"MSG_TYPE":"REQ_STATUS"};
                    		// 1분마다 상태체크 시작.
                			var result = util.ajaxCallJson(vsParam, gAldabangUrl, false);
                			util.logInfo("_____알다방 상태체크 결과 값(신용카드결제 버튼 클릭) == >> " + JSON.stringify(result));
                    		if(result == "error" || result == "timeout"){
                    			util.logInfo("_____알다방 상태체크 결과 값(신용카드결제 버튼 클릭) 서버와의통신이 원활하지 않다는 메시지 후 main화면으로 이동._____ ");
                    			let dataObj2 = {};
                    			dataObj2.button2Show = true;
                    			dataObj2.button2Func = this.goToMainPage
                    			dataObj2.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
   								dataObj2.message = util.languageObjReturn(langCode,  'timeoutMsg'); // "서버와의 통신이 원활하지 않습니다. 인터넷을 확인해 주세요."
        						eventBus.$emit('alertPopupIndex', dataObj2);
                    			return;
                    		}   		
                    		if(!result.READY){ // 준비 상태가 false라면 점검중 화면으로 이동.
                    			util.logInfo("_____알다방 상태체크 결과 값(신용카드결제 버튼 클릭)바리스타가 머신을 점검중입니다 메시지 후 main화면으로 이동._____ ");
                    			let dataObj2 = {};
                    			dataObj2.button2Show = true;
                    			dataObj2.button2Func = this.goToMainPage
                    			dataObj2.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
   								dataObj2.message = util.languageObjReturn(langCode,  'kerbanDeviceFalse'); // "바리스타가 머신을 점검중입니다. 잠시 후 재시도 해주세요.";
        						eventBus.$emit('alertPopupIndex', dataObj2);
                    			return;
                    		}
                    	}
	        		} else if(btnType == "EASY") {
	        			util.logInfo("______________ (상품결제)간편결제 버튼 선택 _______________" )
	        		} else if(btnType == "TOLLGATE") {
	        			util.logInfo("______________ (상품결제)톨게이트 버튼 선택 _______________" )
	        		} else if(btnType == "SUPERCON") {
	        			util.logInfo("______________ (상품결제)슈퍼콘 버튼 선택 _______________" )
	        		} else {
	        			util.logInfo("______________ (상품결제)기타결제 버튼 선택 _______________" )
	        		}
	        		
		        	var obj = {
		        			BTN_TYPE : btnType,
		        			accCreditType : this.accCreditType,
		        			accEasyType : this.accEasyType
		        	};
		        	
		        	util.logInfo('fn_accPoint_Popup btnType2  >> ' + btnType);
					// 간편결제 페이지 접근시 복수사업자일경우에서 코너가 다중일때 결제 안되도록 처리 2020.11.12
    				if ( btnType == 'EASY' &&  BIZ_CLS_TYPE != '0' && orderInfo.CORNER_LIST.length != 1 ) {
    					var messageObj = util.languageObjReturn(langCode,  'multiCornerListEasyPaydont');    					    					
    					var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
    			        var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj };

    			        // 경고메세지 팝업
    			        eventBus.$emit('alertPopupIndex', dataObj);
    					return;
    				}
    				
		        	if(orderInfo.POS_ODHDR_T.CST_NO == undefined || orderInfo.POS_ODHDR_T.CST_NO == "" || orderInfo.POS_ODHDR_T.CST_NO == null) {
		        		if(btnType == 'CREDIT') {
		        			util.logInfo('fn_accPoint_Popup CREDIT');
		        			// 신용카드 결제
		        			if(SHOP_INFO.PNT_ACMT_STATUS_VAL == "0" || SHOP_INFO.PNT_ACMT_STATUS_VAL == "1" ) {
		        				if(gsMobileCouponTg == "Y") {
		        					if(this.combinePayVal != "Y") {
		        						obj.barcodeOnly = "Y";
		        						this.$root.$emit('addPointPopup' , obj);
		        					} else {
		        						this.fn_pay();
		        					}
		        				} else{
		        					this.fn_pay();
		        				}
		        			} else {
		        				if( orderInfo.addPoint.CREDIT == "Y") {
		        					this.$router.push({ name : 'addPointAction' , params : {obj : obj } });
		        				}else if(orderInfo.addPoint.CREDIT == "N") {
		        					this.fn_pay();
		        				}else{
		        					orderInfo.addPoint.CREDIT = "N";
		        					this.$root.$emit('addPointPopup' , obj);
		        				}
		        			}
		        		} else if(btnType == 'EASY') {
		        			util.logInfo('fn_accPoint_Popup EASY');
		        			if(SHOP_INFO.PNT_ACMT_STATUS_VAL == "0" || SHOP_INFO.PNT_ACMT_STATUS_VAL == "1" ){
		        				if(gsMobileCouponTg == "Y") { //톨게이트 스탬프 적립유무 팝업
		        					if(this.combinePayVal != "Y") {
		        						obj.barcodeOnly = "Y";
		        						this.$root.$emit('addPointPopup' , obj);
		        					} else {
		        						this.$router.push({ path : '/easyPayment' });
		        					}
		        				} else{
		        					this.$router.push({ path : '/easyPayment' });
		        				}
		        				
		        			}else{
		        				// 간편결제
		        				if(orderInfo.addPoint.EASY == "Y"){
		        					this.$router.push({ name : 'addPointAction' , params : {obj : obj } });
		        					
		        				}else if(orderInfo.addPoint.EASY == "N"){
		        					
		        					this.$router.push({ path : '/easyPayment' });
		        					
		        				}else{
		        					orderInfo.addPoint.EASY = "N";
		        					this.$root.$emit('addPointPopup' , obj  );
		        				}
		        			}

		        		} else if(btnType == 'TOLLGATE') {
		        			//결제요청 타입이 톨게이트일때, 바코드 인식 화면으로 이동
		        			gPayBarcodeType = "TOLLGATE";
		        			this.$router.push({ path : '/easyPayment'});
		        			//router.push({ path : '/easyPayment' , params : { "payBarcodeType" : btnType}});
		        		} else if(btnType == 'SUPERCON') {
		        			//결제요청 타입이 톨게이트일때, 바코드 인식 화면으로 이동
		        			gPayBarcodeType = "SUPERCON";
		        			this.$router.push({ path : '/easyPayment'});
		        		} else {
		        			util.logInfo('fn_accPoint_Popup else');
		        			this.$root.$emit('addPointPopup' , obj  );
		        		}
		        	}else{
		        		// 마일리지 조회후, 카드결제
		        		if ( btnType == 'CREDIT') {
		        			// this.$router.push({ path : '/addPointAction' });
		        			util.logInfo("CREDIT>>")
		        			this.fn_pay();
		        		}

		        		// 마일리지 조회후, 간편결제
		        		if ( btnType == 'EASY') { this.$router.push({ path : '/easyPayment' }); }
		        	}
		        }
	        	, goToMainPage : function() {
                	util.logInfo("### goToMainPage ###");
                	
                	//구독취소 추가
                	this.$router.push({ path: '/start' });
                }
                , fnMenuScroll : function() {
                	//console.log("fnMenuScroll========")
	                // 토글버튼 - 사이드 버튼 클릭 이벤트 및 스크롤
					$(function(){
		                // 주문리스트 스크롤바 플러그인 적용
		                var $sTarget = $('.selectedMenu .selectedWrap')
		                function applyScroll(){
		                    var sHei = $sTarget.height();
		                    $(".selectedMenu .menuList").jScrollPane(
		                        {
		                            showArrows: true,
		                            horizontalGutter: 30,
		                            verticalGutter: 30
		                        }
		                    );
   		                    /* //[수정] 2020-10-27::함수내용 수정 */
		                    if ($('.jspScrollable').length){
		                        if($sTarget.height() <= 525){
		                            util.logInfo("check");
		                            $('.jspPane').css('top','0');
		                        }
		                    }
		                }

		                // 토글버튼
		                $('.sideBtn').click(function(){

		                    $(this).parent().toggleClass('on');
		                    applyScroll();
		                });

		                applyScroll();

		            });

                }
                , fnMenuTotalCount : function() {
                	util.logInfo("fnMenuTotalCount========");
	                // 상품 총 개수 (사이드 개수는 포함하지 않는다.)
					var menuCount = 0;
                	for(var i=0; i<orderInfo.POS_ODDTL_T.length;i++){
                		menuCount += Number(orderInfo.POS_ODDTL_T[i].ORDER_QTY); // 주문 수량을 더한다.
                	}
                	this.menuTotalCnt = menuCount;

                }
                , fnHomeClick : function() {
                	util.logInfo("______________ (상품결제)홈 버튼 선택 _______________" );
                	
                	//구독취소 추가
                	
                    var dataObj = {
							  button1Show : true
							, button1Name : util.languageObjReturn(langCode, 'yes') // [ 예 ]
							, button1Func : this.fnGoHome
							, button2Show : true
							, button2Name : util.languageObjReturn(langCode, 'no') // [ 아니오 ]
							, button2Func : ""
							, message     : util.languageObjReturn(langCode,  'orderConfirmHomeClick') // [ 주문 내역이 초기화 됩니다. 홈 화면으로 돌아가시겠습니까? ]
						};
                    eventBus.$emit('alertPopupIndex', dataObj);

                }
                , fnGoHome : function(){
                	// 홈으로 돌아갈 때, 

					// 톨게이트 쿠폰할인 사용취소..
					if(orderInfo.TOLLGATE_DC_INFO !== undefined && orderInfo.TOLLGATE_DC_INFO.discountAmount > 0){
						util.fnTgCouponCancel();
					}
                								
               		if(orderInfo.POS_ODJCD_T != undefined) {
               			util.logInfo("***** paymentChoiceView fnGoHome fnUpdatePayInfoFile CALL POINT CANCEL*****");
   						var fileNameAlli = orderInfo.POS_ODJCD_T.TRADE_SERIAL_NUM +"_"+ orderInfo.POS_ODJCD_T.APPR_FULL_TIME + ".tr";
   					 	util.logInfo("***** paymentChoiceView fnGoHome fnUpdatePayInfoFile CALL POINT CANCEL fileNameAlli == > "+fileNameAlli);
   					 	try{
   					 		util.fnUpdatePayInfoFile(fileNameAlli); // 제휴할인 승인파일 업데이트 (취소)
	   					 	util.logInfo(" ***** paymentChoiceView fnGoHome 제휴할인만 하고 홈으로 돌아갈 때 fnNetCancelCommand 시작 *****");
							// 제휴할인 하고 홈으로 돌아갈 때, NetCancel 재실행이 되도록 함수를 수행한다.
							util.fnNetCancelCommand(1, 0);
   					 	}catch(e){
   					 		util.logError("paymentChoiceView fnGoHome catch e== > " + e.toString());
   					 	}
   					}

               		this.$router.push({path: '/start'});                		
                }                

                , fnBack : function(){
                	
                	if(orderInfo.SUPERCON_INFO !== undefined ) { //슈퍼콘 사용 취소
        				util.fnSuperConCancel();
        			}

					// 톨게이트 쿠폰할인 사용취소..
					if(orderInfo.TOLLGATE_DC_INFO !== undefined && orderInfo.TOLLGATE_DC_INFO.discountAmount > 0){
						util.fnTgCouponCancel();
					}
                	
                	if(orderInfo.couponBarcode == undefined) {
                		// 홈으로 돌아갈 때, 
                		if(orderInfo.POS_ODJCD_T != undefined){
                			util.logInfo("***** paymentChoiceView fnBack fnUpdatePayInfoFile CALL POINT CANCEL*****");
                			var fileNameAlli = orderInfo.POS_ODJCD_T.TRADE_SERIAL_NUM +"_"+ orderInfo.POS_ODJCD_T.APPR_FULL_TIME + ".tr";
                			util.logInfo("***** paymentChoiceView fnBack fnUpdatePayInfoFile CALL POINT CANCEL fileNameAlli == > "+fileNameAlli);
                			try{
                				util.fnUpdatePayInfoFile(fileNameAlli); // 제휴할인 승인파일 업데이트 (취소)
                				
                				util.logInfo(" ***** paymentChoiceView fnBack 제휴할인만 하고 뒤로(메뉴선택) 돌아갈 때 fnNetCancelCommand 시작 *****");
                				// 제휴할인 하고 홈으로 돌아갈 때, NetCancel 재실행이 되도록 함수를 수행한다.
                				util.fnNetCancelCommand(1, 0);
                			}catch(e){
                				util.logError("paymentChoiceView fnBack catch e== > " + e.toString());
                			}
                		}
                		this.$router.push({path: '/menu'});
                	} else {
                		var dataObj = {
  							  button1Show : true
  							, button1Name : util.languageObjReturn(langCode, 'no') // [ 아니요 ]
  							, button1Func : ""
  							, button2Show : true
  							, button2Name : util.languageObjReturn(langCode, 'yes') // [ 네 ]
  							, button2Func : function(){ this.$router.push({name: 'start'})}
  							, message     : util.languageObjReturn(langCode,  'progressInit') // [ 진행내역이 초기화됩니다. 계속하시겠습니까? ]
  						};
                		
                		eventBus.$emit('alertPopupIndex', dataObj);
                	}
                }
                , fnStampAvlPopup : function(){
            		var messageObj = { message : "", messageType : "alert" };
            		var msg = util.languageObjReturn(langCode,  "cantUseStampMsg"); // 서버와의 통신이 원활하지 않습니다. 인터넷을 확인해 주세요.
            		messageObj.message = msg;
            		//alert("제휴할인과 스탬프는 동시에 사용할 수 없습니다.");
            		this.$root.$emit( "notiMessage" ,   messageObj  );
                }
                , fnClickMile : function(){
                	this.$router.push({name: 'mileage', params: { price: this.menuPrice }})
                },
                inputPwdPopupShow : function (evt) {
                	util.logInfo("*****paymentChoiceView index1 inputPwdPopupShow Open*****");
            		//더블클릭시 팝업창 보여줌
                	var paramObj = {
              			  title : "권한 확인"
              			, openType : "inspection"
              			, url : "cashReceipts"
              			, totalAmt : this.payTotalAmtView
                	};
                    this.$root.$emit('inputPwdPopupOpen', paramObj);
                }
                , fnCouponPayRequest : function() {
                	var paramData = {
							"token" : kerbanToken,
							"device_id" : gShopCd + gPosNo,
							"barcode" : orderInfo.couponBarcode,
					}
					//쿠폰조회
					var kerbanFullUrl = kerbanUrl + "api/fiserv/v1/barcodeuse";
					
					util.ajaxCallJson(paramData, kerbanFullUrl, false, this.fnAjaxCallJsonCallback);
                }
                , fnAjaxCallJsonCallback : function(result) {
					util.logInfo("***** fnAjaxCallJsonCallback START *****");
					if(result == "error"){
						util.logError("*****fnAjaxCallJsonCallback result ERROR*****");
					}else if(result == "timeout"){
						var messageObj = util.languageObjReturn(langCode,  'timeoutMsg_2');
						var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
				        var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj};
				        //경고메세지 팝업
				        eventBus.$emit('alertPopupIndex', dataObj); 
					}else{
						util.logInfo("*****fnAjaxCallJsonCallback result ==>> "+ result);
						if(result.code == "200"){
							//쿠폰결제시작
		        			orderMenuService.fnPayCouponBtn();
						} else {
							//var messageObj = util.languageObjReturn(langCode,  'timeoutMsg_2');
							var messageObj = result.msg;
							var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
					        var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj};
					        //경고메세지 팝업
					        eventBus.$emit('alertPopupIndex', dataObj); 
						}
					}							
				}
//                , fnChkBeforGoToMain : function() {
//                	//구독취소 추가
//                	if(orderInfo.BARODA_INFO !== undefined ) {
//                		if(orderInfo.BARODA_INFO.newSubscribeStatus == "Y") { //신규구독여부일때만 취소
//                			let barodaParams;
//                			//구독신청
//                			barodaParams = {
//                					storeId : gShopCd
//                					, subscribeNumber : orderInfo.BARODA_INFO.subscribeNumber
//                					, memo : "고객요청"
//                			}
//                			util.barodaAjaxCall(barodaParams, false, "POST", "/api/subscribe/buy/cancel", this.barodaSubBuyCancelCallBack);
//                		}
//                	}
//                	
//                	this.$router.push({name: 'start'});
//                }
//                , barodaSubBuyCancelCallBack : function(result) {
//                	if(result.success) {
//                		//구독취소 성공
//                		util.logInfo("___________ 구독권 취소 성공 ___________");
//                	} else {
//                		let barodaParams;
//            			//구독신청
//            			barodaParams = {
//            					storeId : gShopCd
//            					, subscribeNumber : orderInfo.BARODA_INFO.subscribeNumber
//            					, memo : "고객요청"
//            			}
//            			
//            			//넷캔슬파일 만들기
//            			util.makeBarodaDataFile(barodaParams);
//                	}
//                	
//                }
	        }
	    };
	    return returnTemplate;
	},

    // 마일리지 조회 전
	this.fnGetMileage = function(){
		let swiperStamp ; //레이어 내부 슬라이드 시작
		let returnTemplate = { template: '#mileage'
        	, data : function () {
        		return {
        			phoneMask : ""
        	      , phoneNumber : ""
        	      , isHidden : true
        	      , activeClass : "black"
        	      , activeButton : util.languageObjReturn(langCode,  'activeButton')
        	      , custAvlPoint : "0"
        	      , nUsePoint : "0"
        	      , price : ""
        		  , pointClass : "c_org"
        		  , focusType : "phone"
        		  , minUsePoint : "0"
        		  , maxUsePoint : "0"
        		  , phone : ""
        		  , cstUsePoint : "0"
        		  , cstNo : ""
    			  , cstClsCd : ""
    			  , cstCardNo : ""
    			  , phoneNumberIn : util.languageObjReturn(langCode,  'phoneNumberIn')
    			  , pointType : ""
    			  , styleObject : { display : 'none' } 
        		  , orderProdList : []
        		  , allStampProdList : []
        		  , cstPointAmt : "0"
        		  //, pointCoType : "F"
        		}
        	},
        	filters : {
        		comma : function (val){
        			return String(val).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        		},
        		ojbToString : function (val){
        			return String(ojbToString);
        		}
			}
            , created : function() {
            	util.logInfo('마일리지 스탬프 조회전 화면  (created)====> SHOP_INFO.POINT_FG >>' +SHOP_INFO.POINT_FG );
            	//this.phoneNumber        = util.languageObjReturn(langCode,  'phoneNumber');

            	if(SHOP_INFO.POINT_FG=="M"){
            		//도도토인트
            		if(SHOP_INFO.POINT_CO_VAL == "2"){
            			this.toUse        = util.languageObjReturn(langCode,  'toUseDodo');
        			} else {
        				this.toUse        = util.languageObjReturn(langCode,  'toUse');
        			}
                	this.rmTypeOne    = util.languageObjReturn(langCode,  'rmTypeOne');
                	this.rmTypeTwo    = util.languageObjReturn(langCode,  'rmTypeTwo');
                	this.rmType       = util.languageObjReturn(langCode,  'rmTypeMile');
                	this.selectProd   = util.languageObjReturn(langCode,  'selectProd');
                	this.pointType    = "M"
                }else{
                	this.toUse        = util.languageObjReturn(langCode,  'toUse');
                	this.rmTypeOne    = util.languageObjReturn(langCode,  'rmTypeThree');
                	this.rmTypeTwo    = util.languageObjReturn(langCode,  'rmTypeFour');
                	this.rmType       = util.languageObjReturn(langCode,  'rmTypeStamp');
                	this.selectProd   = util.languageObjReturn(langCode,  'selectProd');
                	this.pointType    = "S"
                }
            	
            	if(SHOP_INFO.POINT_CO_VAL == "2"){
            		//도도포인트 매장일 경우
            		//this.pointCoType == "D";
            		//this.pointType    = "D";
            	}
            	
            	this.activeButton = util.languageObjReturn(langCode,  'activeButton');
            	util.logInfo("this.$route.params.price : " + this.$route.params.price );
            	this.price = this.$route.params.price;
            	// 제휴할인값이 존재 한다면 할인받은 금액을 차감해준다.
            	if ( orderInfo.POS_ODJCD_T !== undefined) {
            		if(orderInfo.POS_ODJCD_T.JCD_TYPE_FG =="M"){ // mp포인트 일 때
            			this.price  =  Number(this.$route.params.price) - Number(orderInfo.POS_ODHDR_T.JCD_CARD_AMT);
            		}else{
            			this.price  =  Number(this.$route.params.price) - Number(orderInfo.POS_ODJCD_T.JCD_USE_POINT);
            		}
            		
            	}

				if(gvEatTakeOutVal == "0" || gvEatTakeOutVal == "1" || gvEatTakeOutVal == "2"){
                	//포장하기인 경우에만 금액변동 - TOGO_CHARGE < 0
                	if(gOrderType == "takeout"){
						this.price  = this.price - orderInfo.POS_ODHDR_T.DC_PACK_AMT;
					}
				}
            	
            	if(basicOrderInfo.notifyTalkPhoneNo != "" ) {
            		this.phoneNumber = basicOrderInfo.notifyTalkPhoneNo;
            		
            		var x1 = paymentChoiceService.fnPhoneNumMasking(this.phoneNumber);
            		//console.log('x1'  , x1);
            		this.phoneMask = x1;
            	} 
            	
            }
            , mounted : function() {
                util.setMenuSlider();
                var messageErr = "";
                var hpEntered = this.$route.params.phone;
                
                this.stampCssStyle();
                
                //this.$root.$on('barCodeInputResult' , obj => {
                this.$root.$on('dodoAuthKeyVerifyCallback' , obj => {
					util.logInfo("on -> dodoAuthKeyVerifyCallback " , obj);
					this.dodoAuthKeyVerifyCallback(obj);
            	});
                
            }
            , methods : {
            	// 전화번호 키패드
            	fn_number_keypad : function (key) {
            		//console.clear();
            		util.logInfo('마일리지  조회전 화면  (전화번호 키패드)====>');

            		// 핸드폰번호 입력시
            		if(this.focusType == "phone"){
            			if(this.phoneNumber == undefined) this.phoneNumber = "";
            			// phone : 하이픈 포함.
                		// phoneNumber : 입력받고
                		this.phoneNumber = paymentChoiceService.number_keypad( key, this.phoneNumber);

                		if(this.phoneNumber.substr(0, 2) == "02") {
                			if (this.phoneNumber.length > 10){
                				this.phoneNumber = this.phoneNumber.slice(0, -1);
        					}
                		} else if(this.phoneNumber.substr(0, 3) == "050") {
                			if (this.phoneNumber.length > 12){
                				this.phoneNumber = this.phoneNumber.slice(0, -1);
        					}
                		} else {
                			if (this.phoneNumber.length > 11){
                				this.phoneNumber = this.phoneNumber.slice(0, -1);
        					}
                		}

                    	//var x1 = paymentChoiceService.autoHypenPhone(this.phoneNumber);
                    	var x1 = paymentChoiceService.fnPhoneNumMasking(this.phoneNumber);
                    	//console.log('x1'  , x1);
                    	this.phoneMask = x1;

                    	if(this.phoneNumber.length < 1){
                    		this.activeClass = "black";
                    		this.activeButton = util.languageObjReturn(langCode,  'activeButton')
                    		this.isHidden = true;
                    		this.custAvlPoint = "0";
        		    		this.nUsePoint = "0";
        		    		this.pointClass = "c_org";
        		    		this.minUsePoint = "0";
        		    		this.maxUsePoint = "0";
        		    		this.cstNo = "";
                    	}
            		} else {
            			// 마일리지 입력시
            			this.nUsePoint = paymentChoiceService.number_keypad( key, this.nUsePoint);

                    	// this.availablePoint
            		}
                },// end fn_number_keypad

                fnMileageChk : function() {
            		// this.rmType = "조회완료";
                	util.logInfo("***** #mileage fnMileageChk START *****");
            		util.logDebug("*** #mileage fnMileageChk isHidden >>>" + this.isHidden);
            		var obj = { message : "", messageType : "alert" };
            		$("#stampUseBtn").attr("disabled", false);
            		if(this.phoneNumber.length >= 10){
            			this.isHidden = false;
            			if(this.activeButton === util.languageObjReturn(langCode,  'activeButton')){
            				util.logInfo("고객정보 조회하기 >>> ");
            				// 폰번호로 고객정보 조회
            				if(SHOP_INFO.POINT_CO_VAL == "2"){
                        		//도도포인트 매장일 경우
            					dodoPointService.dodoGetPostAjaxCall("", "", false, "GET", this.phoneNumber, this.dodoClientInfoDataCallback);
                        	} else {
                        		aspData.clientBasicInfoAspDataSearch("CS010", "", this.phoneNumber, "", "", this.clientBasicInfoAspDataCallback);
                        	}

            			} else {
            				if(SHOP_INFO.POINT_CO_VAL == "2"){
                        		//도도포인트 매장일 경우
                        		//this.pointCoType == "D";
                        		//this.pointType    = "D";
            					this.useDodoPoint();
                        	} else {
                        		setTimeout(this.useMileage, 100);
                        		//this.useMileage();
                        	}
            			}
            		} else {
		    			obj.message = this.phoneNumberIn;
		    			this.makeMessageAlert(obj);
            		}
            	},
            	clientBasicInfoAspDataCallback : function(resultData, returnObj){
            		util.logInfo(" ***** #mileage clientBasicInfoAspDataCallback START *****")
            		util.logDebug("*** resultData >>>>> " + resultData);
            		var obj = { message : "", messageType : "alert" };
            		
            		// asp 통신시 에러발생한 경우 처리.
            		if(resultData == "error"){
            			util.logInfo("***** #mileage clientBasicInfoAspDataCallback asp result error *****");
            			var vsTimeoutMsg
            			if(returnObj.status == "timeout"){
            				vsTimeoutMsg = util.languageObjReturn(langCode,  "timeoutMsg"); // 서버와의 통신이 원활하지 않습니다. 인터넷을 확인해 주세요.
            			}else{
            				vsTimeoutMsg = util.languageObjReturn(langCode,  "failMsg")  + " [" + returnObj.e.toString() + "]"; // 정상 처리되지 않았습니다.
            			}
            			//obj.message = vsTimeoutMsg;
            			//this.makeMessageAlert(obj);
            			
            			let dataObj = {};
            			dataObj.button2Show = true;
            			dataObj.button2Func = this.fnBackMile
            			dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 예 ]
						dataObj.message = vsTimeoutMsg;
						eventBus.$emit('alertPopupIndex', dataObj);
						
            			return;
                	}
            		
    				var txjmFd = resultData["TSP-NVP"]["TXJM-FD"];
    		    	var resultData = {};


    		    	if(txjmFd["_RETCD"] == "0000") {
    		    		var dataHd = txjmFd["DATA-HD"];

    		    		// util.log(JSON.stringify(txjmFd));
    		    		// util.log(JSON.stringify(dataDt));

    		    		if(dataHd._DATA_CNT == 0 ){
    		    			// 조회한 고객정보가 없을때
    		    			//obj.message = util.languageObjReturn(langCode,  'noCustomerInformation');
    		    			//this.makeMessageAlert(obj);
    		    			let dataObj = {};
                			dataObj.button2Show = true;
                			dataObj.button2Func = this.fnBackMile
                			dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 예 ]
							dataObj.message = util.languageObjReturn(langCode,  'noCustomerInformation');
							//dataObj.data.subsMenuHasChk = "Y"; 
    						eventBus.$emit('alertPopupIndex', dataObj);
    						
    		    			return false;
    		    		}

    		    		var dataDt;
    		    		
    		    		//회원정보가 1개이상일때 고객번호를 비교해서 가장큰 고객번호의 회원정보로 세팅해준다
    		    		//dataHd._DATA_CNT 조회된 고객정보 함계
    		    		if(dataHd._DATA_CNT > 1) {
    		    			var cstNo = 0;
    		    			var cstNoTemp = 0;
    		    			var cstListNo = 0;
    		    			for(var i=0; i<dataHd._DATA_CNT; i++){
    		    				if(i == 0){
    		    					cstNo = parseInt(dataHd["DATA-DT"][i]._CST_NO);
    		    				} else {
    		    					cstNoTemp = parseInt(dataHd["DATA-DT"][i]._CST_NO);
    		    					if(cstNo < cstNoTemp){
    		    						cstNo = cstNoTemp;
    		    						cstListNo = i;
    		    					}
    		    				}
    		    			}
    		    			dataDt = dataHd["DATA-DT"][cstListNo];
    		    		} else {
    		    			dataDt = dataHd["DATA-DT"];
    		    		}
    		    		
    		    		//var dataDt = dataHd["DATA-DT"];
    		    		// var usageMileage = 0;
    		    		

    		    		if(dataDt._AVL_POINT > 0 ) {
        		    		if(SHOP_INFO.POINT_FG == "M") {
	    					// usageMileage = this.price;
	    					// 최대 사용 포인트가 0이면 사용 포인트 제한이 없음
    		    			if(dataDt._MAX_USE_POINT == 0) {
    		    				
    		    				if(this.price > dataDt._AVL_POINT) {
    		    					this.nUsePoint = dataDt._AVL_POINT;
    		    				} else {
    		    					this.nUsePoint = this.price;
    		    				}
    		    			} else {
    		    				if(this.price > dataDt._MAX_USE_POINT) {
    		    					this.nUsePoint = dataDt._MAX_USE_POINT;
    		    				} else {
    		    					this.nUsePoint = this.price;
    		    				}
    		    				//_MAX_USE_POINT(최대 사용 포인트), _MIN_USE_POINT(최소 사용 포인트)
        		    		}

        		    			this.nUsePoint = this.nUsePoint;
        		    		} else {
        		    			this.allStampProdList = [];
        		    			//스탬프 매장일 경우
        		    			for(var i=0; i<orderInfo.POS_ODDTL_T.length; i++) {
        		    				for(var j=0; j<orderInfo.POS_ODDTL_T[i].ORDER_QTY; j++) {
        		    					if(orderInfo.POS_ODDTL_T[i].STAMP_USE_YN == "Y") {
	    		    						let stampRow = orderInfo.POS_ODDTL_T[i];
	    		    						stampRow = util.clone(stampRow);
	    		    						stampRow.INDEX = "check" + i + j;
	    		    						stampRow.INDEXNO = i + '' +  j;
	    		    						this.allStampProdList.push(stampRow);
        		    						
	    		    						//사이드 메뉴중 가격이 0원이상인 속성을 스탬프 선택화면에 추가
	    		    						if(stampRow.사이드_LIST != undefined) {
	    		    							for(var x=0; x<stampRow.사이드_LIST.length; x++) {
	    		    								let stampSideRow = stampRow.사이드_LIST[x];
	    		    								if(stampSideRow.사이드판매가 > 0 ) {
	    		    									let stampSideInfo = JSON.parse(stampSideRow.사이드INFO_TXT);
	    		    									if(stampSideInfo.STAMP_USE_YN == "Y") { //스탬프 사용 유무 체크
	    		    										var stampSideLength = 0;
	    		    										stampSideLength = stampSideRow.SIDE_QTY;

    		    											for(k=0; k < stampSideLength; k++) {
	    		    											var tempStampSideInfo = util.clone(stampSideInfo);
	    		    											var tempStampSideRow = util.clone(stampSideRow);
	    		    											tempStampSideInfo.INDEX = "check" + i + j + x + k;
	    		    											tempStampSideInfo.INDEXNO = i + '' +  j + '' + x + '' + k;
	        		    										tempStampSideRow.INDEX = tempStampSideInfo.INDEX;
	        		    										tempStampSideRow.INDEXNO = tempStampSideInfo.INDEXNO;
	        		    										tempStampSideRow.NORMAL_UPRC = tempStampSideInfo.SIDE_UPRC;
	        		    										tempStampSideRow.DCM_SALE_AMT = stampSideInfo.SIDE_UPRC;
	        		    										tempStampSideRow.판매단가 = tempStampSideInfo.SIDE_UPRC;
	        		    										tempStampSideRow.PROD_NM = tempStampSideInfo.SIDE_NM;
	        		    										tempStampSideRow.PROD_NM_EN = tempStampSideInfo.SIDE_NM_EN;
	        		    										tempStampSideRow.STAMP_ACC_YN = tempStampSideInfo.STAMP_ACC_YN;
	        		    										tempStampSideRow.STAMP_ACC_QTY = tempStampSideInfo.STAMP_ACC_QTY;
	        		    										tempStampSideRow.STAMP_USE_YN = tempStampSideInfo.STAMP_USE_YN;
	        		    										tempStampSideRow.STAMP_USE_QTY = tempStampSideInfo.STAMP_USE_QTY;
	        		    										//사이드 메뉴는 PROD_CD로 중복체크하기 힘들기 떄문에 사이드_중복체크값을 비교값으로 사용하기 위해서 추가
	        		    										tempStampSideRow.사이드_중복체크값 = stampRow.사이드_중복체크값;
	        		    										this.allStampProdList.push(tempStampSideRow);
    		    											}
	//        		    										STAMPSIDEINFO.INDEX = "CHECK" + I + J + X;
	//        		    										STAMPSIDEINFO.INDEXNO = I + '' +  J + '' + X;
	//        		    										STAMPSIDEROW.INDEX = STAMPSIDEINFO.INDEX;
	//        		    										STAMPSIDEROW.INDEXNO = STAMPSIDEINFO.INDEXNO;
	//        		    										STAMPSIDEROW.NORMAL_UPRC = STAMPSIDEINFO.SIDE_UPRC;
	//        		    										STAMPSIDEROW.DCM_SALE_AMT = STAMPSIDEINFO.SIDE_UPRC;
	//        		    										STAMPSIDEROW.판매단가 = STAMPSIDEINFO.SIDE_UPRC;
	//        		    										STAMPSIDEROW.PROD_NM = STAMPSIDEINFO.SIDE_NM;
	//        		    										STAMPSIDEROW.PROD_NM_EN = STAMPSIDEINFO.SIDE_NM_EN;
	//        		    										STAMPSIDEROW.STAMP_ACC_YN = STAMPSIDEINFO.STAMP_ACC_YN;
	//        		    										STAMPSIDEROW.STAMP_ACC_QTY = STAMPSIDEINFO.STAMP_ACC_QTY;
	//        		    										STAMPSIDEROW.STAMP_USE_YN = STAMPSIDEINFO.STAMP_USE_YN;
	//        		    										STAMPSIDEROW.STAMP_USE_QTY = STAMPSIDEINFO.STAMP_USE_QTY;
	//        		    										//사이드 메뉴는 PROD_CD로 중복체크하기 힘들기 떄문에 사이드_중복체크값을 비교값으로 사용하기 위해서 추가
	//        		    										STAMPSIDEROW.사이드_중복체크값 = STAMPROW.사이드_중복체크값;
	//        		    										THIS.ALLSTAMPPRODLIST.PUSH(STAMPSIDEROW);
	    		    									}
        		    									
	    		    								}
        		    								
	    		    							}
	    		    						}
        		    					}
        		    				}
        		    			}
	    		    			util.logInfo("____________ this.allStampProdList : " + JSON.stringify(this.allStampProdList) + "___________");
	    		    			util.setRowsLanguage( this.allStampProdList, langCode, 'PROD_NM'  );//언어처리.
	    		    			this.styleObject = {display : 'block'};
        		    		}

			    			this.activeClass = "org";
	    		    		this.activeButton = util.languageObjReturn(langCode,  'toUse');
	    		    		this.pointClass = "c_org";
	
	    		    		this.custAvlPoint = dataDt._AVL_POINT;
	    		    		this.minUsePoint = dataDt._MIN_USE_POINT;
	    		    		this.maxUsePoint = dataDt._MAX_USE_POINT;
	    		    		this.cstNo = dataDt._CST_NO;
	    		    		this.cstClsCd = dataDt._CST_CLS_CD;
	    		    		this.cstCardNo = dataDt._CST_CARD_NO;

    		    		} else {
		    			// 잔액이 부족합니다. 메세지 처리
//    		    			obj.message = util.languageObjReturn(langCode,  'noRemainingPoints');
//    		    			this.makeMessageAlert(obj);
    		    			
			    			let dataObj = {};
	            			dataObj.button2Show = true;
	            			dataObj.button2Func = this.fnBackMile
	            			dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 예 ]
							dataObj.message = util.languageObjReturn(langCode,  'noRemainingPoints');
							eventBus.$emit('alertPopupIndex', dataObj);
			    		}

    		    	} else {
    		    		obj.message = util.languageObjReturn(langCode,  "failMsg") + " [_RETCD is not 0000]";
    		    		this.makeMessageAlert(obj);	// 정상처리 되지 않았습니다. [_RETCD is not 0000]
    		    	}
            	},
                useMileage : function() {
                	util.logInfo("포인트 사용하기 >>> ");
                	util.logInfo("custAvlPoint >>> " + this.custAvlPoint);
                	util.logInfo("nUsePoint >>> " + this.nUsePoint);
                	this.nUsePoint = this.nUsePoint.toString();
                	/*************************************************
					 * 2020.11.18. 입력값 없을때 0으로 설정.
                	 *************************************************/
                	if ( util.byteLen (this.nUsePoint ) == 0)
                		this.nUsePoint = 0;

                	this.custAvlPoint = parseInt(this.custAvlPoint);
                	this.nUsePoint = parseInt(this.nUsePoint);
                	util.logInfo("custAvlPoint >>> " + typeof this.custAvlPoint);
                	util.logInfo("nUsePoint >>> " + typeof this.nUsePoint);

                	var obj = { message : "", messageType : "alert" };

                	if(this.nUsePoint > this.custAvlPoint){
                		// 잔여포인트 AVL_POINT 가 사용 포인트 this.nUsePoint 보다 작습니다.
                		// 잔여 포인트내에서 결제 해 주세요.
                		//alert("잔여포인트가 "+ this.custAvlPoint +"가 사용 포인트 " + this.nUsePoint + "보다 작습니다.");
                		obj.message = util.languageObjReturn(langCode,  'mileageNotificationMsg1');
		    			this.makeMessageAlert(obj);
                		return;
            		}

                	// 최대 사용 포인트가 0이면 사용 포인트 제한이 없음
                	// max value check
            		if(this.maxUsePoint > 0 && this.maxUsePoint < this.nUsePoint){
            			// _MAX_USE_POINT
            			// alert("최대사용가능포인트 "+ this.maxUsePoint +"를 초과 하였습니다.");
            			obj.message = util.languageObjReturn(langCode,  'mileageNotificationMsg2');
		    			this.makeMessageAlert(obj);
            			return;
            		}

            		// min value check
            		if(this.custAvlPoint < this.minUsePoint ) {
            			//alert("잔여 표인트가 최소사용 포인트 "+ this.minUsePoint +" 보다 작습니다.");
            			obj.message = util.languageObjReturn(langCode,  'mileageNotificationMsg3');
		    			this.makeMessageAlert(obj);
            			return;
            		}

            		// min&nUsePoint value check
            		if(this.nUsePoint < this.minUsePoint ) {
            			//alert("사용 포인트가 최소 사용포인트인 "+ this.minUsePoint +" 보다 작습니다.");
            			obj.message = util.languageObjReturn(langCode,  'mileageNotificationMsg4');
		    			this.makeMessageAlert(obj);
            			return;
            		}
            		
            		//orderInfo.POS_ODHDR_T.CST_CLS_CD = this.cstClsCd;
            		orderInfo.POS_ODHDR_T.CST_NO = this.cstNo;
            		orderInfo.POS_ODHDR_T.CST_USE_POINT = this.nUsePoint;
            		orderInfo.POS_ODHDR_T.CST_POINT_AMT = this.nUsePoint;
            		orderInfo.POS_ODHDR_T.CST_CARD_NO = this.cstCardNo;
            		orderInfo.POS_ODHDR_T.CST_AVL_POINT = this.custAvlPoint;
            		//orderInfo.POS_ODHDR_T.GST_PAY_AMT = this.nUsePoint;
//            		if(orderInfo.POS_ODHDR_T.CST_POINT_AMT !== undefined) {
//        	  	   		orderInfo.POS_ODHDR_T.GST_PAY_AMT += parseInt(orderInfo.POS_ODHDR_T.CST_POINT_AMT);  
//        	  	   	}
            		
            		let flag = false;
            		
            		if(orderInfo.POS_ODHDR_T.CST_USE_POINT > 0) {
	            		var totSaleAmt = this.price;
	            		var totCstUsePoint = orderInfo.POS_ODHDR_T.CST_USE_POINT;

	            		if ( totSaleAmt ==  totCstUsePoint )
	            			flag = true;
            		}
            		//let flag = this.cornerMileageCalc();
            		
            		// 0원 결제 여부.(0원 결제일때는 결제 프로세스를 바로 탄다.
            		if ( flag == true ) {

            			//0원 결제정보 설정
            			paymentChoiceService.setPointPaymentInfo();

            			//결제 프로세스로 이동.
//            			orderPayRegService.orderPayReg();
            			util.logInfo("***** useMileage flag true IN *****");
            			paymentChoiceView.fnCardReaderStatus("M"); // 파라미터가 C일 때만 카드제거해주세요 로직을 수행하도록함. 따라서 M이라고 임의로 셋팅

            		} else {

            			this.$router.push({name: 'paymentChoiceView', params: { price: util.numberWithCommas(this.nUsePoint) }})

            		}
            	},
            	useStamp : function() {
            		util.logInfo("포인트 사용하기 >>> ");
                	util.logInfo("custAvlPoint >>> " + this.custAvlPoint);
                	util.logInfo("nUsePoint >>> " + this.nUsePoint);
                	
                	var obj = { message : "", messageType : "alert" };
                	
                	if($("input:checkbox[name^=check]:checked").length < 1) {
                		//선택한 상품이 없을경우
                		obj.message = util.languageObjReturn(langCode,  'selectProd');
		    			this.makeMessageAlert(obj);
                		return;
                	}
                	
                	this.nUsePoint = this.nUsePoint.toString();
                	/*************************************************
                	 * 2020.11.18. 입력값 없을때 0으로 설정.
                	 *************************************************/
                	if ( util.byteLen (this.nUsePoint ) == 0)
                		this.nUsePoint = 0;

                	this.custAvlPoint = parseInt(this.custAvlPoint);
                	this.nUsePoint = parseInt(this.nUsePoint);
                	util.logInfo("custAvlPoint >>> " + typeof this.custAvlPoint);
                	util.logInfo("nUsePoint >>> " + typeof this.nUsePoint);


                	if(this.nUsePoint > this.custAvlPoint){
                		//잔여포인트 AVL_POINT 가 사용 포인트 this.nUsePoint 보다 작습니다.
                		//잔여 포인트내에서 결제 해 주세요.
                		//alert("잔여포인트가 "+ this.custAvlPoint +"가 사용 포인트 " + this.nUsePoint + "보다 작습니다.");
                		obj.message = util.languageObjReturn(langCode,  'stampNotificationMsg1');
		    			this.makeMessageAlert(obj);
                		return;
            		}

                	//최대 사용 포인트가 0이면 사용 포인트 제한이 없음
                	// max value check
            		if(this.maxUsePoint > 0 && this.maxUsePoint < this.nUsePoint){
            			//_MAX_USE_POINT
            			//alert("최대사용가능포인트 "+ this.maxUsePoint +"를 초과 하였습니다.");
            			obj.message = util.languageObjReturn(langCode,  'stampNotificationMsg2');
		    			this.makeMessageAlert(obj);
            			return;
            		}

            		//min value check
            		if(this.custAvlPoint < this.minUsePoint ) {
            			//alert("잔여 표인트가 최소사용 포인트 "+ this.minUsePoint +" 보다 작습니다.");
            			obj.message = util.languageObjReturn(langCode,  'stampNotificationMsg3');
		    			this.makeMessageAlert(obj);
            			return;
            		}

            		//min&nUsePoint value check
            		if(this.nUsePoint < this.minUsePoint ) {
            			//alert("사용 포인트가 최소 사용포인트인 "+ this.minUsePoint +" 보다 작습니다.");
            			obj.message = util.languageObjReturn(langCode,  'stampNotificationMsg4');
		    			this.makeMessageAlert(obj);
            			return;
            		}

            		orderInfo.POS_ODHDR_T.CST_CLS_CD = this.cstClsCd;
            		orderInfo.POS_ODHDR_T.CST_NO = this.cstNo;
            		orderInfo.POS_ODHDR_T.CST_USE_POINT = this.nUsePoint;
            		orderInfo.POS_ODHDR_T.CST_POINT_AMT = this.cstPointAmt;
            		orderInfo.POS_ODHDR_T.CST_CARD_NO = this.cstCardNo;
            		orderInfo.POS_ODHDR_T.CST_AVL_POINT = this.custAvlPoint;
            		orderInfo.POS_ODHDR_T.GST_PAY_AMT = this.cstPointAmt;
            		
            		util.logInfo("__________stampUseBtn disabled__________ : " + $("#stampUseBtn").attr("disabled"));
            		$("#stampUseBtn").attr("disabled", true);
            		// 스탬프 적립계산
            		let flag = this.cornerStampCalc();

            		//0원 결제 여부.(0원 결제일때는 결제 프로세스를 바로 탄다.
            		if ( flag == true ) {
            			// 0원 결제정보 설정
            			paymentChoiceService.setPointPaymentInfo();

            			//결제 프로세스로 이동.
//            			orderPayRegService.orderPayReg();
            			util.logInfo("***** useMileage flag true IN *****");
            			paymentChoiceView.fnCardReaderStatus("M"); // 파라미터가 C일 때만 카드제거해주세요 로직을 수행하도록함. 따라서 M이라고 임의로 셋팅

            		} else {
            			util.logInfo("***** this.cstPointAmt >> " + this.cstPointAmt);
            			this.$router.push({name: 'paymentChoiceView', params: { price: util.numberWithCommas(this.nUsePoint) }})

            		}
            	},
            	setFocusType(type) {
            		this.focusType = type;
            	},
            	makeMessageAlert(messageObj) {
            		$("#stampUseBtn").attr("disabled", false);
	    			this.$root.$emit( "notiMessage" ,   messageObj  );
            	},
            	cornerMileageCalc(){
            		/************************
					 * 0원결제 처리 여부.
            		 ************************/
            		let rtnFlag = false;
            		
            		// 마일리지 사용시 상품별 마일리지계산
            		// 사용포인트가 0이상일떄
            		if(orderInfo.POS_ODHDR_T.CST_USE_POINT > 0) {
	            		var totSaleAmt = this.price; //orderInfo.POS_ODHDR_T.TOT_SALE_AMT;
	            		var totCstUsePoint = orderInfo.POS_ODHDR_T.CST_USE_POINT;
	            		var productTaxRate = totCstUsePoint / totSaleAmt;
	            		var tmpCstUsePoint = 0;

	            		util.logInfo("### totSaleAmt : " + totSaleAmt + ", totCstUsePoint : " + totCstUsePoint + ", productTaxRate : " + productTaxRate);
	            		if ( totSaleAmt ==  totCstUsePoint )
	            			rtnFlag = true;

	            		var poddtlt = orderInfo.POS_ODDTL_T;

	            		for(var i=0; i<orderInfo.POS_ODDTL_T.length; i++){
	            			util.logInfo("### cstUsePoint["+i+"]: " + orderInfo.POS_ODDTL_T[i].SALE_AMT * productTaxRate);
	            			util.logInfo("### parseInt cstUsePoint["+i+"]: " + parseInt(orderInfo.POS_ODDTL_T[i].SALE_AMT * productTaxRate));
	            			var cstUsePoint = parseInt(orderInfo.POS_ODDTL_T[i].SALE_AMT * productTaxRate);
	            			tmpCstUsePoint += cstUsePoint;
	            			orderInfo.POS_ODDTL_T[i].CST_USE_POINT = cstUsePoint;
	            		}

	            		let POS_ODCST_T = [];
	            		let localDate = moment().format("YYYYMMDDHHmmss");

	            		var tmpCornerCstUsePoint = 0;

             			// 고객 사용 포인트
             			for(var j=0; j<orderInfo.CORNER_LIST.length; j++){
             				util.logInfo("### CORNER cstUsePoint["+j+"]: " + orderInfo.CORNER_LIST[j].SALE_AMT * productTaxRate);
                			util.logInfo("### CORNER parseInt cstUsePoint["+j+"]: " + parseInt(orderInfo.CORNER_LIST[j].SALE_AMT * productTaxRate));
                			tmpCornerCstUsePoint += parseInt(orderInfo.CORNER_LIST[j].SALE_AMT * productTaxRate);
             				var podcst = {
             						SHOP_CD        : gShopCd             // VARCHAR(6)
             						,SALE_DATE      : saleDate            // VARCHAR(8)
             						,ORDER_NO       : ""  	 	          // VARCHAR(4)
         							,LINE_NO        : ""              	  // VARCHAR(4)
     								,POS_NO         : gPosNo              // VARCHAR(2)
     								,SALE_YN        : "Y"                 // VARCHAR(1)		'Y'
 									,CST_NO         : orderInfo.POS_ODHDR_T.CST_NO                  				// VARCHAR(10)
 									,CST_CARD_NO    : orderInfo.POS_ODHDR_T.CST_CARD_NO  							// VARCHAR(16)
 									,CST_CLS_CD     : orderInfo.POS_ODHDR_T.CST_CLS_CD                 				// VARCHAR(2)
 									,CST_USE_POINT  : parseInt(orderInfo.CORNER_LIST[j].SALE_AMT * productTaxRate)  // NUMERIC(12,2) DEFAULT 0 NOT NULL
 									,CST_POINT_AMT  : parseInt(orderInfo.CORNER_LIST[j].SALE_AMT * productTaxRate)  // NUMERIC(12,2) DEFAULT 0 NOT NULL
 									,INS_DT         : localDate           // VARCHAR(14)
 									,EMP_NO        	: ""                  // VARCHAR(4)
									,CST_USE_AMT    : orderInfo.CORNER_LIST[j].SALE_AMT    	 // NUMERIC(12,2)
									,CORNER_CD      : orderInfo.CORNER_LIST[j].CORNER_CD     // VARCHAR(2)				'00'
									,SEQ_NO      	: ""                  // VARCHAR(2)				'01'
             				};
             				POS_ODCST_T.push(podcst);
             				util.logInfo("### podcst["+j+"] : " + JSON.stringify(podcst));
             				orderInfo.CORNER_LIST[j].CST_USE_POINT = parseInt(orderInfo.CORNER_LIST[j].SALE_AMT * productTaxRate);
             			}

            	 		orderInfo.POS_ODCST_T = POS_ODCST_T;

	             		var poddtltLength = orderInfo.POS_ODDTL_T.length;
	             		var cornerListLength = orderInfo.CORNER_LIST.length;

	             		util.logInfo("### poddtltLength : " + poddtltLength);
	             		util.logInfo("### cornerListLength : " + cornerListLength);
	             		util.logInfo("### totCstUsePoint : " + totCstUsePoint);
	             		util.logInfo("### tmpCstUsePoint : " + tmpCstUsePoint);
	             		util.logInfo("### tmpCornerCstUsePoint : " + tmpCornerCstUsePoint);
	             		util.logInfo("### totCstUsePoint - tmpCstUsePoint : " + (totCstUsePoint - tmpCstUsePoint));
	             		util.logInfo("### totCstUsePoint - tmpCstUsePoint : " + (totCstUsePoint - tmpCornerCstUsePoint));

	             		// POS_ODDTL_T(상품별) 소수점 절사하고 남은금액은 마지막 상품및 코너에 금액추가해서 계산
	             		if(tmpCstUsePoint < totCstUsePoint){
	            			orderInfo.POS_ODDTL_T[poddtltLength-1].CST_USE_POINT += totCstUsePoint - tmpCstUsePoint;
	            		}

	             		// POS_ODCST_T(코너별) 소수점 절사하고 남은금액은 마지막 상품및 코너에 금액추가해서 계산
	             		if(tmpCornerCstUsePoint < totCstUsePoint){
	            			orderInfo.POS_ODCST_T[cornerListLength-1].CST_USE_POINT += totCstUsePoint - tmpCornerCstUsePoint;
	            			orderInfo.POS_ODCST_T[cornerListLength-1].CST_POINT_AMT += totCstUsePoint - tmpCornerCstUsePoint;
	            			orderInfo.CORNER_LIST[cornerListLength-1].CST_USE_POINT += totCstUsePoint - tmpCornerCstUsePoint;
	            		}
             		}
            		return rtnFlag;
            	}
            	, stampCssStyle : function()  {
            		$("#stampUseBtn").attr("disabled", false);
            		swiperStamp = new Swiper('.menuselectedWrap', {
            			direction: 'vertical',
            			slidesPerView: 8,
            			navigation: {
            				nextEl: '.scroll_down',
            				prevEl: '.scroll_up',
            			},
            		});
            	}
            	, stampCssStyleUpdate : function() {
                	swiperStamp.update();
                }
                , fnAddStamp : function(obj) {
                	util.logInfo("___________" + JSON.stringify(obj) + "__________" );
                	
                	if(obj.STAMP_USE_QTY == null || obj.STAMP_USE_QTY == undefined || obj.STAMP_USE_QTY == "" || obj.STAMP_USE_QTY.length == 0){
            			obj.STAMP_USE_QTY = 0;
            		}
                	
                	if(gvEatTakeOutVal == "0" || gvEatTakeOutVal == "1" || gvEatTakeOutVal == "2"){
        	        	if(gOrderType == "takeout"){
        	        		if(obj.TOGO_CHARGE !== undefined && obj.TOGO_PROD_YN !== undefined) {
        	        			if(obj.TOGO_PROD_YN != "N" && obj.TOGO_CHARGE < 0){
        	        				if($("#"+obj.INDEX).prop("checked")) {
                        				this.nUsePoint = parseInt(this.nUsePoint) + parseInt(obj.STAMP_USE_QTY);
                        				if(SHOP_INFO.VAT_CD == "0") {
                        					this.cstPointAmt = parseInt(this.cstPointAmt) + parseInt(obj.판매단가);
                        				} else {
                        					this.cstPointAmt = parseInt(this.cstPointAmt) + parseInt(obj.판매단가) - Math.abs(obj.TOGO_CHARGE);
                        				}
                                	} else {
                                		this.nUsePoint = parseInt(this.nUsePoint) - parseInt(obj.STAMP_USE_QTY);
                                		if(SHOP_INFO.VAT_CD == "0") {
                        					this.cstPointAmt = parseInt(this.cstPointAmt) - parseInt(obj.판매단가);
                        				} else {
                        					this.cstPointAmt = parseInt(this.cstPointAmt) - parseInt(obj.판매단가) + Math.abs(obj.TOGO_CHARGE);
                        				}
                                		
                                	}
        	        			} else {
        	        				if($("#"+obj.INDEX).prop("checked")) {
                                		this.nUsePoint = parseInt(this.nUsePoint) + parseInt(obj.STAMP_USE_QTY);
                                		this.cstPointAmt = parseInt(this.cstPointAmt) + parseInt(obj.판매단가);
                                		
                                	} else {
                                		this.nUsePoint = parseInt(this.nUsePoint) - parseInt(obj.STAMP_USE_QTY);
                                		this.cstPointAmt = parseInt(this.cstPointAmt) - parseInt(obj.판매단가);
                                	}
        	        			}
        	        		} else {
        	        			if($("#"+obj.INDEX).prop("checked")) {
                            		this.nUsePoint = parseInt(this.nUsePoint) + parseInt(obj.STAMP_USE_QTY);
                            		this.cstPointAmt = parseInt(this.cstPointAmt) + parseInt(obj.판매단가);
                            	} else {
                            		this.nUsePoint = parseInt(this.nUsePoint) - parseInt(obj.STAMP_USE_QTY);
                            		this.cstPointAmt = parseInt(this.cstPointAmt) - parseInt(obj.판매단가);
                            	}
        	        		}
        	        	} else {
        	        		if($("#"+obj.INDEX).prop("checked")) {
                        		this.nUsePoint = parseInt(this.nUsePoint) + parseInt(obj.STAMP_USE_QTY);
                        		this.cstPointAmt = parseInt(this.cstPointAmt) + parseInt(obj.판매단가);
                        		
                        	} else {
                        		this.nUsePoint = parseInt(this.nUsePoint) - parseInt(obj.STAMP_USE_QTY);
                        		this.cstPointAmt = parseInt(this.cstPointAmt) - parseInt(obj.판매단가);
                        	}
        	        	}
            		} else {
            			if($("#"+obj.INDEX).prop("checked")) {
                    		this.nUsePoint = parseInt(this.nUsePoint) + parseInt(obj.STAMP_USE_QTY);
                    		this.cstPointAmt = parseInt(this.cstPointAmt) + parseInt(obj.판매단가);
                    		
                    	} else {
                    		this.nUsePoint = parseInt(this.nUsePoint) - parseInt(obj.STAMP_USE_QTY);
                    		this.cstPointAmt = parseInt(this.cstPointAmt) - parseInt(obj.판매단가);
                    	}
            		}
                	
                	util.logInfo("### nUsePoint : " + this.nUsePoint + ", cstPointAmt : " + this.cstPointAmt);
                	
				}
                , cornerStampCalc(){
                	util.logInfo("______________ (스탬프적립) 스탬프적립금 계산 START _______________");
            		/************************
            		 * 0원결제 처리 여부.
            		 ************************/
            		let rtnFlag = false;
            		util.logInfo("___________" + JSON.stringify(this.allStampProdList) + "__________" );
            		//스탬프 사용시 상품별 마일리지계산
            		//사용포인트가 0이상일떄
            		//포장할인 금액을 빼준다, 포장할인값이없으면 기본 포장할인값은 0원
            		// var totSaleAmt = orderInfo.POS_ODHDR_T.TOT_SALE_AMT - orderInfo.POS_ODHDR_T.DC_PACK_AMT;
            		var totSaleAmt = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;
            		var totCstUsePoint = orderInfo.POS_ODHDR_T.CST_USE_POINT;
            		//포장할인 금액을 빼준다, 포장할인값이없으면 기본 포장할인값은 0원
            		var totCstPointAmt = this.cstPointAmt;
            		
            		util.logInfo("### totSaleAmt : " + totSaleAmt + ", totCstPointAmt : " + totCstPointAmt);
            		if ( totSaleAmt ==  totCstPointAmt ) rtnFlag = true;
            		
            		var resultData = gfn_SQLiteSQLProcess("SELECT STAMP_ACC_FG, STAMP_ACC_COST, STAMP_ACC_QTY, DC_ACC_YN, USE_ACC_YN FROM HCS_CSTCL_T WHERE CST_CLS_CD = ?" , [orderInfo.POS_ODHDR_T.CST_CLS_CD]);
            		let rows;
            		if ( resultData != null && resultData.ResultCode == "0" ) {
        				rows = resultData.Data;
        				if ( rows == undefined || rows == null ||  rows.length == 0 ) {
        					util.logError( "회원등급 테이블에 정보가 없습니다." );
        					return [];
        				}
             	   	}
             	   	
            		let cstSaleTotalPoint = 0;
             	   	//상품 상세별 스탬프 적립 및 사용
             	   	//코너별 스탬프 사용
            		//0.미사용, 1.사용, 2.사용+적립팝업
             	   	if(SHOP_INFO.PNT_ACMT_STATUS_VAL == "2") {
             	   		//사용스탬프 적립 O
	             	   	for(var i=0; i<orderInfo.POS_ODDTL_T.length; i++) {
	            			util.logInfo("### STAMP_USE_QTY["+i+"]: " + orderInfo.POS_ODDTL_T[i].STAMP_USE_QTY);
	            			let cstUsePoint = 0;
	            			let cstSalePoint = 0;
	            			let cstSideUsePoint = 0;
	            			if(orderInfo.POS_ODDTL_T[i].STAMP_USE_YN == "Y") { 
	            				for(var x=0; x<this.allStampProdList.length; x++) {
	            					if(orderInfo.POS_ODDTL_T[i].PROD_CD == this.allStampProdList[x].PROD_CD) {
	            						if(orderInfo.POS_ODDTL_T[i].사이드_중복체크값 != undefined) {
	            							if(orderInfo.POS_ODDTL_T[i].사이드_중복체크값 == this.allStampProdList[x].사이드_중복체크값) {
			            						if($("#"+this.allStampProdList[x].INDEX).prop("checked")) {
			            							cstUsePoint += parseInt(this.allStampProdList[x].STAMP_USE_QTY);
		            								if(this.allStampProdList[x].STAMP_ACC_YN == "Y" ) {
		            									if(rows[0].USE_ACC_YN == "Y") {
		            										//HCS_CSTCL_T 환경설정에서 스탬프 사용시 적립 사용
		            										cstSaleTotalPoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
		            									}
		            									cstSalePoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
			            							}
			            						} else {
		            								if(this.allStampProdList[x].STAMP_ACC_YN == "Y") {
		            									cstSalePoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
		            									cstSaleTotalPoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
			            							}
			            						}
			            					}
	            						} else {
	            							if($("#"+this.allStampProdList[x].INDEX).prop("checked")) {
		            							cstUsePoint += parseInt(this.allStampProdList[x].STAMP_USE_QTY);
	            								if(this.allStampProdList[x].STAMP_ACC_YN == "Y" ) {
	            									if(rows[0].USE_ACC_YN == "Y"){
	            										//HCS_CSTCL_T 환경설정에서 스탬프 사용시 적립 사용
	            										cstSaleTotalPoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
	            									}
	            									cstSalePoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
		            							}
		            						} else {
	            								if(this.allStampProdList[x].STAMP_ACC_YN == "Y"){
	            									cstSalePoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
	            									cstSaleTotalPoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
		            							}
		            						}
	            						}
	            					}
	            					
	            					//메인 메뉴가 아닌 사이드 메뉴 스탬프 적립 및 사용 체크 
	            					//메인 메뉴와 사이드 메뉴를 같은 객체에 담기 때문에 구분값이 필요해서 사이드 중복체크값으로 비교
	            					if(this.allStampProdList[x].사이드구분 != null && this.allStampProdList[x].사이드구분 != undefined) {
	            						if(orderInfo.POS_ODDTL_T[i].사이드_중복체크값 == this.allStampProdList[x].사이드_중복체크값) {
		            						if($("#"+this.allStampProdList[x].INDEX).prop("checked")) {
		            							for(var j=0; j<orderInfo.POS_ODDTL_T[i].사이드_LIST.length; j++) {
		            								if(orderInfo.POS_ODDTL_T[i].사이드_LIST[j].PROD_CD == this.allStampProdList[x].PROD_CD) {
		            									//cstUsePoint += parseInt(this.allStampProdList[x].STAMP_USE_QTY);
		            									cstSideUsePoint += parseInt(this.allStampProdList[x].STAMP_USE_QTY);
		            									orderInfo.POS_ODDTL_T[i].사이드_LIST[j].SIDE_CST_USE_POINT = cstSideUsePoint;
		            									orderInfo.POS_ODDTL_T[i].사이드_LIST[j].SIDE_STAMP_USE_QTY = this.allStampProdList[x].STAMP_USE_QTY;
		            								}
		            							}
	        									//cstUsePoint += parseInt(this.allStampProdList[x].STAMP_USE_QTY);
	        									
	        									if(this.allStampProdList[x].STAMP_ACC_YN == "Y" ) {
	        										if(rows[0].USE_ACC_YN == "Y") {
	        											//HCS_CSTCL_T 환경설정에서 스탬프 사용시 적립 사용
	        											cstSaleTotalPoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
	        										}
	        										cstSalePoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
	        									}
	        								} else {
	        									if(this.allStampProdList[x].STAMP_ACC_YN == "Y") {
	        										cstSalePoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
	        										cstSaleTotalPoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
	        									}
	        								}
	            						}
	            					}
	            				}
	            			}
	            			orderInfo.POS_ODDTL_T[i].CST_USE_POINT = cstUsePoint;
	            			orderInfo.POS_ODDTL_T[i].CST_SALE_POINT = cstSalePoint;
	            		}
             	   	} else if (SHOP_INFO.PNT_ACMT_STATUS_VAL == "1") {
             	   		//사용스탬프 적립 X
	             	   	for(var i=0; i<orderInfo.POS_ODDTL_T.length; i++) {
	            			util.logInfo("### STAMP_USE_QTY["+i+"]: " + orderInfo.POS_ODDTL_T[i].STAMP_USE_QTY);
	            			let cstUsePoint = 0;
	            			let cstSalePoint = 0;
	            			if(orderInfo.POS_ODDTL_T[i].STAMP_USE_YN == "Y") {
	            				for(var x=0; x<this.allStampProdList.length; x++) {
	            					if(orderInfo.POS_ODDTL_T[i].PROD_CD == this.allStampProdList[x].PROD_CD) {
	            						if(orderInfo.POS_ODDTL_T[i].사이드_중복체크값 != undefined) {
	            							if(orderInfo.POS_ODDTL_T[i].사이드_중복체크값 == this.allStampProdList[x].사이드_중복체크값) {
	    	            						if($("#"+this.allStampProdList[x].INDEX).prop("checked")) {
	    	            							cstUsePoint += parseInt(this.allStampProdList[x].STAMP_USE_QTY);
	    	            						} else {
	                								if(this.allStampProdList[x].STAMP_ACC_YN == "Y") {
	                									cstSalePoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
	                									cstSaleTotalPoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
	                								}
	    	            						}
	    	            					}
	            						} else {
	            							if($("#"+this.allStampProdList[x].INDEX).prop("checked")) {
    	            							cstUsePoint += parseInt(this.allStampProdList[x].STAMP_USE_QTY);
    	            						} else {
                								if(this.allStampProdList[x].STAMP_ACC_YN == "Y") {
                									cstSalePoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
                									cstSaleTotalPoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
                								}
    	            						}
	            						}
	            					}
	            					
	            					//메인 메뉴가 아닌 사이드 메뉴 스탬프 적립 및 사용 체크 
	            					//메인 메뉴와 사이드 메뉴를 같은 객체에 담기 때문에 구분값이 필요해서 사이드 중복체크값으로 비교
	            					if(this.allStampProdList[x].사이드구분 != null && this.allStampProdList[x].사이드구분 != undefined) {
	            						if(orderInfo.POS_ODDTL_T[i].사이드_중복체크값 == this.allStampProdList[x].사이드_중복체크값) {
		            						if($("#"+this.allStampProdList[x].INDEX).prop("checked")) {
		            							//cstUsePoint += parseInt(this.allStampProdList[x].STAMP_USE_QTY);
		            							for(var j=0; j<orderInfo.POS_ODDTL_T[i].사이드_LIST.length; j++) {
		            								if(orderInfo.POS_ODDTL_T[i].사이드_LIST[j].PROD_CD == this.allStampProdList[x].PROD_CD) {
		            									//cstUsePoint += parseInt(this.allStampProdList[x].STAMP_USE_QTY);
		            									cstSideUsePoint += parseInt(this.allStampProdList[x].STAMP_USE_QTY);
		            									orderInfo.POS_ODDTL_T[i].사이드_LIST[j].SIDE_CST_USE_POINT = cstSideUsePoint;
		            									orderInfo.POS_ODDTL_T[i].사이드_LIST[j].SIDE_STAMP_USE_QTY = this.allStampProdList[x].STAMP_USE_QTY;
		            								}
		            							}
		            						} else {
	            								if(this.allStampProdList[x].STAMP_ACC_YN == "Y") {
	            									cstSalePoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
	            									cstSaleTotalPoint += parseInt(this.allStampProdList[x].STAMP_ACC_QTY);
	            								}
		            						}
	            						}
	            					}
	            					
	            				}
	            			}
	            			orderInfo.POS_ODDTL_T[i].CST_USE_POINT = cstUsePoint;
	            			orderInfo.POS_ODDTL_T[i].CST_SALE_POINT = cstSalePoint;
	            		}
             	   	}
             	   	
             	   	util.logInfo("### cstSaleTotalPoint : " + cstSaleTotalPoint);
             	   	orderInfo.POS_ODHDR_T.CST_SALE_POINT = cstSaleTotalPoint;
             	   	orderInfo.POS_ODHDR_T.CST_POINT_AMT = totCstPointAmt;
             	   	orderInfo.POS_ODHDR_T.GST_PAY_AMT = totCstPointAmt;
            		var poddtlt = orderInfo.POS_ODDTL_T;

            		let POS_ODCST_T = [];
            		let localDate = moment().format("YYYYMMDDHHmmss");
            		
            		if(orderInfo.POS_ODHDR_T.CST_USE_POINT > 0) {
	         			//고객 사용 포인트
	         			for(var j=0; j<orderInfo.CORNER_LIST.length; j++) {
	         				var podCstUsePoint = 0;
	         				for(var z=0; z<orderInfo.POS_ODDTL_T.length; z++) {
	         					if(orderInfo.CORNER_LIST[j].CORNER_CD == orderInfo.POS_ODDTL_T[z].CORNER_CD) {
	         						podCstUsePoint += orderInfo.POS_ODDTL_T[z].CST_USE_POINT;
	         						if(orderInfo.POS_ODDTL_T[z].사이드_LIST !== undefined) {
	         							for(var xx=0; xx<orderInfo.POS_ODDTL_T[z].사이드_LIST.length; xx++) {
	         								if(orderInfo.POS_ODDTL_T[z].사이드_LIST[xx].SIDE_CST_USE_POINT !== undefined) {
	         									podCstUsePoint += orderInfo.POS_ODDTL_T[z].사이드_LIST[xx].SIDE_CST_USE_POINT;
	         								}
	         							}
	         						}
	         					}
	         				}
	            			
	         				var podcst = {
	         						SHOP_CD        : gShopCd             // VARCHAR(6)
	         						,SALE_DATE      : saleDate            // VARCHAR(8)
	         						,ORDER_NO       : ""  	 	          // VARCHAR(4)
	     							,LINE_NO        : ""              	  // VARCHAR(4)
	 								,POS_NO         : gPosNo              // VARCHAR(2)
	 								,SALE_YN        : "Y"                 // VARCHAR(1)		'Y'
									,CST_NO         : orderInfo.POS_ODHDR_T.CST_NO                  				// VARCHAR(10)
									,CST_CARD_NO    : orderInfo.POS_ODHDR_T.CST_CARD_NO  							// VARCHAR(16)
									,CST_CLS_CD     : orderInfo.POS_ODHDR_T.CST_CLS_CD                 				// VARCHAR(2)
									,CST_USE_POINT  : podCstUsePoint  // NUMERIC(12,2) DEFAULT 0 NOT NULL
									,CST_USE_AMT  	: totCstPointAmt  // NUMERIC(12,2) DEFAULT 0 NOT NULL
									,INS_DT         : localDate           // VARCHAR(14)
									,EMP_NO        	: ""                  // VARCHAR(4)
									//,CST_USE_AMT    : orderInfo.CORNER_LIST[j].SALE_AMT    	 // NUMERIC(12,2)
									,CORNER_CD      : orderInfo.CORNER_LIST[j].CORNER_CD     // VARCHAR(2)				'00'
									,SEQ_NO      	: ""                  // VARCHAR(2)				'01'
	         				};
	         				POS_ODCST_T.push(podcst);
	         				util.logInfo("### podcst["+j+"] : " + JSON.stringify(podcst));
	         				orderInfo.CORNER_LIST[j].CST_USE_POINT = podCstUsePoint;
	         			}
	
	        	 		orderInfo.POS_ODCST_T = POS_ODCST_T;
	
	             		var poddtltLength = orderInfo.POS_ODDTL_T.length;
	             		var cornerListLength = orderInfo.CORNER_LIST.length;
	
	             		util.logInfo("### poddtltLength : " + poddtltLength);
	             		util.logInfo("### cornerListLength : " + cornerListLength);
            		}
            		util.logInfo("### totCstUsePoint : " + totCstUsePoint);
            		
             		util.logInfo("______________ (스탬프적립) 스탬프적립금 계산 END _______________");
             		return rtnFlag;
            	}
                , fnClosePopup : function() {
                	this.fn_number_keypad('RESET');
                	$(".swiper-wrapper > *").remove();
                	this.allStampProdList = [];
                	this.styleObject = { display : 'none' };
                }
                , dodoClientInfoDataCallback : function(resultData){
            		util.logInfo(" ***** #dodoPoint dodoClientInfoDataCallback START *****")
            		util.logDebug("*** resultData >>>>> " + resultData);
            		util.logDebug("*** resultData >>>>> " + JSON.stringify(resultData));
            		var obj = { message : "", messageType : "alert" };
            		
            		// 통신시 에러발생한 경우 처리.
            		//if(resultData == undefined || resultData == "" || resultData == null ){
            		if(resultData.result == "error" ){
            			util.logInfo("***** #dodoPoint dodoClientInfoDataCallback asp result error *****");
            			obj.message = util.languageObjReturn(langCode,  "dodoPointApprFail4") + "[" + resultData.message + "]"; // 서버와의 통신이 원활하지 않습니다. 인터넷을 확인해 주세요.
            			this.makeMessageAlert(obj);
            			//message
            			return;
                	}
            		
    		    	if(resultData.result == "success") {
    		    		//util.log(JSON.stringify(dataDt));

    		    		if(resultData.current_points.points > 0 ){
        		    		if(SHOP_INFO.POINT_FG == "M"){
		    					// usageMileage = this.price;
		    					// 최대 사용 포인트가 0이면 사용 포인트 제한이 없음
			    				if(this.price > resultData.current_points.points){
			    					this.nUsePoint = resultData.current_points.points;
			    				} else {
			    					this.nUsePoint = this.price;
			    				}
    		    			}

    		    		} else {
    		    			// 잔액이 부족합니다. 메세지 처리
    		    			obj.message = util.languageObjReturn(langCode,  'noRemainingPoints');
    		    			this.makeMessageAlert(obj);
    		    		}
    		    		
    		    		this.activeClass = "org";
    		    		this.activeButton = util.languageObjReturn(langCode,  'toUse');
    		    		this.pointClass = "c_org";

    		    		this.custAvlPoint = resultData.current_points.points;
    		    		//this.minUsePoint = dataDt._MIN_USE_POINT;
    		    		//this.maxUsePoint = dataDt._MAX_USE_POINT;
    		    		this.cstNo = this.phoneNumber;
    		    		//도도포인트일때만 핸드폰번호 뒷4자리 
    		    		orderInfo.POS_ODHDR_T.CST_NO = this.phoneNumber.substr(7);
//    		    		this.cstClsCd = dataDt._CST_CLS_CD;
//    		    		this.cstCardNo = dataDt._CST_CARD_NO;

    		    	} else {
    		    		obj.message = util.languageObjReturn(langCode,  "failMsg");
    		    		this.makeMessageAlert(obj);	// 정상처리 되지 않았습니다.
    		    	}
            	}
                , useDodoPoint : function() {
                	util.logInfo("도도포인트 사용하기 >>> ");
                	util.logInfo("custAvlPoint >>> " + this.custAvlPoint);
                	util.logInfo("nUsePoint >>> " + this.nUsePoint);
                	util.logInfo("this.price >>> " + this.price);
                	this.nUsePoint = this.nUsePoint.toString();
                	/*************************************************
					 * 2020.11.18. 입력값 없을때 0으로 설정.
                	 *************************************************/
                	if ( util.byteLen (this.nUsePoint ) == 0)
                		this.nUsePoint = 0;

                	this.custAvlPoint = parseInt(this.custAvlPoint);
                	this.nUsePoint = parseInt(this.nUsePoint);
                	util.logInfo("custAvlPoint >>> " + typeof this.custAvlPoint);
                	util.logInfo("nUsePoint >>> " + typeof this.nUsePoint);
                	util.logInfo("this.price >>> " + typeof this.price);

                	var obj = { message : "", messageType : "alert" };

                	if(this.nUsePoint > this.custAvlPoint){
                		// 잔여포인트 AVL_POINT 가 사용 포인트 this.nUsePoint 보다 작습니다.
                		// 잔여 포인트내에서 결제 해 주세요.
                		//alert("잔여포인트가 "+ this.custAvlPoint +"가 사용 포인트 " + this.nUsePoint + "보다 작습니다.");
                		obj.message = util.languageObjReturn(langCode,  'mileageNotificationMsg1');
		    			this.makeMessageAlert(obj);
                		return;
            		}
                	
                	if(this.nUsePoint > this.price){
                		obj.message = util.languageObjReturn(langCode,  'mileageNotificationMsg2');
		    			this.makeMessageAlert(obj);
                		return;
            		}
                	
                	var params = {};
                	params.points = this.nUsePoint;
                	dodoPointService.dodoGetPostAjaxCall(params, "redeems", false, "POST", this.phoneNumber, this.dodoAuthKeyPopupCallback);
                	
//                	var resultData = {};
//                	resultData.result = "ready";
//                	resultData.auth_key = "1234";
//                	resultData.finish_url = "https://www.naver.com";
//                	this.dodoAuthKeyPopupCallback(resultData);
                }
                , dodoAuthKeyPopupCallback : function(resultData) {
                	
                	var msgObj = { message : "", messageType : "alert" };
                	
                	if(resultData == "error"){
            			util.logInfo("***** #dodoPoint dodoAuthKeyPopupCallback asp result error *****");
            			msgObj.message = util.languageObjReturn(langCode,  "timeoutMsg"); // 서버와의 통신이 원활하지 않습니다. 인터넷을 확인해 주세요.
            			this.makeMessageAlert(msgObj);
            			return;
                	}
            		
                	
    		    	if(resultData.result == "ready") {
    		    		var obj = {
    		    				auth_key : resultData.auth_key,
    		    				finish_url : resultData.finish_url,
    		    		};
    		    		eventBus.$emit('dodoPointPopup' , obj );
    		    		this.$root.$emit( "dodoPointPopup" ,   obj  );
    		    	} else {
    		    		//오류코드 정리필요
    		    		if(resultData.error_type == "insufficient_points") {
    		    			msgObj.message = util.languageObjReturn(langCode,  "mileageNotificationMsg5"); // 서버와의 통신이 원활하지 않습니다. 인터넷을 확인해 주세요.
                			this.makeMessageAlert(msgObj);
    		    		} else if(resultData.error_type == "invalid_points") {
    		    			msgObj.message = util.languageObjReturn(langCode,  "mileageNotificationMsg6"); // 서버와의 통신이 원활하지 않습니다. 인터넷을 확인해 주세요.
                			this.makeMessageAlert(msgObj);
    		    		} else if(resultData.error_type == "no_payable_point_policy") {
    		    			msgObj.message = util.languageObjReturn(langCode,  "mileageNotificationMsg7"); // 서버와의 통신이 원활하지 않습니다. 인터넷을 확인해 주세요.
                			this.makeMessageAlert(msgObj);
    		    		} else {
    		    			msgObj.message = util.languageObjReturn(langCode,  "timeoutMsg"); // 서버와의 통신이 원활하지 않습니다. 인터넷을 확인해 주세요.
                			this.makeMessageAlert(msgObj);
    		    		}
    		    	}
                }, dodoAuthKeyVerifyCallback : function(paramObj) {
                	var flag = false;
                	
                	if(this.nUsePoint == this.price)
                		flag = true;
                	
                	let DODO_POINT_INFO = {
                			AUTH_KEY 			: paramObj.auth_key,		//포인트 사용 인증키
                			FINISH_URL 			: paramObj.finish_url, 		//포인트 사용 인증 url
                			USE_POINT	 		: this.nUsePoint,			//포인트 사용금액
                			ADD_POINT			: 0, 		//포인트 적립금액
                			REDEEM_ID 			: "",		//포인트 사용 id
                			PURCHASES_ID		: "",		//포인트 적립 id
                			USE_POINT_REMAIN    : 0,
                			ADD_POINT_REMAIN    : 0,
                			USER_PHONE_NUM	    : this.phoneNumber
                	}
                	
                	orderInfo.DODO_POINT_INFO = DODO_POINT_INFO;
                	
                	if ( flag == true ) {
            			//0원 결제정보 설정
            			paymentChoiceService.setPointPaymentInfo();
            			//결제 프로세스로 이동.
//            			orderPayRegService.orderPayReg();
            			util.logInfo("***** dodoAuthKeyVerifyCallback flag true IN *****");
            			paymentChoiceView.fnCardReaderStatus("M"); // 파라미터가 C일 때만 카드제거해주세요 로직을 수행하도록함. 따라서 M이라고 임의로 셋팅
            		} else {
            			this.$router.push({name: 'paymentChoiceView', params: { price: util.numberWithCommas(this.nUsePoint) }})
            		}
                }, fnBackMile : function(){
                	this.$router.push({path: '/paymentChoiceView'});
                }
                
            }// end methods
            , updated : function(){
            	util.logInfo('### stampCssStyleUpdate updated');
                this.stampCssStyleUpdate();
            }
            , beforeUpdate : function(){
                
            }
            , destroyed : function(){
            	gCombinePayVal = "";
				//swiperStamp = undefined;
            }
       };
       return returnTemplate;
    },


    // 적립하기 팝업
    this.fnAccPointPop = function(){
    	 var returnTemplate = { template: '#addPointPopup'
             , created : function() {
            	 if(SHOP_INFO.POINT_CO_VAL == "2") {
     				this.saveTo        = util.languageObjReturn(langCode,  'saveToDoDo');
            	 } else {
     				this.saveTo = util.languageObjReturn(langCode,  'saveTo');
            	 }
            	 
            	 if(gsMobileCouponTg == "N") {
            		 this.toSave = util.languageObjReturn(langCode,  'toSave');
            	 } else {
            		 this.toSave = util.languageObjReturn(langCode,  'toSaveTg');
            		 this.toSave2 = util.languageObjReturn(langCode,  'toSaveTgEx');
            	 }
            	 this.no     = util.languageObjReturn(langCode,  'no');
            	 this.yes    = util.languageObjReturn(langCode,  'yes');
             }
         	, mounted : function() {
             	// util.log('addPoint mounted==' );
             	this.$root.$on('addPointPopup' , obj => {
             		util.logInfo("on -> addPointPopup 1111" + JSON.stringify(obj));
             		this.styleObject = { display : 'block' };
             		this.payType = obj.BTN_TYPE;
             		this.barcodeOnly = obj.barcodeOnly;
             	});
             }
			,beforeDestroy () {
 					this.$root.$off('addPointPopup' );
 			}
         	, data : function () {
         		return {
         			  codeNum     : ""
         			, styleObject : { display : 'none' }
         			, payType     : ""  // 결제 방법 (CREDIT , EASY)
         			, yes         : ""
         	        , no          : ""
         	        , mCouponTg   : gsMobileCouponTg	
         	        , barcodeOnly : "N"	
         		}
         	}
            , methods : {
            	fn_closeOut : function(){
            		orderInfo.addPoint.CREDIT = '';
 	   	            orderInfo.addPoint.EASY = '';
            		this.styleObject = {display : 'none'};
            	}
	            , fn_close : function() {
	            	this.styleObject = {display : 'none'};
	            	setTimeout(this.fn_closePayCall, 100); // payment를 호출하면 위의 display none이 없어지지 않는 문제가 발생하여 0.1초 후 payment 호출하도록 처리.
	            }
	            , fn_closePayCall : function(){
	            	// 복수사업자
	            	if(  BIZ_CLS_TYPE == '1'  ){
	            		if ( this.payType == 'CREDIT'  ) {
	            			paymentChoiceView.creditApprRequest();
	            			return;
	            		} else {
	            			if ( orderInfo.CORNER_LIST.length != 1 ) {
	            				alert('복수사업자는 간편결제를 사용할 수 없습니다.');
	            				return;
	            			} else {
		            			// 간편결제
		            			var obj = {
		            					BTN_TYPE    : this.payType,
		            					accEasyType : 'N'
		            			};

		            			util.logInfo("간편결제 적립 아니오 상태에서 간편결제 화면으로 이동 " + obj);
		            			this.$router.push({name : 'easyPayment' , params: {obj}})
		            			return;
	            			}
	            		}

	            	}else{
	            		if ( this.payType == 'CREDIT') {

	            			paymentChoiceView.creditApprRequest();

	            		} else  {
	            			// 간편결제
	            			var obj = {
	            					BTN_TYPE    : this.payType,
	            					accEasyType : 'N'
	            			};

	            			util.logInfo("간편결제 적립 아니오 상태에서 간편결제 화면으로 이동 " + obj);

	            			this.$router.push({name : 'easyPayment' , params: {obj}})
	            		}
	            	}
	            }
	            , accTypeGbn : function(){
	            	// console.log('accTypeGbn this.payType' , this.payType );

	            	var obj = {
	            			BTN_TYPE      : this.payType,
	            			accCreditType : this.$route.params.accCreditType,
	            			accEasyType   : this.$route.params.accEasyType
	            	};
	            	
	            	util.logInfo("간편결제 적립 예 상태에서 간편결제 화면으로 이동 " + JSON.stringify(obj));
	            	
	            	if ( this.payType == "CREDIT") {
	            		obj.accCreditType = "Y";
	            	}else if ( this.payType == "EASY") {
	            		obj.accEasyType = "Y";
	            	}else{
	            		obj.accCreditType = "";
	            		obj.accEasyType = "";
	            	}

	            	//this.$router.push({name : 'paymentChoiceView' , params: { accCreditType : "Y" , accEasyType : "Y"}})
	            	//console.log('addPointType this.btnType == ' , this.btnType)

	            	//톨게이트 스템프 적립은 바코드로 스캔후 적립 
	            	if(this.mCouponTg == "N") {
	            		this.$router.push({name : 'addPointAction' , params: {obj}})
	            	} else {
	            		//톨게이트 스탬프 적립 바코드 화면일 경우
	            		gPayBarcodeType = "TOLLGATE_S";
	            		//this.$router.push({ path : '/easyPayment'});
//	            		var obj = {
//		            			tgStampAddType : "Y"
//		            			, barcodeOnly : this.barcodeOnly
//		            	};
	            		obj.tgStampAddType = "Y";
	            		obj.barcodeOnly = this.barcodeOnly;
	            		this.$router.push({name : 'easyPayment' , params: {obj}})
	            	}
	            }
            }
    	 };
    	 return returnTemplate;
    }

    // 회원 존재 여부
    this.fnAddPointAction = function(){

    	var returnTemplate = { template: '#addPointAction'
    		, data : function () {
        		return {
        			phone       : ""
        		  , phoneNumber : ""
        		  , phoneNumberIn : util.languageObjReturn(langCode,  'phoneNumberIn')
        		}
        	}
    		, created : function(){
    			//도도토인트
        		if(SHOP_INFO.POINT_CO_VAL == "2"){
        			this.accSave    = util.languageObjReturn(langCode , 'accSaveDoDoPoint');
    			} else {
    				this.accSave    = util.languageObjReturn(langCode , 'accSave');
    			}
    			
    			this.accBtnSave = util.languageObjReturn(langCode , 'accBtnSave');
    			
    			if(basicOrderInfo.notifyTalkPhoneNo != "" ) {
            		this.phoneNumber = basicOrderInfo.notifyTalkPhoneNo;
            		
            		var x1 = paymentChoiceService.fnPhoneNumMasking(this.phoneNumber);
            		//console.log('x1'  , x1);
            		this.phone = x1;
            	}
    			
    		}
    		, mounted : function() {
    			//console.log('회원 존재 여부   this.btnType  == ' , this.$route.params.obj.BTN_TYPE)
	        	// var obj = {
	        	// BTN_TYPE : btnType,
	        	// accCreditType : this.$route.params.accCreditType,
	        	// accEasyType : this.$route.params.accEasyType
	        	// };
    		}
			, methods : {
	        	fn_number_keypad : function (key) {
	        		//console.clear();
	        		//util.logInfo('addPointAction  (전화번호 키패드)====>');
	        		//phone       : 하이픈 포함.
	        		//phoneNumber : 입력받은 휴대폰 번호.
	        		
	        		if(this.phoneNumber == undefined) this.phoneNumber = "";
	        		
	        		this.phoneNumber = paymentChoiceService.number_keypad( key, this.phoneNumber);
	        		
	        		var x1 = paymentChoiceService.fnPhoneNumMasking(this.phoneNumber);
	            	// util.logInfo('x1' , x1);
	            	this.phone = x1;

	        		if(this.phoneNumber.substr(0, 2) == "02") {
            			if (this.phoneNumber.length > 10){
            				this.phoneNumber = this.phoneNumber.slice(0, -1);
    					}
            		} else if(this.phoneNumber.substr(0, 3) == "050") {
            			if (this.phoneNumber.length > 12){
            				this.phoneNumber = this.phoneNumber.slice(0, -1);
    					}
            		} else {
            			if (this.phoneNumber.length > 11){
            				this.phoneNumber = this.phoneNumber.slice(0, -1);
    					}
            		}

                	var x1 = paymentChoiceService.fnPhoneNumMasking(this.phoneNumber);
                	//util.logInfo("x1"  + x1);
                	this.phone = x1;

                	//util.logInfo("addPointAction 화면  (전화번호 길이)====>" + this.phoneNumber.length);
                	//util.logInfo("addPointAction 화면  (전화번호 키패드)====>" + this.phoneNumber  +"          "+ this.phone);
	        	}
			
	        	,setFocusType(type) {
	        		this.focusType = type;
	        	}
	
				, fn_backAccType : function(){
					var obj = {
		        			BTN_TYPE      : this.$route.params.obj.BTN_TYPE,
		        			accCreditType : this.$route.params.obj.accCreditType,
		        			accEasyType   : this.$route.params.obj.accEasyType
		        	};
					util.logInfo("fn_backAccType  back" + obj);
	
					this.$router.push({name : 'paymentChoiceView' , params: { obj  }})
	        	}
	
				,fn_close : function() {
	
	   	            this.styleObject = {display : 'none'};
	   	            this.$router.push({ path : '/paymentChoiceView' });
	        	}
	
				,savePoint : function(){
					console.clear();					
	
					if(this.phone.length == 0 ){
						let dataObj = {};
						dataObj.button1Show = false;
						dataObj.button2Show = true;
						dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
						dataObj.button2Func = "";
						dataObj.message = util.languageObjReturn(langCode,  'phoneNumberIn'); // 번호를 입력하세요.
						eventBus.$emit('alertPopupIndex', dataObj);				
						return false;
					}

					// 사용자가 입력한 번호로 asp 고객정보조회
					//var resultUserAspData = aspData.clientBasicInfoAspDataSearch("CS010", "", this.phoneNumber , "", "", "");
					if(SHOP_INFO.POINT_CO_VAL == "2"){
                		//도도포인트 매장일 경우
    					let DODO_POINT_INFO = {
    							USER_PHONE_NUM	    : this.phoneNumber
                    	}
                    	
                    	orderInfo.DODO_POINT_INFO = DODO_POINT_INFO;
    					
    					if(this.$route.params.obj.BTN_TYPE == 'CREDIT'){
		 	   	            orderInfo.addPoint.CREDIT = '';
		 	   	            orderInfo.addPoint.EASY = '';
		 	   	            this.styleObject = {display : 'none'};
		 	   	            // 신용카드 결제.
		 	   	            paymentChoiceView.creditApprRequest();
		 	   	        	// return;
						}

						if(this.$route.params.obj.BTN_TYPE == 'EASY'){
							this.$router.push({ path : '/easyPayment' });
						}
    					
                	} else {
                		//var phone = this.phoneNumber.replace(/(^02.{0}|^01.{1}|[0-9]{3})([0-9]+)([0-9]{4})/,"$1-$2-$3");
                		util.logInfo("this.phoneNumber >> " + this.phoneNumber);
                		aspData.clientBasicInfoAspDataSearch("CS010", "", this.phoneNumber, "", "", this.clientBasicInfoAspDataCallback);
                	}
			    	// router.push({ path : '/receiptPrint' });
				}
				,clientBasicInfoAspDataCallback : function(resultUserAspData, returnObj){
					util.logInfo("***** #addPointAction clientBasicInfoAspDataCallback START *****");
					
					let dataObj = {};					
					// asp 통신시 에러발생한 경우 처리.
	        		if(resultUserAspData == "error"){
	        			util.logInfo("***** #addPointAction clientBasicInfoAspDataCallback asp result error *****");
	        			var vsTimeoutMsg = util.languageObjReturn(langCode,  "mileageFail"); // 마일리지 적립에 실패했습니다. 바로 결제를 진행하시겠습니까?
	        			dataObj.button1Show = true;
						dataObj.button1Name = util.languageObjReturn(langCode, 'no');// [ 아니오 ]
	        			dataObj.button2Show = true;
						dataObj.button2Name = util.languageObjReturn(langCode, 'yes');// [ 예 ]
						dataObj.message = vsTimeoutMsg; // 

						// 확인을 누르면 결제를 진행하도록 한다. 아니오를 누르면 그대로 리턴
						dataObj.button2Func = function(){
							if(this.$route.params.obj.BTN_TYPE == 'CREDIT'){
			 	   	            orderInfo.addPoint.CREDIT = '';
			 	   	            orderInfo.addPoint.EASY = '';
			 	   	            this.styleObject = {display : 'none'};
			 	   	            // 신용카드 결제.
			 	   	            paymentChoiceView.creditApprRequest();
							}
	
							if(this.$route.params.obj.BTN_TYPE == 'EASY'){
								this.$router.push({ path : '/easyPayment' });
							}
						};
						eventBus.$emit('alertPopupIndex', dataObj);	
	        			return;
	            	}
	        		
					var txjmFd = resultUserAspData["TSP-NVP"]["TXJM-FD"];
					// util.logDebug("resultUserAspData " + resultUserAspData);
					// var resultUserAspData = {};
					var dataHd = txjmFd["DATA-HD"];
					//var dataDt = dataHd["DATA-DT"];
					var dataDt;
					
					//회원정보가 1개이상일때 고객번호를 비교해서 가장큰 고객번호의 회원정보로 세팅해준다
		    		//dataHd._DATA_CNT 조회된 고객정보 함계
		    		if(dataHd._DATA_CNT > 1) {
		    			var cstNo = 0;
		    			var cstNoTemp = 0;
		    			var cstListNo = 0;
		    			for(var i=0; i<dataHd._DATA_CNT; i++){
		    				if(i == 0){
		    					cstNo = parseInt(dataHd["DATA-DT"][i]._CST_NO);
		    				} else {
		    					cstNoTemp = parseInt(dataHd["DATA-DT"][i]._CST_NO);
		    					if(cstNo < cstNoTemp){
		    						cstNo = cstNoTemp;
		    						cstListNo = i;
		    					}
		    				}
		    			}
		    			dataDt = dataHd["DATA-DT"][cstListNo];
		    		} else {
		    			dataDt = dataHd["DATA-DT"];
		    		}
	
		    		var phoneHyphen = this.phoneNumber.replace(/(^02.{0}|^01.{1}|[0-9]{3})([0-9]+)([0-9]{4})/,"$1-$2-$3");
		    		util.logInfo("phone >> " + phone);

		    		// var paramObj = { phone : this.phone.split("-").join("") };
		    		var paramObj = { phone : phoneHyphen };
            		
			    	// CS010 정상일 때
			    	if(txjmFd["_RETCD"] == "0000") {
			    		// CS010 데이터 없을 때
			    		if(dataHd._DATA_CNT == 0 ){
			    			// local DB 고객조회
							//var localUserSearch = gfn_SQLiteSQLProcess(paymentChoicesql.selectLocalUserInfoSearch, [this.phone.split("-").join("") , this.phone.split("-").join("") , this.phone.split("-").join("") ]);
							var localUserSearch = gfn_SQLiteSQLProcess(paymentChoicesql.selectLocalUserInfoSearch, [phoneHyphen , phoneHyphen , phoneHyphen ]).Data;	
							
							if(localUserSearch == undefined || localUserSearch == "" || localUserSearch == null || localUserSearch.length < 1) {
								paramObj.BTN_TYPE = this.$route.params.obj.BTN_TYPE;
								this.styleObject = {display : 'none'};
								this.$root.$emit('newUserPopup', paramObj);//신규 가입으로 이동.
								// return;
							}else{
								util.logInfo('localUserSearch 22: ' + localUserSearch.CST_NO);
								if(this.$route.params.obj.BTN_TYPE == 'CREDIT'){
									util.logInfo("_RETCD CREDIT");
									// this.newUserInsert;
									paymentChoiceView.creditApprRequest();
								}
								if(this.$route.params.obj.BTN_TYPE == 'EASY'){
									util.logInfo("_RETCD EASY");
									this.$router.push({ path : '/easyPayment' });
								}
							}
							this.styleObject = {display : 'none'};
	
			    		}else{
			    			
			    			var localUserSearch = gfn_SQLiteSQLProcess(paymentChoicesql.selectLocalUserInfoSearch, [phoneHyphen , phoneHyphen , phoneHyphen ]).Data;
			    			//ASP서버에 회원정보가 있는데 로컬DB에 회원정보가 없을경우 회원정보 저장
			    			if(localUserSearch == undefined || localUserSearch == "" || localUserSearch == null || localUserSearch.length < 1) {
								var lsatSql = sqlQuery.fnSelectQuery("CS011", dataDt);
			    				
			    				if(lsatSql != "") {
			    					try{
			    						var resultMsg = gfn_DbExecute(lsatSql);
			    						if(resultMsg.ResultCode != 0) {
			    							//util.log("resultMsg.ResultCode   :" + resultMsg.ResultCode);
			    							throw  "fail 전문ID[%s] 마스터 정보 등록 실패하였습니다.\n%s\n%s".sprintf("CS011", lsatSql, JSON.stringify(resultMsg ));
			    						}
			    					}catch(ex){
			    						util.logInfo("catch   :" + ex);
			    					}
			    				}
							}
			    			
			    			orderInfo.POS_ODHDR_T.CST_USE_POINT = 0 ;
			    			orderInfo.POS_ODHDR_T.CST_POINT_AMT = 0 ;
			    			
			    			orderInfo.POS_ODHDR_T.CST_CLS_CD  = dataDt._CST_CLS_CD;		// 고객 등급
			    			orderInfo.POS_ODHDR_T.CST_NO 	 = dataDt._CST_NO;			// 고객번호
			    			orderInfo.POS_ODHDR_T.CST_CARD_NO = dataDt._CST_CARD_NO;	// 고객카드번호
			    			orderInfo.POS_ODHDR_T.CST_AVL_POINT = dataDt._AVL_POINT;	// 가용포인트
			    			
//			    			if(dataHd._DATA_CNT == 1){ // 휴대전화번호의 고객 id가 혹시나 여러명인경우 첫번째 배열값의 고객에게 적립시키기 위해 분기
//			    				orderInfo.POS_ODHDR_T.CST_CLS_CD  = dataDt._CST_CLS_CD;		// 고객 등급
//				    			orderInfo.POS_ODHDR_T.CST_NO 	 = dataDt._CST_NO;			// 고객번호
//				    			orderInfo.POS_ODHDR_T.CST_CARD_NO = dataDt._CST_CARD_NO;	// 고객카드번호
//				    			orderInfo.POS_ODHDR_T.CST_AVL_POINT = dataDt._AVL_POINT;	// 가용포인트
//			    			}else if(dataHd._DATA_CNT > 1){ // 입력한 휴대폰번호로 여러명의 고객이 나온다면 첫번째 고객꺼를 넣는다.
//			    				orderInfo.POS_ODHDR_T.CST_CLS_CD  = dataDt[0]._CST_CLS_CD;		// 고객 등급
//				    			orderInfo.POS_ODHDR_T.CST_NO 	 = dataDt[0]._CST_NO;			// 고객번호
//				    			orderInfo.POS_ODHDR_T.CST_CARD_NO = dataDt[0]._CST_CARD_NO;	// 고객카드번호
//				    			orderInfo.POS_ODHDR_T.CST_AVL_POINT = dataDt[0]._AVL_POINT;	// 가용포인트
//			    			}
			    			
			    			if (SHOP_INFO.PNT_ACMT_STATUS_VAL == '2' && SHOP_INFO.POINT_FG=="S") {
        		    			//스탬프 매장일 경우
			    				util.stampCalcForUser();
    		    			}
			    			
			    			if(this.$route.params.obj.BTN_TYPE == 'CREDIT'){
			 	   	            orderInfo.addPoint.CREDIT = '';
			 	   	            orderInfo.addPoint.EASY = '';
			 	   	            this.styleObject = {display : 'none'};
			 	   	            // 신용카드 결제.
			 	   	            paymentChoiceView.creditApprRequest();
			 	   	        	// return;
							}
	
							if(this.$route.params.obj.BTN_TYPE == 'EASY'){
								this.$router.push({ path : '/easyPayment' });
							}
			    		}
			    	}else{
			    		let dataObj = {};
			    		var vsTimeoutMsg = util.languageObjReturn(langCode,  "mileageFail"); // 마일리지 적립에 실패했습니다. 바로 결제를 진행하시겠습니까?
	        			dataObj.button1Show = true;
						dataObj.button1Name = util.languageObjReturn(langCode, 'no');// [ 아니오 ]
	        			dataObj.button2Show = true;
						dataObj.button2Name = util.languageObjReturn(langCode, 'yes');// [ 예 ]
						dataObj.message = vsTimeoutMsg; // 

						// 확인을 누르면 결제를 진행하도록 한다. 아니오를 누르면 그대로 리턴
						dataObj.button2Func = function(){
							if(this.$route.params.obj.BTN_TYPE == 'CREDIT'){
			 	   	            orderInfo.addPoint.CREDIT = '';
			 	   	            orderInfo.addPoint.EASY = '';
			 	   	            this.styleObject = {display : 'none'};
			 	   	            // 신용카드 결제.
			 	   	            paymentChoiceView.creditApprRequest();
							}
	
							if(this.$route.params.obj.BTN_TYPE == 'EASY'){
								this.$router.push({ path : '/easyPayment' });
							}
						};
						eventBus.$emit('alertPopupIndex', dataObj);	
						
//			    		var msg = util.languageObjReturn(langCode,  "failMsg") + " [_RETCD is not 0000]";
//			    		this.$root.$emit( "notiMessage" ,   {message: msg, messageType : "alert" }  ); // 정상처리 되지 않았습니다. [_RETCD is not 0000]
			    	}
				}
			}
	    };
    	return returnTemplate;
    },

    // 신규회원 pop
    this.fnNewUserPop = function(){

    	var returnTemplate = { template: '#newUserPopup'
    		, data : function () {
    			return {
    				  phone : ""
    				, styleObject : { display : 'none' }
    			    , orderNo : ""
    			    , BTN_TYPE : ""
    			    , posCstmstIns : ""
    			    , reCallCnt : 0 	
    			}
    			
    		}
    		, created : function() {
             	// util.log('newUserPopup created==' );
             	this.newUser         = util.languageObjReturn(langCode,  'newUser');
        		this.saveTo          = util.languageObjReturn(langCode,  'saveTo');
             	this.newMeber        = util.languageObjReturn(langCode,  'newMeber');
             	this.memberExistence = util.languageObjReturn(langCode,  'memberExistence');
             	this.no              = util.languageObjReturn(langCode,  'no');
             	this.yes             = util.languageObjReturn(langCode,  'yes');
             }
         	, mounted : function() {
             	this.$root.$on('newUserPopup' , obj => {
             		util.logInfo("on mounted -> newUserPopup " , obj);
             		this.phone = obj.phone;
             		this.styleObject = { display : 'block' };
             		this.BTN_TYPE = obj.BTN_TYPE;
             	});
             }
             ,beforeDestroy () {
 					this.$root.$off('newUserPopup' );
 			}
            , methods : {
            	fn_closeOut : function(){
            		this.styleObject = {display : 'none'};
            	}

            	,fn_close : function() {
            		this.styleObject = {display : 'none'};
            		this.fn_pay();
            	}

            	,fn_pay : function(){
					this.styleObject = {display : 'none'};

            		if ( this.BTN_TYPE == 'EASY') {
            			this.$router.push({ path : '/easyPayment' });            			
            		} else {
            			//setTimeout(()=> {
//            			$(".newUserPayIng").show();
//            				paymentChoiceView.creditApprRequest();//신규회원pop
//            				//eventBus.$emit('alertPopup', {message: "신규가입 진행중입니다. 잠시만 기다려 주세요."});
//            				$(".newUserPayIng").hide();
//            			}, 1000);
            			this.$router.push({ name : 'paymentChoiceView' , params : { action: 'CREDIT_PAY'  }});
            		}
            		// paymentChoiceView.creditApprRequest();//신규회원pop
            	}

               ,newUserInsert : function(){
            	   
            	   //ASP 이중회원등록 방지
            	   if(this.reCallCnt < 1){
            		   this.reCallCnt++;
            		   
            		   this.styleObject = {display : 'none'};
            		   var vsUserMsg = util.languageObjReturn(langCode , "newUserP");
            		   
            		   $("#newUserP").text(vsUserMsg);
            		   $(".newUserPayIng").show();
            		   var localDate = moment().format("YYYYMMDDHHmmss");
            		   // var newCstSeq = gShopCd+localDate;
            		   var newCstSeq = localDate;
            		   
            		   // 로컬에 신규 추가
            		   var newUserLocalIns = gfn_SQLiteSQLProcess(paymentChoicesql.insertUserInfoSearch , [gShopCd, newCstSeq, this.phone, saleDate, gPosNo]);
            		   util.logInfo('newUserLocalIns : ' + newUserLocalIns);
            		   
            		   if (newUserLocalIns.ResultCode != 0 ) {
            			   util.logError("[INFO] newUserInsert newUserLocalIns.ResultCode != 0");
            			   $(".newUserPayIng").hide();
            		   }else{             		  
            			   
            			   util.logInfo("else newCstSeq >>>" + newCstSeq);
            			   
            			   // POS_CSTMS_T 신규회원 등록
            			   try{
            				   aspEtcDataReceiveService.newCustProcess(newCstSeq, this.newCustProcessCallback);
            			   }catch(e){
            				   util.logError(e.toString());
            				   var paramObj = { a : "a" , b : "b", BTN_TYPE : this.BTN_TYPE };
            				   this.$root.$emit('newUserForcePayPop', paramObj); // 신규가입 실패하였습니다. 결제를 하시겠습니까?, 예 클릭시에 결제 진행하도록 구현되어있음.
            				   $(".newUserPayIng").hide();
            			   }
            			   
//                	    util.logInfo("[INFO] newUserInsert setTimeout before!!!");
            			   //setTimeout(this.newUserInsertAfter,4000);
            		   } // if (newUserLocalIns.ResultCode != 0 ) {
            	   } 
            	   
               	}
               , newCustProcessCallback : function(paPosCstmstIns){
            	   util.logInfo("***** newCustProcessCallback START *****");
            	    // asp 통신시 에러발생한 경우 처리.
	        		if(paPosCstmstIns == "error"){
	        			util.logError("***** newCustProcessCallback param Error *****");
	        			var paramObj = { a : "a" , b : "b", BTN_TYPE : this.BTN_TYPE };
	        			this.$root.$emit('newUserForcePayPop', paramObj); // 신규가입 실패하였습니다. 결제를 하시겠습니까?, 예 클릭시에 결제 진행하도록 구현되어있음.
	        			$(".newUserPayIng").hide();
	        			return;
	            	}
            	   this.posCstmstIns = paPosCstmstIns;
            	   // CS010을 재조회 시에 4초정도 딜레이를 줘야한다. 신규회원이 asp에서 등록되는 시간이 있기 때문
            	   setTimeout(this.newUserInsertAfter, 4000);
            	   
               }
               ,newUserInsertAfter : function(){
               	   util.logInfo("[INFO] newUserInsertAfter START(setTimeout after)!!!");
             	   // CS010 재조회 
               	   aspData.clientBasicInfoAspDataSearch("CS010", "", this.phone.split("-").join("") , "", "", this.clientBasicInfoAspDataCallback);
               	}
               ,clientBasicInfoAspDataCallback : function(reSearch, returnObj){
            	   util.logInfo("***** #newUserPopup clientBasicInfoAspDataCallback START *****");
					
					// asp 통신시 에러발생한 경우 처리.
            	   if(reSearch == "error"){
            		   util.logError("clientBasicInfoAspDataCallback reSearch error");
            		   var paramObj = { a : "a" , b : "b", BTN_TYPE : this.BTN_TYPE };
            		   this.$root.$emit('newUserForcePayPop', paramObj); // 신규가입 실패하였습니다. 결제를 하시겠습니까?, 예 클릭시에 결제 진행하도록 구현되어있음.
            		   $(".newUserPayIng").hide();
            		   return;
            	   }
	        		
            	   util.logInfo("CS010 재조회  reSearch:"  + JSON.stringify(reSearch));
            	   $(".newUserPayIng").hide();
            	   util.logInfo("========= this.posCstmstIns " + this.posCstmstIns);
               	   if(this.posCstmstIns == false){
               		   // fail
               		  var paramObj = { a : "a" , b : "b", BTN_TYPE : this.BTN_TYPE };
      				  this.$root.$emit('newUserForcePayPop', paramObj);
               	   }else{
               		   util.logInfo("reSearch >>> " + reSearch);

                  	   var txjmFd = reSearch["TSP-NVP"]["TXJM-FD"];
                  	   // var reSearch = {};
                  	   if(txjmFd["_RETCD"] == "0000") {

                  		   util.logInfo("_RETCD] == 0000");
                  		   var dataHd = txjmFd["DATA-HD"];
                  		   var dataDt = dataHd["DATA-DT"];
                  		   
                  		   var localUserSearch = gfn_SQLiteSQLProcess(paymentChoicesql.selectLocalUserInfoSearch, [this.phone , this.phone , this.phone ]).Data;
                  		   //ASP서버에 회원정보가 있는데 로컬DB에 회원정보가 없을경우 회원정보 저장
                  		   if(localUserSearch == undefined || localUserSearch == "" || localUserSearch == null || localUserSearch.length < 1) {
                  			   var lsatSql = sqlQuery.fnSelectQuery("CS011", dataDt);
			    				
                  			   if(lsatSql != "") {
                  				   try{
                  					   var resultMsg = gfn_DbExecute(lsatSql);
                  					   if(resultMsg.ResultCode != 0) {
                  						   //util.log("resultMsg.ResultCode   :" + resultMsg.ResultCode);
                  						   throw  "fail 전문ID[%s] 마스터 정보 등록 실패하였습니다.\n%s\n%s".sprintf("CS011", lsatSql, JSON.stringify(resultMsg ));
                  					   }
                  				   }catch(ex){
                  					   util.logInfo("catch   :" + ex);
                  				   }
                  			   }
                  		   }
                  		   
                  		   orderInfo.POS_ODHDR_T.CST_USE_POINT = 0 ;
                  		   orderInfo.POS_ODHDR_T.CST_POINT_AMT = 0 ;
                  		   orderInfo.POS_ODHDR_T.CST_CLS_CD  = dataDt._CST_CLS_CD;		// 고객 등급
                  		   orderInfo.POS_ODHDR_T.CST_NO 	 = dataDt._CST_NO;			// 고객번호
                  		   orderInfo.POS_ODHDR_T.CST_CARD_NO = dataDt._CST_CARD_NO;	// 고객카드번호
                  		   
                  		   if (SHOP_INFO.PNT_ACMT_STATUS_VAL == '2' && SHOP_INFO.POINT_FG=="S") {
                  			   //스탬프 매장일 경우
                  			   util.stampCalcForUser();
                  		   }
                  		 
                  		   this.styleObject = {display : 'none'};

                  		   if(dataHd._DATA_CNT == 0 ){
                  			   util.logInfo("dataHd._DATA_CNT == 0 ");
                  			   var paramObj = { a : "a" , b : "b", BTN_TYPE : this.BTN_TYPE };
                  			   this.$root.$emit('newUserForcePayPop', paramObj);
                  		   }else{
                  			  if(dataDt._CST_NO == undefined || dataDt._CST_NO == "" || dataDt._CST_NO == null){
                  				  util.logInfo('dataDt._CST_NO >>' + dataDt._CST_NO);
                  				  util.logInfo("dataDt._CST_NO == undefined");
                  				  var paramObj = { a : "a" , b : "b", BTN_TYPE : this.BTN_TYPE };
                  				  this.$root.$emit('newUserForcePayPop', paramObj);
                  			  }else{

                  				  // 결제 처리중
                  				  this.fn_pay();
                  				  this.styleObject = {display : 'none'};                    				  
                  			  }
                  		   }

                  	   }else{

                  		   util.logInfo("_RETCD] !!!!!!! 0000");
                  		   this.styleObject = {display : 'none'};
                  		   var paramObj = { a : "a" , b : "b", BTN_TYPE : this.BTN_TYPE };
                  		   this.$root.$emit('newUserForcePayPop', paramObj);
                  	   }// if(txjmFd["_RETCD"] == "0000") {
                   }// if(posCstmstIns == false){
               }
            }
    	};

    	return returnTemplate;
    },

    this.fnNewUserForcePayPop  = function(){
    	var returnTemplate = { template: '#newUserForcePayPop'
    		, data : function () {
    			return {
    				styleObject : { display : 'none' } ,
    				BTN_TYPE : ""
    			}
    		}
    		, created : function() {
    			this.newUserPay       = util.languageObjReturn(langCode,  'newUserPay');
    			this.newUserDbFail 	  = util.languageObjReturn(langCode,  'newUserDbFail');
    			this.newUserDbFailPay = util.languageObjReturn(langCode,  'newUserDbFailPay');
    			this.no               = util.languageObjReturn(langCode,  'no');
             	this.yes              = util.languageObjReturn(langCode,  'yes');
    		}
    		, mounted : function(){
    			this.$root.$on('newUserForcePayPop' , obj => {
    				util.logInfo("on mounted -> newUserForcePayPop " + obj);
             		this.styleObject = { display : 'block' };
             		this.BTN_TYPE = obj.BTN_TYPE;
             	});
    		}

    		,beforeDestroy () {
					this.$root.$off('newUserForcePayPop' );
			}
    		, methods : {
    			fn_newUserclose : function() {
    				this.styleObject = {display : 'none'};
            	}

	    		,fn_newUserForceClose : function() {
	    			this.styleObject = {display : 'none'};
	    			this.fn_newUserForcePay();
	        	}
	    		// 신규회원 등록후, 재조회가 안될때 결제 pop
	            ,fn_newUserForcePay : function(){
	            	this.styleObject = {display : 'none'};
	            	if ( this.BTN_TYPE == 'EASY') {
            			this.$router.push({ path : '/easyPayment' });
            		} else {
            			this.$router.push({ name : 'paymentChoiceView' , params : { action: 'CREDIT_PAY'  }});
            		}
	            }
    		}
    };

    	return returnTemplate;
    },

    this.init = function() {
		if ( !Number.isNaN ( parseInt (sto1 ) ) ) {
			return;
		}		
    	/********************************** 서명패드 timeout 설정 Start **********************************/
    	let sto_row_1 = util.GetEnvXmlPosEnvDtl(  '918' ) ;// 서명 패드 표시
    	util.logInfo('____sto_row_1 : ' + sto_row_1);
    	let sto_row_2 = util.GetEnvXmlPosEnvDtl(  '919' ) ;//서명 패드 서명 후 확인 버튼 클릭시간.
    	util.logInfo('____sto_row_2 : ' + sto_row_2);
    	
    	if ( sto_row_1.ENV_VAL_NM == undefined ) {
    		sto1 = 30;
    	} else {
    		if ( sto_row_1.ENV_VAL_NM.indexOf("미사용") != -1 ) {
    			sto1 = 0;
    		} else {
    			sto1 = sto_row_1.ENV_VAL_NM;
    		}
    	}
    	if ( sto_row_2.ENV_VAL_NM == undefined ) {
    		sto2 = 5;
    	} else {    		
   			sto2 = sto_row_2.ENV_VAL_NM;
    	}

    	util.logInfo('서명패드 Timeout : ' + sto1);
    	util.logInfo('서명패드 확인 Timeout : ' + sto2);
    	/********************************** 서명패드 timeout 설정 End   **********************************/
	}
    
    // 비동기 print를 5번 까지 호출하기 위한 함수. 재귀함수(print실패시 5회 재귀호출), 성공시 다음함수 수행.
    // 영수증 화면이 나오는 경우 여기 호출.
	this.printCallFor = function(params){
		util.logInfo("*****paymentChoiceView printCallFor START*****");
		orderPayRegService.printCall(params, function(rtn){
			util.logInfo("*****paymentChoiceView printCallFor return == > " +rtn);
			if(rtn==true){
				gnPrintIdx=0;
				gChgPrintVal = true;
				orderPayRegService.printForKitchen(params);
				paymentChoiceView.fnMovePageExe(gnPrintIdx,params);
			}else{
				if(gnPrintIdx == 4){ // 5번 수행후에도 true가 아니면 다음 로직 수행
					orderPayRegService.printForKitchen(params);
					paymentChoiceView.fnMovePageExe(5,params); // 인덱스를 5로 바꿔서 다음 로직 수행.
				}	
				gnPrintIdx++; // 프린트 5회를 재시도하기 위한 전역변수 (최초 0으로 설정)
				paymentChoiceView.printCallFor(params);
			}
		})
	}
	
    //print 출력이 완료 된 후의 callback 함수
    this.fnMovePageExe = function(j, params){
		util.logInfo("paymentChoiceView fnMovePageExe params >>> " + params.BILL_NO);            	

		// ASP전송 3번시도
		for (var x = 0 ; x < 3; x++ ) {
			if(orderPayRegService.transAspSaleData(params.BILL_NO) === true) {
				util.logInfo( "### orderPayRegService.transAspSaleData true ###");
				break;
			} 
			util.logInfo( "### make aspTransFile retry >>> " + x );
		}

		// 재출력시도 5번후 메세지 처리
		if(j == 5){
			var messageObj = util.languageObjReturn(langCode,  'issueReceiptOutput');
			var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
	        var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj, "button1Func": this.fnMoveIndex(), "button2Func": this.fnMoveIndex()};

	        // 경고메세지 팝업
	        eventBus.$emit('alertPopupIndex', dataObj);
		} else {
			
			// 영수증 화면 대기시간만큼만 보여주고 메인으로 이동
			var delayTime = parseInt(params.ENV_SET_VAL); // 영수증 대기화면 시간 (환경설정에서 설정가능)
			delayTime = delayTime -2; // 프린트를 비동기로 바꾸고 처리하는 시간동안 대기하고 있다. 3초정도 프린트 처리하는 시간이 있어 영수증대기화면시간-2초를 한다.
			if(delayTime < 0){ // 영수증대기화면 시간이 마이너스라면 0으로 바꾼다.
				delayTime = 1;
			}
			util.logInfo( "### delayTime >> " + delayTime);
			orderInfo = {};
			util.logInfo("______________ (상품결제) 결제 END _______________");
    		
    			//router.push({ path: '/start' })
    			if(0 == TempApproveCnt%5){
    				TempApproveCnt = 1;
    				setTimeout(() => {
	    				util.logInfo("______________________ *** #receiptPrint fnMovePage WAITING.HTML GO GO GO *** ___________________");
	    				location.href ='./waiting.html#?param='+ encodeURI(encodeURIComponent(langCode)) + ',' + encodeURI(encodeURIComponent(gvEatTakeOutVal));
    				}
    				, 5000);
    			}else{
    				setTimeout(() => {
	    				util.logInfo("______________________ *** #receiptPrint fnMovePage /start GO *** ___________________");
	    				router.push({ path: '/start' });//router 로 처리.2020.10.06 BJK 2020-12-23
	    			}
					, delayTime * 1000);
    			}
    			// router.push({path: '/start'})
    			
    			
			// router.push({path: '/start'});
		}
    }
    // 영수증 출력 화면
    this.fnReceiptPrint = function(){
        var returnTemplate = { template: '#receiptPrint'
	        , data : function () {
	    		return {
	    			orderNo : ""
	    			, getReceipt : ""
	    			, payComplete : ""
	    			, getCardAndReceipt : ""
    				, orderNumber : ""
    				, changePaperSubmit : ""
    				, aa : ""
    				//, reReceiptOutput : 0
    				, receiptNumShowVal : ""	
					, receiptBellImgVal : "N"	
					, receiptBellMsg1 : ""	
					, receiptBellMsg2 : ""	
	    		}
	    	}
            , created : function() {
            	if(SHOP_INFO.SHOP_TYPE == "1" || gvOrderOnly == "1"){
            		this.getReceipt = util.languageObjReturn(langCode,  'getReceiptCalcul');
                	this.payComplete = util.languageObjReturn(langCode,  'payCompleteCalcul');
                	this.getCardAndReceipt = util.languageObjReturn(langCode,  'getCardAndReceiptCalcul');
                	this.orderNumber = util.languageObjReturn(langCode,  'orderNumber');
            	}else{
            		this.getReceipt = util.languageObjReturn(langCode,  'getReceipt');
                	this.payComplete = util.languageObjReturn(langCode,  'payComplete');
                	this.getCardAndReceipt = util.languageObjReturn(langCode,  'getCardAndReceipt');
                	this.orderNumber = util.languageObjReturn(langCode,  'orderNumber');
            	}
            	
            	//진동벨 관련 문구
            	this.receiptBellMsg1 = util.languageObjReturn(langCode,  'receiptBellMsg1');
            	this.receiptBellMsg1 = util.languageObjReturn(langCode,  'receiptBellMsg2');
            	
            	if( gShopCd == "053705" ) {
            		this.changePaperSubmit = util.languageObjReturn(langCode,  'changePaperSubmit');
            	} else {
            		var pagmsOption = gfn_SQLiteSQLProcess(sqlQuery.selectPagmsOption, [gShopCd, gPosNo]).Data;
        			util.logInfo("### pagmsOption >>> " + JSON.stringify(pagmsOption));
        			
        			if(pagmsOption != undefined && pagmsOption != null && pagmsOption != "" && pagmsOption.length > 0) {
        				if(pagmsOption[0].PAG_TYPE_FG == "00" || pagmsOption[0].PAG_TYPE_FG == "01" || pagmsOption[0].PAG_TYPE_FG == "02" || pagmsOption[0].PAG_TYPE_FG == "03" || pagmsOption[0].PAG_TYPE_FG == "51") {
        					//진동벨이 있는경우
    						util.logInfo("______________ 영수증 화면에서 진동벨 관련 문구 보여주기!! ____________");
    						this.receiptBellImgVal = "Y";
        				} 
        			}
        			
        			if(this.receiptBellImgVal == "N") {
        				var s = "SELECT COM_CD_NM, COM_CD_ITEM_01, COM_CD_ITEM_02 FROM SCD_CODEM_T WHERE SHOP_CD = ? AND COM_CD_FG = ? ORDER BY COM_CD LIMIT 1 /** 단발성 SQL **/ ";
        				var db_result = gfn_SQLiteSQLProcess( s , [gShopCd, 606]);
        				
        				util.logInfo( "### db_result.Data >> " + JSON.stringify(db_result.Data));
        				
        				//출력문구가 있는경우
        				if (!util.isEmpty(db_result.Data)) {
        					if(langCode == "ko") {
        						this.changePaperSubmit = db_result.Data[0].COM_CD_ITEM_01;
        					} else {
        						this.changePaperSubmit = db_result.Data[0].COM_CD_ITEM_02;
        					}
        				}
        			}
            		
            	}
            	
            }
            , mounted : function() {
            	// this.$root.$on('goReceiptPrintPage', obj);
            	var params = this.$route.params.obj;
            	this.orderNo = params.ORDER_NO;
            	// this.fnMovePage(params);

            	//영수증 번호를 노출하기 위한 옵션
            	//this.receiptNumShowVal = util.GetEnvXmlPosENV(702);
            	//this.receiptNumShowVal = "1";
        		if( util.byteLen(this.receiptOutputVal) == 0 ) this.receiptOutputVal = "1";
        		
            	// setTimeout( this.fnMovePage(params), delayTime * 1000);
    			setTimeout(() => {
    				this.fnMovePage(params);
        			}, 100);
    			
            }
            , updated : function() {
            	
            }
            , beforeDestroy : function() {
            	
            }
            , destroyed: function(params) {
            	
            }
            , methods : {
            	fnMovePage : function(params) {

					util.logInfo("#receiptPrint fnMovePage START params >>> " + params.BILL_NO);
            		//TODO 프린트 재출력 호출....5번 시도.
//            		for (var i = 0 ; i < 5; i++ ) {
//            			if ( this.printCall(params) == true) {
//            				util.logInfo( "this.printCall(params) true!! ");
//            				break;
//            			} else {
//            				util.logInfo("______________ (상품결제) printCall " + i + " 회 출력시도 _______________");
//            				j++;
//            			}
//            		}
            		
            		var receiptOutputVal = util.GetEnvXmlPosENV(702);
            		if( util.byteLen(receiptOutputVal) == 0 ) receiptOutputVal = "1";
            		util.logInfo("###receiptPrint receiptOutputVal >>> " + receiptOutputVal);
            		
            		gChgPrintVal = false;
            		
            		if(receiptOutputVal == "1") {
            			//영수증 출력
            			paymentChoiceView.printCallFor(params); 
            		} else if(receiptOutputVal == "2") {
            			//영수증 조건부 출력
            			var messageObj = util.languageObjReturn(langCode,  'receiptOutput');
            			var messageObj2 = "";
            			var messageObj3 = "";
            			
            			if(!util.isEmpty(orderInfo.BARODA_INFO)) {
            				if(!util.isEmpty(orderInfo.BARODA_INFO.subscribeEndDate)) {
            					messageObj2 = util.languageObjReturn(langCode, 'phoneNumber2') + " : " + orderInfo.BARODA_INFO.phoneNumber;
//                    			messageObj3 = util.languageObjReturn(langCode, 'startDate') + " : " + orderInfo.BARODA_INFO.subscribeStartDate
//                    							+ " / " + util.languageObjReturn(langCode, 'endDate') + " : " + orderInfo.BARODA_INFO.subscribeEndDate
    							messageObj3 = util.languageObjReturn(langCode, 'subsEndDate') + " : " + orderInfo.BARODA_INFO.subscribeEndDate;
            				}
            			}
                    	var button1Name = util.languageObjReturn(langCode, 'no') // [ 아니요 ]
        				var button2Name = util.languageObjReturn(langCode, 'yes') // [ 예 ]
            			
            			var dataObj = {"button1Show" : true, "button1Name" : button1Name, "button2Show" : true, "button2Name" : button2Name, message: messageObj, "couponProdExs" : "Y", "params" : params, message2: messageObj2,  message3: messageObj3};
            			
            			dataObj.button2Func = function(){
            				//영수증 재출력 방지용
            				gReReceiptOutput++;
            				util.log("### fnReceiptPrint gReReceiptOutput : " + gReReceiptOutput);
            				if(gReReceiptOutput < 2){
            					this.alertPopupShow = false;
            					this.styleObject = {display : 'none'};
            					paymentChoiceView.fnReceiptPrintResult(params, "Y");
            				}
            			};
            			
            			dataObj.button1Func = function(){
            				//영수증 재출력 방지용
            				gReReceiptOutput++;
            				util.log("### fnReceiptPrint gReReceiptOutput : " + gReReceiptOutput);
            				if(gReReceiptOutput < 2){
            					this.alertPopupShow = false;
            					this.styleObject = {display : 'none'};
            					paymentChoiceView.fnReceiptPrintResult(params, "N");
            				}
            			};
            									
						if(issueStampMsgInfo != null){
							// 스템프 적립 메시지..
							dataObj.message4 = issueStampMsgInfo.message;
						}

						eventBus.$emit('receiptOutputPopup', dataObj);

            		} else {
            			//영수증 미출력, 추방출력
            			util.logInfo("#receiptPrint TEST 33 ");
        				this.fnNoReceiptOutput(params);
            			
            		}
            	} 
	            , printCall : function( params  ) {
	            	var rtn = false;
	        		var r ;
	        		try {
	        			r = printService.printDo("93", params );
	        			if (r.ResultCode != 0 ) {
	        				// this.printData = r.printData ;//TODO
	        				util.logInfo("print fail!!!!!");
	        			} else {
	        				util.logInfo("print success!!!!!");
	        				rtn = true;
	        				// 출력완료
	        				//router.push({name: 'receiptPrint', params: { orderNo: row.BILL_NO }})fnGoToMain
	        			}

					} catch (e) {
						util.logError(e);
						// TODO 메세지 출력...
						// alert('프린터 출력 실패...');
					}
					return rtn;
	            }// end printCall
	            , fnMoveIndex : function(){
	            	util.logInfo("______________________ *** #receiptPrint fnMoveIndex /start GO *** ___________________");
//    				router.push({ path: '/start' });//router 로 처리.2020.10.06 BJK 2020-12-23
	    			if(0 == TempApproveCnt%5){
	    				TempApproveCnt = 1;
	    				util.logInfo("______________________ *** #receiptPrint fnMoveIndex WAITING.HTML GO GO GO *** ___________________");
	    				location.href ='./waiting.html#?param='+ encodeURI(encodeURIComponent(langCode)) + ',' + encodeURI(encodeURIComponent(gvEatTakeOutVal));
	    			}else{
	    				util.logInfo("______________________ *** #receiptPrint fnMoveIndex /start GO *** ___________________");
	    				router.push({ path: '/start' });//router 로 처리.2020.10.06 BJK 2020-12-23
	    			}
//	        		router.push({ path: '/start' });//router 로 처리.2020.10.06
	            }
	            , fnGoToMain : function (){
					util.logInfo("_________fnGoToMain Button______________");
	            	gReRegFlag = "Y";
	            	router.push({path: '/start'});
	            }
	            , fnNoReceiptOutput : function (params){
	            	util.logInfo("#receiptPrint TEST 44 ");
	            	orderPayRegService.printForKitchen(params);
        			paymentChoiceView.fnMovePageExe(0,params);
	            }
            }
        };
        return returnTemplate;
    }
    ,
    
    this.fnReceiptPrintResult = function(params, receiptYn) {
    	util.logInfo("#fnReceiptPrintResult receiptYn " + receiptYn);
    	$(".layerPopup").hide();
    	
    	if(gReChgOutput != ""){
			clearTimeout(gReChgOutput);
		}
    	
    	if(receiptYn == "Y"){
			paymentChoiceView.printCallFor(params);
    	} else {
			if(orderPayRegService.printForKitchen(params)) {
				util.logInfo("#fnReceiptPrintResult printForKitchen true!!! ");
				paymentChoiceView.fnMovePageExe(0,params);
				
			};
    	}
    }
    ,
    // 간편결제 화면
    this.fnGetEasyPayment = function(){
    	// Test 코드.
		// orderInfo.POS_ODHDR_T = {};
		// orderInfo.POS_ODHDR_T.TOT_SALE_AMT = 11000;
		let retryCount = 0;
		let isFirst = true;
        let returnTemplate = {
			template: '#easyPayment'
			, data : function() {
				return {
					getTotalAmtView2   : ""
					, barcodeType  : ""
					, tgStampAddType  : "N"
					, barcodeOnly : "N"
					, accCreditType : ""
					, accEasyType : ""
				    , scPayCompleteVal : "Y"	
			    	, reqAmt : "0"	
				}
			}
			, created : function(){
				this.paymentAmount   = util.languageObjReturn(langCode , 'paymentAmount');
				this.selBarCode      = util.languageObjReturn(langCode , 'selBarCode');
				this.distanceBarcode = util.languageObjReturn(langCode , 'distanceBarcode');
				
				util.logInfo('## gPayBarcodeType : ' + gPayBarcodeType);
				//util.logInfo('## tgStampAddType : ' + JSON.stringify(this.$route.params.obj.tgStampAddType));
        		if(gPayBarcodeType == "TOLLGATE_S") {
        			//결제요청 타입이 톨게이트일떄
        			this.barcodeType = "tollgate";
        			//톨게이트 스탬프 바코드 스캔
        			this.toPaySimple     = util.languageObjReturn(langCode , 'tollgateBarcodeMsg1');
        			this.scanBarCode     = util.languageObjReturn(langCode , 'scanBarCode');
        			this.selBarCode      = util.languageObjReturn(langCode , 'tollgateBarcodeMsg5');
        		} else if(gPayBarcodeType == "TOLLGATE") {
        			//결제요청 타입이 톨게이트일떄
        			this.barcodeType = "tollgate";
        			//톨게이트 바코드 스캔
        			this.toPaySimple     = util.languageObjReturn(langCode , 'tollgateBarcodeMsg2');
        			//선불카드 번호 직접 입력
        			this.selBarCode      = util.languageObjReturn(langCode , 'tollgateBarcodeMsg8');
        			this.scanBarCode     = util.languageObjReturn(langCode , 'scanBarCode');
        		} else if(gPayBarcodeType == "SUPERCON") {
        			//결제요청 타입이 톨게이트일떄
        			this.barcodeType = "supercon";
        			//슈퍼콘 바코드 스캔
        			this.toPaySimple     = util.languageObjReturn(langCode , 'superConBarcodeMsg1');
        			this.scanBarCode     = util.languageObjReturn(langCode , 'scanBarCode');
        		} else {
        			this.toPaySimple     = util.languageObjReturn(langCode , 'toPaySimple');
        			this.scanBarCode     = util.languageObjReturn(langCode , 'scanBarCode');
        		}
        		
        		if(this.$route.params.obj !== undefined) {
        			this.tgStampAddType = this.$route.params.obj.tgStampAddType;
        			this.barcodeOnly = this.$route.params.obj.barcodeOnly;
        			this.accCreditType = this.$route.params.obj.accCreditType;
        			this.accEasyType = this.$route.params.obj.accEasyType;
        		}
			}
            ,mounted : function() {
        		try {
					b2bbarcode.stopScanBarcode();
				} catch (e) {
					util.logError('## error barcode camera 바코드 승인났는데 카메라 안꺼짐.');
					util.logError(e);
				}

            	// console.clear();
            	if ( orderInfo.POS_ODHDR_T == undefined ) {

            		this.$router.push({ path : '/start' });            		
            		return;
            	}

            	var getTotalSaleAmt = orderInfo.POS_ODHDR_T.TOT_SALE_AMT ;		// 주문금액
            	var getCstUsePoint  = orderInfo.POS_ODHDR_T.CST_USE_POINT;		// 할인금액
            	// var getDcPackPoint  = orderInfo.POS_ODHDR_T.DC_PACK_AMT;		// 포장할인금액
            	var getDcCpnAmt  = orderInfo.POS_ODHDR_T.DC_CPN_AMT;		// 쿠폰할인금액

            	if(getCstUsePoint == undefined || getCstUsePoint == "" || getCstUsePoint == null) {
            		getCstUsePoint = 0;
				}
            	
            	// if(getDcPackPoint == undefined || getDcPackPoint == "" || getDcPackPoint == null) {
            	// 	getDcPackPoint = 0;
				// }

            	if(getDcCpnAmt == undefined || getDcCpnAmt == "" || getDcCpnAmt == null) {
            		getDcCpnAmt = 0;
				}

            	// var realEasyPayAmt  = (getTotalSaleAmt - getCstUsePoint - getDcPackPoint - getDcCpnAmt);		// 결제금액(주문금액-할인금액-포장할인금액 - 쿠폰할인금액)
            	var realEasyPayAmt  = (getTotalSaleAmt - getCstUsePoint - getDcCpnAmt);		// 결제금액(주문금액-할인금액-쿠폰할인금액)
            	
				this.getTotalAmtView2   = util.numberWithCommas(realEasyPayAmt);

	        	retryCount = 0;// 초기화
            	this.$root.$on('barCodeInputResult' , obj => {
					util.logInfo("on -> barCodeInputResult " , obj);
					if(obj.appType != "tollgate" && obj.appType != "supercon") {
						if (util.byteLen(obj.appType.trTypeKey) == 0) {
							
							retryCount = 0;// 초기화
							if(util.isTizen() === false ) {
								setTimeout( this.fnStartBarCodeReader ,2000);
							} else {
								this.fnStartBarCodeReader();
							}
						} else {
							this.fnPayCall( obj.appType , obj.barCode);
						}
					} else {
						this.fnSetAppType(obj.barCode);
					}
					
            	});
            	
            	this.$root.$on('gotoEasyPayment' , obj => {
					util.logInfo("on -> gotoEasyPayment " + JSON.stringify(obj));
					this.toPaySimple     = util.languageObjReturn(langCode , 'toPaySimple');
        			this.barcodeType = "";
        			gPayBarcodeType = "";
        			//vue 강제 리프레쉬
        			this.$forceUpdate();
        			
        			setTimeout( ()=> {
    					this.fnStartBarCodeReader();
    				}, 500)
            	});

            	// 카메라에 바코드 또는 QR코드를 인식해 주세요. 음성추가.
            	var paramSrc = "./audio/28.mp3";
 			    // string으로 보내면 해당 src한건 수행, 배열로 보내면 배열만큼 연속적으로 음성안내 수행 (한글src만 보내면됨)
 			    util.fnAudioPlay(paramSrc); // 음성안내 공통함수 호출
 			    
 			    /******************************************
 			     * 최초 화면 진입전에 바코드 카메라가 구동되어 간편결제 화면이 렌더링 되지 않는 문제가 있다.
 			     * Delay time 을 주어서 일부 회피한다.
 			     ******************************************/
        		if ( isFirst == true ) {
        			if(util.isTizen() === false ) {
        				setTimeout( this.fnStartBarCodeReader ,2000);
        			} else {
        				setTimeout( ()=> {
        					this.fnStartBarCodeReader();
        				}, 500)
        			}
        			isFirst = false;
        		}
            }
        	,beforeDestroy : function () {
        		this.$root.$off('barCodeInputResult' );
        		this.$root.$off('gotoEasyPayment' );
        		retryCount= 0 , isFirst = true;
        		this.fnStopBarCodeReader();// 카메라 중지 한후 돌아가야한다.
        	}
        	, updated : function() {

        	}
        	,methods : {
            	fn_barCode_Popup : function() {
                    util.logInfo("openbarCodePopup Start");
                	try {
                		b2bbarcode.stopScanBarcode();
    				} catch (e) {
    				}

                    var paramObj = {
                    		a : 1
                    	  , b : 2
                    	  , barcodeType : this.barcodeType
                    };
                    this.$root.$emit('openbarCodePopup', paramObj);
                }
        		, fnHistoryBack : function() {
        			this.fnStopBarCodeReader();// 카메라 중지 한후 돌아가야한다.
        			if(orderInfo.SUPERCON_INFO !== undefined ) { //슈퍼콘 사용 취소
        				util.fnSuperConCancel();
        			}
              	    this.$router.push({ path : '/paymentChoiceView' });
        		}
        		, fnStartBarCodeReader : function() {
        			util.logInfo('barcode scan start!!')
        			try {
        				if(typeof tizen === 'undefined' ) {
        					//this.fncBarCodeListner("281006020000000000857324");//윈도우는 테스트 카카오 페이 신용
        				} else {
        					b2bbarcode.startScanBarcode(this.fncBarCodeListner);
        				}

					} catch (e) {
						console.error(e);
					}
        		}
        		, fncBarCodeListner : function(msg) {
        			let strBarcode ;
        			if(typeof tizen === 'undefined' ) {
        				strBarcode = msg;
        			} else {
        				if ( msg.data !== 'NOT_DETECTED' ){// 입력됨.
        					strBarcode = msg.data;
        				} else {
        					retryCount++;
        					console.log(`barcode 입력안됨 ${retryCount}`);
        					if( retryCount < 10 ) {
        						console.log(`Simple pay barcode empty, so retry  [${ retryCount}]`);
								this.fnStartBarCodeReader();// 재시도 함.
								return;
							}
							retryCount = 0;
							let dataObj = {
								  button1Show : true
								, button1Name : util.languageObjReturn(langCode, 'noticeCancel') // [ 취소 ]
								, button1Func : function(){
													router.push({path : '/paymentChoiceView'})
												}
								, button2Show : true
								, button2Name : util.languageObjReturn(langCode, 'retry') // [ 재시도 ]
								, button2Func : this.fnStartBarCodeReader
								, message     : util.languageObjReturn(langCode, 'barCodeEasyPayRetry') // [ 다시 결재를 시도하시겠습니까? ]
								, timeout     : 30 * 1000
								, timeoutFunc : function() {
												router.push({ path : '/start'})
											}
							};
							eventBus.$emit('alertPopupIndex' , dataObj);

        					return;
        				}
        			}
        			this.fnSetAppType(strBarcode);
				}
				, fnPayCall : function( appType , strBarcode ) {
					util.logInfo("easyPayment card auth call(fnPayCall)");
					try {
						//메인포스에서 주문번호를 받아오는 경우에는 db저장전에 한번더  채번을 해준다. 중복금지!!
					    //util.getOrderNoAspNoCallBack();
					    
	             		let payInfo = paymentChoiceService.singleBizAppr('BARCODE');
	             		payInfo.catId = orderInfo.CORNER_LIST[0].VAN_TERM_NO;
						paymentChoiceView.fnCreditApproveRequest(payInfo , appType, strBarcode , this.fnStartBarCodeReader);

					} catch (error) {
						console.error(error);
					}
				}
        		// app type 설정.
        		, fnSetAppType : function(strBarcode) {
        			let appType ="" , dataObj = {};
					try {
						util.beep(); // 바코드 인식되었다는 비프음 출력.
						waitingService.ResetLogOutTimer(); // 대기영상으로 돌아가는 시간 초기화.
						
						if(this.barcodeType == "tollgate") { // 톨게이트가 아닌 바코드 화면
							//tollgate 상품권일 경우
							var preStrBarcode = strBarcode.substr(0, 3)
							//tollgate 선불카드,금액권일 경우
							if(preStrBarcode == "305") {
								if(gPayBarcodeType == "TOLLGATE_S") {
									dataObj.button1Show = true;
									dataObj.button1Name = util.languageObjReturn(langCode, 'noticeCancel'); // [ 취소 ]
									dataObj.button1Func = function(){ router.push({path : '/paymentChoiceView'}) };
									dataObj.button2Show = true;
									dataObj.button2Name = util.languageObjReturn(langCode, 'retry'); // [ 재시도 ]
									dataObj.button2Func = this.fnStartBarCodeReader;
									//선불카드 바코드가 아닌 스탬프 바코드를 읽혀주세요.
									dataObj.message     = util.languageObjReturn(langCode, 'tollgateBarcodeMsg4');
									eventBus.$emit('alertPopupIndex' , dataObj);
									return;
								}
								
								// 선불카드인 경우
								if (orderInfo.tgStampBarcode !== undefined) {
									orderInfo.tgStampBarcode = undefined;
								}
								
								this.fnTgInquiry(strBarcode);
							} else if(preStrBarcode == "304" || preStrBarcode == "010") {
								// 스탬프 적립스캔, 핸드폰 번호로도 적립이 가능!!
								//this.fnTgStampInquiry(strBarcode);
								if(gPayBarcodeType == "TOLLGATE") {
									dataObj.button1Show = true;
									dataObj.button1Name = util.languageObjReturn(langCode, 'noticeCancel'); // [ 취소 ]
									dataObj.button1Func = function(){ router.push({path : '/paymentChoiceView'}) };
									dataObj.button2Show = true;
									dataObj.button2Name = util.languageObjReturn(langCode, 'retry'); // [ 재시도 ]
									dataObj.button2Func = this.fnStartBarCodeReader;
									//스탬프 바코드가 아닌 선불카드 바코드를 읽혀주세요.
									dataObj.message     = util.languageObjReturn(langCode, 'tollgateBarcodeMsg3'); // [ 다시 결재를 시도하시겠습니까? ]
									eventBus.$emit('alertPopupIndex' , dataObj);
									return;
								}
								
								orderInfo.tgStampBarcode = strBarcode;
								//util.logInfo("orderInfo.tgStampBarcode >>> " + orderInfo.tgStampBarcode);
								//this.fnPayCall( appType , strBarcode);
								if(this.accCreditType == "Y") {
									paymentChoiceView.creditApprRequest();
								}
								
								if(this.accEasyType == "Y") {
									gPayBarcodeType = "";
//									var obj = {
//			            					BTN_TYPE    : "EASY",
//			            					accEasyType : 'Y',
//			            					btnType		: "EASY"
//			            			};
									//this.$router.go(0);
									let paramObj ={
										 barCode : strBarcode
									};
									this.$root.$emit('gotoEasyPayment', paramObj);
									//this.$router.push({ name : 'easyPayment', params: {"id": 12}});
								}
							} else {
								if(this.accEasyType == "Y" || this.accCreditType == "Y") {
									var preStrBarcode = strBarcode.substr(0, 3);
									//tollgate 선불카드,금액권일 경우
									if(preStrBarcode == "404") {
										dataObj.button1Show = true;
										dataObj.button1Name = util.languageObjReturn(langCode, 'noticeCancel'); // [ 취소 ]
										dataObj.button1Func = function(){ router.push({path : '/paymentChoiceView'}) };
										dataObj.button2Show = true;
										dataObj.button2Name = util.languageObjReturn(langCode, 'retry'); // [ 재시도 ]
										dataObj.button2Func = this.fnStartBarCodeReader;
										//스탬프 바코드가 아닌 선불카드 바코드를 읽혀주세요.
										dataObj.message     = util.languageObjReturn(langCode, 'tollgateBarcodeMsg10'); // [ 다시 결재를 시도하시겠습니까? ]
										eventBus.$emit('alertPopupIndex' , dataObj);
										return;
									}
								} else {
									if(kerbanDiscountRateYn == "Y"){ // 할인률적용 여부
										dataObj.button1Show = true;
										dataObj.button1Name = util.languageObjReturn(langCode, 'noticeCancel'); // [ 취소 ]
										dataObj.button1Func = function(){ router.push({path : '/paymentChoiceView'}) };
										dataObj.button2Show = true;
										dataObj.button2Name = util.languageObjReturn(langCode, 'retry'); // [ 재시도 ]
										dataObj.button2Func = this.fnStartBarCodeReader;
										dataObj.message     = '고객등급할인 적용시 쿠폰 사용불가합니다.';
										eventBus.$emit('alertPopupIndex' , dataObj);
										return;
									}else{
										
										if(orderInfo.TOLLGATE_DC_INFO !== undefined && orderInfo.TOLLGATE_DC_INFO.discountAmount > 0){
											dataObj.button1Show = true;
											dataObj.button1Name = util.languageObjReturn(langCode, 'noticeCancel'); // [ 취소 ]
											dataObj.button1Func = function(){ router.push({path : '/paymentChoiceView'}) };
											dataObj.button2Show = true;
											dataObj.button2Name = util.languageObjReturn(langCode, 'retry'); // [ 재시도 ]
											dataObj.button2Func = this.fnStartBarCodeReader;
											dataObj.message     = '선불카드만 사용가능합니다.';
											eventBus.$emit('alertPopupIndex' , dataObj);
											return;
										}else{
											//404288 교환권
											this.fnTgCouponInquiry(strBarcode);
										}

									}
								}
							}
							
						} else if(this.barcodeType == "supercon") {
							//슈퍼콘일 경우
							var preStrBarcode = strBarcode.substr(0, 3)
							//supercon 선불카드,금액권이 아닌 경우
							if(preStrBarcode != "390" && preStrBarcode != "391" && preStrBarcode != "392") {
								dataObj.button1Show = true;
								dataObj.button1Name = util.languageObjReturn(langCode, 'noticeCancel'); // [ 취소 ]
								dataObj.button1Func = function(){ router.push({path : '/paymentChoiceView'}) };
								dataObj.button2Show = true;
								dataObj.button2Name = util.languageObjReturn(langCode, 'retry'); // [ 재시도 ]
								dataObj.button2Func = this.fnStartBarCodeReader;
								//슈퍼콘 바코드를 읽혀주세요.
								dataObj.message     = "슈퍼콘 바코드를 읽혀주세요.";
								//dataObj.message    = util.languageObjReturn(langCode, 'tollgateBarcodeMsg4');
								eventBus.$emit('alertPopupIndex' , dataObj);
								return;
							} else {
								//슈퍼콘 쿠폰인경우 390xxxxx
								
							}
							
							this.fnScInquiry(strBarcode);
						} else {
							appType = util.GetSimplePayTrType(strBarcode);						
							// bjk 중계서버 여기서 분기할 부분 확인하면 될거 같음.
							this.fnPayCall( appType , strBarcode);
						}
						
					} catch (e) {
						console.error(e);
						let ecd = e.errCode;
						if ( ecd.startsWith("0") ) {
							dataObj.button2Show = false;
							dataObj.button1Func = this.fnStartBarCodeReader
						}  else {
							dataObj.button2Show = false;
							dataObj.button1Func = this.fnStartBarCodeReader
						}
						dataObj.message = e.errMsg;
						eventBus.$emit('alertPopupIndex', dataObj);
					}
        		}
        		, fnStopBarCodeReader : function() {
        			if(typeof tizen == "undefined" ) return;
        			try {
        				b2bbarcode.stopScanBarcode();
					} catch (e) {
						console.error(e);
					}
        		}
        		, fnTgInquiry : function(strBarcode) {
        			//톨게이트 선불카드 조회
        			var tgSignMsg = "";
        			
        			//예: serviceId: "A", posStoreNo: "B"일때 plain이 serviceId + posStoreNo라면 "A:B"
        			tgSignMsg = tgServiceId + ":" + gShopCd + ":" + gPosNo + ":" + strBarcode;
        			
        			var hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey);
        			var hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
        			  
        			let paramObj = {
    					serviceId : tgServiceId
						, posStoreNo : gShopCd
						, posTerminalNo : gPosNo
						, sign : hashInBase64
						, callbackParam : ""
						, additionalData : ""
						, barcodeNo : strBarcode
						, barcodeInputType : "SCAN"	
					};
        			var tgTargetUrl = "/v1/gw/pos/fdk/getBarcodeInfo.do";
        			//debugger;
        			var result = util.ajaxCallTollgate(paramObj, tgTargetUrl, this.fnTgInquiryCallback);
        			
        			if(result.resultCode == "ERROR") {
        				//톨게이트 선불카드 조회 실패입니다. 관리자에게 문의해주세요.
        				var errMsg = "톨게이트 선불카드 조회 실패입니다. 관리자에게 문의해주세요.";
        				this.tgErrorResult(errMsg)
        			}
        		}
        		, fnTgCouponInquiry : function(strBarcode) {
        			//톨게이트 선불카드 조회
        			var tgSignMsg = "";
        			
        			//예: serviceId: "A", posStoreNo: "B"일때 plain이 serviceId + posStoreNo라면 "A:B"
        			tgSignMsg = tgServiceId + ":" + gShopCd + ":" + gPosNo + ":" + strBarcode;
        			
        			var hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey);
        			var hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
        			  
        			let paramObj ={
    					serviceId : tgServiceId
						, posStoreNo : gShopCd
						, posTerminalNo : gPosNo
						, sign : hashInBase64
						, callbackParam : ""
						, additionalData : ""
						, barcodeNo : strBarcode
						, barcodeInputType : "SCAN"	
					};
        			var tgTargetUrl = "/v1/gw/pos/fdk/getCouponInfo.do";
        			
    				var result = util.ajaxCallTollgate(paramObj, tgTargetUrl, this.fnTgCouponInquiryCallback);
        			
					// test
    				// var result = {};

					// console.log('orderInfo',orderInfo);
					// result = {
					// 	"resultCode": "SUCCESS",
					// 	"resultMessage": null,
					// 	"verboseMessage": null,
					// 	"body": {
					// 	  "serviceId": "tollgate",
					// 	  "posStoreNo": "OKSHOP01",
					// 	  "posTerminalNo": "OKTERM01",
					// 	  "sign": "설계-요청전문 Sign 참고",
					// 	  "callbackParam": "cbParam",
					// 	  "additionalData": "plusDate",
					// 	  "barcodeNo": "4042883286126341",
					// 	  "barcodeInputType": "SCAN",
					// 	  "title": "아메리카노(HOT)",
					// 	  "details": "아메리카노(HOT)",
					// 	  "productCodes": [
					// 		"E0000127",
					// 		"E0000126"
					// 	  ],
					// 	  "couponPrice": 20,
					// 	  "issueDate": "2017-04-06T15:19:13",
					// 	  "expireDate": "2017-05-06T15:19:13",
					// 	  "isUsable": false,
					// 	  "usedPosStoreNo": "OKSHOP01",
					// 	  "usedHqStoreNo": "SHOP01",
					// 	  "usedTerminalNo": "OKTERM01",
					// 	  "usedPosOrderNo": "201704061945260147Ydl4qO",
					// 	  "usedPosOrderDate": "2017-04-06T19:45:26",
					// 	  "usedSattlementDate": "2017-04-06",
					// 	  "usedCouponTransactionId": "TEST2017040619452608886Xzmye",
					// 	  "usedCouponTransactionDate": "2017-04-06T19:45:27"
					// 	}
					//   }

					//   this.fnTgCouponInquiryCallback(result);
					// test


    				if(result.resultCode == "ERROR") {
        				//톨게이트 선불카드 조회 실패입니다. 관리자에게 문의해주세요.
        				var errMsg = "톨게이트 교환권 조회 실패입니다. 관리자에게 문의해주세요.";
						if(!util.isEmpty(result.resultMessage)){
							errMsg = result.resultMessage;
						}
        				this.tgErrorResult(errMsg);
        			}else if(!result.body.isUsable){
						var errMsg = "톨게이트 교환권 조회 실패입니다. 관리자에게 문의해주세요.";
        				this.tgErrorResult(errMsg);
					}
        		}
        		, fnTgStampInquiry : function(strBarcode) {
        			//톨게이트 선불카드 조회
        			var tgSignMsg = "";
        			
        			//톨게이트 선불카드 사용 요청
        			util.logInfo("### fnTgStampInquiry START");
        			
        			//getBillNo
                    var sslTrhdrBillNo = orderInfo.posBillNo;
        			
        			var tgSignMsg = "";
        			var orderDate = moment().format("YYYY-MM-DDTHH:mm:ss");
        			var tgStampCnt = util.calcTgStampCnt();
        			//"serviceId+posStoreNo+posTerminalNo+posOrderNo+orderDate+amount+barcodeNo"
        			tgSignMsg = tgServiceId + ":" + gShopCd + ":" + gPosNo + ":" + sslTrhdrBillNo 
        			 			+ ":" + orderDate + ":" + tgStampCnt + ":" + strBarcode;
        			
        			var hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey);
        			var hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
        			  
        			let paramObj = {
    					serviceId : tgServiceId
						, posStoreNo : gShopCd
						, posTerminalNo : gPosNo
						, sign : hashInBase64
						, callbackParam : ""
						, additionalData : ""
						, posOrderNo : sslTrhdrBillNo
						, orderDate : orderDate
						, stampCount : tgStampCnt	
						, barcodeNo : strBarcode
						, barcodeInputType : "SCAN"	
						, sattlementDate : moment().format("YYYY-MM-DD", saleDate)	
					};
        			
        			var tgTargetUrl = "/v1/gw/pos/fdk/issueStamp.do";
        			
        			var result = util.ajaxCallTollgate(paramObj, tgTargetUrl, this.fnTgStampInquiryCallback);
        			
    				if(result.resultCode == "ERROR") {
        				//톨게이트 선불카드 조회 실패입니다. 관리자에게 문의해주세요.
        				var errMsg = "톨게이트 스탬프 적립 실패입니다. 관리자에게 문의해주세요.";
        				this.tgErrorResult(errMsg);
        			}
        			
        		}
        		, fnTgInquiryCallback : function(result) {
        			//톨게이트 선불카드 조회후 콜백
        			//util.logInfo("### fnTgInquiryCallback typeof result : " + typeof result)
        			util.logInfo("### fnTgInquiryCallback result : " + JSON.stringify(result))
        			
        			var resInquiryData = result;
        			var bInquiryData = resInquiryData.body; 
        			
        			let obj ={
    					resultingBalance : bInquiryData.resultingBalance
    					, barcodeNo : bInquiryData.barcodeNo
    					, barcodeType : "P" //선불카드
					};
        			
					//this.$root.$emit('onTollgatePayView', paramObj);
					this.$router.push({name: 'tollgatePayView', params : {obj}})
        		}
        		, fnTgCouponInquiryCallback : function(result) {
        			//톨게이트 선불카드 조회후 콜백
        			util.logInfo("### fnTgCouponInquiryCallback typeof result : " + typeof result)
        			
        			var resInquiryData = result;
        			var bInquiryData = resInquiryData.body; 
        			
        			let obj = {
    					resultingBalance : 0
    					, barcodeNo : bInquiryData.barcodeNo
    					, barcodeType : "C" //교환권
    					, productCodes : bInquiryData.productCodes
    					, title : bInquiryData.title
					};

					if(Number(bInquiryData.couponPrice) < 100){ // couponPrice 100이하면 쿠폰할인..
						obj.barcodeType = "D" // 쿠폰할인
						obj.couponPrice = bInquiryData.couponPrice // couponPrice
					}
        			
					//this.$root.$emit('onTollgatePayView', obj);
					this.$router.push({name: 'tollgatePayView', params : {obj}})
        		}
        		, fnTgRedeemCallback : function (result) {
        			//쿠폰사용 신청후 콜백함수
        			util.logInfo("### fnTgRedeemCallback START ###");
        			var resRedeemData = JSON.parse(result);
        			var bRedeemData = resRedeemData.body;
        			
        			//톨게이트 결제요청 응답데이터, 결제취소할대 필요한 데이터
        			orderInfo.TOLLGATE_INFO = {
        					"posOrderNo" : bRedeemData.posOrderNo
        					, "orderDate" : bRedeemData.orderDate
        					, "amount" : bRedeemData.amount
        					, "barcodeNo" : bRedeemData.barcodeNo
        					, "sattlementDate" : bRedeemData.sattlementDate
        					, "receiptNo" : bRedeemData.receiptNo
        					, "accountTransactionId" : bRedeemData.accountTransactionId
        					, "accountTransactionDate" : bRedeemData.accountTransactionDate
        			};
        			
        			//
        			
        			util.logInfo("### fnTgRedeemCallback END ###");
        		}
        		, tgErrorResult : function (errMsg) {
        			let dataObj = {};
    				dataObj.button2Show = true;
    				dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm') // [ 예 ]
    				dataObj.button2Func = function() {
						router.push({ path : '/start'})
					}
        			dataObj.message = errMsg;
    				
        			eventBus.$emit('alertPopupIndex', dataObj);
        		}
        		
        		, fnScInquiry : function(strBarcode) {
        			//슈퍼콘 쿠폰 조회
        			  
        			let paramObj = {
    					couponNo : strBarcode
        				, branchId : gShopCd
						, branchName : SHOP_INFO.SHOP_NM
						, partnerId : scPartnerId
						, posDate : saleDate
						, posTime : moment().format("HHmmss")
						, posType : "Kiosk"
					};
        			var tgTargetUrl = "/authapi/auth";
        			//debugger;
        			
        			util.superConAjaxCall(paramObj, false, tgTargetUrl, this.fnScInquiryCallback);
        			
//        			if(result.resultCode != "0000") {
//        				//슈퍼콘 조회 실패입니다. 관리자에게 문의해주세요.
//        				var errMsg = "슈퍼콘 조회 실패입니다. 관리자에게 문의해주세요.";
//        				this.tgErrorResult(errMsg);
//        			}
        		}
        		
        		, fnScInquiryCallback : function(result) {
        			//슈퍼콘 쿠폰 조회 후 콜백함수
        			util.logInfo("### fnScInquiryCallback result : " + JSON.stringify(result))

        			let scInquiryData = result; 
        			
        			if(scInquiryData.resultCode != "0000") {
        				//모바일 교환권(금액권) 조회에 실패했습니니다. 구매처에 문의해주세요.
        				//var errMsg = "모바일 교환권(금액권) 조회에 실패했습니니다. 구매처에 문의해주세요.";
        				var errMsg = util.languageObjReturn(langCode, 'superConBarcodeMsg6')
        				this.scErrorResult(errMsg);
        				return;
        			}
        			
//        			orderInfo.SUPERCON_INFO = {
//    					branchId : scInquiryData.branchId
//    					, branchName : scInquiryData.branchName
//    					, couponNo : scInquiryData.couponNo
//    					, execTime : scInquiryData.execTime
//    					, partnerId : scInquiryData.partnerId
//    					, posDate : scInquiryData.posDate
//    					, posTime : scInquiryData.posTime
//    					, prodBalance : scInquiryData.prodBalance
//    					, prodCode : scInquiryData.prodCode
//    					, prodName : scInquiryData.prodName
//    					, prodPrice : scInquiryData.prodPrice
//    					, prodType : scInquiryData.prodType
//					};
        			
        			//this.$router.push({ path : '/paymentChoiceView' });
        			
        			//쿠폰상품이 상품가격보다 비싼지 비교하는 변수
    				let prodPriceMore = "Y";
        			let useAmount = "";
					let s_posType = '';
        			if(scInquiryData.prodType == "AMOUNT" ) {
        				//금액권인 경우에 잔액과 상품금액을 비교해서 잔액이 상품 금액보다 적은경우에는 잔액으로 사용금액을 세팅
        				if(Number(scInquiryData.prodBalance) >= Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT)) {
        					this.reqAmt = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;
        				} else {
        					this.reqAmt = scInquiryData.prodBalance;
        					//잔액이 상품금액보다 적고 복합결제인 경우
        					//this.scPayCompleteVal = "N";
        				}
        			} else {
        				//슈퍼콘 쿠폰 상품의 금액이 실제 매장의 상품 금액보다 큰 경우에는 실제 매장의 상품금액으로 세팅해준다.
        				//그외 실제 상품금액보다 쿠폰의 금액이 작은경우에는 쿠폰의 상품금액으로 세팅
        				let sumProdPrice = 0;
						
						if(scInquiryData.prodCode.includes(',')){ // 쿠폰 상품코드가 배열일경우.. ('a1,a2,a3'...)
							const tmpProdCodeList = scInquiryData.prodCode.split(',');
							let tmpArray = [];
							for(var i = 0; i < orderInfo.POS_ODDTL_T.length; i++) {
								tmpProdCodeList.forEach(obj => {									
									if(orderInfo.POS_ODDTL_T[i].PROD_CD == obj) { // 쿠폰상품코드 일치
										tmpArray.push(orderInfo.POS_ODDTL_T[i])
									}
								});
							}

							if(tmpArray.length > 1){ // 쿠폰상품코드 일치하는 수가 1개 이상일경우..
								// 판매가가 가장높은상품
								const maxSaleUprc = tmpArray.reduce((a, b) => { 
									return (a > Number(b.SALE_UPRC)) ? a:Number(b.SALE_UPRC);
								});
								s_posType = tmpArray.filter((a) => {
										return Number(a.SALE_UPRC) === Number(maxSaleUprc)
								})[0].PROD_CD // 쿠폰의 상품코드와 일치하는 코드..

								sumProdPrice += maxSaleUprc; 

							}else if(tmpArray.length == 1){ // 1개 일경우..
								sumProdPrice += Number(tmpArray[0].SALE_UPRC);
								s_posType = tmpArray[0].PROD_CD; // 쿠폰의 상품코드와 일치하는 코드..
							}

						}else{
							
							for(var i = 0; i < orderInfo.POS_ODDTL_T.length; i++) {
								if(orderInfo.POS_ODDTL_T[i].PROD_CD == scInquiryData.prodCode) {
									sumProdPrice += Number(orderInfo.POS_ODDTL_T[i].SALE_UPRC);
									s_posType = orderInfo.POS_ODDTL_T[i].PROD_CD; // 쿠폰의 상품코드와 일치하는 코드..
								}
							}
						}
        				
        				this.reqAmt = sumProdPrice;
        				
        				if(sumProdPrice == 0) {
        					//슈퍼본 쿠폰 상품의 코드가 없는 경우에는 쿠폰 상품 금액 or 매장의 상품 금액으로 요청 금액 세팅
        					if(Number(scInquiryData.prodPrice) > Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT)) {
        						this.reqAmt = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;
        					} else {
        						this.reqAmt = scInquiryData.prodPrice;
        					}
							s_posType = 'NONE'; // 쿠폰의 상품코드와 일치하는 코드가 없을경우..
        				}
    					
        				if(Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT) >= Number(scInquiryData.prodPrice)) {
        					//모바일 쿠폰 금액과 상품의 결제 금액이 같은 경우에는 팝업 패스!!
        					prodPriceMore = "N";
        				}
        			}
        			
        			let paramObj = {
    					couponNo : scInquiryData.couponNo
        				, branchId : scInquiryData.branchId
						, branchName : scInquiryData.branchName
						, partnerId : scInquiryData.partnerId
						, posDate : scInquiryData.posDate
						, posTime : scInquiryData.posTime
						, useAmount : this.reqAmt
						// , posType : "Kiosk"
						, posType : s_posType
					};
        			var tgTargetUrl = "/authapi/use";
        			
        			if(prodPriceMore == "N") {
        				util.superConAjaxCall(paramObj, false, tgTargetUrl, this.fnScCouponUseCallback);
        			} else {
	    				let dataObj = {};
	        	        dataObj.button1Show = true;
	        	        dataObj.button1Name = util.languageObjReturn(langCode, 'no') // [ 아니오 ]
	        	        dataObj.button1Func = this.fnGoBack
	    				dataObj.button2Show = true;
	    				dataObj.button2Name = util.languageObjReturn(langCode, 'yes') // [ 예 ]
	    				dataObj.button2Func = this.fnScCouponUse;
	        			dataObj.data = paramObj;
	    				
	        			if(scInquiryData.prodType == "EXCHANGE") {
	        				dataObj.message = util.languageObjReturn(langCode, 'superConBarcodeMsg2');
	    					dataObj.message2 = util.languageObjReturn(langCode, 'superConBarcodeMsg3') + scInquiryData.prodPrice 
	    					+ ", " + util.languageObjReturn(langCode, 'superConBarcodeMsg4') + this.reqAmt;
	    				} else {
	    					dataObj.message = util.languageObjReturn(langCode, 'superConBarcodeMsg5');
	    					dataObj.message2 = util.languageObjReturn(langCode, 'superConBarcodeMsg3') + scInquiryData.prodBalance 
	    					+ ", " + util.languageObjReturn(langCode, 'superConBarcodeMsg4') + this.reqAmt;
	    				}
	        			eventBus.$emit('alertPopupIndex', dataObj);
	        			return;
        			}
        		}
        		, fnScCouponUse : function(data) {
        			var tgTargetUrl = "/authapi/use";
        			//setTimeout(util.superConAjaxCall(data, false, tgTargetUrl, this.fnScCouponUseCallback);
        			setTimeout(() => {
        				util.superConAjaxCall(data, false, tgTargetUrl, this.fnScCouponUseCallback)
    				}
    				, 1000);
        		}
        		, fnScCouponUseCallback : function(result) {
        			util.logInfo("### fnScCouponUseCallback result : " + JSON.stringify(result))

        			let scCouponUseData = result; 
        			
        			if(scCouponUseData.resultCode != "0000") {
        				//슈퍼콘 조회 실패입니다. 관리자에게 문의해주세요.
        				var errMsg = "슈퍼콘 조회 실패입니다. 관리자에게 문의해주세요.";
        				this.scErrorResult(errMsg);
        				return;
        			}
        			
        			// 쿠폰조회후 결과처리 바로 결체 or 복합결제 or 쿠폰교환권 처리
        			orderInfo.SUPERCON_INFO = {
    					branchId : scCouponUseData.branchId
    					, branchName : scCouponUseData.branchName
    					, couponNo : scCouponUseData.couponNo
    					, execTime : scCouponUseData.execTime
    					, partnerId : scCouponUseData.partnerId
    					, posDate : scCouponUseData.posDate
    					, posTime : scCouponUseData.posTime
    					, prodCode : scCouponUseData.prodCode
    					, useAmount : scCouponUseData.useAmount
    					, prodName : scCouponUseData.prodName
    					, prodPrice : scCouponUseData.prodPrice
    					, prodType : scCouponUseData.prodType
    					, prodBalance : scCouponUseData.prodBalance
    					, useDate : scCouponUseData.useDate
    					, useTime : scCouponUseData.useTime
    					, approvalNo : scCouponUseData.approvalNo
    					, posType : scCouponUseData.posType
					};
        			
    				// 매장의 상품코드와 슈퍼콘의 상품코드가 일치하지 않는경우 총결제금액이 쿠폰의 상품금액보다 큰 경우에는 복합결체
    				// 쿠폰의 상품금액이 총 결제 금액보다 큰 경우에는 결체금액으로 세팅해서 결제 처리
					orderInfo.SUPERCON_INFO.useAmount = this.reqAmt;
					if(Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT) > Number(orderInfo.SUPERCON_INFO.useAmount)) {
						this.scPayCompleteVal = "N";
					} else {
						this.scPayCompleteVal = "Y";
						
//						dataObj.button1Show = true;
//	        	        dataObj.button1Name = util.languageObjReturn(langCode, 'no'); // [ 아니오 ]
//	        	        dataObj.button1Func = this.fnGoBack;
//	    				dataObj.button2Show = true;
//	    				dataObj.button2Name = util.languageObjReturn(langCode, 'yes'); // [ 예 ]
//	    				dataObj.button2Func = this.cashReceiptPopup1;
//	    				//dataObj.data = scCouponUseData;
//	        			//dataObj.message = util.languageObjReturn(langCode, 'cashIssue');
//	    				dataObj.message = util.languageObjReturn(langCode, 'superConBarcodeMsg5');
//	    				
//	    				//잔액과 사용 요청 금액 표시
//	    				if(scCouponUseData.prodType == "EXCHANGE") {
//	    					dataObj.message2 = util.languageObjReturn(langCode, 'superConBarcodeMsg3') + scCouponUseData.prodPrice 
//	    					+ ", " + util.languageObjReturn(langCode, 'superConBarcodeMsg4') + scCouponUseData.useAmount;
//	    				} else {
//	    					dataObj.message2 = util.languageObjReturn(langCode, 'superConBarcodeMsg3') + scCouponUseData.prodBalance 
//	    					+ ", " + util.languageObjReturn(langCode, 'superConBarcodeMsg4') + scCouponUseData.useAmount;
//	    				}
//	    				
//	        			eventBus.$emit('alertPopupIndex', dataObj);
//	        	        return;
					}
					
					let dataObj = {};
        			
        	        dataObj.button1Show = true;
        	        dataObj.button1Name = util.languageObjReturn(langCode, 'no'); // [ 아니오 ]
        	        dataObj.button1Func = this.goToPayment;
    				dataObj.button2Show = true;
    				dataObj.button2Name = util.languageObjReturn(langCode, 'yes'); // [ 예 ]
    				dataObj.button2Func = this.goToCashReceipts;
        			dataObj.message = util.languageObjReturn(langCode, 'cashIssue');
        			dataObj.message2 = "";
    				
        			eventBus.$emit('alertPopupIndex', dataObj);
        	        return;
					
    				//this.goToPayment();
        			
        		}
        		, goToCashReceipts : function() {
        			this.$router.push({name: 'cashReceipts', params: { totalAmt: this.reqAmt, scPayCompleteVal : this.scPayCompleteVal }})
        		}
        		, fnGoBack : function() {
        			if(orderInfo.SUPERCON_INFO !== undefined ) { //슈퍼콘 사용 취소
        				util.fnSuperConCancel();
        			}
        			router.push({path: '/paymentChoiceView'}); 
        		}
        		, goToPayment : function() {
        			//0원 결제정보 설정
        			if(orderInfo.POS_ODHDR_T.GST_PAY_AMT == undefined) {
        				if(orderInfo.SUPERCON_INFO.useAmount !== undefined) {
        					orderInfo.POS_ODHDR_T.GST_PAY_AMT = Number(orderInfo.SUPERCON_INFO.useAmount); //받은금액
//        					if(this.scPayCompleteVal == "N") {
//        						orderInfo.POS_ODHDR_T.GST_PAY_AMT = orderInfo.SUPERCON_INFO.useAmount; //받은금액
//        					} else {
//        						orderInfo.POS_ODHDR_T.GST_PAY_AMT = 0; //받은금액
//        					}
        				} else {
        					orderInfo.POS_ODHDR_T.GST_PAY_AMT = 0; //받은금액
        				}
        			}
        			orderInfo.POS_ODHDR_T.CRD_CARD_AMT = 0;
        	  	   	orderInfo.POS_ODHDR_T.EXP_PAY_AMT  = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;	// 받을금액
        	  	   	orderInfo.POS_ODHDR_T.RET_PAY_AMT  = 0;		    							// 거스름돈 (RET_PAY_AMT)
        	  	   	
        	  	   	if(orderInfo.POS_ODHDR_T.DCM_SALE_AMT != undefined) {
        	  	   		orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.DCM_SALE_AMT;	// 매출금액
        	  	   	} else {
        	  	   		orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;	// 매출금액
        	  	   	}
        	  	   	
        	  	   	util.logInfo("### scPayCompleteVal " + this.scPayCompleteVal);
        	  	   	
        	  	   	if(this.scPayCompleteVal == "N") {
        	  	   		//router.push({path: '/paymentChoiceView'});
        	  	   		gCombinePayVal = "Y";
        	  	   		router.push({path: '/paymentChoiceView'});
        	  	   	} else {
        	  	   		paymentChoiceView.fnCardReaderStatusCallBack();
        	  	   	}
        		}
        		, scErrorResult : function (errMsg) {
        			let dataObj = {};
        			dataObj.button2Show = true;
        			dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm') // [ 예 ]
        			dataObj.button2Func = function() {
        				router.push({ path : '/start'})
        			}
        			dataObj.message = errMsg;
        			
        			eventBus.$emit('alertPopupIndex', dataObj);
        		}
            }
        };
        return returnTemplate;
    },

    // 바코드 팝업
    this.fnGetBarCode = function(){
        var returnTemplate = { template: '#barCodePopup'
            , created : function() {
            	util.logInfo('barCodePopup created=='  );
            	this.barCodeInput    = util.languageObjReturn(langCode , 'barCodeInput');
            	this.barCodeEntry    = util.languageObjReturn(langCode , 'barCodeEntry');
            	this.barcodeInputComplete    = util.languageObjReturn(langCode , 'barcodeInputComplete');
            	
            	if(gPayBarcodeType == "TOLLGATE_S"){
            		this.barCodeInput    = util.languageObjReturn(langCode , 'tollgateBarcodeMsg6');
                	this.barcodeInputComplete    = util.languageObjReturn(langCode , 'tollgateBarcodeMsg7');
            	} else if(gPayBarcodeType == "TOLLGATE") {
            		this.barCodeInput    = util.languageObjReturn(langCode , 'tollgateBarcodeMsg9');
                	this.barcodeInputComplete    = util.languageObjReturn(langCode , 'tollgateBarcodeMsg7');
            	} 
            }
        	, mounted : function() {
        		util.logInfo('fnGetBarCode mounted==' );

            	this.$root.$on('openbarCodePopup' , obj => {
            		util.logInfo("on -> openbarCodePopup " + JSON.stringify( obj ) );
            		this.styleObject = { display : 'block' };
            		this.barcodeType = obj.barcodeType;
            	});
            }
            ,beforeDestroy () {
            	util.logInfo('fnGetBarCode 바코드 팝업 beforeDestory');
					this.$root.$off('openbarCodePopup' );
			}
        	, data : function () {
        		return {
        			 codeNum : "" // "222222222222222222222"
        		   , styleObject : { display : 'none' }
        		   , barcodeType : ""
        		}
        	}
            , methods : {
            	fn_close : function() {
            		this.styleObject = {display : 'none'};

					let paramObj ={
							  appType : ""
							, barCode : ""
					};
					this.$root.$emit('barCodeInputResult', paramObj);
            	}
            	// 바코드 키패드
            	,fn_number_keypad : function (key) {
            		// console.clear();
            		this.codeNum = paymentChoiceService.number_keypad( key, this.codeNum);
				}
				, fn_barCode_select : function() {
					let appType ;
					try {
						if(this.barcodeType == ""){
							appType = util.GetSimplePayTrType(this.codeNum);
							let paramObj ={
									appType : appType
									, barCode : this.codeNum
							};
							this.$root.$emit('barCodeInputResult', paramObj);
							this.codeNum = "";
							this.styleObject = { display : 'none' };
						} else if(this.barcodeType == "tollgate") {
							appType = "tollgate"
							let paramObj ={
									appType : appType
									, barCode : this.codeNum
							};
							this.$root.$emit('barCodeInputResult', paramObj);
							this.codeNum = "";
							this.styleObject = { display : 'none' };
						} else if(this.barcodeType == "supercon") {
							appType = "supercon"
							let paramObj ={
									appType : appType
									, barCode : this.codeNum
							};
							this.$root.$emit('barCodeInputResult', paramObj);
							this.codeNum = "";
							this.styleObject = { display : 'none' };
						}
					} catch (e) {
						util.logError("fn_barCode_select. e => " + e);
						let ecd = e.errCode;
						let dataObj = {};
						if ( ecd.startsWith("0") ) {
							dataObj.button2Show = false;
							dataObj.button1Func = this.fnStartBarCodeReader
						}  else {
							dataObj.button2Show = false;
							dataObj.button1Func = this.fnStartBarCodeReader
						}
						dataObj.message = e.errMsg;
						eventBus.$emit('alertPopupIndex', dataObj);
					}
				}
            }
        };
        return returnTemplate;
    }
    
    // 카드 삽입 여부확인 call
    this.fnCardReaderStatus = function(paCardType){

    	try {
    		if ( util.isTizen() == false ) {
    			this.fnCardReaderStatusCallBack();
    		} else {
    			
    			if(paCardType == "C"){ // IC카드인 경우만 카드제거해주세요 처리.
    				util.logInfo("### fnCardReaderStatus cardRemove START!! ");
    				util.cardRemove();
    			}else{
    				util.logInfo("### fnCardReaderStatus NO cardRemove !! ");
    				this.fnCardReaderStatusCallBack();
    			}
    		}

		} catch (e) {
			// TODO: handle exception
			util.logError("util.cardRemove err >>  " + e.message);
		}
    }
    
    // 카드 삽입 여부확인 callBack
    this.fnCardReaderStatusCallBack = function(){
    	try {
    		util.logInfo("______________!!!!fnCardReaderStatusCallBack ______________");
    		orderPayRegService.orderPayReg();// 차후 CAT_ID 가 복수개일 경우 처리방식 수정.
    		this.soundPayed();  // 사운드 처리.
		} catch (e) {
			// TODO: handle exception
		}
    }
    
    this.fnPaymentExe = function(){
    	var returnTemplate = { template: '#paymentExe'
	        , created : function() {
	        	util.logInfo('*** paymentExe created ***');
	        }
	    	, mounted : function() {
	    		util.logInfo('*** fnPaymentExe mounted ***' );
	    		// eventBus.$on('paymentExe', this.fnMount);
	    		this.reqParam = this.$route.params.paramObj;
	    		this.fnMount();
	    		
	    		
	    		// 사인패드 서명 후 결제함수 호출시에 해당 함수 호출.
//	    		eventBus.$on('creditApproveRequestSign', this.creditApproveRequest);
	    		
	    		eventBus.$on('creditApproveRequestSign', obj => {
	    			util.logInfo("***** &on creditApproveRequestSign IN obj == >> " + obj);
	    			this.creditApproveRequest(obj);
            	}); 
	    		
	    		// 복수(코너)사업자인 경우에 해당 creditApproveRequest를 호출하여 코너별로 반복 결제 수행.
	    		eventBus.$on('creditApproveRequest' , obj => {
					this.reqParam = obj;
					this.jsonRequestData = this.reqParam.creditData;
					
					// 결제 화면 상단에 결제 금액을 바꿔준다.
					var approvePay = this.jsonRequestData["Pay"];
					util.logInfo("***** &on creditApproveRequest IN Pay == >> " + approvePay);
					approvePay = parseInt(approvePay.replace(/,/g, "")) + "";										
					this.setDisplayMessage(langCode, approvePay);
					
					this.creditApproveRequest(); // 결제수행
            	});
	    		util.logInfo('*** fnPaymentExe mounted2 ***' );
	    		
	        }
	        ,beforeDestroy () {
	        	util.logInfo('fnPaymentExe beforeDestroy');
	        	eventBus.$off('creditApproveRequest');
	        	eventBus.$off('alertPopupIndex');
	        	eventBus.$off('creditApproveRequestSign');
	        	clearTimeout(this.signatureTimeoutId);
			}
	    	, data : function () {
	    		return {
	    			canvas : "",
	    		    ctx : "",
	    		    isSignatureComplet : false, 	// 서명 여부
	    		    isApprove : false, 				// 서명 여부
	    		    signTimeout : 20,
	    		    signTimeout1 : 20,
	    		    signTimeout2 : 20,	    		    	
	    		    // 메모리 증가되는것 떄문에 임시로 사용.
	    		    // 메모리 문제 해결 후 삭제 해야 함.
	    		    reqAppControl : null,
	    			jsonRequestData : null,
	    			listenerId : "",
	    			paymentListener : "",
	    			reqParam : "",
	    			msg_payment_balance : util.languageObjReturn(langCode, 'msg_payment_balance'),
	    			msg_sign_1 : util.languageObjReturn(langCode, 'msg_sign_1'),
	    			msg_resign : util.languageObjReturn(langCode, 'msg_resign'),
	    			msg_sign_2 : util.languageObjReturn(langCode, 'msg_sign_2'),
	    			msg_btn_cancel : util.languageObjReturn(langCode, 'msg_btn_cancel'),
	    			msg_btn_confirm : util.languageObjReturn(langCode, 'msg_btn_confirm'),
	    			msg_btn_close : util.languageObjReturn(langCode, 'msg_btn_close'),
	    			msg_notice : util.languageObjReturn(langCode, 'msg_notice'),
	    		    swModelName : "##T4KIOSK001",		// ##T4KIOSK001
														// SamplePOS001
														// ##WIN4POS001 ..???
	    		    swModelVersion : "1001",	    		    
	    		    signatureTimeoutId : "",
	    		    vsBackYn : "N",
	    		    paymentRecallCnt : 0, // 리더기 시간 종료시에 재시도 하기 위한 카운트
	    		    bizClsType : BIZ_CLS_TYPE, // 복수사업자 여부 0: 단일, 1: 복수
	    		    resultParam : ""
	    		}
	    	}
	        , methods : {
	        	fnMount : function() {
	        		util.logInfo('*** fnPaymentExe fnMount START ***' );	        		
	        		// this.reqParam = data.params;
	        		
		        	this.canvas = document.getElementById('credit_signature');
		        	// this.canvas = $("#credit_signature");
		    		this.ctx = this.canvas.getContext('2d');
		    		this.ctx.fillStyle = '#ffffff';
		    		this.ctx.fillRect(0, 0, this.canvas.width, this.canvas.height);
		
		    		$('#divSignaturePad').signaturePad({
		    			drawOnly : true,
		    			defaultAction : 'drawIt',
		    			validateFields : false,
		    			penColour : '#000000',
		    			penWidth : 5,
		    			lineWidth : 0,
		    			output : null,
		    			sigNav : null,
		    			name : null,
		    			typed : null,
		    			typeIt : null,
		    			drawIt : null,
		    			typeItDesc : null,
		    			drawItDesc : null,
		    			onDraw : this.onDrawSignature,
		    			onDrawEnd : this.onDrawEndSignature
		    		});
		    		
		    		
	        		util.logInfo('*** fnPaymentExe fnMount2 ***' );
				    		
		    		$('#popBtnClose').off('click');
		    	
				 
		    		try {
		    			util.logInfo('*** fnPaymentExe fnMount4 ***' );
		    			var result = nativeApp.initialize();
		    			this.paymentListener = nativeApp.addPaymentListener(this.creditApproveCallbackListener);		    			
		    		} catch (error) {
		    		}
		    		
		    		this.isApprove = false;
		    		setTimeout(this.startRequest, 200);  // startRequest()
															// 0.2초 정도 Delay 추가
															// - 20200111, WDH
	        	},
	        	onDrawEndSignature : function(){
	        		util.logInfo('*** paymentExe onDrawEndSignature ***');	        		
	        		this.isSignatureComplet = true;
	        		
	        		if(this.signTimeout2 > 0) {
	        			this.signTimeout = this.signTimeout2;
	        			this.signatureTimeout();
	        		}		
	        	},
	        	onDrawSignature : function(){	        		
	        		util.logInfo('*** paymentExe onDrawSignature ***');
	        		this.signTimeout = -1;	
	        	},
	        	btnSignatureCloseClick : function(){
	        		util.logInfo('*** paymentExe btnSignatureCloseClick ***');
	        		util.logInfo("______________ (상품결제)서명팝업에서 취소 버튼 선택 _______________" );
	        		this.orderErrorResult("CANCEL", "사용자 취소 처리");
	    			$('#signaturePadPopup').hide(); // 서명 팝업
	        	},
	        	btnSignatureOkClick : function(){
	        		util.logInfo('*** paymentExe btnSignatureOkClick ***');
	        		this.saveSignature(); // 서명완료
	        	},
	        	btnClearSignatureClick : function(){
	        		util.logInfo('*** paymentExe btnClearSignatureClick ***');
	        		// 서명 초기화
	        		this.signTimeout = this.signTimeout1;
	    			this.clearCanvas(); 
	        	},
	        	closeClick : function(){
	        		util.logInfo('*** paymentExe closeClick ***');
	        		util.logInfo("______________ (상품결제)결제 취소 버튼 선택 _______________" );
	        		// 닫기버튼
	        		if (this.isApprove == true) {	    				
	    				this.showMessage(util.languageObjReturn(langCode, 'msg_01'), true, false);
	    				return;
	    			}
	        		this.vsBackYn = "Y";
	    			var result = nativeApp.functionCallSync(["FDK_CreditCancel"]);
	    			var resultData = this.nativeApiResultCheck(result);
//	    			if(resultData != null) {
	    				//this.orderErrorResult("CANCEL", "사용자 취소 처리");
//	    			}
	        	},
	        	popBtnCloseClick : function(){
	        		util.logInfo('*** paymentExe popBtnCloseClick ***');
	        		// 서명 초기화
	        		$('#messageAlertPopup').hide();
	        	},
	        	
	        	startRequest : function() {
	        		util.logInfo('*** paymentExe startRequest START ***');	        		
	        		try {
	        			this.paymentRecallCnt = 0; // 리더기 재호출 카운트 초기화.
	        			var requestData = null;
	        			// this.reqAppControl =
						// tizen.application.getCurrentApplication().getRequestedAppControl();
	        			util.logInfo('*** fnPaymentExe startRequest1 ***' );
    					this.jsonRequestData = this.reqParam.creditData;
    					util.logInfo('*** fnPaymentExe startRequest2 ***' );
			        	// 메모리 증가되는것 떄문에 임시로 사용.
			        	// 메모리 문제 해결 후 삭제 해야 함.
    					    					
    					// 기본 설정
    					this.signTimeout1 = Number(this.jsonRequestData["SignTimeout1"]);    					
    					this.signTimeout2 = Number(this.jsonRequestData["SignTimeout2"]);
    					    					
    					if(langCode == null || langCode == "") {
    						langCode = "ko";
    					}
    					var approvalType = this.jsonRequestData["Type"];
    					var approvePay = this.jsonRequestData["Pay"];
    					approvePay = parseInt(approvePay.replace(/,/g, "")) + "";
    					util.logInfo('*** fnPaymentExe startRequest3 ***' );
    					
    					this.setDisplayMessage(langCode, approvePay);
    					util.logInfo('*** fnPaymentExe startRequest4 ***' );
    					if(this.signTimeout1 > 0) {
    						this.signTimeout = this.signTimeout1;
    						this.signatureTimeout();
    					}
    					util.logInfo('*** fnPaymentExe startRequest5 ***' );
    					// 신용 승인 처리
    					if (approvePay > 50000 && approvalType != '2') {
    						util.logInfo('*** fnPaymentExe startRequest6 ***' );
    						this.clearCanvas(); // 서명 패드 초기화
    						this.deleteSignature(); // 기존 저장된 서명 이미지 삭제
    						util.logInfo('*** fnPaymentExe startRequest61 ***' );
    						$('#signaturePadPopup').show(); // 서명 팝업
    					} else {
    						// creditApproveRequest("");
    						util.logInfo('*** fnPaymentExe startReques7 ***' );
    					    setTimeout(this.creditApproveRequest, 100, "");
    					}
    				// }
	        	/* --- */	
	        			// }
	        		} catch (error) {
	        			this.orderErrorResult("CANCEL", "결제에 실패하였습니다. 다시 시도 해주세요"); 	        			
	        		}
	        		
	        		
	        	}	        	
	        	,setDisplayMessage : function (language, approvePay) {
	        		util.logInfo('*** paymentExe setDisplayMessage START ***');
	        		try {
	        	 		if(approvePay != "") {
	        	 			var dispApprovePay = approvePay.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ',');
	        	 			$('#creditPay').html("<span>￦</span>" + dispApprovePay);
	        	 		}
	        	 		
// const $lang = document.querySelectorAll("[data-lang]");
// $lang.forEach(el => {
// let code = el.dataset.lang;
// el.textContent = util.languageObjReturn(langCode, code);
// })
	        		} catch (e) {
	        			util.logError("[setDisplayMessage] Error : " + e.message);
	        			this.orderErrorResult("ERROR", "결제에 실패하였습니다. 다시 시도 해주세요");	        			
	        			//alert("Error: " + e.message);
	        		}
				}
				, signatureTimeout : function() {
					util.logInfo('*** paymentExe signatureTimeout START ***');
					if(this.signTimeout == -1) {
						$('#dispTimeout').html("&nbsp;");
						return;
					}
					
					$('#dispTimeout').html(this.signTimeout+"");
					if(this.signTimeout <= 0) {
						if(this.isSignatureComplet) {
							this.saveSignature();
						} else {							
							this.orderErrorResult("CANCEL", "사용자 취소 처리");
							$('#signaturePadPopup').hide(); // 서명 팝업
							return;
						}
					}
					this.signTimeout--;
					
				    this.signatureTimeoutId = setTimeout(this.signatureTimeout, 1000);
				}
				, creditApproveCallbackListener : function(data) {
					util.logInfo('*** paymentExe creditApproveCallbackListener START ***');
					try {
						var cbCode = "9";
						var cbData = "";
							
						try {
							var jsonData = JSON.parse(data);
	
							cbCode = jsonData["Code"];
							cbData = jsonData["Data"];
						} catch (e) {
						}
						util.logInfo('*** cbCode / Data === >> ' + cbCode + " / " + cbData);
						$('#divDebug').html("<p>" + cbCode + " : " + cbData + "</p>");
							
								
						if (cbCode == "0") { // 결재중입니다.
							$('#creditMsg1').html(util.languageObjReturn(langCode, 'msg_callback_1'));
							$('#creditMsg2').html(util.languageObjReturn(langCode, 'msg_callback_2'));
							 		 
							// 결제가 진행중입니다. 잠시만 기다려주세요. 음성추가.
	                    	var paramSrc = "./audio/22.mp3";
	         			    // string으로 보내면 해당 src한건 수행, 배열로 보내면 배열만큼 연속적으로 음성안내
							// 수행 (한글src만 보내면됨)
	         			    
	                    	util.fnAudioPlay(paramSrc); // 음성안내 공통함수 호출
						} else if (cbCode == "1") { // [카드인식요류] 카드를 다시 읽혀 주세요.
							util.logInfo("*** IC 카드를 확인 후, 다시 삽입해주세요. 마그네틱 카드 리더기에 신용카드를 다시 읽혀주세요. [code=1]***");
							$("#payImg2").attr("src", "./images/pay03.gif");
							$('#creditMsg1').html(util.languageObjReturn(langCode, 'msg_callback_9')); // IC 카드를 확인 후, 다시 삽입해주세요
							$('#creditMsg2').html(util.languageObjReturn(langCode, 'msg_callback_10')); // 마그네틱 카드 리더기에 신용카드를 다시 읽혀주세요.
						} else if (cbCode == "2") { // Chip카드입니다. IC카드를 삽입해주세요
							util.logInfo("*** POS 보안 정책으로 일반 MS거래가 불가능합니다. IC 카드를 먼저 읽혀 주세요 [code=2]***");
							$('#creditMsg1').html(util.languageObjReturn(langCode, 'msg_callback_7')); // POS 보안 정책으로 일반 MS거래가 불가능합니다.
							$('#creditMsg2').html(util.languageObjReturn(langCode, 'msg_callback_8')); // IC 카드를 먼저 읽혀 주세요!!
						} else if (cbCode == "3") { // 서명이 너무 짧습니다. 다시 서명해 주세요.
							util.logInfo("*** 서명쪽 에러인듯한테 오더앱에서 처리되는건 없음. [code=3]***");
							// showMessage(cbData, false, false);
						} else if (cbCode == "4") { // exception
							util.logInfo("*** 처리에 실패 하였습니다. 관리자에게 문의 하여 주세요. [code=4]***");
							$('#creditMsg1').html(util.languageObjReturn(langCode, 'msg_callback_5')); // 처리에 실패 하였습니다.
							$('#creditMsg2').html(util.languageObjReturn(langCode, 'msg_callback_6')); // 관리자에게 문의 하여 주세요.
						} else if (cbCode == "5") { // 카드를 삽입해주세요.
							util.logInfo("*** 카드를 삽입해주세요. 결제가 끝날때까지 카드를 뽑지 마세요. [code=5]***");
							$("#payImg2").attr("src", "./images/pay02.gif"); // 삼성페이 사용하는 gif 이미지.
							
							$('#creditMsg1').html(util.languageObjReturn(langCode, 'msg_callback_4')); // 카드를 삽입해주세요.
							$('#creditMsg2').html(util.languageObjReturn(langCode, 'msg_callback_2')); // 결제가 끝날때까지 카드를 뽑지 마세요.
							
							// 카드를 삽입해주세요. 음성추가.
	                    	var paramSrc = "./audio/1.mp3";
	         			    // string으로 보내면 해당 src한건 수행, 배열로 보내면 배열만큼 연속적으로 음성안내
							// 수행 (한글src만 보내면됨)
	                    	util.fnAudioPlay(paramSrc); // 음성안내 공통함수 호출
							
						} else if (cbCode == "9") { // 처리 완료
							util.logInfo("*** 결제 진행중입니다. 결제가 끝날때까지 카드를 뽑지 마세요. [code=9]***");
							this.isApprove = true;
							$('#creditMsg1').html(util.languageObjReturn(langCode, 'msg_callback_3'));
							$('#creditMsg2').html(util.languageObjReturn(langCode, 'msg_callback_2'));
							
						} else {
							// $('#messageAlertPopup').hide();
							
						}
					} catch (e) {
						util.logError("[creditApproveCallbackListener] Exception : " + e.message);
						this.orderErrorResult("ERROR", "결제에 실패하였습니다. 다시 시도 해주세요"); 	
						//this.showMessage("[creditApproveCallbackListener] Exception: " + e.message, false, false);
					}
				}
				, clearCanvas : function() {
					util.logInfo('*** paymentExe clearCanvas START ***');
					this.isSignatureComplet = false;
	
					this.ctx.clearRect(0, 0, this.canvas.width, this.canvas.height); // 픽셀정리
					this.ctx.beginPath(); // 컨텍스트 리셋
	
					this.ctx.fillStyle = '#ffffff';
					this.ctx.fillRect(0, 0, this.canvas.width, this.canvas.height);
				}
				, creditApproveCallbackResult : function(callbackName, result) {
					util.logInfo('__________ 결제 함수 호출 후 콜백 시작 creditApproveCallbackResult __________');
					waitingService.ResetLogOutTimer(); // 대기화면으로 돌아가는 타이머 초기화. ( 결제 도중에 대기화면으로 돌아가지 않기 위해)
					try 
					{
						nativeApp.removeASyncApiListener(callbackName, this.listenerId);
						nativeApp.functionCallSync(["FDK_CreditCancel"]); // native 수행중인것 모두 취소. (초기화)
						var apiResult = this.getNativeApiResult(result);
						util.logInfo("__________ 결제 콜백 apiResult[0] == >>  " + apiResult[0]);
						if(apiResult != null && apiResult[0] == 0) {
							util.logInfo("__________ 결제 콜백 정상코드로 if문 진입 __________");
							
							
							if(this.bizClsType == "1"){ // 복수사업자(코너)
								util.logInfo("__________ 결제 콜백 정상코드 > 코너(복수)사업자 if문 시작 __________");
								var vsResultJson = JSON.stringify(apiResult);
								util.logInfo("vsResultJson == > " + vsResultJson);
								util.logInfo("Result[0] == > " + apiResult[0]);
								util.logInfo("Result[1] == > " + apiResult[1]);
								var vsData = apiResult[1];
								util.logInfo("vsData == > " + vsData);
								if(vsData["Status"] == "APPROVE"){
									util.logInfo("__________ 결제 콜백 정상코드 > 코너(복수)사업자 APPROVE일 때 if문 시작__________");
									this.orderResultData(apiResult[1]);
								}else{
									util.logInfo("__________ 결제 콜백 정상코드 > 코너(복수)사업자 APPROVE 아닐 때 다시 결제하시겠습니까 창 띄우기 시작__________");
									this.resultParam = apiResult[2];
									var dataObj = {
		    								  button1Show : true
		    								, button1Name : util.languageObjReturn(langCode, 'no') // [ 아니오 ]
		    								, button1Func : this.cornerError
		    								, button2Show : true
		    								, button2Name : util.languageObjReturn(langCode, 'yes') // [ 예 ]
		    								, button2Func : this.retryCornerPay
		    								, message     : util.languageObjReturn(langCode,  'paymentRetry') // [ 결제 중 문제가 발생하였습니다. 다시 시도하시겠습니까? ]
		    							};																	
									eventBus.$emit('alertPopupIndex', dataObj);
								}
								
							}else{ // 단일사업자
								util.logInfo("__________ 결제 콜백 정상코드 > 단일사업자 if문 __________ ");
								this.orderResultData(apiResult[1]);
							}
							
							
							
						} else {
							util.logError("__________ 결제 콜백 비정상코드로 else진입 __________ ");
							if(this.vsBackYn == "Y"){ // 뒤로가기 눌렀을 때.
								util.logInfo("__________결제 콜백 비정상코드 > 사용자 취소 __________");
								this.orderErrorResult("CANCEL", "사용자 취소 처리");
							}else{
								if(apiResult[0] == "-7102"){ // 리더기 대기시간 초과 에러
									util.logInfo("__________결제 콜백 비정상코드 > 7102 __________");
									if(this.paymentRecallCnt < 3){
										util.logInfo("__________결제 콜백 비정상코드 > 리더기 시간 초과로 인한 재호출 실행 ***** " + (Number(this.paymentRecallCnt) + 1) + "번째");
										util.logInfo("__________isSignatureComplet == > " + this.isSignatureComplet)
										// 리더기 시간이 초과되면 api를 재호출한다.
										if(this.isSignatureComplet){ // 서명이 되어있다면, 서명파일 경로를 파라미터로 보낸다.
											this.creditApproveRequest(signatureRealPath + "/" + signatureName);
										}else{
											this.creditApproveRequest();
										}
										this.paymentRecallCnt++;  // 리더기 재시도 카운트를 올린다.
									}else{
										this.orderErrorResult("ERROR", apiResult[2]);
										return;
									}
								}else if(apiResult[0] == "-7109"){ // HD리더기 수신실패
									util.logError("__________결제 콜백 비정상코드 > HD리더기 수신실패 (-7109) __________");
									this.orderErrorResult("ERROR", util.languageObjReturn(langCode, 'hdReaderFail')); // 카드가 정상적으로 인식되지 않았습니다. 카드 확인 후 다시 시도해 주세요.
									return;
								}else if(apiResult[0] == "-7326"){ // 접촉식 리더기 EMV커널 미지원
									util.logError("__________결제 콜백 비정상코드 >접촉식 리더기 EMV커널 미지원 (-7326) __________");
									this.orderErrorResult("ERROR", util.languageObjReturn(langCode, 'emvReaderError')); // 미지원 카드입니다. 다른 카드를 이용해 주세요.
									return;
								}else{
									util.logError("__________결제 콜백 비정상코드 > 에러발생. else부분 기타에러  __________ " + apiResult[0]);
									this.orderErrorResult("ERROR", apiResult[2]);
									return;
								}
							}
						}		
						
					} catch (e) {
						util.logError("__________ 결제 함수 호출 후 콜백에서 Error : " + e.message);
						this.orderErrorResult("ERROR", "결제에 실패하였습니다. 다시 시도 해주세요");
						//this.showMessage("[creditApproveRequest] Error : " + e.message, true, false);
					}
				}
				, 
				// 타임아웃으로 호출하지 않으면 메시지 팝업이 정상적으로 동작하지 않는다. 2번 연속으로 팝업이 뜨면서 문제가 발생함.
				// 아래 cornerErrorExt함수를 따로 또 만든것은 setTimeout안에 함수에다가 파라미터를 넣으면 딜레이가 적용되지 않아서, timeout을 사용하기 위해서 분리.
				cornerError : function(){ 
					setTimeout(this.cornerErrorExt, 1000);
				}
				, cornerErrorExt : function(){
					this.orderErrorResult("ERROR", this.resultParam);
				}
				, retryCornerPay : function(){
					util.logInfo("__________ 코너사업자 결제 중 다시 시도 팝업 예 클릭 retryCornerPay __________");
					if(this.isSignatureComplet){ // 서명이 되어있다면, 서명파일 경로를 파라미터로 보낸다.
						this.creditApproveRequest(signatureRealPath + "/" + signatureName);
					}else{
						this.creditApproveRequest();
					}
				}
				, getNativeApiResult : function(result)
				{
					util.logInfo('*** paymentExe getNativeApiResult START ***');
					var apiResult = new Array(3);
					
					try {
						result = result.substring(0, result.lastIndexOf("$$^")); 	// Eof
																					// 이후
																					// 문자는
																					// 버린다
																					// ($$^)
						var jsonResult = JSON.parse(result);
						
						apiResult[0] = parseInt(jsonResult["ResultCode"]);
						apiResult[1] = jsonResult["Data"];
						apiResult[2] = jsonResult["Message"];
					} catch (e) {
						apiResult = null;
					}
					
					return apiResult;
				}

				, creditApproveRequest : function(signatureImage) {
					util.logInfo('__________ 결제 호출 함수 시작 paymentExe creditApproveRequest START !!!__________');
					util.logInfo("__________ signatureImage == > " + signatureImage);
					util.logInfo('jsonRequestData'+ JSON.stringify(this.jsonRequestData));
					if(this.bizClsType=='1'){
						if(this.jsonRequestData["cornerCntCur"] !== undefined ) {
							var vsCurCnt = Number(this.jsonRequestData["cornerCntCur"]) + 1; // 현재 진행 건에 대한 순번.
							$('#creditMsgCorner').html(this.jsonRequestData["cornerNm"] + " [" + vsCurCnt + "/" + this.jsonRequestData["cornerCnt"] + "]");
						}
					}
					
					var result;
					try {
						// 거래금액, 부가세, 할부 개월, 원거래 승인번호, 원거래 일자, 카드번호
						// {"Pay":"1,025", "Tax":"", "InstallmentMonths":"00",
						// "ApproveNo":"",
						// "ApproveDate":"", "CardNo":"" }
						
						util.logInfo("__________결제 함수 호출을 위해 넘어온 파라미터 데이터 ==> " + JSON.stringify(this.jsonRequestData));
						
						var approvePay = this.jsonRequestData["Pay"]; // 거래금액
						approvePay = approvePay.replace(/,/g, "");
						var tax = this.jsonRequestData["Tax"]; // 부가세
						tax = tax.replace(/,/g, "");

						var installmentMonths = this.jsonRequestData["InstallmentMonths"]; // 할부
																							// 개월
						var approveNo = this.jsonRequestData["ApproveNo"]; // 원거래
																			// 승인번호
						var approveDate = this.jsonRequestData["ApproveDate"]; // 원거래
																				// 일자

						var cardNo = this.jsonRequestData["CardNo"]; // 카드번호
						var approvalType = this.jsonRequestData["Type"];						
						var catId = this.jsonRequestData["CatId"];

						if (installmentMonths == null || !installmentMonths) {
							installmentMonths = "00";
						}

						var tranType = "-1";

						var mechantTempInfo = this.jsonRequestData["MechantTempInfo"]; 		// 가맹점임의정보
						var taxSaleAmt = this.jsonRequestData["TaxSaleAmt"]; 				// 과세
																							// 대상금액
						var nonTaxSaleAmt = this.jsonRequestData["NonTaxSaleAmt"]; 			// 비과세
																							// 대상금액
						var userServiceCode = this.jsonRequestData["UserServiceCode"]; 		// 사용자코드
						var userServiceData = this.jsonRequestData["UserServiceData"]; 		// 사용자데이터						
						var serviceAmt = this.jsonRequestData["serviceAmt"]; 		// 봉사료
						var cupDeposit = this.jsonRequestData["totalCupAmt"]; 		// 컵보증금 합계
						
						if(!serviceAmt){
							serviceAmt = "";
						}
						if(!cupDeposit){
							cupDeposit = "";
						}
						if(!signatureImage){
							signatureImage = "";
						}
						waitingService.ResetLogOutTimer(); // 대기화면으로 돌아가는 타이머 초기화. ( 결제 도중에 대기화면으로 돌아가지 않기 위해)			
						util.logInfo("approveNo ==> " + approveNo);
						util.logInfo("approveDate ==> " + approveDate);
						/**
						 * 승잌 / 취소 요청
						 */
						if(cardNo == "") {
							util.logInfo('__________ 신용카드 결제 호출 (cardNo 없음) __________');
                            util.logInfo('__________ 결제 함수 호출 직전 파라미터  == > catId='+catId+", approvePay="+ approvePay+", tax="+tax+", swModelName="+this.swModelName+", swModelVersion="+this.swModelVersion+", installmentMonths="+installmentMonths+", signatureImage="+signatureImage+", taxSaleAmt="+taxSaleAmt+", nonTaxSaleAmt="+nonTaxSaleAmt+", userServiceCode="+userServiceCode+", userServiceData="+userServiceData+", serviceAmt="+serviceAmt+", cupDeposit="+cupDeposit);
							if (approveNo == "" && approveDate == "") { // 승인
								util.logInfo("_____ 결제 승인 if문 수행  ______");
								// 코너 : 11313486 , 1회용컵 : 10069371
								tranType = "0";
								this.listenerId = nativeApp.functionCallASync([ "FDK_CreditPurchase",
																		    catId, 
																			approvePay, 
																			tax, 
																			this.swModelName,
																			this.swModelVersion,
																			installmentMonths, 
																			signatureImage, 
																			mechantTempInfo, 
																			taxSaleAmt, 
																			nonTaxSaleAmt, 
																			userServiceCode, 
																			userServiceData,
																			serviceAmt,
																			cupDeposit], this.creditApproveCallbackResult);
							} else { // 승인 취소
								util.logInfo("_____ 결제 취소 if문 수행  ______");
								/*
								 * tranType = "1"; this.listenerId =
								 * nativeApp.functionCallASync([
								 * "FDK_CreditRefund", catId, approvePay, tax,
								 * swModelName, swModelVersion,
								 * installmentMonths, signatureImage, approveNo,
								 * approveDate, mechantTempInfo, taxSaleAmt,
								 * nonTaxSaleAmt, userServiceCode,
								 * userServiceData ],
								 * creditApproveCallbackResult);
								 */
							}
						} else {
							util.logInfo('__________ 제로,바코드 등 결제 호출 (cardNo 있음) __________');
							util.logInfo('__________ 결제 함수 호출 직전 파라미터  == > catId='+catId+", approvePay="+ approvePay+", tax="+tax+", swModelName="+this.swModelName+", swModelVersion="+this.swModelVersion+", installmentMonths="+installmentMonths+", signatureImage="+signatureImage+", taxSaleAmt="+taxSaleAmt+", nonTaxSaleAmt="+nonTaxSaleAmt+", userServiceCode="+userServiceCode+", userServiceData="+userServiceData+", serviceAmt="+serviceAmt+", cupDeposit="+cupDeposit);
							util.logInfo('*** paymentExe creditApproveRequest else ***');
							if (approveNo == "" && approveDate == "") { // 승인
								tranType = "0";
								if(parseInt(approvalType) == 8){ // payco
									util.logInfo('*** payco FDK_Pay_Common_Request ***');
									this.listenerId = nativeApp.functionCallASync(["FDK_Pay_Common_Request",
																				catId,
																				approvePay,
																				tax,
																				this.swModelName,
																				this.swModelVersion,
																				installmentMonths, 
																			  	signatureImage, 
																				cardNo,
																				1,
																				mechantTempInfo, 
																			  	taxSaleAmt, 
																			  	nonTaxSaleAmt, 
																			  	userServiceCode, 
																			  	userServiceData,
																			  	serviceAmt,
																			  	cupDeposit,
																				"NC", // 서비스구분 PAYCO 서비스
																				"D1", // 전문구분 D1 - 승인
																				"PC" //복합거래 구분코드 - PC로 통합
																				], this.creditApproveCallbackResult);
								}else{
									this.listenerId = nativeApp.functionCallASync(["FDK_BarcodePurchase", 
																			  catId, 
																			  approvePay,
																			  tax, 
																			  this.swModelName, 
																			  this.swModelVersion,
																			  installmentMonths, 
																			  signatureImage, 
																			  cardNo,
																			  parseInt(approvalType),
																			  mechantTempInfo, 
																			  taxSaleAmt, 
																			  nonTaxSaleAmt, 
																			  userServiceCode, 
																			  userServiceData,
																			  serviceAmt,
																			  cupDeposit ], this.creditApproveCallbackResult);

								}
							} else { // 승인 취소
								/*
								 * tranType = "1"; this.listenerId =
								 * nativeApp.functionCallASync(["FDK_BarcodeRefund",
								 * catId, approvePay, tax, swModelName,
								 * swModelVersion, installmentMonths,
								 * signatureImage, approveNo, approveDate,
								 * cardNo, parseInt(approvalType),
								 * mechantTempInfo, taxSaleAmt, nonTaxSaleAmt,
								 * userServiceCode, userServiceData ],
								 * creditApproveCallbackResult);
								 */
							}
						}
					} catch (e) {
						util.logError("__________ 신용카드 결제 호출 도중에 Error 발생 : " + e.message);
						this.orderErrorResult("ERROR", "결제에 실패하였습니다. 다시 시도 해주세요");
						//this.showMessage("[creditApproveRequest] Error : " + e.message, true, false);
					}

					return;
				}
				, deleteSignature : function() {
					util.logInfo('*** paymentExe deleteSignature START ***');
					util.logInfo('signatureName :' + signatureName);
					try {
						var onResolveSuccess = function(dir) {
							var onListFilesSuccess = function(files) {
								files.forEach(function(file) {
									util.logInfo('file.name :' + file.name);
									if (!file.isDirectory && file.name == signatureName) {
										dir.deleteFile(file.fullPath, onDeleteSuccess, onError);
									}
								});
							};
							dir.listFiles(onListFilesSuccess, onError);
						};

						var onDeleteSuccess = function() {
							// alert("이전 서명 삭제 ===>>> OK...!");
							util.logInfo('[deleteSignature] onDeleteSuccess');
						};

						var onError = function() {
							// alert("이전 서명 삭제 ===>>> Error...!");
							util.logInfo('[deleteSignature] onError');
						};

						tizen.filesystem.resolve(signaturePath, onResolveSuccess, onError);
					} catch (e) {
						util.logInfo('[deleteSignature] Error :: ' + e.message);
						// alert("[deleteSignature] Error : " + e.message);
					}
				}
				, saveSignature : function() {
					util.logInfo('*** paymentExe saveSignature START ***');
					try {
						if (!this.isSignatureComplet) {
							this.showMessage(util.languageObjReturn(langCode, 'msg_02'), true, false);
							return;
						}
						$('#signaturePadPopup').hide(); // 서명 팝업
						this.paymentRecallCnt = 0; // 리더기 재호출 카운트 초기화.
						// 입력 받은 서명을 24비트 Bitmap 이미지로 변환
						var image = CanvasToBMP24.toDataURL(this.canvas, 128, 64);
						util.logInfo('*** paymentExe saveSignature 111 ***');
						tizen.filesystem.resolve(signaturePath, function(dir) {
							util.logInfo('*** paymentExe saveSignature 222 ***');
							var newFile = dir.createFile(signatureName);
							newFile.openStream("w", function(fs) {
								var base64Image = image.split(",")[1];
								fs.writeBase64(base64Image);
								fs.close();
								setTimeout(eventBus.$emit('creditApproveRequestSign', signatureRealPath + "/" + signatureName), 100);
								//this.creditApproveRequest(signatureRealPath + "/" + signatureName);
							}, function(e) {
								util.logError("[saveSignature - newFile.openStream] Error : " + e.message);
								this.orderErrorResult("ERROR", "결제에 실패하였습니다. 다시 시도 해주세요");
								//this.showMessage("The error " + e.message, true, false);
							});
						});
					} catch (e) {
						util.logError("[saveSignature] Error : " + e.message);
						this.orderErrorResult("ERROR", "결제에 실패하였습니다. 다시 시도 해주세요");
						//this.showMessage("[saveSignature] Error : " + e.message, true, false);
					}
					return;
				}
				, orderResultData : function(resultData) {
					util.logInfo("__________ 결제 콜백 함수에서 orderResultData 함수 호출. resultData를 파라미터로 받음. __________ ");
					util.logInfo('*** paymentExe orderResultData START ***');
					try {
						clearTimeout(this.signatureTimeoutId);
						var credittData = JSON.stringify(resultData);
						// var data = new tizen.ApplicationControlData("text", [
						// credittData ]);
						util.logInfo("__________orderResultData. resultData를 가공하여  approveOnsuccessCallback(결제 후 후처리 하기 전 함수) 함수 호출 시작. __________ ");
						paymentChoiceView.approveOnsuccessCallback(credittData, this.reqParam.creditData , this.reqParam.appType , this.reqParam.reCallFn);
						// this.reqAppControl.replyResult([ data ]);
					} catch (e) {
						util.logError("[orderResultData] Error : " + e.message);
						this.orderErrorResult("ERROR", util.languageObjReturn(langCode , 'paymentExeError1'));
						//alert("orderResultData failed. \n reason: " + e.message);
					}
					/*
					 * $('#creditPay').html("&nbsp;");
					 * $('#creditMsg1').html("&nbsp;");
					 * $('#creditMsg2').html(util.languageObjReturn(langCode,
					 * 'msg_callback_2'));
					 */
					
				}
				, orderErrorResult : function(status, message) {
					util.logInfo('*** paymentExe orderErrorResult START ***');
					util.logInfo('*** paymentExe orderErrorResult status == >  ' + status);
					util.logInfo('*** paymentExe orderErrorResult message == >  ' + message);
					try {
						
						clearTimeout(this.signatureTimeoutId);
						var credittData = '{ "Status" : "'+status+'", "응답메세지2" : "'+message+'" }'; 
						// var data = new tizen.ApplicationControlData("text", [
						// credittData ]);
						paymentChoiceView.approveOnsuccessCallback(credittData, this.reqParam.creditData , this.reqParam.appType , this.reqParam.reCallFn);
						// this.reqAppControl.replyResult([ data ]);
					} catch (e) {
						util.logError("[orderErrorResult] Error : " + e.message);	        			
					}
					/*
					 * $('#creditPay').html("&nbsp;");
					 * $('#creditMsg1').html("&nbsp;");
					 * $('#creditMsg2').html(util.languageObjReturn(langCode,
					 * 'msg_callback_2'));
					 */
				}
				, showMessage : function(message, isOK, isCancel) {
					util.logInfo('*** paymentExe showMessage START ***');
				    $('#messageAlertPopup').show();
					$('#popAlertMessage').html("<p>&nbsp;</p><p>"+message+"</p>");

					$('#popBtnOk').hide();
					$('#popBtnCancel').hide();
					$('#popBtnOk').html("확인");
					$('#popBtnCancel').html("취소");

					if(isOK == false && isCancel == false) {
						$('#popHeader').hide();
						$('#popButtonGroup').hide();
						return;
					} else {
						$('#popHeader').show();
						$('#popButtonGroup').show();
					}
					
					if(isOK == true) {
						$('#popBtnOk').show();
						
						$('#popBtnOk').off('click');
					    $('#popBtnOk').click(function(){
					    	$('#messageAlertPopup').hide();
					    });
					}
					
					if(isCancel == true) {
						$('#popBtnCancel').show();
						
						$('#popBtnCancel').off('click');
					    $('#popBtnCancel').click(function(){
					    	$('#messageAlertPopup').hide();
					    });
					}
				}
				/**
				 * Native API 결과 처리
				 */
				, nativeApiResultCheck : function(result)
				{
					util.logInfo('*** paymentExe nativeApiResultCheck START ***');
					var resultCode;
					var resultData;
					var resultMessage;
					
					try {
						if(result.lastIndexOf("$$^") != -1) {
							result = result.substring(0, result.lastIndexOf("$$^")); 	// Eof 이후 문자는 버린다 ($$^)
						}
						
						$('#divDebug').html("");
						var jsonResult = JSON.parse(result);
						
						resultCode = parseInt(jsonResult["ResultCode"]);	// jsonResult["ResultCode"];
						resultData = jsonResult["Data"];
						resultMessage = jsonResult["Message"];
						
						if(resultCode != 0) {
							if(resultCode == -7100) {
								this.orderErrorResult("ERROR", "리더기 오류. 리더기를 확인 후 다시 읽혀 주세요.");
//								this.showMessage("리더기 오류.<br>리더기를 확인 후 다시 읽혀 주세요.", true, false);
							} else if(resultCode == -7201) {
								this.orderErrorResult("ERROR", "IC 카드 거래 불가. 카드를 확인 후 다시 읽혀 주세요.");
//								this.showMessage("IC 카드 거래 불가.<br>카드를 확인 후 다시 읽혀 주세요.", true, false);
							} else if(resultCode == -7104) {
								this.orderErrorResult("ERROR", resultMessage);
//								this.showMessage(">>> " + resultMessage, true, false);
							} else {
								this.orderErrorResult("ERROR", "[" + resultCode + "] " + resultMessage);
//								this.showMessage("[" + resultCode + "] " + resultMessage, true, false);
							}
							
							return null;
						}
					} catch (e) {
							// 인증을 위해 임시로 막음.
							 this.showMessage("[nativeApiResultCheck] Exception: <br>" + e.message + "<br>[[[<br>" + result + "<br>]]]", true, false);
								
						resultData = null;
					}
					
					return resultData;
				}
				
				
	        }
	    };
    	return returnTemplate;
    },
    
    
    // 이통사 제휴할인 화면
    this.fnGetAllianceDiscount = function(){    	    	
        var returnTemplate = { template: '#allianceDiscount'
        	, created : function() {
        		util.logInfo("_____allianceDiscount created Start_____");
        		// BJK GetEnvXmlPosENV의 값이 없는 경우 디폴트로 선언한 0이 분기 되도록 try catch 적용.
            	try {
	            	this.txtAllianceCompany  = util.languageObjReturn(langCode , 'allianceCompany'); // 제휴사 
	            	this.txtBarcodeNo = util.languageObjReturn(langCode , 'barcodeNo'); // 바코드번호
		        	this.txtPaymentAmount       = util.languageObjReturn(langCode , 'paymentAmount'); // 결제 금액
		        	this.txtRemainingMile  = util.languageObjReturn(langCode , 'remainingMile'); // 잔여 포인트
		        	this.txtUseMile   = util.languageObjReturn(langCode , 'useMile'); // 사용 포인트
		        	this.txtActiveButton        = util.languageObjReturn(langCode , 'activeButton'); // 조회하기
		        	this.txtToUse      = util.languageObjReturn(langCode , 'toUse'); // 사용하기
		        	this.directInput = util.languageObjReturn(langCode , 'directInput'); // 직접입력
            	} catch (error) {
            		util.logError("_____allianceDiscount created catch_____");
        		}
            }
	    	, data : function() {
	    		return {
	    			  alliCompanyList        : [] /** 제휴사 목록 **/	    		    
	    		    , totSaleAmt             : "0" /** 결제 금액 **/
	    		    , remainMile             : "0" /** 잔여 포인트 **/
	    		    , useMile                : "0" /** 사용 포인트 **/
	    		    , barcodeNo              : ""
	    		    , selJcdCd               : ""
	    		    , retryCount             : 0
	    		    , readBarcodeNo          : ""
	    		    , txtAllianceCompany     : ""
	    		    , txtBarcodeNo           : ""
	    		    , txtPaymentAmount       : ""
	    		    , txtRemainingMile       : ""
	    		    , txtUseMile             : ""
	    		    , txtActiveButton        : ""
	    		    , txtToUse               : ""
	    		    , listenerIdC            : ""
	    		    , listenerIdB            : ""
	    		    , listenerIdA            : ""
	    		    , POS_ODJCD_T            : {}
	    		    , procId                 : ""
	    		    , jcdTypeFgNm            : "" /** 제휴할인-유형구분 ( CCD_CODEM_T : 035 ) 1:OCBS 2:SKT 3:KTF 4:LGT 5:신용제휴 9:기타제휴 **/
	    		    , dcLimitAmt             : "" /** 할인한도금액 **/
	    		    , dcLimitFg              : "" /** 할인한도구분 (0:한도없음, 1:한도설정) **/
	    		    , dcProdFg               : "" /** 할인상품구분 ( 0:전체상품(제외대상상품) , 1:특정상품(할인대상상품) ) **/
	    		    , JCD_TYPE_FG            : ""
	    		    , APPR_AMT               : 0
	    		    , ORIGIN_APPR_AMT        : 0
	    		    , POINT_SALE_LIST        : []
	    		    , POINT_SALE_LIST_SIDE   : []
	    		    , readMsg                : ""
	    		    , directYn               : "N"
	    		    , directInput            : ""
	    		    , useMileYn              : "N"
	    		    , taxEnvVal              : "" /** 부가세 포함여부 **/
	    		}
	    	}
	        , mounted : function() {
	        	util.logInfo("_____allianceDiscount mount Start_____");
	        	var vmMileMiner = 0;
	        	// 마일리지를 먼저 사용한 경우에 마일리지 금액을 차감하고 제휴할인을 계산하기 위해서 계산한다.
	        	if(orderInfo.POS_ODHDR_T.CST_USE_POINT !== undefined ) {            		
            		// this.getVatSaleAmtView = this.$route.params.price;
            		if(SHOP_INFO.POINT_FG=="M"){
            			//마일리지 매장일경우 사용포인트가 할인 금액과 동일            			
            			vmMileMiner = Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT) - Number(orderInfo.POS_ODHDR_T.CST_USE_POINT);
            		} else {
            			//스탬프 매장일경우 사용스탬프에 따라서 실제 할인 금액이 달라진다.            			
            			//vmMileMiner = Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT) - Number(orderInfo.POS_ODHDR_T.CST_POINT_AMT);
            		}
            	}
	        	// 도도포인트를 먼저 사용한 경우에 마일리지 금액을 차감하고 제휴할인을 계산하기 위해서 계산한다.            	
            	if(orderInfo.DODO_POINT_INFO !== undefined ) {
            		if(SHOP_INFO.POINT_FG=="M"){
            			//마일리지 매장일경우 사용포인트가 할인 금액과 동일
            			vmMileMiner = Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT) - Number(orderInfo.DODO_POINT_INFO.USE_POINT);
            		} 
            	}
            	
            	if(vmMileMiner != "0"){
            		this.totSaleAmt = util.numberWithCommas(vmMileMiner); // 총금액(할인대상금액)
            	}else{
            		this.totSaleAmt = util.numberWithCommas(orderInfo.POS_ODHDR_T.TOT_SALE_AMT); // 총금액(할인대상금액)
            	}
	        	// 리더기 진행사항 콜백 리스터 추가. bjk
            	nativeApp.addPaymentListener(this.creditApproveCallbackListener);
            	try{
            		this.readMsg = util.languageObjReturn(langCode, "pointRead");
            		this.taxEnvVal = util.GetEnvXmlShopENV(128); // ( 부가세 여부 - 1:부가세포함, 0:부가세별도 )
            	}catch(e){
            		util.logError("_____allianceDiscount mount Catch e == > " + e.toString());
            	}
            	this.accCreditType = this.$route.params.accCreditType;
            	this.accEasyType = this.$route.params.accEasyType;
            	this.selectAlliCompany(); // 제휴사 목록 조회. 
            	this.readAllStart(); // 리더기, 카메라 구동
	        }
	        ,beforeDestroy () {
	        	util.logInfo("_____allianceDiscount beforeDestroy_____");
	        	this.fnStopBarCodeReader();
	        	nativeApp.functionCallSync(["FDK_CreditCancel"]); // 카드 리더기 대기 취소
	    	}
	        , methods : {
	        	selectAlliCompany:function(){
	        		var vsInsDt = moment().format("YYYYMMDD");
	        		// 제휴사 조회
	        		var resultData = gfn_SQLiteSQLProcess(sqlQuery.sqlSelectAlliCompany , [gShopCd, vsInsDt]);
            		let rows;
            		if ( resultData!= null && resultData.ResultCode == "0" ) {
        				rows = resultData.Data;
        				if ( rows == undefined || rows == null ||  rows.length == 0 ) {
        					util.logError("*****Alliance CompanyList Result No!!!!!!*****");
        				}
             	   	}
            		this.alliCompanyList = rows; // 제휴사 정보를 변수에 담는다.
            		this.selJcdCd = rows[0].JCD_CD;
	        	}

	        	, fn_keypad : function(key){ // 키패드 입력
	        		util.logInfo("***** 제휴할인 직접입력 키패드 클릭 함수 *****");
	        		if(key == "RESET" || key == "DEL"){
	        			util.logInfo("***** 제휴할인 직접입력 키패드 key == >> " + key);
	        		}else{
	        			util.logInfo("***** 제휴할인 직접입력 키패드 key == >> 숫자입력함.");
	        		}
	        		
	        		var vsNoTemp = this.barcodeNo.replace(/-/gi, "");
	        		vsNoTemp = paymentChoiceService.number_keypad( key, vsNoTemp);
	        		var vsLen = vsNoTemp.length;
	        		if(vsLen < 4){
	        			this.barcodeNo = vsNoTemp;
	        		}else if (vsLen < 8){
	        			var vsNo1 = vsNoTemp.substr(0,4);
	        			var vsNo2 = vsNoTemp.substr(4,4);
	        			this.barcodeNo = vsNo1 +"-" + vsNo2;
	        		}else if (vsLen < 12){
	        			var vsNo1 = vsNoTemp.substr(0,4);
	        			var vsNo2 = vsNoTemp.substr(4,4);
	        			var vsNo3 = vsNoTemp.substr(8,4);
	        			this.barcodeNo = vsNo1 +"-" + vsNo2 +"-" + vsNo3;
	        		}else if (vsLen <= 16){
	        			var vsNo1 = vsNoTemp.substr(0,4);
	        			var vsNo2 = vsNoTemp.substr(4,4);
	        			var vsNo3 = vsNoTemp.substr(8,4);
	        			var vsNo4 = vsNoTemp.substr(12,4);
	        			this.barcodeNo = vsNo1 +"-" + vsNo2 +"-" + vsNo3 +"-" + vsNo4;
	        		}
	        		gCardInFgAlliance = "K" // 직접입력은 K
	        	}
	        	, readAllStart : function(paPointNo){
	        		util.logInfo("_____allianceDiscount readAllStart Start_____");
	        		
	        		this.fnGetJcdType(); // 통신사 코드를 변화하여 가져온다.
	        		// 리더기 활성화를 위해서 바코드 번호 없이 호출한다.
	        		this.fnCardReaderStart(); // 카드리더기 활성화
	        		setTimeout(this.fnStartBarCodeReader, 1000); // 카메라 활성화 1초후에 시작.
	        		
	        	}
	        	, fnCardReaderStart : function(){
	        		/**
	        		 * 카드로 포인트 조회하는 함수
	        		 * 바코드 번호 없이 호출하면 리더기를 활성화하고, 포인트카드를 읽을 때까지 대기한다.
	        		 * 바코드 번호를 넣고 호출하면 포인트 카드를 조회한다.
	        		 */
	        		util.logInfo("_____allianceDiscount fnCardReaderStart Start_____");
	        		util.logInfo("*****fnCardReaderStart CardReader FDK_PointInquiry : BIZ_CLS_SINGLE_CAT_ID == > " + BIZ_CLS_SINGLE_CAT_ID + ", this.jcdTypeFgNm = > " + this.jcdTypeFgNm);
	        		// 포인트 조회하기 위해 리더기 활성화 구동, 마지막에 바코드번호를 ""으로 보내면 리더기가 구동된다. 카드 읽히면 자동으로 바로 조회됨.
//	        		this.listenerIdC = nativeApp.functionCallASync(["FDK_PointInquiry", "10140185", "0", gvSwModelName, gvSwModelVersion, this.jcdTypeFgNm,""], this.fnPointCallbackResultS);
	        		this.listenerIdC = nativeApp.functionCallASync(["FDK_PointInquiry", BIZ_CLS_SINGLE_CAT_ID, "0", gvSwModelName, gvSwModelVersion, this.jcdTypeFgNm,""], this.fnPointCallbackResultS);
//	        		this.fnPointCallbackResultS();
	        	}
	        	, fn_pointSearchBtn : function(){ // 제휴할인 조회버튼 클릭 함수. 포인트 조회 수행.
        			var result = nativeApp.functionCallSync(["FDK_CreditCancel"]); // 카드 리더기 대기 취소
        			b2bbarcode.stopScanBarcode(); // 바코드 중지
        			this.fnGetJcdType(); // 통신사 코드를 변화하여 가져온다.
        			if(this.directYn == "Y"){ // 직접입력의 경우
        				if(!this.barcodeNo){
        					this.useMileYn = "N";
            				var dataObj = {
    								  button1Show : false
    								, button1Name : ""
    								, button1Func : ""
    								, button2Show : true
    								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 아니오 ]
    								, button2Func : ""
    								, message     : util.languageObjReturn(langCode,  'barCodeInput') // [ 바코드를 입력해 주세요. ]
    							};
    		    				eventBus.$emit('alertPopupIndex', dataObj);
    		    			return false;
            			}
        				this.readMsg = util.languageObjReturn(langCode, 'pointSearching'); // 포인트를 조회하고 있습니다.
        				// 포인트조회 함수 호출, 직접입력한 바코드번호를 파라미터로 보낸다.
        				var vsBarcodeNo = this.barcodeNo.replace(/-/gi, "");
        				util.logInfo("*****fn_pointSearchBtn Direct FDK_PointInquiry : BIZ_CLS_SINGLE_CAT_ID == > " + BIZ_CLS_SINGLE_CAT_ID + ", this.jcdTypeFgNm = > " + this.jcdTypeFgNm);
            		    this.listenerIdC = nativeApp.functionCallASync(["FDK_PointInquiry", BIZ_CLS_SINGLE_CAT_ID, "0", gvSwModelName, gvSwModelVersion, this.jcdTypeFgNm, vsBarcodeNo], this.fnPointCallbackResultS);
        			}else{ // 직접입력이 아닌경우에 다시 카메라와 리더기를 활성화한다.
        				this.readMsg = util.languageObjReturn(langCode, 'pointRead'); // 바코드 인식 및 카드를 읽혀주세요.
        				this.readAllStart();
        			}
	        	}
	        	, fnPointCallbackResultS : function(callbackName, result){
	        		util.logInfo("*****allianceDiscount fnPointCallbackResultS FDK_PointInquiry Callback Start*****");
        			try {
        				nativeApp.removeASyncApiListener(callbackName, this.listenerIdC); // 리더기 카드체크하는 리스너 해제함수.
        				b2bbarcode.stopScanBarcode(); // 바코드 중지					
    		    		var vsResult = result.substring(0, result.lastIndexOf("$$^")); // native 데이터 중 마지막 $$^를 제거    		    		
    		    		waitingService.ResetLogOutTimer(); // 대기화면으로 돌아가는 타이머 초기화. ( 결제 도중에 대기화면으로 돌아가지 않기 위해)
//    		    		var vsResult = {
//    		    				   "Data" : {
//    		    					      "Cancel_Reason" : "",
//    		    					      "Cash_Receipt_Transaction_Type" : "",
//    		    					      "DDCFlag" : "",
//    		    					      "Discount_Company_Code" : "",
//    		    					      "Goods_Code" : "",
//    		    					      "OCB결과코드" : "",
//    		    					      "OCB고객명" : "",
//    		    					      "Point_Amount_3" : "          ",
//    		    					      "Point_Transaction_Type" : "",
//    		    					      "Point_Value_Type" : "M",
//    		    					      "Status" : "APPROVE",
//    		    					      "가맹점명" : "남인천방송(주)",
//    		    					      "가맹점번호" : "V6931001",
//    		    					      "가맹점임의정보" : "0000000001",
//    		    					      "가맹점전화번호" : "0222873000",
//    		    					      "가맹점주소" : "인천 남구 주안동 203-3",
//    		    					      "가용포인트" : "8997760",
//    		    					      "거래금액" : "",
//    		    					      "거래시간" : "210319161914",
//    		    					      "거래일련번호" : "031934000060",
//    		    					      "거래일시" : "210319161917",
//    		    					      "누적포인트" : "",
//    		    					      "대표자명" : "김인태",
//    		    					      "리더기번호" : "24",
//    		    					      "매입사명" : "SKT",
//    		    					      "매입사코드" : "34",
//    		    					      "무서명금액" : "",
//    		    					      "발급사명" : "",
//    		    					      "발급사코드" : "",
//    		    					      "부가세" : "",
//    		    					      "사업자번호" : "1000000000",
//    		    					      "승인번호" : "00000000",
//    		    					      "승인일자" : "210319",
//    		    					      "알림메세지" : "",
//    		    					      "알림메세지1" : "",
//    		    					      "알림메세지2" : "",
//    		    					      "알림메세지3" : "",
//    		    					      "알림메세지4" : "",
//    		    					      "응답메세지1" : "정상완료",
//    		    					      "응답메세지2" : "",
//    		    					      "적립포인트" : "",
//    		    					      "전표번호" : "",
//    		    					      "체크카드구분" : "",
//    		    					      "카드명" : "SKT T멤버십",
//    		    					      "카드번호" : "216409**********",
//    		    					      "카드잔액" : "",
//    		    					      "카드종류" : "S",
//    		    					      "포인트할인금액" : "",
//    		    					      "포인트할인후금액" : "",
//    		    					      "프린터출력유무" : "O",
//    		    					      "할부" : "",
//    		    					      "할인금액" : "",
//    		    					      "할인후금액" : ""
//    		    					   },
//    		    					   "Message" : "",
//    		    					   "ResultCode" : "0"
//    		    					}

    		    		util.logInfo("vsResult search == > " + vsResult);
    		    		vsResult = JSON.parse(vsResult);
    		    		var vsCode = vsResult.ResultCode;
    		    		var vsMessage = vsResult.Message;
    		    		util.logInfo("*****allianceDiscount fnPointCallbackResultS FDK_PointInquiry Callback vsCode === > " + vsCode);
    		    		if(vsCode == "0"){
    		    			util.logInfo("*****allianceDiscount fnPointCallbackResultS FDK_PointInquiry Callback Status === > " + vsResult.Data["Status"]);
    		    			if(vsResult.Data["Status"] == "APPROVE"){
    		    				this.readMsg = util.languageObjReturn(langCode, 'pointSearchEnd'); // 포인트가 조회 되었습니다.
    		    				util.logInfo("*****allianceDiscount fnPointCallbackResultS FDK_PointInquiry Callback Success*****");
        		    			this.remainMile = util.numberWithCommas(Number(vsResult.Data["가용포인트"]));
        		    			if(this.directYn != "Y"){ // 직접입력인 경우에 바코드 번호를 *로 변경하여 셋팅하지 않는다. 번호 그대로 둔다.
        		    				this.barcodeNo = this.fnSplitNo(vsResult.Data["카드번호"]);
        		    			}
        		    			this.procId = vsResult.Data["리더기번호"];
        		    			gCardInFgAlliance = "S"; // 리더기 처리.
        		    			if(this.useMileYn == "Y"){
        		    				this.fnUseMileExe(); // 사용하기를 바로 수행한다.
        		    			}
    		    			}else{
    		    				util.logError("allianceDiscount readAllStart FDK_PointInquiry Callback No APPROVE Message == > " + vsResult.Data["응답메세지1"] + vsResult.Data["응답메세지2"]);
    		    				this.useMileYn = "N";
    		    				this.readMsg = util.languageObjReturn(langCode, 'pointSearchFail'); // 포인트 조회에 실패했습니다.
    		    				
    		    				var dataObj = {
  									  button1Show : false
  									, button1Name : ""
  									, button1Func : ""
  									, button2Show : true
  									, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 아니오 ]
  									, button2Func : ""
  									, message     : util.languageObjReturn(langCode,  'pointSearchFail') + "[" + vsResult.Data["응답메세지1"] + vsResult.Data["응답메세지2"] + "]" // [ 포인트 조회에 실패했습니다. ]
  								};
    		    				eventBus.$emit('alertPopupIndex', dataObj);
    		    			}
    		    			
		    			}else if (vsCode == "-7104"){ //
		    				util.logInfo("*****allianceDiscount readAllStart FDK_PointInquiry Callback CREDIT CANCEL*****");
		    				return;
		    			}else if (vsCode == "-7102"){ // 리더기 대기시간 초과일 때 다시 리더기를 활성화 한다.
		    				util.logInfo("*****allianceDiscount readAllStart FDK_PointInquiry Callback CREDIT CANCEL*****");
		    				this.fnCardReaderStart(); // 카드리더기 활성화
		    				return;
		    			}else{ // 승인 실패
		    				this.useMileYn = "N";
		    				util.logError("allianceDiscount readAllStart FDK_PointInquiry Callback ERROR Message == > " + vsMessage);
		    				this.readMsg = util.languageObjReturn(langCode, 'pointSearchFail'); // 포인트 조회에 실패했습니다.
		    				var dataObj = {
									  button1Show : false
									, button1Name : ""
									, button1Func : ""
									, button2Show : true
									, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 아니오 ]
									, button2Func : ""
									, message     : util.languageObjReturn(langCode,  'pointSearchFail') + "[" + vsMessage + "]" // [ 포인트 조회에 실패했습니다. ]
								};
		        			eventBus.$emit('alertPopupIndex', dataObj);
		    			}
        			} catch (e) {
        				this.useMileYn = "N";
        				this.readMsg = util.languageObjReturn(langCode, 'pointSearchFail'); // 포인트 조회에 실패했습니다.
        				var dataObj = {
								  button1Show : false
								, button1Name : ""
								, button1Func : ""
								, button2Show : true
								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 아니오 ]
								, button2Func : ""
								, message     : util.languageObjReturn(langCode,  'pointSearchFail') // [ 포인트 조회에 실패했습니다. ]
							};
	        			eventBus.$emit('alertPopupIndex', dataObj);
						util.logError("*****allianceDiscount readAllStart FDK_PointInquiry Callback Catch e == > " + e.toString());
						util.logError("*****allianceDiscount readAllStart FDK_PointInquiry Callback Catch e json == > " + JSON.stringify(e));
						
					}
	        	}
	        	, fn_pointSearchB : function(){ // 카메라로 바코드 인식하여 포인트 조회 수행.
        			
        			this.fnGetJcdType(); // 통신사 코드를 변화하여 가져온다.
        		    // 포인트조회 함수 호출 this.selJcdCd     BIZ_CLS_SINGLE_CAT_ID  10069371 
//        		    this.listenerIdB = nativeApp.functionCallASync(["FDK_PointInquiry", "10140185", "0", gvSwModelName, gvSwModelVersion, this.jcdTypeFgNm, "2164096900030013"], this.fnPointSearchCallbackB);
        			util.logInfo("*****fn_pointSearchB Barcode FDK_PointInquiry : BIZ_CLS_SINGLE_CAT_ID == > " + BIZ_CLS_SINGLE_CAT_ID + ", this.jcdTypeFgNm = > " + this.jcdTypeFgNm + ", this.readBarcodeNo = > " + this.readBarcodeNo);
        		    this.listenerIdB = nativeApp.functionCallASync(["FDK_PointInquiry", BIZ_CLS_SINGLE_CAT_ID, "0", gvSwModelName, gvSwModelVersion, this.jcdTypeFgNm, this.readBarcodeNo], this.fnPointSearchCallbackB);
	        	}
	        	, fnPointSearchCallbackB : function(callbackName, result){ // 바코드 포인트 조회 콜백
	        		util.logInfo("*****allianceDiscount fnPointSearchCallbackB Start*****" );		
	        		try 
    		    	{
    		    		nativeApp.removeASyncApiListener(callbackName, this.listenerIdB); // 리더기 카드체크하는 리스너 해제함수.
    		    		var vsResult = result.substring(0, result.lastIndexOf("$$^")); // native 데이터 중 마지막 $$^를 제거
    		    		waitingService.ResetLogOutTimer(); // 대기화면으로 돌아가는 타이머 초기화. ( 결제 도중에 대기화면으로 돌아가지 않기 위해)
    		    		vsResult = JSON.parse(vsResult);
    		    		var vsCode = vsResult.ResultCode;
    		    		if(vsCode == "0"){
    		    			if(vsResult.Data["Status"] == "APPROVE"){
    		    				this.readMsg = util.languageObjReturn(langCode, 'pointSearchEnd'); // 포인트가 조회 되었습니다.
    		    				this.remainMile = util.numberWithCommas(Number(vsResult.Data["가용포인트"]));
    		    				if(this.directYn != "Y"){ // 직접입력인 경우에 바코드 번호를 *로 변경하여 셋팅하지 않는다. 번호 그대로 둔다.
    		    					this.barcodeNo = this.fnSplitNo(this.readBarcodeNo);
    		    				}    		    				
    		    				this.procId = vsResult.Data["리더기번호"];
    		    				gCardInFgAlliance = "K"; // 바코드로 처리.
    		    			}else{ // 승인 실패
    		    				this.readMsg = util.languageObjReturn(langCode, 'rePointSearchEnd'); // 조회 버튼을 누른 후 카드를 인식하세요.
    		    				util.logInfo("*****allianceDiscount fnPointSearchCallbackB NO APPROVE*****" );
    		    				var dataObj = {
    									  button1Show : false
    									, button1Name : ""
    									, button1Func : ""
    									, button2Show : true
    									, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
    									, button2Func : ""
    									, message     : util.languageObjReturn(langCode,  'pointSearchFail') // [ 포인트 조회에 실패했습니다. ]
    								};
    		        			eventBus.$emit('alertPopupIndex', dataObj);
    		    			}
    		    			
    		    		}else{
    		    			this.readMsg = util.languageObjReturn(langCode, 'rePointSearchEnd'); // 조회 버튼을 누른 후 카드를 인식하세요.
    		    			util.logInfo("*****allianceDiscount fnPointSearchCallbackB Code NOT 0*****" );
    		    			util.logError("*****allianceDiscount fnPointSearchCallbackB vsResult == > " + JSON.stringify(vsResult));
    		    			var dataObj = {
									  button1Show : false
									, button1Name : ""
									, button1Func : ""
									, button2Show : true
									, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
									, button2Func : ""
									, message     : util.languageObjReturn(langCode,  'pointSearchFail') // [ 포인트 조회에 실패했습니다. ]
								};
    		    			eventBus.$emit('alertPopupIndex', dataObj);
    		    		}
    		    	} catch (e) {
    		    		this.readMsg = util.languageObjReturn(langCode, 'rePointSearchEnd'); // 조회 버튼을 누른 후 카드를 인식하세요.
    		    		util.logError("*****allianceDiscount fnPointSearchCallbackB Catch***** e ==> " + e.toString() );
    		    		var dataObj = {
								  button1Show : false
								, button1Name : ""
								, button1Func : ""
								, button2Show : true
								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
								, button2Func : ""
								, message     : util.languageObjReturn(langCode,  'pointSearchFail') // [ 포인트 조회에 실패했습니다. ]
							};
    		    		eventBus.$emit('alertPopupIndex', dataObj);	        		    		
    		    	}
	        	}
	        	, fnStartBarCodeReader : function() { // 카메라 구동시작.
        			util.logInfo('*****allianceDiscount fnStartBarCodeReader start!!*****');
        			try {
        				if(typeof tizen === 'undefined' ) {
        					//this.fncBarCodeListner("281006020000000000857324");//윈도우는 테스트 카카오 페이 신용
        				} else {
        					b2bbarcode.startScanBarcode(this.fncBarCodeListner);
        				}

					} catch (e) {
						util.logError("*****allianceDiscount fnStartBarCodeReader catch e ==> \n" + e.toString());
					}
        		}
        		, fncBarCodeListner : function(msg) {
        			util.logInfo('*****allianceDiscount fncBarCodeListner start!!*****');
        			let strBarcode ;
        			if(typeof tizen === 'undefined' ) {
        				this.readBarcodeNo = msg;
        			} else {
        				if ( msg.data !== 'NOT_DETECTED' ){// 입력됨.
        					util.logInfo("*****allianceDiscount fncBarCodeListner NOT_DETECTED");
        					this.readBarcodeNo = msg.data;
        				} else {
        					util.logInfo("*****allianceDiscount fncBarCodeListner retry");
							this.fnStartBarCodeReader();// 재시도 함.
        					return;
        				}
        			}
        			this.fnBarcodeReadEnd();
				}
        		, fnBarcodeReadEnd : function(paReadBarcodeNo){
        			util.logInfo('*****allianceDiscount fnBarcodeReadEnd start!!*****');
        			let appType ="" , dataObj = {};
					try {
						util.beep(); // 바코드 인식되었다는 비프음 출력.
						this.fnStopBarCodeReader(); // 카메라 중지
						waitingService.ResetLogOutTimer(); // 대기영상으로 돌아가는 시간 초기화.
						var result = nativeApp.functionCallSync(["FDK_CreditCancel"]); // 카드 리더기 대기 취소
						setTimeout(this.fn_pointSearchB, 500); // 바코드로 포인트 조회 함수 
//						this.fn_pointSearchB(); 
					} catch (e) {
						util.logError("*****allianceDiscount fnBarcodeReadEnd catch e =>> " + e.toString());
					}
        		}
        		, fnStopBarCodeReader : function() {
        			if(typeof tizen == "undefined" ) return;
        			try {
        				util.logInfo("*****allianceDiscount fnStopBarCodeReader Start*****");
        				b2bbarcode.stopScanBarcode();
					} catch (e) {
						util.logError("*****allianceDiscount fnStopBarCodeReader catch e =>> " + e.toString());
					}
        		}
        		, fnBack : function(){
        			var dataObj = {
							  button1Show : true
							, button1Name : util.languageObjReturn(langCode, 'no') // [ 예 ]
							, button1Func : ""
							, button2Show : true
							, button2Name : util.languageObjReturn(langCode, 'yes') // [ 아니오 ]
							, button2Func : this.fnGoBack
							, message     : util.languageObjReturn(langCode,  'pointHomeClick') // [ 진행내역이 초기화 됩니다. 뒤로 돌아가시겠습니까? ]
						};
        			eventBus.$emit('alertPopupIndex', dataObj);
        		}
        		, fnGoBack : function(){
        			router.push({path: '/paymentChoiceView'}); 
        		}
        		, fnUseMile : function(){ // 사용하기 버튼 클릭 이벤트
        			if(this.directYn == "Y"){ // 직접입력인 경우에 현재 입력된 바코드 번호로 조회를 무조건 하고나서 사용기능까지 자동으로 로직이 수행된다.(조회를 이미 한 상태라도 다시 조회함)
        				this.useMileYn = "Y"; // 조회를 호출한 후에 사용함수를 호출할지 말지 플래그
        				this.fn_pointSearchBtn(); // 조회함수 호출
        			}else{
        				this.fnUseMileExe();
        			}
        		}
        		, fnUseMileExe : function(){ // 사용하기 버튼 클릭 이벤트 
        			if(this.directYn != "Y" && !this.barcodeNo){ // 직접입력이 아닌경우
        				var dataObj = {
								  button1Show : false
								, button1Name : ""
								, button1Func : ""
								, button2Show : true
								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
								, button2Func : ""
								, message     : util.languageObjReturn(langCode,  'pointSearchValid') // [ "바코드 또는 카드를 인식하여 조회해 주세요." ]
							};
		    				eventBus.$emit('alertPopupIndex', dataObj);
		    			return false;
        			}else if (this.directYn == "Y" && !this.barcodeNo){ // 직접입력인 경우
        				this.useMileYn = "N";
        				var dataObj = {
								  button1Show : false
								, button1Name : ""
								, button1Func : ""
								, button2Show : true
								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
								, button2Func : ""
								, message     : util.languageObjReturn(langCode,  'barCodeInput') // [ 바코드를 입력해 주세요. ]
							};
		    				eventBus.$emit('alertPopupIndex', dataObj);
		    			return false;
        			}
        			var vsMenuCnt = orderInfo.POS_ODDTL_T.length; // 선택한 메뉴 정보
        			var paVaProdList = "";
        			for(var i=0; i<vsMenuCnt; i++){ // 메뉴정보에서 prod_cd를 'A','B','C' 와 같은 형태로 만든다.
        				if(i==0){
        					paVaProdList = "'" + orderInfo.POS_ODDTL_T[i].PROD_CD + "'";	
        				}else{
        					paVaProdList += ",'" + orderInfo.POS_ODDTL_T[i].PROD_CD + "'";
        				}
        				// 사이드메뉴가 있는경우에 사이드 메뉴도 추가한다.
        				if(orderInfo.POS_ODDTL_T[i].사이드_LIST != undefined){
        					for(var ii=0; ii < orderInfo.POS_ODDTL_T[i].사이드_LIST.length; ii++){
        						paVaProdList += ",'" + orderInfo.POS_ODDTL_T[i].사이드_LIST[ii].PROD_CD + "'";
        					}
        				}
        			}        			//[gShopCd, this.selJcdCd, paVaProdList]);
        			        			
        			var resultList = this.alliCompanyList.filter (p => p.JCD_CD == this.selJcdCd );        			
     	    		this.dcLimitAmt = resultList[0].DC_LIMIT_AMT; /** 할인한도금액 **/
     	    		this.dcLimitFg = resultList[0].DC_LIMIT_FG; /** 할인한도구분 (0:한도없음, 1:한도설정) **/
     	    		this.dcProdFg = resultList[0].DC_PROD_FG; /** 할인상품구분 ( 0:전체상품(제외대상상품) , 1:특정상품(할인대상상품) ) **/
     	    		util.logDebug("*****allianceDiscount fnUseMile dcLimitAmt => " + this.dcLimitAmt + ", dcLimitFg => " + this.dcLimitFg);
        			
        			util.logDebug("*****fnUseMile paVaProdList == >>> " + paVaProdList);        			
        			var vsSql = sqlQuery.selectSalePodList;        			
        			
        			vsSql += "AND A.STYLE_PROD_CD IN ( ? )".replace("?", paVaProdList); // 위에서 만든 prod_cd값을 IN절에 붙인다.
        			
        			var resultData = gfn_SQLiteSQLProcess(vsSql , [gShopCd, this.selJcdCd]); // 할인 대상의 제품인지 여부 쿼리 수행 (할인대상 테이블에 prod_cd 조건으로 가져옴)
            		let rows;
            		if ( resultData!= null && resultData.ResultCode == "0" ) {
        				rows = resultData.Data;
//        				if ( rows == undefined || rows == null ||  rows.length == 0 ) {
//        					util.logError("*****allianceDiscount fnUseMile selectSalePodList Result No!!!!!!*****");
//        					var dataObj = {
//      							  button1Show : false
//      							, button1Name : ""
//      							, button1Func : ""
//      							, button2Show : true
//      							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
//      							, button2Func : ""
//      							, message     : util.languageObjReturn(langCode,  'noSaleMenu') // [ 할인 대상의 상품이 존재하지 않습니다. ]
//      						};
//        					eventBus.$emit('alertPopupIndex', dataObj);
//        					return false;
//        				}
             	   	}
            		
            		var vsSaleAmt = 0; // 포인트 할인받을 금액
            		var vsPointAmt = 0; // 할인대상인 상품이 다른 마일리지로 할인받은 금액(마일리지 금액만 비율대로 가져온다.)      
            		var vsOtherMileAmt = 0; // 다른 마일리지로 할인을 받은 금액

            		//////// 기타 마일리지들에서 차감된 금액을 가져온다. //////            		
            		// 마일리지
            		if(orderInfo.POS_ODHDR_T.CST_USE_POINT !== undefined ) {
                		if(SHOP_INFO.POINT_FG=="M"){// 마일리지 매장일경우
                			// 마일리지 할인 값
                			vsOtherMileAmt = Number(orderInfo.POS_ODHDR_T.CST_USE_POINT);
                			util.logInfo(" ***** 마일리지 할인금액  == > " + vsOtherMileAmt);
                		}
                	}
                	
            		// 도도포인트
                	if(orderInfo.DODO_POINT_INFO !== undefined ) {
                		if(SHOP_INFO.POINT_FG=="M"){
                			// 도도포인트 할인 값
                			vsOtherMileAmt = Number(orderInfo.DODO_POINT_INFO.USE_POINT);
                			util.logInfo(" ***** 도도포인트 할인금액  == > " + vsOtherMileAmt);
                		} 
                	}
                	
                	//////// 기타 마일리지들에서 차감된 금액을 가져온다. //////
                	this.POINT_SALE_LIST = []; // 할인 대상이 되는 pos_oddtl_t의 row를 담고, 마일리지가 차감된 dcm_sale_amt를 수정하여 변경한다.
                	this.POINT_SALE_LIST_SIDE = []; // 할인 대상이 되는 pos_oddtl_t의 사이드 row를 담고, 마일리지가 차감된 dcm_sale_amt를 수정하여 변경한다.
                	var vnListCnt = 0;
                	var vnSideListCnt = 0;
                	// 스템프는 제외해야한다.
        			if(this.dcProdFg == "0"){ // 0이면 selectSalePodList에 제품들은 제외대상임
        				util.logInfo("***** 할인대상테이블(제외대상)과 주문한 제품 대상 찾기 시작 *****");
        				if(!!rows){ // 제외대상 테이블의 데이터가 존재한다면
        					util.logInfo("***** 할인대상테이블에 주문한 제품이 있음 *****");
	        				var vsRowCnt = rows.length;
	        				for(var z=0; z<vsRowCnt;z++){ // 제외대상제품 for문
	        					
	        					var vsProdCd = rows[z].PROD_CD; // 제외대상 상품코드
        						for(var jj=0; jj<vsMenuCnt; jj++){ // 주문한 내역 POS_ODDTL_T FOR문
        							var vsMenuYn = "Y";
                    				if(orderInfo.POS_ODDTL_T[jj].PROD_CD == vsProdCd){ // 제외대상 제품과 일치하면
                    					vsMenuYn = "N";
                    				}
                    				// 메뉴가 제외대상 상품이 아니라면
                    				if(vsMenuYn == "Y"){
                    					util.logInfo("할인대상 메인제품 == > PROD_CD :: " + orderInfo.POS_ODDTL_T[jj].PROD_CD + ", DCM_SALE_AMT :: " + orderInfo.POS_ODDTL_T[jj].DCM_SALE_AMT + ", SALE_UPRC :: " + orderInfo.POS_ODDTL_T[jj].SALE_UPRC + ", DC_AMT :: " + orderInfo.POS_ODDTL_T[jj].DC_AMT + ", ORDER_QTY :: " + orderInfo.POS_ODDTL_T[jj].ORDER_QTY);
                    					this.POINT_SALE_LIST[vnListCnt] = orderInfo.POS_ODDTL_T[jj]; // 대상 상품 정보를 따로 list에 담는다.
                    					this.POINT_SALE_LIST[vnListCnt].DTL_IDX = jj; // 할인 대상인 메뉴객체에 pos_ordtl_t의 메인메뉴 배열index를 담는다.
                    					vnListCnt++;
            						}
                    				
                    				if(orderInfo.POS_ODDTL_T[jj].사이드_LIST != undefined){ // 사이드가 존재한다면
                    					var vsSideCnt = orderInfo.POS_ODDTL_T[jj].사이드_LIST.length;
                    					for(var s=0; s<vsSideCnt; s++){
                    						var vsSideMenuYn = "Y";
                    						if(orderInfo.POS_ODDTL_T[jj].사이드_LIST[s].PROD_CD == vsProdCd){ // 사이드 상품과 제외대상 제품과 일치하면
                    							vsSideMenuYn = "N"; // 테이블 제품과 일치하는게 있다면 제외대상이기때문에 플레그를 N으로 변경
                    						}
                    						if(vsSideMenuYn == "Y"){ // 제외대상과 일치하지 않을 때만 담는다.
                    							util.logInfo("할인대상 메인제품 사이드 존재  == > PROD_CD :: " + orderInfo.POS_ODDTL_T[jj].사이드_LIST[s].PROD_CD + ", SIDE_SALE_UPRC :: " + orderInfo.POS_ODDTL_T[jj].사이드_LIST[s].SIDE_SALE_UPRC + ", SIDE_DC_AMT :: " + orderInfo.POS_ODDTL_T[jj].사이드_LIST[s].SIDE_DC_AMT + ", SIDE_QTY :: " + orderInfo.POS_ODDTL_T[jj].사이드_LIST[s].SIDE_QTY);
                    							this.POINT_SALE_LIST_SIDE[vnSideListCnt] = orderInfo.POS_ODDTL_T[jj].사이드_LIST[s]; // 대상 사이드 상품 정보를 따로 list에 담는다.  
                    							this.POINT_SALE_LIST_SIDE[vnSideListCnt].MAIN_PROD_CD = orderInfo.POS_ODDTL_T[jj].PROD_CD; // 메인상품의 상품코드를 담는다. 추후에 사이드와 메인메뉴의 키값으로 매칭하기 위해서
                    							this.POINT_SALE_LIST_SIDE[vnSideListCnt].DTL_IDX = jj; // 할인 대상인 사이드 객체에 pos_ordtl_t의 메인메뉴 배열index를 담는다.
                    							this.POINT_SALE_LIST_SIDE[vnSideListCnt].SIDE_DTL_IDX = s; // 할인 대상인 사이드 객체에 pos_ordtl_t의 사이드 배열index를 담는다.
                    							vnSideListCnt++;
                    						}
                    						
                    					}
                    				}
                    			}
        						
        						
        					}
        				}
        			}else{ // 1인경우에 selectSalePodList 제품들은 할인대상임
        				util.logInfo("***** 할인대상테이블(할인대상)과 주문한 제품 대상 찾기 시작 *****");
        				if(!!rows){ // 제외대상 테이블의 데이터가 존재한다면
	        				var vsRowCnt = rows.length;
	        				for(var z=0; z<vsRowCnt;z++){ // 제외대상제품 for문
        						var vsProdCd = rows[z].PROD_CD; // 제외대상 상품코드
        						for(var jj=0; jj<vsMenuCnt; jj++){ // 주문한 내역 POS_ODDTL_T FOR문
            						
                    				if(orderInfo.POS_ODDTL_T[jj].PROD_CD == vsProdCd){ // 제외대상 제품과 일치하면
                    					util.logInfo("할인대상 메인제품 == > PROD_CD :: " + orderInfo.POS_ODDTL_T[jj].PROD_CD + ", DCM_SALE_AMT :: " + orderInfo.POS_ODDTL_T[jj].DCM_SALE_AMT + ", SALE_UPRC :: " + orderInfo.POS_ODDTL_T[jj].SALE_UPRC + ", DC_AMT :: " + orderInfo.POS_ODDTL_T[jj].DC_AMT + ", ORDER_QTY :: " + orderInfo.POS_ODDTL_T[jj].ORDER_QTY);
                    					this.POINT_SALE_LIST[vnListCnt] = orderInfo.POS_ODDTL_T[jj]; // 대상 상품 정보를 따로 list에 담는다.
                    					this.POINT_SALE_LIST[vnListCnt].DTL_IDX = jj; // 할인 대상인 메뉴객체에 pos_ordtl_t의 메인메뉴 배열index를 담는다.
                    					vnListCnt++;
                    				}
                    				if(orderInfo.POS_ODDTL_T[jj].사이드_LIST != undefined){ // 사이드가 존재한다면
                    					var vsSideCnt = orderInfo.POS_ODDTL_T[jj].사이드_LIST.length;
                    					for(var s=0; s<vsSideCnt; s++){
                    						if(orderInfo.POS_ODDTL_T[jj].사이드_LIST[s].PROD_CD == vsProdCd){ // 사이드 상품과 제외대상 제품과 일치하면
                    							util.logInfo("할인대상 메인제품 사이드 존재  == > PROD_CD :: " + orderInfo.POS_ODDTL_T[jj].사이드_LIST[s].PROD_CD + ", SIDE_SALE_UPRC :: " + orderInfo.POS_ODDTL_T[jj].사이드_LIST[s].SIDE_SALE_UPRC + ", SIDE_DC_AMT :: " + orderInfo.POS_ODDTL_T[jj].사이드_LIST[s].SIDE_DC_AMT + ", SIDE_QTY :: " + orderInfo.POS_ODDTL_T[jj].사이드_LIST[s].SIDE_QTY);
                    							this.POINT_SALE_LIST_SIDE[vnSideListCnt] = orderInfo.POS_ODDTL_T[jj].사이드_LIST[s]; // 대상 사이드 상품 정보를 따로 list에 담는다.  
                    							this.POINT_SALE_LIST_SIDE[vnSideListCnt].MAIN_PROD_CD = orderInfo.POS_ODDTL_T[jj].PROD_CD; // 메인상품의 상품코드를 담는다. 추후에 사이드와 메인메뉴의 키값으로 매칭하기 위해서
                    							this.POINT_SALE_LIST_SIDE[vnSideListCnt].DTL_IDX = jj; // 할인 대상인 사이드 객체에 pos_ordtl_t의 메인메뉴 배열index를 담는다.
                    							this.POINT_SALE_LIST_SIDE[vnSideListCnt].SIDE_DTL_IDX = s; // 할인 대상인 사이드 객체에 pos_ordtl_t의 사이드 배열index를 담는다.
                    							vnSideListCnt++;
                    						}
                    					}
                    				}
                    			}
        					}
        				}
        			}
    				var vsSelMenuCnt = this.POINT_SALE_LIST.length; // 대상이되는 메뉴 cnt
    				var vsSelSideMenuCnt = this.POINT_SALE_LIST_SIDE.length; // 대상이되는 사이드메뉴 cnt
    				var vnTotSaleAmt = 0;
    				if(this.taxEnvVal == "1"){ // 부가세 포함
    					vnTotSaleAmt = Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT);
    				}else{ // 부가세 별도
    					vnTotSaleAmt = Number(orderInfo.POS_ODHDR_T.NO_TOT_SALE_AMT);
    				}
    				// 할인대상 금액이 없다면 리턴.
            		if(vsSelMenuCnt == "0" && vsSelSideMenuCnt == "0"){
            			var dataObj = {
    							  button1Show : false
    							, button1Name : ""
    							, button1Func : ""
    							, button2Show : true
    							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
    							, button2Func : ""
    							, message     : util.languageObjReturn(langCode, 'saleProdNo') // [ 선택한 품목 중에 할인 대상이 없습니다. ]
    						};
      					eventBus.$emit('alertPopupIndex', dataObj);
      					return;
            		}
    				for(var j=0; j<vsSelMenuCnt; j++){ // 대상이되는 메뉴 for문
    					util.logInfo("***** 할인대상 제품 for문 " + j + "번째");
//        						vsSaleAmt = vsSaleAmt + vsSaleAmtTemp; // 주문한 상품 LIST에서 금액을 찾아와 더한다. (할인이 차감된 상품금액 누적)
    					var vnSaleUprcQty = Number(this.POINT_SALE_LIST[j].SALE_UPRC) * Number(this.POINT_SALE_LIST[j].ORDER_QTY); // 단가 * 수량
    					util.logInfo("***** vnSaleUprcQty == > " + vnSaleUprcQty);
						vsSaleAmt = vsSaleAmt + vnSaleUprcQty; // 주문한 상품 LIST에서 금액을 찾아와 더한다. (할인이 차감된 상품금액 누적)
						util.logInfo("***** vsSaleAmt + vnSaleUprcQty == > " + vsSaleAmt);
						var vsMilePercentAmt = 0;
						if(SHOP_INFO.POINT_FG=="S"){ // S인 경우는 스탬프
							// 스탬프인 경우에 상품하나를 통채로 사용하는 것이기 때문에, sale_amt(해당 상품의 값 * 개수)와 스탬프 할인을 제외한 금액(vsSaleAmtTemp)이 다르다면 해당 제외금액만 담는다.
//        							if(Number(orderInfo.POS_ODDTL_T[j].SALE_AMT) != vsSaleAmtTemp){
//        								vsMilePercentAmt = vsSaleAmtTemp;
//        							}else{
//        								vsMilePercentAmt = 0;
//        							}
							var vsCstUsePoint = 0;
							// cst_use_point가 undefined 인 경우가 있어서, 값이 있을 때만 set하고, 아니면 0으로 계산한다.
							if(!!this.POINT_SALE_LIST[j].CST_USE_POINT){
								vsCstUsePoint = this.POINT_SALE_LIST[j].CST_USE_POINT; // 마일리지 할인 값 (스탬프사용인 경우에 스탬프 총사용한 개수가 들어감 / 햄버거 3개를 시키고 그중 두 개나 한개만 스탬프로 사용할 수 있다.)
							}
							// CST_USE_POINT(총 사용한 스탬프 개수),  STAMP_USE_QTY(한개의 상품에 대한 스탬프 개수 기준) , SALE_UPRC(한개의 단일가격)
							vsMilePercentAmt = (Number(vsCstUsePoint) / Number(this.POINT_SALE_LIST[j].STAMP_USE_QTY)) * Number(orderInfo.POINT_SALE_LIST[j].SALE_UPRC);
							util.logInfo("***** 스탬프 할인 금액 vsMilePercentAmt == > " + vsMilePercentAmt);
                		}else if(SHOP_INFO.POINT_FG=="M"){
                			util.logInfo("***** 마일리지 할인 금액 계산 대상 값(메인메뉴). vnSaleUprcQty == > " + vnSaleUprcQty);
                			util.logInfo("***** 마일리지 할인 금액 계산 대상 값(메인메뉴). vnTotSaleAmt == > " + vnTotSaleAmt);
                			util.logInfo("***** 마일리지 할인 금액 계산 대상 값(메인메뉴). vsOtherMileAmt == > " + Number(vsOtherMileAmt));
                			// 다른 마일리지 값을 해당상품값의 비율대로만 계산하여 더하여 담는다. vsOtherMileAmt(도도포인트 혹은 마일리지의 할인 금액)                			
    						vsMilePercentAmt = Number(vnSaleUprcQty) / vnTotSaleAmt * Number(vsOtherMileAmt);
    						util.logInfo("***** 마일리지 할인 금액 vsMilePercentAmt == > " + vsMilePercentAmt);
                		}						
						// 포장할인인 경우에 DC_AMT에 금액이 있따. 그걸 할인대상누적금액에 포함한다.
						if(this.POINT_SALE_LIST[j].DC_AMT != "" && this.POINT_SALE_LIST[j].DC_AMT != "0" ){
							vsMilePercentAmt += Number(this.POINT_SALE_LIST[j].DC_AMT);
							util.logInfo("***** 포장 할인 금액 this.POINT_SALE_LIST[j].DC_AMT == > " + this.POINT_SALE_LIST[j].DC_AMT);
						}
						vsPointAmt += vsMilePercentAmt; // 다른 마일리지 값을 해당상품값의 비율대로만 계산하여 더하여 담는다.
						util.logInfo("***** 스탬프 할인 금액(메인) vsPointAmt += vsMilePercentAmt == > " + vsPointAmt);
						if(vsMilePercentAmt != "0"){ // 마일리지가 차감된 금액이 0원이 아닐 때 담는다. (계산상 0원이면 마일리지가 없는 것임)
//							this.POINT_SALE_LIST[j].DCM_SALE_AMT = Number(this.POINT_SALE_LIST[j].DCM_SALE_AMT) - vsMilePercentAmt;  // 마일리지가 자감된 상품 금액을 담는다.
							this.POINT_SALE_LIST[j].DCM_SALE_UPRC = Number(vnSaleUprcQty) - vsMilePercentAmt;  // 마일리지가 자감된 상품 금액을 담는다.
						}else{
							this.POINT_SALE_LIST[j].DCM_SALE_UPRC = Number(vnSaleUprcQty);
						}
    						
            		}
    				// 대상 사이드 for문
    				for(var j=0; j<vsSelSideMenuCnt; j++){
    					util.logInfo("***** 할인대상 사이드 제품 for문  " + j + "번째");
    					var vnMainIdx = this.POINT_SALE_LIST_SIDE[j].DTL_IDX; // 해당 사이드메뉴의 메인메뉴 인덱스(orderInfo.POS_ODDTL_T 기준)
    					var vnSaleUprcQtySide = Number(this.POINT_SALE_LIST_SIDE[j].SIDE_SALE_UPRC) * Number(this.POINT_SALE_LIST_SIDE[j].SIDE_QTY) * Number(orderInfo.POS_ODDTL_T[vnMainIdx].ORDER_QTY); // 사이드단가 * 사이드수량 * 메인상품의 수량
    					util.logInfo("***** vnSaleUprcQtySide == > " + vnSaleUprcQtySide);
    					vsSaleAmt = vsSaleAmt + Number(vnSaleUprcQtySide); // 주문한 상품 LIST에서 금액을 찾아와 더한다. (할인이 차감된 상품금액 누적)
    					util.logInfo("***** (사이드) vsSaleAmt + vnSaleUprcQtySide == > " + vsSaleAmt);
						var vsMilePercentAmtSide = 0;
						if(SHOP_INFO.POINT_FG=="S"){ // S인 경우는 스탬프
							// 스탬프인 경우에 상품하나를 통채로 사용하는 것이기 때문에, sale_amt(해당 상품의 값 * 개수)와 스탬프 할인을 제외한 금액(vsSaleAmtTemp)이 다르다면 해당 제외금액만 담는다.
//        							if(Number(orderInfo.POS_ODDTL_T[j].SALE_AMT) != vsSaleAmtTemp){
//        								vsMilePercentAmt = vsSaleAmtTemp;
//        							}else{
//        								vsMilePercentAmt = 0;
//        							}
							var vsCstUsePoint = 0;
							// cst_use_point가 undefined 인 경우가 있어서, 값이 있을 때만 set하고, 아니면 0으로 계산한다.
							if(!!this.POINT_SALE_LIST[j].CST_USE_POINT){
								vsCstUsePoint = this.POINT_SALE_LIST_SIDE[j].SIDE_CST_USE_POINT; // 마일리지 할인 값 (스탬프사용인 경우에 스탬프 할인 값 들어감)
							}
							// CST_USE_POINT(총 사용한 스탬프 개수),  STAMP_USE_QTY(한개의 상품에 대한 스탬프 개수 기준) , SALE_UPRC(한개의 단일가격)
							// 햄버거 3개 주문 한거라고 가정하면, 햄버거 1개금액 : 10000원, 햄버거 1개 기준 스탬프 사용개수 : 5개 라고 했을 때, 햄버거 2개를 스탬프로 할인 받으면
							// vsCstUsePoint(스탬프 사용한 개수) : 10, STAMP_USE_QTY(햄버거 1개쓰기위한 스탬프 개수) : 5 가 들어간다. 거기에 단가를 곱하면 스탬프 할인받은 금액이다.
							vsMilePercentAmtSide = (Number(vsCstUsePoint) / Number(this.POINT_SALE_LIST_SIDE[j].SIDE_STAMP_USE_QTY)) * Number(orderInfo.POINT_SALE_LIST_SIDE[j].SIDE_SALE_UPRC);
							util.logInfo("***** 스탬프 할인 금액(사이드) vsMilePercentAmt == > " + vsMilePercentAmt);
                		}else if(SHOP_INFO.POINT_FG=="M"){
                			util.logInfo("***** 마일리지 할인 금액 계산 대상 값(사이드). vnSaleUprcQtySide == > " + vnSaleUprcQtySide);
                			util.logInfo("***** 마일리지 할인 금액 계산 대상 값(사이드). vnTotSaleAmt == > " + vnTotSaleAmt);
                			util.logInfo("***** 마일리지 할인 금액 계산 대상 값(사이드). vsOtherMileAmt == > " + Number(vsOtherMileAmt));
                			// 다른 마일리지 값을 해당상품값의 비율대로만 계산하여 더하여 담는다. vsOtherMileAmt(도도포인트 혹은 마일리지의 할인 금액)
                			vsMilePercentAmtSide = Number(vnSaleUprcQtySide) / vnTotSaleAmt * Number(vsOtherMileAmt);
                			util.logInfo("***** 마일리지 할인 금액(사이드) vsMilePercentAmtSide == > " + vsMilePercentAmtSide);
                		}
						
						vsPointAmt += vsMilePercentAmtSide; // 다른 마일리지 값을 해당상품값의 비율대로만 계산하여 더하여 담는다.
						util.logInfo("***** 할인 누적 금액(사이드) vsPointAmt == > " + vsPointAmt);
						if(vsMilePercentAmtSide != "0"){ // 마일리지가 차감된 금액이 0원이 아닐 때 담는다. (계산상 0원이면 마일리지가 없는 것임)						
//							this.POINT_SALE_LIST[j].DCM_SALE_AMT = Number(this.POINT_SALE_LIST[j].DCM_SALE_AMT) - vsMilePercentAmtSide;  // 마일리지가 자감된 상품 금액을 담는다.
							this.POINT_SALE_LIST_SIDE[j].SIDE_DCM_SALE_UPRC = Number(vnSaleUprcQtySide) - vsMilePercentAmtSide;  // 마일리지가 자감된 상품 금액을 담는다.
						}else{
							this.POINT_SALE_LIST_SIDE[j].SIDE_DCM_SALE_UPRC = Number(vnSaleUprcQtySide);  // 마일리지가 자감된 상품 금액을 담는다.
						}
    				}
        			
    				util.logInfo("***** 제휴할인 대상 금액  vsSaleAmt == > " + vsSaleAmt);
    				util.logInfo("***** 제휴할인 다른 마일리지 금액  vsPointAmt == > " + vsPointAmt);
    				
                 	vsSaleAmt = vsSaleAmt - vsPointAmt; // 할인 대상 상품 판매가의 합계 - 다른 마일리지 값
                 	vsSaleAmt = Math.floor(vsSaleAmt);
                 	util.logInfo("***** 제휴할인 절사 처리한 최종 대상금액   vsSaleAmt == > " + vsSaleAmt);
                 	this.ORIGIN_APPR_AMT = vsSaleAmt;
            		if(this.dcLimitFg == "1" && Number(this.dcLimitAmt) < vsSaleAmt){ // 한도있음으로 설정되어 있고, 할인 한도 금액보다 할인 대상 총금액이 크면 할인한도금액으로 제휴카드 승인함수에 보낸다.
                			vsSaleAmt = Number(this.dcLimitAmt);
                	}
            		this.APPR_AMT = vsSaleAmt; // 할인대상 금액을 승인금액에 넣어준다. (최종 제휴할인 대상 총금액)            		
            		this.fnGetJcdType(); // 통신사 코드를 변화하여 가져온다.
            		util.logInfo("*****allianceDiscount FDK_PointSearch_Purchase PARAM ===>  " + BIZ_CLS_SINGLE_CAT_ID + " / " + vsSaleAmt + " / " + gvSwModelName+ " / " + gvSwModelVersion + " / " + this.jcdTypeFgNm + " / " + this.procId);
            		
            		// BIZ_CLS_SINGLE_CAT_ID  10140185
//            		this.listenerIdA = nativeApp.functionCallASync(["FDK_PointSearch_Purchase", "10140185", "" + vsSaleAmt, gvSwModelName, gvSwModelVersion, this.jcdTypeFgNm, "" + this.procId, "1001"], this.fnPointCallbackResultA);
            		this.listenerIdA = nativeApp.functionCallASync(["FDK_PointSearch_Purchase", BIZ_CLS_SINGLE_CAT_ID, "" + vsSaleAmt, gvSwModelName, gvSwModelVersion, this.jcdTypeFgNm, "" + this.procId, "1001"], this.fnPointCallbackResultA);
//            		this.fnPointCallbackResultA();
        		}
        		// 포인트 사용 후 콜백 (제휴할인사용 콜백)
        		, fnPointCallbackResultA : function(callbackName, result){
        			try 
        			{
        				util.logInfo("*****allianceDiscount fnPointCallbackResultA START ***** ");
        				nativeApp.removeASyncApiListener(callbackName, this.listenerIdA); // 리더기 카드체크하는 리스너 해제함수.
        				var vsResult = result.substring(0, result.lastIndexOf("$$^")); // native 데이터 중 마지막 $$^를 제거
//        				var vsResult =  {
//        						   "Data" : {
//        							      "Cancel_Reason" : "",
//        							      "Cash_Receipt_Transaction_Type" : "",
//        							      "DDCFlag" : "",
//        							      "Discount_Company_Code" : "",
//        							      "Goods_Code" : "1001",
//        							      "OCB결과코드" : "",
//        							      "OCB고객명" : "",
//        							      "Point_Amount_3" : "          ",
//        							      "Point_Transaction_Type" : "",
//        							      "Point_Value_Type" : "M",
//        							      "Status" : "APPROVE",
//        							      "가맹점명" : "남인천방송(주)",
//        							      "가맹점번호" : "V6931001",
//        							      "가맹점임의정보" : "0000000001",
//        							      "가맹점전화번호" : "0222873000",
//        							      "가맹점주소" : "인천 남구 주안동 203-3",
//        							      "가용포인트" : "8995130",
//        							      "거래금액" : "25004",
//        							      "거래시간" : "210319164823",
//        							      "거래일련번호" : "031934000066",
//        							      "거래일시" : "210319164827",
//        							      "누적포인트" : "",
//        							      "대표자명" : "김인태",
//        							      "리더기번호" : "24",
//        							      "매입사명" : "SKT",
//        							      "매입사코드" : "34",
//        							      "무서명금액" : "",
//        							      "발급사명" : "",
//        							      "발급사코드" : "",
//        							      "부가세" : "",
//        							      "사업자번호" : "1000000000",
//        							      "승인번호" : "80372326",
//        							      "승인일자" : "210319",
//        							      "알림메세지" : "",
//        							      "알림메세지1" : "",
//        							      "알림메세지2" : "",
//        							      "알림메세지3" : "",
//        							      "알림메세지4" : "",
//        							      "응답메세지1" : "정상완료",
//        							      "응답메세지2" : "",
//        							      "적립포인트" : "",
//        							      "전표번호" : "",
//        							      "체크카드구분" : "",
//        							      "카드명" : "SKT T멤버십",
//        							      "카드번호" : "216409**********",
//        							      "카드잔액" : "",
//        							      "카드종류" : "S",
//        							      "포인트할인금액" : "3750",
//        							      "포인트할인후금액" : "21254",
//        							      "프린터출력유무" : "O",
//        							      "할부" : "",
//        							      "할인금액" : "",
//        							      "할인후금액" : ""
//        							   },
//        							   "Message" : "",
//        							   "ResultCode" : "0"
//        							}

        				util.logInfo("*****allianceDiscount fnPointCallbackResultA Resultdata == >  " + vsResult);
        				vsResult = JSON.parse(vsResult); 
        				var vsCode = vsResult.ResultCode;
        				if(vsCode == "0"){ // 정상코드
        					if(vsResult.Data["Status"] == "APPROVE"){ // 정상 승인
        						
        						////////////// 받아온 포인트할인 금액으로 상품별로 비율을 계산하여 각 상품별 컬럼에 값들을 셋팅한다. //////////
        						// 각각의 상품별로 할인받은 금액을 상품금액의 비율대로 계산하여 컬럼에 값을 추가해준다.
        						var vsPointCnt = this.POINT_SALE_LIST.length; // 제휴할인 대상만 담은 list
        						var vsPointSideCnt = this.POINT_SALE_LIST_SIDE.length; // 제휴할인 대상만 담은 list
        						var vsMenuCnt = orderInfo.POS_ODDTL_T.length; // 선택한 메뉴 정보
        						var vsJcdDcAmt =  vsResult.Data["포인트할인금액"]; //제휴카드-할인금액
        						if(Number(vsJcdDcAmt) == 0 || !vsJcdDcAmt){ // 할인을 받지 못했다면 메시지 처리 후 리턴한다.
        							util.logError("*****allianceDiscount fnPointCallbackResultA NO Sale Amt 포인트할인금액이 0원 또는 null *****");
            						var dataObj = {
              							  button1Show : false
              							, button1Name : ""
              							, button1Func : ""
              							, button2Show : true
              							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
              							, button2Func : ""
              							, message     : util.languageObjReturn(langCode,  'pointUseReject') // [ 제휴 할인을 받지 못하였습니다. [제휴사 문의] ]
              						};
                					eventBus.$emit('alertPopupIndex', dataObj);
                					this.fnGoBack(); // 결제수단 선택화면으로 돌아간다.
                					return;
        						}
        						var vnDcTotAmt = 0; // 상품별로 제휴할인받은 금액을 더한 값.
        						
        						var vaIdx = [];				
        						
        						util.logInfo("***** 할인 사용 후 금액 재계산 시작 *****");
    							for(var i=0; i<vsPointCnt; i++){ // 제휴할인 대상 for문
    								util.logInfo("***** 할인 사용 후 금액 재계산 메인메뉴 시작 *****");
									// 해당 상품별 상품가격의 비율로 계산된  제휴할인 금액 //////////////////////////////////////////////DCM_SALE_AMT 이거를 마일리지 차감된 각각의 금액으로 매칭해야함.!!!!!!!!!!!!!!
        							// 상품개별가격(상품금액 비율로 마일리지가 차감된 금액) / 할인대상총금액 * 할인된금액        									
									util.logInfo("==========this.POINT_SALE_LIST[i].PROD_CD == > " + this.POINT_SALE_LIST[i].PROD_CD);
									util.logInfo("==========Number(this.POINT_SALE_LIST[i].SALE_UPRC) == > " + Number(this.POINT_SALE_LIST[i].SALE_UPRC));
									util.logInfo("==========Number(this.POINT_SALE_LIST[i].ORDER_QTY) == > " + Number(this.POINT_SALE_LIST[i].ORDER_QTY));
        							util.logInfo("==========Number(this.APPR_AMT) == > " + Number(this.APPR_AMT));
        							util.logInfo("==========Number(vsJcdDcAmt) == > " + Number(vsJcdDcAmt));
        							
        							var j = this.POINT_SALE_LIST[i].DTL_IDX; // pos_oddtl_t와 매칭되는 인덱스
        							var vnSaleUprcQty = Number(this.POINT_SALE_LIST[i].SALE_UPRC) * Number(this.POINT_SALE_LIST[i].ORDER_QTY); // 단가 * 수량
        							// 할인된 총금액에서 해당 상품의 금액비율로 할인금액을 추출.
									var vnDcAmt = Number(this.POINT_SALE_LIST[i].DCM_SALE_UPRC) * (Number(this.APPR_AMT) / Number(this.ORIGIN_APPR_AMT)) / Number(this.APPR_AMT) * Number(vsJcdDcAmt); // DCM_SALE_UPRC : 메뉴 금액에서 제휴할인 전에 할인받은 내역을 차감한 금액 (마일리지, 스탬프 등) / 제휴할인을 위한 총금액 * 제휴할인 받은금액
        							vnDcAmt = Math.floor(vnDcAmt);
        							util.logInfo("========== vnDcAmt == > " + vnDcAmt);
        							vnDcTotAmt = vnDcTotAmt + parseInt(vnDcAmt); // 
        							
									if(i==vsPointCnt-1 && vsPointSideCnt=="0"){ // 마지막 제휴할인 상품이고, 할인대상 사이드가 없다면 제품마지막에 잔여포인트 보정처리함.
										var vnRemainAmt = Number(vsJcdDcAmt) - Number(vnDcTotAmt); // 전체할인금액 - 상품별로 절삭하면서 더한 할인금액  (짜투리금액)
										// 비율로 계산하면서 절삭하고 남은 금액을 마지막 상품에 더해서 넣어준다.
    									// 할인된 금액을 넣는다. 지금은 한개의 할인만 존재하지만, 추후에 여러개의 할인이 있는 경우에 할인금액을 계속 더하여 넣는다.
										// 할인받은 금액(기존에 받았던 할인금액) + 현재 할인 받은 금액 + 절삭하고 남은 금액
										util.logInfo("==========orderInfo.POS_ODDTL_T[j].DC_AMT == > " + orderInfo.POS_ODDTL_T[j].DC_AMT);
										util.logInfo("==========Number(vnDcAmt) == > " + Number(vnDcAmt));
										util.logInfo("==========vnRemainAmt == > " + vnRemainAmt);
    									orderInfo.POS_ODDTL_T[j].DC_AMT = Number(orderInfo.POS_ODDTL_T[j].DC_AMT) + Number(vnDcAmt) + vnRemainAmt;
    									orderInfo.POS_ODDTL_T[j].DC_AMT_JCD = Number(vnDcAmt) + vnRemainAmt;
										
									}else{
    									// 할인된 금액을 넣는다. 지금은 한개의 할인만 존재하지만, 추후에 여러개의 할인이 있는 경우에 할인금액을 계속 더하여 넣는다.
										util.logInfo("==========orderInfo.POS_ODDTL_T[j].DC_AMT == > " + orderInfo.POS_ODDTL_T[j].DC_AMT);
										util.logInfo("==========Number(vnDcAmt) == > " + Number(vnDcAmt));
    									orderInfo.POS_ODDTL_T[j].DC_AMT = Number(orderInfo.POS_ODDTL_T[j].DC_AMT) + Number(vnDcAmt);
    									orderInfo.POS_ODDTL_T[j].DC_AMT_JCD = Number(vnDcAmt);
									}
									util.logInfo("==========Number(orderInfo.POS_ODDTL_T[j].SALE_AMT) == > " + Number(orderInfo.POS_ODDTL_T[j].SALE_AMT));
									util.logInfo("==========Number(orderInfo.POS_ODDTL_T[j].DC_AMT == > " + Number(orderInfo.POS_ODDTL_T[j].DC_AMT));
									
									
									// 원래금액 - 할인된 금액 (위에 여러 할인금액이 더해진 값(dc_amt)을 마이너스한다)
									orderInfo.POS_ODDTL_T[j].DCM_SALE_AMT = Number(orderInfo.POS_ODDTL_T[j].SALE_AMT) - Number(orderInfo.POS_ODDTL_T[j].DC_AMT);
									vaIdx[vaIdx.length] = j;  // 차감된 메인메뉴의 인덱스를 vaIdx배열에 담는다.
    							}
    							
    							
								for(var ss=0; ss<vsPointSideCnt; ss++){
									util.logInfo("***** 할인 사용 후 금액 재계산 사이드메뉴 시작 *****");
									var j = this.POINT_SALE_LIST_SIDE[ss].DTL_IDX; // pos_oddtl_t와 메인메뉴와 매칭되는 인덱스
									var s = this.POINT_SALE_LIST_SIDE[ss].SIDE_DTL_IDX; // pos_oddtl_t의 사이드LIST와 매칭되는 인덱스								
									util.logInfo("***** 할인 사용 후 금액 재계산 사이드 for문 j ==> " + j + ", s ==> " + s);
									util.logInfo("==========this.POINT_SALE_LIST_SIDE[ss].SIDE_DCM_SALE_UPRC == > " + this.POINT_SALE_LIST_SIDE[ss].SIDE_DCM_SALE_UPRC);
									// SIDE_DCM_SALE_UPRC : 사이드 메뉴 금액에서 제휴할인 전에 할인받은 내역을 차감한 금액 (마일리지, 스탬프 등) * 메인메뉴 수량 / 제휴할인을 위한 총금액 * 제휴할인 받은금액
									var vnDcAmt = Number(this.POINT_SALE_LIST_SIDE[ss].SIDE_DCM_SALE_UPRC) * (Number(this.APPR_AMT) / Number(this.ORIGIN_APPR_AMT)) / Number(this.APPR_AMT) * Number(vsJcdDcAmt); 
        							vnDcAmt = Math.floor(vnDcAmt);
        							util.logInfo("==========vnDcAmt SIDE for == > " + vnDcAmt);
        							vnDcTotAmt = vnDcTotAmt + parseInt(vnDcAmt);
        							
									if(ss==vsPointSideCnt-1){ // 마지막 제휴할인 상품일 때 
										util.logInfo("***** 마지막 제휴할인 상품일 때 *****");
										var vnRemainAmt = Number(vsJcdDcAmt) - Number(vnDcTotAmt); // 전체할인금액 - 상품별로 절삭하면서 더한 할인금액  (짜투리금액)
										util.logInfo("***** 마지막 제휴할인 상품일 때 *****");
										// 비율로 계산하면서 절삭하고 남은 금액을 마지막 상품에 더해서 넣어준다.
    									// 할인된 금액을 넣는다. 지금은 한개의 할인만 존재하지만, 추후에 여러개의 할인이 있는 경우에 할인금액을 계속 더하여 넣는다.
										// 할인받은 금액(기존에 받았던 할인금액) + 현재 할인 받은 금액 + 절삭하고 남은 금액
										util.logInfo("==========orderInfo.POINT_SALE_LIST_SIDE[ss].SIDE_DC_AMT == > " + this.POINT_SALE_LIST_SIDE[ss].SIDE_DC_AMT);
										util.logInfo("==========Number(vnDcAmt) SIDE for== > " + Number(vnDcAmt));
										util.logInfo("==========vnRemainAmt SIDE for == > " + vnRemainAmt);
    									orderInfo.POS_ODDTL_T[j].사이드_LIST[s].SIDE_DC_AMT = Number(this.POINT_SALE_LIST_SIDE[ss].SIDE_DC_AMT) + Number(vnDcAmt) + vnRemainAmt;
    									orderInfo.POS_ODDTL_T[j].사이드_LIST[s].SIDE_DC_AMT_JCD = Number(vnDcAmt) + vnRemainAmt;
									}else{
										util.logInfo("***** 제휴할인 마지막 아닌 상품일 때 *****");
    									// 할인된 금액을 넣는다. 지금은 한개의 할인만 존재하지만, 추후에 여러개의 할인이 있는 경우에 할인금액을 계속 더하여 넣는다.
										util.logInfo("==========orderInfo.POINT_SALE_LIST_SIDE[ss].SIDE_DC_AMT== > " + this.POINT_SALE_LIST_SIDE[ss].SIDE_DC_AMT);
										util.logInfo("==========Number(vnDcAmt) == > " + Number(vnDcAmt));
    									//orderInfo.POS_ODDTL_T[j].DC_AMT = Number(orderInfo.POS_ODDTL_T[j].DC_AMT) + Number(vnDcAmt);
										util.logInfo("==========JSON.stringify(orderInfo.POS_ODDTL_T[j]) SIDE for == > " + JSON.stringify(orderInfo.POS_ODDTL_T[j]));
										orderInfo.POS_ODDTL_T[j].사이드_LIST[s].SIDE_DC_AMT = Number(this.POINT_SALE_LIST_SIDE[ss].SIDE_DC_AMT) + Number(vnDcAmt); 
										orderInfo.POS_ODDTL_T[j].사이드_LIST[s].SIDE_DC_AMT_JCD = Number(vnDcAmt);
									}
									util.logInfo("==========Number(orderInfo.POS_ODDTL_T[j].SALE_AMT) == > " + Number(orderInfo.POS_ODDTL_T[j].SALE_AMT));
									util.logInfo("==========Number(orderInfo.POS_ODDTL_T[j].DC_AMT == > " + Number(orderInfo.POS_ODDTL_T[j].DC_AMT));
									util.logInfo("==========Number(orderInfo.POS_ODDTL_T[j].사이드_LIST[s].SIDE_DC_AMT) == > " + Number(orderInfo.POS_ODDTL_T[j].사이드_LIST[s].SIDE_DC_AMT));
									
									if(vaIdx.indexOf(j) > -1){ // vaIdx 배열에는 메인메뉴가 차감될때마다 차감된 메인메뉴의 인덱스를 담는다.
										// 메인메뉴 상품에 금액이 이미 차감되어있다면, DCM_SALE_AMT에 사이드할인 금액을 추가로 마이너스한다)
										orderInfo.POS_ODDTL_T[j].DCM_SALE_AMT = Number(orderInfo.POS_ODDTL_T[j].DCM_SALE_AMT) - Number(orderInfo.POS_ODDTL_T[j].사이드_LIST[s].SIDE_DC_AMT);
									}else{
										// 메인메뉴 상품에 금액이 한번도 차감되어지지 않았다면, 원래금액 - 할인된 금액 - 사이드 할인 금액 (위에 여러 할인금액이 더해진 값(dc_amt)을 마이너스한다)
										orderInfo.POS_ODDTL_T[j].DCM_SALE_AMT = Number(orderInfo.POS_ODDTL_T[j].SALE_AMT) - Number(orderInfo.POS_ODDTL_T[j].DC_AMT) - Number(orderInfo.POS_ODDTL_T[j].사이드_LIST[s].SIDE_DC_AMT);
									}
									vaIdx[vaIdx.length] = j; // 차감된 메인메뉴의 인덱스를 vaIdx배열에 담는다.
									    
								}
									
        						
        						
        						
        						if(!orderInfo.POS_ODHDR_T.TOT_DC_AMT){ // 객체가 없는 경우에 +를 하면 NaN으로 변경되어, 값이 있는 경우에만 +하도록 한다.
        							orderInfo.POS_ODHDR_T.TOT_DC_AMT = Number(vsJcdDcAmt); // 포인트 할인 금액을 헤더 TOT_DC_AMT 추가로 더해서 넣어준다. (할인에 대한 총 금액)
        						}else{
        							orderInfo.POS_ODHDR_T.TOT_DC_AMT = Number(orderInfo.POS_ODHDR_T.TOT_DC_AMT) + Number(vsJcdDcAmt); // 포인트 할인 금액을 헤더 TOT_DC_AMT 추가로 더해서 넣어준다. (할인에 대한 총 금액)
        						}
        						
        						if(orderInfo.POS_ODHDR_T.DCM_SALE_AMT != undefined && orderInfo.POS_ODHDR_T.DCM_SALE_AMT != "0"){
        							orderInfo.POS_ODHDR_T.DCM_SALE_AMT = Number(orderInfo.POS_ODHDR_T.DCM_SALE_AMT) - Number(vsJcdDcAmt); // 실매출금액이 존재한다면  DCM_SALE_AMT - 포인트 할인 금액을 헤더 DCM_SALE_AMT 넣어준다.
        						}else{
        							orderInfo.POS_ODHDR_T.DCM_SALE_AMT = Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT) - Number(vsJcdDcAmt); // 실매출금액이 없다면 원금액 - 포인트 할인 금액을 헤더 DCM_SALE_AMT 넣어준다.
        						}
        						orderInfo.POS_ODHDR_T.DC_PCD_AMT = vsJcdDcAmt; // 포인트 할인 금액을 헤더 TOT_DC_AMT를 넣어준다.(제휴 할인에 대한 금액)
        						util.logInfo("*****allianceDiscount fnPointCallbackResultA TOT_DC_AMT == > " + orderInfo.POS_ODHDR_T.TOT_DC_AMT);
        						util.logInfo("*****allianceDiscount fnPointCallbackResultA DC_PCD_AMT == > " + vsJcdDcAmt);
        						
        						// 부가세를 계산한다.
        						util.fnTaxCalcul(this.taxEnvVal); // 부가세 계산 함수.
        						
                            	orderInfo.POS_ODHDR_T.JCD_CARD_AMT = "0";
        						
        						// POS_ODJCD_T 테이블에 저장하기 위한 값 저장.
        						this.POS_ODJCD_T.SHOP_CD = gShopCd; // 매장코드
        						this.POS_ODJCD_T.SALE_DATE = saleDate	//영업일자
        						this.POS_ODJCD_T.ORDER_NO = "";	// 주문번호
        						this.POS_ODJCD_T.LINE_NO = "";	// 라인번호
        						this.POS_ODJCD_T.SEQ_NO	= ""; // 라인일련번호
        						this.POS_ODJCD_T.POS_NO	 = gPosNo; //포스번호
        						this.POS_ODJCD_T.SALE_YN = "Y";	//판매여부(Y:판매 N:반품(취소))
        						this.POS_ODJCD_T.JCD_CARD_NO = vsResult.Data["카드번호"]; // 제휴카드번호
        						this.POS_ODJCD_T.JCD_CD	= this.selJcdCd //제휴할인코드
        						this.POS_ODJCD_T.JCD_TYPE_FG = this.JCD_TYPE_FG; //제휴카드유형구분 ( CCD_CODEM_T : 035 ) 1:OCBS 2:SKT 3:KTF 4:LGT
        						this.POS_ODJCD_T.JCD_PROC_FG = "0"; // 제휴카드처리구분 ( CCD_CODEM_T : 036 ) 0:할인 1:적립 2:사용 3:할인취소 4:적립취소 5:사용취소 9:조회
        						this.POS_ODJCD_T.APPR_LOG_NO = ""; // 승인로그번호 ( 결제내역 저장하는 부분에 채번하는 부분 있음. 가져다 쓰면됨.
        						this.POS_ODJCD_T.APPR_AMT = this.APPR_AMT; // 승인금액
        						
        						var vsJcdOcc = 0;
        						if(!!vsResult.Data["적립포인트"]){
        							vsJcdOcc = vsResult.Data["적립포인트"];
        						}
        						var vnJcdAvl = 0;
        						if(!!vsResult.Data["가용포인트"]){
        							vnJcdAvl = vsResult.Data["가용포인트"];
        						}
        						var vnJcdDcAmt = 0;
        						if(!!vsResult.Data["포인트할인금액"]){
        							vnJcdDcAmt = vsResult.Data["포인트할인금액"];
        						}
        						var vnJcdRem = 0;
        						if(!!vsResult.Data["포인트할인후금액"]){
        							vnJcdRem = vsResult.Data["포인트할인후금액"];
        						}
        						
        						this.POS_ODJCD_T.JCD_DC_AMT = vnJcdDcAmt; //제휴카드-할인금액   
        						this.POS_ODJCD_T.JCD_OCC_POINT = vsJcdOcc //제휴카드-발생포인트        						
        						this.POS_ODJCD_T.JCD_AVL_POINT = vnJcdAvl; //제휴카드-가용포인트
        						this.POS_ODJCD_T.JCD_USE_POINT = vnJcdDcAmt; //제휴카드-사용포인트
        						this.POS_ODJCD_T.JCD_REM_POINT = vnJcdRem; //제휴카드-잔여포인트        						
        						this.POS_ODJCD_T.EMP_NO = loginEmpNo; //판매원번호 
        						this.POS_ODJCD_T.JCD_PAY_FG = "01"; // 적립거래구분 01:현금 02:신용카드 03:직불카드 04:자사카드
        						this.POS_ODJCD_T.VAN_TERM_NO = BIZ_CLS_SINGLE_CAT_ID // 밴사터미널번호
        						this.POS_ODJCD_T.APPR_NO = vsResult.Data["승인번호"];
        						var vsCurDt = moment().format("YYYYMMDDHHmmss");
        						var vsCurDtYY = vsCurDt.substr(0,2); // 현재 년도 앞 2자리
        						var vsApproveDt = vsCurDtYY + vsResult.Data["승인일자"];
        						var vsApprTime = vsResult.Data["거래일시"].substr(6,6);
        						this.POS_ODJCD_T.APPR_DATE = vsApproveDt; // 승인일자
        						this.POS_ODJCD_T.APPR_TIME = vsApprTime; // 승인시간
        						this.POS_ODJCD_T.APPR_MSG = vsResult.Data["응답메세지1"] + " " + vsResult.Data["응답메세지2"];
        						this.POS_ODJCD_T.BROAD_MSG = vsResult.Data["알림메세지1"] + " " + vsResult.Data["알림메세지2"] 
        						                           + " " + vsResult.Data["알림메세지3"] + " "+ vsResult.Data["알림메세지4"];
        						this.POS_ODJCD_T.CRDCP_TERM_NO = vsResult.Data["가맹점번호"];
        						this.POS_ODJCD_T.TRADE_SERIAL_NUM = vsResult.Data["거래일련번호"];
        						this.POS_ODJCD_T.CNMK_CD = vsResult.Data["거래일련번호"]; // 거래일련번호는 할인취소할 때 필요한데, 컬럼이 명확히 없어서 CNMK_CD에 저장하여 취소시에 사용하도록 한다.
        						
        						this.POS_ODJCD_T.APPR_FULL_TIME = vsResult.Data["거래일시"];        						
        					     
        						this.POS_ODJCD_T.DEAL_NO = vsResult.Data["거래일련번호"];
        						this.POS_ODJCD_T.JCD_TYPE_FG_NM = this.jcdTypeFgNm;
        						
        						orderInfo.POS_ODJCD_T = this.POS_ODJCD_T;
        						
        						util.logInfo("*****allianceDiscount fnPointCallbackResultA JCD_DC_AMT == > " + this.POS_ODJCD_T.APPR_MSG);
        						util.logInfo("*****allianceDiscount fnPointCallbackResultA BROAD_MSG == > " + this.POS_ODJCD_T.BROAD_MSG);
        						util.logInfo("*****allianceDiscount fnPointCallbackResultA TRADE_SERIAL_NUM == > " + this.POS_ODJCD_T.TRADE_SERIAL_NUM);
        						util.logInfo("*****allianceDiscount fnPointCallbackResultA APPR_FULL_TIME == > " + this.POS_ODJCD_T.APPR_FULL_TIME);
        						
        						util.logInfo(" ***** allianceDiscount fnNetCancelCommand 시작 전 *****");
        						// 제휴할인 승인 후 NetCancel파일 생성을 먼저하기 때문에, NetCancel 데몬이 중지 되도록 함수를 수행한다.
        						util.fnNetCancelCommand(0, 10);        						        					
        						
        						// 결제수단 선택화면으로 이동한다.
        						this.$router.push({name: 'paymentChoiceView'});
        					}else{
        						this.useMileYn = "N";
        						util.logError("*****allianceDiscount fnPointCallbackResultA NO APPROVE*****");
        						var dataObj = {
          							  button1Show : false
          							, button1Name : ""
          							, button1Func : ""
          							, button2Show : true
          							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
          							, button2Func : ""
          							, message     : util.languageObjReturn(langCode,  'failMile') + "[" + vsResult.Data["응답메세지1"] + vsResult.Data["응답메세지2"] + "]" // [ 포인트 사용에 실패했습니다. ]
          						};
            					eventBus.$emit('alertPopupIndex', dataObj);
            					return false;
        					}
        					
        				}else{
        				}
        			} catch (e) {
        				this.useMileYn = "N";
        				util.logError("allianceDiscount fnPointCallbackResultA catch e ==> " + e.toString());
        				var dataObj = {
    							  button1Show : false
    							, button1Name : ""
    							, button1Func : ""
    							, button2Show : true
    							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
    							, button2Func : ""
    							, message     : util.languageObjReturn(langCode,  'failMile') // [ 포인트 사용에 실패했습니다. ]
    						};
      					eventBus.$emit('alertPopupIndex', dataObj);
        			}	
        		}
        		// 4자리마다 "-"를 붙인다.
        		, fnSplitNo : function(paNo){ 
        			var vsCnt = paNo.length / 4; // 4자리로 나눈다.
        			vsCnt = parseInt(vsCnt); // 양의정수로 변환
        			if(vsCnt == 0){
        				return paNo;
        			}
        			var rtnNo = "";
        			// 4자리 마다 "-"를 붙이기 위해 4자리로 자른 수만큼 for문
        			for(var i=0;i<vsCnt;i++){
        				var vnIdxS ="";
        					vnIdxS = (i*4);
        				var vsNo = paNo.substr(vnIdxS,4);
        				rtnNo += vsNo + "-";
        				
        				// 만약 마지막 인덱스일 때, 4자리가 안되서 나머있는 No를 붙인다.
        				if(i == vsCnt-1){
        					var vsEtcNoAddCnt  = vnIdxS + 4;
        					var vsEtcNo = paNo.substring(vsEtcNoAddCnt);
        					if(!vsEtcNo){ // 여분의 NO가 없고 4의배수로 딱 떨어지면 마지막에 "-"를 제거한다.
        						rtnNo = rtnNo.slice(0, -1);
        					}else{ // 여분의 NO가 있다면 뒤에 붙인다.
        						rtnNo += paNo.substring(vsEtcNoAddCnt);
        					}
        				}
        			}
        			return rtnNo;        			
        		}
        		, fnGetJcdType : function(){ // 현재 선택된 제휴사르 jcdCd로 포인트사의 코드를 조회한다.
        			util.logInfo("*****allianceDiscount fnGetJcdType Start*****");
        			var resultList = this.alliCompanyList.filter (p => p.JCD_CD == this.selJcdCd );
        			var vsResultType = resultList[0].JCD_TYPE_FG;
        			this.JCD_TYPE_FG = vsResultType;
        			var resultJcdType = util.fnGetJcdType(vsResultType);
        			util.logInfo("*****allianceDiscount fnGetJcdType resultJcdType == >> " + resultJcdType);
       				this.jcdTypeFgNm = resultJcdType;
        			
        		}
        		, fnDirectBtn : function(){ // 직접입력 버튼을 클릭하면 키패드를 활성화 한다.
        			util.logInfo("*****allianceDiscount fnDirectBtn Start*****");
        			var result = nativeApp.functionCallSync(["FDK_CreditCancel"]); // 카드 리더기 대기 취소
        			this.fnStopBarCodeReader(); // 카메라 구동 스탑.
        			this.barcodeNo = ""; // 바코드 번호 제거
        			this.remainMile = 0; // 잔여포인트 0원 처리.
        			this.directYn = "Y"; // 직접입력 Y로 수정 (직접입력 화면여부)
        			$("#alliDirectBtnDiv").hide();
        			$("#alliImgDiv").hide();
        			$("#alliNumbPadDiv").show();
        		}, fnCompanyChg : function(){ // 제휴사를 변경한 경우에, 해당 제휴사코드로 리더기 및 바코드를 재 시작한다.
        			util.logInfo("*****allianceDiscount fnCompanyChg Start*****");
        			try{
        				var result = nativeApp.functionCallSync(["FDK_CreditCancel"]); // 카드 리더기 대기 취소
            			this.fnStopBarCodeReader(); // 카메라 구동 스탑.
            			this.remainMile = "0"; // 포인트 금액 초기화.
            			this.barcodeNo = ""; // 바코드 번호 초기화
            			this.readAllStart(); // 리더기 대기, 카메라 구동 시작
            			util.logInfo("*****allianceDiscount fnCompanyChg END*****");
        			}catch(e){
        				util.logInfo("*****allianceDiscount fnCompanyChg Catch e ==>  "+ e.toString());
        			}
        			
        		}
        		, creditApproveCallbackListener : function(data) {
					util.logInfo('*** allianceDiscount creditApproveCallbackListener START ***');
					try {
						var cbCode = "9";
						var cbData = "";
	
						
						try {
							var jsonData = JSON.parse(data);
	
							cbCode = jsonData["Code"];
							cbData = jsonData["Data"];
						} catch (e) {
						}
						util.logInfo('*** cbCode / Data ***' + cbCode + " / " + cbData);
						$('#divDebug').html("<p>" + cbCode + " : " + cbData + "</p>");
							
								
						if (cbCode == "0") { // 결재중입니다.
							this.readMsg = util.languageObjReturn(langCode, 'pointSearching'); // 포인트를 조회하고 있습니다.
							 		 
							// 결제가 진행중입니다. 잠시만 기다려주세요. 음성추가.
//	                    	var paramSrc = "./audio/22.mp3";
	         			    // string으로 보내면 해당 src한건 수행, 배열로 보내면 배열만큼 연속적으로 음성안내
							// 수행 (한글src만 보내면됨)	         			    
//	                    	util.fnAudioPlay(paramSrc); // 음성안내 공통함수 호출
						} else if (cbCode == "1") { // [카드인식요류] 카드를 다시 읽혀 주세요.
							$('#creditMsg1').html(util.languageObjReturn(langCode, 'msg_callback_9')); // IC 카드를 확인 후, 다시 읽혀주세요.
						} else if (cbCode == "2") { // Chip카드입니다. IC카드를 삽입해주세요
//							$('#creditMsg1').html(util.languageObjReturn(langCode, 'msg_callback_7'));
//							$('#creditMsg2').html(util.languageObjReturn(langCode, 'msg_callback_8'));
						} else if (cbCode == "3") { // 서명이 너무 짧습니다. 다시 서명해 주세요.
							// showMessage(cbData, false, false);
						} else if (cbCode == "4") { // exception
//							$('#creditMsg1').html(util.languageObjReturn(langCode, 'msg_callback_5')); // 처리 실패했습니다.
						} else if (cbCode == "5") { // Chip카드입니다. IC카드를 삽입해주세요
							
							this.readMsg = util.languageObjReturn(langCode, 'pointRead'); //바코드 인식 및 카드를 읽혀주세요.
							
							// 카드를 삽입해주세요. 음성추가.
//	                    	var paramSrc = "./audio/1.mp3";
	         			    // string으로 보내면 해당 src한건 수행, 배열로 보내면 배열만큼 연속적으로 음성안내
							// 수행 (한글src만 보내면됨)
//	                    	util.fnAudioPlay(paramSrc); // 음성안내 공통함수 호출
							
						} else if (cbCode == "9") { // 처리 완료
//							this.readMsg = util.languageObjReturn(langCode, 'pointSearching'); // 포인트를 조회하고 있습니다.							
						} else {
							
						}
					} catch (e) {
						util.logError("[creditApproveCallbackListener] allianceDiscount Exception : " + e.message);						 	
						//this.showMessage("[creditApproveCallbackListener] Exception: " + e.message, false, false);
					}
				}
        		
	        }
	    };
	    return returnTemplate;
	},
	
	/**************************************************************
	 * 카드 승인/승인거절에 대한 Callback 처리
	 **************************************************************/
	this.deviceApproveOnsuccessCallback = function(data, creditData , appType , reCallFn ) {
//		waitingService.timeoutHnd = window.setTimeout(waitingService.OnTimeoutReached, waitingService.logouTimeInterval); // 결제 완료 후 대기화면 돌아가기를 시작한다.
		// $(".newUserPayIng").hide();
		util.logInfo("______________ (상품결제) PAYMENT APP RESPONSE(deviceApproveOnsuccessCallback) _______________");
		util.logDebug("<<<===== CARD PAYMENT RESULT DATA =====>>>\n " + JSON.stringify(data));
		
		waitingService.ResetLogOutTimer(); // 대기영상으로 돌아가는 시간 초기화.
		
		// let payResult = data[0].value[0];
		// util.logDebug("<<<===== payResult =====>>> "+ payResult);
		let resultParse = ""
		if( util.isTizen() == true) {
			//resultParse = JSON.parse(data);	
			resultParse = JSON.parse(data[0].value[0]);
		} else {
			resultParse = JSON.parse(data[0].value[0]);
		}
		
		util.logDebug("<<<===== resultParse =====>>> "+ resultParse);
		// alert($("#myVideoSrc").attr("src"));
		
		
		/* 2020-11-27 백종기
		 * 임우성 부장님과 협의 결과 return의 메시지 종류는, 
		 * 1. 결제 BACK했을 때 payResult = "CANCEL"이 리턴됨
		 * 2. 카드 결제시에 승인거절 및 통신장애등의 오류형태는 JSON형태의 메시지로 리턴됨
		 * 따라서 취소일 때만 그대로 CANCEL 자체로 리턴되고, 나머지는 JSON형태이기 때문에 아래와 같이 분기함.
		 */
		if(resultParse["Status"] == "APPROVE" ){
			util.logInfo("***** deviceApproveOnsuccessCallback status :: APPROVE ***** ");			
//			if ( util.byteLen( creditData.CardNo ) != 0 )  {
//				try {
//					b2bbarcode.stopScanBarcode();
//				} catch (e) {
//					util.logError('## error barcode camera 바코드 승인났는데 카메라 안꺼짐.');
//					util.logError(e);
//				}
//			}

		   /*********************************************************
		    * 신용카드 결제 후, 매핑 값 넘긴다.
		    *********************************************************/
		   paymentChoiceService.returnDevicePaymentInfo( resultParse , creditData , appType );

		 //단독 사업자.
		   if(  BIZ_CLS_TYPE == '0' ){
			   // 매핑된 값을 DB저장
			   util.logInfo("***** 매핑된 값을 DB저장 ***** ");
				orderPayRegService.orderPayReg();//차후 CAT_ID 가 복수개일 경우 처리방식 수정.
//				   this.soundPayed();  //사운드 처리.			   
		   } else  {
			   //복수사업자.
			   ++orderInfo.BMC_WORKING;
			   if ( orderInfo.BMC_WORKING  == orderInfo.CORNER_LIST.length ) {
				util.logInfo("***** 매핑된 값을 DB저장 ***** ");
				   orderPayRegService.orderPayReg();
//					   this.soundPayed();  //사운드 처리.
			   } else {
				   paymentChoiceService.multiBizAppr( orderInfo.BMC_WORKING );
			   }
		   }
		   return;
		} else{
   			util.logInfo("<<<===== PAYMENT STATUS ETC =====>>>");
			// TODO 복수사업자의 경우 1건이 아닐경우 망취소 처리한다. 2020.11.09
   			// util.fnUpdatePayInfoFile 망취소
			let dataObj = {};
			dataObj.button2Show = true;
			dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
//			dataObj.button2Func = function(){
//				router.push({ path : '/paymentChoiceView' });
//			};
			if ( util.byteLen( creditData.CardNo ) != 0 )  { // 카드 번호가 없으면 신용카드, 있으면 간편결제
				$("#barCodePop").show(); // 에러시에는 바토드 직접입력 버튼 보이게한다.
			}
			
			if(resultParse["Status"] == "CANCEL"){
				dataObj.message = util.languageObjReturn(langCode, 'noticeCanceled') + "\n [" + resultParse["응답메세지2"] + "]"; // 취소되었습니다.
				
				// payment 호출 전에 결제수단 버튼을 안보이게한다.
				$(".mileage").show(); // 마일리지
				$(".creditcard").show(); // 신용카드
				$(".simplepay").show(); // 간편결제
				
				
				// 뒤로가기(cancel의 에러가 나면 메뉴선택 화면으로 이동한다)
				dataObj.button2Func = function(){
					this.$router.push({name: 'paymentChoiceView'})
//					router.push({path: '/paymentChoiceView'});
				};
				
			}else{
				var vsMsg1 = "";
				var vsMsg2 = "";
				if(!!resultParse["응답메세지1"]){
					vsMsg1 = resultParse["응답메세지1"];
				}
				if(!!resultParse["응답메세지2"]){
					vsMsg2 = resultParse["응답메세지2"];
				}
				var returnMsg = "";
				if(!!vsMsg1 || !!vsMsg2){
					returnMsg = " [" + vsMsg1 + vsMsg2 + "]";
				}
				
				dataObj.message = util.languageObjReturn(langCode, 'failMsg') + returnMsg; // 정상처리 되지 않았습니다. + 리턴 메시지
				
				// 망취소 처리. 망취소 파일이 생성되는 경우는 approve인 경우만 이라고 함.
				this.multiBizNetCancel();
				
				// 뒤로가기(cancel이 아닌경우의 에러가 나면 메뉴선택 화면으로 이동한다)
				dataObj.button2Func = function(){
					router.push({path: '/menu'});
				};
			}
			eventBus.$emit('alertPopupIndex', dataObj);
			
			if(resultParse["Status"] == "CANCEL"){
				/*****************************************************************
				 * 단독사업자는 망취소할 할 필요없다.
				 * 복수사업자일 경우 CORNER_LIST 가 1개가 아닐경우 할 필요가 없다.
				 * 복수사업자의 경우 1건이 아닐경우 망취소 처리한다. 2020.11.09
				 *****************************************************************/
				if(  BIZ_CLS_TYPE == '0' || orderInfo.CORNER_LIST.length == 1 ){
					return;
				}
			}
		}
		
	},
	
	// 카드 결제 승인
	this.fnCouponApproveRequestExe = function(pay, appType = {}){		
		util.logInfo("______________ (상품결제) 쿠폰 승인정보 세팅 START _______________");
		//console.log("카드 승인 요청...!!!");
		//console.log('카드 승인 요청 pay >> ' + pay);

		let appControl = null;
		let successCallback = null;
		let errorCallback = null;
		let appControlReplyCallback = null;
		let odh = orderInfo.POS_ODHDR_T;// 주문 HEADER 정보
		let catid= "";
		let creditData = {};

		if ( BIZ_CLS_TYPE == '0') {			
			// 단독사업자
			catid = BIZ_CLS_SINGLE_CAT_ID ;
        	creditData = {
      			  "CatId"             : catid  //"10069371"
      			, "Pay"               : pay.pay    +""           /** 거래 금액         **/
      			, "Tax"               : pay.tax    +""           /** 부가세            **/
      			, "InstallmentMonths" : "00"                     /** 할부 거래         **/
      			, "ApproveNo"         : ""                       /** 원거래 승인번호   **/
      			, "ApproveDate"       : ""                       /** 원거래 일자       **/
      			, "CardNo"            : ""               		 /** 카드번호          **/
      			, "Type"              : ""        /** 결재 구분 (BC-QR : 0, 카카오 : 1, 제로페이 : 2) **/
      			, "MechantTempInfo"   : ""                       /** 가맹점 임의정보   **/
      			, "TaxSaleAmt"        : pay.VatSaleAmt       +"" /** 과세 대상금액     **/
      			, "NonTaxSaleAmt"     : pay.NonTaxSaleAmt     +"" /** 비과세 대상금액   **/
      			, "UserServiceCode"   : ""                       /** 사용자 코드       **/
      			, "UserServiceData"   : ""                       /** 사용자 데이터     **/
			};

		} else {			
			// 복수사업자
			util.logInfo('복수사업자...');
			catid = pay.catId;
        	creditData = {
        			  "CatId"             : catid  //"10069371"
        			, "Pay"               : pay.pay    +""           /** 거래 금액         **/
        			, "Tax"               : pay.tax    +""           /** 부가세            **/
        			, "InstallmentMonths" : "00"                     /** 할부 거래         **/
        			, "ApproveNo"         : ""                       /** 원거래 승인번호   **/
        			, "ApproveDate"       : ""                       /** 원거래 일자       **/
        			, "CardNo"            : ""               		 /** 카드번호          **/
        			, "Type"              : ""        /** 결재 구분 (BC-QR : 0, 카카오 : 1, 제로페이 : 2) **/
        			, "MechantTempInfo"   : ""                       /** 가맹점 임의정보   **/
        			, "TaxSaleAmt"        : pay.VatSaleAmt       +"" /** 과세 대상금액     **/
        			, "NonTaxSaleAmt"     : pay.NonTaxSaleAmt     +"" /** 비과세 대상금액   **/
        			, "UserServiceCode"   : ""                       /** 사용자 코드       **/
        			, "UserServiceData"   : ""                       /** 사용자 데이터     **/
  			};
		}

        try {        	
		    creditData["Language"     ] =  langCode ;
        	util.logInfo('카드 승인요청 데이터 : ' + JSON.stringify(creditData));
        	util.logInfo("______________ (상품결제) 쿠폰 승인정보 세팅 END _______________");
        	
        	paymentChoiceView.couponPaymentApprove( creditData , appType);
        } catch (error)  {
        	// TODO 어떻게...???
        	console.error(error);
        }

    },
    
    // 쿠폰결제 승인처리 데이터 
	this.couponPaymentApprove = function(creditData , appType) {
		try {
			//validWindowTest();
			//Window
			let nowTime = moment().format("YYYYMMDDHHmmss");
			let x = {
					"DDCFlag"         : "D",
					"OCB결과코드"     : "",
					"OCB고객명"       : "",
					"Status"          : "APPROVE",
					"가맹점명"        : "포스주문매장",
					"가맹점번호"      : "",
					"가맹점임의정보"  : "",
					"가맹점전화번호"  : "",
					"가맹점주소"      : "",
					"가용포인트"      : "          ",
					"거래금액"        :  creditData.Pay ,
					"거래시간"        : nowTime.substring(2),
					"거래일련번호"    : "",
					"거래일시"        : nowTime.substring(2),
					"누적포인트"      : "          ",
					"대표자명"        : "",
					"매입사명"        : "",
					"매입사코드"      : "",
					"무서명금액"      : "",
					"발급사명"        : "기타",
					"발급사코드"      : "99",
					"부가세"          : creditData.Tax + "",
					"사업자번호"      : "",
					"승인번호"        : "",
					"승인일자"        : nowTime.substring(2, 8) ,
					"알림메세지"      : "",
					"알림메세지1"     : "",
					"알림메세지2"     : "",
					"알림메세지3"     : "",
					"알림메세지4"     : "",
					"응답메세지1"     : "",
					"응답메세지2"     : "",
					"적립포인트"      : "",
					"전표번호"        : "",
					"체크카드구분"    : "",
					"카드명"          : "",
					"카드번호"        : "",
					"카드잔액"        : "",
					"프린터출력유무"  : "O",
					"할부"            : "",
					"할인금액"        : "",
					"할인후금액"      : ""
			}
			//appType.trTypeKey = '02';//BC QR
			//appType.trTypeVal = '1';//카카오
			//appType   = {};//신용카드
			
			let data =  [ {
				"key" : "text",
				"value" : [JSON.stringify(x) ]
			} ]
			;
			paymentChoiceView.couponApproveOnsuccessCallback(data, creditData, appType);  
		} catch (e) {
			console.error(e);
		}
	},
    
    /**************************************************************
	 * 쿠폰 승인/승인거절에 대한 Callback 처리
	 **************************************************************/
	this.couponApproveOnsuccessCallback = function(data, creditData, appType) {
		util.logInfo("______________ (상품결제) PAYMENT APP RESPONSE(couponApproveOnsuccessCallback) _______________");
		util.logDebug("<<<===== CARD PAYMENT RESULT DATA =====>>>\n " + JSON.stringify(data));
		
		waitingService.ResetLogOutTimer(); // 대기영상으로 돌아가는 시간 초기화.
		
		let resultParse = ""
		if( util.isTizen() == true) {
			//resultParse = JSON.parse(data);	
			resultParse = JSON.parse(data[0].value[0]);
		} else {
			resultParse = JSON.parse(data[0].value[0]);
		}
		
		util.logDebug("<<<===== resultParse =====>>> "+ resultParse);

		if(resultParse["Status"] == "APPROVE" ){
			util.logInfo("***** deviceApproveOnsuccessCallback status :: APPROVE ***** ");			

		   /*********************************************************
		    * 신용카드 결제 후, 매핑 값 넘긴다.
		    *********************************************************/
		   paymentChoiceService.returnPayInfoForCoupon( resultParse , creditData , appType );

		 //단독 사업자.
		   if(  BIZ_CLS_TYPE == '0' ){
			   // 매핑된 값을 DB저장
			   orderPayRegService.orderPayReg();//차후 CAT_ID 가 복수개일 경우 처리방식 수정.
		   } else  {
			   //복수사업자.
			   ++orderInfo.BMC_WORKING;
			   if ( orderInfo.BMC_WORKING  == orderInfo.CORNER_LIST.length ) {
				   orderPayRegService.orderPayReg();
			   } else {
				   paymentChoiceService.multiBizAppr( orderInfo.BMC_WORKING );
			   }
		   }
		   return;
		} else{
   			util.logInfo("<<<===== PAYMENT STATUS ETC =====>>>");
			let dataObj = {};
			dataObj.button2Show = true;
			dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
			
			if ( util.byteLen( creditData.CardNo ) != 0 )  { // 카드 번호가 없으면 신용카드, 있으면 간편결제
				$("#barCodePop").show(); // 에러시에는 바토드 직접입력 버튼 보이게한다.
			}
			
			if(resultParse["Status"] == "CANCEL"){
				dataObj.message = util.languageObjReturn(langCode, 'noticeCanceled') + "\n [" + resultParse["응답메세지2"] + "]"; // 취소되었습니다.
				
				// 뒤로가기(cancel의 에러가 나면 메뉴선택 화면으로 이동한다)
				dataObj.button2Func = function(){
					this.$router.push({name: 'paymentChoiceView'})
				};
				
			}else{
				var vsMsg1 = "";
				var vsMsg2 = "";
				if(!!resultParse["응답메세지1"]){
					vsMsg1 = resultParse["응답메세지1"];
				}
				if(!!resultParse["응답메세지2"]){
					vsMsg2 = resultParse["응답메세지2"];
				}
				var returnMsg = "";
				if(!!vsMsg1 || !!vsMsg2){
					returnMsg = " [" + vsMsg1 + vsMsg2 + "]";
				}
				
				dataObj.message = util.languageObjReturn(langCode, 'failMsg') + returnMsg; // 정상처리 되지 않았습니다. + 리턴 메시지
				
				// 뒤로가기(cancel이 아닌경우의 에러가 나면 메뉴선택 화면으로 이동한다)
				dataObj.button2Func = function(){
					router.push({path: '/start'});
				};
			}
			eventBus.$emit('alertPopupIndex', dataObj);
			
		}
		
	},
	
	// mp포인트 화면
    this.fnGetMpPoint = function(){    	
        var returnTemplate = { template: '#mpPoint'
        	, created : function() {
        		util.logInfo("_____mpPoint created Start_____");
        		// BJK GetEnvXmlPosENV의 값이 없는 경우 디폴트로 선언한 0이 분기 되도록 try catch 적용.
            	try {	            	
	            	this.txtBarcodeNo = util.languageObjReturn(langCode , 'barcodeNo'); // 바코드번호
		        	this.txtPaymentAmount       = util.languageObjReturn(langCode , 'paymentAmount'); // 결제 금액
		        	this.txtRemainingMile  = util.languageObjReturn(langCode , 'remainingMile'); // 잔여 포인트
		        	this.txtUseMile   = util.languageObjReturn(langCode , 'useMile'); // 사용 포인트
		        	this.txtUseMileSet   = util.languageObjReturn(langCode , 'useMileSet'); // 사용 포인트 입력
		        	this.txtActiveButton        = util.languageObjReturn(langCode , 'activeButton'); // 조회하기
		        	this.txtToUse      = util.languageObjReturn(langCode , 'useEarn'); // 사용 + 적립하기
		        	this.directInput = util.languageObjReturn(langCode , 'directInput'); // 직접입력
		        	this.accBtnSave = util.languageObjReturn(langCode , 'accBtnSave'); // 적립하기
            	} catch (error) {
            		util.logError("_____mpPoint created catch_____");
        		}
            }
	    	, data : function() {
	    		return {
	    		      totSaleAmt             : "0" /** 결제 금액 **/
	    		    , remainMile             : "0" /** 잔여 포인트 **/
	    		    , useMile                : "" /** 사용 포인트 **/
	    		    , barcodeNo              : ""
	    		    , selJcdCd               : ""
	    		    , retryCount             : 0
	    		    , readBarcodeNo          : ""	    		    
	    		    , txtBarcodeNo           : ""
	    		    , txtPaymentAmount       : ""
	    		    , txtRemainingMile       : ""
	    		    , txtUseMile             : ""
	    		    , txtUseMileSet          : ""
	    		    , txtActiveButton        : ""
	    		    , txtToUse               : ""
	    		    , listenerIdC            : ""
	    		    , listenerIdB            : ""
	    		    , listenerIdA            : ""
	    		    , POS_ODJCD_T            : {}
	    		    , procId                 : ""
	    		    , dcLimitAmt             : "" /** 할인한도금액 **/
	    		    , dcLimitFg              : "" /** 할인한도구분 (0:한도없음, 1:한도설정) **/
	    		    , dcProdFg               : "" /** 할인상품구분 ( 0:전체상품(제외대상상품) , 1:특정상품(할인대상상품) ) **/
	    		    , JCD_TYPE_FG            : ""
	    		    , APPR_AMT               : 0	    		    
	    		    , readMsg                : ""
	    		    , directYn               : "N"
	    		    , directInput            : ""
	    		    , useMileYn              : "N"
	    		    , accBtnSave             : ""
	    		    , taxEnvVal              : "" /** 부가세 포함여부 **/
	    		}
	    	}
	        , mounted : function() {
	        	util.logInfo("_____mpPoint mount Start_____");
	        	var vmMileMiner = 0;

	        	// 마일리지를 먼저 사용한 경우에 마일리지 금액을 차감하고 제휴할인을 계산하기 위해서 계산한다.
	        	if(orderInfo.POS_ODHDR_T.CST_USE_POINT !== undefined ) {            		
            		// this.getVatSaleAmtView = this.$route.params.price;
            		if(SHOP_INFO.POINT_FG=="M"){
            			//마일리지 매장일경우 사용포인트가 할인 금액과 동일            			
            			vmMileMiner = Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT) - Number(orderInfo.POS_ODHDR_T.CST_USE_POINT);
            		} else {
            			//스탬프 매장일경우 사용스탬프에 따라서 실제 할인 금액이 달라진다.            			
            			//vmMileMiner = Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT) - Number(orderInfo.POS_ODHDR_T.CST_POINT_AMT);
            		}
            	}
	        	// 도도포인트를 먼저 사용한 경우에 마일리지 금액을 차감하고 제휴할인을 계산한다.            	
            	if(orderInfo.DODO_POINT_INFO !== undefined ) {
            		if(SHOP_INFO.POINT_FG=="M"){
            			//마일리지 매장일경우 사용포인트가 할인 금액과 동일
            			vmMileMiner = Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT) - Number(orderInfo.DODO_POINT_INFO.USE_POINT);
            		} 
            	}
            	
            	if(vmMileMiner != "0"){
            		this.totSaleAmt = util.numberWithCommas(vmMileMiner); // 총금액(할인대상금액)
            	}else{
            		this.totSaleAmt = util.numberWithCommas(orderInfo.POS_ODHDR_T.TOT_SALE_AMT); // 총금액(할인대상금액)
            	}
            	
	        	// 리더기 진행사항 콜백 리스터 추가. bjk
            	nativeApp.addPaymentListener(this.creditApproveCallbackListener);
            	
            	try{
            		this.readMsg = util.languageObjReturn(langCode, "pointRead"); // "바코드 인식 및 카드를 읽혀주세요."
            		this.taxEnvVal = util.GetEnvXmlShopENV(128); // ( 부가세 여부 - 1:부가세포함, 0:부가세별도 )
            	}catch(e){
            		util.logError("_____mpPoint mount Catch e == > " + e.toString());
            	}
            	this.accCreditType = this.$route.params.accCreditType;
            	this.accEasyType = this.$route.params.accEasyType;
            	this.readAllStart(); // 리더기, 카메라 구동
	        }
	        ,beforeDestroy () {
	        	util.logInfo("_____mpPoint beforeDestroy_____");
	        	this.fnStopBarCodeReader();
	        	nativeApp.functionCallSync(["FDK_CreditCancel"]); // 카드 리더기 대기 취소
	    	}
	        , methods : {
	        	fn_keypad : function(key){ // 키패드 입력
	        		util.logInfo("_____ mp point 직접입력 키패드 클릭 함수_____");
	        		if(key == "RESET" || key == "DEL"){
	        			util.logInfo("_____ mp point 직접입력 키패드 key == >> " + key);
	        		}else{
	        			util.logInfo("_____ mp point 직접입력 키패드 key == >> 숫자입력함.");
	        		}
	        		var vsNoTemp = this.barcodeNo.replace(/-/gi, "");
	        		vsNoTemp = paymentChoiceService.number_keypad( key, vsNoTemp);
	        		var vsLen = vsNoTemp.length;
	        		if(vsLen < 4){
	        			this.barcodeNo = vsNoTemp;
	        		}else if (vsLen < 8){
	        			var vsNo1 = vsNoTemp.substr(0,4);
	        			var vsNo2 = vsNoTemp.substr(4,4);
	        			this.barcodeNo = vsNo1 +"-" + vsNo2;
	        		}else if (vsLen < 12){
	        			var vsNo1 = vsNoTemp.substr(0,4);
	        			var vsNo2 = vsNoTemp.substr(4,4);
	        			var vsNo3 = vsNoTemp.substr(8,4);
	        			this.barcodeNo = vsNo1 +"-" + vsNo2 +"-" + vsNo3;
	        		}else if (vsLen <= 16){
	        			var vsNo1 = vsNoTemp.substr(0,4);
	        			var vsNo2 = vsNoTemp.substr(4,4);
	        			var vsNo3 = vsNoTemp.substr(8,4);
	        			var vsNo4 = vsNoTemp.substr(12,4);
	        			this.barcodeNo = vsNo1 +"-" + vsNo2 +"-" + vsNo3 +"-" + vsNo4;
	        		}
	        		gCardInFgAlliance = "K" // 직접입력은 K
	        	}
	        	, readAllStart : function(paPointNo){
	        		util.logInfo("_____mpPoint readAllStart Start_____");
	        			        		
	        		// 리더기 활성화를 위해서 바코드 번호 없이 호출한다.
	        		this.fnCardReaderStart(); // 카드리더기 활성화
	        		setTimeout(this.fnStartBarCodeReader, 1000); // 카메라 활성화 1초후에 시작.
	        		
	        	}
	        	, fnCardReaderStart : function(){
	        		/**
	        		 * 카드로 포인트 조회하는 함수
	        		 * 바코드 번호 없이 호출하면 리더기를 활성화하고, 포인트카드를 읽을 때까지 대기한다.
	        		 * 바코드 번호를 넣고 호출하면 포인트 카드를 조회한다.
	        		 */
	        		util.logInfo("_____mpPoint fnCardReaderStart Start_____");
	        		util.logInfo("*****fnCardReaderStart CardReader FDK_MpPointInquiry : BIZ_CLS_SINGLE_CAT_ID == > " + BIZ_CLS_SINGLE_CAT_ID);
	        		// 포인트 조회하기 위해 리더기 활성화 구동, 마지막에 바코드번호를 ""으로 보내면 리더기가 구동된다. 카드 읽히면 자동으로 바로 조회됨.
//	        		this.listenerIdC = nativeApp.functionCallASync(["FDK_MpPointInquiry", "10069371", "0", gvSwModelName, gvSwModelVersion, "MP", ""], this.fnPointCallbackResultS);
	        		this.listenerIdC = nativeApp.functionCallASync(["FDK_MpPointInquiry", BIZ_CLS_SINGLE_CAT_ID, "0", gvSwModelName, gvSwModelVersion, "MP",""], this.fnPointCallbackResultS);
//	        		this.fnPointCallbackResultS();
	        	}
	        	, fn_pointSearchBtn : function(){ // 조회버튼 클릭 함수. 포인트 조회 수행.
        			var result = nativeApp.functionCallSync(["FDK_CreditCancel"]); // 카드 리더기 대기 취소
        			b2bbarcode.stopScanBarcode(); // 바코드 중지
        			
        			if(this.directYn == "Y"){ // 직접입력의 경우
        				if(!this.barcodeNo){
            				var dataObj = {
    								  button1Show : false
    								, button1Name : ""
    								, button1Func : ""
    								, button2Show : true
    								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
    								, button2Func : ""
    								, message     : util.languageObjReturn(langCode,  'barCodeInput') // [ 바코드를 입력해 주세요. ]
    							};
    		    				eventBus.$emit('alertPopupIndex', dataObj);
    		    			return false;
            			}
        				this.readMsg = util.languageObjReturn(langCode, 'pointSearching'); // 포인트를 조회하고 있습니다.
        				// 포인트조회 함수 호출, 직접입력한 바코드번호를 파라미터로 보낸다.
        				var vsBarcodeNo = this.barcodeNo.replace(/-/gi, "");
        				util.logInfo("*****mpPoint fn_pointSearchBtn Direct FDK_MpPointInquiry : BIZ_CLS_SINGLE_CAT_ID == > " + BIZ_CLS_SINGLE_CAT_ID );
//        				this.listenerIdC = nativeApp.functionCallASync(["FDK_MpPointInquiry", "10069371", "0", gvSwModelName, gvSwModelVersion, "MP", vsBarcodeNo], this.fnPointCallbackResultS);        				
            		    this.listenerIdC = nativeApp.functionCallASync(["FDK_MpPointInquiry", BIZ_CLS_SINGLE_CAT_ID, "0", gvSwModelName, gvSwModelVersion, "MP", vsBarcodeNo], this.fnPointCallbackResultS);
        			}else{ // 직접입력이 아닌경우에 다시 카메라와 리더기를 활성화한다.
        				this.readMsg = util.languageObjReturn(langCode, 'pointRead'); // 바코드 인식 및 카드를 읽혀주세요.
        				this.readAllStart();
        			}
	        	}
	        	// 리더기 조회 콜백.
	        	, fnPointCallbackResultS : function(callbackName, result){
	        		util.logInfo("*****mpPoint readAllStart FDK_MpPointInquiry Callback Start*****");
        			try {
        				util.logInfo("*****mpPoint readAllStart FDK_MpPointInquiry Callback barcode STOP*****");
        				waitingService.ResetLogOutTimer(); // 대기영상으로 돌아가는 시간 초기화.
        				nativeApp.removeASyncApiListener(callbackName, this.listenerIdC); // 리더기 카드체크하는 리스너 해제함수.
        				b2bbarcode.stopScanBarcode(); // 바코드 중지					
    		    		var vsResult = result.substring(0, result.lastIndexOf("$$^")); // native 데이터 중 마지막 $$^를 제거    		    		
//    		    		var vsResult = {
//    		    				   "Data" : {
//    		    					      "Cancel_Reason" : "",
//    		    					      "Cash_Receipt_Transaction_Type" : "",
//    		    					      "DDCFlag" : "",
//    		    					      "Discount_Company_Code" : "",
//    		    					      "Goods_Code" : "",
//    		    					      "OCB결과코드" : "",
//    		    					      "OCB고객명" : "",
//    		    					      "Point_Amount_3" : "          ",
//    		    					      "Point_Transaction_Type" : "",
//    		    					      "Point_Value_Type" : "M",
//    		    					      "Status" : "APPROVE",
//    		    					      "가맹점명" : "남인천방송(주)",
//    		    					      "가맹점번호" : "V6931001",
//    		    					      "가맹점임의정보" : "0000000001",
//    		    					      "가맹점전화번호" : "0222873000",
//    		    					      "가맹점주소" : "인천 남구 주안동 203-3",
//    		    					      "가용포인트" : "8997760",
//    		    					      "거래금액" : "",
//    		    					      "거래시간" : "210319161914",
//    		    					      "거래일련번호" : "031934000060",
//    		    					      "거래일시" : "210319161917",
//    		    					      "누적포인트" : "",
//    		    					      "대표자명" : "김인태",
//    		    					      "리더기번호" : "24",
//    		    					      "매입사명" : "SKT",
//    		    					      "매입사코드" : "34",
//    		    					      "무서명금액" : "",
//    		    					      "발급사명" : "",
//    		    					      "발급사코드" : "",
//    		    					      "부가세" : "",
//    		    					      "사업자번호" : "1000000000",
//    		    					      "승인번호" : "00000000",
//    		    					      "승인일자" : "210319",
//    		    					      "알림메세지" : "",
//    		    					      "알림메세지1" : "",
//    		    					      "알림메세지2" : "",
//    		    					      "알림메세지3" : "",
//    		    					      "알림메세지4" : "",
//    		    					      "응답메세지1" : "정상완료",
//    		    					      "응답메세지2" : "",
//    		    					      "적립포인트" : "",
//    		    					      "전표번호" : "",
//    		    					      "체크카드구분" : "",
//    		    					      "카드명" : "SKT T멤버십",
//    		    					      "카드번호" : "216409**********",
//    		    					      "카드잔액" : "",
//    		    					      "카드종류" : "S",
//    		    					      "포인트할인금액" : "",
//    		    					      "포인트할인후금액" : "",
//    		    					      "프린터출력유무" : "O",
//    		    					      "할부" : "",
//    		    					      "할인금액" : "",
//    		    					      "할인후금액" : ""
//    		    					   },
//    		    					   "Message" : "",
//    		    					   "ResultCode" : "0"
//    		    					}

    		    		util.logInfo("mpPoint fnPointCallbackResultS vsResult == > " + vsResult);
    		    		vsResult = JSON.parse(vsResult);
    		    		var vsCode = vsResult.ResultCode;
    		    		var vsMessage = vsResult.Message;
    		    		util.logInfo("*****mpPoint readAllStart FDK_MpPointInquiry Callback vsCode === > " + vsCode);
    		    		if(vsCode == "0"){
    		    			util.logInfo("*****mpPoint readAllStart FDK_MpPointInquiry Callback Status === > " + vsResult.Data["Status"]);
    		    			if(vsResult.Data["Status"] == "APPROVE"){
    		    				this.readMsg = util.languageObjReturn(langCode, 'pointSearchEnd'); // 포인트가 조회 되었습니다.
    		    				util.logInfo("*****mpPoint readAllStart FDK_MpPointInquiry Callback Success*****");
        		    			this.remainMile = util.numberWithCommas(Number(vsResult.Data["가용포인트"]));
        		    			if(this.directYn != "Y"){ // 직접입력인 경우에 바코드 번호를 *로 변경하여 셋팅하지 않는다. 번호 그대로 둔다.
        		    				this.barcodeNo = this.fnSplitNo(vsResult.Data["카드번호"]);
        		    			}
        		    			this.procId = vsResult.Data["리더기번호"];
        		    			gCardInFgAlliance = "S"; // 리더기 처리.
        		    			if(this.useMileYn == "Y"){
        		    				this.fnUseMileExe(); // 사용하기를 바로 수행한다.
        		    			}
    		    			}else{
    		    				this.useMileYn = "N";
    		    				this.readMsg = util.languageObjReturn(langCode, 'pointSearchFail'); // 포인트 조회에 실패했습니다.
    		    				
    		    				var dataObj = {
  									  button1Show : false
  									, button1Name : ""
  									, button1Func : ""
  									, button2Show : true
  									, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
  									, button2Func : ""
  									, message     : util.languageObjReturn(langCode,  'pointSearchFail') + "[" + vsResult.Data["응답메세지1"] + vsResult.Data["응답메세지2"] + "]" // [ 포인트 조회에 실패했습니다. ]
  								};
    		    				eventBus.$emit('alertPopupIndex', dataObj);
    		    			}
    		    			
		    			}else if (vsCode == "-7104"){ // 사용자 취소.
		    				this.useMileYn = "N";
		    				util.logInfo("*****mpPoint readAllStart FDK_MpPointInquiry Callback CREDIT CANCEL -7104 사용자취소 *****");
		    				return;
		    			}else if (vsCode == "-7102"){ // 리더기 대기시간 초과일 때 다시 리더기를 활성화 한다.
		    				util.logInfo("*****mpPoint readAllStart FDK_MpPointInquiry Callback CREDIT CANCEL*****");
		    				//this.fnCardReaderStart(); // 카드리더기 활성화
		    				this.readAllStart();
		    				return;
		    			}else{ // 승인 실패
		    				this.useMileYn = "N";
		    				this.readMsg = util.languageObjReturn(langCode, 'pointSearchFail'); // 포인트 조회에 실패했습니다.
		    				var dataObj = {
									  button1Show : false
									, button1Name : ""
									, button1Func : ""
									, button2Show : true
									, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
									, button2Func : ""
									, message     : util.languageObjReturn(langCode,  'pointSearchFail') + "[" + vsResult.ResultCode + "]"  // [ 포인트 조회에 실패했습니다. ]
								};
		        			eventBus.$emit('alertPopupIndex', dataObj);
		    			}
        			} catch (e) {
        				this.useMileYn = "N";
        				this.readMsg = util.languageObjReturn(langCode, 'pointSearchFail'); // 포인트 조회에 실패했습니다.
        				var dataObj = {
								  button1Show : false
								, button1Name : ""
								, button1Func : ""
								, button2Show : true
								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
								, button2Func : ""
								, message     : util.languageObjReturn(langCode,  'pointSearchFail') // [ 포인트 조회에 실패했습니다. ]
							};
	        			eventBus.$emit('alertPopupIndex', dataObj);
						util.logError("*****mpPoint readAllStart FDK_MpPointInquiry Callback Catch e == > " + e.toString());
						util.logError("*****mpPoint readAllStart FDK_MpPointInquiry Callback Catch e json == > " + JSON.stringify(e));
						
					}
	        	}
	        	, fn_pointSearchB : function(){ // 카메라로 바코드 인식하여 포인트 조회 수행.        			        			
        		    // 포인트조회 함수 호출 this.selJcdCd     BIZ_CLS_SINGLE_CAT_ID  10069371 ,   2164096900030013
//        		    this.listenerIdB = nativeApp.functionCallASync(["FDK_MpPointInquiry", "10069371", "0", gvSwModelName, gvSwModelVersion, "MP", this.readBarcodeNo], this.fnMpPointSearchCallbackB);
        			util.logInfo("*****mpPoint fn_pointSearchB Barcode FDK_MpPointInquiry : BIZ_CLS_SINGLE_CAT_ID == > " + BIZ_CLS_SINGLE_CAT_ID + ", this.readBarcodeNo = > " + this.readBarcodeNo);
        		    this.listenerIdB = nativeApp.functionCallASync(["FDK_MpPointInquiry", BIZ_CLS_SINGLE_CAT_ID, "0", gvSwModelName, gvSwModelVersion, "MP", this.readBarcodeNo], this.fnMpPointSearchCallbackB);
	        	}
	        	, fnMpPointSearchCallbackB : function(callbackName, result){ // 바코드 포인트 조회 콜백
	        		util.logInfo("*****mpPoint fnMpPointSearchCallbackB Start*****" );		
	        		try 
    		    	{
	        			waitingService.ResetLogOutTimer(); // 대기영상으로 돌아가는 시간 초기화.
    		    		nativeApp.removeASyncApiListener(callbackName, this.listenerIdB); // 리더기 카드체크하는 리스너 해제함수.
    		    		var vsResult = result.substring(0, result.lastIndexOf("$$^")); // native 데이터 중 마지막 $$^를 제거
    		    		vsResult = JSON.parse(vsResult);
    		    		var vsCode = vsResult.ResultCode;
    		    		if(vsCode == "0"){
    		    			if(vsResult.Data["Status"] == "APPROVE"){
    		    				this.readMsg = util.languageObjReturn(langCode, 'pointSearchEnd'); // 포인트가 조회 되었습니다.
    		    				this.remainMile = util.numberWithCommas(Number(vsResult.Data["가용포인트"]));
    		    				if(this.directYn != "Y"){ // 직접입력인 경우에 바코드 번호를 *로 변경하여 셋팅하지 않는다. 번호 그대로 둔다.
    		    					this.barcodeNo = this.fnSplitNo(this.readBarcodeNo);
    		    				}    		    				
    		    				this.procId = vsResult.Data["리더기번호"];
    		    				gCardInFgAlliance = "K"; // 바코드로 처리.
    		    			}else{ // 승인 실패
    		    				this.readMsg = util.languageObjReturn(langCode, 'rePointRead'); // 조회 버튼을 누른 후 카드를 인식하세요.
    		    				util.logInfo("*****mpPoint fnMpPointSearchCallbackB NO APPROVE*****" );
    		    				var dataObj = {
    									  button1Show : false
    									, button1Name : ""
    									, button1Func : ""
    									, button2Show : true
    									, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
    									, button2Func : ""
    									, message     : util.languageObjReturn(langCode,  'pointSearchFail') + " [" + vsResult.Data["응답메세지1"] + vsResult.Data["응답메세지2"] + "]" // [ 포인트 조회에 실패했습니다. ]
    								};
    		        			eventBus.$emit('alertPopupIndex', dataObj);
    		    			}
    		    			
    		    		}else{
    		    			this.readMsg = util.languageObjReturn(langCode, 'rePointRead'); // 조회 버튼을 누른 후 카드를 인식하세요.
    		    			util.logInfo("*****mpPoint fnMpPointSearchCallbackB Code NOT 0*****" );
    		    			util.logError("*****mpPoint fnMpPointSearchCallbackB vsResult == > " + JSON.stringify(vsResult));
    		    			var dataObj = {
									  button1Show : false
									, button1Name : ""
									, button1Func : ""
									, button2Show : true
									, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
									, button2Func : ""
									, message     : util.languageObjReturn(langCode,  'pointSearchFail') + " [" + vsResult.ResultCode + "]" // [ 포인트 조회에 실패했습니다. ]
								};
    		    			eventBus.$emit('alertPopupIndex', dataObj);
    		    		}
    		    	} catch (e) {
    		    		this.readMsg = util.languageObjReturn(langCode, 'rePointRead'); // 조회 버튼을 누른 후 카드를 인식하세요.
    		    		util.logError("*****mpPoint fnMpPointSearchCallbackB Catch***** e ==> " + e.toString() );
    		    		var dataObj = {
								  button1Show : false
								, button1Name : ""
								, button1Func : ""
								, button2Show : true
								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
								, button2Func : ""
								, message     : util.languageObjReturn(langCode,  'pointSearchFail') // [ 포인트 조회에 실패했습니다. ]
							};
    		    		eventBus.$emit('alertPopupIndex', dataObj);	        		    		
    		    	}
	        	}
	        	, fnStartBarCodeReader : function() { // 카메라 구동시작.
        			util.logInfo('*****mpPoint fnStartBarCodeReader start!!*****');
        			try {
        				if(typeof tizen === 'undefined' ) {
        					//this.fncBarCodeListner("281006020000000000857324");//윈도우는 테스트 카카오 페이 신용
        				} else {
        					//util.logInfo('*****mpPoint fnStartBarCodeReader CAMARA SCAN START!!*****');
        					b2bbarcode.startScanBarcode(this.fncBarCodeListner);
        				}

					} catch (e) {
						util.logError("*****mpPoint fnStartBarCodeReader catch e ==> \n" + e.toString());
					}
        		}
        		, fncBarCodeListner : function(msg) {
        			util.logInfo('*****mpPoint fncBarCodeListner start!!*****');
        			let strBarcode ;
        			if(typeof tizen === 'undefined' ) {
        				this.readBarcodeNo = msg;
        			} else {
        				if ( msg.data !== 'NOT_DETECTED' ){// 입력됨.
        					util.logInfo("*****mpPoint fncBarCodeListner NOT_DETECTED");
        					this.readBarcodeNo = msg.data;
        				} else {
        					util.logInfo("*****mpPoint fncBarCodeListner retry");
							this.fnStartBarCodeReader();// 재시도 함.
        					return;
        				}
        			}
        			this.fnBarcodeReadEnd();
				}
        		, fnBarcodeReadEnd : function(paReadBarcodeNo){
        			util.logInfo('*****mpPoint fnBarcodeReadEnd start!!*****');
        			let appType ="" , dataObj = {};
					try {
						util.beep(); // 바코드 인식되었다는 비프음 출력.
						this.fnStopBarCodeReader(); // 카메라 중지
						waitingService.ResetLogOutTimer(); // 대기화면으로 돌아가는 타이머 초기화. ( 결제 도중에 대기화면으로 돌아가지 않기 위해)
						var result = nativeApp.functionCallSync(["FDK_CreditCancel"]); // 카드 리더기 대기 취소
						setTimeout(this.fn_pointSearchB, 500); // 바코드로 포인트 조회 함수 
//						this.fn_pointSearchB(); 
					} catch (e) {
						util.logError("*****mpPoint fnBarcodeReadEnd catch e =>> " + e.toString());
					}
        		}
        		, fnStopBarCodeReader : function() {
        			if(typeof tizen == "undefined" ) return;
        			try {
        				util.logInfo("*****mpPoint fnStopBarCodeReader Start*****");
        				b2bbarcode.stopScanBarcode();
					} catch (e) {
						util.logError("*****mpPoint fnStopBarCodeReader catch e =>> " + e.toString());
					}
        		}
        		, fnBack : function(){
        			var dataObj = {
							  button1Show : true
							, button1Name : util.languageObjReturn(langCode, 'no') // [ 예 ]
							, button1Func : ""
							, button2Show : true
							, button2Name : util.languageObjReturn(langCode, 'yes') // [ 아니오 ]
							, button2Func : this.fnGoBack
							, message     : util.languageObjReturn(langCode,  'pointHomeClick') // [ 진행내역이 초기화 됩니다. 뒤로 돌아가시겠습니까? ]
						};
        			eventBus.$emit('alertPopupIndex', dataObj);
        		}
        		, fnGoBack : function(){
        			router.push({path: '/paymentChoiceView'})
        		}
        		, fnUseMile : function(){ // 사용하기 버튼 클릭 이벤트 (MP포인트)
        			if(this.directYn == "Y"){ // 직접입력인 경우에 현재 입력된 바코드 번호로 조회를 무조건 하고나서 사용기능까지 자동으로 로직이 수행된다.(조회를 이미 한 상태라도 다시 조회함)
        				this.useMileYn = "Y"; // 조회를 호출한 후에 사용함수를 호출할지 말지 플래그
        				this.fn_pointSearchBtn(); // 조회함수 호출
        			}else{
        				this.fnUseMileExe();
        			}
        		}
        		, fnUseMileExe : function(){ // 사용하기 버튼 클릭 이벤트
        			if(this.directYn != "Y" && !this.barcodeNo){ // 직접입력이 아니고 바코드 번호가 없을 때
        				this.useMileYn = "N";
        				var dataObj = {
								  button1Show : false
								, button1Name : ""
								, button1Func : ""
								, button2Show : true
								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
								, button2Func : ""
								, message     : util.languageObjReturn(langCode,  'pointSearchValid') // [ "바코드 또는 카드를 인식하여 조회해 주세요." ]
							};
		    				eventBus.$emit('alertPopupIndex', dataObj);
		    			return false;
        			}else if (this.directYn == "Y" && !this.barcodeNo){ // 직접입력이고, 바코드 번호가 없을 때
        				this.useMileYn = "N";
        				var dataObj = {
								  button1Show : false
								, button1Name : ""
								, button1Func : ""
								, button2Show : true
								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
								, button2Func : ""
								, message     : util.languageObjReturn(langCode,  'barCodeInput') // [ 바코드를 입력해 주세요. ]
							};
		    				eventBus.$emit('alertPopupIndex', dataObj);
		    			return false;
        			}
        			if(!this.useMile || this.useMile == "0"){
        				this.useMileYn = "N";
        				var dataObj = {
								  button1Show : false
								, button1Name : ""
								, button1Func : ""
								, button2Show : true
								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
								, button2Func : ""
								, message     : util.languageObjReturn(langCode,  'pointUseIn') // [ 사용포인트를 입력해 주세요. ]
							};
		    				eventBus.$emit('alertPopupIndex', dataObj);
		    			return false;
        			}

            		util.logInfo("*****mpPoint FDK_MpPointInquiry_Using PARAM ===>  " + BIZ_CLS_SINGLE_CAT_ID + " / " + this.useMile + " / " + gvSwModelName+ " / " + gvSwModelVersion + " / MP / " + this.procId);
            		// BIZ_CLS_SINGLE_CAT_ID  10140185
//            		this.listenerIdA = nativeApp.functionCallASync(["FDK_MpPointInquiry_Using", "10140185", "" + vsSaleAmt, gvSwModelName, gvSwModelVersion, "MP", "" + this.procId, "1001"], this.fnPointCallbackResultA);
            		
            		// mpPoint 사용+적립 동시진행 함수
            		var vsUseAmt = this.useMile.replace(/,/gi, "");
            		var vsTotalAmt = this.totSaleAmt.replace(/,/gi, "");
            		
            		// 사용+적립 함수 호출.
            		this.listenerIdA = nativeApp.functionCallASync(["FDK_MpPointInquiry_Using", BIZ_CLS_SINGLE_CAT_ID, "" + vsTotalAmt, "" + vsUseAmt, gvSwModelName, gvSwModelVersion, "MP", "" + this.procId, "1005"], this.fnPointCallbackResultA);
            		
            		// 기존에 적립용도로 사용하던 함수을 사용 또는 적립 둘다 사용하는 것으로 변경됨 (2021.06.15)
//            		this.listenerIdA = nativeApp.functionCallASync(["FDK_MpPointInquiry_Purchase", BIZ_CLS_SINGLE_CAT_ID, "" + vsTotalAmt, "" + vsUseAmt,  gvSwModelName, gvSwModelVersion, "MP", "" + this.procId, "1001"], this.fnPointCallbackResultA);
//            		this.fnPointCallbackResultA();
        		}
        		// 포인트 사용+적립 후 콜백
        		, fnPointCallbackResultA : function(callbackName, result){
        			try 
        			{
        				util.logInfo("*****mpPoint fnPointCallbackResultA START ***** ");
        				nativeApp.removeASyncApiListener(callbackName, this.listenerIdA); // 리더기 카드체크하는 리스너 해제함수.
        				var vsResult = result.substring(0, result.lastIndexOf("$$^")); // native 데이터 중 마지막 $$^를 제거        				        				        				
        				
//        				var vsResult =  {
//        						   "Data" : {
//        							      "Cancel_Reason" : "",
//        							      "Cash_Receipt_Transaction_Type" : "",
//        							      "DDCFlag" : "",
//        							      "Discount_Company_Code" : "",
//        							      "Goods_Code" : "1001",
//        							      "OCB결과코드" : "",
//        							      "OCB고객명" : "",
//        							      "Point_Amount_3" : "          ",
//        							      "Point_Transaction_Type" : "",
//        							      "Point_Value_Type" : "M",
//        							      "Status" : "APPROVE",
//        							      "가맹점명" : "남인천방송(주)",
//        							      "가맹점번호" : "V6931001",
//        							      "가맹점임의정보" : "0000000001",
//        							      "가맹점전화번호" : "0222873000",
//        							      "가맹점주소" : "인천 남구 주안동 203-3",
//        							      "가용포인트" : "8995130",
//        							      "거래금액" : "25004",
//        							      "거래시간" : "210319164823",
//        							      "거래일련번호" : "031934000066",
//        							      "거래일시" : "210319164827",
//        							      "누적포인트" : "",
//        							      "대표자명" : "김인태",
//        							      "리더기번호" : "24",
//        							      "매입사명" : "SKT",
//        							      "매입사코드" : "34",
//        							      "무서명금액" : "",
//        							      "발급사명" : "",
//        							      "발급사코드" : "",
//        							      "부가세" : "",
//        							      "사업자번호" : "1000000000",
//        							      "승인번호" : "80372326",
//        							      "승인일자" : "210319",
//        							      "알림메세지" : "",
//        							      "알림메세지1" : "",
//        							      "알림메세지2" : "",
//        							      "알림메세지3" : "",
//        							      "알림메세지4" : "",
//        							      "응답메세지1" : "정상완료",
//        							      "응답메세지2" : "",
//        							      "적립포인트" : "",
//        							      "전표번호" : "",
//        							      "체크카드구분" : "",
//        							      "카드명" : "SKT T멤버십",
//        							      "카드번호" : "216409**********",
//        							      "카드잔액" : "",
//        							      "카드종류" : "S",
//        							      "포인트할인금액" : "3750",
//        							      "포인트할인후금액" : "21254",
//        							      "프린터출력유무" : "O",
//        							      "할부" : "",
//        							      "할인금액" : "",
//        							      "할인후금액" : ""
//        							   },
//        							   "Message" : "",
//        							   "ResultCode" : "0"
//        							}

        				util.logInfo("*****mpPoint fnPointCallbackResultA Resultdata == >  " + vsResult);
        				vsResult = JSON.parse(vsResult); 
        				var vsCode = vsResult.ResultCode;
        				// 사용 + 적립 콜백함수.
        				if(vsCode == "0"){ // 정상코드
        					if(vsResult.Data["Status"] == "APPROVE"){ // 정상 승인
        						
        						/** 누적포인트 : 부스트업 포인트 (추가할인) -> 알림메세지1이 부스트업포인트로 변경됨. 누적포인트 사용안함.
        						 *  포인트할인후금액 : 총금액 - 실제 차감된 금액
        						 *  적립포인트 : 적립금액
        						 *  거래금액 : 총금액
        						 *  MP포인트사용금액 : 실제 사용된 금액
        						 *  가용포인트 : 남은 포인트
        						 *  취소시에는 실제 차감된 금액(사용자가 입력한 포인트가 아닌)을 파라미터로 보내줘야 정상 취소된다. (거래금액을 넣어야함. 누적포인트(부스트업 차감)등은 합쳐서 보내지 않는다. 거래금액으로 보내야한다.)
        						 *  적립시에도 사용이 되는 경우가 있다. 이때 플래그를 어떻게 구분해야할지 조치 필요.
        						 *  적립 취소시에 총금액 (적립 사용시에 보냈던 금액)
        						 *  
        						 * **/

        						// 차감 및 할인금액의 합계 : 포인트 차감금액(MP포인트사용금액) + 부스트업 금액(누적포인트) -> (알림메세지1이 부스트업포인트로 변경됨.) + 할인금액(포인트할인금액)
                            	orderInfo.POS_ODHDR_T.JCD_CARD_AMT = Number(vsResult.Data["MP포인트사용금액"]) + Number(vsResult.Data["알림메세지1"]) + Number(vsResult.Data["포인트할인금액"]);
//                            	orderInfo.POS_ODHDR_T.EXP_PAY_AMT = this.totSaleAmt.replace(/,/gi, ""); // 계산 총금액
//                            	orderInfo.POS_ODHDR_T.GST_PAY_AMT = orderInfo.POS_ODHDR_T.JCD_CARD_AMT // 고객이 낸 금액 (현금인 경우에 결제 금액은 7000원이나 10000원을 낼수가 있다. EXP : 7000, GST : 10000 이 된다.)
//                            	orderInfo.POS_ODHDR_T.RET_PAY_AMT = Number(orderInfo.POS_ODHDR_T.JCD_CARD_AMT) - Number(orderInfo.POS_ODHDR_T.EXP_PAY_AMT); // 위의 두 금액의 차액 ( 거스름 돈이라고 생각하면 됨.) 
//        						
        						// POS_ODJCD_T 테이블에 저장하기 위한 값 저장.
        						this.POS_ODJCD_T.SHOP_CD = gShopCd; // 매장코드
        						this.POS_ODJCD_T.SALE_DATE = saleDate	//영업일자
        						this.POS_ODJCD_T.ORDER_NO = "";	// 주문번호
        						this.POS_ODJCD_T.LINE_NO = "";	// 라인번호
        						this.POS_ODJCD_T.SEQ_NO	= ""; // 라인일련번호
        						this.POS_ODJCD_T.POS_NO	 = gPosNo; //포스번호
        						this.POS_ODJCD_T.SALE_YN = "Y";	//판매여부(Y:판매 N:반품(취소))
        						this.POS_ODJCD_T.JCD_CARD_NO = vsResult.Data["카드번호"]; // 제휴카드번호
        						this.POS_ODJCD_T.JCD_CD	= "" //제휴할인코드 (SCD_JCDHD_T 테이블의 jcd_cd 값 : AAAA, ZBNK 등의 값)
        						this.POS_ODJCD_T.JCD_TYPE_FG = "M"; //제휴카드유형구분 ( CCD_CODEM_T : 035 ) 1:OCBS 2:SKT 3:KTF 4:LGT
        						var vsUseAmt = this.useMile.replace(/,/gi, "");
        						if(!orderInfo.POS_ODHDR_T.JCD_CARD_AMT || orderInfo.POS_ODHDR_T.JCD_CARD_AMT == "0"){
        							this.POS_ODJCD_T.JCD_PROC_FG = "1"; // 적립셋팅. 제휴카드처리구분 ( CCD_CODEM_T : 036 ) 0:할인 1:적립 2:사용 3:할인취소 4:적립취소 5:사용취소 6:적립사용 7:적립사용취소 9:조회 //
        						}else{
        							this.POS_ODJCD_T.JCD_PROC_FG = "6"; // 적립사용셋팅. 제휴카드처리구분 ( CCD_CODEM_T : 036 ) 0:할인 1:적립 2:사용 3:할인취소 4:적립취소 5:사용취소 6:적립사용 7:적립사용취소 9:조회 //
        						}
       							
        						
        						this.POS_ODJCD_T.APPR_LOG_NO = ""; // 승인로그번호 ( 결제내역 저장하는 부분에 채번하는 부분 있음. 가져다 쓰면됨.
        						this.POS_ODJCD_T.APPR_AMT = this.totSaleAmt.replace(/,/gi, ""); // 결제 금액 (총금액)
        						var vnJcdDcAmt = 0;
        						var vsJcdOcc = 0;
        						var vnJcdAvl = 0;
        						var vnJcdUse = 0;
        						var vnJcdRem = 0;
        						if(!!vsResult.Data["포인트할인금액"]){
        							vnJcdDcAmt = vsResult.Data["포인트할인금액"];
        						}
        						if(!!vsResult.Data["적립포인트"]){
        							vsJcdOcc = vsResult.Data["적립포인트"];
        						}
        						if(!!vsResult.Data["알림메세지1"]){ // 부스트업 포인트가 알림메세지1으로 변경됨.(기존에 누적포인트였음)
        							vnJcdAvl = vsResult.Data["알림메세지1"];
        						}
        						if(!!vsResult.Data["MP포인트사용금액"]){ // 실제사용금액
        							vnJcdUse = vsResult.Data["MP포인트사용금액"];
        						}
        						if(!!vsResult.Data["가용포인트"]){
        							vnJcdRem = vsResult.Data["가용포인트"];
        						}
        						this.POS_ODJCD_T.JCD_DC_AMT = vnJcdDcAmt; // 할인금액   
        						this.POS_ODJCD_T.JCD_OCC_POINT = vsJcdOcc //제휴카드-발생포인트        						
        						this.POS_ODJCD_T.JCD_AVL_POINT = vnJcdAvl; // MP포인트에서는 누적포인트가 부스트업 할인 금액으로 사용됨.
        						this.POS_ODJCD_T.JCD_USE_POINT = vnJcdUse; // 내 포인트에서의 실제 차감된 포인트 [MP포인트사용금액]
        						this.POS_ODJCD_T.JCD_REM_POINT = vnJcdRem; //잔여포인트.   MP포인트에서 '포인트할인후금액'은 총금액-MP포인트사용금액(실제 차감된 포인트)이다. MP포인트에서 가용포인트가 남은포인트임. 
        						
        						//this.POS_ODJCD_T.JCD_REM_POINT = vsResult.Data["할인금액"]; // 
        						//this.POS_ODJCD_T.JCD_REM_POINT = vsResult.Data["할인후금액"]; // mp포인트 할인 및 적립 후 최종금액?
        						
        						this.POS_ODJCD_T.EMP_NO = loginEmpNo; //판매원번호 
        						this.POS_ODJCD_T.JCD_PAY_FG = "02"; // 적립거래구분 01:현금 02:신용카드 03:직불카드 04:자사카드
        						this.POS_ODJCD_T.VAN_TERM_NO = BIZ_CLS_SINGLE_CAT_ID // 밴사터미널번호
        						this.POS_ODJCD_T.APPR_NO = vsResult.Data["승인번호"];
        						var vsCurDt = moment().format("YYYYMMDDHHmmss");
        						var vsCurDtYY = vsCurDt.substr(0,2); // 현재 년도 앞 2자리
        						var vsApproveDt = vsCurDtYY + vsResult.Data["승인일자"];
        						var vsApprTime = vsResult.Data["거래일시"].substr(6,6);
        						this.POS_ODJCD_T.APPR_DATE = vsApproveDt; // 승인일자
        						this.POS_ODJCD_T.APPR_TIME = vsApprTime; // 승인시간
        						this.POS_ODJCD_T.APPR_MSG = vsResult.Data["응답메세지1"] + " " + vsResult.Data["응답메세지2"];
        						
        						var vsBroadMsg = vsResult.Data["알림메세지2"];
        						
        						if(!!vsResult.Data["알림메세지3"]){
        							if(!vsBroadMsg){
        								vsBroadMsg += vsResult.Data["알림메세지3"];
        							}else{
        								vsBroadMsg += "\r\n" + vsResult.Data["알림메세지3"];
        							}
        						}
        						
        						if(!!vsResult.Data["알림메세지4"]){
        							if(!vsBroadMsg){
        								vsBroadMsg += vsResult.Data["알림메세지4"];
        							}else{
        								vsBroadMsg += "\r\n" + vsResult.Data["알림메세지4"];
        							}
        						}
        						
        						this.POS_ODJCD_T.BROAD_MSG = vsBroadMsg;
        						
        						this.POS_ODJCD_T.CRDCP_TERM_NO = vsResult.Data["가맹점번호"];
        						this.POS_ODJCD_T.TRADE_SERIAL_NUM = vsResult.Data["거래일련번호"];
        						this.POS_ODJCD_T.CNMK_CD = vsResult.Data["거래일련번호"]; // 거래일련번호는 할인취소할 때 필요한데, 컬럼이 명확히 없어서 CNMK_CD에 저장하여 취소시에 사용하도록 한다.
        						
        						this.POS_ODJCD_T.APPR_FULL_TIME = vsResult.Data["거래일시"];        						
        					     
        						this.POS_ODJCD_T.DEAL_NO = vsResult.Data["거래일련번호"];
        						this.POS_ODJCD_T.JCD_TYPE_FG_NM = "MP포인트";
        						
        						orderInfo.POS_ODJCD_T = this.POS_ODJCD_T;
        						
        						var vsUseAmt = this.useMile.replace(/,/gi, ""); // 사용포인트
        						// 사용포인트를 고객이 입력하였으나, 실제로 차감된 금액이 없고 적립도 안되었을 때 메시지
        						if((!orderInfo.POS_ODHDR_T.JCD_CARD_AMT || orderInfo.POS_ODHDR_T.JCD_CARD_AMT == "0") && (!!vsUseAmt && vsUseAmt != "0") && (!vsResult.Data["적립포인트"] || vsResult.Data["적립포인트"] == "0")){        							
        							var dataObj = {
                							  button1Show : false
                							, button1Name : ""
                							, button1Func : ""
                							, button2Show : true
                							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
                							, button2Func : this.fnGoPaymentChoiceView
                							, message     : util.languageObjReturn(langCode, 'mpUseMsg1') // "포인트사에 의해 사용 및 적립이 적용되지 않았습니다." 
                						}; 
                  					eventBus.$emit('alertPopupIndex', dataObj);      
        						}else if((!orderInfo.POS_ODHDR_T.JCD_CARD_AMT || orderInfo.POS_ODHDR_T.JCD_CARD_AMT == "0") && (!!vsUseAmt && vsUseAmt != "0") && (!!vsResult.Data["적립포인트"] && vsResult.Data["적립포인트"] != "0" )){
            						// 사용포인트를 고객이 입력하였으나, 실제로 차감된 금액이 없고 적립만 된 경우.
        							var dataObj = {
                							  button1Show : false
                							, button1Name : ""
                							, button1Func : ""
                							, button2Show : true
                							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
                							, button2Func : this.fnGoPaymentChoiceView
                							, message     : util.languageObjReturn(langCode, 'mpUseMsg2') // "포인트사에 의해 적립만 적용 되었습니다." 
                						}; 
                  					eventBus.$emit('alertPopupIndex', dataObj);      
        						}else if((!!orderInfo.POS_ODHDR_T.JCD_CARD_AMT && orderInfo.POS_ODHDR_T.JCD_CARD_AMT != "0") && (!!vsUseAmt && vsUseAmt != "0") && (!vsResult.Data["적립포인트"] || vsResult.Data["적립포인트"] == "0")){
        							// 사용포인트를 고객이 입력하였으나, 실제로 차감된 금액은 있고 적립이 안되었을 때 메시지
        							var dataObj = {
                							  button1Show : false
                							, button1Name : ""
                							, button1Func : ""
                							, button2Show : true
                							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
                							, button2Func : this.fnGoPaymentChoiceView
                							, message     : util.languageObjReturn(langCode, 'mpUseMsg3') // "포인트사에 의해 사용이 승인되었으나 적립은 적용되지 않았습니다." 
                						}; 
                  					eventBus.$emit('alertPopupIndex', dataObj);      
        						}else{
        							
        							util.logInfo(" ***** mpPoint fnNetCancelCommand 시작 전 *****");
        							// mpPoint 승인 후 NetCancel파일 생성을 먼저하기 때문에, NetCancel 데몬이 중지 되도록 함수를 수행한다.
            						util.fnNetCancelCommand(0, 10);
            						
            						// 결제수단 선택 화면으로 이동
        							this.fnGoPaymentChoiceView();
        						}
        						
        					}else{
        						this.useMileYn = "N";
        						util.logError("*****mpPoint fnPointCallbackResultA NO APPROVE*****");
        						var dataObj = {
          							  button1Show : false
          							, button1Name : ""
          							, button1Func : ""
          							, button2Show : true
          							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
          							, button2Func : ""
          							, message     : util.languageObjReturn(langCode,  'failMile') + " [" + vsResult.Data["응답메세지1"] + vsResult.Data["응답메세지2"] + "]" // [ 포인트 사용에 실패했습니다. ]
          						}; 
            					eventBus.$emit('alertPopupIndex', dataObj);            					
        					}
        					
        				}else{
        					this.useMileYn = "N";
        					util.logError("*****mpPoint fnPointCallbackResultA ResultCode NO 0 *****");
    						var dataObj = {
      							  button1Show : false
      							, button1Name : ""
      							, button1Func : ""
      							, button2Show : true
      							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
      							, button2Func : ""
      							, message     : util.languageObjReturn(langCode,  'failMile') + " [" + vsResult.ResultCode + "]" // [ 포인트 사용에 실패했습니다. ]
      						}; 
        					eventBus.$emit('alertPopupIndex', dataObj);   
        					
        				}
        			} catch (e) {
        				this.useMileYn = "N";
        				util.logError("mpPoint fnPointCallbackResultA catch e ==> " + e.toString());
        				var dataObj = {
    							  button1Show : false
    							, button1Name : ""
    							, button1Func : ""
    							, button2Show : true
    							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
    							, button2Func : ""
    							, message     : util.languageObjReturn(langCode,  'failMile') // [ 포인트 사용에 실패했습니다. ]
    						};
      					eventBus.$emit('alertPopupIndex', dataObj);
        			}	
        		}
        		, fnGoPaymentChoiceView : function(){
        			this.$router.push({name: 'paymentChoiceView'});
        		}
        		, fnSaveMile : function(){ // 적립하기 버튼 클릭 이벤트 (2021.06.15 적립만 따로하는 버튼은 없애기로 함. 사용+적립 버튼에서 사용포인트가 0인경우에 적립으로 처리되기로)
        			var vsSaleAmt = this.totSaleAmt.replace(/,/gi, ""); // 결제 금액에서 ,를 없앤 값.
        			
        			if(this.directYn == "Y"){ // 직접입력인 경우에 현재 입력된 바코드 번호로 조회를 무조건 하고나서 사용기능까지 자동으로 로직이 수행된다.(조회를 이미 한 상태라도 다시 조회함)
        				if(!this.barcodeNo){
            				var dataObj = {
    								  button1Show : false
    								, button1Name : ""
    								, button1Func : ""
    								, button2Show : true
    								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
    								, button2Func : ""
    								, message     : util.languageObjReturn(langCode,  'barCodeInput') // [ 바코드를 입력해 주세요. ]
    							};
    		    				eventBus.$emit('alertPopupIndex', dataObj);
    		    			return false;
            			}
        				this.readMsg = util.languageObjReturn(langCode, 'pointSaving'); // 포인트를 적립하고 있습니다.
        				// 포인트조회 함수 호출, 직접입력한 바코드번호를 파라미터로 보낸다.
        				var vsBarcodeNo = this.barcodeNo.replace(/-/gi, "");
        				util.logInfo("*****mpPoint FDK_MpPointInquiry_Purchase START (직접입력 적립 함수, 카드번호로 적립) ***** ");
            			// 적립함수 호출.(직접입력한 바코드 번호로 보내야함)
            			this.listenerIdA = nativeApp.functionCallASync(["FDK_MpPointPurchase", BIZ_CLS_SINGLE_CAT_ID, "" + vsSaleAmt, gvSwModelName, gvSwModelVersion, "MP", vsBarcodeNo, "1005"], this.fnPointCallbackResultSave);        				
        			}else{ // 직접입력이 아닌경우
        				if(!this.barcodeNo){
            				var dataObj = {
    								  button1Show : false
    								, button1Name : ""
    								, button1Func : ""
    								, button2Show : true
    								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 아니오 ]
    								, button2Func : ""
    								, message     : util.languageObjReturn(langCode,  'pointSearchValid') // [ "바코드 또는 카드를 인식하여 조회해 주세요." ]
    							};
    		    				eventBus.$emit('alertPopupIndex', dataObj);
    		    			return false;
            			}
        				// 적립함수 호출.(직접입력이 아닌 경우 조회하고 생성된 procId를 바코드 번호 대신 보내야함)
        				util.logInfo("*****mpPoint FDK_MpPointInquiry_Purchase START (조회 후 적립 함수, procId로 적립) ***** ");        				
        				this.listenerIdA = nativeApp.functionCallASync(["FDK_MpPointInquiry_Purchase", BIZ_CLS_SINGLE_CAT_ID, "" + vsSaleAmt, gvSwModelName, gvSwModelVersion, "MP", "" + this.procId, "1005"], this.fnPointCallbackResultSave);
        			}

        		}
        		 //포인트 적립 후 콜백 (2021.06.15 적립만 따로하는 버튼은 없애기로 함. 사용+적립 버튼에서 사용포인트가 0인경우에 적립으로 처리되기로)
        		, fnPointCallbackResultSave : function(callbackName, result){
        			util.logInfo("*****mpPoint fnPointCallbackResultSave START (포인트 적립 후 콜백) ***** ");
    				nativeApp.removeASyncApiListener(callbackName, this.listenerIdA); // 리더기 카드체크하는 리스너 해제함수.
    				var vsResult = result.substring(0, result.lastIndexOf("$$^")); // native 데이터 중 마지막 $$^를 제거    			
    				
    				util.logInfo("*****mpPoint fnPointCallbackResultSave Resultdata == >  " + vsResult);
    				vsResult = JSON.parse(vsResult); 
    				var vsCode = vsResult.ResultCode;
    				if(vsCode == "0"){ // 정상코드
    					if(vsResult.Data["Status"] == "APPROVE"){ // 정상 승인
    						
    						/** 누적포인트 : 부스트업 포인트 (추가할인)
    						 *  포인트할인후금액 : 총금액 - 실제 차감된 금액
    						 *  적립포인트 : 적립금액
    						 *  거래금액 : 실제 차감된 금액
    						 *  가용포인트 : 남은 포인트
    						 *  취소시에는 실제 차감된 금액(사용자가 입력한 포인트가 아닌)을 파라미터로 보내줘야 정상 취소된다. (거래금액을 넣어야함. 누적포인트(부스트업 차감)등은 합쳐서 보내지 않는다. 거래금액으로 보내야한다.)
    						 *  적립시에도 사용이 되는 경우가 있다. 이때 플래그를 어떻게 구분해야할지 조치 필요.
    						 *  적립 취소시에 총금액 (적립 사용시에 보냈던 금액)
    						 *  
    						 * **/
    						
    						// 차감 및 할인금액의 합계 :  부스트업 금액(알림메세지1) + 할인금액(포인트할인금액)
                        	orderInfo.POS_ODHDR_T.JCD_CARD_AMT = Number(vsResult.Data["알림메세지1"]) + Number(vsResult.Data["포인트할인금액"]); // 적립의 경우 거래금액은 총금액이 내려오기 때문에 jcd_card_amt에 누적포인트 + 포인트할인금액만 넣어준다.
                        	
//                        	orderInfo.POS_ODHDR_T.EXP_PAY_AMT = this.totSaleAmt.replace(/,/gi, ""); // 계산 총금액
//                        	orderInfo.POS_ODHDR_T.GST_PAY_AMT = orderInfo.POS_ODHDR_T.JCD_CARD_AMT // 고객이 낸 금액 (현금인 경우에 결제 금액은 7000원이나 10000원을 낼수가 있다. EXP : 7000, GST : 10000 이 된다.)
//                        	orderInfo.POS_ODHDR_T.RET_PAY_AMT = Number(orderInfo.POS_ODHDR_T.JCD_CARD_AMT) - Number(orderInfo.POS_ODHDR_T.EXP_PAY_AMT); // 위의 두 금액의 차액 ( 거스름 돈이라고 생각하면 됨.) 
    						
    						// POS_ODJCD_T 테이블에 저장하기 위한 값 저장.
    						this.POS_ODJCD_T.SHOP_CD = gShopCd; // 매장코드
    						this.POS_ODJCD_T.SALE_DATE = saleDate	//영업일자
    						this.POS_ODJCD_T.ORDER_NO = "";	// 주문번호
    						this.POS_ODJCD_T.LINE_NO = "";	// 라인번호
    						this.POS_ODJCD_T.SEQ_NO	= ""; // 라인일련번호
    						this.POS_ODJCD_T.POS_NO	 = gPosNo; //포스번호
    						this.POS_ODJCD_T.SALE_YN = "Y";	//판매여부(Y:판매 N:반품(취소))
    						this.POS_ODJCD_T.JCD_CARD_NO = vsResult.Data["카드번호"]; // 제휴카드번호
    						this.POS_ODJCD_T.JCD_CD	= "" //제휴할인코드 (SCD_JCDHD_T 테이블의 jcd_cd 값 : AAAA, ZBNK 등의 값)
    						this.POS_ODJCD_T.JCD_TYPE_FG = "M"; //제휴카드유형구분 ( CCD_CODEM_T : 035 ) 1:OCBS 2:SKT 3:KTF 4:LGT
    						
    						if(orderInfo.POS_ODHDR_T.JCD_CARD_AMT == "0" || !orderInfo.POS_ODHDR_T.JCD_CARD_AMT ){ // 부스트업/할인이 없는 경우.
    							this.POS_ODJCD_T.JCD_PROC_FG = "1"; // 적립셋팅. 제휴카드처리구분 ( CCD_CODEM_T : 036 ) 0:할인 1:적립 2:사용 3:할인취소 4:적립취소 5:사용취소 6:적립사용 7:적립사용취소 9:조회
    						}else{
    							// 사용적립셋팅.(적립만 했지만 부스트업/할인등이 되는 경우가 있다. 이때는 사용적립(6)을 셋팅한다. 
    							this.POS_ODJCD_T.JCD_PROC_FG = "6"; // 사용적립 셋팅. 제휴카드처리구분 ( CCD_CODEM_T : 036 ) 0:할인 1:적립 2:사용 3:할인취소 4:적립취소 5:사용취소 6:적립사용 7:적립사용취소 9:조회
    						}
    						
    						
    						this.POS_ODJCD_T.APPR_LOG_NO = ""; // 승인로그번호 ( 결제내역 저장하는 부분에 채번하는 부분 있음. 가져다 쓰면됨.
    						this.POS_ODJCD_T.APPR_AMT = this.totSaleAmt.replace(/,/gi, ""); // 결제 금액 (총금액)
    						
    						var vnJcdDcAmt = 0;
    						var vsJcdOcc = 0;
    						var vnJcdAvl = 0;
    						var vnJcdUse = 0;
    						var vnJcdRem = 0;
    						if(!!vsResult.Data["포인트할인금액"]){
    							vnJcdDcAmt = vsResult.Data["포인트할인금액"];
    						}    						
    						if(!!vsResult.Data["적립포인트"]){
    							vsJcdOcc = vsResult.Data["적립포인트"];
    						}
    						if(!!vsResult.Data["알림메세지1"]){ // 부스트업 포인트
    							vnJcdAvl = vsResult.Data["알림메세지1"];
    						}
    						if(!!vsResult.Data["MP포인트사용금액"]){ 
    							vnJcdUse = vsResult.Data["MP포인트사용금액"];
    						}
    						if(!!vsResult.Data["가용포인트"]){
    							vnJcdRem = vsResult.Data["가용포인트"];
    						}
    						this.POS_ODJCD_T.JCD_DC_AMT = vnJcdDcAmt; // 할인금액   
    						this.POS_ODJCD_T.JCD_OCC_POINT = vsJcdOcc //제휴카드-발생포인트			
    						this.POS_ODJCD_T.JCD_AVL_POINT = vnJcdAvl; // MP포인트에서는 알림메세지1이 부스트업 할인 금액으로 사용됨.
    						this.POS_ODJCD_T.JCD_USE_POINT = vnJcdUse; // 내 포인트에서의 실제 차감된 포인트 [MP포인트사용금액].
    						this.POS_ODJCD_T.JCD_REM_POINT = vnJcdRem; //잔여포인트.   MP포인트에서 '포인트할인후금액'은 총금액-거래금액(실제 차감된 포인트)이다. MP포인트에서 가용포인트가 남은포인트임. 
    						
    						//this.POS_ODJCD_T.JCD_REM_POINT = vsResult.Data["할인금액"]; // 
    						//this.POS_ODJCD_T.JCD_REM_POINT = vsResult.Data["할인후금액"]; // mp포인트 할인 및 적립 후 최종금액?
    						
    						this.POS_ODJCD_T.EMP_NO = loginEmpNo; //판매원번호 
    						this.POS_ODJCD_T.JCD_PAY_FG = "02"; // 적립거래구분 01:현금 02:신용카드 03:직불카드 04:자사카드
    						this.POS_ODJCD_T.VAN_TERM_NO = BIZ_CLS_SINGLE_CAT_ID // 밴사터미널번호
    						this.POS_ODJCD_T.APPR_NO = vsResult.Data["승인번호"];
    						var vsCurDt = moment().format("YYYYMMDDHHmmss");
    						var vsCurDtYY = vsCurDt.substr(0,2); // 현재 년도 앞 2자리
    						var vsApproveDt = vsCurDtYY + vsResult.Data["승인일자"];
    						var vsApprTime = vsResult.Data["거래일시"].substr(6,6);
    						this.POS_ODJCD_T.APPR_DATE = vsApproveDt; // 승인일자
    						this.POS_ODJCD_T.APPR_TIME = vsApprTime; // 승인시간
    						
    						
    						this.POS_ODJCD_T.APPR_MSG = vsResult.Data["응답메세지1"] + " " + vsResult.Data["응답메세지2"];
    						
    						var vsBroadMsg = vsResult.Data["알림메세지2"];
    						
    						if(!!vsResult.Data["알림메세지3"]){
    							if(!vsBroadMsg){
    								vsBroadMsg += vsResult.Data["알림메세지3"];
    							}else{
    								vsBroadMsg += "\r\n" + vsResult.Data["알림메세지3"];
    							}
    						}
    						
    						if(!!vsResult.Data["알림메세지4"]){
    							if(!vsBroadMsg){
    								vsBroadMsg += vsResult.Data["알림메세지4"];
    							}else{
    								vsBroadMsg += "\r\n" + vsResult.Data["알림메세지4"];
    							}
    						}
    						
    						this.POS_ODJCD_T.BROAD_MSG = vsBroadMsg;
    						
    						this.POS_ODJCD_T.CRDCP_TERM_NO = vsResult.Data["가맹점번호"];
    						this.POS_ODJCD_T.TRADE_SERIAL_NUM = vsResult.Data["거래일련번호"];
    						this.POS_ODJCD_T.CNMK_CD = vsResult.Data["거래일련번호"]; // 거래일련번호는 할인취소할 때 필요한데, 컬럼이 명확히 없어서 CNMK_CD에 저장하여 취소시에 사용하도록 한다.
    						
    						this.POS_ODJCD_T.APPR_FULL_TIME = vsResult.Data["거래일시"];        						
    					     
    						this.POS_ODJCD_T.DEAL_NO = vsResult.Data["거래일련번호"];
    						this.POS_ODJCD_T.JCD_TYPE_FG_NM = "MP포인트";
    						
    						orderInfo.POS_ODJCD_T = this.POS_ODJCD_T;
    						
    						// 적립버튼을 눌렀으나, 실제로 추가 사용 및 적립이 되지 않은 경우
    						if((!orderInfo.POS_ODHDR_T.JCD_CARD_AMT || orderInfo.POS_ODHDR_T.JCD_CARD_AMT == "0") && (!vsResult.Data["적립포인트"] || vsResult.Data["적립포인트"] == "0")){    							
    							var dataObj = {
            							  button1Show : false
            							, button1Name : ""
            							, button1Func : ""
            							, button2Show : true
            							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
            							, button2Func : this.fnGoPaymentChoiceView
            							, message     : util.languageObjReturn(langCode, 'mpAccmulateMsg1') //"포인트사에 의해 적립이 적용되지 않았습니다." 
            						}; 
              					eventBus.$emit('alertPopupIndex', dataObj);      
    						}else if((!!orderInfo.POS_ODHDR_T.JCD_CARD_AMT && orderInfo.POS_ODHDR_T.JCD_CARD_AMT != "0") && (!vsResult.Data["적립포인트"] || vsResult.Data["적립포인트"] == "0")){
    							// 적립버튼을 눌렀으나, 실제로 추가 사용은 되었고  적립이 되지 않은 경우    							
    							var dataObj = {
            							  button1Show : false
            							, button1Name : ""
            							, button1Func : ""
            							, button2Show : true
            							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
            							, button2Func : this.fnGoPaymentChoiceView
            							, message     : util.languageObjReturn(langCode, 'mpAccmulateMsg2') // "포인트사에 의해 적립은 처리되지 않았으나 추가 할인이 적용 되었습니다." 
            						}; 
              					eventBus.$emit('alertPopupIndex', dataObj);      
    						}else if((!!orderInfo.POS_ODHDR_T.JCD_CARD_AMT && orderInfo.POS_ODHDR_T.JCD_CARD_AMT != "0") && (!!vsResult.Data["적립포인트"] && vsResult.Data["적립포인트"] != "0")){
    							// 적립버튼을 눌렀으나, 실제로 추가 사용이 되었고  적립도 된 경우    							
    							var dataObj = {
            							  button1Show : false
            							, button1Name : ""
            							, button1Func : ""
            							, button2Show : true
            							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 확인 ]
            							, button2Func : this.fnGoPaymentChoiceView
            							, message     : util.languageObjReturn(langCode, 'mpAccmulateMsg3') // "포인트사에 의해 적립 및 추가 할인이 적용 되었습니다."  
            						}; 
              					eventBus.$emit('alertPopupIndex', dataObj);      
    						}else{
    							util.logInfo(" ***** mpPoint fnNetCancelCommand 적립 후 시작 전 *****");
    							// mpPoint 적립 후 NetCancel파일 생성을 먼저하기 때문에, NetCancel 데몬이 중지 되도록 함수를 수행한다.
    							util.fnNetCancelCommand(0, 10);
        						
        						// 적립이 성공되면 결제수단 화면으로 이동한다.
    							this.fnGoPaymentChoiceView();
    						}
    						    						
    					}else{
    						var dataObj = {
  								  button1Show : false
  								, button1Name : ""
  								, button1Func : ""
  								, button2Show : true
  								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 아니오 ]
  								, button2Func : ""
  								, message     : util.languageObjReturn(langCode,  'pointSaveFail') + " [" + vsResult.Data["응답메세지1"] + vsResult.Data["응답메세지2"] + "]" // [ "포인트 적립에 실패했습니다." ]
  							};
  		    				eventBus.$emit('alertPopupIndex', dataObj);
  		    			return false;
    					}
    				}else{
    					var dataObj = {
								  button1Show : false
								, button1Name : ""
								, button1Func : ""
								, button2Show : true
								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 아니오 ]
								, button2Func : ""
								, message     : util.languageObjReturn(langCode,  'pointSaveFail') + " [" + vsResult.ResultCode + "]" // [ "포인트 적립에 실패했습니다." ]
							};
		    				eventBus.$emit('alertPopupIndex', dataObj);
		    			return false;
    				}
        			
        		}
        		// 4자리마다 "-"를 붙인다.
        		, fnSplitNo : function(paNo){ 
        			var vsCnt = paNo.length / 4; // 4자리로 나눈다.
        			vsCnt = parseInt(vsCnt); // 양의정수로 변환
        			if(vsCnt == 0){
        				return paNo;
        			}
        			var rtnNo = "";
        			// 4자리 마다 "-"를 붙이기 위해 4자리로 자른 수만큼 for문
        			for(var i=0;i<vsCnt;i++){
        				var vnIdxS ="";
        					vnIdxS = (i*4);
        				var vsNo = paNo.substr(vnIdxS,4);
        				rtnNo += vsNo + "-";
        				
        				// 만약 마지막 인덱스일 때, 4자리가 안되서 나머있는 No를 붙인다.
        				if(i == vsCnt-1){
        					var vsEtcNoAddCnt  = vnIdxS + 4;
        					var vsEtcNo = paNo.substring(vsEtcNoAddCnt);
        					if(!vsEtcNo){ // 여분의 NO가 없고 4의배수로 딱 떨어지면 마지막에 "-"를 제거한다.
        						rtnNo = rtnNo.slice(0, -1);
        					}else{ // 여분의 NO가 있다면 뒤에 붙인다.
        						rtnNo += paNo.substring(vsEtcNoAddCnt);
        					}
        				}
        			}
        			return rtnNo;        			
        		}
        		, fnDirectBtn : function(){ // 직접입력 버튼을 클릭하면 키패드를 활성화 한다.
        			util.logInfo("*****mpPoint fnDirectBtn Start*****");
        			var result = nativeApp.functionCallSync(["FDK_CreditCancel"]); // 카드 리더기 대기 취소
        			this.fnStopBarCodeReader(); // 카메라 구동 스탑.
        			this.barcodeNo = ""; // 바코드 번호 제거
        			this.remainMile = 0; // 잔여포인트 0원 처리.
        			this.directYn = "Y"; // 직접입력 Y로 수정 (직접입력 화면여부)
        			$("#mpDirectBtnDiv").hide();
        			$("#mpImgDiv").hide();
        			$("#mpNumbPadDiv").show();
        		}
        		, creditApproveCallbackListener : function(data) {
					util.logInfo('*** mpPoint creditApproveCallbackListener START ***');
					try {
						var cbCode = "9";
						var cbData = "";
	
						
						try {
							var jsonData = JSON.parse(data);
	
							cbCode = jsonData["Code"];
							cbData = jsonData["Data"];
						} catch (e) {
							util.logError("***** mpPoint creditApproveCallbackListener JSON.parse(data) catch *****");
						}
						util.logDebug('*** cbCode / Data ***' + cbCode + " / " + cbData);
						$('#divDebug').html("<p>" + cbCode + " : " + cbData + "</p>");
							
								
						if (cbCode == "0") { // 결재중입니다.
							this.readMsg = util.languageObjReturn(langCode, 'pointSearching'); // 포인트를 조회하고 있습니다.
							 		 
							// 결제가 진행중입니다. 잠시만 기다려주세요. 음성추가.
//	                    	var paramSrc = "./audio/22.mp3";
	         			    // string으로 보내면 해당 src한건 수행, 배열로 보내면 배열만큼 연속적으로 음성안내
							// 수행 (한글src만 보내면됨)	         			    
//	                    	util.fnAudioPlay(paramSrc); // 음성안내 공통함수 호출
						} else if (cbCode == "1") { // [카드인식요류] 카드를 다시 읽혀 주세요.
							$('#creditMsg1').html(util.languageObjReturn(langCode, 'msg_callback_9')); // IC 카드를 확인 후, 다시 읽혀주세요.
						} else if (cbCode == "2") { // Chip카드입니다. IC카드를 삽입해주세요
//							$('#creditMsg1').html(util.languageObjReturn(langCode, 'msg_callback_7'));
//							$('#creditMsg2').html(util.languageObjReturn(langCode, 'msg_callback_8'));
						} else if (cbCode == "3") { // 서명이 너무 짧습니다. 다시 서명해 주세요.
							// showMessage(cbData, false, false);
						} else if (cbCode == "4") { // exception
//							$('#creditMsg1').html(util.languageObjReturn(langCode, 'msg_callback_5')); // 처리 실패했습니다.
						} else if (cbCode == "5") { // Chip카드입니다. IC카드를 삽입해주세요
							
							this.readMsg = util.languageObjReturn(langCode, 'pointRead'); //바코드 인식 및 카드를 읽혀주세요.
							
							// 카드를 삽입해주세요. 음성추가.
//	                    	var paramSrc = "./audio/1.mp3";
	         			    // string으로 보내면 해당 src한건 수행, 배열로 보내면 배열만큼 연속적으로 음성안내
							// 수행 (한글src만 보내면됨)
//	                    	util.fnAudioPlay(paramSrc); // 음성안내 공통함수 호출
							
						} else if (cbCode == "9") { // 처리 완료
//							this.readMsg = util.languageObjReturn(langCode, 'pointSearching'); // 포인트를 조회하고 있습니다.							
						} else {
							
						}
					} catch (e) {
						util.logError("[creditApproveCallbackListener] mpPoint Exception : " + e.message);						 	
						//this.showMessage("[creditApproveCallbackListener] Exception: " + e.message, false, false);
					}
				},
				fn_mileClick : function(param){
					if(param == "RESET"){
						this.useMile = "";
					}else if(param == "DEL"){
						var vsUseMile = this.useMile.replace(/,/gi, "");
						vsUseMile = paymentChoiceService.number_keypad( param, vsUseMile);
						this.useMile = util.numberWithCommas(vsUseMile);
					}else{
						var vsUseMile = this.useMile.replace(/,/gi, "");
						vsUseMile = vsUseMile + param;
						this.useMile = util.numberWithCommas(vsUseMile); // 총금액(할인대상금액)
					}
				}
        		
	        }
	    };
	    return returnTemplate;
	}
	
	// 현금영수증 승인화면
	this.fnGetCashReceipts = function(){
		let swiperStamp ; //레이어 내부 슬라이드 시작
		let returnTemplate = { template: '#cashReceipts'
        	, data : function () {
        		return {
        			phoneMask : ""
        	      , phoneNumber : ""
        	      , cashReceiptsBtn : util.languageObjReturn(langCode,  'toApprove') /** 승인하기 **/
        	      , cashReceiptsAmtTxt : util.languageObjReturn(langCode,  'targetAmount') /** 대상금액 **/
        	      , cashReceiptTitle : util.languageObjReturn(langCode,  'cashReceiptTitle') /** 현금영수증 승인하기 **/
        	      , consumer : util.languageObjReturn(langCode,  'consumer') /** 소비자 **/
        	      , buisnessman : util.languageObjReturn(langCode,  'buisnessman') /** 사업자 **/
        	      , noluntaryIssuance : util.languageObjReturn(langCode,  'voluntaryIssuance') /** 자진발급 **/
        	      , deselect : util.languageObjReturn(langCode,  'deselect') /** 선택해제 **/
        	      , cashTxt : util.languageObjReturn(langCode,  'cashTxt') /** * 자진발급 및 비승인(선택해제)인 경우에는 입력한 번호가 무시됩니다. **/
        	      , totalAmt : "0"
    			  , phoneNumberIn : util.languageObjReturn(langCode,  'phoneNumberIn')
    			  , cashRadioVal : "00"
    			  , selfIssue : ""
    			  , listenerIdCash : ""
    			  , POS_ODCSH_T : []
        		  , taxEnvVal: ""
        		  , tranType : ""
        		  , tgPayCompleteVal : "Y"	  
    			  , scPayCompleteVal : "Y"	  
    			  , cashReceipts : "C"	  //현금영수증에서만 사용, 톨게이트 현금영수증에서 같이 사용 : T
        		  //, pointCoType : "F"
        		}
        	},
            created : function() {
            	util.logInfo("***** 현금영수증 화면 시작 cashReceipts create *****");
            	//this.phoneNumber        = util.languageObjReturn(langCode,  'phoneNumber');
            	this.totalAmt = util.numberWithCommas(this.$route.params.totalAmt);
            	util.logInfo("***** 현금영수증 화면 시작 cashReceipts param totalAmt == >> " + this.totalAmt);
            	if(this.$route.params.tgPayCompleteVal != undefined) {
            		this.tgPayCompleteVal = this.$route.params.tgPayCompleteVal;
            		if(this.tgPayCompleteVal == "Y") {
            			//톨게이트 선불카드 결제
            			this.cashReceipts = "T";
            		} else {
            			//톨게이트 복합결제
            			this.cashReceipts = "C";
            		}
            	}
            	util.logInfo("***** 현금영수증 화면 시작 cashReceipts param tgPayCompleteVal == >> " + this.tgPayCompleteVal);
            	
            	if(this.$route.params.scPayCompleteVal != undefined) {
            		this.scPayCompleteVal = this.$route.params.scPayCompleteVal;
            		if(this.scPayCompleteVal == "Y") {
            			//슈퍼콘 선불카드 결제
            			this.cashReceipts = "T";
            		} else {
            			//슈퍼콘 복합결제
            			this.cashReceipts = "C";
            		}
            	}
            	util.logInfo("***** 현금영수증 화면 시작 cashReceipts param scPayCompleteVal == >> " + this.scPayCompleteVal);
            }
            , mounted : function() {
            	this.phoneNumber = "";
            	this.phoneMask = "";
            	$("#btnCashReceiptExe").show();
            }
            , methods : {
            	// 전화번호 키패드
            	fn_number_keypad : function (key) {
            		this.phoneNumber = paymentChoiceService.number_keypad( key, this.phoneNumber);

            		if(this.phoneNumber.substr(0, 2) == "02") {
            			if (this.phoneNumber.length > 10){
            				this.phoneNumber = this.phoneNumber.slice(0, -1);
    					}
            		} else if(this.phoneNumber.substr(0, 3) == "050") {
            			if (this.phoneNumber.length > 12){
            				this.phoneNumber = this.phoneNumber.slice(0, -1);
    					}
            		} else {
            			if (this.phoneNumber.length > 11){
            				this.phoneNumber = this.phoneNumber.slice(0, -1);
    					}
            		}
                	//var x1 = paymentChoiceService.autoHypenPhone(this.phoneNumber);
                	var x1 = paymentChoiceService.fnPhoneNumMasking(this.phoneNumber);
                	//console.log('x1'  , x1);
                	this.phoneMask = x1;
                	
                },// end fn_number_keypad
                fnGoBack : function() {
                	if(this.cashReceipts != "T"){
                		//선불카드&기타 복합결제일때
                		gCombinePayVal = "Y";
        	  	   		router.push({path: '/paymentChoiceView'});
                	} else {
            			//현금영수증 back버튼 누르면 현금영수증 승인없이 결제로 이동
            			//톨게이트 잔액부족으로 복합결제
            			this.fnGoToPayment();
                		//router.push({path: '/easyPayment'});
                	}
            	},                
            	makeMessageAlert(messageObj) {
	    			this.$root.$emit( "notiMessage" ,   messageObj  );
            	},
            	// 승인하기 버튼 클릭
            	cashReceiptsExe : function(){
            		util.logInfo("****현금영수증 승인버튼 클릭 ***** ");
            		util.logInfo("****현금영수증 승인버튼 파라미터 ***** ");
            		$("#btnCashReceiptExe").hide();
            		// 비승인과 자진발급인 경우에는 번호를 입력할 필요가 없음.
            		if(this.cashRadioVal != "" && this.cashRadioVal != "02"){ // 비승인이 아니고, 자진발급이 아닌경우
            			if(!this.phoneNumber){
                			var dataObj = {
    								  button1Show : false
    								, button1Name : ""
    								, button1Func : ""
    								, button2Show : true
    								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 아니오 ]
    								, button2Func : ""
    								, message     : util.languageObjReturn(langCode,  'phoneNumberIn') // 번호를 입력하세요.
    							};
    	    				eventBus.$emit('alertPopupIndex', dataObj);
    	    				$("#btnCashReceiptExe").show();
    	    				return;
                		}
            		}
            		
            		/**
            		 * 현금영수증 승인 : FDK_CashSave_Purchase
            		 * param1 String : 단말기 번호
            		 * param2 String : 현금영수증 금액 
            		 * param3 String : sw모델
            		 * param4 String : sw버전
            		 * param5 String : 현금영수증 사용자 코드 (00 고정)
            		 * param6 String : 현금영수증 거래 구분 (00: 소비자 소득공제, 01: 사업자 지출증빙)
            		 * param7 String : 카드번호 ( 없을 경우에 "" 입력 )
            		 * param8 String : 자진발급여부 - 자진발급 1, 자진발급 아닌경우 0
            		 *                 자진발급인 경우 카드번호는 입력받지 않으며 native에서 자동으로 '0100001234' 고정됨
            		 * @returns
            		 */  
            		try{
            			var vsAmt = Number(this.totalAmt.replace(/,/gi, ""));
//            			this.taxEnvVal = util.GetEnvXmlShopENV(128); // ( 부가세 여부 - 1:부가세포함, 0:부가세별도 )                		
//                		if(this.taxEnvVal == "1"){ // 부가세 포함
//                			vsAmt = Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT); // 부가세가 포함된 금액
//        				}else{ // 부가세 별도
//        					vsAmt = Number(orderInfo.POS_ODHDR_T.NO_TOT_SALE_AMT); // 부가세가 포함되지 않은 금액
//        				}
                		util.logInfo("***** FDK_CashSave_Purchase 라디오버튼 선택 값 == > " + this.cashRadioVal);
                		
                		// 비승인인 경우에 해당 함수를 호출(native 승인 안받고 바로 저장함)
                		if(this.cashRadioVal == ""){
                			this.fnCashReceiptsCallbackResultNoAppr();
                			return;
                		}
                		
                		if(this.cashRadioVal == "02"){ // 라디오 버튼에서 선택한 값이 자진발급 이라면 param8의 값을 1로 셋팅한다.
                			this.selfIssue = "1";
                			this.tranType = "00"; // 자진발급인 경우에 거래 구분은 소비자로 한다.
                		}else{ // 자진발급이 아니라면 param8의 값을 0으로 셋팅한다.
                			this.selfIssue = "0";
                			this.tranType = this.cashRadioVal;
                		}
                		util.logInfo("***** FDK_CashSave_Purchase param == > 금액 : " + vsAmt + ", 거래구분(소비자 00, 사업자 01, 자진발급 02) : " + this.tranType +", 휴대폰(카드) : " + this.phoneNumber + ", 자진발급여부(자진 1, 자진아님 0) : " + this.selfIssue);
                		// 마지막 파라미터는 1회용컵 보증금금액으로 아직 현금영수증에 기능추가가 안되어 있는 상황으로 빈값으로 보낸다. 2022-06-15
        				this.listenerIdCash = nativeApp.functionCallASync(["FDK_CashSave_Purchase", BIZ_CLS_SINGLE_CAT_ID, "" + vsAmt, gvSwModelName, gvSwModelVersion, "00", this.tranType, this.phoneNumber, this.selfIssue, ""], this.fnCashReceiptsCallbackResult);
            		}catch(e){
            			$("#btnCashReceiptExe").show();
            			util.logInfo("***** FDK_CashSave_Purchase cashReceiptsExe ERROR == > " + e.toString());
            		}
            		
            	},
            	// 승인하기 후 콜백 함수.
            	fnCashReceiptsCallbackResult : function(callbackName, result){
            		try{
            			nativeApp.removeASyncApiListener(callbackName, this.listenerIdCash); // 리더기 카드체크하는 리스너 해제함수.
        				var vsResult = result.substring(0, result.lastIndexOf("$$^")); // native 데이터 중 마지막 $$^를 제거    			
        				
        				
        				//단독 사업자 또는 복수사업자의 경우 1건만 있을때...
        				if(  BIZ_CLS_TYPE == '0'  ){
        		    		if(orderInfo.POS_ODHDR_T.GST_PAY_AMT == undefined){
        		    			orderInfo.POS_ODHDR_T.GST_PAY_AMT  = 0; //받은금액
        		    		}
        					orderInfo.POS_ODHDR_T.CRD_CARD_AMT = 0;
        				} 
        		  	   	
        				/******************************************
        				 * 카드헤더정보
        				 * 최광림 차장님 협의 컨펌
        				 ******************************************/
        				if(this.tgPayCompleteVal == "N" || this.scPayCompleteVal == "N") {
        					orderInfo.POS_ODHDR_T.EXP_PAY_AMT  = this.totalAmt.replace(/,/gi, "");	// 받을금액
            		  	   	orderInfo.POS_ODHDR_T.RET_PAY_AMT  = 0;		    // 거스름돈 (RET_PAY_AMT)
            		  	   	
            		  	   	if(orderInfo.POS_ODHDR_T.DCM_SALE_AMT != undefined){
            		  	   		orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.DCM_SALE_AMT;	// 매출금액
            			   		orderInfo.POS_ODHDR_T.EXP_PAY_AMT = this.totalAmt.replace(/,/gi, "");
            			   	} else {
            			   		orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;	// 매출금액
            			   		orderInfo.POS_ODHDR_T.EXP_PAY_AMT = this.totalAmt.replace(/,/gi, "");
            			   	}
        				} else {
        					orderInfo.POS_ODHDR_T.EXP_PAY_AMT  = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;	// 받을금액
            		  	   	orderInfo.POS_ODHDR_T.RET_PAY_AMT  = 0;		    							// 거스름돈 (RET_PAY_AMT)
            		  	   	
            		  	   	if(orderInfo.POS_ODHDR_T.DCM_SALE_AMT != undefined){
            			   		orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.DCM_SALE_AMT;	// 매출금액
            			   		orderInfo.POS_ODHDR_T.EXP_PAY_AMT = orderInfo.POS_ODHDR_T.DCM_SALE_AMT;
            			   	} else {
            			   		orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;	// 매출금액
            			   		orderInfo.POS_ODHDR_T.EXP_PAY_AMT = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;
            			   	}
            		  	   	
            		  	   	if(SHOP_INFO.VAT_CD == "0") {
            		  	   		orderInfo.POS_ODHDR_T.EXP_PAY_AMT += orderInfo.POS_ODHDR_T.VAT_AMT
            		  	   	}
        				}
        				
        				util.logInfo("***** 현금영수증 승인 후 콜백 함수 fnCashReceiptsCallbackResult Resultdata == >  " + vsResult);
        				vsResult = JSON.parse(vsResult); 
        				var vsCode = vsResult.ResultCode;
        				if(vsCode == "0"){ // 정상코드
        					if(vsResult.Data["Status"] == "APPROVE"){ // 정상 승인    						
        						// POS_ODJCD_T 테이블에 저장하기 위한 값 저장.
        						this.POS_ODCSH_T.SHOP_CD = gShopCd; // 매장코드
        						this.POS_ODCSH_T.SALE_DATE = saleDate	//영업일자
        						this.POS_ODCSH_T.ORDER_NO = "";	// 주문번호
        						this.POS_ODCSH_T.LINE_NO = "";	// 라인번호
        						this.POS_ODCSH_T.SEQ_NO	= ""; // 라인일련번호
        						this.POS_ODCSH_T.POS_NO	 = gPosNo; //포스번호
        						this.POS_ODCSH_T.SALE_YN = "Y";	//판매여부(Y:판매 N:반품(취소))
        						this.POS_ODCSH_T.CORNER_CD = ""; // 승인로그번호 ( 결제내역 저장하는 부분에 채번하는 부분 있음. 가져다 쓰면됨.
        						this.POS_ODCSH_T.CASH_AMT = vsResult.Data["거래금액"]; // 현금영수증금액
        						this.POS_ODCSH_T.APPR_AMT = vsResult.Data["거래금액"]; // 승인금액
        						this.POS_ODCSH_T.SVC_TIP_AMT = "0"; // 차장님께 물어봐야함.
        						this.POS_ODCSH_T.VAT_AMT = "0"; 
        						this.POS_ODCSH_T.APPR_LOG_NO = "";
        						this.POS_ODCSH_T.INS_DT = ""; 
        						this.POS_ODCSH_T.EMP_NO = loginEmpNo; //판매원번호
        						this.POS_ODCSH_T.EX_CD = ""; 
        						this.POS_ODCSH_T.EX_KRW = "";
        						this.POS_ODCSH_T.EX_EXP_AMT = "0"; 
        						this.POS_ODCSH_T.EX_IN_AMT = "0"; 
        						this.POS_ODCSH_T.EX_RET_AMT = "0"; 
        						this.POS_ODCSH_T.KR_RET_AMT = "0"; 
        						this.POS_ODCSH_T.EX_PAY_AMT = "0";
        						this.POS_ODCSH_T.KR_PAY_AMT = "0";
        						this.POS_ODCSH_T.KR_ETC_AMT = "0";
        						this.POS_ODCSH_T.PRE_PAY_FG = "";
        						this.POS_ODCSH_T.VAT_SALE_AMT = "0";
        						this.POS_ODCSH_T.NO_VAT_SALE_AMT = "0";
        						
        						this.POS_ODCSH_T.VAN_TERM_NO = BIZ_CLS_SINGLE_CAT_ID // 밴사터미널번호
        						this.POS_ODCSH_T.APPR_NO = vsResult.Data["승인번호"];
        						
        						var vsCurDt = moment().format("YYYYMMDDHHmmss");
        						var vsCurDtYY = vsCurDt.substr(0,2); // 현재 년도 앞 2자리
        						var vsApproveDt = vsCurDtYY + vsResult.Data["승인일자"];
        						var vsApprTime = vsResult.Data["거래일시"].substr(6,6);
        						this.POS_ODCSH_T.APPR_DATE = vsApproveDt; // 승인일자
        						this.POS_ODCSH_T.APPR_TIME = vsApprTime; // 승인시간
        						
        						this.POS_ODCSH_T.APPR_MSG = vsResult.Data["응답메세지1"] + " " + vsResult.Data["응답메세지2"];
        						this.POS_ODCSH_T.BROAD_MSG = vsResult.Data["알림메세지1"] + " " + vsResult.Data["알림메세지2"] 
        						                           + " " + vsResult.Data["알림메세지3"] + " "+ vsResult.Data["알림메세지4"];
        						this.POS_ODCSH_T.NOTICE_MSG = "";
        						this.POS_ODCSH_T.CRDCP_TERM_NO = vsResult.Data["가맹점번호"];
        						this.POS_ODCSH_T.TRADE_SERIAL_NUM = vsResult.Data["거래일련번호"]; // 넷캔슬 파일 삭제용으로 해당 컬럼으로 담는다.
        						this.POS_ODCSH_T.CNMK_CD = vsResult.Data["거래일련번호"]; // 거래일련번호는 컬럼이 명확히 없어서 CNMK_CD에 저장하여 취소시에 사용하도록 한다.
        						
        						this.POS_ODCSH_T.APPR_FULL_TIME = vsResult.Data["거래일시"];        						
        					     
        						this.POS_ODCSH_T.DEAL_NO = vsResult.Data["거래일련번호"];
        						    						
        						var vsApprIdtType = "";
        						var vsApprIdtFg = "";
        						if(this.cashRadioVal == "00"){ // 소비자(개인)
        							vsApprIdtType = "1"; // 개인
        							vsApprIdtFg = "2"; // 휴대폰
        						}else if(this.cashRadioVal == "01"){ // 사업자
        							vsApprIdtType = "2"; // 사업자
        							vsApprIdtFg = "4"; // 사업자번호
        						}else if(this.cashRadioVal == "02"){ // 자진발급
        							vsApprIdtType = "5"; // 자진발급
        							vsApprIdtFg = "5"; // 자진발급
        						}else{ // 값이 없다면 비승인
        							vsApprIdtType = "0"; // 비승인
        							vsApprIdtFg = "0"; // 비승인
        						}
        						this.POS_ODCSH_T.APPR_IDT_TYPE = vsApprIdtType; // 0 : 비승인(승인안하고저장), 1: 개인, 2: 사업자, 5: 자진발급
        						this.POS_ODCSH_T.APPR_IDT_FG = vsApprIdtFg; // 0: 비승인(승인안하고저장), 2 : 휴대폰 번호, 4: 사업자 번호, 5: 자진발급
        						this.POS_ODCSH_T.APPR_IDT_NO = vsResult.Data["카드번호"]; // 현금영수증 번호(카드번호)
        						this.POS_ODCSH_T.CARD_IN_FG = vsResult.Data["카드종류"]; // 카드 종류 ex) K, S
        						orderInfo.POS_ODCSH_T = this.POS_ODCSH_T;
        						
        						orderInfo.POS_ODHDR_T.CASH_AMT = Number(vsResult.Data["거래금액"]); // 승인금액
        						orderInfo.POS_ODHDR_T.GST_PAY_AMT = Number(orderInfo.POS_ODHDR_T.GST_PAY_AMT) + Number(vsResult.Data["거래금액"]); // 승인금액
        						
        						// 제휴할인 승인 후 NetCancel파일 생성을 먼저하기 때문에, NetCancel 데몬이 중지 되도록 함수를 수행한다.
        						util.fnNetCancelCommand(0, 10);
        						
        						//톨게이트일때 분기 필요 -> 선불금액 사용후 결제잔여금액이 남아있으면 결제화면 이동
        						if(this.tgPayCompleteVal == "Y" && this.scPayCompleteVal == "Y") {
        							orderPayRegService.orderPayReg(); // 저장로직 바로 수행.
        						} else {
        							//선불카드&기타 복합결제일때
        							gCombinePayVal = "Y";
        	        	  	   		router.push({path: '/paymentChoiceView'});
        						}
        						
        					}else{
        						$("#btnCashReceiptExe").show();
//        						this.readMsg = util.languageObjReturn(langCode, 'pointSearchFail'); // 포인트 조회에 실패했습니다.		    				
    		    				var dataObj = {
    									  button1Show : false
    									, button1Name : ""
    									, button1Func : ""
    									, button2Show : true
    									, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 아니오 ]
    									, button2Func : ""
    									, message     : util.languageObjReturn(langCode,  'cashFail') + "[" + vsResult.Data["응답메세지1"] + vsResult.Data["응답메세지2"] + "]" // [ 현금영수증 처리에 실패했습니다. ]
    								};
    		    				eventBus.$emit('alertPopupIndex', dataObj);
        					}
        				}else{
        					$("#btnCashReceiptExe").show();
        					var dataObj = {
  								  button1Show : false
  								, button1Name : ""
  								, button1Func : ""
  								, button2Show : true
  								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 아니오 ]
  								, button2Func : ""
  								, message     : util.languageObjReturn(langCode,  'cashFail') + "[승인 후 비 정상코드 리턴]" // [ 현금영수증 처리에 실패했습니다. ]
  							};
  	    				eventBus.$emit('alertPopupIndex', dataObj);
        				}
            		}catch(e){
            			$("#btnCashReceiptExe").show();
            			var dataObj = {
								  button1Show : false
								, button1Name : ""
								, button1Func : ""
								, button2Show : true
								, button2Name : util.languageObjReturn(langCode, 'noticeConfirm') // [ 아니오 ]
								, button2Func : ""
								, message     : util.languageObjReturn(langCode,  'cashFail') + "[승인 후 콜백 오류]" // [ 현금영수증 처리에 실패했습니다. ]
							};
	    				eventBus.$emit('alertPopupIndex', dataObj);
            		}
            		 
            	},
            	// 비승인 했을 때 함수. (체크박스 체크 안했을 때 비승인)
            	fnCashReceiptsCallbackResultNoAppr : function(){
    				util.logInfo("***** 현금영수증 비승인 함수 시작 *****");
    				
    				//단독 사업자 또는 복수사업자의 경우 1건만 있을때...
    				if(  BIZ_CLS_TYPE == '0'  ){
    		    		if(orderInfo.POS_ODHDR_T.GST_PAY_AMT == undefined){
    		    			orderInfo.POS_ODHDR_T.GST_PAY_AMT  = 0; //받은금액
    		    		}
    					orderInfo.POS_ODHDR_T.CRD_CARD_AMT = 0;
    				} 
    		  	   	
    				/******************************************
    				 * 카드헤더정보
    				 * 최광림 차장님 협의 컨펌
    				 ******************************************/
    		  	   	orderInfo.POS_ODHDR_T.EXP_PAY_AMT  = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;	// 받을금액
    		  	   	orderInfo.POS_ODHDR_T.RET_PAY_AMT  = 0;		    							// 거스름돈 (RET_PAY_AMT)
    		  	   	
    		  	   	if(orderInfo.POS_ODHDR_T.DCM_SALE_AMT != undefined){
    			   		orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.DCM_SALE_AMT;	// 매출금액
    			   		orderInfo.POS_ODHDR_T.EXP_PAY_AMT = orderInfo.POS_ODHDR_T.DCM_SALE_AMT;
    			   	} else {
    			   		orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;	// 매출금액
    			   		orderInfo.POS_ODHDR_T.EXP_PAY_AMT = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;
    			   	}
    		  	   	if(SHOP_INFO.VAT_CD == "0") {
    		  	   		orderInfo.POS_ODHDR_T.EXP_PAY_AMT += orderInfo.POS_ODHDR_T.VAT_AMT
    		  	   	}
    		  	   	
    				    				
					// POS_ODJCD_T 테이블에 저장하기 위한 값 저장.
					this.POS_ODCSH_T.SHOP_CD = gShopCd; // 매장코드
					this.POS_ODCSH_T.SALE_DATE = saleDate	//영업일자
					this.POS_ODCSH_T.ORDER_NO = "";	// 주문번호
					this.POS_ODCSH_T.LINE_NO = "";	// 라인번호
					this.POS_ODCSH_T.SEQ_NO	= ""; // 라인일련번호
					this.POS_ODCSH_T.POS_NO	 = gPosNo; //포스번호
					this.POS_ODCSH_T.SALE_YN = "Y";	//판매여부(Y:판매 N:반품(취소))
					this.POS_ODCSH_T.CORNER_CD = ""; // 승인로그번호 ( 결제내역 저장하는 부분에 채번하는 부분 있음. 가져다 쓰면됨.
					this.POS_ODCSH_T.CASH_AMT = Number(this.totalAmt.replace(/,/gi, "")); // 현금영수증금액
					this.POS_ODCSH_T.APPR_AMT = Number(this.totalAmt.replace(/,/gi, "")); // 승인금액
					this.POS_ODCSH_T.SVC_TIP_AMT = "0"; // 차장님께 물어봐야함.
					this.POS_ODCSH_T.VAT_AMT = "0"; 
					this.POS_ODCSH_T.APPR_LOG_NO = "";
					this.POS_ODCSH_T.INS_DT = ""; 
					this.POS_ODCSH_T.EMP_NO = loginEmpNo; //판매원번호
					this.POS_ODCSH_T.EX_CD = ""; 
					this.POS_ODCSH_T.EX_KRW = "";
					this.POS_ODCSH_T.EX_EXP_AMT = "0"; 
					this.POS_ODCSH_T.EX_IN_AMT = "0"; 
					this.POS_ODCSH_T.EX_RET_AMT = "0"; 
					this.POS_ODCSH_T.KR_RET_AMT = "0"; 
					this.POS_ODCSH_T.EX_PAY_AMT = "0";
					this.POS_ODCSH_T.KR_PAY_AMT = "0";
					this.POS_ODCSH_T.KR_ETC_AMT = "0";
					this.POS_ODCSH_T.PRE_PAY_FG = "";
					this.POS_ODCSH_T.VAT_SALE_AMT = "0";
					this.POS_ODCSH_T.NO_VAT_SALE_AMT = "0";
					
					this.POS_ODCSH_T.VAN_TERM_NO = BIZ_CLS_SINGLE_CAT_ID // 밴사터미널번호
					this.POS_ODCSH_T.APPR_NO = "";
					
					var vsCurDt = moment().format("YYYYMMDDHHmmss");
					var vsCurDtYY = vsCurDt.substr(0,2); // 현재 년도 앞 2자리
					var vsCurDtYmd = vsCurDt.substr(0,8); // 현재 년도 앞 2자리
					var vsApproveDt = vsCurDtYmd;
					var vsApprTime = vsCurDt.substr(8,6);
					this.POS_ODCSH_T.APPR_DATE = vsApproveDt; // 승인일자
					this.POS_ODCSH_T.APPR_TIME = vsApprTime; // 승인시간
					
					this.POS_ODCSH_T.APPR_MSG = "";
					this.POS_ODCSH_T.BROAD_MSG = "";
					this.POS_ODCSH_T.NOTICE_MSG = "";
					this.POS_ODCSH_T.CRDCP_TERM_NO = "";
					this.POS_ODCSH_T.TRADE_SERIAL_NUM = "";
					this.POS_ODCSH_T.CNMK_CD = "";
					
					this.POS_ODCSH_T.APPR_FULL_TIME = vsCurDt;        						
				     
					this.POS_ODCSH_T.DEAL_NO = "";
					    						
					var vsApprIdtType = "";
					var vsApprIdtFg = "";
					if(this.cashRadioVal == "00"){ // 소비자(개인)
						vsApprIdtType = "1"; // 개인
						vsApprIdtFg = "2"; // 휴대폰
					}else if(this.cashRadioVal == "01"){ // 사업자
						vsApprIdtType = "2"; // 사업자
						vsApprIdtFg = "4"; // 사업자번호
					}else if(this.cashRadioVal == "02"){ // 자진발급
						vsApprIdtType = "5"; // 자진발급
						vsApprIdtFg = "5"; // 자진발급
					}else{ // 값이 없다면 비승인
						vsApprIdtType = "0"; // 비승인
						vsApprIdtFg = "0"; // 비승인
					}
					this.POS_ODCSH_T.APPR_IDT_TYPE = vsApprIdtType; // 0 : 비승인(승인안하고저장), 1: 개인, 2: 사업자, 5: 자진발급
					this.POS_ODCSH_T.APPR_IDT_FG = vsApprIdtFg; // 0: 비승인(승인안하고저장), 2 : 휴대폰 번호, 4: 사업자 번호, 5: 자진발급
					this.POS_ODCSH_T.APPR_IDT_NO = ""; // 현금영수증 번호(카드번호)
					this.POS_ODCSH_T.CARD_IN_FG = ""; // 카드 종류 ex) K, S
					orderInfo.POS_ODCSH_T = this.POS_ODCSH_T;
					
					orderInfo.POS_ODHDR_T.CASH_AMT = Number(this.totalAmt.replace(/,/gi, ""));  // 승인금액
					orderInfo.POS_ODHDR_T.GST_PAY_AMT += Number(this.totalAmt.replace(/,/gi, ""));  // 승인금액
					
					// 제휴할인 승인 후 NetCancel파일 생성을 먼저하기 때문에, NetCancel 데몬이 중지 되도록 함수를 수행한다.
//					util.fnNetCancelCommand(0, 10);
					
					orderPayRegService.orderPayReg(); // 저장로직 바로 수행.
    						
            	},
            	fnDeselect : function(){
					//name이 fruit인 라디오 버튼 일괄 해제
					$("input:radio[name='fruit']").prop('checked',false);
					this.cashRadioVal = "";
				},
				fnGoToPayment : function() {
        			//0원 결제정보 설정
        			//paymentChoiceService.setPointPaymentInfo();
        	    	
        			if(orderInfo.POS_ODHDR_T.GST_PAY_AMT == undefined) {
        				if(orderInfo.TOLLGATE_INFO !== undefined) {
        					if(this.tgPayCompleteVal == "N" && orderInfo.TOLLGATE_INFO.amount !== undefined) {
        						orderInfo.POS_ODHDR_T.GST_PAY_AMT = orderInfo.TOLLGATE_INFO.amount; //받은금액
        					} else {
        						orderInfo.POS_ODHDR_T.GST_PAY_AMT = 0; //받은금액
        					}
        				} else {
        					orderInfo.POS_ODHDR_T.GST_PAY_AMT = 0; //받은금액
        				}
        				
        				if(orderInfo.SUPERCON_INFO !== undefined) {
        					if(this.scPayCompleteVal == "N" && orderInfo.SUPERCON_INFO.useAmount !== undefined) {
        						orderInfo.POS_ODHDR_T.GST_PAY_AMT = Number(orderInfo.SUPERCON_INFO.useAmount); //받은금액
        					} else {
        						orderInfo.POS_ODHDR_T.GST_PAY_AMT = 0; //받은금액
        					}
        				} else {
        					orderInfo.POS_ODHDR_T.GST_PAY_AMT = 0; //받은금액
        				}
        			}
        			
        			orderInfo.POS_ODHDR_T.CRD_CARD_AMT = 0;
        	  	   	orderInfo.POS_ODHDR_T.EXP_PAY_AMT  = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;	// 받을금액
        	  	   	orderInfo.POS_ODHDR_T.RET_PAY_AMT  = 0;		    							// 거스름돈 (RET_PAY_AMT)
        	  	   	
        	  	   	if(orderInfo.POS_ODHDR_T.DCM_SALE_AMT != undefined) {
        	  	   		orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.DCM_SALE_AMT;	// 매출금액
        	  	   	} else {
        	  	   		orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;	// 매출금액
        	  	   	}
        	  	   	
        	  	   	if(this.tgPayCompleteVal == "N" || this.scPayCompleteVal == "N") {
        	  	   		router.push({path: '/paymentChoiceView'});
        	  	   	} else {
        	  	   		paymentChoiceView.fnCardReaderStatusCallBack();
        	  	   	}
        		}
                
            }// end methods
            , updated : function(){
            }
            , beforeUpdate : function(){
                
            }
            , destroyed : function(){
				//swiperStamp = undefined;
            }
       };
       return returnTemplate;
    },
    
    this.fnTollgatePayView = function() {
    	let returnTemplate = { template: '#tollgatePayView'
        	, data : function () {
        		return {
        			totSaleAmt : "0" 	//주문금액
    				, resultingBalance : "0" 	//t선불금액 남은 잔액
					, reqAmt : "0"		//주문요청금액
					, remainAmt : "0"		//사용후잔액
					, addPayAmt : "0"	//추가결제금액
					, tgPayCompleteVal : "Y" 	//결제완료값 Y이면 추가금액x N이면 추가금액 발생 -> 복합결제
					, barcodeNo : "" 	//바코드값
					, barcodeType : ""  //바코드타입	
					, productCodes : ""  //톨게이트 상품 코드 몰록	
					, productNm : ""  //톨게이트 상품명	
					, discountList : [] // 할인목록
					, discountMaxObj : {} // 할인목록중, 상품 가격이 최대값인것...
					, discountAmount : 0 // 할인금액..
        		}
        	}
    		, created : function() { 
    			util.logInfo("***** 톨게이트 화면 시작 fnTollgatePayView create *****");
    			this.barcodeNo = this.$route.params.obj.barcodeNo;
				this.barcodeType = this.$route.params.obj.barcodeType;
				this.totSaleAmt = Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT); // 주문금액

				if(this.barcodeType == "P"){ // 선불카드

					if(orderInfo.TOLLGATE_DC_INFO !== undefined && orderInfo.TOLLGATE_DC_INFO.discountAmount > 0){
						this.totSaleAmt = this.totSaleAmt - orderInfo.TOLLGATE_DC_INFO.discountAmount;
					}

					this.resultingBalance = Number(this.$route.params.obj.resultingBalance);
					//this.resultingBalance = 500;
					this.remainAmt = this.resultingBalance - this.totSaleAmt;
					if(this.remainAmt < 0){
						this.remainAmt = 0;
					}
					
					if(this.totSaleAmt > this.resultingBalance){ //결제 금액이 잔액보다 많은 경우 남은 잔액을 요청금액으로 세팅
	    				this.reqAmt = this.resultingBalance;
	    				this.tgPayCompleteVal = "N";
						this.addPayAmt = this.totSaleAmt - this.resultingBalance;
	    			} else { //결제 금액을 요청금액으로 세팅
    					this.reqAmt = this.totSaleAmt;
	    				this.tgPayCompleteVal = "Y";
	    			}
					
				} else if(this.barcodeType == "C"){ // 교환권
					this.resultingBalance = 0;
					this.productCodes = this.$route.params.obj.productCodes;
					this.productNm = this.$route.params.obj.title;
					this.remainAmt = 0;
					this.reqAmt = "0";
					this.tgPayCompleteVal = "Y";
				}else if(this.barcodeType == "D"){ // 쿠폰할인
					this.resultingBalance = 0;
					this.productCodes = this.$route.params.obj.productCodes;
					this.productNm = this.$route.params.obj.title;
					this.remainAmt = 0;
					this.reqAmt = 0;
					this.tgPayCompleteVal = "N";

					// 쿠폰의 상품코드와 일치하는 주문목록
					this.productCodes.forEach(element => {
						orderInfo.POS_ODDTL_T.forEach(element2 => {							
							if(element == element2.PROD_CD){		
								this.discountList.push(element2);
							}
						});
					});
					
					if(this.discountList.length > 0){
						// 상품 가격이 최대값인것...
						this.discountMaxObj = this.discountList.reduce( (prev, value) => {
							return Number(prev.SALE_UPRC) >= Number(value.SALE_UPRC) ? prev : value
						});
						console.log(this.discountMaxObj)
						
						// 할인율 적용..
						const couponPrice = Number(this.$route.params.obj.couponPrice);
						this.discountAmount = Math.round(Number(this.discountMaxObj.SALE_UPRC) * (couponPrice / 100)); // 할인						
						this.addPayAmt = this.totSaleAmt - this.discountAmount; // 추가결제금액 셋팅..

						// 할인적용된 메뉴
						orderInfo.POS_ODDTL_T.forEach(element => {
							if(element.PROD_CD == this.discountMaxObj.PROD_CD){
								element.discountYn = "Y";
							}
						});


					}else{
						util.logInfo("***** 쿠폰할인 - 일치하는 상품없음... *****");
					}


				}

// s // 기존소스 주석처리.. 2023/11/21
				//톨게이트 결제 타입이 교환권이 아닌경우
				// if(this.barcodeType != "C"){
				// 	this.resultingBalance = Number(this.$route.params.obj.resultingBalance);
				// 	//this.resultingBalance = 500;
				// 	this.remainAmt = this.resultingBalance - this.totSaleAmt;
				// 	if(this.remainAmt < 0){
				// 		this.remainAmt = 0;
				// 	}
					
				// 	if(this.totSaleAmt > this.resultingBalance){ //결제 금액이 잔액보다 많은 경우 남은 잔액을 요청금액으로 세팅
	    		// 		this.reqAmt = this.resultingBalance;
	    		// 		this.tgPayCompleteVal = "N";
	    		// 		if(this.barcodeType != "C"){//톨게이트 결제 타입이 교환권이 아닌경우
	    		// 			this.addPayAmt = this.totSaleAmt - this.resultingBalance;
	    		// 		}
	    		// 	} else { //결제 금액을 요청금액으로 세팅
    			// 		this.reqAmt = this.totSaleAmt;
	    		// 		this.tgPayCompleteVal = "Y";
	    		// 	}
					
				// } else {
				// 	this.resultingBalance = 0;
				// 	this.productCodes = this.$route.params.obj.productCodes;
				// 	this.productNm = this.$route.params.obj.title;
				// 	this.remainAmt = 0;
				// 	this.reqAmt = "0";
				// 	this.tgPayCompleteVal = "Y";
				// }
    			
// e // 기존소스 주석처리.. 2023/11/21

//    			if(this.totSaleAmt > this.resultingBalance){ //결제 금액이 잔액보다 많은 경우 남은 잔액을 요청금액으로 세팅
//    				this.reqAmt = this.resultingBalance;
//    				this.tgPayCompleteVal = "N";
//    				if(this.barcodeType != "C"){//톨게이트 결제 타입이 교환권이 아닌경우
//    					this.addPayAmt = this.totSaleAmt - this.resultingBalance;
//    				}
//    			} else { //결제 금액을 요청금액으로 세팅
//    				if(this.barcodeType != "C"){//톨게이트 결제 타입이 교환권이 아닌경우
//    					this.reqAmt = this.totSaleAmt;
//    				} else {
//    					this.reqAmt = "0";
//    				}
//    				this.tgPayCompleteVal = "Y";
//    			}
    			
    		}
    		, mounted : function() {
//    			this.$root.$on('onTollgatePayView' , obj => {
//					util.logInfo("on -> onTollgatePayView " , obj);
//					//this.fnTgInquiryCallback(obj);
//					this.barcodeNo = obj.barcodeNo;
//					this.barcodeType = obj.barcodeType;
//					this.totSaleAmt = Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT); // 주문금액
//        			this.resultingBalance = Number(obj.resultingBalance);
//        			this.remainAmt = this.resultingBalance - this.totSaleAmt;
//        			
//        			if(totSaleAmt > resultingBalance){ //결제 금액이 잔액보다 많은 경우 남은 잔액을 요청금액으로 세팅
//        				this.reqAmt = resultingBalance;
//        				this.tgPayCompleteVal = "N";
//        				this.addPayAmt = this.totSaleAmt - this.resultingBalance;
//        			} else { //결제 금액을 요청금액으로 세팅
//        				this.reqAmt = this.totSaleAmt;
//        				this.tgPayCompleteVal = "Y";
//        			}
//            	});
    			
//    			util.logInfo("***** 현금영수증 화면 시작 cashReceipts mounted *****");
//    			this.barcodeNo = this.$route.params.obj.barcodeNo;
//				this.barcodeType = this.$route.params.obj.barcodeType;
//				this.totSaleAmt = Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT); // 주문금액
//    			this.resultingBalance = Number(this.$route.params.obj.resultingBalance);
//    			this.remainAmt = this.resultingBalance - this.totSaleAmt;
//    			
//    			if(this.totSaleAmt > this.resultingBalance){ //결제 금액이 잔액보다 많은 경우 남은 잔액을 요청금액으로 세팅
//    				this.reqAmt = resultingBalance;
//    				this.tgPayCompleteVal = "N";
//    				this.addPayAmt = this.totSaleAmt - this.resultingBalance;
//    			} else { //결제 금액을 요청금액으로 세팅
//    				this.reqAmt = this.totSaleAmt;
//    				this.tgPayCompleteVal = "Y";
//    			}
    		}
    		, methods : {
    			fnTgRedeemValue : function() {
        			//톨게이트 선불카드 사용 요청
        			util.logInfo("### fnTgRedeemValue START");
        			
        			
        			var sslTrhdrBillNo = orderInfo.posBillNo;
        			
        			//요청할때 주문번호가 필요하기 때문에 주문번호 조회 
//        			var setBillNumber = util.GetEnvXmlShopENV("735");
//
//        			//getBillNo
//        			var sslTrhdrBillNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectBillNo, [gShopCd, saleDate, gPosNo]).Data;
//                    var sslTrhdrBillNo = sslTrhdrBillNoResult[0].BILL_NO;
//
//                    util.logInfo("### sslTrhdrBillNo >>> " + sslTrhdrBillNo + ", setBillNumber : " + setBillNumber);
//
//                    //영수증번호 임의 채번
//        			if(sslTrhdrBillNo == "0001" && !util.isEmptyStr(setBillNumber) && setBillNumber > 0 ){
//                        sslTrhdrBillNo = setBillNumber + "0";
//        			}
        			
        			var tgSignMsg = "";
        			var orderDate = moment().format("YYYY-MM-DDTHH:mm:ss");
        			//"serviceId+posStoreNo+posTerminalNo+posOrderNo+orderDate+amount+barcodeNo"
        			var cbPosStoreNo = "KPNKIOSK" + gShopCd; 
        			var cbPosTerminalNo = gShopCd + gPosNo; 
        			var cbPosOrderNo = gShopCd + gPosNo + moment().format("YYYYMMDDHHmmss") + sslTrhdrBillNo; 
        			tgSignMsg = tgServiceId + ":" + gShopCd + ":" + cbPosTerminalNo + ":" + cbPosOrderNo 
        			 			+ ":" + orderDate + ":" + this.reqAmt + ":" + this.barcodeNo;
        			
        			var hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey);
        			var hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
        			  
        			let paramObj = {
    					serviceId : tgServiceId
						, posStoreNo : gShopCd
						, posTerminalNo : cbPosTerminalNo
						, sign : hashInBase64
						, callbackParam : ""
						, additionalData : ""
						, posOrderNo : cbPosOrderNo
						, orderDate : orderDate
						, amount : this.reqAmt	
						, barcodeNo : this.barcodeNo
						, barcodeInputType : "SCAN"	
						, sattlementDate : moment().format("YYYY-MM-DD", saleDate)	
						, receiptNo : ""	
						, receiptLines : ""	
					};
        			
        			var tgTargetUrl = "/v1/gw/pos/fdk/redeemValue.do";
        			
        			var result = util.ajaxCallTollgate(paramObj, tgTargetUrl, this.fnTgRedeemCallback);
        			//var result = '{"resultCode":"SUCCESS","resultMessage":null,"verboseMessage":null,"body":{"serviceId":"CB0001","posStoreNo":"066626","posTerminalNo":"01","sign":"eWTuvIF3DBF4p1YkgS6LB4OpenUzccRIRlrVOAwFqSk=","callbackParam":"","additionalData":"","posOrderNo":"0001","orderDate":"2022-08-25T02:14:02","amount":1500,"barcodeNo":"3050831324159657","barcodeInputType":"SCAN","sattlementDate":"2022-08-25","receiptNo":"","receiptLines":"","accountTransactionId":"OTMzODI0OTQ0ODQ2NzYzLjk===","accountTransactionDate":"2022-08-25T14:14:03","approvedAmount":1500,"resultingBalance":48500,"noticeToUser":"","noticeToStore":""}}';
        			//this.fnTgRedeemCallback(JSON.parse(result));
        			
        			if(result.resultCode == "ERROR") {
	    				//톨게이트 선불카드 조회 실패입니다. 관리자에게 문의해주세요.
	    				var errMsg = "톨게이트 선불카드 주문 실패입니다. 관리자에게 문의해주세요.";
	    				//localStorage.setItem("gCbBillNoVal", "F");
	    				this.tgErrorResult(errMsg);
	    			}
        			
    			}
    			, fnTgCouponValue : function() {
	    			//톨게이트 선불카드 사용 요청
	    			util.logInfo("### fnTgCouponValue START");
	    			
	    			if(orderInfo.POS_ODDTL_T.length > 1) {
	    				//교환권의 경우에는 1:1 결제만 가능합니다.
	    				var messageObj = util.languageObjReturn(langCode,  'oneOnOnePay');
	    				//util.languageObjReturn(langCode,  'oneOnOnePay');
	        			var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
	        	        var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj, "button2Func": this.fnGoBack};

	        	        // 경고메세지 팝업
	        	        eventBus.$emit('alertPopupIndex', dataObj);
	    				return false;
	    			} else {
	    				//상품수량이 1개 이상인것
	    				if(orderInfo.POS_ODDTL_T[0].ORDER_QTY > 1) {
	    					//교환권의 경우에는 1:1 결제만 가능합니다.
		    				var messageObj = util.languageObjReturn(langCode,  'oneOnOnePay');
		    				//util.languageObjReturn(langCode,  'oneOnOnePay');
		        			var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
		        	        var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj, "button2Func": this.fnGoBack};

		        	        // 경고메세지 팝업
		        	        eventBus.$emit('alertPopupIndex', dataObj);
		    				return false;
	    				}

	    			}
	    			
	    			var prodCdChkVal = false;
	    			for(var i=0; i < this.productCodes.length; i++) {
	    				if(this.productCodes[i] == orderInfo.POS_ODDTL_T[0].PROD_CD){
	    					prodCdChkVal = true;
	    					break;
	    				}
	    			}
	    			
	    			if(!prodCdChkVal){
	    				//해당 매장의 쿠폰가 맞는지 확인이 필요
    					//상품이 일치하지 않습니다. 아메리카노(교환권 상품명)를 선택 후 다시 결제하시길 바랍니다. 
    					var messageObj = util.languageObjReturn(langCode,  'goodsNotMatch');
    					//var messageObj = "상품이 일치하지 않습니다. %s를 선택 후 다시 결제하시길 바랍니다.";  
    					messageObj = messageObj.sprintf(this.productNm);
//    					if(langCode == "ko"){
//    						messageObj = messageObj.sprintf(this.productNm);	
//    					} else {
//    						messageObj = messageObj.sprintf(orderInfo.POS_ODDTL_T[0].PROD_NM_EN)
//    					}
        				var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
        				var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj, "button2Func": this.fnGoBack};
        				
        				// 경고메세지 팝업
	        	        eventBus.$emit('alertPopupIndex', dataObj);
        				return false;
	    			}
	    			
	    			var sslTrhdrBillNo = orderInfo.posBillNo;
	    			
	    			//요청할때 주문번호가 필요하기 때문에 주문번호 조회 
//	    			var setBillNumber = util.GetEnvXmlShopENV("735");
//	    			
//	    			var sslTrhdrBillNoResult;
//	    			var sslTrhdrBillNo;
//	    			
//	    			if(gCbBillNoVal){
//	    			    //getBillNo
//	    			    sslTrhdrBillNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectBillNo, [gShopCd, saleDate, gPosNo]).Data;
//	    			    sslTrhdrBillNo = sslTrhdrBillNoResult[0].BILL_NO;
//	    			} else {
//	    				sslTrhdrBillNo = String(Number(gCbBillNo)+1).padding(4, "0");
//	    			}
//	    			
//	    			util.logInfo("### sslTrhdrBillNo >>> " + sslTrhdrBillNo + ", setBillNumber : " + setBillNumber);
//	    			
//	    			//영수증번호 임의 채번
//	    			if(sslTrhdrBillNo == "0001" && !util.isEmptyStr(setBillNumber) && setBillNumber > 0 ){
//	    				sslTrhdrBillNo = setBillNumber + "0";
//	    			}
	    			
	    			var tgSignMsg = "";
	    			var orderDate = moment().format("YYYY-MM-DDTHH:mm:ss");
	    			var cbPosStoreNo = "KPNKIOSK" + gShopCd; 
        			var cbPosTerminalNo = gShopCd + gPosNo; 
        			var cbPosOrderNo = gShopCd + gPosNo + moment().format("YYYYMMDDHHmmss") + sslTrhdrBillNo;
	    			//"serviceId+posStoreNo+posTerminalNo+posOrderNo+orderDate+amount+barcodeNo"
	    			tgSignMsg = tgServiceId + ":" + gShopCd + ":" + cbPosTerminalNo + ":" + cbPosOrderNo 
	    			+ ":" + orderDate + ":" + this.barcodeNo + ":" + orderInfo.POS_ODDTL_T[0].PROD_CD;
	    			
	    			var hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey);
	    			var hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
	    			
	    			let paramObj = {
	    					serviceId : tgServiceId
	    					, posStoreNo : gShopCd
	    					, posTerminalNo : cbPosTerminalNo
	    					, sign : hashInBase64
	    					, callbackParam : ""
							, additionalData : ""
							, posOrderNo : cbPosOrderNo
							, orderDate : orderDate
							, barcodeNo : this.barcodeNo
							, barcodeInputType : "SCAN"	
							, productCode : orderInfo.POS_ODDTL_T[0].PROD_CD	
							, sattlementDate : moment().format("YYYY-MM-DD", saleDate)	
	    			};
	    			
	    			var tgTargetUrl = "/v1/gw/pos/fdk/useCoupon.do";
	    			
	    			var result = util.ajaxCallTollgate(paramObj, tgTargetUrl, this.fnTgCouponCallback);

					if(result.resultCode == "ERROR") {
	    				//톨게이트 선불카드 조회 실패입니다. 관리자에게 문의해주세요.
	    				var errMsg = "톨게이트 교환권 주문 실패입니다. 관리자에게 문의해주세요.";
	    				//localStorage.setItem("gCbBillNoVal", "F");
	    				this.tgErrorResult(errMsg);
//	    				if(gCbBillNoVal){
//	    					gCbBillNoVal = false;
//		    			    gCbBillNo = sslTrhdrBillNo;
//	    				} else {
//	    					gCbBillNoVal = false;
//	    					gCbBillNo = String(Number(gCbBillNo)+1).padding(4, "0");
//	    					localStorage.setItem("gCbBillNoVal", false);
//	    				}
	    			    
	    			}
    			}
				, fnTgDCouponValue : function() {
					//톨게이트 쿠폰할인 사용 요청
	    			util.logInfo("### fnTgDCouponValue START");

					if(this.discountList.length == 0){
						var messageObj = '조회된 쿠폰과 일치하는 상품이 업습니다.';
						//util.languageObjReturn(langCode,  'oneOnOnePay');
						var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
						var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj, "button2Func": this.fnGoBack};

						// 경고메세지 팝업
						eventBus.$emit('alertPopupIndex', dataObj);
						return false;
					}

					var sslTrhdrBillNo = orderInfo.posBillNo;
					var tgSignMsg = "";
	    			var orderDate = moment().format("YYYY-MM-DDTHH:mm:ss");
	    			var cbPosStoreNo = "KPNKIOSK" + gShopCd; 
        			var cbPosTerminalNo = gShopCd + gPosNo; 
        			var cbPosOrderNo = gShopCd + gPosNo + moment().format("YYYYMMDDHHmmss") + sslTrhdrBillNo;
					var prodCd = this.discountMaxObj.PROD_CD;


	    			//"serviceId+posStoreNo+posTerminalNo+posOrderNo+orderDate+amount+barcodeNo"
	    			tgSignMsg = tgServiceId + ":" + gShopCd + ":" + cbPosTerminalNo + ":" + cbPosOrderNo 
	    			+ ":" + orderDate + ":" + this.barcodeNo + ":" + prodCd;
	    			
	    			var hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey);
	    			var hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
	    			
	    			let paramObj = {
	    					serviceId : tgServiceId
	    					, posStoreNo : gShopCd
	    					, posTerminalNo : cbPosTerminalNo
	    					, sign : hashInBase64
	    					, callbackParam : ""
							, additionalData : ""
							, posOrderNo : cbPosOrderNo
							, orderDate : orderDate
							, barcodeNo : this.barcodeNo
							, barcodeInputType : "SCAN"	
							, productCode : prodCd	
							, sattlementDate : moment().format("YYYY-MM-DD", saleDate)	
	    			};
	    			
	    			var tgTargetUrl = "/v1/gw/pos/fdk/useCoupon.do";
	    			
	    			var result = util.ajaxCallTollgate(paramObj, tgTargetUrl, this.fnTgCouponCallback);

					// test

					// var result = {
					// 	"posOrderNo": "06662601202311221504460025",
					// 	"orderDate": "2023-11-22T15:04:46",
					// 	"barcodeNo": "4042882317626309",
					// 	"barcodeInputType": "SCAN",
					// 	"productCode": "E0000127",
					// 	"sattlementDate": "2023-11-22",
					// 	"couponTransactionId": "202311221504470603UQPhRe",
					// 	"couponTransactionDate": "2023-11-22T15:04:47",
					// 	"discountAmount": 600,
					// 	"barcodeType": "D"
					// }
					//   this.fnTgCouponCallback(result);
					// test
	    			
					if(result.resultCode == "ERROR") {
	    				//톨게이트 선불카드 조회 실패입니다. 관리자에게 문의해주세요.
	    				var errMsg = "톨게이트 할인권 주문 실패입니다. 관리자에게 문의해주세요.";
	    				//localStorage.setItem("gCbBillNoVal", "F");
	    				this.tgErrorResult(errMsg);	    			    
	    			}					

				}

        		, fnTgRedeemCallback : function (result) {
        			//쿠폰사용 신청후 콜백함수
        			util.logInfo("### fnTgRedeemCallback START ###");
        			var resRedeemData = result;
        			var bRedeemData = resRedeemData.body;
        			
        			//톨게이트 결제요청 응답데이터, 결제취소할대 필요한 데이터 - 이미 승인요청된 상태라서 결제취소 및 실패시에 승인요청취소를 보내야함
        			orderInfo.TOLLGATE_INFO = {
        					"posOrderNo" : bRedeemData.posOrderNo
        					, "orderDate" : bRedeemData.orderDate
        					, "amount" : bRedeemData.amount
        					, "barcodeNo" : bRedeemData.barcodeNo
        					, "barcodeInputType" : bRedeemData.barcodeInputType
        					, "sattlementDate" : bRedeemData.sattlementDate
        					, "receiptNo" : bRedeemData.receiptNo
        					, "accountTransactionId" : bRedeemData.accountTransactionId
        					, "accountTransactionDate" : bRedeemData.accountTransactionDate
        			};
        			
        			// 톨게이트 사용요청후 망취소파일 만들어두기, 인터넷 끊겼을때 네이티브에서 처리 
        			// 향후 톨게이트 파일만들기 함수 추가
        			
        			if(resRedeemData.resultCode == "SUCCESS") {
        				// 톨게이트 선불카드 파일 생성
        				gTgFileName = util.makeTollgateDataFile(bRedeemData, "P");
        				
            	        let dataObj = {};
            	        dataObj.button1Show = true;
            	        dataObj.button1Name = util.languageObjReturn(langCode, 'no') // [ 아니오 ]
            	        dataObj.button1Func = this.goToPayment
        				dataObj.button2Show = true;
        				dataObj.button2Name = util.languageObjReturn(langCode, 'yes') // [ 예 ]
        				dataObj.button2Func = this.goToCashReceipts
            			dataObj.message = util.languageObjReturn(langCode, 'cashIssue');
        				
            			eventBus.$emit('alertPopupIndex', dataObj);
            	        return;
        			} else {
        				// 톨게이트 선불카드 사용 실패
        				var messageObj = util.languageObjReturn(langCode,  'issueReceiptOutput');
            			var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
            	        var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj, "button2Func": this.fnGoBack()};
            	        // 경고메세지 팝업
            	        eventBus.$emit('alertPopupIndex2', dataObj);
            	        return;
        			}
        	        
        			util.logInfo("### fnTgRedeemCallback END ###");
        		}
        		, fnTgCouponCallback : function (result) {
        			//쿠폰사용 신청후 콜백함수
        			util.logInfo("### fnTgRedeemCallback START ###");
        			var resCouponData = result;
        			var bCouponData = resCouponData.body;
        			
        			//톨게이트 결제요청 응답데이터, 결제취소할대 필요한 데이터 - 이미 승인요청된 상태라서 결제취소 및 실패시에 승인요청취소를 보내야함					
					if(this.barcodeType == 'D'){ // 쿠폰할인..
						orderInfo.TOLLGATE_DC_INFO = {
							"posOrderNo" : bCouponData.posOrderNo
							, "orderDate" : bCouponData.orderDate
							, "barcodeNo" : bCouponData.barcodeNo
							, "barcodeInputType" : bCouponData.barcodeInputType
							, "productCode" : bCouponData.productCode
							, "sattlementDate" : bCouponData.sattlementDate
							, "couponTransactionId" : bCouponData.couponTransactionId
							, "couponTransactionDate" : bCouponData.couponTransactionDate
						};						
					}else{
						orderInfo.TOLLGATE_INFO = {
							"posOrderNo" : bCouponData.posOrderNo
							, "orderDate" : bCouponData.orderDate
							, "barcodeNo" : bCouponData.barcodeNo
							, "barcodeInputType" : bCouponData.barcodeInputType
							, "productCode" : bCouponData.productCode
							, "sattlementDate" : bCouponData.sattlementDate
							, "couponTransactionId" : bCouponData.couponTransactionId
							, "couponTransactionDate" : bCouponData.couponTransactionDate
						};
					}

        			
        			if(resCouponData.resultCode == "SUCCESS") {
        				// 톨게이트 쿠폰용 파일 생성
        				gTgFileName = util.makeTollgateDataFile(bCouponData, "C");
        				this.goToPayment();
        			} else {
        				// 톨게이트 쿠폰 사용 실패
        				var messageObj = util.languageObjReturn(langCode,  'issueReceiptOutput');
        				var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
        				var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj, "button2Func": this.fnGoBack};
        				
        				// 경고메세지 팝업
        				eventBus.$emit('alertPopupIndex', dataObj);
        			}
        			
        			//쿠폰 결제완료
        			util.logInfo("### fnTgRedeemCallback END ###");
        		}
        		, fnTgStampInquiryCallback : function (result) {
        			//스탬프적립 신청후 콜백함수
        			util.logInfo("### fnTgStampCallback START ###");
        			var resStampData = JSON.parse(result);
        			var bStampData = resStampData.body;
        			
        			//톨게이트 결제요청 응답데이터, 결제취소할대 필요한 데이터 - 이미 승인요청된 상태라서 결제취소 및 실패시에 승인요청취소를 보내야함
        			orderInfo.TOLLGATE_INFO = {
        					"posOrderNo" : bStampData.posOrderNo
        					, "orderDate" : bStampData.orderDate
        					, "originalPosOrderNo" : bStampData.posOrderNo
        					, "originalStampTxId" : bStampData.stampTransactionId
        					, "originalOrderDate" : bStampData.stampTransactionDate
        					, "originalStampCount" : bStampData.stampCount
        					, "sattlementDate" : bStampData.sattlementDate
        			};
        		
        			//상품이 일치하지 않습니다.아메리카노(교환권 상품명)를 선택 후 다시 결제하시길 바랍니다
        			if(resStampData.resultCode == "SUCCESS") {
        				// 톨게이트 쿠폰용 파일 생성
        				gTgStampFileName = util.makeTollgateDataFile(bStampData, "S");
        				
        				if(this.tgStampAddType == "Y") {
        					//톨게이트 스탬프 적립후 결제 화면으로 이동하는 경우
        					paymentChoiceView.creditApprRequest();
        				}
        			} else {
        				// 톨게이트 쿠폰 사용 실패
        				var messageObj = util.languageObjReturn(langCode,  'issueReceiptOutput');
        				var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
        				var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj, "button2Func": this.fnGoBack()};
        				
        				// 경고메세지 팝업
        				eventBus.$emit('alertPopupIndex', dataObj);
        			}
        			
        			//쿠폰 결제완료
        			util.logInfo("### fnTgRedeemCallback END ###");
        		}
        		, goToCashReceipts : function() {
        			this.$router.push({name: 'cashReceipts', params: { totalAmt: this.reqAmt, tgPayCompleteVal : this.tgPayCompleteVal }})
        		}
        		, goToPayment : function() {
        			//0원 결제정보 설정
        			//paymentChoiceService.setPointPaymentInfo();
        	    	
        			if(orderInfo.POS_ODHDR_T.GST_PAY_AMT == undefined) {
        				if(orderInfo.TOLLGATE_INFO !== undefined && orderInfo.TOLLGATE_INFO.amount !== undefined) {
        					if(this.tgPayCompleteVal == "N") {
        						orderInfo.POS_ODHDR_T.GST_PAY_AMT = orderInfo.TOLLGATE_INFO.amount; //받은금액
        					} else {
        						orderInfo.POS_ODHDR_T.GST_PAY_AMT = 0; //받은금액
        					}
        				} else {
        					orderInfo.POS_ODHDR_T.GST_PAY_AMT = 0; //받은금액
        				}
        			}
        			orderInfo.POS_ODHDR_T.CRD_CARD_AMT = 0;
        	  	   	orderInfo.POS_ODHDR_T.EXP_PAY_AMT  = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;	// 받을금액
        	  	   	orderInfo.POS_ODHDR_T.RET_PAY_AMT  = 0;		    							// 거스름돈 (RET_PAY_AMT)
        	  	   	
        	  	   	if(orderInfo.TOLLGATE_INFO !== undefined && orderInfo.TOLLGATE_INFO.couponTransactionId !== undefined) {							 
						//톨게이트 쿠폰결제는 매출금액은 0원 할인금액은 결제금액으로 표시
						orderInfo.POS_ODHDR_T.DCM_SALE_AMT = 0;
						orderInfo.POS_ODHDR_T.TOT_DC_AMT = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;
						
						orderInfo.POS_ODHDR_T.NO_TAX_SALE_AMT = "0";
						orderInfo.POS_ODHDR_T.NO_TOT_SALE_AMT = "0";
						orderInfo.POS_ODHDR_T.TAX_SALE_AMT = "0";
						orderInfo.POS_ODHDR_T.VAT_SALE_AMT = "0";
						orderInfo.POS_ODHDR_T.VAT_AMT = "0";

        	  	   	}else if(orderInfo.TOLLGATE_DC_INFO !== undefined && orderInfo.TOLLGATE_DC_INFO.couponTransactionId !== undefined && this.barcodeType == 'D') { // 쿠폰할인일경우..
							 
						if(!orderInfo.POS_ODHDR_T.TOT_DC_AMT){ // 객체가 없는 경우에 +를 하면 NaN으로 변경되어, 값이 있는 경우에만 +하도록 한다.
							orderInfo.POS_ODHDR_T.TOT_DC_AMT = this.discountAmount; // 쿠폰할인 금액을 헤더 TOT_DC_AMT 추가로 더해서 넣어준다. (할인에 대한 총 금액)
						}else{
							orderInfo.POS_ODHDR_T.TOT_DC_AMT = this.discountAmount;
							orderInfo.POS_ODHDR_T.TOT_DC_AMT = Number(orderInfo.POS_ODHDR_T.TOT_DC_AMT) + this.discountAmount; // 포인트 할인 금액을 헤더 TOT_DC_AMT 추가로 더해서 넣어준다. (할인에 대한 총 금액)
						}

						orderInfo.POS_ODHDR_T.DCM_SALE_AMT = Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT) - this.discountAmount;	// 매출금액
						orderInfo.TOLLGATE_DC_INFO.discountAmount = this.discountAmount;
						orderInfo.POS_ODHDR_T.DC_CPN_AMT = this.discountAmount; // 쿠폰할인 금액
						orderInfo.POS_ODHDR_T.NO_TAX_SALE_AMT = "0";
						orderInfo.POS_ODHDR_T.NO_TOT_SALE_AMT = "0";
						orderInfo.POS_ODHDR_T.TAX_SALE_AMT = "0";
						orderInfo.POS_ODHDR_T.VAT_SALE_AMT = "0";
						orderInfo.POS_ODHDR_T.VAT_AMT = "0";

        	  	   	} else {
        	  	   		if(orderInfo.POS_ODHDR_T.DCM_SALE_AMT != undefined) {
        	  	   			orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.DCM_SALE_AMT;	// 매출금액
        	  	   		} else {
        	  	   			orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;	// 매출금액
        	  	   		}
        	  	   	}

        	  	   	if(this.tgPayCompleteVal == "N") {
        	  	   		//router.push({path: '/paymentChoiceView'});
						if(this.barcodeType != "D"){ // 쿠폰할인이 아닐경우..
							gCombinePayVal = "Y";
						}
        	  	   		router.push({path: '/paymentChoiceView'});
        	  	   	} else {
        	  	   		paymentChoiceView.fnCardReaderStatusCallBack();
        	  	   	}
        		}
        		, fnGoBack : function() {
        			router.push({path: '/menu'}); 
        		}
        		, tgErrorResult : function (errMsg) {
        			let dataObj = {};
    				dataObj.button2Show = true;
    				dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm') // [ 예 ]
    				dataObj.button2Func = function() {
						router.push({ path : '/start'})
					}
        			dataObj.message = errMsg;
    				
        			eventBus.$emit('alertPopupIndex', dataObj);
        		}
    		
    		}
	        , updated : function(){
	        	
	        }
	        , beforeUpdate : function(){
	            
	        }
	        , destroyed : function(){

	        }
    	};
    	return returnTemplate;
    }
    
}