var Util = function(){

    this.isAdd_RemoveStatusListener = false;
    this.removeListenerId;
    this.listenerId;    
    var fgCnt=0; // 무인로봇 send실패시에 connection 재시도를 위한 flag (1회만 재시도)
    var gClientSock=""; // 무인로봇 connection key값
    var autoLoginTimeId; //자동로그인 경고창 ID

    this.logError = function(Obj) {
        var callName = "";
        try{
            callName = arguments.callee.caller.name;
        }catch(e){

        }
        this.log(Obj, "E", callName);

    },
    this.logWarning = function(Obj) {
        var callName = "";
        try{
            callName = arguments.callee.caller.name;
        }catch(e){

        }
        this.log(Obj, "W", callName);

    },
    this.logInfo = function(Obj) {
        var callName = "";
        try{
            callName = arguments.callee.caller.name;
        }catch(e){

        }
        this.log(Obj, "I", callName);

    },
    this.logDebug = function(Obj) {
        var callName = "";
        try{
            callName = arguments.callee.caller.name;
        }catch(e){

        }
        this.log(Obj, "D", callName);

    },

    this.log = function(Obj, logLevel, callName){

        var logMessage ;
        var logObj = "";

//        if(dibugYn == "Y"){
//            $("#debugTextArea").show();
//            var value = $("#tizenText").val();
//            $("#tizenText").val(value + "\n" + Obj);
//
//        }else {
//            $("#debugTextArea").hide();
//        }

        if(util.isEmpty(callName)){
            callName = "";
        }
        //console.log("log  gLogLevel : " + gLogLevel);

        if(util.isEmptyStr(gLogLevel)){
            //util.fnGetLogLevel();
            gLogLevel = "0";
        }

        if(util.isEmptyStr(logLevel)){
            logLevel = "D";
        }
        if(logLevel == "I"){
            debugName = "[INFO]";
        }else if(logLevel == "E"){
            debugName = "[ERROR]";
        }else if(logLevel == "W"){
            debugName = "[WARNING]";
        }else{
            debugName = "[DEBUG]";
        }

        if ( typeof Obj == 'object') {
            logObj = JSON.stringify(Obj);
        } else  {
            logObj = Obj;
        }
        if(debugName == "[WARNING]" || debugName == "[DEBUG]"){
            logMessage = "[" + moment().format("YYYY-MM-DD HH:mm:ss.SSS") + "]" + debugName +" : " + callName + " " + logObj;
        }else{
            // logMessage = "[" + moment().format("YYYY-MM-DD HH:mm:ss.SSS") + "][" + util.fnGetUseMemory() + "]" + debugName +" : " + callName + " " + logObj;
            logMessage = "[" + moment().format("YYYY-MM-DD HH:mm:ss.SSS") + "]" + debugName +" : " + callName + " " + logObj;
        }

        if(util.isTizen() == false ){
            console.log( logMessage );
        }else {

            if(gLogLevel == "0" && (logLevel == "I" || logLevel == "E")){
                //var result = nativeApp.functionCallSync(["LOG_Writer", logLevel, logMessage]);
                this.fnUpdateLogFile(logMessage);
            }else if(gLogLevel == "1" && (logLevel == "I" || logLevel == "E" || logLevel == "W")){
                //var result = nativeApp.functionCallSync(["LOG_Writer", logLevel, logMessage]);
                this.fnUpdateLogFile(logMessage);
            }else if(gLogLevel == "2"){
                //var result = nativeApp.functionCallSync(["LOG_Writer", logLevel, logMessage]);
                this.fnUpdateLogFile(logMessage);
            }
            if(TEST_REAL_FLAG == "test"){
                console.error( logMessage );
            }
        }
    },

    this.fnUpdateLogFile = function(logText) {

        try {

            if(logFileOpenStream == null || logFileGenerateDate != moment().format("YYYY_MM_DD")){

                util.fnGenerateOpenStream();

                setTimeout(function(){
                    logFileOpenStream.write(logText +"\n");
                }, 3000);
            }else{
                logFileOpenStream.write(logText +"\n");
            }

        } catch (e) {
            //util.log("###################  fnUpdatePayInfoFile ERROR : " + JSON.stringify(e));
        }
    },
    this.fnGenerateOpenStream = function(){
        var nowDate = moment().format("YYYY_MM_DD");
        var fileName = "SKIOSK_LOG_" + nowDate + ".log";
        var dirPath = "/opt/usr/home/owner/content/Downloads/FirstKIOSK/LOG/";
        var fullPath = dirPath + fileName;

//        util.log("###################  fullPath : " + fullPath);
//        util.log("###################  fileName : " + fileName);

        try{
            tizen.filesystem.resolve(fullPath, function(fileResult) {

                //util.log("################### fnUpdateLogFile newFile Start #################");

                fileResult.openStream(
                    "a",
                    function(fileStream) {
                        logFileOpenStream = fileStream;


                    }, function(e) {
                        //util.log("Error " + e.message);
                    }, "UTF-8");

                //util.log("################### fnUpdateLogFile newFile End #################");

            }, function(e) {
                //util.log("### fnUpdateLogFile resolve Error : " + e.message);
                tizen.filesystem.resolve(dirPath,
                    function(result) {
                        //util.log("###################  fnUpdateLogFile result : " + JSON.stringify(result));

                        if(result.isDirectory){
                            newFile = result.createFile(fileName);
                            logFileGenerateDate = nowDate;
                            tizen.filesystem.resolve(fullPath, function(fileResult) {

                                fileResult.openStream(
                                "a",
                                function(fileStream) {
                                    logFileOpenStream = fileStream;
                                    //logFileOpenStream.write(logText +"\n");

                                }, function(e) {
                                    util.log("Error " + e.message);
                                }, "UTF-8");

                            }, function(e) {
                                //util.log("### fnUpdateLogFile resolve Error : " + e.message);
                            }, 'a');
                        }
                    }, function(e) {
                        //util.log("### fnUpdateLogFile resolve Error : " + e.message);
                    }, 'a'
                );
            }, "a" );
        }catch(e){
            //util.log("### fnGenerateOpenStream Error : " + e.message);
        }
    },

    this.htmlLog = function(Obj){

        var debugYn = "N";

        if(debugYn == "Y"){
            $("#debugTextArea").show();
            var value = $("#tizenText").val();
            $("#tizenText").val(value + "\n" + Obj);

            console.error( Obj );

        }else {
            $("#debugTextArea").hide();
        }
    },

    this.fnGenerateFile = function(vsFromDt, vsToDt, alertYn){

        /* 기간만큼 로그파일 압축하여 생성.
                            압축 위치 : /opt/usr/home/owner/content/Downloads/FirstKIOSK/LogZip
        */
        if(alertYn){
            $(".loadingCon").show();
        }

        try{
            var vsResultVal = nativeApp.functionCallSync(["FDK_LogFilesToZip",vsFromDt, vsToDt]);
            vsResultVal = JSON.parse(vsResultVal.replace("$$^", ""));

            if(vsResultVal.ResultCode != "0"){
                eventBus.$emit('alertPopup', {message: "로그송신에 문제가 발생했습니다.\n[" + vsResultVal.Message +"]"});
                return false;
            }
            var fileName = vsResultVal.Data.substring(vsResultVal.Data.lastIndexOf("/")+1);

            var dirPath = "/opt/usr/home/owner/content/Downloads/FirstKIOSK/LogZip/";
            var fullPath = dirPath + fileName;

            var url = logSendAspUrl + "/common/jsp/pos_upload/logfile_upload.jsp";
            var zipFileName = gShopCd + "-" + gPosNo + "-" + moment().format("YYYYMMDDHHmmss") + ".zip";

            util.logDebug("###### fnGenerateFile resolve start vsFromDt >> " + vsFromDt + ", vsToDt : " + vsToDt + ", url : " + url + ", fullPath >> " + fullPath);

            var param = {"fullPath" : fullPath, "url" : url, "zipFileName" : zipFileName, "fileName" : fileName, "alertYn" : alertYn};

            var resultObj = util.fnDoGenerateFile(param);

            util.logDebug("###### fnGenerateFile end resultObj >> " + resultObj);

            resultObj.fileName = fileName;
        }catch(e){
            util.logDebug("###### fnGenerateFile error  >> " + e);
            $(".loadingCon").hide();
        }

        return resultObj;
    }

    this.fnDoGenerateFile = function(param){

        var resultObj = {};
        try{
            tizen.filesystem.resolve(param.fullPath,
                function(resolvedfile) {
                    resolvedfile.openStream("r", function(file) {
                        var filereadBytes = file.readBytes(file.bytesAvailable);
                        var filereadBytesArray = [new Uint8Array(filereadBytes)];
                        util.logDebug("fnGenerateFile filereadBytesArray end ");

                        //util.logDebug("fnGenerateFile filereadBytesArray=="+filereadBytesArray);

                        result = new Blob(filereadBytesArray, {
                            type: "application/octet-stream"
                        });

                        var fd = new FormData();
                        fd.append("PosLogNm", result, param.zipFileName);

                        util.logDebug("fnGenerateFile filereadBytesArray  fd  end =========== ");
                        
                        var vsUrl = param.url;
                        if(TEST_REAL_FLAG == "test"){
                        	vsUrl = "https://testasp.firstpos.co.kr/common/jsp/pos_upload/logfile_upload.jsp";
                        }
                        
						util.logInfo("### 로그전송 URL == >> " + vsUrl);
                        $.ajax({
                            type: 'POST',
                            url: vsUrl,
                            data: fd,
                            processData: false,
                            contentType: false,
                            async: true,
                            success: function(data) {
                                util.logDebug("data=="+data);
                                resultObj = data;
                                if(param.alertYn){
                                    eventBus.$emit('alertPopup', {message: "로그송신을 완료하였습니다."});
                                    $(".loadingCon").hide();
                                }
                                resultObj.message = "로그송신을 완료하였습니다.";


                            },
                            error: function(error) {
                                util.logError("### 로그송신 error ==>> " + error);
                                util.logError("### 로그송신 error ==>> " + JSON.stringify(error));
                                resultObj = error;
                                if(param.alertYn){
                                    eventBus.$emit('alertPopup', {message: "로그송신을 완료하지 못하였습니다."});
                                    $(".loadingCon").hide();
                                }
                                resultObj.message = "로그송신을 완료하지 못하였습니다.";

                            }
                        });

                    }, function(error) {
                        util.logError("### 로그송신 파일 openStream error ==>> " + error);
                        util.logError("### 로그송신 파일 openStream error ==>> " + JSON.stringify(error));
                        if(param.alertYn){
                            eventBus.$emit('alertPopup', {message: "로그송신을 완료하지 못하였습니다."});
                            $(".loadingCon").hide();
                        }
                        resultObj.message = "로그송신을 완료하지 못하였습니다.";
                    });

                },
                function(e) {
                    util.logError("### filesystem Error: " + e.message);
                    if(param.alertYn){
                        eventBus.$emit('alertPopup', {message: "로그송신을 완료하지 못하였습니다."});
                        $(".loadingCon").hide();
                    }
                    resultObj.message = "로그송신을 완료하지 못하였습니다.";
                },
                "r");
        }catch(e){
            util.logError("### catch 로그송신 error  >> " + e);
            if(param.alertYn){
                eventBus.$emit('alertPopup', {message: "로그송신을 완료하지 못하였습니다."});
                $(".loadingCon").hide();
            }
            resultObj.message = "로그송신을 완료하지 못하였습니다.";
        }

        return resultObj;

    },

    this.fnGenerateFile2 = function(dates){
        //var fileName = "SKIOSK_LOG_2020_11_27.log";
        var fileName = "testLogfile_01.zip";
        var dirPath = "/opt/usr/home/owner/content/Downloads/FirstKIOSK/LOG/";
        var dbFileName = "skiosk.db";
        var dbDirPath = "/opt/usr/home/owner/content/Downloads/FirstKIOSK/DB/";
        //var dbFullPath = dbDirPath + dbFileName;

        $(".loadingCon").show();

        try{

            util.logDebug("############ fnGenerateFile  dates : " + JSON.stringify(dates));

            tizen.filesystem.resolve(dirPath, function(dir)
            {
                dir.listFiles(function(files) {

                    util.logDebug("############ fnGenerateFile  file : " + files.length + ", : " + JSON.stringify(files));

                    for(var i=0; dates.length > i ; i++){
                        var date = dates[i];
                        for(var j=0; files.length > j ; j++){
                            var file = files[j];

                            //util.logDebug("############ fnGenerateFile  file : " + JSON.stringify(file));

                            if(file.name.indexOf(date) != -1){
                                util.logDebug("############ fnGenerateFile  file.name : " + file.name + ", date : " + date);
                                util.fnGetFileStream(file);
                            }
                        }
                    }

                    eventBus.$emit('alertPopup', {message: "로그 송신을 완료하였습니다."});
                    $(".loadingCon").hide();

                }, function(e) {
                    util.log("### fnGenerateFile resolve Error : " + e.message);
                    $(".loadingCon").hide();

                });
            }, function(e)
            {
            	util.logError("*****fnGenerateFile2 file resolve error e = >> " + e.message);
               $(".loadingCon").hide();
            }, "r");

        }catch(e){
            util.logError("*****fnGenerateFile2 catch e = >>" + e.message);
            $(".loadingCon").hide();
        }
    },

    this.fnGetFileStream = function(fileResolve){
        var textResult = "";

        fileResolve.openStream(
        "rw",
        function(fileStream) {

            //util.logDebug("### fnUpdateLogFile text fileStream >> " + JSON.stringify(fileStream));

            var textResult = fileStream.read(fileStream.bytesAvailable);

            //util.logDebug("### fnUpdateLogFile text textResult >> " + textResult);

            util.fnSendLog(textResult, fileResolve.name);

        }, function(e) {
            util.log("writeBytes Error " + e.message);
        }, "UTF-8");
        return textResult;

    },

    this.fnSendLog = function(fileData, fileName){

        var prefix = "\r\n-----------------------------7d13a23b368\r\nContent-Disposition: form-data; name=\"PosLogNm\"; filename=\"" + fileName + "\"\r\nContent-Type: application/octet-stream\r\n\r\n";
        var data = prefix + fileData + "\r\n\r\n-----------------------------7d13a23b368--\r\n";

        var url = "https://testasp.firstpos.co.kr/common/jsp/pos_upload/logfile_upload.jsp";
        var headers = {"Accept": "text/*", "Content-Type": "multipart/form-data; boundary=---------------------------7d13a23b368", "User-Agent": "PosLogSend"};

        $.ajax({
            type : "POST",
            url: url,
            data: data,
            contentType : "multipart/form-data",
            headers : headers,
            processData : false,
            async: true,
            success: function(res) {
                util.htmlLog('성공 ==' + JSON.stringify(res));

            },
            error: function(xhr) {
                util.htmlLog('실패 - ', xhr);
            }
        });
    }

    this.fnGetLogLevel = function(){

        var sql = "SELECT LogLevel FROM SCD_SETUP_T ";

        try {
            let row = gfn_SQLiteSQLProcess(sql, [] ).Data;

            //util.logInfo("fnGetLogLevel  row : " + JSON.stringify(row));
            if(util.isEmpty(row)){
                gLogLevel = "0";
            }else{
                //util.logInfo("fnGetLogLevel  row[0].LogLevel : " + row[0].LOGLEVEL);
                gLogLevel = row[0].LOGLEVEL;
            }
        } catch (e) {
            console.error("fnGetLogLevel  e : " + e);
            gLogLevel = "0";
        }
    },
    this.fnIsMainPos = function(){
        var returnValue = false;
        if(util.GetEnvXmlShopENV(528) == "1"){
            returnValue = true;
        }else if(mainPosNo == gPosNo){
            returnValue = true;
        }else{
            returnValue = false;
        }

        util.logInfo("@@@@@@@  fnIsMainPos returnValue : " +returnValue );

        return returnValue;

    },
    this.sleepUtil = function(t){
        return new Promise(resolve=>setTimeout(resolve,t));
    },
    this.languageReturn = function(Obj){
        var returnValue = {};
        var langPack = koLang;
        if(langCode == 'en'){
            langPack = enLang;
        }

        for(var value in Obj){
            returnValue[value] = langPack[Obj[value]]
        }

        util.logInfo("returnValue  :", returnValue);
        return returnValue;

    },

    this.languageObjReturn = function(langCo, target){

        var langPack = koLang;
        if(langCo == 'en'){
            langPack = enLang;
        }

        return langPack[target];

    },


    this.changeLang = function(langValue){
        if(langCode != langValue){
            langCode = langValue;

        }
    },

    this.setEmptyStr = function(target){
        if(target == null || target == 'undefined'){
            return "";
        }
        return target;
    }
	,
	/**************************************************************************
	 * target 값이 없다면 dest 값으로 대체 한다.
	 * oracle 의 nvl 기능과 유사.
	 * @parameter target empty 인지 체크할값.
	 * @parameter dest 대체될 값
	 **************************************************************************/
	this.setEmptyStrDefault = function(target , dest) {
		if (this.isEmptyStr(target) ){
			return dest;
		}
		return target;
	}

    this.isEmptyStr = function(target){
        if(target == null || target == 'undefined' || target == ''){
            return true;
        }
        return false;
    },
    this.isEmpty = function(target){
        if(target == undefined || target == null || target == 'undefined' || target.length == 0 ){
            return true;
        }
        return false;
    },

    this.dayOfWeek = function(targetDay){
        var week = [0,1,2,3,4,5,6];
        var dayOfWeek = week[new Date(targetDay).getDay()];
        return dayOfWeek;
    },
    this.dayOfWeekName = function(targetDay){
        var week = ['일요일', '월요일', '화요일', '수요일', '목요일', '금요일', '토요일'];
        var dayOfWeek = week[new Date(targetDay).getDay()];
        return dayOfWeek;
    },

    this.setTableSelected = function(_this){
        $(_this).parent('.swiper-wrapper').find('.tablerow').removeClass('selected');
        $(_this).addClass('selected');

    },
    this.getSwiperOption = function(rowCnt, paramObj){
        var optionObj = {
            autoHeight: true,
            direction: 'vertical',
            slidesPerView: rowCnt,
            navigation: {
                nextEl: ".btnPrev1",
                prevEl: ".btnNext1"
            }
        }
        if(paramObj && !util.isEmptyStr(paramObj.nextEl)){
            optionObj.navigation.prevEl = paramObj.nextEl;
        }
        if(paramObj && !util.isEmptyStr(paramObj.prevEl)){
            optionObj.navigation.nextEl = paramObj.prevEl;
        }
        util.log("$$$$$$$$$$$$$$getSwiperOption  optionObj : " + JSON.stringify(optionObj));

        return optionObj;

    }

    this.setTableBody = function(divId){
        //tableScroll
        //if ($('.tableBody').length) {

        if(util.isEmptyStr(divId)){

            util.log("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ setTableBody  divId : " + divId);

            //tableScroll
            if ($('.tableBody').length) {
                $('.tablerowWrap .tablerow').each(function(){
                    var tbody = $(this).parent('.tablerowWrap');
                    $(this).click(function(){
                        tbody.find('.tablerow').removeClass('selected');
                        $(this).addClass('selected');
                    });
                });

                $('.tableBody' ).each(function(){
                    var $table = $(this),
                    nextBtn = $(this).parent('.tableWrap').next('.btnWrap').find('.tableDown'),
                    prevBtn = $(this).parent('.tableWrap').next('.btnWrap').find('.tableUp'),
                    rowNum = 0;
                    if($table.hasClass('row10')){rowNum = 10;}
                    else if($table.hasClass('row8')){rowNum = 8;}
                    else if($table.hasClass('row20')){rowNum = 20;}
                    else if($table.hasClass('row13')){rowNum = 13;}
                    else if($table.hasClass('row4')){rowNum = 4;}
                    else if($table.hasClass('row6')){rowNum = 6;}

                    var swiperTable = new Swiper($table, {
                        autoHeight: true,
                        direction: 'vertical',
                        slidesPerView: rowNum,
                        navigation: {
                            nextEl: nextBtn,
                            prevEl: prevBtn,
                        },
                    });
                });
            };


        }else{

            util.log("##############################setTableBody  divId : " + divId);

            $(divId + '.tableBody .tablerowWrap .tablerow').each(function(){
                var tbody = $(this).parent('.tablerowWrap');
                $(this).click(function(){
                    tbody.find('.tablerow').removeClass('selected');
                    $(this).addClass('selected');
                });
            });

//            if(mode != "hidden"){
//                mode = "visible";
//            }
            $(divId).each(function(){
                var $table = $(this),
                nextBtn = $(this).parent('.tableWrap').next('.btnWrap').find('.tableDown'),
                prevBtn = $(this).parent('.tableWrap').next('.btnWrap').find('.tableUp'),
                rowNum = 0;
                if($table.hasClass('row10')){rowNum = 10;}
                else if($table.hasClass('row8')){rowNum = 8;}
                else if($table.hasClass('row20')){rowNum = 20;}
                else if($table.hasClass('row13')){rowNum = 13;}
                else if($table.hasClass('row4')){rowNum = 4;}
                else if($table.hasClass('row6')){rowNum = 6;}

                var swiperTable = new Swiper($table, {
                    autoHeight: true,
                    direction: 'vertical',
                    slidesPerView: rowNum,
                    navigation: {
                        nextEl: nextBtn,
                        prevEl: prevBtn,
                    },
                });
            });
        };
    }

    this.isFunction = function(input) {
        return (
            (typeof Function !== 'undefined' && input instanceof Function) ||
            Object.prototype.toString.call(input) === '[object Function]'
        );
    }

    
    /********************************************
     * 숫자 3자리마다 콤마(,) 생성(천원단위)
     ********************************************/
	this.numberWithCommas = function (x) {
		x =  this.setEmptyStr(x);
		return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }


    this.setMenuSlider = function(){
        //menuSlider
        if ($('.menuListWrap').length) {
            var swiperMenu = new Swiper('.menuListWrap', {
                direction: 'vertical',
                slidesPerView: 2,
                slidesPerColumn: 4,
                spaceBetween: 4,
                navigation: {
                    nextEl: '.menuDown',
                    prevEl: '.menuUp',
                },
            });
        };
    },

    this.utilSetDatePicker = function(className, functionObj, startDate){
        var minDate = "";
        var maxDate = "";
        var setDate = "";

        if(util.isEmptyStr(startDate)){
            setDate = moment().format("YYYY-MM-DD");
        }else{
            setDate = moment(startDate, "YYYYMMDD").format("YYYY-MM-DD");
        }

        if(className == ".dateFrom"){
            minDate = '2000-01-01';
            maxDate = setDate;
        }else{
            minDate = setDate;;
            maxDate = setDate;
        }

        util.log("setDatePicker  this.className : " + className +", :" +minDate+", :" +maxDate);
        $(className).datepicker({
            dateFormat: 'yy-mm-dd'
            ,showMonthAfterYear: true
            ,showOtherMonths: true
            ,yearSuffix: "."
            ,monthNames: ['1','2','3','4','5','6','7','8','9','10','11','12']
            ,dayNamesMin: ['일','월','화','수','목','금','토']
            ,showOn: 'button'
            ,buttonText: 'Show Date'
            ,buttonImageOnly: true
            ,buttonImage: 'images/calendar.png'
            ,minDate : minDate
            ,maxDate : maxDate
            ,onClose: function( selectedDate ) {
                util.log("setDatePicker onClose this.className : " + this.className +", :" +selectedDate);
                if(this.className.indexOf("dateFrom") != -1){
                    $(".dateTo").datepicker( "option", "minDate", selectedDate );
                }else{
                    $(".dateFrom").datepicker( "option", "maxDate", selectedDate );
                }
            }
            ,onSelect: function(d,i){
                util.log("setDatePicker onSelect d : " + d + ", :" + i.lastVal);
                if(d !== i.lastVal){
                    $(this).change();
                }
            }
        }).on("change", function(){
            util.log("setDatePicker change this : " + this.value);
            if(util.isFunction(functionObj)){
                functionObj(this);
            }
        });



    },

    this.setDatePicker = function(functionObj){
        if ($('.dateFrom').length) {
            $(".dateFrom,.dateTo").datepicker({
                dateFormat: 'yy-mm-dd'
                ,showMonthAfterYear: true
                ,showOtherMonths: true
                ,yearSuffix: "."
                ,monthNames: ['1','2','3','4','5','6','7','8','9','10','11','12']
                ,dayNamesMin: ['일','월','화','수','목','금','토']
                ,showOn: 'button'
                ,buttonText: 'Show Date'
                ,buttonImageOnly: true
                ,buttonImage: 'images/calendar.png'
                ,onSelect: function(d,i){
                    util.log("setDatePicker  d : " + d + ", :" + i.lastVal);
                    if(d !== i.lastVal){
                        $(this).change();
                    }
                }
            }).on("change", function(){
                util.log("setDatePicker  this : " + this.value);
                if(util.isFunction(functionObj)){
                    functionObj(this);
                }
            });
        }
    },

    this.setNumberingWrap = function(functionObj){
        $('.btnNumber').click(function(){
            var $numbering = $(this).parent().find('.numberingWrap'),
            slider = $numbering.find('.numberSlide'),
            nextBtn = $numbering.find('.numberDown'),
            prevBtn = $numbering.find('.numberUp'),
            btn = slider.find('button');
            $numbering.show();
            var swiperNum = new Swiper(slider, {
                direction: 'vertical',
                slidesPerView: 4,
                spaceBetween: 4,
                navigation: {
                    nextEl: nextBtn,
                    prevEl: prevBtn,
                },
            });
            btn.click(function(){

                util.log("setNumberingWrap :" + this.textContent + ", value : " + this.value);
                if(util.isFunction(functionObj)){
                    functionObj(this);
                }

                $numbering.hide();
            })
        });
    }

    /*************************************************************
     * 데이터 복제하기
     * JSON 데이터 복제.
     *************************************************************/
    this.clone = function ( obj ) {
    	if ( this.isEmpty( obj ) ) {
    		return obj;
    	}
    	if ( typeof obj === 'string' ) {
    		return obj;
    	}
    	if ( typeof obj === 'object') {
    		try {
				return JSON.parse(JSON.stringify(obj));
			} catch (e) {
				throw "데이터 복제에 실패하였습니다.";
			}
    	}
    	return obj;
    }



    /**********************************************************************
     * rows 데이터의 언어처리
     * 한글요청일 경우는 변경하지 않는다.
     * @parameter rows  변경대상 Rows
     * @parameter _langCode 적용할 한글명
     * @parameter korNmColumn 기본 한글컬럼명
     **********************************************************************/
    this.setRowsLanguage = function ( rows , _langCode , korNmColumn ) {
    	if ( rows == undefined || rows == null || rows.length == 0) {
    		return rows
    	}
    	if ( _langCode == 'ko') {
    		//console.log('한글은 기본 변환하지 않는다.');
    		return rows;
    	}

    	if ( this.isEmptyStr( _langCode ) ) {
    		//console.log("langcode 값이 없으므로 변환하지 않는다.");
    		return rows;
    	}
    	var upperLanguage = _langCode.toUpperCase();
    	
    	if(korNmColumn == 'DESCRIPTION_S') {
    		//베스트 메뉴일때 해당 언어셋일때만 상품 설명을 보여준다. 해당언어셋일떄 빈값이면 빈값으로 노출
    		if(_langCode == 'ko'){
    			rows.forEach(e=> {
        			e[korNmColumn] = util.setEmptyStrDefault(  e[korNmColumn ] , e[korNmColumn] ) ; 
        		});
    		} else {
    			rows.forEach(e=> {
        			e[korNmColumn] = util.setEmptyStrDefault(  e[korNmColumn + "_" + upperLanguage ] , e[korNmColumn + "_" + upperLanguage] ) ; 
        		});
    		}
    	} else {
    		rows.forEach(e=> {
    			e[korNmColumn] = util.setEmptyStrDefault(  e[korNmColumn + "_" + upperLanguage ] , e[korNmColumn] ) ; 
    		});
    	}

		return rows;
    }

    /***********************************************************
     * GetEnvXmlPosENV 에 대한 세부버전.
     * GetEnvXmlPosENV 은 ENV_SET_VAL 값이 필요하지만
     * 다른곳에서는 ENV_VAL_NM (공통코드) 의 컬럼값이 필요하다.
     ***********************************************************/
    this.GetEnvXmlPosEnvDtl = function(cdVal) {
    	let s = ""
    		+ "\n SELECT                                ".rtrim()
    		+ "\n        A.ENV_SET_VAL  AS ENV_SET_VAL  ".rtrim()
    		+ "\n      , B.ENV_SET_CD   AS ENV_SET_CD   ".rtrim()
    		+ "\n 	   , B.ENV_VAL_NM   AS ENV_VAL_NM   ".rtrim()
    		+ "\n   FROM SCD_ENVPS_T A                  ".rtrim()
    		+ "\n      , CCD_ENVDT_T B                  ".rtrim()
    		+ "\n  WHERE A.SHOP_CD     = ?              ".rtrim()
    		+ "\n    AND A.POS_NO      = ?              ".rtrim()
    		+ "\n    AND A.ENV_SET_CD  = ?              ".rtrim()
    		+ "\n    AND A.ENV_SET_CD  = B.ENV_SET_CD   ".rtrim()
    		+ "\n    AND A.ENV_SET_VAL = B.ENV_VAL_CD   ".rtrim()
    		+ "\n    AND A.USE_YN = 'Y'                 ".rtrim()
    		+ "\n    AND B.USE_YN = 'Y'                 ".rtrim()
    		;

    	try {
    		let row = this.getDbSingleRow( gfn_SQLiteSQLProcess( s , [gShopCd, gPosNo , cdVal +"" ]) );
    		return row;
		} catch (e) {
			util.logError(e);
			return "-ERROR-";
		}
    }

	this.GetEnvXmlPosENV  = function (cdVal ) {
		var s = "SELECT ENV_SET_VAL FROM SCD_ENVPS_T WHERE SHOP_CD = ? AND POS_NO = ? AND ENV_SET_CD = ? /** 단발성 SQL **/ ";
		var db_result = gfn_SQLiteSQLProcess( s , [gShopCd, gPosNo , cdVal +"" ]);

		if ( util.isEmpty(db_result )  || util.isEmpty( db_result.Data)  || db_result.Data.length == 0 ) {
			util.logInfo("POS Env 정보가져오기에 실패하였습니다.[" + cdVal + "]");
			return "";
		}

		var row = db_result.Data[0];
		return row['ENV_SET_VAL'];
	}

	this.GetEnvXmlShopINFO = function ( keyName ) {
		var sql = ""
			  + "\n SELECT                                                ".rtrim()
			  + "\n        A.SHOP_NM                    AS SHOP_NM        ".rtrim()
			  + "\n      , A.HD_SHOP_CD                 AS HD_SHOP_CD     ".rtrim()
			  + "\n      , A.PGM_TYPE_FG                AS PGM_TYPE_FG    ".rtrim()
			  + "\n      , A.OWNER_NM                   AS OWNER_NM       ".rtrim()
			  + "\n      , A.BIZ_NO                     AS BIZ_NO         ".rtrim()
			  + "\n      , A.TEL_NO                     AS TEL_NO         ".rtrim()
			  + "\n      , A.ADDR || ' ' || A.ADDR_DTL  AS ADDRESS        ".rtrim()
			  + "\n      , B.SALE_MG_CNT                AS SALE_MG_CNT    ".rtrim()
			  + "\n      , A.SALEMG_MGR_YN              AS SALEMG_MGR_YN  ".rtrim()
			  + "\n      , A.SHOP_STAT_FG               AS SHOP_STAT_FG   ".rtrim()
			  + "\n      , A.BIZ_SHOP_NM                AS BIZ_SHOP_NM    ".rtrim()
			  + "\n      , A.VAN_CORP_CD                AS VAN_CORP_CD    ".rtrim()
			  + "\n      , A.POINT_FG                   AS POINT_FG       ".rtrim()
			  + "\n   FROM SCD_SHOPM_T A                                  ".rtrim()
			  + "\n    , ( SELECT COUNT( SALE_MG_CD ) AS SALE_MG_CNT      ".rtrim()
			  + "\n        FROM SCD_SLMGM_T                               ".rtrim()
			  + "\n        WHERE SHOP_CD = ?                              ".rtrim()
			  + "\n        AND USE_YN    = 'Y' ) B                        ".rtrim()
			  + "\n  WHERE A.SHOP_CD = ?                                  ".rtrim()
			 ;

		var params = [gShopCd, gShopCd ];

		var db_result = gfn_SQLiteSQLProcess( sql  , params);
		if ( util.isEmpty(db_result )  || util.isEmpty( db_result.Data)  || db_result.Data.length == 0 ) {
			throw "Shop 정보가져오기에 실패하였습니다.";
		}
		return db_result.Data[0][keyName];
	}

	this.GetEnvXmlShopENV= function (envSetCd ) {
		util.logInfo("*****GetEnvXmlShopENV Start envSetCd == > " + envSetCd);
		envSetCd = envSetCd +"";

		var sql = "SELECT ENV_SET_VAL FROM SCD_ENVSH_T WHERE SHOP_CD = ? AND ENV_SET_CD = ?  ";
		var db_result = gfn_SQLiteSQLProcess( sql  , [ gShopCd , envSetCd +"" ]);
		if ( util.isEmpty(db_result )  || util.isEmpty( db_result.Data)  || db_result.Data.length == 0 ) {
			util.logError("***** GetEnvXmlShopENV 환경설정데이터를 가져오지 못하였습니다.[" + envSetCd + "]" );
			return "";
		}

		val = db_result.Data[0].ENV_SET_VAL;
		util.logInfo("*****GetEnvXmlShopENV result ENV_SET_VAL == > " + val);
		return val ;
	}

	/***************************************
	 * 관리자 페이지 상단 정보.
	 ****************************************/
	this.adminPageHeaderInfoData = function() {
		var obj = {};
		obj.SHOP_NM = SHOP_INFO.SHOP_NM;
		if ( saleDate == "")
			obj.SALE_DATE = "";
		else
			obj.SALE_DATE = moment(saleDate, 'YYYYMMDD').format("YYYY-MM-DD [(]ddd[)]");;
		obj.EMP_NM = loginEmpNm;
		obj.TODAY_DATE = moment().format("YYYY-MM-DD [(]ddd[)]");
		obj.TODAY_TIME = moment().format("HH:mm");
		return obj;
	}

	this.callPaymentApp = function(controlUri, requestData, resultCallback)
    {	
		util.logInfo("controlUri >>> " + controlUri);
        try
        {
            var appControl = new tizen.ApplicationControl(controlUri,
            										  null,
            										  null,
            										  null,
            										  [new tizen.ApplicationControlData("text", [requestData])]);

            var successCallback = function() {
            	util.logInfo("launch application control succeed_________");
            	//alert("launch application control succeed");
            };

            var errorCallback = function(e) {
                //alert("launch application control failed. reason: " + e.message);
            };

            tizen.application.launchAppControl(appControl,
    							               null,
    							               successCallback,
    							               errorCallback,
    							               resultCallback
            );
        }
        catch (error)
        {
            alert("launchAppControl(): " + error.message);
        }
    }

	// 반품함수
    this.fnCreditApproveRequest = function(payData){
    	util.logInfo("***** util.js fnCreditApproveRequest START *****");
        try
        {
            let catid= "";

            if ( BIZ_CLS_TYPE == '0') {
                //단독사업자
                catid = BIZ_CLS_SINGLE_CAT_ID ;
            } else {
                //복수사업자
            	catid = payData.VAN_TERM_NO; 
            }

            var controlUri = 'http://skiosk/payment/appcontrol/orderCreditControl';

            // 거래금액, 부가세, 할부 개월, 원거래 승인번호, 원거래 일자, 카드번호
            // - '카드번호' 는 카카오등 간편 결재시 사용...

		var apprDate = moment(payData.APPR_DATE, 'YYYYMMDD').format("YYMMDD");
            
            if(util.isEmptyStr(payData.CUP_DEPOSIT_AMT)) payData.CUP_DEPOSIT_AMT = "0"
            
            var requestData = { "CatId":catid,
                                "Pay":payData.APPR_AMT,
                                "Tax":"0",
                                "InstallmentMonths":"00",
                                "ApproveNo":payData.APPR_NO,
                                "ApproveDate" : apprDate,
                                "CardNo" : payData.CARD_NO,
                                "Type":payData.appType,
                                "MechantTempInfo":"",
                                "TaxSaleAmt":"",
                                "NonTaxSaleAmt":"",
                                "UserServiceCode":"",
                                "UserServiceData":"",
                                "SignTimeout1":"0",
                                "SignTimeout2":"0",
                                "Language":"ko",
                                "ServiceAmt":"0",
                                "CupDeposit": String(payData.CUP_DEPOSIT_AMT)
                                };


            util.logDebug("util.js fnCreditApproveRequest Reply from Payment requestData : " + JSON.stringify(requestData));
            var appControlReplyCallback = {
                onsuccess: function(data) {
                    /*
                    정상 :
                        - 카드 승인 시: Status  - APPROVE
                            {
                                "Status" : "APPROVE",
                                "가맹점명" : "FDK 2",
                                "가맹점번호" : "9786084798",
                                "가맹점전화번호" : "0215443850",
                                "가맹점주소" : "서울 관악구 봉천11동 자티전자빌딩3층",
                                "거래금액" : "1025",
                                "거래일련번호" : "082719000169",
                                "거래일시" : "200827134715",
                                "대표자명" : "홍길동",
                                "매입사명" : "롯데",
                                "발급사명" : "롯데",
                                "부가세" : "",
                                "카드잔액" : "",
                                "사업자번호" : "3000000000",
                                "승인번호" : "19000169",
                                "알림메세지" : "무서명거래",
                                "알림메세지1" : "",
                                "알림메세지2" : "",
                                "알림메세지3" : "",
                                "알림메세지4" : "",
                                "응답메세지1" : "정상완료",
                                "응답메세지2" : "",
                                "전표번호" : "2008303968",
                                "카드명" : "롯데플래티늄",
                                "카드번호" : "536510**********"
                            }
                        - 카드 승인 거절(실패) 시 : Status  - DECLINE

                            {
                               "Status" : "DECLINE",
                               "응답메세지1" : "거래불가가맹점",
                               "응답메세지2" : "1588-1788",
                               "NOTICE" : "",
                               "알림메세지1" : "",
                               "알림메세지2" : "",
                               "알림메세지3" : "",
                               "알림메세지4" : ""
                            }

                    오류 :
                        CANCEL : 사용자가 승인 취소 시
                        ERROR : 오류
                    */

                    util.logDebug("Reply from Payment data : " + JSON.stringify(data));
                    //util.log("Reply from Payment : " + data[0].value[0]);

                    adminService.fnCallbackCancelApproval(data, payData);
                    //document.getElementById("ResultData").innerHTML= 'Credit Approve Result : '+data[0].value[0];
                },

                onfailure: function() {
                    alert("Failed to get a reply \n from the Payment");
                    adminService.fnCallbackCancelApproval(data, cardReturnInfoParam);
                }
            };

            util.callPaymentApp(controlUri, JSON.stringify(requestData), appControlReplyCallback);
        }
        catch (error)
        {
            alert("launchAppControl(): " + error.message);
            nativeApp.functionCallSync(["DB_Close"]);
        }
    },

    this.fnTranDbExec = function(sql, params){
        try{
            var sendSQL = gfn_sqlBindParameters(sql, params );
            util.log("SQL \n"  + sendSQL );

            var borwserNavigator = navigator.userAgent.toUpperCase();
            if ( borwserNavigator.indexOf("TIZEN") != -1 ) {

                result = nativeApp.functionCallSync(["DB_SqlExec", sendSQL]);
                return result;
            }else{
                var resultData = gfn_db2_window( sendSQL, []  );
                util.logDebug('*****fnTranDbExec gfn_SQLiteSQLProcess result : ' + JSON.stringify(resultData) );
                return resultData;

            }
        }catch(e){
            util.logError("fnTranDbExec catch DB error e : " + e.toString());
        }
    }

    /*******************************************************
     * 입력한 문자를 기준으로 byte 계산(cpp 기준임)
     * 한글, 특수문자 2바이트 그외 1바이트로 계산.
     * 주로 print 에서 사용.
     * 그 이외에는 처리하지 않음.
     *******************************************************/
    this.byteLen = function( s ) {
    	if ( s == undefined || s == null )
    		return 0;
    	if ( typeof s == "string")
    		return s.getByteLength();
    	throw  "입력값이 문자가 아닙니다. 입력값[%s , %s]".sprintf((s + "") , (typeof s));
    }

    /*************************************************************
     * 간편결제에서 결제구분코드 조회.
     *************************************************************/
    this.GetSimplePayTrType = function(strBarcode){
    	let strResult = "";
    	if( this.byteLen(strBarcode) == 0 )
    		throw { errMsg : "Barcode가 입력되지 않았습니다." , errCode : '0001' };

    	let db_result = gfn_SQLiteSQLProcess( sqlQuery.ComCodeSelect_SQL , ['814' ]);
    	if ( db_result == null || db_result == undefined || db_result.Data == null || db_result.Data==undefined || db_result.Data.length == 0 )
    		throw {errMsg : util.languageObjReturn(langCode, 'failBarcodeScan') , errCode : '9001' } ;

    	var rows = db_result.Data;
		for (let itx = 0; itx < rows.length; itx++) {
			let row = rows[itx];
			let strItem_1 = row[ "COM_CD_ITEM_01" ] ;
			let strItem_2 = row[ "COM_CD_ITEM_02" ] ;

			let nBarLength = parseInt( strItem_2.substr(4, 2) ); // 2019-1213-HJH add bin fixlength
			let nLength    = parseInt( strItem_2.substr(2, 2) );
			let nIndex     = parseInt( strItem_2.substr(0, 2) ); // 2019-1213-HJH add bin index

			if (Number.isNaN ( nBarLength ) )
				nBarLength = 0;

			// COM_CD_ITEM_01 : BIN(Prefix) 6자리.
			// COM_CD_ITEM_02 : Index(2) + length(2) + fixlength(2)
			// 페이코 (031) : 21자리
			// lPay (071) : 22 자리
			// SSG (081) : 22 자리

			var barCodeLenObj =  {
				"031" : 21
				,"071" : 22
				,"081" : 22
				};

			nBarLength = barCodeLenObj[row[ "COM_CD" ]] === undefined ? 0  : barCodeLenObj[row[ "COM_CD" ]];

			if( nBarLength == strBarcode.length || nBarLength == 0 ) {
				if( strBarcode.substr( nIndex - 1, nLength ) == strItem_1 ) {
					if( this.byteLen(strItem_1) != 0 ) {
						strResult = row[ "COM_CD" ];
						break;
					}
				}
			}

			if ( strResult == "" && strBarcode.length == 21 ) {
				strResult = "02";
			}else if ( strResult == "" && strBarcode.length == 20 ) { // 페이코 쿠폰
				util.logInfo("***** 페이코 쿠폰 *****");
				if( strBarcode.substr( nIndex - 1, nLength ) == strItem_1 ) {
					if( this.byteLen(strItem_1) != 0 ) {
						// strResult = row[ "COM_CD" ];
						strResult = "030";
						break;
					}
				}				
			}
		}

		console.log(`strResult : ${strResult}`);

		if ( strResult == "02")
			return { trTypeKey : strResult , trTypeVal : '0' };// app card

		if ( strResult == "011")
			return { trTypeKey : "041" , trTypeVal :'1' };//kakao pay

		if ( strResult == "021" || strResult == "022")
			return { trTypeKey : "051" , trTypeVal :'2' } ;//zero pay
		
		if ( strResult == "030"){ // 페이코 쿠폰
			if(BIZ_CLS_TYPE == '0'){
				return { trTypeKey : "021" , trTypeVal :'8' } ;
			}else{
				throw {errMsg : '복수사업자는 페이코 결제가 되지 않습니다.' , errCode : ""};				
			}
		}
		if ( strResult == "031"){ // 페이코 신용
			if(BIZ_CLS_TYPE == '0'){
				return { trTypeKey : "021" , trTypeVal :'8' } ;
			}else{				
				throw {errMsg : '복수사업자는 페이코 결제가 되지 않습니다.' , errCode : ""};
			}
		}

		if( strResult == "041" ){
			return { trTypeKey : strResult , trTypeVal : '0' };//BC-QR
		}

		if( strResult == "071" ){
			return { trTypeKey : '141' , trTypeVal : '5' }; // LPay
		}
		if( strResult == "081" ){
			return { trTypeKey : '161' , trTypeVal : '4' }; // SSGPay
		}
		
		if ( strResult == '') {
			return this.GetSimplePayTrType2(strBarcode); // 일치하는 값이 없다면 알리페이, 위챗페이인지 확인하는 함수 호출.			
		}
    }

    // 알리페이, 위챗페이 여부 확인 함수.
    this.GetSimplePayTrType2 = function(strBarcode){
    	util.logInfo("***** 간편결제 알리/위쳇페이 여부 확인 함수 시작. GetSimplePayTrType2 *****");
    	let strResult = "";

    	let db_result = gfn_SQLiteSQLProcess( sqlQuery.ComCodeSelect_SQL , ['819' ]);
    	if ( db_result == null || db_result == undefined || db_result.Data == null || db_result.Data==undefined || db_result.Data.length == 0 )
    		throw {errMsg : util.languageObjReturn(langCode, 'failBarcodeScan') , errCode : '9001' } ;
    		//간편 결제용 바코드를 스캔해주세요.
    	var rows = db_result.Data;
		for (let itx = 0; itx < rows.length; itx++) {
			let row = rows[itx];
			let strItem_1 = row[ "COM_CD_ITEM_01" ] ;
			let strItem_2 = row[ "COM_CD_ITEM_02" ] ;
			
			let nBarLength = parseInt( strItem_2.substr(4, 2) ); // 2019-1213-HJH add bin fixlength
			let nLength    = parseInt( strItem_2.substr(2, 2) );
			let nIndex     = parseInt( strItem_2.substr(0, 2) ); // 2019-1213-HJH add bin index

			util.logInfo("***** GetSimplePayTrType2 strItem_1 --> " + strItem_1);
			util.logInfo("***** GetSimplePayTrType2 strItem_2 --> " + strItem_2);
			
			if (Number.isNaN ( nBarLength ) )
				nBarLength = 0;

			
			util.logInfo("***** GetSimplePayTrType2 nBarLength --> " + nBarLength);
			util.logInfo("***** GetSimplePayTrType2 strBarcode.length --> " + strBarcode.length);
			util.logInfo("***** GetSimplePayTrType2 strBarcode --> " + strBarcode);
			util.logInfo("***** GetSimplePayTrType2 strBarcode.substr( nIndex - 1, nLength ) --> " + strBarcode.substr( nIndex - 1, nLength ));
			// COM_CD_ITEM_01 : BIN(Prefix) 6자리.
			// COM_CD_ITEM_02 : Index(2) + length(2) + fixlength(2)
			if( nBarLength == strBarcode.length || nBarLength == 0 ) {
				if( strBarcode.substr( nIndex - 1, nLength ) == strItem_1 ) {
					if( this.byteLen(strItem_1) != 0 ) {
						strResult = row[ "COM_CD" ];
						break;
					}
				}
			}
			
			if ( strResult == "" && strBarcode.length == 21 ) {
				strResult = "02";
			}
		}

		util.logInfo("***** GetSimplePayTrType2 strResult --> " + strResult);

		if ( strResult == "051")
			return { trTypeKey : strResult , trTypeVal : '3' };// 알리페이

		if ( strResult == "061")
			return { trTypeKey : strResult , trTypeVal :'3' }; // 위챗페이
			
			
		if ( strResult == '') {
			if ( typeof langCode != 'undefined' )
				throw {errMsg : util.languageObjReturn(langCode, 'unknownBacordRetry') , errCode : "0002"}; //"알수 없는 바코드 형식입니다. 확인 후 다시 거래해 주세요."
			else
				throw {errMsg : "알수 없는 바코드 형식입니다. 확인 후 다시 거래해 주세요." , errCode : "0002"};
		}
    }
    /**********************************************************************
     * 개점정보를 반환한다.
     * @return empty JSON or JSON{REGI_SEQ , CLOSE_FG} 
     **********************************************************************/
    this.shopOpenInfo = function() {
		let result = gfn_SQLiteSQLProcess(sqlQuery.shopOpenInfo_SQL , [gShopCd , saleDate , gPosNo  ]);
		return this.getDbSingleRow(result);
    }

    /**********************************************************************
     *
     * @parameter @parameter db 조회하고 난 후 result
     * @return {} or 첫번째 row {} JSON 형태로 반환.
     * @throw 
     **********************************************************************/
    this.getDbSingleRow = function(db_result) {
    	let rows = this.getDbMultiRows(db_result);
    	if (rows.length == 0 )
    		return {};
    	else
    		return rows[0];
    }

    /**********************************************************************
    * 
    * @parameter db 조회하고 난 후 result
    * @return [] 또는 array
    * @throw DB 처리 오류시 오류메시지나 없을시 자체 메세지 출력.
    **********************************************************************/
    this.getDbMultiRows = function(db_result) {
    	/******************* db_result valid  Start ****************************/
    	if( this.isEmpty (db_result ) || this.isEmpty( db_result.ResultCode ) )
    		return [];

    	if( db_result.ResultCode !== '0' ) {
    		if( this.isEmpty( db_result.Message ) )
    			throw 'DB 처리중에 오류가 발생하였습니다.';
    		else
    			throw db_result.Message;
    	}

    	/******************* db_result valid  End ****************************/

    	if ( this.isEmpty( db_result.Data) || db_result.Data.length === 0  )
    		return [];
    	else
    		return db_result.Data;

    },

	/**********************************************************************************************************
	 * Login 한 정보를 SESSION에서 가져와서 각 전역변수에 등록 처리.
	 **********************************************************************************************************/
	this.bindSession2GV = function () {
	    let EMP_INFO_ROW =  JSON.parse( sessionStorage.getItem("EMP_INFO" ) );
		if ( EMP_INFO_ROW == undefined || EMP_INFO_ROW == null  || util.isEmptyStr( EMP_INFO_ROW.EMP_NO )  ) {
		    window.location.replace('./admin.html');
			return;
		}

        //공통변수 셋팅 함수
		//util.fnSetGlobalVariable();

		//공통변수 설정.
		gShopCd = sessionStorage.getItem("SHOP_NO" );
		gPosNo = sessionStorage.getItem("POS_NO" );
		mainPosNo = sessionStorage.getItem("MAIN_POS_NO"   ); //MAIN POS NO

		// 관리자에서 저장한 서버의 IP,PORT정보를 전역변수에 담는다.
		SERVER_IP_DEFAULT = sessionStorage.getItem("SERVER_IP_DEFAULT" ); // 결제를 위한 서버 IP : 디폴트 값
	    SERVER_PORT_DEFAULT = sessionStorage.getItem("SERVER_PORT_DEFAULT" ); // 결제를 위한 서버 PORT: 디폴트 값
		SERVER_IP = sessionStorage.getItem("SERVER_IP" ); // 결제를 위한 서버 IP: 현재 매장에 설정되어있는 환경변수에 대한 서버정보값
	    SERVER_PORT = sessionStorage.getItem("SERVER_PORT" ); // 결제를 위한 서버 PORT: 현재 매장에 설정되어있는 환경변수에 대한 서버정보값
	    gAspLogoUseYn = sessionStorage.getItem("LOGO_USE_YN"); // 사용자 상단로고를 사용할지 여부.
	    gAspLogoExt = sessionStorage.getItem("LOGO_USE_EXT"); // 사용자 로고 확장자	    
	    
		loginEmpNo = EMP_INFO_ROW.EMP_NO;//사번
		loginEmpNm = EMP_INFO_ROW.EMP_NM;//사원이름.
		loginEmpInfo = this.clone( EMP_INFO_ROW ) ;//사용자 전체 정보.
		
		//SCD_SHOPM_T 가맹점 정보(DB row 데이터로 들어있음)
		let shopInfo = sessionStorage.getItem("SHOP_INFO" );
		SHOP_INFO = JSON.parse(shopInfo);
		
		inRegiCloseFg = sessionStorage.getItem("inRegiCloseFg");
        gsOrderNoAspYn = sessionStorage.getItem("gsOrderNoAspYn"); // asp에서 orderNo를 채번할지 여부
        gsTuClsAll = sessionStorage.getItem("gsTuClsAll"); // 분류의 All을 보여줄지 말지 환경설정코드
        gsSidePopVal = sessionStorage.getItem("gsSidePopVal"); // 사이드 팝업 종류 환경변수 (0:기본화면, 1:상품설명, 2:상품설명+이미지)
        gsWaitingVisibleDiv = sessionStorage.getItem("gsWaitingVisibleDiv"); // 대기화면/동영상일 때 최초에 버튼 보임 여부 환경변수 : 0 = 모두보임, 1 = 이미지만 보임, 2 = 동영상만 보임, 3 = 이미지/동영상 둘다 안보임 (733)
        gsSpecialShopFlag = sessionStorage.getItem("gsSpecialShopFlag"); // 매장 판단 - 값이 5인 경우 커반 매장(이퀴닉스 서버로 전송할지 여부판단), 6인 경우 드롭탑 매장 ( 결제수단의 버튼 분기)
        gsSideQtyYn = sessionStorage.getItem("gsSideQtyYn"); // 사이드 수량 사용여부 0 : 미 사용(또는 빈값), 1 : 사용
        gsMobileCouponTg = sessionStorage.getItem("gsMobileCouponTg"); // 모바일쿠폰 - 톨게이트 0 : 미 사용(또는 빈값), 1 : 사용
        gsMobileCouponSc = sessionStorage.getItem("gsMobileCouponSc"); // 모바일쿠폰 - 슈퍼콘 0 : 미 사용(또는 빈값), 01 : 사용 -> 표시는 미사용 N, 사용 Y
        gWaitingPageVal = sessionStorage.getItem("gWaitingPageVal"); // 기초관리 -> 설치자용 -> 매장환경설정 -> 포스환경 환경설정 번호 : 903 [대기화면제거]
        gMemberService = sessionStorage.getItem("gMemberService"); // 멤버십(구독) 서비스 적용 여부 구분 값 구분값 : 사용 / 미사용
        //gMemberService = "1"; // 멤버십(구독) 서비스 적용 여부 구분 값 구분값 : 미사용 / 사용
        
        gNfcShopVal = sessionStorage.getItem("gNfcShopVal"); // NFC 단말기 여부 판단 0 : 미사용, 1 : 사용
	}

    this.fnSetGlobalVariable = function(){
    	var result = "" , result2 = "";

        var sql = " SELECT A.SHOP_CD AS SHOP_CD, A.POS_NO AS POS_NO "
                    + " ,B.MAIN_POS_NO AS MAIN_POS_NO, A.WAIT_VIDEO_VER AS WAIT_VIDEO_VER "
                    + " ,A.WAIT_VIDEO_EXT AS WAIT_VIDEO_EXT, A.WAIT_IMG_VER AS WAIT_IMG_VER, A.WAIT_IMG_EXT AS WAIT_IMG_EXT "
                    + " ,C.SALE_DATE AS SALE_DATE, C.CLOSE_FG AS CLOSE_FG "
                + " FROM SCD_SETUP_T A "
                    + " ,(SELECT SHOP_CD, POS_NO AS MAIN_POS_NO "
                    + " FROM SCD_ENVPS_T "
                    + " WHERE ENV_SET_CD  = '205' "
                        + " AND   ENV_SET_VAL = '1') B LEFT OUTER JOIN "
                    + " (SELECT SHOP_CD, POS_NO, SALE_DATE , CLOSE_FG "
                    + " FROM POS_REGIS_T "
                    + " WHERE REGI_SEQ = '00' "
                    + " ) C ON B.SHOP_CD = C.SHOP_CD  AND B.MAIN_POS_NO = C.POS_NO "
                + " WHERE A.SHOP_CD = B.SHOP_CD"
                + " ORDER BY C.SALE_DATE DESC "
                + " LIMIT 1 ";

        var sql2 = "SELECT REGI_SEQ, CLOSE_FG "
                    + " FROM POS_REGIS_T "
                    + " WHERE SHOP_CD     = ? "
                        + " AND SALE_DATE = ? "
                        + " AND POS_NO    = ? "
                        + " AND REGI_SEQ <> '00' "
                    + " ORDER BY SALE_DATE DESC , REGI_SEQ DESC "
                    + " LIMIT 1   ";
        try {
        	result = gfn_SQLiteSQLProcess(sql, []).Data;
        	util.logInfo("###################  fnSetGlobalVariable result : " + JSON.stringify(result));
		} catch (e) {
			console.error(' ***** SHOP CD 조회 오류...!')
			util.logError(' ***** SHOP CD 조회 오류...! e == > ' + e.toString());
		}

        //로그레벨 가져옴옴
       util.fnGetLogLevel();

       notifyTalkInterlock = util.GetEnvXmlShopENV(726);

        //util.log("fnSetGlobalVariable END &&&&&&  result : " + JSON.stringify(result));

        var shopENVValue = util.GetEnvXmlShopENV(528);

        if(SHOP_INFO.POINT_CO_VAL == "2") {
            dodoUuid = sessionStorage.getItem("DODO_UU_ID" );
        }

        if(!this.isEmpty(result) && result.length > 0){

            gShopCd = result[0].SHOP_CD;
            gPosNo = result[0].POS_NO;
            gWaitImgExt = result[0].WAIT_IMG_EXT;
            gWaitVideoExt = result[0].WAIT_VIDEO_EXT;
            
            try{
            	//inRegiCloseFg = util.GetEnvXmlShopENV( 113 );
                gvEatTakeOutVal = util.GetEnvXmlPosENV( 698 ); // 먹고가기 포장 환경변수 값
            	//gvEatTakeOutVal = "7";
                //gsOrderNoAspYn = util.GetEnvXmlShopENV( 722 ); // asp에서 orderNo를 채번할지 여부
                //gsTuClsAll = util.GetEnvXmlShopENV(732) // 분류의 All을 보여줄지 말지 환경설정코드
                //gsSidePopVal = util.GetEnvXmlShopENV(831); // 사이드 팝업 종류 환경변수 (0:기본화면, 1:상품설명, 2:상품설명+이미지)
                gsImgVideo = util.GetEnvXmlPosENV ( 709 ) ; // 대기화면 (0:사용자, 1: 외식, 2: 커피)
                //gsWaitingVisibleDiv = util.GetEnvXmlShopENV ( 733 ) ; // 대기화면/동영상일 때 최초에 버튼 보임 여부 환경변수 : 0 = 모두보임, 1 = 이미지만 보임, 2 = 동영상만 보임, 3 = 이미지/동영상 둘다 안보임 (733)
                //gsSpecialShopFlag = util.GetEnvXmlShopENV ( 282 ) ; // 매장 판단 - 값이 5인 경우 커반 매장(이퀴닉스 서버로 전송할지 여부판단), 6인 경우 드롭탑 매장 ( 결제수단의 버튼 분기)
                //gsSideQtyYn = util.GetEnvXmlShopENV ( 741 ) ; // 사이드 수량 사용여부 0 : 미 사용(또는 빈값), 1 : 사용
                gvCashReceiptVal = util.GetEnvXmlPosENV( 742 ); // 현금영수증 사용여부  0: 미사용, 1: 사용
                gvOrderOnly = util.GetEnvXmlPosENV( 748 ); // 주문전용 키오스크 여부(포스설정용)  0: 미사용, 1: 주문전용, 2 : 판매_주문전용
        		
                if ( util.byteLen(gvOrderOnly) == 0 ){
                	gvOrderOnly = "0";
                }
                               
                //적립포인트 사용 상태 체크 
        		//0.미사용, 1.사용, 2.사용+적립팝업
        		SHOP_INFO.PNT_ACMT_STATUS_VAL = util.GetEnvXmlPosENV(699);
                //SHOP_INFO.PNT_ACMT_STATUS_VAL = "2";
        		if ( util.byteLen(SHOP_INFO.PNT_ACMT_STATUS_VAL) == 0 )
        			SHOP_INFO.PNT_ACMT_STATUS_VAL = "0";
        		
        		// 상단메뉴분류타입 0 : 1줄, 1 : 2줄  	  
        		SHOP_INFO.TOP_MENU_TYPE = util.GetEnvXmlPosENV(707);
        		//SHOP_INFO.TOP_MENU_TYPE = "0";
        		if ( util.byteLen(SHOP_INFO.TOP_MENU_TYPE) == 0 )
        			SHOP_INFO.TOP_MENU_TYPE = "0";
        		
        		/** 코너별 결제처리 0 : 통합, 1 : 코너별 결제. **/
        		SHOP_INFO.CORNER_PAY_TYPE = util.GetEnvXmlPosENV(738);
        		if ( util.byteLen(SHOP_INFO.CORNER_PAY_TYPE) == 0 )
        			SHOP_INFO.CORNER_PAY_TYPE = "0";
        		
                if ( util.byteLen(gsTuClsAll) == 0 ) gsTuClsAll = "1";
                
                // 무인로봇 ip/port 불러오기.                
                if(gsSpecialShopFlag == "7" || gsSpecialShopFlag == "9"){ // 알다방 무인로봇, 레인보우 로보틱스 
                	util.logInfo("_____알다방  URL 조회 (대기화면 진입 했을 때)_____");
                	gAldabangUrl = util.GetEnvXmlPosENV(746); // 알다방 url에 값을 셋팅해준다.
                	util.logInfo("_____알다방 URL 결과(대기화면 진입 했을 때) == >>> " + gAldabangUrl);
                }
                
                let cupUprcResult = gfn_SQLiteSQLProcess( sqlQuery.ComCodeSelect_SQL , ['221' ]);
            	if ( cupUprcResult == null || cupUprcResult == undefined || cupUprcResult.Data == null || cupUprcResult.Data==undefined || cupUprcResult.Data.length == 0 ){
            		util.logInfo("1회용 보증금컵 단가 조회 실패");
            	}else{
            		gCupUprc = Number(cupUprcResult.Data[0]["COM_CD_ITEM_01"]); // 보증금컵 단가를 전역변수에 담는다.
            	}
            		
				if(gsSpecialShopFlag == '5'){
					util.bindKerbanSet(); // bindKerbanSet
				}
				
				let langCode = 'ko';
				
				
				//무인/유인 상관없이 전체 상품목록을 저장 - 20231018 , WDH
				util.logInfo("전체 상품 목록체크 !!!! ");
				var vatCd = util.GetEnvXmlShopENV(128)
				gProdAllList = orderMenuService.getProductData(null , langCode , vatCd);
				util.logInfo("전체 상품 목록리스트 갯수 "  + gProdAllList.length);
			
			
				//매장 바코드 상품 코드 데이터를 공통 변수 저장 - 20231018 , WDH
				//초기화 데이터인경우 
				util.logInfo("바코드 상품 목록체크 !!!! ");
				if(!util.isEmpty(gStore_BarcodeProdlist)) 
				{
					util.logInfo("바코드 상품 리스트 확인 완료!!!! ");
				}	
				else
				{
					let posEnv718_shopBarcodeUseType 	= (util.GetEnvXmlPosENV ( 718 ) || "0" ) /**  셀프계산대 대기화면 바코드 인식 기능 : 0- 미사용 , 사용 : 1 **/
					if(posEnv718_shopBarcodeUseType != "0") 
					{
						let shopEvn128 = util.GetEnvXmlShopENV(128);	
						util.logInfo("바코드 상품 최초 저장 시작 !!!! ");
						gStore_BarcodeProdlist = orderMenuService.getProductDataForBarcode(null , langCode , shopEvn128);
					}
				}
				
            }catch(e){
            	util.logError("[ERROR] fnSetGlobalVariable GetEnvXmlShopENV Error" + e.toString());
            }
            
            saleDate = result[0].SALE_DATE;
            if(shopENVValue == "1"){
                mainPosNo = result[0].POS_NO;

            }else{
                mainPosNo = result[0].MAIN_POS_NO;
                inMainRegiFg = result[0].CLOSE_FG;
            }
        }

        try {
        	result2 = gfn_SQLiteSQLProcess(sql2, [gShopCd, saleDate, gPosNo ]).Data;
        	util.logInfo("###################  fnSetGlobalVariable result2 : " + JSON.stringify(result2));
		} catch (e) {
			console.error(' 마감정보 조회 오류...!')
			util.logError('***** 마감정보 조회 오류...! e == > ' + e.toString());
		}

        //util.log("fnSetGlobalVariable END &&&&&&  result : " + JSON.stringify(result2));

        if(!this.isEmpty(result2) && result2.length > 0){
            inRegiSeq    = result2[0].REGI_SEQ;   //현재 POS 마감 차수.
            inRegifg     = result2[0].CLOSE_FG;   //현재 POS 마감 현황.

            if(shopENVValue == "1"){
                inMainRegiFg = result2[0].CLOSE_FG;   //현재 POS 마감 현황.
            }
        }

        loginEmpInfo = JSON.parse( sessionStorage.getItem("EMP_INFO" ) );

        //CAT ID 설정.(global variable)
        this.setBizClsVariable();
        this.setEnvshVariable();


		//상품데이터 LOAD - 20231017
		this.setBizClsVariable();
		
        //util.log("fnSetGlobalVariable END &&&&&&&&&&&&&&&&&&");
    }

    //CAT ID 설정.
    this.setBizClsVariable = function() {
        try {
        	BIZ_CLS_TYPE = util.GetEnvXmlShopENV( 114 );//단독 사업자인지 복수사업자인지 확인(0 : 단독, 1 : 복수)
        	//단일 사업자의 경우...
        	if ( BIZ_CLS_TYPE == "0" ) {

        		let row = this.getDbSingleRow( gfn_SQLiteSQLProcess(sqlQuery.GetCatIdSingleBiz_SQL.sprintf( gShopCd , gPosNo ) , []) ) ;
        		BIZ_CLS_SINGLE_CAT_ID = this.setEmptyStrDefault( row.VAN_TERM_NO , "") ;

        	} else {
        		//TODO 복수 사업자의 경우

        	}

        } catch (e) {
			util.logError('CAT ID 조회중 오류가 발생하였습니다. e == > '+ e.toString());
			console.error(e);
		}
    }
    
    //포인트 적립 기준 설정.
    this.setEnvshVariable = function() {
        try {
    		// 포인트 적립 기준 옵션. (0:기존, 1:판매금액)
    		let ENVSH_ROW  = this.getDbSingleRow( gfn_SQLiteSQLProcess(sqlQuery.GetEnvshSetVal_SQL.sprintf( gShopCd , '656' ) , []) ) ;
    		POINT_ENV_SET_VAL = this.setEmptyStrDefault( ENVSH_ROW.ENV_SET_VAL , "") ;
        } catch (e) {
			util.logError('setEnvshVariable catch e == > '+ e.toString());
		}
    }

    /*******************************************
     * tizen 인지 window 인지 체크 하는 부분.
     *******************************************/
    this.isTizen = function() {
    	let ua = window.navigator.userAgent.toUpperCase();
    	if ( ua.indexOf("TIZEN") != -1 ) {
    		return true;
    	} else {
    		return false;
    	}
    }
    
    //결제성공시 결제승인파일 삭제
    this.fnDelPayInfoFile = function(fileName) {
    	var fullPath = netCancelPath + "/" + fileName;
    	var dirPath = netCancelPath;
    	var downloadsDir;
    	
    	util.logInfo("###################  fnDelPayInfoFile start  #################");
    	
    	util.logInfo("#####  fileName >> " + fileName);
    	
    	if( this.isTizen() == false ) return;
    	
    	tizen.filesystem.resolve(dirPath, function(result) {
			downloadsDir = result;
			
			downloadsDir.deleteFile(fullPath, function() {
				util.logInfo("#### fnDelPayInfoFile Old File Deleted Success ####");
			}, function(e) {
				util.logError("#### fnDelPayInfoFile Old File Deleted Error " + e.message);
			});
		});
    	
    }
    
    //결제실패시 결제승인파일 정보 변경
    this.fnUpdatePayInfoFile = function(fileName) {
    	util.logInfo("***** fnUpdatePayInfoFile START *****");
    	util.logInfo("***** 망취소 시작 (sendOk 2번으로 변경 시작) *****");
    	util.logInfo("###################  fullPath : " + fullPath);
    	var fullPath = netCancelPath + "/" + fileName;
    	var dirPath = netCancelPath;
    	var downloadsDir;
    	var file;
    	util.logInfo("###################  fullPath : " + fullPath);
    	util.logInfo("###################  fileName : " + fileName);
    	
    	var newFile;
    	try {
    		tizen.filesystem.resolve(fullPath, function(result) {
    			util.logInfo("###################  fnUpdatePayInfoFile tizen.filesystem.resolve  #################");
    			util.logDebug("###################  fnUpdatePayInfoFile result tizen.filesystem.resolve result : " + JSON.stringify(result));
    			//downloadsDir.listFiles(listener.onsuccess, listener.onerror);
    			listener.onsuccess(result);
    		},
            function(e){
    			util.logError("###################  fnUpdatePayInfoFile error tizen.filesystem.resolve e : " + JSON.stringify(e));
            	util.logError("###################  fnUpdatePayInfoFile error tizen.filesystem.resolve e.message : " + JSON.stringify(e.message));
            },
            "rw"
    		);
		} catch (e) {
			util.logError("###################  fnUpdatePayInfoFile tizen.filesystem.resolve catch ERROR e : " + JSON.stringify(e));
		}
		
		var listener = {
			onsuccess: function(file) {
				util.logInfo("###################  fnUpdatePayInfoFile onsuccess  #################");
				util.logDebug("### fnUpdatePayInfoFile files" + JSON.stringify(file));
				
				file.readAsText(
						function(str)
						{
							var json = str;
							json = JSON.parse(json);
							
							json['SendOK'] = "2";
							var newFileText = "";
							newFileText += "{\n   \"CAT_ID\" : \"" + json['CAT_ID'] + "\",\n   ";
							newFileText += "\"LOCAL_TIME\" : \"" + json['LOCAL_TIME'] + "\",\n   ";
							newFileText += "\"POS_SW_Model_Name\" : \"" + json['POS_SW_Model_Name'] + "\",\n   ";
							newFileText += "\"POS_SW_Version\" : \"" + json['POS_SW_Version'] + "\",\n   ";
							newFileText += "\"Point_Card_Type\" : \"" + json['Point_Card_Type'] + "\",\n   ";
							newFileText += "\"RetryCount\" : \"" + json['RetryCount'] + "\",\n   ";
							newFileText += "\"SendOK\" : \"" + json['SendOK'] + "\",\n   ";
							newFileText += "\"거래일련번호\" : \"" + json['거래일련번호'] + "\",\n   \"금액\" : \"" + json['금액'] + "\",\n   ";
							newFileText += "\"발생일시\" : \"" + json['발생일시'] + "\",\n   \"서비스비용\" : \"" + json['서비스비용'] + "\",\n   ";							
							newFileText += "\"승인번호\" : \"" + json['승인번호'] + "\",\n   \"승인일자\" : \"" + json['승인일자'] + "\",\n   ";
							newFileText += "\"할부\" : \"" + json['할부'] + "\",\n   \"PAY_TYPE\" : \"" + json['PAY_TYPE'] + "\",\n   ";
							newFileText += "\"현금영수증_사용자코드\" : \"" + json['현금영수증_사용자코드'] + "\",\n   \"현금영수증_거래구분\" : \"" + json['현금영수증_거래구분'] + "\"\n}\n\n";
							
							util.logInfo("***** 망취소 파일 텍스트 정보 : " + JSON.stringify(newFileText));
							
							tizen.filesystem.resolve(fullPath, function(result3) {
								util.logInfo("################### fnUpdatePayInfoFile newFile Start #################");
								util.logDebug("### fnUpdatePayInfoFile before text data >> " + JSON.stringify(result3));
								//newFile = result3.createFile(fileName);
								//util.log("### fnUpdatePayInfoFile newFile >> " + newFile);
								result3.openStream(
							        "rw",
							        function(fs) {
							        	 fs.write(newFileText);
							        	 fs.close();
							        }, function(e) {
							        	 util.log("Error " + e.message);
							        }, "UTF-8");
									util.logInfo("################### fnUpdatePayInfoFile newFile End #################");
								
							}, function(e) {
								util.logError("### fnUpdatePayInfoFile resolve Error" + e.message);
						    }, "rw" );
						},
						function(e)
						{
							util.logError("### fnUpdatePayInfoFile Error " + e.message);
						},
				"UTF-8");
				
            },
            onerror: function(error) {
            	util.logError("### fnUpdatePayInfoFile : The error " + error.message + " occurred when listing the files in the selected folder");
            }
		};
    },

    this.fnReceivingSettlementData = function(callbackFunction, callbackParam) {

        util.logInfo("### fnReceivingSettlementData callbackParam " + JSON.stringify(callbackParam));

        if (util.fnIsMainPos()) {
        	util.logInfo("### fnReceivingSettlementData util.fnIsMainPos() : TRUE ");
            callbackFunction(callbackParam);
            return;
        }

        var url = '/SvrApp/SI000.do';
        var params = {"TSP-NVP":{"TXJM-FD":{"_SRID":"SI380", "_RETCD":"0000", "DATA-HD":{"_SHOP_CD":gShopCd, "_POS_NO":mainPosNo} }}};

        util.logInfo("fnReceivingSettlementData params : " +  JSON.stringify(params));

        try{

            var jsonData = axiosObj.syncAjaxPost(url, params);

            var txjmFd = jsonData["TSP-NVP"]["TXJM-FD"];
            var resultData = {};

            if(txjmFd["_RETCD"] != "0000") {
                util.logError("fnReceivingSettlementData SI380 처리 실패");
            }
            var dataHd = txjmFd["DATA-HD"];
            var dataDt = dataHd["DATA-DT"];

            //util.log('fnReceivingSettlementData dataDt ' + JSON.stringify(dataDt));
            var dataCnt = dataHd["_DATA_CNT"];

            if ( dataCnt == 0 ) {
                util.logError('fnReceivingSettlementData SI380 데이터 없음.');
                return
            }else{
                dataDt = util.fnSetObjToArray(dataDt);
            }

            util.logInfo('fnReceivingSettlementData dataDt ' + dataDt.length);
            
            $.each(dataDt, function (key, value) {

                util.logInfo('fnReceivingSettlementData key : ' + key + ', value : ' + value + ', : ' + mainPosNo);

                if ( value._POS_NO == mainPosNo ) {
                    var lastSaleDate  = value._LAST_SALE_DATE;

                    params = {"TSP-NVP":{"TXJM-FD":{"_SRID":"SI390", "_RETCD":"0000", "_KIOSK_REQ_YN":"Y", "DATA-HD":{"_SHOP_CD":gShopCd, "_SALE_DATE":lastSaleDate, "_POS_NO":mainPosNo}}}};

                    //util.log("fnReceivingSettlementData params : " +  JSON.stringify(params));

                    //정산 자료 조회
                    data = axiosObj.syncAjaxPost(url, params);
                    aspData.receiveAspDataCallback(data);

                    util.logDebug("fnReceivingSettlementData end data : " +  JSON.stringify(data));
                    callbackFunction(callbackParam);
                    return false;
               }
            });

        }catch(er){
            util.logError("fnReceivingSettlementData error ================================================================");
            util.logError("fnReceivingSettlementData error er : " +  JSON.stringify(er));
            eventBus.$emit('alertPopup', {message: "MainPOS 의 마감정보를 확인 할 수 없습니다. \n인터넷 상태를 확인해 주세요"});
        }
        
        util.logInfo("### fnReceivingSettlementData END ");
    },

    //index.html에서 사용
    this.fnReceivingSettlementData2 = function() {

        util.logInfo("### fnReceivingSettlementData start ");

        var url = '/SvrApp/SI000.do';
        var params = {"TSP-NVP":{"TXJM-FD":{"_SRID":"SI380", "_RETCD":"0000", "DATA-HD":{"_SHOP_CD":gShopCd, "_POS_NO":mainPosNo} }}};

        util.logInfo("fnReceivingSettlementData params : " +  JSON.stringify(params));

        try{

            var jsonData = axiosObj.syncAjaxPost(url, params);

            var txjmFd = jsonData["TSP-NVP"]["TXJM-FD"];
            var resultData = {};

            if(txjmFd["_RETCD"] != "0000") {
                util.logError("fnReceivingSettlementData SI380 처리 실패");
            }
            var dataHd = txjmFd["DATA-HD"];
            var dataDt = dataHd["DATA-DT"];

            //util.log('fnReceivingSettlementData dataDt ' + JSON.stringify(dataDt));

            var dataCnt = dataHd["DATA_CNT"];

            if ( dataCnt == 0 ) {
                util.logError('fnReceivingSettlementData SI380 데이터 없음.');
                return
            }else{
                dataDt = util.fnSetObjToArray(dataDt);
            }

            util.logInfo('fnReceivingSettlementData dataDt ' + dataDt.length);

            $.each(dataDt, function (key, value) {

                util.logInfo('fnReceivingSettlementData key : ' + key + ', value : ' + value + ', : ' + mainPosNo);

                if ( value._POS_NO == mainPosNo ) {
                    var lastSaleDate  = value._LAST_SALE_DATE;

                    params = {"TSP-NVP":{"TXJM-FD":{"_SRID":"SI390", "_RETCD":"0000", "_KIOSK_REQ_YN":"Y", "DATA-HD":{"_SHOP_CD":gShopCd, "_SALE_DATE":lastSaleDate, "_POS_NO":mainPosNo}}}};

                    //util.log("fnReceivingSettlementData params : " +  JSON.stringify(params));

                    //정산 자료 조회
                    data = axiosObj.syncAjaxPost(url, params);
                    aspData.receiveAspDataCallback(data);

                    util.logDebug("fnReceivingSettlementData end data : " +  JSON.stringify(data));
                    return false;
               }
            });

        }catch(er){
            util.logError("fnReceivingSettlementData2 error ================================================================");
            util.logError("fnReceivingSettlementData2 error er : " +  JSON.stringify(er));

            setTimeout(function alertMessage(){
                eventBus.$emit('alertPopupIndex2', {message: "MainPOS 의 마감정보를 확인 할 수 없습니다. \n인터넷 상태를 확인해 주세요"});}
                , 500);

            return false;
        }
        return true;

    },

    this.fnSetAutoLogin = function(setTimeYn){
    	var autoLoginYn = "";

        if(gsSpecialShopFlag == "8"){ // 푸드테크라면 자동로그인으로 동작하게 한다.
        	autoLoginYn = "1";
        }else{
        	autoLoginYn = util.GetEnvXmlShopENV("731");
        }

        util.logInfo("#############  fnSetAutoLogin   START  autoLoginYn : " + autoLoginYn);

        if(autoLoginYn == "1"){

            try{
                if(!util.fnIsMainPos()){

                    if(!util.fnReceivingSettlementData2()){
                        return false;
                    }
                    util.logInfo("#############  fnSetAutoLogin   fnReceivingSettlementData2 END  " );

                    var closeInfo = adminService.fnGetPostClosingStatus();

                    util.logInfo("#############  fnSetAutoLogin   closeInfo : " + JSON.stringify(closeInfo));

                    if(util.isEmpty(closeInfo) ){

                        var openDate = moment().format('YYYYMMDDHHmmss');
                        if(!util.fnIsMainPos()){
                            var openSaleDateResult = gfn_SQLiteSQLProcess(adminSql.selectGetSaledate, [gShopCd, mainPosNo]).Data[0];

                            util.logInfo("fnOpenProcessProcess openSaleDateResult :" + JSON.stringify(openSaleDateResult));
                            openDate = openSaleDateResult.SALE_DATE + "000000";
                        }

                        var openData = {openDate : openDate, posReadyAmt : "0", openEmpNo : loginEmpInfo.EMP_NO, moveYn : "N" };
                        
                        //개점처리되는순간 커반 영수증번호 값과 영수증번호 채번 정상유무를 로컬스토리지에서 제거해준다
                        //localStorage.removeItem("gCbBillNoVal");
                    	//localStorage.removeItem("gCbBillNo");
                    	
                        adminService.fnOpen(openData);
                    }

                     util.log("  $$$$$$$$$$$$$$$$$$   fnSetAutoLogin   fnOpen END closeInfo :  " + JSON.stringify(closeInfo));

                    if(!util.isEmpty(closeInfo) && closeInfo.MAIN_POS_CLOSE == "3"){
                        setTimeout(function alertMessage(){
                            eventBus.$emit('alertPopupIndex2', {message: saleDate + " 영업은 마감처리된 상태입니다."});}
                            , 500);

                        util.logInfo("  $$$$$$$$$$$$$$$$$$   fnSetAutoLogin   setTimeout setTimeYn : " + setTimeYn);

                        if(setTimeYn == "Y"){
                            
                            clearTimeout(autoLoginTimeId);

                            autoLoginTimeId = setTimeout(function fnCallFunc(){
                                util.fnSetAutoLogin("Y")}, 30000);

                        }
                        return false;
                    } 
                } else {
                	var openDate = moment().format("YYYYMMDD");
                	util.logInfo("fnIndexAutoLogin saleDate :" + saleDate + " , openDate : " + openDate);
                	if(saleDate == openDate){
                		var closeInfo = adminService.fnGetPostClosingStatus();
                		util.logInfo("### fnIndexAutoLogin closeInfo :" + JSON.stringify(closeInfo));
                		
                		if(closeInfo.CLOSE_FG == "2" || closeInfo.CLOSE_FG == "3" ) {
                			var checkResult = gfn_SQLiteSQLProcess(adminSql.selectOpenProcessCheck, [gShopCd, openDate , gPosNo]).Data;
                			util.logInfo("### checkResult 1 :" + JSON.stringify(checkResult));
                			
                			if(checkResult && checkResult.length > 0 && (checkResult[0].CLOSE_FG == "2" || checkResult[0].CLOSE_FG == "3")){
                				util.logInfo("### checkResult 2 :" + JSON.stringify(checkResult));
                				//eventBus.$emit('alertPopupIndex2', {message: saleDate + "이미 마감되어진 영업일자입니다."});
                				eventBus.$emit('alertPopupIndex2', {message: saleDate + " 영업은 마감처리된 상태입니다."});
                				return false;
                			}
                		}
                	}
                }
                
                adminService.fnIndexAutoLogin({"autoLoginYn" : autoLoginYn});
                return true;
            }catch(e){

                util.logError("<<=== fnSetAutoLogin error!!!===>"+ JSON.stringify(e));
                //자동정산중 네트워크 에러인 경우
                if(e == "네트워크 상태를 확인해주세요."){
                	return true;
                } else {
                	return false;
                }
            }
        }else {
            return true;
        }
    },

    this.fnSetObjToArray = function(obj){
        if(Array.isArray(obj)){
            return obj;
        }else{
            return [obj];
        }
    },

    /**
     * 음성안내 공통함수
     * paramSrc : 음성파일 src - String(단건) or Array(여러건 연속 재생)                  
     * DESC : 파라미터에 담겨있는 음성파일 src를 순차적으로 연속재생한다.
     */
    this.fnAudioPlay = function(paramSrc) {
    	if(!paramSrc){
    		util.logInfo("fnAudioPlay <<=== parameter null ===>");
    		return false;
    	}
    	try{
    		// 음성안내 사용여부 환경변수
    		var vsUseYn = util.GetEnvXmlPosENV(706); // (0:미사용, 1:사용)
    		util.logInfo("<<=== fnAudioPlay GetEnvXmlPosENV(706) 0은 음성 미사용 1은 사용 ===>>  " + vsUseYn);
    		if(vsUseYn == "1"){ // 사용이라면 음성 출력수행    	    		
        		util.logInfo("<<=== fnAudioPlay GetEnvXmlPosENV YYY ===>>");
            	if( typeof paramSrc == "string"){ // 파라미터가 배열이 아니고 string인 경우 한번 음성실행
            		util.logInfo("<<=== fnAudioPlay String 타입 파라미터 paramSrc ===>> " + paramSrc);
            		var audio = new Audio(); 		
                	if(langCode=="en"){ // 영어
                		var vsSrcEn = paramSrc.substr(0, paramSrc.lastIndexOf(".mp3"));
                		vsSrcEn = vsSrcEn + "_en.mp3";
                		audio.src = vsSrcEn;
                	}else{ // 그외 (현재는 한국어)
                		audio.src = paramSrc;
                	}
                	audio.play(); //음성 실행
                	util.logInfo("one audio play Complete!!");
            	}else{
            		util.logInfo("<<=== fnAudioPlay Array 타입 개수  ===>> " + paramSrc.length);
            		
            		var audio = new Audio();
                	if(langCode=="en"){
                		util.logInfo("<<=== fnAudioPlay Array EN ===>>");	
                		var vsSrcEn = paramSrc[0].substr(0, paramSrc[0].lastIndexOf(".mp3"));
                		vsSrcEn = vsSrcEn + "_en.mp3";
                		audio.src = vsSrcEn;
                	}else{
                		util.logInfo("<<=== fnAudioPlay Array ko ===>>");
                		audio.src = paramSrc[0];
                	}
                	util.logInfo("<<=== fnAudioPlay Array 타입 paramSrc[0] ===>>" + paramSrc[0]);
                	audio.play();            	
                	
                	// 오디오 실행이 끝났을 때 이벤트 정의
        	        audio.addEventListener("ended", function(){fnAudioPlayCallback(this,paramSrc)});
            		
        	        // play이후에 실행되는 함수 - 배열에 담겨있는 src를 순차적으로 play한다.
        	        function fnAudioPlayCallback(e, paramSrc){
        	        	for(var i=0; i<paramSrc.length; i++){
        	    			util.logDebug("<<=== audio.addEventListener for ===>>");
        	    			util.logDebug("<<=== audio.addEventListener paramSrc.length ===>>  " + paramSrc.length);
        	    			var vsCurName = e.src.substr(e.src.lastIndexOf("/")+1, e.src.lastIndexOf(".mp3")); // 현재 재생했던 오디오 파일명
        	    			var vsArrName = paramSrc[i].substr(paramSrc[i].lastIndexOf("/")+1, paramSrc[i].lastIndexOf(".mp3")); // 현재 인덱스의 오디오 파일명
        	     		    if(vsCurName == vsArrName || vsCurName == vsArrName +"_en"){ // 배열중에 현재의 음성실행 파일과 같은것을 찾는다.
        	     		    	util.logInfo("<<=== audio.addEventListener same if===>>");    	     		    	
        	     		    	util.logDebug("<<=== audio.addEventListener same Index ===>>  " + i);
        	     		    	util.logDebug("<<=== audio.addEventListener same src ===>>  " + vsArrName);    	     		    	
        	     		    	if(i < paramSrc.length-1){ // 배열의총인덱스-1 보다 작으면 if문 수행
        	     		    	util.logInfo("<<=== audio.addEventListener next play if ===>>");
        	           		    	if(langCode=="en"){
        	    	       		    	var vsSrcEn = paramSrc[i+1].substr(0, paramSrc[i+1].lastIndexOf(".mp3"));
        	    	       		    	vsSrcEn = vsSrcEn + "_en.mp3";
        	    	       		    	e.src = vsSrcEn;
        	    	       		    }else{
        	    	       		    	e.src = paramSrc[i+1];
        	    	       		    }
        	           		    	util.logInfo("<<=== fnAudioPlay Array 타입 > audio.addEventListener 0번째 이후 다음 src ===>>  " + e.src);
        	    	       		    e.play();
        	    	       		    break;
        	     		    	}
        	     		    }
        	    		}   
        	        } // fnAudioPlayCallback end
            	} // else end
        	} else{ // 환경변수에서 음성안내가 미사용일 때 skip
        		util.logInfo("<<=== audio not use!!! ===>>")
        	}// else end
    	}catch(e){
    		util.logError("<<=== fnAudioPlay error!!!===>");
    	}
    } // fnReceivingSettlementData end
    this.setAspUrl = function() {
    	try {
    		let s = "";
    		let row = this.getDbSingleRow( gfn_SQLiteSQLProcess( "SELECT * FROM SCD_SETUP_T  " , []) );
    		gMainIp = row.MAIN_IP;
			if ( mainPosNo != gPosNo  && util.GetEnvXmlShopENV(528) == 0 && row.MAIN_IP != "localhost"  ) {
				apiUrl = aspUrl = 'http://' + row.MAIN_IP + ':2006' ;
			}

		} catch (e) {
			util.logError("setAspUrl catch error e : " +  e);
			util.logError("setAspUrl catch error jsonString e : " +  JSON.stringify(e));
		}

    }
    /********************************************
     * tizen 폴더 생성.
     ********************************************/
	this.makeDirectory = function(fullPath, makeDir) {
		util.logInfo("*****util.js makeDirectory Start *****");
		if( this.isTizen() == false )
			return;

		tizen.filesystem.resolve( fullPath + '/' + makeDir  ,
				function(dir) { 
					if ( dir.isDirectory == true ) {
						util.logInfo('util.js makeDirectory [%s/%s] folder already exists !! fullPath == > ' + fullPath);
						util.logInfo('util.js makeDirectory [%s/%s] folder already exists !! makeDir == > ' + makeDir);
					} else {
						//dir.createDirectory(makeDir);
						tizen.filesystem.resolve( fullPath  ,
								function(dir2) { 
										dir2.createDirectory(makeDir);
								}, function(e) {
									util.logError("util.js makeDirectory resolve Error : " + e.message+  ' ' + JSON.stringify(e));
								}, "rw"
						);
					}
				}, function(e) {
					tizen.filesystem.resolve( fullPath  ,
							function(dir2) { 
									dir2.createDirectory(makeDir);
							}, function(e) {
								console.log("Error2 : " + e.message+  ' ' + JSON.stringify(e));
							}, "rw"
					);
					console.log("Error1 : " + e.message+  ' ' + JSON.stringify(e));
				}, "rw"
		);
	}, 
	this.multiBizNetUpdate = function(type) {
    	util.logInfo("### multiBizNetUpdate start");
		orderInfo.CORNER_LIST.forEach(e => {
			let fileName = e.TRADE_SERIAL_NUM +"_"+ e.APPR_FULL_TIME + ".tr";
			util.logInfo("### multiBizNetUpdate fileName >>> " + fileName + ", type >>> " + type);
			if(type == 'U'){
				//망취소파일 업데이트
				util.fnUpdatePayInfoFile(fileName);
			} else {
				//망취소파일 삭제
				util.fnDelPayInfoFile(fileName);
			}
		});
	}
	
	/*************************************************
	 * FDK_CreditRemove
	 * parameter : no
	 * ASync 방식으로 처리되는 API로 상태 정보를 받는 CallbackListener를 반드시 구현 해 주어야 한다.
     * 상태 CallbackListener는 리더기 상태가 변경 될때마다 호출 된다.
     * 카드 삽입 여부의 상태에 따른 처리를 해 주어야 한다.
     * 리더기에 카드가 삽입되어 있을 경우 카드를 제거 할때까지 대기 하는 처리 필요.
     * 리스터 ID = nativeApp.functionCallASync(["FDK_CreditRemove"], 리스터 함수);
	 *************************************************/
//	var isAdd_RemoveStatusListener = false;
	var removeListenerId;
    var timeoutCardRemove ="";
    var cardRemoveYn = "";
//    var vsCardAudioCnt = 0;
	this.cardRemove = function (){
		removeListenerId = null;
	    try
	    {
	    	util.logInfo( "<<<===== cardRemove cardRemove Start =====>>>>> ");
	        // API 처리 후 callback 리스너를 제거 한다.
	        var removeResultCallback = function(callbackName, result) {
	        	util.logInfo("***** 카드제거 콜백 시작 cardRemove removeResultCallback cardRemoveYn ==> " + cardRemoveYn);
	        	 var vsResult = result.substring(0, result.lastIndexOf("$$^")); // native 데이터 중 마지막 $$^를 제거
	    	     vsResult = JSON.parse(vsResult);
	    	     util.logInfo("***** 카드제거 콜백 cardRemove removeResultCallback vsResult.Data ==> " + vsResult.Data);
	    	  // cardRemoveYn(Y) : 카드가 있어서 '카드를 제거해주세요' 화면이 구동된 상태, N인 경우에는 x표시로 닫기를 직접 눌렀기 때문에 이 함수를 또 호출하면 안된다.
	    	     if(vsResult.Data == "200" && (cardRemoveYn == "" || cardRemoveYn == "Y")){ 
 	             	$(".cardRemove").hide();
 	             	clearTimeout(timeoutCardRemove); // timeoutCardRemove 타임아웃 제거
 	             	setTimeout(function(){
 	             		nativeApp.functionCallSync(["FDK_CreditCancel"]); // 결제 및 카드리더기 동작 파괴
 	             		cardRemoveYn = "N";
// 	             		vsCardAudioCnt = 0;
 	             		util.logInfo("***** 카드제거 콜백 제거 후 저장기능 시작 cardRemove removeResultCallback cardRemoveYn ==> " + cardRemoveYn);
 	             		paymentChoiceView.fnCardReaderStatusCallBack();//카드승인정보 저장.
 	             	}, 1000);
	    	     }
	    	     
	        	util.logDebug( "<<<===== removeResultCallback removeResultCallback callbackName =====>>>>> "+callbackName);
	            nativeApp.removeASyncApiListener(callbackName, removeListenerId);	            
	        };

	        // 페이지가 로딩될때 최초 한번만 등록 한다.
//	        if(!isAdd_RemoveStatusListener) {
//	        	util.logInfo( "<<<===== !isAdd_RemoveStatusListener =====>>>>> ");
	            nativeApp.addPaymentListener(util.removeStatusCallbackListenerOrder);	            
//	            isAdd_RemoveStatusListener = true;
//	        }

	       cardRemoveYn = ""; // FDK_CreditRemove 호출하기 바로 전에 ""로 셋팅.
//	       vsCardAudioCnt = 0;
	       removeListenerId = nativeApp.functionCallASync(["FDK_CreditRemove"], removeResultCallback);
	       util.logDebug('removeListenerId :' + removeListenerId);
	       
	    } catch (e) {
	    	try {
	    		util.logError("[ERROR] FDK_CreditRefund ERROR 1: " + e.message);

			} catch (e1) {
				util.logError("[ERROR] FDK_CreditRefund ERROR 2: " + e.toString());
			}
	    }
	}
	
    // 상태 정보 받는 콜백
    this.removeStatusCallbackListenerOrder = function(data) {
        //alert("Status callback : " + data);
    	util.logInfo("<<<===== Card Removed removeStatusCallbackListenerOrder START=====>>>");
    	try {
            let cbCode = "9";
            let cbData = "";
            try {
                let jsonData = JSON.parse(data);
                util.logDebug('### jsonData ' + JSON.stringify(jsonData));
                cbCode = jsonData["Code"];
                cbData = jsonData["Data"];
                
            } catch (e) { 

            }
            util.logInfo("<<<===== removeStatusCallbackListenerOrder ResultCode =====>>>  " + cbCode);
            util.logInfo("<<<===== Card No Remove =====>>> " + cbCode + " : " + cbData);	// -- 리더기에 카드가 삽입되어 있는 상태로... 카드가 제거될때까지 대기 하는 처리를 해 주어야 함.
            if(cbCode == "111") {		// 리더기 카드를 제거해주세요.
            	cardRemoveYn = "Y";
            	util.cardRemoveAudio();
        		
        		var vsCardDelMsg1 = util.languageObjReturn(langCode , "cardDel1");
         		var vsCardDelMsg2 = util.languageObjReturn(langCode , "cardDel2");
//         		var vsCardDelMsg2_2 = util.languageObjReturn(langCode , "cardDel2_2");
//         		var vsCardDelMsg3 = util.languageObjReturn(langCode , "cardDel3");
//         		var vsCardDelMsg4 = util.languageObjReturn(langCode , "cardDel4");
//         		var vsCardDelMsg5 = util.languageObjReturn(langCode , "cardDel5");                         		
         		
         		$("#cardRemoveP1").text(vsCardDelMsg1);
         		$("#cardRemoveP2").text(vsCardDelMsg2);
         		//$("#cardRemoveP2_2").text(vsCardDelMsg2_2);
         		//$("#cardRemoveP3").text(vsCardDelMsg3);
         		//$("#cardRemoveP4").text(vsCardDelMsg4);
         		//$("#cardRemoveP5").text(vsCardDelMsg5);
         		
         		$(".cardRemove").show();
         		
            } 
//            else if(cbCode == "900"){ // 카드를 제거해주세요에서 3분동안 카드를 제거하지 않으면, 후처리를 하지 않고 메인화면으로 보낸다. (넷캔슬이 3분뒤에 취소를 해버리기 때문에)
//            	eventBus.$emit('alertPopupIndex2', {message: util.languageObjReturn(langCode, 'paymentExceed')});
//            	$(".cardRemove").hide();
//            	router.push({ path: '/start' });
//            }
        } catch (e) {
        	try {
        		util.logError("[ERROR] removeStatusCallbackListenerOrder ERROR 1: " + e.message);
			} catch (e1) {
				util.logError("[ERROR] removeStatusCallbackListenerOrder ERROR 2: " + e.toString());
			}
        }
    },
    
    this.cardRemoveAudio = function(data) {
//    	vsCardAudioCnt++;
//    	util.logInfo("________카드제거화면 vsCardAudioCnt == >> "+ vsCardAudioCnt);
    	util.logInfo("<<<===== cardRemoveAudio =====>>> ");
    	let arrSrc = "./audio/5.mp3";
		util.fnAudioPlay(arrSrc); // 음성안내 공통함수 호출
//		if(vsCardAudioCnt > 5){
//			vsCardAudioCnt = 0;
//			util.removeStatusCallbackSelfClick();
//		}else{
			timeoutCardRemove= setTimeout(function(){
				waitingService.ResetLogOutTimer();
				util.cardRemoveAudio();
			}, 3000);
//		}
			
			gCardRemoveCallCnt++;
			util.logInfo("<<<===== gCardRemoveCallCnt ===== >>> " + gCardRemoveCallCnt);
			if(gCardRemoveCallCnt > 10) {
				
				util.logInfo("<<<===== gCardRemoveCallCnt > 10 ===== >>> " + gCardRemoveCallCnt);
				clearTimeout(timeoutCardRemove); // timeoutCardRemove 타임아웃 제거
				$(".cardRemove").hide();
				
				if(gPaymentStatus == "APPROVE") {
					util.logInfo("<<<===== 정상처리인데 카드제거 안된상태 DB 저장 처리 ===== >>> " + gPaymentStatus);
					//var data = '{"Code":"100","Data":"카드있음"}';
					//util.removeStatusCallbackListenerOrder(data);
					//강제 카드제거 호출
					util.removeStatusCallbackSelfClick();
				}  else {
					router.push({ path: '/start' });
					// 결제 승인 실패시 제휴할인이 존해한다면 파일 sendOk 2로 바꾼 후, NetCancel 재실행이 되도록 함수를 수행한다.
					util.fnNetCancelCommand(1, 0);
					util.logInfo("<<<===== gCardRemoveCallCnt > 10 Go To Main ++++>>> ");
				}
			}
    },
    
    // 카드 제거하세요 화면에서 x버튼 눌렀을 때.
    this.removeStatusCallbackSelfClick = function(){
    	util.logInfo("<<<===== Card Removed remove Self Click(직접 X버튼 눌렀을 때 함수) cardRemoveYn =====>>> " + cardRemoveYn);
    	cardRemoveYn = "Y";
    	
    	if(cardRemoveYn == "" || cardRemoveYn == "Y"){
    		$(".cardRemove").hide();
    		clearTimeout(timeoutCardRemove); // timeoutCardRemove 타임아웃 제거     	            	
    		setTimeout(function(){
    			cardRemoveYn = "N";
    			paymentChoiceView.fnCardReaderStatusCallBack();//카드승인정보 저장.
    			// 직접 화면에서 카드제거 (여기)를 누른경우에 Y가 넘어오고, 이 경우에 콜백을 제거하도록 native에 콜백 제거를 호출한다. ( 나중에 카드를 제거하면 이 함수가 또 호출되기 때문)
    			util.logInfo("<<<===== Card Removed remove Self Click nativeApp.removeASyncApiListener BEFORE =====>>>");
    			nativeApp.functionCallSync(["FDK_CreditCancel"]);
    			nativeApp.removeASyncApiListener("removeResultCallback", removeListenerId);    			
    		}, 100);
    	}
    	
    },

    this.fnGetTotalMemory = function(){
        var memoryCnt = "0";
        if ( util.isTizen() == true ){
            memoryCnt = tizen.systeminfo.getTotalMemory()
        }
        return memoryCnt;
    },

    this.fnGetUseMemory = function(textValue){
        var memoryCnt = "0";
        var text = "";
        if(!util.isEmpty(textValue)){
            text = textValue;
        }

        try{

            if ( util.isTizen() == true ){
                var memoryTotalCnt = tizen.systeminfo.getTotalMemory();
                var memory = tizen.systeminfo.getAvailableMemory();

                memoryCnt = Number(memoryTotalCnt) - Number(memory);

                //util.logInfo("<<<===== fnGetUseMemory " + text + " memoryCnt : " + util.numberWithCommas(memoryCnt) + ", memoryTotalCnt >> " + util.numberWithCommas(memoryTotalCnt) + " memory >> " + util.numberWithCommas(memory));

            }
            memoryCnt = util.numberWithCommas(memoryCnt);

        }catch(e){
            util.logError("eee >> " + e);
        }
        return memoryCnt;
    },

    this.fnTmsUpdateDownLoad = function(obj){

        util.logInfo("fnTmsUpdateDownLoad Start ========= ");

        aspData.tmsUpdateDownLoad(true, new X2JS(), true);
    },

    this.stampCalcForUser = function(){
    	util.logInfo("______________ (스탬프적립) 스탬프적립금 계산 START _______________");
    	//스탬프 사용시 상품별 마일리지계산
		var totSaleAmt = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;
		
		util.logInfo("### totSaleAmt : " + totSaleAmt);
		
		var resultData = gfn_SQLiteSQLProcess("SELECT STAMP_ACC_FG, STAMP_ACC_COST, STAMP_ACC_QTY, DC_ACC_YN, USE_ACC_YN FROM HCS_CSTCL_T WHERE CST_CLS_CD = ?" , [orderInfo.POS_ODHDR_T.CST_CLS_CD]);
		let rows;
		if ( resultData!= null && resultData.ResultCode == "0" ) {
			rows = resultData.Data;
			if ( rows == undefined || rows == null ||  rows.length == 0 ) {
				util.logError( "회원등급 테이블에 정보가 없습니다." );
				return [];
			}
 	   	}
 	   	
		let cstSaleTotalPoint = 0;
 	   	//상품 상세별 스탬프 적립 및 사용
 	   	//코너별 스탬프 사용
		//0.미사용, 1.사용, 2.사용+적립팝업
 	   	if(SHOP_INFO.PNT_ACMT_STATUS_VAL == "2") {
 	   		//사용스탬프 적립 O
			for(var i=0; i<orderInfo.POS_ODDTL_T.length; i++){
				let cstSalePoint = 0;
				if(orderInfo.POS_ODDTL_T[i].STAMP_ACC_YN == "Y"){
					cstSalePoint += parseInt(orderInfo.POS_ODDTL_T[i].STAMP_ACC_QTY) * parseInt(orderInfo.POS_ODDTL_T[i].ORDER_QTY);
					cstSaleTotalPoint += cstSalePoint;
				}
				orderInfo.POS_ODDTL_T[i].CST_SALE_POINT = cstSalePoint;
			}
 	   	} 
 	   	
 	   	util.logInfo("### cstSaleTotalPoint : " + cstSaleTotalPoint);
 	   	orderInfo.POS_ODHDR_T.CST_SALE_POINT = cstSaleTotalPoint;
 	   	util.logInfo("______________ (스탬프적립) 스탬프적립금 계산 END _______________");
    },
    
    this.beep = function() {
    	//var snd = new Audio("./audio/beep_2.mp3");
    	var snd = new Audio("data:audio/wav;base64,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");
    	snd.volume = 0.2;
    	snd.play();
    },
    
    // 터치시에 효과음.
    this.fnTouchAudio = function() {
    	try{
        	util.logInfo("***** fnTouchAudio START *****");
			if(util.isTizen() == true ){
				tizen.tvaudiocontrol.playSound("MOVE");
			}    		
    		//var snd = new Audio("./audio/beep_2.mp3");

        	//var touchAdo = new Audio("./audio/touch.mp3"); // 뾱 소리.
//        	touchAdo.volume = 1;
        	//touchAdo.play();        	
    	}catch(e){
    		util.logError("***** fnTouchAudio CATCH e == > " + e.toString());
    	}
    	
    },
    /**
     * 연동형이고 환경설정에서 asp에서 채번하도록 설정된 경우에 asp에서 채번을 실행한다.
     * 대기화면 및 동영상 화면으로 갔을 때 orderNo를 채번하여 전역변수로 담고, 해당 값으로 결제 후 저장한다.
     * gsOrderNoAspYn : asp에서 orderNo를 채번할지 여부(환경변수 722 값)
     */
    this.getOrderNoAsp = function(orderNoAspCallback){
    	try {
    		// 연동형 체크 : 메인포스와 현재포스번호 다르고, 연동형으로 환경셋팅되어있고, mainIp가 localhost가 아닐 때
    		// asp채번으로 설정되어 있고, 연동형이라면 asp에서 채번한다. 
    		if (gsOrderNoAspYn == "0" && mainPosNo != gPosNo  && util.GetEnvXmlShopENV(528) == 0 && gMainIp != "localhost" ) {
//    		if(gsOrderNoAspYn == "0" && gbMainPosYn == false){ // asp채번으로 설정되어 있고, 연동형이라면 asp에서 채번한다.
        		util.logInfo("*****getOrderNoAsp START*****");
    			util.logInfo("*****util.getOrderNoAsp ASP START  gsOrderNo == > " + gsOrderNo);
        		if(!!gsOrderNo){// 채번해서 담고있는 변수가 0이 아니고 빈값이 아닐 때 채번하지 않는다. 이미 채번이 되어있는 상태이기 때문에
        			util.logInfo("*****util.getOrderNoAsp gsOrderNo already exist *****");
        			orderNoAspCallback(true);
        			return true;
        		}
        		
        		let url = '/SvrApp/PS000.do' , params = {} ,  xmlParam
        		var posOrderNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectPosOrderNoMax, [gShopCd, saleDate, gPosNo]).Data ;
    			
        		var vsLastOrderNo = posOrderNoResult[0].LAST_ORDER_NO;
        		//var vsLastOrderNo = "0000";
        		util.logInfo("##### posOrderNoMax >>> " + vsLastOrderNo);
        		if(vsLastOrderNo.substr(1) == '000') {
    				//POS_ODHDR_T에 ORDER_NO가 없으면 SSL_TRHDR_T 에서 max ORDER_NO 가져온다.
    				//둘다 없을경우 포스번호 + 001로 세팅
    				posOrderNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectSslOrderNoMax, [gShopCd, saleDate, gPosNo]).Data;
    				vsLastOrderNo = posOrderNoResult[0].LAST_ORDER_NO;
    				util.logInfo("##### sslOrderNoMax >>> " + vsLastOrderNo);
    			}
        		
//        		var dataBody = "";
//    			dataBody += "\n<TSP-NVP>";
//    			dataBody += "\n	<TXJM-FD SRID='PS160' RETCD='0000' KIOSK_REQ_YN='Y' >";//고정
//    			dataBody += "\n		<DATA-HD POS_NO='" + gPosNo + "' SHOP_CD='" + gShopCd + "' SALE_DATE='" + saleDate + "' LAST_ORDER_NO='" + vsLastOrderNo + "' >"; 
//    			dataBody += "\n		</DATA-HD>";
//    			dataBody += "\n	</TXJM-FD>";
//    			dataBody += "\n</TSP-NVP>";

        		params ={"TSP-NVP" 
        				:{
        					"TXJM-FD" :{"_SRID":"PS160", "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" 
        						,	"DATA-HD":{   "_POS_NO" 	:gPosNo 
        							, "_SHOP_CD"	: gShopCd
        							, "_SALE_DATE"	: saleDate
        							, "_LAST_ORDER_NO"	: vsLastOrderNo
        						}
        					}
        				}
        		};
        		var x2js = new X2JS();
        		xmlParam = x2js.json2xml_str(params);
        		util.logInfo("*****getOrderNoAsp tlgmCall before *****" );
        		telegram.tlgmCall( XML_PI + xmlParam , url, true, function(r){
        			
        			if(r == "error"){
        				orderNoAspCallback(false);
						return;
					}
        			
        			util.logInfo("*****getOrderNoAsp tlgmCall callback *****" );
        			r = x2js.xml_str2json(r);
            		let fd = r["TSP-NVP"]["TXJM-FD"] ;//["DATA-HD"];
            		util.logDebug('PS160 - tlgmfd' + JSON.stringify( fd));    		
            		
            		if ( r == null || fd["_RETCD"] != '0000' ) {
            			util.logInfo("*****getOrderNoAsp FAIL _RETCD NOT 0000 *****" );
            			orderNoAspCallback(false);
            		} else {
            			util.logInfo("*****getOrderNoAsp Success _RETCD 0000 *****" );
            			gsOrderNo = fd["DATA-HD"]["_MAX_ORDER_NO"]; // orderNo 채번값을 전역변수에 담는다.
            			util.logInfo("*****getOrderNoAsp END gsOrderNo ==> " + gsOrderNo);    
//            			util.logInfo("*****getOrderNoAsp END ASP GET gsOrderNo ==> " + gsOrderNo);    
//            			gsOrderNo = gPosNo.substr(1) + gsOrderNo.substr(1);
//            			util.logInfo("*****getOrderNoAsp END NEW KIOSK gsOrderNo ==> " + gsOrderNo);    						
            			orderNoAspCallback(true);
            		}
        		}, 3000 );
        		
        	}else{
        		util.logInfo("*****util.getOrderNoAsp No ASP return true*****");
        		orderNoAspCallback(true);
        	}
    	} catch(e) {
    		// 주문하기 위한 버튼들을 enable처리한다.
        	$(".takeout").attr("disabled", false);
        	$(".meal").attr("disabled", false);
    		util.logError("*****getOrderNoAsp catch e => " + e.toString());
    		orderNoAspCallback(false);
    	}
    	
    },

    this.fnClientServiceApi = function(params){

        util.logInfo("######## fnClientServiceApi params : " +JSON.stringify(params));
        //POS Jason미지원으로 ASP 다이렉트 변경처리
        //var url = apiUrl + "/clientservice/waiting/chgOrderWaitingStatus.do";
        var url = waitSendApiUrl + "/clientservice/waiting/chgOrderWaitingStatus.do";

        var traceNo = moment().format('YYYYMMDDHHmmss') +  Math.floor(Math.random() * 1000);
        var param = {"header" :  {"version" : "1.0.0", "traceNo" : util.strEndPad(17, traceNo)}};
        var reqOrderWaitingStatus = "";
        var smsSendYn; //알림톡발송여부 Y : 발송(Default), N : 미발송 / 빈 값으로 전송되는 경우 'Y' Default값으로 처리됨

        if(notifyTalkInterlock == "1") {
            reqOrderWaitingStatus = "S";
            smsSendYn = "Y";
        } else if(notifyTalkInterlock == "2") {
            reqOrderWaitingStatus = "O";
            smsSendYn = "Y";
        } else if(notifyTalkInterlock == "3") {
        	reqOrderWaitingStatus = "O";
            smsSendYn = "N";
        } else {
            return false;
        }
        
        util.logInfo('fnClientServiceApi notifyTalkInterlock -->> '+  notifyTalkInterlock);
        param.body = {"shopCd" : gShopCd, "reqType" : "I", "orderWaitingNo": params.orderWaitingNo, "reqOrderWaitingStatus" : reqOrderWaitingStatus, "cstTelNo" : basicOrderInfo.notifyTalkPhoneNo, "prodNm" : params.prodNm, "smsSendYn" : smsSendYn};

        util.logInfo('fnClientServiceApi url -->> '+  JSON.stringify(url));
        util.logInfo('fnClientServiceApi param -->> '+  JSON.stringify(param));

        $.ajax({
            type : "POST",
            url: url,
            data: JSON.stringify(param),
            contentType:"application/json; charset=UTF-8",
            timeout : 10000,
            success: function(res) {
                util.logInfo("***** fnClientServiceApi chgOrderWaitingStatus  success *****");
                util.logInfo('SUCCESS callback -->> '+  JSON.stringify(res));
            },
            error: function(xhr, status, error) {
                util.logError("fnClientServiceApi xhr1 == > " + JSON.stringify(xhr));
                util.logError("fnClientServiceApi status.toString == > " + status.toString());
                util.logError("fnClientServiceApi status == > " + status);
                util.logError("fnClientServiceApi error == > " + error.toString());

            }
        });
    },

    this.fnIndexMoveMenu = function(paramObj){
        var selectTableYn = util.GetEnvXmlPosENV(712);

        util.logDebug("*****  fnIndexMoveMenu paramObj === " + JSON.stringify(paramObj));
        util.logDebug("*****  fnIndexMoveMenu notifyTalkInterlock === " + notifyTalkInterlock + ", gOrderType : " + gOrderType + ", selectTableYn : " + selectTableYn);

        //selectTableYn = "1";
        
        if(paramObj.mealTake != undefined) {
        	gMealTake = paramObj.mealTake;
        }
        if(gOrderType == "meal"
            && (gvEatTakeOutVal == "0" || gvEatTakeOutVal == "1" || gvEatTakeOutVal == "2" )
            && selectTableYn == "1"
            && paramObj.beforePage == "index" ){                                                                                                         

            util.logDebug("*****  fnIndexMoveMenu selectTablePage  go === ");
            //var paramObj = {"name" : 'menu', "mealTake" : this.mealTake, "beforePage" : "index"};
            router.push({name: "selectTablePage", params: { id: gOrderType },});

        }else if((notifyTalkInterlock == "1" || notifyTalkInterlock == "2") && (paramObj.beforePage == "index" || paramObj.beforePage == "selectPage")){
            util.logDebug("*****  fnIndexMoveMenu notifyTalk  go === ");
            router.push({name: "notifyTalk", params: { id: gMealTake },});
        }else{
            util.logDebug("*****  fnIndexMoveMenu paramObj.name  go === " + paramObj.name);
            if(gMealTake == "voucher"){ // 상품권 -> 바코드 화면으로 이동
            	//router.push({name: "couponBarcode", params: { id: gMealTake, "beforePage" : "index" },});
            	router.push({name: "menu", params: { id: gMealTake, "beforePage" : "index" },});
            } else {
            	router.push({name: "menu", params: { id: gMealTake, "beforePage" : "index" },});
            }
            //router.push({name: paramObj.name, params: { id: gOrderType },});
        }
    },

    this.strEndPad = function(width, str){
        return str.length >= width ? str : str + new Array(width-str.length+1).join('0');
    },
    /**
     * 제로페이, 카카오페이 결제 시에는 디폴트 서버정보로 결제하고, 나머지는 해당 매장에 설정된 환경변수값에 따른 서버로 결제해야 하기 때문에 결제시에 서버정보를 바꿀 수 있도록 change공통함수 구현
     * paServerEnvVal : 0 = 디폴트 서버정보 셋팅 ( 카카오, 제로페이 )
     *                  1 = 현재 매장 환경변수의 서버 정보 셋팅
     */ 
    this.fnServerIpPortChange = function(paServerEnvVal, paServerIpPortCallback){    
    	try{
    		// 현재 해당 기능은 사용하지 않아. 바로 정상 리턴을 보낸다. ( 추후 사용시에 해당 주석부분 삭제하면 됨)    		
    		var result = { Code : "0" };
    		paServerIpPortCallback(result); // 콜백함수 호출.
    		return;
    		// 현재 해당 기능은 사용하지 않아. 바로 정상 리턴을 보낸다.
    		
    		var vsIp = "";
    		var vsPort = "";
    		util.logInfo("*****util.js fnServerIpPortChange SERVER IP/PORT SET START*****");
    		// 환경변수에 따라 결제를 위한 SERVER정보 설정
//    		var vsServerEnvVal = util.GetEnvXmlShopENV( 725 ); // 환경변수에서 결제 SERVER 인덱스를 받아온다.
    		util.logInfo("*****server ENV VAL ==>>  " + paServerEnvVal);
    		if(paServerEnvVal == "0"){ // 디폴트 셋팅일 때
    			vsIp = SERVER_IP_DEFAULT;
    			vsPort = SERVER_PORT_DEFAULT;
    		}else{
    			vsIp = SERVER_IP;
    			vsPort = SERVER_PORT;
    		}
    		util.logInfo("*****util.js IP =>>> " + vsIp + ", PORT =>>> " + vsPort);

    		// 콜백함수 정의
    		function changeNetWorkCallback(callbackName, result){
    			util.logInfo("*****util.js SERVER IP/PORT SET CALLBACK START*****");    			
    			if(paServerEnvVal == "0"){ // 디폴트 셋팅일 때 디폴트 ip/port 정보를 현재 ip/port변수에 셋팅
    				sessionStorage.setItem("SERVER_IP_NOW", SERVER_IP_DEFAULT); // 현재 설정된 IP
    			    sessionStorage.setItem("SERVER_PORT_NOW", SERVER_PORT_DEFAULT ); // 현재 설정된 값 PORT
        		}else{ // 현재 매장에 대한 서버로 결제일 때, 현재 매장의 IP/PORT를 현재 IP/PORT 변수에 셋팅
        			sessionStorage.setItem("SERVER_IP_NOW", SERVER_IP); // 현재 설정된 IP
    			    sessionStorage.setItem("SERVER_PORT_NOW", SERVER_PORT ); // 현재 설정된 값 PORT
        		}
    	    	nativeApp.removeASyncApiListener(callbackName, listenerId); // 리더기 카드체크하는 리스너 해제함수.
    	    	var vsResult = result.substring(0, result.lastIndexOf("$$^")); // native 데이터 중 마지막 $$^를 제거
    	    	vsResult = JSON.parse(vsResult);
    	    	paServerIpPortCallback(vsResult); // 콜백함수 호출.
    		}
    		
    		// 결제서버 정보가 있으면 서버 IP/PORT 변경 수행.
    		listenerId = nativeApp.functionCallASync(["FDK_Config_Host_Address", vsIp, vsPort], changeNetWorkCallback);
    		
    	}catch(e){
    		util.logError("*****util.js fnServerIpPortChange SERVER IP/PORT SET ERROR*****");
    		alert("결제 서버 정보 셋팅 중에 문제가 발생했습니다.");
    		return false;
    	}
    },    
    
    /**
     * 무인로봇에 주문내역 보내기 위한 TCP/IP connection 함수.
     * param : 주문번호
     */
    this.fnCallAsync_SocketConn = function(paOrderNo)
    {
    	util.logInfo("*****fnCallAsync_SocketConn START*****");
    	// 기존에 접속되었던 키값이 있으면 바로 send호출
    	if(!!gClientSock){
    		util.logInfo("*****fnCallAsync_SocketConn Conn SKIP GO SEND  gClientSock==> " + gClientSock);    		
    		util.fnCallAsync_SocketSenData(paOrderNo);    		
    		return;
    	}
    	var setupRobotResult = gfn_SQLiteSQLProcess(sqlQuery.selectRobotIpPort, [gShopCd]).Data; // 무인 로봇 IP/PORT 조회
        var vsRobotIp = setupRobotResult[0].IP;
        var vsRobotPort = setupRobotResult[0].PORT;
        
        // 콜백함수
        function fnCallBack_SocketConn(callbackName, result)
        { 
        	util.logInfo("*****fnCallBack_SocketConn Start***** ");
        	try 
        	{
        		util.logInfo("*****fnCallBack_SocketConn 1111*****");
        		nativeApp.removeASyncApiListener(callbackName, listenerId);
        		util.logInfo("*****fnCallBack_Socket result== > " + result);
        		    		
        		gClientSock = util.fnGet_Socket(result);
        		util.logInfo("*****fnCallBack_Socket gClientSock== > " + gClientSock);
        		// 정상적으로 connection 키값이 생성되었으면 send함수를 호출.
        		if(!!gClientSock){
        			util.fnCallAsync_SocketSenData(paOrderNo);
        		}
        	} catch (e) {
        		util.logError("fnCallBack_SocketConn 통신 접속에 실패했습니다.");   
        	}
        }
        util.logInfo("*****fnCallAsync_SocketConn vsRobotIp/vsRobotPort == > " + vsRobotIp+ " / " +vsRobotPort);
    	// param : IP/Port/Msg
    	listenerId = nativeApp.functionCallASync(["FDK_Sock_Connect", vsRobotIp, vsRobotPort], fnCallBack_SocketConn);

    } ,
    
    /**
     * 무인로봇에 주문내역 보내기 위한 send함수
     * param : 주문번호
     */
    // param : socket Descriptor / SendData
    this.fnCallAsync_SocketSenData = function(paOrderNo)
    {
    	util.logInfo("*****fnCallAsync_SocketSenData Start" );
    	
    	// 콜백함수
    	function fnCallBack_SocketSend(callbackName, result)
        {
        	util.logInfo("*****fnCallBack_SocketSend Start  result == >> \n" + JSON.stringify( result ));
        	try 
        	{
        		nativeApp.removeASyncApiListener(callbackName, listenerId);
        		
        		if(result.lastIndexOf("$$^") != -1) {
        			result = result.substring(0, result.lastIndexOf("$$^")); 	// Eof 이후 문자는 버린다 ($$^)
        		}
        		
        		var jsonResult = JSON.parse(result);
        		
        		var resultCode = jsonResult["ResultCode"];
        		var resultData = jsonResult["Data"];
        		var resultMessage = jsonResult["resultMessage"];
        		if(resultCode != "0"){        			
        			if(fgCnt == 0){ // send 실패시에 한번만 재connection을 시도한다.
        				fgCnt=1;
        				gClientSock = ""; // connection 키값 초기화.
        				util.fnCallAsync_SocketConn(paOrderNo);
        				return;
        			}
        			util.logInfo("fnCallBack_SocketSend 데이터 전송에 실패했습니다. " + resultMessage);
        		}else{ // 성공
        			util.logInfo("fnCallBack_SocketSend success");
        		}
        		
        		util.logInfo("*****fnCallAsync_SocketSenData result== > " + result);
        	
        	} catch (e) {
        		util.logError("fnCallBack_SocketSend 데이터 전송에 실패했습니다. " + e.toString());
        		if(fgCnt == 0){ // send 실패시에 한번만 재connection을 시도한다.
        			fgCnt=1;
        			gClientSock = ""; // connection 키값 초기화.
        			util.fnCallAsync_SocketConn(paOrderNo);
        			return;
        		}
        	}
        }
    	
    	try{
    		util.logInfo("*****fnCallAsync_SocketSenData orderNo Select Before gShopCd = > " + gShopCd + ", saleDate = > "+ saleDate + ", paOrderNo = > "+ paOrderNo);
    		util.logInfo("fnCallAsync_SocketSenData gClientSock ==> " + gClientSock );
	    	// gsOrderNo ///////////////////////////////////////////////
    		var db_result = gfn_SQLiteSQLProcess(sqlQuery.selectOrderNo  , [gShopCd, saleDate , paOrderNo]);
    		if ( util.isEmpty(db_result )  || util.isEmpty( db_result.Data)  || db_result.Data.length == 0 ) {
    			throw "주문정보를 가져오는데 실패했습니다.";
    		}    		
//    		var rows = db_result.Data;
//	    	var vsSdsOrgDtlNo ="";
	    	var vsSendData = util.fnMenuData(paOrderNo);
	    	
	    	
			util.logInfo("FDK_Sock_SendData Before vsSendData == > " + vsSendData);
    		listenerId = nativeApp.functionCallASync(["FDK_Sock_SendData", gClientSock, vsSendData], fnCallBack_SocketSend);
    	}catch(e){
    		if(fgCnt == 0){ // send 실패시에 한번만 재connection을 시도한다.
    			fgCnt=1;
    			gClientSock = ""; // connection 키값 초기화.
    			util.fnCallAsync_SocketConn(paOrderNo);
    			return;
    		}
    	}
    }
    
    // 타 장비에 보내기 위해 주문 데이터를 만든다. 
    this.fnMenuData = function(paOrderNo){
    	util.logInfo("***** fnMenuData START gsSpecialShopFlag == >>" + gsSpecialShopFlag);
//    	var db_result = gfn_SQLiteSQLProcess(sqlQuery.selectOrderNo  , [gShopCd, saleDate , paOrderNo]);
//		if ( util.isEmpty(db_result )  || util.isEmpty( db_result.Data)  || db_result.Data.length == 0 ) {
//		throw "주문정보를 가져오는데 실패했습니다.";
//	}
    	
    	var db_result = orderInfo.POS_ODDTL_T;

    	if ( util.isEmpty(db_result )  || util.isEmpty( db_result)  || db_result.length == 0 ) {
    		util.logError("***** fnMenuData 주문정보를 가져오는데 실패했습니다. *****");
			throw "주문정보를 가져오는데 실패했습니다.";
		}    		
		var rows = db_result;
    	var vsSdsOrgDtlNo ="";
    	var vsSendDataCoffiBan = "";
    	var vsSendDataAlDabang = [];
    	
    	// 수량:메인품목:사이드1:사이드2,수량:메인품목:사이드1
    	// ,는 그룹을 의미하고 :는 해당 그룹안에서의 구분자이다. 첫번재는 수량:두번째는 메인품목:나머지에 붙는 것은 모두 사이드메뉴
//		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
//			let row = rows[itx];
//			if(itx == 0){ // 첫번째 데이터
//				//vsSendData = row["SALE_QTY"] + ":" + row["PROD_CD"]; 
//				vsSendData = row["ORDER_QTY"] + ":" + row["PROD_CD"];
//				vsSdsOrgDtlNo = row["SDS_ORG_DTL_NO"];
//			}else{ // 첫번재가 아닌 데이터
//				// 사이드 그룹 없이 단품 주문인 경우에는 ""이 들어간다. 따라서 빈값으로 연속된 데이터가 조회되어도 같은 그룹이 아니다.
//				if(vsSdsOrgDtlNo == row["SDS_ORG_DTL_NO"]  && !!vsSdsOrgDtlNo){
//					vsSendData += ":" + row["PROD_CD"]; // 사이드메뉴를 계속 붙인다.
//				}else{ // 같지 않거나, 빈 값이면 그룹이 아닌 단품으로 담는다.
//					//vsSendData += "," + row["SALE_QTY"] + ":" + row["PROD_CD"];
//					vsSendData += "," + row["ORDER_QTY"] + ":" + row["PROD_CD"];
//					vsSdsOrgDtlNo = row["SDS_ORG_DTL_NO"];
//				}
//			}			
//		}
    	
    	if(gsSpecialShopFlag == "5"){ // 커피에 반하다
    		util.logInfo("***** fnMenuData 커피에반하다 분기문 *****");
    		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
    			let row = rows[itx];
    			if(itx == 0){ // 첫번째 데이터
    				//vsSendData = row["SALE_QTY"] + ":" + row["PROD_CD"]; 
    				vsSendDataCoffiBan = row["ORDER_QTY"] + ":" + row["PROD_CD"];					
    			}else{ // 첫번재가 아닌 데이터
    				// 사이드 그룹 없이 단품 주문인 경우에는 ""이 들어간다. 따라서 빈값으로 연속된 데이터가 조회되어도 같은 그룹이 아니다.
    				vsSendDataCoffiBan += "," + row["ORDER_QTY"] + ":" + row["PROD_CD"];
    			}			
    		}
    		util.logInfo("***** fnMenuData 커피에 반하다 전문 데이터 == >  " + vsSendDataCoffiBan);
    		return vsSendDataCoffiBan;
    	}else if(gsSpecialShopFlag == "7" || gsSpecialShopFlag == "9"){ // 알다방, 레인보우 로보틱스
    		util.logInfo("***** fnMenuData 알다방 분기문 *****");
    		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
    			let row = rows[itx];
    			var vsQty = row["ORDER_QTY"];
    			var vsSideCd = "";
    			// 2022-02-17 보바로보 사이드 메뉴가 필요하다고 하여 사이드 메뉴 추가. SIDE_CD 객체에 담아서 전송처리.
    			if(!!rows[itx].사이드_LIST){ // 사이드가 존재한다면
    				for(var sd=0; sd<rows[itx].사이드_LIST.length; sd++){ // 사이드 row만큼 for문
    					if(!rows[itx].사이드_LIST[sd].PROD_CD){ // 사이드 객체에 prod_cd가 없다면 ( 금액이 없는 옵션의 경우는 prod_cd가 존재하지 않음 )
    						if(vsSideCd == ""){
    							vsSideCd += JSON.parse(rows[itx].사이드_LIST[sd].사이드INFO_TXT).SIDE_CD; // SIDE_CD를 담는다.    							
    						}else{
    							vsSideCd += "," + JSON.parse(rows[itx].사이드_LIST[sd].사이드INFO_TXT).SIDE_CD; // SIDE_CD를 담는다.
    						}
    					}else{ // prod_cd가 존재한다면 ( 금액이 있는 사이드 상품의 경우 prod_cd가 존재 )
    						if(vsSideCd == ""){
    							vsSideCd += rows[itx].사이드_LIST[sd].PROD_CD; // PROD_CD를 담는다.    							
    						}else{
    							vsSideCd += "," + rows[itx].사이드_LIST[sd].PROD_CD; // PROD_CD를 담는다.
    						}
    					}
    				}
    			}
    			
    			for(var iq=0; iq<Number(vsQty); iq++){
    				var vsCnt = vsSendDataAlDabang.length;
        			vsSendDataAlDabang[vsCnt] = {"MENU_ID" : row["PROD_CD"],"MENU_NAME" : row["PROD_NM"],"OPTION" : "00000","SIDE_CD" : vsSideCd};
        			util.logInfo("***** fnMenuData 알다방 전문 데이터  " + vsCnt +"번째 == >  " + JSON.stringify(vsSendDataAlDabang[vsCnt]));
    			}
    			
    		}
    		return vsSendDataAlDabang;
    	}
    	
		
    }
    
    
    /**
     * connection 후에 데이터 가공
     */
    this.fnGet_Socket = function(result)
    {
    	util.logInfo("*****fnGet_Socket Start***** ");
    	var resultCode;
    	var resultData;
    	var resultMessage;
    	
    	try {
    		if(result.lastIndexOf("$$^") != -1) {
    			result = result.substring(0, result.lastIndexOf("$$^")); 	// Eof 이후 문자는 버린다 ($$^)
    		}
    		var jsonResult = JSON.parse(result);
    		resultCode = jsonResult["ResultCode"];
    		resultData = jsonResult["Data"];
    		resultMessage = jsonResult["Message"];
    		util.logInfo("*****fnGet_Socket resultMessage ***** " + resultMessage);
    		if(resultCode != "0") {
    			util.logInfo("통신 접속에 실패했습니다.");
    			return null;
    		}
    	} catch (e) {
    		util.logError("fnGet_Socket 통신 접속에 실패했습니다.");
			return null;
    	}
    	
    	return resultData;
    }
    
    /**
     * 제휴할인 승인을 취소한다.
     */
    this.fnAlliancePointCancel = function(payData){
    	try{
    		 util.logInfo("***** util.fnAlliancePointCancel START*****");
    		 util.logInfo("***** adminSql.selectSslTrJcdTCancel param == > " + gShopCd + ", " + payData.OLD_SALE_DATE + ", " + gPosNo + ", " + payData.OLD_BILL_NO);
	       	 var billNoResult = gfn_SQLiteSQLProcess(adminSql.selectSslTrJcdTCancel, [gShopCd, payData.OLD_SALE_DATE, gPosNo, payData.OLD_BILL_NO]).Data;
	         var CNMK_CD = billNoResult[0].CNMK_CD; // 거래일련번호 (거래일련번호 컬럼이 없어서 CNMK_CD 컬럼에 저장하여 사용하고 있다)
	         util.logDebug( "<<<===== util.fnAlliancePointCancel CNMK_CD =====>>>>> "+CNMK_CD);
	         var resultJcdType = util.fnGetJcdType(billNoResult[0].JCD_TYPE_FG);
	       	 
	       	 var fnPointCallbackResultC = function(callbackName, result) {
	            	util.logDebug( "<<<===== util.fnAlliancePointCancel CALLBACK START callbackName =====>>>>> "+callbackName);
	            	util.logInfo("<<<===== util.fnAlliancePointCancel CALLBACK START =====>>>>>" );
	                nativeApp.removeASyncApiListener(callbackName, listenerId);
	                var vsResult = result.substring(0, result.lastIndexOf("$$^")); // native 데이터 중 마지막 $$^를 제거
	                util.logDebug( "*** util.fnAlliancePointCancel CALLBACK  fnCallbackCancelApproval CALL BEFORE***");
	                adminService.fnCallbackCancelApproval(vsResult, payData);
	         };
	         
	       	 //Setting 10140185
	         var vsApprDt = billNoResult[0].APPR_DATE.substring(2); // 승인일자는 6자리로 넣어야한다.
	         util.logInfo("FDK_PointRefund param -- > " + billNoResult[0].APPR_AMT + " " + billNoResult[0].APPR_NO+ " " + vsApprDt+ " " + resultJcdType + " " + CNMK_CD)
	         util.logInfo("util.fnAlliancePointCancel payData.PAY_TYPE_FG == >> " + payData.PAY_TYPE_FG);
	       	 // param : 펑션명, catId, 금액, 모델명, 모델버전, 원거래승인번호, 원거래일자, 통신사타입, 카드번호, 콜백명  BIZ_CLS_SINGLE_CAT_ID
	         if(payData.PAY_TYPE_FG == "04"){
	        	 util.logInfo("util.fnAlliancePointCancel payData.PAY_TYPE_FG_NM == >> 제휴할인취소");
	        	 listenerId = nativeApp.functionCallASync(["FDK_PointRefund", BIZ_CLS_SINGLE_CAT_ID, "" + billNoResult[0].APPR_AMT, gvSwModelName, gvSwModelVersion, billNoResult[0].APPR_NO, vsApprDt, resultJcdType, "REFNO"+CNMK_CD], fnPointCallbackResultC);	        	 
	         }else if(payData.PAY_TYPE_FG == "03"){ //  MP포인트 사용+적립(03)
	        	 util.logInfo("util.fnAlliancePointCancel payData.PAY_TYPE_FG_NM 03 == >> MP포인트 적립사용취소");
	        	 
//	        	 listenerId = nativeApp.functionCallASync(["FDK_MpPointUsedCancel", BIZ_CLS_SINGLE_CAT_ID, "" + billNoResult[0].JCD_USE_POINT, gvSwModelName, gvSwModelVersion, billNoResult[0].APPR_NO, vsApprDt, "MP", "1001", "REFNO"+CNMK_CD], fnPointCallbackResultC);
	        	 
	        	 // MP포인트 사용 함수를 개발했으나, 추후에 적립함수 하나로 사용/적립을 처리하기로 변경되어 아래 함수 호출로 변경.
	        	 listenerId = nativeApp.functionCallASync(["FDK_MpPointRefund", BIZ_CLS_SINGLE_CAT_ID, "" + billNoResult[0].APPR_AMT, gvSwModelName, gvSwModelVersion, billNoResult[0].APPR_NO, vsApprDt, "MP", "1001", "REFNO"+CNMK_CD], fnPointCallbackResultC);
	         }else if(payData.PAY_TYPE_FG == "07"){ //  MP포인트 적립(07)
	        	 util.logInfo("util.fnAlliancePointCancel payData.PAY_TYPE_FG_NM 07 == >> MP포인트 적립취소");
	        	 listenerId = nativeApp.functionCallASync(["FDK_MpPointRefund", BIZ_CLS_SINGLE_CAT_ID, "" + billNoResult[0].APPR_AMT, gvSwModelName, gvSwModelVersion, billNoResult[0].APPR_NO, vsApprDt, "MP", "1001", "REFNO"+CNMK_CD], fnPointCallbackResultC);
	         }
    	}catch(e){
    		gfn_DbRollBack();
            gfn_DbClose();
    		util.logInfo("***** util.fnAlliancePointCancel catch e == > " + e.toString());
    	}
    	
    }
    
    this.fnGetJcdType = function(paJcdTypeFg){ // 현재 선택된 제휴사르 jcdCd로 포인트사의 코드를 조회한다.
		util.logInfo("*****util fnGetJcdType Start*****");
		
		util.logInfo("*****util fnGetJcdType paJcdTypeFg == >> " + paJcdTypeFg);
		var rtnVal="";
		if(paJcdTypeFg == "2"){        				
			rtnVal = "SK";
		}else if (paJcdTypeFg == "3"){
			rtnVal = "KT";
		}else if (paJcdTypeFg == "4"){
			rtnVal = "LG";
		}else if (paJcdTypeFg == "1"){ // OK 케시백
			rtnVal = "01";
		}
		util.logInfo("*****util fnGetJcdType rtnVal == >> " + rtnVal);
		return rtnVal;
	}
    
    // ajax Json 통신 함수
    this.ajaxCallJson = function(param, url, isAsync, callback, timeOut){
    	util.logInfo("***** ajaxCallJson START *****");
    	if (param == null || param == undefined || param == "" ) {
			param = "";
		}
    	
    	if ( isAsync == undefined ) {
			isAsync = false;
		}
    	
    	if ( timeOut == undefined ) {
    		timeOut = 10000;
    	}
    	
    	if (url == null || url == undefined || url == "" ) {
    		url = "";
		} 
    	
    	
        if(gsSpecialShopFlag == "8"){ // 푸드테크일 때
        	var paramTemp = param; // 넘어온 파라미터를 임시변수에 담는다.
        	var traceNo = moment().format('YYYYMMDDHHmmss') +  Math.floor(Math.random() * 1000);
        	
            param = {"header" :  {"version" : "1.0.0", "traceNo" : util.strEndPad(17, traceNo)}};
            param.body = paramTemp; // 넘어온 파라미터를 param에 다시 담아준다.
        }
    	
    	util.logInfo("***** ajaxCallJson url=== >>> " + url);
    	util.logInfo("***** ajaxCallJson param=== >>> " + JSON.stringify(param));
    	util.logInfo("***** ajaxCallJson isAsync === >>> " + isAsync);
    	try {
    		 var result = null;
	    	 $.ajax({
	             type : "POST",
	             url: url,
	             data: JSON.stringify(param),
	             contentType: "application/json; charset=UTF-8",
	             dataType : "json",
	             timeout : timeOut,
	             async: isAsync,	     
	             success: function(res) {
	                 util.logInfo("***** ajaxCallJson Call success *****");
	                 util.logInfo("***** ajaxCallJson res == >> " + JSON.stringify(res));
	                 //util.logInfo("***** res == >> " + res.toString());
	                 result = res;
	                 if ( typeof callback === 'function') {
	                	 callback(result);
					 }
	             },
	             error: function(xhr, status, error) {
	                 util.logError("ajaxCallJson error xhr1 == > " + JSON.stringify(xhr));
	                 util.logError("ajaxCallJson error status.toString == > " + status.toString());
	                 util.logError("ajaxCallJson error status == > " + status);
	                 util.logError("ajaxCallJson error == > " + error.toString());
	                 result = "error";
	                 if ( typeof callback === 'function') {
	                	 if(status.toString() == "timeout"){
	                		 callback("timeout");
	                	 }else{
	                		 callback("error");
	                	 }
	                	 
					 }
	             }
	         });
    	}catch(e){
    		util.logInfo("*****util ajaxCallJson CATCH e == > " + e.toString());
    	}
    	return result;
    }, 
    
    //진동벨 채번
	this.getVibBellOption = function(posOrderNo, callType) {
		util.logInfo("### getVibBellOption posOrderNo >>> " + posOrderNo);
		var pagmsOption = gfn_SQLiteSQLProcess(sqlQuery.selectPagmsOption, [gShopCd, gPosNo]).Data;
		util.logInfo("### pagmsOption >>> " + JSON.stringify(pagmsOption));
		util.logInfo("### callType >>> " + callType);
		var vibBellNo = "";
		var urlType = "";
		
		if ( pagmsOption != undefined || pagmsOption != null ) {
			if(callType == "B"){
				//callType 진동벨일 경우
				if(pagmsOption[0].PAG_TYPE_FG == "00" || pagmsOption[0].PAG_TYPE_FG == "02" || pagmsOption[0].PAG_TYPE_FG == "51"){

					//진동벨 리텍 -> 주문번호 뒷 3자리
					vibBellNo = posOrderNo.substr(1);
				} else if(pagmsOption[0].PAG_TYPE_FG == "01" || pagmsOption[0].PAG_TYPE_FG == "03") {
					//진동벨 시스콜 -> 주문번호 
					//vibBellNo = gPosNo.substr(1) + posOrderNo.substr(1);
					vibBellNo = posOrderNo;
				} 
			} else {
				//callType DID일 경우
				if(pagmsOption[0].PAG_TYPE_FG == "50") {
					//DID -> 주문번호
					vibBellNo = posOrderNo;
				}
			}
			
			if(pagmsOption[0].PAG_PORT == "02"){
				urlType = "/dev/ttyS2";
			} else if(pagmsOption[0].PAG_PORT == "01") {
				urlType = "/dev/ttyS1";
			}
			
			util.logInfo("### vibBellNo >>> " + vibBellNo);
			if( util.isTizen() == true && vibBellNo.length > 0) {
				//Native APP 진동벨 API 콜 
				//var result = nativeApp.functionCallSync(["FDK_VibratorSet", "/dev/ttyS2", 9600, 0, 1, "777"]);
				if(pagmsOption[0].PAG_TYPE_FG == "50"){
					var result = nativeApp.functionCallSync(["FDK_DigiInfoDisplaySet", urlType, parseInt("9600"), "F1", vibBellNo]);
					util.logInfo("### result >>> " + JSON.stringify(result));
				} else {
					var result = nativeApp.functionCallSync(["FDK_VibratorSet", urlType, parseInt("9600"), parseInt(pagmsOption[0].PAG_TYPE_FG), parseInt("1"), vibBellNo]);
					util.logInfo("### result >>> " + JSON.stringify(result));
				}
			}
		}
	},
	//마감 데이터 삭제
    this.fnDeletePosRegis = function(param){
        try{

            util.logDebug("### fnDeletePosRegis start param >>> " + JSON.stringify(param));
            var sDate = moment(param.pSaleDate, "YYYY-MM-DD").format("YYYYMMDD") ;
            var deleteResult = gfn_SQLiteSQLProcess(adminSql.deletePosRegis, [sDate]).Data;
            util.logInfo("### fnDeletePosRegis deleteResult >>> " + JSON.stringify(deleteResult));

            eventBus.$emit('alertPopup', {message: "완료되었습니다."});
        }catch(e){
            util.logInfo("### fnDeletePosRegis error >>> " + JSON.stringify(e));
        }
    },

    
	// 대기화면/동영상으로 왔을 때 버튼들이 안보이도록 제어한다.
	this.waitingBtnVisible = function() {
		util.logInfo("***** waitingBtnVisible Start gsWaitingVisibleYn == >> " + gsWaitingVisibleYn);
		if(gsWaitingVisibleYn == "Y"){
			$("#btnSet").show();
			$("#btnKr").show();
			$("#btnEn").show();
			$(".meal").show();
			$(".takeout").show();
			$(".meal_for_065313").show();
			$(".orderbtnblank").show();
			$(".orderbtnblank2").show();
			$(".orderbtnblank3").show();
		}else{
			$("#btnSet").hide();
			$("#btnKr").hide();
			$("#btnEn").hide();
			$(".meal").hide();
			$(".takeout").hide();``
			$(".meal_for_065313").hide();
			$(".orderbtnblank").hide();
			$(".orderbtnblank2").hide();
			$(".orderbtnblank3").hide();
		}
	},
	
	this.Delay = function(ms) 
	{
		const delayTime = Date.now() + ms;
		while( Date.now() < delayTime ) {}
	},
	
	this.padLeft = function(val, Idx, digit)
	{
	    return Array( Idx-String(val).length+1 ).join(digit||'0') + val;
	},
	
	/**
	 * 부가세를 계산한다.
	 * @param taxEnvVal : 부가세 포함여부
	 */
	this.fnTaxCalcul = function(taxEnvVal){
		util.logInfo(" ***** 부가세 계산 시작 fnTaxCalcul START *****");
		/////////////////////// 부가세 계산 시작. ///////////////////////// 
		var vsCntDtl = orderInfo.POS_ODDTL_T.length;
		var vnTaxNonSaleAmt = 0; // 상품금액에서 면세를 제외하고 난 값의 합(면세물품가액)
		var vnTaxSaleAmt = 0; // 상품금액에서 부가세를 제외하고 난 값의 합(과세물품가액)
		var vnTotTax = 0; // 부가세만의 합
		
		// 주문한 상품 for문
		for(var i=0;i<vsCntDtl;i++){
			if(orderInfo.POS_ODDTL_T[i].TAX_YN == "N"){ // 해당 인덱스의 상품이 면세일 때는 면세금액에 값을 더한다.
				vnTaxNonSaleAmt += Number(orderInfo.POS_ODDTL_T[i].DCM_SALE_AMT);
			}else{ // 면세가 아닐 때    									
				if(taxEnvVal == "1"){ // 부가세포함
					var vsTax = Number(orderInfo.POS_ODDTL_T[i].DCM_SALE_AMT) - (Number(orderInfo.POS_ODDTL_T[i].DCM_SALE_AMT) / 1.1); // 상품의 금액의 부가세를 계산
					if(vsTax < 0){ // 음수인 경우
						vsTax = parseInt(vsTax) * -1; // 절삭 처리 후 -로 변경 해준다.
					}else{
						vsTax = parseInt(vsTax); // 절삭 처리
					}
					orderInfo.POS_ODDTL_T[i].VAT_AMT = vsTax; // 할인 받은 금액으로 상품별로 차감을하고난 후, tax값을 다시 계산하여 기존 tax값에 대체하여 넣는다.
					vnTaxSaleAmt += Number(orderInfo.POS_ODDTL_T[i].DCM_SALE_AMT) - vsTax; // 상품금액에서 부가세를 뺀다.
					vnTotTax += vsTax; // 부가세를 누적함.
				}else if(taxEnvVal == "0"){ // 부가세별도	            							
					var vsTax = Number(orderInfo.POS_ODDTL_T[i].DCM_SALE_AMT) * 0.1; // 상품의 금액의 부가세를 계산
					if(vsTax < 0){ // 음수인 경우
						vsTax = parseInt(vsTax) * -1; // 절삭 처리 후 -로 변경 해준다.
					}else{
						vsTax = parseInt(vsTax); // 절삭 처리
					}
					orderInfo.POS_ODDTL_T[i].VAT_AMT = vsTax;  // 할인 받은 금액으로 상품별로 차감을하고난 후, tax값을 다시 계산하여 기존 tax값에 대체하여 넣는다.							
					vnTaxSaleAmt += Number(orderInfo.POS_ODDTL_T[i].DCM_SALE_AMT); // 상품금액을 그대로 넣는다.
					vnTotTax += vsTax; // 부가세를 누적함.
					
					util.logInfo("*****부가세 계산 함수 fnTaxCalcul(별도) 부가세 vsTax == > " + vsTax);
					util.logInfo("*****부가세 계산 함수 fnTaxCalcul(별도) 누적 부가세 vnTotTax == > " + vnTotTax);
					util.logInfo("*****부가세 계산 함수 fnTaxCalcul(별도) orderInfo.POS_ODDTL_T[i].DCM_SALE_AMT == > " + Number(orderInfo.POS_ODDTL_T[i].DCM_SALE_AMT));
					
				}
			}
		}
		
		util.logInfo("*****부가세 계산 함수 fnTaxCalcul TAX_SALE_AMT == > " + vnTaxSaleAmt);
		util.logInfo("*****부가세 계산 함수 fnTaxCalcul NON_TAX_SALE_AMT == > " + vnTaxNonSaleAmt);
		util.logInfo("*****부가세 계산 함수 fnTaxCalcul VAT_AMT == > " + vnTotTax);
		orderInfo.POS_ODHDR_T.TAX_SALE_AMT = vnTaxSaleAmt;
		orderInfo.POS_ODHDR_T.VAT_SALE_AMT = vnTaxSaleAmt
		orderInfo.POS_ODHDR_T.NON_TAX_SALE_AMT = vnTaxNonSaleAmt;
		orderInfo.POS_ODHDR_T.NO_VAT_SALE_AMT  = vnTaxNonSaleAmt;
		
		//세금을 제외한 매출금액합계
		orderInfo.POS_ODHDR_T.NO_TAX_SALE_AMT  = vnTaxSaleAmt + vnTaxNonSaleAmt;
		orderInfo.POS_ODHDR_T.VAT_AMT  = vnTotTax; // 부가세 총 합을 헤더에 넣는다.
	},
	
	/**
	 * NetCancel 데몬을 중지/재실행 한다.
	 * @param Int excCd   : NetCancel 데몬을 중지, 재실행 하기 위한 구분자 ( 0 : 데몬중지, 1 : 데몬 재실행 )
	 * @param Int timeCnt : NetCancel 데몬이 중지되는 시간카운트 ( 1 마다 30초씩 중지가 됨.  ex) 5를 넣으면 150초동안 데몬이 중지되었다가 다시 살아남 )
	 */
	this.fnNetCancelCommand = function(excCd, timeCnt){
		util.logInfo(" ***** NetCancel 데몬 제어함수 시작 util fnNetCancelCommand START *****");
		util.logInfo(" ***** NetCancel 데몬 제어함수 excCd == > " + excCd + ", timeCnt == >" + timeCnt);
		try{
			var netCancelCommandCallback = function(callbackName, result) {
				util.logInfo(" *****util fnNetCancelCommand NetCancel 데몬 재실행 콜백 netCancelCommandCallback START *****");
			}
			
			if(excCd == 0){ // 데몬을 중지하는 거라면
				util.logInfo(" *****util fnNetCancelCommand NetCancel FDK_NetCancelCommand(중지) Start *****");
				nativeApp.functionCallASync(["FDK_NetCancelCommand", excCd, timeCnt], netCancelCommandCallback);
			}else{ // 데몬을 다시 살리는 거라면 timeout을 준다. ( 결제나 기타 승인이 정상적으로 완료되면 orderApp에서 NetCancel 파일을 삭제한 후에 해당 데몬 재실행 함수를 실행하는데, tizen API가 파일을 삭제하는데 시간이 걸릴 수 있으므로 데몬 재실행함수를 조금 지연시킨다.
				util.logInfo(" *****util fnNetCancelCommand NetCancel FDK_NetCancelCommand(재실행) Start *****");
				setTimeout(nativeApp.functionCallASync(["FDK_NetCancelCommand", excCd, timeCnt], netCancelCommandCallback), 3000); // NetCancel 데몬 제어. @param1 = 0 : 데몬중지, 1 : 데몬 재실행 / @param2 = 데몬이 중지되는 타임 카운트 ( 1에 30초씩 계산됨 )
			}
		}catch(e){
			util.logError(" *****util fnNetCancelCommand NetCancel FDK_NetCancelCommand ERROR == > e" + e.toString());
		}
	},
	
	/**
	 * 휴대폰번호 가운데 자리를 마스킹한다.
	 * @param String str   : 휴대폰번호
	 */
	this.fnPhoneNumMasking = function(str){

    	var regNotNum = /[^0-9]/g;
		var regPhoneNum = "";
		var dataForm = "";

		// return blank
		if (str == "" || str == null)
			return "";

		// delete not number
		str = str.replace(regNotNum, '');
		//console.log("str11 >>> " + str);
		if (str.length < 3) return str;

		if (str.substr(0, 2) == "02") {
			if (str.length > 2 && str.length < 7) {
				dataForm = "$1-$2";
				regPhoneNum = /([0-9]{2})([0-9]+)/;
			} else if (str.length >= 7) {
				if(str.length == 9){
					dataForm = "$1-$2-$3";
					regPhoneNum = /([0-9]{2})([0-9]{3})([0-9]+)/;
				} else if(str.length == 10) {
					dataForm = "$1-$2-$3";
					regPhoneNum = /([0-9]{2})([0-9]{4})([0-9]+)/;
				} else{
					dataForm = "$1-$2-$3";
					regPhoneNum = /([0-9]{2})([0-9]{4})([0-9]+)/;
				}
			}

		} else if (str.substr(0, 3) == "050") {
			if (str.length == 4 || str.length == 3) {
				dataForm = "$1-$2";
				regPhoneNum = /([0-9]{3,4})/;
			} else if (str.length > 4 && str.length < 8) {
				dataForm = "$1-$2";
				regPhoneNum = /([0-9]{4})([0-9]+)/;
			} else if (str.length == 8) {
				dataForm = "$1-$2";
				regPhoneNum = /([0-9]{4})([0-9]{4})/;
			} else if (str.length >= 9) {
				if(str.length == 11) {
					dataForm = "$1-$2-$3";
					regPhoneNum = /([0-9]{4})([0-9]{3})([0-9]+)/;
				} else if(str.length == 12) {
					dataForm = "$1-$2-$3";
					regPhoneNum = /([0-9]{4})([0-9]{4})([0-9]+)/;
				} else {
					dataForm = "$1-$2-$3";
					regPhoneNum = /([0-9]{4})([0-9]{4})([0-9]+)/;
				}
			}
		} else {
			if (str.length == 3) {
				dataForm = "$1";
				regPhoneNum = /([0-9]{3})/;
			} else if (str.length == 4) {
				dataForm = "$1-$2";
				regPhoneNum = /([0-9]{3})([0-9]{1})/;
			} else if (str.length == 5) {
				dataForm = "$1-$2";
				regPhoneNum = /([0-9]{3})([0-9]{2})/;
			} else if (str.length == 6) {
				dataForm = "$1-$2";
				regPhoneNum = /([0-9]{3})([0-9]{3})/;
			} else if (str.length == 7) {
				dataForm = "$1-$2";
				regPhoneNum = /([0-9]{3})([0-9]{4})/;
			} else if (str.length == 8) {
				dataForm = "$1-$2-$3";
				regPhoneNum = /([0-9]{3})([0-9]{4})([0-9]+)/;
			} else if (str.length == 9) {
				dataForm = "$1-$2-$3";
				regPhoneNum = /([0-9]{3})([0-9]{4})([0-9]+)/;
			} else if (str.length == 10) {
				dataForm = "$1-$2-$3";
				regPhoneNum = /([0-9]{3})([0-9]{3})([0-9]+)/;
			} else if (str.length > 10) {
				dataForm = "$1-$2-$3";
				regPhoneNum = /([0-9]{3})([0-9]{4})([0-9]+)/;
			}
		}

		//console.log("regPhoneNum >>> " + regPhoneNum);
		//console.log("dataForm >>> " + dataForm);

		var tempStr = '';
		if (regPhoneNum != '') {
			if (regPhoneNum.test(str)) {
				tempStr = str.replace(regPhoneNum, dataForm);
				if (str.substr(0, 2) == "02") {
					if (str.length == 3)
						tempStr = tempStr.replace(/-[0-9]{1}/g, "-"+str.substr(str.length - 1));
					if (str.length == 4)
						tempStr = tempStr.replace(/-[0-9]{2}/g, "-*"+str.substr(str.length - 1));
					if (str.length == 5)
						tempStr = tempStr.replace(/-[0-9]{3}/g, "-**"+str.substr(str.length - 1));
					if (str.length == 6)
						tempStr = tempStr.replace(/-[0-9]{4}/g, "-***"+str.substr(str.length - 1));
					if (str.length > 6){
						if(str.length == 9) {
							tempStr = tempStr.replace(/-[0-9]{3}-/g, "-***-");
						} else if(str.length == 10) {
							tempStr = tempStr.replace(/-[0-9]{4}-/g, "-****-");
						} else {
							tempStr = tempStr.replace(/-[0-9]{4}-/g, "-****-");
						}
					}
				} else if (str.substr(0, 3) == "050") {
					if (str.length == 3 || str.length == 4)
						tempStr = str;
					if (str.length == 5)
						tempStr = tempStr.replace(/-[0-9]{1}/g, "-"+str.substr(str.length - 1));
					if (str.length == 6)
						tempStr = tempStr.replace(/-[0-9]{2}/g, "-*"+str.substr(str.length - 1));
					if (str.length == 7)
						tempStr = tempStr.replace(/-[0-9]{3}/g, "-**"+str.substr(str.length - 1));
					if (str.length == 8)
						tempStr = tempStr.replace(/-[0-9]{4}/g, "-***"+str.substr(str.length - 1));
					if (str.length > 8)
						if(str.length == 11) {
							tempStr = tempStr.replace(/-[0-9]{3}-/g, "-***-");
						} else if(str.length == 12) {
							tempStr = tempStr.replace(/-[0-9]{4}-/g, "-****-");
						} else {
							tempStr = tempStr.replace(/-[0-9]{4}-/g, "-****-");
						}
				} else {
					if (str.length == 3)
						tempStr = str;
					if (str.length == 4)
						tempStr = tempStr.replace(/-[0-9]{1}/g, "-"+str.substr(str.length - 1));
					if (str.length == 5)
						tempStr = tempStr.replace(/-[0-9]{2}/g, "-*"+str.substr(str.length - 1));
					if (str.length == 6)
						tempStr = tempStr.replace(/-[0-9]{3}/g, "-**"+str.substr(str.length - 1));
					if (str.length == 7)
						tempStr = tempStr.replace(/-[0-9]{4}/g, "-***"+str.substr(str.length - 1));
					if (str.length > 7) {
						if(str.length == 10) {
							tempStr = tempStr.replace(/-[0-9]{3}-/g, "-***-");
						} else if(str.length == 11) {
							tempStr = tempStr.replace(/-[0-9]{4}-/g, "-****-");
						} else {
							tempStr = tempStr.replace(/-[0-9]{4}-/g, "-****-");
						}
					}


				}
			}
		}
		return tempStr;
	},
	
	// ajax Json 통신 함수
    this.ajaxCallKerbanProdCheck = function(callback){

		console.log('kerbanMsChkhFg', kerbanMsChkhFg);
		if(kerbanMsChkhFg == '0'){
			util.logInfo("***** ajaxCallKerbanProdCheck >> 커피머신 상태체크 기능 Skip *****");
			var resultObj = {
				code : '200'
				,msg : 'SUCCESS'
				,message : '성공'
				,resultKerbanStatus : true
			}
			return resultObj;
		}

		//isAsync, callback
    	util.logInfo("***** ajaxCallKerbanProdCheck START *****");
    	
    	//device_id = gShopCd + gPosNo;
    	//06662601, 06498502
    	
    	var param = {
				"token" : kerbanToken,
				"device_id" : gShopCd + gPosNo,
				//"device_id" : "06662601",
		}
		//쿠폰조회
		var kerbanFullUrl = kerbanUrl + "api/fiserv/v1/devicecheck" ;
    	
    	if (param == null || param == undefined || param == "" ) {
			param = "";
		}
    	
//    	if ( isAsync == undefined ) {
//			isAsync = false;
//		}
    	
    	if (kerbanFullUrl == null || kerbanFullUrl == undefined || kerbanFullUrl == "" ) {
    		kerbanFullUrl = "";
		} 
    	util.logInfo("***** ajaxCallKerbanProdCheck url=== >>> " + kerbanFullUrl);
    	util.logInfo("***** ajaxCallKerbanProdCheck param=== >>> " + JSON.stringify(param));
    	//util.logInfo("***** ajaxCallKerbanProdCheck isAsync === >>> " + isAsync);
    	
    	var resultKerban = {};
    	var resultKerbanStatus = false;
    	
    	try {
    		 var result = null;
	    	 $.ajax({
	             type : "POST",
	             url: kerbanFullUrl,
	             data: JSON.stringify(param),
	             contentType: "application/json; charset=UTF-8",
	             dataType : "json",
	             timeout : 5000,
	             async: false,
	             success: function(res) {
	                 util.logInfo("***** ajaxCallKerbanProdCheck Call success *****");
	                 result = res;
	                 
	                 //test data
	                 //var temp = '{"code": "200","msg": "성공","availability": true,"part_availability": true,"availability_products": '
	                 //			+ '{"000219": true,"000184": true,"000182": true,"000185": true}}';
	                 //result = JSON.parse(temp);
	                 
	                 
	                 if ( typeof callback === 'function') {
	                	 callback(result);
					 } else {
						 util.logInfo("***** ajaxCallKerbanProdCheck res == >> " + JSON.stringify(res));
						 if(result.code == "200"){
							 util.logInfo("***** ajaxCallKerbanProdCheck result == >> " + typeof result.availability);
							 if(!result.availability){
								 router.push({name : 'inspection', params: { "beforePage" : "kerbanMain"}});
							 } else {
								 util.updateKerbanProd(result.availability_products);
								 //resultKerbanStatus = true;
								 //resultKerban.code = "100";
								 resultKerban.message = "성공";
								 resultKerban.resultKerbanStatus = true;
							 }
						 } else {
							 util.logInfo("***** ajaxCallKerbanProdCheck 상품정보갱신 실패 == >> " + result.code );
							 util.logInfo("***** ajaxCallKerbanProdCheck 상품정보갱신 실패 == >> " + result.msg );
							 //eventBus.$emit('alertPopupIndex', {message: result.msg + "[이퀴닉스 관리자 문의]"});
							 //alert(result.msg + "[이퀴닉스 관리자 문의]");
							 //resultKerban.code = "201";
							 resultKerban.message = result.msg + "[이퀴닉스 관리자 문의]";
							 resultKerban.resultKerbanStatus = false;
							 util.logInfo("***** ajaxCallKerbanProdCheck 상품정보갱신 실패1 == >> " + JSON.stringify(resultKerban));
						 }
					 }
	                 
	                 
	             },
	             error: function(xhr, status, error) {
	            	 util.logInfo("ajaxCallKerbanProdCheck error xhr1 == > " + JSON.stringify(xhr));
	                 util.logError("ajaxCallKerbanProdCheck error xhr1 == > " + JSON.stringify(xhr));
	                 util.logError("ajaxCallKerbanProdCheck error status.toString == > " + status.toString());
	                 util.logError("ajaxCallKerbanProdCheck error status == > " + status);
	                 util.logError("ajaxCallKerbanProdCheck error == > " + error.toString());
	                 //alert("기기상태 조회 실패 [이퀴닉스 관리자 문의]");
	                 //alert("상품정보갱신 실패!");
	                 //result = "error";
                	 if(status.toString() == "timeout" || status.toString() == "error"){
                		 //alert("기기상태 조회 실패. 인터넷 접속상태를 확인해주세요.");
                		 //resultKerban.code = "203";
						 resultKerban.message = "커피머신 서버 접속 에러";
						
                	 }else{
                		 //alert("기기상태 조회 실패 [이퀴닉스 관리자 문의]");
                		 //resultKerban.code = "202";
						 resultKerban.message = "커피머신 서버 접속 실패";
                	 }
                	 resultKerban.resultKerbanStatus = false;
                	 
                	 util.logInfo("***** ajaxCallKerbanProdCheck 상품정보갱신 실패2 == >> " + JSON.stringify(resultKerban));
	             }
	         });
    	}catch(e){
    		util.logInfo("*****util ajaxCallKerbanProdCheck CATCH e == > " + e.toString());
    	}
    	return resultKerban;
    },
    
    // 커피에 반하다 상품상태 (soldout 여부) 변경. 알다방 상품상태 업데이트 추가됨.(분기문으로 list만드는 것만 분기함. 저장은 같음)
    this.updateKerbanProd = function(resultData){
    	util.logInfo("_____무인로봇 매장의 메뉴 별 sold out 여부 처리 시작. gsSpecialShopFlag ==>> " + gsSpecialShopFlag)
    	var prodSoldOutList = "";
    	var prodAvlSaleList = "";
    	// 커피사별로 내려오는 데이터가 달라서 분기하여 가공처리.
    	if(gsSpecialShopFlag == "5"){ // 커피에 반하다.
    		util.logInfo("_____무인로봇 매장 별 sold out 메뉴 가공 (커피에반하다)_____");
    		//gProdAllList = orderMenuService.getProductData(null , langCode , vatCd);
    		for(var data in resultData) {
    			//키오스크 상품 상태가 품절이 아닐때
    			//커반 서버데이터값이 품절일떄 -> 키오스크상품상태를 품절로 변경
    			//품절상태일때만 변경 -> 베스트 상품 및 다른 상품상태는 기존으로 유지 
    			if(!resultData[data]){
    				for(var i=0; i<gProdAllList.length; i++){
    					if(gProdAllList[i].PROD_CD == data) {
    						if(gProdAllList[i].KIOSK_PROD_STATUS != "4"){
    							prodSoldOutList += "'" + data + "',";
    							break;
    						}
    					}
    				}
    			}
    			
    			//커반 서버데이터값이 품절이  아닐떄 -> 키오스크상품상태를 정상으로 변경
    			if(resultData[data]){
    				for(var i=0; i<gProdAllList.length; i++){
    					if(gProdAllList[i].PROD_CD == data) {
    						if(gProdAllList[i].KIOSK_PROD_STATUS == "4"){
    							prodAvlSaleList += "'" + data + "',";
    							break;
    						}
    					}
    				}
    			}
    			
        	}
    	}else if(gsSpecialShopFlag == "7" || gsSpecialShopFlag == "9"){ // 알다방, 레인보우 로보틱스
    		util.logInfo("_____무인로봇 매장 별 sold out 메뉴 가공 (알다방)_____");
    		for(var i=0;i<resultData.length;i++){
    			var vsData = resultData[i];
    			if(!vsData.AVAILABLE){
    				for(var j=0; j<gProdAllList.length; j++){
    					if(gProdAllList[j].PROD_CD == vsData.MENU_ID) {
    						if(gProdAllList[j].KIOSK_PROD_STATUS != "4"){
    							prodSoldOutList += "'" + vsData.MENU_ID + "',";
    							break;
    						}
    					}
    				}
    			}
    			if(vsData.AVAILABLE){
    				for(var z=0; z<gProdAllList.length; z++){
    					if(gProdAllList[z].PROD_CD == vsData.MENU_ID) {
    						if(gProdAllList[z].KIOSK_PROD_STATUS == "4"){
    							prodAvlSaleList += "'" + vsData.MENU_ID + "',";
    							break;
    						}
    					}
    				}
    			}
    		}
    	}
    	
    	
    	util.logInfo("_____무인로봇 매장의 메뉴 별 sold out 처리. prodSoldOutList(품절대상) ==>> " + prodSoldOutList);
    	util.logInfo("_____무인로봇 매장의 메뉴 별 sold out 처리. prodAvlSaleList(판매대상) ==>> " + prodAvlSaleList);
    	
    	var s = "UPDATE SCD_PRODM_T SET KIOSK_PROD_STATUS_RBT = '4' WHERE SHOP_CD = '" + gShopCd + "' AND PROD_CD IN (%s) /** 단발성 SQL **/ ";
		prodSoldOutList = prodSoldOutList.slice(0, -1);
		s = s.sprintf(prodSoldOutList);
		
		if(prodSoldOutList != "") { //업데이트할 내용이 있는경우
			var db_result1 = gfn_SQLiteSQLProcess( s , []);
			util.logInfo("_____무인로봇 매장의 메뉴 별 sold out 처리. 품절대상 쿼리결과 ==>> " + JSON.stringify(db_result1));
			var vatCd = util.GetEnvXmlShopENV(128)
        	gProdAllList = orderMenuService.getProductData(null , langCode , vatCd);
    	}
		
		var ss = "UPDATE SCD_PRODM_T SET KIOSK_PROD_STATUS_RBT = '1' "
					//+ "CASE WHEN KIOSK_PROD_STATUS = '4' THEN '1' ELSE KIOSK_PROD_STATUS END "
					+ "WHERE SHOP_CD = '" + gShopCd + "' AND PROD_CD IN (%s) /** 단발성 SQL **/ ";
		
		prodAvlSaleList = prodAvlSaleList.slice(0, -1);
		ss = ss.sprintf(prodAvlSaleList);
		
		if(prodAvlSaleList != "") { //업데이트할 내용이 있는경우
			var db_result2 = gfn_SQLiteSQLProcess( ss , []);
			util.logInfo("_____무인로봇 매장의 메뉴 별 sold out 처리. 판매대상 쿼리결과 ==>> " + JSON.stringify(db_result2));
			var vatCd = util.GetEnvXmlShopENV(128);
        	gProdAllList = orderMenuService.getProductData(null , langCode , vatCd);
		}
		
    }
	,
	// ajax Json 통신 함수
    this.ajaxCallKerbanDeviceCheck = function(){

		console.log('kerbanMsChkhFg', kerbanMsChkhFg);
		if(kerbanMsChkhFg == '0'){
			util.logInfo("***** ajaxCallKerbanDeviceCheck >> 커피머신 상태체크 기능 Skip *****");
			return 'true';
		}
		//isAsync, callback
    	util.logInfo("***** ajaxCallKerbanDeviceCheck START *****");
    	
    	//device_id = gShopCd + gPosNo;
    	var param = {
				"token" : kerbanToken,
				"device_id" : gShopCd + gPosNo,
		}
		//쿠폰조회
		var kerbanFullUrl = kerbanUrl + "api/fiserv/v1/devicecheck" ;
    	
    	if (param == null || param == undefined || param == "" ) {
			param = "";
		}
    	
//    	if ( isAsync == undefined ) {
//			isAsync = false;
//		}
    	
    	if (kerbanFullUrl == null || kerbanFullUrl == undefined || kerbanFullUrl == "" ) {
    		kerbanFullUrl = "";
		} 
    	util.logInfo("***** ajaxCallKerbanDeviceCheck url=== >>> " + kerbanFullUrl);
    	util.logInfo("***** ajaxCallKerbanDeviceCheck param=== >>> " + JSON.stringify(param));
    	//util.logInfo("***** ajaxCallKerbanProdCheck isAsync === >>> " + isAsync);
    	
    	try {
    		 var result = null;
	    	 $.ajax({
	             type : "POST",
	             url: kerbanFullUrl,
	             data: JSON.stringify(param),
	             contentType: "application/json; charset=UTF-8",
	             dataType : "json",
	             timeout : 5000,
	             async: false,
	             success: function(res) {
	                 util.logInfo("***** ajaxCallKerbanDeviceCheck Call success *****");
	                 util.logInfo("***** ajaxCallKerbanDeviceCheck res == >> " + JSON.stringify(res));
	                 result = res;
	                 if ( typeof callback === 'function') {
	                	 callback(result);
					 } else {
						 if(result.code == "200"){
							 if(!result.availability){
								 //팝업 분기처리, 결제버튼 클릭, 신용카드 클릭
								 result = "false";
							 } else {
								 result = "true";
								 //callback("true");
							 }
						 } else {
							 util.logInfo("***** ajaxCallKerbanDeviceCheck 상품정보갱신 실패 == >> " + result.code );
							 util.logInfo("***** ajaxCallKerbanDeviceCheck 상품정보갱신 실패 == >> " + result.msg );
							 result = "error";
						 }
					 }
	                 
	             },
	             error: function(xhr, status, error) {
	                 util.logError("ajaxCallKerbanDeviceCheck error xhr1 == > " + JSON.stringify(xhr));
	                 util.logError("ajaxCallKerbanDeviceCheck error status.toString == > " + status.toString());
	                 util.logError("ajaxCallKerbanDeviceCheck error status == > " + status);
	                 util.logError("ajaxCallKerbanDeviceCheck error == > " + error.toString());
	                 result = "error";
	             }
	         });
    	}catch(e){
    		util.logInfo("*****util ajaxCallKerbanProdCheck CATCH e == > " + e.toString());
    	}
    	return result;
    }
    , 
    /**
     * 테마변경 함수.
     * @param1 main-color
     * @param2 main-backround
     * @param3 text-white
     * @param4 text-black
     * @param5 text-darkgray
     * @param6 text-middlegray
     * @param7 text-lightgray
     * ex) util.chgThm('#ff6600', '#ffffff','#ffffff', '#000000', '#5c5c5c', '#898989', '#f7f7f7'); // 오렌지    	    		
           util.chgThm('#111e90', '#ffffff','#ffffff', '#000000', '#5c5c5c', '#898989', '#f7f7f7'); // 파랑색
     */
	this.chgThm = function(mc, mb, tw, tb, td, tm, tl){
//    	util.chgThm('#ff6600', '#ffffff','#ffffff', '#000000', '#5c5c5c', '#898989', '#f7f7f7'); // 오렌지    	    		
//      util.chgThm('#111e90', '#ffffff','#ffffff', '#000000', '#5c5c5c', '#898989', '#f7f7f7'); // 파랑색
		util.logInfo("__________ 테마변경 시작 __________");
		document.documentElement.style.setProperty("--main-color", mc);
        document.documentElement.style.setProperty("--main-backround", mb);
        document.documentElement.style.setProperty("--text-white", tw);
        document.documentElement.style.setProperty("--text-black", tb);
        document.documentElement.style.setProperty("--text-darkgray", td);
        document.documentElement.style.setProperty("--text-middlegray", tm);
        document.documentElement.style.setProperty("--text-lightgray", tl);
	}
	,
	this.onScanner = function () {
        let isEvent = false; // for check just one event declaration
        let input = document.getElementById("scanner");
        
     
//        var keypressVal = "";
//        if(input != null || input != undefined) {
//        	document.addEventListener("keypress", function (e) {
//        		//util.logInfo("### e.target.tagName : " + e.target.tagName);
//        		//util.logInfo("### e.keyCode11 : " + e.keyCode);
//        		//util.logInfo("### keypressVal1 : " + keypressVal);
//        		if (e.target.tagName !== "INPUT") {
//        			//input.select();
//        			input.focus();
//        		}
//        		
//        	});
//        	
//        	//바코드 입력시 input text 입력란에 포커스를 준다
//        	input.addEventListener("focus", function () {
//        		util.logInfo("### isEvent1 : " + isEvent);
//        		if (!isEvent) {
//        			isEvent = true;
//        			input.addEventListener("keypress", function (e) {
//        				util.logInfo("### e.keyCode : " + e.keyCode);
//        				//keypressVal += e.keyCode+", ";
//        				if (e.keyCode == 13) {
//        					//util.logInfo("### input.value : " + input.value);
//        					//input.select();
//        					//waitingService.docEventCheck(e);
//        					orderMenuService.barcodeNumResult(input.value);
//        					util.logInfo("### scanner" + $("#scanner").val());
//        					//util.logInfo("### keypressVal2 : " + keypressVal);
//        					keypressVal = "";
//        					input.value = "";
//        				}
//        				
//        				
//        			}) 
//        		}
//        	});
//        	
//        	
//        }
    },
    
    /**
     * 권한이 있는 대상자인지 체크한다.
     * 권한이 있는 직원이라면 비밀번호 팝업을 띄우지 않고 바로 화면으로 전환됨.
     * 권한이 없는 직원이라면 adminMenuEmpAuthYn 함수를 통해서 비밀번호를 체크하고 화면으로 전환됨.
     */
    this.adminMenuEmpAuthCheck = function(paFkNo){
    	
    	var empAuthYnResultCnt = gfn_SQLiteSQLProcess(adminSql.selectAdminMenuEmpAuthYn, [gShopCd, paFkNo]).Data;
    	 if(empAuthYnResultCnt && empAuthYnResultCnt.length > 0){
             var vsCnt = empAuthYnResultCnt[0].CNT;
             if(vsCnt == 0){
            	 return true;
             }
    	 }else{
    		 return true;
    	 }
    	
    	var vsEmpInfo = JSON.parse(sessionStorage.getItem("EMP_INFO"));
    	var vsEmpNo = vsEmpInfo.EMP_NO; // 세션의 직원번호
    	var queryResult = gfn_SQLiteSQLProcess(adminSql.selectAdminMenuEmpAuthChk, [gShopCd, paFkNo, vsEmpNo]).Data;
    	util.logInfo("***** 직원별 화면 권한 체크 쿼리.=====> " + adminSql.selectAdminMenuEmpAuth);
    	util.logInfo("***** 직원별 화면 권한 체크 쿼리 파라미터.=====> " + gShopCd + ", " + paFkNo );
        if(queryResult && queryResult.length > 0){
            var vsCnt = queryResult[0].CNT;
            util.logInfo("***** 직원별 화면 권한 체크 쿼리결과.=====> " + vsCnt);
            if(Number(vsCnt) > 0){
            	return true;
            }else{
            	return false;
            }
        }else{
        	util.logInfo("***** 직원별 화면 권한 체크 쿼리 데이터 없음. *****");
        	return false;
        }
    },
    
    /**
     * 직원별 관리자 화면 권한체크. (화면에 대한 권한이 있으면 true를 리턴, 없으면 false 리턴)
     * paFkNo : 화면버튼의 키값.
     * 
     * fkNo 정보
     * 영업관리
     *  123	M멤버십충전
		103	마감취소
		104	시재입출금
		105	시재점검
		106	외상입금
		107	사원근태
		108	판매원변경
		109	마감정산
		110	상품권판매
		112	중간정산
		113	준비금등록
		114	캐시비충전
		115	영업일자변경
		116	재고출력
		117	공지사항
		118	발주등록
		119	발주조회
		120	영수증관리
		121	KIOSK상품수정
		122	KIOSK점검중
	   매출현황
		301	분류별매출현황
		302	상품별매출현황
		303	결제수단별매출현황
		304	할인구분별매출현황
		305	월별매출현황
		306	정산현황
		307	시간대별매출현황
		308	영수증별매출현황
		309	승인현황
     **/ 
    this.adminMenuEmpAuthYn = function(paFkNo, paPwd){
    	var queryResult = gfn_SQLiteSQLProcess(adminSql.selectAdminMenuEmpAuthPwd, [gShopCd, paFkNo, paPwd]).Data;
    	util.logInfo("***** 화면 비밀번호 권한 쿼리.=====> " + adminSql.selectAdminMenuEmpAuth);
    	util.logInfo("***** 화면 비밀번호 권한 쿼리 파라미터.=====> " + gShopCd + ", " + paFkNo + ", " + paPwd);
        if(queryResult && queryResult.length > 0){
            var vsCnt = queryResult[0].CNT;
            util.logInfo("***** 화면 비밀번호 권한 쿼리결과.=====> " + vsCnt);
            if(Number(vsCnt) > 0){
            	return true;
            }else{
            	return false;
            }
        }else{
        	util.logInfo("***** 화면 비밀번호 권한 쿼리 데이터 없음. *****");
        	return false;
        }
    }
    
    /**
     * 무인로봇에 주문내역 보내기 위한 webSocket함수 정의
     * paUrl : 접속 URL
     */
    this.fnWebSocket = function(paUrl)
    {
    	util.logInfo("_____웹소켓 통신 init_____")
    	//var socket = new WebSocket("ws://192.168.0.52:5000/");
    	gWebSocket = new WebSocket(paUrl);
    	gWebSocket.onopen = function(e) {
    		util.onOpenWebSocket(e)
    	}
    	gWebSocket.onclose = function(e) {
    		util.onCloseWebSocket(e)
    	}
    	gWebSocket.onmessage = function(e) {
    		util.onMessageWebSocket(e)
    	}
    	
    	gWebSocket.onerror = function(e) {
    		util.onErrorWebSocket(e)
    	}    	
    }
    
    /**
     * fnWebSocket 함수에서 사용되는 접속 성공시에 함수.
     * e : 이벤트객체
     */
    this.onOpenWebSocket = function(e)
    {
    	alert("웹소켓 오픈 이벤트 e == >> " + e);
    }
    
    /**
     * fnWebSocket 함수에서 사용되는 접속 종료시에 함수.
     * e : 이벤트객체
     */
    this.onCloseWebSocket = function(e)
    {
    	alert("웹소켓 close 이벤트 e == >> " + e);
    }
    
    /**
     * fnWebSocket 함수에서 사용되는 메시지처리 함수.
     * e : 이벤트객체
     */
    this.onMessageWebSocket = function(e)
    {
    	alert("웹소켓 onMessage 이벤트 e == >> " + e);
    	gWebSocket.onclose();
    	
    }
    
    /**
     * fnWebSocket에서 함수에서 사용되는 에러 함수.
     * e : 이벤트객체
     */
    this.onErrorWebSocket = function(e)
    {
    	alert("웹소켓 error 이벤트 e == >> " + e);
    }
    
    /**
     * fnWebSocket에서 접속 성공시에 함수.
     * e : 이벤트객체
     */
    this.webSocketDoSend = function(data)
    {
    	util.waitForConnection(function(){
    		data = JSON.stringify(data);
    		gWebSocket.send(data);
    		if(typeof callback !== 'undefined'){
    			callback();
    		}
    	}, 1000)
    		
//    	debugger;
//    	//data = JSON.stringify(data);
//    	//alert("doSend data == >> " + data);
//    	try{
//    		
//    	}catch(e){
//    		debugger;
//    	}
    	
    }
    var gsSocketTimeId = "";
    /**
     * fnWebSocket에서 접속 성공시에 함수.
     * e : 이벤트객체
     */
    this.waitForConnection = function(callback, interval)
    {
    	/** 0	CONNECTING	소켓이 생성되었다. 연결이 아직 열려 있지 않다.
    	 *  1	OPEN	연결이 열려 있고, 통신할 준비가 되었다.
    	 *  2	CLOSING	연결이 닫히는 중이다.
    	 *  3	CLOSED	연결이 닫혔거나 열 수 없었다.
    	**/
    	util.logInfo("소켓통신 send readyDtate 체크 == > " + gWebSocket.readyState);
    	if(gWebSocket.readyState === 1){
    		clearTimeout(gsSocketTimeId);
    		callback();
    	}else{
    		if(gWebSocket.readyState === 0){
    			gsSocketTimeId = setTimeout(function(){
        			util.waitForConnection(callback,interval);
        		}, interval);
    		}    		
    	}
    	
    	
    }
    
    /**
     * 주문 상품에서 수량만 더해서 총 개수 가져오기
     * paOrderList : 현재 선택한 리스트
     */
    this.fnOrderQtySum = function(paOrderList)
    {
    	var vnResultCnt = 0;
    	if(paOrderList == undefined || !paOrderList || paOrderList.length == 0){
    		return vnResultCnt;
    	}
    	
    	for(var i=0; i<paOrderList.length; i++){
    		var voData = paOrderList[i];
    		vnResultCnt += Number(voData.ORDER_QTY);
    	}
    	
    	return vnResultCnt;
    	
    }
    
    /**
    * Javascript에서 문자열 길이를 체크할때, 그냥 length를 사용하면
    * 1Byte인 영문, 숫자 입력시엔 상관없지만
    * 한글 '가' 입력시에도 length 값은 1로 나온다.
    * 아래 스크립트는 escape() 함수를 이용해 입력받은 값이 한글인지 판단 후 글자수를 2byte로 계산해준다.
    */
    
    this.getTextLength = function(str) {
        var len = 0;
        for (var i = 0; i < str.length; i++) {
            if (escape(str.charAt(i)).length == 6) {
                len++;
            }
            len++;
        }
        return len;
    }
    
    this.fnNetWorkCheck = function(){
    	//네이티브 네트워크 체크
        var borwserNavigator = navigator.userAgent.toUpperCase();
        
        if ( borwserNavigator.indexOf("TIZEN") != -1 ) {
        	var result = nativeApp.functionCallSync(["FDK_Server_PingCheck"]);
        	//util.logInfo('*****fnNetWorkCheck FDK_Server_PingCheck Tizen typeof result : ' + typeof result);
        	util.logInfo('*****fnNetWorkCheck FDK_Server_PingCheck Tizen result : ' + JSON.stringify(result));
        	result = JSON.parse(result.replace("$$^", ""));
        	//util.logInfo('*****fnNetWorkCheck FDK_Server_PingCheck Tizen result22 : ' + JSON.stringify(result));
            return result;
        } else {
        	var resultData = {};
            resultData.ResultCode = "0";
            resultData.Data = "OK";
            util.logInfo('*****fnNetWorkCheck FDK_Server_PingCheck No Tizen resultData : ' + JSON.stringify(resultData) );
            return resultData;
        }
    }
    
 // 컵보증금 데이터 가공
//    this.fnCupDataMng = function(row, orderList){
//    	// CUP_DEPOSIT_FG[일회용컵 보증금 선택] - 0 : 미사용, 1 : 사용여부선택, 2 : 필수
//		if(row.CUP_DEPOSIT_FG == "0"){ // 미사용인 경우 일반 프로세스 호출.
//			row.CUP_TYPE = "";
//			return util.fnCupDataMngAfter(row, orderList);
//		}else if(row.CUP_DEPOSIT_FG == "1"){ // 해당 상품이 일회용컵 보증금 설정이 '사용여부선택'이라면 컵선택하는 팝업을 호출한다.
////			eventBus.$emit('selCupPop', row); // 컵 종류 선택하는 팝업 호출.
//			eventBus.$emit("selCupPop" , row );	// 팝업에서 컵선택 후 fnCupDataMngAfter 함수 호출하도록 처리됨.	
//		}else if(row.CUP_DEPOSIT_FG == "2"){ // 1회용컵이 필수인 경우에 값
//			row.CUP_TYPE = "disposableCup"; // 일회용컵 셋팅
//			return util.fnCupDataMngAfter(row, orderList);
//		}else{ // 값이 없는 경우에 일반 프로세스 호출.
//			row.CUP_TYPE = "";
//			return util.fnCupDataMngAfter(row, orderList);
//		}				
//    }
    
    // 컵보증금 데이터 가공
    this.fnCupDataMng = function(row, orderList, totalAmount, totalAmountView){
    	util.logInfo("_____컵 보증금 데이터 가공 시작(fnCupDataMng)_____");    	
		if(!!row.CUP_TYPE){ // 상품에 컵종류가 존재하는 경우에
			util.logInfo("_____컵 보증금 데이터 가공. 컵종류 있음_____");
			let vsCupOpt = {
    				CUP_TYPE : ""
    			   ,CUP_NAME : ""
    			   ,CUP_CNT : ""
    			   ,CUP_AMT : ""
    		}
			
			if(row.CUP_TYPE == "disposableCup"){ // 일회용 컵인 경우에
				vsCupOpt.CUP_TYPE = "disposableCup";
				vsCupOpt.CUP_NAME = "1회용컵";
				vsCupOpt.CUP_CNT = "1";
				vsCupOpt.CUP_AMT = gCupUprc;
			}else if(row.CUP_TYPE == "burialCup"){ // 매장컵
				vsCupOpt.CUP_TYPE = "burialCup";
				vsCupOpt.CUP_NAME = "매장컵";
				vsCupOpt.CUP_CNT = "1";
				vsCupOpt.CUP_AMT = "0";
			}else if(row.CUP_TYPE == "personalCup"){ // 개인컵
				vsCupOpt.CUP_TYPE = "personalCup";
				vsCupOpt.CUP_NAME = "개인컵";
				vsCupOpt.CUP_CNT = "1";
				vsCupOpt.CUP_AMT = "0";
			}
			
			var flag = false;
			var vnIdx; // 현재 선택한 상품(row)와 같은 데이터를 orderList에서 찾고 그 idx를 담는다.
			
			// 사이드 메뉴가 없는 상품이라면
			if(row.SIDE_MENU_YN == "N"){
				util.logInfo("_____컵 보증금 데이터 가공. 사이드메뉴 없음_____");
				// 앞의 기능에서 선택한 상품은 이미 orderList에 담겼고, 보증금에 대해서 현재 row(선택한상품)와 같은 데이터를 orderList에서 찾아 정보를 갱신해준다.
				for ( let i = 0 ; i < orderList.length ; i++ ) {
	    			let voListObj = orderList[i];
	    			
	    			if ( voListObj.SIDE_MENU_YN == 'Y') { // 사이드 상품인 것은 스킵
        				continue;
        			}
					if ( row.PROD_CD == voListObj.PROD_CD && voListObj.SIDE_MENU_YN == 'N' && voListObj.CUP_TYPE == row.CUP_TYPE) {
						flag = true;
						vnIdx = i;                        					
					}
				}
			}else{ // 사이드 메뉴가 있을 때 
				util.logInfo("_____컵 보증금 데이터 가공. 사이드메뉴 있음_____");
				for ( let i = 0 ; i < orderList.length ; i++ ) {
        			let voListObj = orderList[i];
        			//사이드메뉴가 있는것만 비교한다.
        			if ( voListObj.SIDE_MENU_YN == 'N') { // 사이드 상품이 아닌 것은 스킵
        				continue;
        			}

        			if ( row.PROD_CD == voListObj.PROD_CD && row['사이드_중복체크값'] == voListObj['사이드_중복체크값'] && voListObj.CUP_TYPE == row.CUP_TYPE ) {
    					flag = true;
        				vnIdx = i;
        			}
        		} // for문 끝
			}
			
			
			// 같은 상품이 있을 때
			if(flag){
				util.logInfo("_____컵 보증금 데이터 가공. 선택한 상품과 동일한 상품이 존해한다._____");
				if(!orderList[vnIdx].cupList){ // cupList가 없다면 객체를 컵리스트에 담는다.
					util.logInfo("_____컵 보증금 데이터 가공. cupList가 없음 _____");
					let vsCupList = [];
					// 위에서 만든 컵 데이터를 삽입한다.
					vsCupList.push(vsCupOpt); 
					orderList[vnIdx]["cupList"] = vsCupList;
					// cupList가 없는 경우 사이드 금액에 대한 객체가 없을 것으로 0원으로 생성.
					if(!orderList[vnIdx]['CUP_DEPOSIT_UPRC_SUM']){
						orderList[vnIdx]['CUP_DEPOSIT_UPRC_SUM'] = 0;
					}						
				}else{ // 컵리스트가 있다면 컵리스트의 종류를 판단하여 합산 또는 추가한다.
					util.logInfo("_____컵 보증금 데이터 가공. cupList가 있음 _____");			
					var vsSameYn = "N";
					var vnCupListIdx = 0;											
					
					for(var j=0; j<orderList[vnIdx].cupList.length; j++){
						if(row.CUP_TYPE == orderList[vnIdx].cupList[j].CUP_TYPE){ // 컵 종류가 같은게 존재할 때
							vsSameYn = "Y";
							vnCupListIdx = j;
						}
					}
					// 같은 컵종류가 있다면 합산한다.
					if(vsSameYn == "Y"){
						// 컵 개수를 +1한다.
						orderList[vnIdx].cupList[vnCupListIdx].CUP_CNT = Number(orderList[vnIdx].cupList[vnCupListIdx].CUP_CNT) + 1;
						// 일회용 컵인 경우에 300원을 더한다.
						if(orderList[vnIdx].cupList[vnCupListIdx].CUP_TYPE == "disposableCup"){ // 일회용 컵인 경우만 300원 합산
							orderList[vnIdx].cupList[vnCupListIdx].CUP_AMT = Number(orderList[vnIdx].cupList[vnCupListIdx].CUP_AMT) + gCupUprc;  
						}
					}
//					else{ // cupList는 있지만 같은 컵종류가 없다면
//						// 위에서 만든 컵 데이터를 삽입한다.
//						orderList[vnIdx]["cupList"].push(vsCupOpt);
//					}
				}
				
				
				if(orderList[vnIdx]['CUP_TYPE'] == "disposableCup"){
					util.logInfo("_____컵 보증금 데이터 가공. 1회용 보증금 컵인 경우 진입 _____");
					// row의 CUP_DEPOSIT_UPRC_SUM컬럼에 일회용 컵보증금에 대한 금액의 합계를 넣어준다.
					orderList[vnIdx]['CUP_DEPOSIT_UPRC_SUM'] = Number(orderList[vnIdx]['CUP_DEPOSIT_UPRC_SUM']) + Number(vsCupOpt.CUP_AMT);
					orderList[vnIdx]['사이드_보증금포함_합계금액'] =  Number(orderList[vnIdx]['사이드_보증금포함_합계금액']) + Number(vsCupOpt.CUP_AMT);
					orderList[vnIdx]['사이드_보증금포함_합계금액_출력용'] = util.numberWithCommas(orderList[vnIdx]['사이드_보증금포함_합계금액']);
					return true;
				}
				return false;
			}
				
		}else{
			return false;
		}
    },
    // 톨게이트 ajax Json 통신 함수
    this.ajaxCallTollgate = function(param, targetUrl, callback){
		//isAsync, callback
    	util.logInfo("***** ajaxCallTollgate START *****");
    	
		//쿠폰조회
		var tgServerFullUrl = tgServerUrl + targetUrl ;
    	
    	if (param == null || param == undefined || param == "" ) {
			param = "";
		}
    	
//    	if ( isAsync == undefined ) {
//			isAsync = false;
//		}
    	
    	if (tgServerFullUrl == null || tgServerFullUrl == undefined || tgServerFullUrl == "" ) {
    		tgServerFullUrl = "";
		} 
    	util.logInfo("***** ajaxCallTollgate url=== >>> " + tgServerFullUrl);
    	util.logInfo("***** ajaxCallTollgate param=== >>> " + JSON.stringify(param));
    	
    	try {
    		 var result = null;
	    	 $.ajax({
	             type : "POST",
	             url: tgServerFullUrl,
	             data: JSON.stringify(param),
	             contentType: "application/json; charset=UTF-8",
	             dataType : "json",
	             timeout : 5000,
	             async: false,
	             success: function(res) {
	                 util.logInfo("***** ajaxCallTollgate Call success *****");
	                 util.logInfo("***** ajaxCallTollgate res == >> " + JSON.stringify(res));
	                 result = res;
					 if(result.resultCode == "SUCCESS"){
						 if ( typeof callback === 'function') {
							 callback(result);
						 }
					 } else {
						 //result.resultCode -> ERROR;
						 util.logInfo("***** ajaxCallTollgate 상품정보갱신 실패 == >> " + result.resultCode );
						 util.logInfo("***** ajaxCallTollgate 상품정보갱신 실패 == >> " + result.resultMessage );
						 util.logInfo("***** ajaxCallTollgate 상품정보갱신 실패 == >> " + result.verboseMessage );
					 }
	                 
	             },
	             error: function(xhr, status, error) {
	                 util.logError("ajaxCallTollgate error xhr1 == > " + JSON.stringify(xhr));
	                 util.logError("ajaxCallTollgate error status.toString == > " + status.toString());
	                 util.logError("ajaxCallTollgate error status == > " + status);
	                 util.logError("ajaxCallTollgate error == > " + error.toString());
	                 result = {};
	                 result.resultCode = "ERROR";
	             }
	         });
    	}catch(e){
    		util.logInfo("*****util ajaxCallTollgate CATCH e == > " + e.toString());
    	}
    	
    	return result;
    },
    // 톨게이트 ajax Json 통신 함수 신규
    this.ajaxCallTollgate2 = function(param, targetUrl, callback){
		//isAsync, callback
    	util.logInfo("***** ajaxCallTollgate2 START *****");
    	
		//쿠폰조회
		var tgServerFullUrl = tgServerUrl2 + targetUrl ;
    	
    	if (param == null || param == undefined || param == "" ) {
			param = "";
		}
    	
//    	if ( isAsync == undefined ) {
//			isAsync = false;
//		}
    	
    	if (tgServerFullUrl == null || tgServerFullUrl == undefined || tgServerFullUrl == "" ) {
    		tgServerFullUrl = "";
		} 
    	util.logInfo("***** ajaxCallTollgate2 url=== >>> " + tgServerFullUrl);
    	util.logInfo("***** ajaxCallTollgate2 param=== >>> " + JSON.stringify(param));
    	
    	try {
    		 var result = null;
	    	 $.ajax({
	             type : "POST",
	             url: tgServerFullUrl,
	             data: JSON.stringify(param),
	             contentType: "application/json; charset=UTF-8",
	             dataType : "json",
	             timeout : 5000,
	             async: false,
	             success: function(res) {
	                 util.logInfo("***** ajaxCallTollgate2 Call success *****");
	                 util.logInfo("***** ajaxCallTollgate2 res == >> " + JSON.stringify(res));
	                 result = res;
					 if(result.resultCode == "SUCCESS"){
						 if ( typeof callback === 'function') {
							 callback(result);
						 }
					 } else {
						 //result.resultCode -> ERROR;
						 util.logInfo("***** ajaxCallTollgate2 실패 == >> " + result.resultCode );
						 util.logInfo("***** ajaxCallTollgate2 실패 == >> " + result.resultMessage );
						 util.logInfo("***** ajaxCallTollgat2 실패 == >> " + result.verboseMessage );
						 if ( typeof callback === 'function') {
							callback(result);
						 }
					 }
	                 
	             },
	             error: function(xhr, status, error) {
	                 util.logError("ajaxCallTollgate2 error xhr1 == > " + JSON.stringify(xhr));
	                 util.logError("ajaxCallTollgate2 error status.toString == > " + status.toString());
	                 util.logError("ajaxCallTollgate2 error status == > " + status);
	                 util.logError("ajaxCallTollgate2 error == > " + error.toString());
	                 result = xhr.responseJSON;
					 util.logError("ajaxCallTollgate2 error result == > " + result);
	                 result.resultCode = "ERROR";
					 if ( typeof callback === 'function') {
						callback(result);
					 }
	             }
	         });
    	}catch(e){
    		util.logInfo("*****util ajaxCallTollgate2 CATCH e == > " + e.toString());
    	}
    	
    	return result;
    },
    
    this.makeTollgateDataFile = function(params, tType) {
		var dirPath		= netCancelPath;   
		var newFile;
		var localDate = moment().format("YYYYMMDDHHmmss");
		
		var tgSignMsg = "";
		var hash = "";
		var hashInBase64 = "";
		
		let paramObj;
		
		// 톨게이트 선불카드 데이터 파일 세팅
		if(tType == "P"){
			fileName = params.barcodeNo + "_" + localDate+".tl";
			
			//예: serviceId: "A", posStoreNo: "B"일때 plain이 serviceId + posStoreNo라면 "A:B"
			//serviceId+posStoreNo+posTerminalNo+posOrderNo+orderDate+originalPosOrderNo+originalAccountTxId+originalOrderDate+originalAmount
			//+8000 증가된 주문번호
			//moment().add(1, 'second').format("YYYYMMDDHHmmss")
			var addPosOrderNo = gShopCd + gPosNo + moment().add(3, 'second').format("YYYYMMDDHHmmss") + orderInfo.posBillNo;
			tgSignMsg = tgServiceId + ":" + gShopCd + ":" + gPosNo + ":" + addPosOrderNo + ":" + params.orderDate + ":" + params.posOrderNo
					+ ":" + params.accountTransactionId + ":" + params.accountTransactionDate + ":" + params.amount;
			
			util.logInfo("_______tgSignMsg >>" + tgSignMsg);
			hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey);
			hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
			
			paramObj = {
					serviceId : tgServiceId
					, posStoreNo : gShopCd
					, posTerminalNo : gPosNo
					, sign : hashInBase64
					, callbackParam : ""
					, additionalData : ""
					, posOrderNo : addPosOrderNo
					, orderDate : params.orderDate
					, originalPosOrderNo : params.posOrderNo
					, originalAccountTxId : params.accountTransactionId
					, originalOrderDate : params.accountTransactionDate
					, originalAmount : params.amount
					, sattlementDate : params.sattlementDate	
				};
		} else if(tType == "C"){
			// 톨게이트 쿠폰 데이터 파일 세팅
			fileName = params.barcodeNo + "_" + localDate+".tc";
			
			//예: serviceId: "A", posStoreNo: "B"일때 plain이 serviceId + posStoreNo라면 "A:B"
			//serviceId+posStoreNo+posTerminalNo+posOrderNo+orderDate+originalPosOrderNo+originalCouponTxId+originalOrderDate+originalBarcodeNo
			//+8000 증가된 주문번호
			var addPosOrderNo = gShopCd + gPosNo + moment().add(3, 'second').format("YYYYMMDDHHmmss") + orderInfo.posBillNo;
			tgSignMsg = tgServiceId + ":" + gShopCd + ":" + gPosNo + ":" + addPosOrderNo + ":" + params.orderDate + ":" + params.posOrderNo 
				+ ":" + params.couponTransactionId + ":" + params.couponTransactionDate + ":" + params.barcodeNo;
			util.logInfo("_______tgSignMsg >>" + tgSignMsg);
			hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey);
			hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
			
			paramObj = {
					serviceId : tgServiceId
					, posStoreNo : gShopCd
					, posTerminalNo : gPosNo
					, sign : hashInBase64
					, callbackParam : ""
					, additionalData : ""
					, posOrderNo : addPosOrderNo
					, orderDate : params.orderDate
					, originalPosOrderNo : params.posOrderNo
					, originalCouponTxId : params.couponTransactionId
					, originalOrderDate : params.couponTransactionDate
					, originalBarcodeNo : params.barcodeNo
					, sattlementDate : params.sattlementDate	
				};
		} else {
			// 톨게이트 스탬프취소 데이터 파일 세팅
			fileName = params.barcodeNo + "_" + localDate+".ts";
			
			//+8000 증가된 주문번호
			var addPosOrderNo = gShopCd + gPosNo + moment().add(3, 'second').format("YYYYMMDDHHmmss") + orderInfo.posBillNo;
			
			tgSignMsg = tgServiceId + ":" + gShopCd + ":" + gPosNo + ":" + addPosOrderNo + ":" + params.orderDate 
				+ ":" + params.posOrderNo + ":" + params.stampTransactionId + ":" + params.stampTransactionDate + ":" + params.stampCount;
			util.logInfo("_______tgSignMsg >>" + tgSignMsg);
			hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey); //stampCount
			hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
			
			paramObj = {
					serviceId : tgServiceId
					, posStoreNo : gShopCd
					, posTerminalNo : gPosNo
					, sign : hashInBase64
					, callbackParam : ""
					, additionalData : ""
					, posOrderNo : addPosOrderNo
					, orderDate : params.orderDate
					, originalPosOrderNo : params.posOrderNo
					, originalStampTxId : params.stampTransactionId
					, originalOrderDate : params.stampTransactionDate
					, originalStampCount : params.stampCount
					, sattlementDate : params.sattlementDate	
				};
		}
		
		if( util.isTizen() == true) {
			tizen.filesystem.resolve(dirPath, function(result) {
				util.logInfo("################### makeTollgateDataFile newFile Start #################");
				//util.logInfo("### makeTollgateDataFile text data >> " + xmlParams);
				util.logInfo("### makeTollgateDataFile fileName >> " + fileName);
				newFile = result.createFile(fileName);
				newFile.openStream(
						"rw",
						function(fs) {
							fs.write(JSON.stringify(paramObj));
							fs.close();
						}, function(e) {
							util.logError("Error " + e.message);
						}, "UTF-8");
				util.logInfo("################### makeTollgateDataFile newFile End #################");
				
			}, function(e) {
				util.logError("### makeTollgateDataFile resolve Error" + e.message);
			}, "rw" );
		}
		return fileName;
	}
    , this.calcTgStampCnt = function() {
    	let stampTotalCnt = 0;

		//적립할 스탬프 갯수 구하기
    	for(var i=0; i<orderInfo.POS_ODDTL_T.length; i++){
    		if(orderInfo.POS_ODDTL_T[i].STAMP_ACC_YN == "Y"){
    			// stampTotalCnt += parseInt(orderInfo.POS_ODDTL_T[i].STAMP_ACC_QTY) * parseInt(orderInfo.POS_ODDTL_T[i].ORDER_QTY);				
				if(orderInfo.POS_ODDTL_T[i].discountYn == "Y"){ // 쿠폰할인받은메뉴
					if(parseInt(orderInfo.POS_ODDTL_T[i].ORDER_QTY) > 1){ 
						console.log('쿠폰할인받은 메뉴가 1개이상일경우 할인받은수량 1개는 차감해주고 스템프 계산..');
						stampTotalCnt += parseInt(orderInfo.POS_ODDTL_T[i].STAMP_ACC_QTY) * (parseInt(orderInfo.POS_ODDTL_T[i].ORDER_QTY) - 1);
					}else{
						console.log('쿠폰할인받은 메뉴가 1개일경우');
					}
				}else{
					stampTotalCnt += parseInt(orderInfo.POS_ODDTL_T[i].STAMP_ACC_QTY) * parseInt(orderInfo.POS_ODDTL_T[i].ORDER_QTY);
				}
			}
    	}
    	
    	return stampTotalCnt;
    }
    , this.fnGetBillNo = function() {
    	var cbBillNoVal = localStorage.getItem("gCbBillNoVal");
    	var cbBillNo = localStorage.getItem("gCbBillNo");
    	
    	if(cbBillNoVal == null || cbBillNoVal == undefined) cbBillNoVal = true;
    	if(cbBillNo == null || cbBillNo == undefined) cbBillNo = "0001";
    	
    	var sslTrhdrBillNo;
    	
    	if(cbBillNoVal == "T"){
    		//요청할때 주문번호가 필요하기 때문에 주문번호 조회 
			var setBillNumber = util.GetEnvXmlShopENV("735");

			//getBillNo
			var sslTrhdrBillNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectBillNo, [gShopCd, saleDate, gPosNo]).Data;
            sslTrhdrBillNo = sslTrhdrBillNoResult[0].BILL_NO;

            util.logInfo("### sslTrhdrBillNo >>> " + sslTrhdrBillNo + ", setBillNumber : " + setBillNumber);

            //영수증번호 임의 채번
			if(sslTrhdrBillNo == "0001" && !util.isEmptyStr(setBillNumber) && setBillNumber > 0 ){
                sslTrhdrBillNo = setBillNumber + "0";
			}
			//gCbBillNo = sslTrhdrBillNo;
			localStorage.setItem("gCbBillNo", sslTrhdrBillNo);
    	} else {
    		sslTrhdrBillNo = String(Number(cbBillNo)+1).padding(4, "0");
    		localStorage.setItem("gCbBillNo", sslTrhdrBillNo);
    	}
    	//localStorage.removeItem("gCbBillNoVal"   ) ;
    	return sslTrhdrBillNo;
    }
    , this.fnPrintPaperCheck = function(){
    	// 프린트 용지 체크
        var borwserNavigator = navigator.userAgent.toUpperCase();
        
        if ( borwserNavigator.indexOf("TIZEN") != -1 ) {
        	
        	var prtPaterVal = util.GetEnvXmlPosENV(902);
            if ( util.byteLen(prtPaterVal) == 0 ) {
            	util.logInfo('*****fnPrintPaperCheck FDK_StatePrint prtPaterVal is null *****');
            	var resultData = {};
                resultData.ResultCode = "0";
                resultData.Data = "OK";
            	return resultData;
            }
            
        	var prtPortNo  = this.parseInt( this.GetEnvXmlPosENV( 207 ) );      // 영수프린터-포트번호
    		var prtSpeedCd = this.SetDeviceSpeedRate( this.parseInt( this.GetEnvXmlPosENV( 208 ) ) );      // 영수프린터-속도	
    		
        	var result = nativeApp.functionCallSync(["FDK_StatePrint", "/dev/ttyS" + prtPortNo.toString(), prtSpeedCd, 4]);
        	util.logInfo('*****fnPrintPaperCheck FDK_StatePrint Tizen result : ' + JSON.stringify(result));
        	result = JSON.parse(result.replace("$$^", ""));
            return result;
        } else {
        	var resultData = {};
            resultData.Code = "0";
            resultData.Data = "OK";
            util.logInfo('*****fnPrintPaperCheck FDK_StatePrint No Tizen resultData : ' + JSON.stringify(resultData) );
            return resultData;
        }
    }
    , this.SetDeviceSpeedRate = function( pinSpeedRateCd ) {
		let dwSpeedRate = 0;

		switch( this.parseInt( pinSpeedRateCd ) ) {
			case 1   : dwSpeedRate   = 4800   ; break ;
			case 2   : dwSpeedRate   = 9600   ; break ;
			case 3   : dwSpeedRate   = 14400  ; break ;
			case 4   : dwSpeedRate   = 19200  ; break ;
			case 5   : dwSpeedRate   = 38400  ; break ;
			case 6   : dwSpeedRate   = 57600  ; break ;
			case 7   : dwSpeedRate   = 115200 ; break ;
			default  : dwSpeedRate   = 0      ; break ;
		}

		return dwSpeedRate;
	}
    ,this.parseInt = function ( val ) {
		return parseInt( util.setEmptyStrDefault(val , "0" ) ) ;
	}
    , this.fnPrintBuzzerCall = function(){
    	//프린트 부저음 체크
        var borwserNavigator = navigator.userAgent.toUpperCase();
        
        if ( borwserNavigator.indexOf("TIZEN") != -1 ) {
        	var prtPortNo  = this.parseInt( this.GetEnvXmlPosENV( 207 ) );      // 영수프린터-포트번호
    		var prtSpeedCd = this.SetDeviceSpeedRate( this.parseInt( this.GetEnvXmlPosENV( 208 ) ) );      // 영수프린터-속도
    		
    		var result = {};
        	//프린터기 부저음 발생 ( 프린터 용지 씹음 / 용지 없음 / 프린터기 Error 인 경우 알람 발생) 
			var prtBuzzerVal = util.GetEnvXmlPosENV(901);
            if ( util.byteLen(prtBuzzerVal) == 0 ) { 
            	util.logInfo('*****fnPrintBuzzerCall FDK_PrinterBuzzerOFF prtBuzzerVal is null *****');
            	var resultData = {};
                resultData.ResultCode = "0";
                resultData.Data = "OK";
            	return resultData;
            }

            if(prtBuzzerVal == "0"){  //프린트 부저 미사용
            	util.logInfo('*****fnPrintBuzzerCall FDK_PrinterBuzzerOFF Tizen CALL!!! : ');
            	result = nativeApp.functionCallSync(["FDK_PrinterBuzzerOFF", "/dev/ttyS" + prtPortNo.toString(), prtSpeedCd]);
            } else { //프린트 부저 사용
            	util.logInfo('*****fnPrintBuzzerCall FDK_PrinterBuzzerON Tizen CALL!!! : ');
            	result = nativeApp.functionCallSync(["FDK_PrinterBuzzerON", "/dev/ttyS" + prtPortNo.toString(), prtSpeedCd]);
            }
    		
        	util.logInfo('*****fnPrintBuzzerCall fnPrintBuzzerCall Tizen result : ' + JSON.stringify(result));
        	result = JSON.parse(result.replace("$$^", ""));
            return result;
        } else {
        	var resultData = {};
            resultData.Code = "0";
            resultData.Data = "OK";
            util.logInfo('*****fnPrintBuzzerCall FDK_PrinterBuzzer No Tizen resultData : ' + JSON.stringify(resultData) );
            return resultData;
        }
    }
    ,
    this.dodoGetPostAjaxCall = function(param, targetUrl, isAsync, callType, phoneNum, callbackFunc) {
		//도도포인트 calltype post&get
		if (param == null || param == undefined || param == "" ) {
			param = "";
		} 
		if ( isAsync == undefined ) {
			isAsync = false;
		}
		if (targetUrl == null || targetUrl == undefined || targetUrl == "" ) {
			targetUrl = "";
		} 
		
		var result = null;
		//console.log('request ajax call url : ' + url + ' ( full url : ' + (aspurl +  url) + ' )' , ' -> ajax callback function is ' , fnc_callback );
		//callType = "GET";
		
		if(targetUrl != null && targetUrl !=""){
			targetUrl = targetUrl + "/";
		}
		//var fullUrl = "https://point-api-v1.spoqa.com/1637d6c5-5bc9-11eb-83ac-0a58a9feac2a/customers/010-9170-4686/";
		var fullUrl = dodoUrl + dodoUuid + "/customers/" + phoneNum + "/" + targetUrl;
        //var headers = {"X-Credential-Id": xId, "X-Credential-Secret": xSecret, "Content-Type":"application/json"};
        var headers = {"X-Credential-Id": xId, "X-Credential-Secret": xSecret, "Content-Type":"application/json"};
        //var headers = {"Content-Type":"application/json", "Access-Control-Allow-Origin": "*", "Access-Control-Allow-Headers":"*", "Access-Control-Allow-Method":"PUT, GET, POST, DELETE, OPTIONS"};
        
        //util.logInfo('+++++++++++++++++++++++++ dodoGetPostAjaxCall ajax call fullUrl ('+ fullUrl +') ');
        util.logInfo('+++++++++++++++++++++++++ dodoGetPostAjaxCall ajax call callType ('+ callType +') ');
        
        try {
			$.ajax({
	            type : callType,
	            url : fullUrl,
	            data: JSON.stringify(param),
	            dataType : 'json',
	            headers : headers,
	            async: isAsync,
	            success: function(res) {
	            	util.logInfo('성공 ==' + JSON.stringify(res));
	            	//console.log('typeof' + typeof res);
	            	result = res;
	            	if ( typeof callbackFunc === 'function') {
	            		callbackFunc(result);
					}
	            },
	            error: function(xhr, status, error) {
	            	result = xhr.responseJSON;
	            	util.logInfo('실패 - ', xhr);
	            	util.logError("xhr1 == > " + JSON.stringify(xhr));
	            	util.logError("status.toString == > " + status.toString());
	            	util.logError("status == > " + status);
	            	util.logError("error == > " + error.toString());
	            	
	            	var errorObj = { e : error, status : status.toString() };
	            	if ( typeof callbackFunc === 'function') {
	            		callbackFunc(result);
					}
	            }
	        });
        } catch (e) {
        	util.logInfo('+++++++++++++++++++++++++ dodoGetPostAjaxCall ajax call critical catch('+ fullUrl +') ' + e  );
			throw e;
		}	
	
		return result;
	}, 
	
	this.dodoPutAjaxCall = function(param, fullUrl, isAsync, callType) {
		//도도포인트 calltype put
		if (param == null || param == undefined || param == "" ) {
			param = "";
		} 
		if ( isAsync == undefined ) {
			isAsync = false;
		}
		
		var result = null;
		
		var headers = {"X-Credential-Id": xId, "X-Credential-Secret": xSecret, "Content-Type":"application/json"};
        
		util.logInfo('+++++++++++++++++++++++++ dodoPutAjaxCall ajax call fullUrl ('+ fullUrl +') ');

		try {
			$.ajax({
	            type : callType,
	            url: fullUrl,
	            data: JSON.stringify(param),
	            dataType : 'json',
	            headers : headers,
	            async: isAsync,
	            success: function(res) {
	            	util.logInfo('성공 ==' + JSON.stringify(res));
	            	//console.log('typeof' + typeof res);
	            	result = res;
	            },
	            error: function(xhr) {
	            	result = xhr.responseJSON;
	            	util.logError('실패 - ', xhr);
	            }
	        });
			
		} catch (e) {
			util.logInfo('+++++++++++++++++++++++++ dodoPutAjaxCall ajax call critical catch('+ url +') ' + e  );
			throw e;
		}
	
		return result;
	}, 
	
	this.barodaAjaxCall = function(param, isAsync, callType, barodaUrlType, callbackFunc) {
		
		if (param == null || param == undefined || param == "" ) {
			param = "";
		} 
		
		if ( isAsync == undefined ) {
			isAsync = false;
		}
		
		var result = null;
		
		var fullUrl = barodaUrl + barodaUrlType;
		var headers = {"Authorization": "Bearer " + barodaToken, "Content-Type":"application/json"};
        
		if(param.phoneNumber === undefined ) {
			util.logInfo('+++++++++++++++++++++++++ barodaAjaxCall ajax param ('+ JSON.stringify(param) +') ');
		} else {
			util.logInfo('+++++++++++++++++++++++++ barodaAjaxCall ajax param data has phone number!!!!!!!');
        	util.logInfo('barodaAjaxCall ajax param phoneNumber == ' + param.phoneNumber.substring(param.phoneNumber.length-4));
		}
		util.logInfo('+++++++++++++++++++++++++ barodaAjaxCall ajax call fullUrl ('+ fullUrl +') ');
		
		let params;
		
		if(callType != "GET") {
			params = JSON.stringify(param);
		} else {
			params = param;
		}
		
		try {
			$.ajax({
	            type : callType,
	            url : fullUrl,
	            data: params,
	            dataType : 'json',
	            headers : headers,
	            async: isAsync,
	            success: function(res) {
	            	if(barodaUrlType != '/api/subscribe' ) {
	            		util.logInfo('barodaAjaxCall 성공 ==' + JSON.stringify(res));
	            	} else {
	            		var outputRes = util.clone(res);

						if(outputRes !== null && outputRes.result !== null){
							delete outputRes.result.phoneNumber;
						}
	            		util.logInfo('barodaAjaxCall 성공 구독권 조회인 경우 ==' + JSON.stringify(outputRes));
	            	}
	            	//console.log('typeof' + typeof res);
	            	result = res;
	            	if ( typeof callbackFunc === 'function') {
	            		callbackFunc(result);
					}
	            },
	            error: function(xhr, status, error) {
	            	result = xhr.responseJSON;
	            	util.logInfo('barodaAjaxCall 실패 - ', xhr);
	            	util.logError("xhr1 == > " + JSON.stringify(xhr));
	            	util.logError("status.toString == > " + status.toString());
	            	util.logError("status == > " + status);
	            	util.logError("error == > " + error.toString());
	            	
	            	var errorObj = { e : error, status : status.toString() };
	            	if ( typeof callbackFunc === 'function') {
	            		callbackFunc(result);
					}
	            }
	        });
			
		} catch (e) {
			util.logInfo('+++++++++++++++++++++++++ barodaAjaxCall ajax call critical catch('+ fullUrl +') ' + e  );
			throw e;
		}
	
		return result;
	},
	
	this.superConAjaxCall = function(param, isAsync, superconUrlType, callbackFunc) {
		
		if (param == null || param == undefined || param == "" ) {
			param = "";
		} 
		
		if ( isAsync == undefined ) {
			isAsync = false;
		}
		
		var result = null;
		
		util.logInfo('+++++++++++++++++++++++++ superConAjaxCall ajax superconUrl ('+ superconUrl +') ');
		var fullUrl = superconUrl + superconUrlType;
        
		util.logInfo('+++++++++++++++++++++++++ superConAjaxCall ajax param ('+ JSON.stringify(param) +') ');
		util.logInfo('+++++++++++++++++++++++++ superConAjaxCall ajax call fullUrl ('+ fullUrl +') ');
		
		try {
			$.ajax({
	            type : "POST",
	            url : fullUrl,
	            data: JSON.stringify(param),
	            dataType : 'json',
	            contentType:"application/json; charset=UTF-8",
	            async: isAsync,
	            success: function(res) {
	            	util.logInfo('superConAjaxCall 성공 ==' + JSON.stringify(res));
	            	result = res;
	            	if ( typeof callbackFunc === 'function') {
	            		callbackFunc(result);
					}
	            },
	            error: function(xhr, status, error) {
	            	result = xhr.responseJSON;
	            	util.logInfo('superConAjaxCall 실패 - ', xhr);
	            	util.logError("xhr1 == > " + JSON.stringify(xhr));
	            	util.logError("status.toString == > " + status.toString());
	            	util.logError("status == > " + status);
	            	util.logError("error == > " + error.toString());
	            	
	            	//네트워크 오류
	            	var errorObj = { resultCode : "R999" };
	            	if ( typeof callbackFunc === 'function') {
	            		callbackFunc(errorObj);
					}
	            }
	        });
			
		} catch (e) {
			util.logInfo('+++++++++++++++++++++++++ superConAjaxCall ajax call critical catch('+ fullUrl +') ' + e  );
			throw e;
		}
	
		return result;
	},
	
	this.makeBarodaDataFile = function(params) {
		//바로다 구독신청 및 사용취소 파일 만들기
		var dirPath		= netCancelPath;   
		var newFile;
		var localDate = moment().format("YYYYMMDDHHmmss");
		
		fileName = params.subscribeNumber + "_" + localDate+".br";
		
		if( util.isTizen() == true) {
			tizen.filesystem.resolve(dirPath, function(result) {
				util.logInfo("################### makeBarodaDataFile newFile Start #################");
				//util.logInfo("### makeTollgateDataFile text data >> " + xmlParams);
				util.logInfo("### makeBarodaDataFile fileName >> " + fileName);
				newFile = result.createFile(fileName);
				newFile.openStream(
						"rw",
						function(fs) {
							fs.write(JSON.stringify(params));
							fs.close();
						}, function(e) {
							util.logError("Error " + e.message);
						}, "UTF-8");
				util.logInfo("################### makeBarodaDataFile newFile End #################");
				
			}, function(e) {
				util.logError("### makeBarodaDataFile resolve Error" + e.message);
			}, "rw" );
		}
		return fileName;
	},
	
	this.fnSuperConCancel = function() {
		let paramObj = {
			couponNo : orderInfo.SUPERCON_INFO.couponNo
			, branchId : orderInfo.SUPERCON_INFO.branchId
			, branchName : orderInfo.SUPERCON_INFO.branchName
			, partnerId : orderInfo.SUPERCON_INFO.partnerId
			, posDate : orderInfo.SUPERCON_INFO.posDate
			, posTime : orderInfo.SUPERCON_INFO.posTime
			, approvalNo : orderInfo.SUPERCON_INFO.approvalNo
			, approvalYn : "N"
			, posType : orderInfo.SUPERCON_INFO.posType
		};
		
		var tgTargetUrl = "/authapi/cancel";
		let rCancelScData = util.superConAjaxCall(paramObj, false, tgTargetUrl);
		
		if(rCancelScData.resultCode != "0000") { // 슈퍼콘 쿠폰사용실패!! 
			util.logInfo("################### fnSuperConCancel fail #################");
			eventBus.$emit('alertPopup', {message: "슈퍼콘 쿠폰 사용 취소가 실패하였습니다. 관리자에게 문의하세요."});
		} else {
			delete orderInfo.SUPERCON_INFO;
			util.logInfo("################### fnSuperConCancel success #################");
		}
	},
	
	/**
     * 연동형이고 환경설정에서 asp에서 채번하도록 설정된 경우에 asp에서 채번을 실행한다.
     * 대기화면 및 동영상 화면으로 갔을 때 orderNo를 채번하여 전역변수로 담고, 해당 값으로 결제 후 저장한다.
     * gsOrderNoAspYn : asp에서 orderNo를 채번할지 여부(환경변수 722 값)
     */
    this.getOrderNoAspNoCallBack = function() {
    	try{
    		// 연동형 체크 : 메인포스와 현재포스번호 다르고, 연동형으로 환경셋팅되어있고, mainIp가 localhost가 아닐 때
    		// asp채번으로 설정되어 있고, 연동형이라면 asp에서 채번한다. 
    		var result = false;
    		util.logInfo("*****getOrderNoAspNoCallBack START*****");
    		//util.logInfo("*****util.getOrderNoAspNoCallBack ASP START orderInfo.posOrderNo == > " + orderInfo.posOrderNo);
    		if (gsOrderNoAspYn == "0" && mainPosNo != gPosNo  && util.GetEnvXmlShopENV(528) == 0 && gMainIp != "localhost" ) {
    			let url = '/SvrApp/PS000.do' , params = {} ,  xmlParam
        		var posOrderNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectPosOrderNoMax, [gShopCd, saleDate, gPosNo]).Data ;
    			
        		var vsLastOrderNo = posOrderNoResult[0].LAST_ORDER_NO;
        		//var vsLastOrderNo = "0000";
        		util.logInfo("##### posOrderNoMax >>> " + vsLastOrderNo);
        		if(vsLastOrderNo.substr(1) == '000') {
    				//POS_ODHDR_T에 ORDER_NO가 없으면 SSL_TRHDR_T 에서 max ORDER_NO 가져온다.
    				//둘다 없을경우 포스번호 + 001로 세팅
    				posOrderNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectSslOrderNoMax, [gShopCd, saleDate, gPosNo]).Data;
    				vsLastOrderNo = posOrderNoResult[0].LAST_ORDER_NO;
    				util.logInfo("##### sslOrderNoMax >>> " + vsLastOrderNo);
    			}
    			
        		params ={"TSP-NVP" 
        				:{
        					"TXJM-FD" :{"_SRID":"PS160", "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" 
        						,	"DATA-HD":{   "_POS_NO" 	:gPosNo 
	    							, "_SHOP_CD"	: gShopCd
	    							, "_SALE_DATE"	: saleDate
	    							, "_LAST_ORDER_NO"	: vsLastOrderNo
        						}
        					}
        				}
        		};
        		var x2js = new X2JS();
        		xmlParam = x2js.json2xml_str(params);
        		util.logInfo("*****getOrderNoAspNoCallBack tlgmCall before *****" );
        		telegram.tlgmCall( XML_PI + xmlParam , url, true, function(r) {
        			
        			if(r == "error") {
						return result;
					}
        			
        			util.logInfo("*****getOrderNoAspNoCallBack tlgmCall callback *****" );
        			r = x2js.xml_str2json(r);
            		let fd = r["TSP-NVP"]["TXJM-FD"] ;//["DATA-HD"];
            		util.logDebug('PS160 - tlgmfd' + JSON.stringify( fd));    		
            		
            		if ( r == null || fd["_RETCD"] != '0000' ) {
            			util.logInfo("*****getOrderNoAspNoCallBack FAIL _RETCD NOT 0000 *****" );
            			util.logInfo("*****fn_accPoint_Popup getOrderNoAspNoCallBack fail message Start*****");
            		} else {
            			util.logInfo("*****getOrderNoAspNoCallBack Success _RETCD 0000 *****" );
            			gsOrderNo = fd["DATA-HD"]["_MAX_ORDER_NO"]; // orderNo 채번값을 전역변수에 담는다.
            			util.logInfo("*****getOrderNoAspNoCallBack gsOrderNo ==> " + gsOrderNo);    			
        				orderInfo.posOrderNo = gsOrderNo;
        				util.logInfo("*****getOrderNoAspNoCallBack NEW orderInfo.posOrderNo ==> " + orderInfo.posOrderNo);
        				result = true;
            		}
            		
            		util.logInfo("### pagmsOption >>> " + JSON.stringify(pagmsOption));
                    if (!!pagmsOption && pagmsOption.length > 0) {
                    	if(pagmsOption[0].PAG_TYPE_FG != "03" && pagmsOption[0].PAG_TYPE_FG != "51") {
                    		//진동벨 리텍 디스펜서타워형이 아닌경우 먼저 진동벨 호출
                    		util.logInfo("### go to getVibBellOption ");
                    		util.getVibBellOption(orderInfo.posOrderNo, "B");
                    	} 
                    }
                    
        		}, 1000 );
        	} else {
        		//result = true;
        		util.logInfo("*****util.getOrderNoAspNoCallBack No ASP return true*****");
        	}
    	} catch(e) {
    		// 주문하기 위한 버튼들을 enable처리한다.
    		util.logError("*****getOrderNoAspNoCallBack catch e => " + e.toString());
    		//result = false;
    	}
    	//return result;
    	util.logInfo("*****getOrderNoAspNoCallBack END*****");
    },
    
    /**
     * 연동형이고 환경설정에서 asp에서 채번하도록 설정된 경우에 asp에서 채번을 실행한다.
     * 대기화면 및 동영상 화면으로 갔을 때 orderNo를 채번하여 전역변수로 담고, 해당 값으로 결제 후 저장한다.
     * gsOrderNoAspYn : asp에서 orderNo를 채번할지 여부(환경변수 722 값)
     */
    this.getOrderNoAspBeforePay = function(getOrderNoCallback) {
    	try {
    		// 연동형 체크 : 메인포스와 현재포스번호 다르고, 연동형으로 환경셋팅되어있고, mainIp가 localhost가 아닐 때
    		// asp채번으로 설정되어 있고, 연동형이라면 asp에서 채번한다. 
    		if (gsOrderNoAspYn == "0" && mainPosNo != gPosNo  && util.GetEnvXmlShopENV(528) == 0 && gMainIp != "localhost" ) {
//    		if(gsOrderNoAspYn == "0" && gbMainPosYn == false){ // asp채번으로 설정되어 있고, 연동형이라면 asp에서 채번한다.
        		util.logInfo("*****getOrderNoAspBeforePay START*****");
    			util.logInfo("*****util.getOrderNoAspBeforePay ASP START gsOrderNo == > " + gsOrderNo);
        		
        		let url = '/SvrApp/PS000.do' , params = {} ,  xmlParam
        		var posOrderNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectPosOrderNoMax, [gShopCd, saleDate, gPosNo]).Data ;
    			
        		var vsLastOrderNo = posOrderNoResult[0].LAST_ORDER_NO;
        		//var vsLastOrderNo = "0000";
        		util.logInfo("##### posOrderNoMax >>> " + vsLastOrderNo);
        		if(vsLastOrderNo.substr(1) == '000') {
    				//POS_ODHDR_T에 ORDER_NO가 없으면 SSL_TRHDR_T 에서 max ORDER_NO 가져온다.
    				//둘다 없을경우 포스번호 + 001로 세팅
    				posOrderNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectSslOrderNoMax, [gShopCd, saleDate, gPosNo]).Data;
    				vsLastOrderNo = posOrderNoResult[0].LAST_ORDER_NO;
    				util.logInfo("##### sslOrderNoMax >>> " + vsLastOrderNo);
    			}
        		
        		params ={"TSP-NVP" 
        				:{
        					"TXJM-FD" :{"_SRID":"PS160", "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" 
        						,	"DATA-HD":{   "_POS_NO" 	:gPosNo 
        							, "_SHOP_CD"	: gShopCd
        							, "_SALE_DATE"	: saleDate
        							, "_LAST_ORDER_NO"	: vsLastOrderNo
        						}
        					}
        				}
        		};
        		var x2js = new X2JS();
        		xmlParam = x2js.json2xml_str(params);
        		util.logInfo("*****getOrderNoAspBeforePay tlgmCall before *****" );
        		telegram.tlgmCall( XML_PI + xmlParam , url, true, function(r){
        			
        			if(r == "error"){
        				//orderNoAspCallback(false);
						return;
					}
        			
        			util.logInfo("*****getOrderNoAspBeforePay tlgmCall callback *****" );
        			r = x2js.xml_str2json(r);
            		let fd = r["TSP-NVP"]["TXJM-FD"] ;//["DATA-HD"];
            		util.logDebug('PS160 - tlgmfd' + JSON.stringify( fd));    		
            		
            		if ( r == null || fd["_RETCD"] != '0000' ) {
            			util.logInfo("*****getOrderNoAspBeforePay FAIL _RETCD NOT 0000 *****" );
            			orderNoAspCallback();
            		} else {
            			util.logInfo("*****getOrderNoAsp Success _RETCD 0000 *****" );
            			gsOrderNo = fd["DATA-HD"]["_MAX_ORDER_NO"]; // orderNo 채번값을 전역변수에 담는다.
            			util.logInfo("*****getOrderNoAspBeforePay get ASP gsOrderNo ==> " + gsOrderNo);    
            			orderInfo.posOrderNo = gsOrderNo;
            			util.logInfo("*****getOrderNoAspBeforePay set orderInfo.posOrderNo ==> " + orderInfo.posOrderNo);
            			getOrderNoCallback();
            		}
        		}, 1000 );
        		
        	}else{
        		util.logInfo("*****util.getOrderNoAsp No ASP return true*****");
        		getOrderNoCallback();
        	}
    	} catch(e) {
    		util.logError("*****getOrderNoAsp catch e => " + e.toString());
    		//orderNoAspCallback(false);
    	}
    	
    },

	/**
	 * KIOSK 커반 환경변수 셋팅
	 * 커반머신 상태 체크, 커반머신 URL주소, 커반음성인식적용 사용여부, 커반음성인식 URL주소
	 */
	this.bindKerbanSet = function() {
		
		util.logInfo("KIOSK 커반 환경변수 셋팅...");

		/** 커반머신 상태 체크 S*/
    	const a932 = util.GetEnvXmlPosENV(932); // KIOSK 커반머신 상태 체크 - 0 : 미사용, 1 : 사용(기본값)
		let a932Txt =  a932 == '1' ? '(사용)' : a932 == '0' ? '(미사용)' : '';		
		util.logInfo('GetEnvXmlPosENV(932) ::: '+ a932 + ' ' + a932Txt);
		if(!util.isEmptyStr(a932)){
			kerbanMsChkhFg = a932;
		}
		/** 커반머신 상태 체크 E*/
		
		/** 커반머신 URL주소 S*/
		let v_kerbanUrl = '';
    	const a933 = util.GetEnvXmlPosENV(933); // KIOSK 커반머신 URL주소 - 0 : 구주소(기본값), 1 : 신주소
		let a933Txt =  a933 == '1' ? '(신주소)' : a933 == '0' ? '(구주소)' : '';
    	util.logInfo('GetEnvXmlPosENV(933) ::: '+ a933 + ' ' + a933Txt);
		
		/*
		if(TEST_REAL_FLAG == "test"){ 
			//TEST
			if(a933 == '1'){
				kerbanUrl = 'https://newdev.baristamarco.com/';
			}
		}else if(TEST_REAL_FLAG == "real"){
			//REAL
			if(a933 == '1'){
				kerbanUrl = 'https://fiserv.baristamarco.com/';
			}
		}else if(TEST_REAL_FLAG == "debug"){
			if(a933 == '1'){
				kerbanUrl = 'https://newdev.baristamarco.com/';
			}
		}
		*/

		if(a933 == '1'){
			kerbanUrl = 'https://fiserv.baristamarco.com/';
		}

		util.logInfo('커반머신 URL주소 kerbanUrl ::: ' + kerbanUrl);
		/** 커반머신 URL주소 E*/

		/** 커반음성인식적용 사용여부판단 S*/
		const a934 = util.GetEnvXmlPosENV(934); // KIOSK 커반음성인식적용 사용여부판단 - 0 : 미사용, 1 : 사용
		if(!util.isEmptyStr(a934)){
			kerbanVoiceRecognitionFg = a934 + '';
		}
		//* /커반 음성인식 재요청 시간 셋팅 */
		if(kerbanVoiceRecognitionFg == '1'){
			kerbanVoiceRecognitionReReqTime = 3;
		}else if(kerbanVoiceRecognitionFg == '2'){
			kerbanVoiceRecognitionReReqTime = 5;
		}else if(kerbanVoiceRecognitionFg == '3'){
			kerbanVoiceRecognitionReReqTime = 7;
		}else if(kerbanVoiceRecognitionFg == '4'){
			kerbanVoiceRecognitionReReqTime = 10;
		}else if(kerbanVoiceRecognitionFg == '5'){
			kerbanVoiceRecognitionReReqTime = 15;
		}
		/** 커반음성인식적용 사용여부판단 E*/

		/** 커반음성인식 URL주소 S*/
		const a746 = util.GetEnvXmlPosENV(746); // - 기본값 :  [ * ]
		if(!util.isEmptyStr(a746) && a746 != "*"){
			kerbanVoiceRecognitionURL = a746;
		}
		util.logInfo('커반음성인식 URL주소 kerbanVoiceRecognitionURL ::: ' + kerbanVoiceRecognitionURL);
		/** 커반음성인식 URL주소 E*/
		
		
		/**  커반 할인매장여부 S**/
		// const a935 = util.GetEnvXmlPosENV(935); // 0 : 미시용, 1 : 사용
		// if(!util.isEmptyStr(a935)){
		// 	kerbanDiscountStoreYn = a935 == '0' ? 'N' : a935 == '1' ? 'Y' : 'N';
		// }
		// util.logInfo('커반 할인매장여부 kerbanDiscountStoreYn ::: ' + kerbanDiscountStoreYn);
		/**  커반 할인매장여부 E**/

	},

	// ajax Json 통신 함수 // 커반 음성인식 키오스크에 등록된 주문 정보 조회
    this.ajaxCallKerbanVoiceRecognitionReq = function(){

		console.log('kerbanVoiceRecognitionFg', kerbanVoiceRecognitionFg);
		if(kerbanVoiceRecognitionFg == '0'){
			util.logInfo("***** ajaxCallKerbanVoiceRecognitionReq >> 커반음성인식요청 Skip *****");
			var resultObj = {
				 code : 'SKIP'
				,msg : 'SKIP'
				,result : []
			}
			return resultObj;
		}

		//isAsync, callback
    	util.logInfo("***** ajaxCallKerbanVoiceRecognitionReq START *****");
    	
    	var param = {				
			"deviceId" : gShopCd,
			"posId" : gPosNo
		}
		
		//조회
		var kerbanFullUrl = kerbanVoiceRecognitionURL + "/kiosk/order" ;
    	
    	util.logInfo("***** ajaxCallKerbanVoiceRecognitionReq url=== >>> " + kerbanFullUrl);
    	util.logInfo("***** ajaxCallKerbanVoiceRecognitionReq param=== >>> " + JSON.stringify(param));

    	var resultKerban = {};
    	
    	try {
    		 
	    	 $.ajax({
	             type : "POST",
	             url: kerbanFullUrl,
	             data: JSON.stringify(param),
	             contentType: "application/json; charset=UTF-8",
				 headers: {
					"Access-Control-Allow-Origin": "*", // Required for CORS support to work
					"Access-Control-Allow-Credentials": true // Required for cookies, authorization headers with HTTPS					
				  },
				  accept: "application/json",
				 dataType : "json",
	             timeout : 5000,
	             async: false,
	             success: function(res) {
	                util.logInfo("***** ajaxCallKerbanVoiceRecognitionReq Call success *****");
					util.logInfo("***** ajaxCallKerbanVoiceRecognitionReq res == >> " + JSON.stringify(res));
					/*
						res.resultCode
						res.resultMessage
						res.verboseMessage
						res.orderCount
						res.body
							[								
								{
									deviceId
									posId
									orderId
									itemCd
									itemCount
									orderTime
								}
							]
					*/
					if(typeof res == 'object'){
						if(res.resultCode === 'SUCCESS' && res.body.length > 0){
							resultKerban.code = res.resultCode;
							resultKerban.message = res.resultMessage;
							resultKerban.result = res.body;
						}else{
							resultKerban.code = res.resultCode;
							resultKerban.message = res.resultMessage;
							resultKerban.result = null;
						}
					}else{
						resultKerban.code = "FAIL";	
						resultKerban.message = "[관리자 문의]";
						resultKerban.result = null;
					}
	                 
	                 util.logInfo("***** ajaxCallKerbanVoiceRecognitionReq == >> " + JSON.stringify(resultKerban));

	             },
	             error: function(xhr, status, error) {
	            	 util.logInfo("ajaxCallKerbanVoiceRecognitionReq error xhr1 == > " + JSON.stringify(xhr));
	                 util.logError("ajaxCallKerbanVoiceRecognitionReq error xhr1 == > " + JSON.stringify(xhr));
	                 util.logError("ajaxCallKerbanVoiceRecognitionReq error status.toString == > " + status.toString());
	                 util.logError("ajaxCallKerbanVoiceRecognitionReq error status == > " + status);
	                 util.logError("ajaxCallKerbanVoiceRecognitionReq error == > " + error.toString());
	                 
                	 if(status.toString() == "timeout" || status.toString() == "error"){                		 
						 resultKerban.message = "서버 접속 에러";					
                	 }else{
						 resultKerban.message = "서버 접속 실패";
                	 }
					 resultKerban.code = "FAIL";
                	 
                	 util.logInfo("***** ajaxCallKerbanVoiceRecognitionReq == >> " + JSON.stringify(resultKerban));

	             }
	         });
    	}catch(e){
    		util.logInfo("*****util ajaxCallKerbanVoiceRecognitionReq CATCH e == > " + e.toString());
    	}
		
    	return resultKerban;
    },

	// ajax Json 통신 함수 // 커반 음성인식 키오스크에 등록된 주문 정보 삭제
    this.ajaxCallKerbanVoiceRecognitionDel = function(param){
		
    	util.logInfo("***** ajaxCallKerbanVoiceRecognitionDel params " + JSON.stringify(param));
		// return {code : '200'};

		//isAsync, callback
    	util.logInfo("***** ajaxCallKerbanVoiceRecognitionDel START *****");
    	
    	//조회
		// param = {
		// 		deviceId : '' // 매장코드
		// 		,posId : '' // 키오스크번호
		// 		,orderId : '' // 주문번호
		// }
		//

		var kerbanFullUrl = kerbanVoiceRecognitionURL + "/kiosk/del" ;
    	
    	util.logInfo("***** ajaxCallKerbanVoiceRecognitionDel url=== >>> " + kerbanFullUrl);
    	util.logInfo("***** ajaxCallKerbanVoiceRecognitionDel param=== >>> " + JSON.stringify(param));

    	var resultKerban = {};
    	
    	try {
    		 
	    	 $.ajax({
	             type : "DELETE",
	             url: kerbanFullUrl,
	             data: JSON.stringify(param),
	             contentType: "application/json; charset=UTF-8",
	             dataType : "json",
	             timeout : 5000,
	             async: false,
	             success: function(res) {
					util.logInfo("***** ajaxCallKerbanVoiceRecognitionDel Call success *****");
					util.logInfo("***** ajaxCallKerbanVoiceRecognitionDel res == >> " + res);

					if(typeof res == 'object'){
						resultKerban.code = res.resultCode;
						resultKerban.message = res.resultMessage;
					}else{
						resultKerban.code = 'FAIL';
						resultKerban.message = '[관리자 문의]';
					}

	             },
	             error: function(xhr, status, error) {
	            	 util.logInfo("ajaxCallKerbanVoiceRecognitionDel error xhr1 == > " + JSON.stringify(xhr));
	                 util.logError("ajaxCallKerbanVoiceRecognitionDel error xhr1 == > " + JSON.stringify(xhr));
	                 util.logError("ajaxCallKerbanVoiceRecognitionDel error status.toString == > " + status.toString());
	                 util.logError("ajaxCallKerbanVoiceRecognitionDel error status == > " + status);
	                 util.logError("ajaxCallKerbanVoiceRecognitionDel error == > " + error.toString());
	                 
                	 if(status.toString() == "timeout" || status.toString() == "error"){                		 
						 resultKerban.message = "서버 접속 에러";					
                	 }else{
						 resultKerban.message = "서버 접속 실패";
                	 }

                	 resultKerban.code = 'FAIL';
                	 
                	 util.logInfo("***** ajaxCallKerbanVoiceRecognitionDel == >> " + JSON.stringify(resultKerban));
	             }
	         });
    	}catch(e){
    		util.logInfo("*****util ajaxCallKerbanVoiceRecognitionDel CATCH e == > " + e.toString());
    	}
    	return resultKerban;
    },

	this.duplicateItemCd = function(obj){

		obj = obj.sort(function (a, b) { // orderId sort...
			if(a.hasOwnProperty('orderId')){
				return a.orderId - b.orderId;
			}
		});

		// duplicate check itemCd..
		const resultArr = [ ...new Map(obj.map((obj2) => [obj2["itemCd"], obj2])).values() ];

		return resultArr;

	},

	// 페이코 반품함수
    this.fnCreditApproveRequestPayco = function(payData){
    	util.logInfo("***** util.js fnCreditApproveRequestPayco START *****");
        try
        {
			//단독사업자
			let catId = BIZ_CLS_SINGLE_CAT_ID ;

			util.logInfo('*** payco FDK_Pay_Common_Request_Refund ***');

			function creditApproveCallbackResultPayco(callbackName, result) {
				util.logInfo('__________ 페이코 반품함수 호출 후 콜백 시작 creditApproveCallbackResultPayco __________');
				util.logInfo('__________ creditApproveCallbackResultPayco  callbackName __________' + callbackName);
				util.logInfo('__________ creditApproveCallbackResultPayco  result __________' + result);
				// nativeApp.removeASyncApiListener(callbackName, this.listenerId);
				util.logInfo('*** FDK_CreditCancel START ***');
				nativeApp.functionCallSync(["FDK_CreditCancel"]); // native 수행중인것 모두 취소. (초기화)
				
				util.logInfo('*** getNativeApiResult START ***');
				var apiResult = new Array(3);
				
				try {
					result = result.substring(0, result.lastIndexOf("$$^")); 	// Eof
																				// 이후
																				// 문자는
																				// 버린다
																				// ($$^)
					var jsonResult = JSON.parse(result);
					
					apiResult[0] = parseInt(jsonResult["ResultCode"]);
					apiResult[1] = jsonResult["Data"];
					apiResult[2] = jsonResult["Message"];
				} catch (e) {
					apiResult = null;
				}

				util.logInfo("__________ 콜백 apiResult == >>  " + apiResult);
				util.logInfo("__________ 콜백 apiResult[0] == >>  " + apiResult[0]);
				
				if(apiResult != null && apiResult[0] == 0) {
					util.logInfo("__________ 콜백 정상코드로 if문 진입 __________");
					adminService.fnCallbackCancelApproval(apiResult[1], payData)
		
				}else{
					util.logError("__________ 콜백 비정상코드로 else진입 __________ ");
					adminService.fnCallbackCancelApproval(apiResult[1], payData);
		
				}
		
			}


			var Inq_ApprAmt = '';
			var userData = payData.USER_DATA;
			util.logInfo("payData.userData ===>" + userData );
			var userDataArr = userData.split("|");
			for(var i=0; userDataArr.length > i ; i++){
				var param = userDataArr[i];
				if(param.indexOf("Inq_ApprAmt") != -1){
					Inq_ApprAmt = param.substring(param.indexOf("=") + 1);
				}
			}

			this.listenerId = nativeApp.functionCallASync(["FDK_Pay_Common_Request_Refund",
														catId,
														// payData.APPR_AMT,
														Inq_ApprAmt,
														"0",
														"##T4KIOSK001",
														"1001",
														"00",
														"", 
														payData.APPR_NO,
														moment(payData.APPR_DATE, 'YYYYMMDD').format("YYMMDD"),
														payData.CARD_NO,
														1,
														"", 
														"",
														"",
														"",
														"",
														"0",
														"0",
														"NC", // 서비스구분 PAYCO 서비스
														"D2", // 전문구분 D1 - 승인
														"PC" //복합거래 구분코드 - PC로 통합
														], creditApproveCallbackResultPayco);

        }
        catch (e)
        {
			util.logInfo("***** util.fnCreditApproveRequestPayco catch e == > " + e.toString());
			nativeApp.functionCallSync(["DB_Close"]);
            // gfn_DbRollBack();
            // gfn_DbClose();
        }
    },

	// 커반 사용자 정보 조회
	this.fnKerbanGetUserInfo = function(strPhoneNo, fnKerbanGetUserInfoCallback){

		var tgSignMsg = "";
	
		var posBillNo = localStorage.getItem("gPosBillNo");

		console.log('posBillNo',posBillNo);

		var cbPosTerminalNo = gShopCd + gPosNo; 
		var cbPosOrderNo = gShopCd + gPosNo + moment().format("YYYYMMDDHHmmss") + posBillNo;

		// serviceId + posStoreNo + posTerminalNo + originalPosOrderNo
		tgSignMsg = tgServiceId + ":" + gShopCd + ":" + cbPosTerminalNo + ":" + strPhoneNo;//  + ":" + tgSecretKey;
		
		var hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey);
		var hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
		
		let paramObj = {
			serviceId : tgServiceId
			, posStoreNo : gShopCd
			, posTerminalNo : cbPosTerminalNo
			, sign : hashInBase64
			, callbackParam : ""
			, additionalData : ""
			, phoneNo : strPhoneNo
		};
		var tgTargetUrl = "/getUserInfo";
		
		var result = util.ajaxCallTollgate2(paramObj, tgTargetUrl, fnKerbanGetUserInfoCallback);
		
		console.log('result',result);

		/*
		if(result.resultCode == "ERROR") {
			//톨게이트 선불카드 조회 실패입니다. 관리자에게 문의해주세요.
			var errMsg = "사용자 조회 실패입니다. 관리자에게 문의해주세요.";
			if(!util.isEmpty(result.resultMessage)){
				errMsg = result.resultMessage;
			}
			let dataObj = {};
			dataObj.button2Show = true;
			dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm') // [ 예 ]
			dataObj.button2Func = function() {
				router.push({ path : '/start'})
			}
			dataObj.message = errMsg;	
			eventBus.$emit('alertPopupIndex', dataObj);
		}else if(result.data == null){
			var errMsg = result.resultMessage;
			let dataObj = {};
			dataObj.button2Show = true;
			dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm') // [ 예 ]
			dataObj.button2Func = function() {
				// router.push({ path : '/start'})
			}
			dataObj.message = errMsg;	
			eventBus.$emit('alertPopupIndex', dataObj);

		}
		*/

	},

	this.fnTgCouponCancel = function(){

		//쿠폰사용취소

		var sslTrhdrBillNo = orderInfo.posBillNo;
		var tgSignMsg = "";
		var orderDate = moment().format("YYYY-MM-DDTHH:mm:ss");
		var cbPosStoreNo = "KPNKIOSK" + gShopCd; 
		var cbPosTerminalNo = gShopCd + gPosNo; 
		var cbPosOrderNo = gShopCd + gPosNo + moment().format("YYYYMMDDHHmmss") + sslTrhdrBillNo;


		//serviceId+posStoreNo+posTerminalNo+posOrderNo+orderDate+originalPosOrderNo+originalCouponTxId+originalOrderDate+originalBarcodeNo	    			
		tgSignMsg = tgServiceId + ":" + gShopCd + ":" + cbPosTerminalNo + ":" + cbPosOrderNo + ":" + orderDate + ":"  
		+ orderInfo.TOLLGATE_DC_INFO.posOrderNo + ":"  + orderInfo.TOLLGATE_DC_INFO.couponTransactionId + ":"  + orderInfo.TOLLGATE_DC_INFO.orderDate + ":"  + orderInfo.TOLLGATE_DC_INFO.barcodeNo;
		
		var hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey);
		var hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
		
		let paramObj = {
			serviceId : tgServiceId
			, posStoreNo : gShopCd
			, posTerminalNo : cbPosTerminalNo
			, sign : hashInBase64
			, callbackParam : ""
			, additionalData : ""
			, posOrderNo : cbPosOrderNo
			, orderDate : orderDate
			, originalPosOrderNo : orderInfo.TOLLGATE_DC_INFO.posOrderNo
			, originalCouponTxId : orderInfo.TOLLGATE_DC_INFO.couponTransactionId
			, originalOrderDate : orderInfo.TOLLGATE_DC_INFO.orderDate
			, originalBarcodeNo : orderInfo.TOLLGATE_DC_INFO.barcodeNo
			, sattlementDate : moment().format("YYYY-MM-DD", saleDate)

		};
		
		var tgTargetUrl = "/v1/gw/pos/fdk/voidUseCoupon.do";

		var fnTgCouponCancelCallback = function(result){
			//쿠폰사용취소 콜백함수

			// 톨게이트 쿠폰정보 초기화..
			orderInfo.TOLLGATE_DC_INFO.barcodeType = '';
			orderInfo.TOLLGATE_DC_INFO.discountAmount = 0;
			orderInfo.TOLLGATE_DC_INFO.posOrderNo = '';
			orderInfo.TOLLGATE_DC_INFO.orderDate = '';
			orderInfo.TOLLGATE_DC_INFO.barcodeNo = '';
			orderInfo.TOLLGATE_DC_INFO.barcodeInputType = '';
			orderInfo.TOLLGATE_DC_INFO.productCode = '';
			orderInfo.TOLLGATE_DC_INFO.sattlementDate = '';
			orderInfo.TOLLGATE_DC_INFO.couponTransactionId = '';
			orderInfo.TOLLGATE_DC_INFO.couponTransactionDate = '';
	
			console.log(result);
			util.logInfo(result);
		}

		var result = util.ajaxCallTollgate(paramObj, tgTargetUrl, fnTgCouponCancelCallback);


	}

	

	

	
	

}

	

//tizen.filesystem.resolve(downloadPath, function(result) {
//    downloadsDir = result;
//
//    newDir = downloadsDir.createDirectory(prodImgPath);
//    //util.log("###################  productImageDownload newFile : " + JSON.stringify(newDir));
//    imagesDownload.productImageDownload(newDir.fullPath, imgList);
