var SqlQuery = function(){

    //상품대분류
    this.sqlInsertScdClslmT = "INSERT OR REPLACE INTO SCD_CLSLM_T( SHOP_CD, LCLS_CD, LCLS_NM, USE_YN, INS_DT"
        + ", UPD_DT ) "
        + " values(?, ?, ?, ?, ?,   ?)";

    //상품중분류
    this.sqlInsertScdClsmmT = "INSERT OR REPLACE INTO SCD_CLSMM_T( SHOP_CD, MCLS_CD, MCLS_NM, LCLS_CD, USE_YN"
        + ", INS_DT, UPD_DT ) "
        + " values(?, ?, ?, ?, ?,   ?, ?)";

    //상품소분류
    this.sqlInsertScdClssmT = "INSERT OR REPLACE INTO SCD_CLSSM_T( SHOP_CD, SCLS_CD, SCLS_NM, LCLS_CD, MCLS_CD"
        + ", SIZE_CLS_CD, USE_YN, INS_DT, UPD_DT ) "
        + " values(?, ?, ?, ?, ?,   ?, ?, ?, ?)";

    //상품마스터
    this.sqlInsertScdProdmT = "INSERT OR REPLACE INTO SCD_PRODM_T( SHOP_CD, PROD_CD, PROD_NM, PROD_NM_EN, IMG_URL"
        + ", IMG_DOWNLOAD_FG, KIOSK_PROD_YN, KIOSK_PROD_STATUS, LCLS_CD, MCLS_CD"
        + ", SCLS_CD, BRAND_CD, STYLE_CD, YEAR_CD, SEASON_CD"
        + ", COLOR_CD, SIZE_CD, SIZE_CLS_CD, MAP_PROD_CD, CORNER_CD"
        + ", SPLY_UPRC, TOGO_CHARGE, DBL_CHARGE, CST_ACCDC_YN, TAX_YN"
        + ", TIP_MENU_YN, ORD_PROD_YN, SALE_PROD_YN, STOCK_MGR_YN, STOCK_OUT_YN"
        + ", SIDE_MENU_YN, SDA_CLS_CD, SDS_GRP_CD, PRICE_MGR_FG, SET_PROD_FG"
        + ", DEPOSIT_FG, DEPOSIT_UPRC, ORG_PLACE_CD, VENDOR_CD, ORD_UNIT_FG"
        + ", ORD_UNIT_QTY, ORD_MIN_QTY, PRICE_CTRL_FG, USE_YN, FLOOR_PRT_YN"
        + ", INS_DT, UPD_DT, POS_PRT_YN, STAMP_ACC_YN, STAMP_ACC_QTY, STAMP_USE_YN, STAMP_USE_QTY, DESCRIPTION_DISP_YN, DESCRIPTION, DESCRIPTION_EN, TOGO_PROD_YN"
        + ", CUP_DEPOSIT_FG, CUP_FG) "
        + " values(?, ?, ?, ?, ?,  ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?"
        + ",  ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?"
        + ",  ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    //판매가
    this.sqlInsertScdPrcdyT = "INSERT OR REPLACE INTO SCD_PRCDT_T( SHOP_CD, PRC_MG_CD, PRC_MG_NM, S_DATE, E_DATE"
        + ", PROD_CD, NORMAL_UPRC, SALE_UPRC, INS_DT, UPD_DT, S_TIME, E_TIME, SHOP_TYPE_FG ) "
        + " values(?, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?)";

    //바코드
    this.sqlInsertScdBarcdT = "INSERT OR REPLACE INTO SCD_BARCD_T( SHOP_CD, BAR_CD, PROD_CD, INS_DT, UPD_DT ) "
        + " values(?, ?, ?, ?, ?)";

    //세트상품
    this.sqlInsertScdPrdstT = "INSERT OR REPLACE INTO SCD_PRDST_T( SHOP_CD, PROD_CD, SET_PROD_FG, UNIT_PROD_CD, UNIT_PROD_QTY"
        + ", UNIT_PROD_SEQ, INS_DT, UPD_DT )"
        + " values(?, ?, ?, ?, ?,  ?, ?, ?)";

    //매장 사이드메뉴 속성분류
    this.sqlInsertScdSdaclT = "INSERT OR REPLACE INTO SCD_SDACL_T( SHOP_CD, SDA_CLS_CD, SDA_CLS_NM, SDA_CLS_NM_EN, USE_YN"
        + ", INS_DT, UPD_DT, SDA_ORDER_SEQ ) "
        + " values(?, ?, ?, ?, ?,   ?, ?, ?)";

    //매장 사이드메뉴 속성코드
    this.sqlInsertScdSdacdT = "INSERT OR REPLACE INTO SCD_SDACD_T( SHOP_CD, SDA_CD, SDA_NM, SDA_NM_EN, SDA_CLS_CD "
        + ", USE_YN, INS_DT, UPD_DT, SDA_ORDER_SEQ ) "
        + " values(?, ?, ?, ?, ?,  ?, ?, ?, ?)";

    //매장 사이드메뉴 선택그룹
    this.sqlInsertScdSdsgrT = "INSERT OR REPLACE INTO SCD_SDSGR_T( SHOP_CD, SDS_GRP_CD, SDS_GRP_NM, SDS_GRP_NM_EN, USE_YN "
        + ", INS_DT, UPD_DT, SDS_ORDER_SEQ ) "
        + " values(?, ?, ?, ?, ?,  ?, ?, ?)";

    //매장 사이드메뉴 선택분류
    this.sqlInsertScdSdsclT = "INSERT OR REPLACE INTO SCD_SDSCL_T( SHOP_CD, SDS_CLS_CD, SDS_CLS_NM, SDS_CLS_NM_EN, SDS_GRP_CD "
        + ", SDS_ORDER_SEQ, USE_YN, INS_DT, UPD_DT, SDS_PROC_FG ) "
        + " values(?, ?, ?, ?, ?,  ?, ?, ?, ?, ?)";

    //매장 사이드메뉴 선택코드
    this.sqlInsertScdSdscdT = "INSERT OR REPLACE INTO SCD_SDSCD_T( SHOP_CD, SDS_CD, SDS_NM, SDS_NM_EN, SDS_CLS_CD "
        + ", PROD_CD, SDS_PROD_UPRC, USE_YN, INS_DT, UPD_DT "
        + ", SDS_ORDER_SEQ ) "
        + " values(?, ?, ?, ?, ?      , ?, ?, ?, ?, ?    , ? )";

    //상품대분류
    this.sqlDeleteScdClslmT = "DELETE FROM SCD_CLSLM_T " + " WHERE SHOP_CD = ? AND  LCLS_CD = ? ";
    //상품중분류
    this.sqlDeleteScdClsmmT = "DELETE FROM SCD_CLSMM_T " + " WHERE SHOP_CD = ? AND  MCLS_CD = ? ";
    //상품소분류
    this.sqlDeleteScdClssmT = "DELETE FROM SCD_CLSSM_T " + " WHERE SHOP_CD = ? AND  SCLS_CD = ? ";
    //상품마스터
    this.sqlDeleteScdProdmT = "DELETE FROM SCD_PRODM_T " + " WHERE SHOP_CD = ? AND  PROD_CD = ? ";
    //판매가
    this.sqlDeleteScdPrcdyT = "DELETE FROM SCD_PRCDT_T " + " WHERE SHOP_CD = ? AND  PRC_MG_CD = ? AND PROD_CD = ? ";
    //바코드
    this.sqlDeleteScdBarcdT = "DELETE FROM SCD_BARCD_T " + " WHERE SHOP_CD = ? AND  BAR_CD = ? ";
    //세트상품
    this.sqlDeleteScdPrdstT = "DELETE FROM SCD_PRDST_T " + " WHERE SHOP_CD = ? AND  PROD_CD = ? AND UNIT_PROD_CD = ? ";
    //속성분류
    this.sqlDeleteScdSdaclT = "DELETE FROM SCD_SDACL_T " + " WHERE SHOP_CD = ? AND  SDA_CLS_CD = ? ";
    //속성코드
    this.sqlDeleteScdSdacdT = "DELETE FROM SCD_SDACD_T " + " WHERE SHOP_CD = ? AND  SDA_CD = ? ";
    //선택그룹
    this.sqlDeleteScdSdsgrT = "DELETE FROM SCD_SDSGR_T " + " WHERE SHOP_CD = ? AND  SDS_GRP_CD = ? ";
    //선택분류
    this.sqlDeleteScdSdsclT = "DELETE FROM SCD_SDSCL_T " + " WHERE SHOP_CD = ? AND  SDS_CLS_CD = ? ";
    //선택코드
    this.sqlDeleteScdSdscdT = "DELETE FROM SCD_SDSCD_T " + " WHERE SHOP_CD = ? AND  SDS_CD = ? ";
    //마스터정보 저장후 결과 저장
    this.sqlInsertRecvSeqT = "INSERT OR REPLACE INTO RECV_SEQ_T (RECV_ID, REQT_ID, REQT_NM, LAST_SEQ, REQT_RM , UPD_DT ) "
                              + " VALUES ( ? , ? , ? , IFNULL(? , 0)  , ? , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') )  ";

	this.sqlInsertCcdCrdcpT = " INSERT OR REPLACE INTO CCD_CRDCP_T (".rtrim()
			  + "\n CRDCP_CD , CRDCP_NM , INS_DT , UPD_DT           ".rtrim()
			  + "\n )                                               ".rtrim()
			  + "\n VALUES (                                        ".rtrim()
			  + "\n  ? , ? , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') ".rtrim() 
			  + "\n  ) ".rtrim()
		;
	this.sqlDeleteCcdCrdcpT = "DELETE FROM CCD_CRDCP_T WHERE CRDCP_CD = ? ";
	this.sqlDeleteCcdVancmT = "DELETE FROM CCD_VANCM_T WHERE VAN_CD = ? AND  VAN_CRDCP_CD = ? ";
	//밴사별카드사정보 CCD_VANCM_T
	this.sqlInsertCcdVancmT =
		  '\n INSERT OR REPLACE INTO CCD_VANCM_T ( '.rtrim() 
		+ "\n 	  VAN_CD               ".rtrim()
		+ "\n 	, VAN_CRDCP_CD         ".rtrim()
		+ "\n	, VAN_CRDCP_NM         ".rtrim()
		+ "\n	, CRDCP_CD             ".rtrim()
		+ "\n	, INS_DT               ".rtrim()
		+ "\n	, UPD_DT               ".rtrim()
		+ "\n  )                       ".rtrim()
		+ "\n	VALUES                 ".rtrim()
		+ "\n (                        ".rtrim()
		+ "\n	? , ? , ? , ?, strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') ".rtrim() 
		+ "\n )                    ".rtrim()
		;

    /****************hjjang**************/
    //시스템-공통코드
    //시스템-공통 코드 송수신
    this.sqlInsertCcdCodemT = "INSERT OR REPLACE INTO CCD_CODEM_T( COM_CD_FG, COM_CD, COM_CD_NM, COM_CD_ITEM_01, COM_CD_ITEM_02 "
        + ", USE_COL_NM, USE_YN, INS_DT, UPD_DT ) "
        + " values(?, ?, ?, ?, ?, ?, ?, ?, ?)";
    this.sqlSelectCcdCodemT = "SELECT * FROM CCD_CODEM_T";
    this.sqlDeleteCcdCodemT = "DELETE FROM CCD_CODEM_T WHERE COM_CD_FG = ? AND COM_CD = ?";
    
    //시스템 환경설정HD
    this.sqlInsertCcdEnvhdT = "INSERT OR REPLACE INTO CCD_ENVHD_T( ENV_SET_CD, ENV_SET_NM, ENV_SET_FG, ENV_GRP_CD, USE_YN "
        + ", REMARK, INS_DT, UPD_DT ) "
        + " values(?, ?, ?, ?, ?, ?, ?, ?)";
    this.sqlSelectCcdEnvhdT = "SELECT * FROM CCD_ENVHD_T";
    this.sqlDeleteCcdEnvhdT = "DELETE FROM CCD_ENVHD_T WHERE ENV_SET_CD = ?";
    
    //시스템 환경설정DT
    this.sqlInsertCcdEnvdtT = "INSERT OR REPLACE INTO CCD_ENVDT_T( ENV_SET_CD, ENV_VAL_CD, ENV_VAL_NM, USE_YN "
        + ", INS_DT, UPD_DT ) "
        + " values(?, ?, ?, ?, ?, ?)";
    this.sqlSelectCcdEnvdtT = "SELECT * FROM CCD_ENVDT_T";
    this.sqlDeleteCcdEnvdtT = "DELETE FROM CCD_ENVDT_T WHERE ENV_SET_CD = ? AND ENV_VAL_CD = ?";

    //CCD_ENVPD_T MS04
    this.sqlInsertCcdEnvpdT = "INSERT OR REPLACE INTO CCD_ENVPD_T (                                                 ".rtrim()
    	+ "\n      OGN_CD       , CODE_CD      , CODE_LEN , PROD_SEQ_NO  , PROD_CD_YN                               ".rtrim()
    	+ "\n    , STYLE_SEQ_NO , STYLE_CD_YN  , USE_YN   , DIRECT_YN                                               ".rtrim()
    	+ "\n     ,INS_DT ,UPD_DT    	                                                                            ".rtrim()
    	+ "\n  )                                                                                                    ".rtrim()
    	+ "\n   VALUES                                                                                              ".rtrim()
    	+ "\n (                                                                                                     ".rtrim()
    	+ "\n   ? , ? , ?  , ?  , ? ,                                                                               ".rtrim()
    	+ "\n   ? , ? , ?  , ?   ,                                                                                  ".rtrim()
    	+ "\n   strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME')      , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME')  ".rtrim()
    	+ "\n )                                                                                                     ".rtrim()
    	;
    this.sqlDeleteCcdEnvpdT = "DELETE FROM CCD_ENVPD_T WHERE OGN_CD = ? AND CODE_CD =?  "; 
    
    //출력물 관리
    this.sqlInsertScdPrintT = "INSERT OR REPLACE INTO SCD_PRINT_T( SHOP_CD, PRT_CLS_CD, PRT_FORM"
        + ", INS_DT, UPD_DT ) "
        + " values(?, ?, REPLACE(? , '@CR@', CHAR(10) ), ?, ?)";
    this.sqlSelectScdPrintT = "SELECT * FROM SCD_PRINT_T";
    this.sqlDeleteScdPrintT = "DELETE FROM SCD_PRINT_T WHERE SHOP_CD = ? AND PRT_CLS_CD = ?";
    
    //POS 기능키 권한 관리
    this.sqlInsertScdPosfnT = "INSERT OR REPLACE INTO SCD_POSFN_T( SHOP_CD, EMP_FG, POS_FN_NO, POS_FN_NM, POS_FN_FG, POS_FN_LOC"
        + ", AUTH_YN, ORG_POS_FN_NO, FN_USE_YN_0, FN_USE_YN_1, IMG_FILE_NM_1, IMG_FILE_NM_2, MAIN_DISP_FG, INS_DT, UPD_DT ) "
        + " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    this.sqlSelectScdPosfnT = "SELECT * FROM SCD_POSFN_T";
    this.sqlDeleteScdPosfnT = "DELETE FROM SCD_POSFN_T WHERE SHOP_CD = ? AND EMP_FG = ? AND POS_FN_NO = ?";
    
    //매장 정보
    this.sqlInsertScdShopmT = "INSERT OR REPLACE INTO SCD_SHOPM_T( SHOP_CD, SHOP_NM, HD_SHOP_CD, SHOP_GROUP_CD, SHOP_TYPE_FG, SHOP_CLS_FG"
    	+ ", PGM_TYPE_FG, OWNER_NM, BIZ_NO, BIZ_TYPE_NM, BIZ_KIND_NM, BIZ_SHOP_NM, TEL_NO, HP_NO, FAX_NO, EMAIL_ADDR, POST_NO, ADDR"
    	+ ", ADDR_DTL, SHOP_STAT_FG, SHOP_OPEN_DATE, SYS_OPEN_DATE, SYS_CLOSE_DATE, CLS_MGR_LEVEL_FG, WARE_YN, BRAND_MGR_YN, SALEMG_MGR_YN"
    	+ ", INS_DT, UPD_DT, VAN_CORP_CD, POINT_FG, WALLET_JOIN_YN, IC_PRE_TYPE, NO_CVM_AMT )"
        + " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?,"
        +		 " ?, ?, ?, ?, ?, ?, ?, ?, ?, ?," 
        +		 " ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,"
        +		 " ?, ?, ?, ?)";
    this.sqlSelectScdShopmT = "SELECT * FROM SCD_SHOPM_T";
    this.sqlDeleteScdShopmT = "DELETE FROM SCD_SHOPM_T WHERE SHOP_CD = ?";
    
    //코너 정보
    this.sqlInsertScdShopsT = "INSERT OR REPLACE INTO SCD_SHOPS_T( SHOP_CD, CORNER_CD, CORNER_NM, OWNER_NM, BIZ_NO, TEL_NO"
    	+ ", CSH_FEE_RATE, CRD_FEE_RATE, ETC_FEE_RATE, VAN_CD, VAN_TERM_NO, CASH_VAN_CD, CASH_VAN_TERM_NO, USE_YN, INS_DT, UPD_DT"
    	+ ", VAN_SER_NO, CASH_VAN_SER_NO, VAN_CERT_YN, VAN_CERT_SDT, VAN_CERT_EDT, VAN_CERT_CNT, SEND_FG, SEND_DT"
    	+ ", WORK_INDEX, WORK_KEY, OKCBG_TERM_NO, OKCBG_SER_NO, W_KEY, CORNER_SEQ, IMG_URL, IMG_URL_FG)"
        + " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
        +		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
        +		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )"; 
    this.sqlSelectScdShopsT = "SELECT * FROM SCD_SHOPS_T";
    this.sqlDeleteScdShopsT = "DELETE FROM SCD_SHOPS_T WHERE SHOP_CD = ? AND CORNER_CD = ?";
    
  // 시스템 명칭 테이블
    this.sqlInsertScdCodemT = "INSERT OR REPLACE INTO SCD_CODEM_T( SHOP_CD, COM_CD_FG, COM_CD, COM_CD_NM, COM_CD_ITEM_01, COM_CD_ITEM_02, USE_YN, INS_DT, UPD_DT)"
        + " values(?, ?, ?, ?, ?, ?, ?, ?, ? )"; 
    this.sqlSelectScdCodemT = "SELECT * FROM SCD_CODEM_T";
    this.sqlDeleteScdCodemT = "DELETE FROM SCD_CODEM_T WHERE SHOP_CD = ? AND COM_CD = ? AND COM_CD_FG = ?";
    
    //매장 환경 정보 송수신
    this.sqlInsertScdEnvshT = "INSERT OR REPLACE INTO SCD_ENVSH_T( SHOP_CD, ENV_SET_CD, ENV_SET_VAL, USE_YN, INS_DT, UPD_DT)"
        + " values(?, ?, ?, ?, ?, ?)" 
    this.sqlSelectScdEnvshT = "SELECT * FROM SCD_ENVSH_T";
    this.sqlDeleteScdEnvshT = "DELETE FROM SCD_ENVSH_T WHERE SHOP_CD = ? AND ENV_SET_CD = ?";
    
    //주방프린터 정보 송수신 SCD_ENVKP_T
    this.sqlInsertScdEnvkpT = "INSERT OR REPLACE INTO SCD_ENVKP_T( SHOP_CD, KIT_PRT_NO, ENV_SET_CD, ENV_SET_VAL"
    	+ ", USE_YN, INS_DT, UPD_DT)"
        + " values(?, ?, ?, ?, ?, ?, ?)"; 
    this.sqlSelectScdEnvkpT = "SELECT * FROM SCD_ENVKP_T";
    this.sqlDeleteScdEnvkpT = "DELETE FROM SCD_ENVKP_T WHERE SHOP_CD = ? AND KIT_PRT_NO = ? AND ENV_SET_CD = ?";
    
    //POS 환경 정보 송수신
    this.sqlInsertScdEnvpsT = "INSERT OR REPLACE INTO SCD_ENVPS_T( SHOP_CD, POS_NO, ENV_SET_CD, ENV_SET_VAL, USE_YN"
    	+ ", MODIFY_FG, INS_DT, UPD_DT, SEND_FG, SEND_DT)"
        + " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"; 
    this.sqlSelectScdEnvpsT = "SELECT * FROM SCD_ENVPS_T";
    this.sqlDeleteScdEnvpsT = "DELETE FROM SCD_ENVPS_T WHERE SHOP_CD = ? AND POS_NO = ? AND ENV_SET_CD = ?";
    this.sqlUpdateScdEnvpsT = "UPDATE SCD_ENVPS_T SET ENV_SET_VAL = ?, UPD_DT = strftime('%Y%m%d%H%M%S', 'now', 'localtime') WHERE SHOP_CD = ?  AND ENV_SET_CD = ?"; 
    
    //사원정보
    this.sqlInsertScdEmpmsT = "INSERT OR REPLACE INTO SCD_EMPMS_T( SHOP_CD, EMP_NO, EMP_NM, EMP_PWD, EMP_FG"
    	+ ", EMP_CLASS_CD, WEB_USE_YN, USER_ID, USER_PWD, POSTING_YN, ORDER_FG, EMP_CARD_NO, TEL_NO"
    	+ ", POST_NO, ADDR, ADDR_DTL, RETIRE_FG, SMS_RECV_YN, USE_YN, INS_DT, UPD_DT" 
    	+ ")"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?)"; 
    this.sqlSelectScdEmpmsT = "SELECT * FROM SCD_EMPMS_T";
    this.sqlDeleteScdEmpmsT = "DELETE FROM SCD_EMPMS_T WHERE SHOP_CD = ? AND POS_NO = ? AND ENV_SET_CD = ?";
    
    //매장-포스마스터 
    this.sqlInsertScdPosmsT = "INSERT OR REPLACE INTO SCD_POSMS_T( SHOP_CD, POS_NO, POS_REMARK, LOCAL_DB_YN, USE_YN"
    	+ ", CRD_VAN_SEQ, CASH_VAN_SEQ, IP_ADDR, INS_DT, UPD_DT, FLOOR_NO, VAN_TERM_NO, VAN_CERT_YN, VAN_CERT_SDT"
    	+ ", VAN_CERT_EDT, VAN_CERT_CNT, SEND_FG, SEND_DT, WORK_INDEX, WORK_KEY, OCB_TERM_NO, OCB_SER_NO"
    	+ ", W_KEY, VAN_SER_NO, PM_FG" 
    	+ ")"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?)"; 
    this.sqlSelectScdPosmsT = "SELECT * FROM SCD_POSMS_T";
    this.sqlDeleteScdPosmsT = "DELETE FROM SCD_POSMS_T WHERE SHOP_CD = ? AND POS_NO = ?";
    
    //매장-외식-테이블정보 SCD_FDTBL_T
    this.sqlInsertScdFdtblT = "INSERT OR REPLACE INTO SCD_FDTBL_T( SHOP_CD, FD_TBL_CD, FD_TBL_NM, FD_CLS_CD"
    	+ ", USE_YN, INS_DT, UPD_DT)"
        + " values(?, ?, ?, ?, ?, ?, ?)"; 
    this.sqlDeleteScdFdtblT = "DELETE FROM SCD_FDTBL_T WHERE SHOP_CD = ? AND FD_TBL_CD = ?";
    
    //매장-테이블그룹관리 SCD_TBGRP_T
    this.sqlInsertScdTbgrpT = "INSERT OR REPLACE INTO SCD_TBGRP_T( SHOP_CD, TG_CD, TG_NM, TG_FG"
    	+ ", TG_BGIMAGE, TG_SORT, USE_YN, INS_DT, UPD_DT, TU_CLS_CD)"
        + " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"; 
    this.sqlDeleteScdTbgrpT = "DELETE FROM SCD_TBGRP_T WHERE SHOP_CD = ? AND TG_CD = ?";
    
    //매장-테이블그룹관리 SCD_TABLE_T
    this.sqlInsertScdTableT = "INSERT OR REPLACE INTO SCD_TABLE_T( SHOP_CD, TABLE_CD, TABLE_NM, TG_CD"
    	+ ", GROUP_CD, SEAT_NUM, X, Y, WIDTH, HEIGHT, SHAPE_FG, TABLE_FG, USE_YN, STATUS_FG"
    	+ ", LOCK_POS_NO, LOCK_FG, INS_DT, UPD_DT, CID_TEL_NO, CID_LINE_NO, NEW_CST_FG, CST_NO"
    	+ ", CST_NM, CID_CALL_DT, PKG_TBL_YN, DLV_ADDR, DLV_ADDR_DTL, DLV_PROC_FG"
    	+ ", DLV_ORDER_NO, DLV_CL_CD, DLV_CM_CD)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"; 
    this.sqlDeleteScdTableT = "DELETE FROM SCD_TABLE_T WHERE SHOP_CD = ? AND TABLE_CD = ?";
    
    //매출TR-HEADER SSL_TRHDR_T
    this.sqlInsertSslTrhdrT = "INSERT OR REPLACE INTO SSL_TRHDR_T( SHOP_CD, SALE_DATE, POS_NO, BILL_NO"
    	+ ", REGI_SEQ, SALE_YN, TOT_SALE_AMT, TOT_DC_AMT, SVC_TIP_AMT, TOT_ETC_AMT, DCM_SALE_AMT"
    	+ ", VAT_SALE_AMT, VAT_AMT, NO_VAT_SALE_AMT, NO_TAX_SALE_AMT, EXP_PAY_AMT, GST_PAY_AMT"
    	+ ", RET_PAY_AMT, CASH_AMT, CRD_CARD_AMT, WES_AMT, TK_GFT_AMT, TK_FOD_AMT, CST_POINT_AMT"
    	+ ", JCD_CARD_AMT, RFC_AMT, ETC_APPR_AMT, CST_NO, CST_CARD_NO, CST_SALE_POINT, DC_GEN_AMT"
    	+ ", DC_SVC_AMT, DC_PCD_AMT, DC_CPN_AMT, DC_CST_AMT, DC_TFD_AMT, DC_PRM_AMT, DC_CRD_AMT"
    	+ ", DC_PACK_AMT, DC_LYT_AMT, REPAY_CASH_AMT, REPAY_TK_GFT_AMT, CASH_BILL_AMT, DLV_ORDER_FG"
    	+ ", FD_TBL_CD, FD_GST_CNT_T, FD_GST_CNT_1, FD_GST_CNT_2, FD_GST_CNT_3, FD_GST_CNT_4"
    	+ ", ORG_BILL_NO, ORDER_NO, INS_DT, UPD_DT, UPD_ID, EMP_NO, SEND_FG, SEND_DT, PAY_OUT_DT"
    	+ ", CST_NM, DLV_EMP_NO, DLV_START_DT, DLV_PAYIN_EMP_NO, DLV_PAYIN_DT, NEW_DLV_ADDR_YN"
    	+ ", DLV_ADDR, DLV_ADDR_DTL, NEW_DLV_TEL_NO_YN, DLV_TEL_NO, DLV_CL_CD, DLV_CM_CD, TRAVEL_CD"
    	+ ", RSV_NO, PRE_PAY_CASH, PRE_PAY_CARD, RSV_USER_NM, RSV_USER_TEL_NO, CST_AVL_POINT" 
    	+ ", LOCAL_POINT_YN, CST_USE_POINT, CANCEL_REASON, CUP_DEPOSIT_AMT)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"; 
    this.sqlDeleteSslTrhdrT = "DELETE FROM SSL_TRHDR_T WHERE SHOP_CD = ? AND SALE_DATE = ?"
    	+ " AND POS_NO = ? AND BILL_NO = ?";
    
    //매출TR-제휴할인 SSL_TRJCD_T 
    this.sqlInsertSslTrjcdT = "INSERT OR REPLACE INTO SSL_TRJCD_T"
    	+ "( SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO"
    	+ ", SEQ_NO, REGI_SEQ, SALE_YN, VAN_CD, CORNER_CD"
    	+ ", APPR_PROC_FG, JCD_CD, JCD_TYPE_FG, JCD_PROC_FG, JCD_CARD_NO"
    	+ ", JCD_CARD_PWD, APPR_AMT, VALID_TERM, SIGN_PAD_YN, CARD_IN_FG"
    	+ ", APPR_DATE, APPR_TIME, APPR_NO, JCD_DC_AMT, JCD_OCC_POINT"
    	+ ", JCD_AVL_POINT, JCD_USE_POINT, JCD_REM_POINT, APPR_MSG, VAN_TERM_NO"
    	+ ", VAN_SLIP_NO, CRDCP_TERM_NO, ORG_APPR_DATE, ORG_APPR_NO, APPR_LOG_NO"
    	+" , INS_DT, EMP_NO, BROAD_MSG, JCD_PAY_FG, CNMK_CD"
    	+" , TEST, SEC_FLAG)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?,"
    	+         "?, ?)"; 
        
    this.sqlDeleteSslTrjcdT = "DELETE FROM SSL_TRJCD_T WHERE SHOP_CD = ? AND SALE_DATE = ? " +
    		"AND POS_NO = ? AND BILL_NO = ? AND LINE_NO = ? AND SEQ_NO = ?";
    
    //매출TR-로열티쿠폰 SSL_TRLYT_T
    this.sqlInsertSslTrlytT = "INSERT OR REPLACE INTO SSL_TRLYT_T( SHOP_CD, SALE_DATE, POS_NO, BILL_NO"
    	+ ", LINE_NO, SEQ_NO, REGI_SEQ, SALE_YN, APPR_DATE, APPR_TIME, APPR_NO, LYT_APPR_FG, LYT_CPN_INFO"
    	+ ", LYT_DC_AMT, ORG_APPR_DATE, ORG_APPR_NO, INS_DT, EMP_NO)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?)"; 
    this.sqlDeleteSslTrlytT = "DELETE FROM SSL_TRLYT_T WHERE SHOP_CD = ? AND SALE_DATE = ? " +
    		"AND POS_NO = ? AND BILL_NO = ? AND LINE_NO = ? AND SEQ_NO = ?";
    
    //매출TR-상품-DETAIL SSL_TRDTL_T
    this.sqlInsertSslTrdtlT = "INSERT OR REPLACE INTO SSL_TRDTL_T(SHOP_CD, SALE_DATE, POS_NO, BILL_NO"
    	+ ", DTL_NO, REGI_SEQ, SALE_YN, PROD_CD, PROD_TYPE_FG, CORNER_CD, CHG_BILL_NO, TAX_YN, DLV_PACK_FG"
    	+ ", PROP_CD, PROP_VAL, ORG_SALE_MG_CD, ORG_SALE_UPRC, NORMAL_UPRC, SALE_MG_CD, SALE_QTY, SALE_UPRC"
    	+ ", SALE_AMT, SALE_WEIGHT, DC_AMT, ETC_AMT, SVC_TIP_AMT, DCM_SALE_AMT, VAT_AMT, SVC_CD, TK_CPN_CD"
    	+ ", DC_AMT_GEN, DC_AMT_SVC, DC_AMT_JCD, DC_AMT_CPN, DC_AMT_CST, DC_AMT_FOD, DC_AMT_PRM, DC_AMT_CRD"
    	+ ", DC_AMT_PACK, DC_AMT_LYT, CST_SALE_POINT, CST_USE_POINT, PRM_PROC_YN, PRM_CD, PRM_SEQ, SDA_CD"
    	+ ", SDS_ORG_DTL_NO, INS_DT, EMP_NO, CUP_SALE_CNT, CUP_DEPOSIT_UPRC, CUP_FG)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+ 		  "?, ?, ?, ?, ? ,?, ?, ?, ?, ?, "
    	+		  "?, ?)"; 
    this.sqlDeleteSslTrdtlT = "DELETE FROM SSL_TRDTL_T WHERE SHOP_CD = ? AND SALE_DATE = ? " +
    	"AND POS_NO = ? AND BILL_NO = ? AND DTL_NO = ?";
    
    // SSL_TRCSH_T
    this.sqlInsertSslTrcshT = "INSERT OR REPLACE INTO SSL_TRCSH_T(SHOP_CD, SALE_DATE, POS_NO"
    	+ ", BILL_NO, LINE_NO, SEQ_NO, REGI_SEQ, SALE_YN, VAN_CD, CORNER_CD, CASH_AMT, APPR_AMT"
    	+ ", SVC_TIP_AMT, VAT_AMT, APPR_PROC_FG, APPR_IDT_TYPE, APPR_IDT_FG, CARD_IN_FG, APPR_IDT_NO"
    	+ ", APPR_DATE, APPR_TIME, APPR_NO, APPR_MSG, VAN_TERM_NO, VAN_SLIP_NO, ORG_APPR_DATE"
    	+ ", ORG_APPR_NO, APPR_LOG_NO, INS_DT, EMP_NO, EX_CD, EX_KRW, EX_EXP_AMT, EX_IN_AMT"
    	+ ", EX_RET_AMT, KR_RET_AMT, EX_PAY_AMT, KR_PAY_AMT, KR_ETC_AMT, PRE_PAY_FG, NOTICE_MSG"
    	+ ", BROAD_MSG, CNMK_CD, SEC_FLAG, VAT_SALE_AMT, NO_VAT_SALE_AMT)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+ 		  "?, ?, ?, ?, ? ,?)"; 
    this.sqlDeleteSslTrcshT = "DELETE FROM SSL_TRCSH_T WHERE SHOP_CD = ? AND SALE_DATE = ? " +
    	"AND POS_NO = ? AND BILL_NO = ? AND LINE_NO = ? AND SEQ_NO = ?";
    
    //매출TR-신용카드 SSL_TRCRD_T
    this.sqlInsertSslTrcrdT = "INSERT OR REPLACE INTO SSL_TRCRD_T(SHOP_CD, SALE_DATE, POS_NO, BILL_NO"
    	+ ", LINE_NO, SEQ_NO, REGI_SEQ, SALE_YN, VAN_CD, CORNER_CD, APPR_PROC_FG, CRD_CARD_NO"
    	+ ", APPR_REQ_AMT, SVC_TIP_AMT, VAT_AMT, INST_MM_FG, INST_MM_CNT, VALID_TERM, SIGN_PAD_YN"
    	+ ", CARD_IN_FG, APPR_DATE, APPR_TIME, APPR_NO, CRDCP_CD, ISS_CRDCP_CD, ISS_CRDCP_NM"
    	+ ", PUR_CRDCP_CD, PUR_CRDCP_NM, APPR_AMT, APPR_DC_AMT, APPR_MSG, VAN_TERM_NO, VAN_SLIP_NO"
    	+ ", CRDCP_TERM_NO, ORG_APPR_DATE, ORG_APPR_NO, APPR_LOG_NO, INS_DT, EMP_NO, PRE_PAY_FG"
    	+ ", LYT_APPR_FG, LYT_APPR_INFO, GIFT_CASH, NOTICE_MSG, BROAD_MSG, CNMK_CD, UNION_PAY_FG"
    	+ ", DDC_FLAG, SEC_FLAG, VAT_SALE_AMT, NO_VAT_SALE_AMT)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+ 		  "?)";
    this.sqlDeleteSslTrcrdT = "DELETE FROM SSL_TRCRD_T WHERE SHOP_CD = ? AND SALE_DATE = ? " +
    	"AND POS_NO = ? AND BILL_NO = ? AND LINE_NO = ? AND SEQ_NO = ?";
    
    //매출TR-결제순서 SSL_TRPSQ_T
    this.sqlInsertSslTrpsqT = "INSERT OR REPLACE INTO SSL_TRPSQ_T(SHOP_CD, SALE_DATE, POS_NO, BILL_NO"
    	+ ", PAY_SEQ_NO, REGI_SEQ, SALE_YN, PAY_TYPE_FG, PAY_AMT, LINE_NO, INS_DT, UPD_DT, EMP_NO)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+ 		  "?, ?, ?)";
    this.sqlDeleteSslTrpsqT = "DELETE FROM SSL_TRPSQ_T WHERE SHOP_CD = ? AND SALE_DATE = ? " +
    	"AND POS_NO = ? AND BILL_NO = ? AND PAY_SEQ_NO = ?";

    
    //매출TR-회원포인트결제 SSL_TRCST_T
    this.sqlInsertSslTrcstT = "INSERT OR REPLACE INTO SSL_TRCST_T(SHOP_CD, SALE_DATE, POS_NO, BILL_NO"
    	+ ", LINE_NO, REGI_SEQ, SALE_YN, CST_NO, CST_CARD_NO, CST_CLS_CD, CST_USE_POINT, INS_DT"
    	+ ", EMP_NO, CST_USE_AMT, CORNER_CD, SEQ_NO)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+ 		  "?, ?, ?, ?, ?, ?)";
    this.sqlDeleteSslTrcstT = "DELETE FROM SSL_TRCST_T WHERE SHOP_CD = ? AND SALE_DATE = ? " +
    	"AND POS_NO = ? AND BILL_NO = ? AND LINE_NO = ? AND SEQ_NO = ?";
    
    //SSL_TRGFT_T
    this.sqlInsertSslTrgftT = "INSERT OR REPLACE INTO SSL_TRGFT_T(SHOP_CD, SALE_DATE, POS_NO, BILL_NO"
    	+ ", LINE_NO, REGI_SEQ, SALE_YN, TK_GFT_UAMT, TK_GFT_AMT, REPAY_CSH_AMT, REPAY_GFT_AMT"
    	+ ", INS_DT, EMP_NO)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+ 		  "?, ?, ?)";
    this.sqlDeleteSslTrgftT = "DELETE FROM SSL_TRGFT_T WHERE SHOP_CD = ? AND SALE_DATE = ? " +
    	"AND POS_NO = ? AND BILL_NO = ? AND LINE_NO = ?";
    
    //SSL_TRWES_T
    this.sqlInsertSslTrwesT = "INSERT OR REPLACE INTO SSL_TRWES_T(SHOP_CD, SALE_DATE, POS_NO, BILL_NO"
    	+ ", LINE_NO, REGI_SEQ, SALE_YN, WES_CST_NO, WES_AMT, WES_REMARK, INS_DT, EMP_NO, WES_FG)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+ 		  "?, ?, ?)";
    this.sqlDeleteSslTrwesT = "DELETE FROM SSL_TRWES_T WHERE SHOP_CD = ? AND SALE_DATE = ? " +
    	"AND POS_NO = ? AND BILL_NO = ? AND LINE_NO = ?";
    
    //매출TR-객층관리 SSL_TRGST_T 
    this.sqlInsertSslTrgstT = "INSERT OR REPLACE INTO SSL_TRGST_T(SHOP_CD, SALE_DATE, POS_NO, BILL_NO"
    	+ ", LINE_NO, REGI_SEQ, SALE_YN, FD_GST_CLS_1, FD_GST_CLS_2, FD_GST_CNT, INS_DT, EMP_NO)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+ 		  "?, ?)";
    this.sqlDeleteSslTrgstT = "DELETE FROM SSL_TRGST_T WHERE SHOP_CD = ? AND SALE_DATE = ? " +
    	"AND POS_NO = ? AND BILL_NO = ? AND LINE_NO = ?";
    
    //SSL_TRFOD_T  
    this.sqlInsertSslTrfodT = "INSERT OR REPLACE INTO SSL_TRFOD_T(SHOP_CD, SALE_DATE, POS_NO, BILL_NO"
    	+ ", LINE_NO, REGI_SEQ, SALE_YN, TK_FOD_UAMT, TK_FOD_AMT, TK_FOD_DC_AMT, ETC_AMT, INS_DT, EMP_NO)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+ 		  "?, ?, ?)";
    this.sqlDeleteSslTrfodT = "DELETE FROM SSL_TRFOD_T WHERE SHOP_CD = ? AND SALE_DATE = ? " +
    	"AND POS_NO = ? AND BILL_NO = ? AND LINE_NO = ?";
    
    //SCD_PRTMS_T  
    this.sqlInsertScdPrtmsT = "INSERT OR REPLACE INTO SCD_PRTMS_T(SHOP_CD, PRT_NO, PRT_NM, POS_NO, PRT_TYPE_FG"
    	+ ", PRT_PORT, PRT_SPEED, USE_YN, INS_DT, UPD_DT, PRT_PAPER_QTY, FLOOR_NO, FLOOR_FG)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+ 		  "?, ?, ?)";
    this.sqlDeleteScdPrtmsT = "DELETE FROM SCD_PRTMS_T WHERE SHOP_CD = ? AND PRT_NO = ? ";
    
    //SCD_PRTPR_T   
    this.sqlInsertScdPrtprT = "INSERT OR REPLACE INTO SCD_PRTPR_T(SHOP_CD, PROD_CD, PRT_NO, USE_YN, INS_DT, UPD_DT)"
    	+ " values(?, ?, ?, ?, ?, ?)";
    this.sqlDeleteScdPrtprT = "DELETE FROM SCD_PRTPR_T WHERE SHOP_CD = ? AND PROD_CD = ? AND PRT_NO = ? ";

    //POS_REGIS_T 
    this.sqlInsertPosRegisT = "INSERT OR REPLACE INTO POS_REGIS_T(SHOP_CD, SALE_DATE, POS_NO, REGI_SEQ, EMP_NO"
    	+ ", CLOSE_FG, OPEN_DT, CLOSE_DT, TOT_BILL_CNT, TOT_SALE_AMT, TOT_DC_AMT, SVC_TIP_AMT, TOT_ETC_AMT"
    	+ ", DCM_SALE_AMT, VAT_SALE_AMT, VAT_AMT, NO_VAT_SALE_AMT, NO_TAX_SALE_AMT, RET_BILL_CNT, RET_BILL_AMT"
    	+ ", VISIT_CST_CNT, POS_READY_AMT, POS_CSH_IN_AMT, POS_CSH_OUT_AMT, WEA_IN_CSH_AMT, WEA_IN_CRD_AMT"
    	+ ", TK_GFT_SALE_CSH_AMT, TK_GFT_SALE_CRD_AMT, TK_FOD_SALE_CSH_AMT, TK_FOD_SALE_CRD_AMT, CASH_CNT"
    	+ ", CASH_AMT, CASH_BILL_CNT, CASH_BILL_AMT, CRD_CARD_CNT, CRD_CARD_AMT, WES_CNT, WES_AMT, TK_GFT_CNT"
    	+ ", TK_GFT_AMT, TK_FOD_CNT, TK_FOD_AMT, CST_POINT_CNT, CST_POINT_AMT, JCD_CARD_CNT, JCD_CARD_AMT"
    	+ ", RFC_CNT, RFC_AMT, ETC_APPR_CNT, ETC_APPR_AMT, DC_GEN_CNT, DC_GEN_AMT, DC_SVC_CNT, DC_SVC_AMT"
    	+ ", DC_JCD_CNT, DC_JCD_AMT, DC_CPN_CNT, DC_CPN_AMT, DC_CST_CNT, DC_CST_AMT, DC_TFD_CNT, DC_TFD_AMT"
    	+ ", DC_PRM_CNT, DC_PRM_AMT, DC_CRD_CNT, DC_CRD_AMT, DC_PACK_CNT, DC_PACK_AMT, REM_CHECK_CNT, REM_CHECK_AMT"
    	+ ", REM_W100000_CNT, REM_W50000_CNT, REM_W10000_CNT, REM_W5000_CNT, REM_W1000_CNT, REM_W500_CNT"
    	+ ", REM_W100_CNT, REM_W50_CNT, REM_W10_CNT, REM_CASH_AMT, REM_TK_GFT_CNT, REM_TK_GFT_AMT, REM_TK_FOD_CNT"
    	+ ", REM_TK_FOD_AMT, ETC_TK_FOD_AMT, LOSS_CASH_AMT, LOSS_TK_GFT_AMT, LOSS_TK_FOD_AMT, REPAY_CASH_CNT"
    	+ ", REPAY_CASH_AMT, REPAY_TK_GFT_CNT, REPAY_TK_GFT_AMT, INS_DT, SEND_FG, SEND_DT)"
    	+ " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+ 		  "?, ?, ?, ?, ?)";
    this.sqlDeletePosRegisT = "DELETE FROM POS_REGIS_T WHERE SHOP_CD = ? AND SALE_DATE = ? " +
    	"AND POS_NO = ? AND REGI_SEQ = ?";
    
    this.sqlSelectSslTrhdrT = " SELECT SHOP_CD, SALE_DATE, POS_NO, BILL_NO, ifnull(REGI_SEQ, '01') AS REGI_SEQ"
		+ ", SALE_YN, TOT_SALE_AMT, TOT_DC_AMT, SVC_TIP_AMT, TOT_ETC_AMT" 
		+ ", DCM_SALE_AMT, VAT_SALE_AMT, VAT_AMT, NO_VAT_SALE_AMT, NO_TAX_SALE_AMT" 
		+ ", EXP_PAY_AMT, GST_PAY_AMT, RET_PAY_AMT, CASH_AMT, CRD_CARD_AMT, WES_AMT" 
		+ ", TK_GFT_AMT, TK_FOD_AMT, CST_POINT_AMT, JCD_CARD_AMT, CST_SALE_POINT"
		+ ", DC_GEN_AMT, DC_SVC_AMT, DC_PCD_AMT, DC_CPN_AMT, DC_CST_AMT, DC_TFD_AMT"
		+ ", DC_PRM_AMT, DC_CRD_AMT, DC_PACK_AMT, ifnull(PRE_PAY_CARD, '0') AS PRE_PAY_CARD"
		+ ", ifnull(PRE_PAY_CASH, '0') AS PRE_PAY_CASH"
		+ ", ifnull(REPAY_CASH_AMT, '0') AS REPAY_CASH_AMT"
		+ ", ifnull(REPAY_TK_GFT_AMT, '0') AS REPAY_TK_GFT_AMT, CASH_BILL_AMT, DLV_ORDER_FG"
		+ ", ifnull(FD_TBL_CD, '000') AS FD_TBL_CD"
		+ ", ifnull(FD_GST_CNT_T, '0') AS FD_GST_CNT_T"
		+ ", ifnull(FD_GST_CNT_1, '0') AS FD_GST_CNT_1"
		+ ", ifnull(FD_GST_CNT_2, '0') AS FD_GST_CNT_2"
		+ ", ifnull(FD_GST_CNT_3, '0') AS FD_GST_CNT_3"
		+ ", ifnull(FD_GST_CNT_4, '0') AS FD_GST_CNT_4, ORG_BILL_NO"
		+ ", ifnull(CST_CARD_NO, '') AS CST_CARD_NO, ifnull(CST_NM, '') AS CST_NM"
		+ ", ifnull(CST_NO, '') AS CST_NO, ifnull(ORDER_NO, '000') AS ORDER_NO"
		+ ", INS_DT, ifnull(EMP_NO, '0000') AS EMP_NO, PAY_OUT_DT"
		+ ", ifnull(CST_USE_POINT, '0') AS CST_USE_POINT"
		+ ", ifnull(CST_AVL_POINT, '0') AS CST_AVL_POINT"
		+ ", ifnull(LOCAL_POINT_YN, 'N') AS LOCAL_POINT_YN"
		+ ", ifnull(CANCEL_REASON, '') AS CANCEL_REASON"
		+ ", ifnull(ETC_APPR_AMT, '0') AS ETC_APPR_AMT"
		+ ", ifnull(CUP_DEPOSIT_AMT, '0') AS CUP_DEPOSIT_AMT"
		+ " FROM SSL_TRHDR_T WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? "; // 전송을 위한 데이터 조회.
	
	this.sqlSelectSslTrdtlT = "SELECT DTL_NO, ifnull(REGI_SEQ, '01') AS REGI_SEQ, SALE_YN"
		+ ", PROD_CD, PROD_TYPE_FG, ifnull(CORNER_CD, '00') AS CORNER_CD"
		+ ", CHG_BILL_NO, TAX_YN, DLV_PACK_FG, PROP_CD, PROP_VAL, ORG_SALE_MG_CD"
		+ ", ORG_SALE_UPRC, NORMAL_UPRC, SALE_MG_CD, SALE_QTY, SALE_UPRC"
		+ ", SALE_AMT, SALE_WEIGHT, DC_AMT, ETC_AMT, SVC_TIP_AMT, DCM_SALE_AMT"
		+ ", VAT_AMT, ifnull(SVC_CD, '0') AS SVC_CD, ifnull(TK_CPN_CD, '') AS TK_CPN_CD"
		+ ", DC_AMT_GEN, DC_AMT_SVC, DC_AMT_JCD, DC_AMT_CPN, DC_AMT_CST, DC_AMT_FOD"
		+ ", DC_AMT_PRM, DC_AMT_CRD, DC_AMT_PACK, DC_AMT_LYT, CST_SALE_POINT"
		+ ", CST_USE_POINT, PRM_PROC_YN, PRM_CD, PRM_SEQ, SDA_CD, SDS_ORG_DTL_NO"
		+ ", INS_DT, ifnull(EMP_NO, '0000') AS EMP_NO, ifnull('0', '0') AS SET_PROD_FG"
		+ ", ifnull(CUP_SALE_CNT, '0') AS CUP_SALE_CNT, ifnull(CUP_DEPOSIT_UPRC, '0') AS CUP_DEPOSIT_UPRC, CUP_FG"
		+ " FROM SSL_TRDTL_T WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";
	
	this.sqlSelectSslTrcshT = "SELECT ifnull(LINE_NO, '0001') AS LINE_NO, SEQ_NO, ifnull(REGI_SEQ, '01') AS REGI_SEQ"
		+ ", SALE_YN, ifnull(VAN_CD, '02') AS VAN_CD, ifnull(CORNER_CD, '01') AS CORNER_CD"
		+ ", CASH_AMT, APPR_AMT, SVC_TIP_AMT, VAT_AMT, APPR_PROC_FG, APPR_IDT_TYPE, APPR_IDT_FG"
		+ ", CARD_IN_FG, APPR_IDT_NO, APPR_DATE, APPR_TIME, APPR_NO, APPR_MSG, VAN_TERM_NO"
		+ ", VAN_SLIP_NO, ORG_APPR_DATE, ORG_APPR_NO, ifnull(APPR_LOG_NO, '') AS APPR_LOG_NO, INS_DT"
		+ ", ifnull(EMP_NO, '0000') AS EMP_NO, ifnull(EX_CD, '0') AS EX_CD, ifnull(EX_KRW, '0') AS EX_KRW"
		+ ", ifnull(EX_EXP_AMT, '0') AS EX_EXP_AMT, ifnull(EX_IN_AMT, '0') AS EX_IN_AMT"
		+ ", ifnull(EX_RET_AMT, '0') AS EX_RET_AMT, ifnull(KR_RET_AMT, '0') AS KR_RET_AMT"
		+ ", ifnull(EX_PAY_AMT, '0') AS EX_PAY_AMT, ifnull(KR_PAY_AMT, '0') AS KR_PAY_AMT"
		+ ", ifnull(KR_ETC_AMT, '0') AS KR_ETC_AMT, PRE_PAY_FG, ifnull(NOTICE_MSG, '') AS NOTICE_MSG"
		+ ", ifnull(BROAD_MSG, '') AS BROAD_MSG, CNMK_CD, SEC_FLAG, VAT_SALE_AMT, NO_VAT_SALE_AMT"
		+ " FROM SSL_TRCSH_T WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";
	
	this.sqlSelectSslTrcrdT = "SELECT ifnull(LINE_NO, '0001') AS LINE_NO, SEQ_NO"
		+ ", ifnull(REGI_SEQ, '01') AS REGI_SEQ, SALE_YN, ifnull(VAN_CD, '02') AS VAN_CD"
		+ ", ifnull(CORNER_CD, '00') AS CORNER_CD, APPR_PROC_FG, CRD_CARD_NO, APPR_REQ_AMT"
		+ ", SVC_TIP_AMT, VAT_AMT, INST_MM_FG, INST_MM_CNT, VALID_TERM, SIGN_PAD_YN, CARD_IN_FG"
		+ ", APPR_DATE, APPR_TIME, APPR_NO, CRDCP_CD, ISS_CRDCP_CD, ISS_CRDCP_NM, PUR_CRDCP_CD"
		+ ", PUR_CRDCP_NM, APPR_AMT, APPR_DC_AMT, APPR_MSG, VAN_TERM_NO, VAN_SLIP_NO, CRDCP_TERM_NO"
		+ ", ORG_APPR_DATE, ORG_APPR_NO, ifnull(APPR_LOG_NO, '') AS APPR_LOG_NO, INS_DT, EMP_NO"
		+ ", PRE_PAY_FG, LYT_APPR_FG, LYT_APPR_INFO, GIFT_CASH, ifnull(NOTICE_MSG, '') AS NOTICE_MSG"
		+ ", ifnull(BROAD_MSG, '') AS BROAD_MSG, ifnull(CNMK_CD, '') AS CNMK_CD, UNION_PAY_FG"
		+ ", DDC_FLAG, SEC_FLAG, VAT_SALE_AMT, NO_VAT_SALE_AMT"
		+ " FROM SSL_TRCRD_T WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";
		
	this.sqlSelectSslTrjcdT = "SELECT LINE_NO, SEQ_NO, REGI_SEQ, SALE_YN, VAN_CD, CORNER_CD, APPR_PROC_FG, JCD_CD"
		+ ", JCD_TYPE_FG, JCD_PROC_FG, JCD_CARD_NO, JCD_CARD_PWD, APPR_AMT, VALID_TERM, SIGN_PAD_YN"
		+ ", CARD_IN_FG, APPR_DATE, APPR_TIME, APPR_NO, JCD_DC_AMT, JCD_OCC_POINT, JCD_AVL_POINT"
		+ ", JCD_USE_POINT, JCD_REM_POINT, APPR_MSG, VAN_TERM_NO, VAN_SLIP_NO, CRDCP_TERM_NO, ORG_APPR_DATE"
		+ ", ORG_APPR_NO, APPR_LOG_NO, INS_DT, EMP_NO, BROAD_MSG, JCD_PAY_FG, CNMK_CD, TEST, SEC_FLAG"
		+ " FROM SSL_TRJCD_T WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";
	
	this.sqlSelectSslTrcstT = "SELECT LINE_NO, REGI_SEQ, SALE_YN, CST_NO, CST_CARD_NO, CST_CLS_CD"
		+ ", CST_USE_POINT, INS_DT, EMP_NO, CST_USE_AMT, CORNER_CD, SEQ_NO"
		+ " FROM SSL_TRCST_T WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";
	
	this.sqlSelectSslTretcT = "SELECT LINE_NO, SEQ_NO, TR_TYPE_CD, REGI_SEQ, CORNER_CD, SALE_YN"
		+ ", APPR_DATE, APPR_TIME, APPR_AMT, SVC_TIP_AMT, VAT_AMT, PRE_BF_REM_AMT, PRE_AF_REM_AMT, APPR_NO"
		+ ", CARD_NO, APPR_PROC_FG, ORG_APPR_DATE, ORG_APPR_NO, USER_DATA, INS_DT"
		+ " FROM SSL_TRETC_T WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";
	
	this.sqlSelectSslTrpsqT = "SELECT SHOP_CD, SALE_DATE, POS_NO, BILL_NO, PAY_SEQ_NO, REGI_SEQ, SALE_YN"
		+ ", PAY_TYPE_FG, PAY_AMT, LINE_NO, INS_DT, UPD_DT, EMP_NO"
		+ " FROM SSL_TRPSQ_T WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";
	
	this.sqlSelectSslTrsocT = "SELECT DTL_NO, ifnull(REGI_SEQ, '01') AS REGI_SEQ, SALE_YN"
		+ ", PROD_CD, PROD_TYPE_FG, ifnull(CORNER_CD, '00') AS CORNER_CD"
		+ ", CHG_BILL_NO, TAX_YN, DLV_PACK_FG, PROP_CD, PROP_VAL, ORG_SALE_MG_CD"
		+ ", ORG_SALE_UPRC, NORMAL_UPRC, SALE_MG_CD, SALE_QTY, SALE_UPRC"
		+ ", SALE_AMT, SALE_WEIGHT, DC_AMT, ETC_AMT, SVC_TIP_AMT, DCM_SALE_AMT"
		+ ", VAT_AMT, ifnull(SVC_CD, '0') AS SVC_CD, ifnull(TK_CPN_CD, '') AS TK_CPN_CD"
		+ ", DC_AMT_GEN, DC_AMT_SVC, DC_AMT_JCD, DC_AMT_CPN, DC_AMT_CST, DC_AMT_FOD"
		+ ", DC_AMT_PRM, DC_AMT_CRD, DC_AMT_PACK, DC_AMT_LYT, CST_SALE_POINT"
		+ ", CST_USE_POINT, PRM_PROC_YN, PRM_CD, PRM_SEQ, SDA_CD, SDS_ORG_DTL_NO"
		+ ", INS_DT, ifnull(EMP_NO, '0000') AS EMP_NO, ifnull('0', '0') AS SET_PROD_FG"
		+ ", ifnull(CUP_SALE_CNT, '0') AS CUP_SALE_CNT, ifnull(CUP_DEPOSIT_UPRC, '0') AS CUP_DEPOSIT_UPRC, CUP_FG"
		+ " FROM SSL_TRDTL_T WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND SUBSTR(PROD_CD,1,1) = 'A'";
	
	//POS_ODHDR_T
	this.sqlInsertPosOdhdrT = "INSERT OR REPLACE INTO POS_ODHDR_T(SHOP_CD, SALE_DATE, ORDER_NO, POS_NO, DLV_ORDER_FG"
		+ ", ORDER_END_FG, FD_TBL_CD, TOT_SALE_AMT, TOT_DC_AMT, SVC_TIP_AMT, TOT_ETC_AMT, DCM_SALE_AMT, VAT_SALE_AMT"
		+ ", VAT_AMT, NO_VAT_SALE_AMT, NO_TAX_SALE_AMT, EXP_PAY_AMT, GST_PAY_AMT, RET_PAY_AMT, CASH_AMT, CRD_CARD_AMT"
		+ ", WES_AMT, TK_GFT_AMT, TK_FOD_AMT, CST_POINT_AMT, JCD_CARD_AMT, RFC_AMT, ETC_APPR_AMT, CST_NO, CST_CARD_NO"
		+ ", CST_SALE_POINT, DC_GEN_AMT, DC_SVC_AMT, DC_PCD_AMT, DC_CPN_AMT, DC_CST_AMT, DC_TFD_AMT, DC_PRM_AMT, DC_CRD_AMT"
		+ ", DC_PACK_AMT, DC_LYT_AMT, REPAY_CASH_AMT, REPAY_TK_GFT_AMT, CASH_BILL_AMT, FD_GST_CNT_T, FD_GST_CNT_1, FD_GST_CNT_2"
		+ ", FD_GST_CNT_3, FD_GST_CNT_4, INS_DT, EMP_NO, ORDER_END_DT, BILL_NO, SEND_FG, SEND_DT, DELIVER_NO, RESERVED_NO"
		+ ", KITCHEN_MEMO, CST_NM, NEW_DLV_ADDR_YN, DLV_ADDR, DLV_ADDR_DTL, NEW_DLV_TEL_NO_YN, DLV_TEL_NO, DLV_PAY_TYPE_FG"
		+ ", DLV_IDT_NO, DLV_EMP_NO, DLV_REMARK, DLV_START_DT, DLV_PAYIN_EMP_NO, DLV_PAYIN_DT, DLV_BOWLIN_YN, DLV_BOWLIN_EMP_NO"
		+ ", DLV_BOWLIN_DT, DLV_CL_CD, DLV_CM_CD, DLV_DEBT_FG, TRAVEL_CD, RSV_NO, PRE_PAY_CASH, PRE_PAY_CARD, RSV_USER_NM"
		+ ", RSV_USER_TEL_NO, CST_AVL_POINT, DLV_MOBILE_FG, LOCAL_POINT_YN, CST_USE_POINT, PAGER_VIBE_FG, FD_TBL_CD, CUP_DEPOSIT_AMT)"
    	+ " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	//+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME'), "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
	
	//POS_ODDTL_T 
	this.sqlInsertPosOddtlT = "INSERT OR REPLACE INTO POS_ODDTL_T(SHOP_CD, SALE_DATE, ORDER_NO, ORDER_DTL_NO, ORDER_DTL_FG"
		+ ", ORDER_SEQ_NO, POS_NO, PROD_CD, PROD_TYPE_FG, CORNER_CD, CHG_BILL_NO, TAX_YN, DLV_PACK_FG, PROP_CD, PROP_VAL"  
		+ ", ORG_SALE_MG_CD, ORG_SALE_UPRC, NORMAL_UPRC, SALE_MG_CD, SALE_QTY, SALE_UPRC, SALE_AMT, SALE_WEIGHT, DC_AMT"
		+ ", ETC_AMT, SVC_TIP_AMT, DCM_SALE_AMT, VAT_AMT, SVC_CD, TK_CPN_CD, DC_TYPE_FG, DC_AMT_GEN, DC_AMT_SVC, DC_AMT_JCD"
		+ ", DC_AMT_CPN, DC_AMT_CST, DC_AMT_FOD, DC_AMT_PRM, DC_AMT_CRD, DC_AMT_PACK, DC_AMT_LYT, CST_SALE_POINT, CST_USE_POINT"
		+ ", PRM_PROC_YN, PRM_CD, PRM_SEQ, SDA_CD, SDS_ORG_DTL_NO, ORDER_EMP_NO, ORG_ORDER_NO, ORG_FD_TBL_CD, REMARK, INS_DT"
		+ ", EMP_NO, DC_SEQ_TYPE, DC_SEQ_AMT, DC_SEQ_FG, DC_SEQ_RATE, ORDER_SCN_FG, ORDER_SCN_DT, ORDER_SCN_POS_NO, COOK_MEMO"
		+ ", STAMP_SALE_QTY, CANCEL_REASON, CUP_SALE_CNT, CUP_DEPOSIT_UPRC, CUP_FG)"
    	+ " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME'), ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?)";
	
	//POS_LGCRD_T
	this.sqlInsertPosLgcrdT = "INSERT OR REPLACE INTO POS_LGCRD_T(SHOP_CD, SALE_DATE, APPR_LOG_NO, POS_NO, VAN_CD, CORNER_CD"
		+ ", APPR_TYPE_FG, APPR_FG, APPR_PROC_FG, CRD_CARD_NO, APPR_REQ_AMT, SVC_TIP_AMT, VAT_AMT, INST_MM_FG, INST_MM_CNT"
		+ ", VALID_TERM, SIGN_PAD_YN, CARD_IN_FG, APPR_DATE, APPR_TIME, APPR_NO, CRDCP_CD, ISS_CRDCP_CD, ISS_CRDCP_NM, PUR_CRDCP_CD"
		+ ", PUR_CRDCP_NM, APPR_AMT, APPR_DC_AMT, APPR_MSG, VAN_TERM_NO, VAN_SLIP_NO, CRDCP_TERM_NO, ORG_APPR_DATE, ORG_APPR_NO"
		+ ", ORG_APPR_LOG_NO, LYT_APPR_FG, LYT_APPR_INFO, INS_DT, EMP_NO, SEND_FG, SEND_DT, GIFT_CASH, NOTICE_MSG, BROAD_MSG"
		+ ", CNMK_CD, UNION_PAY_FG, DDC_FLAG, VAT_SALE_AMT, NO_VAT_SALE_AMT)"
    	+ " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME'), ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ? )";
	
	//POS_ODCRD_T
	this.sqlInsertPosOdcrdT = "INSERT OR REPLACE INTO POS_ODCRD_T(SHOP_CD, SALE_DATE, ORDER_NO, LINE_NO, SEQ_NO, POS_NO"
		+ ", SALE_YN, APPR_REQ_AMT, SVC_TIP_AMT, VAT_AMT, APPR_LOG_NO, APPR_AMT, APPR_DC_AMT, INS_DT, EMP_NO, PRE_PAY_FG"
		+ ", VAT_SALE_AMT, NO_VAT_SALE_AMT)"
    	+ " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME'), ?, ?, ?, ?)";
	
	//POS_LGJCD_T
	this.sqlInsertPosLgjcdT = "INSERT OR REPLACE INTO POS_LGJCD_T(SHOP_CD, SALE_DATE, APPR_LOG_NO, POS_NO, VAN_CD, CORNER_CD, "
			+ "APPR_TYPE_FG, APPR_FG, APPR_PROC_FG, JCD_CD, JCD_TYPE_FG, JCD_PROC_FG, JCD_CARD_NO, JCD_CARD_PWD, APPR_AMT, "
			+ "VALID_TERM, SIGN_PAD_YN, CARD_IN_FG, APPR_DATE, APPR_TIME, APPR_NO, JCD_DC_AMT, JCD_OCC_POINT, JCD_AVL_POINT, "
			+ "JCD_USE_POINT, JCD_REM_POINT, APPR_MSG, VAN_TERM_NO, VAN_SLIP_NO, CRDCP_TERM_NO, ORG_APPR_DATE, ORG_APPR_NO, "
			+ "ORG_APPR_LOG_NO, INS_DT, EMP_NO, SEND_FG, SEND_DT, BROAD_MSG, JCD_PAY_FG, CNMK_CD)"
    	+ " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " 
    	+		  "?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) ";
	
	//카드 결제시 간편결제의 카카오페이와 제로페이에 대한 추가정보 등록.
	this.sqlInsertSslTretcT = 
		   "INSERT OR REPLACE INTO SSL_TRETC_T (                                                  ".rtrim()
		 + "\n   SHOP_CD          , SALE_DATE       , POS_NO      , BILL_NO      , LINE_NO        ".rtrim()
		 + "\n , SEQ_NO           , TR_TYPE_CD      , REGI_SEQ    , CORNER_CD    , SALE_YN        ".rtrim()
		 + "\n , APPR_DATE        , APPR_TIME       , APPR_AMT    , SVC_TIP_AMT  , VAT_AMT        ".rtrim()
		 + "\n , PRE_BF_REM_AMT   , PRE_AF_REM_AMT  , APPR_NO     , CARD_NO      , APPR_PROC_FG   ".rtrim()
		 + "\n , ORG_APPR_DATE    , ORG_APPR_NO     , USER_DATA   , INS_DT                        ".rtrim()
		 + "\n )                                                       ".rtrim()
		 + "\n  VALUES                                                 ".rtrim()
		 + "\n  (                                                      ".rtrim()
		 + "\n      ? , ? , ? , ? , ?         , ? , ? , ? , ? , ?      ".rtrim()
		 + "\n    , ? , ? , ? , ? , ?         , ? , ? , ? , ? , ?      ".rtrim()
		 + "\n    , ? , ? , ? , ?                                      ".rtrim()
		 + "\n  )                                                      ".rtrim()
		 ;
	//카드 결제시 간편결제의 카카오페이와 제로페이에 대한 추가정보 등록.
	this.sqlInsertPosOdetcT = 
		   "INSERT OR REPLACE INTO POS_ODETC_T (                                                    ".rtrim()
		 + "\n      SHOP_CD         , SALE_DATE    , POS_NO        , ORDER_NO      , LINE_NO        ".rtrim()
		 + "\n    , SEQ_NO          , TR_TYPE_CD   , CORNER_CD     , SALE_YN       , APPR_DATE      ".rtrim()
		 + "\n    , APPR_TIME       , APPR_AMT     , SVC_TIP_AMT   , VAT_AMT       , PRE_BF_REM_AMT ".rtrim()
		 + "\n    , PRE_AF_REM_AMT  , APPR_NO      , CARD_NO       , APPR_PROC_FG  , ORG_APPR_DATE  ".rtrim()
		 + "\n    , ORG_APPR_NO     , USER_DATA    , INS_DT                                         ".rtrim()
		 + "\n )                                                       ".rtrim()
		 + "\n  VALUES                                                 ".rtrim()
		 + "\n  (                                                      ".rtrim()
		 + "\n      ? , ? , ? , ? , ?         , ? , ? , ? , ? , ?      ".rtrim()
		 + "\n    , ? , ? , ? , ? , ?         , ? , ? , ? , ? , ?      ".rtrim()
		 + "\n    , ? , ? , ?                                          ".rtrim()
		 + "\n  )                                                      ".rtrim()
		 ;

	//POS 마지막 번호 get
    this.selectPosOrderNoMax = "SELECT SUBSTR('0000' ||IFNULL(MAX(  ORDER_NO  ) , 0), -4,4) AS LAST_ORDER_NO"
                        + " FROM POS_ODHDR_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ?";
    
    //결제주문 마지막 번호 get
    this.selectSslOrderNoMax = "SELECT SUBSTR('0000' ||IFNULL(MAX(  ORDER_NO  ) , 0), -4,4) AS LAST_ORDER_NO"
                        + " FROM SSL_TRHDR_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ?";
    
    //POS주문번호 생성
    this.selectPosOrderNo = "SELECT SUBSTR('0000' || IFNULL(MAX( CAST( ORDER_NO AS INTEGER ) ) + 1 , 1), -4, 4) AS MAX_ORDER_NO"
                        + " FROM POS_ODHDR_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ?";

    //결제주문번호 생성
    this.selectSslOrderNo = "SELECT SUBSTR('0000' || IFNULL(MAX( CAST( ORDER_NO AS INTEGER ) ) + 1 , 1), -4, 4) AS MAX_ORDER_NO"
                        + " FROM SSL_TRHDR_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ?";
    
    //주문상세번호 생성
    this.selectPosOrderDtlNo = "SELECT  SUBSTR('0000' || IFNULL(MAX( CAST( ORDER_DTL_NO AS INTEGER ) ) + 1 , 1), -4, 4) AS MAX_ORDER_DTL_NO"
                        + " FROM POS_ODDTL_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND ORDER_NO = ? ";
    
    //결제주문상세번호 생성
    this.selectSslTrdtlDtlNo = "SELECT  SUBSTR('0000' || IFNULL(MAX( CAST( DTL_NO AS INTEGER ) ) + 1 , 1), -4, 4) AS MAX_DTL_NO"
                        + " FROM SSL_TRDTL_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND BILL_NO = ? ";
    
    //주문상세시퀀스번호 생성
    this.selectPosOrderSeqNo = "SELECT  SUBSTR('0000' || IFNULL(MAX( CAST( ORDER_SEQ_NO AS INTEGER ) ) + 1 , 1), -4, 4) AS MAX_ORDER_SEQ_NO"
                        + " FROM POS_ODDTL_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND ORDER_NO = ? AND ORDER_DTL_NO = ?";
    
    //주문카드라인번호 생성
    this.selectPosOdcrdLineNo = "SELECT  SUBSTR('0000' || IFNULL(MAX( CAST( LINE_NO AS INTEGER ) ) + 1 , 1), -4, 4) AS MAX_LINE_NO"
                        + " FROM POS_ODCRD_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND ORDER_NO = ? ";
    
    //기타결제라인번호 생성
    this.selectSslTretcLineNo = "SELECT  SUBSTR('0000' || IFNULL(MAX( CAST( LINE_NO AS INTEGER ) ) + 1 , 1), -4, 4) AS MAX_LINE_NO"
                        + " FROM SSL_TRETC_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND BILL_NO = ? ";
    
    //주문카드시퀀스번호 생성
    this.selectPosOdcrdSeqNo = "SELECT  SUBSTR('00' || IFNULL(MAX( CAST( SEQ_NO AS INTEGER ) ) + 1 , 1), -2, 2) AS MAX_SEQ_NO"
                        + " FROM POS_ODCRD_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND ORDER_NO = ? AND LINE_NO = ?";
    
    //기타결제시퀀스번호 생성
    this.selectSslTretcSeqNo = "SELECT  SUBSTR('00' || IFNULL(MAX( CAST( SEQ_NO AS INTEGER ) ) + 1 , 1), -2, 2) AS MAX_SEQ_NO"
				    	+ " FROM SSL_TRETC_T "
				    	+ " WHERE SHOP_CD = ? AND SALE_DATE = ? AND BILL_NO = ? AND LINE_NO = ?";
	
    //영수증번호 생성
    this.selectBillNo = "SELECT  SUBSTR('0000' || IFNULL(MAX( CAST( BILL_NO AS INTEGER ) ) + 1 , 1), -4, 4) AS BILL_NO"
                        + " FROM SSL_TRHDR_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? ";
    //교환권번호 생성
    this.selectChgBillNo = "SELECT  MAX(CHG_BILL_NO)+1 AS CHG_BILL_NO"
                        + " FROM POS_ODDTL_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND CORNER_CD = ?";
    
    //get SCD_PAGMS_T
    this.selectPagmsOption = "SELECT PAG_TYPE_FG, PAG_PORT"
    	+ " FROM SCD_PAGMS_T "
    	+ " WHERE SHOP_CD = ? AND POS_NO = ?";
    
    //교환권 시퀀스 생성
    this.selectPosChgnoBillNo = "SELECT MAX(CHNAGE_BILL_NO)+1 AS CHNAGE_BILL_NO"
    	+ " FROM POS_CHGNO_T "
    	+ " WHERE SHOP_CD = ? AND SALE_DATE = ? ";
    
    //결제순서 시퀀스 번호 생성
    this.selectPosPaySeqNo = "SELECT  SUBSTR('00' || IFNULL(MAX( CAST( PAY_SEQ_NO AS INTEGER ) ) + 1 , 1), -2, 2) AS MAX_PAY_SEQ_NO"
                        + " FROM POS_ODPSQ_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND ORDER_NO = ? ";
    
    //결제순서 라인 번호 생성
    this.selectPosOdpsqLineNo = "SELECT  SUBSTR('0000' || IFNULL(MAX( CAST( LINE_NO AS INTEGER ) ) + 1 , 1), -4, 4) AS MAX_LINE_NO"
    	+ " FROM POS_ODPSQ_T "
    	+ " WHERE SHOP_CD = ? AND SALE_DATE = ? AND ORDER_NO = ? ";
    
    //주문결제-회원포인트 라인번호 생성
    this.selectPosOdcstLineNo = "SELECT  SUBSTR('0000' || IFNULL(MAX( CAST( LINE_NO  AS INTEGER ) ) + 1 , 1), -4, 4) AS MAX_LINE_NO"
    	+ " FROM POS_ODCST_T "
    	+ " WHERE SHOP_CD = ? AND SALE_DATE = ? AND ORDER_NO = ? ";
    
    //주문결제-회원포인트 시퀀스번호 생성
    this.selectPosOdcstSeqNo = "SELECT  SUBSTR('00' || IFNULL(MAX( CAST( SEQ_NO AS INTEGER ) ) + 1 , 1), -2, 2) AS MAX_SEQ_NO"
        + " FROM POS_ODCST_T "
        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND ORDER_NO = ? AND LINE_NO = ?";
    
    this.insertSslTrhdrT = "INSERT INTO SSL_TRHDR_T ( SHOP_CD, SALE_DATE, POS_NO, BILL_NO, REGI_SEQ, SALE_YN, TOT_SALE_AMT"
    	+ ", TOT_DC_AMT, SVC_TIP_AMT, TOT_ETC_AMT, DCM_SALE_AMT, VAT_SALE_AMT, VAT_AMT, NO_VAT_SALE_AMT, NO_TAX_SALE_AMT"
    	+ ", EXP_PAY_AMT, GST_PAY_AMT, RET_PAY_AMT, CASH_AMT, CRD_CARD_AMT, WES_AMT, TK_GFT_AMT, TK_FOD_AMT, CST_POINT_AMT"
    	+ ", JCD_CARD_AMT, RFC_AMT, ETC_APPR_AMT, DC_GEN_AMT, DC_SVC_AMT, DC_PCD_AMT, DC_CPN_AMT, DC_CST_AMT, DC_TFD_AMT"
    	+ ", DC_PRM_AMT, DC_CRD_AMT, DC_PACK_AMT, DC_LYT_AMT, REPAY_CASH_AMT, REPAY_TK_GFT_AMT, CASH_BILL_AMT, DLV_ORDER_FG"
    	+ ", FD_TBL_CD, FD_GST_CNT_T, FD_GST_CNT_1, FD_GST_CNT_2, FD_GST_CNT_3, FD_GST_CNT_4, ORG_BILL_NO, ORDER_NO, INS_DT, EMP_NO"
    	+ ", SEND_FG, CST_NO, CST_SALE_POINT, CST_CARD_NO, PAY_OUT_DT, DLV_EMP_NO, DLV_START_DT, DLV_PAYIN_EMP_NO, DLV_PAYIN_DT"
    	+ ", NEW_DLV_ADDR_YN, DLV_ADDR, DLV_ADDR_DTL, NEW_DLV_TEL_NO_YN, DLV_TEL_NO, CST_NM, DLV_CL_CD, DLV_CM_CD, TRAVEL_CD"
    	+ ", RSV_NO, PRE_PAY_CASH, PRE_PAY_CARD, RSV_USER_NM, RSV_USER_TEL_NO, CST_AVL_POINT, LOCAL_POINT_YN, CST_USE_POINT, FD_TBL_CD, CUP_DEPOSIT_AMT"
    	+ " ) "                                                       
    	+ "  SELECT SHOP_CD, SALE_DATE, POS_NO, ? AS BILL_NO, '01' AS REGI_SEQ, 'Y', TOT_SALE_AMT, TOT_DC_AMT, SVC_TIP_AMT"
    	+ ", TOT_ETC_AMT, DCM_SALE_AMT, VAT_SALE_AMT, VAT_AMT, NO_VAT_SALE_AMT, NO_TAX_SALE_AMT, EXP_PAY_AMT, GST_PAY_AMT"
    	+ ", RET_PAY_AMT, CASH_AMT, CRD_CARD_AMT, WES_AMT, TK_GFT_AMT, TK_FOD_AMT, CST_POINT_AMT, JCD_CARD_AMT, RFC_AMT"
    	+ ", ETC_APPR_AMT, DC_GEN_AMT, DC_SVC_AMT, DC_PCD_AMT, DC_CPN_AMT, DC_CST_AMT, DC_TFD_AMT, DC_PRM_AMT, DC_CRD_AMT"
    	+ ", DC_PACK_AMT, DC_LYT_AMT, REPAY_CASH_AMT, REPAY_TK_GFT_AMT, CASH_BILL_AMT, DLV_ORDER_FG, FD_TBL_CD, FD_GST_CNT_T"
    	+ ", FD_GST_CNT_1, FD_GST_CNT_2, FD_GST_CNT_3, FD_GST_CNT_4, NULL, ORDER_NO, INS_DT, EMP_NO, '0' AS SEND_FG"
    	+ ", CST_NO, CST_SALE_POINT, CST_CARD_NO"
    	+ ", CASE WHEN DLV_PAYIN_DT IS NULL OR DLV_PAYIN_DT = '' THEN strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') ELSE DLV_PAYIN_DT END"
    	+ ", DLV_EMP_NO, DLV_START_DT, DLV_PAYIN_EMP_NO, DLV_PAYIN_DT, NEW_DLV_ADDR_YN, DLV_ADDR, DLV_ADDR_DTL, NEW_DLV_TEL_NO_YN"
    	+ ", DLV_TEL_NO, CST_NM, DLV_CL_CD, DLV_CM_CD, TRAVEL_CD, RSV_NO, PRE_PAY_CASH, PRE_PAY_CARD, RSV_USER_NM, RSV_USER_TEL_NO"                                                  
		+ ", CST_AVL_POINT, LOCAL_POINT_YN, CST_USE_POINT, FD_TBL_CD, CUP_DEPOSIT_AMT "
        + " FROM   POS_ODHDR_T"
        + " WHERE  SHOP_CD      = ?" 
        + " AND    SALE_DATE    = ?"
        + " AND    ORDER_NO     = ?";
    
    this.selectSslTrhdrT = "SELECT PROD_CD, PROD_TYPE_FG, CORNER_CD, COALESCE( CHG_BILL_NO, '' ) AS CHG_BILL_NO, TAX_YN, DLV_PACK_FG"
    	+ ", COALESCE( PROP_CD , '') AS PROP_CD, COALESCE( PROP_VAL , '') AS PROP_VAL, ORG_SALE_MG_CD, ORG_SALE_UPRC, NORMAL_UPRC, SALE_MG_CD"
    	+ ", SALE_UPRC, PRM_PROC_YN, COALESCE( PRM_CD,  '' ) AS PRM_CD, COALESCE( PRM_SEQ, '' ) AS PRM_SEQ, SDA_CD, SDS_ORG_DTL_NO"
    	+ ", MAX(EMP_NO) AS EMP_NO, SVC_CD, TK_CPN_CD, SUM(SALE_QTY) AS SALE_QTY, SUM(SALE_AMT) AS SALE_AMT, SUM(DC_AMT) AS DC_AMT"
    	+ ", SUM(ETC_AMT) AS ETC_AMT, SUM(SVC_TIP_AMT) AS SVC_TIP_AMT, SUM(DCM_SALE_AMT) AS DCM_SALE_AMT, SUM(VAT_AMT) AS VAT_AMT"
    	+ ", SUM(DC_AMT_GEN) AS DC_AMT_GEN, SUM(DC_AMT_SVC) AS DC_AMT_SVC, SUM(DC_AMT_JCD) AS DC_AMT_JCD, SUM(DC_AMT_CPN) AS DC_AMT_CPN"
    	+ ", SUM(DC_AMT_CST) AS DC_AMT_CST, SUM(DC_AMT_FOD) AS DC_AMT_FOD, SUM(DC_AMT_PRM) AS DC_AMT_PRM, SUM(DC_AMT_CRD) AS DC_AMT_CRD"
    	+ ", SUM(DC_AMT_PACK) AS DC_AMT_PACK, SUM(DC_AMT_LYT) AS DC_AMT_LYT, SUM(CST_SALE_POINT) AS CST_SALE_POINT"
    	+ ", SUM(CST_USE_POINT) AS CST_USE_POINT, COALESCE( SALE_WEIGHT, 0 ) AS SALE_WEIGHT, SUM(CUP_DEPOSIT_UPRC) AS CUP_DEPOSIT_AMT "
    	+ " FROM POS_ODDTL_T"
    	+ " WHERE SHOP_CD = ? AND SALE_DATE = ? AND ORDER_NO = ? AND ORDER_DTL_NO = ? "
    	+ " GROUP BY PROD_CD, PROD_TYPE_FG, CORNER_CD, COALESCE( CHG_BILL_NO, '' ), TAX_YN, DLV_PACK_FG, COALESCE( PROP_CD , '' ) "
    	+ ", COALESCE( PROP_VAL, '' ), ORG_SALE_MG_CD, ORG_SALE_UPRC, NORMAL_UPRC, SALE_MG_CD, SALE_UPRC, PRM_PROC_YN "
    	+ ", COALESCE( PRM_CD,  '' ), COALESCE( PRM_SEQ, '' ), SDA_CD, SDS_ORG_DTL_NO, SVC_CD, TK_CPN_CD, COALESCE( SALE_WEIGHT, 0 ) "
    	+ "HAVING  SUM( SALE_QTY ) > 0 ORDER BY MIN( ORDER_DTL_NO )";
        
	//POS_ODPSQ_T
	this.selectPosOdpsqT = "INSERT OR REPLACE INTO POS_ODPSQ_T(SHOP_CD, SALE_DATE, ORDER_NO, PAY_SEQ_NO, POS_NO, SALE_YN"
		+ ", PAY_TYPE_FG, PAY_AMT, LINE_NO, INS_DT, UPD_DT, EMP_NO)"
    	+ "  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME'), "
    	+		  "strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME'), ?)";
	
	this.insertSslTrpsq = "INSERT INTO SSL_TRPSQ_T(SHOP_CD, SALE_DATE, POS_NO, BILL_NO,	REGI_SEQ, PAY_SEQ_NO, SALE_YN"
		+ " , PAY_TYPE_FG, PAY_AMT, LINE_NO, INS_DT, UPD_DT, EMP_NO"
		+ " ) "
		+ "	SELECT SHOP_CD, SALE_DATE, POS_NO, ? AS BILL_NO, '01' AS REGI_SEQ, PAY_SEQ_NO"
		+ " , 'Y' AS SALE_YN, PAY_TYPE_FG, PAY_AMT, LINE_NO, INS_DT, UPD_DT, EMP_NO"
		+ " FROM POS_ODPSQ_T WHERE SHOP_CD = ? AND SALE_DATE = ? AND ORDER_NO  = ? AND PAY_SEQ_NO = ? AND SALE_YN = 'Y'";
	
	this.insertSslTrcrd = "INSERT INTO SSL_TRCRD_T(SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, SEQ_NO, SALE_YN, VAN_CD"
		+ ",REGI_SEQ, CORNER_CD, APPR_PROC_FG, CRD_CARD_NO, APPR_REQ_AMT, SVC_TIP_AMT, VAT_AMT, INST_MM_FG, INST_MM_CNT, VALID_TERM"
		+ ",SIGN_PAD_YN, CARD_IN_FG,APPR_DATE,APPR_TIME,APPR_NO,CRDCP_CD,ISS_CRDCP_CD,ISS_CRDCP_NM,PUR_CRDCP_CD,PUR_CRDCP_NM"
		+ ",APPR_AMT,APPR_DC_AMT,VAN_TERM_NO,APPR_MSG,VAN_SLIP_NO,ORG_APPR_DATE,ORG_APPR_NO,INS_DT,EMP_NO,APPR_LOG_NO,CRDCP_TERM_NO"
		+ ",PRE_PAY_FG,LYT_APPR_FG,LYT_APPR_INFO,GIFT_CASH,NOTICE_MSG,BROAD_MSG,CNMK_CD,UNION_PAY_FG,DDC_FLAG,VAT_SALE_AMT,NO_VAT_SALE_AMT"
		+ ")"
		+ " SELECT DISTINCT A.SHOP_CD, A.SALE_DATE, A.POS_NO, ? AS BILL_NO, A.LINE_NO, A.SEQ_NO, A.SALE_YN, B.VAN_CD, '01' AS REGI_SEQ, B.CORNER_CD"
		+ ", B.APPR_PROC_FG, B.CRD_CARD_NO, B.APPR_REQ_AMT, B.SVC_TIP_AMT, B.VAT_AMT, B.INST_MM_FG, B.INST_MM_CNT, B.VALID_TERM"
		+ ", B.SIGN_PAD_YN, B.CARD_IN_FG, B.APPR_DATE, B.APPR_TIME, B.APPR_NO, B.CRDCP_CD, B.ISS_CRDCP_CD, B.ISS_CRDCP_NM, B.PUR_CRDCP_CD"
		+ ", B.PUR_CRDCP_NM, B.APPR_AMT, B.APPR_DC_AMT, B.VAN_TERM_NO, B.APPR_MSG, B.VAN_SLIP_NO, B.ORG_APPR_DATE, B.ORG_APPR_NO"
		+ ", A.INS_DT, B.EMP_NO, A.APPR_LOG_NO, B.CRDCP_TERM_NO, A.PRE_PAY_FG, B.LYT_APPR_FG, B.LYT_APPR_INFO, B.GIFT_CASH, B.NOTICE_MSG"
		+ ", B.BROAD_MSG, B.CNMK_CD, B.UNION_PAY_FG, B.DDC_FLAG, A.VAT_SALE_AMT, A.NO_VAT_SALE_AMT"
		+ " FROM POS_ODPSQ_T S, POS_ODCRD_T A, POS_LGCRD_T B"
		+ " WHERE S.SHOP_CD = ? AND S.SALE_DATE = ? AND S.ORDER_NO = ? AND S.PAY_TYPE_FG = ? AND S.SALE_YN = 'Y'"
		+ " AND   A.LINE_NO = ? AND A.SEQ_NO = ?"
		+ " AND   A.SHOP_CD = S.SHOP_CD AND A.SALE_DATE = S.SALE_DATE AND A.ORDER_NO = S.ORDER_NO AND A.LINE_NO = S.LINE_NO"
		+ " AND   B.SHOP_CD = A.SHOP_CD AND B.SALE_DATE = A.SALE_DATE AND B.APPR_LOG_NO = A.APPR_LOG_NO";
	
	this.updateSslTrhdrSendStatus = "UPDATE SSL_TRHDR_T SET SEND_FG = ?, SEND_DT = strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME')"
		+ " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ?";
		
	//POS_ODCST_T
	this.insertPosOdcstT = "INSERT OR REPLACE INTO POS_ODCST_T(SHOP_CD, SALE_DATE, ORDER_NO, LINE_NO, POS_NO, SALE_YN"
		+ ", CST_NO, CST_CARD_NO, CST_CLS_CD, CST_USE_POINT, INS_DT, EMP_NO, CST_USE_AMT, CORNER_CD, SEQ_NO)"
    	+ "  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
    	+  		   "?, ?, ?, ?, ?)";	
	
	//SSL_TRCST_T
	this.insertSslTrcstT = "INSERT OR REPLACE INTO SSL_TRCST_T(SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, REGI_SEQ, SALE_YN"
		+ ", CST_NO, CST_CARD_NO, CST_CLS_CD, CST_USE_POINT, INS_DT, EMP_NO, CST_USE_AMT, CORNER_CD, SEQ_NO)"
		+ "  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "
		+  		   "?, ?, ?, ?, ?, ?)";	
	
	//SELECT INSERT SSL_TRCST_T
	this.selectInsertSslTrcstT = "INSERT OR REPLACE INTO SSL_TRCST_T(SHOP_CD,SALE_DATE,POS_NO,BILL_NO,LINE_NO,REGI_SEQ"
		+ ",SALE_YN,CST_NO,CST_CARD_NO,CST_CLS_CD,CST_USE_POINT,INS_DT,EMP_NO,CST_USE_AMT,CORNER_CD,SEQ_NO)"
		+ " SELECT SHOP_CD, SALE_DATE, POS_NO, ? AS BILL_NO, LINE_NO, ? AS REGI_SEQ, SALE_YN, CST_NO, CST_CARD_NO, CST_CLS_CD"
		+ ", CST_USE_POINT, INS_DT, EMP_NO, CST_USE_AMT, CORNER_CD, SEQ_NO"
        + " FROM POS_ODCST_T WHERE SHOP_CD = ? AND SALE_DATE = ? AND ORDER_NO = ? AND SALE_YN = 'Y'";
    
	this.selectLoginCheck = "SELECT EMP_NM, EMP_NO, EMP_FG, WEB_USE_YN, USER_ID "
        + " , USER_PWD, POSTING_YN "
        + " FROM SCD_EMPMS_T "
        + " WHERE SHOP_CD = ? "
        + " AND EMP_NO = ? "
     	+ " AND UPPER(EMP_PWD)   = UPPER(?) "
     	+ " AND RETIRE_FG = '0' "
     	+ " AND USE_YN    = 'Y'";
	
	//POS_CHGNO_T
	this.insertPosChgnoT = "INSERT OR REPLACE INTO POS_CHGNO_T(SHOP_CD, SALE_DATE, CHNAGE_BILL_NO)"
		+ "  VALUES(?, ?, ?)";	
    /****************hjjang**************/
    
    /** jean43069 start **/
    //고객 기초 정보 MS621
    this.sqlInsertHscCstmsT = " INSERT OR REPLACE INTO HCS_CSTMS_T "
						    +" ( "
						    +"    CST_OGN_CD  , CST_NO     , CST_NM          , CST_NM_ENG       , CST_CLS_CD "
						    +"  , INS_SHOP_CD , POST_NO    , ADDR            , SOLAR_YN         , SEX_FG "
						    +"  , HP_NO       , S_TEL_NO   , WEDDING_YN      , EMAIL_RECV_YN    , SMS_RECV_YN "
						    +"  , DM_RECV_YN  , TMP_INS_YN , CST_CARD_USE_FG , CST_CARD_ISS_CNT , USE_YN "
						    +"  , EMAIL_ADDR  , ADDR_DTL   , CST_CARD_NO     , RESI_NO          , BIRTH_DATE "
						    +"  , TEL_NO      , CSH_IDT_NO , WEDDING_DATE    , ORG_CST_CARD_NO  , CST_REMARK "
						    +"  , INS_DT      , UPD_DT     , WALLET_USE_YN "
						    +" ) VALUES ( "
						    +"    ?, ?, ?, ?, ?, "
						    +"    ?, ?, ?, ?, ?, "
						    +"    ?, ?, ?, ?, ?, "
						    +"    ?, ?, ?, ?, ?, "
						    +"    ?, ?, ?, ?, ?, "
						    +"    ?, ?, ?, ?, ?, "
						    +"    strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') ,  ? "
						    +" )  " ;
    
    this.sqlUpdateHscCstmsT = " UPDATE HCS_CSTMS_T "
						    +"     SET CST_NM=? , CST_NM_ENG=?    , CST_CLS_CD=? "
						    +"   	 , POST_NO=?    , ADDR=?          , SOLAR_YN=? "
						    +"       , SEX_FG=?     , HP_NO=?         , S_TEL_NO=? "
						    +"       , WEDDING_YN=? , EMAIL_RECV_YN=? , SMS_RECV_YN=? "
						    +"       , DM_RECV_YN=? , TMP_INS_YN=?    , CST_CARD_USE_FG=? "
						    +"       , CST_CARD_ISS_CNT=?         , USE_YN=? "
						    +"       , EMAIL_ADDR=? , ADDR_DTL=?      , CST_CARD_NO=? "
						    +"       , RESI_NO=?    , BIRTH_DATE=?    , TEL_NO=? "
						    +"       , CSH_IDT_NO=? , WEDDING_DATE=?  , ORG_CST_CARD_NO=? "
						    +"       , CST_REMARK=? , UPD_DT=strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') "
						    +"       , WALLET_USE_YN=?    , INS_SHOP_CD=? " 
						    +"   WHERE CST_OGN_CD=? AND CST_NO=? "
					    	;
    this.sqlDeleteHscCstmsT =" DELETE FROM HCS_CSTMS_T WHERE CST_OGN_CD=? AND CST_NO=? " ; 
    
    //고객 등급 정보  MS611
    this.sqlInsertHscCstclT =" INSERT OR REPLACE INTO HCS_CSTCL_T "
					    	+" ( "
					    	+"   CST_OGN_CD     , CST_CLS_CD    , CST_SEQ      , CST_CLS_NM     , DC_RATE "
					    	+" , ACC_UNIT_FG    , ACC_BASE_CSH  , ACC_BASE_CRD , ACC_BASE_GFT   , ACC_BASE_FOD "
					    	+" , ACC_BASE_JCD   , ACC_BASE_WES  , ACC_BASE_CST , ACC_BASE_RFC   , NEW_ENTRY_POINT "
					    	+" , MIN_USE_POINT  , BASE_CLS_YN   , INS_DT       , UPD_DT         , STAMP_ACC_FG "
					    	+" , STAMP_ACC_COST , STAMP_ACC_QTY , STAMP_USE_FG , STAMP_USE_COST , STAMP_USE_QTY "
					    	+" , DC_ACC_YN      , USE_ACC_YN    , ACC_BASE_CSB , MAX_USE_POINT "
					    	+" )VALUES(          "
					    	+"    ?, ?, ?, ?, ?, "
					    	+"    ?, ?, ?, ?, ?, "
					    	+"    ?, ?, ?, ?, ?, "
					    	+"    ?, ?, strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME'), strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME'), ?, "
					    	+"    ?, ?, ?, ?, ?, "
					    	+"    ?, ?, ?, ? "
					    	+" )  " ;
    
    this.sqlUpdateHscCstclT =  "UPDATE HCS_CSTCL_T "
					    	+"     SET CST_SEQ=? ,CST_CLS_NM=? ,DC_RATE=? ,ACC_UNIT_FG=? , "
					    	+"         ACC_BASE_CSH=? ,ACC_BASE_CRD=? ,ACC_BASE_GFT=? ,ACC_BASE_FOD=? , "
					    	+"         ACC_BASE_JCD=? ,ACC_BASE_WES=? ,ACC_BASE_CST=? ,ACC_BASE_RFC=? , "
					    	+"         NEW_ENTRY_POINT=? ,MIN_USE_POINT=? ,BASE_CLS_YN=? ,UPD_DT=strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') , "
					    	+"         STAMP_ACC_FG=? ,STAMP_ACC_COST=? , STAMP_ACC_QTY=? ,STAMP_USE_FG=? , "
					    	+"         STAMP_USE_COST=? ,STAMP_USE_QTY=? ,DC_ACC_YN=? ,USE_ACC_YN=? , "
					    	+"         ACC_BASE_CSB=? ,MAX_USE_POINT=?  "
					    	+"   WHERE CST_OGN_CD=? AND CST_CLS_CD=? "
					    	;
    
    this.sqlDeleteHscCstclT =" DELETE FROM HCS_CSTCL_T WHERE CST_OGN_CD=? AND CST_CLS_CD=? " ;
    
    // 고객 포인트 MS631
	this.sqlInsertHcsCstptT = " INSERT OR REPLACE INTO HCS_CSTPT_T "
							+" ( "
							+"  CST_OGN_CD       , CST_NO          , ACC_SALE_CNT "
							+", ACC_SALE_AMT     , ACC_POINT       , USE_POINT "
							+", AVL_POINT        , ADJ_POINT       , POINT_ACC_CNT "
							+", POINT_USE_CNT    , INS_SHOP_CD     , INS_ACC_SALE_CNT "
							+", INS_ACC_SALE_AMT , F_SALE_DATE     , L_SALE_DATE "
							+", INS_F_SALE_DATE  , INS_L_SALE_DATE , INS_DT "
							+", UPD_DT "
							+" )VALUES( "
							+"  ? ,? ,? "
							+", ? ,? ,? "
							+", ? ,? ,? "
							+", ? ,? ,? "
							+", ? ,? ,? "
							+", ? ,? ,strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') "
							+", strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') "
							+") " ;
	this.sqlUpdateHcsCstptT ="UPDATE HCS_CSTPT_T"
							+"   SET ACC_SALE_CNT=?     , ACC_SALE_AMT=?     , ACC_POINT=? "
							+"     , USE_POINT=?        , AVL_POINT = ?      , ADJ_POINT=? "
							+"     , POINT_ACC_CNT=?    , POINT_USE_CNT = ?  , INS_SHOP_CD=? "
							+"     , INS_ACC_SALE_CNT=? , INS_ACC_SALE_AMT=? , F_SALE_DATE=? "
							+"     , L_SALE_DATE=?      , INS_F_SALE_DATE=?  , INS_L_SALE_DATE=? "
							+"     , INS_DT=?           , UPD_DT=? "
		                    +" WHERE CST_OGN_CD=? AND CST_NO=? " ;
	
	this.sqlDeleteHcsCstptT =" DELETE FROM HCS_CSTPT_T WHERE CST_OGN_CD=? AND CST_NO=? " ;
	
	 // 매장-기능키관리 MS701
	this.sqlInsertScdFunkyT ="INSERT OR REPLACE INTO SCD_FUNKY_T "
							+"( "
							+"  SHOP_CD  , FK_NO      , FK_NM      , FK_FG  , AUTH_YN, "
							+"  FK_USE_YN, IMG_FILE_NM, POSITION_YN, PROD_CD, USE_YN, "
							+"  INS_DT   , UPD_DT "
							+")VALUES( "
							+"  ?, ?, ?, ?, ?, "
							+"  ?, ?, ?, ?, ?, "
							+"  strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME')   , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') "
							+") " ;
	
	this.sqlDeleteScdFunkyT ="DELETE FROM SCD_FUNKY_T WHERE SHOP_CD=? AND FK_NO=? " ;
	
	// 매장-포스별기능키설정(MS711)
	this.sqlInsertScdPosfkT = " INSERT OR REPLACE INTO SCD_POSFK_T "
							+" ( "
							+"  SHOP_CD  ,POS_NO    ,FK_NO      ,POSITION_NO ,COL_NUM  ,"
							+"  ROW_NUM  ,WIDTH_NUM ,HEIGHT_NUM ,USE_YN      ,GROUP_FG , "
							+"  IMG_TYPE ,INS_DT    ,UPD_DT "
							+" )VALUES( "
							+"  ?, ?, ?, ?, ?, "
							+"  ?, ?, ?, ?, ?, "
							+"  ?, strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME'), strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') "
							+" ) " ;
	
	this.sqlDeleteScdPosfkT = "DELETE FROM SCD_POSFK_T WHERE SHOP_CD=? AND POS_NO=? AND FK_NO=? " ;	
	
	//매장-사원구분기능키설정 MS721
	this.sqlInsertScdEmpfkT = "INSERT OR REPLACE INTO SCD_EMPFK_T "
	                        +"("
	                        +"  SHOP_CD , EMP_FG , FK_NO , "
	                        +"  USE_YN  , INS_DT , UPD_DT "
	                        +" )VALUES( "
	                        +" ? , ? , ?, "
	                        +" ? , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') "
	                        +") " ;
	
    this.sqlDeleteScdEmpfkT =" DELETE FROM SCD_EMPFK_T WHERE SHOP_CD=? AND EMP_FG=? AND FK_NO=? " ;
	
    // 진동벨 연동 MS911
    this.sqlInsertScdPagmsT =  " INSERT OR REPLACE INTO SCD_PAGMS_T "
					    	+" ( "
					    	+"   SHOP_CD , PAG_NO      , PAG_NM      "
					    	+" , POS_NO  , PAG_TYPE_FG , PAG_PORT    "
					    	+" , USE_YN  , INS_DT      , UPD_DT      "
					    	+" )VALUES( "
					    	+"   ? , ?, ? "
					    	+" , ? , ?, ? "
					    	+" , ? , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME'), strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') "
					    	+" ) " ;
    
    this.sqlDeleteScdPagmsT =  " DELETE FROM SCD_PAGMS_T WHERE SHOP_CD=? AND PAG_NO=? ";
    
    // KIOSK 터치분류 MS931
    this.sqlInsertScdKtclsT = "INSERT OR REPLACE INTO SCD_KTCLS_T "
					    	+"( "
					    	+"   SHOP_CD   ,TU_FG        ,TU_CLS_CD "
					    	+"  ,TU_CLS_NM ,TU_CLS_NM_EN ,TU_CLS_SEQ "
							+"  ,TU_CLS_DISP_FG, TU_CLS_PROC_FG, RECUR_S_DATE, RECUR_E_DATE, RECUR_TERM, RECUR_S_TIME, RECUR_E_TIME "
					    	+"  ,INS_DT    ,UPD_DT "
					    	+")VALUES( "
					    	+"   ?, ?, ? "
					    	+"  ,?, ?, ? "
					    	+"  ,?, ?, ?, ?, ?, ?, ? "
					    	+"  ,strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME'), strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') "
					    	+") "
					    	;
    this.sqlDeleteScdKtclsT = "DELETE FROM SCD_KTCLS_T WHERE SHOP_CD=? AND TU_CLS_CD=? ";
    
    // KIOSK 터치상품 MS941
    this.sqlInsertScdKtkeyT ="INSERT OR REPLACE INTO SCD_KTKEY_T "
					    	+"( "
					    	+"   SHOP_CD   ,TU_FG        ,TU_CLS_CD "
					    	+"  ,TU_KEY_CD ,TU_PROD_SEQ  ,PROD_CD "
					    	+"  ,INS_DT    ,UPD_DT "
					    	+")VALUES( "
					    	+"   ?, ?, ? "
					    	+"  ,?, ?, ? "
					    	+"  ,strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME'), strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') "
					    	+") "
					    	;
	this.sqlDeleteScdKtkeyT ="DELETE FROM SCD_KTKEY_T WHERE SHOP_CD=? AND TU_CLS_CD=? AND TU_KEY_CD=? " ;
    /** jean43069 end **/

	//터치상품분류
	this.sqlInsertScdTuclsT = "INSERT OR REPLACE INTO SCD_TUCLS_T ("
		+"\n    SHOP_CD     , TU_FG    , TU_CLS_CD  , TU_CLS_NM , TU_PAGE      ".rtrim()
		+"\n  , X           , Y        , WIDTH      , HEIGHT    , INS_DT       ".rtrim()
		+"\n  , UPD_DT      , BG_COLOR , FONT_COLOR , FONT_NAME , FONT_SIZE    ".rtrim()
		+"\n  )"
		+"\n  VALUES ( "
		+"\n    ? , ? , ? , ? , ? "
		+"\n  , ? , ? , ? , ? , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') "
		+"\n  , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') , ? , ? , ? , ? "
		+"\n  ) "
		;
	this.sqlDeleteScdTuclsT = "DELETE FROM SCD_TUCLS_T WHERE SHOP_CD = ? AND TU_FG = ? AND TU_CLS_CD = ? "; 
	this.sqlDeleteScdTukeyT = "DELETE FROM SCD_TUKEY_T WHERE SHOP_CD = ? AND TU_FG = ? AND TU_CLS_CD = ? AND TU_KEY_CD = ? "; 
	//터치상품
	this.sqlInsertScdTukeyT = ""
		+"\n  INSERT OR REPLACE INTO SCD_TUKEY_T (                                                                           ".rtrim()                                                                  
		+"\n      SHOP_CD     , TU_FG     , TU_CLS_CD     , TU_KEY_CD    , PROD_CD                                           ".rtrim()
		+"\n    , TU_PAGE     , X         , Y             , WIDTH        , HEIGHT                                            ".rtrim()
		+"\n    , INS_DT      , UPD_DT    , BG_COLOR      , FONT_COLOR   , FONT_NAME                                         ".rtrim()
		+"\n    , FONT_SIZE                                                                                                  ".rtrim()                                             
		+"\n  )                                                                                                              ".rtrim()
		+"\n  VALUES                                                                                                         ".rtrim()
		+"\n  (                                                                                                              ".rtrim()
		+"\n     ? , ? , ? , ? , ?                                                                                           ".rtrim()
		+"\n   , ? , ? , ? , ? , ?                                                                                           ".rtrim()
		+"\n   , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME') , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME'), ? , ? , ?    ".rtrim()
		+"\n   , ?                                                                                                           ".rtrim()
		+"\n  )                                                                                                              ".rtrim()
		;
	
	this.updatePosOdhdrBarodaUserData = "UPDATE POS_ODHDR_T SET BARODA_USER_DATA = ? 	".rtrim()
		+ " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND ORDER_NO = ?			".rtrim();
	this.updateSslTrhdrBarodaUserData = "UPDATE SSL_TRHDR_T SET BARODA_USER_DATA = ? 			".rtrim()
		+ " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ?			".rtrim();
	
    this.fnSelectQuery = function(srId, item){

        var lastSql = "";
        var sqlParams = {};

        //PROC_FG == "D"는 삭제
        if(item["_PROC_FG"] == "D"){
            sqlParams = sqlQuery.fnDeleteQueryParams(srId, item);
        }else {
            sqlParams = sqlQuery.fnInsertQueryParams(srId, item);
        }
        if ( util.isEmptyStr( sqlParams.sql )) {/////
        	throw "전문 [%s] 의 속성[%s]의 SQL 이 없습니다.".sprintf(srId, item["_PROC_FG"]);
        }
        var params = sqlParams.sqlParameter;
        var newParams = []

        for(var i=0; i<params.length; i++) {
            if(params[i] === undefined) {
                newParams.push(null);
            } else {
                newParams.push(params[i]);
            }
        }        
        lastSql = gfn_sqlBindParameters(sqlParams.sql, newParams );

        return lastSql;
    }
    
    this.fnSelectQueryForReceiptPrint = function(srId, orderItem, cardItem){

        var lastSql = "";
        var sqlParams = {};

        //PROC_FG == "D"는 삭제
        sqlParams = sqlQuery.fnInsertQueryParams(srId, item);
        
        if ( util.isEmptyStr( sqlParams.sql )) {
        	throw "전문 [%s] 의 속성[%s]의 SQL 이 없습니다.".sprintf(srId, "");
        }
        var params = sqlParams.sqlParameter;
        var newParams = []

        for(var i=0; i<params.length; i++) {
            if(params[i] === undefined) {
                newParams.push(null);
            } else {
                newParams.push(params[i]);
            }
        }
        lastSql = gfn_sqlBindParameters(sqlParams.sql, newParams );

        return lastSql;
    }

    this.fnInsertQueryParams = function(srId, item){

        var insDt = moment().format("YYYYMMDDHHmmss");
        var sql = "";
        var sqlParameter = [];
        switch (srId) {
            /****************hjjang**************/
	        //시스템-공통코드
	        case "MS011" :
	            sql = sqlQuery.sqlInsertCcdCodemT;
	        	sqlParameter = [ item["_COM_CD_FG"], item["_COM_CD"], item["_COM_CD_NM"], item["_COM_CD_ITEM_01"], item["_COM_CD_ITEM_02"] ];
                //전문에서  USE_YN 값이 없다  일단 강제로 세팅
                if(item["_USE_YN"] === null || item["_USE_YN"] === undefined) item["_USE_YN"] = "Y";
                sqlParameter.push( item["_USE_COL_NM"], item["_USE_YN"], insDt, item["_UPD_DT"]);
	        	break;

	        case "MS021" :
	            sql = sqlQuery.sqlInsertCcdEnvhdT;
	        	sqlParameter = [ item["_ENV_SET_CD"], item["_ENV_SET_NM"], item["_ENV_SET_FG"], item["_ENV_GRP_CD"] ];
	            sqlParameter.push( item["_USE_YN"], item["_REMARK"], insDt, item["_UPD_DT"]);
	        	break;

	        case "MS031" :
	            sql = sqlQuery.sqlInsertCcdEnvdtT;
	        	sqlParameter = [ item["_ENV_SET_CD"], item["_ENV_VAL_CD"], item["_ENV_VAL_NM"]];
	            sqlParameter.push( item["_USE_YN"], insDt, item["_UPD_DT"]);
	        	break;

	        case "MS041" :
	        	sql = sqlQuery.sqlInsertCcdEnvpdT;
	        	sqlParameter = [
	        	  item["_OGN_CD"]        	, item["_CODE_CD"]        	, item["_CODE_LEN"]        	
	        	  , util.byteLen( item["_PROD_SEQ_NO"]  )==0?'':item["_PROD_SEQ_NO" ] 
	        	  , util.byteLen( item["_PROD_CD_YN"  ] )==0?'':item["_PROD_CD_YN"  ]
	        	  , util.byteLen( item["_STYLE_SEQ_NO"] )==0?'':item["_STYLE_SEQ_NO"]
	        	  , util.byteLen( item["_STYLE_CD_YN" ] )==0?'':item["_STYLE_CD_YN" ]
	        	  , item["_USE_YN"]        	, item["_DIRECT_YN"]
	        	];
	        	break;
	        	
	        case "MS051" :
	            sql = sqlQuery.sqlInsertScdPrintT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_PRT_CLS_CD"], item["_PRT_FORM"]];
	            sqlParameter.push( insDt, item["_UPD_DT"]);
	        	break;

	        case "MS061" :
	            sql = sqlQuery.sqlInsertScdPosfnT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_EMP_FG"], item["_POS_FN_NO"], item["_POS_FN_NM"]
                                , item["_POS_FN_FG"], item["_POS_FN_LOC"], item["_AUTH_YN"], item["_ORG_POS_FN_NO"]
                                , item["_FN_USE_YN_0"], item["_FN_USE_YN_1"], item["_IMG_FILE_NM_1"]
                                , item["_IMG_FILE_NM_2"], item["_MAIN_DISP_FG"], insDt, item["_UPD_DT"]
                                ];
	        	break;

	        case "MS071" : // 카드사정보 CCD_CRDCP_T
	        	sql = sqlQuery.sqlInsertCcdCrdcpT;
	        	sqlParameter = [ item["_CRDCP_CD"]  , item["_CRDCP_NM"] ];
	        	break;

	        case "MS081" : //밴사별카드사정보 CCD_VANCM_T
	            sql = sqlQuery.sqlInsertCcdVancmT;
	        	sqlParameter = [  item["_VAN_CD"] , item["_VAN_CRDCP_CD"] , item["_VAN_CRDCP_NM"] , item["_CRDCP_CD"] ];
	        	break;

	        case "MS101" :
	            sql = sqlQuery.sqlInsertScdShopmT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SHOP_NM"], item["_HD_SHOP_CD"], item["_SHOP_GROUP_CD"]
                            , item["_SHOP_TYPE_FG"], item["_SHOP_CLS_FG"], item["_PGM_TYPE_FG"], item["_OWNER_NM"]
                            , item["_BIZ_NO"], item["_BIZ_TYPE_NM"], item["_BIZ_KIND_NM"], item["_BIZ_SHOP_NM"]
                            , item["_TEL_NO"], item["_HP_NO"], item["_FAX_NO"], item["_EMAIL_ADDR"], item["_POST_NO"]
                            , item["_ADDR"], item["_ADDR_DTL"], item["_SHOP_STAT_FG"], item["_SHOP_OPEN_DATE"]
                            , item["_SYS_OPEN_DATE"], item["_SYS_CLOSE_DATE"], item["_CLS_MGR_LEVEL_FG"], item["_WARE_YN"]
                            , item["_BRAND_MGR_YN"], item["_SALEMG_MGR_YN"], insDt, item["_UPD_DT"], item["_VAN_CORP_CD"]
                            , item["_POINT_FG"], item["_WALLET_JOIN_YN"], item["_IC_PRE_TYPE"], item["_NO_CVM_AMT"]
                            ];
                break;

	        case "MS111" :
	            sql = sqlQuery.sqlInsertScdShopsT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_CORNER_CD"], item["_CORNER_NM"], item["_OWNER_NM"]
                                , item["_BIZ_NO"], item["_TEL_NO"], item["_CSH_FEE_RATE"], item["_CRD_FEE_RATE"]
                                , item["_ETC_FEE_RATE"], item["_VAN_CD"], item["_VAN_TERM_NO"], item["_CASH_VAN_CD"]
                                , item["_CASH_VAN_TERM_NO"], item["_USE_YN"], insDt, item["_UPD_DT"], item["_VAN_SER_NO"]
                                , item["_CASH_VAN_SER_NO"], item["_VAN_CERT_YN"], item["_VAN_CERT_SDT"], item["_VAN_CERT_EDT"]
                                , item["_VAN_CERT_CNT"], item["_SEND_FG"], item["_SEND_DT"], item["_WORK_INDEX"]
                                , item["_WORK_KEY"], item["_OKCBG_TERM_NO"], item["_OKCBG_SER_NO"], item["_W_KEY"]
	        					, item["_CORNER_SEQ"], item["_IMG_URL"], item["_IMG_URL_FG"]
                                ];
                break;
                
	        case "MS121" :
	            sql = sqlQuery.sqlInsertScdCodemT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_COM_CD_FG"], item["_COM_CD"], item["_COM_CD_NM"]
                                , item["_COM_CD_ITEM_01"], item["_COM_CD_ITEM_02"], item["_USE_YN"], item["_INS_DT"]
                                , item["_UPD_DT"]
                                ];
                break;
                
	        case "MS131" :
	            sql = sqlQuery.sqlInsertScdEnvshT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_ENV_SET_CD"], item["_ENV_SET_VAL"], item["_USE_YN"]
                                , insDt, item["_UPD_DT"]
                                ];
                break;

	        case "MS141" :
	            sql = sqlQuery.sqlInsertScdEnvkpT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_KIT_PRT_NO"], item["_ENV_SET_CD"], item["_ENV_SET_VAL"]
                                , item["_USE_YN"], insDt, item["_UPD_DT"]
                                ];
                break;

	        case "MS151" :
	            sql = sqlQuery.sqlInsertScdEnvpsT;
                sqlParameter = [ item["_SHOP_CD"], item["_POS_NO"], item["_ENV_SET_CD"], item["_ENV_SET_VAL"]
                                , item["_USE_YN"], item["_MODIFY_FG"], insDt, item["_UPD_DT"]
                                , item["_SEND_FG"], item["_SEND_DT"]
                                ];
                break;

	        case "MS161" :
	            sql = sqlQuery.sqlInsertScdEmpmsT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_EMP_NO"], item["_EMP_NM"], item["_EMP_PWD"]
                                , item["_EMP_FG"], item["_EMP_CLASS_CD"], item["_WEB_USE_YN"], item["_USER_ID"]
                                , item["_USER_PWD"], item["_POSTING_YN"], item["_ORDER_FG"], item["_EMP_CARD_NO"]
                                , item["_TEL_NO"], item["_POST_NO"], item["_ADDR"], item["_ADDR_DTL"]
                                , item["_RETIRE_FG"], item["_SMS_RECV_YN"], item["_USE_YN"]
                                , insDt, item["_UPD_DT"]
                                ];
                break;

	        case "MS171" :
	            sql = sqlQuery.sqlInsertScdPosmsT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_POS_NO"], item["_POS_REMARK"], item["_LOCAL_DB_YN"]
                                , item["_USE_YN"], item["_CRD_VAN_SEQ"], item["_CASH_VAN_SEQ"], item["_IP_ADDR"]
                                , insDt, item["_UPD_DT"], item["_FLOOR_NO"], item["_VAN_TERM_NO"]
                                , item["_VAN_CERT_YN"], item["_VAN_CERT_SDT"], item["_VAN_CERT_EDT"], item["_VAN_CERT_CNT"]
                                , item["_SEND_FG"], item["_SEND_DT"], item["_WORK_INDEX"], item["_WORK_KEY"]
                                , item["_OCB_TERM_NO"], item["_OCB_SER_NO"], item["_W_KEY"], item["_VAN_SER_NO"], item["_PM_FG"]
                                ];
                break;

	        case "MS401" :
	            sql = sqlQuery.sqlInsertScdFdtblT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_FD_TBL_CD"], item["_FD_TBL_NM"], item["_FD_CLS_CD"]
                                , item["_USE_YN"], insDt, item["_UPD_DT"]
                                ];
                break;

	        case "MS411" :
	            sql = sqlQuery.sqlInsertScdTbgrpT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_TG_CD"], item["_TG_NM"], item["_TG_FG"]
                    , item["_TG_BGIMAGE"], item["_TG_SORT"], item["_USE_YN"]
                    , insDt, item["_UPD_DT"], item["_TU_CLS_CD"]
                    ];
                break;
                
		    //매장-테이블정보
	        case "MS441" :
	            sql = sqlQuery.sqlInsertScdTableT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_TABLE_CD"], item["_TABLE_NM"], item["_TG_CD"]
                    , item["_GROUP_CD"], item["_SEAT_NUM"], item["_X"], item["_Y"]
                    , item["_WIDTH"], item["_HEIGHT"], item["_SHAPE_FG"], item["_TABLE_FG"]
                    , item["_USE_YN"], item["_STATUS_FG"], item["_LOCK_POS_NO"], item["_LOCK_FG"]
                    , insDt, item["_UPD_DT"], item["_CID_TEL_NO"], item["_CID_LINE_NO"]
                    , item["_NEW_CST_FG"], item["_CST_NO"], item["_CST_NM"], item["_DLV_ADDR"]
                    , item["_DLV_ADDR_DTL"], item["_DLV_PROC_FG"], item["_DLV_ORDER_NO"], item["_DLV_CL_CD"]
                    , item["_DLV_CM_CD"], item["_CID_CALL_DT"], item["_PKG_TBL_YN"]
                    ];
                break;

            //터치분류
	        case "MS471" :
	        	sql = sqlQuery.sqlInsertScdTuclsT;
				sqlParameter = [
					  item["_SHOP_CD"]       , item["_TU_FG"]         , item["_TU_CLS_CD"]   , item["_TU_CLS_NM"]    , item["_TU_PAGE"]					  
					, item["_X"]             , item["_Y"]             , item["_WIDTH"]       , item["_HEIGHT"]       , item["_BG_COLOR"]
					, item["_FONT_COLOR"]    , item["_FONT_FAMILY"]   , item["_FONT_SIZE"]  
	        	];
	        	break;
	        	
	        //터치상품
	        case "MS481" :
	        	sql = sqlQuery.sqlInsertScdTukeyT;
	        	sqlParameter = [
	        		  item["_SHOP_CD"]     , item["_TU_FG"]       , item["_TU_CLS_CD"]    , item["_TU_KEY_CD"]    , item["_PROD_CD"]
	        		, item["_TU_PAGE"]     , item["_X"]           , item["_Y"]            , item["_WIDTH"]        , item["_HEIGHT"]
	        		, item["_BG_COLOR"]    , item["_FONT_COLOR"]  , item["_FONT_FAMILY"]
	        		, item["_FONT_SIZE"]
	        		];
	        	break;
	        	
        	// 이통사
	        case "MS531" :
	        	sql = sqlQuery.sqlInsertScdJcdhdT;
	        	sqlParameter = [
	        		  item["_SHOP_CD"]     , item["_JCD_CD"]       , item["_JCD_NM"]    , item["_JCD_TYPE_FG"]    , item["_VALID_F_DATE"]
	        		, item["_VALID_T_DATE"]     , item["_DC_PROD_FG"]           , item["_DC_RATE"]            , item["_DC_LIMIT_FG"]        , item["_DC_LIMIT_AMT"]
	        		, item["_APPR_PROC_FG"]    , item["_REMARK"]  , insDt, insDt
	        		];
	        	break;	
	        	
	        // 이통사
	        case "MS541" :
	        	sql = sqlQuery.sqlInsertScdJcddtT;
	        	sqlParameter = [
	        		  item["_SHOP_CD"]     , item["_JCD_CD"]       , item["_PROD_CD"]    , item["_DC_RATE"]    , insDt
	        		, insDt
	        		];
	        	break;
	        	
            //매출TR-HEADER
	        case "TRHDR" :
	            sql = sqlQuery.sqlInsertSslTrhdrT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"]
                    , item["_REGI_SEQ"], item["_SALE_YN"], item["_TOT_SALE_AMT"], item["_TOT_DC_AMT"]
                    , item["_SVC_TIP_AMT"], item["_TOT_ETC_AMT"], item["_DCM_SALE_AMT"], item["_VAT_SALE_AMT"]
                    , item["_VAT_AMT"], item["_NO_VAT_SALE_AMT"], item["_NO_TAX_SALE_AMT"], item["_EXP_PAY_AMT"]
                    , item["_GST_PAY_AMT"], item["_RET_PAY_AMT"], item["_CASH_AMT"], item["_CRD_CARD_AMT"]
                    , item["_WES_AMT"], item["_TK_GFT_AMT"], item["_TK_FOD_AMT"], item["_CST_POINT_AMT"]
                    , item["_JCD_CARD_AMT"], item["_RFC_AMT"], item["_ETC_APPR_AMT"], item["_CST_NO"]
                    , item["_CST_CARD_NO"], item["_CST_SALE_POINT"], item["_DC_GEN_AMT"], item["_DC_SVC_AMT"]
                    , item["_DC_PCD_AMT"], item["_DC_CPN_AMT"], item["_DC_CST_AMT"], item["_DC_TFD_AMT"], item["_DC_PRM_AMT"]
                    , item["_DC_CRD_AMT"], item["_DC_PACK_AMT"], item["_DC_LYT_AMT"], item["_REPAY_CASH_AMT"]
                    , item["_REPAY_TK_GFT_AMT"], item["_CASH_BILL_AMT"], item["_DLV_ORDER_FG"], item["_FD_TBL_CD"]
                    , item["_FD_GST_CNT_T"], item["_FD_GST_CNT_1"], item["_FD_GST_CNT_2"], item["_FD_GST_CNT_3"]
                    , item["_FD_GST_CNT_4"], item["_ORG_BILL_NO"], item["_ORDER_NO"], item["_INS_DT"], item["_UPD_DT"]
                    , item["_UPD_ID"], item["_EMP_NO"], item["_SEND_FG"], item["_SEND_DT"]
                    , item["_PAY_OUT_DT"], item["_CST_NM"], item["_DLV_EMP_NO"], item["_DLV_START_DT"]
                    , item["_DLV_PAYIN_EMP_NO"], item["_DLV_PAYIN_DT"], item["_NEW_DLV_ADDR_YN"], item["_DLV_ADDR"]
                    , item["_DLV_ADDR_DTL"], item["_NEW_DLV_TEL_NO_YN"], item["_DLV_TEL_NO"], item["_DLV_CL_CD"]
                    , item["_DLV_CM_CD"], item["_TRAVEL_CD"], item["_RSV_NO"], item["_PRE_PAY_CASH"]
                    , item["_PRE_PAY_CARD"], item["_RSV_USER_NM"], item["_RSV_USER_TEL_NO"], item["_CST_AVL_POINT"]
                    , item["_LOCAL_POINT_YN"], item["_CST_USE_POINT"], item["_CANCEL_REASON"], item["_CUP_DEPOSIT_AMT"]
                    ];
                break;

	        //매출TR-상품-DETAIL
	        case "TRDTL" :
	            sql = sqlQuery.sqlInsertSslTrdtlT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"]
                    , item["_DTL_NO"], item["_REGI_SEQ"], item["_SALE_YN"], item["_PROD_CD"]
                    , item["_PROD_TYPE_FG"], item["_CORNER_CD"], item["_CHG_BILL_NO"], item["_TAX_YN"]
                    , item["_DLV_PACK_FG"], item["_PROP_CD"]
                    , item["_PROP_VAL"], item["_ORG_SALE_MG_CD"], item["_ORG_SALE_UPRC"], item["_NORMAL_UPRC"]
                    , item["_SALE_MG_CD"], item["_SALE_QTY"], item["_SALE_UPRC"], item["_SALE_AMT"]
                    , item["_SALE_WEIGHT"], item["_DC_AMT"], item["_ETC_AMT"], item["_SVC_TIP_AMT"]
                    , item["_DCM_SALE_AMT"], item["_VAT_AMT"], item["_SVC_CD"], item["_TK_CPN_CD"]
                    , item["_DC_AMT_GEN"], item["_DC_AMT_SVC"], item["_DC_AMT_JCD"], item["_DC_AMT_CPN"]
                    , item["_DC_AMT_CST"], item["_DC_AMT_FOD"], item["_DC_AMT_PRM"], item["_DC_AMT_CRD"]
                    , item["_DC_AMT_PACK"], item["_DC_AMT_LYT"], item["_CST_SALE_POINT"], item["_CST_USE_POINT"]
                    , item["_PRM_PROC_YN"], item["_PRM_CD"], item["_PRM_SEQ"], item["_SDA_CD"]
                    , item["_SDS_ORG_DTL_NO"], item["_INS_DT"], item["_EMP_NO"], item["_CUP_SALE_CNT"], item["_CUP_DEPOSIT_UPRC"]
	        		, item["_CUP_FG"]
                    ];
            break;
            
            //영수증 출력전 주문정보 받아서 DB 저장용으로 사용 -> XXXXX_R 형태
	        case "TRDTL_R" :
	            sql = sqlQuery.sqlInsertSslTrdtlT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["POS_NO"], item["BILL_NO"]
                    , item["DTL_NO"], item["REGI_SEQ"], item["SALE_YN"], item["PROD_CD"]
                    , item["PROD_TYPE_FG"], item["CORNER_CD"], item["CHG_BILL_NO"], item["TAX_YN"]
                    , item["DLV_PACK_FG"], item["PROP_CD"]
                    , item["PROP_VAL"], item["ORG_SALE_MG_CD"], item["ORG_SALE_UPRC"], item["NORMAL_UPRC"]
                    , item["SALE_MG_CD"], item["SALE_QTY"], item["SALE_UPRC"], item["SALE_AMT"]
                    , item["SALE_WEIGHT"], item["DC_AMT"], item["ETC_AMT"], item["SVC_TIP_AMT"]
                    , item["DCM_SALE_AMT"], item["VAT_AMT"], item["SVC_CD"], item["TK_CPN_CD"]
                    , item["DC_AMT_GEN"], item["DC_AMT_SVC"], item["DC_AMT_JCD"], item["DC_AMT_CPN"]
                    , item["DC_AMT_CST"], item["DC_AMT_FOD"], item["DC_AMT_PRM"], item["DC_AMT_CRD"]
                    , item["DC_AMT_PACK"], item["DC_AMT_LYT"], item["CST_SALE_POINT"], item["CST_USE_POINT"]
                    , item["PRM_PROC_YN"], item["PRM_CD"], item["PRM_SEQ"], item["SDA_CD"]
                    , item["SDS_ORG_DTL_NO"], item["INS_DT"], item["EMP_NO"], item["CUP_SALE_CNT"], item["CUP_DEPOSIT_UPRC"]
        			, item["CUP_FG"]
                    ];
            break;
                
	        case "TRCSH" :
	            sql = sqlQuery.sqlInsertSslTrcshT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"]
                    , item["_LINE_NO"], item["_SEQ_NO"], item["_REGI_SEQ"], item["_SALE_YN"]
                    , item["_VAN_CD"], item["_CORNER_CD"], item["_CASH_AMT"], item["_APPR_AMT"]
                    , item["_SVC_TIP_AMT"], item["_VAT_AMT"], item["_APPR_PROC_FG"], item["_APPR_IDT_TYPE"]
                    , item["_APPR_IDT_FG"], item["_CARD_IN_FG"], item["_APPR_IDT_NO"], item["_APPR_DATE"]
                    , item["_APPR_TIME"], item["_APPR_NO"], item["_APPR_MSG"], item["_VAN_TERM_NO"]
                    , item["_VAN_SLIP_NO"], item["_ORG_APPR_DATE"], item["_ORG_APPR_NO"], item["_APPR_LOG_NO"]
                    , item["_INS_DT"], item["_EMP_NO"], item["_EX_CD"], item["_EX_KRW"]
                    , item["_EX_EXP_AMT"], item["_EX_IN_AMT"], item["_EX_RET_AMT"], item["_KR_RET_AMT"]
                    , item["_EX_PAY_AMT"], item["_KR_PAY_AMT"], item["_KR_ETC_AMT"], item["_PRE_PAY_FG"]
                    , item["_NOTICE_MSG"], item["_BROAD_MSG"], item["_CNMK_CD"], item["_SEC_FLAG"]
                    , item["_VAT_SALE_AMT"], item["_NO_VAT_SALE_AMT"]
                    ];
                break;
                
	        case "TRCRD" :
	            sql = sqlQuery.sqlInsertSslTrcrdT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"]
                    , item["_LINE_NO"], item["_SEQ_NO"], item["_REGI_SEQ"], item["_SALE_YN"]
                    , item["_VAN_CD"], item["_CORNER_CD"],item["_APPR_PROC_FG"],  item["_CRD_CARD_NO"], item["_APPR_REQ_AMT"]
                    , item["_SVC_TIP_AMT"], item["_VAT_AMT"], item["_INST_MM_FG"], item["_INST_MM_CNT"]
                    , item["_VALID_TERM"], item["_SIGN_PAD_YN"], item["_CARD_IN_FG"], item["_APPR_DATE"]
                    , item["_APPR_TIME"], item["_APPR_NO"], item["_CRDCP_CD"], item["_ISS_CRDCP_CD"]
                    , item["_ISS_CRDCP_NM"], item["_PUR_CRDCP_CD"], item["_PUR_CRDCP_NM"], item["_APPR_AMT"]
                    , item["_APPR_DC_AMT"], item["_APPR_MSG"], item["_VAN_TERM_NO"], item["_VAN_SLIP_NO"]
                    , item["_CRDCP_TERM_NO"], item["_ORG_APPR_DATE"], item["_ORG_APPR_NO"], item["_APPR_LOG_NO"]
                    , item["_INS_DT"], item["_EMP_NO"], item["_PRE_PAY_FG"], item["_LYT_APPR_FG"]
                    , item["_LYT_APPR_INFO"], item["_GIFT_CASH"], item["_NOTICE_MSG"], item["_BROAD_MSG"]
                    , item["_CNMK_CD"], item["_UNION_PAY_FG"], item["_DDC_FLAG"], item["_SEC_FLAG"]
                    , item["_VAT_SALE_AMT"], item["_NO_VAT_SALE_AMT"]
                    ];
            break;
            
            //영수증 출력전 결제정보 받아서 DB 저장용으로 사용 -> XXXXX_R 형태
	        case "TRCRD_R" :
	        	sql = sqlQuery.sqlInsertSslTrcrdT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["POS_NO"], item["BILL_NO"]
	        	, item["LINE_NO"], item["SEQ_NO"], item["REGI_SEQ"], item["SALE_YN"]
	        	, item["VAN_CD"], item["CORNER_CD"],item["APPR_PROC_FG"],  item["CRD_CARD_NO"], item["APPR_REQ_AMT"]
	        	, item["SVC_TIP_AMT"], item["VAT_AMT"], item["INST_MM_FG"], item["INST_MM_CNT"]
	        	, item["VALID_TERM"], item["SIGN_PAD_YN"], item["CARD_IN_FG"], item["APPR_DATE"]
	        	, item["APPR_TIME"], item["APPR_NO"], item["CRDCP_CD"], item["ISS_CRDCP_CD"]
	        	, item["ISS_CRDCP_NM"], item["PUR_CRDCP_CD"], item["PUR_CRDCP_NM"], item["APPR_AMT"]
	        	, item["APPR_DC_AMT"], item["APPR_MSG"], item["VAN_TERM_NO"], item["VAN_SLIP_NO"]
	        	, item["CRDCP_TERM_NO"], item["ORG_APPR_DATE"], item["ORG_APPR_NO"], item["APPR_LOG_NO"]
	        	, item["INS_DT"], item["EMP_NO"], item["PRE_PAY_FG"], item["LYT_APPR_FG"]
	        	, item["LYT_APPR_INFO"], item["GIFT_CASH"], item["NOTICE_MSG"], item["BROAD_MSG"]
	        	, item["CNMK_CD"], item["UNION_PAY_FG"], item["DDC_FLAG"], item["SEC_FLAG"]
	        	, item["VAT_SALE_AMT"], item["NO_VAT_SALE_AMT"]
	        	];
	        break;

	        case "TRPSQ" :
	            sql = sqlQuery.sqlInsertSslTrpsqT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"], item["_PAY_SEQ_NO"]
                    , item["_REGI_SEQ"], item["_SALE_YN"], item["_PAY_TYPE_FG"], item["_PAY_AMT"]
                    , item["_LINE_NO"], item["_INS_DT"], item["_UPD_DT"], item["_EMP_NO"]
                    ]
            break;
	        
	        //영수증 출력전 결제정보 받아서 DB 저장용으로 사용 -> XXXXX_R 형태	
	        case "TRPSQ_R" :
	        	sql = sqlQuery.sqlInsertSslTrpsqT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["POS_NO"], item["BILL_NO"], item["PAY_SEQ_NO"]
	        	, item["REGI_SEQ"], item["SALE_YN"], item["PAY_TYPE_FG"], item["PAY_AMT"]
	        	, item["LINE_NO"], item["INS_DT"], item["UPD_DT"], item["EMP_NO"]
	        	]
        	break;

	        case "TRCST" :
	            sql = sqlQuery.sqlInsertSslTrcstT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"]
                    , item["_LINE_NO"], item["_REGI_SEQ"], item["_SALE_YN"], item["_CST_NO"]
                    , item["_CST_CARD_NO"], item["_CST_CLS_CD"], item["_CST_USE_POINT"], item["_INS_DT"]
                    , item["_EMP_NO"], item["_CST_USE_AMT"], item["_CORNER_CD"], item["_SEQ_NO"]
                    ]
      		break;
	        	
		    case "TRJCD" :
		        sql = sqlQuery.sqlInsertSslTrjcdT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"], item["_LINE_NO"]
                    , item["_SEQ_NO"], item["_REGI_SEQ"], item["_SALE_YN"], item["_VAN_CD"], item["_CORNER_CD"]
                    , item["_APPR_PROC_FG"], item["_JCD_CD"], item["_JCD_TYPE_FG"], item["_JCD_PROC_FG"], item["_JCD_CARD_NO"]
                    , item["_JCD_CARD_PWD"], item["_APPR_AMT"], item["_VALID_TERM"], item["_SIGN_PAD_YN"], item["_CARD_IN_FG"]
                    , item["_APPR_DATE"], item["_APPR_TIME"], item["_APPR_NO"], item["_JCD_DC_AMT"], item["_JCD_OCC_POINT"]
                    , item["_JCD_AVL_POINT"], item["_JCD_USE_POINT"], item["_JCD_REM_POINT"], item["_APPR_MSG"], item["_VAN_TERM_NO"]
                    , item["_VAN_SLIP_NO"], item["_CRDCP_TERM_NO"], item["_ORG_APPR_DATE"], item["_ORG_APPR_NO"], item["_APPR_LOG_NO"]
                    , insDt, item["_EMP_NO"], item["_BROAD_MSG"], item["_JCD_PAY_FG"], item["_CNMK_CD"]
	        	    , item["_TEST"], item["_SEC_FLAG"]
                    ];
            break;

	        case "TRGFT" :
	            sql = sqlQuery.sqlInsertSslTrgftT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"]
                    , item["_LINE_NO"], item["_REGI_SEQ"], item["_SALE_YN"], item["_TK_GFT_UAMT"]
                    , item["_TK_GFT_AMT"], item["_REPAY_CSH_AMT"], item["_REPAY_GFT_AMT"], item["_INS_DT"]
                    , item["_EMP_NO"]
                    ];
                break;

	        case "TRWES" :
	            sql = sqlQuery.sqlInsertSslTrwesT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"]
                    , item["_LINE_NO"], item["_REGI_SEQ"], item["_SALE_YN"], item["_WES_CST_NO"]
                    , item["_WES_AMT"], item["_WES_REMARK"], item["_INS_DT"], item["_EMP_NO"]
                    , item["_WES_FG"]
                    ];
                break;

	        case "TRGST" :
	            sql = sqlQuery.sqlInsertSslTrgstT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"]
                    , item["_LINE_NO"], item["_REGI_SEQ"], item["_SALE_YN"], item["_FD_GST_CLS_1"]
                    , item["_FD_GST_CLS_2"], item["_FD_GST_CNT"], item["_INS_DT"], item["_EMP_NO"]
                    ];
                break;

	        case "TRFOD" :
	            sql = sqlQuery.sqlInsertSslTrfodT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"]
                    , item["_LINE_NO"], item["_REGI_SEQ"], item["_SALE_YN"], item["_TK_FOD_UAMT"]
                    , item["_TK_FOD_AMT"], item["_TK_FOD_DC_AMT"], item["_ETC_AMT"], item["_INS_DT"]
                    , item["_EMP_NO"]
                    ];
                break;
            
	        case "MS451" :
	            sql = sqlQuery.sqlInsertScdPrtmsT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_PRT_NO"], item["_PRT_NM"], item["_POS_NO"]
                    , item["_PRT_TYPE_FG"], item["_PRT_PORT"], item["_PRT_SPEED"], item["_USE_YN"]
                    , item["_INS_DT"], item["_UPD_DT"], item["_PRT_PAPER_QTY"], item["_FLOOR_NO"]
                    , item["_FLOOR_FG"]
                    ];
                break;
                
	        case "MS461" :
	            sql = sqlQuery.sqlInsertScdPrtprT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_PROD_CD"], item["_PRT_NO"], item["_USE_YN"]
                    , item["_INS_DT"], item["_UPD_DT"]
                    ];
                break;
                
	        case "SI391" :
	            sql = sqlQuery.sqlInsertPosRegisT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_REGI_SEQ"]
                    , item["_EMP_NO"], item["_CLOSE_FG"], item["_OPEN_DT"], item["_CLOSE_DT"]
                    , item["_TOT_BILL_CNT"], item["_TOT_SALE_AMT"], item["_TOT_DC_AMT"], item["_SVC_TIP_AMT"]
                    , item["_TOT_ETC_AMT"], item["_DCM_SALE_AMT"], item["_VAT_SALE_AMT"], item["_VAT_AMT"]
                    , item["_NO_VAT_SALE_AMT"], item["_NO_TAX_SALE_AMT"], item["_RET_BILL_CNT"], item["_RET_BILL_AMT"]
                    , item["_VISIT_CST_CNT"], item["_POS_READY_AMT"], item["_POS_CSH_IN_AMT"], item["_POS_CSH_OUT_AMT"]
                    , item["_WEA_IN_CSH_AMT"], item["_WEA_IN_CRD_AMT"], item["_TK_GFT_SALE_CSH_AMT"], item["_TK_GFT_SALE_CRD_AMT"]
                    , item["_TK_FOD_SALE_CSH_AMT"], item["_TK_FOD_SALE_CRD_AMT"], item["_CASH_CNT"], item["_CASH_AMT"]
                    , item["_CASH_BILL_CNT"], item["_CASH_BILL_AMT"], item["_CRD_CARD_CNT"], item["_CRD_CARD_AMT"]
                    , item["_WES_CNT"], item["_WES_AMT"], item["_TK_GFT_CNT"], item["_TK_GFT_AMT"]
                    , item["_TK_FOD_CNT"], item["_TK_FOD_AMT"], item["_CST_POINT_CNT"], item["_CST_POINT_AMT"]
                    , item["_JCD_CARD_CNT"], item["_JCD_CARD_AMT"], item["_RFC_CNT"], item["_RFC_AMT"]
                    , item["_ETC_APPR_CNT"], item["_ETC_APPR_AMT"], item["_DC_GEN_CNT"], item["_DC_GEN_AMT"]
                    , item["_DC_SVC_CNT"], item["_DC_SVC_AMT"], item["_DC_JCD_CNT"], item["_DC_JCD_AMT"]
                    , item["_DC_CPN_CNT"], item["_DC_CPN_AMT"], item["_DC_CST_CNT"], item["_DC_CST_AMT"]
                    , item["_DC_TFD_CNT"], item["_DC_TFD_AMT"], item["_DC_PRM_CNT"], item["_DC_PRM_AMT"]
                    , item["_DC_CRD_CNT"], item["_DC_CRD_AMT"], item["_DC_PACK_CNT"], item["_DC_PACK_AMT"]
                    , item["_REM_CHECK_CNT"], item["_REM_CHECK_AMT"], item["_REM_W100000_CNT"], item["_REM_W50000_CNT"]
                    , item["_REM_W10000_CNT"], item["_REM_W5000_CNT"], item["_REM_W1000_CNT"], item["_REM_W500_CNT"]
                    , item["_REM_W100_CNT"], item["_REM_W50_CNT"], item["_REM_W10_CNT"], item["_REM_CASH_AMT"]
                    , item["_REM_TK_GFT_CNT"], item["_REM_TK_GFT_AMT"], item["_REM_TK_FOD_CNT"], item["_REM_TK_FOD_AMT"]
                    , item["_ETC_TK_FOD_AMT"], item["_LOSS_CASH_AMT"], item["_LOSS_TK_GFT_AMT"], item["_LOSS_TK_FOD_AMT"]
                    , item["_REPAY_CASH_CNT"], item["_REPAY_CASH_AMT"], item["_REPAY_TK_GFT_CNT"], item["_REPAY_TK_GFT_AMT"]
                    , item["_INS_DT"], item["_SEND_FG"], item["_SEND_DT"]
                    ];
                break;

	        //고객 기초 정보 조회
	        case "CS011" :
	            sql = sqlQuery.sqlInsertHscCstmsT;
            	sqlParameter = [  item["_CST_OGN_CD"]   , item["_CST_NO"]      , item["_CST_NM"]           , item["_CST_NM_ENG"]        , item["_CST_CLS_CD"]
                                , item["_INS_SHOP_CD"]  , item["_POST_NO"]     , item["_ADDR"]             , item["_SOLAR_YN"]          , item["_SEX_FG"]
                                , item["_HP_NO"]        , item["_S_TEL_NO"]    , item["_WEDDING_YN"]       , item["_EMAIL_RECV_YN"]     , item["_SMS_RECV_YN"]
                                , item["_DM_RECV_YN"]   , item["_TMP_INS_YN"]  , item["_CST_CARD_USE_FG"]  , item["_CST_CARD_ISS_CNT"]  , item["_USE_YN"]
                                , item["_EMAIL_ADDR"]   , item["_ADDR_DTL"]    , item["_CST_CARD_NO"]      , item["_RESI_NO"]           , item["_BIRTH_DATE"]
                                , item["_TEL_NO"]       , item["_CSH_IDT_NO"]  , item["_WEDDING_DATE"]     , item["_ORG_CST_CARD_NO"]   , item["_CST_REMARK"]
                                , item["_WALLET_USE_YN"]
                               ];
                break;

            //주문 디테일
	        case "POS_ODDTL_T" :
	            sql = sqlQuery.sqlInsertPosOddtlT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["ORDER_NO"], item["ORDER_DTL_NO"], item["ORDER_DTL_FG"]
	        		, item["ORDER_SEQ_NO"], item["POS_NO"], item["PROD_CD"], item["PROD_TYPE_FG"], item["CORNER_CD"]       
	        		, item["CHG_BILL_NO"], item["TAX_YN"], item["DLV_PACK_FG"], item["PROP_CD"], item["PROP_VAL"]        
	        		, item["ORG_SALE_MG_CD"], item["ORG_SALE_UPRC"], item["NORMAL_UPRC"], item["SALE_MG_CD"], item["SALE_QTY"]        
	        		, item["SALE_UPRC"], item["SALE_AMT"], item["SALE_WEIGHT"], item["DC_AMT"], item["ETC_AMT"]         
	        		, item["SVC_TIP_AMT"], item["DCM_SALE_AMT"], item["VAT_AMT"], item["SVC_CD"], item["TK_CPN_CD"]
	        		, item["DC_TYPE_FG"], item["DC_AMT_GEN"], item["DC_AMT_SVC"], item["DC_AMT_JCD"], item["DC_AMT_CPN"]
	        		, item["DC_AMT_CST"], item["DC_AMT_FOD"], item["DC_AMT_PRM"], item["DC_AMT_CRD"], item["DC_AMT_PACK"]
	        		, item["DC_AMT_LYT"], item["CST_SALE_POINT"], item["CST_USE_POINT"], item["PRM_PROC_YN"], item["PRM_CD"]
	        		, item["PRM_SEQ"], item["SDA_CD"], item["SDS_ORG_DTL_NO"], item["ORDER_EMP_NO"], item["ORG_ORDER_NO"]
	        		, item["ORG_FD_TBL_CD"], item["REMARK"], item["EMP_NO"], item["DC_SEQ_TYPE"], item["DC_SEQ_AMT"]
	        		, item["DC_SEQ_FG"], item["DC_SEQ_RATE"], item["ORDER_SCN_FG"], item["ORDER_SCN_DT"]
	        		, item["ORDER_SCN_POS_NO"], item["COOK_MEMO"], item["STAMP_SALE_QTY"], item["CANCEL_REASON"]
	        		, item["CUP_SALE_CNT"], item["CUP_DEPOSIT_UPRC"], item["CUP_FG"]
                    ];
            break;
            
            //카드 정보
	        case "POS_ODCRD_T" :
	        	sql = sqlQuery.sqlInsertPosOdcrdT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["ORDER_NO"], item["LINE_NO"], item["SEQ_NO"]
	        		, item["POS_NO"], item["SALE_YN"], item["APPR_REQ_AMT"], item["SVC_TIP_AMT"], item["VAT_AMT"]
	        		, item["APPR_LOG_NO"], item["APPR_AMT"], item["APPR_DC_AMT"], item["EMP_NO"], item["PRE_PAY_FG"]
	        		, item["VAT_SALE_AMT"], item["NO_VAT_SALE_AMT"]
	        	];
        	break;
        	
            //카드 로그
	        case "POS_LGCRD_T" :
	        	sql = sqlQuery.sqlInsertPosLgcrdT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["APPR_LOG_NO"], item["POS_NO"], item["VAN_CD"]
	        		, item["CORNER_CD"], item["APPR_TYPE_FG"], item["APPR_FG"], item["APPR_PROC_FG"], item["CRD_CARD_NO"]
	        		, item["APPR_REQ_AMT"], item["SVC_TIP_AMT"], item["VAT_AMT"], item["INST_MM_FG"], item["INST_MM_CNT"]
	        		, item["VALID_TERM"], item["SIGN_PAD_YN"], item["CARD_IN_FG"], item["APPR_DATE"], item["APPR_TIME"]
	        		, item["APPR_NO"], item["CRDCP_CD"], item["ISS_CRDCP_CD"], item["ISS_CRDCP_NM"], item["PUR_CRDCP_CD"]
	        		, item["PUR_CRDCP_NM"], item["APPR_AMT"], item["APPR_DC_AMT"], item["APPR_MSG"], item["VAN_TERM_NO"]
	        		, item["VAN_SLIP_NO"], item["CRDCP_TERM_NO"], item["ORG_APPR_DATE"], item["ORG_APPR_NO"]
	        		, item["ORG_APPR_LOG_NO"], item["LYT_APPR_FG"], item["LYT_APPR_INFO"], item["EMP_NO"], item["SEND_FG"]
	        		, item["SEND_DT"], item["GIFT_CASH"], item["NOTICE_MSG"], item["BROAD_MSG"], item["CNMK_CD"]
	        		, item["UNION_PAY_FG"], item["DDC_FLAG"], item["VAT_SALE_AMT"], item["NO_VAT_SALE_AMT"]
	        	];
        	break;
        	
        	//카드 로그
	        case "POS_ODPSQ_T" :
	        	sql = sqlQuery.selectPosOdpsqT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["ORDER_NO"], item["PAY_SEQ_NO"], item["POS_NO"]
	        		, item["SALE_YN"], item["PAY_TYPE_FG"], item["PAY_AMT"], item["LINE_NO"], item["EMP_NO"]
	        	];
        	break;

        	//카드 결제에서 카카오페이, 제로페이 등록을 위한 테이블.
	        case  "POS_ODETC_T":
	        	sql = sqlQuery.sqlInsertPosOdetcT;
	        	sqlParameter = [
	        		  item["SHOP_CD"]           , item["SALE_DATE"]    , item["POS_NO"]       , item["ORDER_NO"]      , item["LINE_NO"]
	        		, item["SEQ_NO"]            , item["TR_TYPE_CD"]   , item["CORNER_CD"]    , item["SALE_YN"]       , item["APPR_DATE"]
	        		, item["APPR_TIME"]         , item["APPR_AMT"]     , item["SVC_TIP_AMT"]  , item["VAT_AMT"]       , item["PRE_BF_REM_AMT"]
	        		, item["PRE_AF_REM_AMT"]    , item["APPR_NO"]      , item["CARD_NO"]      , item["APPR_PROC_FG"]  , item["ORG_APPR_DATE"]
	        		, item["ORG_APPR_NO"]       , item["USER_DATA"]    , item["INS_DT"]
	        	];
	        	break;
	        case "SSL_TRETC_T" : //카드 결제에서 카카오페이, 제로페이 등록을 위한 테이블.
	        	sql = sqlQuery.sqlInsertSslTretcT;
	        	sqlParameter = [ 
	        		 item["SHOP_CD"]           , item["SALE_DATE"]        , item["POS_NO"]      , item["BILL_NO"]       , item["LINE_NO"]
	        		, item["SEQ_NO"]           , item["TR_TYPE_CD"]       , item["REGI_SEQ"]    , item["CORNER_CD"]     , item["SALE_YN"]
	        		, item["APPR_DATE"]        , item["APPR_TIME"]        , item["APPR_AMT"]    , item["SVC_TIP_AMT"]   , item["VAT_AMT"]
	        		, item["PRE_BF_REM_AMT"]   , item["PRE_AF_REM_AMT"]   , item["APPR_NO"]     , item["CARD_NO"]       , item["APPR_PROC_FG"]
	        		, item["ORG_APPR_DATE"]    , item["ORG_APPR_NO"]      , item["USER_DATA"]   , item["INS_DT"]        
	        	];
	        	break;
        	
	        //고객 포인트 사용정보
	        case "POS_ODCST_T" :
	        	sql = sqlQuery.insertPosOdcstT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["ORDER_NO"], item["LINE_NO"], item["POS_NO"]
	        		, item["SALE_YN"], item["CST_NO"], item["CST_CARD_NO"], item["CST_CLS_CD"], item["CST_USE_POINT"]
	        		, item["INS_DT"], item["EMP_NO"], item["CST_USE_AMT"], item["CORNER_CD"], item["SEQ_NO"]
	        	];
        	break;
        	
        	//고객 포인트 사용정보
	        case "SSL_TRCST_T" :
	        	sql = sqlQuery.insertSslTrcstT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["POS_NO"], item["BILL_NO"], item["LINE_NO"], item["REGI_SEQ"]
	        		, item["SALE_YN"], item["CST_NO"], item["CST_CARD_NO"], item["CST_CLS_CD"], item["CST_USE_POINT"]
	        		, item["INS_DT"], item["EMP_NO"], item["CST_USE_AMT"], item["CORNER_CD"], item["SEQ_NO"]
	        	];
        	break;
        	
        	//교환번호 저장
	        case "POS_CHGNO_T" :
	        	sql = sqlQuery.insertPosChgnoT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["CHNAGE_BILL_NO"]
	        	];
        	break;
        	
        	/****************hjjang**************/

        	/** jean43069 start **/
        	// 고객 기초 정보
            case "MS621" :
                sql = sqlQuery.sqlInsertHscCstmsT;
            	sqlParameter = [  item["_CST_OGN_CD"]   , item["_CST_NO"]      , item["_CST_NM"]           , item["_CST_NM_ENG"]        , item["_CST_CLS_CD"]
                                , item["_INS_SHOP_CD"]  , item["_POST_NO"]     , item["_ADDR"]             , item["_SOLAR_YN"]          , item["_SEX_FG"]
                                , item["_HP_NO"]        , item["_S_TEL_NO"]    , item["_WEDDING_YN"]       , item["_EMAIL_RECV_YN"]     , item["_SMS_RECV_YN"]
                                , item["_DM_RECV_YN"]   , item["_TMP_INS_YN"]  , item["_CST_CARD_USE_FG"]  , item["_CST_CARD_ISS_CNT"]  , item["_USE_YN"]
                                , item["_EMAIL_ADDR"]   , item["_ADDR_DTL"]    , item["_CST_CARD_NO"]      , item["_RESI_NO"]           , item["_BIRTH_DATE"]
                                , item["_TEL_NO"]       , item["_CSH_IDT_NO"]  , item["_WEDDING_DATE"]     , item["_ORG_CST_CARD_NO"]   , item["_CST_REMARK"]
                                , item["_WALLET_USE_YN"]
                                /*, item["_INS_DT"]       , item["_UPD_DT"]      , item["_WALLET_USE_YN"]*/
                               ];
                break;

        	// 고객 등급 정보
            case "MS611" :
                sql = sqlQuery.sqlInsertHscCstclT;
            	sqlParameter = [   item["_CST_OGN_CD"]     , item["_CST_CLS_CD"]    , item["_CST_SEQ"]      , item["_CST_CLS_NM"]     , item["_DC_RATE"]
                                 , item["_ACC_UNIT_FG"]    , item["_ACC_BASE_CSH"]  , item["_ACC_BASE_CRD"] , item["_ACC_BASE_GFT"]   , item["_ACC_BASE_FOD"]
                                 , item["_ACC_BASE_JCD"]   , item["_ACC_BASE_WES"]  , item["_ACC_BASE_CST"] , item["_ACC_BASE_RFC"]   , item["_NEW_ENTRY_POINT"]
                                 /*, item["_MIN_USE_POINT"]  , item["_BASE_CLS_YN"]   , item["_INS_DT"]       , item["_UPD_DT"]         , item["_STAMP_ACC_FG"]*/
                                 , item["_MIN_USE_POINT"]  , item["_BASE_CLS_YN"]   , item["_STAMP_ACC_FG"]
                                 , item["_STAMP_ACC_COST"] , item["_STAMP_ACC_QTY"] , item["_STAMP_USE_FG"] , item["_STAMP_USE_COST"] , item["_STAMP_USE_QTY"]
                                 , item["_DC_ACC_YN"]      , item["_USE_ACC_YN"]    , item["_ACC_BASE_CSB"] , item["_MAX_USE_POINT"]
                                ];

                break;

            // 고객 포인트 정보
            case "MS631" :
                sql = sqlQuery.sqlInsertHcsCstptT;
            	sqlParameter = [ item["_CST_OGN_CD"]       , item["_CST_NO"]          , item["_ACC_SALE_CNT"]
                               , item["_ACC_SALE_AMT"]     , item["_ACC_POINT"]       , item["_USE_POINT"]
                               , item["_AVL_POINT"]        , item["_ADJ_POINT"]       , item["_POINT_ACC_CNT"]
                               , item["_POINT_USE_CNT"]    , item["_INS_SHOP_CD"]     , item["_INS_ACC_SALE_CNT"]
                               , item["_INS_ACC_SALE_AMT"] , item["_F_SALE_DATE"]     , item["_L_SALE_DATE"]
                               , item["_INS_F_SALE_DATE"]  , item["_INS_L_SALE_DATE"]
                               /*, item["_INS_DT"], item["_UPD_DT"]*/
                                ];
                break;

            // 매장-기능키관리
        	case "MS701" :
        	    sql = sqlQuery.sqlInsertScdFunkyT;
            	sqlParameter = [  item["_SHOP_CD"]  , item["_FK_NO"]      , item["_FK_NM"]      , item["_FK_FG"]  , item["_AUTH_YN"]
                                , item["_FK_USE_YN"], item["_IMG_FILE_NM"], item["_POSITION_YN"], item["_PROD_CD"], item["_USE_YN"] ];
                break;

            // 매장-포스별기능키설정
            case "MS711" :
                sql = sqlQuery.sqlInsertScdPosfkT;
            	sqlParameter = [item["_SHOP_CD"]  , item["_POS_NO"]    , item["_FK_NO"]      , item["_POSITION_NO"] , item["_COL_NUM"],
                                item["_ROW_NUM"]  , item["_WIDTH_NUM"] , item["_HEIGHT_NUM"] , item["_USE_YN"]      , item["_GROUP_FG"],
                                item["_IMG_TYPE"] ];
                break;

            // 매장-사원구분기능키설정
            case "MS721" :
                sql = sqlQuery.sqlInsertScdEmpfkT;
            	sqlParameter = [ item["_SHOP_CD"] , item["_EMP_FG"] , item["_FK_NO"] , item["_USE_YN"] ]; break;
             	break;

            // 진동벨 연동
            case "MS911" :
                sql = sqlQuery.sqlInsertScdPagmsT;
            	sqlParameter = [ item["_SHOP_CD"]  , item["_PAG_NO"]        , item["_PAG_NM"]
                               , item["_POS_NO"]   , item["_PAG_TYPE_FG"]   , item["_PAG_PORT"]
                               , item["_USE_YN"]   ];
                break;

            // KIOSK 터치분류
            case "MS931" :
                sql = sqlQuery.sqlInsertScdKtclsT;
            	sqlParameter = [ item["_SHOP_CD"]   ,item["_TU_FG"]        ,item["_TU_CLS_CD"]
                                ,item["_TU_CLS_NM"] ,item["_TU_CLS_NM_EN"] ,item["_TU_CLS_SEQ"] 
                                ,item["_TU_CLS_DISP_FG"] ,item["_TU_CLS_PROC_FG"] ,item["_RECUR_S_DATE"] ,item["_RECUR_E_DATE"] 
								,item["_RECUR_TERM"] ,item["_RECUR_S_TIME"] ,item["_RECUR_E_TIME"] 
							];
                break;

            // KIOSK 터치상품
            case "MS941" :
                sql = sqlQuery.sqlInsertScdKtkeyT;
            	sqlParameter = [ item["_SHOP_CD"]   ];
	        				if(item["_TU_FG"] === null || item["_TU_FG"] === undefined) item["_TU_FG"] = "S";
	        					sqlParameter.push( item["_TU_FG"]);

      					sqlParameter.push( item["_TU_CLS_CD"] ,item["_TU_KEY_CD"] ,item["_TU_PROD_SEQ"] ,item["_PROD_CD"] );
	        	break;

            /** jean43069 end **/

            /** jung start ************************************************************/

            //상품대분류
            case "MS201" :
                sql = sqlQuery.sqlInsertScdClslmT;

                sqlParameter = [ item["_SHOP_CD"], item["_LCLS_CD"], item["_LCLS_NM"], item["_USE_YN"], insDt ];
                sqlParameter.push( "");
                break;
            //상품중분류
            case "MS211" :
                sql = sqlQuery.sqlInsertScdClsmmT;

                sqlParameter = [ item["_SHOP_CD"], item["_MCLS_CD"], item["_MCLS_NM"], item["_LCLS_CD"], item["_USE_YN"] ];
                sqlParameter.push( insDt, "");
                break;
            //상품소분류
            case "MS221" :
                sql = sqlQuery.sqlInsertScdClssmT;

                sqlParameter = [ item["_SHOP_CD"], item["_SCLS_CD"], item["_SCLS_NM"], item["_LCLS_CD"], item["_MCLS_CD"] ];
                sqlParameter.push( item["_SIZE_CLS_CD"], item["_USE_YN"], insDt, "");
                break;
            //상품마스터
            case "MS301" :
                sql = sqlQuery.sqlInsertScdProdmT;
                sqlParameter = [ item["_SHOP_CD"], item["_PROD_CD"], item["_PROD_NM"], item["_PROD_NM_EN"], item["_IMG_URL"] ];
                sqlParameter.push( "U", item["_KIOSK_PROD_YN"],item["_KIOSK_PROD_STATUS"], item["_LCLS_CD"], item["_MCLS_CD"]);
                sqlParameter.push( item["_SCLS_CD"], "", "", "", "");
                sqlParameter.push( "", "", "", item["_MAP_PROD_CD"], item["_CORNER_CD"]);
                sqlParameter.push( item["_SPLY_UPRC"], item["_TOGO_CHARGE"], "", item["_CST_ACCDC_YN"], item["_TAX_YN"]);
                sqlParameter.push( item["_TIP_MENU_YN"], item["_ORD_PROD_YN"], item["_SALE_PROD_YN"], item["_STOCK_MGR_YN"], item["_STOCK_OUT_YN"]);
                sqlParameter.push( item["_SIDE_MENU_YN"], item["_SDA_CLS_CD"], item["_SDS_GRP_CD"], item["_PRICE_MGR_FG"], item["_SET_PROD_FG"]);
                sqlParameter.push( item["_DEPOSIT_FG"], item["_DEPOSIT_UPRC"], item["_ORG_PLACE_CD"], "", item["_ORD_UNIT_FG"]);
                sqlParameter.push( item["_ORD_UNIT_QTY"], item["_ORD_MIN_QTY"], item["_PRICE_CTRL_FG"], item["_USE_YN"], item["_FLOOR_PRT_YN"]);
                sqlParameter.push( insDt, "", item["_POS_PRT_YN"], item["_STAMP_ACC_YN"], item["_STAMP_ACC_QTY"], item["_STAMP_USE_YN"], item["_STAMP_USE_QTY"]);
                sqlParameter.push( item["_DESCRIPTION_DISP_YN"], item["_DESCRIPTION"], item["_DESCRIPTION_EN"], item["_TOGO_PROD_YN"], item["_CUP_DEPOSIT_FG"]);
                sqlParameter.push( item["_CUP_FG"]);

                break;
            //판매가
            case "MS311" :
                sql = sqlQuery.sqlInsertScdPrcdyT;

                sqlParameter = [ item["_SHOP_CD"], item["_PRC_MG_CD"], item["_PRC_MG_NM"], item["_S_DATE"], item["_E_DATE"] ];
                sqlParameter.push( item["_PROD_CD"], item["_NORMAL_UPRC"], item["_SALE_UPRC"], insDt, "", item["_S_TIME"], item["_E_TIME"], item["_SHOP_TYPE_FG"]);
                break;
            //바코드
            case "MS321" :
                sql = sqlQuery.sqlInsertScdBarcdT;

                sqlParameter = [ item["_SHOP_CD"], item["_BAR_CD"], item["_PROD_CD"], insDt, "" ];
                break;
            //세트상품
            case "MS331" :
                sql = sqlQuery.sqlInsertScdPrdstT;

                sqlParameter = [ item["_SHOP_CD"], item["_PROD_CD"], item["_SET_PROD_FG"], item["_UNIT_PROD_CD"], item["_UNIT_PROD_QTY"] ];
                sqlParameter.push( item["_UNIT_PROD_SEQ"], insDt, "");
                break;
            //매장 사이드메뉴 속성분류
            case "MS341" :
                sql = sqlQuery.sqlInsertScdSdaclT;

                sqlParameter = [ item["_SHOP_CD"], item["_SDA_CLS_CD"], item["_SDA_CLS_NM"], item["_SDA_CLS_NM_EN"], item["_USE_YN"] ];
                sqlParameter.push( insDt, "", item["_SDA_ORDER_SEQ"]);
                break;
            //매장 사이드메뉴 속성코드
            case "MS351" :
                sql = sqlQuery.sqlInsertScdSdacdT;

                sqlParameter = [ item["_SHOP_CD"], item["_SDA_CD"], item["_SDA_NM"], item["_SDA_NM_EN"], item["_SDA_CLS_CD"] ];
                sqlParameter.push( item["_USE_YN"], insDt, "", item["_SDA_ORDER_SEQ"] );
                break;
            //매장 사이드메뉴 선택그룹
            case "MS361" :
                sql = sqlQuery.sqlInsertScdSdsgrT;

                sqlParameter = [ item["_SHOP_CD"], item["_SDS_GRP_CD"], item["_SDS_GRP_NM"], item["_SDS_GRP_NM_EN"], item["_USE_YN"] ];
                sqlParameter.push( insDt, "", item["_SDS_ORDER_SEQ"]);
                break;
            //매장 사이드메뉴 선택분류
            case "MS371" :
                sql = sqlQuery.sqlInsertScdSdsclT;

                sqlParameter = [ item["_SHOP_CD"], item["_SDS_CLS_CD"], item["_SDS_CLS_NM"], item["_SDS_CLS_NM_EN"], item["_SDS_GRP_CD"]];
                sqlParameter.push( item["_SDS_ORDER_SEQ"], item["_USE_YN"], insDt, "", item["_SDS_PROC_FG"]);
                break;
            //매장 사이드메뉴 선택코드
            case "MS381" :
                sql = sqlQuery.sqlInsertScdSdscdT;
                sqlParameter = [ item["_SHOP_CD"]
                , item["_SDS_CD"]
                , item["_SDS_NM"]
                , item["_SDS_NM_EN"]
                , item["_SDS_CLS_CD"]
                , item["_PROD_CD"]
                , item["_SDS_PROD_UPRC"]
                , item["_USE_YN"]
                , item["_INS_DT"]
                , item["_UPD_DT"]
                , item["_SDS_ORDER_SEQ"]
               ];
                break;

            /** jung end **************************************************************/
            
            /** JONGKI START **/
            //매장 사이드메뉴 선택코드
            case "POS_ODJCD_T" :
                sql = sqlQuery.sqlInsertPosOdjcdT;
                sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["ORDER_NO"], item["LINE_NO"], item["SEQ_NO"]
			                 , item["POS_NO"], item["SALE_YN"], item["JCD_CD"], item["JCD_TYPE_FG"], item["JCD_PROC_FG"]
                             , item["APPR_LOG_NO"], item["APPR_AMT"], item["JCD_DC_AMT"], item["JCD_OCC_POINT"], item["JCD_AVL_POINT"]
                             , item["JCD_USE_POINT"], item["JCD_REM_POINT"], insDt, item["EMP_NO"], item["JCD_PAY_FG"]                             
	                		];
                break;
                       
            //교환번호 저장
	        case "POS_LGJCD_T" :
	        	sql = sqlQuery.sqlInsertPosLgjcdT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["APPR_LOG_NO"], item["POS_NO"], item["VAN_CD"]
					        	, item["CORNER_CD"], item["APPR_TYPE_FG"], item["APPR_FG"], item["APPR_PROC_FG"], item["JCD_CD"]
					        	, item["JCD_TYPE_FG"], item["JCD_PROC_FG"], item["JCD_CARD_NO"], item["JCD_CARD_PWD"], item["APPR_AMT"]
					        	, item["VALID_TERM"], item["SIGN_PAD_YN"], item["CARD_IN_FG"], item["APPR_DATE"], item["APPR_TIME"]
					        	, item["APPR_NO"], item["JCD_DC_AMT"], item["JCD_OCC_POINT"], item["JCD_AVL_POINT"], item["JCD_USE_POINT"]
					        	, item["JCD_REM_POINT"], item["APPR_MSG"], item["VAN_TERM_NO"], item["VAN_SLIP_NO"], item["CRDCP_TERM_NO"]
					        	, item["ORG_APPR_DATE"], item["ORG_APPR_NO"], item["ORG_APPR_LOG_NO"], insDt, item["EMP_NO"]
					        	, item["SEND_FG"], item["SEND_DT"], item["BROAD_MSG"], item["JCD_PAY_FG"], item["CNMK_CD"]
					        	];
        	break;
        	
        	// TRJCD가 존재하긴 하나, 마스터 데이터 수신용으로 item명에 _가 붙어 있어서 사용불가. _없이 새로 하나 만듬.
	        case "SSL_TRJCD_T" :
		        sql = sqlQuery.sqlInsertSslTrjcdT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["POS_NO"], item["BILL_NO"], item["LINE_NO"]
                    , item["SEQ_NO"], item["REGI_SEQ"], item["SALE_YN"], item["VAN_CD"], item["CORNER_CD"]
                    , item["APPR_PROC_FG"], item["JCD_CD"], item["JCD_TYPE_FG"], item["JCD_PROC_FG"], item["JCD_CARD_NO"]
                    , item["JCD_CARD_PWD"], item["APPR_AMT"], item["VALID_TERM"], item["SIGN_PAD_YN"], item["CARD_IN_FG"]
                    , item["APPR_DATE"], item["APPR_TIME"], item["APPR_NO"], item["JCD_DC_AMT"], item["JCD_OCC_POINT"]
                    , item["JCD_AVL_POINT"], item["JCD_USE_POINT"], item["JCD_REM_POINT"], item["APPR_MSG"], item["VAN_TERM_NO"]
                    , item["VAN_SLIP_NO"], item["CRDCP_TERM_NO"], item["ORG_APPR_DATE"], item["ORG_APPR_NO"], item["APPR_LOG_NO"]
                    , insDt, item["EMP_NO"], item["BROAD_MSG"], item["JCD_PAY_FG"], item["CNMK_CD"]
	        	    , item["TEST"], item["SEC_FLAG"]
                    ];
            break;
            
	        case "POS_ODCSH_T" :
                sql = sqlQuery.sqlInsertPosOdcshT;
                sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["ORDER_NO"], item["LINE_NO"], item["SEQ_NO"]
			                 , item["POS_NO"], item["SALE_YN"], item["CORNER_CD"], item["CASH_AMT"], item["SVC_TIP_AMT"]
                             , item["VAT_AMT"], item["APPR_LOG_NO"], insDt, item["EMP_NO"], item["EX_CD"]
                             , item["EX_KRW"], item["EX_EXP_AMT"], item["EX_IN_AMT"], item["EX_RET_AMT"], item["KR_RET_AMT"]
                			 , item["EX_PAY_AMT"], item["KR_PAY_AMT"], item["KR_ETC_AMT"], item["PRE_PAY_FG"], item["VAT_SALE_AMT"]
                			 , item["NO_VAT_SALE_AMT"]
	                		];
                break;
                       
	        case "POS_LGCSH_T" :
	        	sql = sqlQuery.sqlInsertPosLgcshT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["APPR_LOG_NO"], item["POS_NO"], item["VAN_CD"]
					        	, item["CORNER_CD"], item["APPR_TYPE_FG"], item["APPR_FG"], item["APPR_AMT"], item["SVC_TIP_AMT"]
					        	, item["VAT_AMT"], item["APPR_PROC_FG"], item["APPR_IDT_TYPE"], item["APPR_IDT_FG"], item["CARD_IN_FG"]
					        	, item["APPR_IDT_NO"], item["APPR_DATE"], item["APPR_TIME"], item["APPR_NO"], item["APPR_MSG"]
					        	, item["VAN_TERM_NO"], item["VAN_SLIP_NO"], item["ORG_APPR_DATE"], item["ORG_APPR_NO"], item["ORG_APPR_LOG_NO"]
					        	, insDt, item["EMP_NO"], item["SEND_FG"], item["SEND_DT"], item["NOTICE_MSG"]
					        	, item["BROAD_MSG"], item["CNMK_CD"], item["VAT_SALE_AMT"], item["NO_VAT_SALE_AMT"]
					        	];
        	break;
        	
	        case "SSL_TRCSH_T" :
		        sql = sqlQuery.sqlInsertSslTrcshT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["POS_NO"], item["BILL_NO"], item["LINE_NO"]
                    , item["SEQ_NO"], item["REGI_SEQ"], item["SALE_YN"], item["VAN_CD"], item["CORNER_CD"]
                    , item["CASH_AMT"], item["APPR_AMT"], item["SVC_TIP_AMT"], item["VAT_AMT"], item["APPR_PROC_FG"]
                    , item["APPR_IDT_TYPE"], item["APPR_IDT_FG"], item["CARD_IN_FG"], item["APPR_IDT_NO"], item["APPR_DATE"]
                    , item["APPR_TIME"], item["APPR_NO"], item["APPR_MSG"], item["VAN_TERM_NO"], item["VAN_SLIP_NO"]
                    , item["ORG_APPR_DATE"], item["ORG_APPR_NO"], item["APPR_LOG_NO"], insDt, item["EMP_NO"]
                    , item["EX_CD"], item["EX_KRW"], item["EX_EXP_AMT"], item["EX_IN_AMT"], item["EX_RET_AMT"]
                    , item["KR_RET_AMT"], item["EX_PAY_AMT"], item["KR_PAY_AMT"], item["KR_ETC_AMT"], item["PRE_PAY_FG"]
	        		, item["NOTICE_MSG"], item["BROAD_MSG"], item["CNMK_CD"], item["SEC_FLAG"], item["VAT_SALE_AMT"]
	        	    , item["NO_VAT_SALE_AMT"]
                    ];
            break;
            /** JONGKI END **/
        }

        //console.log("sqlParameter   :" + sqlParameter);
        return {"sql" : sql , "sqlParameter" : sqlParameter};
    }

    this.fnDeleteQueryParams = function(srId, item){

        var insDt = moment().format("YYYYMMDDHHmmss");
        var sql = "";
        var sqlParameter = [];
        switch (srId) {

            /****************hjjang**************/
	        //시스템-공통코드
	        case "MS011" :
	            sql = sqlQuery.sqlDeleteCcdCodemT;
	        	sqlParameter = [ item["_COM_CD_FG"], item["_COM_CD"]];
	        	break;

	        case "MS021" :
	            sql = sqlQuery.sqlDeleteCcdEnvhdT;
	        	sqlParameter = [ item["_ENV_SET_CD"] ];
	        	break;

	        case "MS031" :
	            sql = sqlQuery.sqlDeleteCcdEnvdtT;
	        	sqlParameter = [ item["_ENV_SET_CD"], item["_ENV_VAL_CD"] ];
	        	break;
	        case "MS041" :
	        	sql = sqlQuery.sqlDeleteCcdEnvpdT;
	        	sqlParameter = [ item["_OGN_CD"], item["_CODE_CD"] ];
	        	break;

	        case "MS051" :
	            sql = sqlQuery.sqlDeleteScdPrintT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_PRT_CLS_CD"] ];
	        	break;

	        case "MS061" :
	            sql = sqlQuery.sqlDeleteScdPosfnT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_EMP_FG"], item["_POS_FN_NO"]];
	        	break;

	        case "MS071" :
	        	sql = sqlQuery.sqlDeleteCcdCrdcpT;
	        	sqlParameter = [ item["_CRDCP_CD"] ];
	        	break;
	        	
	        case "MS081" : //밴사별카드사정보
	        	sql = sqlQuery.sqlDeleteCcdVancmT;
	        	sqlParameter = [ item["_VAN_CD"], item["_VAN_CRDCP_CD"] ];
	        	break;
	        	
	        case "MS101" :
	            sql = sqlQuery.sqlDeleteScdShopmT;
	        	sqlParameter = [ item["_SHOP_CD"]];
	        	break;

	        case "MS111" :
	            sql = sqlQuery.sqlDeleteScdShopsT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_CORNER_CD"]];
	        	break;

	        case "MS121" :
	            sql = sqlQuery.sqlDeleteScdCodemT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_COM_CD"], item["_COM_CD_FG"]];
	        	break;
	        	
	        case "MS131" :
	            sql = sqlQuery.sqlDeleteScdEnvshT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_ENV_SET_CD"]];
	        	break;

	        case "MS141" :
	            sql = sqlQuery.sqlDeleteScdEnvkpT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_KIT_PRT_NO"], item["_ENV_SET_CD"]];
	        	break;

	        case "MS151" :
	            sql = sqlQuery.sqlDeleteScdEnvpsT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_POS_NO"], item["_ENV_SET_CD"]];
	        	break;

	        case "MS161" :
	            sql = sqlQuery.sqlDeleteScdEmpmsT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_EMP_NO"] ];
	        	break;

	        case "MS171" :
	            sql = sqlQuery.sqlDeleteScdPosmsT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_POS_NO"] ];
	        	break;

	        case "MS401" :
	            sql = sqlQuery.sqlDeleteScdFdtblT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_FD_TBL_CD"]];
	        	break;

	        case "MS411" :
	            sql = sqlQuery.sqlDeleteScdTbgrpT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_TG_CD"]];
	        	break;

	        //매장-테이블정보
	        case "MS441" :
	            sql = sqlQuery.sqlDeleteScdTableT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_TABLE_CD"]];
	        	break;

	        //터치분류 삭제
	        case "MS471" :
	        	sql = sqlQuery.sqlDeleteScdTuclsT;
				sqlParameter = [   item["_SHOP_CD"]       , item["_TU_FG"]         , item["_TU_CLS_CD"]  ];

	        	break;
	        //터치상품 삭제
	        case "MS481" :
	        	sql = sqlQuery.sqlDeleteScdTukeyT;
	        	sqlParameter = [  item["_SHOP_CD"]     , item["_TU_FG"]       , item["_TU_CLS_CD"]    , item["_TU_KEY_CD"]  ];
	        	break;
	        	
	        case "MS531" :
	            sql = sqlQuery.sqlDeleteScdJcdhdT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_JCD_CD"]];
	        	break;
	        	
	        case "MS541" :
	            sql = sqlQuery.sqlDeleteScdJcddtT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_JCD_CD"], item["_STYLE_PROD_CD"]];
	        	break;
	        	
	        //매출TR-HEADER
	        case "TRHDR" :
	            sql = sqlQuery.sqlDeleteSslTrhdrT;
	        	sqlParameter = [item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"]];
	        	break;

	        //매출TR-상품-DETAIL
	        case "TRDTL" :
	            sql = sqlQuery.sqlDeleteSslTrdtlT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"], item["_DTL_NO"]];
	        	break;

	        case "TRCSH" :
	            sql = sqlQuery.sqlDeleteSslTrcshT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_BILL_NO"]
		        	, item["_LINE_NO"], item["_SEQ_NO"]];
	        	break;

	        case "TRCRD" :
	            sql = sqlQuery.sqlDeleteSslTrcrdT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"]
		        	, item["_BILL_NO"], item["_LINE_NO"], item["_SEQ_NO"]];
	        	break;

	        case "TRPSQ" :
	            sql = sqlQuery.sqlDeleteSslTrpsqT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"]
		        	, item["_BILL_NO"], item["_PAY_SEQ_NO"]];
	        	break;

	        case "TRCST" :
	            sql = sqlQuery.sqlDeleteSslTrcstT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"]
		        	, item["_BILL_NO"], item["_LINE_NO"], item["_SEQ_NO"]];
	        	break;

	        case "TRJCD" :
	            sql = sqlQuery.sqlDeleteSslTrjcdT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"]
		        	, item["_BILL_NO"], item["_LINE_NO"], item["_SEQ_NO"]];
	        	break;

	        case "TRGFT" :
	            sql = sqlQuery.sqlDeleteSslTrgftT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"]
		        	, item["_BILL_NO"], item["_LINE_NO"]];
	        	break;

	        case "TRWES" :
	            sql = sqlQuery.sqlDeleteSslTrwesT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"]
		        	, item["_BILL_NO"], item["_LINE_NO"]];
	        	break;

	        case "TRGST" :
	            sql = sqlQuery.sqlDeleteSslTrgstT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"]
		        	, item["_BILL_NO"], item["_LINE_NO"]];
	        	break;

	        case "TRFOD" :
	            sql = sqlQuery.sqlDeleteSslTrfodT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"]
		        	, item["_BILL_NO"], item["_LINE_NO"]];
	        	break;
	        	
	        case "MS451" :
	            sql = sqlQuery.sqlDeleteScdPrtmsT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_PRT_NO"]];
	        	break;
	        	
	        case "MS461" :
	            sql = sqlQuery.sqlDeleteScdPrtprT;
	            sqlParameter = [ item["_SHOP_CD"], item["_PROD_CD"], item["_PRT_NO"]];
	        	break;

	        case "SI391" :
	            sql = sqlQuery.sqlDeletePosRegisT;
	        	sqlParameter = [ item["_SHOP_CD"], item["_SALE_DATE"], item["_POS_NO"], item["_REGI_SEQ"]];
	            break;

	        //고객 기초 정보 조회
	        case "CS011" :
	            sql = sqlQuery.sqlDeleteHscCstmsT;
            	sqlParameter = [ 	item["_CST_OGN_CD"], item["_CST_NO"] ];
            	break;

        	/****************hjjang**************/

        	/** jean43069 start **/
        	// 고객 기초 정보
            case "MS621" :
                sql = sqlQuery.sqlDeleteHscCstmsT;
            	sqlParameter = [ 	item["_CST_OGN_CD"], item["_CST_NO"] ];
            	break;

        	// 고객 등급 정보
            case "MS611" :
                sql = sqlQuery.sqlDeleteHscCstclT;
            	sqlParameter = [ item["_CST_OGN_CD"], item["_CST_CLS_CD"]];
            	break;

            // 고객 포인트 정보
            case "MS631" :
                sql = sqlQuery.sqlDeleteHcsCstptT;
            	sqlParameter = [ item["_CST_OGN_CD"], item["_CST_NO"]];
            	break;

            // 매장-기능키관리
        	case "MS701" :
        	    sql = sqlQuery.sqlDeleteScdFunkyT;
            	sqlParameter = [ item["_SHOP_CD"]  , item["_FK_NO"] ];
            	break;

            // 매장-포스별기능키설정
            case "MS711" :
                sql = sqlQuery.sqlDeleteScdPosfkT;
            	sqlParameter = [ item["_SHOP_CD"], item["_POS_NO"], item["_FK_NO"] ];
            	break;

            // 매장-사원구분기능키설정
            case "MS721" :
                sql = sqlQuery.sqlDeleteScdEmpfkT;
            	sqlParameter = [ item["_SHOP_CD"] , item["_EMP_FG"] , item["_FK_NO"] ];
            	break;

            // 진동벨 연동
            case "MS911" :
                sql = sqlQuery.sqlDeleteScdPagmsT;
            	sqlParameter = [ item["_SHOP_CD"] , item["_PAG_NO"] ];
            	break;

            // KIOSK 터치분류
            case "MS931" :
                sql = sqlQuery.sqlDeleteScdKtclsT;
            	sqlParameter = [ item["_SHOP_CD"] , item["_TU_CLS_CD"] ];
            	break;

            // KIOSK 터치상품
            case "MS941" :
                sql = sqlQuery.sqlDeleteScdKtkeyT;
            	sqlParameter = [ item["_SHOP_CD"] , item["_TU_CLS_CD"] ,item["_TU_KEY_CD"] ];
            	break;

            /** jean43069 end **/

            /** jung start ************************************************************/

            //상품대분류
            case "MS201" :
                sql = sqlQuery.sqlDeleteScdClslmT;

                sqlParameter = [ item["_SHOP_CD"], item["_LCLS_CD"] ];
                break;
            //상품중분류
            case "MS211" :
                sql = sqlQuery.sqlDeleteScdClsmmT;

                sqlParameter = [ item["_SHOP_CD"], item["_MCLS_CD"] ];
                break;
            //상품소분류
            case "MS221" :
                sql = sqlQuery.sqlDeleteScdClssmT;

                sqlParameter = [ item["_SHOP_CD"], item["_SCLS_CD"] ];
                break;
            //상품마스터
            case "MS301" :
                sql = sqlQuery.sqlDeleteScdProdmT;
                sqlParameter = [ item["_SHOP_CD"], item["_PROD_CD"],  ];
                break;
            //판매가
            case "MS311" :
                sql = sqlQuery.sqlDeleteScdPrcdyT;
                sqlParameter = [ item["_SHOP_CD"], item["_PRC_MG_CD"], item["_PROD_CD"] ];
                break;
            //바코드
            case "MS321" :
                sql = sqlQuery.sqlDeleteScdClslmT;

                sqlParameter = [ item["_SHOP_CD"], item["_BAR_CD"]];
                break;
            //세트상품
            case "MS331" :
                sql = sqlQuery.sqlDeleteScdPrdstT;

                sqlParameter = [ item["_SHOP_CD"], item["_PROD_CD"], item["_UNIT_PROD_CD"] ];
                break;
            //매장 사이드메뉴 속성분류
            case "MS341" :
                sql = sqlQuery.sqlDeleteScdSdaclT;

                sqlParameter = [ item["_SHOP_CD"], item["_SDA_CLS_CD"] ];
                break;
            //매장 사이드메뉴 속성코드
            case "MS351" :
                sql = sqlQuery.sqlDeleteScdSdacdT;

                sqlParameter = [ item["_SHOP_CD"], item["_SDA_CD"] ];
                break;
            //매장 사이드메뉴 선택그룹
            case "MS361" :
                sql = sqlQuery.sqlDeleteScdSdsgrT;

                sqlParameter = [ item["_SHOP_CD"], item["_SDS_GRP_CD"] ];
                break;
            //매장 사이드메뉴 선택분류
            case "MS371" :
                sql = sqlQuery.sqlDeleteScdSdsclT;

                sqlParameter = [ item["_SHOP_CD"], item["_SDS_CLS_CD"] ];
                break;
            //매장 사이드메뉴 선택코드
            case "MS381" :
                sql = sqlQuery.sqlDeleteScdSdscdT;

                sqlParameter = [ item["_SHOP_CD"], item["_SDS_CD"] ];
                break;

            /** jung end **************************************************************/


        }

        //console.log("sqlParameter   :" + sqlParameter);
        return {"sql" : sql , "sqlParameter" : sqlParameter};
    }
    
    this.fnSelectQueryForReceipt = function(srId, item){

        var lastSql = "";
        var sqlParams = {};

        sqlParams = sqlQuery.fnInsertQueryParamsForReceipt(srId, item);
        
        if ( util.isEmptyStr( sqlParams.sql )) {
        	throw "전문 [%s] 의 속성[%s]의 SQL 이 없습니다.".sprintf(srId, item["_PROC_FG"]);
        }
        var params = sqlParams.sqlParameter;
        var newParams = []

        for(var i=0; i<params.length; i++) {
            if(params[i] === undefined) {
                newParams.push(null);
            } else {
                newParams.push(params[i]);
            }
        }
        
        lastSql = gfn_sqlBindParameters(sqlParams.sql, newParams );

        return lastSql;
    }

    this.fnInsertQueryParamsForReceipt = function(srId, item){
    	//item : orderInfo
        var insDt = moment().format("YYYYMMDDHHmmss");
        var sql = "";
        var sqlParameter = [];
        switch (srId) {

            /****************hjjang**************/
            //주문과 결제 정보를 둘다 받아서 저장 item : orderInfo
        	//매출TR-HEADER
	        case "SSL_TRHDR_T" :
	            sql = sqlQuery.sqlInsertSslTrhdrT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["POS_NO"], item["BILL_NO"]
                    , item["REGI_SEQ"], item["SALE_YN"], item["TOT_SALE_AMT"], item["TOT_DC_AMT"]
                    , item["SVC_TIP_AMT"], item["TOT_ETC_AMT"], item["DCM_SALE_AMT"], item["VAT_SALE_AMT"]
                    , item["VAT_AMT"], item["NO_VAT_SALE_AMT"], item["NO_TAX_SALE_AMT"], item["EXP_PAY_AMT"]
                    , item["GST_PAY_AMT"], item["RET_PAY_AMT"], item["CASH_AMT"], item["CRD_CARD_AMT"]
                    , item["WES_AMT"], item["TK_GFT_AMT"], item["TK_FOD_AMT"], item["CST_POINT_AMT"]
                    , item["JCD_CARD_AMT"], item["RFC_AMT"], item["ETC_APPR_AMT"], item["CST_NO"]
                    , item["CST_CARD_NO"], item["CST_SALE_POINT"], item["DC_GEN_AMT"], item["DC_SVC_AMT"]
                    , item["DC_PCD_AMT"], item["DC_CPN_AMT"], item["DC_CST_AMT"], item["DC_TFD_AMT"], item["DC_PRM_AMT"]
                    , item["DC_CRD_AMT"], item["DC_PACK_AMT"], item["DC_LYT_AMT"], item["REPAY_CASH_AMT"]
                    , item["REPAY_TK_GFT_AMT"], item["CASH_BILL_AMT"], item["DLV_ORDER_FG"], item["FD_TBL_CD"]
                    , item["FD_GST_CNT_T"], item["FD_GST_CNT_1"], item["FD_GST_CNT_2"], item["FD_GST_CNT_3"]
                    , item["FD_GST_CNT_4"], item["ORG_BILL_NO"], item["ORDER_NO"], item["INS_DT"], item["UPD_DT"]
                    , item["UPD_ID"], item["EMP_NO"], item["SEND_FG"], item["SEND_DT"]
                    , item["PAY_OUT_DT"], item["CST_NM"], item["DLV_EMP_NO"], item["DLV_START_DT"]
                    , item["DLV_PAYIN_EMP_NO"], item["DLV_PAYIN_DT"], item["NEW_DLV_ADDR_YN"], item["DLV_ADDR"]
                    , item["DLV_ADDR_DTL"], item["NEW_DLV_TEL_NO_YN"], item["DLV_TEL_NO"], item["DLV_CL_CD"]
                    , item["DLV_CM_CD"], item["TRAVEL_CD"], item["RSV_NO"], item["PRE_PAY_CASH"]
                    , item["PRE_PAY_CARD"], item["RSV_USER_NM"], item["RSV_USER_TEL_NO"], item["CST_AVL_POINT"]
                    , item["LOCAL_POINT_YN"], item["CST_USE_POINT"], item["CANCEL_REASON"], item["CUP_DEPOSIT_AMT"]
                    ];
                break;
                
	        case "POS_ODHDR_T" :
	            sql = sqlQuery.sqlInsertPosOdhdrT;
	        	sqlParameter = [ item["SHOP_CD"], item["SALE_DATE"], item["ORDER_NO"], item["POS_NO"], item["DLV_ORDER_FG"]
	        		, item["ORDER_END_FG"], item["FD_TBL_CD"], item["TOT_SALE_AMT"], item["TOT_DC_AMT"], item["SVC_TIP_AMT"]
	        		, item["TOT_ETC_AMT"], item["DCM_SALE_AMT"], item["VAT_SALE_AMT"], item["VAT_AMT"], item["NO_VAT_SALE_AMT"]
	        		, item["NO_TAX_SALE_AMT"], item["EXP_PAY_AMT"], item["GST_PAY_AMT"], item["RET_PAY_AMT"], item["CASH_AMT"]
	        		, item["CRD_CARD_AMT"], item["WES_AMT"], item["TK_GFT_AMT"], item["TK_FOD_AMT"], item["CST_POINT_AMT"]
	        		, item["JCD_CARD_AMT"], item["RFC_AMT"], item["ETC_APPR_AMT"], item["CST_NO"], item["CST_CARD_NO"]
	        		, item["CST_SALE_POINT"], item["DC_GEN_AMT"], item["DC_SVC_AMT"], item["DC_PCD_AMT"], item["DC_CPN_AMT"]
	        		, item["DC_CST_AMT"], item["DC_TFD_AMT"], item["DC_PRM_AMT"], item["DC_CRD_AMT"], item["DC_PACK_AMT"]
	        		, item["DC_LYT_AMT"], item["REPAY_CASH_AMT"], item["REPAY_TK_GFT_AMT"], item["CASH_BILL_AMT"], item["FD_GST_CNT_T"]
	        		, item["FD_GST_CNT_1"], item["FD_GST_CNT_2"], item["FD_GST_CNT_3"], item["FD_GST_CNT_4"], item["INS_DT"], item["EMP_NO"]
	        		, item["ORDER_END_DT"], item["BILL_NO"], item["SEND_FG"], item["SEND_DT"], item["DELIVER_NO"], item["RESERVED_NO"]
	        		, item["KITCHEN_MEMO"], item["CST_NM"], item["NEW_DLV_ADDR_YN"], item["DLV_ADDR"], item["DLV_ADDR_DTL"]
	        		, item["NEW_DLV_TEL_NO_YN"], item["DLV_TEL_NO"], item["DLV_PAY_TYPE_FG"], item["DLV_IDT_NO"], item["DLV_EMP_NO"]
	        		, item["DLV_REMARK"], item["DLV_START_DT"], item["DLV_PAYIN_EMP_NO"], item["DLV_PAYIN_DT"], item["DLV_BOWLIN_YN"]
	        		, item["DLV_BOWLIN_EMP_NO"], item["DLV_BOWLIN_DT"], item["DLV_CL_CD"], item["DLV_CM_CD"], item["DLV_DEBT_FG"]
	        		, item["TRAVEL_CD"], item["RSV_NO"], item["PRE_PAY_CASH"], item["PRE_PAY_CARD"], item["RSV_USER_NM"]
	        		, item["RSV_USER_TEL_NO"], item["CST_AVL_POINT"], item["DLV_MOBILE_FG"], item["LOCAL_POINT_YN"], item["CST_USE_POINT"]
	        		, item["PAGER_VIBE_FG"], item["FD_TBL_CD"], item["CUP_DEPOSIT_AMT"]
                    ];
            break;    
            
        	/****************hjjang**************/
        }
        return {"sql" : sql , "sqlParameter" : sqlParameter};
    }
    
    this.menuProdSideMenuDetail_SQL = ""
    	+ "\n  SELECT                                                                                                  ".rtrim()
    	+ "\n         CASE                                                                                             ".rtrim()
    	+ "\n              WHEN  '1' = VAT_CD  AND TAX_YN = 'Y' THEN SIDE_UPRC_ORG                                     ".rtrim()
    	+ "\n              WHEN  '0' = VAT_CD  AND TAX_YN = 'Y' THEN 공급가 + VAT                                      ".rtrim()
    	+ "\n              ELSE 공급가                                                                                 ".rtrim()
    	+ "\n          END AS SIDE_UPRC                                                                                ".rtrim()
    	+ "\n       ,  *                                                                                               ".rtrim()
    	+ "\n    FROM (                                                                                                ".rtrim()
    	+ "\n       SELECT                                                                                                                        ".rtrim()
		+ "\n       	  *                                                                                                                       ".rtrim()
		+ "\n       	, CASE                                                                                                                    ".rtrim()
		+ "\n         		  WHEN '1' = VAT_CD AND TAX_YN = 'Y' THEN  SIDE_UPRC_ORG - 공급가                                                     ".rtrim()  /** 과세 품목. TAX 포함 **/
		+ "\n         		  WHEN '0' = VAT_CD AND TAX_YN = 'Y' THEN  CAST ( ROUND( ( 공급가 * 0.1 ) ) AS INTEGER)                               ".rtrim()   /** 과세 품목. 미포함 **/
		+ "\n         		  WHEN TAX_YN = 'N'                THEN  0                                                                            ".rtrim()  /** 비과세 품목.**/
		+ "\n         		  ELSE 0                                                                                                              ".rtrim()
		+ "\n         	   END  VAT                                                                                                               ".rtrim()
		+ "\n        FROM (                                                                                                                       ".rtrim()
		+ "\n          SELECT                                                                                                                     ".rtrim()
		+ "\n          		  SIDE_TYPE                                                                                                           ".rtrim()
		+ "\n          		, SIDE_CLS_CD                                                                                                         ".rtrim()
		+ "\n          		, SIDE_CD                                                                                                             ".rtrim()
		+ "\n          		, SIDE_NM                                                                                                             ".rtrim()
		+ "\n          		, SIDE_NM_EN                                                                                                          ".rtrim()
		+ "\n          		, SIDE_UPRC_ORG                                                                                                       ".rtrim()
		+ "\n          		, SIDE_SEQ                                                                                                            ".rtrim()
		+ "\n          		, PROD_CD                                                                                                             ".rtrim()
		+ "\n       		, TAX_YN                                                                                                              ".rtrim()
		+ "\n       		, VAT_CD                                                                                                              ".rtrim()
		+ "\n         		, CASE                                                                                                                ".rtrim()
		+ "\n         			   WHEN SIDE_TYPE != 'A' AND '1' = VAT_CD AND TAX_YN = 'Y' THEN CAST ( ROUND( ( SIDE_UPRC_ORG / 1.1 ) )  AS INTEGER)  ".rtrim()  /** 과세 품목.**/
		+ "\n       			   WHEN SIDE_TYPE != 'A' AND '0' = VAT_CD AND TAX_YN = 'Y' THEN SIDE_UPRC_ORG                                         ".rtrim()  /** 과세 품목.  **/
		+ "\n         			   WHEN SIDE_TYPE != 'A' AND                  TAX_YN = 'N' THEN SIDE_UPRC_ORG                                         ".rtrim()  /** 비과세 품목. **/
		+ "\n       			   ELSE 0                                                                                                         ".rtrim()
		+ "\n         		   END AS  공급가                                                                                                     ".rtrim()
		+ "\n       		, IMG_URL                                                                                                              ".rtrim()
		+ "\n       		, STAMP_ACC_YN                                                                                                              ".rtrim()
		+ "\n       		, STAMP_ACC_QTY                                                                                                              ".rtrim()
		+ "\n       		, STAMP_USE_YN                                                                                                              ".rtrim()
		+ "\n       		, STAMP_USE_QTY                                                                                                              ".rtrim()
		+ "\n       		, KIOSK_PROD_STATUS                                                                                                              ".rtrim()
		+ "\n           FROM                                                                                                                      ".rtrim()
		+ "\n          (                                                                                                                          ".rtrim()
		+ "\n          	SELECT                                                                                                                    ".rtrim()
		+ "\n          		  'A'               AS SIDE_TYPE                                                                                      ".rtrim()
		+ "\n          		, SDA_CLS_CD        AS SIDE_CLS_CD                                                                                    ".rtrim()
		+ "\n          		, SDA_CD            AS SIDE_CD                                                                                        ".rtrim()
		+ "\n          		, SDA_NM            AS SIDE_NM                                                                                        ".rtrim()
		+ "\n          		, SDA_NM_EN         AS SIDE_NM_EN                                                                                     ".rtrim()
		+ "\n          		, ''                AS SIDE_UPRC_ORG                                                                                  ".rtrim()
		+ "\n          		, SDA_ORDER_SEQ     AS SIDE_SEQ                                                                                       ".rtrim()
		+ "\n          		, ''                AS PROD_CD                                                                                        ".rtrim()
		+ "\n       		, ''                AS TAX_YN                                                                                         ".rtrim()
		+ "\n       		, ''                AS IMG_URL                                                                                        ".rtrim()
		+ "\n       		, ''                AS STAMP_ACC_YN                                                                                   ".rtrim()
		+ "\n       		, ''                AS STAMP_ACC_QTY                                                                                  ".rtrim()
		+ "\n       		, ''                AS STAMP_USE_YN                                                                                   ".rtrim()
		+ "\n       		, ''                AS STAMP_USE_QTY                                                                                  ".rtrim()
		+ "\n       		, ''                AS KIOSK_PROD_STATUS                                                                                  ".rtrim()
		+ "\n       		, ''                AS CUP_DEPOSIT_FG                                                                                  ".rtrim()
		+ "\n       		, ''                AS CUP_FG                                                                                  ".rtrim()
		+ "\n          	  FROM SCD_SDACD_T                                                                                                        ".rtrim()
		+ "\n          	 WHERE SHOP_CD      = ?                                                                                                   ".rtrim()  //SHOP_CD
		+ "\n          	   AND SDA_CLS_CD   = ?                                                                                                   ".rtrim()  //SDA_CLS_CD
		+ "\n          	   AND USE_YN       = 'Y'                                                                                                 ".rtrim()
		+ "\n          	UNION                                                                                                                     ".rtrim()
		+ "\n          	SELECT                                                                                                                    ".rtrim()
		+ "\n          		  'B'                AS SIDE_TYPE                                                                                     ".rtrim()
		+ "\n          		, A.SDS_CLS_CD       AS SIDE_CLS_CD                                                                                   ".rtrim()
		+ "\n          		, A.SDS_CD           AS SIDE_CD                                                                                       ".rtrim()
		+ "\n          		, A.SDS_NM           AS SIDE_NM                                                                                       ".rtrim()
		+ "\n          		, A.SDS_NM_EN        AS SIDE_NM_EN                                                                                    ".rtrim()
		+ "\n          		, A.SDS_PROD_UPRC    AS SIDE_UPRC_ORG                                                                                 ".rtrim()
		+ "\n          		, A.SDS_ORDER_SEQ    AS SIDE_SEQ                                                                                      ".rtrim()
		+ "\n          		, A.PROD_CD          AS PROD_CD                                                                                       ".rtrim()
		+ "\n       		, D.TAX_YN           AS TAX_YN                                                                                        ".rtrim()
		+ "\n       		, D.IMG_URL          AS IMG_URL                                                                                       ".rtrim()
		+ "\n       		, D.STAMP_ACC_YN     AS STAMP_ACC_YN                                                                                  ".rtrim()
		+ "\n       		, D.STAMP_ACC_QTY    AS STAMP_ACC_QTY                                                                                 ".rtrim()
		+ "\n       		, D.STAMP_USE_YN     AS STAMP_USE_YN                                                                                  ".rtrim()
		+ "\n       		, D.STAMP_USE_QTY    AS STAMP_USE_QTY                                                                                 ".rtrim()
		+ "\n       		, D.KIOSK_PROD_STATUS AS KIOSK_PROD_STATUS                                                                            ".rtrim()
		+ "\n       		, D.CUP_DEPOSIT_FG AS CUP_DEPOSIT_FG                                                                                 ".rtrim()
		+ "\n       		, D.CUP_FG AS CUP_FG                                                                                				 ".rtrim()
		+ "\n          	 FROM SCD_SDSCD_T A                                                                                                       ".rtrim()
		+ "\n       	    , SCD_SDSCL_T B /* 중분류*/                                                                                             ".rtrim()
		+ "\n       	    , SCD_SDSGR_T C                                                                                                       ".rtrim()
		+ "\n       	    , SCD_PRODM_T D                                                                                                       ".rtrim()
		+ "\n       	WHERE A.SHOP_CD    = ?                                                                                                    ".rtrim() //SHOP_CD
		+ "\n       	  AND B.SHOP_CD    = ?                                                                                                    ".rtrim() //SHOP_CD
		+ "\n       	  AND C.SHOP_CD    = ?                                                                                                    ".rtrim() //SHOP_CD
		+ "\n       	  AND D.SHOP_CD    = ?                                                                                                    ".rtrim() //SHOP_CD
		+ "\n       	  AND C.SDS_GRP_CD = ?                                                                                                    ".rtrim() //SDS_GRP_CD
		+ "\n       	  AND A.USE_YN     = 'Y'                                                                                                  ".rtrim()
		+ "\n       	  AND B.USE_YN     = 'Y'                                                                                                  ".rtrim()
		+ "\n       	  AND C.USE_YN     = 'Y'                                                                                                  ".rtrim()
		+ "\n       	  AND D.USE_YN     = 'Y'                                                                                                  ".rtrim()
		+ "\n       	  AND A.SHOP_CD    = B.SHOP_CD                                                                                            ".rtrim()
		+ "\n       	  AND A.SDS_CLS_CD = B.SDS_CLS_CD                                                                                         ".rtrim()
		+ "\n       	  AND B.SHOP_CD    = C.SHOP_CD                                                                                            ".rtrim()
		+ "\n       	  AND B.SDS_GRP_CD = C.SDS_GRP_CD                                                                                         ".rtrim()
		+ "\n       	  AND A.SHOP_CD    = D.SHOP_CD                                                                                            ".rtrim()
		+ "\n       	  AND A.PROD_CD    = D.PROD_CD                                                                                            ".rtrim()
		+ "\n          )                                                                                                                          ".rtrim()
		+ "\n       	, (SELECT  ? AS VAT_CD ) D                                                                                                ".rtrim() // vat 코드 /** VAT 포함 여부 코드 **/
		+ "\n         )                                                                                                                             ".rtrim()
		+ "\n   ) ORDER BY SIDE_SEQ ASC                                                                                                                            ".rtrim()
    ;

    this.menuProdSideMenuGroup_SQL = ""
		+ "\n  SELECT  /** 속성분류 와 선택분류 정보 반환**/              ".rtrim()
		+ "\n         SIDE_NM                                             ".rtrim()
		+ "\n       , SIDE_NM_EN                                          ".rtrim()
		+ "\n       , SIDE_FG                                             ".rtrim()
		+ "\n       , SIDE_TYPE                                           ".rtrim()
		+ "\n       , SDA_CLS_CD                                          ".rtrim()
		+ "\n       , SDS_PROC_FG                                          ".rtrim()
		+ "\n  FROM ( SELECT                                              ".rtrim()
		+ "\n                SDA_CLS_NM || ' [속성]' AS SIDE_NM           ".rtrim()
		+ "\n              , SDA_CLS_NM_EN || ' [Attri]' AS SIDE_NM_EN    ".rtrim()
		+ "\n              , SDA_CLS_CD              AS SIDE_FG           ".rtrim()
		+ "\n              , SDA_ORDER_SEQ           AS SIDE_SEQ          ".rtrim()
		+ "\n              , 'A'			         AS SIDE_TYPE         ".rtrim()
		+ "\n              , SDA_CLS_CD              AS SDA_CLS_CD        ".rtrim()
		+ "\n              , '0'                     AS SDS_PROC_FG        ".rtrim()
		+ "\n         FROM SCD_SDACL_T                                    ".rtrim()
		+ "\n         WHERE SHOP_CD    = ?                                ".rtrim()
		+ "\n         AND   SDA_CLS_CD = ?                                ".rtrim()
		+ "\n         AND   USE_YN     = 'Y'                              ".rtrim()
		+ "\n         UNION                                               ".rtrim()
		+ "\n         SELECT                                              ".rtrim()
		+ "\n                CASE WHEN SDS_PROC_FG = '4' THEN '*필수항목' ELSE SDS_CLS_NM || ' [선택]' END AS SIDE_NM ".rtrim()
		+ "\n              , SDS_CLS_NM_EN || ' [Select]' AS SIDE_NM_EN   ".rtrim()
		+ "\n              , SDS_CLS_CD              AS SIDE_FG           ".rtrim()
		+ "\n              , SDS_ORDER_SEQ           AS SIDE_SEQ          ".rtrim()
		+ "\n              , 'B'                     AS SIDE_TYPE         ".rtrim()
		+ "\n              , SDS_GRP_CD              AS SDA_CLS_CD        ".rtrim()
		/* + "\n              , SDS_PROC_FG             AS SDS_PROC_FG        ".rtrim() 빈값일경우 기본값으로 처리..  */
		+ "\n 			   , CASE WHEN SDS_PROC_FG IS NULL THEN '0' WHEN SDS_PROC_FG = '' THEN '0' ELSE SDS_PROC_FG END    AS SDS_PROC_FG ".rtrim()
		+ "\n         FROM SCD_SDSCL_T                                    ".rtrim()
		+ "\n         WHERE SHOP_CD    = ?                                ".rtrim()
		+ "\n         AND   SDS_GRP_CD = ?                                ".rtrim()
		+ "\n         AND   USE_YN     = 'Y'                              ".rtrim()
		+ "\n  	 )                                                        ".rtrim()
		+ "\n    ORDER BY SIDE_TYPE , SIDE_SEQ, SIDE_FG                   ".rtrim()
		;
    this.menuProdProducdData_SQL = ""
    	+ "\n  SELECT                                                                                                  ".rtrim()
    	+ "\n         CASE                                                                                             ".rtrim()
    	+ "\n              WHEN  '1' = VAT_CD  AND TAX_YN = 'Y' THEN SALE_UPRC_ORG                                     ".rtrim()
    	+ "\n              WHEN  '0' = VAT_CD  AND TAX_YN = 'Y' THEN 공급가 + VAT                                      ".rtrim()
    	+ "\n              ELSE 공급가                                                                                 ".rtrim()
    	+ "\n          END AS SALE_UPRC                                                                                ".rtrim()
    	+ "\n       , A.*                                                                                              ".rtrim()
    	+ "\n       , VAN_TERM_NO                                                                                      ".rtrim()
    	+ "\n       , (SELECT (CASE WHEN 'MEMBERSHIP' = upper(TU_CLS_NM_EN) THEN 'Y' ELSE 'N' END) FROM SCD_KTCLS_T B WHERE A.TU_FG = B.TU_FG AND A.TU_CLS_CD = B.TU_CLS_CD) AS MBS_PROD_YN                                                                                      ".rtrim()
		+ "\n       , (SELECT IFNULL(B.TU_CLS_PROC_FG, '1') FROM SCD_KTCLS_T B WHERE A.TU_FG = B.TU_FG AND A.TU_CLS_CD = B.TU_CLS_CD) AS TU_CLS_PROC_FG ".rtrim()
    	+ "\n    FROM (                                                                                                ".rtrim()
		+ "\n  SELECT                                                                                                  ".rtrim()
		+ "\n  	CASE                                                                                                   ".rtrim()
		+ "\n  		WHEN '1' = VAT_CD AND TAX_YN = 'Y' THEN SALE_UPRC_ORG - 공급가                                     ".rtrim() /** 과세 품목. TAX 포함  **/
		+ "\n  		WHEN '0' = VAT_CD AND TAX_YN = 'Y' THEN CAST ( ROUND( (   공급가 * 0.1 ) )    AS INTEGER)          ".rtrim() /** 과세 품목. 미포함  **/
		+ "\n  		WHEN TAX_YN = 'N'                  THEN 0/** 비과세 품목.**/                                       ".rtrim()
		+ "\n  		ELSE 0                                                                                             ".rtrim()
		+ "\n  	 END  VAT                                                                                              ".rtrim()
		+ "\n  	,  *                                                                                                   ".rtrim()
		+ "\n   FROM (                                                                                                 ".rtrim()
		+ "\n    SELECT  DISTINCT                                                                                      ".rtrim()
		+ "\n            A.TU_FG                           AS TU_FG                                                    ".rtrim()
		+ "\n          , A.TU_CLS_CD                       AS TU_CLS_CD                                                ".rtrim()
		+ "\n          , A.TU_KEY_CD                       AS TU_KEY_CD                                                ".rtrim()
		+ "\n          , A.PROD_CD                         AS PROD_CD                                                  ".rtrim()
		+ "\n          , B.PROD_NM                         AS PROD_NM                                                  ".rtrim()
		+ "\n          , B.TAX_YN                          AS TAX_YN                                                   ".rtrim()
		+ "\n          , IFNULL( B.PROD_NM_EN , B.PROD_NM) AS PROD_NM_EN                                               ".rtrim()
		+ "\n          , B.IMG_URL                         AS IMG_URL                                                  ".rtrim()
		+ "\n          , B.IMG_DOWNLOAD_FG                 AS IMG_DOWNLOAD_FG                                          ".rtrim()
		//+ "\n          , B.KIOSK_PROD_STATUS               AS KIOSK_PROD_STATUS                                        ".rtrim()
		+ "\n          , CASE WHEN (B.KIOSK_PROD_STATUS_RBT IS NOT NULL OR B.KIOSK_PROD_STATUS_RBT != '')              ".rtrim()
		+ "\n          		THEN (                                        											   ".rtrim()
		+ "\n          			CASE WHEN B.KIOSK_PROD_STATUS = '4' THEN B.KIOSK_PROD_STATUS                           ".rtrim()
		+ "\n          	 	ELSE ( CASE WHEN B.KIOSK_PROD_STATUS_RBT = '4' THEN B.KIOSK_PROD_STATUS_RBT ELSE B.KIOSK_PROD_STATUS END ) ".rtrim()
		+ "\n          	 	END )                                        											   ".rtrim()
		+ "\n            ELSE B.KIOSK_PROD_STATUS                                        							   ".rtrim()
		+ "\n          	 END AS KIOSK_PROD_STATUS                                        							   ".rtrim()
		+ "\n          , C.SALE_UPRC                       AS SALE_UPRC_ORG                                            ".rtrim()
		+ "\n          , C.NORMAL_UPRC                     AS NORMAL_UPRC                                            ".rtrim()
		+ "\n  		    /** 과세 포함.**/                                                                              ".rtrim()
		+ "\n  		   , CASE                                                                                          ".rtrim()
		+ "\n  				WHEN '1' = VAT_CD AND TAX_YN = 'Y' THEN CAST ( ROUND( ( C.SALE_UPRC / 1.1 ) )  AS INTEGER) ".rtrim() /** 부가세 포함,과세 품목.**/
		+ "\n  				WHEN '0' = VAT_CD AND TAX_YN = 'Y' THEN C.SALE_UPRC                                        ".rtrim()  /** 부가세 비포함,과세 품목.**/
		+ "\n  				WHEN TAX_YN = 'N'                  THEN C.SALE_UPRC                                        ".rtrim() /** 비과세 품목.**/
		+ "\n  		       ELSE 0                                                                                      ".rtrim()
		+ "\n  		      END AS  \"공급가\"                                                                           ".rtrim()
		+ "\n          , B.SIDE_MENU_YN                     AS SIDE_MENU_YN /** 사이드메뉴 사용여부       **/          ".rtrim()
		+ "\n          , B.SDA_CLS_CD                       AS SDA_CLS_CD   /** 사이드메뉴-속성분류코드   **/          ".rtrim()
		+ "\n          , B.SDS_GRP_CD                       AS SDS_GRP_CD   /** 사이드메뉴-선택그룹코드   **/          ".rtrim()
		+ "\n          , 1                                  AS ORDER_QTY    /** 주문수량에 사용하기 위함  **/          ".rtrim()
		+ "\n          , STAMP_ACC_YN                                                                                  ".rtrim()
		+ "\n          , STAMP_ACC_QTY                                                                                 ".rtrim()
		+ "\n          , STAMP_USE_YN                                                                                  ".rtrim()
		+ "\n          , STAMP_USE_QTY                                                                                 ".rtrim()
		+ "\n          , VAT_CD                                                                                        ".rtrim()
		+ "\n          , CORNER_CD                                                                                     ".rtrim()
		+ "\n          , TU_PROD_SEQ                                                                                   ".rtrim()
		+ "\n          , '' AS DC_AMT                                                                                  ".rtrim()
		+ "\n          , B.DESCRIPTION_DISP_YN                                                                         ".rtrim()
		+ "\n          , B.DESCRIPTION                                                                                 ".rtrim()
		+ "\n          , B.DESCRIPTION_EN                                                                              ".rtrim()
		+ "\n          , B.LCLS_CD                                                                              	   ".rtrim()
		+ "\n          , B.MCLS_CD                                                                              	   ".rtrim()
		+ "\n          , B.SCLS_CD                                                                              	   ".rtrim()
		+ "\n          , B.PRICE_MGR_FG                                                                                ".rtrim()
		+ "\n          , PRT_NO                                                                              		   ".rtrim()
		+ "\n          , IFNULL(E.BAR_CD ,'')              AS BAR_CD                                                   ".rtrim()
		+ "\n          , B.CST_ACCDC_YN                                                   							   ".rtrim()
		+ "\n          , B.CUP_DEPOSIT_FG                                                   						   ".rtrim()
		+ "\n          , B.CUP_FG                                                   							       ".rtrim()
		+ "\n       FROM SCD_KTKEY_T A   /** KIOSK 터치상품          **/                                                      ".rtrim()
		+ "\n          , SCD_PRODM_T B   /** 상품마스터              **/                                                        ".rtrim()
		+ "\n    	  , (                                                                                              ".rtrim()
		+ "\n    		  SELECT                                                                                       ".rtrim()
		+ "\n    		      A.PROD_CD                                                                                ".rtrim()
		+ "\n    		    , A.S_DATE                                                                                 ".rtrim()
		+ "\n    		    , A.E_DATE                                                                                 ".rtrim()
		+ "\n    		    , B.SALE_UPRC                                                                              ".rtrim()
		+ "\n    		    , B.NORMAL_UPRC                                                                              ".rtrim()
		+ "\n    		  FROM SCD_PRCDT_T  A                                                                          ".rtrim()
		+ "\n    		    , (                                                                                        ".rtrim()
		+ "\n    		  	SELECT                                                                                     ".rtrim()
		+ "\n    		  	  A.PROD_CD, MAX(S_DATE) S_DATE, MAX(S_TIME), MAX(PRC_MG_CD), SALE_UPRC, NORMAL_UPRC	   ".rtrim()
		+ "\n    		  	FROM SCD_PRCDT_T A, SCD_PRODM_T B                                                          ".rtrim()
		+ "\n    		  	WHERE A.SHOP_CD = ?                                                                          ".rtrim() //shop_cd
		+ "\n    		  	AND A.PROD_CD = B.PROD_CD                                    							   ".rtrim()
		+ "\n    		  	AND A.SHOP_CD = B.SHOP_CD                                     							   ".rtrim()
		+ "\n    		  	AND (CASE WHEN '0' = ? THEN (A.PRC_MG_NM != '정기구독' and A.PRC_MG_NM != '정기구독_아메리카노') ELSE A.PRC_MG_NM = ? END)        ".rtrim()
		+ "\n    		  	AND (CASE WHEN '0' = ? THEN A.PRC_MG_NM != '특정시간판매' ELSE A.PRC_MG_NM = '특정시간판매' END)   ".rtrim()
		+ "\n    		  	AND S_DATE  <= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
		+ "\n    		  	AND E_DATE  >= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
		+ "\n    		  	AND strftime('%H%M' , 'NOW' , 'localtime')                                     	   		   ".rtrim()
		+ "\n    		  		BETWEEN strftime('%H%M', substr(IFNULL(CASE WHEN S_TIME == '' THEN NULL ELSE S_TIME END, '0000'), 1, 2)||	".rtrim()
		+ "\n    		  			':'||substr(IFNULL(CASE WHEN S_TIME == '' THEN NULL ELSE S_TIME END, '0000'), 3, 4))                    ".rtrim()
		+ "\n    		  		AND strftime('%H%M', substr(IFNULL(CASE WHEN E_TIME == '' THEN NULL ELSE E_TIME END, '2359'), 1, 2)||		".rtrim()
		+ "\n    		  			':'||substr(IFNULL(CASE WHEN E_TIME == '' THEN NULL ELSE E_TIME END, '2359'), 3, 4))".rtrim()
		+ "\n    		  	GROUP BY A.PROD_CD                                                                           ".rtrim()
		+ "\n    		    ) B                                                                                        ".rtrim()
		+ "\n    		  WHERE A.SHOP_CD = ?                                                                          ".rtrim() //shop_cd
		+ "\n    		    AND A.S_DATE  <= strftime('%Y%m%d' , 'NOW' , 'localtime')                                  ".rtrim()
		+ "\n    		    AND A.E_DATE  >= strftime('%Y%m%d' , 'NOW' , 'localtime')                                  ".rtrim()
		+ "\n    		    AND A.PROD_CD = B.PROD_CD                                                                  ".rtrim()
		+ "\n    		    AND A.S_DATE  = B.S_DATE                                                                   ".rtrim()
		+ "\n    	   ) C                                                                                             ".rtrim()
		+ "\n  	   , (SELECT  ? AS VAT_CD ) D /** VAT 포함 여부 코드 **/                                               	   ".rtrim() //VAT CD (CODE 128)  1 : 과세 포함, 0 : 과세 불포함.(부과세 별도)
		+ "\n  	   LEFT OUTER JOIN SCD_BARCD_T E ON B.SHOP_CD = E.SHOP_CD AND B.PROD_CD = E.PROD_CD                    ".rtrim() 
		+ "\n  	   LEFT OUTER JOIN ( SELECT PROD_CD, GROUP_CONCAT(PRT_NO) PRT_NO FROM SCD_PRTPR_T 					   ".rtrim() 
		+ "\n  	   	WHERE SHOP_CD = ? AND USE_YN  = 'Y' GROUP BY SHOP_CD , PROD_CD)  F ON B.PROD_CD = F.PROD_CD        ".rtrim() 
		+ "\n     WHERE B.SHOP_CD       = A.SHOP_CD                                                                    ".rtrim()
		+ "\n       AND B.PROD_CD       = A.PROD_CD                                                                    ".rtrim()
		+ "\n       AND A.SHOP_CD       = ?                                                                            ".rtrim() //shop_cd
		//+ "\n       AND A.TU_FG         = 'S'                                                                          ".rtrim()//2020.09.08 최광림 차장 요청( 의미없는 조건)
		+ "\n       AND A.TU_CLS_CD     = IFNULL ( ? , A.TU_CLS_CD )                                                   ".rtrim() //clscd-> 터치분류CD
		+ "\n       AND B.PRICE_MGR_FG  != '1'                                                                         ".rtrim()
		+ "\n       AND B.USE_YN        = 'Y'                                                                          ".rtrim()
		+ "\n       AND B.KIOSK_PROD_YN = 'Y'  /** KIOSK 상품 여부 **/                                                 ".rtrim()
		+ "\n       AND B.SALE_PROD_YN  = 'Y'                                                                          ".rtrim()
		+ "\n       AND A.PROD_CD       = C.PROD_CD                                                                    ".rtrim()
		+ "\n       AND (CASE WHEN ? = 'ALL' THEN 1=1 ELSE B.CORNER_CD = ? END)                                        ".rtrim()
		+ "\n  )                                                                                                       ".rtrim()
		+ "\n )   A ,                                                                                                  ".rtrim()
		+ "\n  (                                                                                                       ".rtrim()
		+ "\n   SELECT CORNER_CD                                                                                       ".rtrim()
		+ "\n        , CORNER_NM                                                                                       ".rtrim()
		+ "\n        , OWNER_NM                                                                                        ".rtrim()
		+ "\n        , BIZ_NO                                                                                          ".rtrim()
		+ "\n        , CASE                                                                                            ".rtrim()
		+ "\n 	       WHEN CORNER_CD = '00' THEN                                                                      ".rtrim()
		+ "\n 	          (SELECT VAN_TERM_NO                                                                          ".rtrim()
		+ "\n 	             FROM SCD_POSMS_T                                                                          ".rtrim()
		+ "\n 	            WHERE SHOP_CD = ?                                                                          ".rtrim()
		+ "\n                   AND POS_NO = ? )                                                                       ".rtrim()
		+ "\n            ELSE VAN_TERM_NO                                                                              ".rtrim()
		+ "\n 	     END AS VAN_TERM_NO                                                                                ".rtrim()
		+ "\n    FROM SCD_SHOPS_T                                                                                      ".rtrim()
		+ "\n   WHERE SHOP_CD = ?                                                                                      ".rtrim()
		+ "\n AND   USE_YN  = 'Y'                                                                                      ".rtrim()
		+ "\n  ) B                                                                                                     ".rtrim()
		+ "\n WHERE A.CORNER_CD = B.CORNER_CD                                                                          ".rtrim()
		+ "\n ORDER BY TU_CLS_CD , TU_PROD_SEQ                                                                         ".rtrim()
		;
    this.menuProdProducdToGoData_SQL = ""
    	+ "\n  SELECT                                                                                                  ".rtrim()
    	+ "\n         CASE                                                                                             ".rtrim()
    	+ "\n              WHEN  '1' = VAT_CD  AND TAX_YN = 'Y' THEN SALE_UPRC_ORG                                     ".rtrim()
    	+ "\n              WHEN  '0' = VAT_CD  AND TAX_YN = 'Y' THEN 공급가 + VAT                                      ".rtrim()
    	+ "\n              ELSE 공급가                                                                                 ".rtrim()
    	+ "\n          END AS SALE_UPRC                                                                                ".rtrim()
    	+ "\n       , A.*                                                                                              ".rtrim()
    	+ "\n       , VAN_TERM_NO                                                                                      ".rtrim()
    	+ "\n       , (SELECT (CASE WHEN 'MEMBERSHIP' = upper(TU_CLS_NM_EN) THEN 'Y' ELSE 'N' END) FROM SCD_KTCLS_T B WHERE A.TU_FG = B.TU_FG AND A.TU_CLS_CD = B.TU_CLS_CD) AS MBS_PROD_YN                                                                                      ".rtrim()
		+ "\n       , (SELECT IFNULL(B.TU_CLS_PROC_FG, '1') FROM SCD_KTCLS_T B WHERE A.TU_FG = B.TU_FG AND A.TU_CLS_CD = B.TU_CLS_CD) AS TU_CLS_PROC_FG ".rtrim()
    	+ "\n    FROM (                                                                                                ".rtrim()
    	+ "\n  SELECT                                                                                                  ".rtrim()
    	+ "\n  	CASE                                                                                                   ".rtrim()
    	+ "\n  		WHEN '1' = VAT_CD AND TAX_YN = 'Y' THEN SALE_UPRC_ORG - 공급가                                     ".rtrim() /** 과세 품목. TAX 포함  **/
		+ "\n  		WHEN '0' = VAT_CD AND TAX_YN = 'Y' THEN CAST ( ROUND( (   공급가 * 0.1 ) )    AS INTEGER)          ".rtrim() /** 과세 품목. 미포함  **/
		+ "\n  		WHEN TAX_YN = 'N'                  THEN 0/** 비과세 품목.**/                                       ".rtrim()
		+ "\n  		ELSE 0                                                                                             ".rtrim()
		+ "\n  	 END  VAT                                                                                              ".rtrim()
    	+ "\n  	,  *                                                                                                   ".rtrim()
    	+ "\n   FROM (                                                                                                 ".rtrim()
    	+ "\n    SELECT  DISTINCT                                                                                      ".rtrim()
    	+ "\n            A.TU_FG                           AS TU_FG                                                    ".rtrim()
    	+ "\n          , A.TU_CLS_CD                       AS TU_CLS_CD                                                ".rtrim()
    	+ "\n          , A.TU_KEY_CD                       AS TU_KEY_CD                                                ".rtrim()
    	+ "\n          , A.PROD_CD                         AS PROD_CD                                                  ".rtrim()
    	+ "\n          , B.PROD_NM                         AS PROD_NM                                                  ".rtrim()
    	+ "\n          , B.TAX_YN                          AS TAX_YN                                                   ".rtrim()
    	+ "\n          , IFNULL( B.PROD_NM_EN , B.PROD_NM) AS PROD_NM_EN                                               ".rtrim()
    	+ "\n          , B.IMG_URL                         AS IMG_URL                                                  ".rtrim()
    	+ "\n          , B.IMG_DOWNLOAD_FG                 AS IMG_DOWNLOAD_FG                                          ".rtrim()
    	//+ "\n          , B.KIOSK_PROD_STATUS               AS KIOSK_PROD_STATUS                                        ".rtrim()
    	+ "\n          , CASE WHEN (B.KIOSK_PROD_STATUS_RBT IS NOT NULL OR B.KIOSK_PROD_STATUS_RBT != '')              ".rtrim()
		+ "\n          		THEN (                                        											   ".rtrim()
		+ "\n          			CASE WHEN B.KIOSK_PROD_STATUS = '4' THEN B.KIOSK_PROD_STATUS                           ".rtrim()
		+ "\n          	 	ELSE ( CASE WHEN B.KIOSK_PROD_STATUS_RBT = '4' THEN B.KIOSK_PROD_STATUS_RBT ELSE B.KIOSK_PROD_STATUS END ) ".rtrim()
		+ "\n          	 	END )                                        											   ".rtrim()
		+ "\n            ELSE B.KIOSK_PROD_STATUS                                        							   ".rtrim()
		+ "\n          	 END AS KIOSK_PROD_STATUS                                        							   ".rtrim()
    	+ "\n          , C.SALE_UPRC                       AS SALE_UPRC_ORG                                            ".rtrim()
    	+ "\n          , C.NORMAL_UPRC                       AS NORMAL_UPRC                                            ".rtrim()
    	+ "\n  		    /** 과세 포함.**/                                                                                 ".rtrim()
    	+ "\n  		   , CASE                                                                                          ".rtrim()
		+ "\n  				WHEN '1' = VAT_CD AND TAX_YN = 'Y' THEN CAST ( ROUND( ( C.SALE_UPRC / 1.1 ) )  AS INTEGER) ".rtrim() /** 부가세 포함,과세 품목.**/
		+ "\n  				WHEN '0' = VAT_CD AND TAX_YN = 'Y' THEN C.SALE_UPRC                                        ".rtrim()  /** 부가세 비포함,과세 품목.**/
		+ "\n  				WHEN TAX_YN = 'N'                  THEN C.SALE_UPRC                                        ".rtrim() /** 비과세 품목.**/
		+ "\n  		       ELSE 0                                                                                      ".rtrim()
		+ "\n  		      END AS  \"공급가\"                                                                           ".rtrim()
    	+ "\n          , B.SIDE_MENU_YN                     AS SIDE_MENU_YN /** 사이드메뉴 사용여부       **/          ".rtrim()
    	+ "\n          , B.SDA_CLS_CD                       AS SDA_CLS_CD   /** 사이드메뉴-속성분류코드   **/          ".rtrim()
    	+ "\n          , B.SDS_GRP_CD                       AS SDS_GRP_CD   /** 사이드메뉴-선택그룹코드   **/          ".rtrim()
    	+ "\n          , 1                                  AS ORDER_QTY    /** 주문수량에 사용하기 위함  **/          ".rtrim()
    	+ "\n          , STAMP_ACC_YN                                                                                  ".rtrim()
    	+ "\n          , STAMP_ACC_QTY                                                                                 ".rtrim()
    	+ "\n          , STAMP_USE_YN                                                                                  ".rtrim()
    	+ "\n          , STAMP_USE_QTY                                                                                 ".rtrim()
    	+ "\n          , VAT_CD                                                                                        ".rtrim()
    	+ "\n          , CORNER_CD                                                                                     ".rtrim()
    	+ "\n          , TU_PROD_SEQ                                                                                   ".rtrim()
    	+ "\n          , '' AS DC_AMT                                                                                  ".rtrim()
    	+ "\n          , B.DESCRIPTION_DISP_YN                                                                         ".rtrim()
    	+ "\n          , B.DESCRIPTION                                                                                 ".rtrim()
    	+ "\n          , B.DESCRIPTION_EN                                                                              ".rtrim()
    	+ "\n          , C.TOGO_PROD_YN                                                                                ".rtrim()
    	+ "\n          , C.TOGO_CHARGE                                                                                 ".rtrim()
    	+ "\n          , B.LCLS_CD                                                                              	   ".rtrim()
		+ "\n          , B.MCLS_CD                                                                              	   ".rtrim()
		+ "\n          , B.SCLS_CD                                                                              	   ".rtrim()
		+ "\n          , B.PRICE_MGR_FG                                                                                ".rtrim()
		+ "\n          , PRT_NO                                                                              		   ".rtrim()
		+ "\n          , IFNULL(E.BAR_CD ,'')              AS BAR_CD                                                   ".rtrim()
		+ "\n          , B.CST_ACCDC_YN                                                   							   ".rtrim()
		+ "\n          , B.CUP_DEPOSIT_FG                                                   							   ".rtrim()
		+ "\n          , B.CUP_FG                                                   							   ".rtrim()
    	+ "\n       FROM SCD_KTKEY_T A   /** KIOSK 터치상품          **/                                                      ".rtrim()
    	+ "\n          , SCD_PRODM_T B   /** 상품마스터              **/                                                         ".rtrim()
    	+ "\n    	  , (                                                                                              ".rtrim()
    	+ "\n    		  SELECT                                                                                       ".rtrim()
    	+ "\n    		      A.PROD_CD                                                                                ".rtrim()
    	+ "\n    		    , A.S_DATE                                                                                 	".rtrim()
    	+ "\n    		    , A.E_DATE                                                                                 	".rtrim()
    	+ "\n    		    , CASE WHEN ? = 'T' THEN B.SALE_UPRC ELSE                   								".rtrim()
    	+ "\n    		     	(CASE WHEN (B.SALE_UPRC + B.TOGO_CHARGE) < 0 THEN 0 ELSE B.SALE_UPRC + B.TOGO_CHARGE END)  ".rtrim()
    	+ "\n    		      END AS SALE_UPRC                                                                         	".rtrim()
    	+ "\n    		    , B.TOGO_PROD_YN                                                                           	".rtrim()
    	+ "\n    		    , B.TOGO_CHARGE	                                                                           	".rtrim()
    	+ "\n    		    , A.NORMAL_UPRC	                                                                           	".rtrim()
    	+ "\n    		  FROM SCD_PRCDT_T  A                                                                          	".rtrim()
    	+ "\n    		    , (                                                                                        	".rtrim()
    	+ "\n    		  	SELECT                                                                                     	".rtrim()
    	+ "\n    		  	  A.PROD_CD, MAX(S_DATE) S_DATE, E_DATE, MAX(S_TIME), E_TIME, MAX(PRC_MG_CD), B.TOGO_PROD_YN, B.TOGO_CHARGE ".rtrim()
		+ "\n    		  	  , SALE_UPRC, NORMAL_UPRC             															   ".rtrim()
    	+ "\n    		  	FROM SCD_PRCDT_T A, SCD_PRODM_T B, SCD_KTKEY_T C                                                   ".rtrim()
    	+ "\n    		  	WHERE A.PROD_CD = B.PROD_CD                                                                        ".rtrim() 
    	+ "\n    		  	AND A.PROD_CD = C.PROD_CD                                                                          ".rtrim() 
    	+ "\n    		  	AND A.SHOP_CD = B.SHOP_CD                                                                          ".rtrim() 
    	+ "\n    		  	AND A.SHOP_CD = C.SHOP_CD                                                                          ".rtrim() 
    	+ "\n    		  	AND A.SHOP_CD = ?                                                                          ".rtrim() //shop_cd
    	+ "\n    		  	AND (CASE WHEN '0' = ? THEN A.PRC_MG_NM != '정기구독' ELSE A.PRC_MG_NM = '정기구독' END)        ".rtrim()
    	+ "\n    		  	AND (CASE WHEN '0' = ? THEN A.PRC_MG_NM != '특정시간판매' ELSE A.PRC_MG_NM = '특정시간판매' END)   ".rtrim()
    	+ "\n    		  	AND S_DATE  <= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
    	+ "\n    		  	AND E_DATE  >= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
    	+ "\n    		  	AND strftime('%H%M' , 'NOW' , 'localtime')                                     	   		   ".rtrim()
		+ "\n    		  		BETWEEN strftime('%H%M', substr(IFNULL(CASE WHEN S_TIME == '' THEN NULL ELSE S_TIME END, '0000'), 1, 2)||	".rtrim()
		+ "\n    		  			':'||substr(IFNULL(CASE WHEN S_TIME == '' THEN NULL ELSE S_TIME END, '0000'), 3, 4))                 	".rtrim()
		+ "\n    		  		AND strftime('%H%M', substr(IFNULL(CASE WHEN E_TIME == '' THEN NULL ELSE E_TIME END, '2359'), 1, 2)||		".rtrim()
		+ "\n    		  			':'||substr(IFNULL(CASE WHEN E_TIME == '' THEN NULL ELSE E_TIME END, '2359'), 3, 4))	".rtrim()
    	+ "\n    		  	GROUP BY A.PROD_CD                                                                          	".rtrim()
    	+ "\n    		    ) B                                                                                        ".rtrim()
    	+ "\n    		  WHERE A.SHOP_CD = ?                                                                          ".rtrim() //shop_cd
    	+ "\n    		    AND A.S_DATE  <= strftime('%Y%m%d' , 'NOW' , 'localtime')                                  ".rtrim()
    	+ "\n    		    AND A.E_DATE  >= strftime('%Y%m%d' , 'NOW' , 'localtime')                                  ".rtrim()
    	+ "\n    		    AND A.PROD_CD = B.PROD_CD                                                                  ".rtrim()
    	+ "\n    		    AND A.S_DATE  = B.S_DATE                                                                   ".rtrim()
    	+ "\n    		    AND (B.TOGO_PROD_YN != ? or B.TOGO_PROD_YN IS NULL or B.TOGO_PROD_YN = 'Y' or B.TOGO_PROD_YN = '') ".rtrim()
    	+ "\n    	   ) C                                                                                             ".rtrim()
    	+ "\n  	   , (SELECT  ? AS VAT_CD ) D /** VAT 포함 여부 코드 **/                                               ".rtrim() //VAT CD (CODE 128)  1 : 과세 포함, 0 : 과세 불포함.(부과세 별도)
    	+ "\n  	   LEFT OUTER JOIN SCD_BARCD_T E ON B.SHOP_CD = E.SHOP_CD AND B.PROD_CD = E.PROD_CD                    ".rtrim() 
		+ "\n  	   LEFT OUTER JOIN ( SELECT PROD_CD, GROUP_CONCAT(PRT_NO) PRT_NO FROM SCD_PRTPR_T 					   ".rtrim() 
		+ "\n  	   	WHERE SHOP_CD = ? AND USE_YN  = 'Y' GROUP BY SHOP_CD , PROD_CD)  F ON B.PROD_CD = F.PROD_CD        ".rtrim()
    	+ "\n     WHERE B.SHOP_CD       = A.SHOP_CD                                                                    ".rtrim()
    	+ "\n       AND B.PROD_CD       = A.PROD_CD                                                                    ".rtrim()
    	+ "\n       AND A.SHOP_CD       = ?                                                                            ".rtrim() //shop_cd
    	+ "\n       AND A.TU_CLS_CD     = IFNULL ( ? , A.TU_CLS_CD )                                                   ".rtrim() //clscd-> 터치분류CD
    	+ "\n       AND B.PRICE_MGR_FG  != '1'                                                                         ".rtrim()
    	+ "\n       AND B.USE_YN        = 'Y'                                                                          ".rtrim()
    	+ "\n       AND B.KIOSK_PROD_YN = 'Y'  /** KIOSK 상품 여부 **/                                                 ".rtrim()
    	+ "\n       AND B.SALE_PROD_YN  = 'Y'                                                                          ".rtrim()
    	+ "\n       AND A.PROD_CD       = C.PROD_CD                                                                    ".rtrim()
    	+ "\n       AND (CASE WHEN ? = 'ALL' THEN 1=1 ELSE B.CORNER_CD = ? END)                                        ".rtrim()
    	+ "\n  )                                                                                                       ".rtrim()
    	+ "\n )   A ,                                                                                                  ".rtrim()
    	+ "\n  (                                                                                                       ".rtrim()
    	+ "\n   SELECT CORNER_CD                                                                                       ".rtrim()
    	+ "\n        , CORNER_NM                                                                                       ".rtrim()
    	+ "\n        , OWNER_NM                                                                                        ".rtrim()
    	+ "\n        , BIZ_NO                                                                                          ".rtrim()
    	+ "\n        , CASE                                                                                            ".rtrim()
    	+ "\n 	       WHEN CORNER_CD = '00' THEN                                                                      ".rtrim()
    	+ "\n 	          (SELECT VAN_TERM_NO                                                                          ".rtrim()
    	+ "\n 	             FROM SCD_POSMS_T                                                                          ".rtrim()
    	+ "\n 	            WHERE SHOP_CD = ?                                                                          ".rtrim()
    	+ "\n                   AND POS_NO = ? )                                                                       ".rtrim()
    	+ "\n            ELSE VAN_TERM_NO                                                                              ".rtrim()
    	+ "\n 	     END AS VAN_TERM_NO                                                                                ".rtrim()
    	+ "\n    FROM SCD_SHOPS_T                                                                                      ".rtrim()
    	+ "\n   WHERE SHOP_CD = ?                                                                                      ".rtrim()
    	+ "\n AND   USE_YN  = 'Y'                                                                                      ".rtrim()
    	+ "\n  ) B                                                                                                     ".rtrim()
    	+ "\n WHERE A.CORNER_CD = B.CORNER_CD                                                                          ".rtrim()
    	+ "\n ORDER BY TU_CLS_CD , TU_PROD_SEQ                                                                         ".rtrim()
    	;
    
    this.menuProdProducdToGoForBarcodeData_SQL = ""
    	+ "\n  SELECT                                                                                                  ".rtrim()
    	+ "\n         CASE                                                                                             ".rtrim()
    	+ "\n              WHEN  '1' = VAT_CD  AND TAX_YN = 'Y' THEN SALE_UPRC_ORG                                     ".rtrim()
    	+ "\n              WHEN  '0' = VAT_CD  AND TAX_YN = 'Y' THEN 공급가 + VAT                                      ".rtrim()
    	+ "\n              ELSE 공급가                                                                                 ".rtrim()
    	+ "\n          END AS SALE_UPRC                                                                                ".rtrim()
    	+ "\n       , A.*                                                                                              ".rtrim()
    	+ "\n       , VAN_TERM_NO                                                                                      ".rtrim()
    	+ "\n    FROM (                                                                                                ".rtrim()
    	+ "\n  SELECT                                                                                                  ".rtrim()
    	+ "\n  	CASE                                                                                                   ".rtrim()
    	+ "\n  		WHEN '1' = VAT_CD AND TAX_YN = 'Y' THEN SALE_UPRC_ORG - 공급가                                     ".rtrim() /** 과세 품목. TAX 포함  **/
		+ "\n  		WHEN '0' = VAT_CD AND TAX_YN = 'Y' THEN CAST ( ROUND( (   공급가 * 0.1 ) )    AS INTEGER)          ".rtrim() /** 과세 품목. 미포함  **/
		+ "\n  		WHEN TAX_YN = 'N'                  THEN 0/** 비과세 품목.**/                                       ".rtrim()
		+ "\n  		ELSE 0                                                                                             ".rtrim()
    	+ "\n  	 END  VAT                                                                                              ".rtrim()
    	+ "\n  	,  *                                                                                                   ".rtrim()
    	+ "\n   FROM (                                                                                                 ".rtrim()
    	+ "\n    SELECT  DISTINCT                                                                                      ".rtrim()
    	+ "\n          B.PROD_CD                         AS PROD_CD                                                  ".rtrim()
    	+ "\n          , B.PROD_NM                         AS PROD_NM                                                  ".rtrim()
    	+ "\n          , B.TAX_YN                          AS TAX_YN                                                   ".rtrim()
    	+ "\n          , IFNULL( B.PROD_NM_EN , B.PROD_NM) AS PROD_NM_EN                                               ".rtrim()
    	+ "\n          , B.IMG_URL                         AS IMG_URL                                                  ".rtrim()
    	+ "\n          , B.IMG_DOWNLOAD_FG                 AS IMG_DOWNLOAD_FG                                          ".rtrim()
    	//+ "\n          , B.KIOSK_PROD_STATUS               AS KIOSK_PROD_STATUS                                        ".rtrim()
    	+ "\n          , CASE WHEN (B.KIOSK_PROD_STATUS_RBT IS NOT NULL OR B.KIOSK_PROD_STATUS_RBT != '')              ".rtrim()
		+ "\n          		THEN (                                        											   ".rtrim()
		+ "\n          			CASE WHEN B.KIOSK_PROD_STATUS = '4' THEN B.KIOSK_PROD_STATUS                           ".rtrim()
		+ "\n          	 	ELSE ( CASE WHEN B.KIOSK_PROD_STATUS_RBT = '4' THEN B.KIOSK_PROD_STATUS_RBT ELSE B.KIOSK_PROD_STATUS END ) ".rtrim()
		+ "\n          	 	END )                                        											   ".rtrim()
		+ "\n            ELSE B.KIOSK_PROD_STATUS                                        							   ".rtrim()
		+ "\n          	 END AS KIOSK_PROD_STATUS                                        							   ".rtrim()
    	+ "\n          , C.SALE_UPRC                       AS SALE_UPRC_ORG                                            ".rtrim()
    	+ "\n          , C.NORMAL_UPRC                     AS NORMAL_UPRC                                            ".rtrim()
    	+ "\n  		    /** 과세 포함.**/                                                                                 ".rtrim()
    	+ "\n  		   , CASE                                                                                          ".rtrim()
    	+ "\n  				WHEN '1' = VAT_CD AND TAX_YN = 'Y' THEN CAST ( ROUND( ( C.SALE_UPRC / 1.1 ) )  AS INTEGER) ".rtrim() /** 부가세 포함,과세 품목.**/
		+ "\n  				WHEN '0' = VAT_CD AND TAX_YN = 'Y' THEN C.SALE_UPRC                                        ".rtrim()  /** 부가세 비포함,과세 품목.**/
		+ "\n  				WHEN TAX_YN = 'N'                  THEN C.SALE_UPRC                                        ".rtrim() /** 비과세 품목.**/
		+ "\n  		       ELSE 0                                                                                      ".rtrim()
		+ "\n  		      END AS  \"공급가\"                                                                           ".rtrim()    	+ "\n          , B.SIDE_MENU_YN                     AS SIDE_MENU_YN /** 사이드메뉴 사용여부       **/          ".rtrim()
    	+ "\n          , B.SDA_CLS_CD                       AS SDA_CLS_CD   /** 사이드메뉴-속성분류코드   **/          ".rtrim()
    	+ "\n          , B.SDS_GRP_CD                       AS SDS_GRP_CD   /** 사이드메뉴-선택그룹코드   **/          ".rtrim()
    	+ "\n          , 1                                  AS ORDER_QTY    /** 주문수량에 사용하기 위함  **/          ".rtrim()
    	+ "\n          , STAMP_ACC_YN                                                                                  ".rtrim()
    	+ "\n          , STAMP_ACC_QTY                                                                                 ".rtrim()
    	+ "\n          , STAMP_USE_YN                                                                                  ".rtrim()
    	+ "\n          , STAMP_USE_QTY                                                                                 ".rtrim()
    	+ "\n          , VAT_CD                                                                                        ".rtrim()
    	+ "\n          , CORNER_CD                                                                                     ".rtrim()
    	+ "\n          , '' AS DC_AMT                                                                                  ".rtrim()
    	+ "\n          , B.DESCRIPTION_DISP_YN                                                                         ".rtrim()
    	+ "\n          , B.DESCRIPTION                                                                                 ".rtrim()
    	+ "\n          , B.DESCRIPTION_EN                                                                              ".rtrim()
    	+ "\n          , C.TOGO_PROD_YN                                                                                ".rtrim()
    	+ "\n          , C.TOGO_CHARGE                                                                                 ".rtrim()
    	+ "\n          , B.LCLS_CD                                                                              	   ".rtrim()
		+ "\n          , B.MCLS_CD                                                                              	   ".rtrim()
		+ "\n          , B.SCLS_CD                                                                              	   ".rtrim()
		+ "\n          , B.PRICE_MGR_FG                                                                                ".rtrim()
		+ "\n          , PRT_NO                                                                              		   ".rtrim()
		+ "\n          , IFNULL(E.BAR_CD ,'')              AS BAR_CD                                                   ".rtrim()
		+ "\n          , B.CST_ACCDC_YN                                                   							   ".rtrim()
		+ "\n          , B.CUP_DEPOSIT_FG                                                   							   ".rtrim()
		+ "\n          , B.CUP_FG                                                   							   ".rtrim()
    	+ "\n       FROM SCD_PRODM_T B   /** 상품마스터              **/                                                         ".rtrim()
    	+ "\n    	  , (                                                                                              ".rtrim()
    	+ "\n    		  SELECT                                                                                       ".rtrim()
    	+ "\n    		      A.PROD_CD                                                                                ".rtrim()
    	+ "\n    		    , A.S_DATE                                                                                 ".rtrim()
    	+ "\n    		    , A.E_DATE                                                                                 ".rtrim()
    	+ "\n    		    , CASE WHEN ? = 'T' THEN B.SALE_UPRC ELSE                   								".rtrim()
    	+ "\n    		     	(CASE WHEN (B.SALE_UPRC + B.TOGO_CHARGE) < 0 THEN 0 ELSE B.SALE_UPRC + B.TOGO_CHARGE END)  ".rtrim()
    	+ "\n    		      END AS SALE_UPRC                                                                         ".rtrim()
    	+ "\n    		    , B.TOGO_PROD_YN                                                                           ".rtrim()
    	+ "\n    		    , B.TOGO_CHARGE	                                                                           ".rtrim()
    	+ "\n    		    , B.NORMAL_UPRC	                                                                           ".rtrim()
    	+ "\n    		  FROM SCD_PRCDT_T  A                                                                          ".rtrim()
    	+ "\n    		    , (                                                                                        ".rtrim()
    	+ "\n    		  	SELECT                                                                                     ".rtrim()
    	+ "\n    		  	  A.PROD_CD, MAX(S_DATE) S_DATE, E_DATE, MAX(S_TIME), E_TIME, MAX(PRC_MG_CD), B.TOGO_PROD_YN, B.TOGO_CHARGE ".rtrim()
    	+ "\n    		  	  , SALE_UPRC, NORMAL_UPRC                       						   							   ".rtrim()
    	+ "\n    		  	FROM SCD_PRCDT_T A, SCD_PRODM_T B                                                          ".rtrim()
    	+ "\n    		  	WHERE A.PROD_CD = B.PROD_CD                                                                ".rtrim() //shop_cd
    	+ "\n    		  	AND A.SHOP_CD = B.SHOP_CD                                                                  ".rtrim() //shop_cd
    	+ "\n    		  	AND A.SHOP_CD = ?                                                                          ".rtrim() //shop_cd
    	+ "\n    		  	AND (CASE WHEN '0' = ? THEN A.PRC_MG_NM != '정기구독' ELSE A.PRC_MG_NM = '정기구독' END)        ".rtrim()
    	+ "\n    		  	AND (CASE WHEN '0' = ? THEN A.PRC_MG_NM != '특정시간판매' ELSE A.PRC_MG_NM = '특정시간판매' END)   ".rtrim()
    	+ "\n    		  	AND S_DATE  <= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
    	+ "\n    		  	AND E_DATE  >= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
    	+ "\n    		  	AND strftime('%H%M' , 'NOW' , 'localtime')                                     	   		   ".rtrim()
		+ "\n    		  		BETWEEN strftime('%H%M', substr(IFNULL(CASE WHEN S_TIME == '' THEN NULL ELSE S_TIME END, '0000'), 1, 2)||	".rtrim()
		+ "\n    		  			':'||substr(IFNULL(CASE WHEN S_TIME == '' THEN NULL ELSE S_TIME END, '0000'), 3, 4))                 	".rtrim()
		+ "\n    		  		AND strftime('%H%M', substr(IFNULL(CASE WHEN E_TIME == '' THEN NULL ELSE E_TIME END, '2359'), 1, 2)||		".rtrim()
		+ "\n    		  			':'||substr(IFNULL(CASE WHEN E_TIME == '' THEN NULL ELSE E_TIME END, '2359'), 3, 4))	".rtrim()
    	+ "\n    		  	GROUP BY A.PROD_CD                                                                         ".rtrim()
    	+ "\n    		    ) B                                                                                        ".rtrim()
    	+ "\n    		  WHERE A.SHOP_CD = ?                                                                          ".rtrim() //shop_cd
    	+ "\n    		    AND A.S_DATE  <= strftime('%Y%m%d' , 'NOW' , 'localtime')                                  ".rtrim()
    	+ "\n    		    AND A.E_DATE  >= strftime('%Y%m%d' , 'NOW' , 'localtime')                                  ".rtrim()
    	+ "\n    		    AND A.PROD_CD = B.PROD_CD                                                                  ".rtrim()
    	+ "\n    		    AND A.S_DATE  = B.S_DATE                                                                   ".rtrim()
    	+ "\n    		    AND (B.TOGO_PROD_YN != ? or B.TOGO_PROD_YN IS NULL or B.TOGO_PROD_YN = 'Y' or B.TOGO_PROD_YN = '') ".rtrim()
    	+ "\n    	   ) C                                                                                             ".rtrim()
    	+ "\n  	   , (SELECT  ? AS VAT_CD ) D /** VAT 포함 여부 코드 **/                                               	   ".rtrim() //VAT CD (CODE 128)  1 : 과세 포함, 0 : 과세 불포함.(부과세 별도)
    	+ "\n  	   LEFT OUTER JOIN SCD_BARCD_T E ON B.SHOP_CD = E.SHOP_CD AND B.PROD_CD = E.PROD_CD                    ".rtrim() 
		+ "\n  	   LEFT OUTER JOIN ( SELECT PROD_CD, GROUP_CONCAT(PRT_NO) PRT_NO FROM SCD_PRTPR_T 					   ".rtrim() 
		+ "\n  	   	WHERE SHOP_CD = ? AND USE_YN  = 'Y' GROUP BY SHOP_CD , PROD_CD)  F ON B.PROD_CD = F.PROD_CD        ".rtrim()
    	+ "\n     WHERE B.PROD_CD       = C.PROD_CD                                                                    ".rtrim()
    	+ "\n       AND B.SHOP_CD       = ?                                                                            ".rtrim() //shop_cd
    	+ "\n       AND B.PRICE_MGR_FG  != '1'                                                                         ".rtrim()
    	+ "\n       AND B.USE_YN        = 'Y'                                                                          ".rtrim()
    	+ "\n       AND B.KIOSK_PROD_YN = 'Y'  /** KIOSK 상품 여부 **/                                                 	   ".rtrim()
    	+ "\n       AND B.SALE_PROD_YN  = 'Y'                                                                          ".rtrim()
    	+ "\n       AND (CASE WHEN ? = 'ALL' THEN 1=1 ELSE B.CORNER_CD = ? END)                                        ".rtrim()
    	+ "\n  )                                                                                                       ".rtrim()
    	+ "\n )   A ,                                                                                                  ".rtrim()
    	+ "\n  (                                                                                                       ".rtrim()
    	+ "\n   SELECT CORNER_CD                                                                                       ".rtrim()
    	+ "\n        , CORNER_NM                                                                                       ".rtrim()
    	+ "\n        , OWNER_NM                                                                                        ".rtrim()
    	+ "\n        , BIZ_NO                                                                                          ".rtrim()
    	+ "\n        , CASE                                                                                            ".rtrim()
    	+ "\n 	       WHEN CORNER_CD = '00' THEN                                                                      ".rtrim()
    	+ "\n 	          (SELECT VAN_TERM_NO                                                                          ".rtrim()
    	+ "\n 	             FROM SCD_POSMS_T                                                                          ".rtrim()
    	+ "\n 	            WHERE SHOP_CD = ?                                                                          ".rtrim()
    	+ "\n                   AND POS_NO = ? )                                                                       ".rtrim()
    	+ "\n            ELSE VAN_TERM_NO                                                                              ".rtrim()
    	+ "\n 	     END AS VAN_TERM_NO                                                                                ".rtrim()
    	+ "\n    FROM SCD_SHOPS_T                                                                                      ".rtrim()
    	+ "\n   WHERE SHOP_CD = ?                                                                                      ".rtrim()
    	+ "\n AND   USE_YN  = 'Y'                                                                                      ".rtrim()
    	+ "\n  ) B                                                                                                     ".rtrim()
    	+ "\n WHERE A.CORNER_CD = B.CORNER_CD                                                                          ".rtrim()
    	+ "\n ORDER BY PROD_CD                                                                        				   ".rtrim()
    	;
    
    this.menuProdProducdForBarcodeData_SQL = ""
    	+ "\n  SELECT                                                                                                  ".rtrim()
    	+ "\n         CASE                                                                                             ".rtrim()
    	+ "\n              WHEN  '1' = VAT_CD  AND TAX_YN = 'Y' THEN SALE_UPRC_ORG                                     ".rtrim()
    	+ "\n              WHEN  '0' = VAT_CD  AND TAX_YN = 'Y' THEN 공급가 + VAT                                      ".rtrim()
    	+ "\n              ELSE 공급가                                                                                 ".rtrim()
    	+ "\n          END AS SALE_UPRC                                                                                ".rtrim()
    	+ "\n       , A.*                                                                                              ".rtrim()
    	+ "\n       , VAN_TERM_NO                                                                                      ".rtrim()
    	+ "\n    FROM (                                                                                                ".rtrim()
		+ "\n  SELECT                                                                                                  ".rtrim()
		+ "\n  	CASE                                                                                                   ".rtrim()
		+ "\n  		WHEN '1' = VAT_CD AND TAX_YN = 'Y' THEN SALE_UPRC_ORG - 공급가                                     ".rtrim() /** 과세 품목. TAX 포함  **/
		+ "\n  		WHEN '0' = VAT_CD AND TAX_YN = 'Y' THEN CAST ( ROUND( (   공급가 * 0.1 ) )    AS INTEGER)          ".rtrim() /** 과세 품목. 미포함  **/
		+ "\n  		WHEN TAX_YN = 'N'                  THEN 0/** 비과세 품목.**/                                       ".rtrim()
		+ "\n  		ELSE 0                                                                                             ".rtrim()
		+ "\n  	 END  VAT                                                                                              ".rtrim()
		+ "\n  	,  *                                                                                                   ".rtrim()
		+ "\n   FROM (                                                                                                 ".rtrim()
		+ "\n    SELECT  DISTINCT                                                                                      ".rtrim()
		+ "\n            B.PROD_CD                         AS PROD_CD                                                  ".rtrim()
		+ "\n          , B.PROD_NM                         AS PROD_NM                                                  ".rtrim()
		+ "\n          , B.TAX_YN                          AS TAX_YN                                                   ".rtrim()
		+ "\n          , IFNULL( B.PROD_NM_EN , B.PROD_NM) AS PROD_NM_EN                                               ".rtrim()
		+ "\n          , B.IMG_URL                         AS IMG_URL                                                  ".rtrim()
		+ "\n          , B.IMG_DOWNLOAD_FG                 AS IMG_DOWNLOAD_FG                                          ".rtrim()
		//+ "\n          , B.KIOSK_PROD_STATUS               AS KIOSK_PROD_STATUS                                        ".rtrim()
		+ "\n          , CASE WHEN (B.KIOSK_PROD_STATUS_RBT IS NOT NULL OR B.KIOSK_PROD_STATUS_RBT != '')              ".rtrim()
		+ "\n          		THEN (                                        											   ".rtrim()
		+ "\n          			CASE WHEN B.KIOSK_PROD_STATUS = '4' THEN B.KIOSK_PROD_STATUS                           ".rtrim()
		+ "\n          	 	ELSE ( CASE WHEN B.KIOSK_PROD_STATUS_RBT = '4' THEN B.KIOSK_PROD_STATUS_RBT ELSE B.KIOSK_PROD_STATUS END ) ".rtrim()
		+ "\n          	 	END )                                        											   ".rtrim()
		+ "\n            ELSE B.KIOSK_PROD_STATUS                                        							   ".rtrim()
		+ "\n          	 END AS KIOSK_PROD_STATUS                                        							   ".rtrim()
		+ "\n          , C.SALE_UPRC                       AS SALE_UPRC_ORG                                            ".rtrim()
		+ "\n          , C.NORMAL_UPRC                     AS NORMAL_UPRC                                            ".rtrim()
		+ "\n  		    /** 과세 포함.**/                                                                              ".rtrim()
		+ "\n  		   , CASE                                                                                          ".rtrim()
		+ "\n  				WHEN '1' = VAT_CD AND TAX_YN = 'Y' THEN CAST ( ROUND( ( C.SALE_UPRC / 1.1 ) )  AS INTEGER) ".rtrim() /** 부가세 포함,과세 품목.**/
		+ "\n  				WHEN '0' = VAT_CD AND TAX_YN = 'Y' THEN C.SALE_UPRC                                        ".rtrim()  /** 부가세 비포함,과세 품목.**/
		+ "\n  				WHEN TAX_YN = 'N'                  THEN C.SALE_UPRC                                        ".rtrim() /** 비과세 품목.**/
		+ "\n  		       ELSE 0                                                                                      ".rtrim()
		+ "\n  		      END AS  \"공급가\"                                                                           ".rtrim()
		+ "\n          , B.SIDE_MENU_YN                     AS SIDE_MENU_YN /** 사이드메뉴 사용여부       **/          ".rtrim()
		+ "\n          , B.SDA_CLS_CD                       AS SDA_CLS_CD   /** 사이드메뉴-속성분류코드   **/          ".rtrim()
		+ "\n          , B.SDS_GRP_CD                       AS SDS_GRP_CD   /** 사이드메뉴-선택그룹코드   **/          ".rtrim()
		+ "\n          , 1                                  AS ORDER_QTY    /** 주문수량에 사용하기 위함  **/          ".rtrim()
		+ "\n          , STAMP_ACC_YN                                                                                  ".rtrim()
		+ "\n          , STAMP_ACC_QTY                                                                                  ".rtrim()
		+ "\n          , STAMP_USE_YN                                                                                  ".rtrim()
		+ "\n          , STAMP_USE_QTY                                                                                 ".rtrim()
		+ "\n          , VAT_CD                                                                                        ".rtrim()
		+ "\n          , CORNER_CD                                                                                     ".rtrim()
		+ "\n          , '' AS DC_AMT                                                                                  ".rtrim()
		+ "\n          , B.DESCRIPTION_DISP_YN                                                                         ".rtrim()
		+ "\n          , B.DESCRIPTION                                                                                 ".rtrim()
		+ "\n          , B.DESCRIPTION_EN                                                                              ".rtrim()
		+ "\n          , B.LCLS_CD                                                                              	   ".rtrim()
		+ "\n          , B.MCLS_CD                                                                              	   ".rtrim()
		+ "\n          , B.SCLS_CD                                                                              	   ".rtrim()
		+ "\n          , B.PRICE_MGR_FG                                                                                ".rtrim()
		+ "\n          , PRT_NO                                                                              		   ".rtrim()
		+ "\n          , IFNULL(E.BAR_CD ,'')              AS BAR_CD                                                   ".rtrim()
		+ "\n          , B.CST_ACCDC_YN                                                   							   ".rtrim()
		+ "\n          , B.CUP_DEPOSIT_FG                                                   							   ".rtrim()
		+ "\n          , B.CUP_FG                                                   							   ".rtrim()
		+ "\n       FROM SCD_PRODM_T B   /** 상품마스터              **/                                                        ".rtrim()
		+ "\n    	  , (                                                                                              ".rtrim()
		+ "\n    		  SELECT                                                                                       ".rtrim()
		+ "\n    		      A.PROD_CD                                                                                ".rtrim()
		+ "\n    		    , A.S_DATE                                                                                 ".rtrim()
		+ "\n    		    , A.E_DATE                                                                                 ".rtrim()
		+ "\n    		    , B.SALE_UPRC                                                                              ".rtrim()
		+ "\n    		    , B.NORMAL_UPRC                                                                              ".rtrim()
		+ "\n    		  FROM SCD_PRCDT_T  A                                                                          ".rtrim()
		+ "\n    		    , (                                                                                        ".rtrim()
		+ "\n    		  	SELECT                                                                                     ".rtrim()
		+ "\n    		  	  A.PROD_CD, MAX(S_DATE) S_DATE, MAX(S_TIME), MAX(PRC_MG_CD), SALE_UPRC, NORMAL_UPRC       ".rtrim()
		+ "\n    		  	FROM SCD_PRCDT_T A, SCD_PRODM_T B                                                          ".rtrim()
		+ "\n    		  	WHERE A.SHOP_CD = ?                                                                        ".rtrim() //shop_cd
		+ "\n    		  	AND A.PROD_CD = B.PROD_CD          								                           ".rtrim()
		+ "\n    		  	AND A.SHOP_CD = B.SHOP_CD                                   							   ".rtrim()
		+ "\n    		  	AND (CASE WHEN '0' = ? THEN A.PRC_MG_NM != '정기구독' ELSE A.PRC_MG_NM = '정기구독' END)        ".rtrim()
		+ "\n    		  	AND (CASE WHEN '0' = ? THEN A.PRC_MG_NM != '특정시간판매' ELSE A.PRC_MG_NM = '특정시간판매' END)   ".rtrim()
		+ "\n    		  	AND S_DATE  <= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
		+ "\n    		  	AND E_DATE  >= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
		+ "\n    		  	AND strftime('%H%M' , 'NOW' , 'localtime')                                     	   		   ".rtrim()
		+ "\n    		  		BETWEEN strftime('%H%M', substr(IFNULL(CASE WHEN S_TIME == '' THEN NULL ELSE S_TIME END, '0000'), 1, 2)||	".rtrim()
		+ "\n    		  			':'||substr(IFNULL(CASE WHEN S_TIME == '' THEN NULL ELSE S_TIME END, '0000'), 3, 4))                    ".rtrim()
		+ "\n    		  		AND strftime('%H%M', substr(IFNULL(CASE WHEN E_TIME == '' THEN NULL ELSE E_TIME END, '2359'), 1, 2)||		".rtrim()
		+ "\n    		  			':'||substr(IFNULL(CASE WHEN E_TIME == '' THEN NULL ELSE E_TIME END, '2359'), 3, 4))".rtrim()
		+ "\n    		  	GROUP BY A.PROD_CD                                                                           ".rtrim()
		+ "\n    		    ) B                                                                                        ".rtrim()
		+ "\n    		  WHERE A.SHOP_CD = ?                                                                          ".rtrim() //shop_cd
		+ "\n    		    AND A.S_DATE  <= strftime('%Y%m%d' , 'NOW' , 'localtime')                                  ".rtrim()
		+ "\n    		    AND A.E_DATE  >= strftime('%Y%m%d' , 'NOW' , 'localtime')                                  ".rtrim()
		+ "\n    		    AND A.PROD_CD = B.PROD_CD                                                                  ".rtrim()
		+ "\n    		    AND A.S_DATE  = B.S_DATE                                                                   ".rtrim()
		+ "\n    	   ) C                                                                                             ".rtrim()
		+ "\n  	   , (SELECT  ? AS VAT_CD ) D /** VAT 포함 여부 코드 **/                                               	   ".rtrim() //VAT CD (CODE 128)  1 : 과세 포함, 0 : 과세 불포함.(부과세 별도)
		+ "\n  	   LEFT OUTER JOIN SCD_BARCD_T E ON B.SHOP_CD = E.SHOP_CD AND B.PROD_CD = E.PROD_CD                    ".rtrim() 
		+ "\n  	   LEFT OUTER JOIN ( SELECT PROD_CD, GROUP_CONCAT(PRT_NO) PRT_NO FROM SCD_PRTPR_T 					   ".rtrim() 
		+ "\n  	   	WHERE SHOP_CD = ? AND USE_YN  = 'Y' GROUP BY SHOP_CD , PROD_CD)  F ON B.PROD_CD = F.PROD_CD        ".rtrim() 
		+ "\n     WHERE B.PROD_CD       = C.PROD_CD                                                                    ".rtrim()
		+ "\n       AND B.SHOP_CD       = ?                                                                            ".rtrim() //shop_cd
		//+ "\n       AND A.TU_FG         = 'S'                                                                          ".rtrim()//2020.09.08 최광림 차장 요청( 의미없는 조건)
		+ "\n       AND B.PRICE_MGR_FG  != '1'                                                                         ".rtrim()
		+ "\n       AND B.USE_YN        = 'Y'                                                                          ".rtrim()
		+ "\n       AND B.KIOSK_PROD_YN = 'Y'  /** KIOSK 상품 여부 **/                                                 ".rtrim()
		+ "\n       AND B.SALE_PROD_YN  = 'Y'                                                                          ".rtrim()
		+ "\n       AND (CASE WHEN ? = 'ALL' THEN 1=1 ELSE B.CORNER_CD = ? END)                                        ".rtrim()
		+ "\n  )                                                                                                       ".rtrim()
		+ "\n )   A ,                                                                                                  ".rtrim()
		+ "\n  (                                                                                                       ".rtrim()
		+ "\n   SELECT CORNER_CD                                                                                       ".rtrim()
		+ "\n        , CORNER_NM                                                                                       ".rtrim()
		+ "\n        , OWNER_NM                                                                                        ".rtrim()
		+ "\n        , BIZ_NO                                                                                          ".rtrim()
		+ "\n        , CASE                                                                                            ".rtrim()
		+ "\n 	       WHEN CORNER_CD = '00' THEN                                                                      ".rtrim()
		+ "\n 	          (SELECT VAN_TERM_NO                                                                          ".rtrim()
		+ "\n 	             FROM SCD_POSMS_T                                                                          ".rtrim()
		+ "\n 	            WHERE SHOP_CD = ?                                                                          ".rtrim()
		+ "\n                   AND POS_NO = ? )                                                                       ".rtrim()
		+ "\n            ELSE VAN_TERM_NO                                                                              ".rtrim()
		+ "\n 	     END AS VAN_TERM_NO                                                                                ".rtrim()
		+ "\n    FROM SCD_SHOPS_T                                                                                      ".rtrim()
		+ "\n   WHERE SHOP_CD = ?                                                                                      ".rtrim()
		+ "\n AND   USE_YN  = 'Y'                                                                                      ".rtrim()
		+ "\n  ) B                                                                                                     ".rtrim()
		+ "\n WHERE A.CORNER_CD = B.CORNER_CD                                                                          ".rtrim()
		+ "\n ORDER BY PROD_CD                                                                        				   ".rtrim()
		;
    
    this.menuProdProducdCnt_SQL = ""
		+ "\n SELECT COUNT(*) AS TIME_SALE_CNT				 											 ".rtrim()
    	+ "\n FROM SCD_PRCDT_T A, SCD_PRODM_T B, SCD_KTKEY_T C                                           ".rtrim()
    	+ "\n WHERE A.PROD_CD = B.PROD_CD                                                                ".rtrim() 
    	+ "\n AND A.PROD_CD = C.PROD_CD                                                                  ".rtrim() 
    	+ "\n AND A.SHOP_CD = B.SHOP_CD                                                                  ".rtrim() 
    	+ "\n AND A.SHOP_CD = C.SHOP_CD                                                                  ".rtrim() 
    	+ "\n AND A.SHOP_CD = ?                                                                          ".rtrim() //shop_cd
    	+ "\n AND A.PRC_MG_NM = '특정시간판매' 																 ".rtrim()
    	+ "\n AND S_DATE  <= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
    	+ "\n AND E_DATE  >= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
    	+ "\n AND strftime('%H%M' , 'NOW' , 'localtime')                                     	   		 ".rtrim()
		+ "\n 	BETWEEN strftime('%H%M', substr(IFNULL(CASE WHEN S_TIME == '' THEN NULL ELSE S_TIME END, '0000'), 1, 2)|| ".rtrim()
		+ "\n 		':'||substr(IFNULL(CASE WHEN S_TIME == '' THEN NULL ELSE S_TIME END, '0000'), 3, 4)) ".rtrim()
		+ "\n 	AND strftime('%H%M', substr(IFNULL(CASE WHEN E_TIME == '' THEN NULL ELSE E_TIME END, '2359'), 1, 2)||	".rtrim()
		+ "\n 		':'||substr(IFNULL(CASE WHEN E_TIME == '' THEN NULL ELSE E_TIME END, '2359'), 3, 4)) ".rtrim()
    	+ "\n GROUP BY A.PROD_CD                                                                      	 ".rtrim()
		;
    
    this.getKioskClsData_SQL = ""
		+ "\n SELECT TU_FG                                           ".rtrim()
		+ "\n      , TU_CLS_CD                                       ".rtrim()
		+ "\n      , TU_CLS_NM                                       ".rtrim()
		+ "\n      , IFNULL(TU_CLS_NM_EN , TU_CLS_NM) TU_CLS_NM_EN   ".rtrim()
		+ "\n      , TU_CLS_SEQ                                      ".rtrim()
		+ "\n      , (CASE WHEN 'BEST' = upper(TU_CLS_NM_EN) THEN 'Y' ELSE 'N' END) AS BEST_PROD_YN ".rtrim()
		+ "\n      , (CASE WHEN 'SUGGEST' = upper(TU_CLS_NM_EN) THEN 'Y' ELSE 'N' END) AS REC_PROD_YN ".rtrim()
		+ "\n  		, IFNULL(TU_CLS_DISP_FG, 'Y') AS TU_CLS_DISP_FG ".rtrim()
		+ "\n   	, IFNULL(TU_CLS_PROC_FG, '1') AS TU_CLS_PROC_FG ".rtrim()
	  	+ "\n   	, RECUR_S_DATE  								".rtrim()
	  	+ "\n   	, RECUR_E_DATE  								".rtrim()
	  	+ "\n   	, RECUR_TERM  									".rtrim()
	  	+ "\n   	, RECUR_S_TIME  								".rtrim()
	  	+ "\n   	, RECUR_E_TIME  								".rtrim()
		+ "\n   FROM SCD_KTCLS_T                                     ".rtrim()
		+ "\n  WHERE SHOP_CD = ?	                                 ".rtrim()
//		+ "\n    AND TU_FG   = 'S'  /** 주문 **/                     ".rtrim()//2020.09.08 최광림 차장 요청( 의미없는 조건)
		+ "\n  ORDER BY TU_CLS_SEQ                                   ".rtrim()
		;
    this.getKioskClsDataForCornerPay_SQL = ""
    	+ "\n SELECT TU_FG                                           ".rtrim()
    	+ "\n      , TU_CLS_CD                                       ".rtrim()
    	+ "\n      , TU_CLS_NM                                       ".rtrim()
    	+ "\n      , IFNULL(TU_CLS_NM_EN , TU_CLS_NM) TU_CLS_NM_EN   ".rtrim()
    	+ "\n      , TU_CLS_SEQ                                      ".rtrim()
    	+ "\n      , (CASE WHEN 'BEST' = upper(TU_CLS_NM_EN) THEN 'Y' ELSE 'N' END) AS BEST_PROD_YN ".rtrim()
    	+ "\n      , (CASE WHEN 'SUGGEST' = upper(TU_CLS_NM_EN) THEN 'Y' ELSE 'N' END) AS REC_PROD_YN ".rtrim()
		+ "\n  		, IFNULL(TU_CLS_DISP_FG, 'Y') AS TU_CLS_DISP_FG ".rtrim()
		+ "\n   	, IFNULL(TU_CLS_PROC_FG, '1') AS TU_CLS_PROC_FG ".rtrim()
	  	+ "\n   	, RECUR_S_DATE  								".rtrim()
	  	+ "\n   	, RECUR_E_DATE  								".rtrim()
	  	+ "\n   	, RECUR_TERM  									".rtrim()
	  	+ "\n   	, RECUR_S_TIME  								".rtrim()
	  	+ "\n   	, RECUR_E_TIME  								".rtrim()
    	+ "\n   FROM SCD_KTCLS_T                                     ".rtrim()
    	+ "\n  WHERE SHOP_CD = '%s'	                                 ".rtrim()
		+ "\n  AND TU_CLS_CD IN ('%s')                     			 ".rtrim()//2020.09.08 최광림 차장 요청( 의미없는 조건)
    	+ "\n  ORDER BY TU_CLS_SEQ                                   ".rtrim()
    	;
    this.ComCodeSelect_SQL = "" /** 공통코드 조회.**/
    	+"\n SELECT                                  ".rtrim()
    	+"\n        COM_CD                           ".rtrim()
    	+"\n      , COM_CD_ITEM_01                   ".rtrim()
    	+"\n      , COM_CD_ITEM_02                   ".rtrim()
    	+"\n   FROM CCD_CODEM_T                      ".rtrim()
    	+"\n  WHERE COM_CD_FG = ?                    ".rtrim()
    	+"\n    AND LENGTH (COM_CD_ITEM_01) != 0     ".rtrim()
    	;
    this.GetCatIdSingleBiz_SQL = ""
    	+"\n SELECT                             ".rtrim()
    	+"\n      A.VAN_TERM_NO AS VAN_TERM_NO  ".rtrim()
    	+"\n FROM SCD_POSMS_T A                 ".rtrim()
    	+"\n    , SCD_SHOPS_T B                 ".rtrim()
    	+"\n WHERE A.SHOP_CD   = '%s'           ".rtrim()
    	+"\n AND   A.POS_NO    = '%s'           ".rtrim()
    	+"\n AND   A.USE_YN    = 'Y'            ".rtrim()
    	+"\n AND   B.SHOP_CD   = A.SHOP_CD      ".rtrim()
    	+"\n AND   B.CORNER_CD = '00'           ".rtrim()
    ;
    this.GetEnvshSetVal_SQL = ""
    	+"\n SELECT                             ".rtrim()
    	+"\n      *  							".rtrim()
    	+"\n FROM SCD_ENVSH_T A                 ".rtrim()
    	+"\n WHERE A.SHOP_CD    = '%s'          ".rtrim()
    	+"\n AND   A.ENV_SET_CD = '%s'          ".rtrim()
    	;
    this.shopOpenInfo_SQL = ""
		+ "\n     SELECT REGI_SEQ             ".rtrim()
		+ "\n          , CLOSE_FG             ".rtrim()
		+ "\n       FROM POS_REGIS_T          ".rtrim()
		+ "\n      WHERE SHOP_CD     = ?      ".rtrim()//SHOP NO
		+ "\n        AND SALE_DATE   = ?      ".rtrim()//영업일
		+ "\n        AND POS_NO      = ?      ".rtrim()//현재 POS NO
		+ "\n        AND REGI_SEQ <> '00'     ".rtrim()
		+ "\n      ORDER BY SALE_DATE DESC    ".rtrim()
		+ "\n            , REGI_SEQ DESC      ".rtrim()
		+ "\n    LIMIT 1                      ".rtrim()
		;
    
    this.selectRobotIpPort =  "SELECT  COM_CD_ITEM_01 AS IP, COM_CD_ITEM_02 AS PORT FROM SCD_CODEM_T "
        + " WHERE SHOP_CD = ? "
            + " AND COM_CD_FG = '502' "
            + " AND COM_CD = '001' ";
    
    this.updateRobotIpPort =  "UPDATE SCD_CODEM_T SET COM_CD_ITEM_01 = ?, COM_CD_ITEM_02 = ? WHERE SHOP_CD = ? AND COM_CD_FG  = '502' AND COM_CD = '001' ";
    
    this.selectOrderNo = ""
			+"\n SELECT SHOP_CD, SALE_DATE, ORDER_NO, ORDER_DTL_NO, SALE_QTY, POS_NO, PROD_CD, SDA_CD, SDS_ORG_DTL_NO, REMARK ".rtrim()
			+"\n FROM POS_ODDTL_T                 ".rtrim()
			+"\n WHERE SHOP_CD  = ?                           ".rtrim()
			+"\n AND   SALE_DATE   = ?                           ".rtrim()
			+"\n AND   ORDER_NO   = ?                           ".rtrim()
			+"\n ORDER BY ORDER_DTL_NO ASC                      ".rtrim()	
			;
    
    // 이통사 관련 테이블 (제휴사 테이블)
    this.sqlInsertScdJcdhdT = "INSERT OR REPLACE INTO SCD_JCDHD_T( SHOP_CD, JCD_CD, JCD_NM, JCD_TYPE_FG, VALID_F_DATE, VALID_T_DATE, DC_PROD_FG, DC_RATE, DC_LIMIT_FG, DC_LIMIT_AMT, APPR_PROC_FG, REMARK, INS_DT, UPD_DT)"
        + " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )"; 
    this.sqlSelectScdJcdhdT = "SELECT * FROM SCD_JCDHD_T";
    this.sqlDeleteScdJcdhdT = "DELETE FROM SCD_JCDHD_T WHERE SHOP_CD = ? AND JCD_CD = ?";
    
    // 이통사 관련 테이블 (할인 대상테이블)
    this.sqlInsertScdJcddtT = "INSERT OR REPLACE INTO SCD_JCDDT_T( SHOP_CD, JCD_CD, STYLE_PROD_CD, DC_RATE, INS_DT, UPD_DT)"
        + " values(?, ?, ?, ?, ?, ? )"; 
    this.sqlSelectScdJcddtT = "SELECT * FROM SCD_JCDDT_T";
    this.sqlDeleteScdJcddtT = "DELETE FROM SCD_JCDDT_T WHERE SHOP_CD = ? AND JCD_CD = ? AND STYLE_PROD_CD = ?";
    
    this.sqlSelectAlliCompany = "SELECT SHOP_CD, JCD_CD, JCD_NM, JCD_TYPE_FG, VALID_F_DATE, VALID_T_DATE, DC_PROD_FG, DC_RATE, DC_LIMIT_FG, DC_LIMIT_AMT, APPR_PROC_FG, REMARK, INS_DT, UPD_DT"
    						  + " FROM SCD_JCDHD_T " 
    						  + "WHERE SHOP_CD = ? AND (? BETWEEN VALID_F_DATE AND VALID_T_DATE)"
    						  
    this.selectSalePodList = "SELECT A.STYLE_PROD_CD AS PROD_CD, B.PROD_NM FROM SCD_JCDDT_T A, SCD_PRODM_T B "
    		               + "WHERE B.SHOP_CD = A.SHOP_CD AND B.PROD_CD = A.STYLE_PROD_CD "
    		               + "AND A.SHOP_CD = ? AND A.JCD_CD = ?"
    		               
    		               
    this.sqlInsertPosOdjcdT = "INSERT INTO POS_ODJCD_T(SHOP_CD, SALE_DATE, ORDER_NO, LINE_NO, SEQ_NO, POS_NO, SALE_YN, JCD_CD, JCD_TYPE_FG, JCD_PROC_FG, "
    		              + " APPR_LOG_NO, APPR_AMT, JCD_DC_AMT, JCD_OCC_POINT, JCD_AVL_POINT, JCD_USE_POINT, JCD_REM_POINT, INS_DT, EMP_NO, JCD_PAY_FG)"
                          + " VALUES (?, ?, ?, ?, ?, "
		                           + "?, ?, ?, ?, ?, "
		                           + "?, ?, ?, ?, ?, "
		                           + "?, ?, ?, ?, ? )";
    
    this.sqlSelectPosOdjcdTSeqNo = "SELECT IFNULL(MAX(SEQ_NO), 0)+1 AS MAX_SEQ_NO FROM POS_ODJCD_T WHERE SHOP_CD = ? AND SALE_DATE = ? AND ORDER_NO = ? AND LINE_NO = ?"
    	
	this.sqlInsertPosOdcshT = "INSERT INTO POS_ODCSH_T (SHOP_CD, SALE_DATE, ORDER_NO, LINE_NO, SEQ_NO, POS_NO, SALE_YN, CORNER_CD, CASH_AMT, SVC_TIP_AMT"
							+ ", VAT_AMT, APPR_LOG_NO, INS_DT, EMP_NO, EX_CD, EX_KRW, EX_EXP_AMT, EX_IN_AMT, EX_RET_AMT, KR_RET_AMT"
						    + ", EX_PAY_AMT, KR_PAY_AMT, KR_ETC_AMT, PRE_PAY_FG, VAT_SALE_AMT, NO_VAT_SALE_AMT)"       
							+ " VALUES (?, ?, ?, ?, ?, "
				                     + "?, ?, ?, ?, ?, "
				                     + "?, ?, ?, ?, ?, "
				                     + "?, ?, ?, ?, ?, "
				                     + "?, ?, ?, ?, ?, "
				                     + "? )";
    
    this.sqlInsertPosLgcshT = "INSERT INTO POS_LGCSH_T (SHOP_CD, SALE_DATE, APPR_LOG_NO, POS_NO, VAN_CD, CORNER_CD, APPR_TYPE_FG, APPR_FG, APPR_AMT, SVC_TIP_AMT"
							+ ", VAT_AMT, APPR_PROC_FG, APPR_IDT_TYPE, APPR_IDT_FG, CARD_IN_FG, APPR_IDT_NO, APPR_DATE, APPR_TIME, APPR_NO, APPR_MSG"
							+ ", VAN_TERM_NO, VAN_SLIP_NO, ORG_APPR_DATE, ORG_APPR_NO, ORG_APPR_LOG_NO, INS_DT, EMP_NO, SEND_FG, SEND_DT, NOTICE_MSG"
						    + ", BROAD_MSG, CNMK_CD, VAT_SALE_AMT, NO_VAT_SALE_AMT)"       
							+ " VALUES (?, ?, ?, ?, ?, "
						             + "?, ?, ?, ?, ?, "
						             + "?, ?, ?, ?, ?, "
						             + "?, ?, ?, ?, ?, "
						             + "?, ?, ?, ?, ?, "
						             + "?, ?, ?, ?, ?, "
						             + "?, ?, ?, ? )";
    
    this.kioskProdStatusUpdate_SQL = ""
    	+ "\n UPDATE SCD_PRODM_T                                    ".rtrim()
    	+ "\n 	SET KIOSK_PROD_STATUS = '%s'                     	".rtrim()
    	+ "\n WHERE SHOP_CD = '%s'	                                ".rtrim()
		+ "\n AND PROD_CD IN ('%s')                     			".rtrim()
    	;
    
    this.sqlSelectCornerNmEtc = "SELECT CORNER_NM FROM SCD_SHOPS_T WHERE SHOP_CD = ? AND CORNER_CD = ? ";
    this.sqlSelectCornerNm00 = "SELECT SHOP_NM AS CORNER_NM FROM SCD_SHOPM_T WHERE SHOP_CD = ? ";
    }

