var ImagesDownload = function(){

    this.fullPath = downloadPath + "/" + prodImgPath;
    this.fullPathCorner = downloadPath + "/" + cornerImgPath;
    this.prodDir;
    this.imgObj;
    this.waitFullPath = downloadPath + "/" + waitingFilePath; // downloads/FirstKIOSK/MEDIA/WAIT
    
    this.logoFullPath = downloadPath + "/" + logoFilePath; // downloads/FirstKIOSK/MEDIA/WAIT

    this.productImageDownloadCreateDir = function(){


        var downloadsDir, newDir;
        var imgList = gfn_SQLiteSQLProcess(adminSql.selectProdImgUrl , [gShopCd]).Data;

        util.logInfo("###################   productImageDownloadCreateDir  start time : " + moment().format("YYYY-MM-DD HH:mm:ss") + ",  imgList : " + JSON.stringify(imgList));

        if(imgList == null){
            return false;
        }

        if(imgList.length > 0){
            try{
                tizen.filesystem.resolve(imagesDownload.fullPath, function(result) {
                	util.logInfo("###################  productImageDownloadCreateDir tizen.filesystem func11 ##########");
                	util.logDebug("###################  productImageDownload result : " + JSON.stringify(result));
                    downloadsDir = result;

                    if(downloadsDir.isDirectory){
                        imagesDownload.productImageDownload(downloadsDir.fullPath, imgList);
                    }else{
                        tizen.filesystem.resolve(downloadPath, function(result) {
                            downloadsDir = result;

                            newDir = downloadsDir.createDirectory(prodImgPath);
                           //util.log("###################  productImageDownload newFile : " + JSON.stringify(newDir));
                            imagesDownload.productImageDownload(newDir.fullPath, imgList);
                        });
                    }
                },
                function(data){
                	util.logInfo("###################  productImageDownloadCreateDir tizen.filesystem func22 ##########");
                    util.logDebug("###################  productImageDownload data : " + JSON.stringify(data));

                    tizen.filesystem.resolve(downloadPath, function(result) {
                        downloadsDir = result;

                        newDir = downloadsDir.createDirectory(prodImgPath);
                        //util.log("###################  productImageDownload newFile : " + JSON.stringify(newDir));
                        imagesDownload.productImageDownload(newDir.fullPath, imgList);
                    });
                });

            }catch(e){
                util.logError("***************  productImageDownload ERROR : " + JSON.stringify(e));
                //imagesDownload.productImageDownload();
            }
        }

        var delayTime = 20000 + imgList.length * 200;

        util.logInfo("***************  productImageDownloadDeleteDelay setTimeout : " + delayTime);
        //setTimeout(imagesDownload.productImageDownloadDeleteDelay, delayTime, imgList);
        setTimeout(imagesDownload.productImageDownloadDeleteCheck, delayTime, imgList);

    },

    this.productImageDownloadDeleteDelay = function(imgList){
        util.logInfo("productImageDownloadDeleteDelay   time : " + moment().format("YYYY-MM-DD HH:mm:ss"));
        util.logDebug("@@@@@@@@@@@@@  productImageDownloadDeleteDelay imgList : " + JSON.stringify(imgList));
        if(imgList){
            try{
                tizen.filesystem.resolve(imagesDownload.fullPath, function(result) {
                    var downloadsDir = result;
                    downloadsDir.listFiles(
                        function(files){
                            for(var j=0; files.length > j ; j++){

                                if (files[j].isFile) {

                                    var fileFullPath = files[j].fullPath;
                                    var fileNm = fileFullPath.substring(fileFullPath.lastIndexOf('.')-2, fileFullPath.lastIndexOf('.'));

                                    if(fileNm == "_1" || fileNm == "_2" || fileNm == "_3"){

                                        downloadsDir.deleteFile(fileFullPath,
                                            function(){
                                                util.logInfo("@@@@@@@@@@@@@File Deleted fileFullPath : " + fileFullPath);
                                            },
                                            function(e) {
                                                util.logError("*************Error " + e.message);
                                            }
                                        );
                                    }
                                }
                            }
                        }
                    );
                });
            }catch(e){
                util.logError("***************  productImageDownloadDeleteDelay Catch ERROR : " + JSON.stringify(e));
            //imagesDownload.productImageDownload();
            }
        }
    },

    this.productImageDownloadDeleteCheck = function(item){
        util.logInfo("***************  productImageDownloadDeleteCheck Start #################");
        var imgList = gfn_SQLiteSQLProcess(adminSql.selectProdImgUrlCheck , [gShopCd]).Data;
        if(!util.isEmpty(imgList)){
            for(var i=0; imgList.length > i ; i++){
                var imgObj = imgList[i];

                var imgUrl = imgObj.IMG_URL;
                var fileName = imgUrl.substring(imgUrl.lastIndexOf('/'));
                var checkName = imgObj.SHOP_CD + "_" + imgObj.PROD_CD;

                util.logInfo("***************  productImageDownloadDeleteCheck fileName : " + fileName);

                imagesDownload.productImageDownloadDelete(fileName, checkName);


            }
        }

    },

    this.productImageDownloadDelete = function(fileName, checkName){
        util.logInfo("***************  productImageDownloadDelete Start ***************" );
        try{
            tizen.filesystem.resolve(imagesDownload.fullPath, function(result) {
                var downloadsDir = result;

                if(downloadsDir.isDirectory){
                    downloadsDir.listFiles(
                        function(files){
                            for(var j=0; files.length > j ; j++){

                                if (files[j].isFile) {

                                    var fileFullPath = files[j].fullPath;

                                    if(fileFullPath.indexOf(checkName) != -1 && fileFullPath.indexOf(fileName) == -1){

                                        //util.log("########fnListFiles files : " + JSON.stringify(files[j]));

                                        util.logInfo("File check fileFullPath : " + fileFullPath + ",  :" +checkName + ", : " + fileName);

                                        downloadsDir.deleteFile(fileFullPath,
                                        function(){
                                        	util.logInfo("***************  productImageDownloadDelete deleteFile fnc11 ***************" );
                                            //util.log("@@@@@@@@@@@@@File Deleted fileFullPath : " + fileFullPath);
                                        },
                                        function(e) {
                                        	util.logInfo("***************  productImageDownloadDelete deleteFile fnc22 ***************" );
                                            util.logError("*************Error " + e.message);
                                        });


                                    }
                                }
                            }
                        }
                    );
                }
            });
        }catch(er){
            util.logError("###################  productImageDownloadDelete Catch er : " + JSON.stringify(er));
        }
    },

    this.fnSetImgFullPath = function(item){

        var imageUrl = item["IMG_URL"];
        var extension = imageUrl.substring(imageUrl.lastIndexOf('.'));
        var fileName = item["SHOP_CD"] + "_" + item["PROD_CD"] + extension;
        item.extension = extension;

        return {"fileName" : fileName, "imageUrl" : imageUrl, "item" : item };

    },

    this.productImageDownload = async function(fullPath, imgList){

        try{
        	var vsCnt = imgList.length;
        	util.logInfo("*****productImageDownload Img Download Total Count == > " + vsCnt);
            for(var i=0; vsCnt > i ; i++){
                var item = imgList[i];
                var pathResult = imagesDownload.fnSetImgFullPath(item);
                imagesDownload.imageDownload(pathResult.imageUrl, fullPath, pathResult.fileName, pathResult.item);

                // 5% 진행 시 마다 로그 남김.
                if(parseInt((i+1)/vsCnt*100)%5 == 0 ){
                    util.logInfo("*****productImageDownload Img Download Progress Count == > " + (i+1));
                    util.logInfo("*****productImageDownload Img Download Progress Count Percent == >> [" + parseInt((i+1)/vsCnt*100) + "]%"); // 현재 진행 퍼센테이지	
                }            
                
                if(i != 0 && i%30 == 0){
                    util.logInfo("productImageDownload   i : " + i);                
                    util.logInfo("productImageDownload   before time : " + moment().format("YYYY-MM-DD HH:mm:ss"));
                    await util.sleepUtil(5000);
                    util.logInfo("productImageDownload   after time : " + moment().format("YYYY-MM-DD HH:mm:ss"));

                }
            }
        }catch(er){
            util.log("productImageDownload   er : " + er);
        }
    },
    
    this.imageDownload = function(url, path, fileName, productInfo){

        if(typeof tizen == "undefined" ){
            util.logInfo("downTest imageDownload tizen is no : " + fileName);
            if(progressDelYn == "Y"){
   				util.logInfo("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! waitingFileDownload typeof tizen == undefined progress end !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
   				imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지   				
    		}
            return;
        }
        tizen.systeminfo.getPropertyValue('NETWORK', function(networkInfo) {
            if (networkInfo.networkType === 'NONE') {
                util.logError('downTest connection is not available.  Download is not possible.');
                return;
            }
        });

        // Check if Download API is supported not on a device.
        var download_api_capability = tizen.systeminfo.getCapability("http://tizen.org/feature/download");
        if (download_api_capability === false) {
            util.Error("downTest Download API is not supported on this device.");
            return;
        }

        var listener = {
            oncompleted: function(id, filePath) {

//                filePath = filePath.replace(/_1/g, "");
//                filePath = filePath.replace(/_2/g, "");

                var result = gfn_SQLiteSQLProcess(adminSql.updateProdImgUrl , [filePath, gShopCd, productInfo.PROD_CD]);
                util.logInfo('*****downTest Completed with id: ' + id + ', filePath: ' + filePath + ', productInfo :' + JSON.stringify(productInfo));
                //imagesDownload.productImageDownloadDelete(productInfo);

            },
            onfailed: function(id, error) {
                util.logInfo('downTest Failed with id: ' + id + ', error name: ' + JSON.stringify(error));
            }
        };

        var downloadRequest = new tizen.DownloadRequest(url, path, fileName);
        var downloadId = tizen.download.start(downloadRequest, listener);

        //util.log("downTest fileName : " + fileName + ", path : " + path + " url : " + url );

//        if (wifi_capability === true) {
//
//            util.log("downTest wifi before fileName : " + fileName + ", path : " + path + " url : " + url );
//
//            var wifiDownloadRequest = new tizen.DownloadRequest(url, path, fileName, "WIFI");
//            var downlodId_wifi = tizen.download.start(wifiDownloadRequest, listener);
//
//            util.log("downTest downlodId_wifi : " + downlodId_wifi);
//
//        } else {
//            util.log("downTest before fileName : " + fileName + ", path : " + path + " url : " + url );
//            // Starts downloading the file from the Web with the corresponding callbacks.
//            var downloadRequest = new tizen.DownloadRequest(url, path, fileName);
//            var downloadId = tizen.download.start(downloadRequest, listener);
//
//            util.log("downTest fileName : " + fileName + " downloadId : " + downloadId);
//        }
    },
    
    /**
     * 대기 이미지/동영상 폴더 생성.
     * 아래 waitingFileDownloadCreateDir에서 해당 이미지/동영상 폴더 경로에 접근하여 없으면 생성하는 로직이 있으나, 이미지/동영상을 동시에 수행하면서 tizen api에서 문제가 발생하여
     * 해당 함수에서 폴더가 없으면 생성되도록 따로 로직을 구성함.
     **/
    this.waitingFileCreateDirInit = function(){
    	util.logInfo("\n<<<======= waitingFileCreateDirInit Start =======>>> ");
    	if(typeof tizen == "undefined" ){        	
            return;
        }
    	
    	tizen.filesystem.resolve(this.waitFullPath, function(result) { // successCallback, waitFullPath = "downloads" + "FirstKIOSK/MEDIA/waiting"
    		util.logInfo("\n<<<======= waitingFileCreateDirInit successCallback  Start =======>>> " + JSON.stringify(result));
            downloadsDir = result;
            if(downloadsDir.isDirectory){
            	util.logInfo("\n<<<======= waitingFileCreateDirInit successCallback  IS DIRECTORY =======>>> ");
            }else{
            	util.logInfo("\n<<<======= waitingFileCreateDirInit successCallback  IS NOT DIRECTORY =======>>> ");
                tizen.filesystem.resolve(downloadPath, function(result) { // downloadPath = "downloads"
                	util.logInfo("\n<<<======= waitingFileCreateDirInit successCallback  IS NOT DIRECTORY filesystem.resolve SUCCESS =======>>> ");
                    downloadsDir = result;
                    newDir = downloadsDir.createDirectory(waitingFilePath); // waitingFilePath = "FirstKIOSK/MEDIA/waiting"
                },
                function(data){ // ERROR CALLBACK
                	util.logInfo("\n<<<======= waitingFileCreateDirInit successCallback  IS NOT DIRECTORY filesystem.resolve ERROR =======>>> ");
                });
            }
        },
        function(data){ // errorCallback          
            tizen.filesystem.resolve(downloadPath, function(result) { // downloadPath = "downloads"
            	util.logInfo("\n<<<======= waitingFileCreateDirInit errorCallback resolve Start =======>>> " + JSON.stringify(result));
                downloadsDir = result;
                newDir = downloadsDir.createDirectory(waitingFilePath); // waitingFilePath = "FirstKIOSK/MEDIA/waiting"
            },
            function(data){
            	util.logInfo("\n<<<======= waitingFileCreateDirInit errorCallback resolve > ErrorCalback =======>>> " + JSON.stringify(data));
            });
        });
    }
    /* 대기화면의 동영상과 이미지를 다운받는다.
      paWaitingDownUrl : 다운로드 url 
      paEnvVal : 환경변수 val 
      paVersion : 서버에서 받아온 다운로드 version(사용자인경우만 존재) 
      paVideoImgFlag : 이미지,동영상 구분자  (img, video), 
                       video, img : 사용자 대기화면 설정된 경우 서버에서 video, img를 각각 받아와서 해당 파라미터로 두번 호출
                       all : 외식, 카페인 경우 zip파일을 서버에서 받아와서 처리하기 때문에 all로 해당 함수 한 번만 호출 
      progressDelYn : 프로그레스바 제거할지 여부 (admin_init할때는 프로그레스바 삭제안함, 환경변수에서 재수신할 경우만 프로그레스바 제거) 
      */
    this.waitingFileDownloadCreateDir = function(paWaitingDownUrl, paEnvVal, paVersion, paVideoImgFlag, progressDelYn){
    	util.logInfo("\n======= waitingFileDownloadCreateDir Result Start !!!!!!!!!!! ======= ");
    	util.logInfo("\n<<<======= waitingFileDownloadCreateDir paWaitingDownUrl !!!!!!!!!!! =======>>> " +paWaitingDownUrl);
    	util.logInfo("\n<<<======= waitingFileDownloadCreateDir paEnvVal !!!!!!!!!!! =======>>> " + paEnvVal);
    	util.logInfo("\n<<<======= waitingFileDownloadCreateDir paVersion !!!!!!!!!!! =======>>> " +paVersion);
        var downloadsDir, newDir;

        try{
        	if(typeof tizen == "undefined" ){        	
                if(paVideoImgFlag=="video"){
                	gvInitEndYnVideo = "Y";
                }else if(paVideoImgFlag == "img"){
   	            	gvInitEndYnImg = "Y";
   	            }else{ // all인 경우 (사용자가 아니고 외식, 카페인 경우는 zip파일로 받기 때문에 해당 공통함수를 한번 호출하기 때문에 둘다 성공으로(Y)로 변경한다.
   	            	gvInitEndYnVideo = "Y";
   	            	gvInitEndYnImg = "Y";
   	            }
                imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지   				
                return;
            }
    		// 음성안내 사용여부 환경변수
    		if(!paEnvVal && paEnvVal != "0"){ // 값이 0이 아니고 없을 때 디폴트인 외식을 셋팅한다.
    			util.logInfo("<<<===== waitingFileDownloadCreateDir envVal is null. default 1 set =====>>>");
    			paEnvVal ="1"; // 디폴트인 외식을 셋팅.
    		}
    		
    		util.logInfo("\n<<=== waitingFileDownloadCreateDir GetEnvXmlPosENV(709) ===>>  " + paEnvVal);        		

    		// img/video 버전을 db에서 불러온다.
    		var selectListResult = gfn_SQLiteSQLProcess(adminSql.selectSetUpTData, [gShopCd, gPosNo]).Data; // 로컬의 대기화면 version을 조회
        	var voRow = selectListResult[0];
        	var vsWaitVideoVer = voRow["WAIT_VIDEO_VER"]; 
        	var vsWaitImgVer = voRow["WAIT_IMG_VER"]; 
        	
        	var vsEnvWatingVal = util.GetEnvXmlPosENV(747); // (0:미사용, 1:메인1, 2:메인2, 3:메인3, 4:메인4, 5:메인5)
			if (util.byteLen(vsEnvWatingVal) == 0 )
				vsEnvWatingVal = "0"; 
			
        	if(!vsWaitVideoVer && vsWaitVideoVer != "0"){ // 비교를 위해 값이 없는 경우에 0으로 셋팅
        		vsWaitVideoVer = "0";
        	}
        	if(!vsWaitImgVer && vsWaitImgVer != "0"){ // 비교를 위해 값이 없는 경우에 0으로 셋팅
        		vsWaitImgVer = "0";
        	}
        	if(paEnvVal == "0"){ // 환경변수 '사용자 대기영상'인 경우
        		util.logInfo("\n<<<===== Waiting Env Change envValCd =====>>> 0");
        		// 해당 사용자 대기화면 버전 조회
            	
            	if(paVideoImgFlag == "video"){ // 영상에 관한 처리인 경우 영상버전 비교
            		if(vsEnvWatingVal == "0"){ 
            			// (0:사용자, 1:외식(디폴트), 2:카페)
            			if(vsWaitVideoVer >= paVersion){ // 사용자인 경우에는 로컬 버전보다 전문 버전이 높아야만 다운로드를 수행한다.
            				util.logInfo("\n********** waitingFileDownloadCreateDir VERSION SAME - LOCAL VIDEO VERSION =====> " + vsWaitVideoVer);
            				gvInitEndYnVideo = "Y";       	            	
            				imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지
            				return false;
            			}   
            		} else {
            			// (0:사용자, 1:외식(디폴트), 2:카페)
            			if(vsWaitVideoVer == paVersion){ // 사용자인 경우에는 로컬 버전보다 전문 버전이 달라야지만 다운로드를 수행한다.
            				util.logInfo("\n********** waitingFileDownloadCreateDir VERSION SAME - LOCAL VIDEO VERSION =====> " + vsWaitVideoVer);
            				gvInitEndYnVideo = "Y";       	            	
            				imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지
            				return false;
            			}   
            		}
            	}else if(paVideoImgFlag == "img"){ // 이미지에 관한 처리인 경우 이미지 버전 비교
            		if(vsEnvWatingVal == "0"){ 
            			if(Number(vsWaitImgVer) >= Number(paVersion)){ // 사용자인 경우에는 로컬 버전보다 전문 버전이 높아야만 다운로드를 수행한다.
                			util.logInfo("\n********** waitingFileDownloadCreateDir VERSION SAME - LOCAL IMG VERSION =====> " + vsWaitImgVer);
           	            	gvInitEndYnImg = "Y";
                			imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지   
                			return false;
                		}   
            		} else {
            			if(Number(vsWaitImgVer) == Number(paVersion)){ // 사용자인 경우에는 로컬 버전보다 전문 버전이 달라야지만 다운로드를 수행한다.
                			util.logInfo("\n********** waitingFileDownloadCreateDir VERSION SAME - LOCAL IMG VERSION =====> " + vsWaitImgVer);
           	            	gvInitEndYnImg = "Y";
                			imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지   
                			return false;
                		}   
            		}
                    // gvInitEndYnImg = "Y";
            		
            	}        		 			
    			//imagesDownload.waitingFileDownloadCreateDir(paWaitingDownUrl, paVersion); // 사용자인 경우에 전문에서 받아온 Url과 version을 넘긴다.
        	}else if(paEnvVal == "1"){ // 외식 (디폴트)
        		if(Number(vsWaitVideoVer) == Number(paVersion)){ // 외식, 카페인 경우 환경변수 값인 '1'이 img/video version에 insert되어 있다.        			
        			util.logInfo("\n********** waitingFileDownloadCreateDir VERSION SAME - LOCAL VIDEO VERSION =====> " + paEnvVal);
        			gvInitEndYnVideo = "Y";
   	            	gvInitEndYnImg = "Y";
        			imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지   	
        			return false;
        		}
        		util.logInfo("\n<<<===== Waiting Env Change envValCd =====>>> 1");
        		paWaitingDownUrl = waitingFileDownPath1; // 외식url로 변경
        	}else if(paEnvVal == "2"){ // 카페
        		if(Number(vsWaitVideoVer) == Number(paVersion)){ // 외식, 카페인 경우 환경변수 값인 '1'이 img/video version에 insert되어 있다.
        			util.logInfo("\n********** waitingFileDownloadCreateDir VERSION SAME - LOCAL VIDEO VERSION =====> " + paEnvVal);
        			gvInitEndYnVideo = "Y";
   	            	gvInitEndYnImg = "Y";
        			imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지   
        			return false;
        		}
        		util.logInfo("\n<<<===== Waiting Env Change envValCd =====>>> 2");
        		paWaitingDownUrl = waitingFileDownPath2; // 카페 url로 변경
        	}else if(paEnvVal == "3"){ // 봄
        		if(Number(vsWaitVideoVer) == Number(paVersion)){ 
        			util.logInfo("\n********** waitingFileDownloadCreateDir VERSION SAME - LOCAL VIDEO VERSION =====> " + paEnvVal);
        			gvInitEndYnVideo = "Y";
   	            	gvInitEndYnImg = "Y";
        			imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지   
        			return false;
        		}
        		util.logInfo("\n<<<===== Waiting Env Change envValCd =====>>> 3");
        		paWaitingDownUrl = waitingFileDownPath3; // 카페 url로 변경
        	}else if(paEnvVal == "4"){ // 여름
        		if(Number(vsWaitVideoVer) == Number(paVersion)){ 
        			util.logInfo("\n********** waitingFileDownloadCreateDir VERSION SAME - LOCAL VIDEO VERSION =====> " + paEnvVal);
        			gvInitEndYnVideo = "Y";
   	            	gvInitEndYnImg = "Y";
        			imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지   
        			return false;
        		}
        		util.logInfo("\n<<<===== Waiting Env Change envValCd =====>>> 3");
        		paWaitingDownUrl = waitingFileDownPath4; // 카페 url로 변경
        	}else if(paEnvVal == "5"){ // 가을
        		if(Number(vsWaitVideoVer) == Number(paVersion)){ 
        			util.logInfo("\n********** waitingFileDownloadCreateDir VERSION SAME - LOCAL VIDEO VERSION =====> " + paEnvVal);
        			gvInitEndYnVideo = "Y";
   	            	gvInitEndYnImg = "Y";
        			imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지   
        			return false;
        		}
        		util.logInfo("\n<<<===== Waiting Env Change envValCd =====>>> 3");
        		paWaitingDownUrl = waitingFileDownPath5; // 카페 url로 변경
        	}else if(paEnvVal == "6"){ // 겨울
        		if(Number(vsWaitVideoVer) == Number(paVersion)){ 
        			util.logInfo("\n********** waitingFileDownloadCreateDir VERSION SAME - LOCAL VIDEO VERSION =====> " + paEnvVal);
        			gvInitEndYnVideo = "Y";
   	            	gvInitEndYnImg = "Y";
        			imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지   
        			return false;
        		}
        		util.logInfo("\n<<<===== Waiting Env Change envValCd =====>>> 3");
        		paWaitingDownUrl = waitingFileDownPath6; // 카페 url로 변경
        	}else{ // 값이 없을 때, 기타는 디폴트인 외식으로
        		util.logInfo("\n<<<===== Waiting Env Change envValCd =====>>> else");
        		paWaitingDownUrl = waitingFileDownPath1; // 외식url로 변경
        	}

        	var vsFileNm = paWaitingDownUrl.substring(paWaitingDownUrl.lastIndexOf('/')+1); // 파일명
        	util.logInfo(" waitingFileDownloadCreateDir vsFileNm == > " + vsFileNm);
        	
        	tizen.filesystem.resolve(this.waitFullPath, function(result) { // successCallback, waitFullPath = "downloads" + "FirstKIOSK/MEDIA/waiting"
        		util.logInfo("\n<<<======= waitingFileDownloadCreateDir successCallback  Start =======>>> " + JSON.stringify(result));
                downloadsDir = result;
                if(downloadsDir.isDirectory){
                	util.logInfo("\n<<<======= waitingFileDownloadCreateDir successCallback  IS DIRECTORY vsFileNm =======>>> " + vsFileNm);
                    imagesDownload.waitingFileDownload(paWaitingDownUrl, downloadsDir.fullPath, vsFileNm, paEnvVal, paVersion, progressDelYn, paVideoImgFlag);
                }else{
                	util.logInfo("\n<<<======= waitingFileDownloadCreateDir successCallback  IS NOT DIRECTORY vsFileNm =======>>> " + vsFileNm);
                    tizen.filesystem.resolve(downloadPath, function(result) { // downloadPath = "downloads"
                    	util.logInfo("\n<<<======= waitingFileDownloadCreateDir successCallback  IS NOT DIRECTORY filesystem.resolve SUCCESS vsFileNm =======>>> " + vsFileNm);
                        downloadsDir = result;

                        newDir = downloadsDir.createDirectory(waitingFilePath); // waitingFilePath = "FirstKIOSK/MEDIA/waiting"
                        setTimeout(imagesDownload.waitingFileDownload(paWaitingDownUrl, newDir.fullPath, vsFileNm, paEnvVal, paVersion, progressDelYn, paVideoImgFlag), 1000);
                    },
                    function(data){ // ERROR CALLBACK
                    	util.logInfo("\n<<<======= waitingFileDownloadCreateDir successCallback  IS NOT DIRECTORY filesystem.resolve ERROR vsFileNm =======>>> " + vsFileNm);
                    });
                }
            },
            function(data){ // errorCallback          
                tizen.filesystem.resolve(downloadPath, function(result) { // downloadPath = "downloads"
                	util.logInfo("\n<<<======= waitingFileDownloadCreateDir errorCallback resolve Start =======>>> " + JSON.stringify(result));
                	util.logInfo("\n<<<======= waitingFileDownloadCreateDir errorCallback resolve Start vsFileNm =======>>> " + vsFileNm);
                	
                    downloadsDir = result;
                    newDir = downloadsDir.createDirectory(waitingFilePath); // waitingFilePath = "FirstKIOSK/MEDIA/waiting"
//                    util.logInfo(" errorCallback waitingFileDownloadCreateDir Callback2 result == > " + JSON.stringify(result));
//                    util.logInfo(" errorCallback waitingFileDownloadCreateDir Callback2 paWaitingDownUrl == > " + paWaitingDownUrl);                    
//                    util.logInfo(" errorCallback waitingFileDownloadCreateDir Callback2 vsFileNm == > " + vsFileNm);
//                    util.logInfo(" errorCallback waitingFileDownloadCreateDir Callback2 paEnvVal == > " + paEnvVal);
//                    util.logInfo(" errorCallback waitingFileDownloadCreateDir Callback2 paVideoImgFlag == > " + paVideoImgFlag);
//                    util.logInfo(" errorCallback waitingFileDownloadCreateDir Callback2 waitingFilePath == > " + waitingFilePath);
//                    util.logError(" errorCallback waitingFileDownloadCreateDir ERROR_Callback newDir.fullPath == > " + newDir.fullPath);
                    util.logInfo("\n<<<======= waitingFileDownloadCreateDir errorCallback resolve Start waitingFileDownload before =======>>> ");
                    setTimeout(imagesDownload.waitingFileDownload(paWaitingDownUrl, newDir.fullPath, vsFileNm, paEnvVal, paVersion, progressDelYn,paVideoImgFlag), 1000);
                },
                function(data){
                	util.logInfo("\n<<<======= waitingFileDownloadCreateDir errorCallback resolve > ErrorCalback =======>>> " + JSON.stringify(data));
                });
            });

        }catch(e){
            util.logError("[ERROR] waitingFileDownloadCreateDir ERROR : " + JSON.stringify(e));
            gvInitEndYnVideo = "Y";
           	gvInitEndYnImg = "Y";
			imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지   
        }
    },

    this.waitingFileDownload = function(url, path, fileName, envVal, version, progressDelYn, paVideoImgFlag){
    	util.logInfo("\n<<<===== waitingFileDownload Start =====>>>");
    	util.logInfo("\n<<<===== waitingFileDownload url =====>>>" + url);
    	util.logInfo("\n<<<===== waitingFileDownload path =====>>>" + path);
    	util.logInfo("\n<<<===== waitingFileDownload paVideoImgFlag =====>>>" + paVideoImgFlag);
        if(typeof tizen == "undefined" ){        	
            util.logError("[ERROR] waitingFileDownload tizen is no : " + fileName);
            if(paVideoImgFlag=="video"){
            	gvInitEndYnVideo = "Y";
            }else if(paVideoImgFlag == "img"){
	            	gvInitEndYnImg = "Y";
	            }else{ // all인 경우 (사용자가 아니고 외식, 카페인 경우는 zip파일로 받기 때문에 해당 공통함수를 한번 호출하기 때문에 둘다 성공으로(Y)로 변경한다.
	            	gvInitEndYnVideo = "Y";
	            	gvInitEndYnImg = "Y";
	            }
            imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지  (환경변수에서 대기화면 변경할 때만 사용)		
//            gvInitEndYn = "Y";
            return;
        }
        tizen.systeminfo.getPropertyValue('NETWORK', function(networkInfo) {
        	util.logInfo("\n<<<===== waitingFileDownload NETWORK paVideoImgFlag =====>>> " + paVideoImgFlag);
            if (networkInfo.networkType === 'NONE') {
                util.logError('[ERROR] Network connection is not available.  Download is not possible.');
                if(paVideoImgFlag=="video"){
                	gvInitEndYnVideo = "Y";
                }else if(paVideoImgFlag == "img"){
                	util.logInfo("\n<<<===== waitingFileDownload NETWORK IMG =====>>> ");
   	            	gvInitEndYnImg = "Y";
   	            }else{ // all인 경우 (사용자가 아니고 외식, 카페인 경우는 zip파일로 받기 때문에 해당 공통함수를 한번 호출하기 때문에 둘다 성공으로(Y)로 변경한다.
   	            	util.logInfo("\n<<<===== waitingFileDownload NETWORK else =====>>> ");
   	            	gvInitEndYnVideo = "Y";
   	            	gvInitEndYnImg = "Y";
   	            }
                imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지       				
//                gvInitEndYn = "Y";
                return;
            }
        });

        // Check if Download API is supported not on a device.
        var download_api_capability = tizen.systeminfo.getCapability("http://tizen.org/feature/download");
        if (download_api_capability === false) {
            util.logError("[ERROR] Download API is not supported on this device.");
            if(paVideoImgFlag=="video"){
            	gvInitEndYnVideo = "Y";
            }else if(paVideoImgFlag == "img"){
	            	gvInitEndYnImg = "Y";
	            }else{ // all인 경우 (사용자가 아니고 외식, 카페인 경우는 zip파일로 받기 때문에 해당 공통함수를 한번 호출하기 때문에 둘다 성공으로(Y)로 변경한다.
	            	gvInitEndYnVideo = "Y";
	            	gvInitEndYnImg = "Y";
	            }
            imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지
//            gvInitEndYn = "Y";
            return;
        }

        var listener = {
            oncompleted: function(id, filePath) { // download.start callback
            	try{
            		util.logInfo("\n<<<===== waitingFileDownload listener oncompleted start id, filePath, envVal=====>>> " + id + ", " + filePath + ", " + envVal);
                	
                	var vsFileExt = filePath.substring(filePath.lastIndexOf('.')+1); // 파일확장자
                	var dirPath = filePath.substr(0, filePath.lastIndexOf('/'));
                	var vsImgVideoFlag = ""; // 이미지인지 동영상인지 여부 (저장할때 업데이트 쿼리 분기를 위해 사용)
                	
            		if(envVal == "0"){ // 사용자일 때 받아온 파일의 이름을 변경해 주어야함. waiting.mp4, base.png로
            			
            			tizen.filesystem.resolve(dirPath, function(result) { // 사용자로 선택시 asp에서 동영상, 이미지가 각각 원본파일로 내려오기 때문에 파일명을 변경해준다.(move로 변경처리)
            				util.logInfo("\n********** File moveTo filesystem.resolve Start ************");
                        	var downloadsDir = result;
                        	var vsMoveTargetPath = "";
                        	var vaVideoExt = gaWaitingVideoExt.split(",");
                        	var vaImgExt = gaWaitingImgExt.split(",");
                        	var vsMatchYn = "N";
                        	util.logInfo("\n***** vaVideoExt ==> " + vaVideoExt);
                        	util.logInfo("\n***** vaImgExt ==> " + vaImgExt);
                        	for(var i=0; i<vaVideoExt.length;i++){
                        		util.logInfo("\n ***** vaVideoExt[ ]" + vaVideoExt[i]);
                        		if(vsFileExt == vaVideoExt[i]){
                        			util.logInfo("\n********** File moveTo filesystem.resolve if(vsFileExt == vaVideoExt[i]) ************");
                        			vsMoveTargetPath = waitingFileUnzipPath + "/" + "waiting." + vsFileExt;
                        			vsImgVideoFlag = "video";
                        			vsMatchYn = "Y";
                        			break;
                        		}
                        	}
                        	
                        	for(var i=0; i<vaImgExt.length;i++){
                        		util.logInfo("\n ***** vsFileExt[ ]" + vaImgExt[i]);
                        		if(vsFileExt == vaImgExt[i]){
                        			util.logInfo("\n********** File moveTo filesystem.resolve if(vsFileExt == vaImgExt[i]) ************");
                        			vsMoveTargetPath = waitingFileUnzipPath + "/" + "base." + vsFileExt;
                        			vsImgVideoFlag = "img";
                        			vsMatchYn = "Y";
                        			break;
                        		}
                        	}                        
                        	
                        	util.logInfo("\n**********File moveTo filesystem.resolve filePath, vsMoveTargetPath : " + filePath + ", " +vsMoveTargetPath);
                        	if(vsMatchYn != "Y"){ // Y가 아니라면 지정된 확장자와 매칭되지 않았기 때문에, 다운받을 파일을 지우고 작업을 끝낸다.
                        		util.logInfo("\n********** ASP FILE NOT MATCH EXT- filePath : " + filePath);
                        		tizen.filesystem.resolve(dirPath, function(result) { // asp에서 받아온 파일을 지운다.
                                	var downloadsDir = result;
                                    downloadsDir.deleteFile(filePath,
                                        function(){
                                            util.logInfo("\n**********File Deleted Complete fileFullPath : " + filePath);
                                            return false;
                                        },
                                        function(e) {
                                            util.logError("\n**********File Delete Error " + e.message);
                                            return false;
                                        }
                                    );
                        		});
                        	}
                        	
                        	// moveTo : 대상파일경로, 이동할 경로, overwrite boolean, success callback, error callback
                            downloadsDir.moveTo(filePath, vsMoveTargetPath, true,
                                function(){
                                    util.logInfo("\n********** File moveTo Complete MoveTargetPath : " + vsMoveTargetPath);
                                },
                                function(e) {
                                    util.logError("\n**********[ERROR] File moveTo Error " + e);
                                    util.logInfo("\n********** File moveTo ERROR MoveTargetPath : " + vsMoveTargetPath);
                                }
                            );
                            
                            util.logInfo("\n****** waitingFileDownload listener oncompleted envVal == 0 UPDATE SATART ******");
                    		util.logInfo("\n****** waitingFileDownload listener oncompleted envVal == 0 vsImgVideoFlag, vsFileExt :: " + vsImgVideoFlag + ", "+ vsFileExt);
                    		var vsDelExt = "";                    		
                    		
                    		// version update : 완료 후 scd_setup_t에 버전을 업데이트 한다.
                    		if(envVal == "0"){ // 사용자인 경우에 이미지, 동영상인지에 따라 분기하여 업데이터 한다.
                    			util.logInfo("\n****** waitingFileDownload listener oncompleted envVal : 0 ******");
                    			if(vsImgVideoFlag == "video"){ // mp4인 경우에 비디오 버전 업데이트
                    				util.logInfo("\n****** waitingFileDownload listener oncompleted envVal : 0 FileExt : " + vsFileExt);
                    				var resultData = gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitVideoVer , [version, vsFileExt, gShopCd, gPosNo]);
                    				vsDelExt = gWaitVideoExt; // 삭제할 기존 확장자를 담아둔다.
                    				gWaitVideoExt = vsFileExt; // 전역변수 확장자 현재 파일로 교체
                    				
                    				// 기존확장자와 현재 확장자가 다르다면 기존 파일을 삭제처리. 확장자가 같으면 하지 않는다. move로 덮어버리기 때문에
                    				if(vsDelExt != vsFileExt){
                    					tizen.filesystem.resolve(dirPath, function(result) { // asp에서 받아온 파일을 지운다.
                    						var downloadsDir = result;
                                        	var vsDelFullPath =  downloadsDir.fullPath + "/waiting." + vsDelExt;
                    						util.logInfo("\n***** waitingFileDownload listener oncompleted vsDelExt != vsFileExt VIDEO  vsDelFullPath == > ***** "+vsDelFullPath);
                                            downloadsDir.deleteFile(vsDelFullPath,
                                                function(){
                                                    util.logInfo("\n**********BEFORE FILE VIDEO Deleted Complete fileFullPath : " + vsDelFullPath);
                                                    return false;
                                                },
                                                function(e) {
                                                    util.logError("\n**********BEFORE FILE VIDEO Delete Error " + e.message);
                                                    return false;
                                                }
                                            );
                                		});
                    				}
                    				
                    			}else if(vsImgVideoFlag == "img"){ // png인 경우에 이미지 버전 업데이트
                    				util.logInfo("\n****** waitingFileDownload listener oncompleted envVal : 0 FileExt : "+ vsFileExt);
                    				var resultData = gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitImgVer , [version, vsFileExt, gShopCd, gPosNo]);
                    				vsDelExt = gWaitImgExt; // 삭제할 기존 확장자를 담아둔다.
                    				gWaitImgExt = vsFileExt;// 전역변수 확장자 현재 파일로 교체
                    				
                    				// 기존확장자와 현재 확장자가 다르다면 기존 파일을 삭제처리. 확장자가 같으면 하지 않는다. move로 덮어버리기 때문에
                    				if(vsDelExt != vsFileExt){
                    					tizen.filesystem.resolve(dirPath, function(result) { // asp에서 받아온 파일을 지운다.
                    						var downloadsDir = result;
                    						var vsDelFullPath =  downloadsDir.fullPath + "/base." + vsDelExt;
                    						util.logInfo("\n***** waitingFileDownload listener oncompleted vsDelExt != vsFileExt VIDEO  vsDelFullPath == > ***** "+vsDelFullPath);
                                            downloadsDir.deleteFile(vsDelFullPath,
                                                function(){
                                                    util.logInfo("\n**********BEFORE FILE IMG Deleted Complete fileFullPath : " + vsDelFullPath);
                                                    return false;
                                                },
                                                function(e) {
                                                    util.logError("\n**********BEFORE FILE IMG Delete Error " + e.message);
                                                    return false;
                                                }
                                            );
                                		});
                    				}
                    				
                    			}else{
                    				util.logInfo("\n****** waitingFileDownload listener oncompleted envVal : 0 FileExt else ******");
                       				if(paVideoImgFlag=="video"){
                       	            	gvInitEndYnVideo = "Y";
                       	            }else if(paVideoImgFlag == "img"){
                       	            	gvInitEndYnImg = "Y";
                       	            }else{ // all인 경우 (사용자가 아니고 외식, 카페인 경우는 zip파일로 받기 때문에 해당 공통함수를 한번 호출하기 때문에 둘다 성공으로(Y)로 변경한다.
                       	            	gvInitEndYnVideo = "Y";
                       	            	gvInitEndYnImg = "Y";
                       	            }
                       				imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지
//                       				gvInitEndYn = "Y";
                    			}
                    		}
                    		util.logInfo("[COMPLETE] !!!!!!!!!!!!!! WAITING DOWN COMPLETE !!!!!!!!!!!!!! ");
            			},
                        function(data){ // errorCallback 
                            util.logError(" errorCallback waitingFileDownload Resolve ERROR_Callback : " + JSON.stringify(data));
                            if(paVideoImgFlag=="video"){
                            	gvInitEndYnVideo = "Y";
                            }else if(paVideoImgFlag == "img"){
               	            	gvInitEndYnImg = "Y";
               	            }else{ // all인 경우 (사용자가 아니고 외식, 카페인 경우는 zip파일로 받기 때문에 해당 공통함수를 한번 호출하기 때문에 둘다 성공으로(Y)로 변경한다.
               	            	gvInitEndYnVideo = "Y";
               	            	gvInitEndYnImg = "Y";
               	            }
                            imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지
//                            gvInitEndYn = "Y";
                        });
            			
            			
            			
            		}else{ // 사용자가 아닐 때 (외식, 카페) zip파일로 다운되기 때문에 압출풀기, zip파일 지우기를 수행한다.
            			
            			var vsResult = nativeApp.functionCallSync(["FDK_Unzip", filePath, waitingFileUnzipPath]); // 받아온 파일 압출풀기
                    	util.logInfo("\n********** waitingFileDownload Unzip vsResult =====>> " + vsResult);
                    	util.logInfo("\n********** waitingFileDownload Unzip dirPath =====>> " + dirPath);
                    	
                    	var delResult = nativeApp.functionCallSync(["FDK_FileDelete", dirPath, ".zip"]); // .zip이 들어간 파일 전부 삭제
                    	util.logInfo("\n********** waitingFileDownload DEL ZIP delResult =====>> " + delResult);
                    	util.logInfo("\n********** waitingFileDownload DEL ZIP dirPath :: keyword =====>> " + dirPath);
                    	/*tizen.filesystem.resolve(dirPath, function(result) { // zip파일 지우기.
                            	var downloadsDir = result;
                                downloadsDir.deleteFile(filePath,
                                    function(){
                                        util.logInfo("\n**********File Deleted Complete fileFullPath : " + filePath);
                                    },
                                    function(e) {
                                        util.logError("\n**********File Delete Error " + e.message);
                                    }
                                );
                        });*/
                    	
                    	
                    	util.logInfo("\n****** waitingFileDownload listener oncompleted else UPDATE SATART ******");
                		util.logInfo("\n****** waitingFileDownload listener oncompleted else vsImgVideoFlag, vsFileExt :: " + vsImgVideoFlag, +", "+ vsFileExt);
                		
                		var vsDelExtVideo = gWaitVideoExt; // 삭제할 기존 확장자를 담아둔다.
                		var vsDelExtImg = gWaitImgExt; // 삭제할 기존 확장자를 담아둔다.
        				
                		if(envVal == "2"){ // 카페일 때 version을 2로 업데이트
                			util.logInfo("\n****** waitingFileDownload listener oncompleted envVal : 2 ******");
                			gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitVideoVer , ["2", "mp4", gShopCd, gPosNo]);
                			gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitImgVer , ["2", "png", gShopCd, gPosNo]);
                			gWaitVideoExt = "mp4";
                			gWaitImgExt = "png";
                			
                			
                		}else if(envVal == "3"){ // 봄일 때 version을 3로 업데이트
                			util.logInfo("\n****** waitingFileDownload listener oncompleted envVal else ******");
                			gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitVideoVer , ["3", "", gShopCd, gPosNo]);
                			gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitImgVer , ["3", "jpg", gShopCd, gPosNo]);
                			gWaitVideoExt = "";
                			gWaitImgExt = "jpg";
                		}else if(envVal == "4"){ // 봄일 때 version을 3로 업데이트
                			util.logInfo("\n****** waitingFileDownload listener oncompleted envVal else ******");
                			gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitVideoVer , ["4", "", gShopCd, gPosNo]);
                			gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitImgVer , ["4", "jpg", gShopCd, gPosNo]);
                			gWaitVideoExt = "";
                			gWaitImgExt = "jpg";
                		}else if(envVal == "5"){ // 봄일 때 version을 3로 업데이트
                			util.logInfo("\n****** waitingFileDownload listener oncompleted envVal else ******");
                			gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitVideoVer , ["5", "", gShopCd, gPosNo]);
                			gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitImgVer , ["5", "jpg", gShopCd, gPosNo]);
                			gWaitVideoExt = "";
                			gWaitImgExt = "jpg";
                		}else if(envVal == "6"){ // 봄일 때 version을 3로 업데이트
                			util.logInfo("\n****** waitingFileDownload listener oncompleted envVal else ******");
                			gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitVideoVer , ["6", "", gShopCd, gPosNo]);
                			gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitImgVer , ["6", "jpg", gShopCd, gPosNo]);
                			gWaitVideoExt = "";
                			gWaitImgExt = "jpg";
                		}else{ // envVal ==1 이거나 그밖에는 외식(디폴트) / version을 1로 업데이트
                			util.logInfo("\n****** waitingFileDownload listener oncompleted envVal else ******");
                			gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitVideoVer , ["1", "mp4", gShopCd, gPosNo]);
                			gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitImgVer , ["1", "png", gShopCd, gPosNo]);
                			gWaitVideoExt = "mp4";
                			gWaitImgExt = "png";
                		}
                		
        				// 기존확장자와 현재 확장자가 다르다면 기존 파일을 삭제처리(이미지). 확장자가 같으면 하지 않는다. move로 덮어버리기 때문에
        				if(vsDelExtImg != gWaitImgExt){
        					tizen.filesystem.resolve(dirPath, function(result) { // asp에서 받아온 파일을 지운다.
        						var downloadsDir = result;
        						var vsDelFullPath =  downloadsDir.fullPath + "/base." + vsDelExtImg;
        						util.logInfo("\n***** waitingFileDownload listener oncompleted IMG envVal !=0 vsDelFullPath == > ***** "+vsDelFullPath);
                                downloadsDir.deleteFile(vsDelFullPath,
                                    function(){
                                        util.logInfo("\n**********BEFORE FILE IMG Deleted Complete envVal !=0 fileFullPath : " + vsDelFullPath);
                                        return false;
                                    },
                                    function(e) {
                                        util.logError("\n**********BEFORE FILE IMG envVal !=0  Delete Error " + e.message);
                                        return false;
                                    }
                                );
                    		});
        				}
        				
        				// 기존확장자와 현재 확장자가 다르다면 기존 파일을 삭제처리(동영상). 확장자가 같으면 하지 않는다. move로 덮어버리기 때문에
        				if(vsDelExtVideo != gWaitVideoExt){
        					tizen.filesystem.resolve(dirPath, function(result) { // asp에서 받아온 파일을 지운다.
        						var downloadsDir = result;
        						var vsDelFullPath =  downloadsDir.fullPath + "/waiting." + vsDelExtVideo;
        						util.logInfo("\n***** waitingFileDownload listener oncompleted VIDEO envVal !=0 vsDelFullPath == > ***** "+vsDelFullPath);
                                downloadsDir.deleteFile(vsDelFullPath,
                                    function(){
                                        util.logInfo("\n**********BEFORE FILE VIDEO Deleted Complete envVal !=0 fileFullPath : " + vsDelFullPath);
                                        return false;
                                    },
                                    function(e) {
                                        util.logError("\n**********BEFORE FILE VIDEO envVal !=0  Delete Error " + e.message);
                                        return false;
                                    }
                                );
                    		});
        				}
        				
                		util.logInfo("[COMPLETE] !!!!!!!!!!!!!! WAITING DOWN COMPLETE !!!!!!!!!!!!!! ");
                    	
            		} // else(사용자가 아닐 때) end
            		
            		if(paVideoImgFlag=="video"){
                    	gvInitEndYnVideo = "Y";
                    }else if(paVideoImgFlag == "img"){
       	            	gvInitEndYnImg = "Y";
       	            }else{ // all인 경우 (사용자가 아니고 외식, 카페인 경우는 zip파일로 받기 때문에 해당 공통함수를 한번 호출하기 때문에 둘다 성공으로(Y)로 변경한다.
       	            	gvInitEndYnVideo = "Y";
       	            	gvInitEndYnImg = "Y";
       	            }
            		imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지
//            		gvInitEndYn = "Y";
            		
            	}catch(e){
            		util.logError("\n********** waitingFileDownload listener oncompleted Catch " + e);
            		if(paVideoImgFlag=="video"){
                    	gvInitEndYnVideo = "Y";
                    }else if(paVideoImgFlag == "img"){
       	            	gvInitEndYnImg = "Y";
       	            }else{ // all인 경우 (사용자가 아니고 외식, 카페인 경우는 zip파일로 받기 때문에 해당 공통함수를 한번 호출하기 때문에 둘다 성공으로(Y)로 변경한다.
       	            	gvInitEndYnVideo = "Y";
       	            	gvInitEndYnImg = "Y";
       	            }
            		imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지
//            		gvInitEndYn = "Y";
            	}
            	
            	
            },
            onfailed: function(id, error) {
                util.logError('[ERROR] tizen.download fail with id: ' + id + ', error name: ' + JSON.stringify(error));
                if(paVideoImgFlag=="video"){
                	gvInitEndYnVideo = "Y";
                }else if(paVideoImgFlag == "img"){
   	            	gvInitEndYnImg = "Y";
   	            }else{ // all인 경우 (사용자가 아니고 외식, 카페인 경우는 zip파일로 받기 때문에 해당 공통함수를 한번 호출하기 때문에 둘다 성공으로(Y)로 변경한다.
   	            	gvInitEndYnVideo = "Y";
   	            	gvInitEndYnImg = "Y";
   	            }
                imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지
//                gvInitEndYn = "Y";
                return;
            }
        };
        util.logInfo("tizen.download url=====>>> " + url);
        util.logInfo("tizen.download path=====>>> " + path);
        util.logInfo("tizen.download fileName =====>>> " +fileName);
        try{
        	var downloadRequest = new tizen.DownloadRequest(url, path, fileName);
            var downloadId = tizen.download.start(downloadRequest, listener);
        }catch(e){
        	util.logError("\n**********waitingFileDownload Catch " + e);
        }
        

    },
    // 대기화면이 사용자 일 때, asp에서 받아온 동영상, 이미지 중에 정보가 없다면 해당 파일을 지우고 디비 상태값을 변경한다. 없는 부분은 키오스크에서 수행하지 않도록 하기 위한 상태 
    this.waitingFileDownloadUserNull = function(paImgVideoFlag, progressDelYn){
    	util.logInfo("\n======= waitingFileDownloadUserNull Start !!!!!!!!!!! ======= ");
    	util.logInfo("\n======= waitingFileDownloadUserNull paImgVideoFlag =======>> " + paImgVideoFlag);
        var downloadsDir, newDir;
		if(typeof tizen == "undefined" ){
			util.logInfo("\n****** waitingFileDownloadUserNull NO TIZEN UPDATE START paImgVideoFlag == > "+ paImgVideoFlag);
            if(paImgVideoFlag == "video"){ // mp4인 경우에 비디오 버전 업데이트
				util.logInfo("\n****** waitingFileDownloadUserNull if Video");
				var resultData = gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitVideoVer , ["0", "", gShopCd, gPosNo]); // 환경변수 사용자(0), 확장자 ""
				gWaitVideoExt = "";
				gvInitEndYnVideo = "Y";
			}else if(paImgVideoFlag == "img"){ // png인 경우에 이미지 버전 업데이트
				util.logInfo("\n****** waitingFileDownloadUserNull if Img");
				var resultData = gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitImgVer , ["0", "", gShopCd, gPosNo]); // 환경변수 사용자(0), 확장자 ""
				gWaitImgExt = "";
				gvInitEndYnImg = "Y";
			}
            return;
		}
		
        try{
			tizen.filesystem.resolve(this.waitFullPath, function(result) { // 파일 지우기.
				util.logInfo("\n****** waitingFileDownloadUserNull filesystem.resolve START result ==>> " + JSON.stringify(result));
				var downloadsDir = result;
            	var vsDelFileFath = "";
            	
            	if(paImgVideoFlag == "video"){
            		if(!gWaitVideoExt){ // 전역변수로 담은 비디오 확장자가 없다면 sql에서 조회해서 한번더 값이 없는지 확인한다. 화면 구동시에 대기화면 받을 때 전역변수로 선언된 것이 없을수 있어서 sql에서 한번더 체크.
            			var selectListResult = gfn_SQLiteSQLProcess(adminSql.selectSetUpTData, [gShopCd, gPosNo]).Data; // 로컬의 대기화면 version을 조회
            			gWaitVideoExt = selectListResult[0]["WAIT_VIDEO_EXT"];
            		}
            		util.logInfo("\n****** waitingFileDownloadUserNull filesystem.resolve if VIDEO");
            		vsDelFileFath = downloadsDir.fullPath + "/waiting." + gWaitVideoExt;
            	}else if (paImgVideoFlag == "img"){
            		if(!gWaitVideoExt){ // 전역변수로 담은 비디오 확장자가 없다면 sql에서 조회해서 한번더 값이 없는지 확인한다. 화면 구동시에 대기화면 받을 때 전역변수로 선언된 것이 없을수 있어서 sql에서 한번더 체크.
            			var selectListResult = gfn_SQLiteSQLProcess(adminSql.selectSetUpTData, [gShopCd, gPosNo]).Data; // 로컬의 대기화면 version을 조회
            			gWaitImgExt = selectListResult[0]["WAIT_IMG_EXT"];
            		}
            		util.logInfo("\n****** waitingFileDownloadUserNull filesystem.resolve if IMG");
            		vsDelFileFath = downloadsDir.fullPath + "/base." + gWaitImgExt;
            	}
            	util.logInfo("\n****** waitingFileDownloadUserNull filesystem.resolve vsDelFileFath == >> " + vsDelFileFath);
                downloadsDir.deleteFile(vsDelFileFath,
                    function(){
                        util.logInfo("\n**********File Deleted Complete waitingFileDownloadUserNull fileFullPath : " + vsDelFileFath);
                        if(paImgVideoFlag=="video"){
                        	gvInitEndYnVideo = "Y";
                        }else if(paImgVideoFlag == "img"){
   	    	        		gvInitEndYnImg = "Y";
   	          	 		}
                        imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지
//                        gvInitEndYn = "Y";
                    },
                    function(e) {
                        util.logError("**********File Delete waitingFileDownloadUserNull Error " + e.message);
                        if(paImgVideoFlag=="video"){
                        	gvInitEndYnVideo = "Y";
                        }else if(paImgVideoFlag == "img"){
   	    	        		gvInitEndYnImg = "Y";
   	          	 		}
                        imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지
//                        gvInitEndYn = "Y";
                    }
                );
                
                util.logInfo("\n****** waitingFileDownloadUserNull UPDATE START paImgVideoFlag == > "+ paImgVideoFlag);
                if(paImgVideoFlag == "video"){ // mp4인 경우에 비디오 버전 업데이트
    				util.logInfo("\n****** waitingFileDownloadUserNull if Video");
    				var resultData = gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitVideoVer , ["0", "", gShopCd, gPosNo]); // 환경변수 사용자(0), 확장자 ""
    				gWaitVideoExt = "";
    			}else if(paImgVideoFlag == "img"){ // png인 경우에 이미지 버전 업데이트
    				util.logInfo("\n****** waitingFileDownloadUserNull if Img");
    				var resultData = gfn_SQLiteSQLProcess(adminSql.updateSetUpWaitImgVer , ["0", "", gShopCd, gPosNo]); // 환경변수 사용자(0), 확장자 ""
    				gWaitImgExt = "";
    			}
                
			},
            function(e) {
				util.logError("\n****** waitingFileDownloadUserNull filesystem.resolve ERROR e JSON==>> " + JSON.stringify(e));
				util.logError("\n****** waitingFileDownloadUserNull filesystem.resolve ERROR e.message==>> " + e.message);
				util.logError("\n****** waitingFileDownloadUserNull filesystem.resolve ERROR paImgVideoFlag==>> " + paImgVideoFlag);
                if(paImgVideoFlag=="video"){
                	gvInitEndYnVideo = "Y";
                }else if(paImgVideoFlag == "img"){
   	        		gvInitEndYnImg = "Y";
         	 	}
            });
			
        }catch(e){
            util.logError("[ERROR] waitingFileDownloadUserNull ERROR : " + JSON.stringify(e));
            if(paImgVideoFlag=="video"){
            	gvInitEndYnVideo = "Y";
            }else if(paImgVideoFlag == "img"){
	        	gvInitEndYnImg = "Y";
     	 	}
        }
    }
    
 // 대기화면이 사용자 일 때, asp에서 받아온 동영상, 이미지 중에 정보가 없다면 해당 파일을 지우고 디비 상태값을 변경한다. 없는 부분은 키오스크에서 수행하지 않도록 하기 위한 상태 
    this.waitingFileProgressDel = function(progressDelYn){
    	util.logInfo("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! waitingFileProgressDel START progressDelYn / gvInitEndYnVideo / gvInitEndYnImg == > " + progressDelYn + " / " + gvInitEndYnVideo  + " / " + gvInitEndYnImg);
    	if(gvInitEndYnVideo == "Y" && gvInitEndYnImg == "Y" && progressDelYn == "Y"){
			setTimeout(function(){
				util.logInfo("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! waitingFileProgressDel setTimeout !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            	$(".loadingCon").hide();
        		eventBus.$emit('alertPopup', {message: "환경설정 정보가 저장되었습니다."});
        	}, 3000);
		}
    },
    
    
    
  /** 화면 상단에 사용자 로고이미지를 asp에서 다운받는다. (폴더생성 함수)
      paLogoDownUrl : 다운로드 url 
      paLogoVersion : 서버에서 받아온 다운로드 version(사용자인경우만 존재) 
  **/
  this.logoFileDownloadCreateDir = function(paLogoDownUrl, paLogoVersion){
  	  util.logInfo("\n======= logoFileDownloadCreateDir Result Start !!!!!!!!!!! ======= ");
  	  util.logInfo("\n<<<======= logoFileDownloadCreateDir paLogoDownUrl !!!!!!!!!!! =======>>> " +paLogoDownUrl);
  	  util.logInfo("\n<<<======= logoFileDownloadCreateDir paLogoVersion !!!!!!!!!!! =======>>> " +paLogoVersion);
      var downloadsDir, newDir;

      try{
      	if(typeof tizen == "undefined" ){
      		gvInitLogoImgEndYn = "Y";
            return;
        }
      	
      	// 상단로그 버전/URL을 db에서 불러온다.
  		var selectListResult = gfn_SQLiteSQLProcess(adminSql.selectSetUpTData, [gShopCd, gPosNo]).Data; // 로컬의 대기화면 version을 조회
      	var voRow = selectListResult[0];
      	var vsLogoUrl = ""; 
      	var vsLogoVer = "";
      	if ( voRow == undefined || voRow == null || voRow.length == 0) {
    	}else{
    		vsLogoUrl = voRow["KIOSK_21_LOGO_IMG_URL"]; 
          	vsLogoVer = voRow["KIOSK_21_LOGO_IMG_VER"];
          	gAspLogoExt = vsLogoUrl.substring(vsLogoUrl.lastIndexOf('.')+1); // DB에 저장되어있는 파일확장자      		
      		sessionStorage.setItem("LOGO_USE_EXT" ,gAspLogoExt); // 유저 로고 확장자를 세션에 담는다.
    	}
      	
      	util.logInfo("***** logoFileDownloadCreateDir vsLogoUrl Local DB ==> " + vsLogoUrl);
      	util.logInfo("***** logoFileDownloadCreateDir vsLogoVer Local DB ==> " + vsLogoVer);
      	
      	if((!!paLogoDownUrl && !!paLogoVersion) || (!!paLogoDownUrl && !paLogoVersion && !!vsLogoUrl) ){ // asp url 있고 asp version있을 때, 또는 asp Url은 있는데 version은 없고 로컬 url이 있을 때는 사용자 로고를 사용한다.
      		util.logInfo("***** logoFileDownloadCreateDir 상단 로고 URL 있음. *****");      		
      		// asp에서 받아온 상단 로그를 사용할지 분기하기 위한 구분자.
      		sessionStorage.setItem("LOGO_USE_YN" ,"Y"); // 사용자 로고 사용여부를 세션에 넣어둔다.(admin과 front화면에서 둘다 사용해야하기 때문에, 세션에 넣어 데이터 양쪽다 사용하도록)
      	}else{
      		util.logInfo("***** logoFileDownloadCreateDir 상단 로고 URL 없음. return *****");
      		var resultData = gfn_SQLiteSQLProcess(adminSql.updateSetUpLogoData , ["", "", gShopCd, gPosNo]);
      		// asp에서 받아온 상단 로그를 사용할지 분기하기 위한 구분자.
      		sessionStorage.setItem("LOGO_USE_YN" ,"N"); // 사용자 로고 사용여부를 세션에 넣어둔다.(admin과 front화면에서 둘다 사용해야하기 때문에, 세션에 넣어 데이터 양쪽다 사용하도록)
      		gvInitLogoImgEndYn = "Y";
      		return;
      	}
      	
      	if(Number(vsLogoVer) >= Number(paLogoVersion)){ // 로컬 버전보다 전문 버전이 높아야만 다운로드를 수행한다.
  			util.logInfo("\n********** logoFileDownloadCreateDir VERSION SAME,  LOCAL VERSION =====> " + vsLogoVer);
  			gvInitLogoImgEndYn = "Y";
  			return;
  		}
      	
      	var vsFileNm = paLogoDownUrl.substring(paLogoDownUrl.lastIndexOf('/')+1); // 파일명
          
      	tizen.filesystem.resolve(this.logoFullPath, function(result) { // successCallback, logoFullPath = "downloads" + "FirstKIOSK/MEDIA/LOGO"
          	util.logInfo("\n<<<======= logoFileDownloadCreateDir Result Start paLogoDownUrl =======>>> " + paLogoDownUrl);
              util.logDebug("\n###################  logoFileDownloadCreateDir result : " + JSON.stringify(result));
              downloadsDir = result;
              if(downloadsDir.isDirectory){
              	util.logInfo("\n###======= logoFileDownloadCreateDir downloadsDir.isDirectory downloadsDir.fullPath=======### " + downloadsDir.fullPath);
                  imagesDownload.logoFileDownload(paLogoDownUrl, downloadsDir.fullPath, vsFileNm, paLogoVersion);
              }else{
              	util.logInfo("\n###======= logoFileDownloadCreateDir else =======###");
                  tizen.filesystem.resolve(downloadPath, function(result) { // downloadPath = "downloads"
                      downloadsDir = result;

                      newDir = downloadsDir.createDirectory(logoFilePath); // logoFilePath = "FirstKIOSK/MEDIA/LOGO"
                      imagesDownload.logoFileDownload(paLogoDownUrl, newDir.fullPath, vsFileNm, paLogoVersion);
                  });
              }
          },
          function(data){ // errorCallback          
              util.logError(" errorCallback logoFileDownloadCreateDir ERROR_Callback : " + JSON.stringify(data));                           
              tizen.filesystem.resolve(downloadPath, function(result) { // downloadPath = "downloads"
              	util.logInfo("\n<<<======= logoFileDownloadCreateDir errorCallback resolve RETRY Start =======>>> " + JSON.stringify(result));
                  downloadsDir = result;

                  newDir = downloadsDir.createDirectory(logoFilePath); // logoFilePath = "FirstKIOSK/MEDIA/LOGO"
                  imagesDownload.logoFileDownload(paLogoDownUrl, newDir.fullPath, vsFileNm, paLogoVersion);
              },
              function(data){
            	gvInitLogoImgEndYn = "Y";
              	util.logInfo("\n<<<======= logoFileDownloadCreateDir errorCallback resolve > ErrorCalback =======>>> " + JSON.stringify(data));
              });
          });

      }catch(e){
    	  gvInitLogoImgEndYn = "Y";
    	  util.logError("[ERROR] logoFileDownloadCreateDir ERROR : " + JSON.stringify(e));          
      }
  },
  
  /** 화면 상단에 사용자 로고이미지를 asp에서 다운받는다. (폴더생성 후 파일을 다운로드하는 함수)
      paLogoDownUrl : 다운로드 url 
  	  paLogoVersion : 서버에서 받아온 다운로드 version(사용자인경우만 존재) 
  **/
  this.logoFileDownload = function(url, path, fileName, version){
  	util.logInfo("\n<<<===== logoFileDownload Start =====>>>");
      if(typeof tizen == "undefined" ){        	
          util.logError("[ERROR] logoFileDownload tizen is no : " + fileName);
          gvInitLogoImgEndYn = "Y";
          return;
      }
      tizen.systeminfo.getPropertyValue('NETWORK', function(networkInfo) {
          if (networkInfo.networkType === 'NONE') {
              util.logError('[ERROR] Network connection is not available.  Download is not possible.');
              gvInitLogoImgEndYn = "Y";
              return;
          }
      });

      // Check if Download API is supported not on a device.
      var download_api_capability = tizen.systeminfo.getCapability("http://tizen.org/feature/download");
      if (download_api_capability === false) {
          util.logError("[ERROR] logoFileDownload Download API is not supported on this device.");
          gvInitLogoImgEndYn = "Y";
          return;
      }

      var listener = {
          oncompleted: function(id, filePath) { // download.start callback
          	try{
          		util.logInfo("\n<<<===== logoFileDownload listener oncompleted start id, filePath =====>>> " + id + ", " + filePath);
              	var vsFileExt = filePath.substring(filePath.lastIndexOf('.')+1); // 파일확장자
              	gAspLogoExt = vsFileExt; // asp에서 새로 받아온 확장자로 교체해준다.
              	sessionStorage.setItem("LOGO_USE_EXT" ,gAspLogoExt); // 유저 로고 확장자를 세션에 담는다.
              	var dirPath = filePath.substr(0, filePath.lastIndexOf('/'));
              	var vsImgVideoFlag = ""; // 이미지인지 동영상인지 여부 (저장할때 업데이트 쿼리 분기를 위해 사용)
              	
      			tizen.filesystem.resolve(dirPath, function(result) { // 사용자로 선택시 asp에서 이미지가 원본파일로 내려오기 때문에 파일명을 변경해준다.(move로 변경처리)
      				util.logInfo("\n********** logoFileDownload File moveTo filesystem.resolve Start ************");
                  	var downloadsDir = result;
                  	var vsMoveTargetPath = "";
                  	vsMoveTargetPath = logoFileUnzipPath + "/" + "userLogo." + vsFileExt; // 유저가 올린 로고파일은 userLogo.확장자 통일시킨다.
                  	util.logInfo("\n********** logoFileDownload File moveTo filesystem.resolve filePath, vsMoveTargetPath : " + filePath + ", " +vsMoveTargetPath);                  	              	
                  	
                  	// moveTo : 대상파일경로, 이동할 경로, overwrite boolean, success callback, error callback
                      downloadsDir.moveTo(filePath, vsMoveTargetPath, true,
                          function(){
                    	  	  util.logInfo("\n********** logoFileDownload File moveTo Complete MoveTargetPath : " + vsMoveTargetPath); 
                    	  	  // 최종적으로 다운로드 작업이 끝나면 DB에 다운받은 정보를 저장한다.
                    	  	  var resultData = gfn_SQLiteSQLProcess(adminSql.updateSetUpLogoData , [version, url, gShopCd, gPosNo]);
                    	  	  sessionStorage.setItem("LOGO_URL" ,url); // 사용자 로고 URL
                    	  	  sessionStorage.setItem("LOGO_VERSION" ,version); // 사용자 로고 VERSION
                    	  	  gvInitLogoImgEndYn = "Y";
                          },
                          function(e) {
                              util.logError("\n**********[ERROR] logoFileDownload File moveTo Error " + e.toString());
                              util.logInfo("\n********** logoFileDownload File moveTo ERROR MoveTargetPath : " + vsMoveTargetPath);
                              gvInitLogoImgEndYn = "Y";
                          }
                      );
      			},
                function(data){ // errorCallback 
      				gvInitLogoImgEndYn = "Y";
                    util.logError(" errorCallback logoFileDownload Resolve ERROR_Callback : " + JSON.stringify(data));
                });
          		
          	}catch(e){
          		gvInitLogoImgEndYn = "Y";
          		util.logError("\n********** logoFileDownload listener oncompleted Catch " + e.toString());
          	}
          },
          onfailed: function(id, error) {
        	  gvInitLogoImgEndYn = "Y";
              util.logError('[ERROR] logoFileDownload tizen.download fail with id: ' + id + ', error name: ' + JSON.stringify(error));
              return;
          }
      };
      util.logInfo("tizen.download url=====>>> " + url);
      util.logInfo("tizen.download path=====>>> " + path);
      util.logInfo("tizen.download fileName =====>>> " +fileName);
      try{
      	  var downloadRequest = new tizen.DownloadRequest(url, path, fileName);
          var downloadId = tizen.download.start(downloadRequest, listener);
      }catch(e){
    	  gvInitLogoImgEndYn = "Y";
      	util.logError("\n**********logoFileDownload Catch " + e.toString());
      }
  },
  
  this.cornerImageDownloadCreateDir = function(){

      var downloadsDir, newDir;
      var imgList = gfn_SQLiteSQLProcess(adminSql.selectConerImgUrl , [gShopCd]).Data;

      util.logInfo("###################   cornerImageDownloadCreateDir  start time : " + moment().format("YYYY-MM-DD HH:mm:ss") + ",  imgList : " + JSON.stringify(imgList));

      if(imgList == null){
          return false;
      }

      if(imgList.length > 0){
          try{
              tizen.filesystem.resolve(imagesDownload.fullPathCorner, function(result) {
              	util.logInfo("###################  cornerImageDownloadCreateDir tizen.filesystem func11 ##########");
              	util.logDebug("###################  cornerImageDownloadCreateDir result : " + JSON.stringify(result));
                  downloadsDir = result;

                  if(downloadsDir.isDirectory){
                      imagesDownload.cornerImageDownload(downloadsDir.fullPath, imgList);
                  }else{
                      tizen.filesystem.resolve(downloadPath, function(result) {
                          downloadsDir = result;

                          newDir = downloadsDir.createDirectory(cornerImgPath);
                         //util.log("###################  productImageDownload newFile : " + JSON.stringify(newDir));
                          imagesDownload.cornerImageDownload(newDir.fullPath, imgList);
                      });
                  }
              },
              function(data){
              	util.logInfo("###################  productImageDownloadCreateDir tizen.filesystem func22 ##########");
                  util.logDebug("###################  productImageDownload data : " + JSON.stringify(data));

                  tizen.filesystem.resolve(downloadPath, function(result) {
                      downloadsDir = result;

                      newDir = downloadsDir.createDirectory(cornerImgPath);
                      //util.log("###################  productImageDownload newFile : " + JSON.stringify(newDir));
                      imagesDownload.cornerImageDownload(newDir.fullPath, imgList);
                  });
              });

          }catch(e){
              util.logError("***************  productImageDownload ERROR : " + JSON.stringify(e));
              //imagesDownload.productImageDownload();
          }
      }

      var delayTime = 20000 + imgList.length * 200;

      util.logInfo("***************  productImageDownloadDeleteDelay setTimeout : " + delayTime);
      //setTimeout(imagesDownload.productImageDownloadDeleteDelay, delayTime, imgList);
      setTimeout(imagesDownload.cornerImageDownloadDeleteCheck, delayTime, imgList);

  }
  
  this.fnCornerSetImgFullPath = function(item){

      var imageUrl = item["IMG_URL"];
      var extension = imageUrl.substring(imageUrl.lastIndexOf('.'));
      var fileName = item["SHOP_CD"] + "_" + item["CORNER_CD"] + extension;
      item.extension = extension;

      return {"fileName" : fileName, "imageUrl" : imageUrl, "item" : item };

  },

  this.cornerImageDownload = async function(fullPath, imgList){

      try{
      	var vsCnt = imgList.length;
      	util.logInfo("*****cornerImageDownload Img Download Total Count == > " + vsCnt);
          for(var i=0; vsCnt > i ; i++){
              var item = imgList[i];
              var pathResult = imagesDownload.fnCornerSetImgFullPath(item);
              imagesDownload.imageDownloadForCorner(pathResult.imageUrl, fullPath, pathResult.fileName, pathResult.item);

              // 5% 진행 시 마다 로그 남김.
              if(parseInt((i+1)/vsCnt*100)%5 == 0 ){
                  util.logInfo("*****cornerImageDownload Img Download Progress Count == > " + (i+1));
                  util.logInfo("*****cornerImageDownload Img Download Progress Count Percent == >> [" + parseInt((i+1)/vsCnt*100) + "]%"); // 현재 진행 퍼센테이지	
              }            
              
              if(i != 0 && i%30 == 0){
                  util.logInfo("cornerImageDownload   i : " + i);                
                  util.logInfo("cornerImageDownload   before time : " + moment().format("YYYY-MM-DD HH:mm:ss"));
                  await util.sleepUtil(5000);
                  util.logInfo("cornerImageDownload   after time : " + moment().format("YYYY-MM-DD HH:mm:ss"));
              }
          }
      }catch(er){
          util.log("productImageDownload   er : " + er);
      }
  },
  
  this.imageDownloadForCorner = function(url, path, fileName, cornerInfo){
  
	  if(typeof tizen == "undefined" ){
          util.logInfo("downTest imageDownload tizen is no : " + fileName);
          if(progressDelYn == "Y"){
 				util.logInfo("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! waitingFileDownload typeof tizen == undefined progress end !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
 				imagesDownload.waitingFileProgressDel(progressDelYn); // 프로그레스바 제거 및 완료메시지   				
  		}
          return;
      }
      tizen.systeminfo.getPropertyValue('NETWORK', function(networkInfo) {
          if (networkInfo.networkType === 'NONE') {
              util.logError('downTest connection is not available.  Download is not possible.');
              return;
          }
      });

      // Check if Download API is supported not on a device.
      var download_api_capability = tizen.systeminfo.getCapability("http://tizen.org/feature/download");
      if (download_api_capability === false) {
          util.Error("downTest Download API is not supported on this device.");
          return;
      }

      var listener = {
          oncompleted: function(id, filePath) {
              var result = gfn_SQLiteSQLProcess(adminSql.updateConerImgUrl , [filePath, gShopCd, cornerInfo.CORNER_CD]);
              util.Info('*****downTest Completed with id: ' + id + ', filePath: ' + filePath + ', cornerInfo :' + JSON.stringify(cornerInfo));
          },
          onfailed: function(id, error) {
              util.log('downTest Failed with id: ' + id + ', error name: ' + JSON.stringify(error));
          }
      };

      var downloadRequest = new tizen.DownloadRequest(url, path, fileName);
      var downloadId = tizen.download.start(downloadRequest, listener);
  },
  
  this.cornerImageDownloadDeleteCheck = function(item){
      util.logInfo("***************  cornerImageDownloadDeleteCheck Start #################");
      var imgList = gfn_SQLiteSQLProcess(adminSql.selectConerImgUrlCheck , [gShopCd]).Data;
      if(!util.isEmpty(imgList)){
          for(var i=0; imgList.length > i ; i++){
              var imgObj = imgList[i];

              var imgUrl = imgObj.IMG_URL;
              var fileName = imgUrl.substring(imgUrl.lastIndexOf('/'));
              var checkName = imgObj.SHOP_CD + "_" + imgObj.PROD_CD;

              util.logInfo("***************  cornerImageDownloadDeleteCheck fileName : " + fileName);

              imagesDownload.cornerImageDownloadDelete(fileName, checkName);
          }
      }

  },
  
  this.cornerImageDownloadDelete = function(fileName, checkName){
      util.logInfo("***************  cornerImageDownloadDelete Start ***************" );
      try{
          tizen.filesystem.resolve(imagesDownload.fullPathCorner, function(result) {
              var downloadsDir = result;

              if(downloadsDir.isDirectory){
                  downloadsDir.listFiles(
                      function(files){
                          for(var j=0; files.length > j ; j++){

                              if (files[j].isFile) {

                                  var fileFullPath = files[j].fullPath;

                                  if(fileFullPath.indexOf(checkName) != -1 && fileFullPath.indexOf(fileName) == -1){

                                      //util.log("########fnListFiles files : " + JSON.stringify(files[j]));

                                      util.logInfo("File check fileFullPath : " + fileFullPath + ",  :" +checkName + ", : " + fileName);

                                      downloadsDir.deleteFile(fileFullPath,
                                      function(){
                                      	util.logInfo("***************  cornerImageDownloadDelete deleteFile fnc11 ***************" );
                                          //util.log("@@@@@@@@@@@@@File Deleted fileFullPath : " + fileFullPath);
                                      },
                                      function(e) {
                                      	util.logInfo("***************  cornerImageDownloadDelete deleteFile fnc22 ***************" );
                                          util.logError("*************Error " + e.message);
                                      });


                                  }
                              }
                          }
                      }
                  );
              }
          });
      }catch(er){
          util.logError("###################  cornerImageDownloadDelete Catch er : " + JSON.stringify(er));
      }
  }
  
}