var AxiosCommon = function(){

    this.config = {
        headers: {'Content-Type': 'text/xml'}
        , timeout : 12000
    };

    this.axiosJsonPost2 = function(targetUrl, paramsObj, callbackFunc, row){

        var x2js = new X2JS();

        var xmlParam = x2js.json2xml_str(paramsObj);
        var postUrl = aspUrl + targetUrl;

        util.logInfo("postUrl :" + postUrl);

        util.logInfo("xmlParam :" + xmlParam);

        axios.post(postUrl, xmlParam, this.config)
        .then(res => {
            //console.log("axiosJsonPost res  :" , res);
            //console.log("axiosJsonPost data  :" + res.data);

            var jsonData = x2js.xml_str2json(res.data);

            //console.log("axiosJsonPost stringify data  :" + JSON.stringify(jsonData));

            callbackFunc(jsonData, row);

        })
        .catch((ex) => {
            util.logError("[ERROR] axiosJsonPost ex :"+ex.toString());
            //callbackFunc(ex);
        });
    },

    this.axiosJsonPost = async function(targetUrl, params) {
        var x2js = new X2JS();
        var xmlParam = x2js.json2xml_str(params);

        var postUrl = aspUrl + targetUrl;
        try{
            var data = await axios.post(postUrl, xmlParam, this.config);
            util.log("axiosJsonPost url :" + postUrl);
            util.log("axiosJsonPost xmlParam :" + xmlParam);
            util.log("axiosJsonPost data :" + JSON.stringify(data));
            var jsonData = x2js.xml_str2json(data.data);
        } catch (er) {
            util.logError("[ERROR] axiosJsonPost er : " +  er.toString());
        }
        return jsonData;

    },

    this.syncAjaxPost = function(targetUrl, paramsObj, serverUrl){

        var x2js = new X2JS();

        var xmlParam = x2js.json2xml_str(paramsObj);
        var hostUrl = aspUrl;
        if ( typeof tizen != "undefined") {
        	hostUrl = apiUrl;
        }
        
        // 리얼서버를 받아서 테스트 할 때 ASP전송은 하지 않기 위한 FLAG. 오류 수정 후 확인시에 사용하기 위함이다.
        if(ASP_SEND_YN == "N"){
			return false;
		}
        var postUrl = "";

        util.logDebug("syncAjaxPost serverUrl : " +  serverUrl + ", targetUrl : " + targetUrl);
        if(!util.isEmptyStr(serverUrl)){
            postUrl = serverUrl + targetUrl;
        }else{
            postUrl = hostUrl + targetUrl;
        }
        var result;

        //postUrl = apiurl + targetUrl + "?" + JSON.stringify(xmlParam);

        util.logDebug("postUrl :: " + postUrl);

        util.logDebug("xmlParam :::: " + xmlParam);
        
        $.ajax({
            type : "POST",
            url: postUrl,
            data: xmlParam,
            contentType : "xml",
            dataType : "text",
            async: false,
            success: function(res) {
                util.logDebug('SUCCESS callback -->> '+  res);
            	var parser = new DOMParser();

                //프린트 출력폼에서는 개행문자가 들어가야 한다.
                if ( res.indexOf("MS051") != -1  && res.indexOf("SCD_PRINT_T") != -1 ) {
                	//res = '<?xml version="1.0"?>'
                	//+'\n<TSP-NVP><TXJM-FD DATA_CNT="35" MAX_SEQ="479550016" RETCD="0000" RETMSG="" ROWNUM="5000" SRID="MS051" TABLE_NAME="SCD_PRINT_T"><DATA-HD LAST_YN="Y" POS_NO="04" SHOP_CD="062170"><DATA-DT INS_ID="SHOPM_R01" NUMBER="1" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="01" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{재발행여부}{FONT1}{/:C}{CRLF}&#xA;[매장명] {상호}&#xA;[사업자] {사업자}&#xA;[주  소] {주소}&#xA;[대표자] {대표자}  [TEL] {전화번호}&#xA;[매출일] {매출시간}     &#xA;[영수증] {영수증번호}&#xA;주문번호: {주문번호}&#xA;주문서일련{주문서일련번호}&#xA;교환번호{교환번호}&#xA;포명 {포스명칭}&#xA;==========================================&#xA;{상품리스트2}&#xA;------------------------------------------&#xA;{세액}&#xA;------------------------------------------&#xA;{합계금액}&#xA;{할인금액}&#xA;------------------------------------------&#xA;{결제리스트}&#xA;------------------------------------------&#xA;{포스명칭}&#xA;{신용카드}&#xA;{현금영수증}&#xA;{회원정보}&#xA;{OKCASHBAG}&#xA;{상품권정보}&#xA;{식권정보}&#xA;{재출력}&#xA;{CUT}" RANK="1" SEND_SEQ="479549982" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="2" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="02" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{FONT1}{/:C}{CRLF}&#xA;[영수증] {영수증번호}&#xA;==========================================가 맹 점 명: {상호}&#xA;대 표 자 명: {대표자}&#xA;사업자 번호: {사업자}&#xA;전 화 번 호: {전화번호}&#xA;주 소: {주소}&#xA;==========================================&#xA;{별도-신용승인전표-내역}&#xA;{별도-신용승인전표-합계}&#xA;{SIGN}&#xA;발 행 일 시: {DATETIME}  {POSNO}-{계산원}&#xA;{CUT}" RANK="2" SEND_SEQ="479549983" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="3" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="03" PRT_FORM="{:C42}{FONT2}{타이틀}{FONT1}{/:C}{CRLF}&#xA;[테이블] {테이블표기} [손님수] {손님수}&#xA;[주문자] {주문자}     [주문번호] {주문번호}&#xA;==========================================&#xA;{이전차수-메뉴목록}&#xA;{주문서-메뉴출력형태1}&#xA;------------------------------------------&#xA;{배달전화번호}&#xA;{배달지주소}&#xA;==========================================&#xA;POS:{POSNO}      [주문시간] {DATETIME}&#xA;&#xA;{CUT}" RANK="3" SEND_SEQ="479549984" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="4" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="04" PRT_FORM="{:C42}{FONT2}{타이틀}{재발행여부}{FONT1}{/:C}&#xA;[테이블] {테이블표기} [손님수] {손님수}&#xA;[주문자] {주문자}       [주문번호] {주문번호}&#xA;[주문서일련번호]{FONT2} {주문서일련번호}{FONT1}&#xA;주문번호: {주문번호}&#xA;주문서일련{주문서일련번호}&#xA;교환번호{교환번호}&#xA;==========================================&#xA;{주문서-메뉴출력형태1}&#xA;------------------------------------------&#xA;{주방메모}&#xA;------------------------------------------&#xA;{배달전화번호}&#xA;{배달지주소}&#xA;==========================================&#xA;POS:{POSNO}      [주문시간] {DATETIME}&#xA;{CUT}" RANK="4" SEND_SEQ="479549985" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="5" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="05" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}[중간계산서]{FONT1}{/:C}{CRLF}&#xA;[테 이 블] {테이블표기}&#xA;[발행일시] {DATETIME}    [POS] {POSNO}&#xA;==========================================&#xA;{중간계산서-메뉴목록}&#xA;------------------------------------------&#xA;{합계금액}&#xA;{할인금액}&#xA;------------------------------------------&#xA;{세액}&#xA;------------------------------------------&#xA;{받을금액}&#xA;{받은금액}&#xA;------------------------------------------&#xA;{배달정보}&#xA;&#xA;{CUT}" RANK="5" SEND_SEQ="479549986" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="6" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="06" PRT_FORM="{:C42}{FONT2}[대기-교환권]{FONT1}{/:C}{CRLF}&#xA;[대기번호] {교환번호}&#xA;[코 너 명] {코너명}&#xA;[발행일시] {DATETIME}&#xA;==========================================&#xA;{코너별-메뉴목록}&#xA;------------------------------------------&#xA;POS:{POSNO}-{계산원}       [{영수증번호}]&#xA;&#xA;{:C42}{FONT2}[대기번호] {교환번호}{FONT1}{/:C}&#xA;&#xA;{CUT}" RANK="6" SEND_SEQ="479549987" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="7" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="07" PRT_FORM="{:C42}{FONT2}{타이틀}{FONT1}{/:C}&#xA;&#xA;[이동시간] {DATETIME}&#xA;==========================================&#xA;{테이블이동}&#xA;{테이블메뉴이동}&#xA;==========================================&#xA;POS:{POSNO}                    [{주문번호}]{주문자}1&#xA;&#xA;{CUT}" RANK="7" SEND_SEQ="479549988" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="8" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="08" PRT_FORM="{:C42}{FONT2}[중간정산서]{FONT1}{/:C}{CRLF}&#xA;&#xA;[영업일자] {영업일자}&#xA;[포스번호] {POSNO}번 POS&#xA;[정 산 원] {정산원} - {정산차수}&#xA;[개점일시] {개점시간}&#xA;[정산일시] {정산시간}&#xA;==========================================&#xA;{매출합계}&#xA;{결제수단별매출내역}&#xA;{할인매출내역}&#xA;{현금시재입력내역}&#xA;{현금정산액}&#xA;{신용카드정산내역}&#xA;{카드사별매출내역}&#xA;{회원포인트내역}&#xA;{상품권시재내역}&#xA;{비매출정산내역}&#xA;&#xA;{매출상품권내역}&#xA;&#xA;{비매출상품권내역}&#xA;&#xA;[발행일시] {DATETIME}&#xA;&#xA;{CUT}" RANK="8" SEND_SEQ="479549989" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="9" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="09" PRT_FORM="{:C42}{FONT2}[마감정산서]{FONT1}{/:C}{CRLF}&#xA;&#xA;[영업일자] {영업일자}&#xA;[포스번호] {POSNO}번 POS&#xA;[정 산 원] {정산원}&#xA;[개점일시] {개점시간}&#xA;[정산일시] {정산시간}&#xA;==========================================&#xA;{매출합계}&#xA;{결제수단별매출내역}&#xA;{할인매출내역}&#xA;{현금시재입력내역}&#xA;{현금정산액}&#xA;{신용카드정산내역}&#xA;{카드사별매출내역}&#xA;{회원포인트내역}&#xA;{상품권시재내역}비매출정산내역&#xA;{비매출정산내역}&#xA;&#xA;{매출상품권내역}&#xA;&#xA;{비매출상품권내역}&#xA;&#xA;[발행일시] {DATETIME}&#xA;&#xA;{CUT}" RANK="9" SEND_SEQ="479549990" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="10" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="10" PRT_FORM="{LOG}&#xA;{:C42}{FONT4}영수증{FONT1}{/:C}{CRLF}&#xA;[매장명] {상호}&#xA;[사업자] {사업자}&#xA;[주  소] {주소}&#xA;[대표자] {대표자}   {:R20}[TEL] {전화번호}{/:R}&#xA;[매출일] {DATETIME}     {POSNO}-{계산원}&#xA;==========================================&#xA;{비매출상품}&#xA;==========================================&#xA;{비매출합계금액}&#xA;------------------------------------------&#xA;{FONT2}{비매출받을금액}&#xA;{FONT2}{비매출받은금액}&#xA;{FONT2}{비매출거스름돈}{FONT1}&#xA;{CUT}" RANK="10" SEND_SEQ="479549991" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="11" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="11" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{FONT1}{/:C}{CRLF}&#xA;[영수증] {영수증번호}&#xA;------------------------------------------&#xA;가 맹 점 명: {상호}&#xA;대 표 자 명: {대표자}&#xA;사업자 번호: {사업자}&#xA;전 화 번 호: {전화번호}&#xA;주       소: {주소}&#xA;------------------------------------------&#xA;{별도-신용승인전표-내역}&#xA;{SIGN}&#xA;발행일시: {DATETIME} {POSNO}-{계산원}&#xA;&#xA;{CUT}" RANK="11" SEND_SEQ="479549992" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="12" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="12" PRT_FORM="{:C42}{FONT2}{타이틀}{FONT1}{/:C}{CRLF}&#xA;[영수증] {영수증번호}&#xA;------------------------------------------&#xA;가 맹 점 명: {상호}&#xA;대 표 자 명: {대표자}&#xA;사업자 번호: {사업자}&#xA;전 화 번 호: {전화번호}&#xA;주       소: {주소}&#xA;------------------------------------------&#xA;{별도-신용승인전표-내역}&#xA;{SIGN}&#xA;발행일시: {DATETIME} {POSNO}-{계산원}&#xA;&#xA;{CUT}" RANK="12" SEND_SEQ="479549993" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="13" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="13" PRT_FORM="{:C42}{FONT2}{타이틀}{FONT1}{/:C}&#xA;&#xA;[매 장 명] {상호}&#xA;[영업일자] {영업일자}&#xA;[POS 번호] {POSNO} - {정산차수}      [판매원] {계산원}&#xA;==========================================&#xA;{시재점검}&#xA;==========================================&#xA;{기타출력}&#xA;[발행일시] {DATETIME}   &#xA;&#xA;{CUT}" RANK="13" SEND_SEQ="479549994" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="14" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="14" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{재발행여부}{FONT1}{/:C}{CRLF}&#xA;[매장명] {상호}&#xA;[사업자] {사업자}&#xA;[주  소] {주소}&#xA;[대표자] {대표자}     {:R20}[TEL] {전화번호}{/:R}&#xA;==========================================&#xA;{중간계산서-메뉴목록}&#xA;------------------------------------------&#xA;{합계금액}&#xA;{할인금액}&#xA;------------------------------------------&#xA;{세액}&#xA;------------------------------------------&#xA;{받을금액}&#xA;------------------------------------------&#xA;{배달정보}&#xA;------------------------------------------&#xA;{현금영수증}&#xA;[발행일]{DATETIME}    [{POSNO}-{계산원}]&#xA;&#xA;{재출력}&#xA;{CUT}" RANK="14" SEND_SEQ="479549995" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="15" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="15" PRT_FORM="{:C42}{FONT2}{타이틀}{재발행여부}{FONT1}{/:C}&#xA;&#xA;{배달정보}&#xA;==========================================&#xA;{중간계산서-메뉴목록}&#xA;------------------------------------------&#xA;{합계금액}&#xA;{할인금액}&#xA;------------------------------------------&#xA;{받을금액}&#xA;------------------------------------------&#xA;[배달원] {배달원명}&#xA;[발행일] {DATETIME}&#xA;&#xA;{재출력}&#xA;{CUT}" RANK="15" SEND_SEQ="479549996" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="16" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="16" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{FONT1}{/:C}{CRLF}&#xA;{FONT2}[테이블] {테이블표기}  [주문번호]{주문번호}&#xA;[발행일시] {DATETIME}    [POS] {POSNO}{FONT1}&#xA;==========================================&#xA;{중간계산서-메뉴목록}&#xA;------------------------------------------&#xA;{합계금액}&#xA;{할인금액}&#xA;------------------------------------------&#xA;&#xA;{CUT}" RANK="16" SEND_SEQ="479549997" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="17" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="21" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}현금영수증{FONT1}{/:C}{CRLF}&#xA;[매장명] {상호}&#xA;[사업자] {사업자}&#xA;[주  소] {주소}&#xA;[대표자] {대표자}     {:R20}[TEL] {전화번호}{/:R}&#xA;[발행일] {DATETIME}     {POSNO}-{계산원}&#xA;==========================================&#xA;{현금영수증}&#xA;&#xA;[발행일]{DATETIME}    [{POSNO}-{계산원}]&#xA;&#xA;{CUT}" RANK="17" SEND_SEQ="479549998" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="18" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="22" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{재발행여부}{FONT1}{/:C}{CRLF}&#xA;[매장명] {상호}&#xA;[사업자] {사업자}&#xA;[주  소] {주소}&#xA;[대표자] {대표자}     {:R20}[TEL] {전화번호}{/:R}&#xA;[매출일] {비매출매출시간} {POSNO}-{계산원}&#xA;==========================================&#xA;{비매출상품리스트}&#xA;------------------------------------------&#xA;{비매출합계금액}&#xA;{비매출할인금액}&#xA;------------------------------------------&#xA;{비매출받을금액}&#xA;{비매출받은금액}&#xA;{비매출거스름돈}&#xA;------------------------------------------{비매출결제리스트}&#xA;&#xA;* 물품반품시 본 영수증을 필히 지참하여&#xA;  주시기 바랍니다. &#xA;&#xA;{재출력}&#xA;{CUT}" RANK="18" SEND_SEQ="479549999" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="19" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="31" PRT_FORM="{FONT2}상품분류별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-상품분류-소}&#xA;출력일시 : {DATETIME}&#xA;&#xA;&#xA;{CUT}" RANK="19" SEND_SEQ="479550000" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="20" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="32" PRT_FORM="{FONT2}상품별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-상품별}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="20" SEND_SEQ="479550001" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="21" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="33" PRT_FORM="{FONT2}결제수단별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-결제수단별}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="21" SEND_SEQ="479550002" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="22" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="34" PRT_FORM="{FONT2}할인유형별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-할인유형별}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="22" SEND_SEQ="479550003" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="23" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="35" PRT_FORM="{FONT2}일자별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-일자별}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="23" SEND_SEQ="479550004" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="24" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="36" PRT_FORM="{FONT2}시재입출금 내역{FONT1}&#xA;&#xA;조회일자 : {조회일자}&#xA;포스번호 : {POSNO}&#xA;정산차수 : {정산차수}&#xA;&#xA;{시재입출금내역}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="24" SEND_SEQ="479550005" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="25" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="37" PRT_FORM="{FONT2}[기간별정산서]{FONT1}&#xA;&#xA;[조회기간] {조회기간}&#xA;[포스번호] {POSNO}번 POS&#xA;[정산차수] {정산번호}&#xA;------------------------------------------&#xA;{매출합계}&#xA;{결제수단별매출내역}&#xA;{할인매출내역}&#xA;{일반할인내역}&#xA;{포장할인내역}&#xA;{쿠폰할인내역}&#xA;{현금시재입력내역}&#xA;{현금정산액}&#xA;{신용카드정산내역}&#xA;{카드사별매출내역}&#xA;{신용카드승인내역}&#xA;{회원포인트내역}&#xA;{상품권시재내역}&#xA;{비매출정산내역}&#xA;{매장-배달매출내역}&#xA;&#xA;{매출상품권내역}&#xA;&#xA;{비매출상품권내역}&#xA;&#xA;[발행일시] {DATETIME}&#xA;&#xA;{CUT}" RANK="25" SEND_SEQ="479550006" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="26" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="38" PRT_FORM="{FONT2}시간대별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-시간대별}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="26" SEND_SEQ="479550007" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="27" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="40" PRT_FORM="         {FONT2}영수증별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-영수증별}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="27" SEND_SEQ="479550008" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="28" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="41" PRT_FORM="{상호}&#xA;등록번호:{사업자} 대표:{대표자}&#xA;{주소}&#xA;TEL:{전화번호}&#xA;[ {코너명} ][ {여행사명} ]&#xA;NO:{영수증번호} 담당자:{계산원}&#xA;==========================================&#xA;{FONT3}{타이틀}{FONT1}&#xA;==========================================&#xA;{이용권내역}&#xA;------------------------------------------&#xA;본권은 대기실에서 구명조끼로 교환하여 주세요.&#xA;가--11111&#xA;&#xA;&#xA;&#xA;{CUT}" RANK="28" SEND_SEQ="479550009" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="29" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="42" PRT_FORM="{상호}&#xA;등록번호:{사업자} 대표:{대표자}&#xA;{주소}&#xA;TEL:{전화번호}&#xA;NO:{전표번호} 담당자:{계산원}&#xA;==========================================&#xA;{FONT3}{타이틀}{FONT1}&#xA;==========================================&#xA;{수수료내역}&#xA;------------------------------------------&#xA;{수수료합계}&#xA;------------------------------------------&#xA;{기사정보}&#xA;&#xA;지급영수증번호: {영수증번호}&#xA;&#xA;{CUT}" RANK="29" SEND_SEQ="479550010" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="30" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="43" PRT_FORM="{CENTER}{FONT4}코너별정산서{FONT1}{LEFT}&#xA;&#xA;[영업일자] {영업일자}&#xA;[포스번호] {POSNO}번 POS&#xA;[정 산 원] {정산원}&#xA;[개점일시] {개점시간}&#xA;[정산일시] {정산시간}&#xA;==========================================&#xA;{매출합계}&#xA;{할인매출내역}&#xA;{결제수단별매출내역}&#xA;{주문취소내역}&#xA;&#xA;[발행일시] {DATETIME}&#xA;&#xA;{CUT}" RANK="30" SEND_SEQ="479550011" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="31" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="44" PRT_FORM="{FONT2}승인별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-승인별}&#xA;출력일시 : {DATETIME}&#xA;&#xA;&#xA;{CUT}" RANK="31" SEND_SEQ="479550012" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="32" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="91" PRT_FORM="{CENTER}&#xA;{FONT4}대기번호표&#xA;&#xA;{대기표번호}{FONT1}&#xA;&#xA;[출력시간] {DATETIME}&#xA;&#xA;*** 잠시만 기다려 주십시요 ***&#xA;&#xA;예약인원: {대기인원} 명&#xA;&#xA;{대기메모}&#xA;&#xA;[{상호}]&#xA;{LEFT}&#xA;&#xA;&#xA;&#xA;&#xA;{CUT}" RANK="32" SEND_SEQ="479550013" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="33" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="92" PRT_FORM="{:C42}{FONT2}PreOrder 주문서{FONT1}{/:C}{CRLF}&#xA;[출력시간] {DATETIME}&#xA;[매장명]   {상호}&#xA;&#xA;{PreOrder주문내역}&#xA;&#xA;{CUT}" RANK="33" SEND_SEQ="479550014" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="34" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="93" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{재발행여부}{FONT1}{/:C}{CRLF}&#xA;[매장명] {상호}/{사업자}&#xA;[주  소] {주소}&#xA;[대표자] {대표자}  [TEL] {전화번호}&#xA;[매출일] {매출시간}&#xA;[영수증] {영수증번호}&#xA;          주문번호{음영}{FONT4}{K-주문번호}{FONT1}{음영일반}&#xA;{K-주문형태}&#xA;==========================================&#xA;{K-상품리스트}&#xA;------------------------------------------&#xA;{합계금액}&#xA;{할인금액}&#xA;------------------------------------------&#xA;{세액}&#xA;------------------------------------------&#xA;{R받은금액}&#xA;------------------------------------------&#xA;{결제리스트}&#xA;------------------------------------------&#xA;{R신용카드}&#xA;{회원정보}&#xA;{모바일내역}&#xA;{재출력}&#xA;{CUT}" RANK="34" SEND_SEQ="479550015" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="35" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="94" PRT_FORM="{:C42}{FONT2}[KIOSK-교환권]{FONT1}{/:C}{CRLF}&#xA;{:C42}주문번호{FONT4}{음영}{K-주문번호}{음영일반}{FONT1}{/:C}&#xA;==========================================&#xA;{K-상품리스트}&#xA;------------------------------------------&#xA;주문형태-{K-주문형태}           [{영수증번호}]&#xA;[발행일시] {DATETIME}      POS:{POSNO}&#xA;{CUT}" RANK="35" SEND_SEQ="479550016" SHOP_CD="062170" UPD_ID="SHOPM_R01"/></DATA-HD></TXJM-FD></TSP-NVP>'
                	res = res.trim();
                	res = res.replace(/\n\/\>/gi , "@CRLF@");
                	res = res.replace(/>\n/gi , ">");
                	res = res.replace(/\n</gi , "<");
                	res = res.replace(/\n/gi , "@CR@");
                	res = res.replace(/@CRLF@/gi , "\n/>");
                	res = res.replace(/&#xA;/gi , "@CR@");
                	util.logDebug("***** regular after res ===> " +res);
                }
                
            	var xmlData = parser.parseFromString(res,"text/xml");
            	util.logDebug("***** xmlData=== " +xmlData);
                xmlData = $(xmlData).find("TSP-NVP")[0];
            	util.logDebug("***** xd 2 " +  xmlData)
	            result = x2js.xml_str2json( (new XMLSerializer()).serializeToString(xmlData) );

                util.logDebug(" axiosJsonPost stringify data  : " + JSON.stringify( result ));

            },
            error: function(xhr, status, error) {
            	util.logError("xhr1 == > " + JSON.stringify(xhr));
            	util.logError("status == > " + status.toString());
            	util.logError("error == > " + error.toString());
            	util.logError("xmlParam of error == > " + xmlParam);
            	//if(status == "timeout"){ // 위에 설정한 30초 타임아웃 발생시
				//	var vsTimeoutMsg = util.languageObjReturn(langCode,  "timeoutMsg"); // 서버와의 통신이 원활하지 않습니다. 인터넷을 확인해 주세요.
					//alert(vsTimeoutMsg);
				//}else{
				//	util.logError('[ERROR] syncAjaxPost error --> '+ error.toString());
				//}            	
                
            }
        });
        
        return result;
    }
    
    
    this.asyncAjaxPost = function(targetUrl, paramsObj, callbackFunc, row){
    	util.logInfo("***** asyncAjaxPost START *****");
        var x2js = new X2JS();

        var xmlParam = x2js.json2xml_str(paramsObj);
        var hostUrl = aspUrl;
        if ( typeof tizen != "undefined") {
        	hostUrl = apiUrl;
        }
        
        // 리얼서버를 받아서 테스트 할 때 ASP전송은 하지 않기 위한 FLAG. 오류 수정 후 확인시에 사용하기 위함이다.
        if(ASP_SEND_YN == "N"){
			return false;
		}
        
        var postUrl = hostUrl + targetUrl;
        var result;

        //postUrl = apiurl + targetUrl + "?" + JSON.stringify(xmlParam);

        util.logInfo("postUrl :: " + postUrl);

        util.logInfo("xmlParam ::: " + xmlParam);
        
        $.ajax({
            type : "POST",
            url: postUrl,
            data: xmlParam,
            contentType : "xml",
            dataType : "text",
            timeout : 7000,
            async: true,
            success: function(res) {
            	util.logInfo("***** asyncAjaxPost success *****");
                util.logDebug('SUCCESS callback -->> '+  res);
            	var parser = new DOMParser();

                //프린트 출력폼에서는 개행문자가 들어가야 한다.
                if ( res.indexOf("MS051") != -1  && res.indexOf("SCD_PRINT_T") != -1 ) {
                	//res = '<?xml version="1.0"?>'
                	//+'\n<TSP-NVP><TXJM-FD DATA_CNT="35" MAX_SEQ="479550016" RETCD="0000" RETMSG="" ROWNUM="5000" SRID="MS051" TABLE_NAME="SCD_PRINT_T"><DATA-HD LAST_YN="Y" POS_NO="04" SHOP_CD="062170"><DATA-DT INS_ID="SHOPM_R01" NUMBER="1" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="01" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{재발행여부}{FONT1}{/:C}{CRLF}&#xA;[매장명] {상호}&#xA;[사업자] {사업자}&#xA;[주  소] {주소}&#xA;[대표자] {대표자}  [TEL] {전화번호}&#xA;[매출일] {매출시간}     &#xA;[영수증] {영수증번호}&#xA;주문번호: {주문번호}&#xA;주문서일련{주문서일련번호}&#xA;교환번호{교환번호}&#xA;포명 {포스명칭}&#xA;==========================================&#xA;{상품리스트2}&#xA;------------------------------------------&#xA;{세액}&#xA;------------------------------------------&#xA;{합계금액}&#xA;{할인금액}&#xA;------------------------------------------&#xA;{결제리스트}&#xA;------------------------------------------&#xA;{포스명칭}&#xA;{신용카드}&#xA;{현금영수증}&#xA;{회원정보}&#xA;{OKCASHBAG}&#xA;{상품권정보}&#xA;{식권정보}&#xA;{재출력}&#xA;{CUT}" RANK="1" SEND_SEQ="479549982" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="2" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="02" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{FONT1}{/:C}{CRLF}&#xA;[영수증] {영수증번호}&#xA;==========================================가 맹 점 명: {상호}&#xA;대 표 자 명: {대표자}&#xA;사업자 번호: {사업자}&#xA;전 화 번 호: {전화번호}&#xA;주 소: {주소}&#xA;==========================================&#xA;{별도-신용승인전표-내역}&#xA;{별도-신용승인전표-합계}&#xA;{SIGN}&#xA;발 행 일 시: {DATETIME}  {POSNO}-{계산원}&#xA;{CUT}" RANK="2" SEND_SEQ="479549983" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="3" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="03" PRT_FORM="{:C42}{FONT2}{타이틀}{FONT1}{/:C}{CRLF}&#xA;[테이블] {테이블표기} [손님수] {손님수}&#xA;[주문자] {주문자}     [주문번호] {주문번호}&#xA;==========================================&#xA;{이전차수-메뉴목록}&#xA;{주문서-메뉴출력형태1}&#xA;------------------------------------------&#xA;{배달전화번호}&#xA;{배달지주소}&#xA;==========================================&#xA;POS:{POSNO}      [주문시간] {DATETIME}&#xA;&#xA;{CUT}" RANK="3" SEND_SEQ="479549984" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="4" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="04" PRT_FORM="{:C42}{FONT2}{타이틀}{재발행여부}{FONT1}{/:C}&#xA;[테이블] {테이블표기} [손님수] {손님수}&#xA;[주문자] {주문자}       [주문번호] {주문번호}&#xA;[주문서일련번호]{FONT2} {주문서일련번호}{FONT1}&#xA;주문번호: {주문번호}&#xA;주문서일련{주문서일련번호}&#xA;교환번호{교환번호}&#xA;==========================================&#xA;{주문서-메뉴출력형태1}&#xA;------------------------------------------&#xA;{주방메모}&#xA;------------------------------------------&#xA;{배달전화번호}&#xA;{배달지주소}&#xA;==========================================&#xA;POS:{POSNO}      [주문시간] {DATETIME}&#xA;{CUT}" RANK="4" SEND_SEQ="479549985" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="5" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="05" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}[중간계산서]{FONT1}{/:C}{CRLF}&#xA;[테 이 블] {테이블표기}&#xA;[발행일시] {DATETIME}    [POS] {POSNO}&#xA;==========================================&#xA;{중간계산서-메뉴목록}&#xA;------------------------------------------&#xA;{합계금액}&#xA;{할인금액}&#xA;------------------------------------------&#xA;{세액}&#xA;------------------------------------------&#xA;{받을금액}&#xA;{받은금액}&#xA;------------------------------------------&#xA;{배달정보}&#xA;&#xA;{CUT}" RANK="5" SEND_SEQ="479549986" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="6" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="06" PRT_FORM="{:C42}{FONT2}[대기-교환권]{FONT1}{/:C}{CRLF}&#xA;[대기번호] {교환번호}&#xA;[코 너 명] {코너명}&#xA;[발행일시] {DATETIME}&#xA;==========================================&#xA;{코너별-메뉴목록}&#xA;------------------------------------------&#xA;POS:{POSNO}-{계산원}       [{영수증번호}]&#xA;&#xA;{:C42}{FONT2}[대기번호] {교환번호}{FONT1}{/:C}&#xA;&#xA;{CUT}" RANK="6" SEND_SEQ="479549987" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="7" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="07" PRT_FORM="{:C42}{FONT2}{타이틀}{FONT1}{/:C}&#xA;&#xA;[이동시간] {DATETIME}&#xA;==========================================&#xA;{테이블이동}&#xA;{테이블메뉴이동}&#xA;==========================================&#xA;POS:{POSNO}                    [{주문번호}]{주문자}1&#xA;&#xA;{CUT}" RANK="7" SEND_SEQ="479549988" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="8" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="08" PRT_FORM="{:C42}{FONT2}[중간정산서]{FONT1}{/:C}{CRLF}&#xA;&#xA;[영업일자] {영업일자}&#xA;[포스번호] {POSNO}번 POS&#xA;[정 산 원] {정산원} - {정산차수}&#xA;[개점일시] {개점시간}&#xA;[정산일시] {정산시간}&#xA;==========================================&#xA;{매출합계}&#xA;{결제수단별매출내역}&#xA;{할인매출내역}&#xA;{현금시재입력내역}&#xA;{현금정산액}&#xA;{신용카드정산내역}&#xA;{카드사별매출내역}&#xA;{회원포인트내역}&#xA;{상품권시재내역}&#xA;{비매출정산내역}&#xA;&#xA;{매출상품권내역}&#xA;&#xA;{비매출상품권내역}&#xA;&#xA;[발행일시] {DATETIME}&#xA;&#xA;{CUT}" RANK="8" SEND_SEQ="479549989" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="9" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="09" PRT_FORM="{:C42}{FONT2}[마감정산서]{FONT1}{/:C}{CRLF}&#xA;&#xA;[영업일자] {영업일자}&#xA;[포스번호] {POSNO}번 POS&#xA;[정 산 원] {정산원}&#xA;[개점일시] {개점시간}&#xA;[정산일시] {정산시간}&#xA;==========================================&#xA;{매출합계}&#xA;{결제수단별매출내역}&#xA;{할인매출내역}&#xA;{현금시재입력내역}&#xA;{현금정산액}&#xA;{신용카드정산내역}&#xA;{카드사별매출내역}&#xA;{회원포인트내역}&#xA;{상품권시재내역}비매출정산내역&#xA;{비매출정산내역}&#xA;&#xA;{매출상품권내역}&#xA;&#xA;{비매출상품권내역}&#xA;&#xA;[발행일시] {DATETIME}&#xA;&#xA;{CUT}" RANK="9" SEND_SEQ="479549990" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="10" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="10" PRT_FORM="{LOG}&#xA;{:C42}{FONT4}영수증{FONT1}{/:C}{CRLF}&#xA;[매장명] {상호}&#xA;[사업자] {사업자}&#xA;[주  소] {주소}&#xA;[대표자] {대표자}   {:R20}[TEL] {전화번호}{/:R}&#xA;[매출일] {DATETIME}     {POSNO}-{계산원}&#xA;==========================================&#xA;{비매출상품}&#xA;==========================================&#xA;{비매출합계금액}&#xA;------------------------------------------&#xA;{FONT2}{비매출받을금액}&#xA;{FONT2}{비매출받은금액}&#xA;{FONT2}{비매출거스름돈}{FONT1}&#xA;{CUT}" RANK="10" SEND_SEQ="479549991" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="11" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="11" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{FONT1}{/:C}{CRLF}&#xA;[영수증] {영수증번호}&#xA;------------------------------------------&#xA;가 맹 점 명: {상호}&#xA;대 표 자 명: {대표자}&#xA;사업자 번호: {사업자}&#xA;전 화 번 호: {전화번호}&#xA;주       소: {주소}&#xA;------------------------------------------&#xA;{별도-신용승인전표-내역}&#xA;{SIGN}&#xA;발행일시: {DATETIME} {POSNO}-{계산원}&#xA;&#xA;{CUT}" RANK="11" SEND_SEQ="479549992" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="12" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="12" PRT_FORM="{:C42}{FONT2}{타이틀}{FONT1}{/:C}{CRLF}&#xA;[영수증] {영수증번호}&#xA;------------------------------------------&#xA;가 맹 점 명: {상호}&#xA;대 표 자 명: {대표자}&#xA;사업자 번호: {사업자}&#xA;전 화 번 호: {전화번호}&#xA;주       소: {주소}&#xA;------------------------------------------&#xA;{별도-신용승인전표-내역}&#xA;{SIGN}&#xA;발행일시: {DATETIME} {POSNO}-{계산원}&#xA;&#xA;{CUT}" RANK="12" SEND_SEQ="479549993" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="13" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="13" PRT_FORM="{:C42}{FONT2}{타이틀}{FONT1}{/:C}&#xA;&#xA;[매 장 명] {상호}&#xA;[영업일자] {영업일자}&#xA;[POS 번호] {POSNO} - {정산차수}      [판매원] {계산원}&#xA;==========================================&#xA;{시재점검}&#xA;==========================================&#xA;{기타출력}&#xA;[발행일시] {DATETIME}   &#xA;&#xA;{CUT}" RANK="13" SEND_SEQ="479549994" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="14" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="14" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{재발행여부}{FONT1}{/:C}{CRLF}&#xA;[매장명] {상호}&#xA;[사업자] {사업자}&#xA;[주  소] {주소}&#xA;[대표자] {대표자}     {:R20}[TEL] {전화번호}{/:R}&#xA;==========================================&#xA;{중간계산서-메뉴목록}&#xA;------------------------------------------&#xA;{합계금액}&#xA;{할인금액}&#xA;------------------------------------------&#xA;{세액}&#xA;------------------------------------------&#xA;{받을금액}&#xA;------------------------------------------&#xA;{배달정보}&#xA;------------------------------------------&#xA;{현금영수증}&#xA;[발행일]{DATETIME}    [{POSNO}-{계산원}]&#xA;&#xA;{재출력}&#xA;{CUT}" RANK="14" SEND_SEQ="479549995" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="15" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="15" PRT_FORM="{:C42}{FONT2}{타이틀}{재발행여부}{FONT1}{/:C}&#xA;&#xA;{배달정보}&#xA;==========================================&#xA;{중간계산서-메뉴목록}&#xA;------------------------------------------&#xA;{합계금액}&#xA;{할인금액}&#xA;------------------------------------------&#xA;{받을금액}&#xA;------------------------------------------&#xA;[배달원] {배달원명}&#xA;[발행일] {DATETIME}&#xA;&#xA;{재출력}&#xA;{CUT}" RANK="15" SEND_SEQ="479549996" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="16" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="16" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{FONT1}{/:C}{CRLF}&#xA;{FONT2}[테이블] {테이블표기}  [주문번호]{주문번호}&#xA;[발행일시] {DATETIME}    [POS] {POSNO}{FONT1}&#xA;==========================================&#xA;{중간계산서-메뉴목록}&#xA;------------------------------------------&#xA;{합계금액}&#xA;{할인금액}&#xA;------------------------------------------&#xA;&#xA;{CUT}" RANK="16" SEND_SEQ="479549997" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="17" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="21" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}현금영수증{FONT1}{/:C}{CRLF}&#xA;[매장명] {상호}&#xA;[사업자] {사업자}&#xA;[주  소] {주소}&#xA;[대표자] {대표자}     {:R20}[TEL] {전화번호}{/:R}&#xA;[발행일] {DATETIME}     {POSNO}-{계산원}&#xA;==========================================&#xA;{현금영수증}&#xA;&#xA;[발행일]{DATETIME}    [{POSNO}-{계산원}]&#xA;&#xA;{CUT}" RANK="17" SEND_SEQ="479549998" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="18" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="22" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{재발행여부}{FONT1}{/:C}{CRLF}&#xA;[매장명] {상호}&#xA;[사업자] {사업자}&#xA;[주  소] {주소}&#xA;[대표자] {대표자}     {:R20}[TEL] {전화번호}{/:R}&#xA;[매출일] {비매출매출시간} {POSNO}-{계산원}&#xA;==========================================&#xA;{비매출상품리스트}&#xA;------------------------------------------&#xA;{비매출합계금액}&#xA;{비매출할인금액}&#xA;------------------------------------------&#xA;{비매출받을금액}&#xA;{비매출받은금액}&#xA;{비매출거스름돈}&#xA;------------------------------------------{비매출결제리스트}&#xA;&#xA;* 물품반품시 본 영수증을 필히 지참하여&#xA;  주시기 바랍니다. &#xA;&#xA;{재출력}&#xA;{CUT}" RANK="18" SEND_SEQ="479549999" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="19" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="31" PRT_FORM="{FONT2}상품분류별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-상품분류-소}&#xA;출력일시 : {DATETIME}&#xA;&#xA;&#xA;{CUT}" RANK="19" SEND_SEQ="479550000" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="20" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="32" PRT_FORM="{FONT2}상품별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-상품별}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="20" SEND_SEQ="479550001" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="21" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="33" PRT_FORM="{FONT2}결제수단별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-결제수단별}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="21" SEND_SEQ="479550002" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="22" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="34" PRT_FORM="{FONT2}할인유형별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-할인유형별}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="22" SEND_SEQ="479550003" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="23" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="35" PRT_FORM="{FONT2}일자별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-일자별}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="23" SEND_SEQ="479550004" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="24" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="36" PRT_FORM="{FONT2}시재입출금 내역{FONT1}&#xA;&#xA;조회일자 : {조회일자}&#xA;포스번호 : {POSNO}&#xA;정산차수 : {정산차수}&#xA;&#xA;{시재입출금내역}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="24" SEND_SEQ="479550005" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="25" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="37" PRT_FORM="{FONT2}[기간별정산서]{FONT1}&#xA;&#xA;[조회기간] {조회기간}&#xA;[포스번호] {POSNO}번 POS&#xA;[정산차수] {정산번호}&#xA;------------------------------------------&#xA;{매출합계}&#xA;{결제수단별매출내역}&#xA;{할인매출내역}&#xA;{일반할인내역}&#xA;{포장할인내역}&#xA;{쿠폰할인내역}&#xA;{현금시재입력내역}&#xA;{현금정산액}&#xA;{신용카드정산내역}&#xA;{카드사별매출내역}&#xA;{신용카드승인내역}&#xA;{회원포인트내역}&#xA;{상품권시재내역}&#xA;{비매출정산내역}&#xA;{매장-배달매출내역}&#xA;&#xA;{매출상품권내역}&#xA;&#xA;{비매출상품권내역}&#xA;&#xA;[발행일시] {DATETIME}&#xA;&#xA;{CUT}" RANK="25" SEND_SEQ="479550006" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="26" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="38" PRT_FORM="{FONT2}시간대별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-시간대별}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="26" SEND_SEQ="479550007" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="27" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="40" PRT_FORM="         {FONT2}영수증별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-영수증별}&#xA;&#xA;출력일시 : {DATETIME}&#xA;&#xA;{CUT}" RANK="27" SEND_SEQ="479550008" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="28" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="41" PRT_FORM="{상호}&#xA;등록번호:{사업자} 대표:{대표자}&#xA;{주소}&#xA;TEL:{전화번호}&#xA;[ {코너명} ][ {여행사명} ]&#xA;NO:{영수증번호} 담당자:{계산원}&#xA;==========================================&#xA;{FONT3}{타이틀}{FONT1}&#xA;==========================================&#xA;{이용권내역}&#xA;------------------------------------------&#xA;본권은 대기실에서 구명조끼로 교환하여 주세요.&#xA;가--11111&#xA;&#xA;&#xA;&#xA;{CUT}" RANK="28" SEND_SEQ="479550009" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="29" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="42" PRT_FORM="{상호}&#xA;등록번호:{사업자} 대표:{대표자}&#xA;{주소}&#xA;TEL:{전화번호}&#xA;NO:{전표번호} 담당자:{계산원}&#xA;==========================================&#xA;{FONT3}{타이틀}{FONT1}&#xA;==========================================&#xA;{수수료내역}&#xA;------------------------------------------&#xA;{수수료합계}&#xA;------------------------------------------&#xA;{기사정보}&#xA;&#xA;지급영수증번호: {영수증번호}&#xA;&#xA;{CUT}" RANK="29" SEND_SEQ="479550010" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="30" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="43" PRT_FORM="{CENTER}{FONT4}코너별정산서{FONT1}{LEFT}&#xA;&#xA;[영업일자] {영업일자}&#xA;[포스번호] {POSNO}번 POS&#xA;[정 산 원] {정산원}&#xA;[개점일시] {개점시간}&#xA;[정산일시] {정산시간}&#xA;==========================================&#xA;{매출합계}&#xA;{할인매출내역}&#xA;{결제수단별매출내역}&#xA;{주문취소내역}&#xA;&#xA;[발행일시] {DATETIME}&#xA;&#xA;{CUT}" RANK="30" SEND_SEQ="479550011" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="31" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="44" PRT_FORM="{FONT2}승인별 매출현황{FONT1}&#xA;&#xA;조회기간 : {조회기간}&#xA;포스번호 : {조회포스번호}&#xA;&#xA;{매출현황-승인별}&#xA;출력일시 : {DATETIME}&#xA;&#xA;&#xA;{CUT}" RANK="31" SEND_SEQ="479550012" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="32" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="91" PRT_FORM="{CENTER}&#xA;{FONT4}대기번호표&#xA;&#xA;{대기표번호}{FONT1}&#xA;&#xA;[출력시간] {DATETIME}&#xA;&#xA;*** 잠시만 기다려 주십시요 ***&#xA;&#xA;예약인원: {대기인원} 명&#xA;&#xA;{대기메모}&#xA;&#xA;[{상호}]&#xA;{LEFT}&#xA;&#xA;&#xA;&#xA;&#xA;{CUT}" RANK="32" SEND_SEQ="479550013" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="33" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="92" PRT_FORM="{:C42}{FONT2}PreOrder 주문서{FONT1}{/:C}{CRLF}&#xA;[출력시간] {DATETIME}&#xA;[매장명]   {상호}&#xA;&#xA;{PreOrder주문내역}&#xA;&#xA;{CUT}" RANK="33" SEND_SEQ="479550014" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="34" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="93" PRT_FORM="{LOG}&#xA;{:C42}{FONT2}{타이틀}{재발행여부}{FONT1}{/:C}{CRLF}&#xA;[매장명] {상호}/{사업자}&#xA;[주  소] {주소}&#xA;[대표자] {대표자}  [TEL] {전화번호}&#xA;[매출일] {매출시간}&#xA;[영수증] {영수증번호}&#xA;          주문번호{음영}{FONT4}{K-주문번호}{FONT1}{음영일반}&#xA;{K-주문형태}&#xA;==========================================&#xA;{K-상품리스트}&#xA;------------------------------------------&#xA;{합계금액}&#xA;{할인금액}&#xA;------------------------------------------&#xA;{세액}&#xA;------------------------------------------&#xA;{R받은금액}&#xA;------------------------------------------&#xA;{결제리스트}&#xA;------------------------------------------&#xA;{R신용카드}&#xA;{회원정보}&#xA;{모바일내역}&#xA;{재출력}&#xA;{CUT}" RANK="34" SEND_SEQ="479550015" SHOP_CD="062170" UPD_ID="SHOPM_R01"/><DATA-DT INS_ID="SHOPM_R01" NUMBER="35" PROC_DT="20201116101227" PROC_FG="A" PRT_CLS_CD="94" PRT_FORM="{:C42}{FONT2}[KIOSK-교환권]{FONT1}{/:C}{CRLF}&#xA;{:C42}주문번호{FONT4}{음영}{K-주문번호}{음영일반}{FONT1}{/:C}&#xA;==========================================&#xA;{K-상품리스트}&#xA;------------------------------------------&#xA;주문형태-{K-주문형태}           [{영수증번호}]&#xA;[발행일시] {DATETIME}      POS:{POSNO}&#xA;{CUT}" RANK="35" SEND_SEQ="479550016" SHOP_CD="062170" UPD_ID="SHOPM_R01"/></DATA-HD></TXJM-FD></TSP-NVP>'
                	res = res.trim();
                	res = res.replace(/\n\/\>/gi , "@CRLF@");
                	res = res.replace(/>\n/gi , ">");
                	res = res.replace(/\n</gi , "<");
                	res = res.replace(/\n/gi , "@CR@");
                	res = res.replace(/@CRLF@/gi , "\n/>");
                	res = res.replace(/&#xA;/gi , "@CR@");
                	util.logDebug("***** regular after res ===> " +res);
                }
                
            	var xmlData = parser.parseFromString(res,"text/xml");
            	util.logDebug("***** xmlData=== " +xmlData);
                xmlData = $(xmlData).find("TSP-NVP")[0];
            	util.logDebug("***** xd 2 " +  xmlData)
	            result = x2js.xml_str2json( (new XMLSerializer()).serializeToString(xmlData) );
            	
            	
            	if(targetUrl = "/SvrApp/CS000.do"){
            		util.logInfo(" axiosJsonPost stringify data  :\n" + JSON.stringify( result ));
            	} else {
            		util.logDebug(" axiosJsonPost stringify data  :\n" + JSON.stringify( result ));
            	}
            	
                if ( typeof callbackFunc === 'function') {
                	callbackFunc(result, paramsObj);
				}
            },
            error: function(xhr, status, error) {
            	util.logError("xhr1 == > " + JSON.stringify(xhr));
            	util.logError("status.toString == > " + status.toString());
            	util.logError("status == > " + status);
            	util.logError("error == > " + error.toString());
            	
            	var errorObj = { e : error, status : status.toString() };
            	if ( typeof callbackFunc === 'function') {
            		callbackFunc("error", errorObj);
				}
            }
        });
    }
}