var AspData = function(){

    this.receiveAspData = async function(srId, mstSeq , row ){
    	//마스터 전문 조회 및 저장
        var url = '/SvrApp/MS000.do';
        var params = {"TSP-NVP":{"TXJM-FD":{"_SRID":srId, "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" },
        	"DATA-HD":{"_POS_NO":gPosNo, "_SHOP_CD":gShopCd, "_MST_SEQ":mstSeq}}};
        var jsonData;

        try{

//            jsonData = await axiosObj.axiosJsonPost(url, params);

            jsonData = axiosObj.syncAjaxPost(url, params);
            //util.log("receiveAspData jsonData : " +  JSON.stringify(jsonData));

            if(jsonData != null){
                this.receiveAspDataCallback(jsonData, row);
            }else{
                util.logDebug("receiveAspData jsonData is null row : " +  JSON.stringify(row));
            }

        }catch(er){        	
            util.logError("receiveAspData error ================================================================");
            util.logError("receiveAspData error er : " +  JSON.stringify(er));
            util.logError("receiveAspData error er : " +  srId + ",row : " + JSON.stringify(row));
            util.logError("receiveAspData error er : " +  srId + ",jsonData : " + JSON.stringify(jsonData));
        }
        return true;
    },

    this.receiptCheckAspData = function(srId, saleDate, billNo){
    	//영수증 전문 조회 및 저장 SI010
    	var url = '/SvrApp/SI000.do';
    	var params = {"TSP-NVP":{"TXJM-FD":{"_SRID":srId, "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" },
    					"DATA-HD":{"_SHOP_CD":gShopCd, "_SALE_DATE":saleDate, "_POS_NO":gPosNo, "_BILL_NO":billNo}}};

    	var result = axiosObj.syncAjaxPost(url, params);
    	this.receiptCheckAspDataCallback(result);

    },

    this.salesCheckAspData = function(srId, saleDate){
    	//매출관련조회 SI300 ~ SI390
    	var url = '/SvrApp/SI000.do';
    	var params = {"TSP-NVP":{"TXJM-FD":{"_SRID":srId, "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" },
    		"DATA-HD":{"_SHOP_CD":gShopCd, "_SALE_DATE":saleDate, "_POS_NO":gPosNo}}};

    	//정산 자료 조회
    	if(srId == "SI390") axiosObj.axiosJsonPost2(url, params, aspData.settleHstryAspDataCallback);
    	else {
    		var rtn = axiosObj.syncAjaxPost(url, params );
    		var list = aspData.salesCheckAspDataCallback (rtn);
    		if ( list == false) {
    			list = [];
    		}
    		return list;
    	}
    },
    this.clientBasicInfoAspData = function(srId, cstCardNo, telNo, cstNo, cstNm){
    	//고객 기초 정보 조회 CS010
    	var url = '/SvrApp/CS000.do';
    	var params = {"TSP-NVP":{"TXJM-FD":{"_SRID":srId, "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" },
    		"DATA-HD":{"_SHOP_CD":gShopCd, "_POS_NO":gPosNo, "_CST_CARD_NO":cstCardNo,
    			"_TEL_NO":telNo, "_CST_NO":cstNo, "_CST_NM":cstNm}}};

    	axiosObj.axiosJsonPost2(url, params, aspData.settleHstryAspDataCallback);
    },
    
    // user 마일리지 및 적립 부분에서 사용함. 2021.01.21 비동기 통신으로 기능수정.
    this.clientBasicInfoAspDataSearch = function(srId, cstCardNo, telNo, cstNo, cstNm, fnCallback){
    	//고객 기초 정보 조회 CS010, asp 조회만, db저장 x
    	var url = '/SvrApp/CS000.do';
    	var params = {"TSP-NVP":{"TXJM-FD":{"_SRID":srId, "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" },
    		"DATA-HD":{"_SHOP_CD":gShopCd, "_POS_NO":gPosNo, "_CST_CARD_NO":cstCardNo,
    			"_TEL_NO":telNo, "_CST_NO":cstNo, "_CST_NM":cstNm}}};

        try{
        	axiosObj.asyncAjaxPost(url, params, fnCallback);
        }catch(er){
            util.log("clientBasicInfoAspDataSearch error ================================================================");
            util.log("clientBasicInfoAspDataSearch error er : " +  JSON.stringify(er));
            util.log("clientBasicInfoAspDataSearch error er : " +  srId + ",jsonData : " + JSON.stringify(jsonData));
        }
    },
       
    // 상품관리 정보 변경 (PS150)
    this.productModifyRequest = function(srId , indexNo , row, printNos){
    	//console.clear();
    	util.logInfo("상품가격 정보 수정 request >>", JSON.stringify(row));
    	
    	
    	var url = '/SvrApp/PS000.do';
    	var params = {"TSP-NVP":{"TXJM-FD"
    								:{"_SRID":srId, "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" },
										
											"DATA-HD":{   "_SHOP_CD"       : gShopCd                                          , "_POS_NO"            : gPosNo
												        , "_INDEX_NO"      : indexNo                                          , "_DT_CNT"            : 0
												        , "_PROD_CD"       : util.setEmptyStrDefault(row.PROD_CD , "")        , "_UDT_FG"            : util.setEmptyStrDefault(row.UDT_FG , "U")
												        , "_PROD_NM"       : util.setEmptyStrDefault(row.PROD_NM , "")        , "_PROD_NM_EN"        : util.setEmptyStrDefault(row.PROD_NM_EN , "")
												        , "_KIOSK_PROD_YN" : util.setEmptyStrDefault(row.KIOSK_PROD_YN ,"")   , "_KIOSK_PROD_STATUS" : util.setEmptyStrDefault(row.KIOSK_PROD_STATUS , "")
												        , "_LCLS_CD"       : util.setEmptyStrDefault(row.LCLS_CD , "")        , "_MCLS_CD"           : util.setEmptyStrDefault(row.MCLS_CD , "")
												        , "_SCLS_CD"       : util.setEmptyStrDefault(row.SCLS_CD , "")        , "_SALE_UPRC"         : util.setEmptyStrDefault(row.SALE_UPRC , "")
												        , "_COST_UPRC"     : util.setEmptyStrDefault(row.COST_UPRC , "*")      , "_PRICE_MGR_FG"      : util.setEmptyStrDefault(row.PRICE_MGR_FG , "")
												        , "_TAX_YN"        : util.setEmptyStrDefault(row.TAX_YN , "")         , "_TIP_MENU_YN"       : util.setEmptyStrDefault(row.TIP_MENU_YN , "")
												        , "_CST_ACCDC_YN"  : util.setEmptyStrDefault(row.CST_ACCDC_YN , "")   , "_STAMP_ACC_YN"      : util.setEmptyStrDefault(row.STAMP_ACC_YN , "")
												        , "_STAMP_ACC_QTY" : util.setEmptyStrDefault(row.STAMP_ACC_QTY , "0") , "_STAMP_USE_YN"      : util.setEmptyStrDefault(row.STAMP_USE_YN , "N")
												        , "_STAMP_USE_QTY" : util.setEmptyStrDefault(row.STAMP_USE_QTY , "")  , "_BAR_CD"            : util.setEmptyStrDefault(row.BAR_CD , "")
												        , "_PRT_CNT"       : util.setEmptyStrDefault(row.PRT_CNT , 0)
											}
    							}
    				 };

    	var jhd = params["TSP-NVP"]["DATA-HD"];
    	var dtList = new Array();
    	
    	util.logInfo("typeof printNos >>" + typeof printNos);
    	
		util.logInfo("상품가격 정보 수정 printNos >>", JSON.stringify(printNos));
		util.logInfo("printNos.length >>" + printNos.length);
		if(printNos.length > 0){
			for(var i = 0; i<printNos.length; i++){
				var obj =  {
						"_DTL_NO"   : i+1
						, "_PRT_NO"   : util.setEmptyStrDefault(printNos[i] , "")    														  
				};
				dtList.push (obj);
			}
			params["TSP-NVP"]["DATA-HD"]["DATA-DT"] = dtList;
			params["TSP-NVP"]["DATA-HD"]["_DT_CNT"] = dtList.length;/** 2020.09.22 PS150전문 print 건수 를 재수정 처리. 최광림 차장 확인 **/
			util.logInfo(params);
		}
    	
    	util.logInfo("상품가격 정보 수정 params : " + JSON.stringify(params));
    	
    	var resData;
    	
    	try{
    		
    		var resData = axiosObj.syncAjaxPost(url, params);
    		//console.log("resData >> " + resData);
    		util.logInfo("receiveAspData jsonData : " +  JSON.stringify(resData));

    	}catch(er){
    		//console.error(er);
    		util.logInfo("receiveAspData error er : " +  JSON.stringify(er));
    		util.logInfo("receiveAspData error er : " +  srId + ",reqData : " + JSON.stringify(resData));
    	}
      return resData;
    },

    this.receiveAspDataCallback = function(data , row ) {

    	var txjmFd = data["TSP-NVP"]["TXJM-FD"];
    	var resultData = {};

    	if(txjmFd["_RETCD"] == "0000") {
    		var dataHd = txjmFd["DATA-HD"];
    		var dataDt = dataHd["DATA-DT"];
    		var maxSeq = txjmFd["_MAX_SEQ"];

    		//util.log(JSON.stringify(txjmFd));
    		//util.log(JSON.stringify(dataDt));

    		var dataDtLength = 0 ;
    		if ( Array.isArray( dataDt ) ) {
    			dataDtLength = dataDt.length;	
    		} else {
    			if ( Object.keys(dataDt).length != 0 )
    			dataDtLength = 1;
    		}

    		if(dataDtLength == 0 ){
    			return false;
    		}

    		var srId = txjmFd._SRID;
    		var lsatSql = "";
    		var resultSeq = "";

    		try {
    			gfn_DbOpen();
    			gfn_DbBegin();

    			for(var i=0 ; dataDtLength > i ; i++){
    				var item = {};
    				if(dataDtLength == 1) {
    					item = dataDt;
    				}else {
    					item = dataDt[i];
    				}
    				//TEST************//////////////
    				//util.logInfo("test item [" + i + "] = "+ JSON.stringify(item));

    				lsatSql = sqlQuery.fnSelectQuery(srId, item);
    				//params = sqlQuery.fnSelectParams(srId, item);
    				
    				if(lsatSql != "") {
    					try{
    						resultSeq = item["_SEND_SEQ"];
    						var resultMsg = gfn_DbExecute(lsatSql);
    						if(resultMsg.ResultCode != 0) {
    							//util.log("resultMsg.ResultCode   :" + resultMsg.ResultCode);
    							throw  "fail 전문ID[%s] 마스터 정보 등록 실패하였습니다.\n%s\n%s".sprintf(srId,lsatSql, JSON.stringify(resultMsg ));
    						}
    					}catch(ex){
    						util.log("catch   :" + ex);
    						return aspData.updateRecvSeqTable(resultSeq, row);
    					}
    				}
    			}
    			gfn_DbCommit();
			} catch (e) {
				console.error(e);
				try {
					gfn_DbRollBack();
				} catch (e) {
				}
			} finally {
				try {
					gfn_DbClose();
				} catch (e) {
				}
			}


//    		var endTime = moment().format("YYYY-MM-DD HH:mm:ss");
//    		var endTime2 = new Date().getTime();
//    		util.log( " startTime >>> " + startTime + ", endTime >>> " + endTime);
//    		util.log( " 처리시간 >>> " + (endTime2 - startTime2) + " ms");

    		aspData.updateRecvSeqTable(resultSeq, row);
    	} else {
    		//ASP 전문 오류
    		util.log( " receiveAspDataCallback RETCD : " + txjmFd["_RETCD"] + ", RETMSG : " + txjmFd["_RETMSG"]);
    		//resultData = { "resultMsg" : false, resultSeq : "" };
    	}
    },

    this.updateRecvSeqTable = function(resultSeq, row){
    	if ( util.byteLen (resultSeq)  == 0 )
    		resultSeq = '0';
    	if(row !== undefined) {
    		var sqlParams = [
    			row.RECV_ID
    			, row.REQT_ID
    			, row.REQT_NM
    			, resultSeq
    			, row.REQT_RM
    			];
    		var result = gfn_SQLiteSQLProcess(sqlQuery.sqlInsertRecvSeqT, sqlParams);
    		util.log("updateRecvSeqTable >>> " + JSON.stringify(result ) );
    	} else {
    		util.log("updateRecvSeqTable row data is undefined");
    	}
    }

    this.receiptCheckAspDataCallback = function(data) {
    	//영수증 조회(일자별 매출 내역 수신 요청)
    	var txjmFd = data["TSP-NVP"]["TXJM-FD"];
    	var resultData = {};

    	if(txjmFd["_RETCD"] == "0000") {
    		var dataHd = txjmFd["DATA-HD"];
    		var trhdr = dataHd["TRHDR"];

    		var srId = txjmFd._SRID;

    		var sqlData = {"srId" : srId};
    		var lsatSql = "";
    		var params = [];

    		//조회 데이터가 없을경우에도 RETCD가 0000으로 넘어온다.
    		if(trhdr !== undefined){
    			var salesDataArr = [
	    				["TRHDR"], 			   ["TRDTL", "DATA-DTL"], ["TRCSH", "DATA-CSH"], ["TRCRD", "DATA-CRD"],
	    				["TRPSQ", "DATA-PSQ"], ["TRCST", "DATA-CST"], ["TRJCD", "DATA-JCD"], ["TRGFT", "DATA-GFT"],
	    				["TRCPN", "DATA-CPN"], ["TRGST", "DATA-GST"], ["TRFOD", "DATA-FOD"]
    				];

    			util.log(JSON.stringify(txjmFd));
    			util.log(JSON.stringify(trhdr));

    			var resultMsg = "";

    			//영수증 조회(일자별 매출 내역 수신 요청) - 요청시 마스터-디테일식으로 한꺼번에 저장할 정보가 전문으로 전달된다
    			for(var i=0; i<salesDataArr.length; i++) {
    				var item = [];
    				if(typeof dataHd[salesDataArr[i][0]] !== "undefined" ) {
    					if( typeof dataHd[salesDataArr[i][0]].length !== "undefined") {
    						//영수증 조회 디테일 데이터 저장, 리스트형식으로 넘어온 데이터 처리
                            util.logInfo(" salesDataArr[i][0] " ,  salesDataArr[i][0] );
    						util.logInfo("dataHd[salesDataArr[i][0]]" , dataHd[salesDataArr[i][0]] );
    						util.logInfo("dataHd[salesDataArr[i][0]].length" , dataHd[salesDataArr[i][0]].length );
    						for(var j=0; j<dataHd[salesDataArr[i][0]].length; j++){

    							util.log(j+1+ "->" + "dataHd["+salesDataArr[i][0]+"]["+j+"]["+salesDataArr[i][1]+"] : " + JSON.stringify(dataHd[salesDataArr[i][0]][j][salesDataArr[i][1]]));
    							item = dataHd[salesDataArr[i][0]][j][salesDataArr[i][1]];
    							resultMsg = aspData.excuteDbStorage(salesDataArr[i][0], item);
    						}
    					} else {
    						if(salesDataArr[i][0] == "TRHDR" ) {
    							//영수증 조회 마스터 데이터 저장
    							util.log(i+1+ "->" + "dataHd["+salesDataArr[i][0]+"] : " + JSON.stringify(dataHd[salesDataArr[i][0]]));
    							item = dataHd[salesDataArr[i][0]];
    							resultMsg = aspData.excuteDbStorage(salesDataArr[i][0], item);
    						} else {
    							//영수증 조회 디테일 데이터 저장
    							if ( !util.isEmpty ( dataHd[salesDataArr[i][0]] )    ) {
        							util.log(i+1+ "->" + "dataHd["+salesDataArr[i][0]+"]["+salesDataArr[i][1]+"] : " + JSON.stringify(dataHd[salesDataArr[i][0]][salesDataArr[i][1]]));
        							item = dataHd[salesDataArr[i][0]][salesDataArr[i][1]];
    	       						resultMsg = aspData.excuteDbStorage(salesDataArr[i][0], item);
    							}
    						}
    					}
    				}
    			}

    			if(resultMsg.ResultCode == 0) {
    				resultData = { "resultMsg" : true, "shopCd" : trhdr["_SHOP_CD"], "saleDate" : trhdr["_SALE_DATE"],
    						"posNo" : trhdr["_POS_NO"], "billNo" : trhdr["_BILL_NO"] };
    			} else {
    				resultData = { "resultMsg" : false };
    			}

    		} else {
    			//조회 데이터가 없을경우에도 RETCD가 0000으로 넘어온다.
    			resultData = { "resultMsg" : true };
    		}

    	} else {
    		util.log( "receiptCheckAspDataCallback RETCD : " + txjmFd["_RETCD"] + ", RETMSG : " + txjmFd["_RETMSG"]);
    		resultData = { "resultMsg" : false };
    	}

    	return resultData;
    },

    this.salesCheckAspDataCallback = function(data) {
    	//포스별매출집계, 최종매출건수및정산건수
    	var txjmFd = data["TSP-NVP"]["TXJM-FD"];
    	var resultData = [];

    	if(txjmFd["_RETCD"] == "0000") {
    		//debugger;
    		var dataHd = txjmFd["DATA-HD"];
    		var dataDt = dataHd["DATA-DT"];

    		//util.log(JSON.stringify(txjmFd));
    		//util.log(JSON.stringify(dataDt));

    		if(dataHd._DATA_CNT == 0 ){
    			return false;
    		}

    		var dataDtLength = dataHd._DATA_CNT;

    		var srId = txjmFd._SRID;

    		var sqlData = {"srId" : srId};
    		var lsatSql = "";
    		var params = [];

    		if(dataDtLength == 1) {
    			util.log(JSON.stringify(dataDt));
    			resultData = dataDt;
    		} else {
    			for(var i=0 ; dataDtLength > i ; i++){
    				util.log("dataDt [" + i + "] = "+ JSON.stringify(dataDt[i]));
    				resultData.push(dataDt[i]);
        		}
    		}

    	} else {
    		util.log( " salesCheckAspDataCallback RETCD : " + txjmFd["_RETCD"] + ", RETMSG : " + txjmFd["_RETMSG"]);
    	}

    	return resultData;
    },

    this.settleHstryAspDataCallback = function(data) {
    	//조회일자정산내역 저장
    	var txjmFd = data["TSP-NVP"]["TXJM-FD"];
    	var resultData = {};

    	if(txjmFd["_RETCD"] == "0000") {
    		var dataHd = txjmFd["DATA-HD"];
    		var dataDt = dataHd["DATA-DT"];

    		//util.log(JSON.stringify(txjmFd));
    		//util.log(JSON.stringify(dataDt));

    		if(dataHd._DATA_CNT == 0 ){
    			return false;
    		}

    		var dataDtLength = dataHd._DATA_CNT;

    		var srId = txjmFd._SRID;

    		var sqlData = {"srId" : srId};
    		var lsatSql = "";
    		var params = [];

    		for(var i=0 ; dataDtLength > i ; i++){
                var item = {};
                if(dataDtLength == 1) {
                    item = dataDt;
                }else {
                    item = dataDt[i];
                }

                lsatSql = sqlQuery.fnSelectQuery(srId, item);
                //params = sqlQuery.fnSelectParams(srId, item);

                if(lsatSql != "") {
                    try{
                        var resultMsg = gfn_SQLiteSQLProcess(lsatSql);
                        util.log(" CS010 resultMsg.ResultCode   :" + resultMsg.ResultCode);
                        if(resultMsg.ResultCode != 0) {
                            throw new Exception();
                        } else {
                        	var lsatSql2 = sqlQuery.fnSelectQuery("SI391", item);
                        	if(lsatSql != "") {
                        		try{
                        			var resultMsg2 = gfn_SQLiteSQLProcess(lsatSql2);
                        			util.log(" CS010 resultMsg2.ResultCode   :" + resultMsg2.ResultCode);
                        			if(resultMsg2.ResultCode != 0) {
                                        throw new Exception();
                                    }
                        		}catch(ex){
                                    util.log("catch   :" + ex);
                                }
                        	}
                        }
                    }catch(ex){
                        util.log("catch   :" + ex);
                    }
                }
            }

//    		if(dataDtLength == 1) {
//    			//저장할 데이터가 한건일때
//    			//util.log("dataDt = "+ JSON.stringify(dataDt));
//    			lsatSql = sqlQuery.fnSelectQuery2(srId, dataDt);
//    			params = sqlQuery.fnSelectParams(srId, dataDt);
//
//    			//util.log("lsatSql  ="+ lsatSql);
//    			var newParams = aspData.changeParamsData(params);
//
//    			if(lsatSql != "") {
//    				try{
//    					var resultMsg = gfn_SQLiteSQLProcess(lsatSql , newParams);
//    				}catch(ex){
//    					util.log("catch   :" + ex)
//    				}
//    			}
//    		} else {
//    			for(var i=0 ; dataDtLength > i ; i++){
//        			var item = dataDt[i];
//        			//util.log("item [" + i + "] = "+ JSON.stringify(item));
//
//        			lsatSql = sqlQuery.fnSelectQuery2(srId, item);
//        			params = sqlQuery.fnSelectParams(srId, item);
//
//        			//util.log("lsatSql  ="+ lsatSql);
//        			var newParams = aspData.changeParamsData(params);
//
//        			if(lsatSql != "") {
//        				try{
//        					var resultMsg = gfn_SQLiteSQLProcess(lsatSql , newParams);
//        				}catch(ex){
//        					util.log("catch   :" + ex);
//        				}
//        			}
//        		}
//    		}
    	} else {
    		util.log( " settleHstryAspDataCallback RETCD : " + txjmFd["_RETCD"] + ", RETMSG : " + txjmFd["_RETMSG"]);
    	}
    },

    this.excuteDbStorage = function(srId, item){
    	util.logInfo(srId, item);
    	//debugger;
    	var sLen = ( Object.keys(item).length == "undefined" )?0:Object.keys(item).length;
    	if ( sLen !=  0 ) {
            Object.keys(item).forEach(e =>{
               var x = item[e];
               if ( Number.isInteger( parseInt(x) ) ) {
                   if( x.startsWith("-") ){
                       x = x.substring(1);
                       item[e] = x;
                   }
               }
            });
    	}

        lsatSql = sqlQuery.fnSelectQuery(srId, item);
        //params = sqlQuery.fnSelectParams(srId, item);
        //util.log("lsatSql = " + lsatSql);
        //util.log("params = " + params);

        //var newParams = aspData.changeParamsData(params);
        //util.log("newParams = " + newParams);
        var resultMsg = "";
        if(lsatSql != "") {
            try{
            	var resultMsg = gfn_SQLiteSQLProcess(lsatSql);
            	util.log("resultMsg.ResultCode   :" + resultMsg.ResultCode + ", SSL_" + srId + "_T TABLE INSERT SUCCESS ");
            }catch(ex){
            	util.log("SSL_" + srId + "_T TABLE INSERT ERROR ");
            	util.log("catch   :" + ex);
            }
        } else {
        	console.error("SQL 없음. 전문ID [" +srId +"]" +JSON.stringify( item) ) ;
        }
        return resultMsg;
    },

    this.changeParamsData = function (params) {
    	//parameter undefined 제거
    	var newParams = []

    	for(var i=0; i<params.length; i++) {
    		if(params[i] === undefined) {
    			newParams.push(null);
    		} else {
    			newParams.push(params[i]);
    		}
    	}

    	return newParams;
    },

    this.checkParamData = function(param){

    	resultData = "";
        if(param === undefined || param === null){
        	resultData = null;
        } else {
        	resultData = param;
        }

        return resultData;
    }
    this.tmsUpdateDownLoad = function( restartAppFg = false , x2js, doAlert) {
    	try {
    		let url = '/SvrApp/DN000.do' , params = {} ,  xmlParam , r
    		var kioskVerSeq = KIOSK_VER_SEQ;

    		params ={"TSP-NVP" 
    				:{
    					"TXJM-FD" :{"_SRID":"DN090", "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" 
    						,	"DATA-HD":{   "_POS_NO" 	:gPosNo //테스트 할 경우 '03' 
    							, "_SHOP_CD"	: gShopCd
    							, "_VER_SEQ"	: kioskVerSeq
    						}
    					}
    				}
    		};
    		
    		xmlParam = x2js.json2xml_str(params);
    		r = telegram.tlgmCall( XML_PI + xmlParam , url );
    		
    		// 네트워크 문제나 서버 문제가 발생한 경우에 바로 리턴.
    		if(r == "timeout" || r == "NetworkError"){
    			util.logError("*****tmsUpdateDownLoad asp Error result == > " + r);
    			return r;
    		}
    		r = x2js.xml_str2json(r);
    		util.logDebug("DN090 " + JSON.stringify( r ) );
    		let fd = r["TSP-NVP"]["TXJM-FD"] ;//["DATA-HD"];
    		util.logDebug('DN090 - tlgmHd' + JSON.stringify( fd));

    		var fnData = {"restartAppFg" : restartAppFg, "fd" : fd, "doAlert": doAlert};

    		if ( r == null || r["TSP-NVP"]["TXJM-FD"]["_RETCD"] != '0000' ) {
    			
    			util.logDebug("DN090 result error " + JSON.stringify(r["TSP-NVP"]));
    			return false;
    		}else if(doAlert){

    		    dataObj = {"button1Show" : true, "button1Name" : "아니요", "button2Show" : true, "button2Name" : "확인", "button2Func": aspData.fnCallPaymentDownload
                    , "data" : fnData
                    , "message" : "프로그램 업데이트가 있습니다. \n 업데이트 하시겠습니까?"};

                util.logInfo("    업데이트 파일 존재 메시지 팝업    ");

                eventBus.$emit('alertPopup', dataObj);


    		}else{
    		    return this.fnCallPaymentDownload(fnData);
    		}
    		
    		//let hd = r["TSP-NVP"]["TXJM-FD"]["DATA-HD"];

		} catch (e) {
			util.logError("***** tmsUpdateDownLoad DN000.do catch r == >> " + r);
			util.logError(e);
		}
    },

    this.fnCallPaymentDownload = function( fnData) {

        var fd = fnData.fd;

        if(fnData.doAlert){
            util.logInfo("    확인 버튼 선택    ");
        }

        util.logDebug('fnCallPaymentDownload - DATA-HD' + JSON.stringify(fd));

        let hd = fd["DATA-HD"];

        let verUrl = hd._VER_URL;
        let verSeq = hd._VER_SEQ;
        let fileNm = hd._FILE_NM;
        let fileUrl = '/' + verUrl.split('/').splice(3).join('/');//도메인을 제외한 값을 넣는다.
        util.logDebug('verUrl  : ' + verUrl);
        util.logDebug('verSeq  : ' + verSeq);
        util.logDebug('fileNm  : ' + fileNm);
        util.logDebug('fileUrl :  ' + fileUrl);
        /***
         * TODO
         * 1. 파일다운로드 URL 호출
         * 2. 종료여부 (exitAppFg == true 일 경우 app 재시작)
         */
        //let tlgmDt = r["TSP-NVP"]["TXJM-FD"]["DATA-HD"]["DATA-DT"];
        //TODO download app 호출

        //nativeApp.Update("/test/firstpos/kioskversion/samsung/pkg20200828_02.zip",true);
        if ( util.isTizen() == false )
            return false;

        try {
            util.logInfo('kiosk sucess - tmsUpdate Call Start')
            /*************************************************************************************************
             * true 입력시 즉시 업데이트가 이루어진다.
             * false 입력시 다음 부팅이후에 업데이트가 이루어진다.(false의 경우 vconf가 사전입력 되어야만 동작)
             * 2020.10.23 파일은 도메인을 제외한 값을 넣는다.
             *************************************************************************************************/
            window.b2bapis.paymentdownload.update(fileUrl ,true);
            util.logDebug('sample.getPaymentAppId();' + window.b2bapis.paymentdownload.getPaymentAppId() );
            util.logDebug('kiosk sucess - tmsUpdate Call End')
        } catch (e) {
            util.logError("kiosk paymentDownload exception code["+e.code+"], name["+e.name+"],message["+e.message+"]");
            log.logError("kiosk  paymentDownload exception code["+e.code+"], name["+e.name+"],message["+e.message+"]");
        } finally {
            util.logInfo(' sucess - tmsUpdate Call finally ');
        }

        //return false;//2020.10.23 실제 종료????????????
        if ( fnData.restartAppFg == true ) {
            if(fnData.doAlert){
                $(".loadingCon").show();
            }else{
                //TODO app restart 호출.
                return true;

            }

        }
        return false;

    },
    
    // 상품관리 정보 변경 (PS150)
    this.productStatusChange = function(srId , indexNo , row){
    	//console.clear();
    	util.logInfo("상품가격 정부 수정 request >>", row);
    	
    	var url = '/SvrApp/PS000.do';
    	var params = {"TSP-NVP":
    					{"TXJM-FD"
    						:{"_SRID":srId, "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" },
								"DATA-HD":
								{   "_SHOP_CD"       : gShopCd                                          , "_POS_NO"            : gPosNo
							        , "_INDEX_NO"      : indexNo                                          , "_DT_CNT"            : 0
							        , "_PROD_CD"       : util.setEmptyStrDefault(row.PROD_CD , "")        , "_UDT_FG"            : util.setEmptyStrDefault(row.UDT_FG , "U")
							        , "_PROD_NM"       : util.setEmptyStrDefault(row.PROD_NM , "")        , "_PROD_NM_EN"        : util.setEmptyStrDefault(row.PROD_NM_EN , "")
							        , "_KIOSK_PROD_YN" : util.setEmptyStrDefault(row.KIOSK_PROD_YN ,"")   , "_KIOSK_PROD_STATUS" : util.setEmptyStrDefault(row.KIOSK_PROD_STATUS , "")
							        , "_LCLS_CD"       : util.setEmptyStrDefault(row.LCLS_CD , "")        , "_MCLS_CD"           : util.setEmptyStrDefault(row.MCLS_CD , "")
							        , "_SCLS_CD"       : util.setEmptyStrDefault(row.SCLS_CD , "")        , "_SALE_UPRC"         : util.setEmptyStrDefault(row.SALE_UPRC , "")
							        , "_COST_UPRC"     : util.setEmptyStrDefault(row.COST_UPRC , "*")      , "_PRICE_MGR_FG"      : util.setEmptyStrDefault(row.PRICE_MGR_FG , "")
							        , "_TAX_YN"        : util.setEmptyStrDefault(row.TAX_YN , "")         , "_TIP_MENU_YN"       : util.setEmptyStrDefault(row.TIP_MENU_YN , "")
							        , "_CST_ACCDC_YN"  : util.setEmptyStrDefault(row.CST_ACCDC_YN , "")   , "_STAMP_ACC_YN"      : util.setEmptyStrDefault(row.STAMP_ACC_YN , "")
							        , "_STAMP_ACC_QTY" : util.setEmptyStrDefault(row.STAMP_ACC_QTY , "0") , "_STAMP_USE_YN"      : util.setEmptyStrDefault(row.STAMP_USE_YN , "N")
							        , "_STAMP_USE_QTY" : util.setEmptyStrDefault(row.STAMP_USE_QTY , "")  , "_BAR_CD"            : util.setEmptyStrDefault(row.BAR_CD , "")
							        , "_PRT_CNT"       : util.setEmptyStrDefault(row.PRT_CNT , 0)
								}
						}
    				 };

    	var resData;
    	
    	try{
    		var resData = axiosObj.syncAjaxPost(url, params);
    		util.logInfo("receiveAspData jsonData : " +  JSON.stringify(resData));
    	}catch(er){ 
    		util.logInfo("receiveAspData error er : " +  JSON.stringify(er));
    		util.logInfo("receiveAspData error er : " +  srId + ",reqData : " + JSON.stringify(resData));
    	}
      return resData;
    }

}