const DischargePlugin = {};
DischargePlugin.install = function (Vue, options) {
    // 1. 전역 메소드 또는 속성 추가
    Vue.myGlobalMethod = function (values) {
        util.log("myGlobalMethod values : " + values);
        if(values == "back"){
            history.back();

        }
    },
    Vue.tableScroll = function (methodOptions) {
        util.log("tableScroll values : " + methodOptions);

        //tableScroll
        if ($('.tableBody').length) {
            $('.tablerowWrap .tablerow').each(function(){
                var tbody = $(this).parent('.tablerowWrap');
                $(this).click(function(){
                    tbody.find('.tablerow').removeClass('selected');
                    $(this).addClass('selected');
                });
            });

            $('.tableBody').each(function(){
                var $table = $(this),
                nextBtn = $(this).parent('.tableWrap').next('.btnWrap').find('.tableDown'),
                prevBtn = $(this).parent('.tableWrap').next('.btnWrap').find('.tableUp'),
                rowNum = 0;
                if($table.hasClass('row10')){rowNum = 10;}
                else if($table.hasClass('row8')){rowNum = 8;}
                else if($table.hasClass('row20')){rowNum = 20;}
                else if($table.hasClass('row13')){rowNum = 13;}
                else if($table.hasClass('row4')){rowNum = 4;}
                else if($table.hasClass('row6')){rowNum = 6;}

                var swiperTable = new Swiper($table, {
                    autoHeight: true,
                    direction: 'vertical',
                    slidesPerView: rowNum,
                    navigation: {
                        nextEl: nextBtn,
                        prevEl: prevBtn,
                    },
                });
            });
        };
    }

    // 2. 전역 에셋 추가
    Vue.directive('my-directive', {
        bind (el, binding, vnode, oldVnode) {
            // 필요한 로직 ...
        }
    })

    // 3. 컴포넌트 옵션 주입
    Vue.mixin({
        created: function () {
            // 필요한 로직 ...
        }

    })

    // 4. 인스턴스 메소드 추가
    Vue.prototype.historyBack = function (methodOptions) {
        util.log("historyBack values : " + methodOptions);

        this.$router.push({path: '/adminMain/adminLogin'})

    }
}