var dbCommon = function(){
	let dbOpenFg = false;
	let dbBeginFg = false;//트랜잭션 시작.

	let borwserNavigator = navigator.userAgent.toUpperCase();
	let isTizen =  false;
	if ( borwserNavigator.indexOf("TIZEN") != -1 ) {
		isTizen = true;
	}

	let parseReturnData = function(r , n){
		util.logDebug("\n<<<===== dbProcess Result =====>>> \n" + r);
		if(r == -1){
			let obj = {
					  message : "DB TimeOut 발생.\n 관리자에게 문의바랍니다."
					, messageType : "alert"
				};				
				this.$root.$emit( "notiMessage" ,   obj  );
				return false;
		}
		if ( r == null || r == undefined || r.length == 0 ) return r;

		/*** PP Plugin 의 gabage 처리 부적합으로.. 해당 문자 이전까지 JSON.parse 처리 **/
		var eofCharacters = "$$^"; 
		var x ;
		for ( let i = 0 ; i < 10; i++) {
			if ( r.indexOf( eofCharacters ) != -1)
				r = r.substring(0, r.lastIndexOf( eofCharacters ));
			break;
		}

		r = r.trim();

		try {
			x = JSON.parse(r);
			delete r.Data;
			return x;
		} catch (e) {
			util.logError("pp plugin error native return data JSON Parsing error ");
			util.logDebug("native app name - " + n );
			util.logDebug("pp plugin return value  - " + r );
			util.logDebug("pp catch e - " + e.toString() );
			
			var rx = r.substring(0 , r.lastIndexOf("}")+1);
			delete r.Data;
			try {
				return rx = JSON.parse(rx);
			} catch (ex) {
				throw ex;
			}
		}
	}

	this.dbOpen = function() {
		if(  !isTizen ) return;
		if ( dbOpenFg == false) {
			var r = nativeApp.functionCallSync(["DB_Open"]);

			//util.logInfo("DB_Open" + r);
			dbOpenFg = true;
			return parseReturnData(r , 'DB_Open');
		}
	}

	this.dbBegin = function(){
		if ( dbOpenFg != true)
			this.dbOpen();
		var r = nativeApp.functionCallSync(["DB_Begin"]);
		return parseReturnData(r , 'DB_Begin');
	}

	this.dbClose = function() {
		//if ( dbOpenFg != true) return;
		try {
			var r = nativeApp.functionCallSync(["DB_Close"]);
			dbOpenFg = false;
			return parseReturnData(r , 'DB_Close');
		} catch (e) {
		}
	}

	this.dbCommit = function() {
		var r = nativeApp.functionCallSync(["DB_Commit"]);
		return parseReturnData(r , 'DB_Commit');
	}

	this.dbRollback = function(){
		var r = nativeApp.functionCallSync(["DB_Rollback"]);
		return parseReturnData(r , 'DB_Rollback');
	}

	this.dbProcess = function(sql, parameters) {
		sql = sql.trim();
		var r , rtn ;
		if ( sql.toUpperCase().startsWith("SELECT") ){
			if ( dbOpenFg != true ) {
				this.dbOpen();
				r = nativeApp.functionCallSync(["DB_SqlSelect",  sql, parameters],30000);
				r = parseReturnData(r , 'DB_SqlSelect');
				this.dbClose();
			} else {
				r = nativeApp.functionCallSync(["DB_SqlSelect",  sql, parameters],30000);
				r = parseReturnData(r , 'DB_SqlSelect');
			}
			return r ;

		} else {
			if ( dbOpenFg != true ) {
				this.dbOpen();
				r = nativeApp.functionCallSync(["DB_SqlExec",  sql, parameters]);
				r = parseReturnData(r , 'DB_SqlExec');
				this.dbClose();
			} else{
				r = nativeApp.functionCallSync(["DB_SqlExec",  sql, parameters]);
				r = parseReturnData(r , 'DB_SqlExec');
			}			
			return r;
		}
	}
}

var Log = function() {
	this.logInfo = function(logMessage) {
		this.logWriter('I', logMessage);
	}
	this.logDebug = function(logMessage) {
		this.logWriter('D', logMessage);
	}
	this.logWarning = function (logMessage) {
		this.logWriter('W', logMessage);
	}
	this.logError = function (logMessage) {
		this.logWriter('E', logMessage);
	}

	this.logWriter = function(logLevel, logMessage) {

		if (util.isTizen() == false )
			return;

		var result = nativeApp.functionCallSync([ "LOG_Writer", logLevel, logMessage ]);
		//util.logInfo(result);
	}
}

var dc = new dbCommon();

/*****************************************************
 * SQLite 에 대한 DB 접속에 대한 GateWay 
 * @param sql
 * @param sqlParameter
 * @returns
 *****************************************************/
function gfn_SQLiteSQLProcess(sql   , sqlParameter ) {
	gfn_validate_NotEmpty(sql, "SQL Query is Empty!");
	var sendSQL = "";
	if ( sqlParameter === undefined || sqlParameter === null ) {
		sqlParameter = [];
	}
	try{
		
		var vsCurDt = getCurrentDate();
		var vsRandomVal = Math.floor(Math.random() * 100000);
		var vsKeyVal = vsCurDt + vsRandomVal; // 현재값 + 랜덤함수 조합으로 키값 생성
		
		util.logDebug("\n<<<===== gfn_SQLiteSQLProcess SQL Parameter =====>>> \n" + JSON.stringify(sqlParameter ));
		util.logDebug("\n<<<===== gfn_SQLiteSQLProcess SQL Parameter KEY =====>>> \n" + vsKeyVal);
		
		var sendSQL = gfn_sqlBindParameters(sql, sqlParameter );
		util.logDebug("\n<<<===== gfn_SQLiteSQLProcess SQL =====>>> \n"  + sendSQL );

		if( util.isTizen() == false ){

			var resultData = gfn_db2_window( sendSQL, []  );
            util.logInfo('gfn_SQLiteSQLProcess result : ' + JSON.stringify(resultData) );
			return resultData;


		} else {

			return dc.dbProcess(sendSQL, vsKeyVal);

		}

	} catch (e) {
		util.logError( 'SQL Exception Query (' + sql + JSON.stringify(sqlParameter )+  ')' + e );
		throw e;
	}
}


function gfn_DbExecute(sql , parameters) {
	gfn_validate_NotEmpty(sql, "SQL Query is Empty!");
	var sendSQL = "";
	if ( parameters === undefined || parameters === null ) {
		parameters = [];
	}
	
	var vsCurDt = getCurrentDate();
	var vsRandomVal = Math.floor(Math.random() * 100000);
	var vsKeyVal = vsCurDt + vsRandomVal; // 현재값 + 랜덤함수 조합으로 키값 생성

	//util.logDebug("\n<<<===== gfn_DbExecute SQL Parameter =====>>> \n" + JSON.stringify(parameters ));
	//util.logDebug("\n<<<===== gfn_DbExecute SQL Parameter KEY =====>>> \n" + vsKeyVal);
	
	var sendSQL = gfn_sqlBindParameters(sql, parameters );
	//util.logDebug("\n<<<===== gfn_SQLiteSQLProcess SQL =====>>> \n"  + sendSQL );
	if( util.isTizen() == false ){

		var resultData = gfn_db2_window( sendSQL, []  );
	    util.logInfo('gfn_DbExecute result : ' + JSON.stringify(resultData) );
		return resultData;

	} else {

		return dc.dbProcess(sendSQL, vsKeyVal); ;

	}
}
function gfn_DbSelect(sql , parameters) {
	gfn_validate_NotEmpty(sql, "SQL Query is Empty!");
	var sendSQL = "";
	if ( parameters === undefined || parameters === null ) {
		parameters = [];
	}
	
	var vsCurDt = getCurrentDate();
	var vsRandomVal = Math.floor(Math.random() * 100000);
	var vsKeyVal = vsCurDt + vsRandomVal; // 현재값 + 랜덤함수 조합으로 키값 생성

	//util.logDebug("\n<<<===== gfn_DbSelect SQL Parameter =====>>> \n" + JSON.stringify(parameters ));
	//util.logDebug("\n<<<===== gfn_DbSelect SQL Parameter KEY =====>>> \n" + vsKeyVal);
		
	var sendSQL = gfn_sqlBindParameters(sql, parameters );
	//util.logDebug("\n<<<===== gfn_SQLiteSQLProcess SQL =====>>> \n"  + sendSQL );
	if( util.isTizen() == false ){

		var resultData = gfn_db2_window( sendSQL, []  );
	    util.logInfo('gfn_DbSelect result : ' + JSON.stringify(resultData) );
		return resultData;

	} else {
		return dc.dbProcess(sendSQL, vsKeyVal);

	}

}

function gfn_DbBegin() {
	//util.logInfo('SQL DB BeginStart => DB Transaction process');
	if( util.isTizen() == false ) return;
	return dc.dbBegin();
}
function gfn_DbOpen() {
	//util.logInfo('SQL DB Open Start => DB Transaction process start');

	if( util.isTizen() == false ) return;

	//util.logInfo('SQL DB Open End => DB Transaction process start');

	return dc.dbOpen();
}

function gfn_DbClose() {
	//util.logInfo('SQL DB Close Start => commit process!! ');

	if( util.isTizen() == false ) return;
	return dc.dbClose();


}
function gfn_DbRollBack() {
	//util.logInfo('SQL DB RollBack start');
	if( util.isTizen() == false ) return;
	return dc.dbRollback();
}

function gfn_DbCommit() {
	//util.logInfo('SQL DB Commit Start !!');
	if( util.isTizen() == false ) return;
	return dc.dbCommit();
}


function initalizeSQLiteGateWay() {
	if( util.isTizen() == false ) return;

	try {
		util.logInfo("initalizeSQLiteGateWay initialize called");
		nativeApp = window.b2bapis.payment;
		result = nativeApp.initialize();
		util.logInfo("initalizeSQLiteGateWay nativeApp : " + nativeApp);
		util.logInfo("initalizeSQLiteGateWay result : "  + result);

		/************************
		 * 바코드 카메라 추가.(barcode)
		 ************************/
		b2bbarcode = window.b2bapis.b2bbarcode;
	} catch (e) {
		util.logError("initalizeSQLiteGateWay catch " + e.toString());
		util.logError("initalizeSQLiteGateWay exception code["+e.code+"], name["+e.name+"],message["+e.message+"]")
		
	}
}


/************************************************************
 * Window 환경에서 사용.
 * @param sql
 * @param param
 * @returns
 ************************************************************/
function gfn_db2_window(sql, param) {

	var params = {
		sql : sql,
		param : param
	};

	var rtnValue = null;
	$.ajax({
			type : "POST",
			url : "http://localhost:8080/database.do",
			data : JSON.stringify(params),
			async : false,
			dataType : "json",
			contentType : 'application/json; charset=UTF-8',
			success : function(msg) {
				rtnValue = msg;
			},
			error : function(request, status, error) {
				util.logError('---------------------------------------------------------------------------------------');
				util.logError("code: " + request.status + "\n" + "message: " + request.responseText + "\n" + "error: " + error);
				util.logError('---------------------------------------------------------------------------------------\n\n');
				throw error;
			}
		});

	return rtnValue;
}

function gfn_validate_NotNull(obj, msg){
	if ( obj === undefined || obj === null ) {
		throw msg;
	}
}

function gfn_validate_NotEmpty(obj, msg){
	gfn_validate_NotNull(obj, msg);
	if ( obj === "" ) {
		throw msg;
	}
}


/************************************************************
 * PreparedStatement 구문을 Statement 구문으로 변경(가급적 사용하지 말것)
 * @param sql
 * @param params ( Array type 으로 수신)
 * @returns 변경된 Statement 로 반환.
 ************************************************************/
function gfn_sqlBindParameters (sql, params) {
	var orgSql = sql;
	var _sql = "";

	gfn_validate_NotEmpty(sql, "SQL Query is Empty!");

	if ( params == undefined || params == null || params.length == 0) {
		//throw "물음표 갯수와 값의 갯수가 다릅니다.\n SQL : " + orgSql + " \n Parameters : " + JSON.stringify(params)  ;
		util.logInfo("gfn_sqlBindParameters 파라미터 없음 == > " + sql);
		return sql;
	}


	for ( var i = 0 ; i < params.length ; i++ ) {
		var startPos = sql.indexOf("?");

		if ( startPos == -1 ) {
			util.logError("물음표 갯수와 값의 갯수가 다릅니다.\n SQL : " + orgSql + " \n Parameters : " + JSON.stringify(params));
			throw "물음표 갯수와 값의 갯수가 다릅니다.\n SQL : " + orgSql + " \n Parameters : " + JSON.stringify(params)  ;
		}

		var X5 = params[i];

		var __pre__str__ = sql.substring(0, startPos  );
		var __sub__str__ = sql.substring(startPos + 1 );

		_sql += __pre__str__ ;

		if ( typeof X5 == "string" ) {
			X5 = X5.replace(/\'/g,"''");
			_sql += "'" + X5 + "'";
		} else if (X5 == undefined || X5 == null )  {

			_sql +=  "null" ;

		} else {

			_sql += X5 ;

		}

		sql = __sub__str__ ;
	}

	_sql += sql;

	if ( sql.indexOf("?") != -1 )  {
		throw "물음표 갯수와 값의 갯수가 다릅니다.\n SQL :\n " + orgSql +" parameters Length : " + params.length + " \n Parameters : " + JSON.stringify(params)  ;
	}
//	util.log("원  본 SQL \n: " + orgSql);
//	util.log("완셩된 SQL \n: " + _sql);

//	if ( _sql.indexOf( 'undefined') != -1) {
//		throw "undefined 발생.";
//	}

	return _sql ;
}
