/*****************************************************************************************
 * 프린터 관련 SQL.
 *****************************************************************************************/
var PrintSQL = function() {
	/************************************************************************************************
	 * PARAMETER  1 : pinSelectType		: 0:매출 1:중간계산서용
	 ************************************************************************************************/
	this.GetSalesDataSQL = function (paramObj , pinSelectType ) {
		var params		= [];
		var csQrySql	= "" ;
		var csQryTail	= "";
		var csQryHead	= "";
		if( pinSelectType == 0 ) {
			// 2014-1124-Jane : 현금IC 추가.
			csQryHead = ""
				+"\nSELECT                                                                                                                                              ".rtrim()
				+"\n       ( TOT_DC_AMT   + CASE WHEN TOT_ETC_AMT > 50 THEN 0 ELSE TOT_ETC_AMT END ) * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END AS TOT_DC_AMT        ".rtrim()
				+"\n     , ( DCM_SALE_AMT - CASE WHEN TOT_ETC_AMT > 50 THEN 0 ELSE TOT_ETC_AMT END ) * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END AS DCM_SALE_AMT      ".rtrim()
				+"\n     , CASE WHEN TOT_ETC_AMT > 50 THEN 0 ELSE TOT_ETC_AMT END                    * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END AS TOT_ETC_AMT       ".rtrim()
				+"\n     , TOT_SALE_AMT                                               * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS TOT_SALE_AMT      ".rtrim()
				+"\n     , SVC_TIP_AMT                                                * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS SVC_TIP_AMT       ".rtrim()
				+"\n     , VAT_SALE_AMT                                               * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS VAT_SALE_AMT      ".rtrim()
				+"\n     , VAT_AMT                                                    * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS VAT_AMT           ".rtrim()
				+"\n     , NO_VAT_SALE_AMT                                            * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS NO_VAT_SALE_AMT   ".rtrim()
				+"\n     , NO_TAX_SALE_AMT                                            * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS NO_TAX_SALE_AMT   ".rtrim()
				+"\n     , GST_PAY_AMT                                                * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS GST_PAY_AMT       ".rtrim()
				+"\n     , RET_PAY_AMT                                                * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS RET_PAY_AMT       ".rtrim()
				+"\n     , CASH_AMT                                                   * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS CASH_AMT          ".rtrim()
				+"\n     , CASH_BILL_AMT                                              * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS CASH_BILL_AMT     ".rtrim()
				+"\n     , CRD_CARD_AMT                                               * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS CRD_CARD_AMT      ".rtrim()
				+"\n     , WES_AMT                                                    * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS WES_AMT           ".rtrim()
				+"\n     , TK_GFT_AMT                                                 * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS TK_GFT_AMT        ".rtrim()
				+"\n     , TK_FOD_AMT                                                 * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS TK_FOD_AMT        ".rtrim()
				+"\n     , CST_POINT_AMT                                              * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS CST_POINT_AMT     ".rtrim()
				+"\n     , JCD_CARD_AMT                                               * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS JCD_CARD_AMT      ".rtrim()
				+"\n     , RFC_AMT                                                    * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS RFC_AMT           ".rtrim()
				+"\n     , ETC_APPR_AMT                                               * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS ETC_APPR_AMT      ".rtrim()
				+"\n     , DC_GEN_AMT 	                                              * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS DC_GEN_AMT        ".rtrim()
				+"\n     , DC_SVC_AMT 	                                              * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS DC_SVC_AMT        ".rtrim()
				+"\n     , DC_PCD_AMT 	                                              * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS DC_PCD_AMT        ".rtrim()
				+"\n     , DC_CPN_AMT 	                                              * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS DC_CPN_AMT        ".rtrim()
				+"\n     , DC_CST_AMT 	                                              * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS DC_CST_AMT        ".rtrim()
				+"\n     , DC_TFD_AMT 	                                              * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS DC_TFD_AMT        ".rtrim()
				+"\n     , DC_PRM_AMT 	                                              * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS DC_PRM_AMT        ".rtrim()
				+"\n     , DC_CRD_AMT 	                                              * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS DC_CRD_AMT        ".rtrim()
				+"\n     , DC_PACK_AMT	                                              * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END                AS DC_PACK_AMT       ".rtrim()
				+"\n     , INS_DT                                                                                                        ".rtrim()
				+"\n     , EMP_NO                                                                                                        ".rtrim()
				+"\n     , PAY_OUT_DT                                                                                                    ".rtrim()
				+"\n     , ( SELECT EMP_NM FROM SCD_EMPMS_T WHERE SHOP_CD  = A.SHOP_CD AND EMP_NO = A.EMP_NO  )     AS EMP_NM            ".rtrim()
				+"\n     , TB.TBL_NM                                                                                AS TBL_NM            ".rtrim()
				+"\n     , TB.TG_NM                                                                                AS TG_NM            ".rtrim()
				+"\n     , TB.TABLE_NM                                                                                AS TABLE_NM            ".rtrim()
				+"\n     , A.TRAVEL_CD                                                                              AS TRAVEL_CD         ".rtrim()
				+"\n     , ( SELECT TRAVEL_NM                                                                                            ".rtrim()
				+"\n         FROM SCD_TRVMS_T                                                                                            ".rtrim()
				+"\n         WHERE SHOP_CD   = A.SHOP_CD                                                                                 ".rtrim()
				+"\n         AND   TRAVEL_CD = A.TRAVEL_CD )                                                        AS TRAVEL_NM         ".rtrim()
				+"\n     , A.RSV_NO                                                                                 AS RSV_NO            ".rtrim()
				+"\n     , A.RSV_USER_NM                                                                            AS RSV_USER_NM       ".rtrim()
				+"\n     , A.RSV_USER_TEL_NO                                                                        AS RSV_USER_TEL_NO   ".rtrim()
				+"\n     , A.PRE_PAY_CARD                                                                           AS PRE_PAY_CARD      ".rtrim()
				+"\n     , A.PRE_PAY_CASH                                                                           AS PRE_PAY_CASH      ".rtrim()
				+"\n     , ( SELECT SUM(APPR_AMT)                                                                                        ".rtrim()
				+"\n           FROM  SSL_TRCRD_T                                                                                         ".rtrim()
				+"\n          WHERE  SHOP_CD   = ?                                                                                       ".rtrim()
				+"\n	          AND  SALE_DATE = ?                                                                                     ".rtrim()
				+"\n	          AND  POS_NO    = ?                                                                                     ".rtrim()
				+"\n	          AND  BILL_NO   = ?                                                                                     ".rtrim()
				+"\n	          AND  UNION_PAY_FG = '4' ) * CASE WHEN SALE_YN = 'N' THEN -1 ELSE 1 END AS CASH_IC_AMT                  ".rtrim()// 2014-1117-Jane : 현금IC 결제금액 추가.
				+"\n  FROM SSL_TRHDR_T A                                                                                                 ".rtrim()
				+"\n       LEFT OUTER JOIN ( SELECT B.TABLE_CD                                                                           ".rtrim()
				+"\n                              , C.TG_NM || ' - ' || B.TABLE_NM AS TBL_NM                                             ".rtrim()
				+"\n                              , C.TG_NM AS TG_NM, B.TABLE_NM AS TABLE_NM                                             ".rtrim()
				+"\n                         FROM SCD_TABLE_T B                                                                          ".rtrim()
				+"\n                            , SCD_TBGRP_T C                                                                          ".rtrim()
				+"\n                         WHERE B.SHOP_CD = ?                                                                         ".rtrim()
				+"\n                         AND   C.SHOP_CD = B.SHOP_CD                                                                 ".rtrim()
				+"\n                         AND   C.TG_CD   = B.TG_CD ) TB                                                              ".rtrim()
				+"\n       ON TB.TABLE_CD = A.FD_TBL_CD                                                                                  ".rtrim()
				+"\n  WHERE A.SHOP_CD   = ?                                                                                              ".rtrim()
				+"\n  AND   A.SALE_DATE = ?                                                                                              ".rtrim()
				+"\n  AND   A.POS_NO    = ?                                                                                              ".rtrim()
				+"\n  AND   A.BILL_NO   = ?                                                                                              ".rtrim()
				;
			params.push( paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO ) ;
			params.push( paramObj.SHOP_CD , paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO );


		} else if ( paramObj.csTitle == "<< 단체 중간계산서 >>" ) { // 단체 중간계산서 합계 금액 계산 (by Ilgeun Oh, 200115)

			csQryHead = ""
				+ "\n SELECT SUM ( TOT_SALE_AMT )                                                          AS TOT_SALE_AMT    ".rtrim()
				+ "\n      , SUM ( SVC_TIP_AMT )                                                           AS SVC_TIP_AMT     ".rtrim()
				+ "\n      , SUM ( VAT_SALE_AMT )                                                          AS VAT_SALE_AMT    ".rtrim()
				+ "\n      , SUM ( VAT_AMT )                                                               AS VAT_AMT         ".rtrim()
				+ "\n      , SUM ( NO_VAT_SALE_AMT )                                                       AS NO_VAT_SALE_AMT ".rtrim()
				+ "\n      , SUM ( NO_TAX_SALE_AMT )                                                       AS NO_TAX_SALE_AMT ".rtrim()
				+ "\n      , SUM ( GST_PAY_AMT )                                                           AS GST_PAY_AMT     ".rtrim()
				+ "\n      , SUM ( DC_GEN_AMT )                                                            AS DC_GEN_AMT      ".rtrim()
				+ "\n      , SUM ( DC_SVC_AMT )                                                            AS DC_SVC_AMT      ".rtrim()
				+ "\n      , SUM ( DC_PCD_AMT )                                                            AS DC_PCD_AMT      ".rtrim()
				+ "\n      , SUM ( DC_CPN_AMT )                                                            AS DC_CPN_AMT      ".rtrim()
				+ "\n      , SUM ( DC_CST_AMT )                                                            AS DC_CST_AMT      ".rtrim()
				+ "\n      , SUM ( DC_TFD_AMT )                                                            AS DC_TFD_AMT      ".rtrim()
				+ "\n      , SUM ( DC_PRM_AMT )                                                            AS DC_PRM_AMT      ".rtrim()
				+ "\n      , SUM ( DC_CRD_AMT )                                                            AS DC_CRD_AMT      ".rtrim()
				+ "\n      , SUM ( DC_PACK_AMT )                                                           AS DC_PACK_AMT     ".rtrim()
				+ "\n      , SUM ( TOT_DC_AMT   + CASE WHEN TOT_ETC_AMT > 50 THEN 0 ELSE TOT_ETC_AMT END ) AS TOT_DC_AMT      ".rtrim()
				+ "\n      , SUM ( DCM_SALE_AMT - CASE WHEN TOT_ETC_AMT > 50 THEN 0 ELSE TOT_ETC_AMT END ) AS DCM_SALE_AMT    ".rtrim()
				+ "\n      , SUM ( CASE WHEN TOT_ETC_AMT > 50 THEN 0 ELSE TOT_ETC_AMT END )                AS TOT_ETC_AMT     ".rtrim()
				+ "\n   FROM POS_ODHDR_T                                                                       ".rtrim()
				+ "\n  WHERE SHOP_CD   = ?                                                                     ".rtrim()
				+ "\n  AND   SALE_DATE = ?                                                                     ".rtrim()
				+ "\n  AND   ORDER_NO IN ( SELECT C.ORDER_NO                                                   ".rtrim()
				+ "\n  FROM POS_ODHDR_T C                                                                      ".rtrim()
				+ "\n  , SCD_TABLE_T D                                                                         ".rtrim()
				+ "\n  WHERE C.SHOP_CD = ?                                                                     ".rtrim()
				+ "\n  AND C.SALE_DATE = ?                                                                     ".rtrim()
				+ "\n  AND C.ORDER_END_FG = '0'                                                                ".rtrim()
				+ "\n  AND D.TABLE_CD = C.FD_TBL_CD                                                            ".rtrim()
				+ "\n  AND D.GROUP_CD = ?                                                                      ".rtrim()
				+ "\n  ORDER BY C.FD_TBL_CD )                                                                  ".rtrim()
				+ "\n  GROUP BY SHOP_CD, SALE_DATE                                                             ".rtrim()
				;
			params.push ( paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.csGroupCd );

		} else {

			csQryHead = ""
				+"\n SELECT TOT_SALE_AMT                                                            ".rtrim()
		        +"\n      , TOT_DC_AMT   + CASE WHEN TOT_ETC_AMT > 50 THEN 0 ELSE TOT_ETC_AMT END AS TOT_DC_AMT    ".rtrim()
				+"\n      , DCM_SALE_AMT - CASE WHEN TOT_ETC_AMT > 50 THEN 0 ELSE TOT_ETC_AMT END AS DCM_SALE_AMT  ".rtrim()
				+"\n      , CASE WHEN TOT_ETC_AMT > 50 THEN 0 ELSE TOT_ETC_AMT END                AS TOT_ETC_AMT   ".rtrim()
				+"\n      , SVC_TIP_AMT                                                             ".rtrim()
				+"\n      , VAT_SALE_AMT                                                            ".rtrim()
				+"\n      , VAT_AMT	                                                                ".rtrim()
				+"\n      , NO_VAT_SALE_AMT	                                                        ".rtrim()
				+"\n      , NO_TAX_SALE_AMT	                                                        ".rtrim()
				+"\n      , GST_PAY_AMT                                                             ".rtrim()
				+"\n      , DC_GEN_AMT                                                              ".rtrim()
				+"\n      , DC_SVC_AMT                                                              ".rtrim()
				+"\n      , DC_PCD_AMT                                                              ".rtrim()
				+"\n      , DC_CPN_AMT                                                              ".rtrim()
				+"\n      , DC_CST_AMT                                                              ".rtrim()
				+"\n      , DC_TFD_AMT                                                              ".rtrim()
				+"\n      , DC_PRM_AMT                                                              ".rtrim()
				+"\n      , DC_CRD_AMT                                                              ".rtrim()
				+"\n      , DC_PACK_AMT                                                             ".rtrim()
				+"\n   FROM POS_ODHDR_T                                                             ".rtrim()
				+"\n  WHERE SHOP_CD   = ?                                                           ".rtrim()
				+"\n    AND SALE_DATE = ?                                                           ".rtrim()
				+"\n    AND ORDER_NO  = ?                                                           ".rtrim()
				;
			params = [ paramObj.SHOP_CD , paramObj.SALE_DATE, paramObj.ORDER_NO ];

		}

		csQrySql = csQryHead + csQryTail;

		return {
			sql : csQrySql
			, params : params
		}
	}
	this.GetSalesCardCollectDataSQL = function (paramObj ) {
		var csQrySql	    = "" ;
		var csTemp	        = "" ;
		var params			= [];

		if( paramObj.BILL_NO !=  ""  ) {
			if( paramObj.csLineNoCut == "Y"  ) {
				if( g_csCornerSetFg != "1")  {
					csTemp =  "AND   A.LINE_NO = '%s' ".sprintf (  paramObj.csLineNo );
				}
				else {
					csTemp =   "\n       AND   A.LINE_NO = '%s' "
							 + "\n       AND   A.SEQ_NO  = '%s' "
							 ;
					csTemp = csTemp.sprintf(  paramObj.csLineNo, paramObj.csLineSeqNo );
				}
			}
			else {
				if( paramObj.csLineNo != ""  ) {
					csTemp = "\n     AND   A.LINE_NO >= '%s' ".sprintf(  paramObj.csLineNo  );
				}
			}

			csQrySql = ""
					  + "\n  SELECT A.LINE_NO                                                                            AS LINE_NO         ".rtrim()
		              + "\n       , A.CORNER_CD                                                                          AS CORNER_CD       ".rtrim()
					  + "\n       , CASE WHEN A.CORNER_CD = '00' THEN (SELECT SHOP_NM FROM SCD_SHOPM_T WHERE SHOP_CD = A.SHOP_CD) ELSE C.CORNER_NM END  AS CORNER_NM  ".rtrim()
					  + "\n       , A.ISS_CRDCP_NM                                                                       AS ISS_CRDCP_NM    ".rtrim()
					  + "\n       , A.CRD_CARD_NO                                                                        AS CRD_CARD_NO     ".rtrim()
					  + "\n       , A.INST_MM_FG                                                                         AS INST_MM_FG      ".rtrim()
					  + "\n       , A.INST_MM_CNT                                                                        AS INST_MM_CNT     ".rtrim()
					  + "\n       , A.VALID_TERM                                                                         AS VALID_TERM      ".rtrim()
		              + "\n       , A.APPR_DATE                                                                          AS APPR_DATE       ".rtrim()
					  + "\n       , A.APPR_TIME                                                                          AS APPR_TIME       ".rtrim()
					  + "\n       , A.APPR_NO                                                                            AS APPR_NO         ".rtrim()
					  + "\n       , A.CRDCP_CD                                                                           AS CRDCP_CD        ".rtrim()
		              + "\n       , A.CARD_IN_FG                                                                         AS CARD_IN_FG      ".rtrim()
					  + "\n       , A.VAN_TERM_NO                                                                        AS VAN_TERM_NO     ".rtrim()
					  + "\n       , A.SIGN_PAD_YN                                                                        AS SIGN_PAD_YN     ".rtrim()
					  + "\n       , A.SALE_YN                                                                            AS SALE_YN         ".rtrim()
					  + "\n       , A.CRDCP_TERM_NO                                                                      AS CRDCP_TERM_NO   ".rtrim()
					  + "\n       , A.EMP_NO                                                                             AS EMP_NO          ".rtrim()
					  + "\n       , A.GIFT_CASH                                                                          AS GIFT_CASH       ".rtrim()
					  + "\n       , A.NOTICE_MSG                                                                         AS NOTICE_MSG      ".rtrim()
					  + "\n       , A.BROAD_MSG                                                                          AS BROAD_MSG       ".rtrim()
					  + "\n       , A.CNMK_CD                                                                            AS CNMK_CD         ".rtrim()
					  + "\n       , A.DDC_FLAG                                                                           AS DDC_FLAG        ".rtrim()
					  + "\n       , A.ORG_APPR_DATE                                                                      AS ORG_APPR_DATE   ".rtrim()
					  + "\n       , A.ORG_APPR_NO                                                                        AS ORG_APPR_NO     ".rtrim()
					  + "\n       , A.APPR_PROC_FG                                                                       AS APPR_PROC_FG    ".rtrim()// 2014-0716-Jane : .
					  + "\n       , A.UNION_PAY_FG                                                                       AS UNION_PAY_FG    ".rtrim()// 2014-1124-Jane : UNION_PAY_FG 추가.
					  + "\n       , A.PUR_CRDCP_NM                                                                       AS PUR_CRDCP_NM    ".rtrim()
					  + "\n       , CASE WHEN A.SALE_YN = 'N' THEN A.APPR_AMT * -1 ELSE A.APPR_AMT END                   AS APPR_AMT        ".rtrim()
					  //+ "\n       , ( SELECT COM_CD_NM FROM SP_GET_CCD_CODEM_NM( '059', A.INST_MM_FG ) )                 AS INST_MM_NM      ".rtrim()

					+ this.SP_GET_CCD_CODEM_NM_SQL( "059" , "A.INST_MM_FG") + " AS INST_MM_NM      ".rtrim()

					  + "\n       , A.APPR_DATE || A.APPR_TIME                                                           AS APPR_DATETIME   ".rtrim()
		              + "\n       , CASE WHEN A.SALE_YN = 'N' THEN A.VAT_AMT     * -1 ELSE A.VAT_AMT     END             AS VAT_AMT         ".rtrim()
		              + "\n       , CASE WHEN A.SALE_YN = 'N' THEN A.SVC_TIP_AMT * -1 ELSE A.SVC_TIP_AMT END             AS SVC_TIP_AMT     ".rtrim()
					  + "\n       , ( SELECT EMP_NM FROM SCD_EMPMS_T WHERE SHOP_CD  = A.SHOP_CD AND EMP_NO = A.EMP_NO  ) AS EMP_NM          ".rtrim()
		              + "\n  FROM SSL_TRCRD_T A                                                                                             ".rtrim()
					  + "\n       LEFT OUTER JOIN SCD_SHOPS_T C                                                                             ".rtrim()
					  + "\n       ON  C.SHOP_CD   = A.SHOP_CD                                                                               ".rtrim()
					  + "\n       AND C.CORNER_CD = A.CORNER_CD                                                                             ".rtrim()
		              + "\n  WHERE A.SHOP_CD      = ?                                                                                       ".rtrim()
		              + "\n  AND   A.SALE_DATE    = ?                                                                                       ".rtrim()
		              + "\n  AND   A.POS_NO       = ?                                                                                       ".rtrim()
		              + "\n  AND   A.BILL_NO      = ?                                                                                       ".rtrim()
		              + csTemp
		              + "\n  AND   A.APPR_PROC_FG IN ( '1', '2', '5' )                                                                       ".rtrim() // 2010-0103-JJM : 임의등록 출력 추가. // 2015-0826-Jane : 보안CAT 대리승인 추가.
					  + "\n  AND   A.UNION_PAY_FG <> '6'                                                                                     ".rtrim()
					  + "\n  AND   A.UNION_PAY_FG <> '7'                                                                                     ".rtrim()
					  + "\n  ORDER BY A.LINE_NO                                                                                              ".rtrim()
					  + "\n         , APPR_DATETIME                                                                                          ".rtrim()
				;
			params.push( paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO  );

		} else {
			if( paramObj.csLineNoCut ==  "Y" ) {
				csTemp =  "AND   D.LINE_NO = '%s' ".sprintf( paramObj.csLineNo );
			}
			else {
				if( paramObj.csLineNo != "" ) {
					csTemp =   "AND   D.LINE_NO >= '%s' ".sprintf ( paramObj.csLineNo );
				}
			}

			csQrySql= ""
					+ "\n SELECT D.LINE_NO                                                                           AS LINE_NO         ".rtrim()
					+ "\n      , A.CORNER_CD                                                                         AS CORNER_CD       ".rtrim()
					+ "\n      , CASE WHEN A.CORNER_CD = '00' THEN (SELECT SHOP_NM FROM SCD_SHOPM_T WHERE SHOP_CD = A.SHOP_CD) ELSE C.CORNER_NM END  AS CORNER_NM  ".rtrim()
					+ "\n      , A.ISS_CRDCP_NM                                                                      AS ISS_CRDCP_NM    ".rtrim()
					+ "\n      , A.CRD_CARD_NO                                                                       AS CRD_CARD_NO     ".rtrim()
					+ "\n      , A.INST_MM_FG                                                                        AS INST_MM_FG      ".rtrim()
					+ "\n      , A.INST_MM_CNT                                                                       AS INST_MM_CNT     ".rtrim()
					+ "\n      , A.VALID_TERM                                                                        AS VALID_TERM      ".rtrim()
					+ "\n      , A.APPR_DATE                                                                         AS APPR_DATE       ".rtrim()
					+ "\n      , A.APPR_TIME                                                                         AS APPR_TIME       ".rtrim()
					+ "\n      , A.APPR_NO                                                                           AS APPR_NO         ".rtrim()
					+ "\n      , A.CRDCP_CD                                                                          AS CRDCP_CD        ".rtrim()
					+ "\n      , A.CARD_IN_FG                                                                        AS CARD_IN_FG      ".rtrim()
					+ "\n      , A.VAN_TERM_NO                                                                       AS VAN_TERM_NO     ".rtrim()
					+ "\n      , A.SIGN_PAD_YN                                                                       AS SIGN_PAD_YN     ".rtrim()
					+ "\n      , D.SALE_YN                                                                           AS SALE_YN         ".rtrim()
					+ "\n      , A.CRDCP_TERM_NO                                                                     AS CRDCP_TERM_NO   ".rtrim()
					+ "\n      , D.EMP_NO                                                                            AS EMP_NO          ".rtrim()
					+ "\n      , A.GIFT_CASH                                                                         AS GIFT_CASH       ".rtrim()
					+ "\n      , A.NOTICE_MSG                                                                        AS NOTICE_MSG      ".rtrim()
					+ "\n      , A.BROAD_MSG                                                                         AS BROAD_MSG       ".rtrim()
					+ "\n      , A.CNMK_CD                                                                           AS CNMK_CD         ".rtrim()
					+ "\n      , A.DDC_FLAG                                                                          AS DDC_FLAG        ".rtrim()
					+ "\n      , A.ORG_APPR_DATE                                                                     AS ORG_APPR_DATE   ".rtrim()
					+ "\n      , A.ORG_APPR_NO                                                                       AS ORG_APPR_NO     ".rtrim()
					+ "\n      , A.APPR_PROC_FG                                                                      AS APPR_PROC_FG    ".rtrim() // 2014-0716-Jane : .
					+ "\n      , A.UNION_PAY_FG                                                                      AS UNION_PAY_FG    ".rtrim() // 2014-1124-Jane : Union_Pay_FG 추가.
					+ "\n      , A.PUR_CRDCP_NM                                                                      AS CRDCP_NM        ".rtrim()
					+ "\n      , A.APPR_DATE || A.APPR_TIME                                                          AS APPR_DATETIME   ".rtrim()
					+ "\n      , CASE WHEN A.APPR_FG = '1' THEN A.APPR_AMT * -1 ELSE A.APPR_AMT END                  AS APPR_AMT        ".rtrim()

					+ this.SP_GET_CCD_CODEM_NM_SQL( "059" , "A.INST_MM_FG") + " AS INST_MM_NM      ".rtrim()

					+ "\n      , CASE WHEN A.APPR_FG = '1' THEN A.VAT_AMT     * -1 ELSE A.VAT_AMT     END            AS VAT_AMT         ".rtrim()
					+ "\n      , CASE WHEN A.APPR_FG = '1' THEN A.SVC_TIP_AMT * -1 ELSE A.SVC_TIP_AMT END            AS SVC_TIP_AMT     ".rtrim()
					+ "\n      , ( SELECT EMP_NM FROM SCD_EMPMS_T WHERE SHOP_CD  = D.SHOP_CD AND EMP_NO = D.EMP_NO ) AS EMP_NM          ".rtrim()
					+ "\n   FROM POS_LGCRD_T A                       ".rtrim()
					+ "\n      LEFT OUTER JOIN SCD_SHOPS_T C         ".rtrim()
					+ "\n      ON  A.SHOP_CD   = C.SHOP_CD           ".rtrim()
					+ "\n      AND A.CORNER_CD = C.CORNER_CD         ".rtrim()
					+ "\n      INNER JOIN POS_ODCRD_T D              ".rtrim()
					+ "\n      ON  A.SHOP_CD     = D.SHOP_CD         ".rtrim()
					+ "\n      AND A.SALE_DATE   = D.SALE_DATE       ".rtrim()
					+ "\n      AND A.APPR_LOG_NO = D.APPR_LOG_NO     ".rtrim()
					+ "\n  WHERE A.SHOP_CD      = ?                  ".rtrim()
					+ "\n    AND A.SALE_DATE    = ?                  ".rtrim()
					+ "\n    AND D.ORDER_NO     = ?                  ".rtrim()
					+ csTemp
					+ "\n    AND A.APPR_PROC_FG IN ( '1', '2', '5' ) ".rtrim()  // 2011-0103-JJM : 임의등록 출력 추가. // 2015-0826-Jane : 보안CAT 대리승인 추가.
					+ "\n    AND A.UNION_PAY_FG <> '6'               ".rtrim()
					+ "\n  ORDER BY D.LINE_NO                        ".rtrim()
					+ "\n        , APPR_DATETIME                     ".rtrim()
					;
				params.push( paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.ORDER_NO   );
		}

		return {
			sql : csQrySql
			, params : params
		}
	}
	this.GetEnvXmlShopINFOSQL = function () {
		var sql = ""
		  + "\n SELECT                                                ".rtrim()
		  + "\n        A.SHOP_NM                    AS SHOP_NM        ".rtrim()
		  + "\n      , A.HD_SHOP_CD                 AS HD_SHOP_CD     ".rtrim()
		  + "\n      , A.PGM_TYPE_FG                AS PGM_TYPE_FG    ".rtrim()
		  + "\n      , A.OWNER_NM                   AS OWNER_NM       ".rtrim()
		  + "\n      , A.BIZ_NO                     AS BIZ_NO         ".rtrim()
		  + "\n      , A.TEL_NO                     AS TEL_NO         ".rtrim()
		  + "\n      , A.ADDR || ' ' || A.ADDR_DTL  AS ADDRESS        ".rtrim()
		  + "\n      , B.SALE_MG_CNT                AS SALE_MG_CNT    ".rtrim()
		  + "\n      , A.SALEMG_MGR_YN              AS SALEMG_MGR_YN  ".rtrim()
		  + "\n      , A.SHOP_STAT_FG               AS SHOP_STAT_FG   ".rtrim()
		  + "\n      , A.BIZ_SHOP_NM                AS BIZ_SHOP_NM    ".rtrim()
		  + "\n      , A.VAN_CORP_CD                AS VAN_CORP_CD    ".rtrim()
		  + "\n      , A.POINT_FG                   AS POINT_FG       ".rtrim()
		  + "\n   FROM SCD_SHOPM_T A                                  ".rtrim()
		  + "\n    , ( SELECT COUNT( SALE_MG_CD ) AS SALE_MG_CNT      ".rtrim()
		  + "\n        FROM SCD_SLMGM_T                               ".rtrim()
		  + "\n        WHERE SHOP_CD = ?                              ".rtrim()
		  + "\n        AND USE_YN    = 'Y' ) B                        ".rtrim()
		  + "\n  WHERE A.SHOP_CD = ?                                  ".rtrim()
		 ;
		 return sql;
	}
	this.GetEnvXmlShopENV_SQL = "SELECT ENV_SET_VAL FROM SCD_ENVSH_T WHERE SHOP_CD = ? AND ENV_SET_CD = ?  ";
	this.GetEnvXmlPosENV_SQL  = "SELECT ENV_SET_VAL FROM SCD_ENVPS_T WHERE SHOP_CD = ? AND POS_NO = ? AND ENV_SET_CD = ? /** 단발성 SQL **/ ";

	this.GetProductListData_SQL = function( pcsCode , pObj , pInOrderBy , pblSales) {
		var csQrySql	= "";
		var csSubQrySql = "";
		var params = [];

		if( pblSales ) {

			////////////////////////////////////////////////////////////////////////
			//2010-0106-YBC : 대기교환권에서 사이드메뉴 출력순서 ORDER BY 절에 추가.
			//// 2016-09-27-JYL [곱빼기] : PROP_CD 추가
			////////////////////////////////////////////////////////////////////////
			if( pcsCode == "{코너별-메뉴목록}" ) {
				csQrySql = ""
					+"\nSELECT                                                                                              ".rtrim()
					+"\n	   A.PROD_CD                                                                   AS PROD_CD       ".rtrim()
					+"\n     , A.NORMAL_UPRC                                                               AS NORMAL_UPRC   ".rtrim()
					+"\n     , A.SALE_UPRC                                                                 AS UPRC          ".rtrim()
					+"\n     , A.DLV_PACK_FG                                                               AS DLV_PACK_FG   ".rtrim()
					+"\n     , A.PROP_CD                                                                   AS PROP_CD       ".rtrim() // 2016-09-27-JYL [곱빼기]
					+"\n     , A.SALE_WEIGHT                                                               AS SALE_WEIGHT   ".rtrim() // 2018-06-05-HJH
					+"\n     , B.PRICE_MGR_FG                                                              AS PRICE_MGR_FG  ".rtrim() // 2018-06-05-HJH
					+"\n     , CASE WHEN A.SALE_YN = 'N' THEN A.SALE_QTY     * -1 ELSE A.SALE_QTY     END  AS QTY           ".rtrim()
					+"\n     , CASE WHEN A.SALE_YN = 'N' THEN A.DC_AMT       * -1 ELSE A.DC_AMT       END  AS DC_AMT        ".rtrim()
					+"\n     , CASE WHEN A.SALE_YN = 'N' THEN A.SALE_QTY     * -1 ELSE A.SALE_QTY     END  AS QTY           ".rtrim()
					+"\n     , CASE WHEN A.SALE_YN = 'N' THEN A.DC_AMT       * -1 ELSE A.DC_AMT       END  AS DC_AMT        ".rtrim()
					+"\n     , CASE WHEN A.SALE_YN = 'N' THEN A.DCM_SALE_AMT * -1 ELSE A.DCM_SALE_AMT END  AS AMT           ".rtrim()
					+"\n     , LTRIM( CASE WHEN A.TAX_YN = 'N' THEN '*' ELSE '' END || CASE WHEN A.SDS_ORG_DTL_NO > '0' AND A.SDA_CD <> '' AND A.SDA_CD IS NOT NULL AND B.SIDE_MENU_YN = 'N' THEN '▶' ELSE '' END || B.PROD_NM ) AS PROD_NM       ".rtrim()
					+"\n     , CASE WHEN A.SALE_YN = 'N' THEN A.CUP_SALE_CNT * -1 ELSE A.CUP_SALE_CNT END AS CUP_SALE_CNT    ".rtrim()
					+"\n     , A.CUP_DEPOSIT_UPRC                                                         AS CUP_DEPOSIT_UPRC ".rtrim()
					+"\n     , A.CUP_FG                                                                   AS CUP_FG          ".rtrim()
					+"\n  FROM SSL_TRDTL_T A            ".rtrim()
					+"\n     , SCD_PRODM_T B            ".rtrim()
					+"\n WHERE A.SHOP_CD   = '%s'       ".rtrim()
					+"\n   AND A.SALE_DATE = '%s'       ".rtrim()
					+"\n   AND A.POS_NO    = '%s'       ".rtrim()
					+"\n   AND A.BILL_NO   = '%s'       ".rtrim()
					+"\n   AND A.CORNER_CD = '%s'       ".rtrim()
					+"\n   AND B.SHOP_CD   = A.SHOP_CD  ".rtrim()
					+"\n   AND B.PROD_CD   = A.PROD_CD  ".rtrim()
					+"\n ORDER BY A.SDS_ORG_DTL_NO      ".rtrim()
					+"       , A.DTL_NO                 ".rtrim()
					;
				csQrySql = csQrySql.sprintf(  pObj.SHOP_CD,  pObj.SALE_DATE, pObj.POS_NO, pObj.BILL_NO, pObj.CORNER_CD  );

			} else if( pcsCode == "{이용권내역}")  {
				csQrySql = ""
				+"\n SELECT B.PROD_NM 												".rtrim()
				+"\n      , A.PROP_CD 		        								".rtrim() // 2016-09-27-JYL [곱빼기]
				+"\n      , CASE WHEN A.SALE_YN = 'N' THEN  -1 ELSE 1 END * A.DCM_SALE_AMT AS UPRC  ".rtrim()
				+"\n      , CASE WHEN A.SALE_YN = 'N' THEN  -1 ELSE 1 END * A.VAT_AMT      AS VAT   ".rtrim()
				+"\n      , CASE WHEN A.SALE_YN = 'N' THEN  -1 ELSE 1 END * A.SALE_QTY     AS QTY   ".rtrim()
				+"\n      , A.SALE_WEIGHT  AS SALE_WEIGHT  							".rtrim() // 2018-06-05-HJH
				+"\n      , B.PRICE_MGR_FG AS PRICE_MGR_FG 							".rtrim() // 2018-06-05-HJH
				+"\n   FROM SSL_TRDTL_T A 											".rtrim()
				+"\n      , SCD_PRODM_T B 											".rtrim()
				+"\n  WHERE A.SHOP_CD   = '%s' 										".rtrim()
				+"\n    AND A.SALE_DATE = '%s' 										".rtrim()
				+"\n    AND A.POS_NO    = '%s' 										".rtrim()
				+"\n    AND A.BILL_NO   = '%s' 										".rtrim()
				+"\n    AND A.CORNER_CD = '%s' 										".rtrim()
				+"\n    AND B.SHOP_CD   = A.SHOP_CD 								".rtrim()
				+"\n    AND B.PROD_CD   = A.PROD_CD 								".rtrim()
				+"\n  ORDER BY A.CORNER_CD "
				;
				csQrySql = csQrySql.sprintf( pObj.SHOP_CD,  pObj.SALE_DATE, pObj.POS_NO ,pObj.BILL_NO, pObj.CORNER_CD );

			} else {
				////////////////////////////////////////////////////////////////////
				//2009-1202-YBC : 사이드메뉴 순서 때문에 ORDER BY 절에 추가.
				//매출 - 영수증 상품 내역
				//2010-0305-YBC : 사이드메뉴 순서 때문에 ORDER BY 절에 A.SDA_CD 추가.
				//2010-0813-YBC : PROD_NM 쿼리중간에 RTRIM 추가.
				////////////////////////////////////////////////////////////////////
				csQrySql = ""
					+"\n  SELECT                                                                                                                                                                       ".rtrim()
					+"\n         A.PROD_CD                                                                                                                                            AS PROD_CD       ".rtrim()
					+"\n       , A.NORMAL_UPRC                                                                                                                                        AS NORMAL_UPRC   ".rtrim()
					+"\n       , A.SALE_UPRC                                                                                                                                          AS UPRC          ".rtrim()
					+"\n       , A.PROP_CD                                                                                                                                            AS PROP_CD       ".rtrim() // 2016-09-27-JYL [곱빼기]
					+"\n       , A.SALE_WEIGHT                                                                                                                                        AS SALE_WEIGHT   ".rtrim()
					+"\n       , B.PRICE_MGR_FG                                                                                                                                       AS PRICE_MGR_FG  ".rtrim()
					+"\n       , CASE WHEN A.SALE_YN = 'N' THEN A.SALE_QTY     * -1 ELSE A.SALE_QTY     END                                                                           AS QTY           ".rtrim()
					+"\n       , CASE WHEN A.SALE_YN = 'N' THEN A.DC_AMT       * -1 ELSE A.DC_AMT       END                                                                           AS DC_AMT        ".rtrim()
					+"\n       , CASE WHEN A.SALE_YN = 'N' THEN A.DCM_SALE_AMT * -1 ELSE A.DCM_SALE_AMT END                                                                           AS AMT           ".rtrim()
					+"\n       , LTRIM( CASE WHEN A.TAX_YN = 'N' THEN '*' ELSE '' END ) || RTRIM( CASE WHEN A.SDS_ORG_DTL_NO > '0' AND A.SDA_CD <> '' AND A.SDA_CD IS NOT NULL AND B.SIDE_MENU_YN = 'N' THEN '▶' ELSE '' END ) || B.PROD_NM  AS PROD_NM  ".rtrim()
					+"\n       , CASE WHEN A.SALE_YN = 'N' THEN A.CUP_SALE_CNT * -1 ELSE A.CUP_SALE_CNT END AS CUP_SALE_CNT    ".rtrim()
					+"\n       , A.CUP_DEPOSIT_UPRC                                                         AS CUP_DEPOSIT_UPRC ".rtrim()
					+"\n       , A.CUP_FG                                                                   AS CUP_FG          ".rtrim()
					+"\n    FROM SSL_TRDTL_T A             ".rtrim()
					+"\n         INNER JOIN SCD_PRODM_T B  ".rtrim()
					+"\n         ON  A.SHOP_CD = B.SHOP_CD ".rtrim()
					+"\n         AND A.PROD_CD = B.PROD_CD ".rtrim()
					+"\n   WHERE A.SHOP_CD   = '%s'        ".rtrim()
					+"\n     AND A.SALE_DATE = '%s'        ".rtrim()
					+"\n     AND A.POS_NO    = '%s'        ".rtrim()
					+"\n     AND A.BILL_NO   = '%s'        ".rtrim()
					+"\n   ORDER BY A.SDS_ORG_DTL_NO       ".rtrim()
					+"\n         , A.SDA_CD                ".rtrim()
					+"\n         , A.DTL_NO                ".rtrim()
				;
				csQrySql = csQrySql.sprintf(pObj.SHOP_CD, pObj.SALE_DATE, pObj.POS_NO, pObj.BILL_NO );
			}

		} else {


			////////////////////////////////////////////////////////////////////////
			// 2010-0118-YBC : 고객주문서 동일금액 취소/추가시 출력안되는 현상 제거 : HAVING절 추가. 2009-1202-YBC
			// 2010-0601-YBC : 부가세별도매장에 대한 VAT 추가 처리.
			////////////////////////////////////////////////////////////////////////
			if( pcsCode == "{이전차수-메뉴목록}" ||  pcsCode == "{이전차수-메뉴목록-금액}" )	{
				csSubQrySql = ""
					 "\n SELECT             "
					+"\n        A.PROD_CD             AS PROD_CD          ".rtrim()		// 2019-04-24-SHK [정렬방식]
					+"\n      , A.DLV_PACK_FG         AS DLV_PACK_FG      ".rtrim()
					+"\n      , A.PROP_CD             AS PROP_CD          ".rtrim()		        								        	 // 2016-09-27-JYL [곱빼기]
					+"\n      , SUM( A.SALE_QTY )     AS QTY              ".rtrim()
					+"\n      , SUM( A.DCM_SALE_AMT ) AS DCM_SALE_AMT     ".rtrim()
					+"\n      , SUM( A.VAT_AMT )      AS VAT_AMT          ".rtrim()
					+"\n      , SUM( A.SALE_UPRC )    AS UPRC             ".rtrim()											// 2010-1119-YBC
					+"\n      , A.SALE_WEIGHT         AS SALE_WEIGHT      ".rtrim()											// 2018-0601-HJH
					+"\n      , B.PRICE_MGR_FG        AS PRICE_MGR_FG	  ".rtrim()														// 2018-0601-HJH
					+"\n      , MIN(ORDER_DTL_NO)     AS ORDER_DTL_NO     ".rtrim()											// 2019-04-24-SHK [정렬방식]
					+"\n      , A.SDS_ORG_DTL_NO      AS SDS_ORG_DTL_NO   ".rtrim()										// 2019-04-24-SHK [정렬방식]
					+"\n      , B.PROD_NM             AS PROD_NM_TMP      ".rtrim()													// 2019-04-24-SHK [정렬방식]
					+"\n      , B.SIDE_MENU_YN        AS SIDE_MENU_YN     ".rtrim()                             			// 2019-0807-Jane : 쿼리 오류 수정. SIDE_MENU_YN 컬럼 추가.
					+"\n      , LTRIM( CASE WHEN  B.TAX_YN = 'N' THEN '*' ELSE  '' END || B.PROD_NM ) AS PROD_NM ".rtrim()
					+"\n   FROM POS_ODDTL_T A                 ".rtrim()																// 2019-04-24-SHK [정렬방식]
					+"\n      , SCD_PRODM_T B                 ".rtrim()
					+"\n  WHERE A.SHOP_CD      = '%s'         ".rtrim()
					+"\n    AND A.SALE_DATE    = '%s'         ".rtrim()
					+"\n    AND A.ORDER_NO     = '%s'         ".rtrim()
					+"\n    AND A.ORDER_SEQ_NO < '%s'         ".rtrim()
					+"\n    AND B.SHOP_CD      = A.SHOP_CD    ".rtrim()
					+"\n    AND B.PROD_CD      = A.PROD_CD    ".rtrim()
					+"\n  GROUP BY A.PROD_CD                  ".rtrim()
					+"\n      , B.PROD_NM                     ".rtrim()
					+"\n      , A.DLV_PACK_FG                 ".rtrim()
					+"\n      , A.PROP_CD                     ".rtrim()						 							     // 2016-09-27-JYL [곱빼기]
					+"\n      , B.TAX_YN                      ".rtrim()
					+"\n 	  , B.PRICE_MGR_FG	              ".rtrim()													// 2018-0601-HJH
					+"\n 	  , A.SALE_WEIGHT	              ".rtrim()														// 2018-0601-HJH
					+"\n 	  , A.SDS_ORG_DTL_NO              ".rtrim()														// 2019-04-24-SHK [정렬방식]
					+"\n      , B.SIDE_MENU_YN                ".rtrim()																// 2019-0807-Jane : 쿼리 오류 수정. SIDE_MENU_YN 컬럼 추가.
					+"\n HAVING ( SUM( A.SALE_QTY ) <> 0 ) OR ( SUM( A.DCM_SALE_AMT ) <> 0 )      ".rtrim()
					+"\n ORDER BY MIN( A.ORDER_DTL_NO )                                           ".rtrim()
					;
				csSubQrySql = csSubQrySql.sprintf(  pObj.SHOP_CD, pObj.SALE_DATE, pObj.ORDER_NO, pObj.ORDER_SEQ_NO );
				csQrySql = "SELECT * FROM (%s) %s".sprintf(  csSubQrySql,  this.GetOrderByQuery("ORDER_DTL_NO" ,  "QTY" , "", pInOrderBy  ) ) ;		// 2019-04-24-SHK [정렬방식]
			}  else if( pcsCode == "{중간계산서-메뉴목록}"
			     ||  pcsCode == "{상품리스트1}"
				 ||  pcsCode == "{상품리스트2}"
				 ||  pcsCode == "{중간계산서-메뉴목록2}"
				 ||  pcsCode == "{중간계산서-메뉴목록3}") {
				////////////////////////////////////////////////////////////////////
				// 2010-0118-YBC : 고객주문서 동일금액 취소/추가시 출력안되는 현상 제거 : HAVING절 추가.
				// 2010-0212-YBC : 사이드 처리.
				// 2010-1006-YBC : 원산지명 추가.
				////////////////////////////////////////////////////////////////////
				if ( pObj.TITLE == "<< 단체 중간계산서 >>" )	 {	// 단체 중간계산서용 주문번호 (by Ilgeun Oh, 200115)
					csOrderNo = ""+
						+"\n    IN ( SELECT C.ORDER_NO                ".rtrim()
						+"\n           FROM POS_ODHDR_T C             ".rtrim()
						+"\n              , SCD_TABLE_T D             ".rtrim()
						+"\n          WHERE C.SHOP_CD = '%s'          ".rtrim()
						+"\n            AND C.SALE_DATE = '%s'        ".rtrim()
						+"\n            AND C.ORDER_END_FG = '0'      ".rtrim()
						+"\n            AND D.TABLE_CD = C.FD_TBL_CD  ".rtrim()
						+"\n            AND D.GROUP_CD = '%s'         ".rtrim()
						+"\n          ORDER BY C.FD_TBL_CD )          ".rtrim()
						;
					csOrderNo = csOrderNo.sprintf(  pObj.SHOP_CD, pObj.SALE_DATE, pObj.csGroupCd );
				} else {
					csOrderNo = "= '%s' " .sprintf ( pObj.ORDER_NO) ;
				}
					csSubQrySql= ""
						+ "\n SELECT A.PROD_CD              AS PROD_CD                                                                    ".rtrim() // 2019-04-24-SHK [정렬방식]
				        + "\n      , A.SALE_UPRC            AS UPRC                                                                       ".rtrim()
						+ "\n      , A.PROP_CD              AS PROP_CD                                                                    ".rtrim() // 2016-09-27-JYL [곱빼기]
						+ "\n      , SUM( A.SALE_QTY )      AS QTY                                                                        ".rtrim()
						+ "\n      , SUM( A.DCM_SALE_AMT )  AS AMT                                                                        ".rtrim()
						+ "\n      , SUM( A.SALE_UPRC )     AS SALE_UPRC                                                                  ".rtrim() // 2019-04-24-SHK [정렬방식]
						+ "\n      , A.SALE_WEIGHT          AS SALE_WEIGHT                                                                ".rtrim()
						+ "\n      , B.PRICE_MGR_FG         AS PRICE_MGR_FG                                                               ".rtrim()
				        + "\n      , MIN(ORDER_DTL_NO)      AS ORDER_DTL_NO                                                               ".rtrim() // 2019-04-24-SHK [정렬방식]
						+ "\n      , A.SDS_ORG_DTL_NO       AS SDS_ORG_DTL_NO                                                             ".rtrim() // 2019-04-24-SHK [정렬방식]
						+ "\n      , B.PROD_NM              AS PROD_NM_TMP                                                                ".rtrim() // 2019-04-24-SHK [정렬방식]
						+ "\n      , B.SIDE_MENU_YN         AS SIDE_MENU_YN                                                               ".rtrim() // 2019-07-23-SHK [정렬방식]
				        + "\n      , MIN( CASE                                                                                            ".rtrim()
				        + "\n                   WHEN  ( A.SDS_ORG_DTL_NO > '0' AND A.SDA_CD <> '' AND A.SDA_CD IS NOT NULL AND                                     ".rtrim()
				        + "\n                     CASE WHEN B.PROD_NM IS NULL THEN 'N' ELSE  B.SIDE_MENU_YN END = 'N' THEN                ".rtrim()
				        + "\n                            CASE WHEN B.PROD_NM IS NULL THEN '▷' ELSE '▶' END                              ".rtrim()
				        + "\n                   ELSE ''                                                                                   ".rtrim()
				        + "\n              END                                                                                            ".rtrim()
						+ "\n          || CASE WHEN B.PROD_NM IS NULL THEN  /** SP_GET_SDA_NM_SQL **/ (                                ".rtrim()
						+ this.SP_GET_SDA_NM_SQL( " A.SHOP_CD" , " SUBSTR( A.PROD_CD, 4, 7 ) " )
						+ "\n                                                  ) ".rtrim()

						+ "\n                                         ELSE B.PROD_NM END ) AS PROD_NM                                     ".rtrim()
						+ "\n      , MAX( ( SELECT COM_CD_NM AS ORG_PLACE_NM FROM SCD_CODEM_T WHERE SHOP_CD = '%s' AND COM_CD_FG = '003' AND COM_CD = B.ORG_PLACE_CD ) ) AS ORG_PLACE_NM ".ltrim()
						+ "\n   FROM POS_ODDTL_T A                                                                    ".rtrim() // 2019-04-24-SHK [정렬방식]
				        + "\n      , SCD_PRODM_T B                                                                    ".rtrim()
				        + "\n  WHERE A.SHOP_CD   = '%s'                                                               ".rtrim()
				        + "\n    AND A.SALE_DATE = '%s'                                                               ".rtrim()
				        + "\n    AND A.ORDER_NO     %s                                                                ".rtrim()
				        + "\n    AND B.SHOP_CD   = A.SHOP_CD                                                          ".rtrim()
				        + "\n    AND B.PROD_CD   = A.PROD_CD                                                          ".rtrim()
				        + "\n  GROUP BY A.PROD_CD                                                                     ".rtrim()
				        + "\n      , B.PROD_NM                                                                        ".rtrim()
				        + "\n      , A.SALE_UPRC                                                                      ".rtrim()
						+ "\n      , A.PROP_CD                                                                        ".rtrim() // 2016-09-27-JYL [곱빼기]
						+ "\n      , B.PRICE_MGR_FG                                                                   ".rtrim() // 2018-06-05-HJH
						+ "\n 	   , A.SALE_WEIGHT	                                                                  ".rtrim() // 2018-0601-HJH
				        + "\n 	   , A.SDS_ORG_DTL_NO                                                                 ".rtrim() // 2019-04-24-SHK [정렬방식]
						+ "\n 	   , B.SIDE_MENU_YN                                                                   ".rtrim() // 2019-07-23-SHK [정렬방식]
						+ "\n  HAVING ( SUM( A.SALE_QTY ) <> 0 ) OR ( SUM( A.DCM_SALE_AMT ) <> 0 )                    ".rtrim()
				        + "\n  ORDER BY MIN( A.ORDER_DTL_NO )                                                         ".rtrim()
						;
					csSubQrySql = csSubQrySql.sprintf( pObj.SHOP_CD, pObj.SHOP_CD, pObj.SALE_DATE, csOrderNo ) ;

					csQrySql = csQrySql.sprintf ("SELECT * FROM (%s) %s" , csSubQrySql, this.GetOrderByQuery("ORDER_DTL_NO" , "QTY" , "AMT" , pInOrderBy ));	// 2019-04-24-SHK [정렬방식]
			} else if (pcsCode == "{K-상품리스트}")  {

				csQrySql = ""                                                                                                    
					+"\n SELECT C.PROD_CD                                                                  AS PROD_CD            ".rtrim()
					+"\n  , C.NORMAL_UPRC                                                              AS NORMAL_UPRC            ".rtrim()
				    +"\n  , C.UPRC                                                                	   AS UPRC                   ".rtrim()
				    +"\n  , C.PROP_CD                                                                  AS PROP_CD                ".rtrim()
				    +"\n  , C.QTY AS QTY                                                                                     	 ".rtrim()
				    +"\n  , C.DC_AMT AS DC_AMT                                                                                   ".rtrim()
				    +"\n  , C.AMT AS AMT                                                                                         ".rtrim()
				    +"\n  , C.SIDE_MENU_YN                                                             AS SIDE_MENU_YN           ".rtrim()
				    +"\n  , C.SDS_ORG_DTL_NO                                                           AS SDS_ORG_DTL_NO         ".rtrim()
				    +"\n  , C.SALE_WEIGHT                                                              AS SALE_WEIGHT            ".rtrim()
				    +"\n  , C.PRICE_MGR_FG     														   AS PRICE_MGR_FG           ".rtrim()
					+"\n  , C.SIDE_MENU_YN      													   AS SIDE_MENU_YN           ".rtrim()
				    +"\n  , C.CUP_SALE_CNT                                                             AS CUP_SALE_CNT           ".rtrim()
				    +"\n  , C.CUP_DEPOSIT_UPRC                                                         AS CUP_DEPOSIT_UPRC       ".rtrim()
				    +"\n  , C.CUP_FG                                                                   AS CUP_FG                 ".rtrim()
				    +"\n  , CASE WHEN C.PROD_NM IS NOT NULL THEN C.PROD_NM                                                       ".rtrim()
					+"\n	ELSE (                                                                                               ".rtrim()
					+ 			this.SP_GET_SDA_NM_SQL( " C.SHOP_CD" , " SUBSTR( C.PROD_CD, 4, 7 ) " )
					+"\n	)                                                                                                    ".rtrim()
					+"\n  END AS PROD_NM                                                                                         ".rtrim()
					+"\n FROM                                                                                                    ".rtrim()
					+"\n 	(                                                                           	".rtrim()
					+"\n 		SELECT A.PROD_CD                                                                  AS PROD_CD         ".rtrim()
					+"\n      	, A.NORMAL_UPRC                                                              AS NORMAL_UPRC     ".rtrim()
					+"\n      	, A.SALE_UPRC                                                                AS UPRC            ".rtrim()
					+"\n      	, A.PROP_CD                                                                  AS PROP_CD         ".rtrim()  // 2016-09-27-JYL [곱빼기]
					+"\n      	, CASE WHEN A.SALE_YN = 'N' THEN A.SALE_QTY     * -1 ELSE A.SALE_QTY     END AS QTY             ".rtrim()
					+"\n      	, CASE WHEN A.SALE_YN = 'N' THEN A.DC_AMT       * -1 ELSE A.DC_AMT       END AS DC_AMT          ".rtrim()
					+"\n      	, CASE WHEN A.SALE_YN = 'N' THEN A.DCM_SALE_AMT * -1 ELSE A.DCM_SALE_AMT END AS AMT             ".rtrim()
					+"\n      	, CASE WHEN B.SIDE_MENU_YN IS NOT NULL THEN B.SIDE_MENU_YN ELSE 'N' END      AS SIDE_MENU_YN    ".rtrim()
					+"\n      	, A.SDS_ORG_DTL_NO                                                           AS SDS_ORG_DTL_NO  ".rtrim()  // 2019-04-24-SHK [정렬방식]
					+"\n      	, A.SALE_WEIGHT                                                              AS SALE_WEIGHT     ".rtrim()
					+"\n      	, CASE WHEN B.PRICE_MGR_FG IS NOT NULL THEN B.PRICE_MGR_FG ELSE '0' END      AS PRICE_MGR_FG    ".rtrim()
					+"\n      	, LTRIM( CASE WHEN A.TAX_YN = 'N' THEN '*' ELSE '' END ) || RTRIM( CASE WHEN A.SDS_ORG_DTL_NO > '0' AND A.SDA_CD <> '' AND A.SDA_CD IS NOT NULL AND B.SIDE_MENU_YN = 'N' THEN '▶' ELSE '' END ) || B.PROD_NM  AS PROD_NM  ".rtrim()
					+"\n      	, CASE WHEN A.SALE_YN = 'N' THEN A.CUP_SALE_CNT * -1 ELSE A.CUP_SALE_CNT END AS CUP_SALE_CNT    ".rtrim()
					+"\n      	, A.CUP_DEPOSIT_UPRC                                                         AS CUP_DEPOSIT_UPRC ".rtrim()
					+"\n      	, A.CUP_FG                                                                   AS CUP_FG          ".rtrim()
					+"\n      	, CASE WHEN (A.SDA_CD = ' ' OR A.SDA_CD = '' OR A.SDA_CD IS NULL) THEN 'zzzzz' ELSE A.SDA_CD END AS SDA_CD ".rtrim()
					+"\n      	, A.SHOP_CD AS SHOP_CD ".rtrim()
					//+"\n      , LTRIM( IIF( A.TAX_YN = 'N', '*', '' ) || RTRIM( IIF( A.SDS_ORG_DTL_NO > '0' AND A.SDA_CD <> '' AND B.SIDE_MENU_YN = 'N', '▶', '' ) ) || B.PROD_NM ) PROD_NM     ".rtrim()
					+"\n 	FROM SSL_TRDTL_T A                                                                                                                                                     ".rtrim()
					+"\n      	LEFT OUTER JOIN SCD_PRODM_T B                                                                                                                                          ".rtrim()
					+"\n      	ON  A.SHOP_CD = B.SHOP_CD                                                                                                                                         ".rtrim()
					+"\n      	AND A.PROD_CD = B.PROD_CD                                                                                                                                         ".rtrim()
					+"\n WHERE A.SHOP_CD   = '%s'                                                                                                                                               ".rtrim()
					+"\n AND   A.SALE_DATE = '%s'                                                                                                                                               ".rtrim()
					+"\n AND   A.POS_NO    = '%s'                                                                                                                                               ".rtrim()
					+"\n AND   A.BILL_NO   = '%s'                                                                                                                                               ".rtrim()
					+"\n ORDER BY A.SDS_ORG_DTL_NO                                                                                                                                              ".rtrim()
					+"\n        , A.DTL_NO                                                                                                                                                      ".rtrim()
					+"\n        , SDA_CD    	".rtrim() // 2021-12-01 SDA_CD가 있는게 먼저 나와야 하는데, 반대로 ' ' 들어간게 먼저 나와서 ' ' 들어간 데이터를 zzzzzz로 치환하여 순위를 낮춰서 정렬 처리
					+"\n     ) C    			".rtrim()
				;
				csQrySql = csQrySql.sprintf(pObj.SHOP_CD,pObj.SALE_DATE,pObj.POS_NO,pObj.BILL_NO );
				

			} else {
				/////////////////////////////////////////////////////////////////////
				// 2009-1202-YBC
				// 2010-0113-YBC : A.DCM_SALE_AMT 추가.
				// 2010-0211-YBC : 사이드메뉴 속성명 추가 처리.
				// 2010-0601-YBC : 부가세별도매장에 대한 VAT 추가 처리.
				// 2011-0113-YBC : SALE_AMT 부분에 대한 합계 처리가 안되어져 있었음. A.SALE_AMT->SUM( A.SALE_AMT ) 변경.
				// 2014-0711 Antony.Choi : DCM_SALE_AMT 부분에 대한 합계 처리가 안되어져 있었음. A.DCM_SALE_AMT->SUM( A.DCM_SALE_AMT ) 변경.
				// 2014-0711 Antony.Choi : ORDER_DTL_FG 추가.
				////////////////////////////////////////////////////////////////////
				csSubQrySql =
					 "\n SELECT A.PROD_CD                                  AS PROD_CD                                                              ".rtrim() // 2019-04-24-SHK [정렬방식]
					+"\n      , A.PROD_NM                                  AS PROD_NM                                                              ".rtrim()
					+"\n      , A.SIDE_MENU_YN                             AS SIDE_MENU_YN                                                         ".rtrim()
					+"\n      , A.SDS_ORG_DTL_NO                           AS SDS_ORG_DTL_NO                                                       ".rtrim() // 2019-04-24-SHK [정렬방식]
					+"\n      , A.UPRC                                     AS UPRC                                                                 ".rtrim()
					+"\n      , A.SDA_CD                                   AS SDA_CD                                                               ".rtrim()
					+"\n      , SUM( A.QTY )                               AS QTY                                                                  ".rtrim()
					+"\n      , SUM( A.SALE_AMT )                          AS SALE_AMT                                                             ".rtrim()
					+"\n      , CASE WHEN  A.SIDE_MENU_YN = 'Y'THEN SD.SDA_NM ELSE '' END AS SDA_NM                                                ".rtrim()
					+"\n      , A.PRICE_MGR_YN                             AS PRICE_MGR_YN                                                         ".rtrim()
					+"\n      , A.ORDER_CNT                                AS ORDER_CNT                                                            ".rtrim()
					+"\n      , A.DLV_PACK_FG                              AS DLV_PACK_FG                                                          ".rtrim()
					+"\n      , A.PROP_CD                                  AS PROP_CD                                                              ".rtrim() // 2016-09-27-JYL [곱빼기]
					+"\n      , SUM( A.DCM_SALE_AMT )                      AS DCM_SALE_AMT                                                         ".rtrim()
					+"\n      , A.VAT_AMT                                  AS VAT_AMT                                                              ".rtrim()
					+"\n      , A.ORDER_DTL_FG                             AS ORDER_DTL_FG                                                         ".rtrim()
					+"\n      , A.SALE_WEIGHT                              AS SALE_WEIGHT                                                          ".rtrim() // 2018-06-01-HJH [중량]
					+"\n      , A.PRICE_MGR_FG                             AS PRICE_MGR_FG                                                         ".rtrim() // 2018-06-01-HJH [중량]
					+"\n      , MIN(ORDER_DTL_NO)                          AS ORDER_DTL_NO                                                         ".rtrim()
					+"\n      , A.PROD_NM                                  AS PROD_NM_TMP                                                          ".rtrim() // 2019-04-24-SHK [정렬방식]
					+"\n      , SUM( A.QTY )                               AS SALE_QTY                                                             ".rtrim() // 2019-04-24-SHK [정렬방식]
					+"\n FROM ( SELECT A.ORDER_DTL_NO                                                                                              ".rtrim()
					+"\n             , A.PROD_CD                                                                                                   ".rtrim()
					+"\n             , A.PROD_NM                                                                                                   ".rtrim()
					+"\n             , A.SIDE_MENU_YN                                                                                              ".rtrim()
					+"\n             , A.SDS_ORG_DTL_NO                                                                                            ".rtrim()
					+"\n             , A.UPRC                                                                                                      ".rtrim()
					+"\n             , A.SDA_CD                                                                                                    ".rtrim()
					+"\n             , A.QTY                                                                                                       ".rtrim()
					+"\n             , A.SALE_AMT                                                                                                  ".rtrim()
					+"\n             , A.PRICE_MGR_YN                                                                                              ".rtrim()
					+"\n             , B.ORDER_CNT                                                                                                 ".rtrim()
					+"\n             , A.DLV_PACK_FG                                                                                               ".rtrim()
					+"\n             , A.PROP_CD                                                                                                   ".rtrim() // 2016-09-27-JYL [곱빼기]
					+"\n             , A.DCM_SALE_AMT                                                                                              ".rtrim()
					+"\n             , A.VAT_AMT                                                                                                   ".rtrim()
					+"\n             , A.ORDER_DTL_FG                                                                                              ".rtrim() // 2018-06-01-HJH [중량]
					+"\n             , A.SALE_WEIGHT                                                                                               ".rtrim() // 2018-06-01-HJH [중량]
					+"\n             , A.PRICE_MGR_FG                                                                                              ".rtrim()
					+"\n        FROM ( SELECT A.ORDER_DTL_NO                                                                                       ".rtrim()
					+"\n                    , A.PROD_CD                                                                                            ".rtrim()
					+"\n                    , CASE WHEN B.PROD_NM IS NULL THEN (                                         ".rtrim()
					+ this.SP_GET_SDA_NM_SQL( " A.SHOP_CD" , " SUBSTR( A.PROD_CD, 4, 7 ) " )
					+"\n                                                         )     ".rtrim()
					+"\n                                                  ELSE LTRIM( CASE WHEN B.TAX_YN = 'N' THEN '*' ELSE '' END || B.PROD_NM ) END AS PROD_NM ".rtrim()
					+"\n                    , CASE WHEN B.PROD_NM IS NULL THEN 'N'                                                                 ".rtrim()
					+"\n                                                  ELSE B.SIDE_MENU_YN END AS SIDE_MENU_YN                                  ".rtrim()
					+"\n                    , A.SDS_ORG_DTL_NO                                                                                     ".rtrim()
					+"\n                    , A.SALE_UPRC AS UPRC                                                                                  ".rtrim()
					+"\n                    , A.SDA_CD                                                                                             ".rtrim()
					+"\n                    , A.SALE_QTY AS QTY                                                                                    ".rtrim()
					+"\n                    , A.SALE_AMT AS SALE_AMT                                                                               ".rtrim()
					+"\n                    , CASE WHEN B.PRICE_MGR_FG = '1' THEN 'Y' ELSE 'N' END AS PRICE_MGR_YN                                 ".rtrim()
					+"\n                    , A.DLV_PACK_FG                                                                                        ".rtrim()
					+"\n                    , A.PROP_CD                                                                                            ".rtrim() // 2016-09-27-JYL [곱빼기]
					+"\n                    , A.DCM_SALE_AMT                                                                                       ".rtrim()
					+"\n                    , A.VAT_AMT                                                                                            ".rtrim()
					+"\n                    , A.ORDER_DTL_FG                                                                                       ".rtrim()
					+"\n                    , A.SALE_WEIGHT                                                                                        ".rtrim()
					+"\n                    , B.PRICE_MGR_FG                                                                                       ".rtrim() // 2018-06-01-HJH [중량]
					+"\n               FROM POS_ODDTL_T A                                                                                          ".rtrim()
					+"\n                    LEFT OUTER JOIN SCD_PRODM_T B                                                                          ".rtrim()
					+"\n                    ON  B.SHOP_CD = A.SHOP_CD                                                                              ".rtrim()
					+"\n                    AND B.PROD_CD = A.PROD_CD                                                                              ".rtrim()
					+"\n               WHERE A.SHOP_CD      = '%s'                                                                                 ".rtrim()
					+"\n               AND   A.SALE_DATE    = '%s'                                                                                 ".rtrim()
					+"\n               AND   A.ORDER_NO     = '%s'                                                                                 ".rtrim()
					+"\n               AND   A.ORDER_SEQ_NO = '%s' ) A                                                                             ".rtrim()
	            	+"\n           , ( SELECT PROD_CD, PROP_CD                                                                                     ".rtrim() // 2017-11-22-BGM [곱빼기_구문표기_수정건]
					+"\n                    , COUNT( PROD_CD ) AS ORDER_CNT                                                                        ".rtrim()
					+"\n               FROM POS_ODDTL_T                                                                                            ".rtrim()
					+"\n               WHERE SHOP_CD       = '%s'                                                                                  ".rtrim()
					+"\n               AND   SALE_DATE     = '%s'                                                                                  ".rtrim()
					+"\n               AND   ORDER_NO      = '%s'                                                                                  ".rtrim()
					+"\n               AND   ORDER_SEQ_NO <= '%s'                                                                                  ".rtrim()
					+"\n               GROUP BY PROD_CD, PROP_CD ) B                                                                               ".rtrim() // 2017-11-22-BGM [곱빼기_구문표기_수정건]
					+"\n        WHERE A.PROD_CD = B.PROD_CD                                                                                        ".rtrim() // 2017-11-22-BGM [곱빼기_구문표기_수정건]
					+"\n          AND IFNULL( A.PROP_CD , '0') = IFNULL( B.PROP_CD, '0') ) A                                                       ".rtrim() // 2017-11-22-BGM [곱빼기_구문표기_수정건]
					+"\n      LEFT OUTER JOIN SCD_SDACD_T SD                                                                                       ".rtrim()
					+"\n      ON  SD.SHOP_CD = '%s'                                                                                                ".rtrim()
					+"\n      AND SD.SDA_CD  = A.SDA_CD                                                                                            ".rtrim()
					+"\n GROUP BY A.PROD_CD                                                                                                        ".rtrim()
					+"\n        , A.PROD_NM                                                                                                        ".rtrim()
					+"\n        , A.SIDE_MENU_YN                                                                                                   ".rtrim()
					+"\n        , A.SDS_ORG_DTL_NO                                                                                                 ".rtrim()
					+"\n        , A.UPRC                                                                                                           ".rtrim()
					+"\n        , A.SDA_CD                                                                                                         ".rtrim()
					+"\n        , SD.SDA_NM                                                                                                        ".rtrim()
					+"\n        , A.PRICE_MGR_YN                                                                                                   ".rtrim()
					+"\n        , A.SALE_AMT                                                                                                       ".rtrim()
					+"\n        , A.ORDER_CNT                                                                                                      ".rtrim()
					+"\n        , A.DLV_PACK_FG                                                                                                    ".rtrim()
					+"\n        , A.PROP_CD                                                                                                        ".rtrim()	    																									 // 2016-09-27-JYL [곱빼기]
					+"\n        , A.DCM_SALE_AMT                                                                                                   ".rtrim()
					+"\n        , A.VAT_AMT                                                                                                        ".rtrim()
					+"\n        , A.ORDER_DTL_FG                                                                                                   ".rtrim()
					+"\n        , A.PRICE_MGR_FG                                                                                                   ".rtrim() // 2018-06-01-HJH [중량]
					+"\n 		, A.SALE_WEIGHT	                                                                                                   ".rtrim() // 2018-0601-HJH
					+"\n HAVING ( SUM( A.QTY ) <> 0 ) OR ( SUM( A.SALE_AMT ) <> 0 )                                                                ".rtrim()
					+"\n ORDER BY MIN( A.ORDER_DTL_NO )                                                                                            ".rtrim()
					;

				csSubQrySql = csSubQrySql.sprintf(
							     pObj.SHOP_CD, pObj.SALE_DATE, pObj.ORDER_NO, pObj.ORDER_SEQ_NO
							   , pObj.SHOP_CD, pObj.SALE_DATE, pObj.ORDER_NO, pObj.ORDER_SEQ_NO
							   , pObj.SHOP_CD
							   );

				csQrySql =  "SELECT * FROM (%s) %s".sprintf( csSubQrySql, this.GetOrderByQuery("ORDER_DTL_NO", "QTY", "SALE_AMT" , pInOrderBy) );			// 2019-04-24-SHK [정렬방식]
			}
		}
		return csQrySql;

	}
	this.SP_GET_SDA_NM_SQL = function ( colA, colB ) {
		var sql = ""
			+"\n     SELECT SDA_NM                ".rtrim()
			+"\n     FROM   SCD_SDACD_T           ".rtrim()
			+"\n     WHERE  SHOP_CD = %s          ".rtrim()
			+"\n     AND    SDA_CD  = %s          ".rtrim()
			;
		sql = sql.sprintf(colA, colB);
		return sql;
	}

	this.GetEnvXmlCornerENVSQL = function (env114) {
		var sql = "";
		if( env114 == "0")	{
			sql = ""
				+ "\n  	SELECT B.CORNER_CD   AS CORNER_CD        ".rtrim()
				+ "\n  		 , B.CORNER_NM   AS CORNER_NM        ".rtrim()
				+ "\n  		 , B.OWNER_NM    AS OWNER_NM         ".rtrim()
				+ "\n  		 , B.BIZ_NO      AS BIZ_NO           ".rtrim()
				+ "\n  		 , B.VAN_CD      AS VAN_CD           ".rtrim()
				+ "\n  		 , A.VAN_TERM_NO AS VAN_TERM_NO      ".rtrim()
				+ "\n  		 , B.VAN_CD      AS CASH_VAN_CD      ".rtrim()
				+ "\n  		 , A.VAN_TERM_NO AS CASH_VAN_TERM_NO ".rtrim()
				+ "\n  		 , A.VAN_CERT_YN AS VAN_CERT_YN      ".rtrim()
				+ "\n  		 , A.WORK_INDEX  AS WORK_INDEX       ".rtrim()
				+ "\n  		 , A.WORK_KEY    AS WORK_KEY         ".rtrim()
				+ "\n  		 , A.OCB_TERM_NO AS OKCBG_TERM_NO    ".rtrim()
				+ "\n  		 , A.OCB_SER_NO  AS OKCBG_SER_NO     ".rtrim()
				+ "\n  		 , A.VAN_SER_NO                      ".rtrim()
				+ "\n  	FROM SCD_POSMS_T A                       ".rtrim()
				+ "\n  	   , SCD_SHOPS_T B                       ".rtrim()
				+ "\n  	WHERE A.SHOP_CD   = '%s'                 ".rtrim()
				+ "\n  	AND   A.POS_NO    = '%s'                 ".rtrim()
				+ "\n  	AND   A.USE_YN    = 'Y'                  ".rtrim()
				+ "\n  	AND   B.CORNER_CD   = ?                  ".rtrim()
				+ "\n  	AND   B.SHOP_CD   = A.SHOP_CD            ".rtrim()
				+ "\n  	AND   B.CORNER_CD = '00'                 ".rtrim()
				;
				sql = sql.sprintf( gShopCd, gPosNo   );;

		} else {
			sql = ""
				+ "\n  	SELECT                                                                               ".rtrim()
				+ "\n          CORNER_CD                                                                     ".rtrim()
				+ "\n  		 , CORNER_NM                                                                     ".rtrim()
				+ "\n  		 , OWNER_NM                                                                      ".rtrim()
				+ "\n  		 , BIZ_NO                                                                        ".rtrim()
				+ "\n  		 , VAN_CD                                                                        ".rtrim()
				+ "\n  		 , VAN_TERM_NO                                                                   ".rtrim()
				+ "\n  		 , CASH_VAN_CD                                                                   ".rtrim()
				+ "\n  		 , CASH_VAN_TERM_NO                                                              ".rtrim()
				+ "\n  		 , VAN_CERT_YN                                                                   ".rtrim()
				+ "\n  		 , WORK_INDEX                                                                    ".rtrim()
				+ "\n  		 , WORK_KEY                                                                      ".rtrim()
				+ "\n  		 , OKCBG_TERM_NO                                                                 ".rtrim()
				+ "\n  		 , OKCBG_SER_NO                                                                  ".rtrim()
				+ "\n  		 , CASE WHEN CORNER_CD <> '00' THEN VAN_SER_NO ELSE ( SELECT VAN_SER_NO          ".rtrim()
				+ "\n  												 FROM SCD_POSMS_T                        ".rtrim()
				+ "\n  												 WHERE SHOP_CD = '%s'                    ".rtrim()
				+ "\n  												 AND   POS_NO  = '%s' ) END AS VAN_SER_NO   ".rtrim()
				+ "\n  	  FROM SCD_SHOPS_T                                                                   ".rtrim()
				+ "\n  	 WHERE SHOP_CD     = '%s'                                                            ".rtrim()
				+ "\n  	   AND USE_YN      = 'Y'                                                             ".rtrim()
				+ "\n  	   AND CORNER_CD   = ?                                                               ".rtrim()
				+ "\n  	 ORDER BY CORNER_CD                                                                  ".rtrim()
				;
			sql = sql.sprintf( gShopCd, gPosNo , gShopCd  );
		}
		return sql;
	}

	this.GetEtcValueSQL = function() {
		var sql = ""
			+"\n SELECT TOT_SALE_AMT                                                         ".ltrim()
			+"\n      , TOT_DC_AMT   + CASE WHEN TOT_ETC_AMT > 50 THEN 0 ELSE TOT_ETC_AMT END AS TOT_DC_AMT ".rtrim()
			+"\n      , SVC_TIP_AMT                                                          ".rtrim()
			+"\n      , VAT_AMT	                                                             ".rtrim()
			+"\n FROM POS_ODHDR_T                                                            ".rtrim()
			+"\n WHERE SHOP_CD   = ?                                                         ".rtrim()
			+"\n AND   SALE_DATE = ?                                                         ".rtrim()
			+"\n AND   ORDER_NO  = ?                                                         ".rtrim()
			return sql;
	}

	this.GetOrderByQuery = function ( csOrderDtlNoColumnName,  qty,  amt , pInOrderBy ) {
		var csOrderByQuery  = "" ;
		var csOrderByColumn = "" ;
		var csAscending     =  "ASC" ;

		switch(parseInt( pInOrderBy)) {
			case 0:		// 주문시각
				csOrderByColumn = csOrderDtlNoColumnName;
				break;
			case 1:		// 상품명
				csOrderByColumn =  "PROD_NM_TMP" ;
				break;
			case 2:		// 상품코드
				csOrderByColumn =  "PROD_CD" ;
				break;
			case 3:		// 금액
				csOrderByColumn = amt;
				csAscending = "DESC" ;
				break;
			case 4:		// 수량
				csOrderByColumn = qty;
				csAscending = "DESC";
				break;
			case 5:		// 주문시각-역순
				csOrderByColumn = csOrderDtlNoColumnName;
				csAscending =  "DESC" ;
				break;
			case 6:		// 상품명-역순
				csOrderByColumn = "PROD_NM_TMP" ;
				csAscending = "DESC" ;
				break;
			case 7:		// 상품코드-역순
				csOrderByColumn =  "PROD_CD";
				csAscending =  "DESC" ;
				break;
			case 8:		// 금액-역순
				csOrderByColumn = amt;
				break;
			case 9:		// 수량-역순
				csOrderByColumn = qty;
				break;
		}

		csOrderByQuery = ""
			+"\n ORDER BY SDS_ORG_DTL_NO                                            ".rtrim()
			+"\n		, CASE WHEN SDS_ORG_DTL_NO <> '' AND SDS_ORG_DTL_NO IS NOT NULL THEN SIDE_MENU_YN END DESC ".rtrim()
			+"\n		, CASE WHEN SDS_ORG_DTL_NO = '' OR SDS_ORG_DTL_NO IS NULL THEN %s END %s              ".rtrim()
			+"\n		, %s                                                        ".rtrim()
			;

		csOrderByQuery = csOrderByQuery.sprintf(  csOrderByColumn, csAscending, csOrderDtlNoColumnName );

		return csOrderByQuery;
	}
	this.GetNoneSalesCardCollectData_SQL = function(paramObj) {
		var csQrySql = ""
				+ "\n SELECT                                                                          ".rtrim()
				+ "\n        A.ISS_CRDCP_NM                                                           AS ISS_CRDCP_NM      ".rtrim()
				+ "\n      , A.CRD_CARD_NO                                                            AS CRD_CARD_NO       ".rtrim()
				+ "\n      , A.APPR_AMT                                                               AS APPR_AMT          ".rtrim()
				+ "\n      , A.INST_MM_FG                                                             AS INST_MM_FG        ".rtrim()
				+ "\n      , A.INST_MM_CNT                                                            AS INST_MM_CNT       ".rtrim()
				+ "\n      , A.VALID_TERM                                                             AS VALID_TERM        ".rtrim()
				+ "\n      , A.APPR_DATE                                                              AS APPR_DATE         ".rtrim()
				+ "\n      , A.APPR_TIME                                                              AS APPR_TIME         ".rtrim()
				+ "\n      , A.APPR_NO                                                                AS APPR_NO           ".rtrim()
				+ "\n      , A.CRDCP_CD                                                               AS CRDCP_CD          ".rtrim()
				+ "\n      , A.CARD_IN_FG                                                             AS CARD_IN_FG        ".rtrim()
				+ "\n      , A.VAN_TERM_NO                                                            AS VAN_TERM_NO       ".rtrim()
				+ "\n      , A.SIGN_PAD_YN                                                            AS SIGN_PAD_YN       ".rtrim()
				+ "\n      , A.APPR_FG                                                                AS APPR_FG           ".rtrim()
				+ "\n      , A.VAT_AMT                                                                AS VAT_AMT           ".rtrim()
				+ "\n      , A.SVC_TIP_AMT                                                            AS SVC_TIP_AMT       ".rtrim()
				+ "\n      , A.CRDCP_TERM_NO                                                          AS CRDCP_TERM_NO     ".rtrim()
				+ "\n      , A.EMP_NO                                                                 AS EMP_NO            ".rtrim()
				+ "\n      , A.GIFT_CASH                                                              AS GIFT_CASH         ".rtrim() // 2012-0202-JJM : Gift 카드 잔액.
				+ "\n      , A.NOTICE_MSG                                                             AS NOTICE_MSG        ".rtrim() // 2012-0202-JJM : NOTICE 메세지.
				+ "\n      , A.BROAD_MSG                                                              AS BROAD_MSG         ".rtrim() // 2012-0829-LSH : 알림 메세지.(컬럼명수정)
				+ "\n      , A.VAN_TERM_NO                                                            AS VAN_TERM_NO       ".rtrim() // 2012-0306-JJM : .
				+ "\n      , A.CNMK_CD                                                                AS CNMK_CD           ".rtrim() // 2012-0313-JJM : .
				+ "\n      , A.ORG_APPR_DATE                                                          AS ORG_APPR_DATE     ".rtrim()
				+ "\n      , A.ORG_APPR_NO                                                            AS ORG_APPR_NO       ".rtrim()
				+ "\n      , A.APPR_PROC_FG                                                           AS APPR_PROC_FG      ".rtrim() // 2014-0716-Jane :.
				+ "\n      , A.DDC_FLAG                                                               AS DDC_FLAG          ".rtrim() // 2016-0812-Jane :.
				+ "\n      , A.PUR_CRDCP_NM                                                           AS CRDCP_NM          ".rtrim()
				+ "\n      , A.APPR_DATE || A.APPR_TIME                                               AS APPR_DATETIME     ".rtrim()
				+ "\n      , ( SELECT EMP_NM                                                                               ".rtrim()
				+ "\n            FROM SCD_EMPMS_T WHERE SHOP_CD = A.SHOP_CD AND EMP_NO = A.EMP_NO   ) AS EMP_NM            ".rtrim()

				+ this.SP_GET_CCD_CODEM_NM_SQL( "059" , "A.INST_MM_FG") + " AS INST_MM_NM      ".rtrim()

				+ "\n   FROM POS_LGCRD_T A                                                                                 ".rtrim()
				+ "\n  WHERE A.SHOP_CD      = '%s'                                                                         ".rtrim()
				+ "\n    AND A.SALE_DATE    = '%s'                                                                         ".rtrim()
				+ "\n    AND A.APPR_LOG_NO  = '%s'                                                                         ".rtrim()
				+ "\n    AND ( A.APPR_PROC_FG = '1' OR A.APPR_PROC_FG = '2' OR A.APPR_PROC_FG = '5' )                      ".rtrim()// 2015-0826-Jane : 보안CAT 대리승인 추가
		;
		return csQrySql.sprintf(paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.APPR_LOG_NO );

	}

	this.GetSalesCardData_SQL = function (paramObj , blCorner) {
		var csQrySql = "";
		if( blCorner ) {
			csQrySql = ""
				+"\n  SELECT DISTINCT                                             ".rtrim()
				+"\n         BB.CHG_BILL_NO               AS CHG_BILL_NO          ".rtrim()
				+"\n       , AA.LINE_NO                   AS LINE_NO              ".rtrim()
				+"\n       , AA.CORNER_CD                 AS CORNER_CD            ".rtrim()
				+ "\n      , CASE WHEN AA.CORNER_CD = '00' THEN (SELECT SHOP_NM FROM SCD_SHOPM_T WHERE SHOP_CD = AA.SHOP_CD) ELSE AA.CORNER_NM END  AS CORNER_NM  ".rtrim()
				+"\n       , AA.ISS_CRDCP_NM              AS ISS_CRDCP_NM         ".rtrim()
				+"\n       , AA.CRD_CARD_NO               AS CRD_CARD_NO          ".rtrim()
				+"\n       , AA.APPR_AMT                  AS APPR_AMT             ".rtrim()
				+"\n       , AA.INST_MM_FG                AS INST_MM_FG           ".rtrim()
				+"\n       , AA.INST_MM_CNT               AS INST_MM_CNT          ".rtrim()
				+"\n       , AA.INST_MM_NM                AS INST_MM_NM           ".rtrim()
				+"\n       , AA.APPR_DATE                 AS APPR_DATE            ".rtrim()
				+"\n       , AA.APPR_TIME                 AS APPR_TIME            ".rtrim()
				+"\n       , AA.APPR_DATETIME             AS APPR_DATETIME        ".rtrim()
				+"\n       , AA.APPR_NO                   AS APPR_NO              ".rtrim()
				+"\n       , AA.CRDCP_CD                  AS CRDCP_CD             ".rtrim()
				+"\n       , AA.CRDCP_NM                  AS CRDCP_NM             ".rtrim()
				+"\n       , AA.CARD_IN_FG                AS CARD_IN_FG           ".rtrim()
				+"\n       , AA.VAN_TERM_NO               AS VAN_TERM_NO          ".rtrim()
				+"\n       , AA.SIGN_PAD_YN               AS SIGN_PAD_YN          ".rtrim()
				+"\n       , AA.SALE_YN                   AS SALE_YN              ".rtrim()
				+"\n       , AA.VAT_AMT                   AS VAT_AMT              ".rtrim()
				+"\n       , AA.SVC_TIP_AMT               AS SVC_TIP_AMT          ".rtrim()
				+"\n       , AA.CRDCP_TERM_NO             AS CRDCP_TERM_NO        ".rtrim()
				+"\n       , AA.APPR_PROC_FG              AS APPR_PROC_FG         ".rtrim()
				+"\n       , AA.GIFT_CASH                 AS GIFT_CASH            ".rtrim()
				+"\n       , AA.NOTICE_MSG                AS NOTICE_MSG           ".rtrim()
				+"\n       , AA.BROAD_MSG                 AS BROAD_MSG            ".rtrim()
				+"\n       , AA.VAN_SLIP_NO               AS VAN_SLIP_NO          ".rtrim()
				+"\n       , AA.DDC_FLAG                  AS DDC_FLAG             ".rtrim()
				+"\n       , AA.ORG_APPR_DATE             AS ORG_APPR_DATE        ".rtrim()
				+"\n       , AA.ORG_APPR_NO               AS ORG_APPR_NO          ".rtrim()
				+"\n       , AA.UNION_PAY_FG              AS UNION_PAY_FG         ".rtrim()																				// 2014-1124-Jane : Union_Pay_Fg 추가.
				+"\n    FROM ( SELECT A.SHOP_CD                                                   ".rtrim()
			    +"\n              , A.SALE_DATE                                                   ".rtrim()
			    +"\n              , A.POS_NO                                                      ".rtrim()
			    +"\n              , A.BILL_NO                                                     ".rtrim()
			    +"\n              , A.LINE_NO                                                     ".rtrim()
			    +"\n              , A.CORNER_CD                                                   ".rtrim()
			    +"\n              , C.CORNER_NM                                                   ".rtrim()
			    +"\n              , A.ISS_CRDCP_NM                                                ".rtrim()
			    +"\n              , A.CRD_CARD_NO                                                 ".rtrim()
			    +"\n              , CASE WHEN  A.SALE_YN = 'N' THEN  -1 ELSE  1 END * A.APPR_AMT AS APPR_AMT        ".rtrim()
			    +"\n              , A.INST_MM_FG                                                  ".rtrim()
			    +"\n              , A.INST_MM_CNT                                                 ".rtrim()
//			    +"\n              , ( SELECT COM_CD_NM FROM SP_GET_CCD_CODEM_NM( '059', A.INST_MM_FG ) ) AS INST_MM_NM "

			    + this.SP_GET_CCD_CODEM_NM_SQL( "059" , "A.INST_MM_FG") + " AS INST_MM_NM      ".rtrim()

			    +"\n              , A.APPR_DATE                                                   ".rtrim()
			    +"\n              , A.APPR_TIME                                                   ".rtrim()
			    +"\n              , A.APPR_DATE || A.APPR_TIME AS APPR_DATETIME                   ".rtrim()
			    +"\n              , A.APPR_NO                                                     ".rtrim()
			    +"\n              , A.CRDCP_CD                                                    ".rtrim()
			    +"\n              , A.PUR_CRDCP_NM AS CRDCP_NM                                    ".rtrim()
			    +"\n              , A.CARD_IN_FG                                                  ".rtrim()
			    +"\n              , A.VAN_TERM_NO                                                 ".rtrim()
			    +"\n              , A.SIGN_PAD_YN                                                 ".rtrim()
			    +"\n              , A.SALE_YN                                                     ".rtrim()
			    +"\n              , A.VAT_AMT                                                     ".rtrim()
			    +"\n              , A.SVC_TIP_AMT                                                 ".rtrim()
			    +"\n              , A.CRDCP_TERM_NO                                               ".rtrim()
			    +"\n              , A.APPR_PROC_FG                                                ".rtrim()
				+"\n              , A.GIFT_CASH                                                   ".rtrim()
				+"\n              , A.NOTICE_MSG                                                  ".rtrim()
				+"\n              , A.BROAD_MSG                                                   ".rtrim()
				+"\n              , A.VAN_SLIP_NO                                                 ".rtrim()
				+"\n              , A.DDC_FLAG                                                    ".rtrim()
				+"\n              , A.ORG_APPR_DATE                                               ".rtrim()
				+"\n              , A.ORG_APPR_NO                                                 ".rtrim()
				+"\n              , A.INS_DT                                                      ".rtrim()// 2014-0711-Jane : insert 일시 추가.
				+"\n              , A.UNION_PAY_FG                                                ".rtrim() // 2014-1124-Jane : Union_Pay_Fg 추가.
				+"\n         FROM SSL_TRCRD_T A                                                   ".rtrim()
				+"\n              LEFT OUTER JOIN SCD_SHOPS_T C                                   ".rtrim()
				+"\n              ON A.CORNER_CD = C.CORNER_CD                                    ".rtrim()
			    +"\n         WHERE A.SHOP_CD   = '%s'                                             ".rtrim()
			    +"\n         AND   A.SALE_DATE = '%s'                                             ".rtrim()
			    +"\n         AND   A.POS_NO    = '%s'                                             ".rtrim()
			    +"\n         AND   A.BILL_NO   = '%s'                                             ".rtrim()
			    +"\n         ORDER BY A.LINE_NO                                                   ".rtrim()
				+"\n                , APPR_DATETIME ) AA                                          ".rtrim()
				+"\n       , SSL_TRDTL_T BB                                                       ".rtrim()
				+"\n  WHERE BB.SHOP_CD   = AA.SHOP_CD                                             ".rtrim()
				+"\n  AND   BB.SALE_DATE = AA.SALE_DATE                                           ".rtrim()
				+"\n  AND   BB.POS_NO    = AA.POS_NO                                              ".rtrim()
				+"\n  AND   BB.BILL_NO   = AA.BILL_NO                                             ".rtrim()
				+"\n  AND   BB.CORNER_CD = AA.CORNER_CD                                           ".rtrim()
                +"\n  ORDER BY AA.LINE_NO                                                         ".rtrim()
				+"\n         , AA.CORNER_CD                                                       ".rtrim()
				;
			csQrySql = csQrySql.sprintf( paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO );

		}  else {

			csQrySql = ""
				+"\n SELECT DISTINCT                                           ".ltrim()
				+"\n        A.LINE_NO                   AS LINE_NO             ".ltrim()
				+"\n      , A.CORNER_CD                 AS CORNER_CD           ".ltrim()
				+ "\n     , CASE WHEN A.CORNER_CD = '00' THEN (SELECT SHOP_NM FROM SCD_SHOPM_T WHERE SHOP_CD = A.SHOP_CD) ELSE C.CORNER_NM END  AS CORNER_NM  ".rtrim()
				+"\n      , A.ISS_CRDCP_NM              AS ISS_CRDCP_NM        ".ltrim()
				+"\n      , A.CRD_CARD_NO               AS CRD_CARD_NO         ".ltrim()
				+"\n      , A.APPR_DATE                 AS APPR_DATE           ".ltrim()
				+"\n      , A.APPR_TIME                 AS APPR_TIME           ".ltrim()
				+"\n      , A.APPR_NO                   AS APPR_NO             ".ltrim()
				+"\n      , A.CRDCP_CD                  AS CRDCP_CD            ".ltrim()
				+"\n      , A.CARD_IN_FG                AS CARD_IN_FG          ".ltrim()
				+"\n      , A.VAN_TERM_NO               AS VAN_TERM_NO         ".ltrim()
				+"\n      , A.SIGN_PAD_YN               AS SIGN_PAD_YN         ".ltrim()
				+"\n      , A.SALE_YN                   AS SALE_YN             ".ltrim()
				+"\n      , A.VAT_AMT                   AS VAT_AMT             ".ltrim()
				+"\n      , A.SVC_TIP_AMT               AS SVC_TIP_AMT         ".ltrim()
				+"\n      , A.CRDCP_TERM_NO             AS CRDCP_TERM_NO       ".ltrim()
				+"\n      , A.APPR_PROC_FG              AS APPR_PROC_FG        ".ltrim()
				+"\n      , A.GIFT_CASH                 AS GIFT_CASH           ".ltrim()
				+"\n      , A.NOTICE_MSG                AS NOTICE_MSG          ".ltrim()
				+"\n      , A.BROAD_MSG                 AS BROAD_MSG           ".ltrim()
				+"\n      , A.VAN_SLIP_NO               AS VAN_SLIP_NO         ".ltrim()
				+"\n      , A.DDC_FLAG                  AS DDC_FLAG            ".ltrim()
				+"\n      , A.ORG_APPR_DATE             AS ORG_APPR_DATE       ".ltrim()
				+"\n      , A.ORG_APPR_NO               AS ORG_APPR_NO         ".ltrim()
				+"\n      , A.INS_DT                    AS INS_DT              ".ltrim()                     // 2014-0711-Jane : insert 일시 추가.
				+"\n      , A.UNION_PAY_FG              AS UNION_PAY_FG        ".ltrim()  // 2014-1124-Jane : Union_Pay_Fg 추가.
				+"\n      , A.PUR_CRDCP_NM              AS CRDCP_NM            ".ltrim()
				+"\n      , A.INST_MM_FG                AS INST_MM_FG          ".ltrim()
				+"\n      , A.INST_MM_CNT               AS INST_MM_CNT         ".ltrim()
				+"\n      , A.APPR_DATE || A.APPR_TIME  AS APPR_DATETIME       ".ltrim()
				+"\n      , CASE WHEN A.SALE_YN = 'N' THEN A.APPR_AMT * -1 ELSE A.APPR_AMT END   AS APPR_AMT "
				+ this.SP_GET_CCD_CODEM_NM_SQL( "059" , "A.INST_MM_FG") + " AS INST_MM_NM      ".rtrim()

				+"\n   FROM SSL_TRCRD_T A                 "
				+"\n        LEFT OUTER JOIN SCD_SHOPS_T C "
				+"\n        ON A.CORNER_CD = C.CORNER_CD  "
				+"\n  WHERE A.SHOP_CD   = '%s'            "
				+"\n    AND A.SALE_DATE = '%s'            "
				+"\n    AND A.POS_NO    = '%s'            "
				+"\n    AND A.BILL_NO   = '%s'            "
				+"\n  ORDER BY A.LINE_NO                  "
				+"\n      , APPR_DATETIME                 "
				;
			csQrySql = csQrySql.sprintf( paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO );
		}
		util.logInfo("csQrySql >>> " + csQrySql)
		return csQrySql;
	}

	this.SP_GET_CCD_CODEM_NM_SQL = function( cdKey , cdColumn  ) {
		var sql = ""
			+"\n       , ( SELECT COM_CD_NM             ".rtrim()
			+"\n             FROM CCD_CODEM_T           ".rtrim()
			+"\n            WHERE COM_CD_FG = '%s'      ".rtrim()
			+"\n              AND COM_CD    = %s      ".rtrim()
			+"\n              AND USE_YN    = 'Y'     ) ".rtrim()
			;
		sql = sql.sprintf( cdKey, cdColumn );
		return sql;
	}

	this.GetSalesCashData_SQL = function (blCorner , paramObj , csTemp) {
		var csQrySql = "";
		if( blCorner ) {
			csQrySql  = ""
				+"\n SELECT DISTINCT                               ".rtrim()
				+"\n        BB.CHG_BILL_NO         AS CHG_BILL_NO  ".rtrim()
				+"\n      , AA.LINE_NO             AS LINE_NO      ".rtrim()
				+"\n      , AA.APPR_IDT_NO         AS APPR_IDT_NO  ".rtrim()
				+"\n      , AA.APPR_IDT_TYPE       AS APPR_IDT_TYPE".rtrim()
				+"\n      , AA.APPR_NO             AS APPR_NO      ".rtrim()
				+"\n      , AA.CORNER_CD           AS CORNER_CD    ".rtrim()
				+"\n      , AA.APPR_AMT            AS APPR_AMT     ".rtrim()
				+"\n      , AA.APPR_DATE           AS APPR_DATE    ".rtrim()
				+"\n      , AA.APPR_TIME           AS APPR_TIME    ".rtrim()
				+"\n      , AA.CORNER_NM           AS CORNER_NM    ".rtrim()
				+"\n      , AA.APPR_PROC_FG        AS APPR_PROC_FG ".rtrim()
				+"\n      , AA.NOTICE_MSG          AS NOTICE_MSG   ".rtrim()
				+"\n      , AA.BROAD_MSG           AS BROAD_MSG    ".rtrim()
				+"\n      , AA.VAN_TERM_NO         AS VAN_TERM_NO  ".rtrim()
				+"\n      , AA.CASH_AMT            AS CASH_AMT     ".rtrim()  //2013-1202 Antony Choi : 단순현금 영수증도 전표 출력 처리(결제 금액이 아닌 현금 금액으로)
				+"\n FROM ( SELECT A.SHOP_CD           ".rtrim()
				+"\n             , A.SALE_DATE         ".rtrim()
				+"\n             , A.POS_NO            ".rtrim()
				+"\n             , A.BILL_NO           ".rtrim()
				+"\n             , A.LINE_NO           ".rtrim()
				+"\n             , A.APPR_IDT_NO       ".rtrim()
				+"\n             , A.APPR_IDT_TYPE     ".rtrim()
				+"\n             , A.APPR_NO           ".rtrim()
				+"\n             , A.CORNER_CD         ".rtrim()
				+"\n             , A.APPR_DATE         ".rtrim()
				+"\n             , A.APPR_TIME         ".rtrim()
				+"\n             , B.CORNER_NM         ".rtrim()
				+"\n             , A.APPR_PROC_FG      ".rtrim()
				+"\n             , A.NOTICE_MSG        ".rtrim()
				+"\n             , A.BROAD_MSG         ".rtrim()
				+"\n             , A.VAN_TERM_NO       ".rtrim()
				+"\n             , CASE WHEN A.SALE_YN = 'N' THEN A.APPR_AMT * -1 ELSE A.APPR_AMT END APPR_AMT "
				+"\n             , CASE WHEN A.SALE_YN = 'N' THEN A.CASH_AMT * -1 ELSE A.CASH_AMT END CASH_AMT "	 //2013-1202 Antony Choi : 단순현금 영수증도 전표 출력 처리(결제 금액이 아닌 현금 금액으로)
				+"\n        FROM SSL_TRCSH_T A                    ".rtrim()
				+"\n             LEFT OUTER JOIN SCD_SHOPS_T B    ".rtrim()
				+"\n             ON  A.SHOP_CD   = B.SHOP_CD      ".rtrim()
				+"\n             AND A.CORNER_CD = B.CORNER_CD    ".rtrim()
				+"\n       WHERE A.SHOP_CD   = '%s'                ".rtrim()
				+"\n       AND   A.SALE_DATE = '%s'                ".rtrim()
				+"\n       AND   A.POS_NO    = '%s'                ".rtrim()
				+"\n       AND   A.BILL_NO   = '%s'                ".rtrim()
				+"\n %s                                            ".rtrim()
				+"\n AND   ( A.APPR_PROC_FG = '0' OR A.APPR_PROC_FG = '1' OR A.APPR_PROC_FG = '2' ) "				  //2013-1202 Antony Choi : 단순현금 영수증도 전표 출력 처리
				+"\n       ORDER BY A.LINE_NO                  ".rtrim()
				+"\n              , A.CORNER_CD ) AA           ".rtrim()
				+"\n    , SSL_TRDTL_T BB                       ".rtrim()
				+"\n WHERE BB.SHOP_CD   = AA.SHOP_CD           ".rtrim()
				+"\n AND   BB.SALE_DATE = AA.SALE_DATE         ".rtrim()
				+"\n AND   BB.POS_NO    = AA.POS_NO            ".rtrim()
				+"\n AND   BB.BILL_NO   = AA.BILL_NO           ".rtrim()
				+"\n AND   BB.CORNER_CD = AA.CORNER_CD         ".rtrim()
				;
			csQrySql = csQrySql.sprintf( paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO, csTemp );
		}
		else {
			csQrySql = ""
				+"\n SELECT A.LINE_NO                 AS  LINE_NO       ".rtrim()
				+"\n      , A.APPR_IDT_NO             AS  APPR_IDT_NO   ".rtrim()
				+"\n      , A.APPR_IDT_TYPE           AS  APPR_IDT_TYPE ".rtrim()
				+"\n      , A.APPR_NO                 AS  APPR_NO       ".rtrim()
				+"\n      , A.CORNER_CD               AS  CORNER_CD     ".rtrim()
				+"\n      , A.APPR_DATE               AS  APPR_DATE     ".rtrim()
				+"\n      , A.APPR_TIME               AS  APPR_TIME     ".rtrim()
				+"\n      , B.CORNER_NM               AS  CORNER_NM     ".rtrim()
		        +"\n      , A.APPR_PROC_FG            AS  APPR_PROC_FG  ".rtrim()
		        +"\n      , A.NOTICE_MSG              AS  NOTICE_MSG    ".rtrim()
		        +"\n      , A.BROAD_MSG               AS  BROAD_MSG     ".rtrim()
				+"\n      , A.VAN_TERM_NO             AS  VAN_TERM_NO   ".rtrim()
				+"\n      , CASE WHEN A.SALE_YN = 'N' THEN A.APPR_AMT * -1 ELSE A.APPR_AMT END APPR_AMT ".rtrim()
				+"\n      , CASE WHEN A.SALE_YN = 'N' THEN A.CASH_AMT * -1 ELSE A.CASH_AMT END CASH_AMT ".rtrim()  //2013-1202 Antony Choi : 단순현금 영수증도 전표 출력 처리(결제 금액이 아닌 현금 금액으로)
				+"\n FROM SSL_TRCSH_T A                                 ".rtrim()
				+"\n      LEFT OUTER JOIN SCD_SHOPS_T B                 ".rtrim()
				+"\n      ON  A.SHOP_CD   = B.SHOP_CD                   ".rtrim()
				+"\n      AND A.CORNER_CD = B.CORNER_CD                 ".rtrim()
				+"\n WHERE A.SHOP_CD   = '%s'                           ".rtrim()
				+"\n AND   A.SALE_DATE = '%s'                           ".rtrim()
				+"\n AND   A.POS_NO    = '%s'                           ".rtrim()
				+"\n AND   A.BILL_NO   = '%s'                           ".rtrim()
				+"\n %s                                                 ".rtrim()
				+"\n AND   ( A.APPR_PROC_FG = '0' OR A.APPR_PROC_FG = '1' OR A.APPR_PROC_FG = '2'"   // 2013-1202 Antony Choi : 단순현금 영수증도 전표 출력 처리
				+"\n  OR A.APPR_PROC_FG = '4' OR A.APPR_PROC_FG = '5' )    ".rtrim()                         // 2015-0610-Jane : 인천공항결제 추가, (2015-0826-Jane : 타장비 결제요청 추가)
				+"\n ORDER BY A.LINE_NO                                    ".rtrim()
				;

			csQrySql = csQrySql.sprintf(  paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO, csTemp );
		}

		return csQrySql;
	}
	this.GetNoneSalesCashData_SQL = function ( paramObj ) {
		var csQrySql = "";
		if( paramObj.APPR_LOG_NO.length /** .GetLength() **/ > 0 ) {
			csQrySql = ""
				+"\n SELECT A.APPR_IDT_NO                   AS APPR_IDT_NO    ".rtrim()
				+"\n      , A.APPR_IDT_TYPE                 AS APPR_IDT_TYPE  ".rtrim()
				+"\n      , A.APPR_NO                       AS APPR_NO        ".rtrim()
				+"\n      , A.APPR_AMT                      AS APPR_AMT       ".rtrim()
				+"\n      , A.APPR_DATE                     AS APPR_DATE      ".rtrim()
				+"\n      , A.APPR_TIME                     AS APPR_TIME      ".rtrim()
				+"\n      , A.CORNER_CD                     AS CORNER_CD      ".rtrim()
				+"\n      , A.APPR_FG                       AS APPR_FG        ".rtrim()
				+"\n      , A.NOTICE_MSG                    AS NOTICE_MSG     ".rtrim()
				+"\n      , A.BROAD_MSG                     AS BROAD_MSG      ".rtrim()
				+"\n      , A.VAN_TERM_NO                   AS VAN_TERM_NO    ".rtrim()
				+"\n      , ( SELECT CORNER_NM                                ".rtrim()
				+"\n          FROM SCD_SHOPS_T                                ".rtrim()
				+"\n          WHERE SHOP_CD = A.SHOP_CD                       ".rtrim()
				+"\n          AND CORNER_CD = A.CORNER_CD ) AS CORNER_NM      ".rtrim()
				+"\n FROM POS_LGCSH_T A                                       ".rtrim()
				+"\n WHERE A.SHOP_CD      = '%s'                              ".rtrim()
				+"\n AND   A.SALE_DATE    = '%s'                              ".rtrim()
				+"\n AND   A.APPR_LOG_NO  = '%s'                              ".rtrim()
				+"\n AND   A.APPR_PROC_FG IN ('1','2','5')                    ".rtrim()
				;
			csQrySql = csQrySql.sprintf( paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.APPR_LOG_NO );
		}
		else {
			csQrySql = ""
				+"\nSELECT B.APPR_IDT_NO                   AS APPR_IDT_NO    ".rtrim()
				+"\n     , B.APPR_IDT_TYPE                 AS APPR_IDT_TYPE  ".rtrim()
				+"\n     , B.APPR_NO                       AS APPR_NO        ".rtrim()
				+"\n     , B.APPR_AMT                      AS APPR_AMT       ".rtrim()
				+"\n     , B.APPR_DATE                     AS APPR_DATE      ".rtrim()
				+"\n     , B.APPR_TIME                     AS APPR_TIME      ".rtrim()
				+"\n     , A.CORNER_CD                     AS CORNER_CD      ".rtrim()
				+"\n     , B.APPR_FG                       AS APPR_FG        ".rtrim()
				+"\n     , B.NOTICE_MSG                    AS NOTICE_MSG     ".rtrim()
				+"\n     , B.BROAD_MSG                     AS BROAD_MSG      ".rtrim()
				+"\n     , B.VAN_TERM_NO                   AS VAN_TERM_NO    ".rtrim()
				+"\n     , ( SELECT CORNER_NM                                ".rtrim()
				+"\n         FROM SCD_SHOPS_T                                ".rtrim()
				+"\n         WHERE SHOP_CD = B.SHOP_CD                       ".rtrim()
				+"\n         AND CORNER_CD = B.CORNER_CD ) AS CORNER_NM      ".rtrim()
				+"\n  FROM POS_ODCSH_T A                                     ".rtrim()
				+"\n     , POS_LGCSH_T B                                     ".rtrim()
				+"\n WHERE A.SHOP_CD      = '%s'                             ".rtrim()
				+"\n   AND A.SALE_DATE    = '%s'                             ".rtrim()
				+"\n   AND A.ORDER_NO     = '%s'                             ".rtrim()
				+"\n   AND A.LINE_NO     >= '%s'                             ".rtrim()
				+"\n   AND (A.APPR_LOG_NO <> '' AND A.APPR_LOG_NO IS NOT NULL)                               ".rtrim()
				+"\n   AND B.SHOP_CD      = A.SHOP_CD                        ".rtrim()
				+"\n   AND B.SALE_DATE    = A.SALE_DATE                      ".rtrim()
				+"\n   AND B.APPR_LOG_NO  = A.APPR_LOG_NO                    ".rtrim()
				+"\n   AND B.APPR_PROC_FG IN ('1','2','5')                   ".rtrim()
				+"\n ORDER BY B.APPR_NO                                      ".rtrim()
				;
			csQrySql = csQrySql.sprintf( paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.ORDER_NO, paramObj.csLineNo );
		}
		return csQrySql;
	}

	this.GetSalesJCardData_SQL = function (paramObj) {
		var csQrySql = "";
		csQrySql = ""
				+ "\n SELECT A.JCD_CARD_NO               AS  JCD_CARD_NO      ".rtrim()
				+ "\n      , A.APPR_AMT                  AS  APPR_AMT         ".rtrim()
				+ "\n      , A.APPR_DATE                 AS  APPR_DATE        ".rtrim()
				+ "\n      , A.APPR_TIME                 AS  APPR_TIME        ".rtrim()
				+ "\n      , A.APPR_NO                   AS  APPR_NO          ".rtrim()				
				+ "\n      , A.JCD_AVL_POINT             AS  JCD_AVL_POINT    ".rtrim()
				+ "\n      , CASE WHEN A.SALE_YN = 'N' THEN A.JCD_AVL_POINT * -1 ELSE A.JCD_AVL_POINT END       AS JCD_AVL_POINT_MP    ".rtrim()
				+ "\n      , A.JCD_REM_POINT             AS  JCD_REM_POINT    ".rtrim()
				+ "\n      , A.JCD_TYPE_FG               AS  JCD_TYPE_FG      ".rtrim()
				+ "\n      , A.APPR_PROC_FG              AS  APPR_PROC_FG     ".rtrim()
				+ "\n      , B.JCD_NM                    AS  JCD_NM           ".rtrim()
				+ "\n      , A.JCD_PROC_FG               AS  JCD_PROC_FG      ".rtrim()
				+ "\n      , A.BROAD_MSG                 AS  BROAD_MSG        ".rtrim()
				+ "\n      , CASE WHEN A.SALE_YN = 'N' THEN A.JCD_OCC_POINT * -1 ELSE A.JCD_OCC_POINT END       AS JCD_OCC_POINT    ".rtrim()
				+ "\n      , CASE WHEN A.SALE_YN = 'N' THEN A.JCD_DC_AMT * -1 ELSE A.JCD_DC_AMT END       AS JCD_DC_AMT    ".rtrim()
				+ "\n      , CASE WHEN A.SALE_YN = 'N' THEN A.JCD_USE_POINT * -1 ELSE A.JCD_USE_POINT END AS JCD_USE_POINT ".rtrim()
				+ "\n   FROM SSL_TRJCD_T A                                    ".rtrim()
				+ "\n   LEFT OUTER JOIN SCD_JCDHD_T B                         ".rtrim()
				+ "\n     ON B.SHOP_CD = A.SHOP_CD                            ".rtrim()
				+ "\n    AND B.JCD_CD  = A.JCD_CD                             ".rtrim()
				+ "\n  WHERE A.SHOP_CD   = '%s'                               ".rtrim()
				+ "\n    AND A.SALE_DATE = '%s'                               ".rtrim()
				+ "\n    AND A.POS_NO    = '%s'                               ".rtrim()
				+ "\n    AND A.BILL_NO   = '%s'                               ".rtrim()
				+ "\n  ORDER BY A.LINE_NO                                     ".rtrim()
			;
		csQrySql = csQrySql.sprintf( paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO);
		return csQrySql;
	}

	this.GetSalesCustData_SQL = function (paramObj) {
		var csQrySql = "";
		csQrySql = ""
			+ "\n SELECT A.CST_NO          AS CST_NO                                                      ".rtrim()
			+ "\n      , B.CST_NM          AS CST_NM                                                      ".rtrim()
			+ "\n      , SUM( AVL_POINT  ) AS AVL_POINT                                                   ".rtrim()
			+ "\n      , SUM( SALE_POINT ) AS SALE_POINT                                                  ".rtrim()
			+ "\n      , SUM( USE_POINT  ) AS USE_POINT                                                   ".rtrim()
			+ "\n      , SUM( WES_AMT    ) AS WES_AMT                                                     ".rtrim()
			+ "\n FROM ( SELECT CST_NO                                                     AS CST_NO      ".rtrim()
			+ "\n             , 0                                                          AS AVL_POINT   ".rtrim()
			+ "\n             , 0                                                          AS SALE_POINT  ".rtrim()
			+ "\n             , COALESCE( CST_USE_POINT, 0 ) * CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END  AS USE_POINT   ".rtrim()
			+ "\n             , 0                                                          AS WES_AMT     ".rtrim()
			+ "\n        FROM SSL_TRCST_T                                                                 ".rtrim()
			+ "\n        WHERE SHOP_CD   = '%s'                                                           ".rtrim()
			+ "\n        AND   SALE_DATE = '%s'                                                           ".rtrim()
			+ "\n        AND   POS_NO    = '%s'                                                           ".rtrim()
			+ "\n        AND   BILL_NO   = '%s'                                                           ".rtrim()
			+ "\n        AND   COALESCE( CST_NO, '' ) <> ''                                               ".rtrim()
			+ "\n        UNION "                                                                           .rtrim()
			+ "\n        SELECT WES_CST_NO                                                 AS CST_NO      ".rtrim()
			+ "\n             , 0                                                          AS AVL_POINT   ".rtrim()
			+ "\n             , 0                                                          AS SALE_POINT  ".rtrim()
			+ "\n             , 0                                                          AS USE_POINT   ".rtrim()
			+ "\n             , COALESCE( WES_AMT, 0 ) *  CASE WHEN SALE_YN = 'N' THEN  -1 ELSE 1 END       AS WES_AMT     ".rtrim()
			+ "\n        FROM SSL_TRWES_T                                                                 ".rtrim()
			+ "\n        WHERE SHOP_CD   = '%s'                                                           ".rtrim()
			+ "\n        AND   SALE_DATE = '%s'                                                           ".rtrim()
			+ "\n        AND   POS_NO    = '%s'                                                           ".rtrim()
			+ "\n        AND   BILL_NO   = '%s'                                                           ".rtrim()
			+ "\n        AND   COALESCE( WES_CST_NO, '' ) <> ''                                           ".rtrim()
			+ "\n        UNION                                                                            ".rtrim()
			+ "\n        SELECT CST_NO                                                      AS CST_NO     ".rtrim()
			+ "\n             , COALESCE( CST_AVL_POINT,  0 )                               AS AVL_POINT  ".rtrim()
			+ "\n             , COALESCE( CST_SALE_POINT, 0 ) *  CASE WHEN SALE_YN = 'N' THEN -1 ELSE 1 END AS SALE_POINT ".rtrim()
			+ "\n             , 0                                                           AS USE_POINT  ".rtrim()
			+ "\n             , 0                                                           AS WES_AMT    ".rtrim()
			+ "\n        FROM SSL_TRHDR_T " + "       WHERE SHOP_CD   = '%s'                              ".rtrim()
			+ "\n        AND   SALE_DATE = '%s'                                                           ".rtrim()
			+ "\n        AND   POS_NO    = '%s'                                                           ".rtrim()
			+ "\n        AND   BILL_NO   = '%s'                                                           ".rtrim()
			+ "\n        AND   COALESCE( CST_NO, '' ) <> '' ) A                                           ".rtrim()
			+ "\n      LEFT JOIN HCS_CSTMS_T B                                                            ".rtrim()
			+ "\n      ON  B.CST_OGN_CD = '%s'                                                            ".rtrim()
			+ "\n      AND B.CST_NO     = A.CST_NO " + "GROUP BY A.CST_NO                                 ".rtrim()
			+ "\n        , B.CST_NM                                                                       ".rtrim()
		;

		csQrySql = csQrySql.sprintf(
		     paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO
		   , paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO
		   , paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO
		   , SHOP_INFO.HD_SHOP_CD /* g_csOgnCd */ );
		return csQrySql ;
	}

	this.GetSalesGiftData_SQL = function(paramObj) {
		var csQrySql = "";
		csQrySql = ""
			+ "\n SELECT CASE WHEN SALE_YN = 'N' THEN TK_GFT_UAMT   * -1 ELSE TK_GFT_UAMT   END AS TK_GFT_UAMT   "
			+ "\n      , CASE WHEN SALE_YN = 'N' THEN TK_GFT_AMT    * -1 ELSE TK_GFT_AMT    END AS TK_GFT_AMT    "
			+ "\n      , CASE WHEN SALE_YN = 'N' THEN REPAY_CSH_AMT * -1 ELSE REPAY_CSH_AMT END AS REPAY_CSH_AMT "
			+ "\n      , CASE WHEN SALE_YN = 'N' THEN REPAY_GFT_AMT * -1 ELSE REPAY_GFT_AMT END AS REPAY_GFT_AMT "
			+ "\n FROM SSL_TRGFT_T       "
			+ "\n WHERE SHOP_CD   = '%s' "
			+ "\n AND   SALE_DATE = '%s' "
			+ "\n AND   POS_NO    = '%s' "
			csQrySql = csQrySql.sprintf( paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO );
	     ;
		return csQrySql;
	}
	this.GetSalesFoodData_SQL = function(paramObj ) {
		var csQrySql = "";
		csQrySql = ""
			+"\n SELECT CASE WHEN SALE_YN = 'N' THEN TK_FOD_UAMT   * -1 ELSE TK_FOD_UAMT   END AS TK_FOD_UAMT "
			+"\n      , CASE WHEN SALE_YN = 'N' THEN TK_FOD_AMT    * -1 ELSE TK_FOD_AMT    END AS TK_FOD_AMT "
			+"\n      , CASE WHEN SALE_YN = 'N' THEN TK_FOD_DC_AMT * -1 ELSE TK_FOD_DC_AMT END AS TK_FOD_DC_AMT "
			+"\n      , CASE WHEN SALE_YN = 'N' THEN ETC_AMT       * -1 ELSE ETC_AMT       END AS ETC_AMT "
			+"\n   FROM SSL_TRFOD_T      "
			+"\n  WHERE SHOP_CD   = '%s' "
			+"\n    AND SALE_DATE = '%s' "
			+"\n    AND POS_NO    = '%s' "
			+"\n    AND BILL_NO   = '%s' "
			;
		csQrySql = csQrySql.sprintf(  paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO);
		return csQrySql;
	}
	this.GetSalesCouponData_SQL = function(paramObj) {
		var csQrySql = "";
		csQrySql = ""
				+ "\n SELECT A.TK_CPN_CD                                                                                AS TK_CPN_CD   ".rtrim()
				+ "\n      , (SELECT B.TK_CPN_NM FROM SCD_TKCPN_T B WHERE SHOP_CD = '%s' AND B.TK_CPN_CD = A.TK_CPN_CD) AS TK_CPN_NAME ".rtrim()
				+ "\n      , SUM( CASE WHEN A.SALE_YN = 'Y' THEN 1 ELSE -1 END * A.DC_AMT_CPN )                         AS TK_CPN_AMT  ".rtrim()
				+ "\n   FROM SSL_TRDTL_T A		                                                                                       ".rtrim()
				+ "\n  WHERE A.SHOP_CD    = '%s'	                                                                                   ".rtrim()
				+ "\n    AND A.POS_NO     = '%s'	                                                                                   ".rtrim()
				+ "\n    AND A.SALE_DATE  = '%s'                                                                                       ".rtrim()
				+ "\n    AND A.BILL_NO    = '%s'                                                                                       ".rtrim()
				+ "\n  GROUP BY A.TK_CPN_CD                                                                                            ".rtrim()
			;
		csQrySql = csQrySql.sprintf(  paramObj.SHOP_CD, paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO);
		return csQrySql;
	}

	this.GetSalesEtcApprData_SQL = function (paramObj , sType ) {
		var csQrySql = "";
		if ( sType == "01") {
			csQrySql = ""
				+ "\n SELECT CASE WHEN A.SALE_YN = 'Y' THEN  A.ETC_APPR_AMT  "
				+ "\n             ELSE A.ETC_APPR_AMT * -1                   "
				+ "\n        END AS ETC_APPR_AMT   "
				+ "\n   FROM SSL_TRHDR_T A         "
				+ "\n  WHERE A.SHOP_CD   = '%s'    "
				+ "\n    AND A.SALE_DATE = '%s'    "
				+ "\n    AND A.POS_NO    = '%s'    "
				+ "\n    AND A.BILL_NO   = '%s'    "
				;
			csQrySql = csQrySql.sprintf(  paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO);
		} else if (sType == "02") {
			csQrySql = ""
				+"\n SELECT A.TR_TYPE_CD          AS TR_TYPE_CD     "
				+"\n      , A.USER_DATA           AS USER_DATA      "
				+"\n      , A.SALE_YN             AS SALE_YN        "
				+"\n      , B.CORNER_NM           AS CORNER_NM      "
				+"\n      , A.APPR_DATE           AS APPR_DATE      "
				+"\n      , A.APPR_TIME           AS APPR_TIME      "
				+"\n      , A.APPR_NO             AS APPR_NO        "
				+"\n      , A.CORNER_CD           AS CORNER_CD      "
				+"\n      , A.APPR_PROC_FG        AS APPR_PROC_FG   "	 // 2019-1129-HJH 임의승인 추가
				+"\n      , A.CARD_NO             AS CARD_NO        "	 // 2019-1210-HJH 카드번호 추가
//				+"\n      , ( SELECT COM_CD_NM FROM SP_GET_CCD_CODEM_NM ( '090' , A.TR_TYPE_CD ) ) AS TR_TYPE_NM "
				+ this.SP_GET_CCD_CODEM_NM_SQL( "090" , "A.TR_TYPE_CD") + " AS TR_TYPE_NM      ".rtrim()
				+"\n      , CASE WHEN A.SALE_YN = 'Y' THEN A.APPR_AMT        "
				+"\n             ELSE A.APPR_AMT * -1                        "
				+"\n         END                                   AS AMT_CNT_VALUE                            "
				+"\n FROM SSL_TRETC_T A       "
				+"\n      LEFT OUTER JOIN SCD_SHOPS_T B "
				+"\n      ON  A.SHOP_CD   = B.SHOP_CD "
				+"\n      AND A.CORNER_CD = B.CORNER_CD "
				+"\n WHERE A.SHOP_CD   = '%s' "
				+"\n   AND A.SALE_DATE = '%s' "
				+"\n   AND A.POS_NO    = '%s' "
				+"\n   AND A.BILL_NO   = '%s' "
				;
			csQrySql = csQrySql.sprintf(  paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO);
		}


		return csQrySql;
	}
	this.GetApprSlipRePrint_SQL = function(m_csPrintCode , paramObj) {
		var csQuery = "";
		var params = [];

		if( m_csPrintCode == "11"  ||  m_csPrintCode == "12" ) {
			csQuery = ""
					+  "\n SELECT LINE_NO                          "
					+  "\n      , SEQ_NO                           "
					+  "\n FROM SSL_TRCRD_T                        "
					+  "\n WHERE SHOP_CD      = '%s'               "
					+  "\n AND   SALE_DATE    = '%s'               "
					+  "\n AND   POS_NO       = '%s'               "
					+  "\n AND   BILL_NO      = '%s'               "
					+  "\n AND   APPR_PROC_FG IN ( '1', '2', '5' ) " 			// 2015-0826-Jane : 보안CAT 대리승인 추가.
					+  "\n ORDER BY LINE_NO                        "
					+  "\n        , SEQ_NO                         "
					;
			csQuery = csQuery.sprintf( paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO );

		}  else if( m_csPrintCode ==  "47" )		 { // 기타결제 추가
			csQuery =
					  "SELECT LINE_NO "
					+ "\n      , SEQ_NO "
					+ "\n FROM SSL_TRETC_T "
					+ "\n WHERE SHOP_CD      = '%s' "
					+ "\n AND   SALE_DATE    = '%s' "
					+ "\n AND   POS_NO       = '%s' "
					+ "\n AND   BILL_NO      = '%s' "
					+ "\n AND   APPR_PROC_FG IN ( '1', '2', '5' ) "			// 2015-0826-Jane : 보안CAT 대리승인 추가.
					+ "\n ORDER BY LINE_NO "
					+ "\n        , SEQ_NO "
					;
			csQuery = csQuery.sprintf( paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO );

		}  else {
			csQuery =
					   "\n  SELECT LINE_NO                               "
					+  "\n       , SEQ_NO                                "
					+  "\n    FROM SSL_TRCSH_T                             "
					+  "\n   WHERE SHOP_CD      = '%s'                    "
					+  "\n     AND SALE_DATE    = '%s'                    "
					+  "\n     AND POS_NO       = '%s'                    "
					+  "\n     AND BILL_NO      = '%s'                    "
					+  "\n     AND APPR_PROC_FG IN ( '0', '1', '2', '5' ) " 	  // 2013-1202 Antony.Choi : 단순현금도 현금 영수증 출력	//2015-0826-Jane : 보안CAT 대리승인 추가.
					+  "\n   ORDER BY LINE_NO "

					;
			csQuery = csQuery.sprintf( paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO );
		}
		return csQuery ;
	}
	this.GetOrderCancelReason_SQL = function() {
		return ""
			+"\n SELECT DISTINCT                       ".rtrim()
			+"\n        B.COM_CD_NM AS                 ".rtrim()
			+"\n   FROM POS_ODDTL_T A                  ".rtrim()
			+"\n   LEFT JOIN SCD_CODEM_T B             ".rtrim()
			+"\n        ON  A.SHOP_CD = B.SHOP_CD      ".rtrim()
			+"\n        AND A.CANCEL_REASON = B.COM_CD ".rtrim()
			+"\n  WHERE A.SHOP_CD   = '%s'             ".rtrim()
			+"\n    AND A.POS_NO    = '%s'             ".rtrim()
			+"\n    AND A.SALE_DATE = '%s'             ".rtrim()
			+"\n    AND A.ORDER_NO  = '%s'             ".rtrim()
			+"\n    AND A.ORDER_DTL_FG = '1'           ".rtrim()
			+"\n    AND A.ORG_ORDER_NO = ''            ".rtrim() // 2019-04-05-SHK [변경주문/변경취소]
			+"\n    AND A.ORDER_SEQ_NO = '%s'          ".rtrim()
			+"\n    AND B.COM_CD_FG    = '600'         ".rtrim()
			+"\n    AND B.USE_YN       = 'Y'           ".rtrim()
			;
	}
	this.GetGroupTableNo_SQL = function(paramObj) {

		var csQueryFormat =""
			+"\n SELECT B.TABLE_NM AS TABLE_NM						".rtrim()
			+"\n , C.TG_NM AS GROUP_NM								".rtrim()
			+"\n FROM POS_ODHDR_T A									".rtrim()
			+"\n , SCD_TABLE_T B									".rtrim()
			+"\n , SCD_TBGRP_T C									".rtrim()
			+"\n WHERE A.SHOP_CD   = '%s'							".rtrim()
			+"\n AND   A.SALE_DATE = '%s'							".rtrim()
			+"\n AND   A.ORDER_NO IN ( SELECT A.ORDER_NO			".rtrim()
			+"\n                     FROM POS_ODHDR_T A				".rtrim()
			+"\n                     , SCD_TABLE_T B				".rtrim()
			+"\n                     WHERE A.SHOP_CD = '%s'			".rtrim()
			+"\n                     AND A.SALE_DATE = '%s'			".rtrim()
			+"\n                     AND A.ORDER_END_FG = '0'		".rtrim()
			+"\n                     AND B.TABLE_CD = A.FD_TBL_CD	".rtrim()
			+"\n                     AND B.GROUP_CD = '%s'			".rtrim()
			+"\n                     ORDER BY B.TABLE_NM )			".rtrim()
			+"\n AND   B.SHOP_CD   = A.SHOP_CD						".rtrim()
			+"\n AND   B.TABLE_CD  = A.FD_TBL_CD					".rtrim()
			+"\n AND   C.SHOP_CD   = B.SHOP_CD						".rtrim()
			+"\n AND   C.TG_CD     = B.TG_CD						".rtrim()
			+"\n ORDER BY GROUP_NM                                  ".rtrim()
			;
		csQueryFormat = csQueryFormat.sprintf(  paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.GROUP_CD );
		return csQueryFormat;
	}

	this.GetGstData_SQL = function (paramObj) {
		var s = ""
			+ "SELECT SUM(FD_GST_CNT) AS FD_GST_CNT   ".rtrim()
			+ "FROM SSL_TRGST_T	                      ".rtrim()
			+ "WHERE SHOP_CD = '%s'                   ".rtrim()
			+ "AND SALE_DATE = '%s'                   ".rtrim()
			+ "AND BILL_NO   = '%s'                   ".rtrim()
		;
		s = s.sprintf( paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.BILL_NO );
		return s;
	}
	this.GetSalesOrderEmpName_SQL = function ( paramObj ) {
		var s = "";
		if( util.isEmptyStr( paramObj.BILL_NO )  ) {
			var s= ""
				+"\n SELECT (SELECT EMP_NM FROM SCD_EMPMS_T WHERE SHOP_CD = A.SHOP_CD AND EMP_NO = A.EMP_NO ) AS ORDER_EMP_NM "
				+"\n   FROM POS_ODDTL_T A                            ".rtrim()
				+"\n  WHERE SHOP_CD      = '%s'                      ".rtrim()
				+"\n    AND SALE_DATE    = '%s'                      ".rtrim()
				+"\n    AND POS_NO	     = '%s'                      ".rtrim()
				+"\n    AND ORDER_NO     = '%s'                      ".rtrim()
				+"\n    AND	ORDER_DTL_NO = (SELECT MAX(ORDER_DTL_NO) ".rtrim()
				+"\n                        FROM POS_ODDTL_T         ".rtrim()
				+"\n                        WHERE SHOP_CD   = '%s'   ".rtrim()
				+"\n 					   AND   SALE_DATE = '%s'    ".rtrim()
				+"\n 					   AND   POS_NO    = '%s'    ".rtrim()
				+"\n 					   AND   ORDER_NO  = '%s' )  ".rtrim()
				+"\n LIMIT 1                                         ".rtrim()
				;
			s = s.sprintf(gShopCd, paramObj.SALE_DATE, paramObj.POS_NO, paramObj.ORDER_NO , gShopCd, paramObj.SALE_DATE, paramObj.POS_NO, paramObj.ORDER_NO );
		} else {
			s = ""
				+"\n SELECT ( SELECT EMP_NM FROM SCD_EMPMS_T WHERE SHOP_CD = A.SHOP_CD AND   EMP_NO  = A.EMP_NO ) AS ORDER_EMP_NM "
				+"\n   FROM SSL_TRDTL_T A                        ".rtrim()
				+"\n  WHERE SHOP_CD   = '%s'                     ".rtrim()
				+"\n    AND SALE_DATE = '%s'                     ".rtrim()
				+"\n    AND POS_NO	  = '%s'                     ".rtrim()
				+"\n    AND BILL_NO   = '%s'                     ".rtrim()
				+"\n    AND	DTL_NO = (SELECT MAX(DTL_NO)         ".rtrim()
				+"\n                    FROM SSL_TRDTL_T         ".rtrim()
				+"\n                   WHERE SHOP_CD     = '%s'  ".rtrim()
				+"\n 				     AND SALE_DATE   = '%s'  ".rtrim()
				+"\n 			         AND POS_NO	     = '%s'  ".rtrim()
				+"\n 				     AND BILL_NO     = '%s' ) ".rtrim()
				+"\n LIMIT 1                                     ".rtrim()
				;
			s = s.sprintf( gShopCd, paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO ,gShopCd, paramObj.SALE_DATE, paramObj.POS_NO, paramObj.BILL_NO );
		}
		return s;
	}
	this.GetRegiEmpData_SQL = function( paramObj ) {
		var s = "";

		s = ""
			+"\n SELECT A.SALE_DATE    AS SALE_DATE ".rtrim()
			+"\n      , A.EMP_NO       AS EMP_NO    ".rtrim()
			+"\n      , B.EMP_NM       AS EMP_NM    ".rtrim()
			+"\n      , A.OPEN_DT      AS OPEN_DT   ".rtrim()
			+"\n      , A.CLOSE_DT     AS CLOSE_DT  ".rtrim()
			+"\n   FROM POS_REGIS_T A               ".rtrim()
			+"\n   LEFT OUTER JOIN SCD_EMPMS_T B    ".rtrim()
			+"\n     ON  A.SHOP_CD = B.SHOP_CD      ".rtrim()
			+"\n    AND A.EMP_NO  = B.EMP_NO        ".rtrim()
			+"\n  WHERE A.SHOP_CD   = '%s'          ".rtrim()
			+"\n    AND A.SALE_DATE = '%s'          ".rtrim()
			+"\n    AND A.POS_NO    = '%s'          ".rtrim()
			+"\n    AND A.REGI_SEQ  = '%02d'        ".rtrim()
		;
		s = s.sprintf( paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO, paramObj.REGI_SEQ );
		return s;
	}
	this.GetRegiOpenDtData_SQL = function ( paramObj ) {
		var s = ""
			+ "\n SELECT OPEN_DT         ".rtrim()
		    + "\n FROM POS_REGIS_T       ".rtrim()
		    + "\n WHERE SHOP_CD   = '%s' ".rtrim()
		    + "\n AND   SALE_DATE = '%s' ".rtrim()
		    + "\n AND   POS_NO    = '%s' ".rtrim()
		    + "\n AND   REGI_SEQ  = '00' ".rtrim()
		    ;
		s = s.sprintf(paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO);
		return s;
	}
	this.GetReissueAccountData_01_SQL =function (pcsCode , paramObj ) {
		var csQuery = "";
		///////////////////////////////////////////////////////////////////////////
		// 2014-1124-Jane : 현금IC카드 금액 조회.
		///////////////////////////////////////////////////////////////////////////
		csQuery  = ""
			+"\n SELECT                                         ".rtrim()
			+"\n        SALE_YN                                 ".rtrim()
			+"\n      , SUM(APPR_REQ_AMT) AS CRD_CASHIC_AMT     ".rtrim()
			+"\n   FROM SSL_TRCRD_T                             ".rtrim()
            +"\n  WHERE SHOP_CD   = '%s'                        ".rtrim()
			+"\n    AND UNION_PAY_FG   = '4'                    ".rtrim()
			+"\n    AND SALE_DATE BETWEEN '%s' AND '%s'         ".rtrim()
			;
		csQuery = csQuery.sprintf( paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE );
		csQuery += this.GetWhereClauseByPosNoAndSeqNo(paramObj.POS_NO, paramObj.REGI_SEQ);		// 2019-05-23-SHK [정산현황]
		csQuery += "\n  GROUP BY SALE_YN  ".rtrim();
		return csQuery
	}

	this.GetReissueAccountData_02_SQL =function (pcsCode , paramObj ) {

		var s =""
			+"\n SELECT                                      ".rtrim()
			+"\n        SUM(CASH_AMT)     AS RET_CASH_AMT    ".rtrim()
			+"\n      , SUM(CRD_CARD_AMT) AS RET_CARD_AMT    ".rtrim()
			+"\n   FROM SSL_TRHDR_T                          ".rtrim()
			+"\n WHERE SHOP_CD   = '%s'                      ".rtrim()
			+"\n AND   SALE_DATE BETWEEN '%s' AND '%s'       ".rtrim()
			+"\n AND   SALE_YN   = 'N'                       ".rtrim()
			;
		s = s.sprintf(paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE );
		s += this.GetWhereClauseByPosNoAndSeqNo(paramObj.POS_NO, paramObj.REGI_SEQ);		// 2019-05-23-SHK [정산현황]
		return s;
	}
	this.GetReissueAccountData_03_SQL =function (pcsCode , paramObj ) {
		var s= ""
			+"\n SELECT SUM( TOT_AMT        )  AS TOT_AMT          ".rtrim()
		    +"\n      , SUM( CANCEL_TOT_AMT )  AS CANCEL_TOT_AMT   ".rtrim()
			+"\n      , SUM( TOT_SALE_AMT   )  AS TOT_SALE_AMT     ".rtrim()
			+"\n      , SUM( TOT_DC_AMT     )  AS TOT_DC_AMT       ".rtrim()
			+"\n      , SUM( TOT_ETC_AMT    )  AS TOT_ETC_AMT      ".rtrim()
			+"\n      , SUM( DCM_SALE_AMT   )  AS DCM_SALE_AMT     ".rtrim()
			+"\n      , SUM( SVC_TIP_AMT    )  AS SVC_TIP_AMT      ".rtrim()
			+"\n      , SUM( NO_TAX_SALE_AMT)  AS NO_TAX_SALE_AMT  ".rtrim()
			+"\n      , SUM( NO_VAT_SALE_AMT)  AS NO_VAT_SALE_AMT  ".rtrim()
			+"\n      , SUM( VAT_SALE_AMT   )  AS VAT_SALE_AMT     ".rtrim()
			+"\n      , SUM( VAT_AMT        )  AS VAT_AMT          ".rtrim()
			+"\n   FROM REGI_SUM_VW                                ".rtrim()
			+"\n  WHERE SHOP_CD   = '%s'                           ".rtrim()
			+"\n    AND SALE_DATE BETWEEN '%s' AND '%s'            ".rtrim()
		;
	  s = s.sprintf( paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE );
	  s += this.GetWhereClauseByPosNoAndSeqNo(paramObj.POS_NO, paramObj.REGI_SEQ);		// 2019-05-23-SHK [정산현황]
	  return s;
	}

	this.GetReissueAccountData_04_SQL =function (pcsCode , paramObj ) {
		var s = "";
		///////////////////////////////////////////////////////////////////////////
		// 2014-1124-Jane : 현금IC카드 금액 조회.
		///////////////////////////////////////////////////////////////////////////
		s  = ""
			+"\n SELECT SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END * APPR_REQ_AMT) AS CRD_CASHIC_AMT  ".rtrim()
			+"\n   FROM SSL_TRCRD_T                                                        ".rtrim()
			+"\n  WHERE SHOP_CD         = '%s'                                             ".rtrim()
			+"\n    AND UNION_PAY_FG    = '4'                                              ".rtrim()
			+"\n    AND SALE_DATE BETWEEN '%s' AND '%s'                                    ".rtrim()
			;
		s = s.sprintf(paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE );
		s += this.GetWhereClauseByPosNoAndSeqNo(paramObj.POS_NO, paramObj.REGI_SEQ);		// 2019-05-23-SHK [정산현황]
		return s
	}

	this.GetReissueAccountData_05_SQL =function (pcsCode , paramObj ) {
		var s = "";
		s  = ""
			+"\n SELECT SUM( CASH_AMT       )   AS CASH_AMT        ".rtrim()
			+"\n      , SUM( CASH_BILL_AMT  )   AS CASH_BILL_AMT   ".rtrim()
			+"\n	  , SUM( CRD_CARD_AMT   )   AS CRD_CARD_AMT    ".rtrim()
			+"\n	  , SUM( WES_AMT        )   AS WES_AMT         ".rtrim()
			+"\n	  , SUM( TK_GFT_AMT     )   AS TK_GFT_AMT      ".rtrim()
			+"\n	  , SUM( JCD_CARD_AMT   )   AS JCD_CARD_AMT    ".rtrim()
			+"\n	  , SUM( CST_POINT_AMT  )   AS CST_POINT_AMT   ".rtrim()
			+"\n	  , SUM( TK_FOD_AMT     )   AS TK_FOD_AMT      ".rtrim()
			+"\n	  , SUM( TOT_SALE_AMT   )   AS TOT_SALE_AMT    ".rtrim()
			+"\n	  , SUM( DCM_SALE_AMT   )   AS DCM_SALE_AMT    ".rtrim()
			+"\n	  , SUM( VAT_SALE_AMT   )   AS VAT_SALE_AMT    ".rtrim()
			+"\n	  , SUM( VAT_AMT        )   AS VAT_AMT         ".rtrim()
			+"\n	  , SUM( NO_VAT_SALE_AMT)   AS NO_VAT_SALE_AMT ".rtrim()
			+"\n	  , SUM( TOT_ETC_AMT    )   AS TOT_ETC_AMT     ".rtrim()
			+"\n	  , SUM( SVC_TIP_AMT    )   AS SVC_TIP_AMT     ".rtrim()
			+"\n	  , SUM( RFC_AMT        )   AS RFC_AMT         ".rtrim()
			+"\n	  , SUM( ETC_APPR_AMT   )   AS ETC_APPR_AMT    ".rtrim()	      //2017-0628 Antony.Choi : [커반]기타결제 금액 추가
			+"\n   FROM REGI_SUM_VW                                ".rtrim()
			+"\n  WHERE SHOP_CD   = '%s'                           ".rtrim()
			+"\n    AND SALE_DATE BETWEEN '%s' AND '%s'            ".rtrim()
		;
		s = s.sprintf(  paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE );
		s += this.GetWhereClauseByPosNoAndSeqNo(paramObj.POS_NO, paramObj.REGI_SEQ);		// 2019-05-23-SHK [정산현황]
		return s
	}
	this.GetReissueAccountData_06_SQL =function (pcsCode , paramObj ) {
		var s = ""
			+"\n SELECT SUM( DC_GEN_AMT )  AS DC_GEN_AMT ".rtrim()
			+"\n 	  , SUM( DC_SVC_AMT )  AS DC_SVC_AMT ".rtrim()
			+"\n 	  , SUM( DC_PCD_AMT )  AS DC_PCD_AMT ".rtrim()
			+"\n 	  , SUM( DC_CPN_AMT )  AS DC_CPN_AMT ".rtrim()
			+"\n 	  , SUM( DC_CST_AMT )  AS DC_CST_AMT ".rtrim()
			+"\n 	  , SUM( DC_TFD_AMT )  AS DC_TFD_AMT ".rtrim()
			+"\n 	  , SUM( DC_PRM_AMT )  AS DC_PRM_AMT ".rtrim()
			+"\n 	  , SUM( DC_CRD_AMT )  AS DC_CRD_AMT ".rtrim()
			+"\n 	  , SUM( TOT_DC_AMT )  AS TOT_DC_AMT ".rtrim()
			+"\n   FROM REGI_SUM_VW                      ".rtrim()
			+"\n  WHERE SHOP_CD   = '%s'                 ".rtrim()
			+"\n    AND SALE_DATE BETWEEN '%s' AND '%s'  ".rtrim()
		;
		s = s.sprintf( paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE );
		s+= this.GetWhereClauseByPosNoAndSeqNo(paramObj.POS_NO, paramObj.REGI_SEQ);		// 2019-05-23-SHK [정산현황]
		return s;
	}

	this.GetReissueAccountData_07_SQL =function (pcsCode , paramObj ) {
		var s = ""
			+"\nSELECT SUM( REM_CHECK_AMT  )  		   AS REM_CHECK_AMT "
			+"\n	 , SUM( REM_W100000_CNT)  		   AS REM_W100000_CNT "
			+"\n	 , SUM( REM_W50000_CNT )  		   AS REM_W50000_CNT "
			+"\n	 , SUM( REM_W10000_CNT )  		   AS REM_W10000_CNT "
			+"\n	 , SUM( REM_W5000_CNT  )  		   AS REM_W5000_CNT "
			+"\n	 , SUM( REM_W1000_CNT  )  		   AS REM_W1000_CNT "
			+"\n	 , SUM( REM_W500_CNT   )  		   AS REM_W500_CNT "
			+"\n	 , SUM( REM_W100_CNT   )  		   AS REM_W100_CNT "
			+"\n	 , SUM( REM_W50_CNT    )  		   AS REM_W50_CNT "
			+"\n	 , SUM( REM_W10_CNT    )  		   AS REM_W10_CNT "
			+"\n	 , SUM( REM_W100000_CNT)  * 100000 AS REM_W100000_AMT "
			+"\n	 , SUM( REM_W50000_CNT )  * 50000  AS REM_W50000_AMT "
			+"\n	 , SUM( REM_W10000_CNT )  * 10000  AS REM_W10000_AMT "
			+"\n	 , SUM( REM_W5000_CNT  )  * 5000   AS REM_W5000_AMT "
			+"\n	 , SUM( REM_W1000_CNT  )  * 1000   AS REM_W1000_AMT "
			+"\n	 , SUM( REM_W500_CNT   )  * 500    AS REM_W500_AMT "
			+"\n	 , SUM( REM_W100_CNT   )  * 100    AS REM_W100_AMT "
			+"\n	 , SUM( REM_W50_CNT    )  * 50     AS REM_W50_AMT "
			+"\n	 , SUM( REM_W10_CNT    )  * 10     AS REM_W10_AMT "
			+"\n	 , SUM( REM_CASH_AMT   )           AS REM_CASH_AMT "
			+"\n	 , SUM( LOSS_CASH_AMT  )           AS LOSS_CASH_AMT "
			+"\n  FROM POS_REGIS_T "
			+"\n WHERE SHOP_CD   = '%s' "
			+"\n   AND   SALE_DATE BETWEEN '%s' AND '%s' "
			;
		s = s.sprintf( paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE );
		s += this.GetWhereClauseByPosNoAndSeqNo(paramObj.POS_NO, paramObj.REGI_SEQ);		// 2019-05-23-SHK [정산현황]
		return s;
	}

	this.GetReissueAccountData_08_SQL =function (pcsCode , paramObj ) {
		var s = ""
			+"\n SELECT AMT1 "
			+"\n  	 , AMT2 "
			+"\n 	 , AMT3 "
			+"\n 	 , AMT4 "
			+"\n 	 , AMT5 "
			+"\n 	 , AMT6 "
			+"\n 	 , AMT7 "
			+"\n 	 , AMT8 "
			+"\n 	 , ( AMT1 + AMT2 + AMT3 + AMT4 + AMT5 + AMT6 - AMT7 - AMT8)  AS AMT "
			+"\n FROM ( SELECT SUM( CASE WHEN CODE = '01' THEN AMT ELSE 0 END ) AMT1 "
			+"\n 			 , SUM( CASE WHEN CODE = '08' THEN AMT ELSE 0 END ) AMT2 "
			+"\n 			 , SUM( CASE WHEN CODE = '04' THEN AMT ELSE 0 END ) AMT3 "
			+"\n 			 , SUM( CASE WHEN CODE = '02' THEN AMT ELSE 0 END ) AMT4 "
			+"\n 			 , SUM( CASE WHEN CODE = '03' THEN AMT ELSE 0 END ) AMT5 "
			+"\n 			 , SUM( CASE WHEN CODE = '05' THEN AMT ELSE 0 END ) AMT6 "
			+"\n 			 , SUM( CASE WHEN CODE = '06' THEN AMT ELSE 0 END ) AMT7 "
			+"\n 			 , SUM( CASE WHEN CODE = '07' THEN AMT ELSE 0 END ) AMT8 "
			+"\n        FROM CASH_SUM_VW   "
			+"\n        WHERE SHOP_CD   = '%s' "
			+"\n        AND   SALE_DATE BETWEEN '%s' AND '%s' "
			;
		  s = s.sprintf( paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE );
		  s += this.GetWhereClauseByPosNoAndSeqNo(paramObj.POS_NO, paramObj.REGI_SEQ ) + "\n   )\n";		// 2019-05-23-SHK [정산현황]
		  return s;
	}
	this.GetReissueAccountData_09_SQL =function (pcsCode , paramObj ) {
		var s = ""
				+ "\n SELECT SUM( CNT1 )  AS CNT1 "
				+ "\n      , SUM( CNT2 )  AS CNT2 "
				+ "\n 	   , SUM( AMT1 )  AS AMT1 "
				+ "\n 	   , SUM( AMT2 )  AS AMT2 "
				+ "\n      , SUM( CNT1)  - SUM( CNT2 ) AS TOT_CNT "
				+ "\n      , SUM( AMT1)  - SUM( AMT2 ) AS TOT_AMT "
				+ "\n   FROM ( SELECT CASE SALE_YN WHEN 'Y' THEN 1 ELSE 0 END AS CNT1 "
				+ "\n             , CASE SALE_YN WHEN 'N' THEN 1 ELSE 0 END AS CNT2 "
				+ "\n             , CASE SALE_YN WHEN 'Y' THEN APPR_AMT ELSE 0 END AS AMT1 "
				+ "\n             , CASE SALE_YN WHEN 'N' THEN APPR_AMT ELSE 0 END AS AMT2 "
				+ "\n        FROM SSL_TRCRD_T " + "       WHERE SHOP_CD   = '%s' "
				+ "\n        AND   SALE_DATE BETWEEN '%s' AND '%s' ";
		s = s.sprintf(paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE);
		s += this.GetWhereClauseByPosNoAndSeqNo(paramObj.POS_NO, paramObj.REGI_SEQ) + "\n   )\n";		// 2019-05-23-SHK [정산현황]
		return s;
	}

	this.GetReissueAccountData_10_SQL =function (pcsCode , paramObj ) {
		var s = ""
			+"\n SELECT                                                                                        ".rtrim()
			+"\n        APPR_NO                                                                                ".rtrim()
			+"\n      , CASE WHEN SALE_YN = 'Y' THEN '승인' ELSE '취소' END                   AS APPR_FG       ".rtrim()
			+"\n      , CASE WHEN SALE_YN = 'N' THEN -1 ELSE 1 END * APPR_REQ_AMT             AS APPR_REQ_AMT  ".rtrim()
			+"\n      , CASE                                                                                   ".rtrim()
			+"\n             WHEN UNION_PAY_FG = '4' THEN CRD_CARD_NO                                          ".rtrim() 
			+"\n             ELSE SUBSTR( CRD_CARD_NO, 1, 8 ) || '****' || SUBSTR( CRD_CARD_NO, 13, 16 )       ".rtrim() 
			+"\n         END AS CRD_CARD_NO                                                                    ".rtrim()  // 2014-1124-Jane : 현금IC 추가.
			+"\n   FROM SSL_TRCRD_T                                                                            ".rtrim()
			+"\n  WHERE SHOP_CD   = '%s'                                                                       ".rtrim()
			+"\n    AND SALE_DATE BETWEEN '%s' AND '%s'                                                        ".rtrim()
		;

		s = s.sprintf( paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE );
		s+= this.GetWhereClauseByPosNoAndSeqNo(paramObj.POS_NO, paramObj.REGI_SEQ);		// 2019-05-23-SHK [정산현황]
		return s;
	}

	this.GetReissueAccountData_11_SQL =function (pcsCode , paramObj ) {
		var s = ""

			+"\n SELECT PUR_CRDCP_CD                                                              ".rtrim()
			+"\n      , PUR_CRDCP_NM                                                              ".rtrim()
			+"\n 	  , COUNT( PUR_CRDCP_CD ) AS CNT                                              ".rtrim()
			+"\n 	  , SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END * APPR_AMT ) AS APPR_AMT  ".rtrim()
			+"\n   FROM SSL_TRCRD_T                                                               ".rtrim()
			+"\n  WHERE SHOP_CD   = '%s'                                                          ".rtrim()
			+"\n    AND SALE_DATE BETWEEN '%s' AND '%s'                                           ".rtrim()
		;
		s = s.sprintf( paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE );
		s += this.GetWhereClauseByPosNoAndSeqNo(paramObj.POS_NO, paramObj.REGI_SEQ);		// 2019-05-23-SHK [정산현황]
		s += "\n  GROUP BY PUR_CRDCP_CD, PUR_CRDCP_NM ";
		return s;
	}
	this.GetReissueAccountData_12_SQL =function (pcsCode , paramObj ) {
		var csQuery = ""
			+"\n SELECT COUNT( TRHDR.BILL_NO )                                                                                                                                             AS BILL_CNT       ".rtrim()
			+"\n 	  , SUM( TRHDR.FD_GST_CNT_T )                                                                                                                                           AS GUEST_CNT       ".rtrim()
			+"\n 	  , SUM( CASE WHEN ( TRHDR.SALE_YN = 'Y' ) AND (  TRHDR.CST_SALE_POINT > 0 ) THEN 1 WHEN ( TRHDR.SALE_YN = 'N' ) AND (  TRHDR.CST_SALE_POINT > 0 ) THEN -1 ELSE 0 END ) AS SALE_CNT        ".rtrim()
			+"\n 	  , SUM( CASE TRHDR.SALE_YN WHEN 'Y' THEN  TRHDR.CST_SALE_POINT WHEN 'N' THEN  TRHDR.CST_SALE_POINT * -1 ELSE 0 END )                                                   AS SALE_POINT      ".rtrim()
			+"\n 	  , SUM( CASE WHEN ( TRHDR.SALE_YN = 'Y' ) AND ( TRHDR.CST_USE_POINT > 0 ) THEN 1 WHEN ( TRHDR.SALE_YN = 'N' ) AND ( TRHDR.CST_USE_POINT > 0 ) THEN -1 ELSE 0 END )     AS USE_CNT         ".rtrim()  // 2019-05-23-SHK [정산현황]
			+"\n 	  , SUM( CASE TRHDR.SALE_YN WHEN 'Y' THEN TRHDR.CST_USE_POINT WHEN 'N' THEN TRHDR.CST_USE_POINT * -1 ELSE 0 END )                                                       AS USE_POINT       ".rtrim()
			+"\n   FROM SSL_TRHDR_T TRHDR                                                                                                                                                                       ".rtrim()  // 2019-05-23-SHK [정산현황]
			+"\n  WHERE TRHDR.SHOP_CD   = '%s'                                                                                                                                                                 ".rtrim()
			+"\n    AND TRHDR.SALE_DATE BETWEEN '%s' AND '%s'                                                                                                                                                  ".rtrim()
		;
		csQuery = csQuery.sprintf( paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE );

		csQuery += this.GetWhereClauseByPosNoAndSeqNo(paramObj.POS_NO, paramObj.REGI_SEQ);		// 2019-05-23-SHK [정산현황]
		return csQuery;
	}

	this.GetWhereClauseByPosNoAndSeqNo = function ( pcsPosNo , pcsSeqNo ) {
		var csClause = "";
		var csTemp = "";

		if (  parseInt(pcsPosNo) != 0 ) {
			csClause = "\n   AND POS_NO    = '%s'  ".sprintf( pcsPosNo).rtrim();
		}

		if ( parseInt (pcsSeqNo) != 0 ) {
			var sd = "";
			var parseSeqNo = parseInt(pcsSeqNo);
			if ( parseSeqNo < 10) {
				sd = "0" + parseSeqNo;
			} else {
				sd = parseSeqNo + "";
			}
			csTemp  = "\n   AND REGI_SEQ  = '%s' ".sprintf( sd );
		} else if (pcsSeqNo == "전체" || pcsSeqNo == "마감") {
			csTemp  = "\n   AND REGI_SEQ  <> '00'   ";

		}

		csClause += csTemp.rtrim();
		return csClause
	}
	this.GetRegiTotalData_true_SQL_01 = function ( paramObj) {
		var s =""
		  +"\n SELECT                                                                                                             ".rtrim()
		  +"\n        SUM( CASE WHEN TK_GFT_SALE_FG = 0 OR TK_GFT_SALE_FG = 2 THEN 1 ELSE 0 END * TK_GFT_UAMT ) AS TK_GFT_IN_AMT  ".rtrim()
		  +"\n      , SUM( CASE WHEN TK_GFT_SALE_FG = 1 OR TK_GFT_SALE_FG = 3 THEN 1 ELSE 0 END * TK_GFT_UAMT ) AS TK_GFT_OUT_AMT ".rtrim()
		  +"\n   FROM ( SELECT A.SHOP_CD                 ".rtrim()
		  +"\n             , A.SALE_DATE                 ".rtrim()
		  +"\n             , A.POS_NO                    ".rtrim()
		  +"\n             , B.REGI_SEQ                  ".rtrim()
		  +"\n             , A.TK_GFT_SALE_FG            ".rtrim()
		  +"\n             , A.TK_GFT_UAMT               ".rtrim()
		  +"\n        FROM SSL_TRGFA_T A                 ".rtrim()
		  +"\n             LEFT JOIN SSL_TRGFT_T B       ".rtrim()
		  +"\n             ON  B.SHOP_CD   = A.SHOP_CD   ".rtrim()
		  +"\n             AND B.SALE_DATE = A.SALE_DATE ".rtrim()
		  +"\n             AND B.POS_NO    = A.POS_NO    ".rtrim()
		  +"\n             AND B.BILL_NO   = A.BILL_NO  )".rtrim()
		  +"\n  WHERE SHOP_CD   = '%s'                   ".rtrim()
		  +"\n    AND SALE_DATE = '%s'                   ".rtrim()
		  +"\n    AND POS_NO    = '%s'                   ".rtrim()
		  ;
		  s = s.sprintf( paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO );
		  return s;
	}
	this.GetRegiTotalData_true_SQL_02 = function ( paramObj) {
		var s= ""
			+"\n SELECT                                   ".rtrim()
			+"\n        SUM(CASH_AMT)     AS RET_CASH_AMT ".rtrim()
			+"\n      , SUM(CRD_CARD_AMT) AS RET_CARD_AMT ".rtrim()
		    +"\n   FROM SSL_TRHDR_T                       ".rtrim()
		    +"\n  WHERE SHOP_CD   = '%s'                  ".rtrim()
		    +"\n    AND SALE_DATE = '%s'                  ".rtrim()
		    +"\n    AND POS_NO    = '%s'                  ".rtrim()
		    +"\n    AND SALE_YN   = 'N'                   ".rtrim()
		   ;
	   s =s.sprintf(paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO );
	   return s;
	}

	this.GetRegiTotalData_true_SQL_03 = function ( paramObj ) {
		var s= ""
			+"\n SELECT                                 ".rtrim()
			+"\n        SALE_YN                         ".rtrim()
			+"\n      , SUM(APPR_REQ_AMT) AS CASHIC_AMT ".rtrim()
			+"\n   FROM SSL_TRCRD_T                     ".rtrim()
			+"\n  WHERE SHOP_CD     = '%s'              ".rtrim()
			+"\n    AND SALE_DATE   = '%s'              ".rtrim()
			+"\n    AND POS_NO      = '%s'              ".rtrim()
			+"\n    AND UNION_PAY_FG = '4'              ".rtrim()
			+"\n  GROUP BY SALE_YN                      ".rtrim()
			;
		s = s.sprintf(paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO);
		return s;
	}
	this.GetRegiTotalData_true_SQL_04 = function ( paramObj ) {
		var s= ""
			+"\n SELECT                  ".rtrim()
			+"\n        *                ".rtrim()
			+"\n   FROM (                ".rtrim()
			+ this.SP_POS_REGIS_T_REGI_SEQ_SUM_SQL()
			+"\n  )                      ".rtrim()
			;

		s = s.sprintf(paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO , '00' );
		return s;
	}

	this.SP_POS_REGIS_T_REGI_SEQ_SUM_SQL = function () {
		var s = ""
			+"\n         SELECT TOT_BILL_CNT                AS TOT_BILL_CNT          ".rtrim()
			+"\n              , TOT_SALE_AMT + RET_BILL_AMT AS TOT_AMT               ".rtrim()
			+"\n              , TOT_SALE_AMT                AS TOT_SALE_AMT          ".rtrim()
			+"\n              , TOT_DC_AMT                  AS TOT_DC_AMT            ".rtrim()
			+"\n              , SVC_TIP_AMT                 AS SVC_TIP_AMT           ".rtrim()
			+"\n              , TOT_ETC_AMT                 AS TOT_ETC_AMT           ".rtrim()
			+"\n              , DCM_SALE_AMT                AS DCM_SALE_AMT          ".rtrim()
			+"\n              , VAT_SALE_AMT                AS VAT_SALE_AMT          ".rtrim()
			+"\n              , VAT_AMT                     AS VAT_AMT               ".rtrim()
			+"\n              , NO_VAT_SALE_AMT             AS NO_VAT_SALE_AMT       ".rtrim()
			+"\n              , NO_TAX_SALE_AMT             AS NO_TAX_SALE_AMT       ".rtrim()
			+"\n              , RET_BILL_CNT                AS RET_BILL_CNT          ".rtrim()
			+"\n              , RET_BILL_AMT                AS RET_BILL_AMT          ".rtrim()
			+"\n              , VISIT_CST_CNT               AS VISIT_CST_CNT         ".rtrim()
			+"\n              , POS_READY_AMT               AS POS_READY_AMT         ".rtrim()
			+"\n              , POS_CSH_IN_AMT              AS POS_CSH_IN_AMT        ".rtrim()
			+"\n              , POS_CSH_OUT_AMT             AS POS_CSH_OUT_AMT       ".rtrim()
			+"\n              , WEA_IN_CSH_AMT              AS WEA_IN_CSH_AMT        ".rtrim()
			+"\n              , WEA_IN_CRD_AMT              AS WEA_IN_CRD_AMT        ".rtrim()
			+"\n              , TK_GFT_SALE_CSH_AMT         AS TK_GFT_SALE_CSH_AMT   ".rtrim()
			+"\n              , TK_GFT_SALE_CRD_AMT         AS TK_GFT_SALE_CRD_AMT   ".rtrim()
			+"\n              , TK_FOD_SALE_CSH_AMT         AS TK_FOD_SALE_CSH_AMT   ".rtrim()
			+"\n              , TK_FOD_SALE_CRD_AMT         AS TK_FOD_SALE_CRD_AMT   ".rtrim()
			+"\n              , CASH_CNT                    AS CASH_CNT              ".rtrim()
			+"\n              , CASH_AMT                    AS CASH_AMT              ".rtrim()
			+"\n              , CASH_BILL_CNT               AS CASH_BILL_CNT         ".rtrim()
			+"\n              , CASH_BILL_AMT               AS CASH_BILL_AMT         ".rtrim()
			+"\n              , CRD_CARD_CNT                AS CRD_CARD_CNT          ".rtrim()
			+"\n              , CRD_CARD_AMT                AS CRD_CARD_AMT          ".rtrim()
			+"\n              , WES_CNT                     AS WES_CNT               ".rtrim()
			+"\n              , WES_AMT                     AS WES_AMT               ".rtrim()
			+"\n              , TK_GFT_CNT                  AS TK_GFT_CNT            ".rtrim()
			+"\n              , TK_GFT_AMT                  AS TK_GFT_AMT            ".rtrim()
			+"\n              , TK_FOD_CNT                  AS TK_FOD_CNT            ".rtrim()
			+"\n              , TK_FOD_AMT                  AS TK_FOD_AMT            ".rtrim()
			+"\n              , CST_POINT_CNT               AS CST_POINT_CNT         ".rtrim()
			+"\n              , CST_POINT_AMT               AS CST_POINT_AMT         ".rtrim()
			+"\n              , JCD_CARD_CNT                AS JCD_CARD_CNT          ".rtrim()
			+"\n              , JCD_CARD_AMT                AS JCD_CARD_AMT          ".rtrim()
			+"\n              , RFC_CNT                     AS RFC_CNT               ".rtrim()  //-- 2010-1028-JJM : 사원카드결제.
			+"\n              , RFC_AMT                     AS RFC_AMT               ".rtrim()  //-- 2010-1020-JJM : 사원카드결제.
			+"\n              , ETC_APPR_CNT                AS ETC_APPR_CNT          ".rtrim()  // -- 2017-06-13-JYL [기타결제:커피에반하다(톨게이트)]
			+"\n              , ETC_APPR_AMT                AS ETC_APPR_AMT          ".rtrim()  // -- 2017-06-13-JYL [기타결제:커피에반하다(톨게이트)]
			+"\n              , DC_GEN_CNT                  AS DC_GEN_CNT            ".rtrim()
			+"\n              , DC_GEN_AMT                  AS DC_GEN_AMT            ".rtrim()
			+"\n              , DC_SVC_CNT                  AS DC_SVC_CNT            ".rtrim()
			+"\n              , DC_SVC_AMT                  AS DC_SVC_AMT            ".rtrim()
			+"\n              , DC_JCD_CNT                  AS DC_JCD_CNT            ".rtrim()
			+"\n              , DC_JCD_AMT                  AS DC_JCD_AMT            ".rtrim()
			+"\n              , DC_CPN_CNT                  AS DC_CPN_CNT            ".rtrim()
			+"\n              , DC_CPN_AMT                  AS DC_CPN_AMT            ".rtrim()
			+"\n              , DC_CST_CNT                  AS DC_CST_CNT            ".rtrim()
			+"\n              , DC_CST_AMT                  AS DC_CST_AMT            ".rtrim()
			+"\n              , DC_TFD_CNT                  AS DC_TFD_CNT            ".rtrim()
			+"\n              , DC_TFD_AMT                  AS DC_TFD_AMT            ".rtrim()
			+"\n              , DC_PRM_CNT                  AS DC_PRM_CNT            ".rtrim()
			+"\n              , DC_PRM_AMT                  AS DC_PRM_AMT            ".rtrim()
			+"\n              , DC_CRD_CNT                  AS DC_CRD_CNT            ".rtrim()
			+"\n              , DC_CRD_AMT                  AS DC_CRD_AMT            ".rtrim()
			+"\n              , DC_PACK_CNT                 AS DC_PACK_CNT           ".rtrim()
			+"\n              , DC_PACK_AMT                 AS DC_PACK_AMT           ".rtrim()
			+"\n              , REM_CHECK_CNT               AS REM_CHECK_CNT         ".rtrim()
			+"\n              , REM_CHECK_AMT               AS REM_CHECK_AMT         ".rtrim()
			+"\n              , REM_W100000_CNT             AS REM_W100000_CNT       ".rtrim()
			+"\n              , REM_W50000_CNT              AS REM_W50000_CNT        ".rtrim()
			+"\n              , REM_W10000_CNT              AS REM_W10000_CNT        ".rtrim()
			+"\n              , REM_W5000_CNT               AS REM_W5000_CNT         ".rtrim()
			+"\n              , REM_W1000_CNT               AS REM_W1000_CNT         ".rtrim()
			+"\n              , REM_W500_CNT                AS REM_W500_CNT          ".rtrim()
			+"\n              , REM_W100_CNT                AS REM_W100_CNT          ".rtrim()
			+"\n              , REM_W50_CNT                 AS REM_W50_CNT           ".rtrim()
			+"\n              , REM_W10_CNT                 AS REM_W10_CNT           ".rtrim()
			+"\n              , REM_W100000_CNT* 100000     AS REM_W100000_AMT       ".rtrim()
			+"\n              , REM_W50000_CNT * 50000      AS REM_W50000_AMT        ".rtrim()
			+"\n              , REM_W10000_CNT * 10000      AS REM_W10000_AMT        ".rtrim()
			+"\n              , REM_W5000_CNT  * 5000       AS REM_W5000_AMT         ".rtrim()
			+"\n              , REM_W1000_CNT  * 1000       AS REM_W1000_AMT         ".rtrim()
			+"\n              , REM_W500_CNT   * 500        AS REM_W500_AMT          ".rtrim()
			+"\n              , REM_W100_CNT   * 100        AS REM_W100_AMT          ".rtrim()
			+"\n              , REM_W50_CNT    * 50         AS REM_W50_AMT           ".rtrim()
			+"\n              , REM_W10_CNT    * 10         AS REM_W10_AMT           ".rtrim()
			+"\n              , REM_CASH_AMT                AS REM_CASH_AMT          ".rtrim()
			+"\n              , REM_TK_GFT_CNT              AS REM_TK_GFT_CNT        ".rtrim()
			+"\n              , REM_TK_GFT_AMT              AS REM_TK_GFT_AMT        ".rtrim()
			+"\n              , REM_TK_FOD_CNT              AS REM_TK_FOD_CNT        ".rtrim()
			+"\n              , REM_TK_FOD_AMT              AS REM_TK_FOD_AMT        ".rtrim()
			+"\n              , ETC_TK_FOD_AMT              AS ETC_TK_FOD_AMT        ".rtrim()
			+"\n              , LOSS_CASH_AMT               AS LOSS_CASH_AMT         ".rtrim()
			+"\n              , LOSS_TK_GFT_AMT             AS LOSS_TK_GFT_AMT       ".rtrim()
			+"\n              , LOSS_TK_FOD_AMT             AS LOSS_TK_FOD_AMT       ".rtrim()
			+"\n              , REPAY_CASH_CNT              AS REPAY_CASH_CNT        ".rtrim()
			+"\n              , REPAY_CASH_AMT              AS REPAY_CASH_AMT        ".rtrim()
			+"\n              , REPAY_TK_GFT_CNT            AS REPAY_TK_GFT_CNT      ".rtrim()
			+"\n              , REPAY_TK_GFT_AMT            AS REPAY_TK_GFT_AMT      ".rtrim()
			+"\n              , POS_READY_AMT + CASH_AMT + WEA_IN_CSH_AMT + TK_GFT_SALE_CSH_AMT + TK_FOD_SALE_CSH_AMT + POS_CSH_IN_AMT - POS_CSH_OUT_AMT - REPAY_CASH_AMT AS TOT_CASH_AMT    ".rtrim()
			+"\n         FROM POS_REGIS_T                                             ".rtrim()
			+"\n         WHERE SHOP_CD   = '%s'                                       ".rtrim()
			+"\n         AND   SALE_DATE = '%s'                                       ".rtrim()
			+"\n         AND   POS_NO    = '%s'                                       ".rtrim()
			+"\n         AND   REGI_SEQ  = '%s'                                       ".rtrim()
			;
		return s;
		/**
			+"\n --------------------------------------------------------------------------------               ".rtrim()
			+"\n -- 2009-1211-JJM. 현금 환불액이 상품권 환불액으로 처리됨. 수정.               ".rtrim()
			+"\n --------------------------------------------------------------------------------               ".rtrim()
			+"\n --           , POS_READY_AMT + CASH_AMT + WEA_IN_CSH_AMT + TK_GFT_SALE_CSH_AMT + TK_FOD_SALE_CSH_AMT + POS_CSH_IN_AMT - POS_CSH_OUT_AMT - REPAY_TK_GFT_AMT AS TOT_CASH_AMT               ".rtrim()
		 */
	}


	this.GetRegiTotalData_false_SQL_01 = function ( paramObj ) {
		var s= ""
			+"\n SELECT                                                                                                             ".rtrim()
			+"\n        SUM( CASE WHEN TK_GFT_SALE_FG = 0 OR TK_GFT_SALE_FG = 2 THEN 1 ELSE 0 END * TK_GFT_UAMT ) AS TK_GFT_IN_AMT  ".rtrim()
			+"\n      , SUM( CASE WHEN TK_GFT_SALE_FG = 1 OR TK_GFT_SALE_FG = 3 THEN 1 ELSE 0 END * TK_GFT_UAMT ) AS TK_GFT_OUT_AMT ".rtrim()
			+"\n   FROM ( SELECT A.SHOP_CD                  ".rtrim()
			+"\n             , A.SALE_DATE                  ".rtrim()
			+"\n             , A.POS_NO                     ".rtrim()
			+"\n             , B.REGI_SEQ                   ".rtrim()
			+"\n             , A.TK_GFT_SALE_FG             ".rtrim()
			+"\n             , A.TK_GFT_UAMT                ".rtrim()
			+"\n        FROM SSL_TRGFA_T A                  ".rtrim()
			+"\n             LEFT JOIN SSL_TRGFT_T B        ".rtrim()
			+"\n             ON  B.SHOP_CD   = A.SHOP_CD    ".rtrim()
			+"\n             AND B.SALE_DATE = A.SALE_DATE  ".rtrim()
			+"\n             AND B.POS_NO    = A.POS_NO     ".rtrim()
			+"\n             AND B.BILL_NO   = A.BILL_NO  ) ".rtrim()
			+"\n WHERE SHOP_CD   = '%s'                     ".rtrim()
			+"\n AND   SALE_DATE = '%s'                     ".rtrim()
			+"\n AND   POS_NO    = '%s'                     ".rtrim()
			+"\n AND   REGI_SEQ  = '%02d'                   ".rtrim()
		;
		s = s.sprintf(paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO, paramObj.REGI_SEQ );
		return s;
	}

	this.GetRegiTotalData_false_SQL_02 = function ( paramObj ) {
		var s= ""
			+"\n SELECT                                 ".rtrim()
			+"\n        SALE_YN                         ".rtrim()
			+"\n      , SUM(APPR_REQ_AMT) AS CASHIC_AMT ".rtrim()
			+"\n   FROM SSL_TRCRD_T                     ".rtrim()
			+"\n  WHERE SHOP_CD   = '%s'                ".rtrim()
			+"\n    AND SALE_DATE = '%s'                ".rtrim()
			+"\n    AND POS_NO    = '%s'                ".rtrim()
			+"\n    AND UNION_PAY_FG = '4'              ".rtrim()
			+"\n    AND REGI_SEQ  = '%02d'              ".rtrim()
			+"\n  GROUP BY SALE_YN                      ".rtrim()
			;

		s = s.sprintf(paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO , paramObj.REGI_SEQ );
		return s;
	}

	this.GetRegiTotalData_false_SQL_03 = function ( paramObj ) {
		var s= ""
			+"SELECT                                   ".rtrim()
			+"       SUM(CASH_AMT)     AS RET_CASH_AMT ".rtrim()
			+"     , SUM(CRD_CARD_AMT) AS RET_CARD_AMT ".rtrim()
			+"  FROM SSL_TRHDR_T                       ".rtrim()
			+" WHERE SHOP_CD   = '%s'                  ".rtrim()
			+"   AND SALE_DATE = '%s'                  ".rtrim()
			+"   AND POS_NO    = '%s'                  ".rtrim()
			+"   AND REGI_SEQ  = '%02d'                ".rtrim()
			+"   AND SALE_YN   = 'N'                   ".rtrim()
			;

		s = s.sprintf(paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO ,paramObj.REGI_SEQ );
		return s;
	}

	this.GetRegiTotalData_false_SQL_04 = function ( paramObj ) {
		var s= ""
			+"\n SELECT                  ".rtrim()
			+"\n        *                ".rtrim()
			+"\n   FROM (                ".rtrim()
			+ this.SP_POS_REGIS_T_REGI_SEQ_SUM_SQL()
			+"\n  )                      ".rtrim()
			;

		s = s.sprintf(paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO , paramObj.REGI_SEQ );
		return s;
	}

	this.GetTravelWes_SQL = function (paramObj , m_csPrintCode) {
		var s = "";
		var csTemp  = "";	   /** CString **/

		if( m_csPrintCode == "08" ||  m_csPrintCode == "09" ) {
			s = ""
				+"\n SELECT WES_FG                                                                     ".rtrim()
				+"\n      , SUM( CASE WHEN  SALE_YN = 'N'  THEN  -1 ELSE 1 END  * WES_AMT ) AS WES_AMT " .rtrim()
				+"\n   FROM SSL_TRWES_T      ".rtrim()
				+"\n  WHERE SHOP_CD   = '%s' ".rtrim()
				+"\n    AND SALE_DATE = '%s' ".rtrim()
				+"\n    AND POS_NO    = '%s' ".rtrim()
				+"\n  GROUP BY WES_FG        ".rtrim()
			;
			 s = s.sprintf( paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO );

		} else {
			s = ""
				+"\n SELECT WES_FG                                                                  ".rtrim()
				+"\n      , SUM( CASE WHEN SALE_YN = 'N' THEN -1 ELSE 1 END  * WES_AMT ) AS WES_AMT ".rtrim()
				+"\n FROM SSL_TRWES_T                                                               ".rtrim()
				+"\n WHERE SHOP_CD   = '%s'                                                         ".rtrim()
				+"\n AND   SALE_DATE BETWEEN '%s' AND '%s'                                          ".rtrim()
				;
			s = s.sprintf( paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE  );

			if( parseInt ( paramObj.REGI_SEQ ) != 0 ) {
				csTemp  = ""
					+ "\n    AND   POS_NO    = '%s'   ".rtrim()
					+ "\n    AND   REGI_SEQ  = '%02d' ".rtrim()
				;
				csTemp = csTemp.sprintf( paramObj.POS_NO, /** atoi **/ parseInt ( paramObj.REGI_SEQ ) );

			} else if( paramObj.REGI_SEQ == "전체" ) {
				csTemp  = ""
					+"\n    AND   POS_NO     = '%s' ".rtrim()
					+"\n    AND   REGI_SEQ  <> '00' ".rtrim()
				;
				csTemp = csTemp.sprintf( paramObj.POS_NO );
			} else if( paramObj.REGI_SEQ == "마감" )	{
				csTemp = "\n   AND   REGI_SEQ  <> '00' ".rtrim()	;
			}

			s += csTemp;
			s += "\n  GROUP BY WES_FG ";
		}
		return s;
	}

	this.GetAgentFeeAmt_SQL = function (paramObj , m_csPrintCode)  {
		var s = "";
		if(  m_csPrintCode == "08"  || m_csPrintCode == "09" ) {
				s = ""
					+"\n SELECT SUM( CASE WHEN PAY_OUT_YN = 'N' THEN -1 ELSE 1 END  * PAY_OUT_AMT ) AS PAY_OUT_AMT ".rtrim()
					+"\n FROM POS_DRVPO_T                                                                          ".rtrim()
					+"\n WHERE SHOP_CD   = '%s'                                                                    ".rtrim()
					+"\n AND   SALE_DATE = '%s'                                                                    ".rtrim()
					+"\n AND   POS_NO    = '%s'                                                                    ".rtrim()
				;
				s = s.sprintf( paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO );
			} else {
				s =  ""
					+"\n SELECT SUM( CASE WHEN PAY_OUT_YN = 'N' THEN -1 ELSE 1 ELSE * PAY_OUT_AMT ) AS PAY_OUT_AMT ".rtrim()
					+"\n   FROM POS_DRVPO_T                                                                        ".rtrim()
					+"\n  WHERE SHOP_CD   = '%s'                                                                   ".rtrim()
					+"\n    AND SALE_DATE BETWEEN '%s' AND '%s'                                                    ".rtrim()
				;
				s = s.sprintf( paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE );
				s += this.GetWhereClauseByPosNoAndSeqNo(paramObj.POS_NO, paramObj.REGI_SEQ);		// 2019-05-23-SHK [정산현황];
			}
		return s;
	}
	this.GetDeliveryData_SQL = function (paramObj , m_SaleClose) {
		var iifCaseSaleYn = "  CASE WHEN SALE_YN = 'Y' THEN  1 ELSE  -1 END  ";
		var s = "";
		var ss = "";
			+"\n SELECT                                                                                                                                                 ".rtrim()
			+"\n      , SUM( CASE WHEN  DLV_ORDER_FG = '0'   THEN          "+ iifCaseSaleYn  +"      * NO_VAT_SALE_AMT  ELSE   0   END        ) AS SHOP_NO_VAT_SALE_AMT ".rtrim()
			+"\n      , SUM( CASE WHEN  DLV_ORDER_FG = '0'   THEN          "+ iifCaseSaleYn  +"      * VAT_SALE_AMT     ELSE   0   END        ) AS SHOP_VAT_SALE_AMT    ".rtrim()
			+"\n      , SUM( CASE WHEN  DLV_ORDER_FG = '0'   THEN          "+ iifCaseSaleYn  +"      * VAT_AMT          ELSE   0   END        ) AS SHOP_VAT_AMT         ".rtrim()
			+"\n      , SUM( CASE WHEN  DLV_ORDER_FG = '0'   THEN          "+ iifCaseSaleYn  +"      * SVC_TIP_AMT      ELSE   0   END        ) AS SHOP_SVC_TIP_AMT     ".rtrim()
			+"\n      , SUM( CASE WHEN  DLV_ORDER_FG = '0'   THEN          "+ iifCaseSaleYn  +"      * TOT_ETC_AMT      ELSE   0   END        ) AS SHOP_TOT_ETC_AMT     ".rtrim()
			+"\n      , SUM( CASE WHEN  DLV_ORDER_FG = '2'   THEN          "+ iifCaseSaleYn  +"      * NO_VAT_SALE_AMT  ELSE   0   END        ) AS DLV_NO_VAT_SALE_AMT  ".rtrim()
			+"\n      , SUM( CASE WHEN  DLV_ORDER_FG = '2'   THEN          "+ iifCaseSaleYn  +"      * VAT_SALE_AMT     ELSE   0   END        ) AS DLV_VAT_SALE_AMT     ".rtrim()
			+"\n      , SUM( CASE WHEN  DLV_ORDER_FG = '2'   THEN          "+ iifCaseSaleYn  +"      * VAT_AMT          ELSE   0   END        ) AS DLV_VAT_AMT          ".rtrim()
			+"\n      , SUM( CASE WHEN  DLV_ORDER_FG = '2'   THEN          "+ iifCaseSaleYn  +"      * SVC_TIP_AMT      ELSE   0   END        ) AS DLV_SVC_TIP_AMT      ".rtrim()
			+"\n      , SUM( CASE WHEN  DLV_ORDER_FG = '2'   THEN          "+ iifCaseSaleYn  +"      * TOT_ETC_AMT      ELSE   0   END        ) AS DLV_TOT_ETC_AMT      ".rtrim()

			+"\n      , SUM( CASE WHEN DLV_ORDER_FG = '0'   THEN  1 ELSE 0 END  ) AS SHOP_SALE_CNT        ".rtrim()
			+"\n      , SUM( CASE WHEN DLV_ORDER_FG = '2'   THEN  1 ELSE 0 END  ) AS DLV_SALE_CNT         ".rtrim()
			+"\n FROM SSL_TRHDR_T       ".rtrim()
			+"\n WHERE SHOP_CD   = '%s' ".rtrim()
			+"\n AND   SALE_DATE = '%s' ".rtrim()

		;
		s = s.sprintf( paramObj.SHOP_CD, paramObj.SALE_DATE );

		if( ! m_SaleClose ) {
			ss = ""
				+"\n    AND   POS_NO    = '%s'   ".rtrim()
				+"\n    AND   REGI_SEQ  = '%02d' ".rtrim()
				;
			ss = ss.sprintf( paramObj.POS_NO, paramObj.REGI_SEQ );
		}
		s += ss;
		return s;
	}

	this.GetRegiCardData_SQL = function (paramObj , m_SaleClose ) {
		var s = "";
		if( m_SaleClose )	{
			s = ""
				+"\nSELECT SUM( A.CNT1)  AS CNT1 "
	            +"\n     , SUM( A.CNT2)  AS CNT2 "
				+"\n     , SUM( A.AMT1)  AS AMT1 "
				+"\n     , SUM( A.AMT2)  AS AMT2 "
	            +"\n     , SUM( A.CNT1)  - SUM( A.CNT2 ) AS TOT_CNT "
				+"\n     , SUM( A.AMT1)  - SUM( A.AMT2 ) AS TOT_AMT "
	            +"\nFROM ( SELECT CASE SALE_YN WHEN 'Y' THEN 1        ELSE 0 END AS CNT1 "
	            +"\n            , CASE SALE_YN WHEN 'N' THEN 1        ELSE 0 END AS CNT2 "
	            +"\n            , CASE SALE_YN WHEN 'Y' THEN APPR_AMT ELSE 0 END AS AMT1 "
	            +"\n            , CASE SALE_YN WHEN 'N' THEN APPR_AMT ELSE 0 END AS AMT2 "
	            +"\n       FROM SSL_TRCRD_T "
	            +"\n       WHERE SHOP_CD    = '%s' "
				+"\n		AND   SALE_DATE = '%s' )  A "
				;
			s = s.sprintf( paramObj.SHOP_CD,  paramObj.SALE_DATE );
		}
		else {
			s = ""
				+"\nSELECT SUM( A.CNT1)                  AS CNT1                    ".rtrim()
				+"\n     , SUM( A.CNT2)                  AS CNT2                    ".rtrim()
				+"\n	 , SUM( A.AMT1)                  AS AMT1                    ".rtrim()
				+"\n	 , SUM( A.AMT2)                  AS AMT2                    ".rtrim()
		        +"\n     , SUM( A.CNT1)  - SUM( A.CNT2 ) AS TOT_CNT                 ".rtrim()
				+"\n	 , SUM( A.AMT1)  - SUM( A.AMT2 ) AS TOT_AMT                 ".rtrim()
				+"\n  FROM ( SELECT CASE SALE_YN WHEN 'Y' THEN 1        ELSE 0 END AS CNT1 ".rtrim()
				+"\n              , CASE SALE_YN WHEN 'N' THEN 1        ELSE 0 END AS CNT2 ".rtrim()
				+"\n              , CASE SALE_YN WHEN 'Y' THEN APPR_AMT ELSE 0 END AS AMT1 ".rtrim()
				+"\n              , CASE SALE_YN WHEN 'N' THEN APPR_AMT ELSE 0 END AS AMT2 ".rtrim()
				+"\n           FROM SSL_TRCRD_T            ".rtrim()
				+"\n          WHERE SHOP_CD   = '%s'       ".rtrim()
				+"\n		    AND SALE_DATE = '%s'       ".rtrim()
				+"\n            AND POS_NO    = '%s'       ".rtrim()
				+"\n            AND REGI_SEQ  = '%02d' ) A ".rtrim()
			;

			s = s.sprintf(	paramObj.SHOP_CD,  paramObj.SALE_DATE, paramObj.POS_NO, paramObj.REGI_SEQ);
		}
		return s;
	}
	this.GetRegiCardTypeData_SQL = function (m_SaleClose , paramObj ) {
		var csQrySql = "";
		if( this.m_SaleClose ) {
			csQrySql = ""
				+"\n SELECT PUR_CRDCP_CD                                                                    ".rtrim()
				+"\n      , PUR_CRDCP_NM                                                                    ".rtrim()
				+"\n 	  , COUNT( PUR_CRDCP_CD ) AS CNT                                                    ".rtrim()
				+"\n 	  , SUM( APPR_AMT * CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END ) AS APPR_AMT        ".rtrim()
				+"\n FROM SSL_TRCRD_T                                                                       ".rtrim()
				+"\n WHERE SHOP_CD   = '%s'                                                                 ".rtrim()
				+"\n AND   SALE_DATE = '%s'                                                                 ".rtrim()
				+"\n GROUP BY PUR_CRDCP_CD                                                                  ".rtrim()
				+"\n        , PUR_CRDCP_NM                                                                  ".rtrim()
			;
			csQrySql = csQrySql.sprintf( paramObj.SHOP_CD, paramObj.SALE_DATE );

		} else {
			csQrySql = ""
				+"\n SELECT PUR_CRDCP_CD                                                                    ".rtrim()
				+"\n      , PUR_CRDCP_NM                                                                    ".rtrim()
				+"\n 	  , COUNT( PUR_CRDCP_CD ) AS CNT                                                    ".rtrim()
				+"\n 	  , SUM( APPR_AMT * CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END ) AS APPR_AMT        ".rtrim()
				+"\n FROM SSL_TRCRD_T  A                                                                    ".rtrim()
				+"\n WHERE SHOP_CD   = '%s'                                                                 ".rtrim()
				+"\n AND   SALE_DATE = '%s'                                                                 ".rtrim()
				+"\n AND   POS_NO    = '%s'                                                                 ".rtrim()
				// 현재 키오스크에서는 중간마감이 없고, 차수별 출력이 없기 때문에, 카드사별매출내역을 가져올 때 regi_seq를 조건으로 설정할 필요가 없다.
//				+"\n AND   REGI_SEQ  = '%02d'                                                               ".rtrim()
				+"\n GROUP BY PUR_CRDCP_CD                                                                    ".rtrim()
				+"\n        , PUR_CRDCP_NM                                                                    ".rtrim()
			;
//			csQrySql = csQrySql.sprintf( paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO, paramObj.REGI_SEQ );
			csQrySql = csQrySql.sprintf( paramObj.SHOP_CD, paramObj.SALE_DATE, paramObj.POS_NO );
		}
		return csQrySql;
	}
	this.SP_SSL_TRCST_T_SQL = function(paramObj) {
		var s = ""
			+"\n     SELECT COUNT( BILL_NO )                                                                                                                            AS BILL_CNT   ".rtrim()
			+"\n          , SUM( FD_GST_CNT_T )                                                                                                                         AS GUEST_CNT  ".rtrim()
			+"\n          , SUM( CASE WHEN ( SALE_YN = 'Y' ) AND ( CST_SALE_POINT > 0 ) THEN 1 WHEN ( SALE_YN = 'N' ) AND ( CST_SALE_POINT > 0 ) THEN -1 ELSE 0 END )   AS SALE_CNT   ".rtrim()
			+"\n          , SUM( CASE SALE_YN WHEN 'Y' THEN CST_SALE_POINT WHEN 'N' THEN CST_SALE_POINT * -1 ELSE 0 END )                                               AS SALE_POINT ".rtrim()
			+"\n          , SUM( CASE WHEN ( SALE_YN = 'Y' ) AND ( CST_POINT_AMT > 0 ) THEN 1 WHEN ( SALE_YN = 'N' ) AND ( CST_POINT_AMT > 0 ) THEN -1 ELSE 0 END )     AS USE_CNT    ".rtrim()
			+"\n          , SUM( CASE SALE_YN WHEN 'Y' THEN CST_POINT_AMT WHEN 'N' THEN CST_POINT_AMT * -1 ELSE 0 END ) AS USE_POINT                                                  ".rtrim()
			+"\n     FROM SSL_TRHDR_T                                                                                                                                                 ".rtrim()
			+"\n     WHERE SHOP_CD   = '%s'                                                                                                                                           ".rtrim()
			+"\n     AND   SALE_DATE = '%s'                                                                                                                                           ".rtrim()
			;
		s = s.sprintf(paramObj.SHOP_CD , paramObj.SALE_DATE );
		return s ;
	}
	this.SP_SSL_TRCST_T_REGI_SEQ_SQL = function(paramObj) {
		var s = ""
			+"\n      SELECT COUNT( BILL_NO )                                                                                                                          AS BILL_CNT      ".rtrim()
			+"\n           , SUM( FD_GST_CNT_T )                                                                                                                       AS GUEST_CNT     ".rtrim()
			+"\n           , SUM( CASE WHEN ( SALE_YN = 'Y' ) AND ( CST_SALE_POINT > 0 ) THEN 1 WHEN ( SALE_YN = 'N' ) AND ( CST_SALE_POINT > 0 ) THEN -1 ELSE 0 END ) AS SALE_CNT      ".rtrim()
			+"\n           , SUM( CASE SALE_YN WHEN 'Y' THEN CST_SALE_POINT WHEN 'N' THEN CST_SALE_POINT * -1 ELSE 0 END )                                             AS SALE_POINT    ".rtrim()
			+"\n           , SUM( CASE WHEN ( SALE_YN = 'Y' ) AND ( CST_POINT_AMT > 0 ) THEN 1 WHEN ( SALE_YN = 'N' ) AND ( CST_POINT_AMT > 0 ) THEN -1 ELSE 0 END )   AS USE_CNT       ".rtrim()
			+"\n           , SUM( CASE SALE_YN WHEN 'Y' THEN CST_POINT_AMT WHEN 'N' THEN CST_POINT_AMT * -1 ELSE 0 END )                                               AS USE_POINT     ".rtrim()
			+"\n      FROM SSL_TRHDR_T                        ".rtrim()
			+"\n      WHERE SHOP_CD   = '%s'                  ".rtrim()
			+"\n      AND   SALE_DATE = '%s'                  ".rtrim()
			+"\n      AND   POS_NO    = '%s'                  ".rtrim()
			+"\n      AND   REGI_SEQ  = '%02d'                ".rtrim()

			;
		s = s.sprintf( paramObj.SHOP_CD , paramObj.SALE_DATE , paramObj.POS_NO , paramObj.REGI_SEQ  );
		return s;
	}
	this.GetNoneSaleAccount_01_SQL = function() {
		var s = ""
			+"\n SELECT IFNULL(SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END * CASH_AMT     ), 0) AS CASH_AMT   ".rtrim()
			+"\n      , IFNULL(SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END * CRD_CARD_AMT ), 0) AS CARD_AMT   ".rtrim()
			+"\n FROM POS_TKSHD_T                                                                ".rtrim()
			+"\n WHERE SHOP_CD   = '%s'                                                          ".rtrim()
			+"\n AND   SALE_DATE BETWEEN '%s' AND '%s'                                           ".rtrim()
			+"\n %s                                                                              ".rtrim()
		;
		return s;
	}
	this.GetNoneSaleAccount_02_SQL = function() {
		var s = ""
			+"\n SELECT IFNULL(SUM( CASE WHEN TK_GFT_SALE_FG = 0 OR TK_GFT_SALE_FG = 2 THEN 1 ELSE 0 END * TK_GFT_UAMT ), 0) AS TK_GFT_IN_AMT   ".rtrim()
			+"\n      , IFNULL(SUM( CASE WHEN TK_GFT_SALE_FG = 1 OR TK_GFT_SALE_FG = 3 THEN 1 ELSE 0 END * TK_GFT_UAMT ), 0) AS TK_GFT_OUT_AMT  ".rtrim()
			+"\n FROM ( SELECT A.SHOP_CD                                                                                              ".rtrim()
			+"\n             , A.SALE_DATE                                                                                            ".rtrim()
			+"\n             , A.POS_NO                                                                                               ".rtrim()
			+"\n             , B.REGI_SEQ                                                                                             ".rtrim()
			+"\n             , A.TK_GFT_SALE_FG                                                                                       ".rtrim()
			+"\n             , A.TK_GFT_UAMT                                                                                          ".rtrim()
			+"\n        FROM SSL_TRGFA_T A                                                                                            ".rtrim()
			+"\n             LEFT JOIN SSL_TRGFT_T B                                                                                  ".rtrim()
			+"\n             ON  B.SHOP_CD   = A.SHOP_CD                                                                              ".rtrim()
			+"\n             AND B.SALE_DATE = A.SALE_DATE                                                                            ".rtrim()
			+"\n             AND B.POS_NO    = A.POS_NO                                                                               ".rtrim()
			+"\n             AND B.BILL_NO   = A.BILL_NO )                                                                            ".rtrim()
			+"\n WHERE SHOP_CD = '%s'                                                                                                 ".rtrim()
			+"\n AND   SALE_DATE BETWEEN '%s' AND '%s'                                                                                ".rtrim()
			+"\n %s                                                                                                                   ".rtrim()
			;
		return s;
	}
	this.GetNoneSaleAccount_03_SQL = function() {
		var s = ""
			+"\n SELECT IFNULL(SUM( CASE WHEN WES_IN_YN = 'Y' THEN 1 ELSE -1 END * CASE WHEN PAY_TYPE_FG = '01' THEN WES_IN_AMT ELSE 0  END ), 0) AS CASH_AMT  ".rtrim()
			+"\n      , IFNULL(SUM( CASE WHEN WES_IN_YN = 'Y' THEN 1 ELSE -1 END * CASE WHEN PAY_TYPE_FG = '02' THEN WES_IN_AMT ELSE 0  END ), 0) AS CARD_AMT  ".rtrim()
			+"\n FROM POS_INWES_T                                                                                       ".rtrim()
			+"\n WHERE SHOP_CD   = '%s'                                                                                 ".rtrim()
			+"\n AND   SALE_DATE BETWEEN '%s' AND '%s'                                                                  ".rtrim()
			+"\n %s                                                                                                     ".rtrim()
		;
		return s;
	}
	this.GetSaleGiftList_SQL = function() {
		var s = ""
				+"\n SELECT B.TK_GFT_NM                        AS TK_GFT_NM       ".rtrim()
				+"\n      , A.TK_GFT_SEQ                       AS TK_GFT_SEQ      ".rtrim()
				+"\n      , CASE A.TK_GFT_SALE_FG                                 ".rtrim()
				+"\n             WHEN '0' THEN '매출-결제'                            ".rtrim()
				+"\n             WHEN '1' THEN '매출-환불'                            ".rtrim()
				+"\n             WHEN '2' THEN '반품-환입'                            ".rtrim()
				+"\n             WHEN '3' THEN '반품-환불' END AS TK_GFT_SALE_FG      ".rtrim()
				+"\n      , A.TK_GFT_UPRC                      AS TK_GFT_UPRC     ".rtrim()
				+"\n      , A.TK_GFT_QTY                       AS TK_GFT_QTY      ".rtrim()
				+"\n      , A.TK_GFT_UAMT                      AS TK_GFT_UAMT     ".rtrim()
				+"\n FROM ( SELECT A.SHOP_CD        AS SHOP_CD                    ".rtrim()
				+"\n             , A.SALE_DATE      AS SALE_DATE                  ".rtrim()
				+"\n             , A.POS_NO         AS POS_NO                     ".rtrim()
				+"\n             , A.BILL_NO        AS SALE_NO                    ".rtrim()
				+"\n             , B.REGI_SEQ       AS REGI_SEQ                   ".rtrim()
				+"\n             , A.TK_GFT_CD      AS TK_GFT_CD                  ".rtrim()
				+"\n             , A.TK_GFT_SEQ     AS TK_GFT_SEQ                 ".rtrim()
				+"\n             , A.TK_GFT_SALE_FG AS TK_GFT_SALE_FG             ".rtrim()
				+"\n             , A.TK_GFT_UPRC    AS TK_GFT_UPRC                ".rtrim()
				+"\n             , A.TK_GFT_QTY     AS TK_GFT_QTY                 ".rtrim()
				+"\n             , A.TK_GFT_UAMT    AS TK_GFT_UAMT                ".rtrim()
				+"\n             , B.SALE_YN        AS SALE_YN                    ".rtrim()
				+"\n        FROM SSL_TRGFA_T A                                    ".rtrim()
				+"\n             LEFT JOIN SSL_TRHDR_T B                          ".rtrim()
				+"\n             ON  B.SHOP_CD   = A.SHOP_CD                      ".rtrim()
				+"\n             AND B.SALE_DATE = A.SALE_DATE                    ".rtrim()
				+"\n             AND B.POS_NO    = A.POS_NO                       ".rtrim()
				+"\n             AND B.BILL_NO   = A.BILL_NO	                     ".rtrim()
				+"\n        WHERE TK_GFT_SALE_FG <> '9' ) A                       ".rtrim()
				+"\n      LEFT JOIN SCD_TKGFT_T B                                 ".rtrim()
				+"\n      ON  B.SHOP_CD   = A.SHOP_CD                             ".rtrim()
				+"\n      AND B.TK_CLS_FG = '1'                                   ".rtrim()
				+"\n      AND B.TK_GFT_CD = A.TK_GFT_CD                           ".rtrim()
				+"\n WHERE A.SHOP_CD   = '%s'                                     ".rtrim()
				+"\n AND   A.SALE_DATE BETWEEN '%s' AND '%s'                      ".rtrim()
				+"\n %s                                                           ".rtrim()
			;
		return s;
	}
	this.GetNoneSaleGiftList_SQL= function() {
		var s = ""
			+"\n SELECT B.TK_GFT_NM                          AS TK_GFT_NM             ".rtrim()
			+"\n      , A.TK_GFT_SEQ                         AS TK_GFT_SEQ            ".rtrim()
			+"\n      , CASE A.TK_GFT_SALE_FG                                         ".rtrim()
			+"\n             WHEN '0' THEN '비매출-판매'                              ".rtrim()
			+"\n             WHEN '1' THEN '비매출-반품' END AS TK_GFT_SALE_FG        ".rtrim()
			+"\n      , A.TK_GFT_UPRC                        AS TK_GFT_UPRC           ".rtrim()
			+"\n      , A.TK_GFT_QTY                         AS TK_GFT_QTY            ".rtrim()
			+"\n      , A.TK_GFT_UAMT                        AS TK_GFT_UAMT           ".rtrim()
			+"\n FROM ( SELECT A.SHOP_CD                        AS SHOP_CD            ".rtrim()
			+"\n             , A.SALE_DATE                      AS SALE_DATE          ".rtrim()
			+"\n             , A.POS_NO                         AS POS_NO             ".rtrim()
			+"\n             , A.SALE_NO                        AS SALE_NO            ".rtrim()
			+"\n             , A.REGI_SEQ                       AS REGI_SEQ           ".rtrim()
			+"\n             , A.TK_GFT_CD                      AS TK_GFT_CD          ".rtrim()
			+"\n             , A.TK_GFT_SEQ                     AS TK_GFT_SEQ         ".rtrim()
			+"\n             , CASE WHEN  B.SALE_YN = 'Y' THEN '0' ELSE '1' END AS TK_GFT_SALE_FG     ".rtrim()
			+"\n             , A.TK_GFT_UPRC                    AS TK_GFT_UPRC        ".rtrim()
			+"\n             , A.SALE_QTY                       AS TK_GFT_QTY         ".rtrim()
			+"\n             , A.DCM_SALE_AMT                   AS TK_GFT_UAMT        ".rtrim()
			+"\n             , B.SALE_YN                        AS SALE_YN            ".rtrim()
			+"\n        FROM POS_TKSDT_T A                                            ".rtrim()
			+"\n             LEFT JOIN POS_TKSHD_T B                                  ".rtrim()
			+"\n             ON  B.SHOP_CD   = A.SHOP_CD                              ".rtrim()
			+"\n             AND B.SALE_DATE = A.SALE_DATE                            ".rtrim()
			+"\n             AND B.POS_NO    = A.POS_NO                               ".rtrim()
			+"\n             AND B.SALE_NO   = A.SALE_NO ) A                          ".rtrim()
			+"\n      LEFT JOIN SCD_TKGFT_T B                                         ".rtrim()
			+"\n      ON  B.SHOP_CD   = A.SHOP_CD                                     ".rtrim()
			+"\n      AND B.TK_CLS_FG = '1'                                           ".rtrim()
			+"\n      AND B.TK_GFT_CD = A.TK_GFT_CD                                   ".rtrim()
			+"\n WHERE A.SHOP_CD   = '%s'                                             ".rtrim()
			+"\n AND   A.SALE_DATE BETWEEN '%s' AND '%s'                              ".rtrim()
			+"\n %s                                                                   ".rtrim()
		;
		return s;

	}
	this.GetSaleDataQuery_SQL = function(pcsCode , shop_env, paramObj ) {
		var s = 0;
		var	csQuery           = "" ; /** CString **/
		var	csTemp            = "" ; /** CString **/
		var csEnvShop114      = shop_env[ "114" ]; /** CString **/
		var csProdQuery       = "" ; /** CString **/
		var csClassQuery      = "" ; /** CString **/
		var csCornerQuery     = "" ; /** CString **/
		var csCornerJoinQuery = "" ; /** CString **/
		var csCornerSubQuery  = "" ; /** CString **/
		switch( parseInt( pcsCode ) ) {
		////////////////////////////////////////////////////////////////////////
		// 매출현황-분류별-소
		////////////////////////////////////////////////////////////////////////
		case 31	:
			csQuery = ""
				+"\n SELECT A.MCLS_CD         							                    AS MCLS_CD      ".rtrim()
				+"\n      , B.MCLS_NM         							                    AS MCLS_NM      ".rtrim()
				+"\n      , A.SCLS_CD         							                    AS SCLS_CD      ".rtrim()
				+"\n      , A.SCLS_NM                                                       AS SCLS_NM      ".rtrim()
				+"\n      , SUM( CASE WHEN  A.SALE_YN = 'Y' THEN 1 ELSE -1 END * SALE_QTY ) AS SALE_QTY     ".rtrim()
				+"\n      , SUM( CASE WHEN  A.SALE_YN = 'Y' THEN 1 ELSE -1 END * SALE_DCM ) AS SALE_DCM     ".rtrim()
				+"\n      , SUM( CASE WHEN  A.SALE_YN = 'Y' THEN 1 ELSE -1 END * SALE_VAT ) AS SALE_VAT     ".rtrim()
				+"\n      , SUM( CASE WHEN  A.SALE_YN = 'Y' THEN 1 ELSE -1 END * SVC_AMT  ) AS SVC_AMT      ".rtrim()
				+"\n FROM ( SELECT CLSSM.MCLS_CD      AS MCLS_CD                            ".rtrim()
				+"\n             , CLSSM.SCLS_CD      AS SCLS_CD                            ".rtrim()
				+"\n             , CLSSM.SCLS_NM      AS SCLS_NM                            ".rtrim()
				+"\n             , TRDTL.PROD_CD      AS PROD_CD                            ".rtrim()
				+"\n             , TRDTL.SALE_DATE    AS SALE_DATE                          ".rtrim()
				+"\n             , TRDTL.SALE_YN      AS SALE_YN                            ".rtrim()
				+"\n             , TRDTL.SALE_QTY     AS SALE_QTY                           ".rtrim()
				+"\n             , TRDTL.DC_AMT       AS SALE_DC                            ".rtrim()
				+"\n             , TRDTL.DCM_SALE_AMT AS SALE_DCM                           ".rtrim()
				+"\n             , TRDTL.VAT_AMT      AS SALE_VAT                           ".rtrim()
				+"\n             , TRDTL.DC_AMT_SVC   AS SVC_AMT                            ".rtrim()
				+"\n        FROM SSL_TRDTL_T TRDTL                                          ".rtrim()
				+"\n             LEFT JOIN SCD_PRODM_T PRODM                                ".rtrim()
				+"\n             ON  PRODM.SHOP_CD = TRDTL.SHOP_CD                          ".rtrim()
				+"\n             AND PRODM.PROD_CD = TRDTL.PROD_CD                          ".rtrim()
				+"\n             LEFT JOIN SCD_CLSSM_T CLSSM                                ".rtrim()
				+"\n             ON  CLSSM.LCLS_CD = PRODM.LCLS_CD                          ".rtrim()
				+"\n             AND CLSSM.MCLS_CD = PRODM.MCLS_CD                          ".rtrim()
				+"\n             AND CLSSM.SCLS_CD = PRODM.SCLS_CD                          ".rtrim()
				+"\n             AND CLSSM.SHOP_CD = TRDTL.SHOP_CD                          ".rtrim()
				+"\n        WHERE TRDTL.SHOP_CD   = '%s'                                    ".rtrim()
				+"\n        AND   TRDTL.SALE_DATE BETWEEN '%s' AND '%s'                     ".rtrim()
				+"\n        AND   TRDTL.POS_NO    LIKE '%%%s' ) A                           ".rtrim()
				+"\n    , SCD_CLSMM_T B                                                     ".rtrim()
				+"\n WHERE  B.MCLS_CD = A.MCLS_CD                                           ".rtrim()
				+"\n GROUP BY A.MCLS_CD                                                     ".rtrim()
				+"\n        , B.MCLS_NM                                                     ".rtrim()
				+"\n        , A.SCLS_NM                                                     ".rtrim()
				+"\n        , A.SCLS_CD                                                     ".rtrim()
			;
			csQuery = csQuery.sprintf( paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE, paramObj.POS_NO );
			break;

		case 32 :
			if( csEnvShop114 != "0" ) {
				csCornerQuery = ""
					+"\n UNION ALL                                                                                           ".rtrim()
					+"\nSELECT 'XXX'                                                                                         ".rtrim()
					+"\n      , 'XXX'                                                                                        ".rtrim()
					+"\n      , 'XXX'                                                                                        ".rtrim()
					+"\n      , '코너'                                                                       AS PROD_CD      ".rtrim()
					+"\n      , SHOPS.CORNER_NM                                                              AS PROD_NM      ".rtrim()
					+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.SALE_QTY     ) AS SALE_QTY     ".rtrim()
					+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.DCM_SALE_AMT ) AS SALE_DCM     ".rtrim()
					+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.VAT_AMT      ) AS SALE_VAT     ".rtrim()
					+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.DC_AMT       ) AS SALE_DC      ".rtrim()
					+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.DC_AMT_SVC   ) AS SVC_AMT      ".rtrim()
					+"\n      , '0' AS SALE_WEIGHT                                                                           ".rtrim()
					+"\n      , '0' AS PRICE_MGR_FG                                                                          ".rtrim()
					+"\n      , SHOPS.CORNER_CD                                                                              ".rtrim()
					+"\n FROM SSL_TRDTL_T TRDTL                                                                              ".rtrim()
					+"\n      LEFT JOIN SCD_SHOPS_T SHOPS                                                                    ".rtrim()
					+"\n      ON  SHOPS.SHOP_CD   = TRDTL.SHOP_CD                                                            ".rtrim()
					+"\n      AND SHOPS.CORNER_CD = TRDTL.CORNER_CD                                                          ".rtrim()
					+"\n WHERE TRDTL.SHOP_CD   = '%s'                                                                        ".rtrim()
					+"\n AND   TRDTL.SALE_DATE BETWEEN '%s' AND '%s'                                                         ".rtrim()
					+"\n AND   TRDTL.POS_NO    LIKE '%%%s'                                                                   ".rtrim()
					+"\n GROUP BY SHOPS.CORNER_NM                                                                            ".rtrim()
					+"       , SHOPS.CORNER_CD "
					;
				csCornerQuery = csCornerQuery.sprintf( paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE, paramObj.POS_NO );

				csCornerJoinQuery = "\n LEFT JOIN SCD_SHOPS_T SHOPS "
                                    "\n   ON SHOPS.SHOP_CD   = TRDTL.SHOP_CD "
                                    "\n  AND SHOPS.CORNER_CD = TRDTL.CORNER_CD "	;
				csCornerSubQuery  = "\n      , SHOPS.CORNER_CD "	;
			}




			csProdQuery = ""
				+"\n SELECT CLSLM.LCLS_CD                                                                AS LCLS_CD   ".rtrim()
				+"\n      , CLSMM.MCLS_CD                                                                AS MCLS_CD   ".rtrim()
				+"\n      , CLSSM.SCLS_CD                                                                AS SCLS_CD   ".rtrim()
				+"\n      , TRDTL.PROD_CD                                                                AS PROD_CD   ".rtrim()
				+"\n      , PRODM.PROD_NM                                                                AS PROD_NM   ".rtrim()
				+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.SALE_QTY     ) AS SALE_QTY  ".rtrim()
				+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.DCM_SALE_AMT ) AS SALE_DCM  ".rtrim()
				+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.VAT_AMT      ) AS SALE_VAT  ".rtrim()
				+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.DC_AMT       ) AS SALE_DC   ".rtrim()
				+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.DC_AMT_SVC   ) AS SVC_AMT   ".rtrim()
				+"\n      , TRDTL.SALE_WEIGHT AS SALE_WEIGHT                                              ".rtrim()
				+"\n      , PRODM.PRICE_MGR_FG                                                            ".rtrim()
				+"\n      %s                                                                              ".rtrim()
				+"\n FROM SSL_TRDTL_T TRDTL                                                               ".rtrim()
				+"\n      LEFT JOIN SCD_PRODM_T PRODM                                                     ".rtrim()
				+"\n      ON  PRODM.SHOP_CD = TRDTL.SHOP_CD                                               ".rtrim()
				+"\n      AND PRODM.PROD_CD = TRDTL.PROD_CD                                               ".rtrim()
				+"\n      LEFT JOIN SCD_CLSLM_T CLSLM                                                     ".rtrim()
				+"\n      ON  CLSLM.SHOP_CD = PRODM.SHOP_CD                                               ".rtrim()
				+"\n      AND CLSLM.LCLS_CD = PRODM.LCLS_CD                                               ".rtrim()
				+"\n      LEFT OUTER JOIN SCD_CLSMM_T CLSMM                                               ".rtrim()
				+"\n      ON  CLSMM.SHOP_CD = PRODM.SHOP_CD                                               ".rtrim()
				+"\n      AND CLSMM.MCLS_CD = PRODM.MCLS_CD                                               ".rtrim()
				+"\n      LEFT OUTER JOIN SCD_CLSSM_T CLSSM                                               ".rtrim()
				+"\n      ON  CLSSM.SHOP_CD = PRODM.SHOP_CD                                               ".rtrim()
				+"\n      AND CLSSM.SCLS_CD = PRODM.SCLS_CD                                               ".rtrim()
				+"\n      %s                                                                              ".rtrim()
				+"\n WHERE TRDTL.SHOP_CD   = '%s'                                                         ".rtrim()
				+"\n AND   TRDTL.SALE_DATE BETWEEN '%s' AND '%s'                                          ".rtrim()
				+"\n AND   TRDTL.POS_NO    LIKE '%%%s'                                                    ".rtrim()
				+"\n GROUP BY CLSLM.LCLS_CD                                                               ".rtrim()
				+"\n        , CLSMM.MCLS_CD                                                               ".rtrim()
				+"\n        , CLSSM.SCLS_CD                                                               ".rtrim()
				+"\n        , TRDTL.PROD_CD                                                               ".rtrim()
				+"\n        , PRODM.PROD_NM                                                               ".rtrim()
				+"\n        , PRODM.PRICE_MGR_FG                                                          ".rtrim()
				+"\n        , TRDTL.SALE_WEIGHT                                                           ".rtrim()
				+"\n        %s                                                                            ".rtrim()
			;
			csProdQuery = csProdQuery.sprintf( csCornerSubQuery , csCornerJoinQuery , paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE, paramObj.POS_NO , csCornerSubQuery );
util.logDebug("*** csProdQuery1 ===> \n" + csProdQuery);




			csClassQuery = ""
				+"\n UNION ALL "
				+"\n SELECT CLSLM.LCLS_CD                                                               AS LCLS_CD      ".rtrim()
				+"\n      , CLSMM.MCLS_CD                                                               AS MCLS_CD      ".rtrim()
				+"\n      , CLSSM.SCLS_CD                                                               AS SCLS_CD      ".rtrim()
				+"\n      , '분류'                                                                      AS PROD_CD      ".rtrim()
				+"\n      , CASE SHOPM.CLS_MGR_LEVEL_FG WHEN '1' THEN CLSLM.LCLS_NM                                     ".rtrim()
				+"\n                                    WHEN '2' THEN CLSMM.MCLS_NM                                     ".rtrim()
				+"\n                                    WHEN '3' THEN CLSSM.SCLS_NM                                     ".rtrim()
				+"\n        END                                                                          AS PROD_NM     ".rtrim()
				+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.SALE_QTY     ) AS SALE_QTY    ".rtrim()
				+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.DCM_SALE_AMT ) AS SALE_DCM    ".rtrim()
				+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.VAT_AMT      ) AS SALE_VAT    ".rtrim()
				+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.DC_AMT       ) AS SALE_DC     ".rtrim()
				+"\n      , SUM( CASE WHEN TRDTL.SALE_YN = 'Y' THEN 1 ELSE -1 END * TRDTL.DC_AMT_SVC   ) AS SVC_AMT     ".rtrim()  // 2011-1130-LSH : 서비스할인 분리.
				+"\n      , '0' AS SALE_WEIGHT                                                            ".rtrim()
				+"\n      , '0' AS PRICE_MGR_FG                                                           ".rtrim()
				+"\n      %s                                                                              ".rtrim()
				+"\n FROM SSL_TRDTL_T TRDTL                                                               ".rtrim()
				+"\n      LEFT JOIN SCD_PRODM_T PRODM                                                     ".rtrim()
				+"\n      ON  PRODM.SHOP_CD = TRDTL.SHOP_CD                                               ".rtrim()
				+"\n      AND PRODM.PROD_CD = TRDTL.PROD_CD                                               ".rtrim()
				+"\n      LEFT JOIN SCD_CLSLM_T CLSLM                                                     ".rtrim()
				+"\n      ON  CLSLM.SHOP_CD = PRODM.SHOP_CD                                               ".rtrim()
				+"\n      AND CLSLM.LCLS_CD = PRODM.LCLS_CD                                               ".rtrim()
				+"\n      LEFT OUTER JOIN SCD_CLSMM_T CLSMM	                                              ".rtrim()
				+"\n      ON  CLSMM.SHOP_CD = PRODM.SHOP_CD                                               ".rtrim()
				+"\n      AND CLSMM.MCLS_CD = PRODM.MCLS_CD                                               ".rtrim()
				+"\n      LEFT OUTER JOIN SCD_CLSSM_T CLSSM                                               ".rtrim()
				+"\n      ON  CLSSM.SHOP_CD = PRODM.SHOP_CD                                               ".rtrim()
				+"\n      AND CLSSM.SCLS_CD = PRODM.SCLS_CD                                               ".rtrim()
				+"\n      LEFT JOIN SCD_SHOPM_T SHOPM                                                     ".rtrim()
				+"\n      ON SHOPM.SHOP_CD = TRDTL.SHOP_CD                                                ".rtrim()
				+"\n      %s                                                                              ".rtrim()
				+"\n WHERE TRDTL.SHOP_CD   = '%s'                                                         ".rtrim()
				+"\n AND   TRDTL.SALE_DATE BETWEEN '%s' AND '%s'                                          ".rtrim()
				+"\n AND   TRDTL.POS_NO    LIKE '%%%s'                                                    ".rtrim()
				+"\n GROUP BY CLSLM.LCLS_CD                                                               ".rtrim()
				+"\n        , CLSLM.LCLS_NM                                                               ".rtrim()
				+"\n        , CLSMM.MCLS_CD                                                               ".rtrim()
				+"\n        , CLSMM.MCLS_NM                                                               ".rtrim()
				+"\n        , CLSSM.SCLS_CD                                                               ".rtrim()
				+"\n        , CLSSM.SCLS_NM                                                               ".rtrim()
				+"\n        , SHOPM.CLS_MGR_LEVEL_FG                                                      ".rtrim()
				+"\n        , PRODM.PRICE_MGR_FG                                                          ".rtrim()
				+"\n        , TRDTL.SALE_WEIGHT                                                           ".rtrim()
				+"       %s "
				;
			csClassQuery = csClassQuery.sprintf( csCornerSubQuery  , csCornerJoinQuery , paramObj.SHOP_CD, paramObj.FROM_DATE, paramObj.TO_DATE, paramObj.POS_NO , csCornerSubQuery );


			csQuery = ""
				+"\n SELECT PROD_CD          ".rtrim()
				+"\n      , PROD_NM          ".rtrim()
				+"\n      , SALE_QTY         ".rtrim()
				+"\n      , SALE_DCM         ".rtrim()
				+"\n      , SALE_VAT         ".rtrim()
				+"\n      , SALE_DC          ".rtrim()
				+"\n      , SVC_AMT          ".rtrim()
				+"\n      , SALE_WEIGHT      ".rtrim()
				+"\n      , PRICE_MGR_FG     ".rtrim()
				+"\n FROM ( %s               ".rtrim()
				+"\n        %s               ".rtrim()
				+"\n        %s )             ".rtrim()
			;
			csQuery = csQuery.sprintf( csProdQuery , csClassQuery , csCornerQuery );
			util.logDebug("*** csQuery1 ===> \n" + csQuery);
			if( csEnvShop114 != "0" ) {
				csQuery += "ORDER BY CORNER_CD "
				csQuery += "       , LCLS_CD "
				csQuery += "       , MCLS_CD "
				csQuery += "       , SCLS_CD "
				csQuery += "       , PROD_CD "
			}
			else {
				csQuery += "ORDER BY LCLS_CD "
				csQuery += "       , MCLS_CD "
				csQuery += "       , SCLS_CD "
				csQuery += "       , PROD_CD "
			}
			break;
			util.logDebug("*** csQuery2 ===> \n" + csQuery);


		case 33 :
			break;
		case 35 :
			csQuery = ""
				+"\n SELECT SALE_DATE                                                                                     AS SALE_DAT  ".rtrim()
				+"\n      , CAST( SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END * DCM_SALE_AMT  ) AS NUMERIC( 11, 0 ) ) AS SUM_AMT   ".rtrim()
				+"\n      , CAST( SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END * VAT_AMT       ) AS NUMERIC( 11, 0 ) ) AS VAT_AMT   ".rtrim()
				+"\n FROM SSL_TRHDR_T                                                                                      ".rtrim()
				+"\n WHERE SHOP_CD   = '%s'                                                                                ".rtrim()
				+"\n AND   SALE_DATE LIKE '%s%%'                                                                           ".rtrim()
				+"\n AND   POS_NO    LIKE '%%%s'                                                                           ".rtrim()
				+"\n GROUP BY SALE_DATE                                                                                    ".rtrim()
			;
			csQuery = csQuery.sprintf( paramObj.SHOP_CD, paramObj.FROM_DATE.substr( 0, 6 ), paramObj.POS_NO );
			break;


		}
		return csQuery;
	}
	this.GetSalesDcData_SQL = function(pcsCode , paramObj){
		var s = "";

		s = ""
			+"\n SELECT B.PROD_NM                                                       ".rtrim()
			+"\n      , SUM( CASE WHEN A.SALE_YN = 'N' THEN -1 ELSE 1 END * %s         ) AS DC_AMT     ".rtrim()
			+"\n      , SUM( CASE WHEN A.SALE_YN = 'N' THEN -1 ELSE 1 END * A.SALE_QTY ) AS DC_QTY     ".rtrim()
			+"\n FROM SSL_TRDTL_T A                                                     ".rtrim()
			+"\n      LEFT JOIN SCD_PRODM_T B                                           ".rtrim()
			+"\n      ON  B.SHOP_CD = A.SHOP_CD                                         ".rtrim()
			+"\n      AND B.PROD_CD = A.PROD_CD                                         ".rtrim()
			+"\n WHERE A.SHOP_CD   = '%s'                                               ".rtrim()
			+"\n AND   A.SALE_DATE BETWEEN '%s' AND '%s'                                ".rtrim()
			+"\n %s                                                                     ".rtrim()
			+"\n %s                                                                     ".rtrim()
			+"\n GROUP BY B.PROD_NM                                                     ".rtrim()
		;
		return s;
	}
	this.GetCardApprData_SQL = function(m_SaleClose, paramObj ) {
		var csTemp1 = "";
		var csQuery = "";
			;
		var csQuery = ""
			+"\n SELECT CASE WHEN  SALE_YN = 'Y' THEN '승인' ELSE '취소' END               AS APPR_FG                                                    ".rtrim()
			+"\n      , CASE WHEN  UNION_PAY_FG = '4' THEN CRD_CARD_NO  ELSE SUBSTR( CRD_CARD_NO, 1, 8 ) || '****' || SUBSTR( CRD_CARD_NO, 13, 16 )) AS CRD_CARD_NO     ".rtrim()  // 2014-1124-Jane : 현금IC 추가.
			+"\n      , APPR_NO                                                                                                                          ".rtrim()
			+"\n      , CASE WHEN SALE_YN = 'N' THEN -1 ELSE 1 END * APPR_REQ_AMT          AS APPR_REQ_AMT                                               ".rtrim()
			+"\n FROM SSL_TRCRD_T                                                                                                                        ".rtrim()
			+"\n WHERE SHOP_CD   = '%s'                                                                                                                  ".rtrim()
			+"\n AND   SALE_DATE = '%s'                                                                                                                  ".rtrim()
		;
		csQuery = csQuery.sprintf( paramObj.SHOP_CD, paramObj.SALE_DATE );
		if( !m_SaleClose ) {
			var nR = parseInt(paramObj.REGI_SEQ);
			if ( nR < 10 ) {
				nR = "0" + nR;
			} else {
				nR = "" + nR; 
			}

			csTemp1 = 
				 "\n    AND   POS_NO    = '%s' ".rtrim()
			   + "\n    AND   REGI_SEQ  = '%s' ".rtrim()
			;
			csTemp1 = csTemp1.sprintf( paramObj.POS_NO,  nR );
		}

		csQuery += csTemp1;
		csQuery += "\n  ORDER BY SALE_DATE, APPR_DATE, APPR_TIME ".rtrim();
		return csQuery;
	}
	//주방프린터 SQL
	this.InsertPrintTableMenuMove_01_SQL = function(obj) {
		var csQrySql = ""
			+"\n SELECT MAX( ORG_TBL_NM ) AS ORG_TBL_NM     ".rtrim()
			+"\n      , MAX( ORG_TG_NM  ) AS ORG_TG_NM      ".rtrim()
			+"\n      , MAX( TGT_TBL_NM ) AS TGT_TBL_NM     ".rtrim()
			+"\n      , MAX( TGT_TG_NM  ) AS TGT_TG_NM      ".rtrim()
			+"\n FROM ( SELECT A.TABLE_NM AS ORG_TBL_NM     ".rtrim()
			+"\n             , B.TG_NM    AS ORG_TG_NM      ".rtrim()
			+"\n             , ''         AS TGT_TBL_NM     ".rtrim()
			+"\n             , ''         AS TGT_TG_NM      ".rtrim()
			+"\n        FROM SCD_TABLE_T A                  ".rtrim()
			+"\n           , SCD_TBGRP_T B                  ".rtrim()
			+"\n        WHERE A.SHOP_CD  = '%s'             ".rtrim()
			+"\n        AND   A.TABLE_CD = '%s'             ".rtrim()
			+"\n        AND   B.SHOP_CD  = A.SHOP_CD        ".rtrim()
			+"\n        AND   B.TG_CD    = A.TG_CD          ".rtrim()
			+"\n        UNION ALL                           ".rtrim()
			+"\n        SELECT ''         AS ORG_TBL_NM     ".rtrim()
			+"\n             , ''         AS ORG_TG_NM      ".rtrim()
			+"\n             , A.TABLE_NM AS TGT_TBL_NM     ".rtrim()
			+"\n             , B.TG_NM    AS TGT_TG_NM      ".rtrim()
			+"\n        FROM SCD_TABLE_T A                  ".rtrim()
			+"\n           , SCD_TBGRP_T B                  ".rtrim()
			+"\n        WHERE A.SHOP_CD  = '%s'             ".rtrim()
			+"\n        AND   A.TABLE_CD = '%s'             ".rtrim()
			+"\n        AND   B.SHOP_CD  = A.SHOP_CD        ".rtrim()
			+"\n        AND   B.TG_CD    = A.TG_CD )        ".rtrim()
		;
		csQrySql = csQrySql.sprintf( gShopCd, obj.ORG_TABLE_CD, gShopCd, obj.TGT_TABLE_CD );
		return csQrySql;
	}
	//주방프린터 SQL.
	this.InsertPrintTableMenuMove_02_SQL = function(obj) {
		var csQrySql = ""
			+"\n SELECT B.PRT_NO                          AS PRT_NO         ".rtrim()
			+"\n      , A.ORDER_SEQ_NO                    AS ORDER_SEQ_NO   ".rtrim()
			+"\n      , ( SELECT MAX( ORDER_PRT_SEQ )                       ".rtrim()
			+"\n          FROM SCD_PRTDT_T                                  ".rtrim()
			+"\n          WHERE SHOP_CD   = '%s'                            ".rtrim()
			+"\n          AND SALE_DATE = '%s' )          AS ORDER_PRT_SEQ  ".rtrim()  // 2010-0610-JJM : 주문서 출력일련번호.
			+"\n FROM POS_ODDTL_T A                                         ".rtrim()
			+"\n    , SCD_PRTPR_T B                                         ".rtrim()
			+"\n    , SCD_PRTMS_T C                                         ".rtrim()
			+"\n WHERE A.SHOP_CD      = '%s'                                ".rtrim()
			+"\n AND   A.SALE_DATE    = '%s'                                ".rtrim()
			+"\n AND   A.ORDER_NO     = '%s'                                ".rtrim()
			+"\n AND   A.ORDER_SEQ_NO = ( SELECT MAX( ORDER_SEQ_NO )        ".rtrim()
			+"\n                          FROM POS_ODDTL_T                  ".rtrim()
			+"\n                          WHERE SHOP_CD   = '%s'            ".rtrim()
			+"\n                          AND   SALE_DATE = '%s'            ".rtrim()
			+"\n                          AND   ORDER_NO  = '%s' )          ".rtrim()
			+"\n AND   B.SHOP_CD      = A.SHOP_CD                           ".rtrim()
			+"\n AND   B.PROD_CD      = A.PROD_CD                           ".rtrim()
			+"\n AND   B.USE_YN       = 'Y'                                 ".rtrim()
			+"\n AND   C.SHOP_CD      = A.SHOP_CD                           ".rtrim()
			+"\n AND   C.POS_NO       = '%s'                                ".rtrim()
			+"\n AND   C.PRT_NO       = B.PRT_NO                            ".rtrim()
			+"\n AND   C.USE_YN       = 'Y'                                 ".rtrim()
			+"\n GROUP BY B.PRT_NO                                          ".rtrim()
			+"\n        , A.ORDER_SEQ_NO                                    ".rtrim()
			+"\n HAVING SUM( A.SALE_QTY ) <> 0                              ".rtrim()
		;
		csQrySql = csQrySql.sprintf( gShopCd,  obj.SALE_DATE, gShopCd, obj.SALE_DATE,  obj.TGT_ORDER_NO, gShopCd,  obj.SALE_DATE, obj.TGT_ORDER_NO, gPosNo );
		return csQrySql;
	}

	this.SP_SCD_PRTDT_TO_TIME_01_SQL = function( obj ){
		var prtTime = moment().format('HHmm');
		var s = ""
			+ "\n SELECT                                        ".rtrim()
			+ "\n        COUNT( PRT_FG )     AS CNT             ".rtrim()
			+ "\n   FROM SCD_PRTTM_T                            ".rtrim()
			+ "\n  WHERE SHOP_CD = '%s'                         ".rtrim()
			+ "\n    AND PRT_NO  = '%s'                         ".rtrim()
			+ "\n    AND '%s' BETWEEN PRT_TM_FROM AND PRT_TM_TO ".rtrim()
			+ "\n    AND PRT_FG  = '0'                          ".rtrim()
			+ "\n    AND USE_YN  = 'Y'                          ".rtrim()
		;
		s = s.sprintf( gShopCd , obj.PRT_NO , prtTime ) ;
		return s;
	}
	this.SP_SCD_PRTDT_TO_TIME_02_SQL = function(obj){
		var prtTime = moment().format('HHmm');
		var s = ""
				+ "\n SELECT DST_PRT_NO                               ".rtrim()
				+ "\n      , PRT_FG                                   ".rtrim()
				+ "\n   FROM SCD_PRTTM_T                              ".rtrim()
				+ "\n  WHERE SHOP_CD = '%s'                           ".rtrim()
				+ "\n    AND PRT_NO  = '%s'                           ".rtrim()
				+ "\n    AND '%s' BETWEEN PRT_TM_FROM AND PRT_TM_TO   ".rtrim()
				+ "\n    AND USE_YN  = 'Y'                            ".rtrim()
			;
		s = s.sprintf( gShopCd , obj.PRT_NO , prtTime ) ;
		return s;
	}
	this.SP_SCD_PRTDT_TO_TIME_03_SQL = function(obj) {
		var s = ""
				+ "\n SELECT                                                                            ".rtrim() 
				+ "\n        SUBSTR( X , LENGTH( X) - 3  ) AS SEQ                                       ".rtrim() 
				+ "\n   FROM (                                                                          ".rtrim() 
				+ "\n         SELECT                                                                    ".rtrim() 
				+ "\n                ( '0000000000' ||  (IFNULL(MAX( ORDER_PRT_SEQ ) , 0 ) + 1)  ) AS X ".rtrim() 
				+ "\n           FROM SCD_PRTDT_T                                                        ".rtrim() 
				+ "\n          WHERE SHOP_CD   = '%s'                                                   ".rtrim() 
				+ "\n            AND SALE_DATE = '%s'                                                   ".rtrim() 
				+ "\n            AND PRT_NO    = '%s'                                                   ".rtrim() 
				+ "\n        )                                                                          ".rtrim() 
		s = s.sprintf( obj.SHOP_CD, obj.SALE_DATE , obj.PRT_NO );
		return s;
	}

	this.SP_SCD_PRTDT_TO_TIME_04_SQL = function(obj) {
		var s = ""
			+ "\n SELECT COUNT( PRINT_SEQ ) AS CNT     ".rtrim()
			+ "\n   FROM SCD_PRTDT_T                   ".rtrim()
			+ "\n  WHERE SHOP_CD      = '%s'           ".rtrim()  /*** :SHOP_CD        ***/
			+ "\n    AND ORDER_NO     = '%s'           ".rtrim()  /*** :ORDER_NO       ***/
			+ "\n    AND PRT_NO       = '%s'           ".rtrim()  /*** :csDstPrtNo     ***/
			+ "\n    AND ORDER_SEQ_NO = '%s'           ".rtrim()  /*** :ORDER_SEQ_NO   ***/
		;
		s = s.sprintf(obj.SHOP_CD , obj.ORDER_NO , obj.csDstPrtNo , obj.ORDER_SEQ_NO);
		return s;
	}
	
	/*
	 * 2021. 05. 26 xbwing
	 * 시퀀스 maximum 정보를 확인하기 위한 SQL Query문.
	 */
	this.SP_SCD_PRTDT_T_MAX_SQL = function()
	{  
		var sSql = "" 
			+ "\n  SELECT IFNULL( MAX(PRINT_SEQ) , 0) as MAX_SEQ                    ".rtrim()
			+ "\n         FROM SCD_PRTDT_T                                          ".rtrim()
			+ "\n         WHERE SALE_DATE = strftime('%Y%m%d', 'NOW' , 'LOCALTIME') ".rtrim()
			;
		
		return sSql; 
	}

	
	/*
	 * 2021. 05. 26 xbwing
	 * Maximum 시퀀스 초기화를 위해 bIsMax 파라미터 추가함.
	 *  false - 시퀀스 증가.
	 *  true  - 시퀀스 초기화.
	 */
	this.SP_SCD_PRTDT_T_AUD_SQL = function(obj, bIsMax) {
		/*********************************************************************************
		 * 채번은 일별로 1 부터 시작하기로 확정함. 2020.09.04 10:00 최광림 차장 confirm
		 * SQLIte 의 특성상 autoincrement 로 처리시 PK 는 하나만 되는 상황이 됨.
		 *********************************************************************************/
		var sSeq = "" 
			+ "\n   ,(SELECT IFNULL( MAX(PRINT_SEQ) , 0) + 1        ".rtrim()
			+ "\n       FROM SCD_PRTDT_T                            ".rtrim()
			+ "\n      WHERE SHOP_CD = '%s' AND SALE_DATE = '%s' )  ".rtrim()
			;
		sSeq = sSeq.sprintf( obj.SHOP_CD, obj.SALE_DATE);

		if( bIsMax )
			sSeq = "1";
		
			
		var s = ""
			+"\n INSERT INTO SCD_PRTDT_T                         ".rtrim()
			+"\n (                                               ".rtrim()
			+"\n      SHOP_CD                                    ".rtrim()
			+"\n    , SALE_DATE                                  ".rtrim()
			+"\n    , PRINT_SEQ                                  ".rtrim()
			+"\n    , ORDER_NO                                   ".rtrim()
			+"\n    , PRT_NO                                     ".rtrim()
			+"\n    , CONTENTS                                   ".rtrim()
			+"\n    , PRINT_YN                                   ".rtrim()
			+"\n    , INS_DT                                     ".rtrim()
			+"\n    , PRT_DT                                     ".rtrim()
			+"\n    , ORDER_PRT_SEQ                              ".rtrim() /**  -- 2010-0609-JJM : 주문서 주문일련번호. **/
			+"\n    , ORDER_SEQ_NO                               ".rtrim() /**  -- 2010-0907-JJM : 주문차수. **/
			+"\n )                                               ".rtrim()
			+"\n VALUES                                          ".rtrim()
			+"\n (                                               ".rtrim()
			+"\n       '%s' /* :SHOP_CD   */                     ".rtrim()
			+"\n     , '%s' /* :SALE_DATE */                     ".rtrim()
			+sSeq                                           // "     , :inSeq            ".rtrim()
			+"\n     , '%s' /* :ORDER_NO */                      ".rtrim()
			+"\n     , '%s' /* :PRT_NO   */                      ".rtrim()
			+"\n     , '%s' /* :CONTENTS */                      ".rtrim()
			+"\n     , '%s' /* :PRINT_YN */                      ".rtrim()
			;
			var s2 = ""
			+"\n     , ''                                        ".rtrim()
			+"\n     , '%s' /* :ORDER_PRT_SEQ */                 ".rtrim() /***  -- 2010-0609-JJM : 주문서 주문일련번호.". ***/
			+"\n     , '%s' /* :ORDER_SEQ_NO  */                 ".rtrim() /***  -- 2010-0907-JJM : 주문차수.              ***/
			+"\n )                                               ".rtrim()
		;
		s  = s.sprintf(obj.SHOP_CD , obj.SALE_DATE , obj.ORDER_NO , obj.PRT_NO , obj.CONTENTS , obj.PRINT_YN  );
		s2 = s2.sprintf( obj.ORDER_PRT_SEQ , obj.ORDER_SEQ_NO );
		s = s +"\n     , strftime('%Y%m%d', 'NOW' , 'LOCALTIME')   ".rtrim() + s2;
		return s;
	}

	this.InsertPrintDataByOrderNo_01_true_SQL = function(obj ) {
		var s = ""
				+"\n SELECT DISTINCT DT.POS_NO      AS POS_NO                                   ".rtrim()
				+"\n      , DT.PRT_NO               AS PRT_NO                                   ".rtrim()
				+"\n      , DT.ORDER_SEQ_NO         AS ORDER_SEQ_NO                             ".rtrim()
				+"\n      , HD.FD_TBL_CD            AS FD_TBL_CD                                ".rtrim()
				+"\n      , HD.TABLE_NM             AS TABLE_NM                                 ".rtrim()
				+"\n      , HD.TG_NM                AS TG_NM                                    ".rtrim()
				+"\n      , HD.KITCHEN_MEMO         AS KITCHEN_MEMO                             ".rtrim()
				+"\n      , HD.FD_GST_CNT_T         AS FD_GST_CNT_T                             ".rtrim()
				+"\n      , DT.CHG_BILL_NO          AS CHG_BILL_NO                              ".rtrim()
				+"\n      , DT.CORNER_CD            AS CORNER_CD                                ".rtrim()
				+"\n      , DT.CORNER_NM            AS CORNER_NM                                ".rtrim()
				+"\n      , ( SELECT EMP_NM                                                     ".rtrim()
				+"\n          FROM SCD_EMPMS_T WHERE SHOP_CD = HD.SHOP_CD AND   EMP_NO  = DT.ORDER_EMP_NO ) AS EMP_NM     ".rtrim()
				+"\n      , ( SELECT MAX( ORDER_PRT_SEQ )                                       ".rtrim()
				+"\n          FROM SCD_PRTDT_T                                                  ".rtrim()
				+"\n          WHERE SHOP_CD   = '%s'                                            ".rtrim()
				+"\n          AND   PRT_NO    = DT.PRT_NO                                       ".rtrim()  // 2010-0907-JJM : 프린터별 주문서 출력일련번호.
				+"\n          AND   SALE_DATE = '%s' ) AS ORDER_PRT_SEQ                         ".rtrim()  // 2010-0610-JJM : 주문서 출력일련번호.
				+"\n      , HD.DELIVER_NO              AS DELIVER_NO                            ".rtrim()  // 2011-0413-JJM : 대기(페이저)번호 수기.
				+"\n FROM ( SELECT A.SHOP_CD                                                    ".rtrim()
				+"\n             , A.FD_TBL_CD                                                  ".rtrim()
				+"\n             , A.KITCHEN_MEMO                                               ".rtrim()
				+"\n             , TB.TABLE_NM                                                  ".rtrim()
				+"\n             , TB.TG_NM                                                     ".rtrim()
				+"\n             , A.FD_GST_CNT_T                                               ".rtrim()
				+"\n             , A.DELIVER_NO                                                 ".rtrim()  // 2011-0413-JJM : 대기(페이저)번호 수기.
				+"\n        FROM POS_ODHDR_T A                                                  ".rtrim()
				+"\n             LEFT OUTER JOIN ( SELECT B.TABLE_CD                            ".rtrim()
				+"\n                                    , B.TABLE_NM                            ".rtrim()
				+"\n                                    , C.TG_NM                               ".rtrim()
				+"\n                               FROM SCD_TABLE_T B                           ".rtrim()
				+"\n                                  , SCD_TBGRP_T C                           ".rtrim()
				+"\n                               WHERE C.SHOP_CD = B.SHOP_CD                  ".rtrim()
				+"\n                               AND   C.TG_CD   = B.TG_CD ) TB               ".rtrim()
				+"\n                  ON TB.TABLE_CD = A.FD_TBL_CD                              ".rtrim()
				+"\n        WHERE A.SHOP_CD   = '%s'                                            ".rtrim()
				+"\n        AND   A.SALE_DATE = '%s'                                            ".rtrim()
				+"\n        AND   A.ORDER_NO  = '%s' ) HD                                       ".rtrim()
				+"\n    , ( SELECT A.ORDER_SEQ_NO                                               ".rtrim()
				+"\n             , A.POS_NO                                                     ".rtrim()
				+"\n             , A.ORDER_EMP_NO                                               ".rtrim()
				+"\n             , A.PROD_CD                                                    ".rtrim()
				+"\n             , B.PRT_NO                                                     ".rtrim()
				+"\n             , A.CHG_BILL_NO                                                ".rtrim()
				+"\n             , A.CORNER_CD                                                  ".rtrim()
				+"\n             , D.CORNER_NM                                                  ".rtrim()
				+"\n        FROM POS_ODDTL_T A                                                  ".rtrim()
				+"\n           , SCD_PRTPR_T B                                                  ".rtrim()
				+"\n           , SCD_PRTMS_T C                                                  ".rtrim()
				+"\n           , SCD_SHOPS_T D                                                  ".rtrim()
				+"\n        WHERE A.SHOP_CD      = '%s'                                         ".rtrim()
				+"\n        AND   A.SALE_DATE    = '%s'                                         ".rtrim()
				+"\n        AND   A.ORDER_NO     = '%s'                                         ".rtrim()
				+"\n        AND   A.ORDER_SEQ_NO = ( SELECT MAX( ORDER_SEQ_NO )                 ".rtrim()
				+"\n                                 FROM POS_ODDTL_T                           ".rtrim()
				+"\n                                 WHERE SHOP_CD   = '%s'                     ".rtrim()
				+"\n                                 AND   SALE_DATE = '%s'                     ".rtrim()
				+"\n                                 AND   ORDER_NO  = '%s' )                   ".rtrim()
				+"\n        AND   B.SHOP_CD      = A.SHOP_CD                                    ".rtrim()
				+"\n        AND   B.PROD_CD      = A.PROD_CD                                    ".rtrim()
				+"\n        AND   B.USE_YN       = 'Y'                                          ".rtrim()
				+"\n        AND   C.SHOP_CD      = A.SHOP_CD                                    ".rtrim()
				+"\n        AND   C.POS_NO       = '%s'                                         ".rtrim()
				+"\n        AND   C.PRT_NO       = B.PRT_NO                                     ".rtrim()
				+"\n        AND   C.USE_YN       = 'Y'                                          ".rtrim()
				+"\n        AND   D.SHOP_CD      = A.SHOP_CD                                    ".rtrim()
				+"\n        AND   D.CORNER_CD    = A.CORNER_CD                                  ".rtrim()
				+"\n        GROUP BY A.ORDER_SEQ_NO                                             ".rtrim()
				+"\n               , A.POS_NO                                                   ".rtrim()
				+"\n               , A.ORDER_EMP_NO                                             ".rtrim()
				+"\n               , A.PROD_CD                                                  ".rtrim()
				+"\n               , B.PRT_NO                                                   ".rtrim()
				+"\n               , A.CHG_BILL_NO                                              ".rtrim()
				+"\n               , A.CORNER_CD                                                ".rtrim()
				+"\n               , D.CORNER_NM                                                ".rtrim()
				+"\n        HAVING ( SUM( A.SALE_QTY ) <> 0 )                                   ".rtrim()
				+"\n            OR ( SUM( A.SALE_AMT ) <> 0 )                                   ".rtrim()
				+"\n            OR ( MIN( A.SDA_CD ) <> MAX( A.SDA_CD ) ) ) DT                  ".rtrim()
			;
		s = s.sprintf( gShopCd, obj.SALE_DATE, gShopCd, obj.SALE_DATE, obj.ORDER_NO, gShopCd, obj.SALE_DATE, obj.ORDER_NO, gShopCd, obj.SALE_DATE, obj.ORDER_NO, gPosNo );
		s = s.sprintf();
		return s;
	}
	this.InsertPrintDataByOrderNo_01_false_SQL = function(obj) {
		// Default : 코너분할출력 미사용
		var s = ""
			+"\n SELECT DISTINCT DT.POS_NO        AS POS_NO                                 ".rtrim()
			+"\n      , DT.PRT_NO                 AS PRT_NO                                 ".rtrim()
			+"\n      , DT.ORDER_SEQ_NO           AS ORDER_SEQ_NO                           ".rtrim()
			+"\n      , HD.FD_TBL_CD              AS FD_TBL_CD                              ".rtrim()
			+"\n      , HD.TABLE_NM               AS TABLE_NM                               ".rtrim()
			+"\n      , HD.TG_NM                  AS TG_NM                                  ".rtrim()
			+"\n      , HD.KITCHEN_MEMO           AS KITCHEN_MEMO                           ".rtrim()
			+"\n      , HD.FD_GST_CNT_T           AS FD_GST_CNT_T                           ".rtrim()
			+"\n      , DT.CHG_BILL_NO            AS CHG_BILL_NO                            ".rtrim()
			+"\n      , NULL                      AS CORNER_CD                              ".rtrim()
			+"\n      , NULL                      AS CORNER_NM                              ".rtrim()
			+"\n      , ( SELECT EMP_NM                                                     ".rtrim()
			+"\n          FROM SCD_EMPMS_T WHERE SHOP_CD = HD.SHOP_CD AND   EMP_NO  = DT.ORDER_EMP_NO ) AS EMP_NM     ".rtrim()
			+"\n      , ( SELECT MAX( ORDER_PRT_SEQ )                                       ".rtrim()
			+"\n          FROM SCD_PRTDT_T                                                  ".rtrim()
			+"\n          WHERE SHOP_CD   = '%s'                                            ".rtrim()
			+"\n          AND   PRT_NO    = DT.PRT_NO                                       ".rtrim()  // 2010-0907-JJM : 프린터별 주문서 출력일련번호.
			+"\n          AND   SALE_DATE = '%s' ) AS ORDER_PRT_SEQ                         ".rtrim()  // 2010-0610-JJM : 주문서 출력일련번호.
			+"\n      , HD.DELIVER_NO              AS DELIVER_NO                            ".rtrim()  // 2011-0413-JJM : 대기(페이저)번호 수기.
			+"\n FROM ( SELECT A.SHOP_CD                                                    ".rtrim()
			+"\n             , A.FD_TBL_CD                                                  ".rtrim()
			+"\n             , A.KITCHEN_MEMO                                               ".rtrim()
			+"\n             , TB.TABLE_NM                                                  ".rtrim()
			+"\n             , TB.TG_NM                                                     ".rtrim()
			+"\n             , A.FD_GST_CNT_T                                               ".rtrim()
			+"\n             , A.DELIVER_NO                                                 ".rtrim()  // 2011-0413-JJM : 대기(페이저)번호 수기.
			+"\n        FROM POS_ODHDR_T A                                                  ".rtrim()
			+"\n             LEFT OUTER JOIN ( SELECT B.TABLE_CD                            ".rtrim()
			+"\n                                    , B.TABLE_NM                            ".rtrim()
			+"\n                                    , C.TG_NM                               ".rtrim()
			+"\n                               FROM SCD_TABLE_T B                           ".rtrim()
			+"\n                                  , SCD_TBGRP_T C                           ".rtrim()
			+"\n                               WHERE C.SHOP_CD = B.SHOP_CD                  ".rtrim()
			+"\n                               AND   C.TG_CD   = B.TG_CD ) TB               ".rtrim()
			+"\n                  ON TB.TABLE_CD = A.FD_TBL_CD                              ".rtrim()
			+"\n        WHERE A.SHOP_CD   = '%s'                                            ".rtrim()
			+"\n        AND   A.SALE_DATE = '%s'                                            ".rtrim()
			+"\n        AND   A.ORDER_NO  = '%s' ) HD                                       ".rtrim()
			+"\n      , ( SELECT A.ORDER_SEQ_NO                                             ".rtrim()
			+"\n               , A.POS_NO                                                   ".rtrim()
			+"\n               , A.ORDER_EMP_NO                                             ".rtrim()
			+"\n               , A.PROD_CD                                                  ".rtrim()
			+"\n               , B.PRT_NO                                                   ".rtrim()
			+"\n               , CASE WHEN %d = 1 THEN A.CHG_BILL_NO ELSE '0' END AS CHG_BILL_NO   ".rtrim()
			+"\n          FROM POS_ODDTL_T A                                                ".rtrim()
			+"\n             , SCD_PRTPR_T B                                                ".rtrim()
			+"\n             , SCD_PRTMS_T C                                                ".rtrim()
			+"\n          WHERE A.SHOP_CD      = '%s'                                       ".rtrim()
			+"\n          AND   A.SALE_DATE    = '%s'                                       ".rtrim()
			+"\n          AND   A.ORDER_NO     = '%s'                                       ".rtrim()
			+"\n          AND   A.ORDER_SEQ_NO = ( SELECT MAX( ORDER_SEQ_NO )               ".rtrim()
			+"\n                                   FROM POS_ODDTL_T                         ".rtrim()
			+"\n                                   WHERE SHOP_CD   = '%s'                   ".rtrim()
			+"\n                                   AND   SALE_DATE = '%s'                   ".rtrim()
			+"\n                                   AND   ORDER_NO  = '%s' )                 ".rtrim()
			+"\n          AND   B.SHOP_CD      = A.SHOP_CD                                  ".rtrim()
			+"\n          AND   B.PROD_CD      = A.PROD_CD                                  ".rtrim()
			+"\n          AND   B.USE_YN       = 'Y'                                        ".rtrim()
			+"\n          AND   C.SHOP_CD      = A.SHOP_CD                                  ".rtrim()
			+"\n          AND   C.POS_NO       = '%s'                                       ".rtrim()
			+"\n          AND   C.PRT_NO       = B.PRT_NO                                   ".rtrim()
			+"\n          AND   C.USE_YN       = 'Y'                                        ".rtrim()
			+"\n          GROUP BY A.ORDER_SEQ_NO                                           ".rtrim()
			+"\n                 , A.POS_NO                                                 ".rtrim()
			+"\n                 , A.ORDER_EMP_NO                                           ".rtrim()
			+"\n                 , A.PROD_CD                                                ".rtrim()
			+"\n                 , B.PRT_NO                                                 ".rtrim()
			+"\n                 , CASE WHEN %d = 1 THEN A.CHG_BILL_NO ELSE '0'  END        ".rtrim()
			+"\n          HAVING ( SUM( A.SALE_QTY ) <> 0 )                                 ".rtrim()
			+"\n              OR ( SUM( A.SALE_AMT ) <> 0 )                                 ".rtrim()
			+"\n              OR ( MIN( A.SDA_CD ) <> MAX( A.SDA_CD ) ) ) DT                ".rtrim()
		;
		s = s.sprintf( gShopCd, obj.SALE_DATE, gShopCd, obj.SALE_DATE, obj.ORDER_NO, obj.blChgBillNoUseFg  , gShopCd, obj.SALE_DATE, obj.ORDER_NO, gShopCd, obj.SALE_DATE, obj.ORDER_NO, gPosNo, obj.blChgBillNoUseFg );
		return s;
	}
	this.InsertPrintTableMove_01_SQL = function(obj) {
		var s = "" ;
		s = ""
			+"\n SELECT MAX( ORG_TBL_NM ) AS ORG_TBL_NM     ".rtrim()
			+"\n      , MAX( ORG_TG_NM  ) AS ORG_TG_NM      ".rtrim()
			+"\n      , MAX( TGT_TBL_NM ) AS TGT_TBL_NM     ".rtrim()
			+"\n      , MAX( TGT_TG_NM  ) AS TGT_TG_NM      ".rtrim()
			+"\n FROM ( SELECT A.TABLE_NM AS ORG_TBL_NM     ".rtrim()
			+"\n             , B.TG_NM    AS ORG_TG_NM      ".rtrim()
			+"\n             , ''         AS TGT_TBL_NM     ".rtrim()
			+"\n             , ''         AS TGT_TG_NM      ".rtrim()
			+"\n        FROM SCD_TABLE_T A                  ".rtrim()
			+"\n           , SCD_TBGRP_T B                  ".rtrim()
			+"\n        WHERE A.SHOP_CD  = '%s'             ".rtrim()
			+"\n        AND   A.TABLE_CD = '%s'             ".rtrim()
			+"\n        AND   B.SHOP_CD  = A.SHOP_CD        ".rtrim()
			+"\n        AND   B.TG_CD    = A.TG_CD          ".rtrim()
			+"\n        UNION ALL                           ".rtrim()
			+"\n        SELECT ''         AS ORG_TBL_NM     ".rtrim()
			+"\n             , ''         AS ORG_TG_NM      ".rtrim()
			+"\n             , A.TABLE_NM AS TGT_TBL_NM     ".rtrim()
			+"\n             , B.TG_NM    AS TGT_TG_NM      ".rtrim()
			+"\n        FROM SCD_TABLE_T A                  ".rtrim()
			+"\n           , SCD_TBGRP_T B                  ".rtrim()
			+"\n        WHERE A.SHOP_CD  = '%s'             ".rtrim()
			+"\n        AND   A.TABLE_CD = '%s'             ".rtrim()
			+"\n        AND   B.SHOP_CD  = A.SHOP_CD        ".rtrim()
			+"\n        AND   B.TG_CD    = A.TG_CD )        ".rtrim()
			;
		s = s.sprintf( gShopCd, obj.ORG_TABLE_CD, gShopCd, obj.TGT_TABLE_CD );
		return s;
	}
	this.InsertPrintTableMove_02_SQL = function(obj) {
		var s = ""
			+"\n SELECT B.PRT_NO                                        ".rtrim()
			+"\n      , MAX( A.ORDER_SEQ_NO ) ORDER_SEQ_NO              ".rtrim()
			+"\n      , ( SELECT MAX( ORDER_PRT_SEQ )                   ".rtrim()
			+"\n          FROM SCD_PRTDT_T                              ".rtrim()
			+"\n          WHERE SHOP_CD   = '%s'                        ".rtrim()
			+"\n          AND   SALE_DATE = '%s' ) AS ORDER_PRT_SEQ     ".rtrim()  // 2010-0610-JJM : 주문서 출력일련번호.
			+"\n FROM POS_ODDTL_T A                                     ".rtrim()
			+"\n    , SCD_PRTPR_T B                                     ".rtrim()
			+"\n    , SCD_PRTMS_T C                                     ".rtrim()
			+"\n WHERE A.SHOP_CD   = '%s'                               ".rtrim()
			+"\n AND   A.SALE_DATE = '%s'                               ".rtrim()
			+"\n AND   A.ORDER_NO  = '%s'                               ".rtrim()
			+"\n AND   B.SHOP_CD   = A.SHOP_CD                          ".rtrim()
			+"\n AND   B.PROD_CD   = A.PROD_CD                          ".rtrim()
			+"\n AND   B.USE_YN    = 'Y'                                ".rtrim()
			+"\n AND   C.SHOP_CD   = A.SHOP_CD                          ".rtrim()
			+"\n AND   C.POS_NO    = '%s'                               ".rtrim()
			+"\n AND   C.PRT_NO    = B.PRT_NO                           ".rtrim()
			+"\n AND   C.USE_YN    = 'Y'                                ".rtrim()
			+"\n GROUP BY B.PRT_NO                                      ".rtrim()
			+"\n HAVING SUM( A.SALE_QTY ) <> 0                          ".rtrim()
		;
		s = s.sprintf( gShopCd, obj.SALE_DATE, gShopCd, obj.SALE_DATE, obj.ORG_ORDER_NO, gPosNo );

		return s;
	}
	this.SetMakePrtThreadByData_SQL = function(obj , pinProcTypeNo) {
		var csQrySql = "";
		////////////////////////////////////////////////////////////////////////
		// 2009-1028-YBC : 해당 포스에서 담당하는 주방프린터 번호만을 구하게 변경한다.
		////////////////////////////////////////////////////////////////////////
		switch( parseInt( pinProcTypeNo) )	{
		
			case 2 :
				csQrySql = ""
					+"\n SELECT DISTINCT A.PRT_NO AS PRT_NO  ".rtrim()
					+"\n FROM SCD_PRTDT_T A                  ".rtrim()
					+"\n    , SCD_PRTMS_T B                  ".rtrim()
					+"\n WHERE A.SHOP_CD   = '%s'            ".rtrim()
					+"\n AND   A.SALE_DATE = '%s'            ".rtrim()
					+"\n AND   A.PRINT_SEQ = '%s'            ".rtrim()
					+"\n AND   B.SHOP_CD   = A.SHOP_CD       ".rtrim()
					+"\n AND   B.POS_NO    = '%s'            ".rtrim()
					+"\n AND   B.PRT_NO    = A.PRT_NO        ".rtrim()
					+"\n AND   B.USE_YN    = 'Y'             ".rtrim()
				;
				csQrySql = csQrySql.sprintf( gShopCd, obj.SALE_DATE, obj.ORDER_NO, gPosNo );
				break;
	
			case 3 :
				csQrySql = ""
					+"\n SELECT DISTINCT A.PRT_NO  AS PRT_NO ".rtrim()
					+"\n   FROM SCD_PRTDT_T A                ".rtrim()
					+"\n    , SCD_PRTMS_T B                  ".rtrim()
					+"\n WHERE A.SHOP_CD   = '%s'            ".rtrim()
					+"\n AND   A.SALE_DATE = '%s'            ".rtrim()
					+"\n AND   A.PRINT_YN  = 'N'             ".rtrim()
					+"\n AND   B.SHOP_CD   = A.SHOP_CD       ".rtrim()
					+"\n AND   B.POS_NO    = '%s'            ".rtrim()
					+"\n AND   B.PRT_NO    = A.PRT_NO        ".rtrim()
					+"\n AND   B.USE_YN = 'Y'                ".rtrim()
				;
				csQrySql = csQrySql.sprintf( gShopCd, obj.SALE_DATE , gPosNo );
				break;
			default	:
				csQrySql = ""
					+"\n SELECT DISTINCT A.PRT_NO          ".rtrim()
					+"\n FROM SCD_PRTDT_T A                ".rtrim()
					+"\n    , SCD_PRTMS_T B                ".rtrim()
					+"\n WHERE A.SHOP_CD   = '%s'          ".rtrim()
					+"\n AND   A.SALE_DATE = '%s'          ".rtrim()
					+"\n AND   A.PRINT_YN  = 'N'           ".rtrim()
					+"\n AND   A.ORDER_NO  = '%s'          ".rtrim()
					+"\n AND   B.SHOP_CD   = A.SHOP_CD     ".rtrim()
					+"\n AND   B.POS_NO    = '%s'          ".rtrim()
					+"\n AND   B.PRT_NO    = A.PRT_NO      ".rtrim()
					+"\n AND   B.USE_YN    = 'Y'           ".rtrim()
				;
				csQrySql = csQrySql.sprintf( gShopCd, obj.SALE_DATE, obj.ORDER_NO , gPosNo );
				break;
		}
		return csQrySql;
	}

	this.GetUserTitle_SQL = function(pcsComCD) {
		var csQuery = ""
			+"\n SELECT COM_CD_NM                         ".rtrim()
			+"\n FROM SCD_CODEM_T                         ".rtrim()
			+"\n WHERE SHOP_CD   = '%s'                   ".rtrim()
			+"\n AND   COM_CD_FG = '602'                  ".rtrim()
			+"\n AND   COM_CD    = '%s'                   ".rtrim()
			+"\n AND   USE_YN    = 'Y'                    ".rtrim()
		;
		csQuery = csQuery.sprintf( gShopCd, pcsComCD);
		return csQuery;
	}
	this.SetKitchenPrinterInfo_SQL = function(obj) {
		///////////////////////////////////////////////////////////////////////////////
		// 2009-1209-YBC : PRT_PAPER_QTY 추가
		///////////////////////////////////////////////////////////////////////////////
		var s = ""
			+"\n SELECT PRT_NO            ".rtrim()
			+"\n      , PRT_TYPE_FG       ".rtrim()
			+"\n      , PRT_PORT          ".rtrim()
			+"\n      , PRT_SPEED         ".rtrim()
			+"\n      , PRT_NM            ".rtrim()
			+"\n      , POS_NO            ".rtrim()
			+"\n      , PRT_PAPER_QTY     ".rtrim()
			+"\n   FROM SCD_PRTMS_T       ".rtrim()
			+"\n  WHERE SHOP_CD = '%s'    ".rtrim()
			+"\n    AND USE_YN  = 'Y'     ".rtrim()
		;
		s = s.sprintf( gShopCd );
		return s;
	}
	this.GetPresentOrderList_SQL = function(obj) {
		var s = "" 
			+"\n SELECT A.PROD_CD                                                   AS PROD_CD                                                 ".rtrim()
			+"\n      , A.PROD_NM                                                   AS PROD_NM                                                 ".rtrim()
			+"\n      , A.SIDE_MENU_YN                                              AS SIDE_MENU_YN                                            ".rtrim()
			+"\n      , A.SDS_ORG_DTL_NO                                            AS SDS_ORG_DTL_NO                                          ".rtrim()
			+"\n      , A.UPRC                                                      AS UPRC                                                    ".rtrim()
			+"\n      , A.SDA_CD                                                    AS SDA_CD                                                  ".rtrim()
			+"\n      , SUM( A.QTY )                                                AS QTY                                                     ".rtrim()
			+"\n      , SUM( A.SALE_AMT )                                           AS SALE_AMT                                                ".rtrim()
			+"\n      , CASE WHEN  A.SIDE_MENU_YN = 'Y' THEN SD.SDA_NM ELSE '' END  AS SDA_NM                                                  ".rtrim()
			+"\n      , A.PRICE_MGR_YN                                              AS PRICE_MGR_YN                                            ".rtrim()
			+"\n      , A.ORDER_CNT                                                 AS ORDER_CNT                                               ".rtrim()
			+"\n      , A.DLV_PACK_FG                                               AS DLV_PACK_FG                                             ".rtrim()
			+"\n      , A.DCM_SALE_AMT                                              AS DCM_SALE_AMT                                            ".rtrim()
			+"\n      , A.VAT_AMT                                                   AS VAT_AMT                                                 ".rtrim()
			+"\n FROM ( SELECT A.ORDER_DTL_NO                                                                                                  ".rtrim()
			+"\n             , A.PROD_CD                                                                                                       ".rtrim()
			+"\n             , A.PROD_NM                                                                                                       ".rtrim()
			+"\n             , A.SIDE_MENU_YN                                                                                                  ".rtrim()
			+"\n             , A.SDS_ORG_DTL_NO                                                                                                ".rtrim()
			+"\n             , A.UPRC                                                                                                          ".rtrim()
			+"\n             , A.SDA_CD                                                                                                        ".rtrim()
			+"\n             , A.QTY                                                                                                           ".rtrim()
			+"\n             , A.SALE_AMT                                                                                                      ".rtrim()
			+"\n             , A.PRICE_MGR_YN                                                                                                  ".rtrim()
			+"\n             , B.ORDER_CNT                                                                                                     ".rtrim()
			+"\n             , A.DLV_PACK_FG                                                                                                   ".rtrim()
			+"\n             , A.DCM_SALE_AMT                                                                                                  ".rtrim()
			+"\n             , A.VAT_AMT                                                                                                       ".rtrim()
			+"\n        FROM ( SELECT A.ORDER_DTL_NO                                                                                           ".rtrim()
			+"\n                    , A.PROD_CD                                                                                                ".rtrim()
			+"\n                    , CASE WHEN B.PROD_NM IS NULL THEN ( SELECT SDA_NM AS PROD_NM                                           ".rtrim()
			//+"\n                                                         FROM SP_GET_SDA_NM( A.SHOP_CD,  SUBSTR( A.PROD_CD, 4, 7 ) ) )         ".rtrim()
			+"\n                                                         FROM  (                                                               ".rtrim()
			+ this.SP_GET_SDA_NM_SQL( "A.SHOP_CD" , " SUBSTR( A.PROD_CD, 4, 7 ) ) ) " )
			+"\n                                                  ELSE LTRIM( CASE WHEN B.TAX_YN = 'N' THEN '*' ELSE '' END || B.PROD_NM ) END AS PROD_NM   ".rtrim()
			+"\n                    , CASE WHEN B.PROD_NM IS NULL THEN 'N'                                                                     ".rtrim()
			+"\n                                                  ELSE B.SIDE_MENU_YN END AS SIDE_MENU_YN                                      ".rtrim()
			+"\n                    , A.SDS_ORG_DTL_NO                                                                                         ".rtrim()
			+"\n                    , A.SALE_UPRC AS UPRC                                                                                      ".rtrim()
			+"\n                    , A.SDA_CD                                                                                                 ".rtrim()
			+"\n                    , A.SALE_QTY AS QTY                                                                                        ".rtrim()
			+"\n                    , A.SALE_AMT AS SALE_AMT                                                                                   ".rtrim()
			+"\n                    , CASE WHEN B.PRICE_MGR_FG = '1' THEN 'Y' ELSE 'N' END AS PRICE_MGR_YN                                     ".rtrim()
			+"\n                    , A.DLV_PACK_FG                                                                                            ".rtrim()
			+"\n                    , A.DCM_SALE_AMT                                                                                           ".rtrim()
			+"\n                    , A.VAT_AMT                                                                                                ".rtrim()
			+"\n               FROM POS_ODDTL_T A                                                                                              ".rtrim()
			+"\n                    LEFT OUTER JOIN SCD_PRODM_T B                                                                              ".rtrim()
			+"\n                    ON  B.SHOP_CD = A.SHOP_CD                                                                                  ".rtrim()
			+"\n                    AND B.PROD_CD = A.PROD_CD                                                                                  ".rtrim()
			+"\n               WHERE A.SHOP_CD      = '%s'                                                                                     ".rtrim()
			+"\n               AND   A.SALE_DATE    = '%s'                                                                                     ".rtrim()
			+"\n               AND   A.ORDER_NO     = '%s'                                                                                     ".rtrim()
			+"\n               AND   A.ORDER_SEQ_NO = '%s' ) A                                                                                 ".rtrim()
			+"\n           , ( SELECT PROD_CD                                                                                                  ".rtrim()
			+"\n                    , COUNT( PROD_CD ) AS ORDER_CNT                                                                            ".rtrim()
			+"\n               FROM POS_ODDTL_T                                                                                                ".rtrim()
			+"\n               WHERE SHOP_CD      = '%s'                                                                                       ".rtrim()
			+"\n               AND   SALE_DATE    = '%s'                                                                                       ".rtrim()
			+"\n               AND   ORDER_NO     = '%s'                                                                                       ".rtrim()
			+"\n               AND   ORDER_SEQ_NO <= '%s'                                                                                      ".rtrim()
			+"\n               GROUP BY PROD_CD ) B                                                                                            ".rtrim()
			+"\n        WHERE A.PROD_CD = B.PROD_CD ) A                                                                                        ".rtrim()
			+"\n      LEFT OUTER JOIN SCD_SDACD_T SD                                                                                           ".rtrim()
			+"\n      ON  SD.SHOP_CD = '%s'                                                                                                    ".rtrim()
			+"\n      AND SD.SDA_CD  = A.SDA_CD                                                                                                ".rtrim()
			+"\n GROUP BY A.PROD_CD                                                                                                            ".rtrim()
			+"\n        , A.PROD_NM                                                                                                            ".rtrim()
			+"\n        , A.SIDE_MENU_YN                                                                                                       ".rtrim()
			+"\n        , A.SDS_ORG_DTL_NO                                                                                                     ".rtrim()
			+"\n        , A.UPRC                                                                                                               ".rtrim()
			+"\n        , A.SDA_CD                                                                                                             ".rtrim()
			+"\n        , SD.SDA_NM                                                                                                            ".rtrim()
			+"\n        , A.PRICE_MGR_YN                                                                                                       ".rtrim()
			+"\n        , A.SALE_AMT                                                                                                           ".rtrim()
			+"\n        , A.ORDER_CNT                                                                                                          ".rtrim()
			+"\n        , A.DLV_PACK_FG                                                                                                        ".rtrim()
			+"\n        , A.DCM_SALE_AMT                                                                                                       ".rtrim()
			+"\n        , A.VAT_AMT                                                                                                            ".rtrim()
			+"\n HAVING ( SUM( A.QTY ) <> 0 ) OR ( SUM( A.SALE_AMT ) <> 0 )                                                                    ".rtrim()
			+"\n ORDER BY MIN( A.ORDER_DTL_NO )                                                                                                ".rtrim()
		;
		s = s.sprintf( obj.SHOP_CD, obj.SALE_DATE, obj.ORDER_NO, obj.ORDER_SEQ_NO 
				, obj.SHOP_CD, obj.SALE_DATE, obj.ORDER_NO
				, obj.ORDER_SEQ_NO , obj.SHOP_CD );
		return s;
	}
	this.GetSummaryOrderList_SQL = function(obj) {
		var s = ""
			+"\n SELECT A.PROD_CD                                                           AS PROD_CD      ".rtrim()
			+"\n      , LTRIM( CASE WHEN B.TAX_YN = 'N' THEN '*' ELSE '' END || B.PROD_NM ) AS PROD_NM      ".rtrim()
			+"\n      , A.DLV_PACK_FG                                                       AS DLV_PACK_FG  ".rtrim()
			+"\n      , SUM( A.SALE_QTY     )                                               AS QTY          ".rtrim()
			+"\n      , SUM( A.DCM_SALE_AMT )                                               AS DCM_SALE_AMT ".rtrim()
			+"\n      , SUM( A.VAT_AMT      )                                               AS VAT_AMT      ".rtrim()
			+"\n      , SUM( A.SALE_UPRC    )                                               AS UPRC         ".rtrim()
			+"\n FROM POS_ODDTL_T A                                                                         ".rtrim()
			+"\n    , SCD_PRODM_T B                                                                         ".rtrim()
			+"\n WHERE A.SHOP_CD      = '%s'                                                                ".rtrim()
			+"\n AND   A.SALE_DATE    = '%s'                                                                ".rtrim()
			+"\n AND   A.ORDER_NO     = '%s'                                                                ".rtrim()
			+"\n AND   B.SHOP_CD      = A.SHOP_CD                                                           ".rtrim()
			+"\n AND   B.PROD_CD      = A.PROD_CD                                                           ".rtrim()
			+"\n GROUP BY A.PROD_CD                                                                         ".rtrim()
			+"\n        , B.PROD_NM                                                                         ".rtrim()
			+"\n        , A.DLV_PACK_FG                                                                     ".rtrim()
			+"\n        , B.TAX_YN                                                                          ".rtrim()
			+"\n HAVING ( SUM( A.SALE_QTY ) <> 0 ) OR ( SUM( A.DCM_SALE_AMT ) <> 0 )                        ".rtrim()
			+"\n ORDER BY MIN( A.ORDER_DTL_NO )                                                             ".rtrim()
		;
		s =s.sprintf( obj.SHOP_CD, obj.SALE_DATE, obj.ORDER_NO );
		return s;
	}
	this.GetProductListData_04_SQL = function(obj , pblSales , pcsCode , SHOP_ENV , m_csOrderDtlNo ) {
		var csQrySql	= "" ; /** CString **/
		var csSubQrySql = "" ; /** CString **/	// 2019-04-24-SHK [정렬방식]
		var csSubQuery1 = "" ; /** CString **/
		var csSubQuery2 = "" ; /** CString **/
		var s = "" ;
		if ( pblSales == true ) {
			if(pcsCode == "{상품리스트2}") {				// 2019-08-13-SHK [상품리스트2]

				var iif_3 = "CASE WHEN B.PROD_NM IS NULL THEN  '▷' ELSE '▶' END ";
				var csSubQrySql = ""
					+"\n SELECT A.PROD_CD                    AS PROD_CD                                                                                                                              ".rtrim()  // 2019-04-24-SHK [정렬방식]
					+"\n      , MIN( CASE WHEN A.SDS_ORG_DTL_NO > '0' AND A.SDA_CD <> '' AND A.SDA_CD IS NOT NULL AND CASE WHEN  B.PROD_NM IS NULL THEN 'N' ELSE B.SIDE_MENU_YN END = 'N' THEN " + iif_3 + "   ELSE '' END    ".rtrim()
					+"\n          || CASE WHEN B.PROD_NM IS NULL THEN ( SELECT SDA_NM AS PROD_NM                                                                                          ".rtrim()
					+"\n                                                FROM (                                                                                                            ".rtrim()
					+ this.SP_GET_SDA_NM_SQL( " A.SHOP_CD" , " SUBSTR( A.PROD_CD, 4, 7 ) " )
					+"\n                                                         )                                                                                                        ".rtrim()
					+"\n                                         ELSE B.PROD_NM END ) AS PROD_NM                                                                                          ".rtrim()
					+"\n      , A.SALE_UPRC                                           AS UPRC                                                                                             ".rtrim()
					+"\n      , A.PROP_CD                                             AS PROP_CD                                                                                          ".rtrim()  // 2016-09-27-JYL [곱빼기]
					+"\n      , SUM( A.SALE_QTY )                                     AS QTY                                                                                              ".rtrim()
					+"\n      , SUM( A.DCM_SALE_AMT )                                 AS SALE_AMT                                                                                         ".rtrim()
					+"\n      , SUM( A.SALE_UPRC )                                    AS SALE_UPRC                                                                                        ".rtrim()  // 2019-04-24-SHK [정렬방식]
					+"\n      , MAX( ( SELECT COM_CD_NM AS ORG_PLACE_NM FROM SCD_CODEM_T WHERE SHOP_CD = '%s' AND COM_CD_FG = '003' AND COM_CD = B.ORG_PLACE_CD ) ) AS ORG_PLACE_NM       ".rtrim()
					+"\n      , A.SALE_WEIGHT                                         AS SALE_WEIGHT                                                                                      ".rtrim()
					+"\n      , B.PRICE_MGR_FG                                        AS PRICE_MGR_FG                                                                                     ".rtrim()
					+"\n      , MIN(ORDER_DTL_NO)                                     AS ORDER_DTL_NO                                                                                     ".rtrim()  // 2019-04-24-SHK [정렬방식]
					+"\n      , A.SDS_ORG_DTL_NO                                      AS SDS_ORG_DTL_NO                                                                                   ".rtrim()  // 2019-04-24-SHK [정렬방식]
					+"\n      , B.PROD_NM                                             AS PROD_NM_TMP                                                                                      ".rtrim()  // 2019-04-24-SHK [정렬방식]
					+"\n      , B.SIDE_MENU_YN                                        AS SIDE_MENU_YN                                                                                     ".rtrim()  // 2019-07-23-SHK [정렬방식]
					+"\n      , A.CUP_SALE_CNT                                        AS CUP_SALE_CNT                                                                                     ".rtrim()  // 2019-07-23-SHK [정렬방식]
					+"\n      , A.CUP_DEPOSIT_UPRC                                    AS CUP_DEPOSIT_UPRC                                                                                     ".rtrim()  // 2019-07-23-SHK [정렬방식]
					+"\n      , A.CUP_FG                                              AS CUP_FG                                                                                     ".rtrim()  // 2019-07-23-SHK [정렬방식]
					+"\n FROM POS_ODDTL_T A                                                                                                                                               ".rtrim()  // 2019-04-24-SHK [정렬방식]
					+"\n    , SCD_PRODM_T B                                                                                                                                               ".rtrim()
					+"\n WHERE A.SHOP_CD   = '%s'                                                                                                                                         ".rtrim()
					+"\n AND   A.SALE_DATE = '%s'                                                                                                                                         ".rtrim()
					+"\n AND   A.ORDER_NO  = '%s'                                                                                                                                         ".rtrim()
					+"\n AND   B.SHOP_CD   = A.SHOP_CD                                                                                                                                    ".rtrim()
					+"\n AND   B.PROD_CD   = A.PROD_CD                                                                                                                                    ".rtrim()
					+"\n GROUP BY A.PROD_CD                                                                                                                                               ".rtrim()
					+"\n        , B.PROD_NM                                                                                                                                               ".rtrim()
					+"\n        , A.SALE_UPRC                                                                                                                                             ".rtrim()
					+"\n        , A.PROP_CD                                                                                                                                               ".rtrim()  // 2016-09-27-JYL [곱빼기]
					+"\n        , B.PRICE_MGR_FG                                                                                                                                          ".rtrim()  // 2018-06-05-HJH
					+"\n 		, A.SALE_WEIGHT	                                                                                                                                          ".rtrim()  // 2018-0601-HJH
					+"\n 		, A.SDS_ORG_DTL_NO                                                                                                                                        ".rtrim()  // 2019-04-24-SHK [정렬방식]
					+"\n 		, B.SIDE_MENU_YN                                                                                                                                          ".rtrim()  // 2019-07-23-SHK [정렬방식]
					+"\n HAVING ( SUM( A.SALE_QTY ) <> 0 ) OR ( SUM( A.DCM_SALE_AMT ) <> 0 )                                                                                              ".rtrim()
					+"\n ORDER BY MIN( A.ORDER_DTL_NO )                                                                                                                                   ".rtrim()
				;
				csSubQrySql = csSubQrySql.sprintf( obj.SHOP_CD, obj.SHOP_CD, obj.SALE_DATE, obj.ORDER_NO );

			} else {
				// 매출
				csQrySql = ""
					+"\n SELECT A.PROD_CD                                                                  AS PROD_CD     ".rtrim()
					+"\n      , LTRIM( CASE WHEN A.TAX_YN = 'N' THEN '*' ELSE '' END || B.PROD_NM )        AS PROD_NM     ".rtrim()
					+"\n      , A.NORMAL_UPRC                                                              AS NORMAL_UPRC ".rtrim()
					+"\n      , A.SALE_UPRC                                                                AS UPRC        ".rtrim()
					+"\n      , CASE WHEN A.SALE_YN = 'N' THEN A.SALE_QTY     * -1 ELSE A.SALE_QTY     END AS QTY         ".rtrim()
					+"\n      , CASE WHEN A.SALE_YN = 'N' THEN A.DC_AMT       * -1 ELSE A.DC_AMT       END AS DC_AMT      ".rtrim()
					+"\n      , CASE WHEN A.SALE_YN = 'N' THEN A.DCM_SALE_AMT * -1 ELSE A.DCM_SALE_AMT END AS AMT         ".rtrim()
					+"\n      , A.PROP_CD                                                                  AS PROP_CD     ".rtrim()  // 2016-09-27-JYL [곱빼기]
					+"\n FROM SSL_TRDTL_T A                                                                               ".rtrim()
					+"\n      INNER JOIN SCD_PRODM_T B                                                                    ".rtrim()
					+"\n            ON  A.SHOP_CD = B.SHOP_CD                                                             ".rtrim()
					+"\n            AND A.PROD_CD = B.PROD_CD                                                             ".rtrim()
					+"\n WHERE A.SHOP_CD   = '%s'                                                                         ".rtrim()
					+"\n AND   A.SALE_DATE = '%s'                                                                         ".rtrim()
					+"\n AND   A.POS_NO    = '%s'                                                                         ".rtrim()
					+"\n AND   A.BILL_NO   = '%s'                                                                         ".rtrim()
					+"\n ORDER BY A.DTL_NO                                                                                ".rtrim()
				;
				csQrySql = csQrySql.sprintf( obj.SHOP_CD,  obj.SALE_DATE, obj.POS_NO, obj.BILL_NO );

			}

		} else {
			if( SHOP_ENV [ 539 ]== 1 ) {
				csSubQuery1 =  ", %s \r\n , %s ".sprintf( "A.FLOOR_PRT_YN", "A.POS_PRT_YN" );
				csSubQuery2 =  ", %s \r\n , %s ".sprintf( "B.FLOOR_PRT_YN", "B.POS_PRT_YN" );
			}

			var strOption584_1 = "", strOption584_2= "", strOption584Group = "";
			if(SHOP_ENV [ 584 ]== 0) {
				strOption584_1 = " COUNT( PROD_CD ) AS ORDER_CNT ";
				strOption584_2 = " <= ";

			} else {
				strOption584_1 = " ORDER_SEQ_NO AS ORDER_CNT ";
				strOption584_2 = " = ";
				strOption584Group = " , ORDER_CNT ";
			}
			// 포스형태 : 외식-푸드코트용
			if( SHOP_ENV [ 101 ] == 4 ) {
				
				if ( obj.blPreOrderFg == true ) {
					csSubQrySql = this.GetProductListData_04_SQL_SHOP_ENV_101_TRUE_blPreOrderFg_TRUE;
					csSubQrySql = csSubQrySql.sprintf( csSubQuery1 , csSubQuery1 , obj.PRT_NO , obj.SHOP_CD , obj.SALE_DATE , obj.ORDER_NO , csSubQuery2 , obj.PRT_NO , obj.SHOP_CD , obj.SALE_DATE , obj.ORDER_NO , m_csOrderDtlNo , obj.SHOP_CD , obj.SALE_DATE , obj.ORDER_NO , obj.SHOP_CD , csSubQuery1 );
					csQrySql = "SELECT * FROM (%s) %s".sprintf( csSubQrySql, this.GetOrderByQuery_04(SHOP_ENV, ""));		// 2019-04-24-SHK [정렬방식]
				} else {
					csSubQrySql = this.GetProductListData_04_SQL_SHOP_ENV_101_TRUE_blPreOrderFg_FALSE;
					csSubQrySql = csSubQrySql.sprintf( csSubQuery1 , csSubQuery1 , obj.PRT_NO , obj.SHOP_CD , obj.SALE_DATE , obj.ORDER_NO , obj.ORDER_SEQ_NO , csSubQuery2 , obj.PRT_NO , obj.SHOP_CD , obj.SALE_DATE , obj.ORDER_NO
							, obj.ORDER_SEQ_NO , obj.csChgBillNo  , m_csOrderDtlNo , strOption584_1  , obj.SHOP_CD  , obj.SALE_DATE , obj.ORDER_NO , strOption584_2 , obj.ORDER_SEQ_NO , strOption584Group  , obj.SHOP_CD );
					csQrySql = "SELECT * FROM (%s) %s".sprintf( csSubQrySql, this.GetOrderByQuery_04(SHOP_ENV, "") );
				}
			} else {
				if ( obj.blPreOrderFg == true ) {
					csSubQrySql = this.GetProductListData_04_SQL_SHOP_ENV_101_FALSE_blPreOrderFg_TRUE;
					csSubQrySql = csSubQrySql.sprintf( csSubQuery1 , csSubQuery1 , obj.csPrtNo, obj.csSHOP_CD, obj.csSALE_DATE, obj.csORDER_NO, csSubQuery2, obj.csPrtNo, obj.csSHOP_CD, obj.csSALE_DATE, obj.csORDER_NO, m_csOrderDtlNo, obj.csSHOP_CD, obj.csSALE_DATE, obj.csORDER_NO, obj.csSHOP_CD, csSubQuery1 ); 
					csQrySql = "SELECT * FROM (%s) %s".sprintf( csSubQrySql, this.GetOrderByQuery_04(SHOP_ENV, "")  );		// 2019-04-24-SHK [정렬방식]
				} else {
					csSubQrySql = this.GetProductListData_04_SQL_SHOP_ENV_101_FALSE_blPreOrderFg_FALSE ;
					csSubQrySql = csSubQrySql.sprintf( csSubQuery1, csSubQuery1, obj.PRT_NO, obj.SHOP_CD, obj.SALE_DATE, obj.ORDER_NO, obj.ORDER_SEQ_NO, csSubQuery2, obj.PRT_NO, obj.SHOP_CD, obj.SALE_DATE, obj.ORDER_NO, obj.ORDER_SEQ_NO, m_csOrderDtlNo, strOption584_1, obj.SHOP_CD, obj.SALE_DATE, obj.ORDER_NO, strOption584_2, obj.ORDER_SEQ_NO, strOption584Group, obj.SHOP_CD, csSubQuery1  );
					csQrySql ="SELECT * FROM (%s) %s".sprintf( csSubQrySql, this.GetOrderByQuery_04(SHOP_ENV, "") );			// 2019-04-24-SHK [정렬방식]
				}
			}
			return csQrySql;

		}  //end pbSales == true
	}

	////////////////////////////////////////////////////////////////////////////////
	// 2019-04-24-SHK [정렬방식] : 정렬방식에 따른 ORDER BY 쿼리문 리턴
	////////////////////////////////////////////////////////////////////////////////	
	this.GetOrderByQuery_04 = function(SHOP_ENV , csOrderDtlNoColumnName) {
		var inOrderBy  = SHOP_ENV[ 682 ] ;
		var csOrderByQuery = "" ; /** CString **/
		var csOrderByColumn = "" ; /** CString **/
		var csAscending = "ASC" ; /** CString **/
		switch(parseInt( inOrderBy)) {
			case 1:		// 상품명
				csOrderByColumn = "PROD_NM";
				break;
			case 2:		// 상품코드
				csOrderByColumn = "PROD_CD";
				break;
			case 3:		// 금액
				csOrderByColumn = "SALE_AMT";
				csAscending = "DESC";
				break;
			case 4:		// 수량
				csOrderByColumn = "QTY";
				csAscending = "DESC";
				break;
			case 6:		// 상품명-역순
				csOrderByColumn = "PROD_NM";
				csAscending = "DESC";
				break;
			case 7:		// 상품코드-역순
				csOrderByColumn = "PROD_CD";
				csAscending = "DESC";
				break;
			case 8:		// 금액-역순
				csOrderByColumn = "SALE_AMT";
				break;
			case 9:		// 수량-역순
				csOrderByColumn = "QTY";
				break;
		}
		util.logDebug("!!!!!!!!!!!!!!!!!!!!!! GetOrderByQuery_04 ======>>>>>>> inOrderBy====>> " + inOrderBy);
		util.logDebug("!!!!!!!!!!!!!!!!!!!!!! GetOrderByQuery_04 ======>>>>>>> csOrderDtlNoColumnName====>> " + csOrderDtlNoColumnName);
		util.logDebug("!!!!!!!!!!!!!!!!!!!!!! GetOrderByQuery_04 ======>>>>>>> csOrderByColumn====>> " + csOrderByColumn);
		util.logDebug("!!!!!!!!!!!!!!!!!!!!!! GetOrderByQuery_04 ======>>>>>>> csAscending====>> " + csAscending);

		if(!csOrderDtlNoColumnName){
			csOrderDtlNoColumnName = "ORDER_DTL_NO";
		}
		
		if (inOrderBy == 0) {		// 주문
			csOrderByQuery   = "\n ORDER BY SDS_ORG_DTL_NO,  %s".sprintf( csOrderDtlNoColumnName );
		} else if(inOrderBy == 5) {	// 주문-역순
			csOrderByQuery  = ( "\n ORDER BY SDS_ORG_DTL_NO "
									+"\n , CASE WHEN SDS_ORG_DTL_NO <> '' AND SDS_ORG_DTL_NO IS NOT NULL THEN %s END ASC "
									+"\n , CASE WHEN SDS_ORG_DTL_NO = '' OR SDS_ORG_DTL_NO IS NULL THEN %s END DESC").sprintf( csOrderDtlNoColumnName, csOrderDtlNoColumnName);
		} else {
			csOrderByQuery = ( "\n ORDER BY SDS_ORG_DTL_NO "
					+ "\n , CASE WHEN SDS_ORG_DTL_NO IS NOT NULL THEN %s END ASC" 
					+ "\n , CASE WHEN SDS_ORG_DTL_NO IS NULL THEN %s END %s "
					+ "\n , %s").sprintf( csOrderDtlNoColumnName, csOrderByColumn, csAscending, csOrderDtlNoColumnName);
		}
		util.logDebug("!!!!!!!!!!!!!!!!!!!!!! GetOrderByQuery_04 ======>>>>>>> csOrderByQuery====>> \n" + csOrderByQuery);
		return csOrderByQuery;
		
		
	}

		this.GetProductListData_04_SQL_SHOP_ENV_101_FALSE_blPreOrderFg_FALSE = ""
			+"\n SELECT A.PROD_CD                AS PROD_CD                                                                                                                                        ".rtrim()  // 2019-04-24-SHK [정렬방식]
			+"\n      , A.PROD_NM                AS PROD_NM                                                                                                                                        ".rtrim()
			+"\n      , A.SIDE_MENU_YN           AS SIDE_MENU_YN                                                                                                                                   ".rtrim()
			+"\n      , A.SDS_ORG_DTL_NO         AS SDS_ORG_DTL_NO                                                                                                                                 ".rtrim()
			+"\n      , A.UPRC                   AS UPRC                                                                                                                                           ".rtrim()
			+"\n      , A.SDA_CD                 AS SDA_CD                                                                                                                                         ".rtrim()
			+"\n      , SUM( A.QTY )             AS QTY                                                                                                                                            ".rtrim()
			+"\n      , A.SALE_AMT               AS SALE_AMT                                                                                                                                       ".rtrim()  // 2019-04-24-SHK [정렬방식]
			+"\n      , SD.SDA_NM                AS SDA_NM                                                                                                                                         ".rtrim()
			+"\n      , A.PRICE_MGR_YN           AS PRICE_MGR_YN                                                                                                                                   ".rtrim()
			+"\n      , A.ORDER_CNT              AS ORDER_CNT                                                                                                                                      ".rtrim()
			+"\n      , A.DLV_PACK_FG            AS DLV_PACK_FG                                                                                                                                    ".rtrim()
			+"\n      , A.PROP_CD                AS PROP_CD                                                                                                                                        ".rtrim()  // 2016-09-27-JYL [곱빼기]
			+"\n      , A.SET_PROD_FG            AS SET_PROD_FG                                                                                                                                    ".rtrim()
			+"\n      , A.SVC_FG                 AS SVC_FG                                                                                                                                         ".rtrim()
			+"\n      , A.COOK_MEMO              AS COOK_MEMO                                                                                                                                      ".rtrim()
			+"\n      , MIN(ORDER_DTL_NO)        AS ORDER_DTL_NO                                                                                                                                   ".rtrim()  // 2019-04-24-SHK [정렬방식]
			+"\n      , A.CUP_SALE_CNT           AS CUP_SALE_CNT                                                                                                                                   ".rtrim()
			+"\n      , A.CUP_DEPOSIT_UPRC       AS CUP_DEPOSIT_UPRC                                                                                                                               ".rtrim()
			+"\n      , A.CUP_FG                 AS CUP_FG                                                                                                                                         ".rtrim()
			+"\n        %s                                                                                                                                                                         ".rtrim()
			+"\n FROM ( SELECT A.ORDER_DTL_NO                                                                                                                                                      ".rtrim()
			+"\n             , A.PROD_CD                                                                                                                                                           ".rtrim()
			+"\n             , A.PROD_NM                                                                                                                                                           ".rtrim()
			+"\n             , A.SIDE_MENU_YN                                                                                                                                                      ".rtrim()
			+"\n             , A.SDS_ORG_DTL_NO                                                                                                                                                    ".rtrim()
			+"\n             , A.UPRC                                                                                                                                                              ".rtrim()
			+"\n             , A.SDA_CD                                                                                                                                                            ".rtrim()
			+"\n             , A.QTY                                                                                                                                                               ".rtrim()
			+"\n             , A.SALE_AMT                                                                                                                                                          ".rtrim()
			+"\n             , A.PRICE_MGR_YN                                                                                                                                                      ".rtrim()
			+"\n             , B.ORDER_CNT                                                                                                                                                         ".rtrim()
			+"\n             , A.DLV_PACK_FG                                                                                                                                                       ".rtrim()
			+"\n             , A.PROP_CD                                                                                                                                                           ".rtrim()  // 2016-09-27-JYL [곱빼기]
			+"\n             , A.SET_PROD_FG                                                                                                                                                       ".rtrim()
			+"\n             , A.SVC_FG                                                                                                                                                            ".rtrim()
			+"\n             , A.COOK_MEMO                                                                                                                                                         ".rtrim()
			+"\n             , A.CUP_SALE_CNT                                                                                                                                                      ".rtrim()
			+"\n             , A.CUP_DEPOSIT_UPRC                                                                                                                                                  ".rtrim()
			+"\n             , A.CUP_FG                                                                                                                                                            ".rtrim()
			+"\n             %s                                                                                                                                                                    ".rtrim()
			+"\n        FROM ( SELECT *                                                                                                                                                            ".rtrim()
			+"\n               FROM ( SELECT A.ORDER_DTL_NO                                                                                                                                        ".rtrim()
			+"\n                                                     , A.PROD_CD                                                                                                                   ".rtrim()
			+"\n                                                     , CASE WHEN B.PROD_NM is NULL THEN ( SELECT SDA_NM    AS PROD_NM                                                              ".rtrim()
//			+"\n                                                                FROM SP_GET_SDA_NM ( A.SHOP_CD, SUBSTR( A.PROD_CD, 4, 6 ) ) )                                                      ".rtrim()
				+"\n                                                FROM (                                                                                                            ".rtrim()
				+ this.SP_GET_SDA_NM_SQL( " A.SHOP_CD" , " SUBSTR( A.PROD_CD, 4, 6 ) " )
				+"\n                                                 )        )                                                                                                        ".rtrim()
			

			+"\n                                  ELSE B.PROD_NM END AS PROD_NM                                                                                                                    ".rtrim()
			+"\n                                                     , CASE WHEN B.PROD_NM is NULL THEN 'N'                                                                                        ".rtrim()
			+"\n                                  ELSE B.SIDE_MENU_YN END AS SIDE_MENU_YN                                                                                                          ".rtrim()
			+"\n                                                     , A.SDS_ORG_DTL_NO                                                                                                            ".rtrim()
			+"\n                                                     , A.SALE_UPRC AS UPRC                                                                                                         ".rtrim()
			+"\n                                                     , A.SDA_CD                                                                                                                    ".rtrim()
			+"\n                                                     , A.SALE_QTY AS QTY                                                                                                           ".rtrim()
			+"\n                                                     , A.SALE_AMT AS SALE_AMT                                                                                                      ".rtrim()
			+"\n                                                     , CASE WHEN B.PRICE_MGR_FG = '1' THEN 'Y' ELSE 'N' END AS PRICE_MGR_YN                                                        ".rtrim()
			+"\n                                                     , A.DLV_PACK_FG                                                                                                               ".rtrim()
			+"\n                                                     , A.PROP_CD                                                                                                                   ".rtrim()  // 2016-09-27-JYL [곱빼기]
			+"\n                                                     , CASE WHEN B.PROD_NM is NULL THEN '0'                                                                                        ".rtrim()
			+"\n                                  ELSE B.SET_PROD_FG END AS SET_PROD_FG                                                                                                            ".rtrim()
			+"\n                                                     , CASE WHEN A.DC_AMT_SVC <> 0  THEN 'Y' ELSE 'N' END AS SVC_FG                                                                ".rtrim()
			+"\n                                                     , CASE WHEN ( ( C.PRT_NO IS NULL ) AND SUBSTR( A.PROD_CD, 1, 1 ) = 'A' ) THEN ( SELECT F.PRT_NO                               ".rtrim()
			+"\n                                                                                                                                     FROM POS_ODDTL_T D                            ".rtrim()
			+"\n                                                                                                                                          LEFT OUTER JOIN SCD_PRODM_T E            ".rtrim()
			+"\n                                                                                                                                          ON  E.SHOP_CD = D.SHOP_CD                ".rtrim()
			+"\n                                                                                                                                          AND E.PROD_CD = D.PROD_CD                ".rtrim()
			+"\n                                                                                                                                          LEFT OUTER JOIN SCD_PRTPR_T F            ".rtrim()
			+"\n                                                                                                                                          ON  F.SHOP_CD = D.SHOP_CD                ".rtrim()
			+"\n                                                                                                                                          AND F.PROD_CD = D.PROD_CD                ".rtrim()
			+"\n                                                                                                                                          AND F.PRT_NO  = '%s'                     ".rtrim()
			+"\n                                                                                                                                     WHERE D.SHOP_CD        = '%s'                 ".rtrim()
			+"\n                                                                                                                                     AND   D.SALE_DATE      = '%s'                 ".rtrim()
			+"\n                                                                                                                                     AND   D.ORDER_NO       = '%s'                 ".rtrim()
			+"\n                                                                                                                                     AND   D.ORDER_SEQ_NO   = '%s'                 ".rtrim()
			+"\n                                                                                                                                     AND   D.SDS_ORG_DTL_NO = A.SDS_ORG_DTL_NO     ".rtrim()
			+"\n                                                                                                                                     AND   E.SIDE_MENU_YN   = 'Y' )                ".rtrim()
			+"\n                                  ELSE C.PRT_NO END AS PRT_NO                                                                                                                      ".rtrim()
			+"\n                            , A.COOK_MEMO                                                                                                                                          ".rtrim()
			+"\n                            , A.CUP_SALE_CNT                                                                                                                                       ".rtrim()
			+"\n                            , A.CUP_DEPOSIT_UPRC                                                                                                                                   ".rtrim()
			+"\n                            , A.CUP_FG                                                                                                                                             ".rtrim()
			+"\n                              %s                                                                                                                                                   ".rtrim()
			+"\n                                            FROM POS_ODDTL_T A                                                                                                                     ".rtrim()
			+"\n                                                     LEFT OUTER JOIN SCD_PRODM_T B                                                                                                 ".rtrim()
			+"\n                                                     ON  B.SHOP_CD = A.SHOP_CD                                                                                                     ".rtrim()
			+"\n                                                     AND B.PROD_CD = A.PROD_CD                                                                                                     ".rtrim()
			+"\n                                                     LEFT OUTER JOIN SCD_PRTPR_T C                                                                                                 ".rtrim()
			+"\n                                                     ON  C.SHOP_CD = A.SHOP_CD                                                                                                     ".rtrim()
			+"\n                                                     AND C.PROD_CD = A.PROD_CD                                                                                                     ".rtrim()
			+"\n                                                     AND C.PRT_NO  = '%s'                                                                                                          ".rtrim()
			+"\n                                        WHERE A.SHOP_CD      = '%s'                                                                                                                ".rtrim()
			+"\n                                            AND   A.SALE_DATE    = '%s'                                                                                                            ".rtrim()
			+"\n                                            AND   A.ORDER_NO     = '%s'                                                                                                            ".rtrim()
			+"\n                                            AND   A.ORDER_SEQ_NO = '%s'                                                                                                            ".rtrim()
			+"\n                      AND   A.ORDER_DTL_NO LIKE '%s' )                                                                                                                             ".rtrim()
			+"\n                                 WHERE PRT_NO IS NOT NULL ) A                                                                                                                      ".rtrim()
			+"\n           , ( SELECT PROD_CD, PROP_CD,                                                                                                                                            ".rtrim()
			+"\n                                         %s                                                                                                                                        ".rtrim()  // 2017-11-22-BGM [곱빼기_구문표기_수정건]
			+"\n               FROM POS_ODDTL_T                                                                                                                                                    ".rtrim()
			+"\n               WHERE SHOP_CD       = '%s'                                                                                                                                          ".rtrim()
			+"\n               AND   SALE_DATE     = '%s'                                                                                                                                          ".rtrim()
			+"\n               AND   ORDER_NO      = '%s'                                                                                                                                          ".rtrim()
			+"\n               AND   ORDER_SEQ_NO %s '%s'                                                                                                                                          ".rtrim()
			+"\n               GROUP BY PROD_CD, PROP_CD %s) B                                                                                                                                     ".rtrim()  // 2017-11-22-BGM [곱빼기_구문표기_수정건]
			+"\n        WHERE A.PROD_CD = B.PROD_CD                                                                                                                                                ".rtrim()  // 2017-11-22-BGM [곱빼기_구문표기_수정건]
			+"\n          AND IFNULL(A.PROP_CD , '0')  = IFNULL(B.PROP_CD , '0')     ) A                                                                                                            ".rtrim()  // 2017-11-22-BGM [곱빼기_구문표기_수정건]
			+"\n      LEFT OUTER JOIN SCD_SDACD_T SD                                                                                                                                               ".rtrim()
			+"\n      ON SD.SHOP_CD = '%s'                                                                                                                                                         ".rtrim()
			+"\n      AND SD.SDA_CD = A.SDA_CD                                                                                                                                                     ".rtrim()
			+"\n GROUP BY A.PROD_CD                                                                                                                                                                ".rtrim()
			+"\n        , A.PROD_NM                                                                                                                                                                ".rtrim()
			+"\n        , A.SIDE_MENU_YN                                                                                                                                                           ".rtrim()
			+"\n        , A.SDS_ORG_DTL_NO                                                                                                                                                         ".rtrim()
			+"\n        , A.UPRC                                                                                                                                                                   ".rtrim()
			+"\n        , A.SDA_CD                                                                                                                                                                 ".rtrim()
			+"\n        , SD.SDA_NM                                                                                                                                                                ".rtrim()
			+"\n        , A.PRICE_MGR_YN                                                                                                                                                           ".rtrim()
			+"\n        , A.SALE_AMT                                                                                                                                                               ".rtrim()
			+"\n        , A.ORDER_CNT                                                                                                                                                              ".rtrim()
			+"\n        , A.DLV_PACK_FG                                                                                                                                                            ".rtrim()
			+"\n        , A.PROP_CD                                                                                                                                                                ".rtrim()  // 2016-09-27-JYL [곱빼기]
			+"\n        , A.SET_PROD_FG                                                                                                                                                            ".rtrim()
			+"\n        , A.SVC_FG                                                                                                                                                                 ".rtrim()
			+"\n          %s                                                                                                                                                                       ".rtrim()
			+"\n        , A.COOK_MEMO                                                                                                                                                              ".rtrim()
			+"\n HAVING ( SUM( A.QTY ) <> 0 ) OR ( SUM( A.SALE_AMT ) <> 0 )                                                                                                                        ".rtrim()
			+"\n ORDER BY MIN( A.ORDER_DTL_NO )                                                                                                                                                    ".rtrim()
		;

		this.GetProductListData_04_SQL_SHOP_ENV_101_FALSE_blPreOrderFg_TRUE = ""
			+"\n  SELECT A.PROD_CD                                                                        AS PROD_CD                                                 ".rtrim()
			+"\n       , A.PROD_NM                                                                        AS PROD_NM                                                 ".rtrim()
			+"\n       , A.SIDE_MENU_YN                                                                   AS SIDE_MENU_YN                                            ".rtrim()
			+"\n       , CASE WHEN A.SDS_CD  != ''  AND A.SDS_CD IS NOT NULL THEN   1 ELSE CASE WHEN A.SDA_CD  != '' AND A.SDA_CD IS NOT NULL THEN 1 END END AS SDS_ORG_DTL_NO                                          ".rtrim()
			+"\n       , ''                                                                               AS UPRC                                                    ".rtrim()
			+"\n       , A.SDA_CD                                                                         AS SDA_CD                                                  ".rtrim()
			+"\n       , SUM(CAST(A.QTY AS NUMERIC(3,0)))                                                 AS QTY                                                     ".rtrim()
			+"\n       , A.SALE_AMT                                                                       AS SALE_AMT                                                ".rtrim()       // 2019-04-24-SHK [정렬방식]
			+"\n       , SD.SDA_NM                                                                        AS SDA_NM                                                  ".rtrim()
			+"\n       , A.PRICE_MGR_YN                                                                   AS PRICE_MGR_YN                                            ".rtrim()
			+"\n       , A.ORDER_CNT                                                                      AS ORDER_CNT                                               ".rtrim()
			+"\n       , ''                                                                               AS DLV_PACK_FG                                             ".rtrim()
			+"\n       , ''                                                                               AS PROP_CD                                                 ".rtrim()
			+"\n       , A.SET_PROD_FG                                                                                                                               ".rtrim()
			+"\n       , '' AS SVC_FG                                                                                                                                ".rtrim()
			+"\n       , '' AS COOK_MEMO                                                                                                                             ".rtrim()
			+"\n      , MIN(ORDER_DTL_NO) AS ORDER_DTL_NO                                                                                                            ".rtrim()       // 2019-04-24-SHK [정렬방식]
			+"\n         %s                                                                                                                                          ".rtrim()
			+"\n  FROM ( SELECT A.ORDER_DTL_NO                                                                                                                       ".rtrim()
			+"\n              , A.PROD_CD                                                                                                                            ".rtrim()
			+"\n              , A.PROD_NM                                                                                                                            ".rtrim()
			+"\n              , A.SIDE_MENU_YN                                                                                                                       ".rtrim()
			+"\n              , A.SDS_CD                                                                                                                             ".rtrim()
			+"\n              , A.SDA_CD                                                                                                                             ".rtrim()
			+"\n              , A.QTY                                                                                                                                ".rtrim()
			+"\n              , A.SALE_AMT                                                                                                                           ".rtrim()
			+"\n              , A.PRICE_MGR_YN                                                                                                                       ".rtrim()
			+"\n              , B.ORDER_CNT                                                                                                                          ".rtrim()
			+"\n              , A.SET_PROD_FG                                                                                                                        ".rtrim()
			+"\n                %s                                                                                                                                   ".rtrim()
			+"\n         FROM ( SELECT *                                                                                                                             ".rtrim()
			+"\n                FROM ( SELECT A.ORDER_DTL_NO                                                                                                         ".rtrim()
			+"\n                              , A.PROD_CD                                                                                                            ".rtrim()
			+"\n                              , CASE WHEN B.PROD_NM is NULL THEN ( SELECT SDA_NM    AS PROD_NM                                                       ".rtrim()
			//+"\n                                                                 FROM SP_GET_SDA_NM ( A.SHOP_CD, SUBSTR( A.PROD_CD, 4, 6 ) ) )                       ".rtrim()
				+"\n                                                FROM (                                                                                                            ".rtrim()
				+ this.SP_GET_SDA_NM_SQL( " A.SHOP_CD" , " SUBSTR( A.PROD_CD, 4, 6 ) " )
				+"\n                                                         )                                                                                                        ".rtrim()

			+"\n                                   ELSE B.PROD_NM END AS PROD_NM                                                                                     ".rtrim()
			+"\n                              , CASE WHEN B.PROD_NM is NULL THEN 'N'                                                                                 ".rtrim()
			+"\n                                   ELSE B.SIDE_MENU_YN END AS SIDE_MENU_YN                                                                           ".rtrim()
			+"\n                              , A.SDS_CD                                                                                                             ".rtrim()
			+"\n                              , A.SDA_CD                                                                                                             ".rtrim()
			+"\n                              , A.SALE_QTY AS QTY                                                                                                    ".rtrim()
			+"\n                              , A.SALE_AMT AS SALE_AMT                                                                                               ".rtrim()
			+"\n                              , CASE WHEN B.PRICE_MGR_FG = '1' WHEN 'Y' ELSE 'N' END AS PRICE_MGR_YN                                                 ".rtrim()
			+"\n                              , CASE WHEN B.PROD_NM is NULL THEN '0'                                                                                 ".rtrim()
			+"\n                                   ELSE B.SET_PROD_FG END AS SET_PROD_FG                                                                             ".rtrim()
			+"\n                              , CASE WHEN ( ( C.PRT_NO IS NULL ) AND SUBSTR( A.PROD_CD, 1, 1 ) = 'A' ) THEN ( SELECT F.PRT_NO                        ".rtrim()
			+"\n                                                                                                              FROM POS_PODTL_T D                     ".rtrim()
			+"\n                                                                                                                   LEFT OUTER JOIN SCD_PRODM_T E     ".rtrim()
			+"\n                                                                                                                   ON  E.SHOP_CD = D.SHOP_CD         ".rtrim()
			+"\n                                                                                                                   AND E.PROD_CD = D.PROD_CD         ".rtrim()
			+"\n                                                                                                                   LEFT OUTER JOIN SCD_PRTPR_T F     ".rtrim()
			+"\n                                                                                                                   ON  F.SHOP_CD = D.SHOP_CD         ".rtrim()
			+"\n                                                                                                                   AND F.PROD_CD = D.PROD_CD         ".rtrim()
			+"\n                                                                                                                   AND F.PRT_NO  = '%s'              ".rtrim()
			+"\n                                                                                                              WHERE D.SHOP_CD        = '%s'          ".rtrim()
			+"\n                                                                                                              AND   D.ORDER_DATE      = '%s'         ".rtrim()
			+"\n                                                                                                              AND   D.PRE_ORDER_NO       = '%s'      ".rtrim()
			+"\n                                                                                                              AND   E.SIDE_MENU_YN   = 'Y' )         ".rtrim()
			+"\n                                   ELSE C.PRT_NO END AS PRT_NO                                                                                       ".rtrim()
			+"\n                                   %s                                                                                                                ".rtrim()
			+"\n                         FROM POS_PODTL_T A                                                                                                          ".rtrim()
			+"\n                              LEFT OUTER JOIN SCD_PRODM_T B                                                                                          ".rtrim()
			+"\n                              ON  B.SHOP_CD = A.SHOP_CD                                                                                              ".rtrim()
			+"\n                              AND B.PROD_CD = A.PROD_CD                                                                                              ".rtrim()
			+"\n                              LEFT OUTER JOIN SCD_PRTPR_T C                                                                                          ".rtrim()
			+"\n                              ON  C.SHOP_CD = A.SHOP_CD                                                                                              ".rtrim()
			+"\n                              AND C.PROD_CD = A.PROD_CD                                                                                              ".rtrim()
			+"\n                              AND C.PRT_NO  = '%s'                                                                                                   ".rtrim()
			+"\n                         WHERE A.SHOP_CD      = '%s'                                                                                                 ".rtrim()
			+"\n                         AND   A.ORDER_DATE    = '%s'                                                                                                ".rtrim()
			+"\n                         AND   A.PRE_ORDER_NO     = '%s'                                                                                             ".rtrim()
			+"\n                       AND   A.ORDER_DTL_NO LIKE '%s' )                                                                                              ".rtrim()
			+"\n                  WHERE PRT_NO IS NOT NULL ) A                                                                                                       ".rtrim()
			+"\n            , ( SELECT PROD_CD,                                                                                                                      ".rtrim()
			+"\n                        COUNT( PROD_CD ) AS ORDER_CNT                                                                                                ".rtrim()
			+"\n                FROM POS_PODTL_T                                                                                                                     ".rtrim()
			+"\n                WHERE SHOP_CD       = '%s'                                                                                                           ".rtrim()
			+"\n                AND   ORDER_DATE     = '%s'                                                                                                          ".rtrim()
			+"\n                AND   PRE_ORDER_NO      = '%s'                                                                                                       ".rtrim()
			+"\n                GROUP BY PROD_CD ) B                                                                                                                 ".rtrim()
			+"\n         WHERE A.PROD_CD = B.PROD_CD ) A                                                                                                             ".rtrim()
			+"\n       LEFT OUTER JOIN SCD_SDACD_T SD                                                                                                                ".rtrim()
			+"\n       ON SD.SHOP_CD = '%s'                                                                                                                          ".rtrim()
			+"\n       AND SD.SDA_CD = A.SDA_CD                                                                                                                      ".rtrim()
			+"\n  GROUP BY A.PROD_CD                                                                                                                                 ".rtrim()
			+"\n         , A.PROD_NM                                                                                                                                 ".rtrim()
			+"\n         , A.SIDE_MENU_YN                                                                                                                            ".rtrim()
			+"\n         , A.SDS_CD                                                                                                                                  ".rtrim()
			+"\n         , A.SDA_CD                                                                                                                                  ".rtrim()
			+"\n         , SD.SDA_NM                                                                                                                                 ".rtrim()
			+"\n         , A.PRICE_MGR_YN                                                                                                                            ".rtrim()
			+"\n         , A.SALE_AMT                                                                                                                                ".rtrim()
			+"\n         , A.ORDER_CNT                                                                                                                               ".rtrim()
			+"\n         , A.SET_PROD_FG                                                                                                                             ".rtrim()
			+"\n           %s                                                                                                                                        ".rtrim()
			+"\n  ORDER BY MIN( A.ORDER_DTL_NO )                                                                                                                     ".rtrim()
		;
		this.GetProductListData_04_SQL_SHOP_ENV_101_TRUE_blPreOrderFg_FALSE = ""
			  +"\n SELECT A.PROD_CD              AS PROD_CD                                                                                                                       ".rtrim()  // 2019-04-24-SHK [정렬방식]
			  +"\n      , A.PROD_NM              AS PROD_NM                                                                                                                       ".rtrim()  // 2019-04-24-SHK [정렬방식]
			  +"\n      , A.SIDE_MENU_YN         AS SIDE_MENU_YN                                                                                                                  ".rtrim()
			  +"\n      , A.SDS_ORG_DTL_NO       AS SDS_ORG_DTL_NO                                                                                                                ".rtrim()
			  +"\n      , A.UPRC                 AS UPRC                                                                                                                          ".rtrim()
			  +"\n      , A.SDA_CD               AS SDA_CD                                                                                                                        ".rtrim()
			  +"\n      , SUM( A.QTY )           AS QTY                                                                                                                           ".rtrim()
			  +"\n      , A.SALE_AMT             AS SALE_AMT                                                                                                                      ".rtrim()  // 2019-04-24-SHK [정렬방식]
			  +"\n      , SD.SDA_NM              AS SDA_NM                                                                                                                        ".rtrim()
			  +"\n      , A.PRICE_MGR_YN         AS PRICE_MGR_YN                                                                                                                  ".rtrim()
			  +"\n      , A.ORDER_CNT            AS ORDER_CNT                                                                                                                     ".rtrim()
			  +"\n      , A.DLV_PACK_FG          AS DLV_PACK_FG                                                                                                                   ".rtrim()
			  +"\n      , A.PROP_CD              AS PROP_CD                                                                                                                       ".rtrim()  // 2016-09-27-JYL [곱빼기]
			  +"\n      , A.SET_PROD_FG          AS SET_PROD_FG                                                                                                                   ".rtrim()
			  +"\n      , A.SVC_FG               AS SVC_FG                                                                                                                        ".rtrim()
			  +"\n      , A.COOK_MEMO            AS COOK_MEMO                                                                                                                     ".rtrim()
			  +"\n      , MIN(ORDER_DTL_NO)      AS ORDER_DTL_NO                                                                                                                  ".rtrim()  // 2019-04-24-SHK [정렬방식]
			  +"\n      , A.CUP_SALE_CNT         AS CUP_SALE_CNT                                                                                                                  ".rtrim()
			  +"\n      , A.CUP_DEPOSIT_UPRC     AS CUP_DEPOSIT_UPRC                                                                                                              ".rtrim()
			  +"\n      , A.CUP_FG               AS CUP_FG                                                                                                                        ".rtrim()
			  +"\n        %s                                                                                                                                                      ".rtrim()
			  +"\n FROM ( SELECT A.ORDER_DTL_NO                                                                                                                                   ".rtrim()
			  +"\n             , A.PROD_CD                                                                                                                                        ".rtrim()
			  +"\n             , A.PROD_NM                                                                                                                                        ".rtrim()
			  +"\n             , A.SIDE_MENU_YN                                                                                                                                   ".rtrim()
			  +"\n             , A.SDS_ORG_DTL_NO                                                                                                                                 ".rtrim()
			  +"\n             , A.UPRC                                                                                                                                           ".rtrim()
			  +"\n             , A.SDA_CD                                                                                                                                         ".rtrim()
			  +"\n             , A.QTY                                                                                                                                            ".rtrim()
			  +"\n             , A.SALE_AMT                                                                                                                                       ".rtrim()
			  +"\n             , A.PRICE_MGR_YN                                                                                                                                   ".rtrim()
			  +"\n             , B.ORDER_CNT                                                                                                                                      ".rtrim()
			  +"\n             , A.DLV_PACK_FG                                                                                                                                    ".rtrim()
			  +"\n             , A.PROP_CD                                                                                                                                        ".rtrim()  // 2016-09-27-JYL [곱빼기]
			  +"\n             , A.SET_PROD_FG                                                                                                                                    ".rtrim()
			  +"\n             , A.SVC_FG                                                                                                                                         ".rtrim()
			  +"\n             , A.COOK_MEMO                                                                                                                                      ".rtrim()
			  +"\n             , A.CUP_SALE_CNT                                                                                                                                                      ".rtrim()
			  +"\n             , A.CUP_DEPOSIT_UPRC                                                                                                                                                  ".rtrim()
			  +"\n             , A.CUP_FG                                                                                                                                                            ".rtrim()
			  +"\n               %s                                                                                                                                               ".rtrim()
			  +"\n        FROM ( SELECT *                                                                                                                                         ".rtrim()
			  +"\n               FROM ( SELECT A.ORDER_DTL_NO                                                                                                                     ".rtrim()
			  +"\n                           , A.PROD_CD                                                                                                                          ".rtrim()
			  +"\n                           , CASE WHEN B.PROD_NM is NULL THEN ( SELECT SDA_NM    AS PROD_NM                                                                     ".rtrim()
			  //+"\n                                                                FROM SP_GET_SDA_NM( A.SHOP_CD, SUBSTR( A.PROD_CD, 4, 6 ) ) )                                                     ".rtrim()
			  +"\n                                                FROM (                                                                                                          ".rtrim()
			  + this.SP_GET_SDA_NM_SQL( " A.SHOP_CD" , " SUBSTR( A.PROD_CD, 4, 6 ) " )
			  +"\n                                                    )     )                                                                                                      ".rtrim()

			  +"\n                                  ELSE B.PROD_NM END AS PROD_NM                                                                                                 ".rtrim()
			  +"\n                           , CASE WHEN B.PROD_NM is NULL THEN 'N'                                                                                               ".rtrim()
			  +"\n                                  ELSE B.SIDE_MENU_YN END AS SIDE_MENU_YN                                                                                       ".rtrim()
			  +"\n                           , A.SDS_ORG_DTL_NO                                                                                                                   ".rtrim()
			  +"\n                           , A.SALE_UPRC AS UPRC                                                                                                                ".rtrim()
			  +"\n                           , A.SDA_CD                                                                                                                           ".rtrim()
			  +"\n                           , A.SALE_QTY AS QTY                                                                                                                  ".rtrim()
			  +"\n                           , A.SALE_AMT AS SALE_AMT                                                                                                             ".rtrim()
			  +"\n                           , CASE WHEN B.PRICE_MGR_FG = '1' THEN 'Y' ELSE 'N' END AS PRICE_MGR_YN                                                               ".rtrim()
			  +"\n                           , A.DLV_PACK_FG                                                                                                                      ".rtrim()
			  +"\n                           , A.PROP_CD                                                                                                                          ".rtrim()  // 2016-09-27-JYL [곱빼기]
			  +"\n                           , CASE WHEN B.PROD_NM is NULL THEN '0'                                                                                               ".rtrim()
			  +"\n                                  ELSE B.SET_PROD_FG END AS SET_PROD_FG                                                                                         ".rtrim()
			  +"\n                           , CASE WHEN A.DC_AMT_SVC <> 0  THEN 'Y' ELSE 'N' END AS SVC_FG                                                                       ".rtrim()
			  +"\n                           , CASE WHEN ( ( C.PRT_NO IS NULL ) AND SUBSTR( A.PROD_CD, 1, 1 ) = 'A' ) THEN ( SELECT F.PRT_NO                                      ".rtrim()
			  +"\n                                                                                          FROM POS_ODDTL_T D                                                    ".rtrim()
			  +"\n                                                                                               LEFT OUTER JOIN SCD_PRODM_T E                                    ".rtrim()
			  +"\n                                                                                                                ON  E.SHOP_CD = D.SHOP_CD                       ".rtrim()
			  +"\n                                                                                               AND E.PROD_CD = D.PROD_CD                                        ".rtrim()
			  +"\n                                                                                               LEFT OUTER JOIN SCD_PRTPR_T F                                    ".rtrim()
			  +"\n                                                                                               ON  F.SHOP_CD = D.SHOP_CD                                        ".rtrim()
			  +"\n                                                                                               AND F.PROD_CD = D.PROD_CD                                        ".rtrim()
			  +"\n                                                                                               AND F.PRT_NO  = '%s'                                             ".rtrim()
			  +"\n                                                                                          WHERE D.SHOP_CD      = '%s'                                           ".rtrim()
			  +"\n                                                                                          AND   D.SALE_DATE    = '%s'                                           ".rtrim()
			  +"\n                                                                                          AND   D.ORDER_NO     = '%s'                                           ".rtrim()
			  +"\n                                                                                          AND   D.ORDER_SEQ_NO = '%s'                                           ".rtrim()
			  +"\n                                                                                          AND   D.SDS_ORG_DTL_NO = A.SDS_ORG_DTL_NO                             ".rtrim()
			  +"\n                                                                                          AND   E.SIDE_MENU_YN = 'Y' )                                          ".rtrim()
			  +"\n                                  ELSE C.PRT_NO END AS PRT_NO                                                                                                   ".rtrim()
			  +"\n                           , A.COOK_MEMO                                                                                                                        ".rtrim()
			  +"\n                           , A.CUP_SALE_CNT                                                                                                                                                      ".rtrim()
			  +"\n                           , A.CUP_DEPOSIT_UPRC                                                                                                                                                  ".rtrim()
			  +"\n                           , A.CUP_FG                                                                                                                                                            ".rtrim()
			  +"\n                             %s                                                                                                                                 ".rtrim()
			  +"\n        FROM POS_ODDTL_T A                                                                                                                                      ".rtrim()
			  +"\n                           LEFT OUTER JOIN SCD_PRODM_T B                                                                                                        ".rtrim()
			  +"\n          ON  B.SHOP_CD = A.SHOP_CD                                                                                                                             ".rtrim()
			  +"\n          AND B.PROD_CD = A.PROD_CD                                                                                                                             ".rtrim()
			  +"\n          LEFT OUTER JOIN SCD_PRTPR_T C                                                                                                                         ".rtrim()
			  +"\n          ON  C.SHOP_CD = A.SHOP_CD                                                                                                                             ".rtrim()
			  +"\n          AND C.PROD_CD = A.PROD_CD                                                                                                                             ".rtrim()
			  +"\n          AND C.PRT_NO  = '%s'                                                                                                                                  ".rtrim()
			  +"\n         WHERE A.SHOP_CD      = '%s'                                                                                                                            ".rtrim()
			  +"\n         AND   A.SALE_DATE    = '%s'                                                                                                                            ".rtrim()
			  +"\n         AND   A.ORDER_NO     = '%s'                                                                                                                            ".rtrim()
			  +"\n         AND   A.ORDER_SEQ_NO = '%s'                                                                                                                            ".rtrim()
			  +"\n         AND   A.CHG_BILL_NO  = '%s'                                                                                                                            ".rtrim()
			  +"\n                       AND   A.ORDER_DTL_NO LIKE '%s' )                                                                                                         ".rtrim()
			  +"\n      WHERE PRT_NO IS NOT NULL ) A                                                                                                                              ".rtrim()
			  +"\n           , ( SELECT PROD_CD,                                                                                                                                  ".rtrim()
			  +"\n                    %s                                                                                                                                          ".rtrim()
			  +"\n               FROM POS_ODDTL_T                                                                                                                                 ".rtrim()
			  +"\n               WHERE SHOP_CD       = '%s'                                                                                                                       ".rtrim()
			  +"\n               AND   SALE_DATE     = '%s'                                                                                                                       ".rtrim()
			  +"\n               AND   ORDER_NO      = '%s'                                                                                                                       ".rtrim()
			  +"\n               AND   ORDER_SEQ_NO %s '%s'                                                                                                                       ".rtrim()
			  +"\n               GROUP BY PROD_CD %s) B                                                                                                                           ".rtrim()
			  +"\n        WHERE A.PROD_CD = B.PROD_CD ) A                                                                                                                         ".rtrim()
			  +"\n      LEFT OUTER JOIN SCD_SDACD_T SD                                                                                                                            ".rtrim()
			  +"\n      ON  SD.SHOP_CD = '%s'                                                                                                                                     ".rtrim()
			  +"\n      AND SD.SDA_CD  = A.SDA_CD                                                                                                                                 ".rtrim()
			  +"\n GROUP BY A.PROD_CD                                                                                                                                             ".rtrim()
			  +"\n        , A.PROD_NM                                                                                                                                             ".rtrim()
			  +"\n        , A.SIDE_MENU_YN                                                                                                                                        ".rtrim()
			  +"\n        , A.SDS_ORG_DTL_NO                                                                                                                                      ".rtrim()
			  +"\n        , A.UPRC                                                                                                                                                ".rtrim()
			  +"\n        , A.SDA_CD                                                                                                                                              ".rtrim()
			  +"\n        , SD.SDA_NM                                                                                                                                             ".rtrim()
			  +"\n        , A.PRICE_MGR_YN                                                                                                                                        ".rtrim()
			  +"\n        , A.SALE_AMT                                                                                                                                            ".rtrim()
			  +"\n        , A.ORDER_CNT                                                                                                                                           ".rtrim()
			  +"\n        , A.DLV_PACK_FG                                                                                                                                         ".rtrim()
			  +"\n        , A.PROP_CD                                                                                                                                             ".rtrim()  // 2016-09-27-JYL [곱빼기]
			  +"\n        , A.SET_PROD_FG                                                                                                                                         ".rtrim()
			  +"\n        , A.SVC_FG                                                                                                                                              ".rtrim()
			  +"\n          %s                                                                                                                                                    ".rtrim()
			  +"\n        , A.COOK_MEMO                                                                                                                                           ".rtrim()
			  +"\n HAVING ( SUM( A.QTY ) <> 0 ) OR ( SUM( A.SALE_AMT ) <> 0 )                                                                                                     ".rtrim()
			  +"\n ORDER BY MIN( A.ORDER_DTL_NO )                                                                                                                                 ".rtrim()
			;

		this.GetProductListData_04_SQL_SHOP_ENV_101_TRUE_blPreOrderFg_TRUE = ""
			+"\n  SELECT A.PROD_CD                                                                           AS PROD_CD                                             ".rtrim()  // 2019-04-24-SHK [정렬방식]
			+"\n  	   , A.PROD_NM	                                                                         AS PROD_NM    											".rtrim()
			+"\n  	   , A.SIDE_MENU_YN	                                                                     AS SIDE_MENU_YN										".rtrim()
			+"\n  	   , CASE WHEN A.SDS_CD  != '' AND A.SDS_CD IS NOT NULL THEN   1 ELSE CASE WHEN A.SDA_CD  != '' AND A.SDA_CD IS NOT NULL THEN 1 END END    AS SDS_ORG_DTL_NO										".rtrim()
			+"\n  	   , '0'                                                                                 AS UPRC												".rtrim()
			+"\n  	   , A.SDA_CD                                                                            AS SDA_CD												".rtrim()
			+"\n  	   , SUM(CAST(A.QTY AS NUMERIC (3,0)))                                                   AS QTY													".rtrim()
			+"\n  	   , A.SALE_AMT                                                                          AS SALE_AMT											".rtrim()  // 2019-04-24-SHK [정렬방식]
			+"\n  	   , SD.SDA_NM                                                                           AS SDA_NM                                              ".rtrim()
			+"\n  	   , A.PRICE_MGR_YN                                                                      AS PRICE_MGR_YN										".rtrim()
			+"\n  	   , A.ORDER_CNT                                                                         AS ORDER_CNT											".rtrim()
			+"\n  	   , ''                                                                                  AS DLV_PACK_FG											".rtrim()
			+"\n  	   , ''                                                                                  AS PROP_CD												".rtrim()
			+"\n  	   , A.SET_PROD_FG                                                                       AS SET_PROD_FG											".rtrim()
			+"\n  	   , ''                                                                                  AS SVC_FG												".rtrim()
			+"\n       %s                                                                                                                                           ".rtrim()
			+"\n  	   , ''                                                                                  AS COOK_MEMO											".rtrim()
			+"\n  FROM ( SELECT A.ORDER_DTL_NO 																														".rtrim()
			+"\n  			 , A.PROD_CD 																															".rtrim()
			+"\n  			 , A.PROD_NM 																															".rtrim()
			+"\n  			 , A.SIDE_MENU_YN 																														".rtrim()
			+"\n  			 , A.SDS_CD																																".rtrim()
			+"\n  			 , A.SDA_CD																																".rtrim()
			+"\n  			 , A.QTY 																																".rtrim()
			+"\n  			 , A.SALE_AMT 																															".rtrim()
			+"\n  			 , A.PRICE_MGR_YN 																														".rtrim()
			+"\n  			 , B.ORDER_CNT 																															".rtrim()
			+"\n  			 , A.SET_PROD_FG																														".rtrim()
			+"\n                %s                                                                                                                                  ".rtrim()
			+"\n  	   FROM ( SELECT *																																".rtrim()
			+"\n  			  FROM ( SELECT A.ORDER_DTL_NO 																											".rtrim()
			+"\n  						  , A.PROD_CD 																												".rtrim()
			+"\n  						  , CASE WHEN B.PROD_NM is NULL THEN ( SELECT SDA_NM    AS PROD_NM                                                          ".rtrim()
			//+"\n  						  								   FROM SP_GET_SDA_NM( A.SHOP_CD, SUBSTR( A.PROD_CD, 4, 6 ) ) ) 						".rtrim()
				+"\n                                                FROM (                                                                                          ".rtrim()
				+ this.SP_GET_SDA_NM_SQL( " A.SHOP_CD" , " SUBSTR( A.PROD_CD, 4, 6 ) " )
				+"\n                                         )                )                                                                                      ".rtrim()

			+"\n  						  	 ELSE B.PROD_NM END AS PROD_NM 																							".rtrim()
			+"\n  						  , CASE WHEN B.PROD_NM is NULL THEN 'N' 																					".rtrim()
			+"\n  						  	 ELSE B.SIDE_MENU_YN END AS SIDE_MENU_YN 																				".rtrim()
			+"\n  						  , A.SDS_CD																												".rtrim()
			+"\n  						  , A.SDA_CD																												".rtrim()
			+"\n  						  , A.SALE_QTY AS QTY 																										".rtrim()
			+"\n  						  , A.SALE_AMT AS SALE_AMT 																									".rtrim()
			+"\n  						  , CASE WHEN B.PRICE_MGR_FG = '1' THEN 'Y' ELSE 'N' END AS PRICE_MGR_YN 												    ".rtrim()
			+"\n  						  , CASE WHEN B.PROD_NM is NULL THEN '0'																					".rtrim()
			+"\n  						    ELSE B.SET_PROD_FG END AS SET_PROD_FG 																					".rtrim()
			+"\n  						  , CASE WHEN ( ( C.PRT_NO IS NULL ) AND SUBSTR( A.PROD_CD, 1, 1 ) = 'A' ) THEN ( SELECT F.PRT_NO							".rtrim()
			+"\n  																										   FROM POS_PODTL_T D						".rtrim()
			+"\n  																												LEFT OUTER JOIN SCD_PRODM_T E 		".rtrim()
			+"\n  																											   ON  E.SHOP_CD = D.SHOP_CD 			".rtrim()
			+"\n  																												AND E.PROD_CD = D.PROD_CD 			".rtrim()
			+"\n  																												LEFT OUTER JOIN SCD_PRTPR_T F 		".rtrim()
			+"\n  																												ON  F.SHOP_CD = D.SHOP_CD 			".rtrim()
			+"\n  																												AND F.PROD_CD = D.PROD_CD 			".rtrim()
			+"\n  																												AND F.PRT_NO  = '%s' 				".rtrim()
			+"\n  																										   WHERE D.SHOP_CD      = '%s' 			    ".rtrim()
			+"\n  																										   AND   D.ORDER_DATE    = '%s'		        ".rtrim()
			+"\n  																										   AND   D.PRE_ORDER_NO     = '%s'          ".rtrim()
			+"\n  																										   AND   E.SIDE_MENU_YN = 'Y' )				".rtrim()
			+"\n  								 ELSE C.PRT_NO END AS PRT_NO 																						".rtrim()
			+"\n                              %s                                                                                                                    ".rtrim()
			+"\n  					  FROM POS_PODTL_T A																											".rtrim()
			+"\n  						  LEFT OUTER JOIN SCD_PRODM_T B 																							".rtrim()
			+"\n  						   ON  B.SHOP_CD = A.SHOP_CD 																								".rtrim()
			+"\n  						   AND B.PROD_CD = A.PROD_CD 																								".rtrim()
			+"\n  						   LEFT OUTER JOIN SCD_PRTPR_T C 																							".rtrim()
			+"\n  						   ON  C.SHOP_CD = A.SHOP_CD 																								".rtrim()
			+"\n  						   AND C.PROD_CD = A.PROD_CD 																								".rtrim()
			+"\n  						   AND C.PRT_NO  = '%s' 																									".rtrim()
			+"\n  					   WHERE A.SHOP_CD      = '%s' 																								    ".rtrim()
			+"\n  					   AND   A.ORDER_DATE    = '%s'																							        ".rtrim()
			+"\n  					   AND   A.PRE_ORDER_NO     = '%s'																					            ".rtrim()
			+"\n  					  AND   A.ORDER_DTL_NO LIKE '%s' )																								".rtrim()
			+"\n  				 WHERE PRT_NO IS NOT NULL ) A 																										".rtrim()
			+"\n  		  , ( SELECT PROD_CD, 																														".rtrim()
			+"\n  				   COUNT( PROD_CD ) AS ORDER_CNT 																									".rtrim()
			+"\n  			  FROM POS_PODTL_T																														".rtrim()
			+"\n  			  WHERE SHOP_CD       = '%s' 																										    ".rtrim()
			+"\n  			  AND   ORDER_DATE     = '%s'																										    ".rtrim()
			+"\n  			  AND   PRE_ORDER_NO      = '%s'																								        ".rtrim()
			+"\n  			  GROUP BY PROD_CD ) B																													".rtrim()
			+"\n  	   WHERE A.PROD_CD = B.PROD_CD ) A 																												".rtrim()
			+"\n  	 LEFT OUTER JOIN SCD_SDACD_T SD 																												".rtrim()
			+"\n  	 ON  SD.SHOP_CD = '%s' 																														    ".rtrim()
			+"\n  	 AND SD.SDA_CD  = A.SDA_CD 																														".rtrim()
			+"\n  GROUP BY A.PROD_CD 																																".rtrim()
			+"\n  	   , A.PROD_NM																																	".rtrim()
			+"\n  	   , A.SIDE_MENU_YN																																".rtrim()
			+"\n  	   , A.SDS_CD																																	".rtrim()
			+"\n  	   , A.SDA_CD																																	".rtrim()
			+"\n  	   , SD.SDA_NM																																	".rtrim()
			+"\n  	   , A.PRICE_MGR_YN																																".rtrim()
			+"\n  	   , A.SALE_AMT																																	".rtrim()
			+"\n  	   , A.ORDER_CNT																																".rtrim()
			+"\n  	   , A.SET_PROD_FG																																".rtrim()
			+"\n          %s                                                                                                                                        ".rtrim()
			+"\n  ORDER BY MIN( A.ORDER_DTL_NO )																													".rtrim()
		;
		this.GetFloorPrtFgCheck_SQL = function( pcsPrtNo ) {
			var s = "" 
					+"\n SELECT COUNT(PRT_NO) AS PRTCNT                    ".rtrim()
					+"\n   FROM SCD_PRTMS_T                                ".rtrim()
					+"\n  WHERE SHOP_CD = '%s'                             ".rtrim()
					+"\n    AND PRT_NO  = '%s'                             ".rtrim()
					+"\n    AND USE_YN  = 'Y'                              ".rtrim()
				;
			s	= s.sprintf( gShopCd, pcsPrtNo );
			return s;
		}
		this.GetFloorPosCheck_SQL = function(pcsPosNo, pcsPrtNo) {
			var s = ""
				+"\n SELECT A.POS_NO , A.FLOOR_NO, B.PRT_NO            ".rtrim()
				+"\n FROM SCD_POSMS_T A, SCD_PRTPS_T B                 ".rtrim()
				+"\n WHERE A.SHOP_CD  = '%s'                           ".rtrim()
				+"\n AND   A.POS_NO   = '%s'                           ".rtrim()
				+"\n AND   B.PRT_NO   = '%s'                           ".rtrim()
				+"\n AND   A.SHOP_CD  = B.SHOP_CD                      ".rtrim()
				+"\n AND   A.FLOOR_NO = B.FLOOR_NO                     ".rtrim()
			;
			s = s.sprintf( gShopCd, pcsPosNo, pcsPrtNo);

			return s;
		}
		this.code_len_SQL = function() {
			var s = ""
				+ "\n SELECT B.CODE_NM || '_LEN' AS CODE_LEN_NM       ".rtrim()
				+ "\n      , A.CODE_LEN          AS CODE_LEN          ".rtrim()
				+ "\n   FROM ( SELECT CODE_CD                         ".rtrim()
				+ "\n               , CODE_LEN                        ".rtrim()
				+ "\n            FROM CCD_ENVPD_T                     ".rtrim()
				+ "\n           WHERE OGN_CD = '%s' ) A               ".rtrim()
				+ "\n       , ( SELECT COM_CD AS CODE_CD              ".rtrim()
				+ "\n                , USE_COL_NM AS CODE_NM          ".rtrim()
				+ "\n            FROM CCD_CODEM_T                     ".rtrim()
				+ "\n           WHERE COM_CD_FG = '052'               ".rtrim()
				+ "\n   ) B                                           ".rtrim()
				+ "\n  WHERE B.CODE_CD = A.CODE_CD                    ".rtrim()
				+ "\n  ORDER BY B.CODE_CD                             ".rtrim()
				;
			s = s.sprintf(gShopCd);
			return s;
		}
		
		this.selectKitchenMemo = function(obj ) {
			var s = ""
					+"\n SELECT KITCHEN_MEMO                                   ".rtrim()
					+"\n   FROM POS_ODHDR_T                                    ".rtrim()
					+"\n  WHERE SHOP_CD          = '%s'                        ".rtrim()
					+"\n    AND SALE_DATE    = '%s'                        ".rtrim()
					+"\n    AND ORDER_NO     = '%s'                        ".rtrim()
				;
			s = s.sprintf( gShopCd, obj.SALE_DATE, obj.ORDER_NO);
			s = s.sprintf();
			return s;
		}
		
		//*------------------------------------------------------------------------------
		//*---- 2021. 10. 26 xbwing
		//*----
		//*----  주방주문 충수량 쿼리문을 통해 가져온다.
		//*------------------------------------------------------------------------------
		this.GetkitchenOrderTotalCount_SQL = function(bIs688, obj, m_csOrderDtlNo)
		{
			var	str688Sql_1 = "";
			var str688Sql_2 = "";
			
			if( bIs688 )
	        {
		        str688Sql_1 ="\n            LEFT OUTER JOIN SCD_PRODM_T P        ".rtrim()
		        			+"\n		      ON P.SHOP_CD = D.SHOP_CD           ".rtrim()
		        			+"\n             AND P.PROD_CD = D.PROD_CD           ".rtrim();
		        
		        str688Sql_2 ="\n 		 AND (P.SIDE_MENU_YN = 'Y'               ".rtrim()
						    +"\n                OR ( P.SIDE_MENU_YN ='N'         ".rtrim()
						    +"\n               AND (D.SDS_ORG_DTL_NO = ''        ".rtrim() 
						    +"\n		         OR D.SDS_ORG_DTL_NO IS NULL)))  ".rtrim();
	        }
			
			var s = ""
					+"\n SELECT ODDTL.SALE_QTY AS SALE_QTY FROM          ".rtrim()																								
					+"\n 	( SELECT PROD_CD FROM SCD_PRTPR_T 	         ".rtrim()						
					+"\n					 WHERE SHOP_CD = '%s'        ".rtrim()
					+"\n					   AND PRT_NO  = '%s'        ".rtrim()
					+"\n					   AND USE_YN  = 'Y'         ".rtrim()
					+"\n	) PRNT,										 ".rtrim() 															
			        +"\n	( SELECT D.PROD_CD, SUM(SALE_QTY) SALE_QTY   ".rtrim()
			        +"\n		FROM POS_ODDTL_T D                       ".rtrim()
			        +"\n             %s                                  ".rtrim()
			        +"\n       WHERE D.SHOP_CD   = '%s' 	             ".rtrim()
			        +"\n		 AND D.SALE_DATE = '%s'                  ".rtrim()				
				    +"\n         AND D.ORDER_NO  = '%s'                  ".rtrim()
				    +"\n		 AND D.ORDER_DTL_NO LIKE '%s'			 ".rtrim()
				    +"\n             %s                                  ".rtrim()
			        +"\n       GROUP BY D.PROD_CD ) ODDTL                ".rtrim() 														
			        +"\n    WHERE PRNT.PROD_CD = ODDTL.PROD_CD           ".rtrim()
			        +"\n";
			
			s = s.sprintf( obj.SHOP_CD, obj.PRT_NO, str688Sql_1, obj.SHOP_CD, obj.SALE_DATE, obj.ORDER_NO, m_csOrderDtlNo, str688Sql_2 );
		
//debugger; //xbwing
			return s;
		}
		
		this.selectCornerPayDataGroup = function(pObj) {
			var s = ""
				+"\n SELECT A.PROD_CD                                                                  AS PROD_CD         ".rtrim()
				+"\n      , A.NORMAL_UPRC                                                              AS NORMAL_UPRC     ".rtrim()
				+"\n      , A.SALE_UPRC                                                                AS UPRC            ".rtrim()
				+"\n      , A.PROP_CD                                                                  AS PROP_CD         ".rtrim()  // 2016-09-27-JYL [곱빼기]
				+"\n      , CASE WHEN A.SALE_YN = 'N' THEN A.SALE_QTY     * -1 ELSE A.SALE_QTY     END AS QTY             ".rtrim()
				+"\n      , CASE WHEN A.SALE_YN = 'N' THEN A.DC_AMT       * -1 ELSE A.DC_AMT       END AS DC_AMT          ".rtrim()
				+"\n      , CASE WHEN A.SALE_YN = 'N' THEN A.DCM_SALE_AMT * -1 ELSE A.DCM_SALE_AMT END AS AMT             ".rtrim()
				+"\n      , B.SIDE_MENU_YN                                                             AS SIDE_MENU_YN    ".rtrim()
				+"\n      , A.SDS_ORG_DTL_NO                                                           AS SDS_ORG_DTL_NO  ".rtrim()  // 2019-04-24-SHK [정렬방식]
				+"\n      , A.SALE_WEIGHT                                                              AS SALE_WEIGHT     ".rtrim()
				+"\n      , B.PRICE_MGR_FG                                                             AS PRICE_MGR_FG    ".rtrim()
				+"\n      , LTRIM( CASE WHEN A.TAX_YN = 'N' THEN '*' ELSE '' END ) || RTRIM( CASE WHEN A.SDS_ORG_DTL_NO > '0' AND A.SDA_CD <> '' AND A.SDA_CD IS NOT NULL AND B.SIDE_MENU_YN = 'N' THEN '▶' ELSE '' END ) || B.PROD_NM  AS PROD_NM  ".rtrim()
				+"\n      , A.CORNER_CD                                                                                   ".rtrim()
				+"\n      , CASE WHEN A.CORNER_CD = '00' THEN (SELECT SHOP_NM FROM SCD_SHOPM_T WHERE SHOP_CD = A.SHOP_CD) ELSE (SELECT CORNER_NM FROM SCD_SHOPS_T WHERE SHOP_CD = A.SHOP_CD AND CORNER_CD = A.CORNER_CD) END AS CORNER_NM                                                                                   ".rtrim()
				+"\n FROM SSL_TRDTL_T A                                           ".rtrim()
				+"\n      INNER JOIN SCD_PRODM_T B                                ".rtrim()
				+"\n      ON  A.SHOP_CD = B.SHOP_CD                               ".rtrim()
				+"\n      AND A.PROD_CD = B.PROD_CD                               ".rtrim()
				+"\n WHERE A.SHOP_CD   = '%s'                                     ".rtrim()
				+"\n AND   A.SALE_DATE = '%s'                                     ".rtrim()
				+"\n AND   A.POS_NO    = '%s'                                     ".rtrim()
				+"\n AND   A.BILL_NO   = '%s'                                     ".rtrim()
				+"\n GROUP BY A.SHOP_CD, A.SALE_DATE, A.BILL_NO, A.CORNER_CD      ".rtrim()
				+"\n ORDER BY A.SDS_ORG_DTL_NO                                    ".rtrim()
				+"\n        , A.SDA_CD                                            ".rtrim()
				+"\n        , A.DTL_NO                                            ".rtrim()
			;
			s = s.sprintf( pObj.SHOP_CD, pObj.SALE_DATE, pObj.POS_NO, pObj.BILL_NO);
			return s;
		}
		
		this.selectCornerPayData = function(pObj) {
			var s = ""
				+"\n SELECT A.PROD_CD                                                                  AS PROD_CD         ".rtrim()
				+"\n      , A.NORMAL_UPRC                                                              AS NORMAL_UPRC     ".rtrim()
				+"\n      , A.SALE_UPRC                                                                AS UPRC            ".rtrim()
				+"\n      , A.PROP_CD                                                                  AS PROP_CD         ".rtrim()  // 2016-09-27-JYL [곱빼기]
				+"\n      , CASE WHEN A.SALE_YN = 'N' THEN A.SALE_QTY     * -1 ELSE A.SALE_QTY     END AS QTY             ".rtrim()
				+"\n      , CASE WHEN A.SALE_YN = 'N' THEN A.DC_AMT       * -1 ELSE A.DC_AMT       END AS DC_AMT          ".rtrim()
				+"\n      , CASE WHEN A.SALE_YN = 'N' THEN A.DCM_SALE_AMT * -1 ELSE A.DCM_SALE_AMT END AS AMT             ".rtrim()
				+"\n      , B.SIDE_MENU_YN                                                             AS SIDE_MENU_YN    ".rtrim()
				+"\n      , A.SDS_ORG_DTL_NO                                                           AS SDS_ORG_DTL_NO  ".rtrim()  // 2019-04-24-SHK [정렬방식]
				+"\n      , A.SALE_WEIGHT                                                              AS SALE_WEIGHT     ".rtrim()
				+"\n      , B.PRICE_MGR_FG                                                             AS PRICE_MGR_FG    ".rtrim()
				+"\n      , LTRIM( CASE WHEN A.TAX_YN = 'N' THEN '*' ELSE '' END ) || RTRIM( CASE WHEN A.SDS_ORG_DTL_NO > '0' AND A.SDA_CD <> '' AND A.SDA_CD IS NOT NULL AND B.SIDE_MENU_YN = 'N' THEN '▶' ELSE '' END ) || B.PROD_NM  AS PROD_NM  ".rtrim()
				//+"\n      , LTRIM( IIF( A.TAX_YN = 'N', '*', '' ) || RTRIM( IIF( A.SDS_ORG_DTL_NO > '0' AND A.SDA_CD <> '' AND B.SIDE_MENU_YN = 'N', '▶', '' ) ) || B.PROD_NM ) PROD_NM     ".rtrim()
				+"\n FROM SSL_TRDTL_T A                                                                                                                                                     ".rtrim()
				+"\n      INNER JOIN SCD_PRODM_T B                                                                                                                                          ".rtrim()
				+"\n      ON  A.SHOP_CD = B.SHOP_CD                                                                                                                                         ".rtrim()
				+"\n      AND A.PROD_CD = B.PROD_CD                                                                                                                                         ".rtrim()
				+"\n WHERE A.SHOP_CD   = '%s'                                                                                                                                               ".rtrim()
				+"\n AND   A.SALE_DATE = '%s'                                                                                                                                               ".rtrim()
				+"\n AND   A.POS_NO    = '%s'                                                                                                                                               ".rtrim()
				+"\n AND   A.BILL_NO   = '%s'                                                                                                                                               ".rtrim()
				+"\n AND   A.CORNER_CD   = '%s'                                                                                                                                               ".rtrim()
				+"\n ORDER BY A.SDS_ORG_DTL_NO                                                                                                                                              ".rtrim()
				+"\n        , A.SDA_CD                                                                                                                                                      ".rtrim()
				+"\n        , A.DTL_NO                                                                                                                                                      ".rtrim()
			;
			s = s.sprintf( pObj.SHOP_CD, pObj.SALE_DATE, pObj.POS_NO, pObj.BILL_NO, pObj.CORNER_CD );
			return s;
		}
		
		
		this.selectTblCd = function(pObj) {
			var s = ""
				+"\n SELECT FD_TBL_CD             ".rtrim()
				+"\n   FROM SSL_TRHDR_T           ".rtrim()
				+"\n  WHERE SHOP_CD   = '%s'    ".rtrim()
				+"\n    AND SALE_DATE = '%s'  ".rtrim()
				+"\n    AND POS_NO    = '%s'  ".rtrim()
				+"\n    AND BILL_NO   = '%s'  ".rtrim()
			;
			s = s.sprintf( pObj.SHOP_CD, pObj.SALE_DATE, pObj.POS_NO, pObj.BILL_NO );
			return s;
		}
		
		this.selectTblInfoData = function(pObj) {
			var s = ""
				+"\n SELECT G.TG_NM   AS TG_NM         ".rtrim()
				+"\n      , T.TABLE_NM   AS TABLE_NM     ".rtrim()
				+"\n   FROM SCD_TBGRP_T G                                                                                                                                                     ".rtrim()
				+"\n        INNER JOIN SCD_TABLE_T T                                                                                                                                          ".rtrim()
				+"\n        ON  G.SHOP_CD = T.SHOP_CD                                                                                                                                         ".rtrim()
				+"\n        AND G.TG_CD = T.TG_CD                                                                                                                                         ".rtrim()
				+"\n  WHERE T.TABLE_CD   = '%s'                                                                                                                                               ".rtrim()
			;
			s = s.sprintf( pObj );
			return s;
		}
}