
$(document).ready(function(){
    let visualSwiper = new Swiper('.visual-swiper', {
        slidesPerView: 1,
        loop: true,
        centeredSlides: true,
        ratio: 0,
        autoplay: {
            delay: 2000,
            disableOnInteraction: false,
        },
        pagination: {
            el: ".main-visual .swiper-pagination",
            clickable: true,
            renderBullet: function (index, className) {
                return '<span class="' + className + '">' + (index + 1) + "</span>";
            },
        },
        effect: "fade",
    });
    
    let mainSwiper = new Swiper(".main-swiper", {
        slidesPerView: 1,
        loop: true,
        loopAdditionalSlides: 1,
        ratio: 0,
        centeredSlides: true,
        navigation: {
            nextEl: ".main-swiper .swiper-button-next",
            prevEl: ".main-swiper .swiper-button-prev",
        },
    });
}) 


$(".header-btn").click(function () {
    $("#header").toggleClass('active');
});