var peristalsis = false;
var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function() {
        var today = new Date();
        $("#picker").datepicker({
            dateFormat: "yy년 mm월 dd일"
        });
        $("#picker").datepicker("setDate",today);
        app.getTodayTotal($("#picker").val());
    },
    eventInit:function(){
        $('.last').on("click", function () {
            var date = $('#picker').datepicker('getDate');
            date.setTime(date.getTime() + (1000*60*60*24));
            $('#picker').datepicker("setDate", date);

            app.getTodayTotal($("#picker").val());
        });

        $('.first').on("click", function () {
            var date = $('#picker').datepicker('getDate');
            date.setTime(date.getTime() - (1000*60*60*24));
            $('#picker').datepicker("setDate", date);

            app.getTodayTotal($("#picker").val());
        });
        $('#todayTotal').on("click", function(){
            var today = new Date();
            $("#picker").datepicker({
                dateFormat: "yy년 mm월 dd일"
            });
            $("#picker").datepicker("setDate",today);
            app.getTodayTotal($("#picker").val());
        });
    },
    otherInit:function(){
        if(isIphone()){
            if(!isPopupClose){
                cordova.plugins.finPlugin.backButton("", null, null);
            }
        }else {
            document.addEventListener("backbutton", app.backbuttonAction, false);
        }
    },
    backbuttonAction:function(){
        if(isIphone()){
            cordova.plugins.finPlugin.backButton("", null, null);
        }else {
            cordova.plugins.finPlugin.moveStack(MAIN.DATA,null, null);
        }
    },
    getTodayTotal:function(today){
        
        if(isIphone())
        {
            var dateVal = {"calender" : today};
            
            cordova.plugins.finPlugin.getTodayTotal(dateVal, function(data){
                       app.setPaymentData(data);
                   }, null);
        }else
        {
            cordova.plugins.finPlugin.getTodayTotal(today, function(data){
                       app.setPaymentData(data);
                   }, null);
        }
        
       
    },
    setToday:function(){
        var today = new Date();
        $("#picker").datepicker({
            dateFormat: "yy년 mm월 dd일"
        });
        $("#picker").datepicker("setDate",today);
        app.getTodayTotal($("#picker").val());
        app.initDayButton();
    },
    initDayButton:function(){
        $('#thisDay').addClass('selected');
        $('#prevDay').removeClass('selected');
    },
    setPaymentData:function(data) {

        if(data == null) return;
        var dataObject = JSON.parse(data);
        if(dataObject == null) return;
        
        if(isIphone())
        {
            $("#li_cardPaymentTotal").html(dataObject['cardAmount'] + '원');
            $("#li_cardPaymentCount").html('(' + dataObject['cardCount'] + '건)');
            $("#li_cashPaymentTotal").html(dataObject['cashAmount']+ '원');
            $("#li_cashPaymentCount").html('(' + dataObject['cashCount'] + '건)');
            $("#li_allPaymentTotal").html(dataObject['totalAmount'] + '원');
            $("#li_allPaymentCount").html('(' + dataObject['totalCount'] + '건)');

            $("#li_cardPaymentTotalCancel").html(dataObject['cancelCardAmount'] + '원');
            $("#li_cardPaymentCountCancel").html('(' + dataObject['cancelCardCount'] + '건)');
            $("#li_cashPaymentTotalCancel").html(dataObject['cancelCashAmount']+ '원');
            $("#li_cashPaymentCountCancel").html('(' + dataObject['cancelCashCount'] + '건)');
            $("#li_allPaymentTotalCancel").html(dataObject['cancelTotalAmount']+ '원');
            $("#li_allPaymentCountCancel").html('(' + dataObject['cancelTotalCount'] + '건)');
        }else
        {
            $("#li_cardPaymentTotal").html(dataObject['card_total']);
            $("#li_cardPaymentCount").html('(' + dataObject.card_count + '건)');
            $("#li_chinaPaymentTotal").html(dataObject.china_total);
            $("#li_chinaPaymentCount").html('(' + dataObject.china_count + '건)');
            $("#li_kakaoPaymentTotal").html(dataObject.kakao_total);
            $("#li_kakaoPaymentCount").html('(' + dataObject.kakao_count + '건)');
            $("#li_zeroPaymentTotal").html(dataObject.zero_total);
            $("#li_zeroPaymentCount").html('(' + dataObject.zero_count + '건)');
            $("#li_cashPaymentTotal").html(dataObject.cash_total);
            $("#li_cashPaymentCount").html('(' + dataObject.cash_count + '건)');

            $("#li_allPaymentTotal").html(dataObject.all_total);
            $("#li_allPaymentCount").html('(' + dataObject.all_count + '건)');

            $("#li_cardPaymentTotalCancel").html(dataObject.card_total_cancel);
            $("#li_cardPaymentCountCancel").html('(' + dataObject.card_count_cancel + '건)');
            $("#li_chinaPaymentTotalCancel").html(dataObject.china_total_cancel);
            $("#li_chinaPaymentCountCancel").html('(' + dataObject.china_count_cancel + '건)');
            $("#li_kakaoPaymentTotalCancel").html(dataObject.kakao_total_cancel);
            $("#li_kakaoPaymentCountCancel").html('(' + dataObject.kakao_count_cancel + '건)');
            $("#li_zeroPaymentTotalCancel").html(dataObject.zero_total_cancel);
            $("#li_zeroPaymentCountCancel").html('(' + dataObject.zero_count_cancel + '건)');
            $("#li_cashPaymentTotalCancel").html(dataObject.cash_total_cancel);
            $("#li_cashPaymentCountCancel").html('(' + dataObject.cash_count_cancel + '건)');

            $("#li_allPaymentTotalCancel").html(dataObject.all_total_cancel);
            $("#li_allPaymentCountCancel").html('(' + dataObject.all_count_cancel + '건)');
        }
    }
};
app.initialize();