var businessNumber;
var productNumber;
var useType = '';
var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function(){
        $(document).on("keyup", ".uPayN", function() {
            $(this).number(true);
        });
        if ($(".uPayN").length > 0) {
            $(".uPayN").number(true);
        }

        cordova.plugins.finPlugin.getUseType("", function(res){
            if(0 < res.length){
                if('연동형' == res){
                    useType = '연동형';
                    $("#hd_title").html("<h3 class='title'>위챗페이 취소</h3><h3 id='battery' class='battery'><span></span></h3>");
                    //연동형 인경우 스키마 값 체크
                    cordova.plugins.finPlugin.checkScheme("", function(isScheme){
                        //스키마 값이 있는 경우 해당 번호 기반으로 인증 정보를 가져와야 한다
                        //번호가 없는 경우 메인 사업장을 가져온다
                        app.getSchemeData();
                    }, function(error){
                        //스키마 값이 없는 경우 해당 앱에 정보 없음 Callback 을 한다.
                    });
                }else {
                    useType = '통합형';
                    //통합형 인 경우 연결된 모든 사업장을 가져온다
                    app.getCancelData();
                }
            }
        }, null);
    },
    eventInit:function(){
       
    },
    otherInit:function(){
        document.addEventListener("backbutton", app.backbuttonAction, false);
        UPDATE_CHECK();
    },
    backbuttonAction:function(){
        var isPopupClose = false;
        if ($("#layerPopup.Popup06").is(':visible')){
            isPopupClose = true;
            $('#layerPopup.Popup06').hide();
        }
        if(!isPopupClose){
            cordova.plugins.finPlugin.backButton("", null, null);
        }
    },
    getSchemeData:function(){
        //스키마 값 가져오기
        cordova.plugins.finPlugin.getSchemeData("", function(schemeData){
            app.setSchemeData(schemeData);
        },function(error){
            if(isIphone()){
                close_Progress();
                open_PopupError(error);
            }
        });
    },
    setSchemeData:function(data){
        //스키마 값 셋팅 하기 (취소 데이터와 동일하게 한다)
        var cancelData = JSON.parse(data);
       if(null == cancelData) return;
       if(isIphone())
       {
           $("#uSum").val(cancelData['srcConfmNo']);
           $("#uInstPlan").val(cancelData['srcConfmDe']);
           $("#uAmount").val(cancelData['totalAmount']);
           $("#uBizName").val(cancelData['businessName']);
           $("#utid").val(cancelData['readerNumber']);
           businessNumber = cancelData['businessNumber'];
           productNumber = cancelData['productNumber'];
       }
       else
       {
           
           $("#uSum").val(cancelData.approvalNumber);
           $("#uInstPlan").val(cancelData.approvalDate);
           $("#uAmount").val(cancelData.totalAmount);
           $("#uBizName").val(cancelData.storeName);
           $("#utid").val(cancelData.catId);
       }
    },
    getCancelData:function(){
        var successCallback = function(res){
            app.setCancelData(res);
        };
        var failureCallback = function(error){
            open_PopupError(error);
        };
        
        var data = {"TYPE":"WECHAT_PAY"};
        cordova.plugins.finPlugin.getCancelData(data, successCallback, failureCallback);
    },
    setCancelData:function(data){
    
    
        var receiptData = JSON.parse(data);
       if(null == receiptData) return;
       if(isIphone())
       {
           $("#uSum").val(receiptData['approvalNumber']);
           $("#uInstPlan").val(receiptData['dateOfApproval']);
           $("#uAmount").val(receiptData['totalAmount']);
           $("#uBizName").val(receiptData['businessName']);
           $("#utid").val(receiptData['readerNumber']);
           businessNumber = receiptData['businessNumber'];
           productNumber = receiptData['productNumber'];
       }
       else
       {
          $("#uSum").val(receiptData.approvalNumber);
          $("#uInstPlan").val(receiptData.approvalDate);
          $("#uAmount").val(receiptData.totalAmount);
          $("#uBizName").val(receiptData.storeName);
          $("#utid").val(receiptData.catId);
       }
    },
    requestPayment:function(){
        
        open_PopupError('위쳇페이 취소요청 중 입니다.');
        if(isIphone()){
          var data = {
                "STACK_ID":"WECHAT_CAN_PAY",
                "STACK_URL":"04_06.html",
                "sepa":"cancel_wechat_pay",
                "totalPrice":$("#uAmount").val(),
                "approvalNumber":$("#uSum").val(),
                "approvalDate":$("#uInstPlan").val(),
                "businessNumber":businessNumber,
                "productNumber":productNumber,
                "readerNumber":$("#utid").val(),
                
               
            };
            cordova.plugins.finPlugin.moveStack(data, null,null);
        }else {
          var sendData = {
              "catId":$("#utid").val(),
              "price":replaceAll($("#uAmount").val(), ",", ""),
              "approvalNumber":$("#uSum").val(),
              "approvalDate":$("#uInstPlan").val()
          };
          cordova.plugins.finPlugin.requestPayment(sendData, function(res){
              open_PopupError('위챗페이 취소가 완료 되었습니다.');
              var receiptPage;
              if(isIphone()){
                  RECEIPT_WECHAT.DATA.RECEIPT_ID = res;
                receiptPage = RECEIPT_ALI_CAN;
              }else {
                RECEIPT_WECHAT
                RECEIPT_WECHAT.DATA.RECEIPT_ID = res;
                receiptPage = RECEIPT_WECHAT;
              }
              cordova.plugins.finPlugin.moveStack(receiptPage.DATA,null, null);
          }, function(error){
              if(error) open_PopupError(error);
              else open_PopupError('위챗페이 취소요청에 실패 하였습니다.');
              if('통합형' == useType){
                  cordova.plugins.finPlugin.backButton("", null, null);
              }
          });
        }
        
    },
    showDeletePayPopup:function() {
        $('#layerPopup.Popup06').show();
    },errorOfPaymentByNetwork:function()
    {
        close_PopupError();
        open_PopupError('네트워크 문제로 인하여 결제 요청에 실패 하였습니다.');
        cordova.plugins.finPlugin.backButton("", null, null);
    }
};

app.initialize();
