var startDate;
var endDate;
var productNum;
var receiptNum;
var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function() {
        if(isIphone()){
            jQuery('#print_button').css("display", "none");
            var data = {"TYPE":"ALI"};
            cordova.plugins.finPlugin.getReceiptData(data,function(res){
                app.showReceiptData(res);
            }, function(error){
                showToastMessage(error);
            });
        }else
        {
            cordova.plugins.finPlugin.getReceiptData("",function(res){
                app.showReceiptData(res);
            }, function(error){
                showToastMessage(error);
            });
        }
        
    },
    eventInit:function(){
    },
    otherInit:function(){

    },
    showReceiptData:function(res){
        var receiptData = JSON.parse(res);
        if(null == receiptData) return;
        
        if(isIphone())
        {
            productNum = receiptData['productNumber'];
            receiptNum = receiptData['receiptNumber'];
            
            $("#referenceNo").html(receiptData['receiptNumber'] );
            $("#bizName").html(receiptData['storeName']);
            $(".bizOwner").html(receiptData['represent']);
            $("#bizNumber").html(receiptData['businessNumber']);
            $("#bizCallNumber").html(receiptData['storePhone']);
            $("#bizAddress").html(receiptData['storeAddress']);
            $("#acquirersName").html(receiptData['acquirersName']);
            $("#alipayBuyerLoginId").html(receiptData['alipayBuyerLoginId']);
            $("#totalAmount"). html( receiptData['totalAmount']);
            $("#transAmountCny"). html(receiptData['transAmountCny']);
            $("#exchangeRate").html("1000KRW =" + receiptData['exchangeRate'] +"  RMB");
            $(".time").html(receiptData['dateAndTime']);

            $("#readerNumber").html(maskCatId(receiptData['readerNumber']));
            $("#readerNumber").val(receiptData['readerNumber']);
            $("#alipayTransId").html(receiptData['alipayTransId']);
            $(".approvalNumber").html(receiptData['approvalNumber']);
            $("#supply").html(receiptData['supplyAmount']);
            $("#tax").html(receiptData['taxAmount']);
            $("#total").html(receiptData['totalAmount']);
            $("#barcodeImg").JsBarcode(receiptData['approvalNumber'], {displayValue: false, height: 80});
            
            if(receiptData['isCanceled']=='Y') {
            $("#buttons").html("<div id='buttons' class='btnSection marginT13'> <button onclick='app.sendMMS();' class='btn wd100'>문자 영수증 전송</button> </div>");
            }
            
        }else
        {
        var kind = receiptData.payKind;
        $("#title").html(receiptData.payKind + ' ' + receiptData.authType  + ' 영수증');
        var sign = "";
        if (receiptData.authType == "취소") {
            $("#kind").html('ALIPAY REFUND');
            sign = "-";
        } else {
            $("#kind").html('ALIPAY APPROVE');
        }
        $("#referenceNo").html(receiptData.referenceNo);
        $(".time").html(receiptData.time);
        $(".approvalNumber").html(receiptData.approvalNumber);
        //$("#cardNumber").html(window.AndroidInterface.getCardNumber());
        $("#total").html(sign + numberWithCommas(receiptData.totalAmount));
        $("#totalAmount").html(sign + numberWithCommas(receiptData.totalAmount));
        $("#supply").html(sign + numberWithCommas(receiptData.supplyAmount));
        $("#tax").html(sign + numberWithCommas(receiptData.taxAmount));
        //$("#notice").html(window.AndroidInterface.getNotice());
        $("#acquirersName").html(receiptData.buyCompany);
        $("#alipayBuyerLoginId").html(receiptData.alipayUserLoginId);
        $("#transAmountCny").html(sign + numberWithCommas(receiptData.alipayTransAmountCny));
        $("#exchangeRate").html(receiptData.alipayExchangeRate);
        $("#alipayTransId").html(receiptData.alipayTransId);

        $("#readerNumber").html(maskCatId(receiptData.catId));
        $("#readerNumber").val(receiptData.catId);
        $("#bizName").html(receiptData.bizName);
        var bizNumber = receiptData.bizNumber;
        if (bizNumber.length == 10) {
            $("#bizNumber").html(bizNumber.substring(0,3) + "-" + bizNumber.substring(3,5) + "-" + bizNumber.substring(5,10));
        } else {
            $("#bizNumber").html(bizNumber);
        }
        $("#bizCallNumber").html(receiptData.bizPhone);
        $(".bizOwner").html(receiptData.ownerName);
        $("#bizAddress").html(receiptData.bizAddress);

        $("#barcodeImg").JsBarcode(receiptData.approvalNumber, {displayValue: false, height: 80});

        if(receiptData.isCancelPayment == false) {
            $("#buttons").html("<div id='buttons' class='btnSection marginT13'> <button onclick='app.sendMMS();' class='btn wd100'>문자 영수증 전송</button> </div>");
        }

        if(receiptData.canPrint){
            $("#print_button").css("display","inline-block");
        }else {
            $("#print_button").css("display","none");
        }
      }
    },
     requestCancel:function(){

        var amount = getAmount($("#totalAmount").html());
        var supplyAmount = getAmount($("#supply").html());
        var vatAmount = getAmount($("#tax").html());

         ALI_CAN.DATA.catId = $("#readerNumber").val();
         ALI_CAN.DATA.totalAmount = amount;
         ALI_CAN.DATA.supplyAmount = supplyAmount;
         ALI_CAN.DATA.vatAmount = vatAmount;
         ALI_CAN.DATA.tradeDate = $(".time").html();
         ALI_CAN.DATA.approvalNumber = $(".approvalNumber").html();
         ALI_CAN.DATA.RECEIPT_ID = receiptNum;
         cordova.plugins.finPlugin.requestCancel(ALI_CAN.DATA,null, null);

     },
     sendMMS:function(){
         
         if(isIphone())
         {
             var data = {"TYPE":"ALI"};
             cordova.plugins.finPlugin.sendMMS(data,null, null);
         }else
         {
             cordova.plugins.finPlugin.sendMMS("",null, null);
         }
         
        
     },
     printReceipt:function(){
         cordova.plugins.finPlugin.printReceipt("",null, function(error){
             showToastMessage(error);
         });
     },
     closeStack:function(){
         cordova.plugins.finPlugin.backButton("", null, null);
     },
    backbuttonAction:function()
    {
        if(isIphone())
        {
            if(!isPopupClose){
                cordova.plugins.finPlugin.backButton("", null, null);
            }
        }else
        {
            
        }
    },backReceipAction:function(){
        if(isIphone()){
          cordova.plugins.finPlugin.moveStack(RECEIPT.DATA, null,null);
        }else {
          app.backbuttonAction();
        }
    }
};

app.initialize();