var approvalTime;
var receiptNumber;
var isTaxIncluded;
var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function() {
        if(isIphone()){
            jQuery('#print_button').css("display", "none");
            var data = {"TYPE":"CASH"};
            cordova.plugins.finPlugin.getReceiptData(data,function(res){
                app.showReceiptData(res);
            }, function(error){
                showToastMessage(error);
            });
        }else
        {
            cordova.plugins.finPlugin.getReceiptData("",function(res){
                app.showReceiptData(res);
            }, function(error){
                showToastMessage(error);
            });
        }
        
    },
    eventInit:function(){
    },
    otherInit:function(){

    },
    showReceiptData:function(res){
        var receiptData = JSON.parse(res);
        if(null == receiptData) return;
        if(isIphone())
        {
            $("#title").html(receiptData['tradingCategory']);
            $("#li_kind").html(receiptData['tradingCategory']);
            $("#li_kind_sub").html(receiptData['information']);
            $("#li_time").html(receiptData['dateAndTime']);
            $("#li_approval").html(receiptData['approvalNumber']);
            $("#li_cardNumber").html(receiptData['cardNumber']);
            $("#li_total").html(numberWithCommas(receiptData['totalAmount']) + '원');
            $("#li_supply").html(numberWithCommas(receiptData['supplyAmount']) + '원');
            $("#li_tax").html(numberWithCommas(receiptData['taxAmount']) + '원');
            
            $("#li_readerNumber").html(receiptData['terminalNumber'] );
            $("#li_bizName").html(receiptData['merchantName']);
            $("#li_bizOwner").html(receiptData['represent']);
            
            $("#li_bizNumber").html(receiptData['businessNumber']);
            $("#li_bizCallNumber").html(receiptData['phoneNumber']);
            $("#li_bizAddress").html(receiptData['merchantAddress']);
            
            if (receiptData['information'] == "발행안함") {
              $('#information').addClass('blind');
              $('#no_publish').addClass('blind');
              
            }
            
            if(receiptData['isCanceled']=='Y') {
            $("#buttons").html("<div id='buttons' class='btnSection marginT13'> <button onclick='app.sendMMS();' class='btn wd100'>문자 영수증 전송</button> </div>");
            }

            $("#print_button").css("display","none");
            receiptNumber = receiptData['receiptNumber'];
        }else
        {
            var kind = receiptData.payKind;
            $("#title").html(receiptData.payKind + ' ' + receiptData.authType + ' 영수증');
            if (kind == "현금결제") {
                kind = "현금영수증"
            }
            $("#li_kind").html(kind);

            var kind_sub = receiptData.authType + '-' + receiptData.issuedName;
            $("#li_kind_sub").html(kind_sub);

            approvalTime = receiptData.time;
            var viewTime = approvalTime.replace(/(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})/g, '$1/$2/$3 $4:$5:$6');
            $("#li_time").html(viewTime);
            //$("#li_time").html(receiptData.time);
            $("#li_approval").html(receiptData.approvalNumber);
            $("#li_cardNumber").html(receiptData.cardNumber);
            var sign = "";
            if (receiptData.authType == "취소") {
              sign = "-";
            }
            $("#li_total").html(sign + numberWithCommas(receiptData.totalAmount) + '원');
            $("#li_supply").html(sign + numberWithCommas(receiptData.supplyAmount) + '원');
            $("#li_tax").html(sign + numberWithCommas(receiptData.taxAmount) + '원');
            //$("#li_notice").html(window.AndroidInterface.getNotice());

            $("#li_readerNumber").html(maskCatId(receiptData.catId));
            $("#li_readerNumber").val(receiptData.catId);
            $("#li_bizName").html(receiptData.bizName);
            $("#li_bizOwner").html(receiptData.ownerName);
            var bizNumber = receiptData.bizNumber;
            if (bizNumber.length == 10) {
              $("#li_bizNumber").html(bizNumber.substring(0,3) + "-" + bizNumber.substring(3,5) + "-" + bizNumber.substring(5,10));
            } else {
              $("#li_bizNumber").html(bizNumber);
            }
            $("#li_bizCallNumber").html(receiptData.bizPhone);
            $("#li_bizAddress").html(receiptData.bizAddress);

            if (receiptData.issuedName == "발행안함") {
              $('#information').addClass('blind');
            }

            if(receiptData.isCancelPayment == false) {
                $("#buttons").html("<div id='buttons' class='btnSection marginT13'> <button onclick='app.sendMMS();' class='btn wd100'>문자 영수증 전송</button> </div>");
            }

            if(receiptData.canPrint){
              $("#print_button").css("display","`inline-block");
            }else {
              $("#print_button").css("display","none");
            }
            isTaxIncluded = receiptData.isTaxIncluded;
        }
    },
    requestCancel:function(){

        var amount = getAmount($("#li_total").html());
        var supplyAmount = getAmount($("#li_supply").html());
        var vatAmount = getAmount($("#li_tax").html());
        CASH_CAN.DATA.catId = $('#li_readerNumber').val();
        CASH_CAN.DATA.totalAmount = amount;
        CASH_CAN.DATA.supplyAmount = supplyAmount;
        CASH_CAN.DATA.vatAmount = vatAmount;
        if(isIphone()){
            CASH_CAN.DATA.tradeDate = $("#li_time").html();
        }else {
            CASH_CAN.DATA.tradeDate = approvalTime;
        }
        CASH_CAN.DATA.approvalNumber = $("#li_approval").html();
        CASH_CAN.DATA.instPlan = $('#li_cardNumber').html();
        CASH_CAN.DATA.issuedName = $("#li_kind_sub").html();
        CASH_CAN.DATA.RECEIPT_ID = receiptNumber;
        cordova.plugins.finPlugin.requestCancel(CASH_CAN.DATA,null, null);

    },
    sendMMS:function(){
       
        if(isIphone())
        {
            var data = {"TYPE":"CASH"};
            cordova.plugins.finPlugin.sendMMS(data,null, null);
        }else
        {
            cordova.plugins.finPlugin.sendMMS("",null, null);
        }
        
        
        
    },
    printReceipt:function(){
        cordova.plugins.finPlugin.printReceipt("",null, function(error){
            showToastMessage(error);
        });
    },
    closeStack:function(){
        cordova.plugins.finPlugin.backButton("", null, null);
    },
    backbuttonAction:function()
    {
        if(isIphone())
        {
            if(!isPopupClose){
                cordova.plugins.finPlugin.backButton("", null, null);
            }
        }else
        {
            
        }
    },backReceipAction:function(){
        if(isIphone()){
          cordova.plugins.finPlugin.moveStack(RECEIPT.DATA, null,null);
        }else {
          app.backbuttonAction();
        }
    }
};

app.initialize();
