var startDate;
var endDate;
var kindName;
var catId;

var amountTotal;
var receiptNumber;

var approvalNumber;
var approvalTime;
var instPlan;
var isTaxIncluded;

var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function() {
        $(document).on("keyup", ".uPayN", function() {
            $(this).number(true);
        });
        if ($(".uPayN").length > 0) {
            $(".uPayN").number(true);
        }

        if(isIphone()){
            jQuery('#print_button').css("display", "none");
        }
        
        var data = {"TYPE":"UNION_CARD"};
        
        cordova.plugins.finPlugin.getReceiptData(data,function(res){
            app.showReceiptData(res);
        }, function(error){
            showToastMessage(error);
        });
    },
    eventInit:function(){

    },
    otherInit:function(){

    },
    showReceiptData:function(res){
        var receiptData = JSON.parse(res);
        if(null == receiptData) return;
        
        $("#li_kind_sub").html(receiptData['tradingCategory']);
        $("#li_kind").html(receiptData['cardName']);
        $("#li_time").html(receiptData['dateAndTime']);
        $("#li_cardNumber").html(receiptData['cardNumber']);
        $("#li_month").html(receiptData['installDoc']);
        $("#li_readerNumber").html(receiptData['merchantNumber']);
        $("#li_approval").html(receiptData['approvalNumber']);
        $("#li_buyCompany").html(receiptData['acquirersName']);
        $("#li_supply").html(receiptData['supplyAmount'] + " 원");
        $("#li_tax").html(receiptData['taxAmount'] + " 원");
        $("#li_total").html(receiptData['totalAmount'] + " 원");
        $("#li_bizName").html(receiptData['storeName']);
        $("#li_bizNumber").html(receiptData['businessNumber']);
        $("#li_bizOwner").html(receiptData['represent']);
        $("#li_bizCallNumber").html(receiptData['storePhone']);
        $("#li_bizAddress").html(receiptData['storeAddress']);
        
        
        if(receiptData['isCanceled']=='Y')
        {
            $("#buttons").html("<div id='buttons' class='btnSection marginT13'><button onclick='app.sendMMS();;' class='btn wd100'>문자 영수증 전송</button></div>");
        }
        receiptNumber = receiptData['receiptNumber'];
        catId = receiptData['readerNumber'];
        amountTotal = receiptData['totalAmount'];
        approvalNumber = receiptData['approvalNumber'];
        approvalTime = receiptData['dateOfApproval'];
        instPlan = receiptData['installment'];
        if(!isIphone()) isTaxIncluded = receiptData['isTaxIncluded'];
    },
    requestCancel:function(){

        var amount = getAmount($("#totalAmount").html());
        var supplyAmount = getAmount($("#supply").html());
        var vatAmount = getAmount($("#tax").html());
        //receiptNumber
        UNION_CAN.DATA.RECEIPT_ID = receiptNumber;
        UNION_CAN.DATA.approvalNumber = approvalNumber;
        UNION_CAN.DATA.tradeDate = approvalTime;

        UNION_CAN.DATA.totalAmount = amount;
        UNION_CAN.DATA.supplyAmount = supplyAmount;
        UNION_CAN.DATA.vatAmount = vatAmount;

//        UNION_CAN.DATA.totalAmount = amountTotal;
//        if('not_included' == isTaxIncluded){
//            UNION_CAN.DATA.totalAmount = $("#li_supply").html();
//        }
        UNION_CAN.DATA.instPlan = instPlan;
        UNION_CAN.DATA.catId = catId;
        cordova.plugins.finPlugin.requestCancel(UNION_CAN.DATA,null, null);
        
        
        
    },
    sendMMS:function(){
        
        if(isIphone())
        {
            var data = {"TYPE":"UNION_CARD"};
            cordova.plugins.finPlugin.sendMMS(data,null, null);
        }else
        {
            cordova.plugins.finPlugin.sendMMS("",null, null);
        }
        
    },
    printReceipt:function(){
        cordova.plugins.finPlugin.printReceipt("",null, function(error){
            showToastMessage(error);
        });
    },
    closeStack:function(){
        cordova.plugins.finPlugin.backButton("", null, null);
    },backbuttonAction:function(){
        var isPopupClose = false;
        if ($("#layerPopup.Popup12").is(':visible')){
            isPopupClose = true;
            app.hideWarnningPopup();
        }
        if(!isPopupClose){
            cordova.plugins.finPlugin.backButton("", null, null);
        }
    },backReceipAction:function(){
        if(isIphone()){
          cordova.plugins.finPlugin.moveStack(RECEIPT.DATA, null,null);
        }else {
          app.backbuttonAction();
        }
    }
};

app.initialize();
