var isPopupShowing = false;
var isPeristalsis = false;
var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.otherInit();
         UPDATE_CHECK();
    },
    itemInit:function() {
        var androidTypeValue = ["blu","blup","ear","usb","notuse"];
        var androidTypeText = ["블루투스 리더기","블루투스 리더기/프린터 일체형","이어폰 타입 리더기","USB 타입 리더기","사용안함"];
        var iosTypeValue = ["notuse","blu","ear"];
        var iosTypeText = ["사용안함","블루투스 리더기","이어폰 타입 리더기"];
//        var varUA = navigator.userAgent.toLowerCase(); //userAgent 값 얻기
        if(isIphone()){
            //IOS 일때 처리
            $("#slt_dongleUsed").html('');
            for(var index = 0 ; index < iosTypeValue.length ; index++){
                var option = $("<option value = "+ iosTypeValue[index]+">" + iosTypeText[index] + "</option>");
                $("#slt_dongleUsed").append(option);
            }
            $('.readerType').hide();
        }else {
            //안드로이드 일때 처리
            $("#slt_dongleUsed").html('');
            for(var index = 0 ; index < androidTypeValue.length ; index++){
                var option = $("<option value = "+ androidTypeValue[index]+">" + androidTypeText[index] + "</option>");
                $("#slt_dongleUsed").append(option);
            }
        }
        //최초 연동형 통합형 확인 하여 상단 타이틀 바 내용 변경
        cordova.plugins.finPlugin.getUseType("", function(useType){
            //설정된 값이 있다면 설정된 값을 가져온다
            app.getDeviceKind();
            if('연동형' == useType){
                isPeristalsis = true;
                $('.readerType').hide();
                //상단 표기 상태 변경
                if(isIphone()){
                  $("#hd_title").html("<a href='#' onclick='app.backbuttonAction();' ><h3 class='btnPre'><span class='blind'>이전</span></h3></a><h3 class='title'>리더기 설정</h3><h3 id='battery' class='battery'><span></span></h3>");
                  cordova.plugins.finPlugin.checkBattery("", function(battery){
                      updateBattery(true, battery)
                  },function(error){
                      updateBattery(false, '')
                  });
                }else {
                  $("#hd_title").html("<h3 class='title'>리더기 설정</h3><h3 id='battery' class='battery'><span></span></h3>");
                }
            }else {
                isPeristalsis = false;
                app.getPrintKind();
            }
        }, function(error){
            //설정된 값이 있다면 설정된 값을 가져온다
            app.getDeviceKind();
            app.getPrintKind();
        });

    },
    eventInit:function(){
        // 타입 변경 이벤트 체크
        $("#slt_dongleUsed").change(function(){
            if('notuse' == $(this).val()){
                $('.connectedInfo').hide();
            }else if('blu' == $(this).val() || 'blup' == $(this).val()){
                app.showBluetoothNameBox();
                app.showDeviceListPopup();
                if(isIphone())
                {
                    cordova.plugins.finPlugin.scanDevice($(this).val(),null,null);
                }
                
            }else if('ear' == $(this).val())
            {
                app.hideBluetoothNameBox();
               // if(isIphone()) cordova.plugins.finPlugin.changeDongleType($(this).val(),null,null);
                if(isIphone()) cordova.plugins.finPlugin.scanDevice($(this).val(),null,null);
            }else {
                app.hideBluetoothNameBox();
            }
            if(app.checkPrintType()){
                cordova.plugins.finPlugin.selectType($(this).val(), function(res){
                    console.log('01_01.html ChangeType: ' + res);
                }, function(error){
                    console.log('01_01.html ChangeType: ' + error);
                });
            }
        });
        /** 프린트 타입 선택*/
        $("#slt_print").change(function(){
            if('notuse' == $(this).val()){
                //연결된 프린트 삭제 및 연결 끊기
                app.hidePrintNameBox();
                app.selectPrintType();
            }else {
                if("blup" == $("#slt_dongleUsed").val()){
                    showToastMessage("리더기 프린터 통합형 사용자는 프린터를 동시 사용 할 수 없습니다.");
                    $("#slt_print").val('notuse').prop("selected", true);
                }else {
                    app.showPrintNameBox();
                    app.showDeviceListPopup();
                    app.selectPrintType();
                }
            }
        });
        //  기기 리스트 팝업 취
        $('#deviceListCancel').on('click',function(){
            //Scan Stop
            app.hideDeviceListPopup();
        });
        // 저장 버튼
        $('#allSave').on('click',function(){
            var readerName = $("#bleReader").html();
            var currentType = $("#slt_dongleUsed").val();
            var printName = "";
            var printType = "";
            if(!isIphone()){
                printName = $("#printInfo").text();
                printType = $('#slt_print').val();
            }
            if('notuse' == currentType) readerName = '';
            //if('notuse' == currentType) return;
            if('blu' == currentType || 'blup' == currentType){
                if(!readerName){
                    open_PopupError('선택된 기기가 없어 저장 할 수 없습니다.');
                    return;
                }
            }
            var saveData ={
                "deviceName":readerName,
                "saveType":currentType,
                "printName":printName,
                "printType":printType
            };
            cordova.plugins.finPlugin.saveType(saveData, function(res){
                app.showSaveCompletedPopup();
            }, function(error){
                //무결성 검사 실패 시 저장하지 않도록 한다
                open_PopupError(error);
            });
        });
        // 무결성 검사까지 완료 되면 모바일 인증 화면으로 이동 하도록 한다.
        $('#savePopupConfirm').on('click',function(){
            app.hideSaveCompletedPopup();
            if(isPeristalsis){
                //연동형 인 경우
                //callback된 앱에 저장 결과 전달
            }else {
                //통합형 인 경우
                cordova.plugins.finPlugin.moveStack(SET02.DATA, null, null);
            }

            //window.location = SET02.URL;
            return false;
        });
        $('#bleReader').on('click',function(){
            app.showDeviceDeletePopup();
        });
        $('#printInfo').on('click',function(){
            app.hideSaveCompletedPopup();
        });

        //블루투스 클래식 핀 입력
        $('#pinInputConfirm').on('click',function(){
            if($("#uSum").val()==0){ // 비밀번호 오류시 조건(조건에 맞게 수정 필요)
                $("#layerPopup.Popup06").show();
            }else{
                //안드로이드로 핀 번호 보내기
                var pinNum = {
                    "pinData":$("#uSum").val()
                };
                //핀 전달
                cordova.plugins.finPlugin.inputPin(pinNum, function(res){
                    app.hideInputPinPopup();
                }, function(error){

                });
            }
        });
        $('#pinInputCancel').on('click',function(){
            //disconnect 가 필요
            app.hideInputPinPopup();
        });
        $('#deleteCancel').on('click',function(){
            app.hideDeviceDeletePopup();
        });
        $('#deleteConfirm').on('click',function(){
            app.hideDeviceDeletePopup();
            cordova.plugins.finPlugin.deleteDevice("", function(res){
                $('#bleReader').html('');
                app.scanReaderBtn();
            }, function(error){
                showToastMessage('기기 삭제에 실패 하였습니다.');
            });
        });
    },
    otherInit:function(){
        if(isIphone()){

        }else {
            document.addEventListener("backbutton", app.backbuttonAction, false);
        }
    },
    backbuttonAction:function(){
        var isPopupClose = false;
        if ($("#layerPopup.Popup05").is(':visible')){
            isPopupClose = true;
            app.hideInputPinPopup();
        }
        if ($("#layerPopup.Popup07").is(':visible')){
            isPopupClose = true;
            app.hideSaveCompletedPopup();
        }
        if ($("#layerPopup.Popup08").is(':visible')){
            isPopupClose = true;
            app.hideDeviceListPopup();
        }
        if ($("#layerPopup.Popup05_2").is(':visible')){
            isPopupClose = true;
            app.hideDeviceDeletePopup();
        }

        if(!isPopupClose){
            cordova.plugins.finPlugin.backButton("", null, null);
        }
    },
    getDeviceKind:function(){
        cordova.plugins.finPlugin.getType("", function(savedType){
            $("#slt_dongleUsed").val(savedType).prop("selected", true);
            if("notuse" != savedType){
                if('blu' == savedType || 'blup' == savedType){
                    app.showBluetoothNameBox();
                    cordova.plugins.finPlugin.getDevice("", function(savedDevice){
                        app.showConnectedDeviceName(savedDevice);
                    }, function(error){
                        app.hideConnectedDevicName();
                    });
                }else {
                    app.hideBluetoothNameBox();
                }
            }else {
                app.hideBluetoothNameBox();
            }
            app.eventInit();
        }, function(error){
            app.eventInit();
        });
    },
    getPrintKind:function(){
        if(!isIphone()){
            cordova.plugins.finPlugin.getPrintType("", function(printType){
                $("#slt_print").val(printType).prop("selected", true);
                if("notuse" != printType){
                    cordova.plugins.finPlugin.getPrintName("", function(printName){
                        app.showConnectedPrintName(printName);
                    },function(error){
                        app.hidePrintNameBox();
                        $("#slt_print").val('notuse').prop("selected", true);
                    });
                }else {
                    app.hidePrintNameBox();
                }
            }, function(error){
                app.hidePrintNameBox();
                $("#slt_print").val('notuse').prop("selected", true);
            });
        }
    },
    addBleList:function(_btNameList){
        //app.showDeviceListPopup();
        var devicesList = _btNameList.split(",");
//        $(".txt").html('장비가 찾아지지 않는 경우 GPS 및 블루투스가 켜져있는지 확인 바랍니다.');
        $("#ul_devices2").html('');
        var html_data = $("#ul_devices2").html();
        for (var i = devicesList.length - 1; i >= 0; i--) {
            var html_data = html_data + "<br/><li> <a href='javascript:app.connectBleReader(\"" + devicesList[i] + "\");' class='blu_name'>" + devicesList[i] + " </a> </li>";
        }
        $("#ul_devices2").html(html_data);
    },
    addBTList:function(_btNameList){
        var devicesList = _btNameList.split(",");
//        $(".txt").html('');
        $("#ul_devices2").html('');
        var html_data = $("#ul_devices2").html();
        for (var i = devicesList.length - 1; i >= 0; i--) {
            var html_data = html_data + "<li> <a href='javascript:app.connectBTReader(\"" + devicesList[i] + "\");' class='blu_name'>" + devicesList[i] + " </a> </li>";
        }
        $("#ul_devices2").html(html_data);
    },
    addBTPrintList:function(_btNameList){
        var devicesList = _btNameList.split(",");
//        $(".txt").html('');
        $("#ul_devices2").html('');
        var html_data = $("#ul_devices2").html();
        for (var i = devicesList.length - 1; i >= 0; i--) {
            var html_data = html_data + "<li> <a href='javascript:app.connectBTPrinter(\"" + devicesList[i] + "\");' class='blu_name'>" + devicesList[i] + " </a> </li>";
        }
        $("#ul_devices2").html(html_data);
    },
    connectBleReader:function(deviceName){
        var data = {
            "deviceName":deviceName,
            "currentType":$("#slt_dongleUsed").val()
        };
        cordova.plugins.finPlugin.selectDevice(data, null, null);
        app.hideDeviceListPopup();
    },
    connectBTReader:function(deviceName){
        var data = {
            "deviceName":deviceName,
            "currentType":$("#slt_dongleUsed").val()
        };
        cordova.plugins.finPlugin.selectDevice(data, null, null);
        app.hideDeviceListPopup();
    },
    connectBTPrinter:function(deviceName){
        showToastMessage(deviceName);
        cordova.plugins.finPlugin.selectPrint(deviceName, null, null);
        app.hideDeviceListPopup();
    },
    showConnectedDeviceName:function(deviceName){
        close_Progress();
        $("#bleReader").css("display","inline-block");
        $("#bleReader").html('');
        $("#bleReader").html(deviceName);
    },
    hideConnectedDevicName:function(){
        $("#bleReader").html('');
        $("#bleReader").css("display","none");
    },
    showConnectedPrintName:function(deviceName){
        close_Progress();
        $("#printInfo").css("display","inline-block");
        $("#printInfo").html('');
        $("#printInfo").html(deviceName);
    },
    hideConnectedPrintName:function(){
        $("#printInfo").html('');
        $("#printInfo").css("display","none");
    },
    showBluetoothNameBox:function(){
        $('.connectedInfo').show();
    },
    hideBluetoothNameBox:function(){
        $('.connectedInfo').hide();
    },
    showPrintNameBox:function(){
        $('.connectedPrintInfo').show();
    },
    hidePrintNameBox:function(){
        $('.connectedPrintInfo').hide();
    },
    deleteConnectedDevice:function(){
        $("#bleReader").html('');
        $("#bleReader").css("display","none");
        cordova.plugins.finPlugin.selectType($("#slt_dongleUsed").val(), function(res){
            console.log('01_01.html ChangeType: ' + res);
            app.showDeviceListPopup();
        }, function(error){
            console.log('01_01.html ChangeType: ' + error);
        });
    },
    scanReaderBtn:function(){

        if(!$('#bleReader').html()){
            app.showDeviceListPopup();
            cordova.plugins.finPlugin.scanDevice($("#slt_dongleUsed").val(), function(res){
                console.log('01_01.html ChangeType: ' + res);
            }, function(error){
                console.log('01_01.html ChangeType: ' + error);
            });
        }else {
            open_PopupError("이미 등록된 기기가 있습니다 기존 기기를 해제 후 스캔 해 주시기 바랍니다.");
        }
    },
    selectPrintType:function(){
        cordova.plugins.finPlugin.selectPrintType($("#slt_print").val(), function(res){

        }, function(error){

        });
    },
    selectPrint:function(printName){
        cordova.plugins.finPlugin.selectPrint(printName, function(res){

        }, function(error){

        });
    },
    scanPrintBtn:function(){
        if(!$('#printInfo').html()){
            app.showDeviceListPopup();
            cordova.plugins.finPlugin.scanPrint("", function(res){
            }, function(error){
            });
        }else {
            open_PopupError("이미 등록된 프린트가 있습니다 기존 기기를 해제 후 스캔 해 주시기 바랍니다.");
        }
    },
    checkPrintType:function(){
        if(isIphone()){
            return true;
        }else {
            if('ok_bluetooth' == $("#slt_print").val() && 'blup' == $("#slt_dongleUsed").val()){
                cordova.plugins.finPlugin.getType("", function(savedType){
                    $("#slt_dongleUsed").val(savedType).prop("selected", true);
                    if('blu' == savedType || 'blup' == savedType){
                        app.showBluetoothNameBox();
                        cordova.plugins.finPlugin.getDevice("", function(savedDevice){
                            app.showConnectedDeviceName(savedDevice);
                            showToastMessage("블루투스 프린트가 연결 되어 있습니다. 선택 한 통합 타입은 프린트와 동시 사용 할 수 없습니다.");
                        }, function(error){
                            app.hideConnectedDevicName();
                            showToastMessage("블루투스 프린트가 연결 되어 있습니다. 선택 한 통합 타입은 프린트와 동시 사용 할 수 없습니다.");
                        });
                    }else {
                        app.hideBluetoothNameBox();
                    }
                    app.hideDeviceListPopup();
                    showToastMessage("블루투스 프린트가 연결 되어 있습니다. 선택 한 통합 타입은 프린트와 동시 사용 할 수 없습니다.");
                }, function(error){
                    $("#slt_dongleUsed").val(savedType).prop("notuse", true);
                });
                return false;
            }
            return true;
        }
    },
    setBattery:function(battery){
        $('#battery').html(battery);
    },
    showInputPinPopup:function(type){
        close_Progress();
        if('SCS' == type){
            $('#pinInputContent').html('<li><span class=\'blu_divice\'></span> 디바이스를 등록하려면 </li><li>기기의 \'*\'버튼을 빠르게 3번눌러</li><li>LCD창에 표시된 비밀번호 를 입력하세요.</li>');
        }else if('PRINT' == type){
            $('#pinInputContent').html('<li><span class=\'blu_divice\'></span> 디바이스를 등록하려면 </li><li>기기의 전원버튼을 빠르게 3번눌러</li><li>프린트된 비밀번호 를 입력하세요.</li>');
        }else {
            $('#pinInputContent').html('<li><span class=\'blu_divice\'></span> 디바이스를 등록하려면 </li><li>기기의 전원버튼을 빠르게 3번눌러</li><li>프린트된 비밀번호 를 입력하세요.</li>');
        }
        $('#layerPopup.Popup05').show();
    },
    hideInputPinPopup:function(){
        $('#layerPopup.Popup05').hide();
    },
    showDeviceListPopup:function(){
        close_Progress();
        cordova.plugins.finPlugin.modeChange({"popupState":"show"}, null, null);
        $('#layerPopup.Popup08').show();
    },
    hideDeviceListPopup:function(){
        cordova.plugins.finPlugin.modeChange({"popupState":"close"}, null, null);
        $("#ul_devices2").html('');
        $('#layerPopup.Popup08').hide();
    },
    showSaveCompletedPopup:function(){
        close_Progress();
        $('#layerPopup.Popup07').show();
    },
    hideSaveCompletedPopup:function(){
        $('#layerPopup.Popup07').hide();
    },
    showDeviceDeletePopup:function(){
        close_Progress();
        $('#layerPopup.Popup05_2').show();
    },
    hideDeviceDeletePopup:function(){
        $('#layerPopup.Popup05_2').hide();
    },
    mobileCert:function(){
        var data = SET02.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },
    
    mobileIntegrity:function(){
        var data = SET03.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },
    
    mobileVatSet:function(){
        var data = SET04.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },
    
    mobileUserSet:function(){
        var data = SET05.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    }
};

app.initialize();