cordova.define("com.firstdata.finplugin.finPlugin", function(require, exports, module) {
var exec = require('cordova/exec');

//// 공통 사용 액션 /////////////////////////////////////////////////////////////////////////////////////
/** 사용 타입 가져오기
*request
    없음
*response
    저장된 사용 타입 - 통합형, 연동형 (String)
*/
exports.getUseType = function (arg0, success, error) {
    var sendData;
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getUseType', [sendData]);
};
/** 사용 타입 설정하기
*request
    저장할 사용 타입 - 통합형, 연동형 (String)
response
    저장된 사용 타입 - 통합형, 연동형 (String)
*/
exports.setUseType = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'setUseType', [sendData]);
};
/** 화면 이동 시 사용
*request
    "STACK_ID":오픈할 페이지 이름 (String)
    "STACK_URL"오픈할 페이지 파일 이름 (String)
*response
    없음
*/
exports.moveStack = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'moveStack', [sendData]);
};
/** 저장된 리더기 타입 가져오기
*request
    없음
*response
    저장된 리더기타입 - blu, blup, ear, usb, notuse (String)
*/
exports.getType = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getType', [sendData]);
};
//// 01_01 블루투스 설정 페이지 액션 ///////////////////////////////////////////////////////////////////////
/** 리더기 타입 선택
 *request
    선택한 리더기 타입 - blu, blup, ear, usb, notuse (String)
 *response
    없음
 */
exports.selectType = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'selectType', [sendData]);
};
/** 선택된 리더기 저장
*request
    "deviceName":블루투스인 경우 저장할 리더기 이름 (String),
    "saveType":저장 할 리더기 타입 (String)
*response - 저장 시 무결성 검사를 실행, 무결성 검사 성공 시 Success
    성공 시 : Callback 호출
    실패 시 : 실패 원인 (String)
*/
exports.saveType = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'saveType', [sendData]);
};
/** 기기 스캔 할때 사용
*request
    리더기 타입 (String)
*response
    없음
*/
exports.scanDevice = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'scanDevice', [sendData]);
};
/** 팝업 발생 하여 생성된 기기 리스트 중 하나의 기기를 선택 하였을때 (bluetooth le, bluetooth Classic 만 있음
*request
    "deviceName":연결 할 기기 이름 (String),
    "currentType": 연결 할 리더기 타입 - blu, blup, ear, usb, notuse (String)
*response
    없음 - 네이티브에서 연결된 리더기 이름 적
*/
exports.selectDevice = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'selectDevice', [sendData]);
};
/** 화면 갱신 시 저장됬던 기기 이름 가져오기 (bluetooth le, bluetooth Classic 만 있음 용
*request
    없음
*response
    저장된 리더기 이름
*/
exports.getDevice = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getDevice', [sendData]);
};
/** 등록된 기기 삭제 (bluetooth le, bluetooth Classic 만 있음
*request
    없음
*response
    성공 여부만 Callback
*/
exports.deleteDevice = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'deleteDevice', [sendData]);
};
/** 블루투스 클래식 버전에만 필요 블루 투스 연결 시 핀 입력*/
exports.inputPin = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'inputPin', [sendData]);
};
/** 자동 수동 모드 변경
*request
    "popupState": show, close (String)
*response
    없음
*/
exports.modeChange = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'modeChange', [sendData]);
};
//// 01_02, 01_02_2, 01_02_3 모바일 인증 설정 페이지 액션 ///////////////////////////////////////////////////
/** 메인 사업장 정보 가져오기
*request
    없음
*response
    "bizOwner": 사업주 이름 (String)
    "res.bizName": 사업장 이름 (String)
    "bizAddress": 사업장 주소 (String)
    "bizTel": 사업장 전화번호 (String)

*/
exports.getMainBizData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getMainBizData', [sendData]);
};
/** 모바일 인증 요청
*request
    "businessNum":입력 된 사업자번호 (String),
    "productNum": 입력 된 제품번호 (String)
*response
    "name": 사업 주 이름 (String)
    "company": 사업장 이름 (String)
    "address": 사업장 주소 (String)
    "phone": 사업장 전화번호 (String)
*/
exports.requestPosAuth = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'requestMainAuth', [sendData]);
};
/** 모바일 인증->키교환->키저장 순서로 진행하여 최종 저장
*request
    "businessNum":입력 된 사업자번호 (String),
    "productNum": 입력 된 제품번호 (String)
*response
    성공, 실패 Callback
*/
exports.requestMainSave = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'requestMainSave', [sendData]);
};
/** 전체 사업장 가져오기 - 복수 사업장 전체 리스트 보여 주기용
*request
    없음
*response
    "merchantsList":[(String),(String),...] 전체 사업장 정보
    in String ("biz_check": 사용 유무 Y,N (String)
                "biz_name": 사업장 이름 (String)
                "biz_number": 사업자 번호 (String)
                "tid" : 리더기 번호 [catId] (String)
                "pos_auth": 메인 사업장 여부 android: Y,N, iOS:pos,merchants (String)
                )
*/
exports.getAllBizData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getAllBizData', [sendData]);
};
/** 복수 사업장 인증
*request
    "businessNum":입력 된 사업자번호 (String),
    "productNum": 입력 된 제품번호 (String)
*response
    "name": 사업 주 이름 (String)
    "company": 사업장 이름 (String)
    "address": 사업장 주소 (String)
    "phone": 사업장 전화번호 (String)
*/
exports.requestSubBizAuth = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'requestSubBizAuth', [sendData]);
};
/** 모바일 인증 복수 사업자 저장
*request
    "businessNum":입력 된 사업자번호 (String),
    "productNum": 입력 된 제품번호 (String)
*response
    성공, 실패 Callback
*/
exports.requestSubSave = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'requestSubSave', [sendData]);
};
/** 복수 사업자 삭제
*request
    "businessNum":입력 된 사업자번호 (String),
    "productNum": 입력 된 제품번호 (String)
*response
    성공, 실패 Callback
*/
exports.requestSubDelete = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'requestSubDelete', [sendData]);
};
/** 복수 사업자 선택 토글
*request
    "businessNum":입력 된 사업자번호 (String),
    "productNum": 입력 된 제품번호 (String)
    "checked": 체크 여부 (boolean)
*response
    성공, 실패 Callback
*/
exports.requestSubToggle = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'requestSubToggle', [sendData]);
};
/** 현재 복수사업장 업로드 데이터
*request
    없음
*response
    "registration_no": 메인 사업장 번호 (String)
    "serial_no":    메인 제품 번호 (String)
    "multi_registration_no": 복수 사업자 번호 - 구분자 "|" (String)
    "multi_serial_no": 복수 제품 번호 - 구분자 "|" (String)
*/
exports.getUploadBizData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getUploadBizData', [sendData]);
};
/** 복수 사업장 복구 요청
*request
    getPosInfo.json 로 부터 받아온 데이터 전달 (String)
*response
    실패,성공 Callback
    실패 시 원인 메시지 제
*/
exports.requestSubBizAuthRecovery = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'requestSubBizAuthRecovery', [sendData]);
};
/** 무결성 검사 실행
*request
    없음
*response
    실패,성공 Callback
    실패 시 원인 메시지 제공
*/
exports.operateVerify = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'operateVerify', [sendData]);
};
/** 무결성 검사 리스트 가져오기
*request
    "pageNum":페이지 정보 (String),
    "startDate":조회 시작 날짜 (String),
    "endDate":조회 종료 날짜 (String)
*response
    "totalCnt": 전체 조회된 갯수
    "verifyList":[  "_date": 검사 날짜가 YYYY-MM-DD(String),
                    "_time": 검사 시간 hh:mm:ss(String),
                    "_content": 검증 성공 여부 (String),
                    "_result":Y,N (String)]
*/
exports.searchVerifyList = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'searchVerifyList', [sendData]);
};
/** 부가세 설정 가져오기
*request
    "pageNum":페이지 정보 (String),
    "startDate":조회 시작 날짜 (String),
    "endDate":조회 종료 날짜 (String)
*response
    taxation, taxfree 저장된 세금 설정 가져옴
*/
exports.getTaxData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getTaxData', [sendData]);
};
/** 부가세 설정 하기
*request
    "isTax": 세금 여부 (boolean)
*response
    성공 여부 Callback
*/
exports.setTaxData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'setTaxData', [sendData]);
};
/** 사용자 설정 가져오기
*request
    없음
*response
    "usedType":통합형,연동형(String),
    "isMultiBiz":복수사업자 사용 여부(boolean),
    "isUnion":은련카드 사용 여부(boolean),
    "isAli":알리페이 사용 여부(boolean)
res.usedType, res.isMultiBiz, res.isUnion, res.isAli
*/
exports.getUserData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getUserData', [sendData]);
};
/** 사용자 설정 하기
*request
    "usedType":통합형,연동형(String),
    "isMultiBiz":복수사업자 사용 여부(boolean),
    "isUnion":은련카드 사용 여부(boolean),
    "isAli":알리페이 사용 여부(boolean)
*response
    저장된 사용 타입 (String)
*/
exports.setUserData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'setUserData', [sendData]);
};
/** 스키마 값 체크*/
exports.checkScheme = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'checkScheme', [sendData]);
};
/** 스키마 액션 실행*/
exports.schemeAction = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'schemeAction', [sendData]);
};
/** 가격 변동 이벤트*/
exports.changePrice = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'changePrice', [sendData]);
};
/** 알리페이 직접입력 시 현재 금액 가져오기
*request
*response
    가격 (String)
*/
exports.getAliManualAmount = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getAliManualAmount', [sendData]);
};
/** 할부 개월 변동 이벤트*/
exports.changeInstPlan = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'changeInstPlan', [sendData]);
};
/** 사업장 변경 이벤트*/
exports.changeCompany = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'changeCompany', [sendData]);
};
/** 알리페이 수기입력 업데이트*/
exports.changeAliPayNum = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'changeAliPayNum', [sendData]);
};

/** NO CVM 값 비교
*request
    "price":가격(String)
    "catId":선택한 사업장 아이디(String)
*response
    -1, 0 , 1 비교 결과 값 전달 (compareTo)
*/
exports.checkNoCVMValue = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'checkNoCVMValue', [sendData]);
};
/** READ CARD
*request
    "price":가격부(String),
    "instPlan":할부개월 수(String),
    "catId":선택한 사업장 아이디(String)
*response
    마킹된 카드값 (String)
*/
exports.requestReadCard = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'requestReadCard', [sendData]);
};
/** 결제요청
*request
    "price":가격부(String),
    "instPlan":할부개월 수(String) ; 현금결제시 확인번호,
    "catId":선택한 사업장 아이디(String),
    "sepa":발급구분(현금결제시)
    "approvalNumber":승인번호 (결제 취소 시)
    "approvalDate":승인날짜 (결제 취소 시)
*response

*/
exports.requestPayment = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'requestPayment', [sendData]);
};
/**
*request

*response
    상단 제목
*/
exports.getSignTitle = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getSignTitle', [sendData]);
};
/**
*request
    "SUBTITLE" = 결제 제목 (String)
    "CARDINFO" = F마킹된 카드번호 (String)
*response
    사인데이터 (String)
*/
exports.requestSignData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'requestSignData', [sendData]);
};
/** 사인 값 받아오기
*reqeust
    생성된 이미지 데이터 (String)
*response
    성공 여부 Callback (서명 안했을때 원인 확인용)
*/
exports.setSignData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'setSignData', [sendData]);
};
/**
*request
    "payKind": 결제 종류 (전체, 신용카드, 현금영수증, 은련카드, 알리페이) - String
    "authType": 승인 방식 (전체, 숭인, 취소) - String
    "startDate": 검색 시작 날짜 - String
    "endDate": 검색 종료 날짜 - String
    "approvalNum": 승인번호 - String
*response
    jsonarray String
    {
        "kind"
        "date"
        "time"
        "amount"
    }
*/
exports.searchReceipt = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'searchReceipt', [sendData]);
};
/**

*response
    JsonObject String
    {
        payKind
        authType
        wcc
        time
        approvalNumber
        cardNmae
        cardNumber
        notice
        buyCompany
        month
        totalAmount
        supplyAmount
        taxAmount
        storeNumber
        bizName
        ownerName
        bizNumber
        bizPhone
        bizAddress
        isCancelPayment
        alipayTransId
        alipayTransAmountCny
        alipayExchangeRate
        alipayUserLoginId
        canPrint
    }
*/
exports.getReceiptData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getReceiptData', [sendData]);
};
/**
금액 취소 요청
*request
    "approvalNumber":승인번호 (String)
    "tradeDate":승인날짜 (String)
    "totalAmount":승인금액 (String)
    "instPlan": 할부개월 (String)
    "catId": 선택된 사업장 catId (String)
*response

*/
exports.requestCancel = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'requestCancel', [sendData]);
};
/**
금액 취소 요청
*request

*response
    "approvalNumber":승인번호 (String)
    "tradeDate":승인날짜 (String)
    "totalAmount":승인금액 (String)
    "instPlan": 할부개월 (String)
    "catId": 선택된 사업장 catId (String)
*/
exports.getCancelData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getCancelData', [sendData]);
};
/**
영수증 이미지 전송
*request
    없음
*response
    없음
*/
exports.sendMMS = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'sendMMS', [sendData]);
};
/**
*영수증 프린트
*request
없음
*response
성공 여부
*/
exports.printReceipt = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'printReceipt', [sendData]);
};
/**
    일일 매출현황 DB 조회
*request
    "yy년 mm월 dd일" 포맷의 날짜 데이터
*response
    card_total - 선택된 날짜 카드 승인 전체 가격 (String)
    cash_total - 선택된 날짜 현금 승인 전체 가격 (String)
    all_total - 선택된 날짜 카드+현금 승인 전체 가격 (String)
    card_count - 선택된 날짜 카드 승인 전체 횟수 (String)
    cash_count - 선택된 날짜 현금 승인 전체 횟수 (String)
    all_count - 선택된 날짜 카드+현금 승인 전체 횟수 (String)
    card_total_cancel - 선택된 날짜 카드 취소 전체 가격 (String)
    cash_total_cancel - 선택된 날짜 현금 취소 전체 가격 (String)
    all_total_cancel - 선택된 날짜 카드+현금 취소 전체 가격 (String)
    card_count_cancel - 선택된 날짜 카드 취소 전체 횟수 (String)
    cash_count_cancel - 선택된 날짜 현금 취소 전체 횟수 (String)
    all_count_cancel - 선택된 날짜 카드+현금 취소 전체 횟수 (String)
*/
exports.getTodayTotal = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getTodayTotal', [sendData]);
};
/**
    시간대별 매출현황 DB 조회
*request
    "yy년 mm월 dd일" 포맷의 날짜 데이터
*response
    "TOTAL" - 875000원 (30건) 포맷의 전체 가격 + 건수 데이터 (String)
    "DATA" = { //array 아님
        "3000원 (2건)" - 포맷의 데이터 (String)
        "0원 (0건)" - 포맷의 데이터 (String)
        "90000원 (5건)" - 포맷의 데이터 (String)
    }
*/
exports.getTimeTotal = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getTimeTotal', [sendData]);
};
/**
    월별 매출현황 DB 조회
*request
    "yy년 mm월" 포맷의 날짜 데이터
*response
    "TOTAL" - 875000원 (30건) 포맷의 전체 가격 + 건수 데이터 (String)
    "DATA" = { //array 아님
        "3000원 (2건)" - 포맷의 데이터 (String)
        "0원 (0건)" - 포맷의 데이터 (String)
        "90000원 (5건)" - 포맷의 데이터 (String)
    }
*/
exports.getMonthTotal = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getMonthTotal', [sendData]);
};
/** Back 키 눌렀을때 액션 - 안드로이드 사용*/
exports.backButton = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'backButton', [sendData]);
};
//// 01_03.html 무결성 검사 액션 ///////////////////////////////////////////////////

/** 발급구분 변경 데이터 전송
*request
    선택한 결제 방식 - 소비자 소득공제,사업자 지출증빙,자진발급,발행안함 (String)
*response

*/
exports.onChageIssue = function (arg0, success, error) {
  if(typeof arg0 === 'string') sendData = arg0;
  else sendData = JSON.stringify(arg0);
  exec(success, error, 'finPlugin', 'onChageIssue', [sendData]);
};

/**
*request
    없음
*response
    카드 결제
    카드 취소
    현금 결제
    현금 취소
    알리 결제
    알리 취소
    설정 화면일때
*/
exports.getSchemeData = function (arg0, success, error) {
  if(typeof arg0 === 'string') sendData = arg0;
  else sendData = JSON.stringify(arg0);
  exec(success, error, 'finPlugin', 'getSchemeData', [sendData]);
};
//// 04_02.html CASH cencel 액션 ///////////////////////////////////////////////////
/** 캔슬할 데이터 가져오기*/
exports.getCashCancelInfo = function (arg0, success, error) {
 if(typeof arg0 === 'string') sendData = arg0;
 else sendData = JSON.stringify(arg0);
 exec(success, error, 'finPlugin', 'getCashCancelInfo', [sendData]);
};

/** 캔슬할 카드 정보 읽기 */
exports.CashCancelReadCard = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'CashCancelReadCard', [sendData]);
};

/** 현금 결제 취소 진행 */
exports.ReqCashCancel = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'ReqCashCancel', [sendData]);
};
//// 03_04_3.html CASH cencel receipt 액션 ///////////////////////////////////////////////////

/** 현금 결제 취소 영수증 내역 조회 */
exports.getReceitCancelCashInfo = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'getReceitCancelCashInfo', [sendData]);
};


//// 02_04_3.html ALIPAY 직접입력 액션 ///////////////////////////////////////////////////

/** AliPay 직접입력 금액 가져오기 */
exports.getAliCost = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'getAliCost', [sendData]);
};

/** AliPay 직접입력 결제요청 */
exports.reqConfirmAliSelfInput = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'reqConfirmAliSelfInput', [sendData]);
};
    
/** WechatPay 직접입력 결제요청 */
exports.reqConfirmWechatSelfInput = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'reqConfirmWechatSelfInput', [sendData]);
};

/** 
ZeroPay 직접입력 결제요청 only iOS

*/
exports.reqConfirmZeroSelfInput = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'reqConfirmZeroSelfInput', [sendData]);
};
    
    
    

//// 04_04.html ALIPAY 취소 액션 ///////////////////////////////////////////////////

/** AliPay 취소할 내역요청 */
exports.getAliCancelInfo = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'getCancelAlinfo', [sendData]);
};
//// 04_04_3.html ALIPAY 취소 직접입력 액션 ///////////////////////////////////////////////////
/** AliPay 직접입력 취소금액 가져오기 */
exports.getAliCancelCost = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'getAliCancelCost', [sendData]);
};

/** AliPay 직접입력 취소요청 */
exports.reqConfirmAliCancelSelfInput = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'reqConfirmAliCancelSelfInput', [sendData]);
};
//// 03_05_3.html ALIPAY 취소 영수증 액션 ///////////////////////////////////////////////////
/** ALIPAY 결제 취소 영수증 내역 조회 */
exports.getReceitCancelAliInfo = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'getReceitCancelAliInfo', [sendData]);
};
/** 메인 화면 슬라이드 버튼 설정 */
exports.getMainSlideBtn = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'getMainSlideBtn', [sendData]);
};
/** 블루투스 프린트 설정 iOS는 사용 안함  */
exports.selectPrintType = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'selectPrintType', [sendData]);
};
/** 블루투스 프린트 선택 iOS는 사용 안함  */
exports.selectPrint = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'selectPrint', [sendData]);
};
/** 블루투스 프린트 스캔 iOS는 사용 안함  */
exports.scanPrint = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'scanPrint', [sendData]);
};
/** 블루투스 프린트 타입 가져옴 iOS는 사용 안함  */
exports.getPrintType = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'getPrintType', [sendData]);
};
/** 저장된 블루투스 프린트 이름 가져옴 iOS는 사용 안함  */
exports.getPrintName = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'getPrintName', [sendData]);
};
exports.requestPinPassword = function (arg0, success, error) {
if(typeof arg0 === 'string') sendData = arg0;
else sendData = JSON.stringify(arg0);
exec(success, error, 'finPlugin', 'requestPinPassword', [sendData]);
};
               
/** TMS */
/** 인증 여부 확인 및 메인 제품번호 가져오기 기능
response
    serial_no - 메인사업장 제품 번호 - String

*/
exports.getMainProductNo = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getMainProductNo', [sendData]);
};
/** TMS 업로드 상태 확인
0 UPDATE_CHECK1   부터 시작
1 UPDATE_CHECK2   부터 시작
2 UPDATE_CHECK3   부터 시작

return 0~2 상태 값
*/
exports.getTMSStatus = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getTMSStatus', [sendData]);
};
exports.setTMSStatus = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'setTMSStatus', [sendData]);
};
/**
    기기정보 설정 정보 전달 (메인 인증 데이터)
    response
        registration_no - 메인 사업장 번호 - String (same with businessNo)
        serial_no - 메인 제 번호 - String (same with productNo)
        os_ver - OS 버전 - String
        native_version - 앱 버전 - String
        device_model - 기기 모델 명 - String
        os_type_cd - OS구분 코드 A:안드로이드, I:아이폰 - String
        create_dt - 앱 생성 날짜 - String
        certification_expired - 인증서 만료 날짜 - String
        profile_expired - Provisioning Profile 만료 날짜 - String
        install_path - 설치 경로 S:Store, M:머니온- String -> 번들id를 체크해서 맨뒤가 ST로 끝나면 'S', 아니면 'M'을 넣는다
        hw_firmware_version - 리더기 펌웨어 버전 (리더기 연결 시 정보에 나옴) - String
        cardreader_name - 리더기 이름 (블루투스인 경우 이름, 그외는 빈칸) - String
        print_name - 블루투스 프린트 이름 (ios는 빈칸) - String
*/
exports.setDeviceInfo = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'setDeviceInfo', [sendData]);
};
/**
    기기정보 설정 정보 전달 (메인 인증 (삭제할 사업장 데이터와 복수 사업자 추가) 데이터)
    response
        registration_no - 메인 사업장 번호 - String (same with businessNo)
        serial_no - 메인 제 번호 - String (same with productNo)
        multi_registration_no - 복수 사업장 번호 (구분자 | ) - String
        multi_serial_no - 복수 제품번호 (구분자 | ) - String
        del_registration_no - 인증 받기 전 사업장 번호 - String
        del_serial_no - 인증 받기 전 제품 번호 - String
        os_ver - OS 버전 - String
        native_version - 앱 버전 - String
        device_model - 기기 모델 명 - String
        os_type_cd - OS구분 코드 A:안드로이드, I:아이폰 - String
        create_dt - 앱 생성 날짜 - String
        certification_expired - 인증서 만료 날짜 - String
        profile_expired - Provisioning Profile 만료 날짜 - String
        install_path - 설치 경로 S:Store, M:머니온- String -> 번들id를 체크해서 맨뒤가 ST로 끝나면 'S', 아니면 'M'을 넣는다
        hw_firmware_version - 리더기 펌웨어 버전 (리더기 연결 시 정보에 나옴) - String
        cardreader_name - 리더기 이름 (블루투스인 경우 이름, 그외는 빈칸) - String
        print_name - 블루투스 프린트 이름 (ios는 빈칸) - String
*/
exports.setDeviceInfoChange = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'setDeviceInfoChange', [sendData]);
};
/**
오늘 TMS 업데이트 체커 했는지 확인 용
return - Success OR Error
*/
exports.checkTodayTMS = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'checkTodayTMS', [sendData]);
};
/**
업데이트 체크 시 날짜 및 버전 확인 팝업
*/
exports.checkUpdatePopup = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'checkUpdatePopup', [sendData]);
};
/**
연동형에서 이어잭인데 은련카드 선택 시
*/
exports.returnerForUnionPayEarDongle = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'returnerForUnionPayEarDongle', [sendData]);
};
/*
카카오페이 조회
request
    catId
    price
response
    referenceNo
    payType
*/
exports.requestKakaoInquiry = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'requestKakaoInquiry', [sendData]);
};
/*
카카오 수동입력 값 업데이트
*/
exports.changeKakaoPayNum = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'changeKakaoPayNum', [sendData]);
};
/*
    카카오페이 데이터 가져오기
    request
    reseponse
        payType
        amount
        discount
        catId
        referenceNo
        companyName
        companyNumber
*/
exports.getKakaoPayData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getKakaoPayData', [sendData]);
};
//수동 바코드 입력 시 값 가져오기
exports.getKakaoManualAmount = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'getKakaoManualAmount', [sendData]);
};
//iOS전용
exports.onUnionCardRequestBySign = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'onUnionCardRequestBySign', [sendData]);
};
exports.setSignUnionData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'setSignUnionData', [sendData]);
};
exports.setCancelUnionSignData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'setCancelUnionSignData', [sendData]);
};
exports.setCancelSignData = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'setCancelSignData', [sendData]);
};
/*
    연동형이며 모바일 인증 화면 시 호출앱으로 부터 받아온 데이터가 있는지 확인 한다
    request
    reseponse
        bizNum
        prdNum
*/
exports.checkCompanyInfo = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'checkCompanyInfo', [sendData]);
};
exports.checkBattery = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'checkBattery', [sendData]);
};
/**
only Android
*/
exports.saveFileTest = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'saveFileTest', [sendData]);
};
/*
    설정된 사업장 DB내역 보기
*/
exports.saveFileMobileAuth = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'saveFileMobileAuth', [sendData]);
};
/**
 로그파일 업로드
 */
exports.uploadLogFile = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'uploadLogFile', [sendData]);
};
/**
 메인 화면에 기기 표시 only iOS
 */
exports.refreshDeviceInfo = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'refreshDeviceInfo', [sendData]);
};
exports.isDebugCheck = function (arg0, success, error) {
    if(typeof arg0 === 'string') sendData = arg0;
    else sendData = JSON.stringify(arg0);
    exec(success, error, 'finPlugin', 'isDebugCheck', [sendData]);
};
});

