var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function(){
//         var successCallback = function(data){
//             var slideData = JSON.parse(data);
//             if(isIphone()){
// //                app.refreshBxSlider(slideData["union"], slideData["ali"], slideData["kakao"]);
//                 app.refreshBxSlider2(slideData.credit, slideData.cash, slideData.union, slideData.ali, slideData.kakao, slideData.wechat, slideData.zero);
//             }else {
//                 //app.refreshBxSlider(slideData.union, slideData.ali, slideData.kakao);
//                 app.refreshBxSlider2(slideData.credit, slideData.cash, slideData.union, slideData.ali, slideData.kakao, slideData.wechat, slideData.zero);
//             }
//         };
//         var failureCallback = function(error){
// //            app.refreshBxSlider(true, true);
//             app.refreshBxSlider2(true, true, true, true, true, true, true);
//         };
//         cordova.plugins.finPlugin.getMainSlideBtn("", successCallback, failureCallback);
    },
    eventInit:function(){

        /** 배터리 체크*/
        $("#batteryCheck").off("click").on("click", function(){
            cordova.plugins.finPlugin.checkBattery("", null, null);
        });
        /** 영수증 화면으로 이동*/
        $("#chkgotoReceiptSearch").off("click").on("click", function(){
            app.chkgotoReceiptSearch();
        });
        /** 매출현황*/
        $("#chkgotoSearchForToday").off("click").on("click", function(){
            app.chkgotoSearchForToday();
        });
        $("#chkgotoSearchForTime").off("click").on("click", function(){
            app.chkgotoSearchForTime();
        });
        $("#chkgotoSearchForMonth").off("click").on("click", function(){
            app.chkgotoSearchForMonth();
        });
        /** 설정*/
        $("#gotoDongleSetting").off("click").on("click", function(){
            app.gotoDongleSetting();
        });
        $("#gotoMobileAuth").off("click").on("click", function(){
            app.gotoMobileAuth();
        });
        $("#gotoVerify").off("click").on("click", function(){
            app.gotoVerify();
        });
        $("#gotoTaxSet").off("click").on("click", function(){
            app.gotoTaxSet();
        });
        $("#gotoUserSet").off("click").on("click", function(){
            app.gotoUserSet();
        });
    },
    otherInit:function(){
          document.addEventListener("backbutton", app.backbuttonAction, false);
          UPDATE_CHECK();
     },
    backbuttonAction:function(){
        cordova.plugins.finPlugin.backButton("", null, null);
    },
    refreshBxSlider:function(_isUseUnionPay, _isUseAliPay, _isUserKakaoPay) {
        var mainSlider = document.getElementById('mainSlider');
        mainSlider.innerHTML = "";
        
        var bxSlider;
        if (!_isUseUnionPay && !_isUseAliPay && !_isUserKakaoPay) {
            bxSlider = mainSlider;
        } else {
            bxSlider = document.createElement("div");
            bxSlider.setAttribute('class', 'bxslider');
            mainSlider.appendChild(bxSlider);
        }
        //첫번째 슬라이드 생성
        var div = document.createElement("div");
        div.setAttribute('style', 'position:inherit;');
        bxSlider.appendChild(div);
        //첫번째 슬라이드 배경이미지 생성
        var img = document.createElement('img');
        img.setAttribute('src', '../images/sliderBackground.png');
        div.appendChild(img);
        //첫번째 슬라이드에 신용카드 공간 생성
        var divCredit = document.createElement("div");
        divCredit.setAttribute('class', 'mainLink01');
        div.appendChild(divCredit);
        //첫번째 슬라이드에 신용카드 클릭 이벤트 적용
        var aCredit = document.createElement('a');
        aCredit.setAttribute('onclick', "app.gotoCardPayment();");
        divCredit.appendChild(aCredit);
        //첫번째 슬라이드에 신용카드 이미지 적용
        var imgCredit = document.createElement('img');
        imgCredit.setAttribute('src', '../images/slider01_1.png');
        aCredit.appendChild(imgCredit);

        var divCash = document.createElement("div");
        divCash.setAttribute('class', 'mainLink02');
        div.appendChild(divCash);

        var aCash = document.createElement('a');
        aCash.setAttribute('onclick', "app.gotoCashPayment();");
        divCash.appendChild(aCash);

        var imgCash = document.createElement('img');
        imgCash.setAttribute('src', '../images/slider01_2.png');
        aCash.appendChild(imgCash);

        if (!_isUseUnionPay && !_isUseAliPay && !_isUserKakaoPay) {
            return;
        }
        var div2 = document.createElement("div");
        div2.setAttribute('style', 'position:inherit;');
        bxSlider.appendChild(div2);

        var img2 = document.createElement('img');
        img2.setAttribute('src', '../images/sliderBackground.png');
        div2.appendChild(img2);

        var secondSlideCnt = 0;
        if (_isUseUnionPay) {
            secondSlideCnt++;
            var divUnionPay = document.createElement("div");
            divUnionPay.setAttribute('class', 'mainLink01');
            div2.appendChild(divUnionPay);

            var aUnionPay = document.createElement('a');
            aUnionPay.setAttribute('onclick', "app.gotoUnionPayment();");
            divUnionPay.appendChild(aUnionPay);

            var imgUnionPay = document.createElement('img');
            imgUnionPay.setAttribute('src', '../images/slider02_1.png');
            aUnionPay.appendChild(imgUnionPay);
        }

        if (_isUseAliPay) {
            secondSlideCnt++;
            var divAliPay = document.createElement("div");
            if (_isUseUnionPay) {
                divAliPay.setAttribute('class', 'mainLink02');
            } else {
                divAliPay.setAttribute('class', 'mainLink01');
            }
            div2.appendChild(divAliPay);

            var aAliPay = document.createElement('a');
            aAliPay.setAttribute('onclick', "app.gotoAliPayment();");
            divAliPay.appendChild(aAliPay);

            var imgAliPay = document.createElement('img');
            imgAliPay.setAttribute('src', '../images/slider02_2.png');
            aAliPay.appendChild(imgAliPay);
        }
        if(_isUserKakaoPay){
            if(2 > secondSlideCnt){
                app.kakaopaySecondSlide(secondSlideCnt, div2, bxSlider);
            }else {
                app.kakaopayThirdSlide(bxSlider);
            }
        }

        $('.bxslider').bxSlider({
            auto : true,
            controls : false
        });
    },
    refreshBxSlider2:function(_isUseCredit, _isUseCash, _isUseUnionPay, _isUseAliPay, _isUserKakaoPay, _isUseWechatPay, _isUseZeroPay) {
            var mainSlider = document.getElementById('mainSlider');
            mainSlider.innerHTML = "";
//            var _isUseWechatPay = true;
            //var _isUseZeroPay = true;
            var bxSlider;
            bxSlider = document.createElement("div");
//            bxSlider.setAttribute('class', 'bxslider');
            bxSlider.setAttribute('class', 'slick');
//            bxSlider.setAttribute('id', 'bxSlider');

            mainSlider.appendChild(bxSlider);

            //첫번째 슬라이드 생성
            var div = document.createElement("div");
            div.setAttribute('style', 'position:inherit;');
            //첫번째는 무조건 생성
            bxSlider.appendChild(div);
            //첫번째 슬라이드 배경이미지 생성
            var img = document.createElement('img');
            img.setAttribute('src', '../images/sliderBackground.png');
            div.appendChild(img);

            //두번째 슬라이드 생성
            var div2 = document.createElement("div");
            div2.setAttribute('style', 'position:inherit;');
            //두번째 슬라이드가 채워지면 추가 할것
            //bxSlider.appendChild(div2);
            var img2 = document.createElement('img');
            img2.setAttribute('src', '../images/sliderBackground.png');
            div2.appendChild(img2);

            //세번째 슬라이드 생성
            var div3 = document.createElement("div");
            div3.setAttribute('style', 'position:inherit;');
            //세번째 슬라이드가 채워지면 추가 할것
            //bxSlider.appendChild(div3);
            var img3 = document.createElement('img');
            img3.setAttribute('src', '../images/sliderBackground.png');
            div3.appendChild(img3);

            //네번째 슬라이드 생성
            var div4 = document.createElement("div");
            div4.setAttribute('style', 'position:inherit;');
            //세번째 슬라이드가 채워지면 추가 할것
            //bxSlider.appendChild(div3);
            var img4 = document.createElement('img');
            img4.setAttribute('src', '../images/sliderBackground.png');
            div4.appendChild(img4);
        
            var slidCnt_first = 0;
            var slidCnt_second = 0;
            var slidCnt_third = 0;
            var slidCnt_fourth = 0;
        
            if(_isUseCredit){
                if(2 > slidCnt_first){
                    div.appendChild(app.creditPayAdd(slidCnt_first));
                    slidCnt_first++;
                }
            }
            if(_isUseCash){
                if(2 > slidCnt_first){
                    div.appendChild(app.cashPayAdd(slidCnt_first));
                    slidCnt_first++;
                }
            }
            if(_isUseUnionPay){
                if(2 > slidCnt_first){
                    div.appendChild(app.unionPayAdd(slidCnt_first));
                    slidCnt_first++;
                }else if( 2 > slidCnt_second){
                    if(0 == slidCnt_second) bxSlider.appendChild(div2);
                    div2.appendChild(app.unionPayAdd(slidCnt_second));
                    slidCnt_second++;
                }else {
                    if(0 == slidCnt_third) bxSlider.appendChild(div3);
                    div3.appendChild(app.unionPayAdd(slidCnt_third));
                    slidCnt_third++;
                }
            }
            if(_isUseAliPay){
                if(2 > slidCnt_first){
                    div.appendChild(app.aliPayAdd(slidCnt_first));
                    slidCnt_first++;
                }else if( 2 > slidCnt_second){
                    if(0 == slidCnt_second) bxSlider.appendChild(div2);
                    div2.appendChild(app.aliPayAdd(slidCnt_second));
                    slidCnt_second++;
                }else {
                    if(0 == slidCnt_third) bxSlider.appendChild(div3);
                    div3.appendChild(app.aliPayAdd(slidCnt_third));
                    slidCnt_third++;
                }
            }
            if(_isUserKakaoPay){
                if(2 > slidCnt_first){
                    div.appendChild(app.kakaoPayAdd(slidCnt_first));
                    slidCnt_first++;
                }else if( 2 > slidCnt_second){
                    if(0 == slidCnt_second) bxSlider.appendChild(div2);
                    div2.appendChild(app.kakaoPayAdd(slidCnt_second));
                    slidCnt_second++;
                }else {
                    if(0 == slidCnt_third) bxSlider.appendChild(div3);
                    div3.appendChild(app.kakaoPayAdd(slidCnt_third));
                    slidCnt_third++;
                }
            }
            if(_isUseWechatPay){
                if(2 > slidCnt_first){
                    div.appendChild(app.wechatPayAdd(slidCnt_first));
                    slidCnt_first++;
                }else if( 2 > slidCnt_second){
                    if(0 == slidCnt_second) bxSlider.appendChild(div2);
                    div2.appendChild(app.wechatPayAdd(slidCnt_second));
                    slidCnt_second++;
                }else {
                    if(0 == slidCnt_third) bxSlider.appendChild(div3);
                    div3.appendChild(app.wechatPayAdd(slidCnt_third));
                    slidCnt_third++;
                }
            }
            if(_isUseZeroPay){
                if(2 > slidCnt_first){
                    div.appendChild(app.zeroPayAdd(slidCnt_first));
                    slidCnt_first++;
                }else if( 2 > slidCnt_second){
                    if(0 == slidCnt_second) bxSlider.appendChild(div2);
                    div2.appendChild(app.zeroPayAdd(slidCnt_second));
                    slidCnt_second++;
                }else if( 2 > slidCnt_third) {
                    if(0 == slidCnt_third) bxSlider.appendChild(div3);
                    div3.appendChild(app.zeroPayAdd(slidCnt_third));
                    slidCnt_third++;
                }else {
                    if(0 == slidCnt_fourth) bxSlider.appendChild(div4);
                    div4.appendChild(app.zeroPayAdd(slidCnt_fourth));
                    slidCnt_fourth++;
                }
            }
            $('.slick').each(
                function(){
                    $(this).not(".slick-initialized").slick({
                        fade: false,
                        autoplay: true,
                        autoplaySpeed: 2800,
                        speed: 2000,
                        slideToShow:1,
                        slidesToScroll: 1,
                        infinite: true,
                        vertical: false,
                        arrow: false,
                        dots: true,
                        accessibility: false,
                        draggable: false,
                        pauseOnHover: false
                    });
                }
            );
//            $('.bxslider').bxSlider({
//                auto : true,
//                controls : false,
//                buildPager: function(slideIndex) {
//                    return '';
//                }
//            });
//            sleep(1000);
//            if(window.navigator.userAgent.toLowerCase().indexOf("chrome") > 0) {
//                $("body").on("mousedown", ".bx-viewport a", function() {
//                    if($(this).attr("href") && $(this).attr("href") != "#") {
//                        window.location=$(this).attr("href");
//                    }
//                });
//            }
        },
        creditPayAdd:function(slidCnt){
            //첫번째 슬라이드에 신용카드 공간 생성
            var divCredit = document.createElement("div");
            if(0 == slidCnt) divCredit.setAttribute('class', 'mainLink01');
            else divCredit.setAttribute('class', 'mainLink02');

            //첫번째 슬라이드에 신용카드 클릭 이벤트 적용
            var aCredit = document.createElement('a');
            aCredit.setAttribute('onclick', "app.gotoCardPayment();");
            divCredit.appendChild(aCredit);
            //첫번째 슬라이드에 신용카드 이미지 적용
            var imgCredit = document.createElement('img');
            imgCredit.setAttribute('src', '../images/slider01_1.png');

            aCredit.appendChild(imgCredit);

            return divCredit;
        },
        cashPayAdd:function(slidCnt){
            var divCash = document.createElement("div");
            if(0 == slidCnt) divCash.setAttribute('class', 'mainLink01');
            else divCash.setAttribute('class', 'mainLink02');

            var aCash = document.createElement('a');
            aCash.setAttribute('onclick', "app.gotoCashPayment();");
            divCash.appendChild(aCash);

            var imgCash = document.createElement('img');
            imgCash.setAttribute('src', '../images/slider01_2.png');
            aCash.appendChild(imgCash);

            return divCash;
        },
        unionPayAdd:function(slidCnt){
            var divUnionPay = document.createElement("div");
            if(0 == slidCnt) divUnionPay.setAttribute('class', 'mainLink01');
            else divUnionPay.setAttribute('class', 'mainLink02');

            var aUnionPay = document.createElement('a');
            aUnionPay.setAttribute('onclick', "app.gotoUnionPayment();");
            divUnionPay.appendChild(aUnionPay);

            var imgUnionPay = document.createElement('img');
            imgUnionPay.setAttribute('src', '../images/slider02_1.png');
            aUnionPay.appendChild(imgUnionPay);
            return divUnionPay;
        },
        aliPayAdd:function(slidCnt){
            var divAliPay = document.createElement("div");
            if(0 == slidCnt) divAliPay.setAttribute('class', 'mainLink01');
            else divAliPay.setAttribute('class', 'mainLink02');

            var aAliPay = document.createElement('a');
            aAliPay.setAttribute('onclick', "app.gotoAliPayment();");
            divAliPay.appendChild(aAliPay);

            var imgAliPay = document.createElement('img');
            imgAliPay.setAttribute('src', '../images/slider02_2.png');
            aAliPay.appendChild(imgAliPay);
            return divAliPay;
        },
        kakaoPayAdd:function(slidCnt){
            var divKakaoPay = document.createElement("div");
            if(0 == slidCnt) divKakaoPay.setAttribute('class', 'mainLink01');
            else divKakaoPay.setAttribute('class', 'mainLink02');

            var aKakaoPay = document.createElement('a');
            aKakaoPay.setAttribute('onclick', "app.gotoKakaoPayment();");
            divKakaoPay.appendChild(aKakaoPay);

            var imgKakaoPay = document.createElement('img');
            imgKakaoPay.setAttribute('src', '../images/slider03_1.png');
            aKakaoPay.appendChild(imgKakaoPay);
            return divKakaoPay;
        },
         wechatPayAdd:function(slidCnt){
             var divWechatPay = document.createElement("div");
             if(0 == slidCnt) divWechatPay.setAttribute('class', 'mainLink01');
             else divWechatPay.setAttribute('class', 'mainLink02');

             var aWechatPay = document.createElement('a');
             aWechatPay.setAttribute('onclick', "app.gotoWechatPayment();");
             divWechatPay.appendChild(aWechatPay);

             var imgWechatPay = document.createElement('img');
             imgWechatPay.setAttribute('src', '../images/slider03_2.png');
             aWechatPay.appendChild(imgWechatPay);
             return divWechatPay;
         },
        zeroPayAdd:function(slidCnt){
            var divZeroPay = document.createElement("div");
            if(0 == slidCnt) divZeroPay.setAttribute('class', 'mainLink01');
            else divZeroPay.setAttribute('class', 'mainLink02');

            var aZeroPay = document.createElement('a');
            aZeroPay.setAttribute('onclick', "app.gotoZeroPayment();");
            divZeroPay.appendChild(aZeroPay);

            var imgZeroPay = document.createElement('img');
            imgZeroPay.setAttribute('src', '../images/slider04_1.png');
            aZeroPay.appendChild(imgZeroPay);
            return divZeroPay;
        },
    kakaopaySecondSlide:function(slidCnt, baseDiv, bxSlider){
        var divKakaoPay = document.createElement("div");
        if(0 == slidCnt){
            divKakaoPay.setAttribute('class', 'mainLink01');
        }else {
            divKakaoPay.setAttribute('class', 'mainLink02');
        }
        baseDiv.appendChild(divKakaoPay);
        var aKakaoPay = document.createElement('a');
        aKakaoPay.setAttribute('onclick', "app.gotoKakaoPayment();");
        divKakaoPay.appendChild(aKakaoPay);

        var imgKakaoPay = document.createElement('img');
        imgKakaoPay.setAttribute('src', '../images/slider03_1.png');
        aKakaoPay.appendChild(imgKakaoPay);
    },
    kakaopayThirdSlide:function(bxSlider){
        //첫번째 슬라이드 생성
        var div3 = document.createElement("div");
        div3.setAttribute('style', 'position:inherit;');
        bxSlider.appendChild(div3);
        //첫번째 슬라이드 배경이미지 생성
        var img = document.createElement('img');
        img.setAttribute('src', '../images/sliderBackground.png');
        div3.appendChild(img);
        //첫번째 슬라이드에 신용카드 공간 생성
        var divCredit = document.createElement("div");
        divCredit.setAttribute('class', 'mainLink03');
        div3.appendChild(divCredit);
        //첫번째 슬라이드에 신용카드 클릭 이벤트 적용
        var aCredit = document.createElement('a');
        aCredit.setAttribute('onclick', "app.gotoKakaoPayment();");
        divCredit.appendChild(aCredit);
        //첫번째 슬라이드에 신용카드 이미지 적용
        var imgCredit = document.createElement('img');
        imgCredit.setAttribute('src', '../images/slider03_1.png');
        aCredit.appendChild(imgCredit);
    },
    gotoCardPayment:function(){
        this.moveStack(CARD_PAY.DATA);
    },
    gotoCashPayment:function(){
        this.moveStack(CASH_PAY.DATA);
    },
    gotoUnionPayment:function(){
        this.moveStack(UNION_PAY.DATA);
    },
    gotoAliPayment:function(){
        this.moveStack(ALI_PAY.DATA);
    },
    gotoKakaoPayment:function(){
        this.moveStack(KAKAO_SEARCH.DATA);
    },
    gotoWechatPayment:function(){
        this.moveStack(WECHAT_PAY.DATA);
    },
    gotoZeroPayment:function(){
        this.moveStack(ZERO_PAY.DATA);
    },
    chkgotoReceiptSearch:function(){
        this.moveStack(RECEIPT.DATA);
    },
    chkgotoSearchForToday:function(){
        this.moveStack(TODAY_CON.DATA);
    },
    chkgotoSearchForTime:function(){
        this.moveStack(TIME_CON.DATA);
    },
    chkgotoSearchForMonth:function(){
        this.moveStack(MONTH_CON.DATA);
    },
    gotoDongleSetting:function(value){
        this.moveStack(SET01.DATA);
    },
    gotoMobileAuth:function(value){
        this.moveStack(SET02.DATA);
    },
    gotoVerify:function(value){
        this.moveStack(SET03.DATA);
    },
    gotoTaxSet:function(value){
        this.moveStack(SET04.DATA);
    },
    gotoUserSet:function(value){
        this.moveStack(SET05.DATA);
    },
    moveStack:function(data){
        cordova.plugins.finPlugin.moveStack(data, null,null);
    
    },
    hideAuthInfo:function(){
        $('#mobile_dongle').html('모바일 리더기 : ');
    },
    showAuthInfo:function(authInfo){
        $('#mobile_dongle').html('모바일 리더기 : ' + authInfo);
    }
};

app.initialize();