var startDate;
var endDate;
var kindName;
var catId;

var amountTotal;
var receiptNumber;

var approvalNumber;
var approvalTime;
var instPlan;


var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function() {
        $(document).on("keyup", ".uPayN", function() {
            $(this).number(true);
        });
        if ($(".uPayN").length > 0) {
            $(".uPayN").number(true);
        }

        if(isIphone()){
            jQuery('#print_button').css("display", "none");
        }
        
        var data = {"TYPE":"CANCEL_UNION_CARD"};
        
        cordova.plugins.finPlugin.getReceiptData(data,function(res){
            app.showReceiptData(res);
        }, function(error){
            showToastMessage(error);
        });
    },
    eventInit:function(){

    },
    otherInit:function(){

    },
    showReceiptData:function(res){
        var receiptData = JSON.parse(res);
        if(null == receiptData) return;
        
        $("#li_kind_sub").html(receiptData['tradingCategory']);
        $("#li_kind").html(receiptData['cardName']);
        $("#li_time").html(receiptData['dateAndTime']);
        $("#li_cardNumber").html(receiptData['cardNumber']);
        $("#li_month").html(receiptData['installDoc']);
        $("#li_readerNumber").html(receiptData['merchantNumber']);
        $("#li_approval").html(receiptData['approvalNumber']);
        $("#li_buyCompany").html(receiptData['acquirersName']);
        $("#li_supply").html("- " + receiptData['supplyAmount'] + " 원");
        $("#li_tax").html("- " + receiptData['taxAmount'] + " 원");
        $("#li_total").html("- " + receiptData['totalAmount'] + " 원");
        $("#li_bizName").html(receiptData['storeName']);
        $("#li_bizNumber").html(receiptData['businessNumber']);
        $("#li_bizOwner").html(receiptData['represent']);
        $("#li_bizCallNumber").html(receiptData['storePhone']);
        $("#li_bizAddress").html(receiptData['storeAddress']);
        
        
        receiptNumber = receiptData['receiptNumber'];
        catId = receiptData['readerNumber'];
        amountTotal = receiptData['totalAmount'];
        approvalNumber = receiptData['approvalNumber'];
        approvalTime = receiptData['dateOfApproval'];
        instPlan = receiptData['installment'];
    },
    sendMMS:function(){
        if(isIphone())
        {
            var data = {"TYPE":"CANCEL_UNION_CARD"};
            cordova.plugins.finPlugin.sendMMS(data,null, null);
        }else
        {
            cordova.plugins.finPlugin.sendMMS("",null, null);
        }
    },
    closeStack:function(){
        cordova.plugins.finPlugin.backButton("", null, null);
    },backbuttonAction:function(){
        var isPopupClose = false;
        if ($("#layerPopup.Popup12").is(':visible')){
            isPopupClose = true;
            app.hideWarnningPopup();
        }
        if(!isPopupClose){
            cordova.plugins.finPlugin.backButton("", null, null);
        }
    },backReceipAction:function(){
        cordova.plugins.finPlugin.moveStack(RECEIPT.DATA, null,null);
    }
};

app.initialize();
