var app = {
    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function() {
        this.itemInit();
        this.eventInit();
        this.otherInit();
    },
    itemInit:function() {
        //상단 표기 상태 변경
        cordova.plugins.finPlugin.getUseType("", function(res){
            if(0 < res.length){
                if('연동형' == res){
                  if(isIphone()){
                    $("#hd_title").html("<a href='#' onclick='app.backbuttonAction();' ><h3 class='btnPre'><span class='blind'>이전</span></h3></a><h3 class='title'>무결성 검사</h3><h3 id='battery' class='battery'><span></span></h3>");
                    cordova.plugins.finPlugin.checkBattery("", function(battery){
                        updateBattery(true, battery)
                    },function(error){
                        updateBattery(false, '')
                    });
                  }else {
                    $("#hd_title").html("<h3 class='title'>무결성 검사</h3><h3 id='battery' class='battery'><span></span></h3>");
                  }
                    
                }
            }
        }, null);
    },
    eventInit:function(){
        /* 무결성 검사 조회 화면 이동*/
        $('#searchVerify').on('click',function(){
            cordova.plugins.finPlugin.moveStack(SET03_1.DATA, null, null);
        });
        /* 무결성 검사 실행*/
        $('#goVerify').on('click',function(){
            app.operateVerify();
        });
    },
    otherInit:function(){
        if(isIphone()){

        }else {
            document.addEventListener("backbutton", app.backbuttonAction, false);
        }
        UPDATE_CHECK();
    },
    backbuttonAction:function(){
        var isPopupClose = false;
        if(!isPopupClose){
            cordova.plugins.finPlugin.backButton("", null, null);
        }
    },
    setBattery:function(battery){
        $('#battery').html(battery);
    },
    operateVerify:function(){
        open_Progress("무결성 검사 실행 중 입니다.");
        var successCallback = function(res){
            close_Progress();
            open_verifyPopup(true);
        };
        var failureCallback = function(error){
            //실패 시 실패 팝업 발생
            close_Progress();
            open_verifyPopup(false);
        };
        cordova.plugins.finPlugin.operateVerify("operateVerify", successCallback, failureCallback);
    },
    mobileCert:function(){
        var data = SET02.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },
    mobileIntegrity:function(){
        var data = SET03.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },
    mobileSetting:function(){
        var data = SET01.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    },
    mobileVatSet:function(){
        var data = SET04.DATA;
        cordova.plugins.finPlugin.moveStack(data,null,null);
    },
    
    mobileUserSet:function(){
        var data = SET05.DATA;
        cordova.plugins.finPlugin.moveStack(data, null,null);
    }
};

app.initialize();