var FrontView = function(){

    this.selectTableGroupList = "SELECT TG_CD, TG_NM FROM SCD_TBGRP_T WHERE SHOP_CD = ? AND   USE_YN  = 'Y' ORDER BY TG_SORT, TG_CD ";
    this.selectTableList = "SELECT TBL.TABLE_CD , TBL.TABLE_NM, TBL.TG_CD, TBG.TG_NM, TBG.TG_SORT FROM SCD_TABLE_T TBL LEFT JOIN SCD_TBGRP_T TBG ON TBG.TG_CD = TBL.TG_CD "
                            + " WHERE TBL.SHOP_CD = ?  AND TBL.SHAPE_FG <> '4' AND   TBL.USE_YN  = 'Y' ";


    this.fnGetNotifyTalk = function(){
        var returnTemplate = { template: '#notifyTalk'
            , created : function() {
                util.logInfo('notifyTalk created==' + this.alertPopupShow);
            }
            ,mounted : function() {
                this.mealTake = this.$route.params.id;
                basicOrderInfo.notifyTalkPhoneNo = "";
                // 영어일 때, 정보이용동의 버튼의 체크버튼을 왼쪽으로 좀더 이동시킨다. (영문이 길어서 포지션 맞춤)
                if(langCode == "en"){
                	this.engStyle = "eng"
                }else{
                	this.engStyle = ""
                }
                 
                $( document ).ready(function() {
                    var checkoutHistory = document.getElementById('showCheckoutHistory');
                    checkoutHistory.onchange = function() {
                        console.log(checkoutHistory);
                        util.logInfo('notifyTalk checkoutHistory.checked : ' + checkoutHistory.checked);
                        
                        if (checkoutHistory.checked) {
                            $('.alert_message_wrap').fadeOut(500);
                        } else {
                            $('.alert_message_wrap').fadeIn(500);
                        }
                    }
                });
                
                util.logInfo('notifyTalk mounted==' + this.mealTake);
            }
            ,data: function(){
                return {
                    phoneNo : "",
                    mealTake : "",
                    menuReady1 : util.languageObjReturn(langCode, 'menuReady1'),
                    menuReady2 : util.languageObjReturn(langCode, 'menuReady2'),
                    personalInfo : util.languageObjReturn(langCode, 'personalInfo'),
                    orderTextMessage : util.languageObjReturn(langCode, 'orderTextMessage'),
                    personalInfoItem : util.languageObjReturn(langCode, 'personalInfoItem'),
                    phoneNumber : util.languageObjReturn(langCode, 'phoneNumber'),
                    periodPersonalInfo : util.languageObjReturn(langCode, 'periodPersonalInfo'),
                    messageNotiService : util.languageObjReturn(langCode, 'messageNotiService'),
                    refuseAgreement : util.languageObjReturn(langCode, 'refuseAgreement'),
                    refusePersonalInfo : util.languageObjReturn(langCode, 'refusePersonalInfo'),
                    chargedAcco : util.languageObjReturn(langCode, 'chargedAcco'),
                    cancelTextMessageService : util.languageObjReturn(langCode, 'cancelTextMessageService'),
                    infoAgree : util.languageObjReturn(langCode, 'infoAgree'),
                    contentsView : util.languageObjReturn(langCode, 'contentsView'),
                    inputComp : util.languageObjReturn(langCode, 'inputComp'),
                    engStyle : "",
                    infoChkMsg : util.languageObjReturn(langCode, 'infoChkMsg')
                }
            }
            ,methods : {
                fnNumberBox : function(value){
                    var hidePhoneNo = this.phoneNo.replace(/-/g, '');

                    if(value == "I"){
                        hidePhoneNo = "";
                    }else if(value == "D"){
                        hidePhoneNo = hidePhoneNo.substr(0, (hidePhoneNo.length-1));
                    }else if(value == "010"){
                    	hidePhoneNo = "010"
                    }else {
                        if(hidePhoneNo.length > 10){
                            return false;
                        }
                        hidePhoneNo = hidePhoneNo + value;
                    }
                    
                    this.phoneNo = hidePhoneNo.replace(/[^0-9]/g, "").replace(/(^02|^0505|^1[0-9]{3}|^0[0-9]{2})([0-9]+)?([0-9]{4})$/,"$1-$2-$3").replace("--", "-");

                },
                fnInfoPopupShow : function(){

                	util.logInfo('notifyTalk fnInfoPopupShow==' + $('.layerPopup').css('display'));
                	util.logInfo('notifyTalk gsNotifyMsgVisible==' + gsNotifyMsgVisible);

                    if( $('.layerPopup').css('display') == 'none' && gsNotifyMsgVisible == "N" )
                    {
                    	gsNotifyMsgVisible = "Y";
                        $(".layerPopup").show();
                    }
                        
                },
                fnInfoPopupClose : function(){
                	
                	$(".layerPopup").hide();
                },
                fnInputComplete : function(){

                    //util.logInfo('notifyTalk phoneNo==' + this.phoneNo);
                    util.logInfo('notifyTalk phoneNo==' + this.phoneNo.substring(this.phoneNo.length-4));
                    util.logInfo('notifyTalk $("#showCheckoutHistory").is(":checked") : ' + $("#showCheckoutHistory").is(":checked"));
                    
                    if(!$("#showCheckoutHistory").is(":checked")) {
                        var dataObj = {};
                        //dataObj.message = util.languageObjReturn(langCode, 'pleaseInfoAgree');

                        var dataObj = {
                              button1Show : true
                            , button1Name : util.languageObjReturn(langCode, 'no') // [ 아니오 ]
                            , button1Func : ""
                            , button2Show : true
                            , button2Name : util.languageObjReturn(langCode, 'yes') // [ 예 ]
                            , button2Func : this.fnMoveMenuPage
                            , message     : util.languageObjReturn(langCode, 'notNotifyTalk')
                        };

                        eventBus.$emit('alertPopupIndex', dataObj);
                        return false;
                    }

                    if(this.phoneNo.length > 10 ){
                        basicOrderInfo.notifyTalkPhoneNo = this.phoneNo.replace(/-/g, '');
                        router.push({name: "menu", params: { id: this.mealTake, "beforePage" : "notifyTalk" },});
                    }else{
                        var dataObj = {};
                        dataObj.message = util.languageObjReturn(langCode, 'phoneNumberIn');
		                eventBus.$emit('alertPopupIndex', dataObj);

                    }
                },
                fnMoveMenuPage : function(){
                    router.push({name: "menu", params: { id: this.mealTake, "beforePage" : "notifyTalk" },});

                },
                touchAudio : function(){
                	util.fnTouchAudio(); // 터치할 때 소리 나도록 함수 호출.
                },
                fnBackNotify : function(){
                	this.$router.push({path: '/start'})

                }
            }
        };
        return returnTemplate;

    }

    this.fnGetNotifyTalkConfirmPopup = function(){
        var returnTemplate = { template: '#notifyTalkConfirmPopup'
            , created : function() {
                util.log('fnGetNotifyTalkConfirmPopup created==' );
                this.$root.$on("notifyTalkConfirmPopup" , obj => {
                    util.logDebug("fnGetNotifyTalkConfirmPopup Recieve : " + JSON.stringify(obj ) );
                    util.logInfo("fnGetNotifyTalkConfirmPopup Recieve : " + JSON.stringify(obj ) );
                    this.fnOnNotifyTalkConfirmPopup();
                    this.mealTake = obj.id;
                });
            }
            , beforeDestroy () {
            	this.$root.$off( 'notifyTalkConfirmPopup' );
            }
            ,mounted : function() {

                util.log('fnGetNotifyTalkConfirmPopup mounted==');

            } 
            ,data: function(){
                return {
                    phoneNo : "",
                    confirmNumber : util.languageObjReturn(langCode, 'confirmNumber'),
                    sendNotify : util.languageObjReturn(langCode, 'sendNotify'),
                    enterPhoneNumber : util.languageObjReturn(langCode, 'enterPhoneNumber'),
                    pleasePhoneNumber : util.languageObjReturn(langCode, 'pleasePhoneNumber'),
                    previous : util.languageObjReturn(langCode, 'previous'),
                    confirmation : util.languageObjReturn(langCode, 'confirmation'),
                    mealTake : "",
                    talkConfirmPopupShow : false
                }
            }
            ,methods : {
                fnOnNotifyTalkConfirmPopup : function(value){
                    this.talkConfirmPopupShow = !this.talkConfirmPopupShow;

                    util.logInfo('fnGetNotifyTalkConfirmPopup talkConfirmPopupShow==' + this.talkConfirmPopupShow);

                    if(this.talkConfirmPopupShow){
                        this.phoneNo = basicOrderInfo.notifyTalkPhoneNo.replace(/[^0-9]/g, "").replace(/(^02|^0505|^1[0-9]{3}|^0[0-9]{2})([0-9]+)?([0-9]{4})$/,"$1-$2-$3").replace("--", "-");
                    }
                },
                fnMoveNotifyTalk : function(){
                	
                	util.logInfo('notifyTalk phoneNo==' + this.phoneNo.substring(this.phoneNo.length-4));
                    router.push({name: "notifyTalk", params: { id: this.mealTake },});

                }
            }
        };
        return returnTemplate;

    }

    this.fnGetSelectTablePage = function(){
        var returnTemplate = { template: '#selectTablePage'
            , created : function() {
                util.log('fnGetSelectTablePage created==' );
            }
            , beforeDestroy () {

            }
            ,mounted : function() {

                util.log('fnGetSelectTablePage mounted==');
                this.fnSelectTableGroupList();

                basicOrderInfo.tableCd = "";
                basicOrderInfo.tableNm = "";
                basicOrderInfo.tableGroup = "";

            }
            ,data: function(){
                return {
                    seatAllocation : util.languageObjReturn(langCode, 'seatAllocation'),
                    tableCd : "",
                    tableGroupList : [],
                    tableList : [],
                    listIndex : 0,
                    swiperOption : {slidesPerView: 4, // 한 슬라이드에 보여줄 갯수
                                        spaceBetween: 20, // 슬라이드 사이 여백
                                        direction: 'horizontal',
                                        navigation: {
                                            nextEl: '#categoryNextBtn',
                                            prevEl: '#categoryPrevBtn',
                                    }},
                    swiperOption2 : {direction: 'vertical',
                                        slidesPerView: 7,
                                        slidesPerColumn: 4,
                                        spaceBetween: 20,
                                        //slidesPerColumnFill: "row",
                                        //autoHeight : true,
                                        //height : 850,
                                        navigation: {
                                            nextEl: '.food_next',
                                            prevEl: '.food_prev',
                                        }}

                }
            }
            ,methods : {
                fnSelectTableList : function(groupInfo){

                    var sql = frontViewObj.selectTableList
                    if(!util.isEmpty(groupInfo)){

                        sql += " AND TBL.TG_CD = '" + groupInfo.TG_CD + "'";

                    }
                    sql += " ORDER BY TBG.TG_SORT  , TBL.TABLE_CD ";

                    util.log('fnSelectTableList sql : ' + sql);

                    var tableResult = gfn_SQLiteSQLProcess(sql, [gShopCd]).Data;

                    if(!util.isEmpty(tableResult)){
                        for(i=0; i < tableResult.length ; i++){
                            var row = tableResult[i];
                            if(row.TABLE_NM.length > 4){
                                row.small = true;
                            }else{
                                row.small = false;
                            }
                        }
                    }

                    util.log('fnSelectTableList this.tableResult : ' + JSON.stringify(tableResult));
                    this.tableList = tableResult;

                },
                fnSelectTableGroupList : function(){

                    util.log('fnSelectTableGroupList this.selectTableGroupList : ' + frontViewObj.selectTableGroupList);

                    var tableGroupResult = gfn_SQLiteSQLProcess(frontViewObj.selectTableGroupList, [gShopCd]).Data;

                    util.log('fnSelectTableGroupList tableGroupResult : ' + JSON.stringify(tableGroupResult));



                    this.tableGroupList = tableGroupResult;
                    this.fnSelectTableList(this.tableGroupList[0]);

                },
                fnClickGroupList : function(row, index) {
                	util.fnTouchAudio(); // 터치할 때 소리 나도록 함수 호출.
                    util.logInfo('######### fnClickGroupList index : ' + index );
                    //util.log('######### fnClickGroupList this : ' + JSON.stringify(_this));

                    this.listIndex = index;

                    this.fnSelectTableList(row);

                },
                fnClickTableList : function(row){
                	util.fnTouchAudio(); // 터치할 때 소리 나도록 함수 호출.
                    this.tableCd = row.TABLE_CD;

                    var dataObj = {
                          button1Show : false
                        , button1Name : util.languageObjReturn(langCode, 'no') // [ 아니오 ]
                        , button1Func : ""
                        , button2Show : true
                        , button2Name : util.languageObjReturn(langCode, 'noticeConfirm')// [ 확인 ]
                        , button2Func : util.fnIndexMoveMenu
                        , data        : {"beforePage" : "selectPage" }
                        , message     : util.languageObjReturn(langCode, 'completeSeatAllocation').replace("@?", row.TABLE_NM)

                    };
        //debugger; 
                    basicOrderInfo.tableCd 		= this.tableCd;
                    basicOrderInfo.tableNm 		= row.TABLE_NM;
                    basicOrderInfo.tableGroup 	= row.TG_NM;
                    

                    eventBus.$emit('alertPopupIndex', dataObj);

                },
                fnBackTable : function(row){
                    this.$router.push({path: '/start'});
                },
                touchAudio : function(){
                	util.fnTouchAudio(); // 터치할 때 소리 나도록 함수 호출.
                }
            }
        };
        return returnTemplate;

    }
    
    //알림메세지, 닫기 눌렀을때 메인으로 이동
    this.fnGetAlertIndex = function(){
        var returnTemplate = { template: '#alertPopupIndex'
            , created : function() {
                util.logInfo('alertPopupIndex created==' + this.alertPopupShow);
            }
            ,
			 beforeDestroy (){
            	util.logInfo("***** alertPopupIndex destroyed *****");
            	eventBus.$off( 'alertPopupIndex' );
            	eventBus.$off( 'selfClosePop' );
			}
            ,mounted : function() {
            	eventBus.$on('alertPopupIndex2', this.fnAlertPopup);
                eventBus.$on('alertPopupIndex', this.fnAlertPopup);
                eventBus.$on('selfClosePop', this.fnAlertPopup);
                
                if(gsSpecialShopFlag == "5" && gMemberService == "1"){
                	this.memberServicePop = "Y";
                }
            }
            ,data: function(){
                return {
                    alertPopupShow: false,
                    message: "",
                    message2: "",
                    button1Show: false,
                    button1Name: util.languageObjReturn(langCode, 'noticeCancel'), // [ 취소 ]
                    button2Show: true,  
                    button2Name: util.languageObjReturn(langCode, 'noticeConfirm'), // [ 확인 ]
                    button2Func: {},
                    button1Func: {},
                    funcData: {},
                    styleObject : { display : 'none' },
                    timeoutID  : "",   /** timeout id  **/
                    timeoutIDSelf  : "",   /** timeout id  **/
                    noti : util.languageObjReturn(langCode, 'noticeTitle'), // [알림]
                    memberServicePop : "N"
                }
            }
            ,methods : {
                fnAlertPopup : function(data) {
                	util.logInfo("fnAlertPopupIndex Start this.alertPopupShow!!!!!!!!!!!!!!!! :" + this.alertPopupShow );
                    this.alertPopupShow = !this.alertPopupShow;

                    util.logInfo("fnAlertPopupIndex Start message :" + data.message );
                    util.logDebug("fnAlertPopupIndex Start this.alertPopupShow :" + this.alertPopupShow );
                    util.logDebug("fnAlertPopupIndex Start data:" + JSON.stringify( data ) );
                    util.logDebug("fnAlertPopupIndex Start this.button2Func :" + util.isFunction(this.button2Func));

                    if(this.alertPopupShow){
                        this.message = data.message;
                        if(!util.isEmpty(data.message2)) {
                        	this.message2 = data.message2;
                        }
                        if(data.button1Show){
                            this.button1Show = true;
                            this.button1Name = data.button1Name;
                            this.button1Func = data.button1Func;
                        }
                        if(data.button2Show){
                            this.button2Show = true;
                            this.button2Name = data.button2Name;
                            this.button2Func = data.button2Func;
                            this.funcData = data.data;
                        }
                        this.styleObject = { display : 'block' };

                        /*********************************************************************
                         * timeout option. 2020.10.08 추가. Mr.Nam(간편결제)
                         *********************************************************************/
                        if ( typeof data.timeout !== 'undefined' || typeof data.timeoutFunc !== 'undefined' ) {
                        	this.timeoutID = setTimeout( data.timeoutFunc , data.timeout ) 
                        }
                        
                        if(gsSpecialShopFlag == "5" && issueStampMsgInfo == null) {
                        	var currLocation = window.location.href;
                			var currArr = currLocation.split("/");
                			var val = currArr[currArr.length - 1 ];
                			
                			//util.logInfo("_____val >>>> " + val)
                			//결제화면일 경우 자동팝업 금지
                			if ( val !== "paymentExe" && val !== "tollgatePayView" && val !== "easyPayment" && issueStampMsgInfo == null) {
                				if(this.memberServicePop != "Y") {
                					this.fnAlertPopupSelfClose(data);
                				} else {
                					if(!util.isEmpty(this.funcData)) {
                						if(this.funcData.memSubGoToFunYn == "Y") { //memSubGoToFunYn 바로다 구독권 자동팝업 닫히고 콜백함수 유무
                							this.fnAlertPopupSelfCloseForFunc(data);
                						} else {
                							this.fnAlertPopupSelfClose(data);
                						}
                					} else {
                						this.fnAlertPopupSelfClose(data);
                					}
                				}
                				
                        	}
                        }
                        
                    }else{
                    	clearTimeout(this.timeoutID);
                    	clearTimeout(this.timeoutIDSelf);
                    	if(data.buttonValue == "button1"){
                            if(util.isFunction(this.button1Func)){
                                this.button1Func(this.funcData);
                            }
                    	}

                        if(data.buttonValue == "button2"){
                        	util.logInfo('alertPopupIndex button2 isFunction : ' + util.isFunction(this.button2Func));
                        	util.logInfo('typeof x : '  + (typeof this.button2Func ) );
                        	util.logInfo('input instanceof Function  : '  + ( this.button2Func instanceof Function ) );
                        	util.logInfo('Object.prototype.toString.call(input) : '  + (Object.prototype.toString.call(this.button2Func)  ) );
                        	
                        	if(util.isFunction(this.button2Func)){
                        		if(this.funcData !== undefined) {
                        			if(this.funcData.subsMenuHasChk == "Y") {
                        				gSubsMenuHasChk = "Y";
                        			}
                        		}
                        		
                                this.button2Func(this.funcData);
                            }
                        }
                        this.button1Show = false;
                        this.button2Name = "확인";
                        this.button2Func = {};
                        this.funcData = {};
                        this.message2 = "";
                    }
                },
                fnAlertPopupSelfClose : function(data) {
    		  		//var selfClosePopVal = util.GetEnvXmlPosENV(); /** **/
                    var selfClosePopVal = 10;
                    if ( selfClosePopVal !== "" && selfClosePopVal !== undefined ) {
                    	this.timeoutIDSelf = setTimeout(function(){
                    		util.logInfo("######## selfClosePopVal >>> " + selfClosePopVal);
                    		eventBus.$emit('selfClosePop', data);
                    		}, selfClosePopVal * 1000);
                    }
                },
                fnAlertPopupSelfCloseForFunc : function(data) {
                	//var selfClosePopVal = util.GetEnvXmlPosENV(); /** **/
                	var selfClosePopVal = 10;
                	if ( selfClosePopVal !== "" && selfClosePopVal !== undefined ) {
                		this.timeoutIDSelf = setTimeout(function(){
                			util.logInfo("######## selfClosePopVal >>> " + selfClosePopVal);
                			data.buttonValue = "button2";
                			eventBus.$emit('selfClosePop', data);
                		}, selfClosePopVal * 1000);
                	}
                }
            }
        };
        return returnTemplate;

    },

    //알림메세지, 닫기 눌렀을때 메인으로 이동
    this.fnGetAlertIndex2 = function(){
        var returnTemplate = { template: '#alertPopupIndex2'
            , created : function() {
                util.log('alertPopupIndex2 created==' + this.alertPopupShow);
            },
             beforeDestroy () {
                eventBus.$off( 'alertPopupIndex2' );
            }
            ,mounted : function() {
                eventBus.$on('alertPopupIndex2', this.fnOpenAlertPopup);
            }
            ,data: function(){
                return {
                    alertPopupShow: false,
                    message: "",
                    button1Show: false,
                    button1Name: util.languageObjReturn(langCode, 'noticeCancel'), // [ 취소 ]
                    button2Show: true,
                    button2Name: util.languageObjReturn(langCode, 'noticeConfirm'), // [ 확인 ]
                    button2Func: {},
                    funcData: {},
                    noti : util.languageObjReturn(langCode, 'noticeTitle') // [알림]
                }
            }
            ,methods : {
                fnOpenAlertPopup : function(data) {
                    this.alertPopupShow = true;

                    util.logInfo("fnAlertPopupIndex Start message :" + data.message );
                    util.logDebug("fnAlertPopupIndex Start data 1:" + this.alertPopupShow );
                    util.logDebug( this.button2Func );
                    util.logDebug("fnAlertPopupIndex Start data 2:" + JSON.stringify( data ) );
                    util.logDebug("fnAlertPopupIndex Start data 3:" + util.isFunction(this.button2Func));

                    this.message = data.message;
                    if(data.button1Show){
                        this.button1Show = true;
                        this.button1Name = data.button1Name;
                        this.button1Func = data.button1Func;
                    }
                    if(data.button2Show){
                        this.button2Show = true;
                        this.button2Name = data.button2Name;
                        this.button2Func = data.button2Func;
                        this.funcData = data.data;
                    }

                },
                fnCloseAlertPopup : function(data) {
                    this.alertPopupShow = false;

                    util.logInfo("fnAlertPopupIndex Start message :" + data.message );
                    util.logDebug("fnAlertPopupIndex Start data 1:" + this.alertPopupShow );
                    //console.log( this.button2Func );
                    util.logDebug("fnAlertPopupIndex Start data 2:" + JSON.stringify( data ) );
                    util.logDebug("fnAlertPopupIndex Start data 3:" + util.isFunction(this.button2Func));

                    if(data.buttonValue == "button1"){
                        if(util.isFunction(this.button1Func)){
                            this.button1Func(this.funcData);
                        }
                    }

                    if(data.buttonValue == "button2"){
//                        console.log('alertPopupIndex button2 isFunction : ' + util.isFunction(this.button2Func));
//                        console.log('typeof x : '  + (typeof this.button2Func ) );
//                        console.log('input instanceof Function  : '  + ( this.button2Func instanceof Function ) );
//                        console.log('Object.prototype.toString.call(input) : '  + (Object.prototype.toString.call(this.button2Func)  ) );
                        if(util.isFunction(this.button2Func)){
                            this.button2Func(this.funcData);
                        }
                    }
                    this.button1Show = false;
                    this.button2Name = "확인";
                    this.button2Func = {};
                    this.funcData = {};
                }
            }
        };
        return returnTemplate;

    },
    
    //알림메세지, 닫기 눌렀을때 메인으로 이동
    this.fnCouponChoicePopup = function(){
    	var returnTemplate = { template: '#couponChoicePopup'
    		, created : function() {
    			util.logInfo('couponChoicePopup created==' + this.alertPopupShow);
    		},
    		beforeDestroy () {
    			eventBus.$off( 'couponChoicePopup' );
    		}
    		,mounted : function() {
    			eventBus.$on('couponChoicePopup', this.fnOpenAlertPopup);
    		}
    		,data: function(){
    			return {
    				 alertPopupShow: false,
                     message: "",
                     button1Show: false,
                     button1Name: util.languageObjReturn(langCode, 'noticeCancel'), // [ 취소 ]
                     button2Show: true,  
                     button2Name: util.languageObjReturn(langCode, 'noticeConfirm'), // [ 확인 ]
                     button2Func: {},
                     button1Func: {},
                     funcData: {},
                     styleObject : { display : 'none' },
                     timeoutID  : "",   /** timeout id  **/
                     noti : util.languageObjReturn(langCode, 'noticeTitle'), // [알림]
                     isCouponPayAbleBtn : false
    			}
    		}
    		,methods : {
    			fnOpenAlertPopup : function(data) {
    				this.alertPopupShow = !this.alertPopupShow;

                    util.logInfo("fnCouponChoicePopup Start message :" + data.message );
                    util.logInfo("fnCouponChoicePopup Start data 1:" + this.alertPopupShow );
                    //console.log( this.button2Func );
                    util.logInfo("fnCouponChoicePopup Start data 2:" + JSON.stringify( data ) );
                    util.logInfo("fnCouponChoicePopup Start data 3:" + util.isFunction(this.button2Func));
                    util.logInfo("fnCouponChoicePopup Start data 4:" + util.isFunction(data.button2Func));
                    util.logInfo("fnCouponChoicePopup Start data 5:" + util.isFunction(data.button1Func));

                    if(this.alertPopupShow){
                        this.message = data.message;
                        if(data.button1Show){
                            this.button1Show = true;
                            this.button1Name = data.button1Name;
                            this.button1Func = data.button1Func;
                        }
                        if(data.button2Show){
                            this.button2Show = true;
                            this.button2Name = data.button2Name;
                            this.button2Func = data.button2Func;
                            this.funcData = data.data;
                        }
                        this.styleObject = { display : 'block' };
                        
                        if(data.couponProdExs == "Y"){
                        	this.isCouponPayAbleBtn = true;
                        } else {
                        	this.isCouponPayAbleBtn = false;
                        }
                        /*********************************************************************
                         * timeout option. 2020.10.08 추가. Mr.Nam(간편결제)
                         *********************************************************************/
                        if ( typeof data.timeout !== 'undefined' || typeof data.timeoutFunc !== 'undefined' ) {
                        	this.timeoutID = setTimeout( data.timeoutFunc , data.timeout ) 
                        }

                    }else{
                    	util.fnTouchAudio(); // 터치할 때 소리 나도록 함수 호출.
                    	clearTimeout(this.timeoutID);
                    	if(data.buttonValue == "button1"){
                            if(util.isFunction(this.button1Func)){
                                this.button1Func(this.funcData);
                            }
                    	}

                        if(data.buttonValue == "button2"){
                        	util.logInfo('fnCouponChoicePopup alertPopupIndex button2 isFunction : ' + util.isFunction(this.button2Func));
                        	util.logInfo('fnCouponChoicePopup typeof x : '  + (typeof this.button2Func ) );
                        	util.logInfo('fnCouponChoicePopup input instanceof Function  : '  + ( this.button2Func instanceof Function ) );
                        	util.logInfo('fnCouponChoicePopup Object.prototype.toString.call(input) : '  + (Object.prototype.toString.call(this.button2Func)  ) );
                            if(util.isFunction(this.button2Func)){
                                this.button2Func(this.funcData);
                            }
                        }
                        this.button1Show = false;
                        this.button2Name = "확인";
                        this.button2Func = {};
                        this.funcData = {};

                    }
    			},
    			
    		  	fnClose : function() {
    		  		this.alertPopupShow = false;
    		  		this.styleObject = {display : 'none'};
    		  	}
    		}
    		
    	};
    	return returnTemplate;
    	
    },
    
    //점검중 패스워드 입렵팝업
    this.fnGetInputPwdPopup = function(){
        var returnTemplate = {
        	  template: '#inputPwdPopup'
        	, data: function(){
                return {
                	//inputPwdPopupShow: false,
                	  empPwd:""
                	, styleObject : {display : 'none'}
                	, contentTitle : "권한 확인"
                   	, openType : "" /*** 점검중 화면에서 진입또는 관리자메인에서 진입.***/
                   	, url : ""
                   	, totalAmt : ""
                   	, beforePage : ""	

                }
            }

            ,  beforeDestroy() {
	    		this.$root.$off( 'inputPwdPopupOpen' );
	    		eventBus.$off('openInputPwdPopup');
	    	}
            , created : function() {
            }
    		, mounted : function(){
    			
            	eventBus.$on('openInputPwdPopup', this.fnInputPwdPopup);
				this.$root.$on("inputPwdPopupOpen" , obj => {
					util.logInfo("***** inputPwdPopup mount inputPwdPopupOpen emit START *****");
					util.logDebug(obj);
					util.logDebug("### inputPwdPopup obj : " + JSON.stringify(obj));
					this.contentTitle   = obj.title;
					this.openType  = obj.openType;/*** 점검중화면 or 관리자화면. ***/
					this.url = obj.url;
					this.totalAmt = obj.totalAmt;
					this.styleObject = {display :'block'};
					this.beforePage = obj.beforePage;
				});

            },
            methods : {
            	fnInputPwdPopup : function(data) {
	                $('.layerPopup2').show();
	                return false;
            	},
            	closePwdPopup : function() {
                    //$('.layerPopup2').hide();
                    //$('.ta_center').val("");
            		this.styleObject = {display : 'none'};
            	},
            	fnNumberBox : function(value){
	                if(value == "C"){
	                    this.empPwd = "";
	                }else if(value == "D"){
	                    this.empPwd = this.empPwd.substr(0, (this.empPwd.length-1));
	                }else {
	                    this.empPwd = this.empPwd + value;
	                }
                },

            	fnPermissionCheck : function(event){
            		//비밀번호로 회원조회
            		if(this.empPwd === undefined || this.empPwd === "" || this.empPwd === null){
            			alert("비밀번호를 입력하세요.");
            			return false;
            		}

            		if ("inspection" == this.openType ) {
            			var empInfo = JSON.parse(sessionStorage.getItem("EMP_INFO"));
            			var encPwd = SHA256(this.empPwd);
            			//util.log("encPwd >>> " + encPwd);

            			var dateResult = gfn_SQLiteSQLProcess(sqlQuery.selectLoginCheck, [gShopCd, empInfo.EMP_NO, encPwd]);
            			util.log('selectLoginCheck dateResult : ' + JSON.stringify(dateResult));
            			util.log("dateResult >>> " + typeof dateResult);

            			if(typeof dateResult === 'undefined') {
            				alert("비밀번호를 확인해주세요.");
            				return;
            			}

            			if(dateResult.Data == '' || dateResult.Data == null){
            				alert("비밀번호를 확인해주세요.");
            				return;
            			}

            		} else if ("prodStatus" == this.openType ) {
            			var empInfo = JSON.parse(sessionStorage.getItem("EMP_INFO"));
            			var encPwd = SHA256(this.empPwd);
            			//util.log("encPwd >>> " + encPwd);

            			var dateResult = gfn_SQLiteSQLProcess(sqlQuery.selectLoginCheck, [gShopCd, empInfo.EMP_NO, encPwd]);
            			util.log('selectLoginCheck dateResult : ' + JSON.stringify(dateResult));
            			util.log("dateResult >>> " + typeof dateResult);

            			if(typeof dateResult === 'undefined') {
            				alert("비밀번호를 확인해주세요.");
            				return;
            			}

            			if(dateResult.Data == '' || dateResult.Data == null){
            				alert("비밀번호를 확인해주세요.");
            				return;
            			}
            		} else {
            			return;
            		}
            		
            		this.closePwdPopup();
            		
            		if(this.url == "cashReceipts"){
            			
            			//더블클릭시 팝업창 보여줌
                    	var paramObj = {
                  			  title : "권한 확인"
                  			, openType : "inspection"
                  			, url : "cashReceipts"
                  			, totalAmt : this.getTotalAmtView
                    	};
                    	
//            			router.push({name: 'cashReceipts', params: { totalAmt: this.menuPrice }})
//                		location.replace('./cashReceipts.html');
            			this.$router.push({name: 'cashReceipts', params: { totalAmt: this.totalAmt }})
            		}else if(this.url == "menu"){
            			gProdStatusChgMode = "A";
            			var paramObj = {"name" : 'menu', "mealTake" : "start"};
            		    util.fnIndexMoveMenu(paramObj);
            		}else{ // 관리자 화면
            			if(this.beforePage == "kerbanMain") {
            				location.replace('./index.html');
            			} else {
            				//완료후 어드민 메인 페이지로 이동
            				location.replace('./admin.html');
            			}	
            		}
            		
                	
            	}
            }
        };
        return returnTemplate;
    }
    ,
    // 도도포인트 인증키 팝업
    this.fnDodoPointPop = function(){
    	 var returnTemplate = { template: '#dodoPointPopup'
             , created : function() {
            	 this.saveTo = util.languageObjReturn(langCode,  'saveTo');
            	 this.toSave = util.languageObjReturn(langCode,  'toSave');
            	 this.no     = util.languageObjReturn(langCode,  'no');
            	 this.yes    = util.languageObjReturn(langCode,  'yes');
            	 this.time	 = "03:00";
             }
	    	 , data : function () {
	      		return {
	      			  codeNum     : ""
	      			, styleObject : { display : 'none' }
	      			, payType     : ""  // 결제 방법 (CREDIT , EASY)
	      			, yes         : ""
	      	        , no          : ""
	      	        , time		  : ""
	      	        , timeChk	  : "Y"	
	      	        , x           : ""	
	      	        , authKey     : ""	
	      	        , iAuthKey    : ""	
	      	        , finishUrl   : ""	
      	        	, authNum1    : ""	
  	        		, authNum2    : ""	
        			, authNum3    : ""	
    				, authNum4    : ""	
	      		}
	      	}
         	, mounted : function() {
             	// util.log('addPoint mounted==' );
         		//eventBus.$on('openDodoPointPopup', this.fnInputPwdPopup);
             	this.$root.$on('dodoPointPopup' , obj => {
             		util.logInfo("on -> dodoPointPopup 1111" + JSON.stringify(obj));
             		this.authKey = obj.auth_key;
             		this.finishUrl = obj.finish_url;
             		this.styleObject = { display : 'block' };
             		//var tenMinutes = 60 * 10;
//             		var display = document.querySelector('#time');
//             		if(this.timer < 1) this.timer = 60 * 10;
//             		this.startTimer(this.timer, display);
             		var display = document.querySelector('#time');
             		var duration = 60 * 3;
             		this.x = setInterval(function () {

             			var minutes, seconds;
            	        minutes = parseInt(duration / 60, 10);
            	        seconds = parseInt(duration % 60, 10);
            	        
            	        minutes = minutes < 10 ? "0" + minutes : minutes;
            	        seconds = seconds < 10 ? "0" + seconds : seconds;
            	        
            	        display.textContent = minutes + ":" + seconds;
            	        
            	        if (--duration < 0) {
            	            //timer = duration;
            	        	this.timeChk = "N";
            	        	location.replace('./index.html');
            	        }
            	    }, 1000);
             	});
             }
			,beforeDestroy () {
					//eventBus.$on('openDodoPointPopup', this.fnDodoPointPopup);
 					this.$root.$off('dodoPointPopup' );
 			}
            , methods : {
            	fn_closeOut : function(){
            		orderInfo.addPoint.CREDIT = '';
 	   	            orderInfo.addPoint.EASY = '';
            		this.styleObject = {display : 'none'};
            		//console.log("close popup");
            		clearInterval(this.x);
            		//document.querySelector('#time').textContent = "10:00";
            	}
	            , fn_close : function() {
	            	this.styleObject = {display : 'none'};
	            	//setTimeout(this.fn_closePayCall, 100); // payment를 호출하면 위의 display none이 없어지지 않는 문제가 발생하여 0.1초 후 payment 호출하도록 처리.
	            }
	            , fnDodoPointPopup : function(data) {
	                $('.layerPopup').show();
	                return false;
            	},
            	authKeyChk : function() {
            		var msgObj = { message : "", messageType : "alert" };
            		
            		var temp = "";
            		
            		$(".card_inputs").each(function(index){
            			//console.log("### data : " + $("#"+$(this).attr("id")).val());
            			temp = temp + $("#"+$(this).attr("id")).val(); 
						//console.log("### temp : " + temp);
            		});
            		
            		this.iAuthKey = temp;
            		//console.log("### iAuthKey : " + this.iAuthKey);
            		
            		if(this.authKey != this.iAuthKey){
            			//인증번호가 틀립니다. 다시 입력해주세요.
            			//msgObj.message = util.languageObjReturn(langCode,  "timeoutMsg"); // 서버와의 통신이 원활하지 않습니다. 인터넷을 확인해 주세요.
            			//this.makeMessageAlert(msgObj);
            			alert("인증번호가 틀립니다. 다시입력해주세요.");
            			this.iAuthKey = "";
            		} else {
            			this.fn_closeOut();
            			
            			var paramObj = {};
            			paramObj.auth_key = this.iAuthKey;
            			paramObj.finish_url = this.finishUrl;
            			this.$root.$emit('dodoAuthKeyVerifyCallback', paramObj);
            		}
            	}, 
            	fnDodoNumberKeyPad : function (key) {
            		if(key == "RESET"){
        				$(".card_inputs").each(function(index){
        					$("#"+$(this).attr("id")).val("");
                		});
        			} else if(key == "DEL"){ 
        				var checkDataLength = 0;
        				$(".card_inputs").each(function(index){
        					if($("#"+$(this).attr("id")).val().length > 0){
        						checkDataLength += 1; 
                			}
                		});
        				
        				if(checkDataLength > 0) {
        					$("#authNum" + checkDataLength).val("");
        				}
        				
        			} else {
        				$(".card_inputs").each(function(index){
                			//$(this)
                			console.log($(this).attr("id"));
                			console.log($("#"+$(this).attr("id")).val());            			
                			
                			if($("#"+$(this).attr("id")).val().length < 1){
                				$("#"+$(this).attr("id")).val(key)
                				return false;
                			}
                		});
        			}
            		
            	},
            	makeMessageAlert(messageObj) {
	    			this.$root.$emit( "notiMessage" ,   messageObj  );
            	}
            }
    	 };
    	 return returnTemplate;
    },
    
    //알림메세지, 닫기 눌렀을때 주방출력 및 교환권 출력
    this.fnReceiptOutputPopup = function(){
    	var returnTemplate = { template: '#receiptOutputPopup'
    		, created : function() {
    			util.logInfo('receiptOutputPopup created==' + this.alertPopupShow);
    		},
    		beforeDestroy () {
    			eventBus.$off( 'receiptOutputPopup' );
    		}
    		,mounted : function() {
    			eventBus.$on('receiptOutputPopup', this.fnOpenAlertPopup);
    		}
    		,data: function(){
    			return {
    				 alertPopupShow: false,
                     message: "",
                     message2: "",
                     message3: "",
                     message4: "",
                     button1Show: false,
                     button1Name: util.languageObjReturn(langCode, 'noticeCancel'), // [ 취소 ]
                     button2Show: true,  
                     button2Name: util.languageObjReturn(langCode, 'noticeConfirm'), // [ 확인 ]
                     button2Func: {},
                     button1Func: {},
                     funcData: {},
                     styleObject : { display : 'none' },
                     timeoutID  : "",   /** timeout id  **/
                     noti : util.languageObjReturn(langCode, 'noticeTitle'), // [알림]
                     isCouponPayAbleBtn : false
    			}
    		}
    		,methods : {
    			fnOpenAlertPopup : function(data) {
    				this.alertPopupShow = !this.alertPopupShow;

                    util.logInfo("fnReceiptOutputPopup Start message :" + data.message );
                    util.logInfo("fnReceiptOutputPopup Start data 1:" + this.alertPopupShow );
                    //console.log( this.button2Func );
                    util.logInfo("fnReceiptOutputPopup Start data 2:" + JSON.stringify( data ) );
                    util.logInfo("fnReceiptOutputPopup Start data 3:" + util.isFunction(this.button2Func));
                    util.logInfo("fnReceiptOutputPopup Start data 4:" + util.isFunction(data.button2Func));
                    util.logInfo("fnReceiptOutputPopup Start data 5:" + util.isFunction(data.button1Func));

                    if(this.alertPopupShow){
                        this.message = data.message;
                        if(!util.isEmpty(data.message2) && !util.isEmpty(data.message3)) {
                        	this.message2 = data.message2;
                        	this.message3 = data.message3;
                        }
                        if(!util.isEmpty(data.message4)) {
                        	this.message4 = data.message4;
                        }
                        if(data.button1Show){
                            this.button1Show = true;
                            this.button1Name = data.button1Name;
                            this.button1Func = data.button1Func;
                        }
                        if(data.button2Show){
                            this.button2Show = true;
                            this.button2Name = data.button2Name;
                            this.button2Func = data.button2Func;
                            this.funcData = data.data;
                        }
                        this.styleObject = { display : 'block' };
                        
                        /*********************************************************************
                         * timeout option. 2020.10.08 추가. Mr.Nam(간편결제)
                         *********************************************************************/
                        if ( typeof data.timeout !== 'undefined' || typeof data.timeoutFunc !== 'undefined' ) {
                        	this.timeoutID = setTimeout( data.timeoutFunc , data.timeout ) 
                        }

                    }else{
                    	util.fnTouchAudio(); // 터치할 때 소리 나도록 함수 호출.
                    	clearTimeout(this.timeoutID);
                    	if(data.buttonValue == "button1"){
                            if(util.isFunction(this.button1Func)){
                                this.button1Func(this.funcData);
                            }
                    	}

                        if(data.buttonValue == "button2"){
                        	util.logInfo('alertPopupIndex button2 isFunction : ' + util.isFunction(this.button2Func));
                        	util.logInfo('typeof x : '  + (typeof this.button2Func ) );
                        	util.logInfo('input instanceof Function  : '  + ( this.button2Func instanceof Function ) );
                        	util.logInfo('Object.prototype.toString.call(input) : '  + (Object.prototype.toString.call(this.button2Func)  ) );
                            if(util.isFunction(this.button2Func)){
                                this.button2Func(this.funcData);
                            }
                        }
                        this.button1Show = false;
                        this.button2Name = "확인";
                        this.button2Func = {};
                        this.funcData = {};

                    }
                    
                    gReChgOutput = setTimeout(function() {
                    	//5초가 지나면 구매영수증 미출력으로 동작
                    	util.logInfo("### data.params : " + data.params);
        				paymentChoiceView.fnReceiptPrintResult(data.params, "N");
        			}, 5000)
    			},
    			
    		}
    		
    	};
    	return returnTemplate;
    },
    
    //점검중
    this.fnGetInspection = function(){
    	var touchtime = 0;
    	var refreshIntervalId;
        var returnTemplate = { template: '#inspection',
            mounted : function(){
            	if(this.$route.params.beforePage == "kerbanMain") {
            		gInspectPageCallYn = "Y";
            		util.logInfo('### fnGetInspection params : ' + this.$route.params.beforePage) ;
            	}
            	
            	if(gsSpecialShopFlag == "9"){
            		//레인보우 로보틱스일때는 30초마다 통신
            		refreshIntervalId = window.setInterval(this.fnInspectChk, 30 * 1000);
            	} else {
            		//몇분마다 호출할지는 아직 미정, 현재는 테스르를 위해서 10초마다 서버 통신 -> 1분마다 통신 확정
            		refreshIntervalId = window.setInterval(this.fnInspectChk, 60 * 1000);
            	}
            	
            	//메인 페이지로 와도 재호출되는 현상을 막기위해서 재호출 방지 글로벌 변수로 통제
            	if(gInspectPageCallYn == "N") {
            		clearInterval(refreshIntervalId);
            	}
            },
            data: function(){
    			return {
    				 reCallYn : false,
    				 reCallCnt : 0
    			}
    		},
            created : function() {
            	util.logInfo("#inspection created!!!!!");
            	//this.inspection  = util.languageObjReturn(langCode,  'inspection');
            	//this.orderAtCounter  = util.languageObjReturn(langCode,  'orderAtCounter');
            },
            destroyed : function(){
            	util.logInfo("#inspection destroyed refreshIntervalId!");
            	clearTimeout(refreshIntervalId); // refreshIntervalId 타임아웃 제거
            },
            methods : {
            	inputPwdPopupShow : function (evt) {
            		util.logInfo('fnGetInspection click') ;
                    touchtime = 0;
                    //console.log('xxxx');
                	var paramObj = {
              			  title : "권한 확인"
              			, openType : "inspection"
              			, beforePage : "kerbanMain"
                	};
                    this.$root.$emit('inputPwdPopupOpen', paramObj);
                },
            
                fnInspectChk : function() {
            		if(gsSpecialShopFlag == "5"){ // 매장 판단 - 값이 5인 경우 커반 매장(이퀴닉스 서버로 전송할지 여부판단),
						//커반 상품 품절 및 상태를 체크
            			util.ajaxCallKerbanProdCheck(this.fnInspectChkResult);
            			//util.ajaxCallKerbanProdCheck2(this.fnInspectChkResult);
               		}else if(gsSpecialShopFlag == "7" || gsSpecialShopFlag == "9"){ // 매장 판단 - 값이 7인 경우 알다방 매장 , 9인경우 레인보우 로보틱스
						// 알다방 상품 품절 및 상태를 체크            			
            			var vsParam = {"MSG_TYPE":"REQ_STATUS"};                        		
                    	util.ajaxCallJson(vsParam, gAldabangUrl, true, this.fnInspectChkResult);
               		}
            	},
            	// 콜백 함수.
            	fnInspectChkResult : function(result) {
            		if(gsSpecialShopFlag == "5"){ // 커피에 반하다.
            			if(result.code == "200" ){
            				util.logInfo("### fnInspectChkResult cnt : " + this.reCallCnt++);
            				util.logInfo("### refreshIntervalId  : " + refreshIntervalId);
            				util.logInfo("### typeof result.availability  : " + typeof result.availability);
            				if(result.availability){
            					util.logInfo("### result.availability  : " + result.availability);
            					clearInterval(refreshIntervalId);
            					router.push({name : 'start'});
            				}
            			}
            		}else if(gsSpecialShopFlag == "7" || gsSpecialShopFlag == "9"){ // 매장 판단 - 값이 7인 경우 알다방 매장 , 9인경우 레인보우 로보틱스
            			if(result != "error" && result != "timeout"){
            				if(result.READY){ // 준비 상태가 false라면 점검중 화면으로 이동.
                				util.logInfo("### result.READY  : " + result.READY);
                				clearInterval(refreshIntervalId);
            					router.push({name : 'start'});
                    		}
                		}
            			
               		}
            	}
            }
        };
        return returnTemplate;
    },
    
    this.fnMemberService = function(){
        var returnTemplate = { template: '#memberService'
            , created : function() {
                util.logInfo('memberService created==' + this.alertPopupShow);
                this.phoneNo = "010";
            }
            ,mounted : function() {
                this.mealTake = this.$route.params.id;
                // 영어일 때, 정보이용동의 버튼의 체크버튼을 왼쪽으로 좀더 이동시킨다. (영문이 길어서 포지션 맞춤)
                if(langCode == "en"){
                	this.engStyle = "eng"
                }else{
                	this.engStyle = ""
                }
                 
                $( document ).ready(function() {
//                    var checkoutHistory = document.getElementById('showCheckoutHistory');
//                    checkoutHistory.onchange = function() {
//                        console.log(checkoutHistory);
//                        util.logInfo('notifyTalk checkoutHistory.checked : ' + checkoutHistory.checked);
//                        
//                        if (checkoutHistory.checked) {
//                            $('.alert_message_wrap').fadeOut(500);
//                        } else {
//                            $('.alert_message_wrap').fadeIn(500);
//                        }
//                    }
                });
                
                util.logInfo('memberService mounted==' + this.mealTake);
            }
            ,data: function(){
                return {
                    phoneNo : "",
                    phoneMask : "",
                    mealTake : "",
                    menuReady1 : util.languageObjReturn(langCode, 'memberServie1'),
                    menuReady2 : util.languageObjReturn(langCode, 'memberServie2'),
                    personalInfo : util.languageObjReturn(langCode, 'personalInfo'),
                    orderTextMessage : util.languageObjReturn(langCode, 'memberServie4'),
                    personalInfoItem : util.languageObjReturn(langCode, 'personalInfoItem'),
                    phoneNumber : util.languageObjReturn(langCode, 'phoneNumber'),
                    periodPersonalInfo : util.languageObjReturn(langCode, 'periodPersonalInfo'),
                    messageNotiService : util.languageObjReturn(langCode, 'memberServie6'),
                    refuseAgreement : util.languageObjReturn(langCode, 'refuseAgreement'),
                    refusePersonalInfo : util.languageObjReturn(langCode, 'memberServie4'),
                    chargedAcco : util.languageObjReturn(langCode, 'chargedAcco'),
                    cancelTextMessageService : util.languageObjReturn(langCode, 'cancelTextMessageService'),
                    infoAgree : util.languageObjReturn(langCode, 'infoAgree2'),
                    contentsView : util.languageObjReturn(langCode, 'infoAgree3'),
                    //contentsView : util.languageObjReturn(langCode, 'contentsView'),
                    inputComp : util.languageObjReturn(langCode, 'inputComp'),
                    engStyle : "",
                    infoChkMsg : util.languageObjReturn(langCode, 'infoChkMsg')
                }
            }
            ,methods : {
                
                fnNumberBox : function(value){
                    //phoneMask  : 
                    //phoneNo : 입력받은 휴대폰 번호.

                    if(value == "I"){
                        this.phoneNo = "";
                    }else if(value == "D"){
                        this.phoneNo = this.phoneNo.substr(0, (this.phoneNo.length-1));
                    }else if(value == "010"){
                    	this.phoneNo = "010"
                    }else {
                        if(this.phoneNo.length > 10){
                            return false;
                        }
                        this.phoneNo = this.phoneNo + value;
                    }
                    
                    var x1 = util.fnPhoneNumMasking(this.phoneNo);
                    
                    this.phoneMask = x1;

                },
                fnInfoPopupShow : function(){

                	util.logInfo('memberService fnInfoPopupShow==' + $('.layerPopup').css('display'));
                	util.logInfo('memberService gsNotifyMsgVisible==' + gsNotifyMsgVisible);

                    if( $('.layerPopup').css('display') == 'none' && gsNotifyMsgVisible == "N" )
                    {
                    	gsNotifyMsgVisible = "Y";
                        $(".layerPopup").show();
                    }
                        
                },
                fnInfoPopupClose : function() {
                	
                	$(".layerPopup").hide();
                },
                fnInputComplete : function() {
                	let dataObj = {};
                    util.logInfo('memberService phoneNo==' + this.phoneNo.substring(this.phoneNo.length-4));
                    util.logInfo('memberService $("#showCheckoutHistory").is(":checked") : ' + $("#showCheckoutHistory").is(":checked"));
                    
                    if(this.phoneNo.replace(/-/g, '').length < 10) {
                        
                        //dataObj.message = util.languageObjReturn(langCode, 'pleaseInfoAgree');
                        dataObj = {
                              button1Show : true
                            , button1Name : util.languageObjReturn(langCode, 'no') // [ 아니오 ]
                            , button1Func : ""
                            , button2Show : true
                            , button2Name : util.languageObjReturn(langCode, 'yes') // [ 예 ]
                            , button2Func : this.fnMoveMenuPage
                            , message     : util.languageObjReturn(langCode, 'notMemberService')
                        };

                        eventBus.$emit('alertPopupIndex', dataObj);
                        return false;
                    }

                    if(this.phoneNo.replace(/-/g, '').length > 10 ) {
                        //basicOrderInfo.notifyTalkPhoneNo = this.phoneNo.replace(/-/g, '');
                    	let barodaParams;
                    	if(orderInfo.BARODA_INFO !== undefined ) {
                    		//구독신청
//                    		barodaParams = {
//                				storeId : gShopCd
//                				, subscribeProductCode : orderInfo.BARODA_INFO.subscribeProductCode
//                				, subscribeProductName : orderInfo.BARODA_INFO.subscribeProductName
//                				, phoneNumber : this.phoneNo
//                				, subscribeStartDate : moment().format('YYYYMMDD')
//                				, subscribeEndDate : moment().add(30, 'days').format("YYYYMMDD")
//                				, avaliableQuantity : 3
//                    		}
//                    		util.barodaAjaxCall(barodaParams, false, "POST", "/api/subscribe/buy", this.barodaSubscribeBuyCallBack);
                    		orderInfo.BARODA_INFO.phoneNumber = this.phoneNo.replace(/-/g, '');
                    		
                    		barodaParams = {
                        			storeId : gShopCd
                					, phoneNumber : this.phoneNo.replace(/-/g, '')
                            	}
                        	util.barodaAjaxCall(barodaParams, false, "GET", "/api/subscribe", this.barodaSubscribeBuyCallBack);
                    	} else {
                    		//구독조회
                        	barodaParams = {
                    			storeId : gShopCd
            					, phoneNumber : this.phoneNo.replace(/-/g, '')
                        	}
                        	
                        	let freeSubsVal = (util.GetEnvXmlPosENV ( 752 ) || "0" );
                        	if(freeSubsVal == "1") { //[삼성전용]커피에반하다 멤버십 무료 체험 매장 설정
                        		util.barodaAjaxCall(barodaParams, false, "GET", "/api/subscribe/free-target", this.barodaSubscribeFreeCallBack);
                        	} else {
                        		util.barodaAjaxCall(barodaParams, false, "GET", "/api/subscribe", this.barodaSubscribeCallBack);
                        	}
                    	}
                    	
                    } else {
                        dataObj.message = util.languageObjReturn(langCode, 'phoneNumberIn');
		                eventBus.$emit('alertPopupIndex', dataObj);
                    }
                },
                fnMoveMenuPage : function() {
                    router.push({name: "menu", params: { id: this.mealTake, "beforePage" : "memberService" },});

                },
                touchAudio : function(){
                	util.fnTouchAudio(); // 터치할 때 소리 나도록 함수 호출.
                },
                fnBackNotify : function(){ 
                	if(orderInfo.BARODA_INFO !== undefined ){
                		this.$router.push({path: '/menu'});
                	} else {
                		this.$router.push({path: '/start'});
                	}
                },
                barodaSubscribeCallBack : function(barodaResult) {
                	let dataObj;
                	//구독권이 있는경우
                	if(barodaResult.success && barodaResult.result !== null) {
                		let BARODA_INFO = {
                			subscribeNumber : barodaResult.result.subscribeNumber
        					, subscribeProductCode : barodaResult.result.subscribeProductCode
        					, subscribeProductName : barodaResult.result.subscribeProductName
        					, storeId : barodaResult.result.storeId
        					, phoneNumber : barodaResult.result.phoneNumber
        					, subscribeStartDate : barodaResult.result.subscribeStartDate
        					, subscribeEndDate : barodaResult.result.subscribeEndDate
        					, avaliableQuantity : barodaResult.result.avaliableQuantity
        					, newSubscribeStatus: "N"
                		}
                		
                		//구매가능수량이 0잔일때는 할인된 가격으로 표시 X
                		if(Number(BARODA_INFO.avaliableQuantity) < 1) {
                			BARODA_INFO.avaliableQuantity = 0;
                			gMemberServiceYn = "N";
                		} else {
                			gMemberServiceYn = "Y";
                			gBarodaInfo = BARODA_INFO;
                		}
                		//orderInfo.BARODA_INFO = gBarodaInfo;
                		
                		dataObj = {
        					message : "현재 구매가능수량 : " + BARODA_INFO.avaliableQuantity +"잔"
        					, message2 : "시작일자 : " + BARODA_INFO.subscribeStartDate +" / 종료일자 : " + BARODA_INFO.subscribeEndDate
        					, button2Show : true
        					, button2Name : util.languageObjReturn(langCode, 'confirmation') // [ 예 ]
                            , button2Func : function () { router.push({name: "menu", params: { id: this.mealTake, "beforePage" : "memberService"}}); } 
            				, data        : {"memSubGoToFunYn" : "Y" } 
            			}
                		eventBus.$emit('alertPopupIndex', dataObj);
                		//router.push({name: "menu", params: { id: this.mealTake, "beforePage" : "memberService" },});
                	} else {
                        //요청을 정상 처리하였으나, 조회된 데이터 없는 경우, result 값이 null 또는 empty arrany
                        // if(barodaResult.code == "E9999") {
                		if(barodaResult.code == "S0001") 
                        {
                			let clsRow;
                			//구독권이 없는경우 구독권 구입 페이지로 이동 -> 카테고리에서 구독권 클릭상태
                        	let resultClsData = gfn_SQLiteSQLProcess(sqlQuery.getKioskClsData_SQL, [gShopCd]);
                			if ( resultClsData!= null && resultClsData.ResultCode == "0" ) {
                				let clsRows = resultClsData.Data;
                				if ( clsRows == undefined || clsRows == null ||  clsRows.length == 0 ) {
                					util.logError( "KIOSK 의 그룹정보를 가져오지 못하였습니다." );
                					return [];
                				}
            					for(var i=0; i < clsRows.length; i++) {
            						if(clsRows[i].TU_CLS_NM_EN == "MEMBERSHIP" || clsRows[i].TU_CLS_NM_EN == "구독권") {
            							clsRow = clsRows[i];
            							break;
            						}
            					}
                			}
                			
                			dataObj = {
            					message : barodaResult.message + " 구독권 구매 페이지로 이동 합니다."
            					, button2Show : true
            					, button2Name : util.languageObjReturn(langCode, 'confirmation') // [ 예 ]
                                , button2Func : function () { router.push({name: "menu", params: { id: this.mealTake, "beforePage" : "memberService", "memberServiceCls" : clsRow }}); } 
                				, data        : {"memSubGoToFunYn" : "Y" } 
                			}
                		} else {
                			dataObj = {
            					message : barodaResult.message
                			}
                		}
 		                eventBus.$emit('alertPopupIndex', dataObj);
                	}
                }
                , barodaSubscribeBuyCallBack : function(result) {
                	let dataObj;
                	//구독권 구매 신청전 해당번호로 구독권 조회
                	if(result.success) {
                		//정상인 경우 구독권이 있으니 중복 구매 방지
//                		dataObj = {
//                				message : "구독권을 구매하신 고객님입니다."
//                				, button2Show : true
//                                , button2Name : util.languageObjReturn(langCode, 'confirmation') // [ 예 ]
//                                , button2Func : this.fnMoveMenuPage
//                    		}
// 		                eventBus.$emit('alertPopupIndex', dataObj);
//                		//구독번호
//                		orderInfo.BARODA_INFO.subscribeNumber = result.subscribeNumber;
                		
                		orderInfo.BARODA_INFO.newSubscribeStatus = "Y";
            			this.$router.push({path: '/paymentChoiceView'});
                	} else {
                		if(result.code == "E9999"){
                			//신규구독자이므로 결제화면으로 이동
                			orderInfo.BARODA_INFO.newSubscribeStatus = "Y";
                			this.$router.push({path: '/paymentChoiceView'});
//        					dataObj = {
//            					message : "구매전화번호 : " + this.phoneNo + " 시작일 : " + moment().format('YYYYMMDD') + " 종료일 : " + moment().add(30, 'days').format("YYYYMMDD")
//            					, button2Show : true
//            					, button2Name : util.languageObjReturn(langCode, 'confirmation') // [ 예 ]
//                                , button2Func : function () { this.$router.push({path: '/paymentChoiceView'}); } 
//                				, data        : {"memSubGoToFunYn" : "Y" } 
//                			}
//        					eventBus.$emit('alertPopupIndex', dataObj);
                		} else {
                			//그외 에러메세지
                			dataObj = {
                    				message : result.message
                    				, button2Show : true
                                    , button2Name : util.languageObjReturn(langCode, 'confirmation') // [ 예 ]
                                    , button2Func : this.fnMoveMainPage
                        		}
     		                eventBus.$emit('alertPopupIndex', dataObj);
                		}
                	}
                }
                , barodaSubscribeFreeCallBack : function(result) {
                	let dataObj;
                	let barodaParams;
                	//무료 구독권 대상자인지 확인
                	if(result.result) {
                    	//무료 구독권 구매 대상자, 무료구독권결제(전메뉴 구독권)
                    	dataObj = {
        					message : util.languageObjReturn(langCode, 'memberServie10')
        					, button2Show : true
        					, button2Name : util.languageObjReturn(langCode, 'confirmation') // [ 예 ]
                            , button2Func : this.barodaSubscribeFreeBuy 
            				, data        : {"memSubGoToFunYn" : "N" } 
            			}
    					eventBus.$emit('alertPopupIndex', dataObj);
                    	
                	} else {
                		if(!result.result){
                			//무료 구독권 대상자가 아닌경우 기존 구독권 구매자인지 확인후에 구독권 상품 카테고리로 이동 
                			//구독조회
                        	barodaParams = {
                    			storeId : gShopCd
            					, phoneNumber : this.phoneNo.replace(/-/g, '')
                        	}
                        	
                    		util.barodaAjaxCall(barodaParams, false, "GET", "/api/subscribe", this.barodaSubscribeCallBack);
                		} else {
                			//그외 에러메세지
                			dataObj = {
                					message : result.message
                					, button2Show : true
                					, button2Name : util.languageObjReturn(langCode, 'confirmation') // [ 예 ]
                					, button2Func : this.fnMoveMainPage
                			}
                			eventBus.$emit('alertPopupIndex', dataObj);
                		}
                	}
                }
                , barodaSubscribeFreeBuy : function () {
                	//무료구독권은 전메뉴 구독권을 제공
                	let barodaParams = {
            			storeId : gShopCd
            			, subscribeProductCode : "E9900002"
                        , phoneNumber : this.phoneNo.replace(/-/g, '')
                        //무료체험매장인 경우 구독권 구매 시, amount / orderID는 제외 - 20240109 , WDH
                        // , amount : "0"
                        // , orderId : "1200" // 주문 ID
                	}
                	util.barodaAjaxCall(barodaParams, false, "POST", "/api/subscribe/buy", this.barodaSubscribeFreeBuyCallBack);
                }
                , barodaSubscribeFreeBuyCallBack : function (result) {
                	let dataObj;
                	let barodaParams;
                	
                	if(!result.success) {
                		//구독권 무료체험 가입이 실패한 경우 에러메세지
            			dataObj = {
            					message : result.message
            					, button2Show : true
            					, button2Name : util.languageObjReturn(langCode, 'confirmation') // [ 예 ]
            					, button2Func : this.fnMoveMainPage
            			}
            			eventBus.$emit('alertPopupIndex', dataObj);
            			return;
                	}
                	
                	//구독권 가입신청후 조회
                	barodaParams = {
            			storeId : gShopCd
    					, phoneNumber : this.phoneNo.replace(/-/g, '')
                	}
                	let barodaResult = util.barodaAjaxCall(barodaParams, false, "GET", "/api/subscribe");
                	
                	if(barodaResult.success) {
                		let BARODA_INFO = {
                			subscribeNumber : barodaResult.result.subscribeNumber
        					, subscribeProductCode : barodaResult.result.subscribeProductCode
        					, subscribeProductName : barodaResult.result.subscribeProductName
        					, storeId : barodaResult.result.storeId
        					, phoneNumber : barodaResult.result.phoneNumber
        					, subscribeStartDate : barodaResult.result.subscribeStartDate
        					, subscribeEndDate : barodaResult.result.subscribeEndDate
        					, avaliableQuantity : barodaResult.result.avaliableQuantity
        					, newSubscribeStatus: "N"
                		}
                		
                		gBarodaInfo = BARODA_INFO;
                		gMemberServiceYn = "Y";
                		
                		router.push({name: "menu", params: { id: this.mealTake, "beforePage" : "memberService"}});
                	} else {
            			//그외 에러메세지
            			dataObj = {
            					message : barodaResult.message
            					, button2Show : true
            					, button2Name : util.languageObjReturn(langCode, 'confirmation') // [ 예 ]
            					, button2Func : this.fnMoveMainPage
            			}
            			eventBus.$emit('alertPopupIndex', dataObj);
                	}
                }
                , fnMoveMainPage : function() {
                	this.$router.push({path: '/start'});
                }
            }
        };
        return returnTemplate;

    },

    this.fnKerbanMemberService = function(){
        var returnTemplate = { template: '#kerbanMemberService'
            , created : function() {
                util.logInfo('kerbanMemberService created==' + this.alertPopupShow);
                this.phoneNo = "010";
            }
            ,mounted : function() {
                this.mealTake = this.$route.params.mealTake;
                // 영어일 때, 정보이용동의 버튼의 체크버튼을 왼쪽으로 좀더 이동시킨다. (영문이 길어서 포지션 맞춤)
                if(langCode == "en"){
                	this.engStyle = "eng"
                }else{
                	this.engStyle = ""
                }
                 
                $( document ).ready(function() {
//                    var checkoutHistory = document.getElementById('showCheckoutHistory');
//                    checkoutHistory.onchange = function() {
//                        console.log(checkoutHistory);
//                        util.logInfo('notifyTalk checkoutHistory.checked : ' + checkoutHistory.checked);
//                        
//                        if (checkoutHistory.checked) {
//                            $('.alert_message_wrap').fadeOut(500);
//                        } else {
//                            $('.alert_message_wrap').fadeIn(500);
//                        }
//                    }
                });
                
                util.logInfo('kerbanMemberService mounted== mealTake :: ' + this.mealTake);
            }
            ,data: function(){
                return {
                    phoneNo : "010",
                    phoneMask : "010",
                    mealTake : "",

                    menuReady1 : util.languageObjReturn(langCode, 'kerbanMemberServie1'),
                    menuReady2 : util.languageObjReturn(langCode, 'kerbanMemberServie2'),
                    personalInfo : util.languageObjReturn(langCode, 'personalInfo'),
                    orderTextMessage : util.languageObjReturn(langCode, 'memberServie4'),
                    personalInfoItem : util.languageObjReturn(langCode, 'personalInfoItem'),
                    phoneNumber : util.languageObjReturn(langCode, 'phoneNumber'),
                    periodPersonalInfo : util.languageObjReturn(langCode, 'periodPersonalInfo'),
                    messageNotiService : util.languageObjReturn(langCode, 'memberServie6'),
                    refuseAgreement : util.languageObjReturn(langCode, 'refuseAgreement'),
                    refusePersonalInfo : util.languageObjReturn(langCode, 'memberServie4'),
                    chargedAcco : util.languageObjReturn(langCode, 'chargedAcco'),
                    cancelTextMessageService : util.languageObjReturn(langCode, 'cancelTextMessageService'),
                    infoAgree : util.languageObjReturn(langCode, 'kerbanInfoAgree2'),
                    contentsView : util.languageObjReturn(langCode, 'kerbanInfoAgree3'),
                    //contentsView : util.languageObjReturn(langCode, 'contentsView'),
                    inputComp : util.languageObjReturn(langCode, 'inputComp'),
                    engStyle : "",
                    infoChkMsg : util.languageObjReturn(langCode, 'infoChkMsg')
                }
            }
            ,methods : {
                
                fnNumberBox : function(value){
                    //phoneMask  : 
                    //phoneNo : 입력받은 휴대폰 번호.

                    if(value == "I"){
                        this.phoneNo = "";
                    }else if(value == "D"){
                        this.phoneNo = this.phoneNo.substr(0, (this.phoneNo.length-1));
                    }else if(value == "010"){
                    	this.phoneNo = "010"
                    }else {
                        if(this.phoneNo.length > 10){
                            return false;
                        }
                        this.phoneNo = this.phoneNo + value;
                    }
                    
                    var x1 = util.fnPhoneNumMasking(this.phoneNo);
                    
                    this.phoneMask = x1;

                },

                fnInfoPopupShow : function(){

                	util.logInfo('memberService fnInfoPopupShow==' + $('.layerPopup').css('display'));
                	util.logInfo('memberService gsNotifyMsgVisible==' + gsNotifyMsgVisible);

                    if( $('.layerPopup').css('display') == 'none' && gsNotifyMsgVisible == "N" )
                    {
                    	gsNotifyMsgVisible = "Y";
                        $(".layerPopup").show();
                    }
                        
                },
                fnInfoPopupClose : function() {
                	
                	$(".layerPopup").hide();
                },
                
                fnInputComplete : function() {
                	let dataObj = {};
                    util.logInfo('kerbanMemberService phoneNo==' + this.phoneNo.substring(this.phoneNo.length-4));
                    util.logInfo('kerbanMemberService $("#showCheckoutHistory").is(":checked") : ' + $("#showCheckoutHistory").is(":checked"));
                    
                    if(this.phoneNo.replace(/-/g, '').length < 10) {
                        
                        //dataObj.message = util.languageObjReturn(langCode, 'pleaseInfoAgree');
                        dataObj = {
                              button1Show : true
                            , button1Name : util.languageObjReturn(langCode, 'no') // [ 아니오 ]
                            , button1Func : ""
                            , button2Show : true
                            , button2Name : util.languageObjReturn(langCode, 'yes') // [ 예 ]
                            , button2Func : this.fnMoveMenuPage
                            , message     : util.languageObjReturn(langCode, 'notMemberService')
                        };

                        eventBus.$emit('alertPopupIndex', dataObj);
                        return false;
                    }

                    if(this.phoneNo.replace(/-/g, '').length > 10 ) {

                        var this_ = this;
                        // 커반 사용자 정보 조회 후 콜백
                        var fnKerbanGetUserInfoCallback = function(result) {
                            util.logInfo("### fnKerbanGetUserInfoCallback result : " + JSON.stringify(result))
                            // result.resultCode // 결과코드
                            // result.resultMessage // 메시지
                            // result.verboseMessage // 개발자용 상세 메시지

                            if(result.resultCode == "SUCCESS") {
                                var data = result.data; 
                                // data.serviceId; // 서비스ID
                                // data.posStoreNo; // POS매장번호
                                // data.posTerminalNo; // POS터미널번호(POS식별번호)
                                // data.sign; // Sign
                                // data.phoneNo // 휴대폰 번호
                                // data.userNm // 사용자명
                                // data.userGrade // 고객등급
                                // data.discountRate // 등급할인율
                                // data.lastWeekVisits // 전주 방문횟수
                            
                                var discountRate = Number(data.discountRate) // 고객등급할인율

                                kerbanDiscountRate = discountRate;
                                
                                if(discountRate > 0 && discountRate < 100){ // 커반 할인률적용 여부
                                    kerbanDiscountRateYn = "Y";
                                }else{
                                    kerbanDiscountRateYn = "N";
                                }

                                console.log('discountRate', discountRate);
                                console.log('kerbanDiscountRateYn', kerbanDiscountRateYn);
    
                                // var paramObj = {"name" : 'menu', "mealTake" : this.mealTake, "beforePage" : "index"};
                                // util.fnIndexMoveMenu(paramObj);
                                this_.fnMoveMenuPage();
                            }else if(result.resultCode == "ERROR") {
                                //톨게이트 선불카드 조회 실패입니다. 관리자에게 문의해주세요.
                                var errMsg = "사용자 조회 실패입니다. 관리자에게 문의해주세요.";
                                if(!util.isEmpty(result.resultMessage)){
                                    errMsg = result.resultMessage + " 주문화면으로 이동합니다.";
                                }
                                let dataObj = {};
                                dataObj.button2Show = true;
                                dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm') // [ 예 ]
                                dataObj.button2Func = function() {
                                    this_.fnMoveMenuPage();
                                }
                                dataObj.message = errMsg;	
                                eventBus.$emit('alertPopupIndex', dataObj);
                            }else if(result.data == null){
                                var errMsg = result.resultMessage + " 주문화면으로 이동합니다.";
                                let dataObj = {};
                                dataObj.button2Show = true;
                                dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm') // [ 예 ]
                                dataObj.button2Func = function() {
                                    this_.fnMoveMenuPage();
                                }
                                dataObj.message = errMsg;	
                                eventBus.$emit('alertPopupIndex', dataObj);
                            }



                            // var paramObj = {"name" : 'menu', "mealTake" : this.mealTake, "beforePage" : "index"};
                            // util.fnIndexMoveMenu(paramObj);
                            
                            
                        }
                        
                        util.fnKerbanGetUserInfo(this.phoneNo, fnKerbanGetUserInfoCallback); // 커반 사용자 정보 조회..
                    	
                    	
                    } else {
                        dataObj.message = util.languageObjReturn(langCode, 'phoneNumberIn');
		                eventBus.$emit('alertPopupIndex', dataObj);
                    }
                },
                fnMoveMenuPage : function() {

                    router.push({name: "menu", params: { id: this.mealTake, "beforePage" : "kerbanMemberService" },});

                },
                touchAudio : function(){
                	util.fnTouchAudio(); // 터치할 때 소리 나도록 함수 호출.
                },
                fnBackNotify : function(){  // 닫기버튼
                    this.$router.push({path: '/start'});                	
                }
                , fnMoveMainPage : function() {
                	this.$router.push({path: '/start'});
                }
            }
        };
        return returnTemplate;

    }
}