var AdminSettingView = function(){

    this.swModelName = "##T4KIOSK001";		// ##T4KIOSK001		SamplePOS001		##WIN4POS001 ..???
    this.swModelVersion = "1001";
    this.posHWInfoHtml = "";

    /**
     * 리더기 사용 설정
     *
     * 	deviceType		POS 리더기 ('0' - CONTACTLESS, '1' - CONTACT)
     * 	setValue 		사용 유무 설정 ('0' - 헤제, '1' - 사용)
     */
    this.fdkReaderUsedSet = function(deviceType, setValue)
    {
    	var result;

    	try {
    		result = nativeApp.functionCallSync(["FDK_ReaderUsedSet", deviceType, setValue]);
    		var resultData = adminSettingView.nativeApiResultCheck(result);
    		util.logInfo('fdkReaderUsedSet  resultData >>' + JSON.stringify(resultData));
    		if(resultData != null) {
    			// TODO...
    		}
    	} catch (e) {
    	    util.logError('fdkReaderUsedSet  e >>' + e.message);
    		util.logError('fdkReaderUsedSet  e >>' + JSON.stringify(e));
    	}
    },
    /**
     * Native 및 기기 정보 초기화
     */
    this.PaymentAppInit = function()
    {
    	var result;

    	try {
    		//result = nativeApi.initialize();
    		// 리더기 섬색
    		result = nativeApp.functionCallSync(["FDK_ReaderFind"]);
    		result = adminSettingView.getnativeAppResult(result);

    		util.logInfo('PaymentAppInit  result >>' + JSON.stringify(result));
    	} catch (e) {
    	    util.logError('PaymentAppInit  e >>' + e.message);
    	    util.logError('PaymentAppInit  e >>' + JSON.stringify(e));
    	}
    	return result;
    },
    /**
     * 장치 사용 유무 설정 및 무결성 검사.
     */
    this.initDevice = function()
    {
    	var posHWInfoHtml = "";
    	var checkResult = [];
    	var checkResultCnt = 0;

    	try {

    		var posDevices = adminSettingView.getPosDeviceUsedInfo();
    		if(posDevices == null) {
    			// "POS 장지 정보가 없다.
    			posHWInfoHtml += '<p><span class="tit">HW모델명</span><span class="vnum">&nbsp;</span></p>';
    			$('#readerTextArea').html(posHWInfoHtml);
    			return;
    		}

    		var deviceCnt = 0;
    		for(i = 0; i < posDevices.length; i++) {
    			var envCd = posDevices[i][0];
    			var envVal = parseInt(posDevices[i][1]);

    			// '1'-CONTACT, '0'-CONTACTLESS
    			var deviceType = (envCd == "100") ? 1 : 0;

    			// Pos 리더기 무결성 검사 : 장치가 사용 설정일 경우만 처리
    			if(envVal == 1) {
    				var infoTitleStr = (deviceCnt == 0) ? "HW모델명" : "&nbsp;";
    				deviceCnt ++;
    				checkResult[checkResultCnt] = adminSettingView.integrityCheck(deviceType, infoTitleStr);
    				util.logInfo('initDevice checkResult  >>' + JSON.stringify(checkResult));
    			}
    		}

    		for(j=0 ; j < checkResult.length ; j++){
                var resultData = checkResult[j];

                util.logInfo('initDevice resultData  >>' + JSON.stringify(resultData));

    		    var checkDate = resultData["Date"];
                var intResult = (resultData["Check"] == "정상") ? "0" : "1";

                var intDt = checkDate.substring(0, 8);
                var intTime = checkDate.substring(8, 10) + ":" + checkDate.substring(10, 12) + ":" + checkDate.substring(12, 14);

                var scrName = resultData["ScrName"];
                var scrVersion = resultData["ScrVersion"];

    		    posHWInfoHtml += "보안리더기 모델명 : " + scrName + " 버전 : " + scrVersion + " \n";

    		}


    	} catch (e) {

    		util.logError('PaymentAppInit  e >>' + JSON.stringify(e));
    		util.logError('PaymentAppInit  e >>' + e.message);
    	}

    	return posHWInfoHtml;
    },

    /**
     * 포스 장시 사용 유무 설정 종보를 얻어 온다.
     */
    this.getPosDeviceUsedInfo = function()
    {
    	var result;

    	try {
    		var sql = "SELECT ENV_CD, ENV_NM, ENV_VAL"
    			    + "  FROM POS_ENV_T"
    			    + " WHERE ENV_CD BETWEEN '100' AND '199'"
    			    + " ORDER BY ENV_CD ASC";

    		var datas = gfn_SQLiteSQLProcess(sql).Data;
    		if(datas == null) {
    		    return null;
    		}

    		var posDevices = new Array(datas.length);
    		for(i = 0; i < datas.length; i++) {
    			posDevices[i] = new Array(2);

    			posDevices[i][0] = datas[i]["ENV_CD"];
    			posDevices[i][1] = datas[i]["ENV_VAL"];
    		}

    		return posDevices;
    	} catch (e) {

    		util.logError('getPosDeviceUsedInfo  e >>' + JSON.stringify(e));
    		util.logError('getPosDeviceUsedInfo  e >>' + e.message);

    	}

    	return null;
    },

    /**
     * 무결성 체크
     */
    this.integrityCheck = function(deviceType, infoTitleStr)
    {
    	var resultData = {};

    	try {
    		result = nativeApp.functionCallSync(["FDK_SecurityCheck", deviceType, "", adminSettingView.swModelName, adminSettingView.swModelVersion]);
    		resultData = adminSettingView.nativeAppResultCheck(result);


    	} catch (e) {
    	    util.logError('integrityCheck  e >>' + e.message);
    		util.logError('integrityCheck  e >>' + JSON.stringify(e));
    	}

    	return resultData;
    },

    /**
     * Native API 결과 처리
     */
    this.nativeAppResultCheck =  function(result)
    {
    	var resultCode;
    	var resultData;
    	var resultMessage;

    	try {
    		if(result.lastIndexOf("$$^") != -1) {
    			result = result.substring(0, result.lastIndexOf("$$^")); 	// Eof 이후 문자는 버린다 ($$^)
    		}

    		$('#divDebug').html("");
    		var jsonResult = JSON.parse(result);

    		resultCode = parseInt(jsonResult["ResultCode"]);	//jsonResult["ResultCode"];
    		resultData = jsonResult["Data"];
    		resultMessage = jsonResult["Message"];

    		util.logInfo('nativeAppResultCheck  resultData >>' + JSON.stringify(resultData));
    		util.logInfo('nativeAppResultCheck  resultMessage >>' + resultMessage);


    		if(resultCode != 0) {
    			if(resultCode == -7100) {
    				resultData = "리더기 오류.<br>리더기를 확인 후 다시 읽혀 주세요.";
    			} else if(resultCode == -7201) {
    				resultData = "IC 카드 거래 불가.<br>카드를 확인 후 다시 읽혀 주세요.";
    			} else if(resultCode == -7104) {
    				resultData = resultMessage;
    			} else {
    				resultData = " [" +resultCode + "] " + resultMessage;
    			}
    		}
    	} catch (e) {

    		resultData = null;
    	}

    	return resultData;
    },

    this.getnativeAppResult = function(result)
    {
    	var apiResult = new Array(3);

    	try {
    		result = result.substring(0, result.lastIndexOf("$$^")); 	// Eof 이후 문자는 버린다 ($$^)
    		var jsonResult = JSON.parse(result);

    		apiResult[0] = parseInt(jsonResult["ResultCode"]);
    		apiResult[1] = jsonResult["Data"];
    		apiResult[2] = jsonResult["Message"];
    	} catch (e) {
    		apiResult = null;
    	}

    	return apiResult;
    },
    this.printData = function(prtPort, baudRate, signImgPath)
    {
        /*
            FDK_Print

            @Param
                - deviceName	: /dev/ttyUSB0
                - baudRate		: 57600
                - printData		: print data
                - dataLength	: print data 길이
                - signImgPath	: 서명 이미지 path

            @Result
                '0' 	: 정상 처리
                '-1'	: 초기화 오류
                '-2'	: 리더기가 검색 되지 않음. 리더 장치 검색 실패

            JSON 결과 예제
                - 정상 : { "ResultCode" : "0",  "Data" : "SUCCESS", "Message" : "" }
                - 오류 : { "ResultCode" : "-2",  "Data" : "NO DEVICE", "Message" : "리더기가가 검색되지 않았습니다.\n리더기 연결 확인 후 다시 시도하세요."  }
         */
        var result;
        try{

            var startTime = new Date().getTime();

            var  reqstr = "";
            reqstr = "\x0a";
            reqstr += "퍼스트데이타";
            reqstr += "\x0a";
            reqstr += "\x0a";
            reqstr += "\x0a";
            reqstr += "![ 영 수 증 ]-재발행!";
            reqstr += "\x1B\x21\x1E";
            reqstr += "\x0a";
            reqstr += "일자 : 2008-05-22 14:28:45";
            reqstr += "\x0a";
            reqstr += "----------------------------------------";
            reqstr += "\x0a";
            reqstr += "\x1B\x21\x10";
            reqstr += "품명             단가  수량    금액";
            reqstr += "\x1B\x21\x1E";
            reqstr += "\x0a";
            reqstr += "----------------------------------------";
            reqstr += "\x0a";
            reqstr += "해물뚝배기           6,000  1     6,000";
            reqstr += "\x0a";
            reqstr += "정성을 다하겠습니다.";
            reqstr += "\x0a";
            reqstr += "\x0a";
            reqstr += "\x11";
            reqstr += "\x1d\x56\x41\x46";




            var printStr = ' This is a test mwssage..1 By Woosung.IM \x0A';

            let dataLength = reqstr.getByteLength() ;

            result = nativeApp.functionCallSync(["FDK_Print", "/dev/ttyS" + prtPort, Number(baudRate), reqstr, dataLength, '']);

            //result = nativeApp.functionCallSync(["FDK_Print", "/dev/ttyS" +  prtPort , baudRate, reqstr, dataLength, signImgPath]);

            util.logDebug('printData  prtPort >> ' + prtPort + ' ,baudRate >>' + baudRate + ", dataLength: " + dataLength + ", signImgPath: " + signImgPath + ", printStr: " +printStr );
            util.logDebug('printData  result >>' + result);

            //result = nativeApp.functionCallSync(["FDK_Print", deviceName, baudRate, printData, dataLength, signImgPath]);


            var endTime = new Date().getTime();
        }catch(e){
            util.logError('printData  e >>' + e.message);
            util.logError('printData  e >>' + JSON.stringify(e));

            result = e.message;

        }

        return result;

    }

    this.fnGetSetAdminPage = function(){
        let returnTemplate = {
        	template: '#setAdminPage',
        	data: function(){
            	return {
            		  afterIp : ""
            		, inputIp : ""
            		, beforeRobotIp : ""
            		, beforeRobotPort : ""
            		, inputRobotIp : ""
            		, inputRobotPort : ""
            		, callMenu : ""
            		, sSaleDate : ""
            		, speed : ""
            		, port : ""
            		, internetUrl : ""
            		, internetUrlShow : false
            		, communicationMessage : ""
            		, barcodeMessage : ""
            		, barcodeStatusMessage : ""
            	};
            },
            destroyed : function(){
                util.logInfo('IP 변경 destroyed');
            },
            created : function() {
            	util.logInfo("created IP 변경");
            },
        	mounted : function(){
        		util.logInfo("<<<===== mounted IP 변경 =====>>>");

        		this.callMenu = this.$route.params.callMenu;
        		util.utilSetDatePicker(".dateFrom",this.fnSelectList);
                util.logInfo('mounted  utilSetDatePicker  sSaleDate >>' + this.sSaleDate);
                util.setNumberingWrap(this.fnSetSearch);

                this.applyCustomSelect("selectPort");
                // 상품관리 스타일 적용
                this.applySelectCssStyle();

                // custom-select에 대한 값이 갱신되지 않아 직접갱신하는 함수 정의
                eventBus.$on('selectBoxSet', this.selectBoxSet);

        		this.fnInit();

            },
            methods : {
                fnInit : function(){
                    var setupResult = gfn_SQLiteSQLProcess(adminSql.selectSetUpTData, [gShopCd, gPosNo]).Data; // 로컬의 대기화면 version을 조회
                    var mainIp = setupResult[0].MAIN_IP;
                    this.afterIp = mainIp;
                    this.fnRobotIpPortS();

                },
                fnRobotIpPortS : function(){
                	this.inputRobotIp = "";
                    this.inputRobotPort = "";
                	var setupRobotResult = util.GetEnvXmlPosENV(746); //gfn_SQLiteSQLProcess(sqlQuery.selectRobotIpPort, [gShopCd]).Data; // 무인 로봇 IP/PORT 조회
                	if(!setupRobotResult){ // 해당
                		this.beforeRobotIp = "";
                        this.beforeRobotPort = "";
                		return;
                	}
                	var vsIdx = setupRobotResult.lastIndexOf(":");
                	var vsRobotIp = setupRobotResult.substring(0,vsIdx);
                	var vsRobotPort = setupRobotResult.substring(vsIdx+1, setupRobotResult.length);
                    this.beforeRobotIp = vsRobotIp;
                    this.beforeRobotPort = vsRobotPort;
                },
                fnSetIp : function(){

                    util.logInfo(" fnSetIp ===  this.inputIp >>>" + this.inputIp);
                    var setupResult = gfn_SQLiteSQLProcess(adminSql.updateSetupMainIp, [this.inputIp, gShopCd, gPosNo]).Data; // 로컬의 대기화면 version을 조회

                    var urlParam = "";
                    try{
                        urlParam = "http://" + this.inputIp + ":2006/SvrApp/MS000.do";
                        var result = nativeApp.functionCallSync(["FDK_SetConfig", "ASP_POST_URL", urlParam, -1]);

                        util.logInfo("FDK_SetConfig urlParam :" + urlParam + ", result : " + result);
                    }catch(e){
                        util.logError("FDK_SetConfig ERROR urlParam :" + urlParam + ", result : " + result);
                    }

                    eventBus.$emit('alertPopup', {message: "MAIN IP가 변경되었습니다"});

                },
                fnSetRobotIpPort : function(){

                	util.logInfo(" fnSetRobotIpPort ===  this.inputRobotIp >>>" + this.inputRobotIp);
                    util.logInfo(" fnSetRobotIpPort ===  this.inputRobotPort >>>" + this.inputRobotPort);
                    if(!this.inputRobotIp || !this.inputRobotPort){
                    	eventBus.$emit('alertPopup', {message: "변경할 IP/PORT를 입력하세요."});
                    	return;
                    }
                    
                    try{
                    	var vsParamUrl = this.inputRobotIp + ":" + this.inputRobotPort; // ip/port를 합쳐서 url형태로 만든다.
                    	var setupResult = gfn_SQLiteSQLProcess(sqlQuery.sqlUpdateScdEnvpsT, [vsParamUrl, gShopCd, "746"]).Data; // 로봇 ip/port 변경
                    	this.fnSetRobotIpPortAspSend(vsParamUrl);
                    	this.fnRobotIpPortS();
                    	eventBus.$emit('alertPopup', {message: "무인로봇 IP/PORT가 변경되었습니다"});
                    }catch(e){
                    	this.fnRobotIpPortS();
                    	eventBus.$emit('alertPopup', {message: "무인로봇 IP/PORT가 변경 중 에러가 발생했습니다."});
                    }
                },
                // 무인로봇 IP/PORT 변경되면 ASP서버로 변경사항을 바꿔준다.
                fnSetRobotIpPortAspSend : function(paramUrl){
                	util.logInfo("_____무인로봇 IP/PORT 변경 후 ASP 전송 시작_____");
                    

                    var url = '/SvrApp/PS000.do';
                    var params = {"TSP-NVP":{"TXJM-FD":{"_SRID":"PS100", "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" ,
                        "DATA-HD":{"_POS_NO":gPosNo, "_SHOP_CD":gShopCd, "_DT_CNT":"1" ,"_INDEX_NO":"01" ,"DATA-DT":{"_PROC_RG":"U", "_ENV_SET_CD":"746", "_ENV_SET_VAL": paramUrl, "_USE_YN":"Y" }}}}};
                    var jsonData;

                    try{
                        jsonData = axiosObj.syncAjaxPost(url, params);
                        util.logInfo("_____무인로봇 IP/PORT 변경 후 ASP 전송 jsonData :: " +  JSON.stringify(jsonData));

                        var txjmFd = jsonData["TSP-NVP"]["TXJM-FD"];


                        if(txjmFd["_RETCD"] == "0000") {
                        	util.logInfo("_____무인로봇 IP/PORT 변경 후 ASP 전송 결과값 정상 [0000]");
                        }else{
                        	util.logInfo("_____무인로봇 IP/PORT 변경 후 ASP 전송 결과값 비정상 [" + txjmFd["_RETCD"] +"]");
                        }
                                                
                    }catch(er){
                        util.logError("_____무인로봇 IP/PORT 변경 후 ASP 전송 CATCH ERROR_____");
                        util.logError("_____무인로봇 IP/PORT 변경 후 ASP 전송 CATCH ERROR 내용 :: " +  JSON.stringify(er));                       
                    }
                },
                fnClosed : function(){
                	util.logInfo("***** setAdminPage fnClosed callMenu == > " + this.callMenu);
                	if(this.callMenu == "adminInit"){
                		location.href = './admin.html';
                	}else{
                		this.$router.push({ path : '/adminMain/adminLogin' });
                	}

                },
                fnSelectList : function(_this){
                    util.logInfo('fnSelectList  _this >>' + _this);

                    if(!util.isEmpty(_this)){
                        this.sSaleDate = _this.value;
                    }

                },
                fnDeleteClose : function(pSaleDate){

                    dataObj = {"button1Show" : true, "button1Name" : "아니요"
                        , "button2Show" : true, "button2Name" : "예",message: "[" + this.sSaleDate + "] 영업일자 마감데이터를 삭제 하시겠습니까?"
                        , "button2Func": util.fnDeletePosRegis
                        , "data" : {"pSaleDate": this.sSaleDate}};
                    eventBus.$emit('alertPopup', dataObj);

                },
                fnKeyClick : function(key){
                    if(key=="RESET"){
                        this.inputIp = "";
                    }else if(key=="DEL"){
                        this.inputIp = this.inputIp.slice(0, -1);
                    }else if(key=="local"){
                        this.inputIp = "localhost";
                    }else{
                        this.inputIp = this.inputIp + key;
                    }

                },
                fnLastDeleteClose : function(){

                    var openSaleDateResult = gfn_SQLiteSQLProcess(adminSql.selectGetSaledate, [gShopCd, mainPosNo]).Data[0];

                    util.logInfo('fnLastDeleteClose  openSaleDateResult >>' + JSON.stringify(openSaleDateResult));

                    var pSaleDate = openSaleDateResult.SALE_DATE;


                    if(!util.isEmptyStr(pSaleDate)){

                        dataObj = {"button1Show" : true, "button1Name" : "아니요"
                            , "button2Show" : true, "button2Name" : "예",message: "[" + pSaleDate + "] 영업일자 마감데이터를 삭제 하시겠습니까?"
                            , "button2Func": util.fnDeletePosRegis
                            , "data" : {"pSaleDate": pSaleDate}};
                        eventBus.$emit('alertPopup', dataObj);
                    }else{
                        eventBus.$emit('alertPopup', {message: "마지막 영업일을 찾지 못했습니다. 관리자한테 문의하세요."});
                    }

                },
                fnReaderFind : function(){

                    var innerHtmlText = "정상 수행";
                    try{
                        adminSettingView.fdkReaderUsedSet(1,0);
                        adminSettingView.fdkReaderUsedSet(1,1);
                        adminSettingView.PaymentAppInit();
                    }catch(e){
                        util.logError('fnReaderFind  e >>' + e.message);
                        innerHtmlText = e.message;
                    }

                    $('#readerTextArea').html(innerHtmlText);
                },
                fnReaderInfo : function(){

                    var innerHtmlText = "정상 수행";

                    try{
                        adminSettingView.PaymentAppInit();
                        innerHtmlText = adminSettingView.initDevice();
                    }catch(e){
                        util.logError('fnReaderFind  e >>' + e.message);
                        innerHtmlText = e.message;
                    }

                    $('#readerTextArea').html(innerHtmlText);

                },
                applyCustomSelect : function(qId) {

                    util.logDebug('applyCustomSelect  qId >>' + qId);

                    let e = $( "#"+qId+ " option:selected" );
                    let text = e.text();
                    let val =  e.val();
                    let pt = e.closest("div");
                    $(pt).find(".select-selected").html(text);
                    $(pt).find(".same-as-selected").removeClass("same-as-selected");
                    $(pt).children(".select-items.select-hide").children("div").each(function(idx, item){
                          let t = $(this).text().trim();
                          if( t == text )
                              $(this).addClass("same-as-selected");
                    });
                },
                applySelectCssStyle : function(){
                    var x, i, j, l, ll, selElmnt, a, b, c;
                    /*look for any elements with the class "custom-select":*/
                    x = document.getElementsByClassName("custom-select");
                    l = x.length;
                    for (i = 0; i < l; i++) {
                        selElmnt = x[i].getElementsByTagName("select")[0];
                        ll = selElmnt.length;
                        /*for each element, create a new DIV that will act as the selected item:*/
                        a = document.createElement("DIV");
                        a.setAttribute("class", "select-selected");
                        a.innerHTML = selElmnt.options[selElmnt.selectedIndex].innerHTML;
                        x[i].appendChild(a);
                        /*for each element, create a new DIV that will contain the option list:*/
                        b = document.createElement("DIV");
                        b.setAttribute("class", "select-items select-hide");
                        for (j = 0; j < ll; j++) {
                            /*for each option in the original select element,
                            create a new DIV that will act as an option item:*/
                            c = document.createElement("DIV");

                            //하위 클릭이벤트에서 해당 컴포넌트가 어떤 select인지 알기위해 id속성 추가. BJK
                            c.setAttribute("id", selElmnt.id+"_"+j);

                            c.innerHTML = selElmnt.options[j].innerHTML;
                            c.addEventListener("click", function(e) {
                                /*when an item is clicked, update the original select box, and the selected item:*/
                                var y, i, k, s, h, sl, yl;
                                s = this.parentNode.parentNode.getElementsByTagName("select")[0];
                                sl = s.length;
                                h = this.parentNode.previousSibling;
                                for (i = 0; i < sl; i++) {
                                    if (s.options[i].innerHTML == this.innerHTML) {
                                        s.selectedIndex = i;
                                        h.innerHTML = this.innerHTML;
                                        y = this.parentNode.getElementsByClassName("same-as-selected");
                                        yl = y.length;
                                        for (k = 0; k < yl; k++) {
                                            y[k].removeAttribute("class");
                                        }
                                        this.setAttribute("class", "same-as-selected");
                                        // [추가] 2020-10-20:: "data-value" 속성 추가 / option.val();
                                        this.setAttribute("data-value", s.options[i].value);

                                        // select box 커스터마이징할때 값이 갱신되지 않아 id와 value를 담아 직접 셋팅하는 함수 호출 코드 추가. BJK
                                        var vsSelId = this.id;
                                        var vsId = vsSelId.substring(0,vsSelId.lastIndexOf("_"));
                                        var dataObj = {"id" : vsId, "value" : s.options[i].value};
                                        eventBus.$emit('selectBoxSet', dataObj);

                                        break;
                                    }
                                }
                                h.click();
                            });
                            b.appendChild(c);

                            if(j==0){
                                this.selectBoxSet({"id" : selElmnt.id, "value" : selElmnt.options[j].value });
                            }

                        }
                        x[i].appendChild(b);
                        a.addEventListener("click", function(e) {
                            /*when the select box is clicked, close any other select boxes, and open/close the current select box:*/
                            e.stopPropagation();
                            adminService.fnProdSelectAllCloseStyle(this);
                            this.nextSibling.classList.toggle("select-hide");
                            this.classList.toggle("select-arrow-active");
                        });
                    }
                },
                selectBoxSet : function(data)  {
                    util.logDebug('selectBoxSet  qId >>' + data.id);

                    // select box 커스터마이징할때 값이 갱신되지 않아 해당 함수를 통해 값 갱신. BJK
                    if(data.id == "selectPort"){
                        this.port = data.value
                    }else if(data.id == "selectSpeed"){
                        this.speed = data.value
                    }
                },
                fnCheckPrint : function(){
                    util.logDebug('fnCheckPrint  speed >>' + this.speed);
                    var printResult = adminSettingView.printData(this.port, this.speed, '');

                    util.logDebug('fnCheckPrint  printResult >>' + this.printResult);

                    eventBus.$emit('alertPopup', {message: printResult});
                },
                fnCallNaver : function(){

                    util.logDebug('fnCallNaver  start======================== ');
                    var popup = window.open('http://www.naver.com', '네이버팝업', 'width=700px,height=800px,scrollbars=yes');

                    this.internetUrlShow = !this.internetUrlShow;

                    util.logDebug('fnCallNaver  start======================== internetUrlShow : ' + this.internetUrlShow);

                    if(this.internetUrlShow){
                        this.internetUrl = "https://www.samsung.com/";
                    }else{
                        this.internetUrl = "";
                    }
                },
                fnCheckAsp : function(){
                    this.communicationMessage = "";
                    var url = '/SvrApp/DN000.do'
                    this.fnInterlockAsp(url);

                },
                fnCheckCommunication : function(){
                    this.communicationMessage = "";
                    if(util.fnIsMainPos()){
                        var url =  '/SvrApp/DN000.do'

                        let row = util.getDbSingleRow( gfn_SQLiteSQLProcess( "SELECT * FROM SCD_SETUP_T  " , []) );

                        var mainUrl = 'http://' + row.MAIN_IP + ':2006';
                        this.fnInterlockAsp(url, mainUrl);
                    }else{
                        eventBus.$emit('alertPopup', {message: "연동형타입만 확인 가능합니다."});

                    }
                },
                fnInterlockAsp :function(url, mainUrl){
                    var kioskVerSeq = KIOSK_VER_SEQ;
                    var aspResult = "";

                    var params ={"TSP-NVP" :{
                                "TXJM-FD" :{"_SRID":"DN090", "_RETCD":"0000", "_KIOSK_REQ_YN":"Y"
                                    ,"DATA-HD":{"_POS_NO" : gPosNo , "_SHOP_CD"	: gShopCd, "_VER_SEQ"	: kioskVerSeq}
                                }
                            }
                    };

                    util.logDebug("fnCheckAsp url : " +  url + ", mainUrl : " + mainUrl);
                    util.logDebug("fnCheckAsp params : " +  JSON.stringify(params));

                    try{
                        var jsonData;
                        if(!util.isEmptyStr(mainUrl)){
                            jsonData = axiosObj.syncAjaxPost(url, params, mainUrl);
                        }else{
                            jsonData = axiosObj.syncAjaxPost(url, params);
                        }

                        var txjmFd = jsonData["TSP-NVP"]["TXJM-FD"];
                        var resultData = {};

                        if(txjmFd["_RETCD"] == "0000") {
                            this.communicationMessage = "정상 수행";
                            util.logError("fnCheckAsp DN090 처리 성공");
                        }else{
                            this.communicationMessage = "처리 실패";
                            util.logError("fnCheckAsp DN090 처리 실패");
                        }
                        var dataHd = txjmFd["DATA-HD"];


                    }catch(e){
                        util.logError('fnCheckAsp  e >>' + JSON.stringify(e));
                        util.logError('fnCheckAsp  e >>' + e.message);
                        this.communicationMessage = "처리 실패";

                    }
                    return aspResult
                },
                fnCheckBarCodeReader : function() {
                    util.logDebug('barcode scan start!!');
                    this.barcodeMessage = "";
                    this.barcodeStatusMessage = "동작중";
                    try {
                        if(typeof tizen === 'undefined' ) {
                            this.fncBarCodeListner("281006020000000000857324");//윈도우는 테스트 카카오 페이 신용
                        } else {
                            b2bbarcode.startScanBarcode(this.fncBarCodeListner);
                        }

                    } catch (e) {
                        util.logError('## error barcode : ' + e.message);
                        util.logError(e);
                        this.barcodeStatusMessage = e.message;
                    }
                },
                fnEndBarCodeReader : function(){
                    util.logDebug('fnEndBarCodeReader scan end!!');
                    this.barcodeStatusMessage = "중지";
                    try {
                        if(typeof tizen != 'undefined' ) {
                            b2bbarcode.stopScanBarcode();
                        }
                    } catch (e) {
                        util.logError('## error barcode : ' + e.message);
                        util.logError(e);
                        this.barcodeStatusMessage = e.message;
                    }

                },
                fncBarCodeListner : function(msg){
                    util.logDebug('fncBarCodeListner msg  :: ' + JSON.stringify(msg));
                    this.barcodeMessage = msg.data;
                }
            }
        };
        return returnTemplate;
    }
}