var AspSaleTransDataService = function() {
	var billNo;
	var fileName;
	var reSendAspDataCnt = 1;
	/*****************************************************
	 * SSL_TRHDR_T : 매출TR-HEADER
	 * 1. 매출정보 조회
	 *  - 매출정보 헤더 조회
	 *  - 품목 건수 조회, 신용결제건수 조회, 제휴카드 건수 조회
	 *  - ASP 데이터 송신
	 *****************************************************/

	this.TLGM_S_SL010_DATA_DT_ATTRS_01 = "REGI_SEQ,SALE_YN,TOT_SALE_AMT,TOT_DC_AMT,SVC_TIP_AMT,TOT_ETC_AMT,DCM_SALE_AMT,VAT_SALE_AMT,VAT_AMT,NO_VAT_SALE_AMT,NO_TAX_SALE_AMT"
		+ ",EXP_PAY_AMT,GST_PAY_AMT,RET_PAY_AMT,CASH_AMT,CRD_CARD_AMT,WES_AMT,TK_GFT_AMT,TK_FOD_AMT,CST_POINT_AMT,JCD_CARD_AMT,CST_SALE_POINT,DC_GEN_AMT,DC_SVC_AMT"
		+ ",DC_PCD_AMT,DC_CPN_AMT,DC_CST_AMT,DC_TFD_AMT,DC_PRM_AMT,DC_CRD_AMT,DC_PACK_AMT,PRE_PAY_CARD,PRE_PAY_CASH,REPAY_CASH_AMT,REPAY_TK_GFT_AMT,CASH_BILL_AMT"
		+ ",DLV_ORDER_FG,FD_TBL_CD,FD_GST_CNT_T,FD_GST_CNT_1,FD_GST_CNT_2,FD_GST_CNT_3,FD_GST_CNT_4,ORG_BILL_NO,CST_CARD_NO,CST_NM,CST_NO,ORDER_NO,INS_DT,EMP_NO"
		+ ",PAY_OUT_DT,CST_USE_POINT,CST_AVL_POINT,LOCAL_POINT_YN,CANCEL_REASON,ETC_APPR_AMT,KITCHEN_MEMO";

	this.TLGM_S_SL010_DATA_DT_ATTRS_02 = "DTL_NO,REGI_SEQ,SALE_YN,PROD_CD,PROD_TYPE_FG,CORNER_CD,CHG_BILL_NO,TAX_YN,DLV_PACK_FG,PROP_CD"        
		+ ",PROP_VAL,ORG_SALE_MG_CD,ORG_SALE_UPRC,NORMAL_UPRC,SALE_MG_CD,SALE_QTY,SALE_UPRC,SALE_AMT,SALE_WEIGHT,DC_AMT,ETC_AMT,SVC_TIP_AMT"
		+ ",DCM_SALE_AMT,VAT_AMT,SVC_CD,TK_CPN_CD,DC_AMT_GEN,DC_AMT_SVC,DC_AMT_JCD,DC_AMT_CPN,DC_AMT_CST,DC_AMT_FOD,DC_AMT_PRM,DC_AMT_CRD"
		+ ",DC_AMT_PACK,DC_AMT_LYT,CST_SALE_POINT,CST_USE_POINT,PRM_PROC_YN,PRM_CD,PRM_SEQ,SDA_CD,SDS_ORG_DTL_NO,INS_DT,EMP_NO,SET_PROD_FG";
	
	this.TLGM_S_SL010_DATA_DT_ATTRS_03 = "LINE_NO,SEQ_NO,REGI_SEQ,SALE_YN,VAN_CD,CORNER_CD,CASH_AMT,APPR_AMT,SVC_TIP_AMT,VAT_AMT,APPR_PROC_FG"
		+ ",APPR_IDT_TYPE,APPR_IDT_FG,CARD_IN_FG,APPR_IDT_NO,APPR_DATE,APPR_TIME,APPR_NO,APPR_MSG,VAN_TERM_NO,VAN_SLIP_NO,ORG_APPR_DATE"
		+ ",ORG_APPR_NO,APPR_LOG_NO,INS_DT,EMP_NO,EX_CD,EX_KRW,EX_EXP_AMT,EX_IN_AMT,EX_RET_AMT,KR_RET_AMT,EX_PAY_AMT,KR_PAY_AMT,KR_ETC_AMT"
		+ ",PRE_PAY_FG,NOTICE_MSG,BROAD_MSG,CNMK_CD,SEC_FLAG,VAT_SALE_AMT,NO_VAT_SALE_AMT";
	
	this.TLGM_S_SL010_DATA_DT_ATTRS_04 = "LINE_NO,SEQ_NO,REGI_SEQ,SALE_YN,VAN_CD,CORNER_CD,APPR_PROC_FG,CRD_CARD_NO,APPR_REQ_AMT,SVC_TIP_AMT"
		+ ",VAT_AMT,INST_MM_FG,INST_MM_CNT,VALID_TERM,SIGN_PAD_YN,CARD_IN_FG,APPR_DATE,APPR_TIME,APPR_NO,CRDCP_CD,ISS_CRDCP_CD,ISS_CRDCP_NM"
		+ ",PUR_CRDCP_CD,PUR_CRDCP_NM,APPR_AMT,APPR_DC_AMT,APPR_MSG,VAN_TERM_NO,VAN_SLIP_NO,CRDCP_TERM_NO,ORG_APPR_DATE,ORG_APPR_NO,APPR_LOG_NO"
		+ ",INS_DT,EMP_NO,PRE_PAY_FG,LYT_APPR_FG,LYT_APPR_INFO,GIFT_CASH,NOTICE_MSG,BROAD_MSG,CNMK_CD,UNION_PAY_FG,DDC_FLAG,SEC_FLAG,VAT_SALE_AMT,NO_VAT_SALE_AMT";
	
	this.TLGM_S_SL010_DATA_DT_ATTRS_05 = "LINE_NO,SEQ_NO,REGI_SEQ,SALE_YN,VAN_CD,CORNER_CD,APPR_PROC_FG,JCD_CD"
		+ ",JCD_TYPE_FG,JCD_PROC_FG,JCD_CARD_NO,JCD_CARD_PWD,APPR_AMT,VALID_TERM,SIGN_PAD_YN"
		+ ",CARD_IN_FG,APPR_DATE,APPR_TIME,APPR_NO,JCD_DC_AMT,JCD_OCC_POINT,JCD_AVL_POINT"		
		+ ",JCD_USE_POINT,JCD_REM_POINT,APPR_MSG,VAN_TERM_NO,VAN_SLIP_NO,CRDCP_TERM_NO,ORG_APPR_DATE"
		+ ",ORG_APPR_NO,APPR_LOG_NO,INS_DT,EMP_NO,BROAD_MSG,JCD_PAY_FG,CNMK_CD,TEST,SEC_FLAG";		
	this.TLGM_S_SL010_DATA_DT_ATTRS_06 = "LINE_NO,CST_NO,CST_CARD_NO,CST_CLS_CD,CST_USE_POINT,INS_DT"
		+ ",EMP_NO,CST_USE_AMT,CORNER_CD,SEQ_NO";
	
	this.TLGM_S_SL010_DATA_DT_ATTRS_07 = "LINE_NO,SEQ_NO,TR_TYPE_CD,REGI_SEQ,CORNER_CD,SALE_YN,APPR_DATE,APPR_TIME,APPR_AMT,SVC_TIP_AMT,VAT_AMT"
		+ ",PRE_BF_REM_AMT,PRE_AF_REM_AMT,APPR_NO,CARD_NO,APPR_PROC_FG,ORG_APPR_DATE,ORG_APPR_NO,USER_DATA,INS_DT";
	
	this.TLGM_S_SL010_DATA_DT_ATTRS_08 = "SHOP_CD,SALE_DATE,POS_NO,BILL_NO,PAY_SEQ_NO,REGI_SEQ,SALE_YN,PAY_TYPE_FG,PAY_AMT,LINE_NO,INS_DT,UPD_DT,EMP_NO";
	
	//POS 매출 송수신(판매일, 영수증번호)
	this.saleTransProcess = function(saleDate, billNo) {
		var aspTransResult = true;
		
		try {
			if ( saleDate === undefined || saleDate === null || saleDate.length === 0  ) {
				throw "영업일자가 입력되지 않았습니다.";
			}

			if ( billNo === undefined || billNo === null || billNo.length === 0  ) {
				throw "영수증번호가 입력되지 않았습니다.";
			}
			
			billNo = billNo;

			var sqlParameter = [ gShopCd, saleDate, gPosNo, billNo ]; //매장번호, 영업일자, POS번호, 영수증번호
			util.logInfo("### AspSaleTransDataService sqlParameter >>> " + sqlParameter);
			var resultTrhdrData = gfn_SQLiteSQLProcess(sqlQuery.sqlSelectSslTrhdrT , sqlParameter );
			util.logInfo("### AspSaleTransDataService resultTrhdrData >>> " + JSON.stringify(resultTrhdrData));
			var resultTrdtlData = gfn_SQLiteSQLProcess(sqlQuery.sqlSelectSslTrdtlT , sqlParameter );
			util.logInfo("### AspSaleTransDataService resultTrdtlData >>> " + JSON.stringify(resultTrdtlData));
			var resultTrcshData = gfn_SQLiteSQLProcess(sqlQuery.sqlSelectSslTrcshT , sqlParameter );
			util.logInfo("### AspSaleTransDataService resultTrcshData >>> " + JSON.stringify(resultTrcshData));
			var resultTrcrdData = gfn_SQLiteSQLProcess(sqlQuery.sqlSelectSslTrcrdT , sqlParameter );
			util.logInfo("### AspSaleTransDataService resultTrcrdData >>> " + JSON.stringify(resultTrcrdData));
			var resultTrjcdData = gfn_SQLiteSQLProcess(sqlQuery.sqlSelectSslTrjcdT , sqlParameter );
			util.logInfo("### AspSaleTransDataService resultTrjcdData >>> " + JSON.stringify(resultTrjcdData));
			var resultTrcstData = gfn_SQLiteSQLProcess(sqlQuery.sqlSelectSslTrcstT , sqlParameter );
			util.logInfo("### AspSaleTransDataService resultTrcstData >>> " + JSON.stringify(resultTrcstData));
			var resultTretcData = gfn_SQLiteSQLProcess(sqlQuery.sqlSelectSslTretcT , sqlParameter );
			util.logInfo("### AspSaleTransDataService resultTretcData >>> " + JSON.stringify(resultTretcData));
			var resultTrpsqData = gfn_SQLiteSQLProcess(sqlQuery.sqlSelectSslTrpsqT , sqlParameter );
			util.logInfo("### AspSaleTransDataService resultTrpsqData >>> " + JSON.stringify(resultTrpsqData));

			// 푸드테크 개발로 인해 사이드메뉴의 속성만 따로 담아 TRSOC에 담아 보낸다.
			var resultTrsocData = gfn_SQLiteSQLProcess(sqlQuery.sqlSelectSslTrsocT , sqlParameter );
			util.logInfo("### AspSaleTransDataService resultTrsocData >>> " + JSON.stringify(resultTrsocData));
			
			if ( resultTrhdrData === undefined || resultTrhdrData === null || resultTrhdrData.length === 0  || resultTrhdrData.Data === undefined || resultTrhdrData.Data ===null || resultTrhdrData.Data.length === 0) {
				util.logInfo("조회된 매출 정보가 없습니다.");
				return;
			}
			
			var row = resultTrhdrData.Data[0] ;
			var trdtlRow = resultTrdtlData.Data ;
			var trcshRow = resultTrcshData.Data ;
			var trcrdRow = resultTrcrdData.Data ;
			var trjcdRow = resultTrjcdData.Data ;
			var trcstRow = resultTrcstData.Data ;
			var tretcRow = resultTretcData.Data ;
			//톨게이트 적립 바코드가 있는경우 기타결제부분은 ASP로 전송 X -> ASP에서 결제취소 안되는 이슈, 키오스크에선 취소 O
//			if(!util.isEmpty(orderInfo.tgStampBarcode)) {
//				util.logInfo("### AspSaleTransDataService orderInfo.tgStampBarcode >>> " + orderInfo.tgStampBarcode);
//				tretcRow = null;
//			} else {
//				util.logInfo("### AspSaleTransDataService orderInfo.tgStampBarcode XXXXXXXXXX");
//				tretcRow = resultTretcData.Data ;
//			}
			var trpsqRow = resultTrpsqData.Data ;
			var trsocRow = resultTrsocData.Data ;
			
			
//			util.logInfo(row);
//			util.logInfo(trdtlRow);
//			util.logInfo(trcshRow);
//			util.logInfo(trcrdRow);
//			util.logInfo(trjcdRow);
//			util.logInfo(tretcRow);
//			util.logInfo(trpsqRow);

			if (row === undefined || row === null ) { 
				return;
			}
			
			if (trdtlRow === undefined || trdtlRow === null ) {
				return;
			}
			
			var trcshRowLength, trcrdRowLength, trjcdRowLength, trcstRowLength, tretcRowLength, trsocRowLength;
			if(trcshRow === null || trcshRow === undefined) trcshRowLength = 0;
			else trcshRowLength = trcshRow.length;
			
			if(trcrdRow === null || trcrdRow === undefined) trcrdRowLength = 0;
			else trcrdRowLength = trcrdRow.length;
				
			if(trjcdRow === null || trjcdRow === undefined) trjcdRowLength = 0;
			else trjcdRowLength = trjcdRow.length;
			
			if(trcstRow === null || trcstRow === undefined) trcstRowLength = 0;
			else trcstRowLength = trcstRow.length;
			
			if(tretcRow === null || tretcRow === undefined) tretcRowLength = 0;
			else tretcRowLength = tretcRow.length;
			
			//모바일쿠폰 결제 및 적립데이터 카운트, 모바일쿠폰 결제 및 적렙 데이터는 제외하고 ASP에 전송한다
//			var tretcMobileLength = 0;
			
//			for( var i=0; i < tretcRowLength; i++ ) {
//				if(tretcRow[i].TR_TYPE_CD == "001" || tretcRow[i].TR_TYPE_CD == "002" || tretcRow[i].TR_TYPE_CD == "003") { //모바일 스탬프 적립을 제외한 기타결제 데이터 갯수만큼 etc 길이제거
//					tretcMobileLength++;
//				}
//			}
			
			
			//모바일쿠폰 결제 및 적립데이터 카운트, 모바일쿠폰 결제 및 적렙 데이터는 제외하고 ASP에 전송한다 
			if(tretcRow !== undefined || tretcRow !== null) { //기타결제 정보중 스탬프 적립이 있는경우 length - 1
				if(tretcRowLength > 0) {
					for( var i=0; i < tretcRow.length; i++ ) {
						if(tretcRow[i].TR_TYPE_CD == "003") { 
							tretcRowLength = tretcRowLength - 1;
						}
					}
				}
			}
			
			util.logInfo("### tretcRowLength >>> " + tretcRowLength);
			
			
			if(trpsqRow === null || trpsqRow === undefined) trpsqRowLength = 0;
			else trpsqRowLength = trpsqRow.length;
			
			if(trsocRow === null || trsocRow === undefined) trsocRowLength = 0;
			else trsocRowLength = trsocRow.length;
			
			//먹고가기, 포장하기 ASP전문전송 추가
			if(orderInfo.POS_ODHDR_T !== undefined && orderInfo.POS_ODHDR_T.KITCHEN_MEMO !== undefined) {
				util.logInfo("### orderInfo.POS_ODHDR_T.KITCHEN_MEMO >>> " + orderInfo.POS_ODHDR_T.KITCHEN_MEMO);
				if(orderInfo.POS_ODHDR_T.KITCHEN_MEMO == "meal"){
					row.KITCHEN_MEMO = "먹고가기";
				}else if (orderInfo.POS_ODHDR_T.KITCHEN_MEMO == "takeout"){
					row.KITCHEN_MEMO = "포장하기";
				}else if (orderInfo.POS_ODHDR_T.KITCHEN_MEMO == "start"){
					row.KITCHEN_MEMO = "시작하기";
				}else if (orderInfo.POS_ODHDR_T.KITCHEN_MEMO == "calculate"){
					row.KITCHEN_MEMO = "계산하기";
				}else if (orderInfo.POS_ODHDR_T.KITCHEN_MEMO == "doOrder"){
					row.KITCHEN_MEMO = "주문하기";
				}else if (orderInfo.POS_ODHDR_T.KITCHEN_MEMO == "nOrder"){
					row.KITCHEN_MEMO = "일반주문";
				}else if (orderInfo.POS_ODHDR_T.KITCHEN_MEMO == "mOrder"){
					row.KITCHEN_MEMO = "회원주문";
				}else{
					row.KITCHEN_MEMO = orderInfo.POS_ODHDR_T.KITCHEN_MEMO;
				}
			} else {
				row.KITCHEN_MEMO = "";
			}
			/******** 송신 전문 속성 생성.***********/
			var trhdrAttrStr = this.makeCell2TlgmAttribute(row , this.TLGM_S_SL010_DATA_DT_ATTRS_01 );
			
			util.logInfo("### trhdrAttrStr >>> "+ trhdrAttrStr);
			var dataBody = "";
			dataBody += "\n<TSP-NVP>\n";
			dataBody += "	<TXJM-FD SRID='SL010' RETCD='0000' KIOSK_REQ_YN='Y' TRHDR_CNT='1' TRDTL_CNT='" + trdtlRow.length + "' TRCSH_CNT='" + trcshRowLength + "' "
			dataBody += "		TRCRD_CNT='" + trcrdRowLength + "' TRCST_CNT='" + trcstRowLength + "' TRGFA_CNT='0' TRGFT_CNT='0' TRJCD_CNT='" + trjcdRowLength + "' TRGST_CNT='0' TRCSA_CNT='0' TRSOC_CNT='" + trsocRowLength + "' "
			dataBody += "		TRWES_CNT='0' TRFOA_CNT='0' TRFOD_CNT='0' TRETC_CNT='" + tretcRowLength + "' TRPSQ_CNT='" + trpsqRowLength + "' />";//고정
			dataBody += "		<TRHDR SHOP_CD='" + gShopCd +"' SALE_DATE='" + row.SALE_DATE + "' POS_NO='" + gPosNo + "' BILL_NO ='"+ row.BILL_NO + "'"; //SHOP_CD(매장코드) ,SALE_DATE(영업일자) ,POS_NO(포스번호), BILL_NO(영수증번호)
			dataBody += "          " + trhdrAttrStr ;
			dataBody += "			 />";
			
			if(trdtlRow.length > 0) {
				dataBody += "<TRDTL>";
				for( var i=0; i < trdtlRow.length; i++ ) {
					var trdtlAttrStr = this.makeCell2TlgmAttribute(trdtlRow[i] , this.TLGM_S_SL010_DATA_DT_ATTRS_02 );
					util.logInfo("### trdtlAttrStr >>> "+ trdtlAttrStr);
					dataBody += "	<DATA-DTL ";
					dataBody += "   	" + trdtlAttrStr;
					dataBody += "	/>";
				}
				dataBody += "</TRDTL>";
			}
			
			if(trcshRow !== undefined || trcshRow !== null) {
				if(trcshRowLength > 0) {
					dataBody += "<TRCSH>";
					for( var i=0; i < trcshRowLength; i++ ) {
						var trcshAttrStr = this.makeCell2TlgmAttribute(trcshRow[i] , this.TLGM_S_SL010_DATA_DT_ATTRS_03 );
						util.logInfo("### trcshAttrStr >>> "+ trcshAttrStr);
						dataBody += "	<DATA-CSH ";
						dataBody += "   	" + trcshAttrStr;
						dataBody += "	/>";
					}
					dataBody += "</TRCSH>";
				}
			}
			
			if(trcrdRow !== undefined || trcrdRow !== null) {
				if(trcrdRowLength > 0) {
					dataBody += "<TRCRD>";
					for( var i=0; i < trcrdRowLength; i++ ) {
						util.logInfo("### trcrdRow["+i+"].CRD_CARD_NO.getByteLength() >>> "+ trcrdRow[i].CRD_CARD_NO.getByteLength());
						
						if(trcrdRow[i].CRD_CARD_NO.getByteLength() > 20){
							//20byte이상일때 20byte로 자르기
							trcrdRow[i].CRD_CARD_NO = trcrdRow[i].CRD_CARD_NO.cutStr(20);
						}
						
						var trcrdAttrStr = this.makeCell2TlgmAttribute(trcrdRow[i] , this.TLGM_S_SL010_DATA_DT_ATTRS_04 );
						util.logInfo("### trcrdAttrStr >>> "+ trcrdAttrStr);
						dataBody += "	<DATA-CRD ";
						dataBody += "   	" + trcrdAttrStr;
						dataBody += "	/>";
					}
					dataBody += "</TRCRD>";
				}
			}
			
			if(trjcdRow !== undefined || trjcdRow !== null) {
				util.logInfo("*****saleTransProcess trjcdRow databody Start*****");
				if(trjcdRowLength > 0) {
					dataBody += "<TRJCD>";
					for( var i=0; i < trjcdRowLength; i++ ) {
						var trjcdAttrStr = this.makeCell2TlgmAttribute(trjcdRow[i] , this.TLGM_S_SL010_DATA_DT_ATTRS_05 );
						util.logInfo("### trjcdAttrStr >>> "+ trjcdAttrStr);
						dataBody += "	<DATA-JCD ";
						dataBody += "   	" + trjcdAttrStr;
						dataBody += "	/>";
					}
					dataBody += "</TRJCD>";
				}
			}
			
			if(trcstRow !== undefined || trcstRow !== null) {
				if(trcstRowLength > 0) {
					dataBody += "<TRCST>";
					for( var i=0; i < trcstRowLength; i++ ) {
						var trcstAttrStr = this.makeCell2TlgmAttribute(trcstRow[i] , this.TLGM_S_SL010_DATA_DT_ATTRS_06 );
						util.logInfo("### trcstAttrStr >>> "+ trcstAttrStr);
						dataBody += "	<DATA-CST ";
						dataBody += "   	" + trcstAttrStr;
						dataBody += "	/>";
					}
					dataBody += "</TRCST>";
				}
			}
			
			if(tretcRow !== undefined || tretcRow !== null) {
				if(tretcRowLength > 0) {
					dataBody += "<TRETC>";
					for( var i=0; i < tretcRow.length; i++ ) {
						if(tretcRow[i].TR_TYPE_CD != "003") { //모바일 스탬프 적립을 제외한 기타결제 데이터를 전송해준다
							// asp에 card_no가 20바이트까지라서 잘라서 전송한다.
							if(tretcRow[i].CARD_NO != null && tretcRow[i].CARD_NO != "") {
								if(tretcRow[i].CARD_NO.getByteLength() > 20){
									//20byte이상일때 20byte로 자르기
									tretcRow[i].CARD_NO = tretcRow[i].CARD_NO.cutStr(20);
								}
							}
							
							var tretcAttrStr = this.makeCell2TlgmAttribute(tretcRow[i] , this.TLGM_S_SL010_DATA_DT_ATTRS_07 );
							util.logInfo("### tretcAttrStr >>> "+ tretcAttrStr);
							dataBody += "	<DATA-ETC ";
							dataBody += "   	" + tretcAttrStr;
							dataBody += "	/>";
						}
					}
					dataBody += "</TRETC>";
				}
			}
			
			if(trpsqRow !== undefined || trpsqRow !== null) {
				if(trpsqRowLength > 0) {
					dataBody += "<TRPSQ>";
					for( var i=0; i < trpsqRowLength; i++ ) {
						var trpsqAttrStr = this.makeCell2TlgmAttribute(trpsqRow[i] , this.TLGM_S_SL010_DATA_DT_ATTRS_08 );
						util.logInfo("### trpsqAttrStr >>> "+ trpsqAttrStr);
						dataBody += "	<DATA-PSQ ";
						dataBody += "   	" + trpsqAttrStr;
						dataBody += "	/>";
					}
					dataBody += "</TRPSQ>";
				}
			}
			// 푸드테크 개발건으로 인해 사이드 데이터 중 속성만 추출하여 trsoc에 담아 전문전송 처리
			if(trsocRow !== undefined || trsocRow !== null) {
				if(trsocRowLength > 0) {
					dataBody += "<TRSOC>";
					for( var i=0; i < trsocRowLength; i++ ) {
						var trsocAttrStr = this.makeCell2TlgmAttribute(trsocRow[i] , this.TLGM_S_SL010_DATA_DT_ATTRS_02 ); // tr_dtl 테이블과 같은 컬럼으로 보내기 때문에 dtl에서 사용한 헤더값 셋팅.
						util.logInfo("### trsocAttrStr >>> "+ trsocAttrStr);
						dataBody += "	<DATA-SOC ";
						dataBody += "   	" + trsocAttrStr;
						dataBody += "	/>";
					}
					dataBody += "</TRSOC>";
				}
			}
			
			dataBody += "</TSP-NVP>\n";
			dataBody += "";
			
			util.logInfo('### 매출 송수신 dataBody : ' + dataBody);
			var svc_urls = "/SvrApp/SL000.do";
			var params = XML_PI + dataBody ;
			util.logInfo('### 매출 송수신 params : ' + params);
			
			//asp전송전 파일 만들기
			var resultFileName = this.makeSaleTransDataFile(params, billNo);
			util.logInfo('### resultFileName  : ' + resultFileName );
			
			//정산마감 및 개점처리가 성공 상태
			if(gSettleDataAspFlag == true){
				telegram.tlgmCall( params, svc_urls, true, this.updateSaleDataCallBack, 10000);
			} else{
				//정산마감 및 개점처리가 실패했을때 ASP에 매출전송은 데몬에서 파일로 처리#
				util.logInfo('### saleTransProcess 정산마감 및 개점처리가 실패했을때 ASP에 매출전송은 데몬에서 파일로 처리###' );
			}

		} catch (e) {
			util.logError("***** saleTransProcess Catch e == > " + JSON.stringify(e));
			util.logError("***** saleTransProcess Catch e == > " + e.toString());
			aspTransResult = false;
			//throw e;
		}
		util.logInfo('### aspTransResult  : ' + aspTransResult );
		return aspTransResult;
	}
	
	this.makeCell2TlgmAttribute = function ( row , dtAttrs ) {
		if ( row === undefined || row === null || row.length === 0  ) {
			return;
		}

		if ( dtAttrs === undefined || dtAttrs === null || dtAttrs.length === 0  ) {
			return;
		}

		util.logInfo("전문에 사용할 row(DB)  : " + JSON.stringify(row));
		var arrs = dtAttrs.split(",");
		var strData = "";
		for ( var i = 0 ; i < arrs.length ; i++ ) {
			var attrKey = arrs[i];
			var attrVal = row[attrKey];
			if ( attrVal === undefined ) {
				throw "[" +attrKey + "] 항목이 없습니다." ;
			}

			if ( attrVal === null ) {
				attrVal = "";
			}

			strData += "   " + attrKey +"='" + attrVal + "' ";

		}

		return strData;
	},
	
	this.makeSaleTransDataFile = function(xmlParams, billNo) {
		var dirPath		= saleFilePath;   
		var newFile;
		var localDate = moment().format("YYYYMMDDHHmmss");
		
		fileName = billNo + "_" + localDate+".sd";
		
		if( util.isTizen() == true) {
			tizen.filesystem.resolve(dirPath, function(result) {
				util.logInfo("################### makeSaleTransDataFile newFile Start #################");
				util.logInfo("### makeSaleTransDataFile text data >> " + xmlParams);
				util.logInfo("### makeSaleTransDataFile fileName >> " + fileName);
				newFile = result.createFile(fileName);
				newFile.openStream(
						"rw",
						function(fs) {
							fs.write(xmlParams);
							fs.close();
						}, function(e) {
							util.logError("Error " + e.message);
						}, "UTF-8");
				util.logInfo("################### makeSaleTransDataFile newFile End #################");
				
			}, function(e) {
				util.logError("### makeSaleTransDataFile resolve Error" + e.message);
			}, "rw" );
		}
		return fileName;
	},
	
	this.updateSaleDataCallBack = function(resultXMLData, param, aspSendParam) {
		util.logInfo("##### updateSaleDataCallBack resultXMLData >> " + resultXMLData);
		util.logInfo("##### updateSaleDataCallBack param >> " + param);
		//if(resultXMLData == "error" && param == "timeout") {
		if(resultXMLData == "error") {
			var svc_urls = "/SvrApp/SL000.do";
			util.logInfo('### asp timeout 매출 재송수신 aspSendParam : ' + aspSendParam);
			//asp전송전 파일 만들기
			util.logInfo('### asp timeout 매출 재송수신 reSendAspDataCnt : ' + reSendAspDataCnt);
			
			//ASP전송 3번시도
			if(reSendAspDataCnt == 3){
				reSendAspDataCnt = 0;
				return;
			} else {
				reSendAspDataCnt++;
				telegram.tlgmCall( aspSendParam, svc_urls, true, aspSaleTransDataService.updateSaleDataCallBack, 10000);
				return;
			}
		}
		
		var retcd = $(resultXMLData).find("TXJM-FD").attr("RETCD");
		var sendBillNo = $(resultXMLData).find("TXJM-FD").find("DATA-HD").attr("BILL_NO");
		
		util.logInfo('### 매출 송수신 resultXMLData RETCD : ' + retcd);
		util.logInfo('### 매출 송수신 resultXMLData BILL_NO : ' + sendBillNo);
		
		if(retcd == "0000") {
    		try {
    			gfn_DbOpen();
    			gfn_DbBegin();//Transaction
    			//SEND_FG, SEND_DT 업데이트
    			var updateResult  = gfn_DbExecute(sqlQuery.updateSslTrhdrSendStatus, ["1", gShopCd, saleDate, gPosNo, sendBillNo]).Data;
    			util.logDebug("### updateResult >> " + updateResult);
    			
    			gfn_DbCommit();
    			gfn_DbClose();
			} catch (e) {
				// TODO: handle exception
				gfn_DbRollBack();
				gfn_DbClose();
				util.logError("### updateResult error >> " + e);
			}
			
			util.logInfo("###################  delSaleTransDataFile start  #################");
			//정산내역 asp전송에 성공한 영업일의 매출전송데이터를 삭제해준다.
	    	if(gSettleDataAspFlag == true){
	    		//asp서버전송 정상일경우 asp전송데이터 파일 삭제
				var dirPath	 = saleFilePath;   
				var fullPath = dirPath + "/" + fileName;
				
				util.logInfo("##### Delete fileName >> " + fileName);
				if( util.isTizen() == true) {
					tizen.filesystem.resolve(dirPath, function(result) {
						
						result.deleteFile(fullPath, function() {
							util.logInfo("#### delSaleTransDataFile Old File Deleted Succese ####");
						}, function(e) {
							util.logError("#### delSaleTransDataFile Old File Deleted Error " + e.message);
						});
					});
					
				}
	    	} else{
	    		util.logInfo("################### 매출정보 ASP 전송 보류(마감 및 개점처리시 ASP서버 문제 발생 - 데몬에서 처리) ###################");
	    	}
	    	util.logInfo("###################  delSaleTransDataFile End  #################");
    	}
	},
	
	this.delSaleTransDataFile = function(fileName) {
		var dirPath	 = saleFilePath;   
		var fullPath = dirPath + "/" + fileName;
		
		util.logInfo("###################  delSaleTransDataFile start  #################");
		
		util.logInfo("##### Delete fileName >> " + fileName);
		if( util.isTizen() == true) {
			tizen.filesystem.resolve(dirPath, function(result) {
				
				result.deleteFile(fullPath, function() {
					util.logInfo("#### delSaleTransDataFile Old File Deleted Succese ####");
				}, function(e) {
					util.logError("#### delSaleTransDataFile Old File Deleted Error " + e.message);
				});
			});
			
			util.logInfo("###################  delSaleTransDataFile End  #################");
		}
	}
	

}
