
var AspEtcDataReceiveService = function() {

	/*****************************************************
	 * POS_REGIS_T :
	 * 1. 포스수신-일마감정산내역
	 *  - 포스 수신 마감은 미전송과 오류를 재송신한다.
	 *  - 미전송 데이터 조회
	 *  -
	 *****************************************************/
	this.T_POS_REGIS_T_S01 = " SELECT * FROM POS_REGIS_T WHERE SHOP_CD = ? AND SALE_DATE = ?  AND POS_NO = ? AND REGI_SEQ = ?  AND SEND_FG IN ( ? )   "; // 전송을 위한 데이터 조회.
	this.T_POS_REGIS_T_U01 = "  UPDATE POS_REGIS_T SET SEND_FG = ? [SEND_DT] WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND REGI_SEQ = ?  " ;
	this.TLGM_S_PS010_DATA_DT_ATTRS = "EMP_NO,CLOSE_FG,OPEN_DT,CLOSE_DT,TOT_BILL_CNT,TOT_SALE_AMT,TOT_DC_AMT,SVC_TIP_AMT,TOT_ETC_AMT,DCM_SALE_AMT,VAT_SALE_AMT,VAT_AMT,NO_VAT_SALE_AMT,NO_TAX_SALE_AMT,RET_BILL_CNT,RET_BILL_AMT,VISIT_CST_CNT,POS_READY_AMT,POS_CSH_IN_AMT,POS_CSH_OUT_AMT,WEA_IN_CSH_AMT,WEA_IN_CRD_AMT,TK_GFT_SALE_CSH_AMT,TK_GFT_SALE_CRD_AMT,TK_FOD_SALE_CSH_AMT,TK_FOD_SALE_CRD_AMT,CASH_CNT,CASH_AMT,CASH_BILL_CNT,CASH_BILL_AMT,CRD_CARD_CNT,CRD_CARD_AMT,WES_CNT,WES_AMT,TK_GFT_CNT,TK_GFT_AMT,TK_FOD_CNT,TK_FOD_AMT,CST_POINT_CNT,CST_POINT_AMT,JCD_CARD_CNT,JCD_CARD_AMT,DC_GEN_CNT,DC_GEN_AMT,DC_SVC_CNT,DC_SVC_AMT,DC_JCD_CNT,DC_JCD_AMT,DC_CPN_CNT,DC_CPN_AMT,DC_CST_CNT,DC_CST_AMT,DC_TFD_CNT,DC_TFD_AMT,DC_PRM_CNT,DC_PRM_AMT,DC_CRD_CNT,DC_CRD_AMT,DC_PACK_CNT,DC_PACK_AMT,REM_CHECK_CNT,REM_CHECK_AMT,REM_W100000_CNT,REM_W50000_CNT,REM_W10000_CNT,REM_W5000_CNT,REM_W1000_CNT,REM_W500_CNT,REM_W100_CNT,REM_W50_CNT,REM_W10_CNT,REM_CASH_AMT,REM_TK_GFT_CNT,REM_TK_GFT_AMT,REM_TK_FOD_CNT,REM_TK_FOD_AMT,ETC_TK_FOD_AMT,LOSS_CASH_AMT,LOSS_TK_GFT_AMT,LOSS_TK_FOD_AMT,REPAY_CASH_CNT,REPAY_CASH_AMT,REPAY_TK_GFT_CNT,REPAY_TK_GFT_AMT,INS_DT";

	/********************************************************************************
	 * 전문송신 오류시 Demon 에서 처리하도록 하기 위한 SQL
	 ********************************************************************************/
	this.T_POS_RESEND_T_I01 = ""
		+ "\n INSERT INTO POS_RESEND_T                                        ".rtrim()
		+ "\n (                                                               ".rtrim()
		+ "\n   SHOP_CD                                                       ".rtrim()
		+ "\n , REG_DATE                                                      ".rtrim()
		+ "\n , POS_NO                                                        ".rtrim()
		+ "\n , SEQ_NO                                                        ".rtrim()
		+ "\n , TARGET_URL                                                    ".rtrim()
		+ "\n , SEND_CONTEXT                                                  ".rtrim()
		+ "\n , SUCCESS_SQL                                                   ".rtrim()
		+ "\n , SEND_FG                                                       ".rtrim()
		+ "\n , INS_DT                                                        ".rtrim()
		+ "\n , UPD_DT                                                        ".rtrim()
		+ "\n , RETRY_CNT                                                     ".rtrim()
		+ "\n )                                                               ".rtrim()
		+ "\n VALUES(                                                         ".rtrim()
		+ "\n    ?                                        /** SHOP_CD    **/  ".rtrim()
		+ "\n  , strftime('%Y%m%d', 'NOW' , 'LOCALTIME') /** REG_DATE    **/  ".rtrim()
		+ "\n  , ?                                        /** POS NO     **/  ".rtrim()
		+ "\n  , (                                                            ".rtrim()
		+ "\n 	 SELECT                                                       ".rtrim()
		+ "\n 	   (IFNULL(MAX(SEQ_NO) , 0) +1 )                              ".rtrim()
		+ "\n 	  FROM POS_RESEND_T                                           ".rtrim()
		+ "\n 	  WHERE SHOP_CD  = ?                                          ".rtrim()
		+ "\n 	    AND REG_DATE = strftime('%Y%m%d', 'NOW' , 'LOCALTIME')    ".rtrim()
		+ "\n 		AND POS_NO   = ?                                          ".rtrim()
		+ "\n  )                                                              ".rtrim()
		+ "\n  , ?                                      /** TARGET_URL    **/ ".rtrim()
		+ "\n  , ?                                      /** SEND_CONTEXT  **/ ".rtrim()
		+ "\n  , ?                                      /** SUCCESS_SQL   **/ ".rtrim()
		+ "\n  , 0      /** 미전송 **/                  /** SEND_FG       **/ ".rtrim()
		+ "\n  , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME')                ".rtrim()
		+ "\n  , strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME')                ".rtrim()
		+ "\n  , 0                                                            ".rtrim()
		+ "\n )                                                               ".rtrim()
		;
		//shop_cd , pos_no , shop_cd, pos_no , target_url, xml_data, success_sql

	/**********************************************************
	 * 전문 재전송을 위해서 등록하는 메소드.
	 *  @parameter target_url 전문 재전송할 URL
	 *  @parameter tlgm_send_xml 재전송할 전문 원본
	 *  @parameter success_sql 전문 재전송이 정상적으로 처리되었을때 이후 처리되는 SQL
	 **********************************************************/
	this.resendInsertPorcess = function ( target_url, tlgm_send_xml, success_sql ) {
		gfn_validate_NotEmpty(target_url    , "URL 이 입력되지 않았습니다.");
		gfn_validate_NotEmpty(tlgm_send_xml , "송신 전문이 입력되지 않았습니다.");
		gfn_validate_NotEmpty(success_sql   , "Success SQL 이 입력되지 않았습니다.");

		var sqlParam = [gShopCd , gPosNo, gShopCd , gPosNo ,target_url , tlgm_send_xml , success_sql ];

		var resendSQL = gfn_sqlBindParameters(this.T_POS_RESEND_T_I01 , sqlParam );
		var resultData = gfn_SQLiteSQLProcess( resendSQL , [] ) ;
		util.logInfo(resultData);

	}

	this.settleProcess= function(saleDate, regiSeq, sendFg) {
		try {

		    util.logInfo("    개점 / 정산 ASP 전송요청    ");
			if ( saleDate === undefined || saleDate === null || saleDate.length === 0  ) {
				throw "영업일자가 입력되지 않았습니다.";
			}

			if ( regiSeq === undefined || regiSeq === null || regiSeq.length === 0  ) {
				throw "정산차수가 입력되지 않았습니다.";
			}
			if(util.isEmptyStr(sendFg)){
			    sendFg =0;
			}

			var sqlParameter = [ gShopCd ,saleDate ,  gPosNo , regiSeq , sendFg];//매장번호, 영업일자, POS번호, 정산차수
			var resultData = gfn_SQLiteSQLProcess(this.T_POS_REGIS_T_S01 , sqlParameter );

			util.logInfo('list' ,resultData );

			if ( resultData === undefined || resultData === null || resultData.length === 0  || resultData.Data === undefined || resultData.Data ===null || resultData.Data.length === 0) {
				//XXX 뭔가 응답을 주어야 하는가?
				return;
			}

			var row = resultData.Data[0] ;//XXX 향후 네이티브에서는 어떻게 처리해야 하는지?

			util.logInfo(row);


			if (row === undefined || row === null ) {
				//TODO 알람 띄워야 하는가?(작업이 끝났다거나.....
				return;
			}

			/******** 송신 전문 속성 생성.***********/
			var attrStr = this.makeCell2TlgmAttribute(row , this.TLGM_S_PS010_DATA_DT_ATTRS );

			var indexNo = gShopCd + row.SALE_DATE+ gPosNo+ row.REGI_SEQ ; //전문 INDEX 는 SHOP_CD+SALE_DATE+POS_NO+REGI_SEQ 로 설정.

			util.logInfo('INDEX_NO' , indexNo );
			var dataBody = "";
			dataBody += "\n<TSP-NVP>\n";
			dataBody += "	<TXJM-FD SRID='PS010' RETCD='0000' KIOSK_REQ_YN='Y' >";//고정
			dataBody += "		<DATA-HD SHOP_CD='" + gShopCd +"' SALE_DATE='" + row.SALE_DATE + "' POS_NO='" + gPosNo + "' REGI_SEQ='"+ row.REGI_SEQ +"' INDEX_NO=' " + indexNo + " ' DT_CNT='1'  >"; //SHOP_CD(매장코드) ,SALE_DATE(영업일자) ,POS_NO(포스번호) ,REGI_SEQ(정산차수) ,INDEX_NO(전문INDEX) ,DT_CNT(DETAIL개수)
			dataBody += "			<DATA-DT ";
			dataBody += "          " + attrStr ;
			dataBody += "			 />";
			dataBody += "		</DATA-HD>";
			dataBody += "	</TXJM-FD>";
			dataBody += "</TSP-NVP>\n";
			dataBody += "";

			var svc_urls = "/SvrApp/PS000.do";

			var params = XML_PI + dataBody ;
			var resultXMLData = telegram.tlgmCall(params,  svc_urls  );
			
			util.logInfo("tlgm result : " + resultXMLData);
			
			//var settleDataFileName;
			var localDate = moment().format("YYYYMMDDHHmmssSS");
//			window.setTimeout(() =>  {
//				settleDataFileName = this.makeSettleDataFile(params, saleDate, localDate);
//			}, 500);
			
			//개점 및 마감전송 xml 파일 만들기
			this.makeSettleDataFile(params, saleDate, localDate)
			//gSettleDataFileName.push(this.makeSettleDataFile(params, saleDate, localDate));
			
			util.logInfo("gSettleDataFileName : " + gSettleDataFileName);

			if(resultXMLData == 'NetworkError') {
				//alert("네트워크 상태를 확인해주세요.");
				gSettleDataAspFlag = false;
				//throw "네트워크 상태를 확인해주세요.";
				util.logInfo('네트워크 상태를 확인해주세요. - 통신 오류');
				
				localStorage.setItem('settle_data_asp_flag'  , 'F');
			} else {
				var retcd = $(resultXMLData).find("TXJM-FD").attr("RETCD");
				
				var successSQL = this.T_POS_REGIS_T_U01.replace("[SEND_DT]" , "\n     , SEND_DT        = strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME')   /* 서버전송일시  */");
				successSQL =  gfn_sqlBindParameters(  successSQL    ,  [ "1" /** 1 전송완료 **/ , gShopCd, row.SALE_DATE , gPosNo , row.REGI_SEQ ]  );
				
				util.logInfo("settleProcess  retcd : " + retcd);
				
				if ( retcd !== '0000'  ) {
					
					//XXX 실패시 재전송 전문 테이블 저장 처리. 2020.07.06
					var failSQL = this.T_POS_REGIS_T_U01.replace("[SEND_DT]" , "\n     , SEND_DT        = ''  /* 서버전송일시  */ " );
					sqlParameter = [  '2'    , gShopCd , row.SALE_DATE , gPosNo , row.REGI_SEQ  ] ;
					resultData = gfn_SQLiteSQLProcess(failSQL , sqlParameter);
					
					this.resendInsertPorcess ( svc_urls, params, successSQL ) ;
				} else {
					resultData = gfn_SQLiteSQLProcess(successSQL   , [] );
					util.logInfo('전문 전송 성공.');
					util.logInfo("    개점 / 정산 ASP 전송응답    ");
					
					localStorage.setItem('settle_data_asp_flag'  , 'S');
					gSettleDataAspFlag = true;
				}
				
				util.logInfo('resultData T_POS_REGIS_T_U01 -  '  , resultData);
			}
			
		} catch (e) {
			throw e;
		}
	}

	//정산내역 파일 만들기
	this.makeSettleDataFile = function(xmlParams, saleDate, localDate) {
		var dirPath		= saleFilePath;   
		var newFile;
		//var localDate = moment().format("YYYYMMDDHHmmss");
		
		var fileName = saleDate + "_" + localDate+".st";
		
		if( util.isTizen() == true) {
			tizen.filesystem.resolve(dirPath, function(result) {
				util.logInfo("################### makeSettleDataFile newFile Start #################");
				util.logInfo("### makeSettleDataFile text data >> " + xmlParams);
				util.logInfo("### makeSettleDataFile fileName >> " + fileName);
				newFile = result.createFile(fileName);
				newFile.openStream(
						"rw",
						function(fs) {
							fs.write(xmlParams);
							fs.close();
						}, function(e) {
							util.logError("Error " + e.message);
						}, "UTF-8");
				util.logInfo("################### makeSettleDataFile newFile End #################");
				
			}, function(e) {
				util.logError("### makeSettleDataFile resolve Error : " + e.message);
			}, "rw" );
		}
		return fileName;
	}
	
	//정산내역 파일 지우기
	this.delSettleDataFile = function(fileNameList) {
		var dirPath	 = saleFilePath;   
		util.logInfo("##### Delete fileNameList >> " + fileNameList);
		
		if( util.isTizen() == true) {
			for(var i=0; i < fileNameList.length; i++){
				var fullPath = dirPath + "/" + fileNameList[i];
				util.logInfo("###################  delSettleDataFile start  #################");
				util.logInfo("##### Delete fileName >> " + fileNameList[i]);
				tizen.filesystem.resolve(dirPath, function(result) {
					
					result.deleteFile(fullPath, function() {
						util.logInfo("#### delSettleDataFile Old File Deleted Succese ####");
					}, function(e) {
						util.logError("#### delSettleDataFile Old File Deleted Error " + e.message);
					});
				});
				
				util.logInfo("###################  delSettleDataFile End  #################");
			}
		}
	}

	/******************************************************************
	 * SCD_ENVPS_T :
	 *   - 오류시 재전송, 실시간 전송, 마스터 수신 전문 실행 앞단에 실행되어야 함
	 ******************************************************************/
	this.T_SCD_ENVPS_T_S01 = "SELECT * FROM SCD_ENVPS_T \n WHERE SHOP_CD = ?  \n  AND POS_NO = ?  \n  AND ENV_SET_CD = ? \n   AND SEND_FG = '0' "; //매장 환경설정 포스별 전송을 위해 데이터 조회

	this.T_SCD_ENVPS_T_U01 = "\n UPDATE SCD_ENVPS_T SET" +
							 "\n       UPD_DT         = strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME')  " +
							 "\n     , MODIFY_FG      = ? /* 0:미변경(서버수신) 1:변경(로컬변경) */" +
							 "\n     , SEND_FG        = ? /* 서버전송구분 0:미전송 1:전송 2:오류 */" +
							 "[SEND_DT] " +
							 "\n WHERE SHOP_CD        = ? " +
							 "\n   AND POS_NO         = ? " +
							 "\n   AND ENV_SET_CD     = ? " ;

	/**************************************************************************
	 * 1. 데이터 조회
	 * 2. 전문 생성
	 * 3. 전문 전송
	 * 4. 결과 Update.
	 **************************************************************************/
	this.posEnvProcess = function( envSetCd ) {
		try {
			console.clear();
			if ( envSetCd === undefined || envSetCd === null || envSetCd.length === 0  ) {
				throw "환경세팅코드가 입력되지 않았습니다.";
			}

			//1. 데이터 조회
			var sqlParameter = [ gShopCd ,  gPosNo , envSetCd ];
			var resultData = gfn_SQLiteSQLProcess(this.T_SCD_ENVPS_T_S01 , sqlParameter );

			util.logInfo('resultData' ,resultData );

			if ( resultData === undefined || resultData === null || resultData.length === 0  || resultData.Data === undefined || resultData.Data ===null || resultData.Data.length === 0) {
				//XXX 뭔가 응답을 주어야 하는가?
				return;
			}

			var row = resultData.Data[0] ;//XXX 향후 네이티브에서는 어떻게 처리해야 하는지?


			//2. 전문 생성&전송
			var procFg = "";
			if( row.INS_DT === row.UPD_DT ) {
				procFg = "I";
			} else {
				procFg = 'U';
			}

			var indexNo = gShopCd + gPosNo + row.ENV_SET_CD ; //전문 INDEX 는 SHOP_CD+POS_NO+ENV_SET_CD 로 설정.

			util.logInfo('PS100 - INDEX_NO' , indexNo );

			var dataBody = "";
			dataBody += "\n<TSP-NVP>";
			dataBody += "\n	<TXJM-FD SRID='PS100' RETCD='0000' KIOSK_REQ_YN='Y' >";//고정
			dataBody += "\n		<DATA-HD SHOP_CD='" + gShopCd + "' POS_NO='" + gPosNo +  "' INDEX_NO='" + indexNo + "' DT_CNT='1'  >"; //SHOP_CD(매장코드) ,SALE_DATE(영업일자) ,POS_NO(포스번호) ,REGI_SEQ(정산차수) ,INDEX_NO(전문INDEX) ,DT_CNT(DETAIL개수)
			dataBody += "\n			<DATA-DT  PROC_FG='"+procFg+"' ENV_SET_CD=' " + row.ENV_SET_CD + "'   ENV_SET_VAL='"+ row.ENV_SET_VAL + "' USE_YN='" + row.USE_YN + "' /> ";
			dataBody += "\n		</DATA-HD>";
			dataBody += "\n	</TXJM-FD>";
			dataBody += "\n</TSP-NVP>";



			var svc_urls = "/SvrApp/PS000.do";

			var params = XML_PI + dataBody ;
			var resultXMLData = telegram.tlgmCall(params,  svc_urls  );
			util.logInfo('tlgm result ' , resultXMLData );
			var retcd = $(resultXMLData).find("TXJM-FD").attr("RETCD");


			var successSQL = this.T_SCD_ENVPS_T_U01.replace("[SEND_DT]" , "\n     , SEND_DT        = strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME')   /* 서버전송일시  */");
			successSQL =  gfn_sqlBindParameters(  successSQL    , [ "0" , "1" /** 1 전송완료 **/ , gShopCd , gPosNo , envSetCd ]  );


			if ( retcd !== '0000'  ) {

				//XXX 실패시 재전송 전문 테이블 저장 처리. 2020.07.06
				util.logInfo("failSQL : \n" , successSQL );
				gfn_SQLiteSQLProcess( this.T_SCD_ENVPS_T_U01.replace("[SEND_DT]" , "\n     , SEND_DT        = ''  /* 서버전송일시  */") , ["1" , "2" /* 오류 */ , gShopCd , gPosNo , envSetCd] );

				this.resendInsertPorcess ( svc_urls, params, successSQL ) ;

			} else {

				util.logInfo('전문 전송 성공.');
				resultData = gfn_SQLiteSQLProcess( successSQL , [] );

			}

			util.logInfo('resultData T_SCD_ENVPS_T_U01 -  '  , resultData);

		} catch (e) {
			throw e;
		}
	}

	//POS_CSTMS_T
	/******************************************************************
	 * POS_CSTMS_T :
	 *   - 신규 회원 등록
	 ******************************************************************/
	this.T_POS_CSTMS_T_S01 = "SELECT * FROM POS_CSTMS_T \n WHERE SHOP_CD = ?  \n  AND NEW_CST_SEQ = ?  \n  AND SEND_FG = '0' "; //신규고객

	this.T_POS_CSTMS_T_U01 = "\n UPDATE POS_CSTMS_T SET" +
							 "\n      SEND_FG         = ? /* 서버전송구분 0:미전송 1:전송 2:오류 */" +
							 "[SEND_DT] " +
							 "\n WHERE SHOP_CD        = ? " +
							 "\n   AND NEW_CST_SEQ    = ? " ;

	//this.TLGM_S_PS140_DATA_HD_ATTRS = "SHOP_CD,SALE_DATE,POS_NO,NEW_CST_SEQ,CST_CARD_NO,CST_NM,TEL_NO,BIRTH_DATE,SOLAR_YN,SEX_FG,ADDR,ADDR_DTL,CST_REMARK,INS_DT,DLV_CL_CD,DLV_CM_CD,EMP_NO";
	this.TLGM_S_PS140_DATA_HD_ATTRS = "SHOP_CD,SALE_DATE,POS_NO";
	this.TLGM_S_PS140_DATA_DT_ATTRS = "SALE_DATE,POS_NO,CST_CARD_NO,CST_NM,TEL_NO,BIRTH_DATE,SOLAR_YN,SEX_FG,ADDR,ADDR_DTL,CST_REMARK,INS_DT,DLV_CL_CD,DLV_CM_CD,EMP_NO,NEW_CST_SEQ";
	
	this.newCustProcess = function ( newCstSeq, fn_callback ) {
		try {
			//console.clear();
			if ( newCstSeq === undefined || newCstSeq === null || newCstSeq.length === 0  ) {
				throw "신규회원 일련번호가 입력되지 않았습니다.";
			}

			//1. 데이터 조회
			var sqlParameter = [ gShopCd ,  newCstSeq ];
			var resultData = gfn_SQLiteSQLProcess(this.T_POS_CSTMS_T_S01 , sqlParameter );

			util.logInfo('resultData' ,resultData );

			if ( resultData === undefined || resultData === null || resultData.length === 0  || resultData.Data === undefined || resultData.Data ===null || resultData.Data.length === 0) {
				//XXX 뭔가 응답을 주어야 하는가?
				return;
			}

			var row = resultData.Data[0] ;//XXX 향후 네이티브에서는 어떻게 처리해야 하는지?

			//2. 전문 생성&전송
			var indexNo = gShopCd + row.SALE_DATE + newCstSeq ; //전문 INDEX 는 SHOP_CD + SALE_DATE + NEW_CST_SEQ 로 설정.

			/******** 송신 전문 속성 생성.***********/
			var attrStr  = this.makeCell2TlgmAttribute(row , this.TLGM_S_PS140_DATA_HD_ATTRS );
			var attrStr1 = this.makeCell2TlgmAttribute(row , this.TLGM_S_PS140_DATA_DT_ATTRS );
			
			

			util.logInfo('PS140 - INDEX_NO' , indexNo );

			var dataBody = "";
			dataBody += "\n<TSP-NVP>";
			dataBody += "\n	<TXJM-FD SRID='PS140' RETCD='0000' KIOSK_REQ_YN='Y' >";//고정
			dataBody += "\n		<DATA-HD  " + attrStr +" INDEX_NO='" + indexNo + "' DT_CNT='1' >"; //SHOP_CD(매장코드) ,SALE_DATE(영업일자) ,POS_NO(포스번호) ,REGI_SEQ(정산차수) ,INDEX_NO(전문INDEX) ,DT_CNT(DETAIL개수)
			dataBody += "\n     	<DATA-DT " + attrStr1 + "/>";
			dataBody += "\n		</DATA-HD>";
			dataBody += "\n	</TXJM-FD>";
			dataBody += "\n</TSP-NVP>";


			var svc_urls = "/SvrApp/PS000.do";

			var params = XML_PI + dataBody ;
			telegram.tlgmCall(params,  svc_urls, true, function(resultXMLData){
				try{
					util.logInfo(' ***** newCustProcess callback Start' );
					
					if(resultXMLData == "error"){
						fn_callback("error");
						return;
					}
					util.logInfo(' ***** tlgm result ==>  ' , resultXMLData );
					//처리 결과.
					var retcd = $(resultXMLData).find("TXJM-FD").attr("RETCD");
	
					var successSQL = aspEtcDataReceiveService.T_POS_CSTMS_T_U01.replace("[SEND_DT]" , "\n     , SEND_DT        = strftime('%Y%m%d%H%M%S', 'NOW' , 'LOCALTIME')   /* 서버전송일시  */");
					successSQL =  gfn_sqlBindParameters(  successSQL    , [  "1" /** 1 전송완료 **/ , gShopCd  , newCstSeq ]  );
	
	
					if ( retcd !== '0000'  ) {
	
						//실패시 재전송 전문 테이블 저장 처리. 2020.07.06
						util.logInfo("failSQL : \n" , successSQL );
	
						resultData = gfn_SQLiteSQLProcess( aspEtcDataReceiveService.T_POS_CSTMS_T_U01.replace("[SEND_DT]" , "\n     , SEND_DT        = ''  /* 서버전송일시  */") , [ "2" /* 오류 */ , gShopCd ,  newCstSeq] );
						util.logDebug( resultData );
	
						aspEtcDataReceiveService.resendInsertPorcess ( svc_urls, params, successSQL ) ;
						fn_callback("error");
						//return false;
	
					} else {
	
						util.logInfo('전문 전송 성공.');
						resultData = gfn_SQLiteSQLProcess( successSQL , [] );
						util.logInfo('resultData T_POS_CSTMS_T_U01 -  '  , resultData);
	
						/******************************************************************************
						 * 2020.10.28.
						 * 회원등록시 ASP 서버에서 등록하는 시간이 있기 때문에 delay 3초 정도 준다.
						 ******************************************************************************/
	//					let ms = 3100;
	//				    let date = new Date();
	//				    let curDate = null;
	//				    do {curDate = new Date();}
	//				    while(curDate-date<ms);
	
					    util.logDebug('신규 회원 등록 처리 성공(?) : ' + newCstSeq );
	
					    fn_callback(resultXMLData);
					}
				}catch(e){
					fn_callback("error");
					return;
				}
			});
			

		} catch (e) {
			$(".newUserPayIng").hide();
			util.logError('신규 회원 등록 처리 실패 - newCustProcess [' + newCstSeq + ']');
			throw e;
		}
	}

	this.makeCell2TlgmAttribute = function ( row , dtAttrs ) {
		if ( row === undefined || row === null || row.length === 0  ) {
			return;
		}

		if ( dtAttrs === undefined || dtAttrs === null || dtAttrs.length === 0  ) {
			return;
		}

		util.logInfo("전문에 사용할 row(DB)  : " + row);
		var arrs = dtAttrs.split(",");
		var strData = "";
		for ( var i = 0 ; i < arrs.length ; i++ ) {
			var attrKey = arrs[i];
			var attrVal = row[attrKey];
			if ( attrVal === undefined ) {
				throw "[" +attrKey + "] 항목이 없습니다." ;
			}

			if ( attrVal === null ) {
				attrVal = "";
			}

			strData += "   " + attrKey +"='" + attrVal + "' ";

		}

		return strData;
	}
}