var AdminService = function(){

    this.setMonthlySalesStatus = function(sDate, sPosNo, conditionValue){

        var items = [];

        targetDay = moment(sDate, "YYYY-MM").format("YYYY-MM") + "-01";

        util.logInfo("setMonthlySalesStatus" + targetDay + ", conditionValue  : " + conditionValue);

        var startDay = util.dayOfWeek(targetDay);

        var lastDate = new Date(targetDay.substring(0,4), targetDay.substring(5,7) , 0).getDate();
        var beforeLastDate = new Date(targetDay.substring(0,4), targetDay.substring(5,7) - 1, 0).getDate();

        //lastDate = new Date(2020, 2, 0).getDate();

        var queryResult = [];

        try{
            queryResult = gfn_SQLiteSQLProcess(adminSql.selectMonthSales, [gShopCd, moment(sDate, "YYYY-MM").format("YYYYMM"), sPosNo]).Data;

        }catch(e){
            util.logInfo("setMonthlySalesStatus error :" + JSON.stringify(e));
        }
        if(queryResult == null){
            queryResult = [];
        }

        util.logInfo("setMonthlySalesStatus queryResult :" + JSON.stringify(queryResult) );
        util.logInfo("setMonthlySalesStatus startDay :" + startDay + ",beforeLastDate : " + beforeLastDate + "=="+lastDate);

        var row = [];
        var rowSum = [];
        var verticalSum = [];
        var rowObj = {};
        var day = beforeLastDate - startDay;
        var tdClass = "";
        var divClass = "";
        var titAmount = 0
        var amount = 0
        var weekCnt = 5;
        if((startDay + lastDate) > 35){
            weekCnt = 6;
        }

        for(var i = 0 ; i < weekCnt ; i++){
            row = [];
            rowSum[i] = 0
            for(var j = 0 ; j < 8 ; j++){
                tdClass = "";
                divClass = "day";
                titAmount = 0;
                if((i == 0 && day >= beforeLastDate) || (i > 3 && day >= lastDate)){
                    day = 0;
                }
                if(j != 7 ){
                    day++;
                }
                if(j == 0){
                    tdClass = "sun ";
                }else if(j == 6 ){
                    tdClass = "sat ";
                }else if(j == 7 ){
                    tdClass = "sum ";
                    divClass = "tit ";
                }

                if((i == 0 && day > 20) || (i > 3 && day < 10)){
                    tdClass += "inactive";
                }else{
                    for(var k = 0; queryResult.length > k ; k++){
                        var resultRow = queryResult[k];
                        if(resultRow && resultRow.SALE_DAY == day && j != 7){
                            //util.log("setMonthlySalesStatus k : " + k + ", resultRow :" + JSON.stringify(resultRow));
                            if(conditionValue == "01"){
                                titAmount = resultRow.CASH_AMT;
                            }else if(conditionValue == "02"){
                                titAmount = resultRow.CRD_CARD_AMT;
                            }else if(conditionValue == "03"){
                                titAmount = resultRow.JCD_CARD_AMT;
                            }else if(conditionValue == "05"){
                                titAmount = resultRow.TK_GFT_AMT;
                            }else if(conditionValue == "06"){
                                titAmount = resultRow.WES_AMT;
                            }else if(conditionValue == "08"){
                                titAmount = resultRow.TK_FOD_AMT;
                            }else if(conditionValue == "09"){
                                titAmount = resultRow.CST_PINT_AMT;
                            }else if(conditionValue == "11"){
                                titAmount = resultRow.ETC_APPR_AMT;
                            }else{
                                titAmount = resultRow.SUM_AMT;
                            }
                            rowSum[i] = Number(rowSum[i]) + Number(titAmount);

                            //util.log("setMonthlySalesStatus11 j : " + j + ", i :" + i + ",titAmount : " + titAmount + ", rowSum[i] : " + rowSum[i]);

                        }
                    }
                }

                if(j == 7 ){
                    titAmount = rowSum[i];
                    rowObj = {tdClass: tdClass, divClass: divClass, day: (i+1) + "주", info: util.numberWithCommas(titAmount), spanYn : "Y"};
                }else {
                    rowObj = {tdClass: tdClass, divClass: divClass, day: day, info: util.numberWithCommas(titAmount), spanYn : "N"};
                }

                if(i ==0){
                    verticalSum[j] = Number(titAmount);
                }else{
                    verticalSum[j] = Number(verticalSum[j]) + Number(titAmount);
                }

//                util.log("setMonthlySalesStatus22 j : " + j + ", verticalSum[j] :" + verticalSum[j] + ", titAmount : " + titAmount);
//                util.log("setMonthlySalesStatus33 j : " + j + ", rowObj :" + JSON.stringify(rowObj));

                row.push(rowObj);
            }
            //util.log("setMonthlySalesStatus row :" + JSON.stringify(row));
            items.push(row);
        }

        util.logInfo("setMonthlySalesStatus items :" + JSON.stringify(items));

        row = [{tdClass: "sum sun", divClass: "tit", day: "일요일", info: util.numberWithCommas(verticalSum[0]), spanYn : "Y"}
            ,{tdClass: "sum", divClass: "tit", day: "월요일", info: util.numberWithCommas(verticalSum[1]), spanYn : "Y"}
            ,{tdClass: "sum", divClass: "tit", day: "화요일", info: util.numberWithCommas(verticalSum[2]), spanYn : "Y"}
            ,{tdClass: "sum", divClass: "tit", day: "수요일", info: util.numberWithCommas(verticalSum[3]), spanYn : "Y"}
            ,{tdClass: "sum", divClass: "tit", day: "목요일", info: util.numberWithCommas(verticalSum[4]), spanYn : "Y"}
            ,{tdClass: "sum", divClass: "tit", day: "금요일", info: util.numberWithCommas(verticalSum[5]), spanYn : "Y"}
            ,{tdClass: "sum sat", divClass: "tit", day: "토요일", info: util.numberWithCommas(verticalSum[6]), spanYn : "Y"}
            ,{tdClass: "sum total", divClass: "tit", day: "월매출합계", info: util.numberWithCommas(verticalSum[7]), spanYn : "N"} ];
        items.push(row);

//        items = [row, row];

        return items;

    },

    this.fnGetPostClosingStatus = function(){
        var closeInfo = gfn_SQLiteSQLProcess(adminSql.selectPosClosingStatus, [gShopCd, mainPosNo, gShopCd, gShopCd, mainPosNo, gPosNo]).Data;

        util.logInfo("fnGetPostClosingStatus selectPosClosingStatus :" + adminSql.selectPosClosingStatus);
        util.logInfo("fnGetPostClosingStatus mainPosNo :" + mainPosNo + " , gPosNo : " + gPosNo);
        util.logInfo("fnGetPostClosingStatus closeInfo :" + JSON.stringify(closeInfo));

        util.logInfo("fnGetPostClosingStatus closeInfo :" + util.isEmpty(closeInfo) + ",  : " + util.isEmpty(closeInfo));

        if(!util.isEmpty(closeInfo) && closeInfo.length > 0){
            return closeInfo[0];
        }else{
            return closeInfo;
        }

    }

    //개점확인
    this.fnOpeningConfirmation = function(paramObj){

        util.logInfo("fnOpeningConfirmation start  paramObj :" + JSON.stringify(paramObj));

        var autoLoginYn = paramObj.autoLoginYn;
        var closeInfo = adminService.fnGetPostClosingStatus();

        util.logInfo("fnOpeningConfirmation closeInfo :" + JSON.stringify(closeInfo));

        if(util.isEmpty(closeInfo)){
            if(autoLoginYn == "1"){
                var openDate = moment().format('YYYYMMDDHHmmss');
                if(!util.fnIsMainPos()){
                    var openSaleDateResult = gfn_SQLiteSQLProcess(adminSql.selectGetSaledate, [gShopCd, mainPosNo]).Data[0];

                    util.logInfo("fnOpenProcessProcess openSaleDateResult :" + JSON.stringify(openSaleDateResult));
                    openDate = openSaleDateResult.SALE_DATE + "000000";
                }

                var openData = {openDate : openDate, posReadyAmt : "0", openEmpNo : loginEmpInfo.EMP_NO };
                adminService.fnOpen(openData);
            }else{
                //개점처리
                eventBus.$emit('openProcessPopup', {});
            }
            return false;

        }

        closeInfo.autoLoginYn = autoLoginYn;

        util.logInfo("fnOpenProcessProcess closeInfo :" + JSON.stringify(closeInfo));
        util.logInfo("fnOpeningConfirmation mainPosNo :" + mainPosNo + ",gPosNo :" + gPosNo + ",inRegiCloseFg :" + inRegiCloseFg + ", autoLoginYn :" + autoLoginYn);

        var openSaleDate = moment(saleDate, 'YYYYMMDD').format("YYYY년 MM월 DD일 ");

        if(util.fnIsMainPos()){
            if(autoLoginYn == 1 && closeInfo.MAIN_POS_CLOSE == 1 && closeInfo.SALE_DATE != moment().format("YYYYMMDD")){

                var paramData = {"closeInfo" : closeInfo, "openSaleDate" : openSaleDate, "autoLoginYn" : autoLoginYn };
                adminService.fnAutoSalesClose(paramData);

                closeInfo = adminService.fnGetPostClosingStatus();
                closeInfo.autoLoginYn = autoLoginYn;
                adminService.fnOpenConfirm(closeInfo);

            //영업일자 체크
            }else if(inRegiCloseFg == 1 && closeInfo.MAIN_POS_CLOSE == "1" && closeInfo.SALE_DATE != moment().format("YYYYMMDD") ){

                dataObj = {"button2Show" : true, "button2Name" : "확인", "button2Func": adminService.fnAutoSalesCloseAlert
                        , "data" : {"closeInfo" : closeInfo, "openSaleDate" : openSaleDate, "autoLoginYn" : autoLoginYn }
                        , "message" : "해당 영업일자 " + openSaleDate + "와 현재일자가 틀립니다. \n 해당영업일자를 자동정산하셔야 영업일자가 당일로 \n 변경되며 당일영업매출이 집계 처리되어집니다."};

                eventBus.$emit('alertPopup', dataObj);

                return false;
            }
        }
        adminService.fnOpenConfirm(closeInfo);
        util.logInfo("fnOpeningConfirmation end ");
    },

    this.fnOpenConfirm = function(closeInfo){
    	util.logInfo("__________ fnOpenConfirm START __________");
        util.logInfo("fnOpenConfirm closeInfo :" + JSON.stringify(closeInfo));

        var messageObj = "";
        var nowTime = moment();
        var openSaleDate = moment(saleDate, 'YYYYMMDD').format("YYYY년 MM월 DD일 ");

        util.logInfo("fnOpenConfirm closeInfo.CLOSE_FG  : " + closeInfo.CLOSE_FG + " closeInfo.MAIN_POS_CLOSE : " + closeInfo.MAIN_POS_CLOSE);

        //연동/단독 확인
        if(util.fnIsMainPos()){
        	util.logInfo("fnOpenConfirm util.fnIsMainPos() : TRUE ");
            if(closeInfo.CLOSE_FG == "1" && closeInfo.MAIN_POS_CLOSE == "1") {
                var openTime = moment(closeInfo.OPEN_DT, 'YYYYMMDDHHmmss');
//                util.log("fnOpeningConfirmation openTime :" + openTime.format("YYYYMMDDHHmmss"));
//                util.log("fnOpeningConfirmation nowTime :" + nowTime.format("YYYYMMDDHHmmss"));

                util.logInfo("fnOpeningConfirmation moment :" + moment.duration(nowTime.diff(openTime)).asHours());

                if(moment.duration(nowTime.diff(openTime)).asHours() > 25 ){
                    messageObj = "해당영업일자 " + openSaleDate + "개점하고 마감정산을 \n 하지않아현재시스템일자와 서로 다릅니다. \n 포스의 영업관리에서 마감정산을 하셔야 영업일자를 당일로 \n 변경되며 당일영업매출이 집계되어 처리되어집니다.";

                    dataObj = {"button2Show" : true, "button2Name" : "확인", message: messageObj, "button2Func": adminService.fnMoveIndex};

                    //경고메세지 팝업
                    eventBus.$emit('alertPopup', dataObj);
                }else{
                    adminService.fnMoveIndex();
                }
            }else if(closeInfo.CLOSE_FG == "2" && closeInfo.MAIN_POS_CLOSE == "3") {
                if(nowTime.format("YYYYMMDD") == saleDate){
                    //경고메세지 팝업
                    eventBus.$emit('alertPopup', {message:openSaleDate + " 영업은 마감처리된 상태입니다."});
                }else{

                    if(closeInfo.autoLoginYn == "1"){
                        var openData = {openDate : moment().format('YYYYMMDDHHmmss'), posReadyAmt : "0", openEmpNo : loginEmpInfo.EMP_NO };
                        adminService.fnOpen(openData);
                    }else{
                        //개점처리
                        eventBus.$emit('openProcessPopup', {});
                    }
                }
            }else {
                eventBus.$emit('alertPopup', {message:"마감상태가 비정상입니다. 관리자한테 문의하세요."});
            }
        }else{
        	util.logInfo("fnOpenConfirm util.fnIsMainPos() : FALSE ");
            if(closeInfo.MAIN_POS_CLOSE == "1" ) {
                if(closeInfo.CLOSE_FG == "1"){
                    adminService.fnMoveIndex();
                }else if(closeInfo.CLOSE_FG == "2"){
                    //경고메세지 팝업
                    eventBus.$emit('alertPopup', {message:openSaleDate + " 영업은 마감처리된 상태입니다."});
                }else{
                    if(closeInfo.autoLoginYn == "1"){
                        var openSaleDateResult = gfn_SQLiteSQLProcess(adminSql.selectGetSaledate, [gShopCd, mainPosNo]).Data[0];

                        util.logInfo("fnOpenProcessProcess openSaleDateResult :" + JSON.stringify(openSaleDateResult));
                        var openDate = openSaleDateResult.SALE_DATE + "000000";
                        var openData = {openDate : openDate, posReadyAmt : "0", openEmpNo : loginEmpInfo.EMP_NO };
                        adminService.fnOpen(openData);
                    }else{
                        //개점처리
                        eventBus.$emit('openProcessPopup', {});
                    }
                }
            }else if(closeInfo.MAIN_POS_CLOSE == "3"){
                eventBus.$emit('alertPopup', {message: openSaleDate + " 영업은 마감처리된 상태입니다."});
                //판매불가
            }else{
                eventBus.$emit('alertPopup', {message: "영업개점 처리가 되어있지 않습니다. \n 메인포스에서 개점처리를 하세요"});
            }
        }
        
        util.logInfo("__________ fnOpenConfirm END __________");
    }

    //개점처리
    this.fnOpen = function(info){
    	util.logInfo("__________ fnOpen 개첨처리 START __________");
        util.logInfo("fnOpen info :" + JSON.stringify(info));
        
        var openDate =  moment(info.openDate, "YYYYMMDDHHmmss").format("YYYYMMDD");

        var checkResult = gfn_SQLiteSQLProcess(adminSql.selectOpenProcessCheck, [gShopCd, openDate , gPosNo]).Data;
        util.logInfo("fnOpen result :" + JSON.stringify(checkResult));

        if(checkResult && checkResult.length > 0 && checkResult[0].CLOSE_FG == "1"){
            eventBus.$emit('alertPopup', {message: "이미 개점처리 되어있습니다."});
            return false;
        }else if(checkResult && checkResult.length > 0 && (checkResult[0].CLOSE_FG == "2" || checkResult[0].CLOSE_FG == "3")){
            eventBus.$emit('alertPopup', {message: "이미 마감되어진 영업일자입니다."});
            return false;
        }

        if(util.fnIsMainPos()){
            var insertResult = gfn_SQLiteSQLProcess(adminSql.insertMainPosOpen, [gShopCd, openDate, gPosNo, info.openEmpNo ]);
            util.logInfo("fnOpen insertResult :" + JSON.stringify(insertResult));
            try{
                aspEtcDataReceiveService.settleProcess(openDate, "00");
            }catch(e){
                util.logInfo("e==" + e);
            }
        }

        if(util.isEmptyStr(info.posReadyAmt)){
            info.posReadyAmt = 0;
        }
        var regiSeq = "";

        var regiSeqResult = gfn_SQLiteSQLProcess(adminSql.selectGetRegiSeq, [gShopCd, openDate, gPosNo]).Data;

        util.logInfo("fnOpen regiSeqResult :" + JSON.stringify(regiSeqResult));
        regiSeq = regiSeqResult[0].REGI_SEQ;

        var insertCnt = gfn_SQLiteSQLProcess(adminSql.insertPosOpen, [gShopCd, openDate, gPosNo, regiSeq, info.openEmpNo, info.posReadyAmt ]);
        util.logInfo("fnOpen insertCnt :" + JSON.stringify(insertCnt));

        util.fnSetGlobalVariable();
        sessionStorage.setItem("SALE_DATE"           , openDate); //영업일
        sessionStorage.setItem("IN_REGI_SEQ"         , regiSeq              );//현재 POS 마감 차수
        try{
        	//개점처리되는순간 커반 영수증번호 값과 영수증번호 채번 정상유무를 로컬스토리지에서 제거해준다
            localStorage.removeItem("gPosOrderNo");
			localStorage.removeItem("gPosBillNo");
			
            aspEtcDataReceiveService.settleProcess(openDate, inRegiSeq);
        }catch(e){
            util.logInfo("fnOpen  e==" + e);
        }

        util.logInfo("#############   fnOpen end  info :" + JSON.stringify(info));
        
//        if(gSettleDataAspFlag == true){
//        	util.logInfo("#############   gSettleDataAspFlag : " + gSettleDataAspFlag);
//        	//정산내역 성공하면 정산내역파일을 지워준다.
//        	setTimeout(aspEtcDataReceiveService.delSettleDataFile(gSettleDataFileName), 10000);
//        }
		
        if(info.moveYn != "N"){
        	util.logInfo("__________ fnOpen 개첨처리 판매시작 이동 __________");
            //판매시작
        	window.setTimeout(() =>  {
        		 adminService.fnMoveIndex();
			}, 500);
           
        }
        
        util.logInfo("__________ fnOpen 개첨처리 END __________");
    },

    this.fnIndexAutoLogin = function(param){
        var openDate = moment().format("YYYYMMDD");

        util.logInfo("######## fnIndexAutoLogin START openDate :" + openDate);
        //openDate = '20210417';

        if(!util.fnIsMainPos()){
            var openSaleDateResult = gfn_SQLiteSQLProcess(adminSql.selectGetSaledate, [gShopCd, mainPosNo]).Data[0];

            util.logInfo("fnIndexAutoLogin openSaleDateResult :" + JSON.stringify(openSaleDateResult));
            openDate = openSaleDateResult.SALE_DATE;
        }

        util.logInfo("fnIndexAutoLogin saleDate :" + saleDate + " , openDate : " + openDate);

        if(saleDate != openDate){

            if(util.fnIsMainPos()){
                var closeInfo = adminService.fnGetPostClosingStatus();
                var paramData = {"closeInfo" : closeInfo, "openSaleDate" : openDate, "autoLoginYn" : param.autoLoginYn };
                adminService.fnAutoSalesClose(paramData);
            }

            var openData = {openDate : openDate, posReadyAmt : "0", openEmpNo : loginEmpInfo.EMP_NO, moveYn : "N" };
            
            adminService.fnOpen(openData);

        }

        util.logInfo("$$$$$$$$$$$$$$$$$  fnIndexAutoLogin end  ");

    },

    this.fnAutoSalesCloseAlert = function(param){
        adminService.fnAutoSalesClose(param);

        var closeInfo = adminService.fnGetPostClosingStatus();
        closeInfo.autoLoginYn = data.autoLoginYn;
        adminService.fnOpenConfirm(closeInfo);

    },

    //자동정산처리
    this.fnAutoSalesClose = function(data){

        util.logInfo("fnAutoSalesClose data :" + JSON.stringify(data));

        var mainInfo = data.closeInfo

        var orderCnt = gfn_SQLiteSQLProcess(adminSql.selectRemainOrderCnt, [gShopCd, saleDate]).Data[0];
        var deliveryCnt = gfn_SQLiteSQLProcess(adminSql.selectRemainDeliveryCnt, [gShopCd, saleDate]).Data[0];
        var waitCnt = gfn_SQLiteSQLProcess(adminSql.selectRemainWaitCnt, [gShopCd, saleDate]).Data[0];

        if(orderCnt.ORD_CNT > 0 || deliveryCnt.ORD_CNT > 0 || waitCnt.ORD_CNT > 0 ){

            var messageStr = "미계산 테이블 주문내역이 " + orderCnt.ORD_CNT + "개 \n "
                                + "미입금 배달주문내역이 " + deliveryCnt.ORD_CNT + "개 \n "
                                + "대기내역이 " + waitCnt.ORD_CNT + "개 있습니다. \n "
                                + "먼저 계산처리후 개점하여주십시오. !";
            eventBus.$emit('alertPopup', {message: messageStr});

        }else{

            var insertResult = gfn_DbExecute(adminSql.updateScdTableT, [gShopCd]);
            util.logInfo("fnOpen insertResult :" + JSON.stringify(insertResult));
            var subPosList = gfn_SQLiteSQLProcess(adminSql.selectSubPosList, [gShopCd, saleDate]).Data;

            util.logInfo("fnOpen subPosList :" + JSON.stringify(subPosList));

            for(cnt in subPosList){
//                var result = subPosResultList[cnt];
//                var subPosResult2 = gfn_SQLiteSQLProcess(adminSql.selectClosingSettlementData2, [gShopCd, saleDate, result.POS_NO, result.REGI_SEQ]).Data;
//
//                util.log("fnOpen result :" + JSON.stringify(result));
//                util.log("fnOpen subPosResult2 :" + JSON.stringify(subPosResult2));
//
//                adminService.fnUpdateSubSalesClose(result, subPosResult2);

                var result = subPosList[cnt];

                var paramData = {"shopCd" : gShopCd, "saleDate" : saleDate, "posNo" : result.POS_NO, "regiSeq" : result.REGI_SEQ}
                adminService.fnSubSalesClose(paramData);

            }

            var closeFg = 3;
            var result1 = gfn_SQLiteSQLProcess(adminSql.selectClosingSettlementData3, [gShopCd, saleDate , gPosNo, "00"]);
            util.logInfo("fnMainSalesClose result :" + JSON.stringify(result1));

            var pr1 = result1.Data[0];

            var params = [loginEmpInfo.EMP_NO, closeFg, pr1.TOT_BILL_CNT, pr1.TOT_SALE_AMT];
            params.push(pr1.TOT_DC_AMT, pr1.SVC_TIP_AMT, pr1.TOT_ETC_AMT, pr1.DCM_SALE_AMT, pr1.VAT_SALE_AMT );
            params.push(pr1.VAT_AMT, pr1.NO_VAT_SALE_AMT, pr1.NO_TAX_SALE_AMT, pr1.RET_BILL_CNT, pr1.RET_BILL_AMT );
            params.push(pr1.VISIT_CST_CNT, pr1.POS_CSH_IN_AMT, pr1.POS_CSH_OUT_AMT, pr1.WEA_IN_CSH_AMT, pr1.WEA_IN_CRD_AMT );
            params.push(pr1.TK_GFT_SALE_CSH_AMT, pr1.TK_GFT_SALE_CRD_AMT, pr1.TK_FOD_SALE_CSH_AMT, pr1.TK_FOD_SALE_CRD_AMT, pr1.CASH_CNT );

            params.push(pr1.CASH_AMT, pr1.CASH_BILL_CNT, pr1.CASH_BILL_AMT, pr1.CRD_CARD_CNT, pr1.CRD_CARD_AMT );
            params.push(pr1.WES_CNT, pr1.WES_AMT, pr1.TK_GFT_CNT, pr1.TK_GFT_AMT, pr1.TK_FOD_CNT );
            params.push(pr1.TK_FOD_AMT, pr1.CST_POINT_CNT, pr1.CST_POINT_AMT, pr1.JCD_CARD_CNT, pr1.JCD_CARD_AMT );
            params.push(pr1.RFC_CNT, pr1.RFC_AMT, pr1.ETC_APPR_CNT, pr1.ETC_APPR_AMT, pr1.DC_GEN_CNT );
            params.push(pr1.DC_GEN_AMT, pr1.DC_SVC_CNT, pr1.DC_SVC_AMT, pr1.DC_JCD_CNT, pr1.DC_JCD_AMT );

            params.push(pr1.DC_CPN_CNT, pr1.DC_CPN_AMT, pr1.DC_CST_CNT, pr1.DC_CST_AMT, pr1.DC_TFD_CNT );
            params.push(pr1.DC_TFD_AMT, pr1.DC_PRM_CNT, pr1.DC_PRM_AMT, pr1.DC_CRD_CNT, pr1.DC_CRD_AMT );
            params.push(pr1.DC_PACK_CNT, pr1.DC_PACK_AMT, pr1.REM_CHECK_CNT, pr1.REM_CHECK_AMT, pr1.REM_W100000_CNT );
            params.push(pr1.REM_W50000_CNT, pr1.REM_W10000_CNT, pr1.REM_W5000_CNT, pr1.REM_W1000_CNT, pr1.REM_W500_CNT );
            params.push(pr1.REM_W100_CNT, pr1.REM_W50_CNT, pr1.REM_W10_CNT, pr1.REM_CASH_AMT, pr1.REM_TK_GFT_CNT );

            params.push(pr1.REM_TK_GFT_AMT, pr1.REM_TK_FOD_CNT, pr1.REM_TK_FOD_AMT, pr1.ETC_TK_FOD_AMT, pr1.LOSS_CASH_AMT );
            params.push(pr1.LOSS_TK_GFT_AMT, pr1.LOSS_TK_FOD_AMT, pr1.REPAY_CASH_CNT, pr1.REPAY_CASH_AMT, pr1.REPAY_TK_GFT_CNT );
            params.push(pr1.REPAY_TK_GFT_AMT, gShopCd, saleDate );

            var insertCnt = gfn_DbExecute(adminSql.updateClosingSettlement2, params);

            util.logInfo("fnMainSalesClose result :" + JSON.stringify(insertCnt));

            util.fnSetGlobalVariable();
            try{
            	//aspEtcDataReceiveService.settleProcess(saleDate, inRegiSeq);
                aspEtcDataReceiveService.settleProcess(saleDate, "00");
            }catch(e){
                util.logError("fnAutoSalesClose error :" + JSON.stringify(e));
            }
        }
    }

    //마감정산
    this.fnSalesClose = function(data){

        //saleDate = '20200713';
        //mainPosNo = "00";
        //var childrenSalesClose = this.$parent.$children[0].$children[1];

        //eventBus.$emit('fnSalesClose', this.fnSalesClose);

        util.logInfo("fnSalesClose inRegifg :" + inRegifg);

        util.logInfo("    마감정산 " + moment().format('YYYY-MM-DD HH:mm:ss') + " 수행    ");

        if(inRegifg == "1"){
            try{

                if(util.fnIsMainPos()){
                    gfn_DbOpen();
                    var paramData = {"shopCd" : gShopCd, "saleDate" : saleDate, "posNo" : gPosNo, "regiSeq" : inRegiSeq}
                    adminService.fnSubSalesClose(paramData);
                    adminService.fnMainSalesClose();
                    gfn_DbClose()

                }else{
                    gfn_DbOpen();
                    var paramData = {"shopCd" : gShopCd, "saleDate" : saleDate, "posNo" : gPosNo, "regiSeq" : inRegiSeq}
                    adminService.fnSubSalesClose(paramData);
                    gfn_DbClose()
                }

//                var result = gfn_SQLiteSQLProcess(adminSql.selectOpenProcessCheck, [gShopCd, saleDate , gPosNo]).Data;
//                if(result){
//                    row = result[0];
//                    inRegiSeq = row.REGI_SEQ; //현재 POS 마감 차수.
//                    inRegifg = row.CLOSE_FG; //현재 POS 마감 현황.
//                }

                util.fnSetGlobalVariable();

                //eventBus.$emit('alertPopup', {message: "마감정산이 완료되었습니다."});
                dataObj = {"button2Show" : true, "button2Name" : "확인", "button2Func": util.fnTmsUpdateDownLoad
                    , "data" : {}
                    , "message" : "마감정산이 완료되었습니다."};

                util.logInfo("    마감정산 완료    ");

                eventBus.$emit('alertPopup', dataObj);


            }catch(er){
                util.logInfo("fnSalesClose er :" + er);

            }
        }
    }

    //서브포스 마감정산
    this.fnSubSalesClose = function(paramData){

        var result1 = gfn_SQLiteSQLProcess(adminSql.selectClosingSettlementData1, [paramData.shopCd, paramData.saleDate , paramData.posNo, paramData.regiSeq]).Data;
        var result2 = gfn_SQLiteSQLProcess(adminSql.selectClosingSettlementData2, [paramData.shopCd, paramData.saleDate , paramData.posNo, paramData.regiSeq]).Data;
        util.logInfo("fnSubSalesClose result :" + JSON.stringify(result1));
        util.logInfo("fnSubSalesClose result2 :" + JSON.stringify(result2));

        var pr1;
        var pr2 = result2[0];

        if(!result1 || result1.length == 0){
            pr1= {"TOT_BILL_CNT": "0", "TOT_SALE_AMT" : "0", "TOT_DC_AMT" : "0", "SVC_TIP_AMT" : "0", "TOT_ETC_AMT" : "0", "DCM_SALE_AMT" : "0", "VAT_SALE_AMT" : "0",
                "VAT_AMT" : "0", "NO_VAT_SALE_AMT" : "0", "NO_TAX_SALE_AMT" : "0", "RET_BILL_CNT" : "0", "CANCEL_TOT_AMT" : "0",
                "FD_GST_CNT_T" : "0", "CASH_CNT" : "0",
                "CASH_AMT" : "0", "CASH_BILL_CNT" : "0", "CASH_BILL_AMT" : "0", "CARD_CNT" : "0", "CRD_CARD_AMT" : "0",
                "WES_CNT" : "0", "WES_AMT" : "0", "TK_GFT_CNT" : "0", "TK_GFT_AMT" : "0", "TK_FOD_CNT" : "0",
                "TK_FOD_AMT" : "0", "CST_POINT_CNT" : "0", "CST_POINT_AMT" : "0", "JCD_CARD_CNT" : "0", "JCD_CARD_AMT" : "0",
                "RFC_CNT" : "0", "RFC_AMT" : "0", "ETC_APPR_CNT" : "0", "ETC_APPR_AMT" : "0", "DC_GEN_CNT" : "0",
                "DC_GEN_AMT" : "0", "DC_SVC_CNT" : "0", "DC_SVC_AMT" : "0", "DC_PCD_CNT" : "0", "DC_PCD_AMT" : "0",

                "DC_CPN_CNT" : "0", "DC_CPN_AMT" : "0", "DC_CST_CNT" : "0", "DC_CST_AMT" : "0", "DC_TFD_CNT" : "0",
                "DC_TFD_AMT" : "0", "DC_PRM_CNT" : "0", "DC_PRM_AMT" : "0", "DC_CRD_CNT" : "0", "DC_CRD_AMT" : "0",
                "DC_PACK_CNT" : "0", "DC_PACK_AMT" : "0", "REPAY_CASH_CNT" : "0", "REPAY_CASH_AMT" : "0", "REPAY_TK_GFT_CNT" : "0",
                "REPAY_TK_GFT_AMT" : "0"
            }
        }else{
            pr1= result1[0];
        }

        adminService.fnUpdateSubSalesClose(pr1, pr2);
    }

    this.fnUpdateSubSalesClose = function(pr1, pr2){
        var closeFg = 2;

        var params = [loginEmpInfo.EMP_NO, closeFg, pr1.TOT_BILL_CNT, pr1.TOT_SALE_AMT];
        params.push(pr1.TOT_DC_AMT, pr1.SVC_TIP_AMT, pr1.TOT_ETC_AMT, pr1.DCM_SALE_AMT, pr1.VAT_SALE_AMT );
        params.push(pr1.VAT_AMT, pr1.NO_VAT_SALE_AMT, pr1.NO_TAX_SALE_AMT, pr1.RET_BILL_CNT, pr1.CANCEL_TOT_AMT );
        params.push(pr1.FD_GST_CNT_T, pr2.POS_CSH_IN_AMT, pr2.POS_CSH_OUT_AMT, pr2.WEA_IN_CSH_AMT, pr2.WEA_IN_CRD_AMT );
        params.push(pr2.TK_GFT_SALE_CSH_AMT, pr2.TK_GFT_SALE_CRD_AMT, pr2.TK_FOD_SALE_CSH_AMT, pr2.TK_FOD_SALE_CRD_AMT, pr1.CASH_CNT );

        params.push(pr1.CASH_AMT, pr1.CASH_BILL_CNT, pr1.CASH_BILL_AMT, pr1.CARD_CNT, pr1.CRD_CARD_AMT );
        params.push(pr1.WES_CNT, pr1.WES_AMT, pr1.TK_GFT_CNT, pr1.TK_GFT_AMT, pr1.TK_FOD_CNT );
        params.push(pr1.TK_FOD_AMT, pr1.CST_POINT_CNT, pr1.CST_POINT_AMT, pr1.JCD_CARD_CNT, pr1.JCD_CARD_AMT );
        params.push(pr1.RFC_CNT, pr1.RFC_AMT, pr1.ETC_APPR_CNT, pr1.ETC_APPR_AMT, pr1.DC_GEN_CNT );
        params.push(pr1.DC_GEN_AMT, pr1.DC_SVC_CNT, pr1.DC_SVC_AMT, pr1.DC_PCD_CNT, pr1.DC_PCD_AMT );

        params.push(pr1.DC_CPN_CNT, pr1.DC_CPN_AMT, pr1.DC_CST_CNT, pr1.DC_CST_AMT, pr1.DC_TFD_CNT );
        params.push(pr1.DC_TFD_AMT, pr1.DC_PRM_CNT, pr1.DC_PRM_AMT, pr1.DC_CRD_CNT, pr1.DC_CRD_AMT );
        params.push(pr1.DC_PACK_CNT, pr1.DC_PACK_AMT, pr1.REPAY_CASH_CNT, pr1.REPAY_CASH_AMT, pr1.REPAY_TK_GFT_CNT );
        params.push(pr1.REPAY_TK_GFT_AMT, gShopCd, saleDate , gPosNo, inRegiSeq );

        var insertCnt = gfn_DbExecute(adminSql.updateClosingSettlement1, params);

        util.logInfo("fnSubSalesClose result :" + JSON.stringify(insertCnt));

        aspEtcDataReceiveService.settleProcess(saleDate, inRegiSeq);

    }

    //메인 마감정산
    this.fnMainSalesClose = function(){

        var closeFg = 3;

        var result1 = gfn_SQLiteSQLProcess(adminSql.selectClosingSettlementData3, [gShopCd, saleDate , gPosNo, "00"]);
        var result2 = gfn_SQLiteSQLProcess(adminSql.selectClosingSettlementData4, [gShopCd, saleDate , gPosNo, "00"]);
        util.logInfo("fnMainSalesClose result :" + JSON.stringify(result1));
        util.logInfo("fnMainSalesClose result2 :" + JSON.stringify(result2));

        var pr1 = result1.Data[0];
        var pr2 = result2.Data[0];

        var params = [loginEmpInfo.EMP_NO, closeFg, pr1.TOT_BILL_CNT, pr1.TOT_SALE_AMT];
        params.push(pr1.TOT_DC_AMT, pr1.SVC_TIP_AMT, pr1.TOT_ETC_AMT, pr1.DCM_SALE_AMT, pr1.VAT_SALE_AMT );
        params.push(pr1.VAT_AMT, pr1.NO_VAT_SALE_AMT, pr1.NO_TAX_SALE_AMT, pr1.RET_BILL_CNT, pr1.RET_BILL_AMT );
        params.push(pr1.VISIT_CST_CNT, pr2.POS_CSH_IN_AMT, pr2.POS_CSH_OUT_AMT, pr2.WEA_IN_CSH_AMT, pr2.WEA_IN_CRD_AMT );
        params.push(pr2.TK_GFT_SALE_CSH_AMT, pr2.TK_GFT_SALE_CRD_AMT, pr2.TK_FOD_SALE_CSH_AMT, pr2.TK_FOD_SALE_CRD_AMT, pr1.CASH_CNT );

        params.push(pr1.CASH_AMT, pr1.CASH_BILL_CNT, pr1.CASH_BILL_AMT, pr1.CRD_CARD_CNT, pr1.CRD_CARD_AMT );
        params.push(pr1.WES_CNT, pr1.WES_AMT, pr1.TK_GFT_CNT, pr1.TK_GFT_AMT, pr1.TK_FOD_CNT );
        params.push(pr1.TK_FOD_AMT, pr1.CST_POINT_CNT, pr1.CST_POINT_AMT, pr1.JCD_CARD_CNT, pr1.JCD_CARD_AMT );
        params.push(pr1.RFC_CNT, pr1.RFC_AMT, pr1.ETC_APPR_CNT, pr1.ETC_APPR_AMT, pr1.DC_GEN_CNT );
        params.push(pr1.DC_GEN_AMT, pr1.DC_SVC_CNT, pr1.DC_SVC_AMT, pr1.DC_JCD_CNT, pr1.DC_JCD_AMT );

        params.push(pr1.DC_CPN_CNT, pr1.DC_CPN_AMT, pr1.DC_CST_CNT, pr1.DC_CST_AMT, pr1.DC_TFD_CNT );
        params.push(pr1.DC_TFD_AMT, pr1.DC_PRM_CNT, pr1.DC_PRM_AMT, pr1.DC_CRD_CNT, pr1.DC_CRD_AMT );
        params.push(pr1.DC_PACK_CNT, pr1.DC_PACK_AMT, pr1.REM_CHECK_CNT, pr1.REM_CHECK_AMT, pr1.REM_W100000_CNT );
        params.push(pr1.REM_W50000_CNT, pr1.REM_W10000_CNT, pr1.REM_W5000_CNT, pr1.REM_W1000_CNT, pr1.REM_W500_CNT );
        params.push(pr1.REM_W100_CNT, pr1.REM_W50_CNT, pr1.REM_W10_CNT, pr1.REM_CASH_AMT, pr1.REM_TK_GFT_CNT );

        params.push(pr1.REM_TK_GFT_AMT, pr1.REM_TK_FOD_CNT, pr1.REM_TK_FOD_AMT, pr1.ETC_TK_FOD_AMT, pr1.LOSS_CASH_AMT );
        params.push(pr1.LOSS_TK_GFT_AMT, pr1.LOSS_TK_FOD_AMT, pr1.REPAY_CASH_CNT, pr1.REPAY_CASH_AMT, pr1.REPAY_TK_GFT_CNT );
        params.push(pr1.REPAY_TK_GFT_AMT, gShopCd, saleDate );

        var insertCnt = gfn_DbExecute(adminSql.updateClosingSettlement2, params);

        aspEtcDataReceiveService.settleProcess(saleDate, "00");

        util.logInfo("fnMainSalesClose result :" + JSON.stringify(insertCnt));

    }

    //마감정산 취소
    this.fnCancelSalesClose = function(data){

        util.logInfo("fnCancelSalesClose  data : " + JSON.stringify(data));
        util.logInfo("    마감취소 " + moment().format('YYYY-MM-DD HH:mm:ss') + " 진행    ");

        var mainPosInfo = gfn_SQLiteSQLProcess(adminSql.selectMainPosInfo, [gShopCd, gShopCd, mainPosNo, mainPosNo]).Data[0];
        var updateData = {};
        var updateCnt = 0;

        if(util.fnIsMainPos()){
            if(mainPosInfo.CLOSE_FG != 3){
                eventBus.$emit('alertPopup', {message: "영업중이거나 마감취소 할 데이터가 없습니다."});
                return false;
            }
        }else{
            if(mainPosInfo.CLOSE_FG == 3){
                eventBus.$emit('alertPopup', {message: "메인 POS " + moment(saleDate, "YYYYMMDD").format('YYYY-MM-DD') + "일자 영업마감이 되어 있어 취소가 불가 합니다."});
                return false;
            }
        }
        updateData = {"regiSeq" : "01", "empNo" : data.empNo, "closeFg" : "1" };
        updateCnt = adminService.fnRunCancelSalesClose(updateData);

        if(util.fnIsMainPos()){
            updateData = {"regiSeq" : "00", "empNo" : data.empNo, "closeFg" : "1" };
            updateCnt = updateCnt + adminService.fnRunCancelSalesClose(updateData);
        }

        util.fnSetGlobalVariable();

        eventBus.$emit('alertPopup', {message: "마감취소 되었습니다."});

        util.logInfo("    마감취소 완료    ");

        eventBus.$emit('CompleteClose', {});

        util.logInfo("fnCancelSalesClose  updateCnt : " + updateCnt);
    }

    //마감정산 취소
    this.fnRunCancelSalesClose = function(data){

        util.logInfo("fnRunCancelSalesClose  data : " + JSON.stringify(data));
        var params = [data.closeFg, data.empNo, gShopCd, saleDate, gPosNo, data.regiSeq];
        var insertResult = gfn_DbExecute(adminSql.updateCloseCancel, params);
        aspEtcDataReceiveService.settleProcess(saleDate, data.regiSeq);
        if(insertResult.ResultCode == "0"){
            return 1;
        }else{
            return 0;
        }


    }

    this.fnMoveIndex = function(){
    	util.logInfo("_________ fnMoveIndex Move _________");
    	location.replace('./index.html');
    }

    //분류별 매출현황 리스트 처리
    this.fnSetSalesClass = function(queryResult){
        var returnObj = {};
        var list = [];

        var taxYn = util.GetEnvXmlShopENV(128);
        var sumQty = 0;
        var sumAmt = 0;
        var sumDc = 0;
        var sumCsSalAmt = 0;
        var sumVat = 0;
        var sumCsSalSumAmt = 0;

        for(var i = 0 ; queryResult.length > i ; i++){

            var result = queryResult[i];
            if(taxYn == 1){
                result.csSalAmt = result.SALE_DCM - result.SALE_VAT;
                result.csSalSumAmt = result.SALE_DCM;
            }else{
                result.csSalAmt = result.SALE_DCM;
                result.csSalSumAmt = result.SALE_DCM + result.SALE_VAT;
            }

            sumQty = sumQty + Number(result.SALE_QTY);
            sumAmt = sumAmt + Number(result.SALE_AMT);
            sumDc = sumDc + Number(result.SALE_DC);
            sumCsSalAmt = sumCsSalAmt + Number(result.csSalAmt);
            sumVat = sumVat + Number(result.SALE_VAT);
            sumCsSalSumAmt = sumCsSalSumAmt + Number(result.csSalSumAmt);

            list.push(result);
        }

        for(var i = 0 ; list.length > i ; i++){
            var result = list[i];
            var share = (result.SALE_AMT / sumAmt) * 100;
            
            result.share = share.toFixed(1) + "%";

            util.logInfo("fnSalesClass  result.SALE_AMT : " + result.SALE_AMT + ",sumAmt : " + sumAmt + ",result.share : " + result.share);

            result.SALE_QTY = util.numberWithCommas(result.SALE_QTY);
            result.SALE_AMT = util.numberWithCommas(result.SALE_AMT);
            result.SALE_DC = util.numberWithCommas(result.SALE_DC);
            result.csSalAmt = util.numberWithCommas(result.csSalAmt);
            result.SALE_VAT = util.numberWithCommas(result.SALE_VAT);
            result.csSalSumAmt = util.numberWithCommas(result.csSalSumAmt);
        }

        util.logInfo("fnSalesClass  this.sumCsSalAmt : " + sumCsSalAmt);

        returnObj.list = list;

        returnObj.sumQty = util.numberWithCommas(sumQty);
        returnObj.sumAmt = util.numberWithCommas(sumAmt);
        returnObj.sumDc = util.numberWithCommas(sumDc);
        returnObj.sumCsSalAmt = util.numberWithCommas(Number(sumCsSalAmt));
        returnObj.sumVat = util.numberWithCommas(sumVat);
        returnObj.sumCsSalSumAmt = util.numberWithCommas(Number(sumCsSalSumAmt));

        return returnObj;

    },
    //영수증 반품 DB처리
    this.fnDoCancelApproval = function(sqlArr, callPaymentAppYn, payData){
    	util.logInfo(" ***** admin.service fnDoCancelApproval START ***** ");
        util.logInfo("fnDoCancelApproval sqlArr  : " + JSON.stringify(sqlArr));
        util.logInfo("fnDoCancelApproval callPaymentAppYn  : " + JSON.stringify(callPaymentAppYn));
        util.logInfo("fnDoCancelApproval payData  : " + JSON.stringify(payData));
        util.logInfo("fnDoCancelApproval gPayCancelExtCnt  : " + gPayCancelExtCnt);
        
            try{            	
            	gfn_DbOpen();
                gfn_DbBegin();
                
            	if(gPayCancelExtCnt == "1"){
            		var commitYn = "Y";
                    for(var i=0; sqlArr.length > i ; i++){
                        var sqlInfo = sqlArr[i];
                        util.logInfo("fnDoCancelApproval sqlInfo  : " + JSON.stringify(sqlInfo.sql));
                        util.logInfo("fnDoCancelApproval sqlInfo  : " + JSON.stringify(sqlInfo.param));

                        var executeResult = gfn_DbExecute(sqlInfo.sql, sqlInfo.param);
                        util.logInfo("fnDoCancelApproval executeResult  : " + JSON.stringify(executeResult));

                        if(executeResult.ResultCode != 0){
                            gfn_DbRollBack();
                            gfn_DbClose();
                            throw "승인취소에 실패하였습니다.";
                        }
                    }
            	}
                
                if ( util.isTizen() == true ) {
	                // 결제 승인이 된 경우
	                if(callPaymentAppYn != "N"){
	                	var cashResult = "";
	                	var vsApprIdtType = "";
	                	// 현금영수증인 경우에, 자진발급함수를 호출할지 소비자/사업자 함수를 호출할지 분기하기 위해 데이터 조회.
	                	if(payData.PAY_TYPE_FG == "01"){
	                		cashResult = gfn_SQLiteSQLProcess(adminSql.selectSslTrcshTCancel, [gShopCd, payData.OLD_SALE_DATE, gPosNo, payData.OLD_BILL_NO]).Data;
	                		vsApprIdtType = cashResult[0].APPR_IDT_TYPE; // 0 : 비승인(승인안하고저장), 1: 개인, 2: 사업자, 5: 자진발급
	                	}
	                	
	//                	if ( util.isTizen() == false || ipPortChgYn == "N") {
	                	if (  ipPortChgYn == "N") {
	                		if(payData.PAY_TYPE_FG == "04" || payData.PAY_TYPE_FG == "03" || payData.PAY_TYPE_FG == "07"){ // 제휴할인인 경우에 제휴할인 취소를 한다.
	    						util.fnAlliancePointCancel(payData);
	    					}else if (payData.PAY_TYPE_FG == "01"){ // 현금영수증
	    						if(vsApprIdtType == "5"){ // 자진발급
	    							this.fnCashReceiptsRefundSelf(payData, cashResult)
	    						}else{
	    							eventBus.$emit('cashReceiptsRefund', {payData: payData, cashResult : cashResult});
	    						}
        					}else{
                                if(payData.appType == 8){
                                    util.logInfo("fnCreditApproveRequestPayco...");
                                    var executeResult7 = util.fnCreditApproveRequestPayco(payData); // ip/port 변경 성공시에, 반품 함수 호출
                                }else{
                                    var executeResult7 = util.fnCreditApproveRequest(payData); // ip/port 변경 성공시에, 반품 함수 호출
                                }
	    					}
	                	}else{
	                		// 카카오, 제로페이인 경우에 결제 서버접속 IP/PORT를 디폴트 값으로 변경한다. (환경변수 0일 때의 값) 
	                    	if(payData.appType == 1 || payData.appType == 2){ // 1: 카카오, 2: 제로			
	                			util.logInfo("*****admin.service.js fnDoCancelApproval IF START*****");
	                			// IP,PORT 변경 공통함수 호출 (파라미터 - 0 : 디폴트 ip/port , 1 : 현재 매장의 ip/port)
	                			util.fnServerIpPortChange("0", function(result){
	                				util.logInfo("*****admin.service.js fnDoCancelApproval IF CALLBACK START*****");            				
	                				var vsCode = result.Code;
	                				if(vsCode == "0"){ // 성공
	                					util.logInfo("*****admin.service.js fnDoCancelApproval IF CALLBACK SERVER IP/PORT CALLBACK success*****");
	                					if(payData.PAY_TYPE_FG == "04" || payData.PAY_TYPE_FG == "03" || payData.PAY_TYPE_FG == "07"){ // 제휴할인(04), MP포인트 사용+적립(03), MP포인트 적립(07)인 경우
	                						util.fnAlliancePointCancel(payData);
	                					}else if (payData.PAY_TYPE_FG == "01"){ // 현금영수증
	                						if(vsApprIdtType == "5"){ // 자진발급
	        	    							this.fnCashReceiptsRefundSelf(payData, cashResult)
	        	    						}else{
	        	    							eventBus.$emit('cashReceiptsRefund', {payData: payData, cashResult : cashResult});
	        	    						}
	                					}else{
	                						var executeResult7 = util.fnCreditApproveRequest(payData); // ip/port 변경 성공시에, 반품 함수 호출
	                					}
	                					
	                					util.logInfo("executeResult7  : " + executeResult7);
	                				}else{ // 실패
	                					gfn_DbRollBack();
	                	                gfn_DbClose();
	                					util.logInfo("*****admin.service.js fnDoCancelApproval IF CALLBACK SERVER IP/PORT CALLBACK fail*****");
	                					eventBus.$emit('alertPopup', {message: "결제 서버 정보 변경에 실패하였습니다.<br/>다시 시도해 주세요."});
	                					return;
	                				}
	                			});
	                			
	                			// 결제서버 정보가 있으면 서버 IP/PORT 변경 수행.
	//                			listenerId = nativeApp.functionCallASync(["FDK_Config_Host_Address", vsIp, vsPort], paymentChoiceView.fnCreditApproveRequestCallback);
	                		}else if(payData.appType == 8){ // 8 : 페이코
                                util.logInfo("*****admin.service.js fnDoCancelApproval ELSE IF payco START*****");
	                			// IP,PORT 변경 공통함수 호출 (파라미터 - 0 : 디폴트 ip/port , 1 : 현재 매장의 ip/port)
	                			util.fnServerIpPortChange("0", function(result){
	                				util.logInfo("*****admin.service.js fnDoCancelApproval ELSE IF payco CALLBACK START*****");            				
	                				var vsCode = result.Code;
	                				if(vsCode == "0"){ // 성공
	                					util.logInfo("*****admin.service.js fnDoCancelApproval ELSE IF payco CALLBACK SERVER IP/PORT CALLBACK success*****");
	                					var executeResult7 = util.fnCreditApproveRequestPayco(payData); // ip/port 변경 성공시에, 반품 함수 호출	                					
	                					util.logInfo("executeResult7  : " + executeResult7);
	                				}else{ // 실패
	                					gfn_DbRollBack();
	                	                gfn_DbClose();
	                					util.logInfo("*****admin.service.js fnDoCancelApproval ELSE IF payco CALLBACK SERVER IP/PORT CALLBACK fail*****");
	                					eventBus.$emit('alertPopup', {message: "결제 서버 정보 변경에 실패하였습니다.<br/>다시 시도해 주세요."});
	                					return;
	                				}
	                			});
                            }                            
                            else{ // 카카오, 제로페이가 아닌경우 현재 매장에 설정된 결제서버 ip/port로 변경처리.
	                			util.logInfo("*****admin.service.js fnDoCancelApproval ELSE START*****");
	                			
	                			var SERVER_IP_NOW = sessionStorage.getItem("SERVER_IP_NOW" ); // 결제를 위한 서버 IP: 현재 설정된 값
	                		    var SERVER_PORT_NOW = sessionStorage.getItem("SERVER_PORT_NOW" ); // 결제를 위한 서버 PORT: 현재 설정된 값
	                		    var SERVER_IP = sessionStorage.getItem("SERVER_IP" ); // 결제를 위한 서버 IP: 매장에 지정된 서버의 값
	                		    var SERVER_PORT = sessionStorage.getItem("SERVER_PORT" ); // 결제를 위한 서버 PORT: 매장에 지정된 서버의 값
	                		    
	                			// 현재 설정되어있는 ip/port와 해당 매장의 ip/port 값이 같다면 바로 결제 수행
	                			if(SERVER_IP_NOW == SERVER_IP && SERVER_PORT_NOW == SERVER_PORT){
	                				util.logInfo("*****admin.service.js fnDoCancelApproval ELSE SAME NOW*****");
	                				if(payData.PAY_TYPE_FG == "04" || payData.PAY_TYPE_FG == "03" || payData.PAY_TYPE_FG == "07"){ // 제휴할인인 경우에 제휴할인 취소를 한다.
	            						util.fnAlliancePointCancel(payData);
	            					}else if (payData.PAY_TYPE_FG == "01"){ // 현금영수증
	            						if(vsApprIdtType == "5"){ // 자진발급
	    	    							this.fnCashReceiptsRefundSelf(payData, cashResult)
	    	    						}else{
	    	    							eventBus.$emit('cashReceiptsRefund', {payData: payData, cashResult : cashResult});
	    	    						}
                					}else{
	            						var executeResult7 = util.fnCreditApproveRequest(payData); // ip/port 변경 성공시에, 반품 함수 호출
	            					}
	                			}else{ // ip/port가 다르다면 해당 매장의 ip/port로 변경
	                				util.logInfo("*****admin.service.js fnDoCancelApproval ELSE DIFF NOW*****");
	                				// IP,PORT 변경 공통함수 호출 (해당 매장의 값으로 변경)
	                				util.fnServerIpPortChange("1", function(result){
	                					util.logInfo("*****admin.service.js fnDoCancelApproval ELSE CALLBACK START*****");
	                					var vsCode = result.Code; 
	                					if(vsCode == "0"){ // 성공
	                						util.logInfo("*****admin.service.js fnDoCancelApproval ELSE CALLBACK SERVER IP/PORT CALLBACK success*****");
	                						if(payData.PAY_TYPE_FG == "04" || payData.PAY_TYPE_FG == "03" || payData.PAY_TYPE_FG == "07"){ // 제휴할인인 경우에 제휴할인 취소를 한다.
	                    						util.fnAlliancePointCancel(payData);
	                    					}else if (payData.PAY_TYPE_FG == "01"){ // 현금영수증
	                    						if(vsApprIdtType == "5"){ // 자진발급
	            	    							this.fnCashReceiptsRefundSelf(payData, cashResult)
	            	    						}else{
	            	    							eventBus.$emit('cashReceiptsRefund', {payData: payData, cashResult : cashResult});
	            	    						}
		                					}else{
	                    						var executeResult7 = util.fnCreditApproveRequest(payData); // ip/port 변경 성공시에, 반품 함수 호출
	                    					}
	                					}else{ // 실패
	                						gfn_DbRollBack();
	                		                gfn_DbClose();
	                						util.logInfo("*****admin.service.js fnDoCancelApproval ELSE CALLBACK SERVER IP/PORT CALLBACK fail*****");
	                						eventBus.$emit('alertPopup', {message: "결제 서버 정보 변경에 실패하였습니다.<br/>다시 시도해 주세요."});
	                    					return;
	                					}
	                				});
	                			}
	                		}
	                	}
	                    
	                }else{ // 결제 승인이 안된 경우 (포인트 등), native통신 없이 바로 반품 저장처리
	                	gfn_DbCommit();
                        gfn_DbClose();
                        
	                    this.fnCancelApprovalSetPage(saleDate, payData);
	
	                }
	    //                    var executeResult8 = util.fnTranDbExec(adminSql.insertCardReturnInfo, cardReturnInfoParam);
	    //                    if(commitYn == "Y") {
	    //                        nativeApp.functionCallSync(["DB_Commit"]);
	    //                    }else{
	    //                        nativeApp.functionCallSync(["DB_Rollback"]);
	    //                    }
	//               gfn_DbCommit();
	//               gfn_DbClose();
	            }else{
	            	// 로컬에서 현금영수증 키패드 팝업을 띄우기 위한 코드(주석처리)	            	
//	            	gfn_DbRollBack();
//	            	gfn_DbClose();
//	            	eventBus.$emit('cashReceiptsRefund', {payData: payData});
	            	gfn_DbCommit();
                    gfn_DbClose();                    
	                this.fnCancelApprovalSetPage(saleDate, payData);
	
	            }
            }catch(e){
                util.logError("fnDoCancelApproval error : " + e.message);
                gfn_DbRollBack();
                gfn_DbClose();
                $("#cancelAppr").show();
                util.logError("fnDoCancelApproval catch ERROR  : " + JSON.stringify(e));
                //eventBus.$emit('alertPopup', {message: e});
            }
//        }else{
//            eventBus.$emit('approveCancelComplete');
//        }

    }
    var listenerIdCashRefund = "";
    // 현금영주증 반품. 자진발급일 때. 이 함수 수행.
    this.fnCashReceiptsRefundSelf = function(payData, cashResult){
    	util.logInfo("***** 현금영수증 자진발급 반품함수 시작 *****");
    	try{
    		
    		// 콜백함수 정의
    		var fnCashReceiptsCallbackResult = function(callbackName, result) {
    			util.logInfo("***** 현금영수증 반품 콜백함수 시작(자진발급) *****");
        		nativeApp.removeASyncApiListener(callbackName, listenerIdCashRefund); // 리더기 카드체크하는 리스너 해제함수.
				var vsResult = result.substring(0, result.lastIndexOf("$$^")); // native 데이터 중 마지막 $$^를 제거    	
				adminService.fnCallbackCancelApproval(vsResult, payData);
    			
    		}
    		// 콜백함수 정의 끝 
    		
    		var vsApprNo = cashResult[0].APPR_NO;
    		var vsApprDt = cashResult[0].APPR_DATE.substring(2); // 승인일자는 6자리로 넣어야한다.
    		var vsAmt = cashResult[0].APPR_AMT;
    		var vsApprIdtType = cashResult[0].APPR_IDT_TYPE; // 0 : 비승인(승인안하고저장), 1: 개인, 2: 사업자, 5: 자진발급
    		
    		/**
    		 * 현금영수증 승인 : FDK_CashSave_Purchase
    		 * param1 String : 단말기 번호
    		 * param2 String : 현금영수증 금액 
    		 * param3 String : sw모델
    		 * param4 String : sw버전
    		 * param5 String : 원거래 승인번호 
    		 * param6 String : 원거래 일자
    		 * param7 String : 현금영수증 취소사유 ( 1: 거래취소, 2: 오류발급, 3: 기타)
    		 * param8 String : 현금영수증 사용자 코드 (00 고정)
    		 * param9 String : 현금영수증 거래 구분 (00: 소비자 소득공제, 01: 사업자 지출증빙)
    		 * param10 String : 카드번호 ( 없을 경우에 "" 입력 )
    		 * param11 String : 자진발급여부 - 자진발급 1, 자진발급 아닌경우 0
    		 *                  자진발급인 경우 카드번호는 입력받지 않으며 native에서 자동으로 '0100001234' 고정됨
    		 * @returns
    		 */  
    		
    		util.logInfo("***** FDK_CashSave_Refund param == > 금액 : " + vsAmt + ", 거래구분(소비자 00, 사업자 01, 자진발급인 경우 00) : 00" + ", 휴대폰(카드) : ''" +  ", 자진발급여부(자진 1, 자진아님 0) : 0");
    		// 마지막 파라미터는 1회용 컵보증금에 대한 하드코딩으로 빈값을 넣음. 추후 현금영수증에 컵보증금 처리시 실제 보증금값을 넣어야함. 2022-06-15
			listenerIdCashRefund = nativeApp.functionCallASync(["FDK_CashSave_Refund", BIZ_CLS_SINGLE_CAT_ID, "" + vsAmt, gvSwModelName, gvSwModelVersion, vsApprNo, vsApprDt, "1", "00", "00", "", "1", ""], fnCashReceiptsCallbackResult);
		}catch(e){
			util.logInfo("***** FDK_CashSave_Purchase cashReceiptsExe ERROR == > " + e.toString());
		}
    	
    }
    //영수증 반품 paymentApp 통신
    this.fnCallbackCancelApproval = function(callbackData, payData){
    	util.logInfo("*****fnCallbackCancelApproval START*****");
    	if ( util.isTizen() == false || ipPortChgYn == "N") {
    		
    	}else{
        	// 제로 페이나 카카오 페이인 경우에는 디폴트 IP/PORT로 결제를 했기 때문에, 다시 원래 매장 결제서버로 원복한다
    		if(payData.appType == 1 || payData.appType == 2){ // 1: 카카오, 2: 제로
    			
    			// IP,PORT 변경 공통함수 호출
    			util.fnServerIpPortChange("1", function(result){
    				util.logInfo("*****fnCallbackCancelApproval CALLBACK START*****");
    				var vsCode = result.Code;
    				if(vsCode == "0"){ // 성공
    					util.logInfo("*****fnCallbackCancelApproval CALLBACK SERVER IP/PORT CALLBACK success*****");
    				}else{ // 실패
    					util.logInfo("*****fnCallbackCancelApproval CALLBACK SERVER IP/PORT CALLBACK fail*****");
    				}
    			});
    		}
    	}
    	
    	var callbackDataValue="";
    	if(payData.PAY_TYPE_FG == "04" ){ // 제휴할인인 경우에 콜백제어    	
    		util.logInfo("*****Alliance Cancel callbackData == > " + callbackData);
    		var vsResult = JSON.parse(callbackData);
    		var vsResultCode = vsResult.ResultCode;	
    		if(vsResultCode == "0"){
    			callbackDataValue = vsResult.Data;
    		}else{
    			gfn_DbRollBack();
                gfn_DbClose();
                eventBus.$emit('alertPopup', {message: "제휴할인 승인취소에 실패하였습니다. "});
                gPayCancelExtCnt--; // 실패시에 반품 대상 처리 카운트를 차감해준다.
                return false;
    		}
    	}else if(payData.PAY_TYPE_FG == "03" ){ // MP포인트 사용 경우에 콜백제어    	
    		util.logInfo("*****MP POINT USE Cancel callbackData == > " + callbackData);    		
    		var vsResult = JSON.parse(callbackData);
    		var vsResultCode = vsResult.ResultCode;	
    		if(vsResultCode == "0"){
    			callbackDataValue = vsResult.Data;
    		}else{
    			gfn_DbRollBack();
                gfn_DbClose();
                eventBus.$emit('alertPopup', {message: "MP포인트(사용+적립) 승인취소에 실패하였습니다. "});
                gPayCancelExtCnt--; // 실패시에 반품 대상 처리 카운트를 차감해준다.
                return false;
    		}
    	}else if(payData.PAY_TYPE_FG == "07" ){ // MP포인트 적립 경우에 콜백제어    	
    		util.logInfo("*****MP POINT SAVE Cancel callbackData == > " + callbackData);
    		var vsResult = JSON.parse(callbackData);
    		var vsResultCode = vsResult.ResultCode;	
    		if(vsResultCode == "0"){
    			callbackDataValue = vsResult.Data;
    		}else{
    			gfn_DbRollBack();
                gfn_DbClose();
                eventBus.$emit('alertPopup', {message: "MP포인트(적립) 승인취소에 실패하였습니다. "});
                gPayCancelExtCnt--; // 실패시에 반품 대상 처리 카운트를 차감해준다.
                return false;
    		}
    	}else if(payData.PAY_TYPE_FG == "01" ){ // 현금영수증인 경우에 콜백제어    	
    		util.logInfo("*****현금영수증 반품 fnCallbackCancelApproval cashReceipts Refund Cancel callbackData ***** ");
    		var vsResult = JSON.parse(callbackData);
    		var vsResultCode = vsResult.ResultCode;	
    		if(vsResultCode == "0"){
    			util.logInfo("*****현금영수증 반품 fnCallbackCancelApproval vsResultCode == >> 0(성공) ");
    			callbackDataValue = vsResult.Data;
    		}else{
    			gfn_DbRollBack();
                gfn_DbClose();
                eventBus.$emit('alertPopup', {message: "현금영수증 반품에 실패하였습니다. "});
                gPayCancelExtCnt--; // 실패시에 반품 대상 처리 카운트를 차감해준다.
                return false;
    		}
    	}else if(payData.PAY_TYPE_FG == "11" ){ // 간편결제 결제취소
    		util.logInfo("*****간편결제 Cancel callbackData == > " + JSON.stringify(callbackData));
    		util.logInfo("*****간편결제 Cancel callbackData typeof == > " + typeof callbackData);
            if(payData.appType == 8){ // 페이코 결제취소
                callbackDataValue = callbackData;
                if(callbackDataValue.Status != "APPROVE"){
                    gfn_DbRollBack();
                    gfn_DbClose();
                    eventBus.$emit('alertPopup', {message: "간편결제 승인취소에 실패하였습니다. "});
                    gPayCancelExtCnt--; // 실패시에 반품 대상 처리 카운트를 차감해준다.
                    return false;
                }

            }else{
                //var vsResult = JSON.parse(callbackData);
                var vsResult = callbackData[0].value;
                
                var vsResultValue = vsResult[0];
                callbackDataValue = JSON.parse(vsResultValue);
                if(callbackDataValue.Status != "APPROVE"){
                    gfn_DbRollBack();
                    gfn_DbClose();
                    eventBus.$emit('alertPopup', {message: "간편결제 승인취소에 실패하였습니다. "});
                    gPayCancelExtCnt--; // 실패시에 반품 대상 처리 카운트를 차감해준다.
                    return false;
                }

            }
    	}else{ // 제휴할인/MP포인트가 아닌경우 콜백 제어
    		var cbResult = callbackData[0].value[0];
            util.logInfo("*****cbResult == > " + cbResult);
            if(cbResult == "CANCEL" || cbResult == "ERROR" || cbResult == "DECLINE"){
                gfn_DbRollBack();
                gfn_DbClose();
                eventBus.$emit('alertPopup', {message: "승인취소가 실패하였습니다. "});
                gPayCancelExtCnt--; // 실패시에 반품 대상 처리 카운트를 차감해준다.
                return false;
            }
            callbackDataValue = JSON.parse(cbResult);
    	}    	    	
        
        util.logDebug("&&&  fnCallbackCancelApproval callbackDataValue : " + JSON.stringify(callbackDataValue));
        util.logDebug("&&&  fnCallbackCancelApproval payData : " + JSON.stringify(payData));
        util.logDebug("&&&  fnCallbackCancelApproval callbackDataValue[Status] : " + callbackDataValue["Status"]);

        if(callbackDataValue["Status"] == "APPROVE"){

            try{

                util.logDebug("&&&  fnCallbackCancelApproval callbackDataValue[거래일시] : " + callbackDataValue["거래일시"]);
                util.logDebug("&&&  fnCallbackCancelApproval payData.PAY_TYPE_FG == > " + payData.PAY_TYPE_FG);
                if(payData.PAY_TYPE_FG == "04" || payData.PAY_TYPE_FG == "03" || payData.PAY_TYPE_FG == "07"){ // 제휴할인/MP포인트사용/MP포인트 적립인 경우에 제휴할인 취소를 한다.
                	var apprPullDate = callbackDataValue["거래일시"];
                    var apprDate = moment(apprPullDate, 'YYMMDDHHmmss').format("YYYYMMDD");
                    var apprTime = moment(apprPullDate, 'YYMMDDHHmmss').format("HHmmss");
                    
                    
                    var vsBroadMsg = "";
                    
                    if(payData.PAY_TYPE_FG == "04"){ // 제휴할인일 때
                    	vsBroadMsg = callbackDataValue["알림메세지1"] + " " + callbackDataValue["알림메세지2"] + " " + callbackDataValue["알림메세지3"]  + " " + callbackDataValue["알림메세지4"];
                    }
                    
                    if(payData.PAY_TYPE_FG == "03" || payData.PAY_TYPE_FG == "07"){ // mp포인트일 때 영수증 하단에 출력을 위한 알림메세지2, 3, 4를 개행처리하여 담는다.
                    	 // 영수증 하단에 출력을 위한 메시지를 담는다.
                        vsBroadMsg = callbackDataValue["알림메세지2"];
    					
    					if(!!callbackDataValue["알림메세지3"]){
    						if(!vsBroadMsg){
    							vsBroadMsg += callbackDataValue["알림메세지3"];
    						}else{
    							vsBroadMsg += "\r\n" + callbackDataValue["알림메세지3"];
    						}
    					}
    					
    					if(!!callbackDataValue["알림메세지4"]){
    						if(!vsBroadMsg){
    							vsBroadMsg += callbackDataValue["알림메세지4"];
    						}else{
    							vsBroadMsg += "\r\n" + callbackDataValue["알림메세지4"];
    						}
    					}
                    }
                   
                    
					var vsApprMsg = callbackDataValue["응답메세지1"] + " " + callbackDataValue["응답메세지2"];
					
                    var sqlData = [gShopCd, saleDate, gPosNo, payData.BILL_NO, inRegiSeq, apprDate, util.setEmptyStrDefault(callbackDataValue["거래일시"].substr(6,6), ""), util.setEmptyStrDefault(callbackDataValue["승인번호"], ""), util.setEmptyStrDefault(callbackDataValue["가용포인트"], "") 
                        , util.setEmptyStrDefault(vsApprMsg, ""), util.setEmptyStrDefault(callbackDataValue["거래일련번호"], ""), loginEmpInfo.EMP_NO, vsBroadMsg, gShopCd, payData.OLD_SALE_DATE, gPosNo, payData.OLD_BILL_NO, payData.OLD_LINE_NO, payData.OLD_SEQ_NO];
                    
                    var stringResult = gfn_DbExecute(adminSql.insertSslTrjcdTCancelSave, sqlData);     // 제휴할인 취소승인 후 저장
                    
                    var sqlData = [callbackDataValue["승인번호"], gShopCd, payData.OLD_SALE_DATE, gPosNo, payData.OLD_BILL_NO, payData.OLD_LINE_NO, payData.OLD_SEQ_NO];
                    var stringResult2 = gfn_DbExecute(adminSql.updateSslTrjcdTCancel, sqlData);     // 제휴할인 취소승인 후 업데이트.
                    
                    var fileName = callbackDataValue["거래일련번호"]  +"_"+ callbackDataValue["거래일시"] + ".tr";
                    util.fnDelPayInfoFile(fileName);
                        
                    if(stringResult.ResultCode == "0" && stringResult2.ResultCode == "0") {
                        gfn_DbCommit();
                        gfn_DbClose();

                        this.fnCancelApprovalSetPage(saleDate, payData);

                    }else{
                    	$("#cancelAppr").show();
                    	gPayCancelExtCnt--; // 실패시에 반품 대상 처리 카운트를 차감해준다.
                        gfn_DbRollBack();
                    }
                }else if(payData.PAY_TYPE_FG == "01"){ // 현금영수증 반품 일 때
                	util.logInfo("***** 현금영수증 반품 후 최종 저장 수행 *****");
                	var vsApprMsg = callbackDataValue["응답메세지1"] + " " + callbackDataValue["응답메세지2"];
                	var vsBroadMsg = callbackDataValue["알림메세지1"] + " " + callbackDataValue["알림메세지2"] + " " + callbackDataValue["알림메세지3"]  + " " + callbackDataValue["알림메세지4"];
                	
                	var sqlData = [gShopCd, saleDate, gPosNo, payData.BILL_NO, inRegiSeq, util.setEmptyStrDefault(callbackDataValue["거래금액"], ""),util.setEmptyStrDefault(callbackDataValue["거래일시"].substr(0,8), ""), util.setEmptyStrDefault(callbackDataValue["거래일시"].substr(6,6), ""), util.setEmptyStrDefault(callbackDataValue["승인번호"], "") 
                        , util.setEmptyStrDefault(vsApprMsg, ""), loginEmpInfo.EMP_NO, vsBroadMsg, util.setEmptyStrDefault(callbackDataValue["거래일련번호"], ""), gShopCd, payData.OLD_SALE_DATE, gPosNo, payData.OLD_BILL_NO, payData.OLD_LINE_NO, payData.OLD_SEQ_NO];
                    
                    var stringResult = gfn_DbExecute(adminSql.insertCashReceiptsRefund, sqlData);     // 현금영수증 취소승인 후 저장
                    
                    var sqlData = [callbackDataValue["승인번호"], gShopCd, payData.OLD_SALE_DATE, gPosNo, payData.OLD_BILL_NO, payData.OLD_LINE_NO, payData.OLD_SEQ_NO];
                    var stringResult2 = gfn_DbExecute(adminSql.updateSslTrcshTCancel, sqlData);     // 제휴할인 취소승인 후 업데이트.
                    
                    var fileName = callbackDataValue["거래일련번호"]  +"_"+ callbackDataValue["거래일시"] + ".tr";
                    util.fnDelPayInfoFile(fileName);
                        
                    if(stringResult.ResultCode == "0" && stringResult2.ResultCode == "0") {
                        gfn_DbCommit();
                        gfn_DbClose();

                        this.fnCancelApprovalSetPage(saleDate, payData);

                    }else{
                    	$("#cancelAppr").show();
                    	eventBus.$emit('alertPopup', {message: "승인취소에 실패했습니다. [저장오류 발생]"});
                    	gPayCancelExtCnt--; // 실패시에 반품 대상 처리 카운트를 차감해준다.
                        gfn_DbRollBack();
                    }
                } else {
                	var apprPullDate = callbackDataValue["거래일시"];
                    var apprDate = moment(apprPullDate, 'YYMMDDHHmmss').format("YYYYMMDD");
                    var apprTime = moment(apprPullDate, 'YYMMDDHHmmss').format("HHmmss");

                    var sqlData = [saleDate, payData.BILL_NO, inRegiSeq, apprDate,apprTime, util.setEmptyStrDefault(callbackDataValue["승인번호"], "")
                        , util.setEmptyStrDefault(callbackDataValue["알림메세지"], ""), util.setEmptyStrDefault(callbackDataValue["거래일련번호"], ""), loginEmpInfo.EMP_NO, util.setEmptyStrDefault(callbackDataValue["카드잔액"], "")
                        , util.setEmptyStrDefault(callbackDataValue["알림메세지1"], "") + util.setEmptyStrDefault(callbackDataValue["알림메세지2"], "") + util.setEmptyStrDefault(callbackDataValue["알림메세지3"], "") + util.setEmptyStrDefault(callbackDataValue["알림메세지"], "")
                        , util.setEmptyStrDefault(callbackDataValue["응답메세지1"], "") + util.setEmptyStrDefault(callbackDataValue["응답메세지2"], ""), gShopCd, payData.OLD_SALE_DATE, gPosNo, payData.OLD_BILL_NO
                        , payData.OLD_LINE_NO, payData.OLD_SEQ_NO];

                    util.logInfo("fnCallbackCancelApproval sqlInfo  : " + JSON.stringify(sqlData));

//                    var sqlStr = gfn_sqlBindParameters(adminSql.insertCardReturnInfo, sqlData );
//                    for(var i =0 ; sqlStr.length > i ; i+=400){
//                        util.logInfo("fnSelectList selectReceiptManagementList  : " + sqlStr.substr(i, 400));
//                    }

                    var stringResult = gfn_DbExecute(adminSql.insertCardReturnInfo, sqlData);     //카드반품정보 저장
                    
                    var sqlData = [callbackDataValue["승인번호"], gShopCd, payData.OLD_SALE_DATE, gPosNo, payData.OLD_BILL_NO, payData.OLD_LINE_NO, payData.OLD_SEQ_NO];
                    var stringResult2 = gfn_DbExecute(adminSql.updateCardReturnInfo, sqlData);     // 결제 취소승인 후 업데이트.
                    
                    var fileName = callbackDataValue["거래일련번호"]  +"_"+ callbackDataValue["거래일시"] + ".tr";
                    util.fnDelPayInfoFile(fileName);

                    util.logDebug("fnCallbackCancelApproval insertCardReturnInfo executeResult : " + JSON.stringify(stringResult));

                    if(stringResult.ResultCode == "0" && stringResult2.ResultCode == "0") {
                        gfn_DbCommit();
                        gfn_DbClose();

                        this.fnCancelApprovalSetPage(saleDate, payData);

                    }else{
                    	$("#cancelAppr").show();
                    	gPayCancelExtCnt--; // 실패시에 반품 대상 처리 카운트를 차감해준다.
                        gfn_DbRollBack();
                    }
                }
                
            }catch(e){
                util.logError("fnCallbackCancelApproval ERROR : " + e.message);
                $("#cancelAppr").show();
                gPayCancelExtCnt--; // 실패시에 반품 대상 처리 카운트를 차감해준다.
                gfn_DbRollBack();
                eventBus.$emit('alertPopup', {message: "승인취소에 실패했습니다. [오류 발생]"});
            }finally{
                gfn_DbClose();
            }
        } else {
        	$("#cancelAppr").show();
            gfn_DbRollBack();
            gPayCancelExtCnt--; // 실패시에 반품 대상 처리 카운트를 차감해준다.
            var vsMsg = "";
            if(!!callbackDataValue["응답메세지1"]){
            	vsMsg += callbackDataValue["응답메세지1"];
            }
            if(!!callbackDataValue["응답메세지2"]){
            	vsMsg += callbackDataValue["응답메세지2"];
            }
            eventBus.$emit('alertPopup', {message: "승인취소에 실패했습니다. ["+ vsMsg +"]"});
        }
        util.logInfo("&&&&&&&&&&&&&&  fnCallbackCancelApproval DB_Close");
        gfn_DbClose();
    }

    this.fnCancelApprovalSetPage = function(saleDate, payData) {
    	util.logInfo("*****fnCancelApprovalSetPage gPayCancelExtCnt == > " + gPayCancelExtCnt);
    	util.logInfo("*****fnCancelApprovalSetPage gPayCancelListCnt == > " + gPayCancelListCnt);
    	if(gPayCancelListCnt == "1") { // 마지막 1개를 수행완료한 것이기 때문에 팝업을 완료 후 팝업을 닫는다.		
    		this.fnCancelDodoPoint(saleDate, payData.OLD_BILL_NO);
    		this.fnCancelTollgate(saleDate, payData.BILL_NO, payData.OLD_BILL_NO);
    		this.fnCancelBaroda(saleDate, payData.BILL_NO, payData.OLD_BILL_NO);
    		this.fnCancelSuperCon(saleDate, payData.BILL_NO);
            aspSaleTransDataService.saleTransProcess(saleDate, payData.BILL_NO);
            $("#cancelAppr").show();
            eventBus.$emit('alertPopup', {message: "승인취소가 완료되었습니다.영수증 출력을 원할 경우 재출력 메뉴를 이용해 주세요."});
            eventBus.$emit('approveCancelComplete2');
    	} else {
    		if(gPayCancelExtCnt == gPayCancelListCnt) {
    			this.fnCancelDodoPoint(saleDate, payData.OLD_BILL_NO);
        		this.fnCancelTollgate(saleDate, payData.BILL_NO, payData.OLD_BILL_NO);
        		this.fnCancelBaroda(saleDate, payData.BILL_NO, payData.OLD_BILL_NO);
        		this.fnCancelSuperCon(saleDate, payData.BILL_NO);
        		aspSaleTransDataService.saleTransProcess(saleDate, payData.BILL_NO);
        		$("#cancelAppr").show();
                eventBus.$emit('alertPopup', {message: "승인취소가 완료되었습니다.영수증 출력을 원할 경우 재출력 메뉴를 이용 주세요."});
                eventBus.$emit('approveCancelComplete3');
    		} else {
    			$("#cancelAppr").show();
        		eventBus.$emit('alertPopup', {message: "승인취소가 완료되었습니다. 나머지 목록도 반품처리 해주세요."});
                eventBus.$emit('approveCancelComplete2');
    		}
    	}
    },


    this.fnCancelDodoPoint = function(saleDate, billNo) {

        try{
            var dodoResult = gfn_SQLiteSQLProcess(adminSql.selectSslTretcList, [gShopCd, saleDate, gPosNo, billNo]).Data;

            util.logInfo("fnCancelDodoPoint ############### dodoResult : " + JSON.stringify(dodoResult));
            if(!util.isEmpty(dodoResult) && dodoResult.length > 0){
                for(var i=0 ; dodoResult.length > i ; i++){
                    var data = dodoResult[i];
                    
                    if(data.TR_TYPE_CD == "111" || data.TR_TYPE_CD == "112") {
                    	util.logInfo("fnCancelDodoPoint data : " + JSON.stringify(data));
                    	
                    	var dodoId = data.USER_DATA;
                    	
                    	dodoId = dodoId.substring(dodoId.indexOf("^") + 1, dodoId.indexOf("|"));
                    	util.logInfo("fnCancelDodoPoint USER_DATA : " + data.USER_DATA);
                    	util.logInfo("fnCancelDodoPoint dodoId : " + dodoId);
                    	if(data.TR_TYPE_CD ==  '111'){
                    		
                    		//도도포인트 적립 승인요청 취소
                    		var saveDodoResult = dodoPointService.dodoDeleteAjaxCall({}, false, "DELETE", dodoId, "purchases");
                    	}else if(data.TR_TYPE_CD ==  '112'){
                    		//도도포인트 사용 승인요청 취소
                    		var useDodoResult = dodoPointService.dodoDeleteAjaxCall({}, false, "DELETE", dodoId, "redeems");
                    	}
                    }
                }
            }
        }catch(e){
            util.logInfo("fnCancelDodoPoint ERROR : " + e.message);

        }

    },
    this.fnCancelTollgate = function(saleDate, billNo, oldBillNo){
    	
    	try{
    		var togateResult = gfn_SQLiteSQLProcess(adminSql.selectSslTretcList, [gShopCd, saleDate, gPosNo, billNo]).Data;
    		
    		util.logInfo("fnCancelTollgate ############### togateResult : " + JSON.stringify(togateResult));
    		
    		if(!util.isEmpty(togateResult) && togateResult.length > 0){
    			for(var i=0 ; togateResult.length > i ; i++){
    				var data = togateResult[i];
    				util.logInfo("fnCancelTollgate data : " + JSON.stringify(data));
    				
    				if(data.USER_DATA.indexOf("sattlementDate") != -1) {
    					if(data.TR_TYPE_CD == "001" || data.TR_TYPE_CD == "002" || data.TR_TYPE_CD == "003" ) { //톨게이트 선불카드, 교환권일 경우에만
    						// 톨게이트 결제 정보는 etc테이블에  USER_DATA컬럼에 데이터가 가공된 상태로 저장
    						var tollgateData = data.USER_DATA.split("|");
    						
    						util.logInfo("fnCancelTollgate USER_DATA : " + data.USER_DATA);
    						util.logInfo("fnCancelTollgate tollgateData : " + tollgateData);
    						
    						var tgSignMsg = "";
    						var hash = "";
    						var hashInBase64 = "";
    						
    						if(data.TR_TYPE_CD ==  '001'){ // 톨게이트 선불카드 승인 취소
    							
//    						userData = "posOrderNo^" + orderInfo.TOLLGATE_INFO.posOrderNo + "|orderDate^" + orderInfo.TOLLGATE_INFO.orderDate 
//    						+ "|amount^" + orderInfo.TOLLGATE_INFO.amount + "|barcodeNo^" + orderInfo.TOLLGATE_INFO.barcodeNo + "|barcodeInputType^" + orderInfo.TOLLGATE_INFO.barcodeInputType 
//    						+ "|sattlementDate^" + orderInfo.TOLLGATE_INFO.sattlementDate + "|receiptNo^" + orderInfo.TOLLGATE_INFO.receiptNo 
//    						+ "|accountTransactionId^" + orderInfo.TOLLGATE_INFO.accountTransactionId + "|accountTransactionDate^" + orderInfo.TOLLGATE_INFO.accountTransactionDate;
//    						
    							//serviceId+posStoreNo+posTerminalNo+posOrderNo+orderDate+originalPosOrderNo+originalAccountTxId+originalOrderDate+originalAmount
    							var cbPosStoreNo = "KPNKIOSK" + gShopCd; 
    							var cbPosTerminalNo = gShopCd + gPosNo; 
    							var cbPosOrderNo = gShopCd + gPosNo + moment().format("YYYYMMDDHHmmss") + billNo;
    							
    							tgSignMsg = tgServiceId + ":" + gShopCd + ":" + cbPosTerminalNo + ":" + cbPosOrderNo + ":" + tollgateData[1].split("^")[1] + ":" + tollgateData[0].split("^")[1]
    							+ ":" + tollgateData[7].split("^")[1] + ":" + tollgateData[8].split("^")[1] + ":" + tollgateData[2].split("^")[1];
    							hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey);
    							hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
    							
    							util.logInfo("fnCancelTollgate ############### 선불카드 취소 tgSignMsg : " + tgSignMsg);
    							
    							let paramObj = {
									serviceId : tgServiceId
									, posStoreNo : gShopCd
									, posTerminalNo : cbPosTerminalNo
									, sign : hashInBase64
									, callbackParam : ""
									, additionalData : ""
									, posOrderNo : cbPosOrderNo
									, orderDate : tollgateData[1].split("^")[1]
	    							, originalPosOrderNo : tollgateData[0].split("^")[1]
	    							, originalAccountTxId : tollgateData[7].split("^")[1]
	    							, originalOrderDate : tollgateData[8].split("^")[1]
	    							, originalAmount : tollgateData[2].split("^")[1]
	    							, sattlementDate : tollgateData[5].split("^")[1]
    							};
    							
    							var tgTargetUrl = "/v1/gw/pos/fdk/voidRedeem.do";
    							
    							var tgCancelResult = util.ajaxCallTollgate(paramObj, tgTargetUrl);
    							util.logInfo("fnCancelTollgate ############### 선불카드 취소 tgCancelResult : " + JSON.stringify(tgCancelResult));
    							
    						} else if(data.TR_TYPE_CD ==  '002'){ //톨게이트 교환권 승인취소
    							
//    						var userData = "posOrderNo^0009|orderDate^2022-09-01T01:07:26|barcodeNo^4042888051526266|
    							//barcodeInputType^SCAN|productCode^E0000126|sattlementDate^2022-09-01|
    							//couponTransactionId^202209011307300340lp7RRG|couponTransactionDate^2022-09-01T13:07:30";
    							
    							
    							var cbPosStoreNo = "KPNKIOSK" + gShopCd; 
    							var cbPosTerminalNo = gShopCd + gPosNo; 
    							var cbPosOrderNo = gShopCd + gPosNo + moment().format("YYYYMMDDHHmmss") + billNo;
    							//serviceId+posStoreNo+posTerminalNo+posOrderNo+orderDate+originalPosOrderNo+originalCouponTxId+originalOrderDate+originalBarcodeNo
    							tgSignMsg = tgServiceId + ":" + gShopCd + ":" + cbPosTerminalNo + ":" + cbPosOrderNo + ":" + tollgateData[1].split("^")[1] 
    							+ ":" + tollgateData[0].split("^")[1] + ":" + tollgateData[6].split("^")[1] + ":" + tollgateData[7].split("^")[1] + ":" + tollgateData[2].split("^")[1];
    							hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey);
    							hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
    							util.logInfo("fnCancelTollgate ############### 교환권 취소 tgSignMsg : " + tgSignMsg);
    							
    							let paramObj = {
									serviceId : tgServiceId
									, posStoreNo : gShopCd
									, posTerminalNo : cbPosTerminalNo
									, sign : hashInBase64
									, callbackParam : ""
									, additionalData : ""
									, posOrderNo : cbPosOrderNo
									, orderDate : tollgateData[1].split("^")[1]
	    							, originalPosOrderNo : tollgateData[0].split("^")[1]
	    							, originalCouponTxId : tollgateData[6].split("^")[1]
	    							, originalOrderDate : tollgateData[7].split("^")[1]
	    							, originalBarcodeNo : tollgateData[2].split("^")[1]
	    							, sattlementDate : tollgateData[5].split("^")[1]	
    							};
    							
    							var tgTargetUrl = "/v1/gw/pos/fdk/voidUseCoupon.do";
    							
    							var tgCancelResult = util.ajaxCallTollgate(paramObj, tgTargetUrl);
    							util.logInfo("fnCancelTollgate ############### 교환권 취소 tgCancelResult : " + JSON.stringify(tgCancelResult));
    							
    							
    						} else if(data.TR_TYPE_CD ==  '003'){ //톨게이트 스탬프 적립취소
    							
//    						var userData = "posOrderNo^" + orderInfo.TOLLGATE_INFO.posOrderNo + "|orderDate^" + orderInfo.TOLLGATE_INFO.orderDate 
//    						+ "|originalPosOrderNo^" + orderInfo.TOLLGATE_INFO.originalPosOrderNo + "|originalStampTxId^" + orderInfo.TOLLGATE_INFO.originalStampTxId 
//    						+ "|originalOrderDate^" + orderInfo.TOLLGATE_INFO.originalOrderDate + "|originalStampCount^" + orderInfo.TOLLGATE_INFO.originalStampCount 
//    						+ "|sattlementDate^" + orderInfo.TOLLGATE_INFO.sattlementDate;			
    							var cbPosStoreNo = "KPNKIOSK" + gShopCd; 
    							var cbPosTerminalNo = gShopCd + gPosNo; 
    							var cbPosOrderNo = gShopCd + gPosNo + moment().format("YYYYMMDDHHmmss") + billNo;
    							
    							//serviceId+posStoreNo+posTerminalNo+posOrderNo+orderDate+originalPosOrderNo+originalStampTxId+originalOrderDate+originalStampCount
    							tgSignMsg = tgServiceId + ":" + gShopCd + ":" + cbPosTerminalNo + ":" + cbPosOrderNo + ":" + tollgateData[1].split("^")[1]
    							+ ":" + tollgateData[2].split("^")[1] + ":" + tollgateData[3].split("^")[1]+ ":" + tollgateData[4].split("^")[1]
    							+ ":" + tollgateData[5].split("^")[1];
    							
    							util.logInfo("fnCancelTollgate ############### 톨게이트 스탬프 적립취소 tgSignMsg : " + tgSignMsg);
    							
    							hash = CryptoJS.HmacSHA256(tgSignMsg, tgSecretKey);
    							hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
    							
    							let paramObj = {
									serviceId : tgServiceId
									, posStoreNo : gShopCd
									, posTerminalNo : cbPosTerminalNo
									, sign : hashInBase64
									, callbackParam : ""
									, additionalData : ""
									, posOrderNo : cbPosOrderNo
									, orderDate : tollgateData[1].split("^")[1]
	    							, originalPosOrderNo : tollgateData[2].split("^")[1]
	    							, originalStampTxId : tollgateData[3].split("^")[1]
	    							, originalOrderDate : tollgateData[4].split("^")[1]
	    							, originalStampCount : tollgateData[5].split("^")[1]
	    							, sattlementDate : tollgateData[6].split("^")[1]	
    							};

                                if(paramObj.originalStampTxId != null){
                                    var tgTargetUrl = "/v1/gw/pos/fdk/voidIssueStamp.do";                                    
                                    var tgCancelResult = util.ajaxCallTollgate(paramObj, tgTargetUrl);
                                    util.logInfo("fnCancelTollgate ############### 톨게이트 스탬프 적립취소  originalStampTxId null 적립요청 X");                                    
                                    util.logInfo("fnCancelTollgate ############### 톨게이트 스탬프 적립취소 tgCancelResult : " + JSON.stringify(tgCancelResult));
                                }
    							
    						}
    					}
    				}
    			}
    		}
    	}catch(e){
    		util.logInfo("fnCancelTollgate ERROR : " + e.message);
    		
    	}
    	
    },
    
    this.fnCancelBaroda = function(saleDate, billNo, oldBillNo){

        try{
            var barodaResult = gfn_SQLiteSQLProcess(adminSql.getBarodaUserData, [gShopCd, saleDate, gPosNo, oldBillNo]).Data;

            util.logInfo("fnCancelBaroda ############### barodaResult : " + JSON.stringify(barodaResult));
            if(!util.isEmpty(barodaResult[0].BARODA_USER_DATA)){
	            var data = JSON.parse(barodaResult[0].BARODA_USER_DATA);
	            //바로다 구독권 사용 취소
	            if(data.orderId != undefined) {
            		util.barodaAjaxCall(data, false, "PUT", "/api/subscribe/use/cancel");
	            }else {
	            	//바로다 구독권 구매 취소
	            	util.barodaAjaxCall(data, false, "PUT", "/api/subscribe/buy/cancel");
	            }
            }
        }catch(e){
            util.logInfo("fnCancelBaroda ERROR : " + e.message);

        }

    },
    
    this.fnCancelSuperCon = function(saleDate, billNo){
    	
    	try {
    		var superConResult = gfn_SQLiteSQLProcess(adminSql.selectSslTretcList, [gShopCd, saleDate, gPosNo, billNo]).Data;
    		
    		util.logInfo("fnCancelSuperCon ############### superConResult : " + JSON.stringify(superConResult));
    		
    		if(!util.isEmpty(superConResult) && superConResult.length > 0) {
    			for(var i=0 ; superConResult.length > i ; i++) {
    				util.logInfo("fnCancelSuperCon data : " + JSON.stringify(superConResult[i]));
    				
    				//기타결제 데이터를 톨게이트 테이블과 같이 가용하기 떄문에 파라미터 문자열로 체크
    				if(superConResult[i].USER_DATA.indexOf("approvalNo") != -1) {
    					if(superConResult[i].TR_TYPE_CD == "004" || superConResult[i].TR_TYPE_CD == "005" ) {
    						if(!util.isEmpty(superConResult[i].USER_DATA)) {
    							
    							var scCancelData = superConResult[i].USER_DATA.split("|");;

    							util.logInfo("fnCancelSuperCon USER_DATA : " + superConResult[i].USER_DATA);
    							util.logInfo("fnCancelSuperCon scCancelData : " + scCancelData);
    							
    							let scCancelParamObj = {
    									couponNo : scCancelData[0].split("^")[1]
										, branchId : scCancelData[1].split("^")[1]
										, branchName : scCancelData[2].split("^")[1]
										, partnerId : scCancelData[3].split("^")[1]
										, posDate : scCancelData[4].split("^")[1]
										, posTime : scCancelData[5].split("^")[1]
										, approvalNo : scCancelData[6].split("^")[1]
										, approvalYn : scCancelData[7].split("^")[1]
		    							, posType : scCancelData[8].split("^")[1]
    								};
    							
    							//슈퍼콘 쿠폰 사용 취소
    							var tgTargetUrl = "/authapi/cancel";
    							let rCancelScData = util.superConAjaxCall(scCancelParamObj, false, tgTargetUrl);
    							
    							if(rCancelScData.resultCode != "0000") { // 슈퍼콘 쿠폰사용실패!! 
    								util.logInfo("################### fnSuperConCancel fail #################");
    								eventBus.$emit('alertPopup', {message: "슈퍼콘 쿠폰 사용 취소가 실패하였습니다. 관리자에게 문의하세요."});
    							} else {
    								util.logInfo("################### fnSuperConCancel success #################");
    							}
    						}
    					}
    				}
    			}
    		}
    	} catch(e) {
    		util.logInfo("fnCancelBaroda ERROR : " + e.message);
    		
    	}
    	
    },
	
    //상품관리 스타일 적용 jean43069
    this.fnProdSelectAllCloseStyle = function(elmnt){
        /*a function that will close all select boxes in the document, except the current select box:*/
        var x, y, i, xl, yl, arrNo = [];
        x = document.getElementsByClassName("select-items");
        y = document.getElementsByClassName("select-selected");
        xl = x.length;
        yl = y.length;
        for (i = 0; i < yl; i++) {
            if (elmnt == y[i]) {
                arrNo.push(i)
            } else {
                y[i].classList.remove("select-arrow-active");
            }
        }
        for (i = 0; i < xl; i++) {
            if (arrNo.indexOf(i)) {
                x[i].classList.add("select-hide");
            }
        }
    }
    
    // 마스터 수신정보
	this.fnMasterDataReceive = function () {
		
		var resultData = gfn_SQLiteSQLProcess("SELECT * FROM RECV_SEQ_T" , []);
		//this.validDbData(resultData , '초기 정보 확인 실패<br /><br />관리자에게 문의하여 주십시오.<br />마스터 정보 수신 오류.');
	
		if ( resultData == null || resultData.ResultCode != '0'  ) {
			return;
		}
	
		var rows = resultData.Data;
		if ( rows == undefined || rows == null || rows.length == 0  ) {
			return;
		}
		var dataJson = {};
		rows.forEach( e => {
			dataJson["_" + e.REQT_NM] = e.LAST_SEQ;
		}) ;
	
	    var url = '/SvrApp/MS000.do';
	    var params ={"TSP-NVP" 
	    				:{
	    					"TXJM-FD" :{"_SRID":"MS000", "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" 
	   					 	,	"DATA-HD":{   "_POS_NO" 		: gPosNo
	   					 					, "_SHOP_CD"		: gShopCd
	   					 					, "_IMG_FILE_NAME"	: "" //공백으로 처리.(2020.07.31 최광림 차장 confirm)
	   					 					, "_IMG_FILE_VER" 	: "" //공백으로 처리.(2020.07.31 최광림 차장 confirm)
	   					 					,  "DATA-DT"		: dataJson
	   					 		}
	    					}
	    					
	    				}
	    			};
	    var x2js = new X2JS();
	    var xmlParam = x2js.json2xml_str(params);
	
		var r = telegram.tlgmCall( XML_PI + xmlParam , url );
		r = x2js.xml_str2json(r);
		if ( r == null || r["TSP-NVP"]["TXJM-FD"]["_RETCD"] != '0000' ) {
			console.error("MS001 result error " + JSON.stringify(r["TSP-NVP"]));
			return;
		}
	
		var tlgmDt = r["TSP-NVP"]["TXJM-FD"]["DATA-HD"]["DATA-DT"];
		util.logInfo(JSON.stringify(tlgmDt));
	
		for ( var i = 0 ; i < rows.length ; i++ ) {
			var row = rows[i];
			//2020.07.30 10:48 최광림 차장 요청(LAST_SEQ 가 0 일때 실행하지 않는다.
			var tlgmSeqVal = tlgmDt["_" + row.REQT_NM];
	
			if (undefined == tlgmSeqVal || '0' == tlgmSeqVal ) {
				continue;
			} 
			
			util.logInfo("***** fnMasterDataReceive MS001 REQT_ID == > " + row.REQT_ID);
			//REQ_ID 에 '0' 붙이는 것은 전문의 요청을 의미함.
			var r = aspData.receiveAspData(row.REQT_ID  + "0", row.LAST_SEQ , row );//1. success , 2 last_seq
		}
	}
	this.fnRecvSalesDataPre = function(fnc, diffDateList ) {
		//console.log();
		try {
			window.setTimeout(() =>  {
				adminService.fnRecvSalesData(fnc, diffDateList );
				//this.diffDateList = [];//자료수신이 끝나면 초기화 처리.
			}, 500);
		} catch (e) {
			util.logError(e);
		}
	}
    this.fnRecvSalesData = function(fnc, diffDateList ) {
		for ( var i = 0 ; i < diffDateList.length ; i++ ) {
			var x = diffDateList[i];
    		//Normal(자동매출)
			var minBill = parseInt( x._NORMAL_BILL_MIN ) ;
			var maxBill = parseInt( x._NORMAL_BILL_MAX ) ;
			var loopCnt = parseInt( x._NORMAL_BILL_CNT ) ;

			if ( loopCnt != 0  ) {
				for ( var j = minBill ; j <= maxBill ; j++ ) {
					var b = (j+ "").padding(4, '0');
					aspData.receiptCheckAspData( "SI010" , x.SALE_DATE , b ) ;// 영수증 조회 전문호출
				}
			}

			//TMP (수기매출)
			minBill = parseInt( x._TMP_BILL_MIN ) ;
			maxBill = parseInt( x._TMP_BILL_MAX ) ;
			loopCnt = parseInt( x._TMP_BILL_CNT ) ;
			if (loopCnt != 0 ) {
				for ( var j = minBill ; j <= maxBill ; j++ ) {
					var b = (j+ "").padding(4, '0');
					aspData.receiptCheckAspData( "SI010" , x.SALE_DATE , b ) ;// 영수증 조회 전문호출
				}
			}

		}//end for
		diffDateList = [];//자료수신이 끝나면 초기화 처리.
		fnc();
		$(".loadingCon").hide();
    }
}

