/****************************************************************************************************************************************************************
 * 1.	SCD_SETUP_T 테이블이 없거나, 해당 테이블에 SHOP_CD, POS_NO 가 없는 경우 최초 테이블을 생성 하고 설치 인증 화면으로 이동
 * 2.	설치 인증 완료 후 버전 비교 하여 업데이트 프로그램이 있는 경우 업데이트 진행 ( TMS 기능 완료 후 작업 )
 * 3.	SCD_SETUP_T 에 저장된 SHOP_CD 와 POS_NO를 공통 변수에 삽입 하고 해당 값을 기준으로 마스터 수신
 * A.	각 마스터에 해당 하는 최종 SEQ No 를 쿼리함.
 * SELECT REQT_ID ,REQT_NM ,LAST_SEQ ,REQT_RM
 * FROM RECV_SEQ_T
 * ORDER BY RECV_ID
 * B.	검색된 REQT_ID ,REQT_NM ,LAST_SEQ ,REQT_RM 기준으로 MS000 전문 생성
 * C.	전문 별 응답을 받은 후 DB에 저장함.
 * D.	저장된 마지막 SEQ를 RECV_SEQ_T 테이블에 업데이트 함.
 *
 * 4.	마스터 수신이 이상 없이 완료 되었을 경우 로그인 화면으로 이동 함.
 ****************************************************************************************************************************************************************/
var AdminInitService = function () {
	let macAddress = "";
	
	this.adminInitComponent = function() {
		let x2js = new X2JS();
		let tmp  = {
			  template : '#adminInit'
			, data : function () {
				var obj = {};
				obj.setup = {};
				obj.intervalId="";
				obj.resultDataSetupT = {};
//				obj.retryCnt = 0;
				//obj.macAddress = "";
				return obj;				
			}
			, created : function () {
				util.logInfo('admin init service created');
			}
			,
			 beforeDestroy () {
				util.logInfo("admin init service  beforeDestory");
			}
			, destory : function () {
				util.logInfo("admin init service  destory");

			}
			, mounted : function () {
				util.logInfo("admin init service  mounted");
				sessionStorage.clear();//세션 초기화
//				initalizeSQLiteGateWay();//SQL 사용을 위해  처리.(tizen)
				// 문구 변경을 위해서 타임아웃 0.1초 설정
				$("#txtProcess").text("MAC ADRESS 확인 중.. [10%]");
				setTimeout(this.preProcess , 3000);//오류시 Layer component 가 생성되지 않아서 3초 정도 흐른뒤에 본작업을 수행한다.
			}

			, methods : {
				preProcess : function() {
					util.logInfo("*****preProcess START*****");
					//mac address 가져오기.
					if ( util.isTizen() == true) {
						try {
							//주방프린터 폴더 생성.
							let kitchFolder = '/opt/usr/home/owner/content/Downloads/FirstKIOSK/ETC';//KitchenPrt
							util.makeDirectory (kitchFolder , 'KitchenPrt');
						} catch (e) {
							
						}
						tizen.systeminfo.getPropertyValue('ETHERNET_NETWORK', this.preProcessCallback );
					} else {
						let data = {};
						data = {
								"macAddress" : "win mac address"
						}
						this.preProcessCallback(data);
					}
				}
				,
				preProcessCallback : function(data) {
					util.logInfo("*****preProcessCallback START*****");
					try {						
						macAddress = data.macAddress; 
						//alert('macAddress : ' + macAddress );
					} catch (e) {
						macAddress = "mac address(fail)";
						util.logError("mac address not receive....")
					}
					// 문구 변경을 위해서 타임아웃 0.1초 설정
					$("#txtProcess").text("DB 및 UPDATE 확인 중.. [30%]");
					setTimeout(this.initProcess , 100);
				}
				,
				initProcess : function () {
					util.logInfo("*****initProcess START*****");
					var result =  "";
					try {
						result = this.initTableCheckSQL();

						if ( result === '0') {
							this.$router.push({ path: '/auth' });
							return;
						}

					} catch (e) {
						util.logError("*****initProcess 초기 테이블 정보 확인 Catch START*****");
						// 관리자 로그인 화면으로 넘어갈 수 있도록 Y로 변경(해당 변수는 대기화면 이미지/동영상 다운로드가 오래 걸려  다운로드처리가 끝날 때까지 대기하다가 Y로 바뀌면 로그인화면으로 전환하기 위함)
						gvInitEndYnVideo = "Y";
						gvInitEndYnImg = "Y";
						gvInitLogoImgEndYn = "Y";
//						gvInitEndYn = "Y"; // 관리자 로그인 화면으로 넘어갈 수 있도록 Y로 변경(해당 변수는 대기화면 이미지/동영상 다운로드가 오래 걸려  다운로드처리가 끝날 때까지 대기하다가 Y로 바뀌면 로그인화면으로 전환하기 위함)
						util.logError("*****initProcess 초기 테이블 정보 확인 Catch e.toString() == > " + e.toString());
						
						if (typeof tizen != "undefined") {					
							if ( window.b2bapis == undefined) {
								util.logError("*****initProcess 초기 테이블 정보 확인 Catch window.b2bapis가 undefined일 때 *****");
								// Paper Plugin 오류시 재시작한다.(url replace 처리)
								let obj = {
										  //message : "Tizen PP Plug in loading fail."
										  message : "DB접속에 문제가 있습니다. [b2bapis]"
										, messageType : "alert"
									};
								util.logInfo("*****initProcess 초기 테이블 정보 확인 Catch 메시지 obj == >> " + JSON.stringify( obj ));
								this.$root.$emit( "notiMessage" ,   obj  );
								return;
							}
						}
						
//						if(this.retryCnt < 3){
//							util.logError("*****initProcess DB Connection Fail Retry Start retryCnt == > " + this.retryCnt);
//							this.retryCnt++;
//							setTimeout(this.initProcess , 1000);
//							return;
//						}
//						location.href = './admin.html';
//						return;
						util.logError("*****initProcess 초기 테이블 정보 확인 Catch window.b2bapis는 존재함. *****");
						let obj = {
								  message : "DB접속에 문제가 있습니다."
								, messageType : "alert"
							};						
						util.logInfo("*****initProcess 초기 테이블 정보 확인 Catch 메시지 obj ==>> " + JSON.stringify( obj ));
						this.$root.$emit( "notiMessage" ,   obj  );

						return;
					}
					
					util.logInfo("TMS 체크 Start(필수 아님) : " + KIOSK_VER_SEQ);
					try {
						util.logInfo("*****tmsUpdateDownload START*****");
						var x2js = new X2JS();
						this.tmsUpdate(x2js);						
						let restartFg = this.tmsUpdateDownload(x2js);
//						let restartFg = "NetworkError";
						util.logInfo('*****initProcess tmsUpdateDownload restartFg ==>>>  ' + restartFg);
						
						let rows = this.resultDataSetupT.Data;
						let posNo = rows[0].POS_NO ; // 현재 기기의 포스번호
						util.logInfo("*****initProcess mainPosNo == > "+  mainPosNo + " / posNo == > " + posNo + " / MAIN_IP == > " + rows[0].MAIN_IP);
						if ( mainPosNo != posNo  && util.GetEnvXmlShopENV(528) == 0 && rows[0].MAIN_IP != "localhost"  ) {
							util.logInfo("*****initProcess This is relation START*****");
							// 서버문제나 네트워크 에러인 경우에 해당 메시지로 리턴받게 해놓았음.
							if(restartFg == "timeout" || restartFg == "NetworkError"){
								$('#initPopup').show();
								$('#initLoader').hide();
//								if(restartFg == "timeout"){
									$('#initTxt').text("메인 POS 통신에 실패했습니다.");
									$('#initTxt2').text("인터넷 및 메인 POS를 확인하세요.");
//								}else{
//									$('#initTxt').text("메인 POS 통신에 실패했습니다.");
//									$('#initTxt2').text("인터넷 및 메인 POS를 확인하세요.");
//								}
								var vnIntervalCount = 20;
								function fnInterval(){
									vnIntervalCount--;
									$('#initTxt3').text(vnIntervalCount + "초 후에 재시작 합니다.");
									if(vnIntervalCount == 0){
										window.parent.onload();
//										location.href = './admin.html';
									}
								}
								util.logInfo("*****initProcess START INTERVAL *****");
								this.intervalId = setInterval(fnInterval, 1000);
				    			return;
				    		}
						}
						
						
						if ( restartFg == true ){
							util.logInfo('*****tms restartFg from true...end...*****');
							let obj = {
									  message : "업데이트 중입니다. 잠시만 기다려 주세요."
									, messageType : "alert"
								};
								this.$root.$emit( "notiMessage" ,   obj  );
							return;
						}
					} catch (e) {
						util.logError("*****tmsUpdateDownload Catch START*****");
						// 관리자 로그인 화면으로 넘어갈 수 있도록 Y로 변경(해당 변수는 대기화면 이미지/동영상 다운로드가 오래 걸려  다운로드처리가 끝날 때까지 대기하다가 Y로 바뀌면 로그인화면으로 전환하기 위함)
						gvInitEndYnVideo = "Y";
						gvInitEndYnImg = "Y";
						gvInitLogoImgEndYn = "Y";
						util.logError(e);
					}

					util.logInfo("TMS 체크 End (필수 아님) : " + KIOSK_VER_SEQ);

					util.logInfo('마스터 정보 수신(필수 아님.)');
					
					// 문구 변경을 위해서 타임아웃 0.1초 설정
					$("#txtProcess").text("마스터 데이터 및 상품 이미지 수신 중.. [50%]");
					setTimeout(this.masterDataCall, 100);
				}
				,
				masterDataCall : function(){
					util.logInfo("*****masterDataCall START*****");
					try {
						this.masterDataReceive();
					} catch (e) {
						util.logError("*****masterDataCall Catch START*****");
						// 관리자 로그인 화면으로 넘어갈 수 있도록 Y로 변경(해당 변수는 대기화면 이미지/동영상 다운로드가 오래 걸려  다운로드처리가 끝날 때까지 대기하다가 Y로 바뀌면 로그인화면으로 전환하기 위함)
						gvInitEndYnVideo = "Y";
						gvInitEndYnImg = "Y";
						gvInitLogoImgEndYn = "Y";
//						gvInitEndYn = "Y"; 
						util.logError("*****마스터 수신 실패*****");
						util.logError("e ==> " + e);
						util.logError("e.toString == > " + e.toString());
						if ( e.toString().indexOf("NetworkError") != -1 || gErrorMsg.indexOf("NetworkError") != -1) {
							util.logError("*****masterDataCall Catch if START*****");
							var obj = {
									  message : "네트워크 문제로 인해 최신 데이터 수신에 실패하였습니다. 인터넷 상태를 확인해 주세요."
									, messageType : "alert"
							};
							alert(obj.message);
							//this.$root.$emit( "notiMessage" ,   obj  );
							//return;
						}else{
							util.logError("*****masterDataCall Catch else START*****");
							var obj = {
									  message : e.toString()
									, messageType : "alert"
							};
							alert("오류가 발생하여 최신 데이터 수신에 실패하였습니다. [" + obj.message + "]");
							//this.$root.$emit( "notiMessage" ,   obj  );
						}
					}
					// 문구 변경을 위해서 타임아웃 0.1초 설정
					$("#txtProcess").text("매장정보 인증 및 대기 영상 수신 중.. [75%]");
					setTimeout(this.masterDataAfterCall, 100);
				}
				,
				masterDataAfterCall : function(){
					util.logInfo("*****masterDataAfterCall START*****");
					/******************************************************************************************
					 * app 초기 로딩시 필수 작업 실행
					 ******************************************************************************************/
					if ('1' !==  this.setShopInfoMustBeRequire() ) {
						util.logInfo("*****masterDataAfterCall this.setShopInfoMustBeRequire Not 1 START*****");
						// 관리자 로그인 화면으로 넘어갈 수 있도록 Y로 변경(해당 변수는 대기화면 이미지/동영상 다운로드가 오래 걸려  다운로드처리가 끝날 때까지 대기하다가 Y로 바뀌면 로그인화면으로 전환하기 위함)
						gvInitEndYnVideo = "Y";
						gvInitEndYnImg = "Y";
						gvInitLogoImgEndYn = "Y";
						return;
					}

					try {
						util.logInfo("*****masterDataAfterCall this.sendTlgmCt030 Before*****");
//						setTimeout(this.sendTlgmCt030 , 100);						
						this.sendTlgmCt030();/** 성공유무에 구분 없이 다음 JOB 실행 **/
					} catch (e) {
						util.logError("*****masterDataAfterCall this.sendTlgmCt030 Catch START*****");
						// 관리자 로그인 화면으로 넘어갈 수 있도록 Y로 변경(해당 변수는 대기화면 이미지/동영상 다운로드가 오래 걸려  다운로드처리가 끝날 때까지 대기하다가 Y로 바뀌면 로그인화면으로 전환하기 위함)
						gvInitEndYnVideo = "Y";
						gvInitEndYnImg = "Y";
						gvInitLogoImgEndYn = "Y";
						util.logInfo("인증정보 수신 중에 에러가 발생했습니다. [" + e.toString() + "]");
						util.logError("CT 030 error " + e.toString());
					}

					//TODO 마감정보 설정 { 메인 포스 NO. , 현재 영업일 , MAIN_POS_마감상태 , 현재 POS 마감 차수, 현재 POS 마감 현황)
//					$("#txtProcess").text("영업 상태 확인 중..");
//					setTimeout(this.setCloseInitData , 100);
					util.logInfo("*****masterDataAfterCall this.setCloseInitData Before*****");
					this.setCloseInitData();
					///sessionStorage.setItem("MAIN_POS_NO"             , mainPosNo              ); //MAIN POS NO
					//sessionStorage.setItem("SALE_DATE"               , saleDate               ); //영업일
					sessionStorage.setItem("MAIN_POS_CLOSE_FG"       , inMainRegiFg           ); //MAIN_POS_마감 상태
					//sessionStorage.setItem("IN_REGI_SEQ"             , inRegiSeq              );//현재 POS 마감 차수
					//sessionStorage.setItem("IN_REGI_FG"              , inRegifg               );//현재 POS 마감 현황
					//모든게 정상적으로 처리 되었다면 Login 화면으로 이동.
					util.logInfo("*****masterDataAfterCall this.adminLoginGo Before*****");
					this.adminLoginGo(); // 로그인화면으로 이동.
					return;
				}
				,
				adminLoginGo : function(){
					util.logInfo("***** adminLogin GO !!!! if Start Self Function Call gvInitEndYnVideo == > " + gvInitEndYnVideo + ", gvInitEndYnImg == > " + gvInitEndYnImg + ", gvInitLogoImgEndYn == > "+ gvInitLogoImgEndYn);
					if(gvInitEndYnVideo == "N" || gvInitEndYnImg == "N" || gvInitLogoImgEndYn == "N"){
						setTimeout(this.adminLoginGo,1000);
					}else{
						util.logInfo("***** adminLogin GO !!!! else Start router Before *****");
						setTimeout(this.$router.push({ path : '/adminMain/adminLogin' }),4000); // 4초 후 로그인 화면 이동.
					}								
				},
				/******************************************************************************************
				 * TMS UPDATE Start DN100
				 ******************************************************************************************/
				tmsUpdate : function(x2js) {
					util.logInfo("***** tmsUpdate Start*****");
					let _verSeq = KIOSK_VER_SEQ;
					let url = '/SvrApp/DN000.do';

					if( this.setup.KIOSK_VER_SEQ != KIOSK_VER_SEQ ) {
						//_verSeq = this.setup.KIOSK_VER_SEQ;
					} else {

						util.logInfo("버전이 동일하기 때문에 전송하지 않는다.");
						return;
					}

					util.logInfo('setup row : ' + JSON.stringify(this.setup));
					let params = {} ,  xmlParam , r ;
					params ={"TSP-NVP" 
		    				:{
		    					"TXJM-FD" :{"_SRID":"DN100", "_RETCD":"0000", "_KIOSK_REQ_YN":"Y"  
		   					 	,	"DATA-HD":{   "_POS_NO" 		: gPosNo //'03'
		   					 					, "_SHOP_CD"		: gShopCd
		   					 					, "_VER_SEQ"		: _verSeq
		   					 		}
		    					}
		    				}
		    			};

				    xmlParam = x2js.json2xml_str(params);
					r = telegram.tlgmCall( XML_PI + xmlParam , url );
					r = x2js.xml_str2json(r);
					util.logInfo("DN100 " +  JSON.stringify( r ));

					if ( r == null || r["TSP-NVP"]["TXJM-FD"]["_RETCD"] != '0000' ) {
						util.logError("***** tmsUpdate Not 0000*****");
						util.logInfo(JSON.stringify(  r["TSP-NVP"]["TXJM-FD"] ) );
						util.logInfo(r["TSP-NVP"]["TXJM-FD"]["_RETCD"]);
						util.logError("MS001 result error " + JSON.stringify(r["TSP-NVP"]));
						return;

					}
					util.logInfo("***** tmsUpdate 0000 Start*****");
					//var tlgmHd = r["TSP-NVP"]["TXJM-FD"]["DATA-HD"];
					let tlgmHd = r["TSP-NVP"]["DATA-HD"];
					util.logInfo('DN100 - tlgmHd' + JSON.stringify( tlgmHd));

					//update SCD_SETUP_T 한다.(comm.val.js -> KIOSK_VER_SEQ)
					gfn_SQLiteSQLProcess("UPDATE SCD_SETUP_T SET KIOSK_VER_SEQ = ? " , [KIOSK_VER_SEQ]);

				}

				/******************************************************************************************
				 * TMS UPDATE Start DN090
				 ******************************************************************************************/
				, tmsUpdateDownload : function(x2js) {
					util.logInfo("***** tmsUpdateDownload Start*****");
					return aspData.tmsUpdateDownLoad(true, x2js);
				}
				/******************************************************************************************
				 * TMS UPDATE End
				 ******************************************************************************************/

				,
				/******************************************************************************************
				 * 초기 테이블 정보 확인 및 가맹점 정보 설정.
				 ******************************************************************************************/
				 initTableCheckSQL : function() {
					util.logInfo("*****initTableCheckSQL 초기 테이블 정보 확인  Start*****");
					let sql = "SELECT * FROM SCD_SETUP_T";
					this.resultDataSetupT = gfn_SQLiteSQLProcess(sql, []);										
					
					if ( this.resultDataSetupT !=  null && this.resultDataSetupT.ResultCode == '0' ) {
						util.logInfo("***** initTableCheckSQL 초기 테이블 정보 확인 setup_t 조회 성공*****");
						dbtableAlter.alterTable();
						let rows = this.resultDataSetupT.Data;
						if ( rows == undefined || rows == null || rows.length == 0  ) {
							util.logInfo("***** initTableCheckSQL 초기 테이블 정보 확인 setup_t 조회 성공 > 결과값이 null 또는 0개임. *****");
							return '0'
						} else {
							util.logInfo("***** initTableCheckSQL 초기 테이블 정보 확인 setup_t 조회 성공 > 결과값이 있음. *****");
							this.setup = rows[0];
							let shopCd = rows[0].SHOP_CD;
							let posNo = rows[0].POS_NO ;
							let empNo = rows[0].EMP_NO  ;
							sessionStorage.setItem("SHOP_NO" ,shopCd);
							sessionStorage.setItem("POS_NO"  , posNo );
							sessionStorage.setItem("INIT_EMP_NO"  ,  empNo );
							gShopCd = shopCd ;
							gPosNo  = posNo  ;

							util.fnSetGlobalVariable();							
							//let mainIp = rows[0].MAIN_IP;
							util.logInfo("***** initTableCheckSQL 초기 테이블 정보 확인 setup_t 조회 성공 > 결과값이 있음 > fnSetGlobalVariable 후 *****");
							if ( mainPosNo != gPosNo  && util.GetEnvXmlShopENV(528) == 0 && rows[0].MAIN_IP != "localhost"  ) {
								apiUrl = aspUrl = 'http://' + rows[0].MAIN_IP + ':2006' ;
							}
							
							//정상적인것이다.
							return '1';
						}
					} else {
						util.logError("***** initTableCheckSQL 초기 테이블 정보 확인 setup_t 조회 실패 (테이블이 정보가 없거나 결과 코드가 0이 아님) *****");
						util.logInfo("***** initTableCheckSQL createTable 호출 전.*****");
						dbtableinit.createTable();
						return '0';
					}
				}
				,
				setCloseInitData : function () {
					util.logInfo("***** setCloseInitData Before*****");
					saleDate     = "" ; //현재 영업일
					inMainRegiFg = "0";  //MAIN_POS_마감 상태

					//GetEnvXmlShopENV
					var sql = ""
						+ "\n   SELECT MS.ENV_SET_CD   AS ENV_SET_CD                  "
						+ "\n        , MS.ENV_SET_VAL  AS ENV_SET_VAL                 "
						+ "\n        , MS.ENV_SET_NM   AS ENV_SET_NM                  "
						+ "\n        , DT.ENV_VAL_NM   AS ENV_VAL_NM                  "
						+ "\n     FROM ( SELECT HD.ENV_SET_CD                         "
						+ "\n               , HD.ENV_SET_NM                           "
						+ "\n               , SH.ENV_SET_VAL                          "
						+ "\n          FROM ( SELECT ENV_SET_CD                       "
						+ "\n                      , ENV_SET_NM                       "
						+ "\n                 FROM CCD_ENVHD_T                        "
						+ "\n                WHERE ENV_SET_FG IN ( '0','1','2', '5' ) "
						+ "\n                 AND   USE_YN     = 'Y' ) HD             "
						+ "\n               LEFT OUTER JOIN SCD_ENVSH_T SH            "
						+ "\n               ON  SH.SHOP_CD    =  ?                    "
						+ "\n               AND SH.USE_YN     = 'Y'                   "
						+ "\n               AND SH.ENV_SET_CD = HD.ENV_SET_CD ) MS    "
						+ "\n        LEFT OUTER JOIN ( SELECT ENV_SET_CD              "
						+ "\n                               , ENV_VAL_CD              "
						+ "\n                               , ENV_VAL_NM              "
						+ "\n                          FROM CCD_ENVDT_T ) DT          "
						+ "\n        ON  DT.ENV_SET_CD = MS.ENV_SET_CD                "
						+ "\n        AND DT.ENV_VAL_CD = MS.ENV_SET_VAL               "
						+ "\n   WHERE MS.ENV_SET_CD = ?                               "
						+ "\n   ORDER BY MS.ENV_SET_CD                                "
						;
					var result = gfn_SQLiteSQLProcess(sql , [gShopCd , '528']); //매장통합DB운영
					try {
						util.logInfo("(연동형 일 때 Main POS의 번호를 확인 후 Main의 마감 상태를확인 해야 함)매장통합DB운영 " + JSON.stringify(result));

						var rows = result.Data;
	
						if ( !util.isEmpty (result ) && result.length != 0 && !util.isEmpty( result.Data ) && result.Data.length != 0  ) {

							util.logInfo("매장통합DB운영 " + JSON.stringify(rows));
							var val = rows[0].ENV_SET_VAL;
							if ( val === '0') {
								sql = ""
									+ "\n  SELECT POS_NO    /** Main Pos 조회***/            "
									+ "\n    FROM SCD_ENVPS_T           "
									+ "\n   WHERE SHOP_CD     =  ?      "
									+ "\n     AND ENV_SET_CD  = '205'   "
									+ "\n     AND ENV_SET_VAL = '1'     "
		
									result = gfn_SQLiteSQLProcess(sql , [gShopCd ]); //매장통합DB운영

									if ( !util.isEmpty (result ) && result.length != 0 && !util.isEmpty( result.Data ) && result.Data.length != 0  ) {
										rows = result.Data;
										mainPosNo = rows[0].POS_NO ; //메인 POS NO
									}

							}  else {
								util.logInfo("***** setCloseInitData else mainPosNo = gPosNo *****");
								mainPosNo = gPosNo ;//메인 POS NO

							}

							/*********************** 현재 영업일 , MAIN POS 마감 상태 Start ************************************/
							sql = ""
								+ "\n   SELECT SALE_DATE                           "
								+ "\n        , CLOSE_FG                            "
								+ "\n     FROM POS_REGIS_T                         "
								+ "\n    WHERE SHOP_CD  = ?                        "
								+ "\n      AND POS_NO   = ?   /** MAIN POS NO **/  "
								+ "\n      AND REGI_SEQ = '00'                     "
								+ "\n    ORDER BY SALE_DATE DESC                   "
								+ "\n    LIMIT 1                                   "
								;

							result = gfn_SQLiteSQLProcess(sql , [gShopCd , mainPosNo ]);
							if ( !util.isEmpty (result ) && result.length != 0  ) {

								rows = result.Data;

								if ( !util.isEmpty(rows) && rows.length !== 0 ) {
									saleDate     = rows[0].SALE_DATE; //현재 영업일
									inMainRegiFg = rows[0].CLOSE_FG;  //MAIN_POS_마감 상태

								}
							}

							/*********************** 현재 영업일 , MAIN POS 마감 상태 End ************************************/

						} else {
							util.logInfo('*****setCloseInitData else 매장관련 마감환경정보 없음.*****');
							//매장관련 마감정보 없음.
						}


						/*********************** 현재 POS의 개점 정보를 가져옮 Start ************************************/
						try {
							let row = util.shopOpenInfo();
							inRegiSeq = row.REGI_SEQ; //현재 POS 마감 차수.
							inRegifg = row.CLOSE_FG; //현재 POS 마감 현황.
						} catch (e) {
							util.logError(e);
						}

						/*********************** 현재 POS의 개점 정보를 가져옮 End ************************************/


						
						if ( !util.isEmptyStr( saleDate ) ) {
							util.logInfo('영업일자 있다...' + saleDate);
							return;
						}
						// 재설치시 매출 Tr Down. 2020.10.22 추가.
						adminInitService.SetMakeSendXmlData_SI380();					
					} catch (e) {
						util.logError("매장관련 마감환경정보 처리중 오류 : " + e.toString());
						return ;
					}
				}
				,
				validDbData : function (r , msg) {
					util.logInfo("*****validDbData Start*****");
					if ( r== null || r.ResultCode != '0'  ) {
						util.logInfo("*****validDbData if Start*****");
						util.logError(JSON.stringify(r));
						if ( util.isEmptyStr(msg)) {
							msg = "초기 정보 확인 실패<br /><br />관리자에게 문의하여 주십시오.<br /> DB 접속에 문제가 있습니다.<br />"
						}

						throw {
							  message : msg  
							, messageType : 'alert'
						}
					}
				}
				,
				/***********************************************************************
				 * SHOP 정보 조회
				 ***********************************************************************/
				setShopInfo : function () {
					util.logInfo("*****setShopInfo Start*****");
					var resultData = gfn_SQLiteSQLProcess("SELECT * FROM SCD_SHOPM_T WHERE SHOP_CD = ? " , [gShopCd]);
					this.validDbData(resultData , '초기 정보 확인 실패<br /><br />관리자에게 문의하여 주십시오.<br />가맹점 정보 조회중에 오류가 발생하였습니다.');

					if ( resultData.Data != null && resultData.Data.length != 0  ) {
						var row = resultData.Data[0];
						if ( row.HD_SHOP_CD == "0000" ){
							row.HD_SHOP_CD = gShopCd ;
						} 
						SHOP_INFO = util.clone(row);
						
						SHOP_INFO.CHG_BILL_NO_VAL = util.GetEnvXmlShopENV(152);
		        		if ( util.byteLen(SHOP_INFO.CHG_BILL_NO_VAL) == 0 )
		        			SHOP_INFO.CHG_BILL_NO_VAL = "0";

		        		//사이드메뉴 선택 옵션 
		        		//0 : 단일 선택 ( 기본값) , 1 : 멀티선택, 2: 단일선택 필수 , 3 : 멀티선택 필수
		        		SHOP_INFO.SIDE_SEL_OPTION = util.GetEnvXmlShopENV(532);
		        		if ( util.byteLen(SHOP_INFO.SIDE_SEL_OPTION) == 0 )
		        			SHOP_INFO.SIDE_SEL_OPTION = "0";
		        		
		        		//매장 스타일 
		        		SHOP_INFO.SHOP_TYPE = util.GetEnvXmlShopENV(829); // 주문전용 키오스크 사용 여부 (0:미사용, 1:사용)
		        		if ( util.byteLen(SHOP_INFO.SHOP_TYPE) == 0 )
		        			SHOP_INFO.SHOP_TYPE = "0";
		        		
		        		//매장 쿠폰사용유무 
		        		SHOP_INFO.COUPON_VAL = util.GetEnvXmlShopENV(282);
		        		if ( util.byteLen(SHOP_INFO.COUPON_VAL) == 0 )
		        			SHOP_INFO.COUPON_VAL = "0";
		        		
		        		/** 사업자 과세 구분 0 : 별도, 1 : 포함. **/
		        		SHOP_INFO.VAT_CD = util.GetEnvXmlShopENV(128);
		        		if ( util.byteLen(SHOP_INFO.VAT_CD) == 0 )
		        			SHOP_INFO.VAT_CD = "1";
		        		
		        		//포인트매장 옵션
		                //1 : FirstPoint , 2 : DodoPoint
		                SHOP_INFO.POINT_CO_VAL = util.GetEnvXmlShopENV(109);
		                //SHOP_INFO.POINT_CO_VAL = "2";
		                if ( util.byteLen(SHOP_INFO.POINT_CO_VAL) == 0 )
		                    SHOP_INFO.POINT_CO_VAL = "0";

		                if(SHOP_INFO.POINT_CO_VAL == "2") {
		                	var dodoUuid1 = util.GetEnvXmlShopENV(826);
		                	sessionStorage.setItem("DODO_UU_ID"  , dodoUuid1);

		                	//도도포인트 적립정책
		                    SHOP_INFO.DODO_POINT_POLICY = util.GetEnvXmlShopENV(828);
		                    if ( util.byteLen(SHOP_INFO.DODO_POINT_POLICY) == 0 )
		                        SHOP_INFO.DODO_POINT_POLICY = "0";
		                }
		        		
		                //util.logInfo("*****JSON.stringify(SHOP_INFO) : " + JSON.stringify(SHOP_INFO));
						sessionStorage.setItem("SHOP_INFO"  , JSON.stringify(SHOP_INFO));
						
						sessionStorage.setItem("inRegiCloseFg"  , util.GetEnvXmlShopENV( 113 ));
						sessionStorage.setItem("gsOrderNoAspYn"  , util.GetEnvXmlShopENV( 722 ));
						sessionStorage.setItem("gsTuClsAll"  , util.GetEnvXmlShopENV( 732 ));
						sessionStorage.setItem("gsSidePopVal"  , util.GetEnvXmlShopENV( 831 ));
						sessionStorage.setItem("gsWaitingVisibleDiv"  , util.GetEnvXmlShopENV( 733 ));
						sessionStorage.setItem("gsSpecialShopFlag"  , util.GetEnvXmlShopENV( 282 ));
						//sessionStorage.setItem("gsSpecialShopFlag"  , "0"); 
						sessionStorage.setItem("gsSideQtyYn"  , util.GetEnvXmlShopENV( 741 ));
						//기초관리 -> 설치자용 -> 매장환경설정 -> 포스환경 환경설정 번호 : 903 [대기화면제거]
						sessionStorage.setItem("gWaitingPageVal"  , util.GetEnvXmlShopENV( 903 ));
						sessionStorage.setItem("gMemberService"  , util.GetEnvXmlShopENV( 286 ));
						
						var couponTgVal = util.GetEnvXmlShopENV( 673 );
						if ( util.byteLen(couponTgVal) == 0 ) sessionStorage.setItem("gsMobileCouponTg"  , "N"); //모바일 쿠폰 - 톨게이트
						//모바일 쿠폰 사용x로 하드코딩
						//else sessionStorage.setItem("gsMobileCouponTg"  , "N"); //모바일 쿠폰 - 톨게이트
						else sessionStorage.setItem("gsMobileCouponTg"  , couponTgVal); //모바일 쿠폰 - 톨게이트
						
						var couponSuperConVal = util.GetEnvXmlShopENV( 182 );
						if ( util.byteLen(couponSuperConVal) == 0 ) {
							sessionStorage.setItem("gsMobileCouponSc"  , "N"); //모바일 쿠폰 - 슈퍼콘
						} else {
							if(couponSuperConVal == "01") {
								sessionStorage.setItem("gsMobileCouponSc"  , "Y"); //모바일 쿠폰 - 슈퍼콘
							} else {
								sessionStorage.setItem("gsMobileCouponSc"  , "N"); //모바일 쿠폰 - 슈퍼콘
							}
						}
						
						//부저음 발생 활경설정값, 사용일때 네이티브 호출
						var prtBuzzerVal = util.GetEnvXmlPosENV(901);
						if ( util.byteLen(prtBuzzerVal) != 0 ) {
							if(prtBuzzerVal == "1") {
								var bResult = util.fnPrintBuzzerCall();
								if(bResult.ResultCode != "0"){
									util.logInfo("_______setShopInfo________ : 부저음 변경 실패!!!");
								}
							}
						}
						
						// NFC 단말기 여부 판단 0 : 미사용, 1 : 사용 -> 사용시 결제버튼 문구가 달라짐
						let resultNfcData = gfn_SQLiteSQLProcess("SELECT ENV_VAL FROM POS_ENV_T WHERE ENV_CD = ? " , ['101']);
						if ( !util.isEmpty( resultNfcData ) && !util.isEmpty( resultNfcData.Data ) && resultNfcData.Data.length != 0 ) {
							util.logInfo("_______resultNfcData________ : " + JSON.stringify(resultNfcData));
							let nfcRow = resultNfcData.Data[0];
							if(nfcRow.ENV_VAL == "1") {
								sessionStorage.setItem("gNfcShopVal"  , nfcRow.ENV_VAL); 
							} else {
								sessionStorage.setItem("gNfcShopVal"  , nfcRow.ENV_VAL); 
							}
						}
					}
				}
				,
				/***********************************************************************
				 * SHOP 정보를 모두 설정한다.
				 ***********************************************************************/
				setShopInfoMustBeRequire : function() {
					util.logInfo("*****setShopInfoMustBeRequire Start*****");
					try {
						util.logInfo('가맹점 정보 조회.');
						this.setShopInfo();
						return '1';
					} catch (e) {
						alert(e.toString());
						//this.$root.$emit( "notiMessage" ,   e  );
						return '0';
					}
				}
				,
				/***********************************************************************
				 * 마스터 수신정보
				 ***********************************************************************/
				masterDataReceive : function () {
					util.logInfo("*****masterDataReceive Start*****");
					var resultData = gfn_SQLiteSQLProcess("SELECT * FROM RECV_SEQ_T" , []);
					//this.validDbData(resultData , '초기 정보 확인 실패<br /><br />관리자에게 문의하여 주십시오.<br />마스터 정보 수신 오류.');

					if ( resultData == null || resultData.ResultCode != '0'  ) {
						util.logInfo("*****masterDataReceive if(resultData == null) Start*****");
						return;
					}

					var rows = resultData.Data;
					if ( rows == undefined || rows == null || rows.length == 0  ) {
						util.logInfo("*****masterDataReceive rows == undefined Start*****");
						return;
					}
					var dataJson = {};
					rows.forEach( e => {
						dataJson["_" + e.REQT_NM] = e.LAST_SEQ;
					}) ;

				    var url = '/SvrApp/MS000.do';
				    var params ={"TSP-NVP" 
				    				:{
				    					"TXJM-FD" :{"_SRID":"MS000", "_RETCD":"0000", "_KIOSK_REQ_YN":"Y" 
				   					 	,	"DATA-HD":{   "_POS_NO" 		: gPosNo
				   					 					, "_SHOP_CD"		: gShopCd
				   					 					, "_IMG_FILE_NAME"	: "" //공백으로 처리.(2020.07.31 최광림 차장 confirm)
				   					 					, "_IMG_FILE_VER" 	: "" //공백으로 처리.(2020.07.31 최광림 차장 confirm)
				   					 					,  "DATA-DT"		: dataJson
				   					 		}
				    					}
				    					
				    				}
				    			};
			        var x2js = new X2JS();
			        var xmlParam = x2js.json2xml_str(params);

					var r = telegram.tlgmCall( XML_PI + xmlParam , url );
					r = x2js.xml_str2json(r);
					if ( r == null || r["TSP-NVP"]["TXJM-FD"]["_RETCD"] != '0000' ) {
						util.logError("*****MS001 result error Not 0000***** " + JSON.stringify(r["TSP-NVP"]));
						return;
					}
					var tlgmDt = r["TSP-NVP"]["TXJM-FD"]["DATA-HD"]["DATA-DT"];
					var tlgmHd = r["TSP-NVP"]["TXJM-FD"]["DATA-HD"];
					util.logInfo("*** masterDataReceive tlgmDt == >>" + JSON.stringify(tlgmDt));
					util.logInfo("*** masterDataReceive tlgmHd == >>" + JSON.stringify(tlgmHd));
					
					var vsCnt = rows.length;
					util.logInfo("*****master data MS001 Insert Total count == >> " + vsCnt); // 총 insert count
					for ( var i = 0 ; i < vsCnt ; i++ ) {

						// insert 5% 진행 시 마다 로그 남김.
						if(parseInt((i+1)/vsCnt*100)%5 == 0 ){
							util.logInfo("*****master data MS001 Insert progress count == >> " + (i+1)); // 현재 진행 count
							util.logInfo("*****master data MS001 Insert progress Percent == >> [" + parseInt((i+1)/vsCnt*100) + "]%"); // 현재 진행 퍼센테이지							
						}						
						
						var row = rows[i];
						//2020.07.30 10:48 최광림 차장 요청(LAST_SEQ 가 0 일때 실행하지 않는다.
						var tlgmSeqVal = tlgmDt["_" + row.REQT_NM];

						if (undefined == tlgmSeqVal || '0' == tlgmSeqVal ) {
							continue;
						}
						util.logInfo("*****master data MS001 REQT_ID == > " + row.REQT_ID);
						//REQ_ID 에 '0' 붙이는 것은 전문의 요청을 의미함.
						var r = aspData.receiveAspData(row.REQT_ID  + "0", row.LAST_SEQ , row );//1. success , 2 last_seq

					}

					if(tlgmDt._DB_SEND_YN == "Y"){
					    var vsFromDt = moment().add(-7,'days').format("YYYYMMDD")
					    var vsToDt = moment().format("YYYYMMDD");
					    util.fnGenerateFile(vsFromDt, vsToDt);
					}
					
					util.logInfo("masterDataReceive productImageDownloadCreateDir Before***** ");
					//상품이미지 다운로드
//					setTimeout(imagesDownload.productImageDownloadCreateDir , 100);
					imagesDownload.productImageDownloadCreateDir();
					
					util.logInfo("masterDataReceive cornerImageDownloadCreateDir Before***** ");
					imagesDownload.cornerImageDownloadCreateDir();
					
					// 대기 이미지/동영상 폴더를 체크하여 없으면 생성 한다. 2021-10-05 : 아래 waitingFileDownloadCreateDir 함수에서 생성하는 로직이 있으나, 이미지/동영상을 동시에 실행하다 보니 tizen api에서 문제가 발생하여 해당 기능만 따로 함수로 만들어 먼저 수행한다.
					imagesDownload.waitingFileCreateDirInit();
					
					try{
						util.logInfo("masterDataReceive logoFileDownloadCreateDir Before***** ");
						// 화면 상단의 로고 이미지를 받아온다.
						var vsLogoUrl = tlgmHd["_KIOSK_21_LOGO_IMG_URL"];
						var vsLogoVer = tlgmHd["_KIOSK_21_LOGO_IMG_VER"];
						util.logInfo("masterDataReceive aspLogoUrl ==>>  "+ vsLogoUrl);
						util.logInfo("masterDataReceive aspLogoVer ==>>  "+ vsLogoVer);
						setTimeout(function(){
							imagesDownload.logoFileDownloadCreateDir(vsLogoUrl, vsLogoVer);
						}, 5000);
						
						// 대기이미지/동영상 받아오기 시작.
						var vsVideoUrl = "";
						var vsVideoVer = "";
						var vsImgUrl = "";
						var vsImgVer = "";
						var vsEnv = util.GetEnvXmlPosENV(709); // (0:사용자, 1:외식(디폴트), 2:카페)
						util.logInfo("[INFO] masterDataReceive waitingFileDownloadCreateDir START ***** ");
						if(vsEnv == "0"){ // 사용자일 때 asp에서 이미지, 동영상 각각 다운
							
							var vsEnvWatingVal = util.GetEnvXmlPosENV(747); // (0:미사용, 1:메인1, 2:메인2, 3:메인3, 4:메인4, 5:메인5)
							if (util.byteLen(vsEnvWatingVal) == 0 )
								vsEnvWatingVal = "0"; 
							
							util.logInfo("*** masterDataReceive vsEnvWatingVal(0:미사용, 1:메인1, 2:메인2, 3:메인3, 4:메인4, 5:메인5) : " + vsEnvWatingVal);
							
							if(vsEnvWatingVal == "0" || vsEnvWatingVal == "1") {
								// 대기화면 이미지, 동영상 다운로드	
								vsVideoUrl = tlgmHd["_KIOSK_AD_VIDEO_URL"];
								vsVideoVer = tlgmHd["_KIOSK_AD_VIDEO_VER"];
								vsImgUrl = tlgmHd["_KIOSK_MAIN_IMG_URL"];
								vsImgVer = tlgmHd["_KIOSK_MAIN_IMG_VER"];
							} else {
								// 대기화면 이미지, 동영상 다운로드	
								vsVideoUrl = tlgmHd["_KIOSK_AD_VIDEO_URL_"+vsEnvWatingVal];
								vsVideoVer = tlgmHd["_KIOSK_AD_VIDEO_VER_"+vsEnvWatingVal];
								vsImgUrl = tlgmHd["_KIOSK_MAIN_IMG_URL_"+vsEnvWatingVal];
								vsImgVer = tlgmHd["_KIOSK_MAIN_IMG_VER_"+vsEnvWatingVal];
							}
							
							if(!!vsVideoUrl || !!vsImgUrl){ // 둘중에 하나라도 있으면 수행. 둘다 없으면 사용자 대기화면을  받아오지 않도록 한다.(신청하지 않은 것으로 간주)
								if(!!vsImgUrl){ // 이미지가 있을 때
									util.logInfo("***** admin init USER IMG URL START *****");
									setTimeout(function(){
										util.logInfo("***** admin init USER IMG URL START timeout *****");
										imagesDownload.waitingFileDownloadCreateDir(vsImgUrl, vsEnv, vsImgVer, "img",""); // 대기화면 이미지 다운로드
									}, 5000);
								}else{ // 이미지가 없을 때
									util.logInfo("***** admin init USER IMG URL NO START *****");
									setTimeout(function(){
										util.logInfo("***** admin init USER IMG URL NO START timeout *****");
										imagesDownload.waitingFileDownloadUserNull("img", ""); // 대기화면 이미지가 없으면 현재 재생되고 있는 이미지 정보들 삭제 후 동영상은 사용안되도록 조치
									}, 5000);
								}
								
								if(!!vsVideoUrl){ // 동영상이 있을 때
									util.logInfo("***** admin init USER VIDEO URL START *****");
									setTimeout(function(){
										util.logInfo("***** admin init USER VIDEO URL START timeout *****");
										imagesDownload.waitingFileDownloadCreateDir(vsVideoUrl, vsEnv, vsVideoVer, "video",""); // 대기화면 동영상 다운로드
									}, 5000);
								}else{ //동영상이 없을 때
									util.logInfo("***** admin init USER VIDEO URL NO START *****");
									setTimeout(function(){
										util.logInfo("***** admin init USER VIDEO URL NO START timeout *****");
										imagesDownload.waitingFileDownloadUserNull("video", ""); // 대기화면 동영상이 없으면 현재 재생되고 있는 동영상 정보들 삭제 후 동영상은 사용안되도록 조치
									}, 5000);
								}
								
							}else{
								util.logInfo("*****admin.init.service vsEnv(709) IS 0 and URL IS NO*****");
								gvInitEndYnVideo="Y";
								gvInitEndYnImg = "Y";
								gvInitLogoImgEndYn = "Y";
							}
							
							
							
						}else{ //  외식, 카페일 때 서버에서 zip파일 하나 다운로드하여 처리.
							util.logInfo("masterDataReceive waitingFile else. vsEnv is Not 0 ***** ");
							setTimeout(function(){
								imagesDownload.waitingFileDownloadCreateDir("", vsEnv, vsEnv, "all", ""); // 대기화면 동영상 다운로드
							}, 2500);
						}

					}catch(e){
						gvInitEndYnVideo="Y";
						gvInitEndYnImg = "Y";
						gvInitLogoImgEndYn = "Y";
						util.logError("[ERROR] masterDataReceive waitingFileDownloadCreateDir error == >>" + e.toString);
					}
					

            		

				}
				,
				/***********************************************************************
				 * 성공여부에 따른 구분없이 다음 JOB 실행
				 ***********************************************************************/
				sendTlgmCt030 : function () {
					util.logInfo("*****sendTlgmCt030 Start*****");
					var empno = sessionStorage.getItem("INIT_EMP_NO"  );
					if ( util.isEmptyStr( empno) ) {
						empno == "";
					}

					var posInfo = "posInfo";//TODO POS INFO
					var attStr = ""
						+ " SHOP_CD='"       + gShopCd +"'"
						+ " POS_NO='"        + gPosNo  +"'"
						+ " INST_CERTI_KEY='"+ macAddress  +"'"  //TODO mac address 값으로 설정
						+ " POS_VER_SEQ='"   + KIOSK_VER_SEQ +"'"  //
						+ " EMP_NO='"        + empno       +"'"
						+ " POS_INFO='"      + posInfo     +"'" /** 매장의 시스템환경에 대한 정보 전달 (매장코드,포스번호,접속시간,OS,MEM,HDD,Explorer,제조업체,프로그램빌드버전) **/
						;
					//debugger;
					util.logInfo("*****sendTlgmCt030 make_auth_ct000_tlgm Before*****");
					var tlgmParam = adminInitService.make_auth_ct000_tlgm("CT030", attStr);
					util.logInfo("*****sendTlgmCt030 tlgm_auth_ct000 Before*****");
					var result = adminInitService.tlgm_auth_ct000(tlgmParam);
				}
				, fnShowSetIpPopupInit : function (){
					util.logInfo("*****fnShowSetIpPopupInit Start*****");
					$('#initTxt3').text("상단 환경설정에서 창을 닫으면 재시작 됩니다.");					
					clearInterval(this.intervalId);
					var paramObj = {
                            title : "사용자권한확인"
                          , openType : "setAdminPage"
                          , callMenu : "adminInit"
                      }
                      this.$root.$emit("inputPwdPopupOpen" , paramObj );
				}

			}

			, updated : function () {
				util.logInfo('*****admin init service  updated*****');
			}
			, beforeUpdate : function(){
				util.logInfo('*****admin init service beforeUpdate*****');
	        }

		}//end var template

		return tmp;
	}

	this.adminAuthComponent = function(){
		var tmp  = {
				  template : '#adminAuth'
				, data : function () {
					var obj = {
						  nShopCd   : ""// "031765"
						, nUserId   : ""// "00008311"
						, nPassWord : ""// "fdk12345"
						, oUserId   : ""// "031765"
						, oPassWord : ""// "111111"
					}
					return obj;
				}
				, created : function () {
					util.logInfo('admin auth service created');
				}
				,
				 beforeDestroy () {
					util.logInfo("admin auth service  beforeDestory");
				}
				,
				destory : function () {
					util.logInfo("admin auth service  destory");
				}
				,
				mounted : function () {
					util.logInfo("admin auth service  mounted");

				    if ($('.tabs').length) {
				        $( ".tabs" ).tabs();
				    }

				    $("#jqueryCss").attr("href" , "");

				}
				, methods : {
					/**** 구인증 ******/
					type_old_auth_action : function() {
						util.logInfo("구인증 선택");
						var attStr = ""
						       + " INST_USER_ID='"+this.oUserId+"' "
						       + " INST_USER_PWD='"+btoa(this.oPassWord)+"' "
						       + " SHOP_CD='' "
						       + " AUTH_FG='3' " /** 1 : 신인증 , 3 : 구인증 **/
						       + " AFFI_NAME='FIRSTPOS' " /*** FIRSTPOS - 고정 ***/
						       + " KIOSK_REQ_YN='Y' "
						       + " POS_FG='10' "   /** 2020.10.29. 최광림 차장 요청사항. 포스용도(FirstPOS가 아닌 경우에 값 전송 - 삼성키오스크, 외부키오스크 등) '10' **/
							;
						util.logInfo(this.authInputValid('old'));
						if ( !this.authInputValid('old')) return;
						util.logInfo('tlgm call');
						var tlgmParam = adminInitService.make_auth_ct000_tlgm("CT010", attStr);
						var result = adminInitService.tlgm_auth_ct000(tlgmParam);
						if ( result == undefined)
							return;

						this.resultProcess(result);
					}
					, authInputValid : function( authType ) {

						let errMessage =  "";
						if ( authType == 'old'){
							if ( util.byteLen(this.oUserId  ) == 0 )  errMessage= "회원 아이디를 입력하여 주세요.";
							if ( util.byteLen(this.oPassWord) == 0 )  errMessage= "회원 비밀번호를 입력하여 주세요.";
						} else if ( authType == 'new' ) {
							if ( util.byteLen(this.nShopCd  ) == 0 )  errMessage= "회원 매장코드를 입력하여 주세요.";
							if ( util.byteLen(this.nUserId  ) == 0 )  errMessage= "회원 아이디를 입력하여 주세요."  ;
							if ( util.byteLen(this.nPassWord) == 0 )  errMessage= "회원 비밀번호를 입력하여 주세요.";
						}

						util.logInfo('util.byteLen(errMessage)' + util.byteLen(errMessage));
						if (util.byteLen(errMessage) != 0 ) {
							let obj = {
									  message : errMessage
									, messageType : "alert"
							};
							this.$root.$emit( "notiMessage" ,   obj  );
							return false;
						}
						return true;
					}
					,
					type_new_auth_action : function() {						
						util.logInfo("신인증 선택");

						let attStr = ""
							+ " INST_USER_ID='"+this.nUserId+"' "
//							+ " INST_USER_PWD='"+SHA256(this.nPassWord)+"' " // 2022-04-13 신인증 암호화 방식을 base64로 변경. mms에서 관리자가 비번을 변경할 때 base64로 되기 때문에, 신인증의 비민번호를 base64로 맞춰야한다고 함. ASP팀에서 수정 요청옴.
							+ " INST_USER_PWD='"+btoa(this.nPassWord)+"' "
							+ " SHOP_CD='" + this.nShopCd + "'       "
							+ " AUTH_FG='1' " /** 1 : 신인증 , 3 : 구인증 **/
							+ " AFFI_NAME='FIRSTPOS' " /*** FIRSTPOS - 고정 ***/
							+ " KIOSK_REQ_YN='Y' "
							+ " POS_FG='10' "   /** 2020.10.29. 최광림 차장 요청사항. 포스용도(FirstPOS가 아닌 경우에 값 전송 - 삼성키오스크, 외부키오스크 등) '10' **/
							;
						
						if ( !this.authInputValid('new')) return;

						let tlgmParam = adminInitService.make_auth_ct000_tlgm("CT010", attStr);
						let result = adminInitService.tlgm_auth_ct000(tlgmParam);
						if ( result == undefined)
							return;
						this.resultProcess(result);
					}
					,
					resultProcess : function (result) {
						$r = $(result);
						var retCd   = $r.find("TXJM-FD").attr("RETCD");
						var shopCnt = $r.find("DATA-HD").attr("SHOP_CNT");
						var empNo   = $r.find("DATA-HD").attr("INST_USER_ID");

						util.logInfo('retCd', retCd );
						util.logInfo('shopCnt', shopCnt );

						if ( "0000" ===retCd) {
							var posList = [];

							$r.find("DATA-DT").each(function (idx, item) {
								var obj = {
										  POS_NO : $(this).attr("POS_NO")
										, SHOP_CD : $(this).attr("SHOP_CD")
										, SHOP_NM : $(this).attr("SHOP_NM")
										, INST_USER_ID : empNo
								}
								posList.push(obj);
							});
							util.logInfo(posList);
							this.$router.push({name : 'posSelect' , params : { posList : posList  }});
						} else {
							var errMessage = $r.find("TXJM-FD").attr("RETMSG");
							var obj = {
									  message : errMessage
									, messageType : "alert"
								};
							this.$root.$emit( "notiMessage" ,   obj  );
						}
					}
				}

				, updated : function () {
					util.logInfo('admin init service  updated');
				}
				, beforeUpdate : function(){
					util.logInfo('admin init service beforeUpdate');
		        }

			}//end var template

			return tmp;
	}

	//POS 설치 리스트 다운 -> POS 설치 인증 처리 -> POS 인증키 로그인 처리 및 버전 확인
	this.tlgm_auth_ct000 = function( param ) {
		
		let result ;
		try {
			result = telegram.tlgmCall(param , "/SvrApp/CT000.do"  );
		} catch (e) {
			if ( e.toString().indexOf("NetworkError") != -1 ) {
				var obj = {
						  message : "설치정보 확인 실패\n인터넷 상태를 확인 해 주세요"
						, messageType : "alert"
				};
				this.$root.$emit( "notiMessage" ,   obj  );
				return;
			}
		}

		return result;
	}

	this.make_auth_ct000_tlgm= function ( tlgmNo , attrStr ) {
		var dataBody = "";
		dataBody += "\n<TSP-NVP>";
		dataBody += "\n   <TXJM-FD SRID='"+tlgmNo +"' RETCD='0000' >";//고정
		dataBody += "\n      <DATA-HD ";

		if ( "CT010" == tlgmNo ) {
			dataBody += "          " + attrStr ;

		} else if ( "CT020" == tlgmNo ) {
			dataBody += "          " + attrStr ;

		} else if ( "CT030" == tlgmNo ) {
			dataBody += "          " + attrStr ;

		}

		dataBody += "  />";
		dataBody += "\n  </TXJM-FD>";
		dataBody += "\n</TSP-NVP>";
		return XML_PI + dataBody;
	}

	this.adminPosSelectComponent = function() {
		var tmp  = {
			  template : '#adminPosSelect'
			, data : function () {
				var obj = {
					  posList : []
					, posInfo : {}
					, serverName : ""
					, shopName   : ""
					, shopCode   : ""
					, posNo      : ""
					, posType    : ""
					, instUserId : ""
				}
				return obj;
			}
			, created : function () {
				util.logInfo('admin pos select service created');
			}
			,
			 beforeDestroy () {
				util.logInfo("admin pos select service  beforeDestory");
			}
			, destory : function () {
				util.logInfo("admin pos select service  destory");
			}
			, mounted : function () {
				util.logInfo("admin pos select service  mounted");
				util.logInfo("this.$route.params.posList : \n" , this.$route.params.posList ) ;
				this.posList = this.$route.params.posList;
				this.tableSet();
			}
			, methods : {
				tableSet : function (){
                    //테이블
                    var swiperTable1 = new Swiper('.certProcess .tableBody', {
                        autoHeight: true,
                        direction: 'vertical',
                        slidesPerView: 4,
                        navigation: {
                            nextEl: '.certProcess .tableDown',
                            prevEl: '.certProcess .tableUp',
                        },
                    });
                } //tableSet end
				,
				posRowClick : function ( row ) {
					util.logInfo('posRowClick ' , row);
					//this.posInfo = pos;
					this.shopName = row.SHOP_NM;
					this.shopCode = row.SHOP_CD;
					this.posNo    = row.POS_NO;
					this.posType  = row.POS_TYPE;
					this.serverName = "localhost";//default
					this.instUserId = row.INST_USER_ID
				}
				,
				fn_pos_selected : function () {
					if ( util.isEmptyStr( this.shopName ) ) {
						var obj = {
								  message : "설치매장 리스트에서 POS 번호를 선택하여 주세요."
								, messageType : "alert"
							};
						this.$root.$emit( "notiMessage" ,   obj  );

					}
					//CT020 전문 정보 설정.(POS 설치 인증 처리)
					var attrStr = ""
					+" SHOP_CD='"+this.shopCode +"'"
					+" POS_NO='"+ this.posNo +"'"
					+" INST_CERTI_KEY='"+ macAddress +"'"//TODO mac address tobe...
					+" INST_USER_ID='"+ this.instUserId +"'"
					+" "
					;
					//debugger;
					var params = adminInitService.make_auth_ct000_tlgm("CT020" , attrStr);
					var result = adminInitService.tlgm_auth_ct000(params);
					if ( result == undefined)
						return;

					$r = $(result);
					var retCd   = $r.find("TXJM-FD").attr("RETCD");
					if ( "0000" == retCd ) {
						util.logInfo("CT021 정상처리 POS 설치 인증 처리.");
						this.upsertScdSetupT();//POS 정보 저장

						var urlParam = "";
						try{
//                            if(this.serverName == "localhost"){
//                            	//https://api.firstpos.co.kr
//                                //urlParam = apiUrl + "/SvrApp/MS000.do";
//                                urlParam = "http://" + this.serverName + ":2006/SvrApp/MS000.do";
//                            }else{
//                            }
                            urlParam = "http://" + this.serverName + ":2006/SvrApp/MS000.do";
                            var result = nativeApp.functionCallSync(["FDK_SetConfig", "ASP_POST_URL", urlParam]);

                            util.logInfo("FDK_SetConfig urlParam :" + urlParam + ", result : " + result);
                        }catch(e){
                            util.logError("FDK_SetConfig ERROR urlParam :" + urlParam + ", result : " + result);
                        }

					}
				}
				,
				upsertScdSetupT : function() {
					let sql = "INSERT OR REPLACE INTO SCD_SETUP_T ( SHOP_CD , POS_NO, MAIN_IP , EMP_NO, KIOSK_VER_SEQ , IMG_FILE_VER ) VALUES  ( ? , ? , ? , ? , ?  , ? ) ";
					try {
						gfn_SQLiteSQLProcess("DELETE FROM SCD_SETUP_T" , []);
						let result = gfn_SQLiteSQLProcess( sql  , [ this.shopCode , this.posNo , this.serverName, this.instUserId , KIOSK_VER_SEQ , "" ]);
						if ( result.ResultCode != 0 ) {
							throw "";
						}
					} catch (e) {
						var obj = {
								  message : "설치매장 정보를 Database 저장에 실패하였습니다.."
								, messageType : "alert"
						};
						this.$root.$emit( "notiMessage" ,   obj  );
						return ;
					}
					this.$router.push({path:"/init"});
				}
			}

			, updated : function () {
				util.logInfo('admin pos select service  updated');
				util.setTableBody();//Style 설정.
				this.tableSet();
			}
			, beforeUpdate : function(){
				util.logInfo('admin pos select service beforeUpdate');
	        }

		}//end var template

		return tmp;
	}

	//재설치시 매출 TR Download.
	this.SetMakeSendXmlData_SI380 = function() {
		try {
			let dataBody = "";
			dataBody += "\n<TSP-NVP>";
			dataBody += "\n   <TXJM-FD SRID='SI380' RETCD='0000' >";//고정
			dataBody += "\n      <DATA-HD ";
			dataBody += " SHOP_CD='%s' POS_NO='%s' ".sprintf(gShopCd , gPosNo) ;
			dataBody += "  />";
			dataBody += "\n  </TXJM-FD>";
			dataBody += "\n</TSP-NVP>";
			
			let result = telegram.tlgmCall(XML_PI + dataBody , "/SvrApp/SI000.do"  );
			util.logInfo(result);
			let $r = $(result);
			util.logInfo('$r' , $r);
			util.logInfo('$result' , $(result));
			let  retCd   = $r.find("TXJM-FD").attr("RETCD");
			if ( "0000" !== retCd ) {
				util.logInfo("SI380 정상처리 POS 설치 인증 처리.");
			}
			let nvp = $(result).find("TSP-NVP")[0]
			util.logInfo('nvp ', nvp);
			
			let dataCnt = $r.find("TXJM-FD > DATA-HD").attr("DATA_CNT");
			util.logInfo('SI380 dataCnt ' + dataCnt);
			if ( dataCnt == 0 ) {
				util.logInfo('SI380 데이터 없음.')
				return
			}
			
			let siParams = {};
			
			$r.find("DATA-DT").each(function (idx, item) {
				util.logInfo('idx : ' + idx ,  $(this) , item);
				if ( $(this).attr('POS_NO'.toLowerCase())  == gPosNo ) {
					//LAST_REGI_CNT="1" LAST_REGI_YN="N" LAST_SALE_CNT="4" LAST_SALE_DATE="20201019" NUMBER="2" POS_NO="02" SHOP_CD="031765"
					siParams.LAST_SALE_DATE  = $(this).attr('LAST_SALE_DATE'.toLowerCase());
					siParams.NUMBER          = $(this).attr('NUMBER'.toLowerCase());
					siParams.LAST_SALE_CNT   = $(this).attr('LAST_SALE_CNT'.toLowerCase());
					siParams.LAST_REGI_YN    = $(this).attr('LAST_REGI_YN'.toLowerCase());
					siParams.LAST_REGI_CNT   = $(this).attr('LAST_REGI_CNT'.toLowerCase());
				}
			});

			for ( let j = 0  ; j <= siParams.LAST_SALE_CNT  ; j++ ) {
				let b = (j+ "").padding(4, '0');
				aspData.receiptCheckAspData( "SI010" , siParams.LAST_SALE_DATE , b ) ;// 영수증 조회 전문호출
			}
			
			if ( mainPosNo != gPosNo ) {				
//				gvInitEndYn = "Y";
				util.logInfo('main pos no 와 gPosNo 가 다르기 때문에 SI390 전문은 호출하지 않는다. main[%s] pos[%s]'.sprintf(mainPosNo , gPosNo))
				return;
			}
			
			aspData.salesCheckAspData('SI390' , siParams.LAST_SALE_DATE);
		} catch (e) {
			util.logError(e);
		}
	}
}