var CanvasToBMP24 = function () 
{
	var $support = function () {
		var canvas = document.createElement('canvas');
		var ctx = canvas.getContext('2d');

		return {
			canvas: !!ctx,
			imageData: !!ctx.getImageData,
			dataURL: !!canvas.toDataURL,
			btoa: !!window.btoa
		};
	}();

	function scaleCanvas (canvas, width, height) {
		var w = canvas.width;
		var h = canvas.height;
		
//alert("w: "+w+"h: "+ h+"width:"+ width +"height: "+ height);		
		var retCanvas = document.createElement('canvas');
		var retCtx = retCanvas.getContext('2d');
		retCanvas.width = width;
		retCanvas.height = height;
		retCtx.drawImage(canvas, 0, 0, w, h, 0, 0, width, height);
		
		return retCanvas;
	}

	function getBmpImageDataURI (canvas) {
		var w = canvas.width;
		var h = canvas.height;
		
		var data = canvas.getContext('2d').getImageData(0, 0, w, h);
		var strData = genBitmapImage(data);
		
		return 'data:image/bmp;base64,' + strData;
	}
	
	function encodeData (data) {
		if (!window.btoa) { 
			throw 'btoa undefined' 
		}
		var str = '';
		if (typeof data == 'string') {
			str = data;
		} else {
			for (var i = 0; i < data.length; i ++) {
				str += String.fromCharCode(data[i]);
			}
		}

		return btoa(str);
	}
	
	/**
	 * create bitmap image
	 */
	var genBitmapImage = function (oData) {
		var biWidth  	= oData.width;
		var biHeight	= oData.height;
		var biSizeImage = biWidth * biHeight * 3;
		var bfSize  	= biSizeImage + 54; 		// total header size = 54 bytes

		//  typedef struct tagBITMAPFILEHEADER {
		//  	WORD bfType;
		//  	DWORD bfSize;
		//  	WORD bfReserved1;
		//  	WORD bfReserved2;
		//  	DWORD bfOffBits;
		//  } BITMAPFILEHEADER;
		var BITMAPFILEHEADER = [
			0x42, 0x4D,
			bfSize & 0xff, bfSize >> 8 & 0xff, bfSize >> 16 & 0xff, bfSize >> 24 & 0xff,
			0, 0,
			0, 0,
			54, 0, 0, 0
		];

		//  typedef struct tagBITMAPINFOHEADER {
		//  	DWORD biSize;
		//  	LONG  biWidth;
		//  	LONG  biHeight;
		//  	WORD  biPlanes;
		//  	WORD  biBitCount;
		//  	DWORD biCompression;
		//  	DWORD biSizeImage;
		//  	LONG  biXPelsPerMeter;
		//  	LONG  biYPelsPerMeter;
		//  	DWORD biClrUsed;
		//  	DWORD biClrImportant;
		//  } BITMAPINFOHEADER, *PBITMAPINFOHEADER;
		var BITMAPINFOHEADER = [
			40, 0, 0, 0,
			biWidth & 0xff, biWidth >> 8 & 0xff, biWidth >> 16 & 0xff, biWidth >> 24 & 0xff,
			biHeight & 0xff, biHeight >> 8  & 0xff, biHeight >> 16 & 0xff, biHeight >> 24 & 0xff,
			1, 0,
			24, 0,
			0, 0, 0, 0,
			biSizeImage & 0xff, biSizeImage >> 8 & 0xff, biSizeImage >> 16 & 0xff, biSizeImage >> 24 & 0xff,
			0,0,0,0,
			0,0,0,0,
			0,0,0,0,
			0,0,0,0
		];

		var iPadding = (4 - ((biWidth * 3) % 4)) % 4;

		var aImgData = oData.data;

		var strPixelData = '';
		var biWidth4 = biWidth<<2;
		var y = biHeight;
		var fromCharCode = String.fromCharCode;

		do {
			var iOffsetY = biWidth4*(y-1);
			var strPixelRow = '';
			for (var x = 0; x < biWidth; x++) {
				var iOffsetX = x<<2;
				strPixelRow += fromCharCode(aImgData[iOffsetY+iOffsetX+2]) +
							   fromCharCode(aImgData[iOffsetY+iOffsetX+1]) +
							   fromCharCode(aImgData[iOffsetY+iOffsetX]);
			}

			for (var c = 0; c < iPadding; c++) {
				strPixelRow += String.fromCharCode(0);
			}

			strPixelData += strPixelRow;
		} while (--y);

		var strEncoded = encodeData(BITMAPFILEHEADER.concat(BITMAPINFOHEADER)) + encodeData(strPixelData);

		return strEncoded;
	};

	/**
	 * toDataURL
	 * 
	 * @param canvasElement
	 * @param {Number} image width
	 * @param {Number} image height
	 */
	var toDataURL = function (canvas, width, height) {
		if ($support.canvas && $support.dataURL) {
			if (typeof canvas == "string") { 
				canvas = document.getElementById(canvas); 
			}

			canvas = scaleCanvas(canvas, width, height);
			var strData = getBmpImageDataURI(canvas);
			
			return strData;
		}
	};
	
	return {
		toDataURL: toDataURL
	};
}();
