var AdminSql = function(){

    //현재 POS의 마감 차수와 마감상태
    this.selectPosClosingStatus = " SELECT REGI_SEQ , CLOSE_FG, POS_NO, SALE_DATE, OPEN_DT, "
                                    + " (SELECT CLOSE_FG FROM POS_REGIS_T WHERE SHOP_CD   = ? AND   SALE_DATE = T.SALE_DATE AND POS_NO    = ? AND   REGI_SEQ = '00' LIMIT 1) AS  MAIN_POS_CLOSE"
                                    + " FROM POS_REGIS_T T"
                                    + " WHERE SHOP_CD   = ? "
                                        + " AND   SALE_DATE = (SELECT SALE_DATE "
                                                    + " FROM POS_REGIS_T "
                                                    + " WHERE SHOP_CD  = ? "
                                                        + " AND   POS_NO   = ? "
                                                        + " AND   REGI_SEQ = '00' "
                                                    + " ORDER BY SALE_DATE DESC "
                                                    + " LIMIT 1) "
                                        + " AND   POS_NO    = ? "
                                        + " AND   REGI_SEQ<> '00' "
                                    + " ORDER BY SALE_DATE DESC, REGI_SEQ "
                                    + " LIMIT 1 ";

    //개점처리화면 정보
    this.selectOpenProcessInfo = "SELECT REGIS.SALE_DATE 	"
                                    +", REGIS.CLOSE_DT"
                                    +", REGIS.REGI_SEQ"
                                    +", REGIS.EMP_NO "
                                    +", EMPMS.EMP_NM "
                                    +"FROM POS_REGIS_T REGIS "
                                        +"LEFT OUTER JOIN SCD_EMPMS_T EMPMS "
                                        +"ON  EMPMS.SHOP_CD = REGIS.SHOP_CD "
                                            +"AND EMPMS.EMP_NO  = REGIS.EMP_NO "
                                    +"WHERE REGIS.SHOP_CD   = ? "
                                        +"AND   REGIS.SALE_DATE = (SELECT SALE_DATE "
                                                                    + " FROM POS_REGIS_T "
                                                                    + " WHERE SHOP_CD  = ? "
                                                                        + " AND   POS_NO   = ? "
                                                                        + " AND   REGI_SEQ = '00' "
                                                                    + " ORDER BY SALE_DATE DESC "
                                                                    + " LIMIT 1) "
                                        +"AND   REGIS.POS_NO    = ? "
                                        +"AND   REGIS.CLOSE_FG  = (SELECT CASE WHEN POS_NO == ? THEN 3 ELSE 2 END "
                                                                    + " FROM SCD_ENVPS_T "
                                                                    + " WHERE SHOP_CD     = ? "
                                                                        + " AND   ENV_SET_CD  = '205' "
                                                                        + " AND   ENV_SET_VAL = '1') "
                                    +"ORDER BY REGIS.SALE_DATE DESC "
                                        +", REGIS.REGI_SEQ DESC ";

    //영업일
    this.selectGetSaledate = "SELECT SALE_DATE "
                            + " FROM POS_REGIS_T "
                            + " WHERE SHOP_CD  = ? "
                                + " AND   POS_NO   = ? "
                                + " AND   REGI_SEQ = '00' "
                            + " ORDER BY SALE_DATE DESC "
                            + " LIMIT 1 ";

    //개점처리 여부확인
    this.selectOpenProcessCheck = "SELECT CLOSE_FG "
                                        + " , REGI_SEQ "
                                        + " , OPEN_DT "
                                    + " FROM POS_REGIS_T "
                                    + " WHERE SHOP_CD   = ? "
                                        + " AND   SALE_DATE = ? "
                                        + " AND   POS_NO    = ? "
                                        + " AND   REGI_SEQ  <> '00' "
                                    + " ORDER BY SALE_DATE DESC , REGI_SEQ "
                                    + " LIMIT 1";


    //개시시간 및 마감상태
    this.selectMainPosInfo = "SELECT SALE_DATE, OPEN_DT , CLOSE_FG"
                            + " FROM POS_REGIS_T "
                            + " WHERE SHOP_CD   = ? "
                                + " AND   SALE_DATE = (SELECT SALE_DATE FROM POS_REGIS_T  WHERE SHOP_CD  = ?  AND   POS_NO   = ?  AND   REGI_SEQ = '00'  ORDER BY SALE_DATE DESC  LIMIT 1)  "
                                + " AND   POS_NO    = ? "
                                + " AND   REGI_SEQ  = '00' "
                            + " ORDER BY SALE_DATE DESC , REGI_SEQ DESC ";
    //메인포스 개점처리
    this.insertMainPosOpen = " INSERT INTO POS_REGIS_T ( "
                                    + " SHOP_CD, SALE_DATE, POS_NO, REGI_SEQ, EMP_NO, "
                                    + " CLOSE_FG, OPEN_DT, INS_DT ) "
                                + " VALUES ( "
                                    + " ?,  ? , ?, '00', ?, "
                                    + " '1', strftime('%Y%m%d%H%M%S', 'now', 'localtime'), strftime('%Y%m%d%H%M%S', 'now', 'localtime') )";

    //포스 개점처리
    this.insertPosOpen = " INSERT INTO POS_REGIS_T ( "
                                    + " SHOP_CD, SALE_DATE, POS_NO, "
                                    + " REGI_SEQ, "
                                    + " EMP_NO, "
                                    + " CLOSE_FG, OPEN_DT, POS_READY_AMT,  INS_DT ) "
                                + " VALUES ( "
                                    + " ?,  ? , ?, ?,  ?, "
                                    + " '1', strftime('%Y%m%d%H%M%S', 'now', 'localtime'), ?, strftime('%Y%m%d%H%M%S', 'now', 'localtime') )";

    //REGI_SEQ 가져오기
    this.selectGetRegiSeq = "SELECT SUBSTR('00'||IFNULL(MAX( CAST( REGI_SEQ AS INTEGER ) ) + 1 , 1), -2, 2) AS REGI_SEQ "
                         + " FROM POS_REGIS_T "
                         + " WHERE SHOP_CD   = ? "
                             + " AND   SALE_DATE = ? "
                             + " AND   POS_NO    = ? ";
    //메인포스 확인
    this.selectMainPosNo = "SELECT POS_NO AS MAIN_POS_NO "
                            + " FROM SCD_ENVPS_T "
                            + "	WHERE SHOP_CD     = ? "
                                + " AND   ENV_SET_CD  = '205' "
                                + " AND   ENV_SET_VAL = '1'";
    //정산지 출력 정산정보 조회
    this.selectClosePrintInfo = ""
    		+ "\n  SELECT A.SALE_DATE        AS  SALE_DATE         ".rtrim()
    		+ "\n       , A.REGI_SEQ         AS  REGI_SEQ          ".rtrim()
    		+ "\n       , A.OPEN_DT          AS  OPEN_DT           ".rtrim()
    		+ "\n       , A.CLOSE_DT         AS  CLOSE_DT          ".rtrim()
    		+ "\n       , A.EMP_NO           AS  EMP_NO            ".rtrim()
    		+ "\n       , B.EMP_NM           AS  EMP_NM            ".rtrim()
    		+ "\n    FROM POS_REGIS_T      A                       ".rtrim()
    		+ "\n    LEFT JOIN SCD_EMPMS_T B                       ".rtrim()
    		+ "\n      ON A.SHOP_CD = B.SHOP_CD                    ".rtrim()
    		+ "\n     AND A.EMP_NO = B.EMP_NO                      ".rtrim()
    		+ "\n   WHERE A.SHOP_CD  = '%s'                          ".rtrim()
    		+ "\n     AND A.POS_NO   = '%s'                          ".rtrim()
    		+ "\n     AND A.CLOSE_FG = '%s'                           ".rtrim()
    		+ "\n   ORDER BY SALE_DATE DESC  , REGI_SEQ DESC       ".rtrim()
    		+ "\n   LIMIT 1                                        ".rtrim()
    		;

    //마감정산 내역
    this.selectClosingSettlementInfo = "SELECT SUM( TOT_BILL_CNT      ) AS TOT_BILL_CNT, "   //BILL_NO
                                            + " SUM( TOT_AMT          ) AS TOT_AMT, "        //총판매액
                                            + " SUM( CANCEL_TOT_AMT   ) AS CANCEL_TOT_AMT, "//총반품액
                                            + " SUM( TOT_SALE_AMT     ) AS TOT_SALE_AMT, "  // 총매출액
                                            + " SUM( TOT_DC_AMT       ) AS TOT_DC_AMT, "    // 총할인액
                                            + " SUM( SVC_TIP_AMT      ) AS SVC_TIP_AMT, "   // 봉사료금액
                                            + " SUM( TOT_ETC_AMT      ) AS TOT_ETC_AMT,  "  // 총 기타매출
                                            + " SUM( DCM_SALE_AMT     ) AS DCM_SALE_AMT, "  // 실매출액
                                            + " SUM( VAT_SALE_AMT     ) AS VAT_SALE_AMT, "  // 과세매출액
                                            + " SUM( VAT_AMT          ) AS VAT_AMT,  "      //부가세액
                                            + " SUM( NO_VAT_SALE_AMT  ) AS NO_VAT_SALE_AMT, "   //면세매출액
                                            + " SUM( NO_TAX_SALE_AMT  ) AS NO_TAX_SALE_AMT, "   //순매출액
                                            + " SUM( RET_BILL_CNT     ) AS RET_BILL_CNT, "      //
                                            + " SUM( CANCEL_TOT_AMT   ) AS CANCEL_TOT_AMT, "    //
                                            + " SUM( FD_GST_CNT_T     ) AS FD_GST_CNT_T, "      //
                                            + " SUM( CASH_CNT         ) AS CASH_CNT, "          //
                                            + " SUM( CASH_AMT         ) AS CASH_AMT,        "   //현금
                                            + " SUM( CASH_BILL_CNT    ) AS CASH_BILL_CNT, "    //
                                            + " SUM( CASH_BILL_AMT    ) AS CASH_BILL_AMT, "      //
                                            + " SUM( CARD_CNT         ) AS CARD_CNT, "          //
                                            + " SUM( CRD_CARD_AMT     ) AS CRD_CARD_AMT,  "     //신용카드
                                            + " SUM( WES_CNT          ) AS WES_CNT,        "    //외상
                                            + " SUM( WES_AMT          ) AS WES_AMT,        "    //외상
                                            + " SUM( TK_GFT_CNT       ) AS TK_GFT_CNT,       "  //
                                            + " SUM( TK_GFT_AMT       ) AS TK_GFT_AMT,       "  //상품권
                                            + " SUM( TK_FOD_CNT       ) AS TK_FOD_CNT,      "   //
                                            + " SUM( TK_FOD_AMT       ) AS TK_FOD_AMT,      "   //식권
                                            + " SUM( CST_POINT_CNT    ) AS CST_POINT_CNT,    "  //
                                            + " SUM( CST_POINT_AMT    ) AS CST_POINT_AMT,    "  //회원마일리지
                                            + " SUM( JCD_CARD_CNT     ) AS JCD_CARD_CNT,    "   //
                                            + " SUM( JCD_CARD_AMT     ) AS JCD_CARD_AMT,    "   //제휴카드
                                            + " SUM( RFC_CNT          ) AS RFC_CNT,    "        //
                                            + " SUM( RFC_AMT          ) AS RFC_AMT,     "       //
                                            + " SUM( ETC_APPR_CNT     ) AS ETC_APPR_CNT,      "   //
                                            + " SUM( ETC_APPR_AMT     ) AS ETC_APPR_AMT,    "   //기타승인금액
                                            + " SUM( DC_GEN_CNT       ) AS DC_GEN_CNT,     "    //
                                            + " SUM( DC_GEN_AMT       ) AS DC_GEN_AMT,     "    //일반할인
                                            + " SUM( DC_SVC_CNT       ) AS DC_SVC_CNT,      "   //
                                            + " SUM( DC_SVC_AMT       ) AS DC_SVC_AMT,      "   //서비스
                                            + " SUM( DC_PCD_CNT       ) AS DC_PCD_CNT,        " //
                                            + " SUM( DC_PCD_AMT       ) AS DC_PCD_AMT,        " //제휴할인
                                            + " SUM( DC_CPN_CNT       ) AS DC_CPN_CNT,       "  //
                                            + " SUM( DC_CPN_AMT       ) AS DC_CPN_AMT,       "  //쿠폰할인
                                            + " SUM( DC_CST_CNT       ) AS DC_CST_CNT,       "  //
                                            + " SUM( DC_CST_AMT       ) AS DC_CST_AMT,       "  //회원할인
                                            + " SUM( DC_TFD_CNT       ) AS DC_TFD_CNT,       "  //
                                            + " SUM( DC_TFD_AMT       ) AS DC_TFD_AMT,       "  //식권할인
                                            + " SUM( DC_PRM_CNT       ) AS DC_PRM_CNT,       "  //
                                            + " SUM( DC_PRM_AMT       ) AS DC_PRM_AMT,       "  //프로모션할인
                                            + " SUM( DC_CRD_CNT       ) AS DC_CRD_CNT,       "  //
                                            + " SUM( DC_CRD_AMT       ) AS DC_CRD_AMT,       "  //신용카드할인
                                            + " SUM( DC_PACK_CNT      ) AS DC_PACK_CNT,      "  //
                                            + " SUM( DC_PACK_AMT      ) AS DC_PACK_AMT,      "  //포장할인
                                            + " SUM( REPAY_CASH_CNT   ) AS REPAY_CASH_CNT,   "  //
                                            + " SUM( REPAY_CASH_AMT   ) AS REPAY_CASH_AMT,   "  //현금환불액
                                            + " SUM( REPAY_TK_GFT_CNT ) AS REPAY_TK_GFT_CNT,  "  //
                                            + " SUM( REPAY_TK_GFT_AMT ) AS REPAY_TK_GFT_AMT  "  //상품권환불액
                                        + " FROM REGI_SUM_VW "
                                        + " WHERE SHOP_CD   = ? "
                                            + " AND   SALE_DATE = ? "
                                            + " AND   POS_NO    = ? "
                                        + " GROUP BY SHOP_CD, SALE_DATE ";

    //마감정산 카드사별 매출현황
    this.selectCardSales = "SELECT PUR_CRDCP_CD , PUR_CRDCP_NM, COUNT( PUR_CRDCP_CD ) AS CNT "
                                + " , SUM( APPR_AMT * CASE WHEN SALE_YN == 'Y' THEN 1 ELSE -1 END ) AS APPR_AMT "
                            + " FROM SSL_TRCRD_T "
                            + " WHERE SHOP_CD   = ? "
                                + " AND   SALE_DATE = ? "
                                + " AND   POS_NO    = ? "
                            + " GROUP BY PUR_CRDCP_CD, PUR_CRDCP_NM "
                            + " ORDER BY PUR_CRDCP_CD ";

    //마감정산 회원 마일리지
    this.selectCstPoint = "SELECT COUNT( BILL_NO ) AS CNT "
                                + " , SUM( FD_GST_CNT_T ) AS GUEST_CNT "
                                + " , SUM( CASE WHEN ( SALE_YN = 'Y' ) AND ( CST_SALE_POINT > 0 ) THEN 1 WHEN ( SALE_YN = 'N' ) AND ( CST_SALE_POINT > 0 ) THEN -1 ELSE 0 END ) AS SALE_CNT "
                                + " , SUM( CASE SALE_YN WHEN 'Y' THEN CST_SALE_POINT WHEN 'N' THEN CST_SALE_POINT * -1 ELSE 0 END ) AS SALE_POINT "
                                + " , SUM( CASE WHEN ( SALE_YN = 'Y' ) AND ( CST_POINT_AMT > 0 ) THEN 1 WHEN ( SALE_YN = 'N' ) AND ( CST_POINT_AMT > 0 ) THEN -1 ELSE 0 END ) AS USE_CNT "
                                + " , SUM( CASE SALE_YN WHEN 'Y' THEN CST_POINT_AMT WHEN 'N' THEN CST_POINT_AMT * -1 ELSE 0 END ) AS USE_POINT "
                            + " FROM SSL_TRHDR_T "
                            + " WHERE SHOP_CD   = ? "
                                + " AND   SALE_DATE    = ? "
                                + " AND   POS_NO    = ? ";

    //마감정산 정산데이터
    this.selectClosingSettlementData1 = "SELECT TOT_BILL_CNT , TOT_SALE_AMT , TOT_DC_AMT , SVC_TIP_AMT , TOT_ETC_AMT "
                                            + " , DCM_SALE_AMT, VAT_SALE_AMT, VAT_AMT, NO_VAT_SALE_AMT, NO_TAX_SALE_AMT "
                                            + " , RET_BILL_CNT , CANCEL_TOT_AMT , FD_GST_CNT_T, CASH_CNT, CASH_AMT "
                                            + " , CASH_BILL_CNT, CASH_BILL_AMT, CARD_CNT, CRD_CARD_AMT, WES_CNT "
                                            + " , WES_AMT, TK_GFT_CNT, TK_GFT_AMT, TK_FOD_CNT, TK_FOD_AMT "
                                            + " , CST_POINT_CNT, CST_POINT_AMT, JCD_CARD_CNT, JCD_CARD_AMT, RFC_CNT "
                                            + " , RFC_AMT , ETC_APPR_CNT , ETC_APPR_AMT, DC_GEN_CNT, DC_GEN_AMT "
                                            + " , DC_SVC_CNT , DC_SVC_AMT, DC_PCD_CNT, DC_PCD_AMT, DC_CPN_CNT "
                                            + " , DC_CPN_AMT, DC_CST_CNT, DC_CST_AMT, DC_TFD_CNT, DC_TFD_AMT "
                                            + " , DC_PRM_CNT, DC_PRM_AMT, DC_CRD_CNT, DC_CRD_AMT, DC_PACK_CNT "
                                            + " , DC_PACK_AMT, REPAY_CASH_CNT, REPAY_CASH_AMT, REPAY_TK_GFT_CNT, REPAY_TK_GFT_AMT "
                                        + " FROM REGI_SUM_VW "
                                        + " WHERE SHOP_CD   = ? "
                                            + " AND   SALE_DATE = ? "
                                            + " AND   POS_NO    = ? "
                                            + " AND   REGI_SEQ  = ? ";

    //마감정산 정산데이터
    this.selectClosingSettlementData2 = "SELECT SUM( CASE CODE WHEN '05' THEN AMT ELSE 0 END ) POS_CSH_IN_AMT, "
                                            + " SUM( CASE CODE WHEN '06' THEN AMT ELSE 0 END ) POS_CSH_OUT_AMT, "
                                            + " SUM( CASE CODE WHEN '04' THEN AMT ELSE 0 END ) WEA_IN_CSH_AMT, "
                                            + " SUM( CASE CODE WHEN '44' THEN AMT ELSE 0 END ) WEA_IN_CRD_AMT, "
                                            + " SUM( CASE CODE WHEN '02' THEN AMT ELSE 0 END ) TK_GFT_SALE_CSH_AMT, "
                                            + " SUM( CASE CODE WHEN '22' THEN AMT ELSE 0 END ) TK_GFT_SALE_CRD_AMT, "
                                            + " SUM( CASE CODE WHEN '03' THEN AMT ELSE 0 END ) TK_FOD_SALE_CSH_AMT, "
                                            + " SUM( CASE CODE WHEN '33' THEN AMT ELSE 0 END ) TK_FOD_SALE_CRD_AMT "
                                        + " FROM CASH_SUM_VW "
                                        + " WHERE SHOP_CD   = ? "
                                            + " AND   SALE_DATE = ? "
                                            + " AND   POS_NO    = ? "
                                            + " AND   REGI_SEQ  = ? ";

    //마감정산 연동형
    this.updateClosingSettlement1 = "UPDATE POS_REGIS_T "
                                        + " SET EMP_NO = ? , CLOSE_FG= ?, CLOSE_DT = strftime('%Y%m%d%H%M%S', 'now', 'localtime'), TOT_BILL_CNT = ?, TOT_SALE_AMT = ?, "
                                        + " TOT_DC_AMT = ?, SVC_TIP_AMT = ? , TOT_ETC_AMT = ? , DCM_SALE_AMT = ?, VAT_SALE_AMT = ?, "
                                        + " VAT_AMT = ?, NO_VAT_SALE_AMT = ?, NO_TAX_SALE_AMT = ?, RET_BILL_CNT =?, RET_BILL_AMT = ?, "
                                        + " VISIT_CST_CNT = ?, POS_CSH_IN_AMT = ?, POS_CSH_OUT_AMT = ?, WEA_IN_CSH_AMT = ?, WEA_IN_CRD_AMT = ?, "
                                        + " TK_GFT_SALE_CSH_AMT = ? , TK_GFT_SALE_CRD_AMT = ? , TK_FOD_SALE_CSH_AMT = ? , TK_FOD_SALE_CRD_AMT = ? , CASH_CNT = ?, "

                                        + " CASH_AMT = ?, CASH_BILL_CNT = ?, CASH_BILL_AMT = ?, CRD_CARD_CNT = ? , CRD_CARD_AMT = ? , "
                                        + " WES_CNT = ?, WES_AMT = ?, TK_GFT_CNT = ?, TK_GFT_AMT = ?, TK_FOD_CNT = ?, "
                                        + " TK_FOD_AMT = ?, CST_POINT_CNT = ?, CST_POINT_AMT = ?, JCD_CARD_CNT = ?, JCD_CARD_AMT = ?, "
                                        + " RFC_CNT = ?, RFC_AMT = ?, ETC_APPR_CNT = ?, ETC_APPR_AMT = ?, DC_GEN_CNT = ?, "
                                        + " DC_GEN_AMT = ?, DC_SVC_CNT = ?, DC_SVC_AMT = ?, DC_JCD_CNT = ?, DC_JCD_AMT = ?, "

                                        + " DC_CPN_CNT = ?, DC_CPN_AMT = ?, DC_CST_CNT = ?, DC_CST_AMT = ?, DC_TFD_CNT = ?, "
                                        + " DC_TFD_AMT = ?, DC_PRM_CNT = ?, DC_PRM_AMT = ?, DC_CRD_CNT = ?, DC_CRD_AMT = ?, "
                                        + " DC_PACK_CNT = ?, DC_PACK_AMT = ?, REPAY_CASH_CNT = ?, REPAY_CASH_AMT = ?, REPAY_TK_GFT_CNT = ?, "
                                        + " REPAY_TK_GFT_AMT = ?, SEND_FG = '0' "
                                    + " WHERE SHOP_CD   = ? "
                                        + " AND   SALE_DATE = ? "
                                        + " AND   POS_NO    = ? "
                                        + " AND   REGI_SEQ  = ? ";

    //마감정산 정산데이터 단독형
    this.selectClosingSettlementData3 = "SELECT CASE WHEN SUM(TOT_BILL_CNT      ) IS NULL THEN 0 ELSE SUM(TOT_BILL_CNT        ) END AS TOT_BILL_CNT "
                                        + " ,CASE WHEN SUM( TOT_SALE_AMT        ) IS NULL THEN 0 ELSE SUM( TOT_SALE_AMT       ) END AS TOT_SALE_AMT "
                                        + " ,CASE WHEN SUM( TOT_DC_AMT          ) IS NULL THEN 0 ELSE SUM( TOT_DC_AMT         ) END AS TOT_DC_AMT "
                                        + " ,CASE WHEN SUM( SVC_TIP_AMT         ) IS NULL THEN 0 ELSE SUM( SVC_TIP_AMT        ) END AS SVC_TIP_AMT "
                                        + " ,CASE WHEN SUM( TOT_ETC_AMT         ) IS NULL THEN 0 ELSE SUM( TOT_ETC_AMT        ) END AS TOT_ETC_AMT "
                                        + " ,CASE WHEN SUM( DCM_SALE_AMT        ) IS NULL THEN 0 ELSE SUM( DCM_SALE_AMT       ) END AS DCM_SALE_AMT "
                                        + " ,CASE WHEN SUM( VAT_SALE_AMT        ) IS NULL THEN 0 ELSE SUM( VAT_SALE_AMT       ) END AS VAT_SALE_AMT "
                                        + " ,CASE WHEN SUM( VAT_AMT             ) IS NULL THEN 0 ELSE SUM( VAT_AMT            ) END AS VAT_AMT "
                                        + " ,CASE WHEN SUM( NO_VAT_SALE_AMT     ) IS NULL THEN 0 ELSE SUM( NO_VAT_SALE_AMT    ) END AS NO_VAT_SALE_AMT "
                                        + " ,CASE WHEN SUM( NO_TAX_SALE_AMT     ) IS NULL THEN 0 ELSE SUM( NO_TAX_SALE_AMT    ) END AS NO_TAX_SALE_AMT "
                                        + " ,CASE WHEN SUM( RET_BILL_CNT        ) IS NULL THEN 0 ELSE SUM( RET_BILL_CNT       ) END AS RET_BILL_CNT "
                                        + " ,CASE WHEN SUM( RET_BILL_AMT        ) IS NULL THEN 0 ELSE SUM( RET_BILL_AMT       ) END AS RET_BILL_AMT "
                                        + " ,CASE WHEN SUM( VISIT_CST_CNT       ) IS NULL THEN 0 ELSE SUM( VISIT_CST_CNT      ) END AS VISIT_CST_CNT "
                                        + " ,CASE WHEN SUM( POS_READY_AMT       ) IS NULL THEN 0 ELSE SUM( POS_READY_AMT      ) END AS POS_READY_AMT "
                                        + " ,CASE WHEN SUM( POS_CSH_IN_AMT      ) IS NULL THEN 0 ELSE SUM( POS_CSH_IN_AMT     ) END AS POS_CSH_IN_AMT "
                                        + " ,CASE WHEN SUM( POS_CSH_OUT_AMT     ) IS NULL THEN 0 ELSE SUM( POS_CSH_OUT_AMT    ) END AS POS_CSH_OUT_AMT "
                                        + " ,CASE WHEN SUM( WEA_IN_CSH_AMT      ) IS NULL THEN 0 ELSE SUM( WEA_IN_CSH_AMT     ) END AS WEA_IN_CSH_AMT "
                                        + " ,CASE WHEN SUM( WEA_IN_CRD_AMT      ) IS NULL THEN 0 ELSE SUM( WEA_IN_CRD_AMT     ) END AS WEA_IN_CRD_AMT "
                                        + " ,CASE WHEN SUM( TK_GFT_SALE_CSH_AMT ) IS NULL THEN 0 ELSE SUM( TK_GFT_SALE_CSH_AMT) END AS TK_GFT_SALE_CSH_AMT "
                                        + " ,CASE WHEN SUM( TK_GFT_SALE_CRD_AMT ) IS NULL THEN 0 ELSE SUM( TK_GFT_SALE_CRD_AMT) END AS TK_GFT_SALE_CRD_AMT "
                                        + " ,CASE WHEN SUM( TK_FOD_SALE_CSH_AMT ) IS NULL THEN 0 ELSE SUM( TK_FOD_SALE_CSH_AMT) END AS TK_FOD_SALE_CSH_AMT "
                                        + " ,CASE WHEN SUM( TK_FOD_SALE_CRD_AMT ) IS NULL THEN 0 ELSE SUM( TK_FOD_SALE_CRD_AMT) END AS TK_FOD_SALE_CRD_AMT "
                                        + " ,CASE WHEN SUM( CASH_CNT            ) IS NULL THEN 0 ELSE SUM( CASH_CNT           ) END AS CASH_CNT "
                                        + " ,CASE WHEN SUM( CASH_AMT            ) IS NULL THEN 0 ELSE SUM( CASH_AMT           ) END AS CASH_AMT "
                                        + " ,CASE WHEN SUM( CASH_BILL_CNT       ) IS NULL THEN 0 ELSE SUM( CASH_BILL_CNT      ) END AS CASH_BILL_CNT "
                                        + " ,CASE WHEN SUM( CASH_BILL_AMT       ) IS NULL THEN 0 ELSE SUM( CASH_BILL_AMT      ) END AS CASH_BILL_AMT "
                                        + " ,CASE WHEN SUM( CRD_CARD_CNT        ) IS NULL THEN 0 ELSE SUM( CRD_CARD_CNT       ) END AS CRD_CARD_CNT "
                                        + " ,CASE WHEN SUM( CRD_CARD_AMT        ) IS NULL THEN 0 ELSE SUM( CRD_CARD_AMT       ) END AS CRD_CARD_AMT "
                                        + " ,CASE WHEN SUM( WES_CNT             ) IS NULL THEN 0 ELSE SUM( WES_CNT            ) END AS WES_CNT "
                                        + " ,CASE WHEN SUM( WES_AMT             ) IS NULL THEN 0 ELSE SUM( WES_AMT            ) END AS WES_AMT "
                                        + " ,CASE WHEN SUM( TK_GFT_CNT          ) IS NULL THEN 0 ELSE SUM( TK_GFT_CNT         ) END AS TK_GFT_CNT "
                                        + " ,CASE WHEN SUM( TK_GFT_AMT          ) IS NULL THEN 0 ELSE SUM( TK_GFT_AMT         ) END AS TK_GFT_AMT "
                                        + " ,CASE WHEN SUM( TK_FOD_CNT          ) IS NULL THEN 0 ELSE SUM( TK_FOD_CNT         ) END AS TK_FOD_CNT "
                                        + " ,CASE WHEN SUM( TK_FOD_AMT          ) IS NULL THEN 0 ELSE SUM( TK_FOD_AMT         ) END AS TK_FOD_AMT "
                                        + " ,CASE WHEN SUM( CST_POINT_CNT       ) IS NULL THEN 0 ELSE SUM( CST_POINT_CNT      ) END AS CST_POINT_CNT "
                                        + " ,CASE WHEN SUM( CST_POINT_AMT       ) IS NULL THEN 0 ELSE SUM( CST_POINT_AMT      ) END AS CST_POINT_AMT "
                                        + " ,CASE WHEN SUM( JCD_CARD_CNT        ) IS NULL THEN 0 ELSE SUM( JCD_CARD_CNT       ) END AS JCD_CARD_CNT "
                                        + " ,CASE WHEN SUM( JCD_CARD_AMT        ) IS NULL THEN 0 ELSE SUM( JCD_CARD_AMT       ) END AS JCD_CARD_AMT "
                                        + " ,CASE WHEN SUM( RFC_CNT             ) IS NULL THEN 0 ELSE SUM( RFC_CNT            ) END AS RFC_CNT "
                                        + " ,CASE WHEN SUM( RFC_AMT             ) IS NULL THEN 0 ELSE SUM( RFC_AMT            ) END AS RFC_AMT "
                                        + " ,CASE WHEN SUM( ETC_APPR_CNT        ) IS NULL THEN 0 ELSE SUM( ETC_APPR_CNT       ) END AS ETC_APPR_CNT "
                                        + " ,CASE WHEN SUM( ETC_APPR_AMT        ) IS NULL THEN 0 ELSE SUM( ETC_APPR_AMT       ) END AS ETC_APPR_AMT "
                                        + " ,CASE WHEN SUM( DC_GEN_CNT          ) IS NULL THEN 0 ELSE SUM( DC_GEN_CNT         ) END AS DC_GEN_CNT "
                                        + " ,CASE WHEN SUM( DC_GEN_AMT          ) IS NULL THEN 0 ELSE SUM( DC_GEN_AMT         ) END AS DC_GEN_AMT "
                                        + " ,CASE WHEN SUM( DC_SVC_CNT          ) IS NULL THEN 0 ELSE SUM( DC_SVC_CNT         ) END AS DC_SVC_CNT "
                                        + " ,CASE WHEN SUM( DC_SVC_AMT          ) IS NULL THEN 0 ELSE SUM( DC_SVC_AMT         ) END AS DC_SVC_AMT "
                                        + " ,CASE WHEN SUM( DC_JCD_CNT          ) IS NULL THEN 0 ELSE SUM( DC_JCD_CNT         ) END AS DC_JCD_CNT "
                                        + " ,CASE WHEN SUM( DC_JCD_AMT          ) IS NULL THEN 0 ELSE SUM( DC_JCD_AMT         ) END AS DC_JCD_AMT "
                                        + " ,CASE WHEN SUM( DC_CPN_CNT          ) IS NULL THEN 0 ELSE SUM( DC_CPN_CNT         ) END AS DC_CPN_CNT "
                                        + " ,CASE WHEN SUM( DC_CPN_AMT          ) IS NULL THEN 0 ELSE SUM( DC_CPN_AMT         ) END AS DC_CPN_AMT "
                                        + " ,CASE WHEN SUM( DC_CST_CNT          ) IS NULL THEN 0 ELSE SUM( DC_CST_CNT         ) END AS DC_CST_CNT "
                                        + " ,CASE WHEN SUM( DC_CST_AMT          ) IS NULL THEN 0 ELSE SUM( DC_CST_AMT         ) END AS DC_CST_AMT "
                                        + " ,CASE WHEN SUM( DC_TFD_CNT          ) IS NULL THEN 0 ELSE SUM( DC_TFD_CNT         ) END AS DC_TFD_CNT "
                                        + " ,CASE WHEN SUM( DC_TFD_AMT          ) IS NULL THEN 0 ELSE SUM( DC_TFD_AMT         ) END AS DC_TFD_AMT "
                                        + " ,CASE WHEN SUM( DC_PRM_CNT          ) IS NULL THEN 0 ELSE SUM( DC_PRM_CNT         ) END AS DC_PRM_CNT "
                                        + " ,CASE WHEN SUM( DC_PRM_AMT          ) IS NULL THEN 0 ELSE SUM( DC_PRM_AMT         ) END AS DC_PRM_AMT "
                                        + " ,CASE WHEN SUM( DC_CRD_CNT          ) IS NULL THEN 0 ELSE SUM( DC_CRD_CNT         ) END AS DC_CRD_CNT "
                                        + " ,CASE WHEN SUM( DC_CRD_AMT          ) IS NULL THEN 0 ELSE SUM( DC_CRD_AMT         ) END AS DC_CRD_AMT "
                                        + " ,CASE WHEN SUM( DC_PACK_CNT         ) IS NULL THEN 0 ELSE SUM( DC_PACK_CNT        ) END AS DC_PACK_CNT "
                                        + " ,CASE WHEN SUM( DC_PACK_AMT         ) IS NULL THEN 0 ELSE SUM( DC_PACK_AMT        ) END AS DC_PACK_AMT "
                                        + " ,CASE WHEN SUM( REM_CHECK_CNT       ) IS NULL THEN 0 ELSE SUM( REM_CHECK_CNT      ) END AS REM_CHECK_CNT "
                                        + " ,CASE WHEN SUM( REM_CHECK_AMT       ) IS NULL THEN 0 ELSE SUM( REM_CHECK_AMT      ) END AS REM_CHECK_AMT "
                                        + " ,CASE WHEN SUM( REM_W100000_CNT     ) IS NULL THEN 0 ELSE SUM( REM_W100000_CNT    ) END AS REM_W100000_CNT "
                                        + " ,CASE WHEN SUM( REM_W50000_CNT      ) IS NULL THEN 0 ELSE SUM( REM_W50000_CNT     ) END AS REM_W50000_CNT "
                                        + " ,CASE WHEN SUM( REM_W10000_CNT      ) IS NULL THEN 0 ELSE SUM( REM_W10000_CNT     ) END AS REM_W10000_CNT "
                                        + " ,CASE WHEN SUM( REM_W5000_CNT       ) IS NULL THEN 0 ELSE SUM( REM_W5000_CNT      ) END AS REM_W5000_CNT "
                                        + " ,CASE WHEN SUM( REM_W1000_CNT       ) IS NULL THEN 0 ELSE SUM( REM_W1000_CNT      ) END AS REM_W1000_CNT "
                                        + " ,CASE WHEN SUM( REM_W500_CNT        ) IS NULL THEN 0 ELSE SUM( REM_W500_CNT       ) END AS REM_W500_CNT "
                                        + " ,CASE WHEN SUM( REM_W100_CNT        ) IS NULL THEN 0 ELSE SUM( REM_W100_CNT       ) END AS REM_W100_CNT "
                                        + " ,CASE WHEN SUM( REM_W50_CNT         ) IS NULL THEN 0 ELSE SUM( REM_W50_CNT        ) END AS REM_W50_CNT "
                                        + " ,CASE WHEN SUM( REM_W10_CNT         ) IS NULL THEN 0 ELSE SUM( REM_W10_CNT        ) END AS REM_W10_CNT "
                                        + " ,CASE WHEN SUM( REM_CASH_AMT        ) IS NULL THEN 0 ELSE SUM( REM_CASH_AMT       ) END AS REM_CASH_AMT  "
                                        + " ,CASE WHEN SUM( REM_TK_GFT_CNT      ) IS NULL THEN 0 ELSE SUM( REM_TK_GFT_CNT     ) END AS REM_TK_GFT_CNT "
                                        + " ,CASE WHEN SUM( REM_TK_GFT_AMT      ) IS NULL THEN 0 ELSE SUM( REM_TK_GFT_AMT     ) END AS REM_TK_GFT_AMT "
                                        + " ,CASE WHEN SUM( REM_TK_FOD_CNT      ) IS NULL THEN 0 ELSE SUM( REM_TK_FOD_CNT     ) END AS REM_TK_FOD_CNT "
                                        + " ,CASE WHEN SUM( REM_TK_FOD_AMT      ) IS NULL THEN 0 ELSE SUM( REM_TK_FOD_AMT     ) END AS REM_TK_FOD_AMT "
                                        + " ,CASE WHEN SUM( ETC_TK_FOD_AMT      ) IS NULL THEN 0 ELSE SUM( ETC_TK_FOD_AMT     ) END AS ETC_TK_FOD_AMT "
                                        + " ,CASE WHEN SUM( LOSS_CASH_AMT       ) IS NULL THEN 0 ELSE SUM( LOSS_CASH_AMT      ) END AS LOSS_CASH_AMT "
                                        + " ,CASE WHEN SUM( LOSS_TK_GFT_AMT     ) IS NULL THEN 0 ELSE SUM( LOSS_TK_GFT_AMT    ) END AS LOSS_TK_GFT_AMT "
                                        + " ,CASE WHEN SUM( LOSS_TK_FOD_AMT     ) IS NULL THEN 0 ELSE SUM( LOSS_TK_FOD_AMT    ) END AS LOSS_TK_FOD_AMT "
                                        + " ,CASE WHEN SUM( REPAY_CASH_CNT      ) IS NULL THEN 0 ELSE SUM( REPAY_CASH_CNT     ) END AS REPAY_CASH_CNT "
                                        + " ,CASE WHEN SUM( REPAY_CASH_AMT      ) IS NULL THEN 0 ELSE SUM( REPAY_CASH_AMT     ) END AS REPAY_CASH_AMT "
                                        + " ,CASE WHEN SUM( REPAY_TK_GFT_CNT    ) IS NULL THEN 0 ELSE SUM( REPAY_TK_GFT_CNT   ) END AS REPAY_TK_GFT_CNT "
                                        + " ,CASE WHEN SUM( REPAY_TK_GFT_AMT    ) IS NULL THEN 0 ELSE SUM( REPAY_TK_GFT_AMT   ) END AS REPAY_TK_GFT_AMT "
                                    + " FROM POS_REGIS_T "
                                    + " WHERE SHOP_CD    = ? "
                                        + " AND   SALE_DATE  = ? "
                                        + " AND   POS_NO    = ? "
                                        + " AND   REGI_SEQ  <> ? ";

    //마감정산 정산데이터 단독형
    this.selectClosingSettlementData4 = "SELECT SUM( CASE CODE WHEN '05' THEN AMT ELSE 0 END ) POS_CSH_IN_AMT, "
                                            + " SUM( CASE CODE WHEN '06' THEN AMT ELSE 0 END ) POS_CSH_OUT_AMT, "
                                            + " SUM( CASE CODE WHEN '04' THEN AMT ELSE 0 END ) WEA_IN_CSH_AMT, "
                                            + " SUM( CASE CODE WHEN '44' THEN AMT ELSE 0 END ) WEA_IN_CRD_AMT, "
                                            + " SUM( CASE CODE WHEN '02' THEN AMT ELSE 0 END ) TK_GFT_SALE_CSH_AMT, "
                                            + " SUM( CASE CODE WHEN '22' THEN AMT ELSE 0 END ) TK_GFT_SALE_CRD_AMT, "
                                            + " SUM( CASE CODE WHEN '03' THEN AMT ELSE 0 END ) TK_FOD_SALE_CSH_AMT, "
                                            + " SUM( CASE CODE WHEN '33' THEN AMT ELSE 0 END ) TK_FOD_SALE_CRD_AMT "
                                        + " FROM CASH_SUM_VW "
                                        + " WHERE SHOP_CD   = ? "
                                            + " AND   SALE_DATE = ? "
                                            + " AND   POS_NO    = ? "
                                            + " AND   REGI_SEQ  <> ? ";

    //마감정산 연동형
    this.updateClosingSettlement2 = "UPDATE POS_REGIS_T "
                                        + " SET EMP_NO = ? , CLOSE_FG= ?, CLOSE_DT = strftime('%Y%m%d%H%M%S', 'now', 'localtime'), TOT_BILL_CNT = ?, TOT_SALE_AMT = ?, "
                                        + " TOT_DC_AMT = ?, SVC_TIP_AMT = ? , TOT_ETC_AMT = ? , DCM_SALE_AMT = ?, VAT_SALE_AMT = ?, "
                                        + " VAT_AMT = ?, NO_VAT_SALE_AMT = ?, NO_TAX_SALE_AMT = ?, RET_BILL_CNT =?, RET_BILL_AMT = ?, "
                                        + " VISIT_CST_CNT = ?, POS_CSH_IN_AMT = ?, POS_CSH_OUT_AMT = ?, WEA_IN_CSH_AMT = ?, WEA_IN_CRD_AMT = ?, "
                                        + " TK_GFT_SALE_CSH_AMT = ? , TK_GFT_SALE_CRD_AMT = ? , TK_FOD_SALE_CSH_AMT = ? , TK_FOD_SALE_CRD_AMT = ? , CASH_CNT = ?, "

                                        + " CASH_AMT = ?, CASH_BILL_CNT = ?, CASH_BILL_AMT = ?, CRD_CARD_CNT = ? , CRD_CARD_AMT = ? , "
                                        + " WES_CNT = ?, WES_AMT = ?, TK_GFT_CNT = ?, TK_GFT_AMT = ?, TK_FOD_CNT = ?, "
                                        + " TK_FOD_AMT = ?, CST_POINT_CNT = ?, CST_POINT_AMT = ?, JCD_CARD_CNT = ?, JCD_CARD_AMT = ?, "
                                        + " RFC_CNT = ?, RFC_AMT = ?, ETC_APPR_CNT = ?, ETC_APPR_AMT = ?, DC_GEN_CNT = ?, "
                                        + " DC_GEN_AMT = ?, DC_SVC_CNT = ?, DC_SVC_AMT = ?, DC_JCD_CNT = ?, DC_JCD_AMT = ?, "

                                        + " DC_CPN_CNT = ?, DC_CPN_AMT = ?, DC_CST_CNT = ?, DC_CST_AMT = ?, DC_TFD_CNT = ?, "
                                        + " DC_TFD_AMT = ?, DC_PRM_CNT = ?, DC_PRM_AMT = ?, DC_CRD_CNT = ?, DC_CRD_AMT = ?, "
                                        + " DC_PACK_CNT = ?, DC_PACK_AMT = ?, REM_CHECK_CNT = ?, REM_CHECK_AMT = ?, REM_W100000_CNT = ?, "
                                        + " REM_W50000_CNT = ?, REM_W10000_CNT = ?, REM_W5000_CNT = ?, REM_W1000_CNT = ?, REM_W500_CNT = ?, "
                                        + " REM_W100_CNT = ?, REM_W50_CNT = ?, REM_W10_CNT = ?, REM_CASH_AMT = ?, REM_TK_GFT_CNT = ?, "

                                        + " REM_TK_GFT_AMT = ?, REM_TK_FOD_CNT = ?, REM_TK_FOD_AMT = ?, ETC_TK_FOD_AMT = ?, LOSS_CASH_AMT = ?, "
                                        + " LOSS_TK_GFT_AMT = ?, LOSS_TK_FOD_AMT = ? , REPAY_CASH_CNT = ?, REPAY_CASH_AMT = ?, REPAY_TK_GFT_CNT = ?, "
                                        + " REPAY_TK_GFT_AMT = ?, SEND_FG = '0' "
                                    + " WHERE SHOP_CD   = ? "
                                        + " AND   SALE_DATE = ? "
                                        + " AND   REGI_SEQ  = '00' ";

    this.selectCloseCancel = "SELECT A.SALE_DATE, A.REGI_SEQ, A.CLOSE_DT, A.CLOSE_FG, A.EMP_NO, B.EMP_NM "
                                + " FROM POS_REGIS_T A LEFT OUTER JOIN SCD_EMPMS_T B "
                                    + " ON  A.SHOP_CD = B.SHOP_CD "
                                    + " AND A.EMP_NO  =B.EMP_NO "
                                + " WHERE A.SHOP_CD  = ? "
                                    + " AND   A.POS_NO   = ? "
                                    + " AND   A.REGI_SEQ = ? "
                                + " ORDER BY A.SALE_DATE DESC, A.REGI_SEQ DESC "
                                + " LIMIT 1 ";

    this.selectLoginCheck = "SELECT EMP_NM, EMP_NO, EMP_FG, WEB_USE_YN, USER_ID "
                                + " , USER_PWD, POSTING_YN "
                             + " FROM SCD_EMPMS_T "
                             + " WHERE SHOP_CD = ? "
                                + " AND EMP_NO = ? "
                             	+ " AND UPPER(EMP_PWD)   = UPPER(?) "
                             	+ " AND RETIRE_FG = '0' "
                             	+ " AND USE_YN    = 'Y'";

    this.updateCloseCancel = " UPDATE POS_REGIS_T "
                                + " SET CLOSE_FG = ? ,"
                                    + " EMP_NO = ?, "
                                    + " SEND_FG = 0 "
                                + " WHERE SHOP_CD = ? "
                                    + " AND SALE_DATE = ? "
                                    + " AND POS_NO = ? "
                                    + " AND REGI_SEQ = ? ";

    //현재 주문건수
    this.selectRemainOrderCnt = "SELECT COUNT( HDR.ORDER_NO ) AS ORD_CNT "
                                + " FROM POS_ODHDR_T HDR, SCD_TABLE_T TBL "
                                + " WHERE HDR.SHOP_CD      = ? "
                                    + " AND   HDR.SALE_DATE    = ? "
                                    + " AND   HDR.DLV_ORDER_FG = '0' "
                                    + " AND   HDR.ORDER_END_FG = '0' "
                                    + " AND   HDR.FD_TBL_CD    <> '000' "
                                    + " AND   HDR.ORDER_NO     <> '' "
                                    + " AND   HDR.SHOP_CD      = TBL.SHOP_CD "
                                    + " AND   HDR.FD_TBL_CD    = TBL.TABLE_CD ";

    //현재 배달건수
    this.selectRemainDeliveryCnt = "SELECT COUNT( HDR.ORDER_NO ) AS ORD_CNT "
                                    + " FROM POS_ODHDR_T HDR "
                                    + " WHERE HDR.SHOP_CD      = ? "
                                        + " AND   HDR.SALE_DATE    = ? "
                                        + " AND   HDR.DLV_ORDER_FG = '2' "
                                        + " AND   HDR.ORDER_END_FG IN ( '0', '3' ) "
                                        + " AND   HDR.FD_TBL_CD    <> '000' "
                                        + " AND   HDR.ORDER_NO     <> '' ";

    //현재 대기내역
    this.selectRemainWaitCnt = "SELECT COUNT( HDR.ORDER_NO ) AS ORD_CNT "
                                + " FROM POS_ODHDR_T HDR "
                                + " WHERE HDR.SHOP_CD       = ? "
                                    + " AND   HDR.SALE_DATE     = ? "
                                    + " AND   HDR.DLV_ORDER_FG  = '0' "
                                    + " AND   HDR.ORDER_END_FG    = '0' "
                                    + " AND   HDR.FD_TBL_CD    = '000' "
                                    + " AND   HDR.ORDER_NO     <> '' ";

    //배달정보 삭제
    this.updateScdTableT = "UPDATE SCD_TABLE_T "
                                + " SET CST_NO     = NULL, CST_NM       = NULL, CID_TEL_NO   = NULL, CID_LINE_NO  = NULL, NEW_CST_FG   = '0' "
                                + " , DLV_ADDR     = NULL, DLV_ADDR_DTL = NULL, STATUS_FG    = '1', DLV_CL_CD    = NULL, DLV_CM_CD    = NULL "
                                + " , CID_CALL_DT  = NULL "
                            + " WHERE SHOP_CD  = ? ";

    //자동정산 SUB POS 마감
    this.selectSubPosCloseList = "SELECT POS_NO, REGI_SEQ, SUM(TOT_BILL_CNT) AS TOT_BILL_CNT, SUM(TOT_SALE_AMT) AS TOT_SALE_AMT, SUM(TOT_DC_AMT) AS TOT_DC_AMT "
                                    + " , SUM(SVC_TIP_AMT) AS SVC_TIP_AMT, SUM(TOT_ETC_AMT) AS TOT_ETC_AMT, SUM(DCM_SALE_AMT) AS DCM_SALE_AMT, SUM(VAT_SALE_AMT) AS VAT_SALE_AMT "
                                    + " , SUM(VAT_AMT) AS VAT_AMT, SUM(NO_VAT_SALE_AMT) AS NO_VAT_SALE_AMT, SUM(NO_TAX_SALE_AMT) AS NO_TAX_SALE_AMT, SUM(RET_BILL_CNT) AS RET_BILL_CNT "
                                    + " , SUM(CANCEL_TOT_AMT) AS CANCEL_TOT_AMT, SUM(FD_GST_CNT_T) AS FD_GST_CNT_T, SUM(CASH_CNT) AS CASH_CNT, SUM(CASH_AMT) AS CASH_AMT "
                                    + " , SUM(CASH_BILL_CNT) AS CASH_BILL_CNT, SUM(CASH_BILL_AMT) AS CASH_BILL_AMT, SUM(CARD_CNT) AS CARD_CNT, SUM(CRD_CARD_AMT) AS CRD_CARD_AMT "
                                    + " , SUM(WES_CNT) AS WES_CNT, SUM(WES_AMT) AS WES_AMT, SUM(TK_GFT_CNT) AS TK_GFT_CNT, SUM(TK_GFT_AMT) AS TK_GFT_AMT "
                                    + " , SUM(TK_FOD_CNT) AS TK_FOD_CNT, SUM(TK_FOD_AMT) AS TK_FOD_AMT, SUM(CST_POINT_CNT) AS CST_POINT_CNT, SUM(CST_POINT_AMT) AS CST_POINT_AMT "
                                    + " , SUM(JCD_CARD_CNT) AS JCD_CARD_CNT, SUM(JCD_CARD_AMT) AS JCD_CARD_AMT, SUM(RFC_CNT) AS RFC_CNT, SUM(RFC_AMT) AS RFC_AMT "
                                    + " , SUM(ETC_APPR_CNT) AS ETC_APPR_CNT, SUM(ETC_APPR_AMT) AS ETC_APPR_AMT, SUM(DC_GEN_CNT) AS DC_GEN_CNT, SUM(DC_GEN_AMT) AS DC_GEN_AMT "
                                    + " , SUM(DC_SVC_CNT) AS DC_SVC_CNT, SUM(DC_SVC_AMT) AS DC_SVC_AMT, SUM(DC_PCD_CNT) AS DC_PCD_CNT, SUM(DC_PCD_AMT) AS DC_PCD_AMT "
                                    + " , SUM(DC_CPN_CNT) AS DC_CPN_CNT, SUM(DC_CPN_AMT) AS DC_CPN_AMT, SUM(DC_CST_CNT) AS DC_CST_CNT, SUM(DC_CST_AMT) AS DC_CST_AMT "
                                    + " , SUM(DC_TFD_CNT) AS DC_TFD_CNT, SUM(DC_TFD_AMT) AS DC_TFD_AMT, SUM(DC_PRM_CNT) AS DC_PRM_CNT, SUM(DC_PRM_AMT) AS DC_PRM_AMT "
                                    + " , SUM(DC_CRD_CNT) AS DC_CRD_CNT, SUM(DC_CRD_AMT) AS DC_CRD_AMT, SUM(DC_PACK_CNT) AS DC_PACK_CNT, SUM(DC_PACK_AMT) AS DC_PACK_AMT "
                                    + " , SUM(REPAY_CASH_CNT) AS REPAY_CASH_CNT, SUM(REPAY_CASH_AMT) AS REPAY_CASH_AMT, SUM(REPAY_TK_GFT_CNT) AS REPAY_TK_GFT_CNT, SUM(REPAY_TK_GFT_AMT) AS REPAY_TK_GFT_AMT "
                                + " FROM REGI_SUM_VW "
                                + " WHERE SHOP_CD   = ? "
                                    + " AND   SALE_DATE = ? "
                                    + " AND   REGI_SEQ <> '00'"
                                + " GROUP BY POS_NO, REGI_SEQ ";

    //자동정산 SUB POS 마감
    this.selectSubPosList = "SELECT POS_NO, REGI_SEQ"
                                + " FROM POS_REGIS_T "
                                + " WHERE SHOP_CD   = ? "
                                    + " AND   SALE_DATE = ? "
                                    + " AND   REGI_SEQ <> '00'";

    //영수증 관리 리스트
    this.selectReceiptManagementList = "SELECT A.SHOP_CD, A.SALE_DATE, A.POS_NO, A.BILL_NO "
                                           + " , A.SALE_DATE || A.POS_NO || A.BILL_NO AS SALE_NO "
                                           + " , A.ORDER_NO "
                                           + " , A.REGI_SEQ "
                                           + " , CASE A.SALE_YN WHEN 'Y' THEN ( CASE COALESCE( TRIM(A.ORG_BILL_NO), '' )  WHEN ''  THEN '' ELSE '반품원거래'END )  WHEN 'N' THEN '반품매출' ELSE '' END AS SALE_FG "
                                           + " , CASE A.SALE_YN WHEN 'Y' THEN A.EXP_PAY_AMT + (CASE WHEN A.CUP_DEPOSIT_AMT IS NOT NULL THEN A.CUP_DEPOSIT_AMT ELSE 0 END)  "
                                           + "							ELSE (A.EXP_PAY_AMT + (CASE WHEN A.CUP_DEPOSIT_AMT IS NOT NULL THEN A.CUP_DEPOSIT_AMT ELSE 0 END))  * -1 END EXP_PAY_AMT "
                                           + " , CASE A.SALE_YN WHEN 'Y' THEN A.CASH_AMT      ELSE A.CASH_AMT      * -1 END CASH_AMT "
                                           + " , CASE A.SALE_YN WHEN 'Y' THEN A.CASH_BILL_AMT ELSE A.CASH_BILL_AMT * -1 END CASH_BILL_AMT "
                                           + " , CASE A.SALE_YN WHEN 'Y' THEN A.CRD_CARD_AMT  ELSE A.CRD_CARD_AMT  * -1 END CRD_CARD_AMT "
                                           + " , A.FD_TBL_CD "
                                       	   + " , CASE WHEN A.TOT_DC_AMT> 0 THEN 'Y' ELSE '' END DC_FG   "
                                           + " , CASE A.SALE_YN WHEN 'Y' THEN A.CASH_AMT - A.CASH_BILL_AMT ELSE 0 END CASH_GAB_AMT "
                                           + " , A.ORG_BILL_NO "
                                           + " , CASE B.TABLE_NM WHEN '' THEN '' ELSE B.TABLE_NM END TABLE_NM "
                                           + " , A.PAY_OUT_DT "
                                           + " , CASE A.SALE_YN WHEN 'Y' THEN A.ETC_APPR_AMT  ELSE A.ETC_APPR_AMT  * -1 END ETC_APPR_AMT  "
                                           + " , A.TK_GFT_AMT AS TK_GFT_AMT "
                                           + " , A.CUP_DEPOSIT_AMT AS TK_GFT_AMT "
                                        + " FROM  SSL_TRHDR_T A LEFT OUTER JOIN SCD_TABLE_T B "
                                            + " ON    A.SHOP_CD = B.SHOP_CD AND   A.FD_TBL_CD = B.TABLE_CD "
                                        + " WHERE A.SHOP_CD   = ? "
                                        	+ " AND A.SALE_DATE = ? AND A.POS_NO = ? "
                                        + " ORDER BY A.BILL_NO DESC ";
    //반품 승인 건수 확인 쿼리
    this.selectReturnApprovalCnt = "SELECT SUM( A.CNT ) AS CNT"
                                    + " FROM ( SELECT COUNT( BILL_NO ) AS CNT "
                                        + " FROM SSL_TRCRD_T "
                                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND SALE_YN = 'Y' AND APPR_PROC_FG <> '0' "
                                    + " UNION ALL "
                                        + " SELECT COUNT( BILL_NO ) AS CNT "
                                        + " FROM SSL_TRCSH_T "
                                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND SALE_YN = 'Y' AND APPR_PROC_FG <> '0' "
                                    + " UNION ALL "
                                        + " SELECT COUNT( BILL_NO ) AS CNT "
                                        + " FROM SSL_TRJCD_T "
                                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND SALE_YN = 'Y' AND APPR_PROC_FG <> '0' "
                                            + " AND JCD_PROC_FG  <> '9' AND JCD_CD <> 'ZBNK' "
                                    + " UNION ALL "
                                        + " SELECT COUNT( BILL_NO ) AS CNT "
                                        + " FROM SSL_TRETC_T "
                                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND SALE_YN = 'Y' AND APPR_PROC_FG <> '0' "
                                            + " AND TR_TYPE_CD IN('011', '021', '041', '042', '051', '161', '141' ) ) A ";

    //승인 취소 결제 내역 목록
    this.selectPaymentDetailList = "SELECT AA.PAY_SEQ_NO, AA.PAY_TYPE_FG "
                                        + "\n , ( (SELECT CASE WHEN '09' = AA.PAY_TYPE_FG THEN CASE WHEN 'M' = ? THEN '회원마일리지' ELSE '회원스탬프금액' END ELSE COM_CD_NM END AS COM_CD_NM "
                                            + "\n    FROM CCD_CODEM_T "
                                            + "\n   WHERE COM_CD_FG= '038' "
                                                + "\n AND COM_CD = AA.PAY_TYPE_FG "
                                                + "\n AND USE_YN = 'Y') || (CASE WHEN BB.TR_TYPE_CD = '111' THEN '(적립)' ELSE '' END)) AS PAY_TYPE_NM "
                                        + "\n , AA.SALE_YN, AA.PAY_AMT, COALESCE(AA.LINE_NO, '') AS LINE_NO, COALESCE(BB.APPR_PROC_FG, '0') AS APPR_PROC_FG "
                                        + "\n , BB.CARD_NO, BB.SIGN_PAD_YN, BB.JCD_PROC_FG "
                                        + "\n , CASE COALESCE( BB.APPR_PROC_FG,'0' ) WHEN '0' THEN 'A' WHEN '2' THEN 'U' WHEN '4' THEN 'A' WHEN '5' THEN 'M' "
                                            + "\n ELSE ( CASE AA.PAY_TYPE_FG WHEN '02' THEN 'S' WHEN '03' THEN 'P' WHEN '04' THEN ( CASE BB.JCD_CD WHEN 'ZBNK' THEN 'A' ELSE 'M' END ) "
                                                + "\n WHEN '11' THEN ( CASE BB.JCD_CD WHEN 'ZBNK' THEN 'M' ELSE 'A' END ) ELSE 'M'  END ) END AS STATUS "
                                        + "\n , BB.CARD_IN_FG, BB.UNION_PAY_FG, BB.DDC_FLAG, BB.TR_TYPE_CD, CASE WHEN AA.SALE_YN ='N' THEN '취소완료' ELSE '' END AS SALE_NM "
                                        + "\n, CASE WHEN ORG_APPR_CNT = 0 THEN '취소완료' ELSE '' END AS REFUND_NM "
                                        + "\n, ORG_APPR_NO, DTL_TYPE_FG, ORG_APPR_CNT "
                                    + "\n FROM SSL_TRPSQ_T AA "
                                        + "\n LEFT OUTER JOIN ( "
                                            + "\n SELECT SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, '02' AS PAY_TYPE_FG, APPR_PROC_FG, CRD_CARD_NO AS CARD_NO "
                                                + "\n, MAX(SIGN_PAD_YN) as SIGN_PAD_YN , '' AS JCD_PROC_FG, CARD_IN_FG, UNION_PAY_FG, MAX(DDC_FLAG) as DDC_FLAG "
                                                + "\n , '' AS JCD_CD, '' AS TR_TYPE_CD, ORG_APPR_NO, '' AS DTL_TYPE_FG "
                                                + "\n, (SELECT COUNT(*) FROM SSL_TRCRD_T WHERE A.SHOP_CD = SHOP_CD AND A.SALE_DATE = SALE_DATE	AND A.POS_NO = POS_NO AND A.BILL_NO = BILL_NO AND (ORG_APPR_NO IS NULL OR ORG_APPR_NO = '')) AS ORG_APPR_CNT "
                                            + "\n FROM SSL_TRCRD_T A "
                                            + "\n WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? "
                                            + "\n GROUP BY SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, APPR_PROC_FG, CRD_CARD_NO, CARD_IN_FG, UNION_PAY_FG "
                                            + "\n UNION ALL "
                                            + "\n SELECT SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, '01' AS PAY_TYPE_FG, APPR_PROC_FG, APPR_IDT_NO AS CARD_NO, '' AS SIGN_PAD_YN "
                                                + "\n , '' AS JCD_PROC_FG, CARD_IN_FG, '0' AS UNION_PAY_FG, '' AS DDC_FLAG, '' AS JCD_CD, '' AS TR_TYPE_CD, ORG_APPR_NO, ''  AS DTL_TYPE_FG "
                                                + "\n, (SELECT COUNT(*) FROM SSL_TRCSH_T WHERE A.SHOP_CD = SHOP_CD AND A.SALE_DATE = SALE_DATE	AND A.POS_NO = POS_NO AND A.BILL_NO = BILL_NO AND (ORG_APPR_NO IS NULL OR ORG_APPR_NO = '')) AS ORG_APPR_CNT"
                                            + "\n FROM SSL_TRCSH_T A "
                                            + "\n WHERE SHOP_CD = ? AND SALE_DATE= ? AND POS_NO = ? AND BILL_NO = ? "
                                            + "\n GROUP BY SHOP_CD , SALE_DATE, POS_NO, BILL_NO, LINE_NO, APPR_PROC_FG, APPR_IDT_NO, CARD_IN_FG, UNION_PAY_FG, DDC_FLAG "
                                            + "\n UNION ALL "
                                            + "\n SELECT SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO "
                                                + "\n, CASE JCD_PROC_FG WHEN '0' THEN '04' WHEN '1' THEN '07' WHEN '6' THEN '03' WHEN '2' THEN '03' END AS PAY_TYPE_FG "
                                                + "\n, APPR_PROC_FG, JCD_CARD_NO AS CARD_NO, SIGN_PAD_YN, JCD_PROC_FG, CARD_IN_FG, '0' AS UNION_PAY_FG "
                                                + "\n, ''  AS DDC_FLAG, JCD_CD, '' AS TR_TYPE_CD, ORG_APPR_NO, JCD_TYPE_FG AS DTL_TYPE_FG "
                                                + "\n, (SELECT COUNT(*) FROM SSL_TRJCD_T WHERE A.SHOP_CD = SHOP_CD AND A.SALE_DATE = SALE_DATE	AND A.POS_NO = POS_NO AND A.BILL_NO = BILL_NO AND (ORG_APPR_NO IS NULL OR ORG_APPR_NO = '')) AS ORG_APPR_CNT"
                                            + "\n FROM SSL_TRJCD_T A "
                                            + "\n WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND JCD_PROC_FG IN ('0','1','2','6') "
                                            + "\n GROUP BY SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, APPR_PROC_FG, JCD_CARD_NO, SIGN_PAD_YN, JCD_PROC_FG "
                                                + "\n , CARD_IN_FG, UNION_PAY_FG, DDC_FLAG, JCD_CD "
                                            + "\n UNION ALL "
                                            + "\n SELECT SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, '11' AS PAY_TYPE_FG, APPR_PROC_FG, CARD_NO, '' AS SIGN_PAD_YN "
                                                + "\n , '' AS JCD_PROC_FG, 'K' AS CARD_IN_FG, '0' AS UNION_PAY_FG, ''  AS DDC_FLAG "
                                                + "\n , CASE TR_TYPE_CD WHEN '001' THEN '' WHEN '002' THEN '' WHEN '003' THEN '' WHEN '011' THEN 'ZBNK' WHEN '021' THEN 'ZBNK' "
                                                    + "\n WHEN '041' THEN 'ZBNK' WHEN '042' THEN 'ZBNK' END AS JCD_CD, TR_TYPE_CD, ORG_APPR_NO, '' AS DTL_TYPE_FG "
                                                    + "\n, (SELECT COUNT(*) FROM SSL_TRETC_T WHERE A.SHOP_CD = SHOP_CD AND A.SALE_DATE = SALE_DATE	AND A.POS_NO = POS_NO AND A.BILL_NO = BILL_NO AND TR_TYPE_CD NOT IN ('001', '002', '003') AND  (ORG_APPR_NO IS NULL OR ORG_APPR_NO = '')) AS ORG_APPR_CNT"
                                            + "\n FROM SSL_TRETC_T A "
                                            + "\n WHERE SHOP_CD= ? AND   SALE_DATE= ? AND   POS_NO= ? AND   BILL_NO= ? "
                                            + "\n GROUP BY SHOP_CD , SALE_DATE , POS_NO , BILL_NO , LINE_NO, APPR_PROC_FG, CARD_NO, CARD_IN_FG, UNION_PAY_FG , DDC_FLAG, JCD_CD, TR_TYPE_CD) BB "
                                        + "\n ON  BB.SHOP_CD     = AA.SHOP_CD "
                                            + "\n AND BB.SALE_DATE   = AA.SALE_DATE "
                                            + "\n AND BB.POS_NO      = AA.POS_NO "
                                            + "\n AND BB.BILL_NO     = AA.BILL_NO "
                                            + "\n AND BB.LINE_NO     = AA.LINE_NO "
                                            + "\n AND BB.PAY_TYPE_FG = AA.PAY_TYPE_FG "
                                    + "\n WHERE AA.SHOP_CD= ? AND AA.SALE_DATE= ? AND AA.POS_NO= ? AND AA.BILL_NO= ? "
                                    + "\n ORDER BY BB.APPR_PROC_FG DESC, AA.PAY_TYPE_FG, AA.PAY_SEQ_NO ";

    //승인 취소 승인 내역 목록
    this.selectApprovalDetailList = "SELECT BB.SEQ_NO, AA.PAY_TYPE_FG "
                                        + " , ( SELECT CASE WHEN '09' = AA.PAY_TYPE_FG THEN CASE WHEN 'M' = ? THEN '회원마일리지' ELSE '회원스탬프금액' END ELSE COM_CD_NM END AS COM_CD_NM "
                                            + " FROM CCD_CODEM_T "
                                            + " WHERE COM_CD_FG= '038' "
                                                + " AND COM_CD = AA.PAY_TYPE_FG "
                                                + " AND USE_YN = 'Y') AS PAY_TYPE_NM "
                                        + " , CASE AA.SALE_YN WHEN 'Y' THEN '정상' ELSE '취소' END AS STATUS, AA.PAY_AMT, COALESCE( BB.LINE_NO, '' ) AS LINE_NO "
                                        + " , BB.CORNER_CD, BB.VAN_TERM_NO, BB.APPR_REQ_AMT, BB.APPR_AMT, BB.VAT_AMT, BB.SVC_TIP_AMT, BB.APPR_TYPE_FG "
                                        + " , BB.APPR_FG, BB.APPR_PROC_FG, BB.CARD_IN_FG, BB.APPR_DATE, BB.APPR_NO, BB.APPR_IDT_TYPE, BB.APPR_IDT_FG "
                                        + " , BB.CARD_NO, BB.INST_MM_FG, BB.INST_MM_CNT, BB.VALID_TERM, BB.SIGN_PAD_YN, BB.CRDCP_CD, BB.APPR_DC_AMT "
                                        + " , BB.APPR_LOG_NO, BB.JCD_PROC_FG, BB.JCD_TYPE_FG, BB.JCD_PAY_FG, BB.CNMK_CD, BB.UNION_PAY_FG, BB.USER_DATA "
                                    + " FROM SSL_TRPSQ_T AA "
                                        + " INNER JOIN ( SELECT SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, SEQ_NO, '02' AS PAY_TYPE_FG, SALE_YN, CORNER_CD "
                                            + " , VAN_TERM_NO, APPR_REQ_AMT, APPR_AMT, VAT_AMT, SVC_TIP_AMT, '0' AS APPR_TYPE_FG, SALE_YN AS APPR_FG "
                                            + " , APPR_PROC_FG, CARD_IN_FG, APPR_DATE, APPR_NO, '' AS APPR_IDT_TYPE, '' AS APPR_IDT_FG, CRD_CARD_NO AS CARD_NO "
                                            + " , INST_MM_FG, INST_MM_CNT, VALID_TERM, SIGN_PAD_YN, CRDCP_CD, APPR_DC_AMT, APPR_LOG_NO, '' AS JCD_PROC_FG "
                                            + " , '' AS JCD_TYPE_FG, '' AS JCD_PAY_FG, CNMK_CD, UNION_PAY_FG, '' AS USER_DATA "
                                        + " FROM SSL_TRCRD_T "
                                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND APPR_PROC_FG <> '0' "
                                    + " UNION ALL "
                                        + " SELECT SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, SEQ_NO, '01' AS PAY_TYPE_FG, SALE_YN, CORNER_CD, VAN_TERM_NO "
                                            + " , 0 AS APPR_REQ_AMT, APPR_AMT, VAT_AMT, SVC_TIP_AMT, '0' AS APPR_TYPE_FG, SALE_YN AS APPR_FG, APPR_PROC_FG "
                                            + " , CARD_IN_FG, APPR_DATE, APPR_NO, APPR_IDT_TYPE, APPR_IDT_FG, APPR_IDT_NO AS CARD_NO, '' AS INST_MM_FG "
                                            + " , 0 AS INST_MM_CNT, '' AS VALID_TERM, '' AS SIGN_PAD_YN, '' AS CRDCP_CD, 0 AS APPR_DC_AMT, APPR_LOG_NO "
                                            + " , '' AS JCD_PROC_FG, '' AS JCD_TYPE_FG, '' AS JCD_PAY_FG, CNMK_CD, '0' AS UNION_PAY_FG, '' AS USER_DATA "
                                        + " FROM SSL_TRCSH_T "
                                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND APPR_PROC_FG <> '0' AND COALESCE( APPR_NO,'' ) <> '' "
                                    + " UNION ALL "
                                        + " SELECT SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, SEQ_NO, CASE JCD_PROC_FG WHEN '0' THEN '04' WHEN '1' THEN '07' WHEN '6' THEN '03' WHEN '2' THEN '03' END AS PAY_TYPE_FG "
                                            + " , SALE_YN, CORNER_CD, VAN_TERM_NO, 0 AS APPR_REQ_AMT, APPR_AMT, 0 AS VAT_AMT, 0 AS SVC_TIP_AMT, '0' AS APPR_TYPE_FG, SALE_YN AS APPR_FG, APPR_PROC_FG "
                                            + " , CARD_IN_FG, APPR_DATE, APPR_NO, '' AS APPR_IDT_TYPE, '' AS APPR_IDT_FG, JCD_CARD_NO AS CARD_NO, '' AS INST_MM_FG, 0 AS INST_MM_CNT, VALID_TERM "
                                            + " , SIGN_PAD_YN, '' AS CRDCP_CD, 0 AS APPR_DC_AMT, APPR_LOG_NO, JCD_PROC_FG, JCD_TYPE_FG, JCD_PAY_FG, CNMK_CD , '0' AS UNION_PAY_FG, '' AS USER_DATA "
                                        + " FROM SSL_TRJCD_T "
                                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND APPR_PROC_FG <> '0' AND JCD_CD <> 'ZBNK' AND   JCD_PROC_FG  IN ('0','1','2','6') "
                                    + " UNION ALL "
                                        + " SELECT SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, SEQ_NO, '11' AS PAY_TYPE_FG, SALE_YN, CORNER_CD, 0 AS VAN_TERM_NO "
                                            + " , APPR_AMT AS APPR_REQ_AMT, APPR_AMT, VAT_AMT, SVC_TIP_AMT, '0' AS APPR_TYPE_FG, SALE_YN AS APPR_FG, APPR_PROC_FG "
                                            + " , 'K' AS CARD_IN_FG, APPR_DATE, APPR_NO, '' AS APPR_IDT_TYPE, '' AS APPR_IDT_FG, CARD_NO, '' AS INST_MM_FG, 0 AS INST_MM_CNT "
                                            + " , '' AS VALID_TERM, '' AS SIGN_PAD_YN, '' AS CRDCP_CD, 0 AS APPR_DC_AMT, '' APPR_LOG_NO, '' AS JCD_PROC_FG, '' AS JCD_TYPE_FG "
                                            + " , '' AS JCD_PAY_FG, '' AS CNMK_CD, '0' AS UNION_PAY_FG, USER_DATA "
                                        + " FROM SSL_TRETC_T "
                                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND APPR_PROC_FG <> '0' "
                                            + " AND   TR_TYPE_CD IN ('011', '021', '041', '042', '051', '161', '141') ) BB "
                                    + " ON  BB.SHOP_CD = AA.SHOP_CD AND BB.SALE_DATE = AA.SALE_DATE AND BB.POS_NO = AA.POS_NO AND BB.BILL_NO = AA.BILL_NO "
                                        + " AND BB.LINE_NO = AA.LINE_NO AND BB.PAY_TYPE_FG = AA.PAY_TYPE_FG "
                                    + " WHERE AA.SHOP_CD = ? AND AA.SALE_DATE = ? AND AA.POS_NO = ? AND AA.BILL_NO = ? AND AA.PAY_SEQ_NO = ? AND BB.APPR_PROC_FG <> '0' "
                                    + " ORDER BY AA.PAY_TYPE_FG, AA.PAY_SEQ_NO ";
    //영수증번호 생성
    this.selectBillNo = "SELECT  SUBSTR('0000' || IFNULL(MAX( CAST( BILL_NO AS INTEGER ) ) + 1 , 1), -4, 4) AS BILL_NO"
                        + " FROM SSL_TRHDR_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? ";
    
    //POS주문번호 생성
    this.selectPosOrderNo = "SELECT SUBSTR('0000' || IFNULL(MAX( CAST( ORDER_NO AS INTEGER ) ) + 1 , 1), -4, 4) AS MAX_ORDER_NO"
                        + " FROM POS_ODHDR_T "
                        + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ?";

    //반품처리
    this.insertSalesHeader = "INSERT INTO SSL_TRHDR_T "
                                + " (SHOP_CD, SALE_DATE, POS_NO, BILL_NO, REGI_SEQ, "
                                + " SALE_YN, TOT_SALE_AMT, TOT_DC_AMT, SVC_TIP_AMT, TOT_ETC_AMT, "
                                + " DCM_SALE_AMT, VAT_SALE_AMT, VAT_AMT, NO_VAT_SALE_AMT, NO_TAX_SALE_AMT, "
                                + " EXP_PAY_AMT, GST_PAY_AMT, RET_PAY_AMT, CASH_AMT, CRD_CARD_AMT, "
                                + " WES_AMT, TK_GFT_AMT, TK_FOD_AMT, CST_POINT_AMT, JCD_CARD_AMT, "
                                + " RFC_AMT, ETC_APPR_AMT, DC_GEN_AMT, DC_SVC_AMT, DC_PCD_AMT, "
                                + " DC_CPN_AMT, DC_CST_AMT, DC_TFD_AMT, DC_PRM_AMT, DC_CRD_AMT, "
                                + " DC_PACK_AMT, DC_LYT_AMT, REPAY_CASH_AMT, REPAY_TK_GFT_AMT, CASH_BILL_AMT, "
                                + " DLV_ORDER_FG, FD_TBL_CD, FD_GST_CNT_T, FD_GST_CNT_1, FD_GST_CNT_2, "
                                + " FD_GST_CNT_3, FD_GST_CNT_4, ORG_BILL_NO, ORDER_NO, INS_DT, "
                                + " EMP_NO, SEND_FG, SEND_DT, CST_NO, CST_CARD_NO, "
                                + " CST_SALE_POINT, PAY_OUT_DT, CST_NM,  DLV_EMP_NO, DLV_START_DT, "
                                + " DLV_PAYIN_EMP_NO, DLV_PAYIN_DT, NEW_DLV_ADDR_YN, DLV_ADDR, DLV_ADDR_DTL, "
                                + " NEW_DLV_TEL_NO_YN, DLV_TEL_NO , DLV_CL_CD, DLV_CM_CD, TRAVEL_CD, "
                                + " RSV_NO, PRE_PAY_CASH, PRE_PAY_CARD, RSV_USER_NM, RSV_USER_TEL_NO, "
                                + " CST_AVL_POINT, LOCAL_POINT_YN, CST_USE_POINT, CANCEL_REASON, CUP_DEPOSIT_AMT "
                                + " ) "
                            + " SELECT SHOP_CD, ?, POS_NO, ?, REGI_SEQ "
                                + " , 'N', TOT_SALE_AMT, TOT_DC_AMT, SVC_TIP_AMT, TOT_ETC_AMT "
                                + " , DCM_SALE_AMT, VAT_SALE_AMT, VAT_AMT, NO_VAT_SALE_AMT, NO_TAX_SALE_AMT "
                                + " , EXP_PAY_AMT, GST_PAY_AMT, RET_PAY_AMT, CASH_AMT, CRD_CARD_AMT "
                                + " , WES_AMT, TK_GFT_AMT, TK_FOD_AMT, CST_POINT_AMT, JCD_CARD_AMT "
                                + " , RFC_AMT, ETC_APPR_AMT, DC_GEN_AMT, DC_SVC_AMT, DC_PCD_AMT "
                                + " , DC_CPN_AMT, DC_CST_AMT, DC_TFD_AMT, DC_PRM_AMT, DC_CRD_AMT "
                                + " , DC_PACK_AMT, DC_LYT_AMT, REPAY_CASH_AMT, REPAY_TK_GFT_AMT, CASH_BILL_AMT "
                                + " , DLV_ORDER_FG, FD_TBL_CD, FD_GST_CNT_T, FD_GST_CNT_1, FD_GST_CNT_2 "
                                + " , FD_GST_CNT_3, FD_GST_CNT_4, SHOP_CD || SALE_DATE || POS_NO || BILL_NO AS ORG_BILL_NO, ORDER_NO, strftime('%Y%m%d%H%M%S', 'now', 'localtime') "
                                + " , ?, '1', strftime('%Y%m%d%H%M%S', 'now', 'localtime'), CST_NO, CST_CARD_NO "
                                + " , CST_SALE_POINT, strftime('%Y%m%d%H%M%S', 'now', 'localtime'), CST_NM, DLV_EMP_NO, DLV_START_DT "
                                + " , DLV_PAYIN_EMP_NO, DLV_PAYIN_DT, NEW_DLV_ADDR_YN, DLV_ADDR, DLV_ADDR_DTL "
                                + " , NEW_DLV_TEL_NO_YN, DLV_TEL_NO, DLV_CL_CD, DLV_CM_CD , TRAVEL_CD "
                                + " , RSV_NO , PRE_PAY_CASH, PRE_PAY_CARD, RSV_USER_NM, RSV_USER_TEL_NO "
                                + " , (SELECT B.AVL_POINT "
                                    + " FROM HCS_CSTPT_T B "
                                    + " WHERE B.INS_SHOP_CD = A.SHOP_CD AND B.CST_NO = A.CST_NO ) "
                                + " , LOCAL_POINT_YN , CST_USE_POINT, CANCEL_REASON, CUP_DEPOSIT_AMT "
                            + " FROM SSL_TRHDR_T A"
                            + " WHERE SHOP_CD   = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";
    //반품처리 헤더 컵보증금 금액 정보
    this.getCupDepositAmt = "SELECT A.CUP_DEPOSIT_AMT"
    	+ " FROM SSL_TRHDR_T A"
    	+ " WHERE SHOP_CD   = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";
    //반품처리 바로다 Api취소 정보
    this.getBarodaUserData = "SELECT A.BARODA_USER_DATA"
    	+ " FROM SSL_TRHDR_T A"
    	+ " WHERE SHOP_CD   = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";

    this.updateReturnPorcess = "UPDATE SSL_TRHDR_T "
                                + " SET ORG_BILL_NO = ? || ? || ? || ? "
                                + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";

    this.insertProductDetail = "INSERT INTO SSL_TRDTL_T "
                                + " ( SHOP_CD, SALE_DATE, POS_NO, BILL_NO, DTL_NO, "
                                    + " REGI_SEQ, SALE_YN, PROD_CD, PROD_TYPE_FG, CORNER_CD, "
                                    + " CHG_BILL_NO, TAX_YN, DLV_PACK_FG, PROP_CD, PROP_VAL, "
                                    + " ORG_SALE_MG_CD, ORG_SALE_UPRC, NORMAL_UPRC, SALE_MG_CD, SALE_QTY, "
                                    + " SALE_UPRC, SALE_AMT, DC_AMT, ETC_AMT, SVC_TIP_AMT, "
                                    + " DCM_SALE_AMT, VAT_AMT, SVC_CD, TK_CPN_CD, DC_AMT_GEN, "
                                    + " DC_AMT_SVC, DC_AMT_JCD, DC_AMT_CPN, DC_AMT_CST, DC_AMT_FOD, "
                                    + " DC_AMT_PRM, DC_AMT_CRD, DC_AMT_PACK, DC_AMT_LYT, CST_SALE_POINT, "
                                    + " CST_USE_POINT, PRM_PROC_YN, PRM_CD, PRM_SEQ, SDA_CD, "
                                    + " SDS_ORG_DTL_NO, INS_DT, EMP_NO, SALE_WEIGHT, CUP_DEPOSIT_UPRC, CUP_FG, CUP_SALE_CNT ) "
                                + " SELECT SHOP_CD, ?, POS_NO, ?, DTL_NO "
                                    + " , REGI_SEQ, 'N', PROD_CD, PROD_TYPE_FG, CORNER_CD "
                                    + " , CHG_BILL_NO, TAX_YN, DLV_PACK_FG, PROP_CD, PROP_VAL "
                                    + " , ORG_SALE_MG_CD, ORG_SALE_UPRC, NORMAL_UPRC, SALE_MG_CD, SALE_QTY "
                                    + " , SALE_UPRC, SALE_AMT, DC_AMT, ETC_AMT, SVC_TIP_AMT "
                                    + " , DCM_SALE_AMT, VAT_AMT, SVC_CD, TK_CPN_CD, DC_AMT_GEN "
                                    + " , DC_AMT_SVC, DC_AMT_JCD, DC_AMT_CPN, DC_AMT_CST, DC_AMT_FOD "
                                    + " , DC_AMT_PRM, DC_AMT_CRD, DC_AMT_PACK, DC_AMT_LYT, CST_SALE_POINT "
                                    + " , CST_USE_POINT, PRM_PROC_YN, PRM_CD, PRM_SEQ, SDA_CD "
                                    + " , SDS_ORG_DTL_NO, strftime('%Y%m%d%H%M%S', 'now', 'localtime'), ? , SALE_WEIGHT, CUP_DEPOSIT_UPRC, CUP_FG, CUP_SALE_CNT "
                                + " FROM SSL_TRDTL_T "
                                + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";

    //결제순서
    this.insertPaymentSequence = "INSERT INTO SSL_TRPSQ_T "
                                    + " (SHOP_CD, SALE_DATE, POS_NO, BILL_NO, PAY_SEQ_NO, "
                                    + " REGI_SEQ, SALE_YN, PAY_TYPE_FG, PAY_AMT, LINE_NO, "
                                    + " INS_DT, UPD_DT, EMP_NO ) "
                                + " SELECT SHOP_CD, ?, POS_NO, ?, PAY_SEQ_NO "
                                    + " , REGI_SEQ, 'N', PAY_TYPE_FG, PAY_AMT, LINE_NO "
                                    + " , strftime('%Y%m%d%H%M%S', 'now', 'localtime'), strftime('%Y%m%d%H%M%S', 'now', 'localtime'), ? "
                                + " FROM SSL_TRPSQ_T "
                                + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";

    //회원정보
    this.insertMemberInfo = "INSERT INTO SSL_TRCST_T "
                                + " (SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, "
                                + " REGI_SEQ, SALE_YN, CST_NO, CST_CARD_NO, CST_CLS_CD, "
                                + " CST_USE_POINT, INS_DT, EMP_NO, CST_USE_AMT, CORNER_CD, "
                                + " SEQ_NO ) "
                            + " SELECT SHOP_CD, ?, POS_NO, ?, LINE_NO "
                                + " , REGI_SEQ, 'N', CST_NO, CST_CARD_NO, CST_CLS_CD "
                                + " , CST_USE_POINT, strftime('%Y%m%d%H%M%S', 'now', 'localtime'), ?, CST_USE_AMT, CORNER_CD "
                                + " , SEQ_NO "
                            + " FROM SSL_TRCST_T "
                            + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? ";

    //제휴카드 비승인 거래(할인만 했을 경우)
    this.insertAffiliatedCard = "INSERT INTO SSL_TRJCD_T "
                                + " (SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, "
                                + " SEQ_NO, REGI_SEQ, SALE_YN, VAN_CD, CORNER_CD, "
                                + " APPR_PROC_FG, JCD_CD, JCD_TYPE_FG, JCD_PROC_FG, JCD_CARD_NO, "
                                + " JCD_CARD_PWD, APPR_AMT, VALID_TERM, SIGN_PAD_YN, CARD_IN_FG, "
                                + " APPR_DATE, APPR_TIME, APPR_NO, JCD_DC_AMT, JCD_OCC_POINT, "
                                + " JCD_AVL_POINT, JCD_USE_POINT, JCD_REM_POINT, APPR_MSG, VAN_TERM_NO, "
                                + " VAN_SLIP_NO, CRDCP_TERM_NO, ORG_APPR_DATE, ORG_APPR_NO, APPR_LOG_NO, "
                                + " INS_DT, EMP_NO, CNMK_CD ) "
                            + " SELECT SHOP_CD, ?, POS_NO, ?, LINE_NO "
                                + " , SEQ_NO, REGI_SEQ, 'N', VAN_CD, CORNER_CD "
                                + " , APPR_PROC_FG, JCD_CD, JCD_TYPE_FG, JCD_PROC_FG, JCD_CARD_NO "
                                + " , JCD_CARD_PWD, APPR_AMT, VALID_TERM, SIGN_PAD_YN, CARD_IN_FG "
                                + " , APPR_DATE, APPR_TIME, APPR_NO, JCD_DC_AMT, JCD_OCC_POINT "
                                + " , JCD_AVL_POINT, JCD_USE_POINT, JCD_REM_POINT, APPR_MSG, VAN_TERM_NO "
                                + " , VAN_SLIP_NO, CRDCP_TERM_NO, ORG_APPR_DATE, ORG_APPR_NO, APPR_LOG_NO "
                                + " , strftime('%Y%m%d%H%M%S', 'now', 'localtime'), ?, CNMK_CD "
                                + " FROM SSL_TRJCD_T "
                                + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND APPR_PROC_FG = '0' ";
    
  //기타카드 ( 비승인저장)
    this.insertEtcCard = "INSERT INTO SSL_TRETC_T "
    							+ " (SHOP_CD, SALE_DATE, POS_NO , BILL_NO , LINE_NO "
    							+ " , SEQ_NO, TR_TYPE_CD, REGI_SEQ, CORNER_CD , SALE_YN "
    							+ " , APPR_DATE , APPR_TIME , APPR_AMT, SVC_TIP_AMT , VAT_AMT " 
    							+ " , PRE_BF_REM_AMT, PRE_AF_REM_AMT, APPR_NO , CARD_NO , APPR_PROC_FG "
    							+ " , ORG_APPR_DATE , ORG_APPR_NO , USER_DATA , INS_DT) "
    							+ " SELECT SHOP_CD, ?, POS_NO, ?, LINE_NO "
    							+ " , SEQ_NO, TR_TYPE_CD, REGI_SEQ, CORNER_CD , 'N' "
    							+ " , APPR_DATE , APPR_TIME , APPR_AMT, SVC_TIP_AMT , VAT_AMT " 
    							+ " , PRE_BF_REM_AMT, PRE_AF_REM_AMT, APPR_NO , CARD_NO , APPR_PROC_FG "
    							+ " , ORG_APPR_DATE , ORG_APPR_NO , USER_DATA , strftime('%Y%m%d%H%M%S', 'now', 'localtime') "
    							+ " FROM SSL_TRETC_T "
                                + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? "; 
    
  // 현금영수증 반품 시 저장.(승인)
    this.insertCashReceipts = "INSERT INTO SSL_TRCSH_T "
                                + " (SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO"
                                + ", SEQ_NO, REGI_SEQ, SALE_YN, VAN_CD, CORNER_CD"
                                + ", CASH_AMT, APPR_AMT, SVC_TIP_AMT, VAT_AMT, APPR_PROC_FG"
						    	+ ", APPR_IDT_TYPE, APPR_IDT_FG, CARD_IN_FG, APPR_IDT_NO, APPR_DATE"
						    	+ ", APPR_TIME, APPR_NO, APPR_MSG, VAN_TERM_NO, VAN_SLIP_NO"
						    	+ ", ORG_APPR_DATE, ORG_APPR_NO, APPR_LOG_NO, INS_DT, EMP_NO"
						    	+ ", EX_CD, EX_KRW, EX_EXP_AMT, EX_IN_AMT, EX_RET_AMT"
						    	+ ", KR_RET_AMT, EX_PAY_AMT, KR_PAY_AMT, KR_ETC_AMT, PRE_PAY_FG"
						    	+ ", NOTICE_MSG, BROAD_MSG, CNMK_CD, SEC_FLAG, VAT_SALE_AMT"
						    	+ ", NO_VAT_SALE_AMT ) "
                            + " SELECT SHOP_CD, ?, POS_NO, ?, LINE_NO "
	                            + ", SEQ_NO, REGI_SEQ, SALE_YN, VAN_CD, CORNER_CD"
	                            + ", CASH_AMT, APPR_AMT, SVC_TIP_AMT, VAT_AMT, APPR_PROC_FG"
						    	+ ", APPR_IDT_TYPE, APPR_IDT_FG, CARD_IN_FG, APPR_IDT_NO, APPR_DATE"
						    	+ ", APPR_TIME, APPR_NO, APPR_MSG, VAN_TERM_NO, VAN_SLIP_NO"
						    	+ ", ORG_APPR_DATE, ORG_APPR_NO, APPR_LOG_NO, strftime('%Y%m%d%H%M%S', 'now', 'localtime'), ?"
						    	+ ", EX_CD, EX_KRW, EX_EXP_AMT, EX_IN_AMT, EX_RET_AMT"
						    	+ ", KR_RET_AMT, EX_PAY_AMT, KR_PAY_AMT, KR_ETC_AMT, PRE_PAY_FG"
						    	+ ", NOTICE_MSG, BROAD_MSG, CNMK_CD, SEC_FLAG, VAT_SALE_AMT"
						    	+ ", NO_VAT_SALE_AMT  "                          
                                + " FROM SSL_TRCSH_T "
                                + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND APPR_PROC_FG = '0'"; 
    
 // 현금영수증 반품 시 저장.(비승인)
    this.insertCashReceiptsRefund = "INSERT INTO SSL_TRCSH_T "
		                    + " (SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO"
		                    + ", SEQ_NO, REGI_SEQ, SALE_YN, VAN_CD, CORNER_CD"
		                    + ", CASH_AMT, APPR_AMT, SVC_TIP_AMT, VAT_AMT, APPR_PROC_FG"
					    	+ ", APPR_IDT_TYPE, APPR_IDT_FG, CARD_IN_FG, APPR_IDT_NO, APPR_DATE"
					    	+ ", APPR_TIME, APPR_NO, APPR_MSG, VAN_TERM_NO, VAN_SLIP_NO"
					    	+ ", ORG_APPR_DATE, ORG_APPR_NO, APPR_LOG_NO, INS_DT, EMP_NO"
					    	+ ", EX_CD, EX_KRW, EX_EXP_AMT, EX_IN_AMT, EX_RET_AMT"
					    	+ ", KR_RET_AMT, EX_PAY_AMT, KR_PAY_AMT, KR_ETC_AMT, PRE_PAY_FG"
					    	+ ", NOTICE_MSG, BROAD_MSG, CNMK_CD, SEC_FLAG, VAT_SALE_AMT"
					    	+ ", NO_VAT_SALE_AMT ) "
					    	+ " SELECT ?, ?, ?, ?, LINE_NO "
		                    + ", SEQ_NO, ?, 'N', VAN_CD, CORNER_CD"
		                    + ", CASH_AMT, ?, SVC_TIP_AMT, VAT_AMT, APPR_PROC_FG"
					    	+ ", APPR_IDT_TYPE, APPR_IDT_FG, CARD_IN_FG, APPR_IDT_NO, ?"
					    	+ ", ?, ?, ?, VAN_TERM_NO, VAN_SLIP_NO"
					    	+ ", APPR_DATE, ORG_APPR_NO, APPR_LOG_NO, strftime('%Y%m%d%H%M%S', 'now', 'localtime'), ?"
					    	+ ", EX_CD, EX_KRW, EX_EXP_AMT, EX_IN_AMT, EX_RET_AMT"
					    	+ ", KR_RET_AMT, EX_PAY_AMT, KR_PAY_AMT, KR_ETC_AMT, PRE_PAY_FG"
					    	+ ", NOTICE_MSG, ?, ?, SEC_FLAG, VAT_SALE_AMT"
					    	+ ", NO_VAT_SALE_AMT  "                          
		                    + " FROM SSL_TRCSH_T "
		                    + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND LINE_NO = ? AND SEQ_NO = ?  AND APPR_PROC_FG = '1'"; 
    
  // 현금영수증 반품 시 저장.( 취소승인 후 승인번호 업데이트 )
    this.updateSslTrcshTCancel = "UPDATE SSL_TRCSH_T "
								     + " SET ORG_APPR_NO = ? "
								     + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? "
								     + " AND LINE_NO = ? AND SEQ_NO = ? ";
    
  //제휴카드 ( 취소승인 후 승인번호 업데이트 )
    this.updateSslTrjcdTCancel = "UPDATE SSL_TRJCD_T "
								     + " SET ORG_APPR_NO = ? "
								     + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? "
								     + " AND LINE_NO = ? AND SEQ_NO = ? ";
    
  //제휴카드 ( 취소승인 후 저장)
    this.insertSslTrjcdTCancelSave = "INSERT INTO SSL_TRJCD_T "
							    + " (SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, "
							    + " SEQ_NO, REGI_SEQ, SALE_YN, VAN_CD, CORNER_CD, "
							    + " APPR_PROC_FG, JCD_CD, JCD_TYPE_FG, JCD_PROC_FG, JCD_CARD_NO, "
							    + " JCD_CARD_PWD, APPR_AMT, VALID_TERM, SIGN_PAD_YN, CARD_IN_FG, "
							    + " APPR_DATE, APPR_TIME, APPR_NO, JCD_DC_AMT, JCD_OCC_POINT, "
							    + " JCD_AVL_POINT, JCD_USE_POINT, JCD_REM_POINT, APPR_MSG, VAN_TERM_NO, "
							    + " VAN_SLIP_NO, CRDCP_TERM_NO, ORG_APPR_DATE, ORG_APPR_NO, APPR_LOG_NO, "
							    + " INS_DT, EMP_NO, CNMK_CD, JCD_PAY_FG, BROAD_MSG ) "
							    + " SELECT ?, ?, ?, ?, LINE_NO "
							    + " , SEQ_NO, ?, 'N', VAN_CD, CORNER_CD "
							    + " , APPR_PROC_FG, JCD_CD, JCD_TYPE_FG, CASE WHEN JCD_PROC_FG = '0' THEN '3' WHEN JCD_PROC_FG = '1' THEN '4' WHEN JCD_PROC_FG = '6' THEN '7' WHEN JCD_PROC_FG = '2' THEN '5' ELSE '' END, JCD_CARD_NO "
							    + " , JCD_CARD_PWD, APPR_AMT, VALID_TERM, SIGN_PAD_YN, CARD_IN_FG "
							    + " , ?, ?, ?, JCD_DC_AMT, JCD_OCC_POINT "
							    + " , JCD_AVL_POINT, JCD_USE_POINT, ?, ?, VAN_TERM_NO "
							    + " , ?, CRDCP_TERM_NO, APPR_DATE, APPR_NO, '' "
							    + " , strftime('%Y%m%d%H%M%S', 'now', 'localtime'), ?, CNMK_CD, JCD_PAY_FG, ? "
							    + " FROM SSL_TRJCD_T "
							    + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND LINE_NO = ? AND SEQ_NO = ? AND APPR_PROC_FG = '1' ";
    
    //카드반품 정보 저장
    this.insertCardReturnInfo = "INSERT INTO SSL_TRCRD_T "
                                + " ( SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, "
                                + " SEQ_NO, REGI_SEQ, SALE_YN, VAN_CD, CORNER_CD, "
                                + " APPR_PROC_FG, CRD_CARD_NO, APPR_REQ_AMT, SVC_TIP_AMT, VAT_AMT, "
                                + " INST_MM_FG, INST_MM_CNT, VALID_TERM, SIGN_PAD_YN, CARD_IN_FG, "
                                + " APPR_DATE, APPR_TIME, APPR_NO, CRDCP_CD, ISS_CRDCP_CD, "
                                + " ISS_CRDCP_NM, PUR_CRDCP_CD, PUR_CRDCP_NM, APPR_AMT, APPR_DC_AMT, "
                                + " APPR_MSG, VAN_TERM_NO, VAN_SLIP_NO, CRDCP_TERM_NO, ORG_APPR_DATE, "
                                + " ORG_APPR_NO, APPR_LOG_NO, INS_DT, EMP_NO, PRE_PAY_FG, "
                                + " LYT_APPR_FG, LYT_APPR_INFO, GIFT_CASH, NOTICE_MSG, BROAD_MSG, "
                                + " CNMK_CD, UNION_PAY_FG, DDC_FLAG ) "
                            + " SELECT SHOP_CD, ?, POS_NO, ?, LINE_NO "
                                + " , SEQ_NO, ?, 'N', VAN_CD, CORNER_CD "
                                + " , APPR_PROC_FG, CRD_CARD_NO, APPR_REQ_AMT, SVC_TIP_AMT, VAT_AMT "
                                + " , INST_MM_FG, INST_MM_CNT, VALID_TERM, 'Y', CARD_IN_FG "
                                + " , ?, ?, ?, CRDCP_CD, ISS_CRDCP_CD "
                                + " , ISS_CRDCP_NM , PUR_CRDCP_CD, PUR_CRDCP_NM, APPR_AMT, APPR_DC_AMT "
                                + " , ? , VAN_TERM_NO, ?, CRDCP_TERM_NO, APPR_DATE "
                                + " , APPR_NO, '', strftime('%Y%m%d%H%M%S', 'now', 'localtime'), ?, PRE_PAY_FG "
                                + " , LYT_APPR_FG, LYT_APPR_INFO, ?, ?, ? "
                                + " , CNMK_CD, UNION_PAY_FG, 'Y' "
                                + " FROM SSL_TRCRD_T "
                                + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND LINE_NO = ? AND SEQ_NO = ? " ;
    
  //카드반품 정보 반품 appr_no 업데이트
    this.updateCardReturnInfo = " UPDATE SSL_TRCRD_T SET "
                                + " ORG_APPR_NO = ? "                                
                                + " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND LINE_NO = ? AND SEQ_NO = ? " ;
    
    //조회조건
    this.selectCheckCondition = "SELECT COM_CD AS PAY_CD, COM_CD_NM AS PAY_NM "
                                + " FROM CCD_CODEM_T "
                                + " WHERE COM_CD_FG = '038' "
                                    + " AND COM_CD_ITEM_01 <> '' ";

    //월별 매출현황
    this.selectMonthSales = "SELECT CAST( SUBSTR( SALE_DATE, 7, 8 )                          AS INTEGER          ) AS SALE_DAY "
                                + " , CAST( SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END  * DCM_SALE_AMT  ) AS NUMERIC( 11, 0 ) ) AS SUM_AMT "
                                + " , CAST( SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END  * VAT_AMT  ) AS NUMERIC( 11, 0 ) ) AS VAT_AMT "
                                + " , CAST( SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END  * CASH_AMT  ) AS NUMERIC( 11, 0 ) ) AS CASH_AMT "
                                + " , CAST( SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END  * CRD_CARD_AMT  ) AS NUMERIC( 11, 0 ) ) AS CRD_CARD_AMT "
                                + " , CAST( SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END  * WES_AMT  ) AS NUMERIC( 11, 0 ) ) AS WES_AMT "
                                + " , CAST( SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END  * TK_GFT_AMT  ) AS NUMERIC( 11, 0 ) ) AS TK_GFT_AMT "
                                + " , CAST( SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END  * TK_FOD_AMT  ) AS NUMERIC( 11, 0 ) ) AS TK_FOD_AMT "
                                + " , CAST( SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END  * CST_POINT_AMT  ) AS NUMERIC( 11, 0 ) ) AS CST_POINT_AMT "
                                + " , CAST( SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END  * JCD_CARD_AMT  ) AS NUMERIC( 11, 0 ) ) AS JCD_CARD_AMT "
                                + " , CAST( SUM( CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END  * ETC_APPR_AMT  ) AS NUMERIC( 11, 0 ) ) AS ETC_APPR_AMT "
                            + " FROM SSL_TRHDR_T "
                            + " WHERE SHOP_CD = ? "
                                + " AND   SALE_DATE LIKE ? || '%' "
                                + " AND   POS_NO    LIKE ? "
                            + " GROUP BY SALE_DATE ";

    //분류별 매출현황
    this.selectSalesClass = "SELECT LCLS_CD   AS LCLS_CD, MCLS_CD   AS MCLS_CD, SCLS_CD    AS SCLS_CD, SCLS_NM   AS SCLS_NM "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_QTY ) AS SALE_QTY "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_AMT ) AS SALE_AMT "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_DC ) AS SALE_DC "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_DCM ) AS SALE_DCM "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_VAT ) AS SALE_VAT "
                            + " FROM ( SELECT CLSSM.LCLS_CD      AS LCLS_CD, CLSSM.MCLS_CD      AS MCLS_CD, CLSSM.SCLS_CD      AS SCLS_CD "
                                    + " , CLSSM.SCLS_NM      AS SCLS_NM, TRDTL.PROD_CD      AS PROD_CD, TRDTL.SALE_DATE    AS SALE_DATE "
                             	    + " , TRDTL.SALE_YN      AS SALE_YN, TRDTL.SALE_QTY     AS SALE_QTY, TRDTL.SALE_AMT     AS SALE_AMT "
                             	    + " , TRDTL.DC_AMT       AS SALE_DC, TRDTL.DCM_SALE_AMT AS SALE_DCM, TRDTL.VAT_AMT      AS SALE_VAT "
                                + " FROM SSL_TRDTL_T TRDTL "
                                    + " LEFT JOIN SCD_PRODM_T PRODM "
                                    + " ON  PRODM.SHOP_CD = TRDTL.SHOP_CD AND PRODM.PROD_CD = TRDTL.PROD_CD "
                                    + " LEFT JOIN SCD_CLSSM_T CLSSM "
                                    + " ON  CLSSM.SHOP_CD = PRODM.SHOP_CD AND CLSSM.LCLS_CD = PRODM.LCLS_CD "
                                        + " AND CLSSM.MCLS_CD = PRODM.MCLS_CD AND CLSSM.SCLS_CD = PRODM.SCLS_CD "
                            + " WHERE TRDTL.SALE_DATE BETWEEN ? AND ? "
                                + " AND   TRDTL.SHOP_CD   = ? "
                                + " AND   TRDTL.POS_NO  = ? ) "
                            + " GROUP BY LCLS_CD, MCLS_CD, SCLS_CD, SCLS_NM ";

    //분류별 매출현황 일별매출
    this.selectDaySalesClass = "SELECT SALE_DATE  AS SALE_DATE "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_QTY ) AS SALE_QTY "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_AMT ) AS SALE_AMT "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_DC ) AS SALE_DC "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_DCM ) AS SALE_DCM "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_VAT ) AS SALE_VAT "
                            + " FROM ( SELECT CLSSM.LCLS_CD      AS LCLS_CD, CLSSM.MCLS_CD      AS MCLS_CD, CLSSM.SCLS_CD      AS SCLS_CD "
                                    + " , CLSSM.SCLS_NM      AS SCLS_NM, TRDTL.PROD_CD      AS PROD_CD, TRDTL.SALE_DATE    AS SALE_DATE "
                                    + " , TRDTL.SALE_YN      AS SALE_YN, TRDTL.SALE_QTY     AS SALE_QTY, TRDTL.SALE_AMT     AS SALE_AMT "
                                    + " , TRDTL.DC_AMT       AS SALE_DC, TRDTL.DCM_SALE_AMT AS SALE_DCM, TRDTL.VAT_AMT      AS SALE_VAT "
                                + " FROM SSL_TRDTL_T TRDTL "
                                    + " LEFT JOIN SCD_PRODM_T PRODM "
                                    + " ON  PRODM.SHOP_CD = TRDTL.SHOP_CD AND PRODM.PROD_CD = TRDTL.PROD_CD "
                                    + " LEFT JOIN SCD_CLSSM_T CLSSM "
                                    + " ON  CLSSM.LCLS_CD = PRODM.LCLS_CD AND CLSSM.MCLS_CD = PRODM.MCLS_CD AND CLSSM.SCLS_CD = PRODM.SCLS_CD AND CLSSM.SHOP_CD = TRDTL.SHOP_CD "
                                + " WHERE TRDTL.SALE_DATE BETWEEN ? AND ? AND   TRDTL.SHOP_CD = ? AND   TRDTL.POS_NO = ? ) "
                            + " WHERE LCLS_CD = ? AND  MCLS_CD = ? AND   SCLS_CD = ? "
                            + " GROUP BY SALE_DATE ";

    //상품별 매출현황
    this.selectProductSales = "SELECT TRDTL.PROD_CD AS PROD_CD, PRODM.PROD_NM AS PROD_NM "
                                + " , TRDTL.SALE_WEIGHT AS SALE_WEIGHT, PRODM.PRICE_MGR_FG "
                                + " , LCLS_CD   AS LCLS_CD, MCLS_CD   AS MCLS_CD, SCLS_CD    AS SCLS_CD "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_QTY ) AS SALE_QTY "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_AMT ) AS SALE_AMT "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * DC_AMT ) AS SALE_DC "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * DCM_SALE_AMT ) AS SALE_DCM "
                                + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * VAT_AMT ) AS SALE_VAT "
                            + " FROM SSL_TRDTL_T TRDTL "
                                + " LEFT JOIN SCD_PRODM_T PRODM "
                                + " ON  PRODM.SHOP_CD = TRDTL.SHOP_CD "
                                    + " AND PRODM.PROD_CD = TRDTL.PROD_CD "
                            + " WHERE TRDTL.SALE_DATE BETWEEN ? AND ? "
                                + " AND   TRDTL.SHOP_CD = ? "
                                + " AND   TRDTL.POS_NO = ? "
                            + " GROUP BY TRDTL.PROD_CD , PRODM.PROD_NM, PRODM.PRICE_MGR_FG, TRDTL.SALE_WEIGHT "
                            + " ORDER BY SALE_AMT DESC ";

    //상품별 매출현황 일자별
    this.selectDayProducSales = "SELECT SALE_DATE  AS SALE_DATE "
                                    + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_QTY ) AS SALE_QTY "
                                    + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * SALE_AMT ) AS SALE_AMT "
                                    + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * DC_AMT ) AS SALE_DC "
                                    + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * DCM_SALE_AMT ) AS SALE_DCM "
                                    + " , SUM(CASE WHEN SALE_YN = 'Y' THEN  1 ELSE -1 END  * VAT_AMT ) AS SALE_VAT "
                                + " FROM SSL_TRDTL_T "
                                + " WHERE SALE_DATE BETWEEN ? AND ? "
                                    + " AND   SHOP_CD = ? "
                                    + " AND   POS_NO  = ? "
                                    + " AND   PROD_CD = ? "
                                + " GROUP BY SALE_DATE ";

    //정산현황 마감 카드
    this.selectSettlementStatusCloseCard = "SELECT APPR_FG, SUM(APPR_CNT ) AS APPR_CNT, SUM(APPR_AMT ) AS APPR_AMT "
                                            + " FROM ( SELECT CASE WHEN SALE_YN = 'Y' THEN '1' ELSE '2' END  AS APPR_FG "
                                                    + " , COUNT(SALE_YN )  AS APPR_CNT, SUM(APPR_AMT )  AS APPR_AMT "
                                                + " FROM SSL_TRCRD_T "
                                                + " WHERE SHOP_CD = ? AND SALE_DATE BETWEEN ? AND ?  @ "
                                                + " GROUP BY SALE_YN "
                                                + " UNION ALL "
                                            	+ " SELECT CASE WHEN SALE_YN = 'Y' THEN '1' ELSE '2' END  AS APPR_FG "
                                            	    + " , COUNT(SALE_YN ) AS APPR_CNT, SUM(APPR_REQ_AMT ) AS APPR_AMT "
                                            	+ " FROM POS_TKCRD_T "
                                            	+ " WHERE SHOP_CD  = ? AND SALE_DATE BETWEEN ? AND ?  @ "
                                            	+ " GROUP BY SALE_YN "
                                            	+ " UNION ALL "
                                            	+ " SELECT CASE WHEN WES_IN_YN = 'Y' THEN '1' ELSE '2' END  AS APPR_FG "
                                                    + " , COUNT(WES_IN_YN )  AS APPR_CNT, SUM(WES_IN_AMT ) AS APPR_AMT "
                                            	+ " FROM POS_INWES_T "
                                            	+ " WHERE SHOP_CD   = ? AND SALE_DATE BETWEEN ? AND ? AND  PAY_TYPE_FG = '02'  @ "
                                            	+ " GROUP BY WES_IN_YN ) "
                                            + " GROUP BY APPR_FG "
                                            + " ORDER BY APPR_FG ";

    //정산현황 승인내역
    this.selectSettlementStatusApprovalList = "SELECT POS_NO, SALE_NO, APPR_PROC_FG, ISS_CRDCP_NM, CRD_CARD_NO, APPR_REQ_AMT, APPR_NO, SALE_YN, SALE_YN_NM "
                                                + " FROM ( SELECT A.POS_NO, A.BILL_NO AS SALE_NO "
                                                        + " , CASE WHEN A.APPR_PROC_FG = '1' THEN '포스' ELSE '단말기' END AS APPR_PROC_FG "
                                                        + " , A.ISS_CRDCP_NM , A.CRD_CARD_NO, A.APPR_REQ_AMT, A.APPR_NO, A.SALE_YN "
                                                        + " , CASE WHEN A.SALE_YN = 'Y' THEN '매출' ELSE '반품' END AS SALE_YN_NM "
                                                    + " FROM SSL_TRCRD_T A "
                                                    + " WHERE A.SHOP_CD = ? AND A.SALE_DATE BETWEEN ? AND ? AND A.UNION_PAY_FG <> '4' @1 "
                                                    + " UNION ALL "
                                                    + " SELECT A.POS_NO, A.SALE_NO AS SALE_NO "
                                                        + " , CASE WHEN A.APPR_PROC_FG = '1' THEN '포스' ELSE '단말기' END AS APPR_PROC_FG "
                                                        + " , A.ISS_CRDCP_NM, A.CRD_CARD_NO, A.APPR_REQ_AMT, A.APPR_NO, A.SALE_YN "
                                                        + " , CASE WHEN A.SALE_YN = 'Y' THEN '비매출' ELSE '비매출반품' END AS SALE_YN_NM "
                                                    + " FROM POS_TKCRD_T A "
                                                    + " WHERE A.SHOP_CD = ? AND A.SALE_DATE BETWEEN ? AND ? @2 "
                                                    + " UNION ALL "
                                                    + " SELECT A.POS_NO, A.WES_IN_NO AS SALE_NO "
                                                        + " , CASE WHEN B.APPR_PROC_FG = '1' THEN '포스' ELSE '단말기' END AS APPR_PROC_FG "
                                                        + " , B.ISS_CRDCP_NM, B.CRD_CARD_NO, B.APPR_REQ_AMT, B.APPR_NO, A.WES_IN_YN AS SALE_YN"
                                                        + " , CASE WHEN A.WES_IN_YN = 'Y' THEN '외상입금' ELSE '입금취소' END  AS SALE_YN_NM "
                                                    + " FROM POS_INWES_T A "
                                                        + " LEFT JOIN POS_LGCRD_T B  "
                                                        + " ON  B.SHOP_CD = A.SHOP_CD AND B.SALE_DATE = A.SALE_DATE AND B.POS_NO = A.POS_NO AND B.APPR_LOG_NO = A.APPR_LOG_NO "
                                                    + " WHERE A.SHOP_CD = ? AND A.SALE_DATE BETWEEN ? AND ? AND A.PAY_TYPE_FG = '02' @3 ) ";

    //정산현황 마감정산 내역
    this.selectSettlementStatusSalesClose = "SELECT SUM(TOT_AMT   ) AS TOT_AMT ,SUM(CANCEL_TOT_AMT   ) AS CANCEL_TOT_AMT ,SUM(TOT_SALE_AMT     ) AS TOT_SALE_AMT , "
                                                + " SUM(TOT_DC_AMT       ) AS TOT_DC_AMT ,SUM(SVC_TIP_AMT      ) AS SVC_TIP_AMT ,SUM(TOT_ETC_AMT      ) AS TOT_ETC_AMT , "
                                                + " SUM(DCM_SALE_AMT     ) AS DCM_SALE_AMT ,SUM(VAT_SALE_AMT     ) AS VAT_SALE_AMT ,SUM(VAT_AMT          ) AS VAT_AMT , "
                                                + " SUM(NO_VAT_SALE_AMT  ) AS NO_VAT_SALE_AMT ,SUM(NO_TAX_SALE_AMT  ) AS NO_TAX_SALE_AMT ,SUM(CASH_AMT         ) AS CASH_AMT , "
                                                + " SUM(CRD_CARD_AMT     ) AS CRD_CARD_AMT ,SUM(WES_AMT          ) AS WES_AMT ,SUM(TK_GFT_AMT       ) AS TK_GFT_AMT , "
                                                + " SUM(TK_FOD_AMT       ) AS TK_FOD_AMT ,SUM(CST_POINT_AMT    ) AS CST_POINT_AMT ,SUM(JCD_CARD_AMT     ) AS JCD_CARD_AMT , "
                                                + " SUM(ETC_APPR_AMT     ) AS ETC_APPR_AMT ,SUM(DC_GEN_AMT       ) AS DC_GEN_AMT ,SUM(DC_SVC_AMT       ) AS DC_SVC_AMT , "
                                                + " SUM(DC_PCD_AMT       ) AS DC_PCD_AMT ,SUM(DC_CPN_AMT       ) AS DC_CPN_AMT ,SUM(DC_CST_AMT       ) AS DC_CST_AMT , "
                                                + " SUM(DC_TFD_AMT       ) AS DC_TFD_AMT ,SUM(DC_PRM_AMT       ) AS DC_PRM_AMT ,SUM(DC_CRD_AMT       ) AS DC_CRD_AMT , "
                                                + " SUM(DC_PACK_AMT      ) AS DC_PACK_AMT ,SUM(REPAY_CASH_AMT   ) AS REPAY_CASH_AMT ,SUM(REPAY_TK_GFT_AMT ) AS REPAY_TK_GFT_AMT "
                                            + " FROM REGI_SUM_VW "
                                            + " WHERE SHOP_CD = ? AND SALE_DATE BETWEEN ? AND ?  @ ";

    //정산현황 카드사별 매출내역
    this.selectSettlementStatusCard = "SELECT PUR_CRDCP_CD, PUR_CRDCP_NM, COUNT(PUR_CRDCP_CD ) AS CNT, SUM(APPR_AMT * CASE WHEN SALE_YN = 'Y' THEN 1 ELSE -1 END) AS APPR_AMT "
                                        + " FROM SSL_TRCRD_T "
                                        + " WHERE SHOP_CD   = ? "
                                            + " AND   SALE_DATE BETWEEN ? AND ? @ "
                                        + " GROUP BY PUR_CRDCP_CD , pur_CRDCP_NM ";

    //정산현황 마일리지 내역
    this.selectSettlementStatusMileage = "SELECT COUNT(TRHDR.BILL_NO ) AS BILL_CNT "
                                            + " , SUM(TRHDR.FD_GST_CNT_T )AS GUEST_CNT "
                                            + " , SUM(CASE WHEN TRHDR.SALE_YN = 'Y' THEN 1 ELSE -1 END * CASE WHEN TRHDR.CST_SALE_POINT> 0 THEN 1 ELSE 0 END  ) AS SALE_CNT "
                                            + " , SUM(CASE WHEN TRHDR.SALE_YN = 'Y' THEN 1 ELSE -1 END * CASE WHEN TRHDR.CST_SALE_POINT> 0 THEN 1 ELSE 0 END * TRHDR.CST_SALE_POINT ) AS SALE_POINT "
                                            + " , SUM(CASE WHEN TRHDR.SALE_YN = 'Y' THEN 1 ELSE -1 END * CASE WHEN TRHDR.CST_USE_POINT> 0 THEN 1 ELSE 0 END  ) AS USE_CNT "
                                            + " , SUM(CASE WHEN TRHDR.SALE_YN = 'Y' THEN 1 ELSE -1 END * CASE WHEN TRHDR.CST_USE_POINT> 0 THEN 1 ELSE 0 END * TRHDR.CST_USE_POINT  ) AS USE_POINT "
                                        + " FROM SSL_TRHDR_T TRHDR "
                                        + " WHERE TRHDR.SHOP_CD = ? "
                                            + " AND   TRHDR.SALE_DATE BETWEEN ? AND ?  @ ";
    //매출자료 수신 그룹데이터.
    this.selectSalesDataGroupRecvList = "" 
    	+"\n SELECT  POS_NO  /*** 매출자료수신 ***/                                                               ".rtrim()
    	+"\n       , COUNT( BILL_NO )                                                            AS SALE_CNT      ".rtrim()
    	+"\n       , MAX( BILL_NO )                                                              AS MAX_BILL_NO   ".rtrim()
    	+"\n       , SUM( CASE WHEN SALE_YN = 'Y' THEN TOT_SALE_AMT ELSE TOT_SALE_AMT * -1 END ) AS TOT_SALE_AMT  ".rtrim()
    	+"\n       , SUM( CASE WHEN SALE_YN = 'Y' THEN TOT_DC_AMT   ELSE TOT_DC_AMT   * -1 END ) AS TOT_DC_AMT    ".rtrim()
    	+"\n       , SUM( CASE WHEN SALE_YN = 'Y' THEN DCM_SALE_AMT ELSE DCM_SALE_AMT * -1 END ) AS DCM_SALE_AMT  ".rtrim()
    	+"\n   FROM SSL_TRHDR_T                                                                                   ".rtrim()
    	+"\n  WHERE SHOP_CD   = '%s'                                                                              ".rtrim()
    	+"\n    AND SALE_DATE = '%s'                                                                              ".rtrim()
    	+"\n    AND POS_NO    = '%s'                                                                              ".rtrim()
    	+"\n  GROUP BY POS_NO                                                                                     ".rtrim()
    ;

    //매출자료 수신 상세내역 데이터.
    this.selectSalesDataDetailRecvList = ""
    	+ "\n SELECT POS_NO                                                                                                   AS POS_NO          ".rtrim()
    	+ "\n      , SALE_DATE || BILL_NO                                                                                     AS BILL_NO         ".rtrim()
    	+ "\n      , CASE WHEN  SALE_YN = 'Y' THEN  '매출'                    ELSE '반품'                                END  AS SALE_FG         ".rtrim()
    	+ "\n      , CASE WHEN  SALE_YN = 'Y' THEN  TOT_SALE_AMT	          ELSE  TOT_SALE_AMT  * -1                   END  AS TOT_SALE_AMT	 ".rtrim()
    	+ "\n      , CASE WHEN  SALE_YN = 'Y' THEN  TOT_DC_AMT		          ELSE  TOT_DC_AMT    * -1                   END  AS TOT_DC_AMT	     ".rtrim()
    	+ "\n      , CASE WHEN  SALE_YN = 'Y' THEN  DCM_SALE_AMT	          ELSE  DCM_SALE_AMT  * -1                   END  AS DCM_SALE_AMT    ".rtrim()
    	+ "\n      , CASE WHEN  SALE_YN = 'Y' THEN  CASH_AMT - CASH_BILL_AMT ELSE  ( CASH_AMT - CASH_BILL_AMT )	* -1     END  AS CASH_AMT        ".rtrim()
    	+ "\n      , CASE WHEN  SALE_YN = 'Y' THEN  CASH_BILL_AMT	          ELSE  CASH_BILL_AMT	* -1                 END  AS CASH_BILL_AMT	 ".rtrim()
    	+ "\n      , CASE WHEN  SALE_YN = 'Y' THEN  CRD_CARD_AMT	          ELSE  CRD_CARD_AMT	* -1                 END  AS CRD_CARD_AMT	 ".rtrim()
    	+ "\n      , CASE WHEN  SALE_YN = 'Y' THEN  WES_AMT + TK_GFT_AMT + TK_FOD_AMT + CST_POINT_AMT + JCD_CARD_AMT                             ".rtrim()
    	+ "\n              ELSE         ( WES_AMT + TK_GFT_AMT + TK_FOD_AMT + CST_POINT_AMT + JCD_CARD_AMT )    * -1     END AS ETC_PAY_AMT      ".rtrim()
    	+ "\n   FROM SSL_TRHDR_T                                                                                                                 ".rtrim()
    	+ "\n  WHERE SHOP_CD = '%s'                                                                                                              ".rtrim()
    	+ "\n  AND SALE_DATE BETWEEN '%s' AND '%s'                                                                                               ".rtrim()
    	+ "\n  AND POS_NO    = '%s'                                                                                                              ".rtrim()
    	+ "\n  ORDER BY BILL_NO    LIMIT 100                                                                                                              ".rtrim()
    ;


    //포스 환경설정
    this.selectPosEnvironmentSetting = "SELECT MS.ENV_GRP_CD AS ENV_GRP_CD, MS.ENV_GRP_NM AS ENV_GRP_NM, MS.ENV_SET_CD AS ENV_SET_CD, MS.ENV_SET_VAL AS ENV_SET_VAL, MS.ENV_SET_NM AS ENV_SET_NM "
                                        + " , CASE WHEN DT.ENV_VAL_NM <> '' THEN DT.ENV_VAL_NM ELSE MS.ENV_SET_VAL END ENV_VAL_NM "
                                    + " FROM ( SELECT HD.ENV_SET_CD, HD.ENV_SET_NM, SH.ENV_SET_VAL, HD.ENV_GRP_CD, HD.ENV_GRP_NM "
                                        + " FROM ( SELECT HD.ENV_SET_CD, HD.ENV_SET_NM, HD.ENV_GRP_CD, CD.COM_CD_NM ENV_GRP_NM "
                                            + " FROM SCD_POSMS_T MS "
                                                + " , CCD_ENVHD_T HD "
                                                + " , ( SELECT COM_CD, COM_CD_NM "
                                                    + " FROM CCD_CODEM_T "
                                                    + " WHERE COM_CD_FG = '117' ) CD "
                                                + " WHERE MS.POS_NO = ? AND MS.USE_YN = 'Y' AND HD.ENV_SET_FG = '3' AND HD.USE_YN = 'Y' "
                                                    + " AND HD.ENV_GRP_CD NOT IN ( 'X01' ) AND CD.COM_CD = HD.ENV_GRP_CD "
                                                + " ) HD "
                                            + " LEFT OUTER JOIN SCD_ENVPS_T SH "
                                                + " ON  SH.SHOP_CD    = ? "
                                                + " AND SH.POS_NO     = ? "
                                                + " AND SH.ENV_SET_CD = HD.ENV_SET_CD "
                                        + " ) MS "
                                        + " LEFT OUTER JOIN ( SELECT ENV_SET_CD, ENV_VAL_CD, ENV_VAL_NM "
                                            + " FROM CCD_ENVDT_T ) DT "
                                        + " ON  DT.ENV_SET_CD = MS.ENV_SET_CD "
                                            + " AND DT.ENV_VAL_CD = MS.ENV_SET_VAL "
                                    + " ORDER BY MS.ENV_GRP_CD, MS.ENV_SET_CD ";


    //포스 환결설정 속성값
    this.selectPosEnvironmentSettingProperty = "SELECT ENV_VAL_CD , ENV_VAL_NM "
                                                + " FROM CCD_ENVDT_T "
                                                + " WHERE ENV_SET_CD = ? "
                                                    + " AND   USE_YN     = 'Y' "
                                                + " ORDER BY ENV_VAL_CD ";

    //포스환결설정 저장
    this.updatePosEnvironmentSetting = "UPDATE SCD_ENVPS_T "
                                        + " SET  ENV_SET_VAL = ? , MODIFY_FG = '1', SEND_FG = '0',UPD_DT = strftime('%Y%m%d%H%M%S', 'now', 'localtime') "
                                        + " WHERE SHOP_CD  = ? AND POS_NO  = ? AND ENV_SET_CD = ? ";

    //포스 다운로드
    this.selectPosDownload1 = "SELECT B.BIZ_NO, B.SHOP_NM AS CORNER_NM, B.OWNER_NM, A.VAN_SER_NO, '00' AS CORNER_CD "
                                + " FROM SCD_POSMS_T A "
                               	    + " , SCD_SHOPM_T B "
                               	+ " WHERE A.SHOP_CD = ? "
                               	    + " AND   A.POS_NO  = ? "
                               	    + " AND   A.USE_YN  = 'Y' "
                               	    + " AND   B.SHOP_CD = A.SHOP_CD ";

    //포스 다운로드
    this.selectPosDownload2 = "SELECT BIZ_NO, CORNER_NM, OWNER_NM "
                                    + " , CASE WHEN CORNER_CD<> '00' THEN VAN_SER_NO ELSE ( "
                                        + " SELECT VAN_SER_NO "
                                        + " FROM SCD_POSMS_T "
                               			+ " WHERE SHOP_CD = ? AND POS_NO = ? ) END AS VAN_SER_NO "
                                    + " , CORNER_CD "
                                + " FROM SCD_SHOPS_T "
                               	+ " WHERE SHOP_CD = ? AND USE_YN = 'Y' ";

    //상품 이미지 다운로드
    this.selectProdImgUrl = " SELECT SHOP_CD, PROD_CD, IMG_URL, IMG_DOWNLOAD_FG "
                            + " FROM SCD_PRODM_T "
                            + " WHERE SHOP_CD = ? "
                                + " AND IMG_DOWNLOAD_FG = 'U' "
                             	+ " AND (IMG_URL IS NOT NULL AND IMG_URL != '') ";

    //상품 이미지 다운로드
    this.selectProdImgUrlCheck = " SELECT SHOP_CD, PROD_CD, IMG_URL, IMG_DOWNLOAD_FG "
                                + " FROM SCD_PRODM_T "
                                + " WHERE SHOP_CD = ? "
                                    + " AND IMG_DOWNLOAD_FG = 'Y' "
                                    + " AND (IMG_URL IS NOT NULL AND IMG_URL != '') "
                                + " ORDER BY PROD_CD";

    //상품 이미지 다운로드 업데이트
    this.updateProdImgUrl = " UPDATE SCD_PRODM_T SET IMG_DOWNLOAD_FG = 'Y', IMG_URL = ? WHERE SHOP_CD = ? AND PROD_CD = ?";

    this.updateScdPosmsT  = "UPDATE SCD_POSMS_T SET VAN_TERM_NO = ? WHERE POS_NO = ? AND SHOP_CD = ?"

    /** jean43069 start **/
    // 마스터 수신 재설정 조회
    this.selectMasterRespons    = "\n    SELECT A.RECV_ID            AS RECV_ID                                                    ".rtrim()
								+ "\n         , A.REQT_RM            AS REQT_RM                                                    ".rtrim()
								+ "\n         , A.TABLE_NM           AS TABLE_NM                                                   ".rtrim()
								+ "\n         , A.LAST_SEQ           AS LAST_SEQ                                                   ".rtrim()
								+ "\n         , A.LAST_SEQ           AS ORG_LAST_SEQ                                               ".rtrim()
								+ "\n         , A.UPD_DT             AS UPD_DT                                                     ".rtrim()
								+ "\n         , B.CNT                AS CNT                                                        ".rtrim()
								+ "\n      FROM (                                                                                  ".rtrim()
								+ "\n    	       SELECT RECV_ID                                                                  ".rtrim()
								+ "\n    	            , REQT_RM                                                                  ".rtrim()								
								+ "\n			        , CASE ( SUBSTR( REQT_NM, 1, 5 ))		                                   ".rtrim()
								+ "\n    	    	 	        WHEN 'CODEM' THEN 'CCD_' || SUBSTR( REQT_NM, 1, 5 ) || '_T'	       ".rtrim()
								+ "\n    	    	 	        WHEN 'CRDCP' THEN 'CCD_' || SUBSTR( REQT_NM, 1, 5 ) || '_T'	       ".rtrim()
								+ "\n    	    	 	        WHEN 'ENVDT' THEN 'CCD_' || SUBSTR( REQT_NM, 1, 5 ) || '_T'	       ".rtrim()
								+ "\n    	    	 	        WHEN 'ENVHD' THEN 'CCD_' || SUBSTR( REQT_NM, 1, 5 ) || '_T'	       ".rtrim()
								+ "\n    	    	 	        WHEN 'ENVPD' THEN 'CCD_' || SUBSTR( REQT_NM, 1, 5 ) || '_T'	       ".rtrim()
								+ "\n    	    	 	        WHEN 'VANCM' THEN 'CCD_' || SUBSTR( REQT_NM, 1, 5 ) || '_T'	       ".rtrim()
								+ "\n    	    	 	        WHEN 'CSTCL' THEN 'HCS_' || SUBSTR( REQT_NM, 1, 5 ) || '_T'	       ".rtrim()
								+ "\n    	    	 	        WHEN 'CSTMS' THEN 'HCS_' || SUBSTR( REQT_NM, 1, 5 ) || '_T'	       ".rtrim()
								+ "\n    	    	 	        WHEN 'CSTPT' THEN 'HCS_' || SUBSTR( REQT_NM, 1, 5 ) || '_T'	       ".rtrim()
								+ "\n    	    	 	        WHEN 'DLTEL' THEN 'HCS_' || SUBSTR( REQT_NM, 1, 5 ) || '_T'	       ".rtrim()
								+ "\n    	    	 	        WHEN 'DLADR' THEN 'HCS_' || SUBSTR( REQT_NM, 1, 5 ) || '_T'	       ".rtrim()
								+ "\n    	    	 	        WHEN 'MCODE' THEN 'SCD_CODEM_T'		                               ".rtrim()
								+ "\n    	              ELSE 'SCD_' || SUBSTR( REQT_NM, 1, 5 ) || '_T'                           ".rtrim()
								+ "\n    	    	      END   TABLE_NM                                                           ".rtrim()
								+ "\n			        , CASE WHEN LENGTH(LAST_SEQ)  = 0 THEN 0 ELSE LAST_SEQ  END AS LAST_SEQ    ".rtrim()
								+ "\n			        , UPD_DT                                                                   ".rtrim()
								+ "\n                FROM RECV_SEQ_T                                                               ".rtrim()
								+ "\n               ORDER BY REQT_RM                                                               ".rtrim()
							    + "\n          ) A                                                                                 ".rtrim()
								+ "\n    	, (                                                                                    ".rtrim()
								+ "\n    			  SELECT COUNT(*) AS CNT , 73 AS RECV_ID  FROM SCD_KTCLS_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 74 AS RECV_ID  FROM SCD_KTKEY_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 7  AS RECV_ID  FROM CCD_CODEM_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 1  AS RECV_ID  FROM SCD_CODEM_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 55 AS RECV_ID  FROM SCD_FUNKY_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 72 AS RECV_ID  FROM SCD_LABEL_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 5  AS RECV_ID  FROM SCD_SHOPM_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 25 AS RECV_ID  FROM SCD_FDTBL_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 8  AS RECV_ID  FROM SCD_ENVSH_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 21 AS RECV_ID  FROM SCD_BARCD_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 61 AS RECV_ID  FROM SCD_DLVCL_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 62 AS RECV_ID  FROM SCD_DLVCM_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 43 AS RECV_ID  FROM CCD_VANCM_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 15 AS RECV_ID  FROM SCD_BRAND_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 11 AS RECV_ID  FROM SCD_EMPMS_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 57 AS RECV_ID  FROM SCD_EMPFK_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 34 AS RECV_ID  FROM SCD_SDSGR_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 35 AS RECV_ID  FROM SCD_SDSCL_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 36 AS RECV_ID  FROM SCD_SDSCD_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 32 AS RECV_ID  FROM SCD_SDACL_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 33 AS RECV_ID  FROM SCD_SDACD_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 12 AS RECV_ID  FROM SCD_CLSLM_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 19 AS RECV_ID  FROM SCD_PRODM_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 14 AS RECV_ID  FROM SCD_CLSSM_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 13 AS RECV_ID  FROM SCD_CLSMM_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 28 AS RECV_ID  FROM SCD_TKGFT_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 20 AS RECV_ID  FROM SCD_PRCDT_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 70 AS RECV_ID  FROM SCD_PRDSN_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 52 AS RECV_ID  FROM SCD_PRTPR_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 4  AS RECV_ID  FROM CCD_ENVPD_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 24 AS RECV_ID  FROM SCD_PRDST_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 64 AS RECV_ID  FROM SCD_PRTTM_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 18 AS RECV_ID  FROM SCD_SEASN_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 17 AS RECV_ID  FROM SCD_YEARM_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 65 AS RECV_ID  FROM SCD_EXCHG_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 29 AS RECV_ID  FROM SCD_ACCNT_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 45 AS RECV_ID  FROM SCD_JCDDT_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 44 AS RECV_ID  FROM SCD_JCDHD_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 58 AS RECV_ID  FROM SCD_KCHMO_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 51 AS RECV_ID  FROM SCD_PRTMS_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 9  AS RECV_ID  FROM SCD_ENVKP_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 31 AS RECV_ID  FROM SCD_KPRMS_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 71 AS RECV_ID  FROM SCD_PAGMS_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 63 AS RECV_ID  FROM SCD_PRTPS_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 42 AS RECV_ID  FROM CCD_CRDCP_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 6  AS RECV_ID  FROM SCD_SHOPS_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 27 AS RECV_ID  FROM SCD_TKCPN_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 26 AS RECV_ID  FROM SCD_TKCLS_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 46 AS RECV_ID  FROM SCD_CPNDT_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 53 AS RECV_ID  FROM SCD_TUCLS_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 54 AS RECV_ID  FROM SCD_TUKEY_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 47 AS RECV_ID  FROM SCD_TBGRP_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 49 AS RECV_ID  FROM SCD_TBLST_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 48 AS RECV_ID  FROM SCD_TBLPT_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 50 AS RECV_ID  FROM SCD_TABLE_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 16 AS RECV_ID  FROM SCD_SLMGM_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 22 AS RECV_ID  FROM SCD_TCCLS_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 23 AS RECV_ID  FROM SCD_TCKEY_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 41 AS RECV_ID  FROM SCD_POSFN_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 30 AS RECV_ID  FROM SCD_POSMS_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 10 AS RECV_ID  FROM SCD_ENVPS_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 56 AS RECV_ID  FROM SCD_POSFK_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 40 AS RECV_ID  FROM SCD_PRINT_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 3  AS RECV_ID  FROM CCD_ENVDT_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 2  AS RECV_ID  FROM CCD_ENVHD_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 37 AS RECV_ID  FROM HCS_CSTCL_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 60 AS RECV_ID  FROM HCS_DLTEL_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 59 AS RECV_ID  FROM HCS_DLADR_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 39 AS RECV_ID  FROM HCS_CSTPT_T                     ".rtrim()
								+ "\n    		UNION SELECT COUNT(*) AS CNT , 38 AS RECV_ID  FROM HCS_CSTMS_T                     ".rtrim()
								+ "\n    		) B                                                                                ".rtrim()
							    + "\n     WHERE A.RECV_ID = B.RECV_ID                                                              ".rtrim()
							    ;
    
    // 마스터 수신 초기화
    this.updateMasterReset = "UPDATE RECV_SEQ_T                                                                        ".rtrim()
     					   + "   SET LAST_SEQ = '0'                                                                    ".rtrim()
     					   + "     , UPD_DT   = strftime('%Y%m%d%H%M%S', 'now', 'localtime')                           ".rtrim()
     					   + " WHERE RECV_ID  = ?                                                                      ".rtrim()
     					   ;    
    /** jean43069 end **/

    //admin login SQL
    this.adminLoginSelectSQL = ""
				+ "\n SELECT                                                                                       " 
				+ "\n        SHOP_CD                                                                  ".rtrim()
				+ "\n      , EMP_NO                                                                   ".rtrim()
				+ "\n      , EMP_NM                                                                   ".rtrim()
				+ "\n      , EMP_PWD                                                                  ".rtrim()
				+ "\n      , EMP_FG                                                                   ".rtrim()
				+ "\n      , EMP_CLASS_CD                                                             ".rtrim()
				+ "\n      , WEB_USE_YN                                                               ".rtrim()
				+ "\n      , USER_ID                                                                  ".rtrim()
				+ "\n      , USER_PWD                                                                 ".rtrim()
				+ "\n      , POSTING_YN                                                               ".rtrim()
				+ "\n      , ORDER_FG                                                                 ".rtrim()
				+ "\n      , EMP_CARD_NO                                                              ".rtrim()
				+ "\n      , TEL_NO                                                                   ".rtrim()
				+ "\n      , POST_NO                                                                  ".rtrim()
				+ "\n      , ADDR                                                                     ".rtrim()
				+ "\n      , ADDR_DTL                                                                 ".rtrim()
				+ "\n      , RETIRE_FG                                                                ".rtrim()
				+ "\n      , SMS_RECV_YN                                                              ".rtrim()
				+ "\n      , USE_YN                                                                   ".rtrim()
				+ "\n   FROM SCD_EMPMS_T                                                              ".rtrim()
				+ "\n  WHERE SHOP_CD   = ?                                                            ".rtrim()
				+ "\n    AND EMP_NO    = ?                                                            ".rtrim()
				+ "\n    AND RETIRE_FG = '0'  /** CCD+CODEM_T :009 , 0:재직, 1 : 퇴직, 2 : 휴직 **/   ".rtrim()
				+ "\n    AND USE_YN    = 'Y'                                                          ".rtrim()
				;

    // scd_setup_t 테이블의 데이터를 조회한다.
    this.selectSetUpTData = "\n SELECT SHOP_CD, POS_NO, MAIN_IP, EMP_NO, KIOSK_VER_SEQ, IMG_FILE_VER, LOGLEVEL, WAIT_VIDEO_VER, WAIT_VIDEO_EXT, WAIT_IMG_VER, WAIT_IMG_EXT, KIOSK_21_LOGO_IMG_URL, KIOSK_21_LOGO_IMG_VER ".rtrim()
                            + "\n   FROM SCD_SETUP_T ".rtrim()                          	    
                            + "\n  WHERE SHOP_CD = ? ".rtrim()
                            + "\n    AND POS_NO  = ? ".rtrim()
                            ;
    
    // scd_setup_t 테이블에 WAIT_VIDEO_VER update한다.
    this.updateSetUpWaitVideoVer =   "\n UPDATE SCD_SETUP_T ".rtrim()
						           + "\n    SET WAIT_VIDEO_VER = ? ".rtrim()
						           + "\n      , WAIT_VIDEO_EXT = ? ".rtrim()
						           + "\n  WHERE SHOP_CD = ? ".rtrim()
						           + "\n    AND POS_NO  = ? ".rtrim()
						           ;
    
    // scd_setup_t 테이블에 WAIT_IMG_VER update한다.
    this.updateSetUpWaitImgVer =   "\n UPDATE SCD_SETUP_T ".rtrim()
    		                     + "\n    SET WAIT_IMG_VER = ? ".rtrim()
    		                     + "\n      , WAIT_IMG_EXT = ? ".rtrim()
                                 + "\n  WHERE SHOP_CD = ? ".rtrim()
                                 + "\n    AND POS_NO  = ? ".rtrim()
                                 ;
    
    // scd_setup_t 테이블에 KIOSK_21_LOGO_IMG_URL, KIOSK_21_LOGO_IMG_VER update한다.
    this.updateSetUpLogoData =   "\n UPDATE SCD_SETUP_T ".rtrim()
						           + "\n    SET KIOSK_21_LOGO_IMG_VER = ? ".rtrim()
						           + "\n      , KIOSK_21_LOGO_IMG_URL = ? ".rtrim()
						           + "\n  WHERE SHOP_CD = ? ".rtrim()
						           + "\n    AND POS_NO  = ? ".rtrim()
						           ;
    
    this.updateSetupMainIp =  "UPDATE SCD_SETUP_T SET MAIN_IP = ? WHERE SHOP_CD = ? AND POS_NO  = ? ";

    this.selectCloseDateList =  "SELECT  SALE_DATE, REGI_SEQ FROM POS_REGIS_T "
                                + " WHERE SHOP_CD = ? "
                                    + " AND SALE_DATE = ? "
                                    + " AND POS_NO = ? "
                                 	+ " AND CLOSE_FG IN ( '2', '3' ) ";

    this.selectSslTretcList = "SELECT SHOP_CD, SALE_DATE, POS_NO, BILL_NO, SEQ_NO, TR_TYPE_CD, APPR_AMT, USER_DATA "
                                + " FROM SSL_TRETC_T "
                                + " WHERE SHOP_CD = ? "
                                    + " AND SALE_DATE = ? "
                                    + " AND POS_NO = ? "
                                    + " AND BILL_NO = ? ";
    
    this.selectSslTrJcdTCancel = "SELECT SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, SEQ_NO, CASE JCD_PROC_FG WHEN '0' THEN '04' WHEN '1' THEN '07' WHEN '6' THEN '03' WHEN '2' THEN '03' END AS PAY_TYPE_FG "
							    + " , SALE_YN, CORNER_CD, VAN_TERM_NO, 0 AS APPR_REQ_AMT, APPR_AMT, 0 AS VAT_AMT, 0 AS SVC_TIP_AMT, '0' AS APPR_TYPE_FG, SALE_YN AS APPR_FG, APPR_PROC_FG "
							    + " , CARD_IN_FG, APPR_DATE, APPR_NO, '' AS APPR_IDT_TYPE, '' AS APPR_IDT_FG, JCD_CARD_NO AS CARD_NO, '' AS INST_MM_FG, 0 AS INST_MM_CNT, VALID_TERM "
							    + " , SIGN_PAD_YN, '' AS CRDCP_CD, 0 AS APPR_DC_AMT, APPR_LOG_NO, JCD_PROC_FG, JCD_TYPE_FG, JCD_PAY_FG, CNMK_CD , '0' AS UNION_PAY_FG, '' AS USER_DATA, JCD_CD, JCD_DC_AMT, JCD_USE_POINT "
								+ " FROM SSL_TRJCD_T "
								+ " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND APPR_PROC_FG <> '0' AND JCD_CD <> 'ZBNK' AND   JCD_PROC_FG  IN ('0','1','2','6') ";

    this.selectSslTrcshTCancel = "SELECT SHOP_CD, SALE_DATE, POS_NO, BILL_NO, LINE_NO, SEQ_NO, REGI_SEQ, SALE_YN, VAN_CD, CORNER_CD "
	    + " , CASH_AMT, APPR_AMT, SVC_TIP_AMT, VAT_AMT, APPR_PROC_FG, APPR_IDT_TYPE, APPR_IDT_FG, CARD_IN_FG, APPR_IDT_NO, APPR_DATE "
	    + " , APPR_TIME, APPR_NO, APPR_MSG, VAN_TERM_NO, VAN_SLIP_NO, ORG_APPR_DATE, ORG_APPR_NO, APPR_LOG_NO, INS_DT, EMP_NO "
	    + " , EX_CD, EX_KRW, EX_EXP_AMT, EX_IN_AMT, EX_RET_AMT, KR_RET_AMT, EX_PAY_AMT, KR_PAY_AMT, KR_ETC_AMT, PRE_PAY_FG, NOTICE_MSG, BROAD_MSG, CNMK_CD, SEC_FLAG, VAT_SALE_AMT, NO_VAT_SALE_AMT "
		+ " FROM SSL_TRCSH_T "
		+ " WHERE SHOP_CD = ? AND SALE_DATE = ? AND POS_NO = ? AND BILL_NO = ? AND APPR_PROC_FG <> '0' ";
    
	this.deletePosRegis = " DELETE FROM POS_REGIS_T WHERE SALE_DATE = ? ";
	
	 this.getKioskClsDataAdmin_SQL = ""
			+ "\n SELECT TU_FG                                              ".rtrim()
			+ "\n      , TU_CLS_CD                                          ".rtrim()
			+ "\n      , TU_CLS_NM                                          ".rtrim()
			+ "\n      , IFNULL(TU_CLS_NM_EN , TU_CLS_NM) TU_CLS_NM_EN      ".rtrim()
			+ "\n      , TU_CLS_SEQ                                         ".rtrim()
			+ "\n      , (CASE WHEN 'BEST' = upper(TU_CLS_NM_EN) THEN 'Y' ELSE 'N' END) AS BEST_PROD_YN ".rtrim()
            + "\n      , IFNULL(TU_CLS_DISP_FG, 'Y') AS TU_CLS_DISP_FG      ".rtrim()
            + "\n      , IFNULL(TU_CLS_PROC_FG, '1') AS TU_CLS_PROC_FG      ".rtrim()
            + "\n      , RECUR_S_DATE                                       ".rtrim()
            + "\n      , RECUR_E_DATE                                       ".rtrim()
            + "\n      , RECUR_TERM                                         ".rtrim()
            + "\n      , RECUR_S_TIME                                       ".rtrim()
            + "\n      , RECUR_E_TIME                                       ".rtrim()
			+ "\n   FROM SCD_KTCLS_T                                        ".rtrim()
			+ "\n  WHERE SHOP_CD = ?	                                    ".rtrim()
			// 사이드 분류 나오도록 UNION 추가
			+ "\n  UNION ".rtrim()
			+ "\n SELECT 'S' AS TU_FG ".rtrim()
			+ "\n      , 'SIDE' AS TU_CLS_CD ".rtrim()
			+ "\n      , '사이드 메뉴' AS TU_CLS_NM ".rtrim()
			+ "\n      , 'SIDE MENU' AS TU_CLS_NM_EN ".rtrim()
			+ "\n      , '999' AS TU_CLS_SEQ        ".rtrim()
			+ "\n      , 'N' AS BEST_PROD_YN        ".rtrim()
            + "\n      , 'Y' AS TU_CLS_DISP_FG      ".rtrim()
	        + "\n      , '1' AS TU_CLS_PROC_FG      ".rtrim()
	        + "\n      , '' AS RECUR_S_DATE         ".rtrim()
	        + "\n      , '' AS RECUR_E_DATE         ".rtrim()
	        + "\n      , '' AS RECUR_TERM           ".rtrim()
	        + "\n      , '' AS RECUR_S_TIME         ".rtrim()
	        + "\n      , '' AS RECUR_E_TIME         ".rtrim()
			+ "\n   FROM SCD_KTCLS_T ".rtrim()
			+ "\n  ORDER BY TU_CLS_SEQ                                   ".rtrim()
			;
	 
	//코너사업자 이미지 다운로드
    this.selectConerImgUrl = " SELECT SHOP_CD, CORNER_CD, IMG_URL, IMG_URL_FG "
                            + " FROM SCD_SHOPS_T "
                            + " WHERE SHOP_CD = ? "
                                + " AND (IMG_URL_FG = 'U' OR IMG_URL_FG IS NULL OR IMG_URL_FG = '') "
                             	+ " AND (IMG_URL IS NOT NULL AND IMG_URL != '') ";
    
    //코너사업자 이미지 다운로드
    this.selectConerImgUrlCheck = " SELECT SHOP_CD, CORNER_CD, IMG_URL, IMG_URL_FG "
                                + " FROM SCD_SHOPS_T "
                                + " WHERE SHOP_CD = ? "
                                    + " AND IMG_URL_FG = 'Y'"
                                    + " AND (IMG_URL IS NOT NULL AND IMG_URL != '') "
                                + " ORDER BY CORNER_CD";
    
    //상품 이미지 다운로드 업데이트
    this.updateConerImgUrl = " UPDATE SCD_SHOPS_T SET IMG_URL_FG = 'Y', IMG_URL = ? WHERE SHOP_CD = ? AND CORNER_CD = ?";

    // 화면 권한이 있는 직원인지를 체크한다.
    this.selectAdminMenuEmpAuthYn = " SELECT COUNT(*) AS CNT " +
    		                            "FROM SCD_FUNKY_T A " +
    		                           "WHERE A.AUTH_YN = 'Y' " +
    		                           "  AND A.SHOP_CD = ?  " +
    		                           "  AND A.FK_NO = ? ";
    
    // 화면 권한이 있는 직원인지를 체크한다.
    this.selectAdminMenuEmpAuthChk = " SELECT COUNT(*) AS CNT " +
    		                            "FROM SCD_EMPMS_T A " +
    		                            "   , SCD_EMPFK_T B " +
    		                            "   , SCD_FUNKY_T C " +
    		                           "WHERE A.SHOP_CD = B.SHOP_CD " +
    		                           "  AND A.EMP_FG = B.EMP_FG " +
    		                           "  AND B.SHOP_CD = C.SHOP_CD " +
    		                           "  AND B.FK_NO = C.FK_NO " +
    		                           "  AND A.USE_YN = 'Y' " +
    		                           "  AND C.AUTH_YN = 'Y' " +
    		                           "  AND A.SHOP_CD = ?  " +
    		                           "  AND B.FK_NO = ? " +
    		                           "  AND A.EMP_NO = ? ";
    
    // 화면 권한이 없는 직원일 때 화면을 진입하기 위한 비밀번호를 체크한다.
    this.selectAdminMenuEmpAuthPwd = " SELECT COUNT(*) AS CNT FROM SCD_EMPMS_T A , SCD_EMPFK_T B WHERE A.SHOP_CD = B.SHOP_CD AND A.EMP_FG = B.EMP_FG AND A.SHOP_CD = ?  AND B.FK_NO = ? AND A.EMP_NO || A.EMP_PWD = ? AND A.USE_YN = 'Y' ";
	    
}