var AdminProductData = function(){
	
	/************************************************
	 * 상품데이터 조회
	 * @parameter clsCd 터치분류코드
	 * @parameter langCode 언어코드
	 ************************************************/
	this.getProductData = function (clsCd, _langCode) {
		let kitchenPrintSQL = ""
			+ "\n           SELECT                              " .rtrim()
			+ "\n                 PROD_CD                       " .rtrim()
			+ "\n               , GROUP_CONCAT(PRT_NO) PRT_NO   ".rtrim() 
			+ "\n            FROM SCD_PRTPR_T                   ".rtrim() 
			+ "\n           WHERE SHOP_CD = '%s'                ".sprintf(gShopCd).rtrim() 
			+ "\n             AND USE_YN  = 'Y'                 ".rtrim()
			+ "\n           GROUP BY SHOP_CD , PROD_CD          ".rtrim()
 			;
		var sql = ""
			+ "\n  SELECT                                                                                                  ".rtrim()
			+ "\n  	CASE                                                                                                   ".rtrim()
			+ "\n  		WHEN '1' = VAT_CD AND TAX_YN = 'Y' THEN SALE_UPRC - 공급가                                                                                              ".rtrim() /** 과세 품목. TAX 포함 **/
			+ "\n  		WHEN '0' = VAT_CD AND TAX_YN = 'Y' THEN CAST ( ROUND( (   공급가 * 0.1 ) )    AS INTEGER)            ".rtrim()  /** 과세 품목. 미포함 **/            
			+ "\n  		WHEN TAX_YN = 'N'                  THEN 0/** 비과세 품목.**/                                           ".rtrim()                                       
			+ "\n  		ELSE 0                                                                                             ".rtrim()
			+ "\n  	 END  VAT                                                                                              ".rtrim()
			+ "\n  	,  *                                                                                                   ".rtrim()
			+ "\n   FROM (                                                                                                 ".rtrim()
			+ "\n    SELECT  DISTINCT                                                                                      ".rtrim()
			+ "\n            A.TU_FG                           AS TU_FG                                                    ".rtrim()
			// 상품관리 ASP 전송시 필요한 col (jean43069) start
			+ "\n          , B.LCLS_CD                         AS LCLS_CD         /**상품-대분류코드**/                        ".rtrim()
			+ "\n          , B.MCLS_CD                         AS MCLS_CD         /**상품-중분류코드**/                        ".rtrim()
			+ "\n          , B.SCLS_CD                         AS SCLS_CD         /**상품-소분류코드**/                        ".rtrim()
			+ "\n          , B.PRICE_MGR_FG                    AS PRICE_MGR_FG    /** 가격관리구분   ( CCD_CODEM_T : 011 ) 0:정가상품 1:비정가상품 **/ ".rtrim()
			+ "\n          , IFNULL(B.TIP_MENU_YN ,'N')        AS TIP_MENU_YN     /** 봉사료부과여부 Y:부과 N:미부과 **/            ".rtrim()
			+ "\n          , IFNULL(B.CST_ACCDC_YN ,'N')       AS CST_ACCDC_YN    /** 고객적립할인여부 **/                      ".rtrim()
			+ "\n          , IFNULL(E.BAR_CD ,'')              AS BAR_CD                                                   ".rtrim()
			+ "\n          , A.SHOP_CD 						   AS SHOP_CD                                                  ".rtrim()
			// 상품관리 ASP 전송시 필요한 col (jean43069) end
			+ "\n          , A.TU_CLS_CD                       AS TU_CLS_CD                                                ".rtrim()
			+ "\n          , A.TU_KEY_CD                       AS TU_KEY_CD                                                ".rtrim()
			+ "\n          , A.PROD_CD                         AS PROD_CD                                                  ".rtrim()
			+ "\n          , B.PROD_NM                         AS PROD_NM                                                  ".rtrim()
			+ "\n          , B.TAX_YN                          AS TAX_YN                                                   ".rtrim()
			+ "\n          , IFNULL( B.PROD_NM_EN , B.PROD_NM) AS PROD_NM_EN                                               ".rtrim()
			+ "\n          , B.IMG_URL                         AS IMG_URL                                                  ".rtrim()
			+ "\n          , B.IMG_DOWNLOAD_FG                 AS IMG_DOWNLOAD_FG                                          ".rtrim()
			+ "\n          , B.KIOSK_PROD_STATUS               AS KIOSK_PROD_STATUS                                        ".rtrim()
			+ "\n          , C.SALE_UPRC                       AS SALE_UPRC                                                ".rtrim()
			+ "\n  		    /** 과세 포함.**/                                                                                 ".rtrim()
			+ "\n  		   , CASE                                                                                          ".rtrim()
			+ "\n  				WHEN '1' = VAT_CD AND TAX_YN = 'Y' THEN CAST ( ROUND( ( C.SALE_UPRC / 1.1 ) )  AS INTEGER) ".rtrim() /** 부가세 포함,과세 품목.**/
			+ "\n  				WHEN '0' = VAT_CD AND TAX_YN = 'Y' THEN C.SALE_UPRC                                        ".rtrim()  /** 부가세 비포함,과세 품목.**/
			+ "\n  				WHEN TAX_YN = 'N'                  THEN C.SALE_UPRC                                        ".rtrim() /** 비과세 품목.**/
			+ "\n  		       ELSE 0                                                                                      ".rtrim()
			+ "\n  		      END AS  \"공급가\"                                                                             ".rtrim()
			+ "\n          , B.SIDE_MENU_YN                     AS SIDE_MENU_YN /** 사이드메뉴 사용여부       **/                    ".rtrim()
			+ "\n          , B.SDA_CLS_CD                       AS SDA_CLS_CD   /** 사이드메뉴-속성분류코드   **/                  ".rtrim()
			+ "\n          , B.SDS_GRP_CD                       AS SDS_GRP_CD   /** 사이드메뉴-선택그룹코드   **/                  ".rtrim()
			+ "\n          , 1                                  AS ORDER_QTY    /** 주문수량에 사용하기 위함  **/                   ".rtrim()
			+ "\n          , IFNULL(STAMP_ACC_YN, 'N')          AS STAMP_ACC_YN                                            ".rtrim()
			+ "\n          , STAMP_ACC_QTY                                                                                 ".rtrim()
			+ "\n          , IFNULL(STAMP_USE_YN , 'N')         AS STAMP_USE_YN                                            ".rtrim()
			+ "\n          , STAMP_USE_QTY                                                                                 ".rtrim()
			+ "\n          , VAT_CD                                                                                        ".rtrim()
			+ "\n          , PRT_NO                                                                                        ".rtrim()
			+ "\n          , B.KIOSK_PROD_YN                                                                                 ".rtrim()
			+ "\n          , B.CUP_DEPOSIT_FG                                                                                 ".rtrim()
			+ "\n          , B.CUP_FG                                                                                 ".rtrim()
			+ "\n       FROM SCD_KTKEY_T A   /** KIOSK 터치상품          **/                                                       ".rtrim()
			+ "\n          , SCD_PRODM_T B   /** 상품마스터              **/                                                          ".rtrim()
			+ "\n    	  , (                                                                                              ".rtrim()
			+ "\n    		  SELECT                                                                                       ".rtrim()
			+ "\n    		      A.PROD_CD                                                                                ".rtrim()
			+ "\n    		    , A.S_DATE                                                                                 ".rtrim()
			+ "\n    		    , A.E_DATE                                                                                 ".rtrim()
			+ "\n    		    , A.SALE_UPRC                                                                              ".rtrim()
			+ "\n    		  FROM SCD_PRCDT_T  A                                                                          ".rtrim()
			+ "\n    		    , (                                                                                        ".rtrim()
			+ "\n    		  	SELECT                                                                                     ".rtrim()
			+ "\n    		  	  PROD_CD, MIN(S_DATE) S_DATE                                                              ".rtrim()
			+ "\n    		  	FROM SCD_PRCDT_T                                                                           ".rtrim()
			+ "\n    		  	WHERE SHOP_CD = ?                                                                          ".rtrim() //shop_cd
			+ "\n    		  	AND S_DATE  <= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
			+ "\n    		  	AND E_DATE  >= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
			+ "\n    		  	GROUP BY PROD_CD                                                                           ".rtrim()
			+ "\n    		    ) B                                                                                        ".rtrim()
			+ "\n    		  WHERE A.SHOP_CD = ?                                                                          ".rtrim() //shop_cd
			+ "\n    		    AND A.S_DATE  <= strftime('%Y%m%d' , 'NOW' , 'localtime')                                  ".rtrim()
			+ "\n    		    AND A.E_DATE  >= strftime('%Y%m%d' , 'NOW' , 'localtime')                                  ".rtrim()
			+ "\n    		    AND A.PROD_CD = B.PROD_CD                                                                  ".rtrim()
			+ "\n    		    AND A.S_DATE  = B.S_DATE                                                                   ".rtrim()
			+ "\n    	   ) C                                                                                             ".rtrim()
			+ "\n  	   , (SELECT  ? AS VAT_CD ) D /** VAT 포함 여부 코드 **/                                                     ".rtrim() //VAT CD (CODE 128)  1 : 과세 포함, 0 : 과세 불포함.
			// 상품관리 ASP 전송시 필요한 table(SCD_BARCD_T)
			+ "\n      LEFT OUTER JOIN SCD_BARCD_T E ON B.SHOP_CD = E.SHOP_CD AND B.PROD_CD = E.PROD_CD					   ".rtrim()
			+ "\n      LEFT OUTER JOIN (" 
			+  kitchenPrintSQL //주방프린터 관련 SQL.
			+		")  F ON B.PROD_CD = F.PROD_CD                                                                         ".rtrim()
			+ "\n     WHERE B.SHOP_CD       = A.SHOP_CD                                                                    ".rtrim()
			+ "\n       AND B.PROD_CD       = A.PROD_CD                                                                    ".rtrim()
			+ "\n       AND A.SHOP_CD       = ?                                                                            ".rtrim() //shop_cd
			//+ "\n       AND A.TU_FG         = 'S'                                                                          ".rtrim()//2020.09.08 최광림 차장 요청( 의미없는 조건)
			+ "\n       AND A.TU_CLS_CD     = IFNULL ( ? , A.TU_CLS_CD )                                                   ".rtrim() //clscd-> 터치분류CD
			+ "\n       AND B.PRICE_MGR_FG  != '1'                                                                         ".rtrim()
			+ "\n       AND B.USE_YN        = 'Y'                                                                          ".rtrim()
			+ "\n       AND B.KIOSK_PROD_YN = 'Y'  /** KIOSK 상품 여부 **/                                                     ".rtrim()
			+ "\n       AND B.SALE_PROD_YN  = 'Y'                                                                          ".rtrim()
			+ "\n       AND A.PROD_CD       = C.PROD_CD                                                                    ".rtrim()
			+ "\n  )                                                                                                       ".rtrim()
			;

		var vsVatCd = util.GetEnvXmlShopENV(128); // 부가세 여부 0:별도, 1:포함
		var resultData = gfn_SQLiteSQLProcess(sql, [gShopCd  , gShopCd , '1' , gShopCd , clsCd ]); 


		if ( resultData!= null && resultData.ResultCode == "0" ) {
			var rows = resultData.Data;
			if ( rows == undefined || rows == null ||  rows.length == 0 ) {
				return [];
			}

			for ( var i = 0 ; i < rows.length ; i++ ) {
				var row = rows[i];
				var saleUrpc = Number(row.SALE_UPRC);
				row['판매단가']		     = saleUrpc;//판매가격 숫자로 변환
				row['판매단가_출력용']	= util.numberWithCommas(row.SALE_UPRC);//판매가격 Text 로 보여질 값.

				row['합계금액']			= saleUrpc  ;//합계금액으로 계산하기 위하여.
				row['합계금액_출력용']	= row.SALE_UPRC_VIEW;//합계금액을 산출 후 보여줄 Text(사용은 됨)
			}
			//debugger;
			if ( _langCode == 'org') {
				rows.forEach(e=>{
					if( !util.isEmpty( e.PRT_NO ) )
						e.printNos = e.PRT_NO.split(",");
					else {
						e.printNos = [];
						e.PRT_NO ="";
					}
				});
				return rows;
			}

			return  util.setRowsLanguage( rows, _langCode, 'PROD_NM'  );//언어처리.
		}
		return [];
	}
	
	/************************************************
	 * 상품데이터 조회
	 * @parameter clsCd 터치분류코드
	 * @parameter langCode 언어코드
	 ************************************************/
	this.getProductSideData = function (clsCd, _langCode) {		
		var sql = ""                                                                                                                      
    + "\n  SELECT DISTINCT                                                                                                                 ".rtrim()
	+ "\n			  ''                           AS TU_FG                                                                                    ".rtrim()
	+ "\n			, M.LCLS_CD                         AS LCLS_CD                                                                             ".rtrim()
	+ "\n			, M.MCLS_CD                         AS MCLS_CD                                                                             ".rtrim()
	+ "\n			, M.SCLS_CD                         AS SCLS_CD                                                                             ".rtrim()
	+ "\n			, M.PRICE_MGR_FG                    AS PRICE_MGR_FG                                                                        ".rtrim()
	+ "\n			, IFNULL(M.TIP_MENU_YN ,'N')        AS TIP_MENU_YN                                                                         ".rtrim()
	+ "\n			, IFNULL(M.CST_ACCDC_YN ,'N')       AS CST_ACCDC_YN                                                                        ".rtrim()
	+ "\n			, IFNULL(E.BAR_CD ,'')              AS BAR_CD                                                                              ".rtrim()
	+ "\n			, M.SHOP_CD 						   AS SHOP_CD                                                                          ".rtrim()
	+ "\n			, ''                       AS TU_CLS_CD                                                                                    ".rtrim()
	+ "\n			, ''                       AS TU_KEY_CD                                                                                    ".rtrim()
	+ "\n			, M.PROD_CD                         AS PROD_CD                                                                                    ".rtrim()
	+ "\n			, M.PROD_NM                         AS PROD_NM                                                                             ".rtrim()
	+ "\n			, M.TAX_YN                          AS TAX_YN                                                                              ".rtrim()
	+ "\n			, IFNULL( M.PROD_NM_EN , M.PROD_NM) AS PROD_NM_EN                                                                          ".rtrim()
	+ "\n			, M.IMG_URL                         AS IMG_URL                                                                             ".rtrim()
	+ "\n			, M.IMG_DOWNLOAD_FG                 AS IMG_DOWNLOAD_FG                                                                     ".rtrim()
	+ "\n			, M.KIOSK_PROD_STATUS               AS KIOSK_PROD_STATUS                                                                   ".rtrim()
	+ "\n			, C.SALE_UPRC                       AS SALE_UPRC                                                                           ".rtrim()                                                        
	+ "\n			, CASE                                                                                                                     ".rtrim()
	+ "\n				   WHEN '1' = VAT_CD AND TAX_YN = 'Y' THEN CAST ( ROUND( ( C.SALE_UPRC / 1.1 ) )  AS INTEGER)                          ".rtrim()
	+ "\n				   WHEN '0' = VAT_CD AND TAX_YN = 'Y' THEN C.SALE_UPRC                                                                 ".rtrim()
	+ "\n				   WHEN TAX_YN = 'N'                  THEN C.SALE_UPRC                                                                 ".rtrim()
	+ "\n				   ELSE 0                                                                                                              ".rtrim()
	+ "\n			   END AS  '공급가'                                                                                                        ".rtrim()
	+ "\n			, M.SIDE_MENU_YN                     AS SIDE_MENU_YN                                                                       ".rtrim()
	+ "\n			, M.SDA_CLS_CD                       AS SDA_CLS_CD                                                                         ".rtrim()
	+ "\n			, M.SDS_GRP_CD                       AS SDS_GRP_CD                                                                         ".rtrim()
	+ "\n			, 1                                 AS ORDER_QTY                                                                           ".rtrim()
	+ "\n			, IFNULL(M.STAMP_ACC_YN, 'N')          AS STAMP_ACC_YN                                                                     ".rtrim()
	+ "\n			, M.STAMP_ACC_QTY                                                                                                          ".rtrim()
	+ "\n			, IFNULL(M.STAMP_USE_YN , 'N')         AS STAMP_USE_YN                                                                     ".rtrim()
	+ "\n			, M.STAMP_USE_QTY                                                                                                          ".rtrim()
	+ "\n			, VAT_CD                                                                                                                   ".rtrim()
	+ "\n			, F.PRT_NO AS PRT_NO                                                                                                             ".rtrim()
	+ "\n			, M.KIOSK_PROD_YN                                                                                                          ".rtrim()
	+ "\n          , M.CUP_DEPOSIT_FG                                                                                 							".rtrim()
	+ "\n          , M.CUP_FG                                                                                 									".rtrim()
	+ "\n			  FROM SCD_PRODM_T M                                                                                                       ".rtrim()
	+ "\n			     , SCD_SDSCD_T S                                                                                                       ".rtrim()
	+ "\n			     , (                                                                                                                   ".rtrim()
	+ "\n					SELECT A.PROD_CD                                                                                                   ".rtrim()
	+ "\n						 , A.S_DATE                                                                                                    ".rtrim()
	+ "\n						 , A.E_DATE                                                                                                    ".rtrim()
	+ "\n						 , A.SALE_UPRC                                                                                                 ".rtrim()
	+ "\n					  FROM SCD_PRCDT_T  A                                                                                              ".rtrim()
	+ "\n						 , (                                                                                                           ".rtrim()
	+ "\n						    SELECT PROD_CD, MIN(S_DATE) S_DATE                                                                         ".rtrim()
	+ "\n			                  FROM SCD_PRCDT_T                                                                                         ".rtrim()
	+ "\n			                  WHERE SHOP_CD = ?                                                                                 ".rtrim()
	+ "\n			                    AND S_DATE  <= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
	+ "\n			                    AND E_DATE  >= strftime('%Y%m%d' , 'NOW' , 'localtime')                                    ".rtrim()
	+ "\n			                  GROUP BY PROD_CD                                                                                         ".rtrim()
	+ "\n			                ) BB                                                                                                       ".rtrim()
	+ "\n			         WHERE A.SHOP_CD = ?                                                                                        ".rtrim()
	+ "\n			           AND A.S_DATE  <= strftime('%Y%m%d' , 'NOW' , 'localtime')                                           ".rtrim()
	+ "\n			           AND A.E_DATE  >= strftime('%Y%m%d' , 'NOW' , 'localtime')                                           ".rtrim()
	+ "\n			           AND A.PROD_CD = BB.PROD_CD                                                                                      ".rtrim()
	+ "\n			           AND A.S_DATE  = BB.S_DATE                                                                                       ".rtrim()
	+ "\n				   ) C                                                                                                                 ".rtrim()
	+ "\n				  , (SELECT ? AS VAT_CD ) D /** VAT 포함 여부 코드 **/                                                              ".rtrim()
	+ "\n				   LEFT OUTER JOIN SCD_BARCD_T E ON M.SHOP_CD = E.SHOP_CD AND M.PROD_CD = E.PROD_CD                                    ".rtrim()
	+ "\n				  LEFT OUTER JOIN (SELECT                                                                                              ".rtrim()
	+ "\n					PROD_CD                                                                                                            ".rtrim()
	+ "\n					, GROUP_CONCAT(PRT_NO) PRT_NO                                                                                      ".rtrim()
	+ "\n					FROM SCD_PRTPR_T                                                                                                   ".rtrim()
	+ "\n					 WHERE SHOP_CD = ?                                                                                          ".rtrim()
	+ "\n					AND USE_YN  = 'Y'                                                                                                  ".rtrim()
	+ "\n					GROUP BY SHOP_CD , PROD_CD                                                                                         ".rtrim()
	+ "\n					) F                                                                                                                ".rtrim()
	+ "\n				   ON M.PROD_CD = F.PROD_CD                                                                                            ".rtrim()
	+ "\n			 WHERE M.SHOP_CD  = S.SHOP_CD                                                                                              ".rtrim()
	+ "\n			  AND M.PROD_CD  = S.PROD_CD                                                                                               ".rtrim()
	+ "\n			  AND M.PROD_CD = C.PROD_CD                                                                                                ".rtrim()
	+ "\n			  AND M.SHOP_CD = ?                                                                                                 ".rtrim()
	+ "\n			  AND M.USE_YN  = 'Y'                                                                                                      ".rtrim()
	+ "\n			  AND S.USE_YN  = 'Y'                                                                                                      ".rtrim();

		var vsVatCd = util.GetEnvXmlShopENV(128); // 부가세 여부 0:별도, 1:포함
		var resultData = gfn_SQLiteSQLProcess(sql, [gShopCd  , gShopCd , '1' , gShopCd, gShopCd ]);

		if ( resultData!= null && resultData.ResultCode == "0" ) {
			var rows = resultData.Data;
			if ( rows == undefined || rows == null ||  rows.length == 0 ) {
				return [];
			}

			for ( var i = 0 ; i < rows.length ; i++ ) {
				var row = rows[i];
				var saleUrpc = Number(row.SALE_UPRC);
				row['판매단가']		     = saleUrpc;//판매가격 숫자로 변환
				row['판매단가_출력용']	= util.numberWithCommas(row.SALE_UPRC);//판매가격 Text 로 보여질 값.

				row['합계금액']			= saleUrpc  ;//합계금액으로 계산하기 위하여.
				row['합계금액_출력용']	= row.SALE_UPRC_VIEW;//합계금액을 산출 후 보여줄 Text(사용은 됨)
			}
			//debugger;
			if ( _langCode == 'org') {
				rows.forEach(e=>{
					if( !util.isEmpty( e.PRT_NO ) )
						e.printNos = e.PRT_NO.split(",");
					else {
						e.printNos = [];
						e.PRT_NO ="";
					}
				});
				return rows;
			}

			return  util.setRowsLanguage( rows, _langCode, 'PROD_NM'  );//언어처리.
		}
		return [];
	}
}