var Telegram = function() {
	/********************************************
	 * 전문 호출(ajax 호출)
	 * @param param 호출시 요청전문(parameter type 은 string 만 허용)
	 * @param url   호출되는 전문의 URL(메인 URL 은 제외함, 개발 또는 운영을 구분하기 위함.)
	 * @param fnc_callback 전문 호출 처리가 성공했을때 응답받을 function
	 * @param isAsync 전문 호출 처리가 성공했을때 응답받을 function
	 * @param 비동기인 경우 호출콜백
	 * @param 타임아웃 시간
	 * @returns 응답결과
	 ********************************************/

	this.tlgmCall= function (param, url , isAsync , fnc_callback, timeout ) {
		util.logInfo("*****tlgmCall START*****");
		var xhr;
		
		if (param == null || param == undefined || param == "" ) {
			param = "";
		} else {
			param = $.trim(param);
		}
		if ( isAsync == undefined ) {			
			isAsync = false;
		}

		if(!timeout || timeout == "0"){
			timeout = 3000;
		}
		util.logInfo("*****tlgmCall timeout == > " + timeout);
		var result = null ;
//		console.log('+++++++++++++++++++++++++  Telegram ajax call start ('+ url +') ');
//		console.log('request ajax call url : ' + url + ' _____full url : ' + (aspUrl +  url) + ' _____ajax callback function is ' + fnc_callback );
//		console.log('ajax call param : \n' +  this.formatXml(param ) );
		
		util.logInfo('+++++++++++++++++++++++++  Telegram ajax call start ('+ url +') ');
		util.logInfo('request ajax call url : ' + url + ' _____full url : ' + (aspUrl +  url) );
		util.logInfo('ajax call param : \n' +  this.formatXml(param ) );
		
		var recvUrl = aspUrl;
		if ( typeof tizen != "undefined") {
			recvUrl = apiUrl;
		}
		util.logInfo('recvUrl : ' +  recvUrl );
		
		// 리얼서버를 받아서 테스트 할 때 ASP전송은 하지 않기 위한 FLAG. 오류 수정 후 확인시에 사용하기 위함이다.
		if(ASP_SEND_YN == "N"){
			return false;
		}
		try {
			xhr = $.ajax({
				  type : "POST"
				, url : recvUrl +  url
				, data : param
				, async : isAsync
				, dataType : "xml"
				, contentType : "text/xml"
				, timeout : timeout
				, success : function(msg) {
					util.logInfo('+++++++++++++++++++++++++ Telegram ajax call success ('+ url +') ');
					var x1 = telegram.xmlToString(msg);
					var xmlData = telegram.formatXml(  x1  );
					util.logInfo("***** xmlData : " + xmlData);
					util.logInfo("***** isAsync : " + isAsync);
					//Sync 방식일때는 직접 return;
					if( isAsync == false ) {
						util.logInfo("***** tlgmCall success callback sync ***** ");
						result = xmlData;
					} else if ( isAsync == true ) { //async 방식일때는 callback function 처리.
						util.logInfo("***** tlgmCall success callback async typeof fnc_callback == > " + typeof fnc_callback);
						if ( typeof fnc_callback === 'function') {
							util.logInfo("***** tlgmCall success async callback CALL ***** ");
							fnc_callback(xmlData, param);
						}
					}

				} , error : function(request, status, error) {
					if(isAsync == false ) {
						util.logInfo("***** tlgmCall error callback sync *****");
						//if(status == "timeout"){ // 위에 설정한 30초 타임아웃 발생시
							//var vsTimeoutMsg = util.languageObjReturn(langCode,  "timeoutMsg"); // 타임아웃이 발생했습니다. 서버상태를 확인해 주세요.
							//alert(vsTimeoutMsg);
						//}else{
						util.logError('+++++++++++++++++++++++++ Telegram ajax call error ('+ url +')' 
								+ "\n code:"    + request.status 
								+ "\n message:" + request.responseText 
								+ "\n error:"   + error
								+ "\n status : " + status);
						
						util.logError("error.toString() == > " + error.toString());
						if(status == "timeout"){ // 서버와의 통신이 안될 때
							result = "timeout";
							gErrorMsg = result;
						}else{ 
							if(error.toString().indexOf("NetworkError") != -1){ // 랜선이 빠져있거나 인터넷 연결이 안되어있을 때
								result = "NetworkError";
								gErrorMsg = result;
							}
						}
						
						util.logError("*****result == > " + result);
						//}
						// 서버 연동 실패 또는 네크워크 문제가 아닐 때 원래로직대로 throw error를 수행.
						if(status != "timeout" && error.toString().indexOf("NetworkError") == -1){
							throw error;
						}
						
					}else if( isAsync == true ) { //async 방식일때는 callback function 처리.
						if ( typeof fnc_callback === 'function') {
							util.logInfo("***** tlgmCall error async callback CALL ***** ");
							util.logError('+++++++++++++++++++++++++ Telegram ajax call error ('+ url +')' 
									+ "\n code:"    + request.status 
									+ "\n message:" + request.responseText
									+ "\n status:" + status 
									+ "\n error:"   + error);
							fnc_callback("error", status, param);
						}
					}
					
				}
			});
		} catch (e) {
			util.logError('+++++++++++++++++++++++++ Telegram ajax call critical catch('+ url +') ' + e  );
			throw e;
		}
		return result;
	}

	this.xmlToString = function(doc) {
		var oSerializer = new XMLSerializer();
		return oSerializer.serializeToString(doc);	
	}


	this.formatXml = function(xml)  {
	    var formatted = '';
	    var reg = /(>)(<)(\/*)/g;
	    xml = xml.replace(reg, '$1\r\n$2$3');
	    var pad = 0;
	    jQuery.each(xml.split('\r\n'), function(index, node) {
	        var indent = 0;
	        if (node.match( /.+<\/\w[^>]*>$/ )) {
	            indent = 0;
	        } else if (node.match( /^<\/\w/ )) {
	            if (pad != 0) {
	                pad -= 1;
	            }
	        } else if (node.match( /^<\w[^>]*[^\/]>.*$/ )) {
	            indent = 1;
	        } else {
	            indent = 0;
	        }

	        var padding = '';
	        for (var i = 0; i < pad; i++) {
	            padding += '  ';
	        }

	        formatted += padding + node + '\r\n';
	        pad += indent;
	    });

	    return formatted;
	}
	
}


/************************************************************************************/

function gfn_ajaxTlgmCall(param, url , isAsync , fnc_callback ) {
	console.warn(
			  " -------------------------------------------------------------------------------\n"
			+ "  gfn_ajaxTlgmCall -> telegram.tlgmCall  으로 변경 \n                            "
			+ " -------------------------------------------------------------------------------\n"
			); 
	
	if (param == null || param == undefined || param == "" ) {
		param = "";
	} else {
		param = $.trim(param);
	}
	if ( isAsync == undefined ) {
		isAsync = false;
	}

	var result = null ;
	util.logInfo('+++++++++++++++++++++++++  Telegram ajax call start ('+ url +') ');
	util.logInfo('request ajax call url : ' + url + ' ( full url : ' + (aspUrl +  url) + ' )' , ' -> ajax callback function is ' , fnc_callback );
	util.logInfo('ajax call param : \n' ,  formatXml(param ) );

	try {
		$.ajax({
			  type : "POST"
			, url : aspUrl +  url
			, data : param
			, async : false
			, dataType : "xml"
			, contentType : "text/xml"
			, success : function(msg) {

				util.logInfo('+++++++++++++++++++++++++ Telegram ajax call success ('+ url +') ');
				var xmlData = formatXml( xmlToString(msg ) );

				//Sync 방식일때는 직접 return;
				if( isAsync == false ) {

					result = xmlData;

				} else if ( isAsync == true ) { //async 방식일때는 callback function 처리.
					if ( typeof fnc_callback === 'function') {
						fnc_callback(xmlData, param);
					}
				}

			} , error : function(request, status, error) {

				console.error('+++++++++++++++++++++++++ Telegram ajax call error ('+ url +')' 
						+ "\n code:"    + request.status 
						+ "\n message:" + request.responseText 
						+ "\n error:"   + error);
				throw error;
			}
		});
	} catch (e) {
		util.logInfo('+++++++++++++++++++++++++ Telegram ajax call critical catch('+ url +') ' + e  );
		throw e;
	}

	return result;

}
