var DodoPointService = function() {	
	/********************************************
	 * 도도포인트 api 호출(ajax 호출)
	 * @param param 호출시 요청전문(parameter type 은 string 만 허용)
	 * @param targetUrl 호출되는 도도포인트 타겟 url ex)purchases, redeems
	 * @param fnc_callback 전문 호출 처리가 성공했을때 응답받을 function
	 * @param isAsync 전문 호출 처리가 성공했을때 응답받을 function
	 * @param phoneNum 도도포인트 적립 밎 사용하는 사용자의 전화번호
	 * @param callType 도도포인트 조회, 적립, 사용, 승인취소 마다 요청 type이 다르다 ex)PUT, POST, DELETE
	 * @returns 응답결과
	 ********************************************/
	//let xId = "cc98a5ed-390c-45b8-ae72-b915b79869fc";
	//let xSecret = "g5mkeJ4yonrZ3/6V+AbNFcr57UXka0FjofeR3IiQrCFDKzPGZKTMDdOwxgzkl1ByA23KY0V0noygs7++Oy8p5HpsT44ZnWJHxeH0IK/r+knQtDd9S5fP4q/B/JtbmWSY";
	
	//let dodoUuid = "1637d6c5-5bc9-11eb-83ac-0a58a9feac2a";
	//let dodoUrl = "https://point-api-v1.spoqa.com/";
	
	this.dodoGetPostAjaxCall = function(param, targetUrl, isAsync, callType, phoneNum, callbackFunc) {
		//도도포인트 calltype post&get
		if (param == null || param == undefined || param == "" ) {
			param = "";
		} 
		if ( isAsync == undefined ) {
			isAsync = false;
		}
		if (targetUrl == null || targetUrl == undefined || targetUrl == "" ) {
			targetUrl = "";
		} 
		
		var result = null;
		//console.log('request ajax call url : ' + url + ' ( full url : ' + (aspurl +  url) + ' )' , ' -> ajax callback function is ' , fnc_callback );
		//callType = "GET";
		
		if(targetUrl != null && targetUrl !=""){
			targetUrl = targetUrl + "/";
		}
		//var fullUrl = "https://point-api-v1.spoqa.com/1637d6c5-5bc9-11eb-83ac-0a58a9feac2a/customers/010-9170-4686/";
		var fullUrl = dodoUrl + dodoUuid + "/customers/" + phoneNum + "/" + targetUrl;
        //var headers = {"X-Credential-Id": xId, "X-Credential-Secret": xSecret, "Content-Type":"application/json"};
        var headers = {"X-Credential-Id": xId, "X-Credential-Secret": xSecret, "Content-Type":"application/json"};
        //var headers = {"Content-Type":"application/json", "Access-Control-Allow-Origin": "*", "Access-Control-Allow-Headers":"*", "Access-Control-Allow-Method":"PUT, GET, POST, DELETE, OPTIONS"};
        
        //util.logInfo('+++++++++++++++++++++++++ dodoGetPostAjaxCall ajax call fullUrl ('+ fullUrl +') ');
        util.logInfo('+++++++++++++++++++++++++ dodoGetPostAjaxCall ajax call callType ('+ callType +') ');
        
        try {
			$.ajax({
	            type : callType,
	            url : fullUrl,
	            data: JSON.stringify(param),
	            dataType : 'json',
	            headers : headers,
	            async: isAsync,
	            success: function(res) {
	            	util.logInfo('성공 ==' + JSON.stringify(res));
	            	//console.log('typeof' + typeof res);
	            	result = res;
	            	if ( typeof callbackFunc === 'function') {
	            		callbackFunc(result);
					}
	            },
	            error: function(xhr, status, error) {
	            	result = xhr.responseJSON;
	            	util.logInfo('실패 - ', xhr);
	            	util.logError("xhr1 == > " + JSON.stringify(xhr));
	            	util.logError("status.toString == > " + status.toString());
	            	util.logError("status == > " + status);
	            	util.logError("error == > " + error.toString());
	            	
	            	var errorObj = { e : error, status : status.toString() };
	            	if ( typeof callbackFunc === 'function') {
	            		callbackFunc(result);
					}
	            }
	        });
        } catch (e) {
        	util.logInfo('+++++++++++++++++++++++++ dodoGetPostAjaxCall ajax call critical catch('+ fullUrl +') ' + e  );
			throw e;
		}	
	
		return result;
	}, 
	
	this.dodoPutAjaxCall = function(param, fullUrl, isAsync, callType) {
		//도도포인트 calltype put
		if (param == null || param == undefined || param == "" ) {
			param = "";
		} 
		if ( isAsync == undefined ) {
			isAsync = false;
		}
		
		var result = null;
		
		var headers = {"X-Credential-Id": xId, "X-Credential-Secret": xSecret, "Content-Type":"application/json"};
        
		util.logInfo('+++++++++++++++++++++++++ dodoPutAjaxCall ajax call fullUrl ('+ fullUrl +') ');

		try {
			$.ajax({
	            type : callType,
	            url: fullUrl,
	            data: JSON.stringify(param),
	            dataType : 'json',
	            headers : headers,
	            async: isAsync,
	            success: function(res) {
	            	util.logInfo('성공 ==' + JSON.stringify(res));
	            	//console.log('typeof' + typeof res);
	            	result = res;
	            },
	            error: function(xhr) {
	            	result = xhr.responseJSON;
	            	util.logError('실패 - ', xhr);
	            }
	        });
			
		} catch (e) {
			util.logInfo('+++++++++++++++++++++++++ dodoPutAjaxCall ajax call critical catch('+ url +') ' + e  );
			throw e;
		}
	
		return result;
	}, 
	
	this.dodoDeleteAjaxCall = function(param, isAsync, callType, dodoId, dodoType) {
		//도도포인트 calltype delete
		//도도포인트 사용취소
		if (param == null || param == undefined || param == "" ) {
			param = "";
		} 
		
		if ( isAsync == undefined ) {
			isAsync = false;
		}
		
		var result = null;
		
		var fullUrl = dodoUrl + dodoUuid + "/" + dodoType + "/" + dodoId + "/";
		var headers = {"X-Credential-Id": xId, "X-Credential-Secret": xSecret, "Content-Type":"application/json"};
        
		util.logInfo('+++++++++++++++++++++++++ dodoDeleteAjaxCall ajax call fullUrl ('+ fullUrl +') ');

		try {
			$.ajax({
	            type : callType,
	            url: fullUrl,
	            data: JSON.stringify(param),
	            dataType : 'json',
	            headers : headers,
	            async: isAsync,
	            success: function(res) {
	            	util.logInfo('성공 ==' + JSON.stringify(res));
	            	//console.log('typeof' + typeof res);
	            	result = res;
	            },
	            error: function(xhr) {
	            	result = xhr.responseJSON;
	            	util.logError('실패 - ', xhr);
	            }
	        });
			
		} catch (e) {
			util.logInfo('+++++++++++++++++++++++++ dodoDeleteAjaxCall ajax call critical catch('+ url +') ' + e  );
			throw e;
		}
	
		return result;
	}
}

