/**
 * 
 */
var PrintUtil = function() {

	///////////////////////////////////////////////////////////////////////////////
	// BASE PRINTER COMMAND
	///////////////////////////////////////////////////////////////////////////////
	//var PRT_BASE_NORM		= "\x1B\x21\x1E"			;// 확대강조해제.

	this.BASE_PRINT = 
	{
		  PRT_NULL_CHAR	: '\x1E'					// \x1E 대체문자.
		, INIT			: "\x1B\x40"                // 프린터 초기화.
		, FEED			: "\x0A"					// 라인피드.
		, MTFEED		: "\x1B\x64"				// 다중라인피드
		, V2X			: "\x1B\x21\x10"			// 세로     2배확대.
		, H2X			: "\x1B\x21\x20"			// 가로     2배확대.
		, HV2X			: "\x1B\x21\x30"			// 가로세로 2배확대.
		, CUT      		: "\x1B\x69"				// 용지컷팅.
		, NORM			: "\x1B\x21\x1E"			// 확대강조해제.
		, EMP_ON		: "\x1B\x21\x08"			// 문자강조.
		, UDLINE		: "\x1B\x21\x80"			// 밑줄문자.
		, CDR_OPEN		: "\x1B\x70\x1E\x40\x50"	// 돈통열림.
		, LF_ALIGN		: "\x1B\x61\x1E"			// 좌측정렬. [ESC a] - Align position, [RS] - Beep the buzzer
		, CT_ALIGN		: "\x1B\x61\x01"			// 중앙정렬.
		, RT_ALIGN		: "\x1B\x61\x02"			// 우측정렬.
	    , CT_ALIGN_HV2X	: "\x1B\x61\x01\x1B\x21\x30" // 중알정렬 + 가로 2배 확대
		//, BELL		: "\x1B\x70\x1E\xF0\xFF"	// 주방벨소리. ( 외장벨 )
	    , BELL			: "\x1B\x70\x1E\x3F"    	// 주방벨소리. ( 외장벨 )	
		, LOGO			: "\x1C\x70\x01\x1E"		// 영수증로고출력.
		, REVERSE_ON	: "\x1D\x42\x31"			// 프린터 반전해제
		, REVERSE_OFF 	: "\x1D\x42\x30"			// 프린터 반전해제
		, PRINT_CHK   	: "\x10\x04\x01"			// 프린터체크.      
		, COVER_CHK   	: "\x10\x04\x02"			// 프린터커버체크.    	
		, TRANS_CHK   	: "\x10\x04\x03"			// 프린터전송체크.    
		, PAPER_CHK   	: "\x10\x04\x04"			// 용지체크.
		, BARCODE_S   	: "\x1D\x48\x30\x1D\x68\x64\x1D\x77\x02\x1D\x6B\x49" // 1D(GS) 48(H) 30(0) - Select print position of HRI characters (1D-Barcode)
			                                                               // 1D(GS) 68(h) 64(d) - Set bar code height (1D-Barcode)
			                                                               // 1D(GS) 77(w) 02(2) - Set lateral size of bar code (1D-Barcode)
			                                                               // 1D(GS) 6B(k) 49(I) - Printing of bar code (1D-Barcode)
		, BARCODE   	: "\x1D\x48\x30\x1D\x68\x64\x1D\x77\x02\x1D\x6B\x49"
		, BARCODE_B   	: "\x1D\x48\x30\x1D\x68\x80\x1D\x77\x02\x1D\x6B\x49"                                                 
		, BARCODE_E   	: "\x7B\x41"
		, BARCODE_ENG  	: "\x7B\x42" // 영문사용가능.
		, BMP_IMG     	: "\x1D\x76\x30\x33"		// 이미지 출력.
	};

	this.BASE_PRINT.EMP_OFF = this.BASE_PRINT.NORM;     // 문자강조해제.

	var DEF_BASE_CHK_NORMAL	= "\x12"					// 상태정상.
	var DEF_BASE_CHK_USING  = "\x1A"					// 사용중 상태값. 2009-1030-YBC

	///////////////////////////////////////////////////////////////////////////////
	// PRINTER 기종.
	///////////////////////////////////////////////////////////////////////////////
	this.PRT_SS_SRP350		=  1;
	this.PRT_SS_STP131		=  2;
	this.PRT_HS_P01			= 11;
	this.PRT_HS_P02			= 12;
	this.PRT_SW_WTP100		= 21;
	this.PRT_SW_WTP150		= 22;
	this.PRT_TO_TOSHIBA		= 31;
	this.PRT_KM_KM1000		= 41;
	this.PRT_ST_STAR		= 51;
	this.PRT_NC_NCR7167		= 61;
	this.PRT_SK_POVI		= 71;
	this.PRT_FDK_CAT		= 81;
	this.PRT_TM_T83			= 91;						// 2013-0729-Jane : 프린터 기종 추가

	///////////////////////////////////////////////////////////////////////////////
	// 삼성    계열 - STP131/SRP350
	///////////////////////////////////////////////////////////////////////////////
	var SS_PRINT =JSON.parse( JSON.stringify(this.BASE_PRINT) );
	SS_PRINT.STP_IN_BELL =  "\x1C\x62\x01\xF4\x01\xFA\x1E" ;  // STP-131 내장벨.
	SS_PRINT.CHK_NORMAL = DEF_BASE_CHK_NORMAL ;


	///////////////////////////////////////////////////////////////////////////////
	// 하나시스계열 - P01/P02
	///////////////////////////////////////////////////////////////////////////////
	var HS_PRINT = util.clone( this.BASE_PRINT );
	HS_PRINT.CHK_NORMAL = DEF_BASE_CHK_NORMAL;
	
	
	///////////////////////////////////////////////////////////////////////////////
	// 세우    계열 - WTP100/WTP150
	///////////////////////////////////////////////////////////////////////////////
	var SW_PRINT = util.clone( this.BASE_PRINT );
	SW_PRINT.WTP_BELL_ON  = "\x16\x01"	;// WTP-100 내장벨 ON.
	SW_PRINT.WTP_BELL_OFF = "\x16\x1E"	;// WTP-100 내장벨 OFF.
	SW_PRINT.CHK_NORMAL = DEF_BASE_CHK_NORMAL ;

	///////////////////////////////////////////////////////////////////////////////
	// 도시바  계열 - TOSHIBA
	///////////////////////////////////////////////////////////////////////////////
	var TO_PRINT        = util.clone( this.BASE_PRINT );
	TO_PRINT.CUT        = "\x0A\x0A\x1B\x69" ;
	TO_PRINT.COVER_CHK	= "" ;
	TO_PRINT.PAPER_CHK  = "" ;
	TO_PRINT.BMP_IMG	= "\x1F\x30\x1E\x1F" ;
	TO_PRINT.BMP_END	= "\x1F\x30\x1E\x1D\x2F\x03" ;
	TO_PRINT.CHK_NORMAL	= "" ;
	
	
	///////////////////////////////////////////////////////////////////////////////
	// KM-1000
	///////////////////////////////////////////////////////////////////////////////
	var KM_PRINT = util.clone(this.BASE_PRINT);
	KM_PRINT.CHK_NORMAL = DEF_BASE_CHK_NORMAL ;

	///////////////////////////////////////////////////////////////////////////////
	// STAR
	///////////////////////////////////////////////////////////////////////////////
	var ST_PRINT = util.clone(this.BASE_PRINT);
	ST_PRINT.V2X        = "\x1D\x21\x01";
	ST_PRINT.H2X        = "\x1D\x21\x10";
	ST_PRINT.HV2X       = "\x1B\x24\x30";	
	ST_PRINT.NORM       = "\x1D\x21\x1E";	
	ST_PRINT.COVER_CHK	= "";	
	ST_PRINT.PAPER_CHK	= "";	
	ST_PRINT.CHK_NORMAL = "";

	this.BASE_PRINT.REVERSE_ON  = "\x1D\x42\x31";  // 프린터 반전해제
	this.BASE_PRINT.REVERSE_OFF = "\x1D\x42\x30";  // 프린터 반전해제


	///////////////////////////////////////////////////////////////////////////////
	// NCR     계열 - NCR7167
	///////////////////////////////////////////////////////////////////////////////
	var NC_PRINT = 	util.clone(this.BASE_PRINT);
	NC_PRINT.V2X 			= "\x1D\x21\x10"  ;
	NC_PRINT.H2X			= "\x1D\x21\x09"  ;
	NC_PRINT.HV2X			= "\x1D\x21\x11"  ;
	NC_PRINT.NORM			= "\x1D\x21\x08"  ;
	NC_PRINT.EMP_ON			= "\x1B\x45\x01"  ;
	NC_PRINT.EMP_OFF		= "\x1B\x45\x1E"  ;
	NC_PRINT.UDLINE			= "\x1B\x2D\x01"  ;
	NC_PRINT.CDR_OPEN		= "\x1B\x70\x1E"  ;
	NC_PRINT.COVER_CHK		= ""              ;
	NC_PRINT.PAPER_CHK  	= ""              ;
	NC_PRINT.BELL			= ""              ;
	NC_PRINT.CHK_NORMAL		= ""              ;

	///////////////////////////////////////////////////////////////////////////////
	// SEIKO - POVI
	///////////////////////////////////////////////////////////////////////////////
	var SK_PRINT = {};
	SK_PRINT.INIT       = "\x1C\x43\x31\x1B\x20\x1E\x1B\x33\x1E\x1B\x30"	;
	SK_PRINT.FEED		= this.BASE_PRINT.FEED;
	SK_PRINT.V2X		= "\x1B\x57\x01";
	SK_PRINT.H2X		= "\x1B\x77\x01";
	SK_PRINT.HV2X		= "\x1B\x57\x01\x1B\x77\x01";
	SK_PRINT.CUT		= "\x1B\x46";
	SK_PRINT.NORM		= "\x1B\x57\x1E\x1B\x77\x1E";
	SK_PRINT.EMP_ON		= "\x1B\x45";
	SK_PRINT.EMP_OFF	= "\x1B\x46";
	SK_PRINT.UDLINE		= "\x1B\x2D\x01";
	SK_PRINT.CDR_OPEN	= "";
	SK_PRINT.LF_ALIGN	= "\x1B\x50\x1E";
	SK_PRINT.CT_ALIGN	= "\x1B\x50\x01";
	SK_PRINT.RT_ALIGN	= "\x1B\x50\x02";
	SK_PRINT.BARCODE	= "";
	SK_PRINT.BARCODE_E	= "";
	SK_PRINT.LOGO		= "";
	SK_PRINT.COVER_CHK	= "";
	SK_PRINT.PAPER_CHK  = "";
	SK_PRINT.BELL		= "";
	SK_PRINT.BMP_IMG	= "\x12~\x64\x1B=1\x12\x7A\x1E\x10\x08";
	SK_PRINT.BMP_MID	= "\x1B\x56\x01\x1E";
	SK_PRINT.BMP_END	= "\x12\x7A\x01\x1E";
	SK_PRINT.CHK_NORMAL	= "";



	///////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : SetPRTDeviceCMD	: PrinterInit
	//=============================================================================
	// PARAMETER  1 : pinPrinterType	: Printer Device Name
	//	          2 : pinBellType		: 0-프린터내장벨, 1-외장부착형벨(Default)
	// RETURN VALUE	: void				: .
	// PROGRAMMER	: YBC-2008-12-31	: New.			  
	///////////////////////////////////////////////////////////////////////////////
	this.SetPRTDeviceCMD = function(pinPrinterType , pinBellType){
		if ( util.isEmpty( pinBellType)) {
			pinBellType = 0;
		}
		var m_stPrtCMD = {};

		switch( pinPrinterType )
		{
			///////////////////////////////////////////////////////////////////////////////
			// 삼성    계열 - STP131/SRP350
			///////////////////////////////////////////////////////////////////////////////
			case this.PRT_SS_SRP350		:
			case this.PRT_SS_STP131		:
	
				m_stPrtCMD.INIT			= SS_PRINT.INIT       ;
				m_stPrtCMD.FEED			= SS_PRINT.FEED       ;
				m_stPrtCMD.V2X			= SS_PRINT.V2X        ;
				m_stPrtCMD.H2X			= SS_PRINT.H2X        ;
				m_stPrtCMD.HV2X			= SS_PRINT.HV2X       ;
				m_stPrtCMD.CUT			= SS_PRINT.CUT        ;
				m_stPrtCMD.NORM			= SS_PRINT.NORM       ;
				m_stPrtCMD.EMP_ON		= SS_PRINT.EMP_ON     ;
				m_stPrtCMD.EMP_OFF		= SS_PRINT.EMP_OFF    ;
				m_stPrtCMD.UDLINE		= SS_PRINT.UDLINE     ;
				m_stPrtCMD.CDR_OPEN		= SS_PRINT.CDR_OPEN   ;
				m_stPrtCMD.LF_ALIGN		= SS_PRINT.LF_ALIGN   ;
				m_stPrtCMD.CT_ALIGN		= SS_PRINT.CT_ALIGN   ;
				m_stPrtCMD.RT_ALIGN		= SS_PRINT.RT_ALIGN   ;
				m_stPrtCMD.BARCODE		= SS_PRINT.BARCODE    ;
				m_stPrtCMD.BARCODE_E	= SS_PRINT.BARCODE_E  ;
				m_stPrtCMD.LOGO			= SS_PRINT.LOGO	      ;
				m_stPrtCMD.COVER_CHK	= SS_PRINT.COVER_CHK  ;
				m_stPrtCMD.PAPER_CHK	= SS_PRINT.PAPER_CHK  ;
				m_stPrtCMD.CHK_NORMAL	= SS_PRINT.CHK_NORMAL ;
	
				if( pinPrinterType == this.PRT_SS_STP131 && pinBellType == 0 ) // STP131-내장벨
					 m_stPrtCMD.szPrtCmd_BELL   = SS_PRINT.BELL ;
				else
					m_stPrtCMD.szPrtCmd_BELL    = SS_PRINT.STP_IN_BELL ;
				break;

				///////////////////////////////////////////////////////////////////////////////
				// 하나시스계열 - P01/P02
				///////////////////////////////////////////////////////////////////////////////
			case this.PRT_HS_P01  :
			case this.PRT_HS_P02  :
	
				m_stPrtCMD.INIT			= HS_PRINT.INIT		 ;
				m_stPrtCMD.FEED			= HS_PRINT.FEED		 ;
				m_stPrtCMD.V2X			= HS_PRINT.V2X		 ;
				m_stPrtCMD.H2X			= HS_PRINT.H2X		 ;
				m_stPrtCMD.HV2X			= HS_PRINT.HV2X		 ;
				m_stPrtCMD.CUT			= HS_PRINT.CUT		 ;
				m_stPrtCMD.NORM			= HS_PRINT.NORM		 ;
				m_stPrtCMD.EMP_ON		= HS_PRINT.EMP_ON		 ;
				m_stPrtCMD.EMP_OFF		= HS_PRINT.EMP_OFF	 ;
				m_stPrtCMD.UDLINE		= HS_PRINT.UDLINE		 ;
				m_stPrtCMD.CDR_OPEN		= HS_PRINT.CDR_OPEN	 ;
				m_stPrtCMD.LF_ALIGN		= HS_PRINT.LF_ALIGN	 ;
				m_stPrtCMD.CT_ALIGN		= HS_PRINT.CT_ALIGN	 ;
				m_stPrtCMD.RT_ALIGN		= HS_PRINT.RT_ALIGN	 ;
				m_stPrtCMD.BARCODE		= HS_PRINT.BARCODE	 ;
				m_stPrtCMD.BARCODE_E	= HS_PRINT.BARCODE_E   ;
				m_stPrtCMD.LOGO			= HS_PRINT.LOGO		 ;
				m_stPrtCMD.COVER_CHK	= HS_PRINT.COVER_CHK	 ;
				m_stPrtCMD.PAPER_CHK	= HS_PRINT.PAPER_CHK	 ;
				m_stPrtCMD.CHK_NORMAL	= HS_PRINT.CHK_NORMAL	 ;
				m_stPrtCMD.BELL	  		= HS_PRINT.BELL		 ;
				break;
	
				///////////////////////////////////////////////////////////////////////////////
				// 세우    계열 - WTP100/WTP150
				///////////////////////////////////////////////////////////////////////////////
			case this.PRT_SW_WTP100		:
			case this.PRT_SW_WTP150		:
				m_stPrtCMD.INIT			= SW_PRINT.INIT		;
				m_stPrtCMD.FEED			= SW_PRINT.FEED		;
				m_stPrtCMD.V2X			= SW_PRINT.V2X		;
				m_stPrtCMD.H2X			= SW_PRINT.H2X		;
				m_stPrtCMD.HV2X			= SW_PRINT.HV2X		;
				m_stPrtCMD.CUT			= SW_PRINT.CUT		;
				m_stPrtCMD.NORM			= SW_PRINT.NORM		;
				m_stPrtCMD.EMP_ON		= SW_PRINT.EMP_ON	;
				m_stPrtCMD.EMP_OFF		= SW_PRINT.EMP_OFF	;
				m_stPrtCMD.UDLINE		= SW_PRINT.UDLINE	;
				m_stPrtCMD.CDR_OPEN		= SW_PRINT.CDR_OPEN	;
				m_stPrtCMD.LF_ALIGN		= SW_PRINT.LF_ALIGN	;
				m_stPrtCMD.CT_ALIGN		= SW_PRINT.CT_ALIGN	;
				m_stPrtCMD.RT_ALIGN		= SW_PRINT.RT_ALIGN	;
				m_stPrtCMD.BARCODE		= SW_PRINT.BARCODE	;
				m_stPrtCMD.BARCODE_E	= SW_PRINT.BARCODE_E;
				m_stPrtCMD.LOGO			= SW_PRINT.LOGO		;
				m_stPrtCMD.COVER_CHK	= SW_PRINT.COVER_CHK;
				m_stPrtCMD.PAPER_CHK	= SW_PRINT.PAPER_CHK;
				m_stPrtCMD.CHK_NORMAL	= SW_PRINT.CHK_NORMAL;
				m_stPrtCMD.BELL	  	 	 = SW_PRINT.BELL		;
	
				//WTP-100 내장벨을 사용하는 경우 우측 코멘드를 별도사용 : SW_PRT_WTP_BELL_ON / SW_PRT_WTP_BELL_OFF 
				break;
	
				///////////////////////////////////////////////////////////////////////////////
				// 도시바  계열 - TOSHIBA
				///////////////////////////////////////////////////////////////////////////////
			case this.PRT_TO_TOSHIBA		:
				m_stPrtCMD.INIT			= TO_PRINT.INIT		;
				m_stPrtCMD.FEED			= TO_PRINT.FEED		;
				m_stPrtCMD.V2X			= TO_PRINT.V2X		;
				m_stPrtCMD.H2X			= TO_PRINT.H2X		;
				m_stPrtCMD.HV2X			= TO_PRINT.HV2X		;
				m_stPrtCMD.CUT			= TO_PRINT.CUT		;
				m_stPrtCMD.NORM			= TO_PRINT.NORM		;
				m_stPrtCMD.EMP_ON		= TO_PRINT.EMP_ON	;
				m_stPrtCMD.EMP_OFF		= TO_PRINT.EMP_OFF	;
				m_stPrtCMD.UDLINE		= TO_PRINT.UDLINE	;
				m_stPrtCMD.CDR_OPEN		= TO_PRINT.CDR_OPEN	;
				m_stPrtCMD.LF_ALIGN		= TO_PRINT.LF_ALIGN	;
				m_stPrtCMD.CT_ALIGN		= TO_PRINT.CT_ALIGN	;
				m_stPrtCMD.RT_ALIGN		= TO_PRINT.RT_ALIGN	;
				m_stPrtCMD.BARCODE		= TO_PRINT.BARCODE	;
				m_stPrtCMD.BARCODE_E	= TO_PRINT.BARCODE_E ;
				m_stPrtCMD.LOGO			= TO_PRINT.LOGO	     ;
				m_stPrtCMD.COVER_CHK	= TO_PRINT.COVER_CHK ;
				m_stPrtCMD.PAPER_CHK	= TO_PRINT.PAPER_CHK ;
				m_stPrtCMD.CHK_NORMAL	= TO_PRINT.CHK_NORMAL ;
				m_stPrtCMD.BELL	    	= TO_PRINT.BELL		  ;
				break;
	
				///////////////////////////////////////////////////////////////////////////////
				// KM-1000
				///////////////////////////////////////////////////////////////////////////////
			case this.PRT_KM_KM1000		:
				m_stPrtCMD.INIT			= KM_PRINT.INIT		 ;
				m_stPrtCMD.FEED			= KM_PRINT.FEED		 ;
				m_stPrtCMD.V2X			= KM_PRINT.V2X		 ;
				m_stPrtCMD.H2X			= KM_PRINT.H2X		 ;
				m_stPrtCMD.HV2X			= KM_PRINT.HV2X		 ;
				m_stPrtCMD.CUT			= KM_PRINT.CUT		 ;
				m_stPrtCMD.NORM			= KM_PRINT.NORM		 ;
				m_stPrtCMD.EMP_ON		= KM_PRINT.EMP_ON	 ;
				m_stPrtCMD.EMP_OFF		= KM_PRINT.EMP_OFF	 ;
				m_stPrtCMD.UDLINE		= KM_PRINT.UDLINE	 ;
				m_stPrtCMD.CDR_OPEN		= KM_PRINT.CDR_OPEN	 ;
				m_stPrtCMD.LF_ALIGN		= KM_PRINT.LF_ALIGN	 ;
				m_stPrtCMD.CT_ALIGN		= KM_PRINT.CT_ALIGN	 ;
				m_stPrtCMD.RT_ALIGN		= KM_PRINT.RT_ALIGN	 ;
				m_stPrtCMD.BARCODE		= KM_PRINT.BARCODE	 ;
				m_stPrtCMD.BARCODE_E	= KM_PRINT.BARCODE_E ;
				m_stPrtCMD.LOGO			= KM_PRINT.LOGO		 ;
				m_stPrtCMD.COVER_CHK	= KM_PRINT.COVER_CHK  ;
				m_stPrtCMD.PAPER_CHK	= KM_PRINT.PAPER_CHK  ;
				m_stPrtCMD.CHK_NORMAL	= KM_PRINT.CHK_NORMAL ;
				m_stPrtCMD.BELL	 	   = KM_PRINT.BELL		  ;
				break;
	
				///////////////////////////////////////////////////////////////////////////////
				// STAR
				///////////////////////////////////////////////////////////////////////////////
			case this.PRT_ST_STAR		:
				 m_stPrtCMD.INIT		= ST_PRINT.INIT		 ;
				 m_stPrtCMD.FEED		= ST_PRINT.FEED		 ;
				 m_stPrtCMD.V2X			= ST_PRINT.V2X		 ;
				 m_stPrtCMD.H2X			= ST_PRINT.H2X		 ;
				 m_stPrtCMD.HV2X		= ST_PRINT.HV2X		 ;
				 m_stPrtCMD.CUT			= ST_PRINT.CUT		 ;
				 m_stPrtCMD.NORM		= ST_PRINT.NORM		 ;
				 m_stPrtCMD.EMP_ON		= ST_PRINT.EMP_ON	 ;
				 m_stPrtCMD.EMP_OFF		= ST_PRINT.EMP_OFF	 ;
				 m_stPrtCMD.UDLINE		= ST_PRINT.UDLINE	 ;
				 m_stPrtCMD.CDR_OPEN	= ST_PRINT.CDR_OPEN	 ;
				 m_stPrtCMD.LF_ALIGN	= ST_PRINT.LF_ALIGN	 ;
				 m_stPrtCMD.CT_ALIGN	= ST_PRINT.CT_ALIGN	 ;
				 m_stPrtCMD.RT_ALIGN	= ST_PRINT.RT_ALIGN	 ;
				 m_stPrtCMD.BARCODE		= ST_PRINT.BARCODE	 ;
				 m_stPrtCMD.BARCODE_E	= ST_PRINT.BARCODE_E  ;
				 m_stPrtCMD.LOGO		= ST_PRINT.LOGO		 ;
				 m_stPrtCMD.COVER_CHK	= ST_PRINT.COVER_CHK ;
				 m_stPrtCMD.PAPER_CHK	= ST_PRINT.PAPER_CHK ;
				 m_stPrtCMD.CHK_NORMAL	= ST_PRINT.CHK_NORMAL ;
				 m_stPrtCMD.BELL	    = ST_PRINT.BELL		 ;
				break;
	
				///////////////////////////////////////////////////////////////////////////////
				// NCR     계열 - NCR7167
				///////////////////////////////////////////////////////////////////////////////
			case this.PRT_NC_NCR7167		:
				m_stPrtCMD.INIT			= NC_PRINT.INIT		      ;
				m_stPrtCMD.FEED			= NC_PRINT.FEED		      ;
				m_stPrtCMD.V2X			= NC_PRINT.V2X		      ;
				m_stPrtCMD.H2X			= NC_PRINT.H2X		      ;
				m_stPrtCMD.HV2X			= NC_PRINT.HV2X		      ;
				m_stPrtCMD.CUT			= NC_PRINT.CUT		      ;
				m_stPrtCMD.NORM			= NC_PRINT.NORM		      ;
				m_stPrtCMD.EMP_ON		= NC_PRINT.EMP_ON		  ;
				m_stPrtCMD.EMP_OFF		= NC_PRINT.EMP_OFF	      ;
				m_stPrtCMD.UDLINE		= NC_PRINT.UDLINE		  ;
				m_stPrtCMD.CDR_OPEN		= NC_PRINT.CDR_OPEN	      ;
				m_stPrtCMD.LF_ALIGN		= NC_PRINT.LF_ALIGN	      ;
				m_stPrtCMD.CT_ALIGN		= NC_PRINT.CT_ALIGN	      ;
				m_stPrtCMD.RT_ALIGN		= NC_PRINT.RT_ALIGN	      ;
				m_stPrtCMD.BARCODE		= NC_PRINT.BARCODE	      ;
				m_stPrtCMD.BARCODE_E	= NC_PRINT.BARCODE_E      ;
				m_stPrtCMD.LOGO			= NC_PRINT.LOGO		      ;
				m_stPrtCMD.COVER_CHK    = NC_PRINT.COVER_CHK	  ;
				m_stPrtCMD.PAPER_CHK    = NC_PRINT.PAPER_CHK	  ;
				m_stPrtCMD.CHK_NORMAL	= NC_PRINT.CHK_NORMAL	  ;
				m_stPrtCMD.BELL		    = NC_PRINT.BELL		      ;
				break;
	
				///////////////////////////////////////////////////////////////////////////////
				// SEIKO - POVI
				///////////////////////////////////////////////////////////////////////////////
			case this.PRT_SK_POVI		:
				 m_stPrtCMD.INIT		= SK_PRINT.INIT		 ;
				 m_stPrtCMD.FEED		= SK_PRINT.FEED		 ;
				 m_stPrtCMD.V2X			= SK_PRINT.V2X		 ;
				 m_stPrtCMD.H2X			= SK_PRINT.H2X		 ;
				 m_stPrtCMD.HV2X		= SK_PRINT.HV2X		 ;
				 m_stPrtCMD.CUT			= SK_PRINT.CUT		 ;
				 m_stPrtCMD.NORM		= SK_PRINT.NORM		 ;
				 m_stPrtCMD.EMP_ON		= SK_PRINT.EMP_ON		 ;
				 m_stPrtCMD.EMP_OFF		= SK_PRINT.EMP_OFF	 ;
				 m_stPrtCMD.UDLINE		= SK_PRINT.UDLINE		 ;
				 m_stPrtCMD.CDR_OPEN	= SK_PRINT.CDR_OPEN	 ;
				 m_stPrtCMD.LF_ALIGN	= SK_PRINT.LF_ALIGN	 ;
				 m_stPrtCMD.CT_ALIGN	= SK_PRINT.CT_ALIGN	 ;
				 m_stPrtCMD.RT_ALIGN	= SK_PRINT.RT_ALIGN	 ;
				 m_stPrtCMD.BARCODE		= SK_PRINT.BARCODE	 ;
				 m_stPrtCMD.BARCODE_E	= SK_PRINT.BARCODE_E        ;
				 m_stPrtCMD.LOGO		= SK_PRINT.LOGO             ;
				 m_stPrtCMD.COVER_CHK   = SK_PRINT.COVER_CHK        ;
				 m_stPrtCMD.PAPER_CHK   = SK_PRINT.PAPER_CHK        ;
				 m_stPrtCMD.CHK_NORMAL	= SK_PRINT.CHK_NORMAL       ;
				 m_stPrtCMD.BELL	    = SK_PRINT.BELL             ;
				break;

			///////////////////////////////////////////////////////////////////////////////
			default					: break;
		}
		return m_stPrtCMD;
	}
	this.g_inPaperTypeFg = 0 ; 
	this.DllGetCutHangul = function ( s , len ) {
		if( this.isEmpty(s)) {
			return s;
		}
		return  s.cutStr(len);
	}

/////////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : DllGetMIDHangul   - 지정변수길이만큼 한글이 깨어지지 않게 자른다
	//=============================================================================
	// PARAMETER  1 : pcsOrgStr         : 원본 문자열.
//	           2   : pinCutLength      : Cutting BYTE.
	// RETURN VALUE   : CString         : No.
	// PROGRAMMER   : YBC-2009-04-08   : New.           
	///////////////////////////////////////////////////////////////////////////////
	this.DllGetMidHangul = function( pcsOrgStr, pinPosition , pinCutLength )
	{
		if( this.isEmpty(pcsOrgStr)) {
			return s;
		}
	    
		return ""+pcsOrgStr.substr(Number(pinPosition), Number(pinCutLength));
	}
	
	this.GetPRTDeviceCMD = function ( key ) {
		var csRetStr = SS_PRINT [ key ] ;
		if ( util.isEmptyStr( csRetStr ))  {
			throw "프린터 Hex Data 없음. KEY [" + key +"]"
		}
		return csRetStr;
	}
	
	
	this.parseFloat = function (val) {
		return parseFloat( util.setEmptyStrDefault(val , "0" ) ) ;
	}

	this.parseInt = function ( val ) {
		return parseInt( util.setEmptyStrDefault(val , "0" ) ) ;
	}

	///////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : Pading.
	//=============================================================================
	// PARAMETER  1 : pcsChar			: .
	// PARAMETER  2 : psnLength			: .
	// RETURN VALUE	: CString			: .
	// PROGRAMMER	: CWS-2009-02-18	: New.
	///////////////////////////////////////////////////////////////////////////////
	this.Pading = function ( pcsChar , psnLength) {
		var csResult = "" ;

		for( var i = 0; i < psnLength; i++ ) {
			csResult += pcsChar;
		}

		return csResult;
	}

	///////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : MaskString.
	//=============================================================================
	// PARAMETER  1 : pcsOrgStr			: .
	// PARAMETER  2 : pinMaxLength		: .
	// PARAMETER  3 : pcsFillChar		: .
	// PARAMETER  4 : bFillType			: .
	// RETURN VALUE	: CString			: .
	// PROGRAMMER	: CWS-2009-02-18	: New.
	///////////////////////////////////////////////////////////////////////////////
	this.MaskString = function ( pcsOrgStr, pinMaxLength, pcsFillChar, bFillType ) {
		var csResult = "";
		var csValue  ="";

		csValue = pcsOrgStr;
		csValue = csValue.replace( /\x1B\x21\x1E/gi, "" );			// 확대강조해제.
		csValue = csValue.replace( /\x1B\x21\x10/gi, "" );			// 세로     2배확대.
		csValue = csValue.replace( /\x1B\x21\x20/gi, "" );			// 가로     2배확대.
		csValue = csValue.replace( /\x1B\x21\x30/gi, "" );			// 가로세로 2배확대.

		var inFillLength = pinMaxLength - csValue.getByteLength() ;
//		console.log("MaskString pinMaxLength    :" + pinMaxLength   );
//		console.log("MaskString csValue         :" + csValue        );
//		console.log("MaskString csValue.length  :" + csValue.length );
//		console.log("MaskString csValue.getByteLength  :" + csValue.getByteLength() );
//		console.log("MaskString inFillLength    :" + inFillLength   );

		if(inFillLength < 0) {
			inFillLength = 0;
		}

		switch( bFillType ) {
			case 0:
				csResult = this.Pading( pcsFillChar, inFillLength ) + pcsOrgStr ;
				break;

			case 1:
				csResult = pcsOrgStr + this.Pading( pcsFillChar, inFillLength ) ;
				break;

			case 2:
				csResult = this.Pading( pcsFillChar, inFillLength / 2 ) + pcsOrgStr  ;
				break;
		}

		return csResult;
	}

	///////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : this.GetMarkString.
	//=============================================================================
	// PARAMETER  1 : pcsName			: .
	// PARAMETER  2 : pcsAmt			: .
	// PARAMETER  3 : pbName(byte)		: .
	// PARAMETER  4 : pbAmt (byte)		: .
	// RETURN VALUE	: CString			: .
	// PROGRAMMER	: CWS-2009-02-18	: New.
	///////////////////////////////////////////////////////////////////////////////
	this.GetMarkString = function(  pcsName,  pcsAmt,  pbName,  pbAmt ) {
		var csResult = "";
		var args = arguments;
		if ( args.length == 4) {
			csResult = "%s%s".sprintf(  this.RPad( pcsName, pbName ), this.LPad( util.numberWithCommas( pcsAmt ), pbAmt ) );
		} else if ( args.length == 6) {
			 var pcsName   = args[0];
			 var pcsCount  = args[1];
			 var pcsAmt    = args[2];
			 var pbName    = args[3];
			 var pbCount   = args[4];
			 var pbAmt     = args[5];

			csResult =  "%s%s%s".sprintf(
			             this.RPad( pcsName, pbName )
					   , this.LPad( pcsCount == "" ? "" : util.numberWithCommas( pcsCount ), pbCount )
					   , this.LPad( util.numberWithCommas( pcsAmt ), pbAmt ) );

		}
		return csResult;
	}

	this.GetMarkString_02 = function(pcsName, pcsAmt, /** byte ?? **/ pbName,/** byte ?? **/  pbAmt) {

		var csResult = "";

		csResult =  this.RPad( pcsName, pbName ) + this.LPad( util.numberWithCommas( pcsAmt ), pbAmt ) ;

		return csResult;
	}
	this.GetMarkString_03 = function( ) {
		var args = arguments;
		var csResult = "";
		if ( args.length == 4 ) {
			csResult ="%s%s".sprintf( this.RPad( args[0], args[2] ),this.LPad( args[1].trim(), args[3] ) )  ;
		} else if ( args.length == 2 ) {

			if( this.g_inPaperTypeFg == 0 ) {
				csResult = "%-16s  %14s".sprintf( args[0], args[1] );

			} else {
				csResult = "%-20s  %20s".sprintf( args[0], args[1] );

			}
		}

		return csResult;
	}

	this.GetMarkString_04 = function(/*** CString ***/ pcsName, /*** CString ***/ pcsQty, /***  CString ***/  pcsAmt) {
		var csResult = "" ;

		if ( util.isEmpty( pcsAmt )) {

			if( this.g_inPaperTypeFg == 0 ) {
				csResult = "%-16s  %14s".sprintf(  pcsName, util.numberWithCommas( pcsQty ) );

			} else {
				csResult = "%-20s  %20s".sprintf( pcsName, util.numberWithCommas( pcsQty ) );
			}

		} else {
			if( this.g_inPaperTypeFg == 0 ) {
				csResult = "%-16s%5s%11s".sprintf ( pcsName, pcsQty, pcsAmt  );
			}
			else {
				csResult = "%-20s%5s%17s".sprintf( pcsName, pcsQty, pcsAmt );
			}
		}

		return csResult;
	}



	this.LPad = function( pcsString, /** WORD **/ psnLength) {
		return this.MaskString( pcsString, psnLength, " ", 0 );
	}
	this.RPad = function( pcsString, psnLength) {
		return this.MaskString( pcsString, psnLength, " ", 1 );
	}

	this.CPad = function ( pcsString, psnLength) {
		return this.MaskString( pcsString, psnLength, " " , 2 );
	}

	this.AlignText= function (pcsString){
		var csResult = "";
		var snLen = 0;
		var snPos = 0;

		snPos = pcsString.indexOf( "{" , 4 );
		snLen = parseInt( pcsString.substr( 3, 2 ) );
		//console.log('snPos' , snPos , 'snLen' , snLen);
		csResult = pcsString.substr( 6, snPos - 6 );
		//console.log('AlignText csResult : ' + csResult);
		return csResult;
	}

	/*************************************************************
	 * -> 구분자값을 기준으로 value 를 가져오는 함수 입니다.
	 * val csTmp1
	 * csKeyVal = a-b-c
	 * csTmp1 = AfxExtractSubString( csTmp1, csKeyVal, 0, _T('-') );
	 * //csTmp1 안에 "a" 값 저장.
	 *************************************************************/
	this.AfxExtractSubString = function( msg , idx,  delim) {
		return msg.split(delim)[idx];
	}

	/*************************************************************
	 * 한글포함 유무를 확인해 준다.
	 *************************************************************/
	this.DllCheckExistHangul = function(s){
		var check = /[ㄱ-ㅎ|ㅏ-ㅣ|가-힣]/;
		if(check.test(s))
			return true;
		else
			return false;
	}

	///////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : DllTransAtoA_Format- 지정문자 포맷 변환 처리.
	//=============================================================================
	// PARAMETER  1 : pszOrgStr			: 원본 문자열.
	//			  2	: pszRetStr			: 생성 문자열.
	//	          3	: pszFormat			: 변경 포맷
	// RETURN VALUE	: Void				: No.
	// PROGRAMMER	: YBC-2008-04-30	: New.
	///////////////////////////////////////////////////////////////////////////////
	this.DllTransAtoA_Format = function( /** char */  pszOrgStr, /** char pszRetStr, */ /** char */ pszFormat ) {
		var szTmpBuff = "";

		var inType      = 0;
		var inDDBasePos = 0;


		if     (  pszFormat ==  "YYYY/MM/DD"			) inType = 1;
		else if(  pszFormat ==  "YYYY-MM-DD"			) inType = 2;
		else if(  pszFormat ==  "YY-MM-DD HH:MM:SS"		) inType = 3;
		else if(  pszFormat ==  "YYYY-MM-DD HH:MM:SS"	) inType = 4;
		else if(  pszFormat ==  "DD HH:MM:SS"			) inType = 5;
		else if(  pszFormat ==  "BIZ_NO"				) inType = 6;
		else if(  pszFormat ==  "HH:MM"					) inType = 7;	// 2009-1005-YBC
		else if(  pszFormat ==  "YYYY-MM-DD HH:MM"		) inType = 8;	// 2010-1005-YBC
		else if(  pszFormat ==  "YYYYMMDD"				) inType = 9;	// 2010-1228-YBC
		else if(  pszFormat ==  "YYYY/MM/DD HH:MM:SS"	) inType = 10; // 2014-0420 Antony.Choi : 포맷 추가
		else if(  pszFormat ==  "MM-DD HH:MM:SS"		) inType = 11; // 2014-1211 Antony.Choi : 포맷 추가
		else if(  pszFormat ==  "HH:MM:SS"				) inType = 12; // 2018-0109 HJH : 포맷 추가
		else if(  pszFormat ==  "MM/DD HH:MM"			) inType = 13; // 2018-0801 HJH : 포맷 추가
		else if(  pszFormat ==  "YY/MM/DD HH:MM:SS"		) inType = 14; // 2019-1118 HJH : 포맷 추가
		///////////////////////////////////////////////////////////////////////////////

		if ( typeof inType != 'number' ) {
			throw " typeof error ";
		}
		switch( inType )
		{
			case	1	:

				szTmpBuff = moment(pszOrgStr).format("YYYY/MM/DD"); //sprintf( pszRetStr, "%s/%s/%s", szTmpBuff[0], szTmpBuff[1], szTmpBuff[2]);
				break;

			case	2	:
				szTmpBuff = moment(pszOrgStr).format("YYYY-MM-DD"); //sprintf( pszRetStr, "%s-%s-%s", szTmpBuff[0], szTmpBuff[1], szTmpBuff[2]);
				break;

			case	3	:
				szTmpBuff = moment(pszOrgStr).format("YY-MM-DD HH:mm:ss");//"YY-MM-DD HH:MM:SS" sprintf( pszRetStr, "%s-%s-%s %s:%s:%s", szTmpBuff[0], szTmpBuff[1], szTmpBuff[2], szTmpBuff[3], szTmpBuff[4], szTmpBuff[5] );
				break;

			case	4	:
				szTmpBuff = szTmpBuff = moment(pszOrgStr, "YYYYMMDDHHmmss").format("YYYY-MM-DD HH:mm:ss"); //"YYYY-MM-DD HH:MM:SS" "%s-%s-%s %s:%s:%s"
				break;

			case	5	:
				if( pszOrgStr.length == 14 ) inDDBasePos = 6;
				if( pszOrgStr.length == 12 ) inDDBasePos = 4;
				szTmpBuff =  "%s일 %s:%s:%s".sprintf (
						  pszOrgStr.substr(  nDDBasePos      , 2 )
						, pszOrgStr.substr(  nDDBasePos + 2  , 2 )
						, pszOrgStr.substr(  nDDBasePos + 4  , 2 )
						, pszOrgStr.substr(  nDDBasePos + 6  , 2 )
						);  ///sprintf( pszRetStr, "%s일 %s:%s:%s", szTmpBuff[0], szTmpBuff[1], szTmpBuff[2], szTmpBuff[3] );

				break;

			case	6	:	// BIZ_NO

				szTmpBuff = "%s-%s-%s".sprintf( pszOrgStr.substr( 0 , 3 ) , pszOrgStr.substr( 3 , 2 ) , pszOrgStr.substr( 5 , 5 ) );
				break;

			case	7	:	// HH:MM		2009-1005-YBC
				if( pszOrgStr.length == 14 ) inDDBasePos = 8;
				if( pszOrgStr.length == 12 ) inDDBasePos = 6;

				szTmpBuff = "%s:%s".sprintf( pszOrgStr.substr(inDDBasePos , 2) , pszOrgStr.substr(inDDBasePos + 2 , 2)) ;
				break;

			// 2010-1005-YBC : YYYY-MM-DD HH:MM
			case	8	:
				////////////////////////////////////////////////////////////////////////
				// 2010-1221-JJM : 수정.
				////////////////////////////////////////////////////////////////////////
				szTmpBuff = szTmpBuff = moment(pszOrgStr).format("YYYY-MM-DD HH:mm:ss"); //sprintf( pszRetStr, "%s-%s-%s %s:%s" )
				break;

			////////////////////////////////////////////////////////////////////////
			// 2010-1228-JJM : .
			////////////////////////////////////////////////////////////////////////
			case	9	:	//YYYYMMDD
				szTmpBuff = szTmpBuff = moment(pszOrgStr).format("YYYYMMDD"); // sprintf( pszRetStr, "%s%s%s", szTmpBuff[ 0 ], szTmpBuff[ 1 ], szTmpBuff[ 2 ] );
				break;
	        ////////////////////////////////////////////////////////////////////////
			// 2014-420-Antony.Choi : 출력 포맷 추가
			////////////////////////////////////////////////////////////////////////
			case	10	:	//"YYYY/MM/DD HH:MM:SS"
				szTmpBuff = szTmpBuff = moment(pszOrgStr).format("YYYY/MM/DD HH:mm:ss");
				break;
			////////////////////////////////////////////////////////////////////////
			// 2015-1211-Antony.Choi : 출력 포맷 추가
			////////////////////////////////////////////////////////////////////////
			case	11	:	//"MM-DD HH:MM:SS"
				szTmpBuff = szTmpBuff = moment(pszOrgStr).format("MM-DD HH:mm:ss");
				break;

			////////////////////////////////////////////////////////////////////////
			// 2015-1211-Antony.Choi : 출력 포맷 추가
			////////////////////////////////////////////////////////////////////////
			case	12	: //"HH:MM:SS"
				if( strlen(pszOrgStr) == LEN_DEF_14 ) inDDBasePos = 8;

				szTmpBuff = "%s:%s:%s".sprintf( pszOrgStr.substr(inDDBasePos , 2) , pszOrgStr.substr(inDDBasePos + 2 , 2) ,pszOrgStr.substr(inDDBasePos + 4 , 2)) ;
				break;

			////////////////////////////////////////////////////////////////////////
			// 2018-0801-HJH : 출력 포맷 추가
			////////////////////////////////////////////////////////////////////////
			case	13	: "MM/DD HH:MM"
				if( strlen(pszOrgStr) == LEN_DEF_14 ) inDDBasePos = 4;

				szTmpBuff = "%s/%s %s:%s".sprintf(
							  pszOrgStr.substr(inDDBasePos , 2)
							, pszOrgStr.substr(inDDBasePos + 2 , 2)
							, pszOrgStr.substr(inDDBasePos + 4 , 2)
							, pszOrgStr.substr(inDDBasePos + 6 , 2)
							) ;
				break;

			case	14	:	"YY/MM/DD HH:MM:SS"														// 2019-1118-HJH :.

				 szTmpBuff = "%s/%s/%s %s:%s:%s".sprintf(
						   pszOrgStr.substr( 0  , 2 )
						 , pszOrgStr.substr( 2  , 2 )
						 , pszOrgStr.substr( 4  , 2 )
						 , pszOrgStr.substr( 6  , 2 )
						 , pszOrgStr.substr( 8  , 2 )
						 , pszOrgStr.substr( 10 , 2 )
				 );
				break;

			default	:
				break;
		}
		return szTmpBuff;
	}

	///////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : AddNewLineMark.	: 출력문자열에 앞에 NewLine 마크 체크.
	//=============================================================================
	// PARAMETER  1 : s		: .
	// RETURN VALUE	: CString			: .
	// PROGRAMMER	: 2010-1203-YBC		: New.			  
	///////////////////////////////////////////////////////////////////////////////
	this.AddNewLineMark = function( s ){
		if( util.isEmptyStr( s )) {
			return "";
		}
		if ( s.length <= 2) {
			return s;
		}

		var csLastStr	  =  s.substring( s.length-2 ) ;// s.Right( 2 ) ;
		var csNewLineMark = "\r\n" ;

		if( csLastStr != csNewLineMark ) {
			return csNewLineMark;
		}

		return "";
	}
	this.isEmpty = function(s) {
		if ( s == null || s == undefined )
			return true;
		if ( typeof s == "object" && Object.keys(s).length  == 0 )
			return true;
		if ( ( typeof s == "string" || typeof s == "array" ) && s.length == 0 )
			return true;

		return false;
	}
	
	this.Left = function( strVal, nIdx )
	{
		//left("abcd",2)
		return strVal.substr( 0, nIdx);
	}
	
	this.Right = function( strVal, nIdx )
	{
		//right("abcd",2)
		return strVal.substr( -nIdx );
	}
	
	this.Mid = function( strVal, nFPos, nEPos )
	{
		//mid("abcd",1,2)
		return strVal.substr( nFPos, nEPos );
	}
	
	this.Copy = function( strVal, nFPos, nEPos )
	{
		//copy("abcd",1,2)
		return strVal.substring( nFPos, nEPos );
	}

		
	/*
	this.DllTransLtoA = function( plnValue, pszRetStr, psnMaxLength = 0 , psnFillCharFg = 1  )
	{
		var szLongValue = "";
		var szLenFormat = "";

		if( psnMaxLength == 0 ) 
		{ 
			sprintf( pszRetStr, "%ld", plnValue ); 
			return ; 
		}

		
		memset ( szLongValue, NULL, sizeof( szLongValue ) );
		memset ( szLenFormat, NULL, sizeof( szLenFormat ) );

		strcat ( szLenFormat, "%" );

		if( psnFillCharFg == 1 )
			sprintf( szLenFormat, "%s%dld"    , szLenFormat, psnMaxLength );
		else
			sprintf( szLenFormat, "%s0%dld"   , szLenFormat, psnMaxLength );

		sprintf( pszRetStr  , szLenFormat, plnValue );
		
	}
*/
	///////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : DllTransLtoA		- Long -> Ascii Variable 변환.
	//=============================================================================
	// PARAMETER  1 : plnValue			: Long Value.
    //			  2	: psnMaxLength		: 문자열의 최대길이
    //			  3	: psnFillCharFg		: FillChar 구분 - 0:Zero, 1:Space(Default)
	// RETURN VALUE	: CString			: 
	// PROGRAMMER	: YBC-2008-04-30	: New.			  
	///////////////////////////////////////////////////////////////////////////////
	this.DllTransLtoA = function( plnValue )
	{
		var	szRetValue = "";
//debugger;
		//DllTransLtoA( plnValue, szRetValue, psnMaxLength, psnFillCharFg );
		szRetValue = "%d".sprintf( plnValue ); 

		//csRetStr = szRetValue;
		return szRetValue;
	}
	
}