'use strict';
/*******************************************************************************
 * 사용자 - 고객 주문서 03 - 신용카드-회수용 11 - 신용카드-보관용 12 - 신용카드-고객용 12 - 영수증 93 - 교환권 06
 * 
 * 관리자-영업관리 - 중간마감정산지 08 - 마감정산지 09 -> 영수증 관리에서 재출력 기능 11,12,93, 06
 * 
 * 관리자-매출현황 - 월별매출현황 35 - 분류별매출현황 31 - 상품별매출현황 32 - 기간별 정산현황 37
 * 
 * TODO printService 사용방법 -> 변환 참조 g_clsUtil.DllTransAddComma ->
 * util.numberWithCommas atoi -> parseInt _T() -> _T 만 주로 삭제.
 * m_inDeliveryVersionFg -> 배달에서만 사용하는 기능으로 본 프로젝트에서는 사용하지 않습니다.
 * g_blReceiptIssueFg -> 영수증 출력 여부 변수. saCmd -> row .asString() -> 삭제
 * g_csCornerSetFg = GetEnvXmlShopENV( 114 ); //복수 사업자 여부 this.g_inPaperTypeFg =
 * GetEnvXmlShopENV( 632 ); //영수증 용지 구분 42컬럼, 32컬럼 g_clsSale != NULL &&
 * !g_clsSale->m_blProdListPrintFg -> 영업관리에서 상품출력 버튼이 활성/비활성 상태를 인자값으로 받는다.
 * this.GetProdNmDbl : CSqlDataQuery::EtcResult stResult; -> this.GetEtcValue
 * g_clsUtil.DllTransAtoA_Format -> pu.DllTransAtoA_Format
 * g_clsUtil.DllGetCutHangul -> pu.DllGetCutHangul 로 변경
 * g_clsUtil.DllSetCrdCardNoMasking -> this.DllSetCrdCardNoMasking 로 변경
 * g_clsPrinter.GetPRTDeviceCMD -> pu.GetPRTDeviceCMD 로 변경. g_inShopStatFg ->
 * 삭제( 데모매장은 필요없음) g_clsBack->GetEnvXmlShopENV -> this.GetEnvXmlShopENV
 * g_clsUtil.DllCheckExistHangul -> g_clsUtil.DllCheckExistHangul _ttoi ->
 * parseInt 2. g_csOgnCd 변수 값 -> SCD_SHOPM_T 테이블의 HD_SHOP_CD 필드이며, 값이 "0000"
 * 일경우에는 자신의 매장코드를 넣습니다. // OGN_CD 세팅처리. if( csAttrNm == _T("HD_SHOP_CD") ) {
 * if( csAttrVal == _T("0000") ) { g_csOgnCd = g_csShopCd; } else { g_csOgnCd =
 * csAttrVal; } }
 * 
 * blRePrint -> RE_PRINT csCashList -> CASH_LIST csTotDcAmt -> TOT_DC_AMT
 * blNoCVM_FLAG -> NO_CVM_FLAG blDDC_FLAG -> DDC_FLAG csVat -> VAT csTotalAmt ->
 * TOTAL_AMT csSvcTipAmt -> SVC_TIP_AMT g_lnCvmAmt -> this.LN_CVM_AMT : 무서명
 * 거래금액. .csExpPayAmt -> .EXP_PAY_AMT 집중점검 : pu.DllGetCutHangul
 * stSale.blNoneSaleFg = false; 삭제.
 * blReturnSaleFg (반품여부)->  
 * g_OrderInfo 관련구문 삭제.
 ******************************************************************************/
// 2021. 10. 28 xbwing - for test flag( false )
let m_gbIs688 = true;

var PrintService = function() {
	
	var LEN_DEF_2 		= 2;
	var LEN_DEF_5		= 5;
	var LEN_DEF_8		= 8;
	var LEN_DEF_16		= 16;
	var LEN_DEF_21		= 21;
	var LEN_DEF_30		= 30;
	var LEN_DEF_36		= 36;
	
	let printPort , printSpeed ;//프린터 포트와 프린터 speed 설정.

	let DEF_MAX_KITCHEN_PRT_CNT = 30;	// 2009-0917-YBC : 주방프린터 최대갯수.
	this._SHOP_ENV_INFO			= {};
	this._GET_ENV_XML_SHOP_ENV	= {};
	this.LN_CVM_AMT				= "50000";// 무서명 거래금액.
	let _ENV_XML_POS_ENV       	= {};
	let m_stPrtInfo             = {};	// 프린터 정보 설정.(일반프린터 및 주방프린터)
	
	let m_stPrtSubInfo			= {};	// 주방에 프린터하기 위한 정보를 추가적으로 저장한다. Make by xbwing.
	
	let m_inSpectialPrintFg     = 0 ;	// 2010-0504-YBC : 주방주문서-특이옵션 0:미사용									// 1:메뉴별컷팅 2:메뉴수량별컷팅
	let m_csOrderDtlNo 			= ""; 
	let m_csOrderDtlProdCd 		= "";
	let m_csUnitSeqNo			= "";
		
	let pu 						= new PrintUtil();	//Print Util 관련 변수.
	let _sql 					= new PrintSQL();	//Print SQL 관련 변수.
	let g_clsPrinter 			= {};	//주방프린터 관련 변수

	let m_inBillPrtPortNo  		=  "" ; // 영수프린터-포트번호
	let m_inBillPrtSpeedCd 		=  "" ; // 영수프린터-속도

	this.setPrintEnv = function() {
		return;//TODO 2020.10.10 보류중...
		try {
			printPort  = this.GetEnvXmlPosENV ( 215 );//프린터 포트

			printSpeed = parseInt (this.GetEnvXmlPosENV ( 216 ) );//프린터 스피드

		} catch (e) {
			let msg = "프린터 환경설정[Port , Speed]에 실패하였습니다."
			util.logError(msg + "\n" + e.toString());
			throw msg;
		}
	}

	this.GetEnvXmlShopENV = function( cdVal ) {
		let val = this._GET_ENV_XML_SHOP_ENV[cdVal];

		if ( pu.isEmpty(val)) {
			val = util.GetEnvXmlShopENV(cdVal);
			if ( pu.isEmpty( val)) {
				return "";
			}

			this._GET_ENV_XML_SHOP_ENV[cdVal] = val;
		}
		return val;
	}
	this.GetEnvXmlCornerENV = function( cornerCd , colName ) {
		let env114 = this.GetEnvXmlShopENV( 114 );
		let sql = _sql.GetEnvXmlCornerENVSQL(env114);

		let db_result = gfn_SQLiteSQLProcess( sql , [cornerCd]);

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data)  || db_result.Data.length == 0 ) {
			throw "[Print]POS Env 정보가져오기에 실패하였습니다.[%s]".sprintf(cornerCd) ;
		}

		let row = db_result.Data[0];
		return row[colName];
	}

	this.GetEnvXmlShopINFO = function ( cdKey ) {
		let val = this._SHOP_ENV_INFO[cdKey];

		if ( pu.isEmpty( val )) {
			val = util.GetEnvXmlShopINFO(cdKey);
			if ( pu.isEmpty(val)) {
				return "";
			}
		} else  {
			return val;
		}

		this._SHOP_ENV_INFO[cdKey] = val;
		return val;
	}

	this.GetEnvXmlPosENV = function ( cdKey ) {
		let val = _ENV_XML_POS_ENV[cdKey];

		if ( pu.isEmpty( val )) {
			val = util.GetEnvXmlPosENV(cdKey);
			if ( pu.isEmpty(val)) {
				return "";
			}
		} else {
			return val;
		}

		_ENV_XML_POS_ENV[cdKey] = val;
		return val;
	}

	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : SetKitchenPrinterInfo.
	// =============================================================================
	// 주방프린터마스터에 등록되어져 있는 프린터들 정보를 구해서 보관한다.
	// =============================================================================
	// PARAMETER 1 : . : .
	// RETURN VALUE : BOOL : .
	// PROGRAMMER : 2009-0917-YBC : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.SetKitchenPrinterInfo = function() {
		util.logInfo("*** SetKitchenPrinterInfo START ***");
		let csQrySql = "" ; 
		let inBillPrtUseFg  = /** atoi * */ pu.parseInt ( this.GetEnvXmlPosENV( 206 ) );	// 영수프린터-종류  0:미사용
		let inBillPrtPortNo = /** atoi * */ pu.parseInt ( this.GetEnvXmlPosENV( 207 ) );

		let inPrtNo       = 0;
		let inPrinterType = 0;

		let m_inPrtCount = 0 ; // 사용중인 프린터 대수.

		// //////////////////////////////////////////////////////////////////////////
		// 주방주문서-특이옵션 0:미사용 1:메뉴별컷팅 2:메뉴수량별컷팅
		// //////////////////////////////////////////////////////////////////////////
		this.m_inSpectialPrintFg = /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 534 ) );
		
		
		// //////////////////////////////////////////////////////////////////////////
		// 주방프린터 환경설정 값에 대한 초기화.
		// //////////////////////////////////////////////////////////////////////////
		for( let i = 0; i < DEF_MAX_KITCHEN_PRT_CNT; i++ ) {
			m_stPrtInfo[ i ] = {};
			m_stPrtInfo[ i ].PRT_NO         = "";			
			m_stPrtInfo[ i ].PRT_NM         = ""; // 2009-1021-YBC
			m_stPrtInfo[ i ].POS_NO         = ""; // 2009-1030-YBC
			m_stPrtInfo[ i ].csPrtTypeFg    = "";
			m_stPrtInfo[ i ].csPrtPortNo    = "";
			m_stPrtInfo[ i ].csPrtSpeed     = "";
			m_stPrtInfo[ i ].csPrtBellFg    = "0";
			m_stPrtInfo[ i ].blPrintStat    = false ;
			m_stPrtInfo[ i ].inPrtPaperCnt	= 1;    // 2009-1209-YBC

			// /////////////////////////////////////////////////////////////////////////
			// 우선 모든 포트를 Pre OPEN 하게끔 구분자 세팅.
			// 실제 PORT OPEN 하는 쪽에서 해당 POS의 BILL 프린터 포트와 동시 사용시에는
			// 구분자를 변경하도록 구성되어진다.
			// /////////////////////////////////////////////////////////////////////////

			// /////////////////////////////////////////////////////////////////////////
			// 2011-0208-YBC :DEF_PORT_OPEN_PRE 1 // PRE PORT OPEN : 미리 포트 OPEN
			// 후 종료시 CLOSE.
			// /////////////////////////////////////////////////////////////////////////
			m_stPrtInfo[ i ].csPrePortOpenFg =  "1" ;	
		}

		try {

			let sql = _sql.SetKitchenPrinterInfo_SQL(  );
			let rows = this.db_get_mumti_rows( sql,[] );
			
			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];


				
				inPrtNo	      = pu.parseInt ( row[ "PRT_NO"      ] );
				inPrinterType = pu.parseInt ( row[ "PRT_TYPE_FG" ] );

				m_stPrtInfo[ inPrtNo ].PRT_NO		 = row[ "PRT_NO"        ];
				m_stPrtInfo[ inPrtNo ].PRT_NM		 = row[ "PRT_NM"        ];	// 2009-1021-YBC
				m_stPrtInfo[ inPrtNo ].csPrtTypeFg	 = row[ "PRT_TYPE_FG"   ];
				m_stPrtInfo[ inPrtNo ].csPrtPortNo	 = row[ "PRT_PORT"      ];
				m_stPrtInfo[ inPrtNo ].csPrtSpeed	 = row[ "PRT_SPEED"     ];
				m_stPrtInfo[ inPrtNo ].POS_NO		 = row[ "POS_NO"        ];	// 2009-1030-YBC
				m_stPrtInfo[ inPrtNo ].inPrtPaperCnt = pu.parseInt(row[ "PRT_PAPER_QTY" ]) ;		// 2009-1209-YBC

				
				// /////////////////////////////////////////////////////////////////////////////
				// 2011-0208-YBC
				// /////////////////////////////////////////////////////////////////////////////
				if( gPosNo == m_stPrtInfo[ inPrtNo ].POS_NO ) {	// 해당 포스.
					if( inBillPrtUseFg > 0 ) { // 영수프린터를 사용중.
						if( inBillPrtPortNo == /** atoi * */ pu.parseInt ( m_stPrtInfo[ inPrtNo ].csPrtPortNo ) ) {	// 영수프린터
																													// 포트와
																													// 주방프린터
																													// 포트가
																													// 같으면
							// //////////////////////////////////////////////////////////
							// 2011-0208-YBC : DEF_PORT_OPEN_DYNAMIC 0 //
							// DYNAMIC PORT OPEN : 출력시 마다 OPEN/CLOSE.
							// //////////////////////////////////////////////////////////
							m_stPrtInfo[ inPrtNo ].csPrePortOpenFg = "0";
						}
					}

					let csLog  = "SetKitchenPrinterInfo : KitchenPrtNo[%d] PortNo[%s] PreOpenFg[%s]".sprintf( inPrtNo, m_stPrtInfo[ inPrtNo ].csPrtPortNo, m_stPrtInfo[ inPrtNo ].csPrePortOpenFg );

					
				}

				
				
				m_inPrtCount++;

				let inPrtTypeFg = 0;	// 2011-0208-YBC

				switch( inPrinterType )	{
					case 1 :	// Sam4s-계열( ELLIX ).
						inPrtTypeFg = pu.PRT_HS_P01;
						break;

					case 2 :	// Bixolon-계열( SRP-STP ).
						inPrtTypeFg = pu.PRT_SS_SRP350;
						break;

					case 3 :	// 하나시스-계열( P01/02 ).
						inPrtTypeFg = pu.PRT_HS_P01;
						break;

					case 4 :	// 세우-계열( WTP ).
						inPrtTypeFg = pu.PRT_SW_WTP100;
						break;

// case 5 : // 엡손-계열( T88 ).
// inPrtTypeFg = PRT_ES_T88;
// break;

					case 6 :	// IBM-계열.
						inPrtTypeFg = pu.PRT_HS_P01;
						break;

					case 7 :	// 도시바-계열.
						inPrtTypeFg = pu.PRT_TO_TOSHIBA;
						break;

					case 8 :	// NCR-계열.
						inPrtTypeFg = pu.PRT_NC_NCR7167;
						break;

					case 9 :	// KM-1000-POVI.
						inPrtTypeFg = pu.PRT_SK_POVI;
						break;

					default	:	// 기타장비.
						inPrtTypeFg = pu.PRT_SS_SRP350;
						break;
				}

				// //////////////////////////////////////////////////////////////////////
				// 2011-0208-YBC
				// //////////////////////////////////////////////////////////////////////
				g_clsPrinter[ inPrtNo ] = pu.SetPRTDeviceCMD( inPrtTypeFg );
			}
			
			if( m_inPrtCount < 1 ) {
				return false;
			} else {
				return true;
			}
		} catch (e) {
			util.logError("SetKitchenPrinterInfo e==>>" + e);
			return false;
		}

	}


	this.init = function(printCode , obj ) {
		util.logInfo("*****ptinter.js this.init START*****");
		this.g_inPaperTypeFg           = pu.parseInt( this.GetEnvXmlShopENV( 632 ) ) ;// 영수증
																						// 용지구분.
		this.m_blZeroUprcProdNoPrintFg = pu.parseInt( this.GetEnvXmlShopENV( 554 ) ); // 2010-1119-YBC
																						// :
																						// 고객주문서
																						// 0원메뉴
																						// 출력여부
																						// 0:출력
																						// 1:미출력
		this.g_inTaxYnENV              = pu.parseInt( this.GetEnvXmlShopENV( 128 ) )
		this.GetEnvXmlShopENV( 114 ) ;
		util.logInfo("*****ptinter.js this.init SetKitchenPrinterInfo() before*****");
		this.SetKitchenPrinterInfo();
		util.logInfo("*****ptinter.js this.init SetKitchenPrinterInfo() after*****");
		pu.g_inPaperTypeFg = this.g_inPaperTypeFg ;

		this.m_stDlvOrderData		= {};
		this.CRLF 					= "\r\n";
		this.m_csPrintCode			= "";
		this.m_blSignPadUseFg		= false;
		this.m_csResult				= "";
		this.m_csView				= false;
		this.m_SaleClose			= false;
		this.blReceiptIssueFg		= true;// TODO 차후 변수로 받아야 함.

		this.m_stSaleInfo			= {};

		this.m_lnOrderTotAmt = 0; // 2009-1202-YBC
		this.m_lnOrderVatAmt = 0; // 2010-0601-YBC

		if ( printCode == '93' && obj.actionType == 'string') {
		} else {
			this.setPrintEnv();//프린터 속도, 포트 설정.
		}
		this.printCode = printCode;
		m_inBillPrtPortNo  = pu.parseInt( this.GetEnvXmlPosENV( 207 ) );      // 영수프린터-포트번호
		m_inBillPrtSpeedCd = this.SetDeviceSpeedRate( pu.parseInt( this.GetEnvXmlPosENV( 208 ) ) );      // 영수프린터-속도		
		util.logInfo("*****ptinter.js this.init END*****");
	}

	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : GetDataBase.
	// =============================================================================
	// PARAMETER 1 : No : .
	// RETURN VALUE : bool : .
	// PROGRAMMER : CWS-2009-02-18 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.GetDataBase = function()  {
		let blResult = false;

		this.m_lnOrderTotAmt = 0;
		this.m_lnOrderVatAmt = 0;

		let tmpPrintCode = parseInt( this.m_csPrintCode ) ;
		switch( parseInt( tmpPrintCode)  )  {
			case 1 :	// 영수증
			case 93 :	// 키오스크 영수증
				blResult = this.GetSalesData();
				break;

			case 2 : // 비매출 용영수증
				blResult = true;
				break;

			case 3:	// 고객주문서
// if( m_inDeliveryVersionFg ) {
// GetDeliveryInfo( false );
// }
				this.GetSalesData( 1 );			// 2019-08-21-SHK [합계금액]
				blResult = true;
				break;

			case 4 :	// 주방주문서
				blResult = true;
				break;

			case 5	:	// 중간계산서
			case 16	:	// 포장교환권.
// if( m_inDeliveryVersionFg ) {
// GetDeliveryInfo( false );
// }
				blResult = this.GetSalesData( 1 );
				break;

			case 6 :	// 푸드교환권
				blResult = true;
				break;

			case 7 :	// 테이블이동
				break;

			case 8 :	// 중간정산서				
				this.m_SaleClose = false;
				this.GetRegiEmpData();
				blResult = this.GetRegiTotalData();// 소스가 많이 길다.. 2020.08.13
				break;

			case 9 :	// 마감정산서

				this.m_SaleClose = true;
				this.GetRegiOpenDtData();
				this.GetRegiEmpData();
				blResult = this.GetRegiTotalData();
				break;

			case 10 : // 간이영수증.
				blResult = true;
				break;

			case 11 : // 신용카드 전표 - 회수용
			case 12 : // 신용카드 전표 - 보관용
				if( this.m_stSaleInfo.APPR_LOG_NO != ""  ) {
					this.m_csResult = this.GetNoneSalesCardCollectData();
					if( this.m_csResult == ""  ) {						
						blResult = false;
					}
					else {
						blResult = true;
					}
				}
				else {
					this.m_csResult = this.GetSalesCardCollectData();
					if(this.m_csResult == "" ) {						
						blResult = false;
					}
					else {
						blResult = true;
					}
				}
				break;

			case 13 :	// 2009-1202-YBC : 시재점검
				blResult = true;
				break;

			case 14 :	// 2010-0312-YBC : 배달영수증-고객용
			case 15 :	// 2010-0312-YBC : 배달전표-배달원용
// if( m_inDeliveryVersionFg ) {
// GetDeliveryInfo( false ); // 2010-0310-YBC
// }
				blResult = this.GetSalesData( 1 );
				break;

			case 47 :	// 2019-0430-HJH : 기타 전표
			case 48 :	// 2020-0123-HJH : 기타 전표 (회수용)
				this.m_csResult = GetSalesEtcCollectData();
					if( this.m_csResult == "" ) {						
						blResult = false;
					}
					else {
						blResult = true;
					}
				break;
			default :
				blResult = true;
				break;
		}

		return blResult;
	}

	/***************************************************************************
	 * 
	 * var stSale = {}; stSale.SHOP_CD = gShopCd; stSale.SALE_DATE = "20200803";
	 * stSale.POS_NO = gPosNo; stSale.BILL_NO = "123"; stSale.EMP_NM = "실비아제인";
	 * stSale.ORDER_NO = ""; stSale.RE_PRINT = false;
	 * 
	 * printService.GetPrintData(stSale , "13" , false);
	 */
	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : GetPrintData.
	// =============================================================================
	// PARAMETER 1 : pSaleInfo(SaleInfo) : .
	// PARAMETER 2 : pcsPrintCode : .
	// PARAMETER 3 : pblView : .
	// RETURN VALUE : CString : .
	// PROGRAMMER : CWS-2009-02-18 : New.
	// /////////////////////////////////////////////////////////////////////////////
	// TODO pcsPrintCode 코드는 뭘로 오는가?
	this.GetPrintData = function( pSaleInfo,  pcsPrintCode, pblView /* = true */) {
//debugger;		
		util.logInfo("*** GetPrintData START ***");
		let blCorner = false;	// 2009-1228-YBC

		let szResult = "";
		let csTemp	 = "";
		// 2015-0526 Antony.Choi : [POS보안] 프린터 출력 메모리 Clear 부분 추가
		this.m_csResult		 = "";
		this.m_blSignPadUseFg = false;
		this.m_stSaleInfo	 = pSaleInfo;
		this.m_csPrintCode	 = pcsPrintCode;
		this.m_csView		 = pblView;

		csTemp = this.GetPrintSource( this.m_csPrintCode ) ;// Print Form 데이터 조회		
		if ( pu.isEmpty( csTemp ) ) {
			util.logError("[" + pcsPrintCode  + "] printForm data emtpy!!");
			return;
		}
		// //////////////////////////////////////////////////////////////////////////
		// 일반영수증 이면서 코너별 승인처리인 경우
		// //////////////////////////////////////////////////////////////////////////
		if( this.m_csPrintCode == "01"  &&  blCorner == true ) {
			csTemp = csTemp.replace( "{현금영수증}" , "{현금영수증}\r\n{코너별단순현금}" );
		}
		

		if( this.GetDataBase() == true ) {
			if(  pSaleInfo.RE_PRINT == true   &&  ( this.m_csPrintCode == "11"  || this.m_csPrintCode == "12"  || this.m_csPrintCode == "21" || this.m_csPrintCode == "47"  || this.m_csPrintCode == "48"  ) )  {
				// 2020-0123-HJH : 기타전표 회수용추가
				szResult = this.GetApprSlipRePrint( csTemp ) ;
			} else if ( this.m_csPrintCode == "04") {// 주방프린터.
				// 주방주문서-특이옵션 0:미사용 1:메뉴별컷팅 2:메뉴수량별컷팅

				m_inSpectialPrintFg = /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 534 ) );

				// 2010-0504-YBC : this.m_csPrintCode 주방주문서의 경우에만 특이옵션 처리. (
				// 테이블이동은 제외 )
				// 2016-1115 Antony.Choi : 프리오더의 경우 사이드메뉴, 속성을 엮을 수 없는 구조이기 때문에
				// 제외함
				if( m_inSpectialPrintFg > 0  && pSaleInfo.blPreOrderFg != true ) {
					
					/* 
					 * 2021. 05. 26 xbwing
					 * 주방 프린터 출력하기 위한 함수 호출.
					 */
					this.SetMakeSpecialPrintData( csTemp );
					return "";
					
				} else {
	
					// 일반주방주문서 출력형태.
					m_csOrderDtlNo = "%";
					szResult = this.PrintCodeMatch( csTemp );
				}

				if( pblView ) 
					szResult = szResult.replace( "\n", "\r\n"  );
				return szResult;

			} else {
				szResult =  this.PrintCodeMatch( csTemp, pSaleInfo.RE_PRINT ) ;
			}

		} else {			
			return "" ;
		}
		 csTemp = "";
		if( pblView ) {
			szResult = szResult.replace( "\n", "\r\n"  );
		}  else  {
			// 2014-0918-Jane : FDK POS로 출력 시, \r 명령 삭제 처리. (\r : 초기화)
			let inEnv206 =  this.GetEnvXmlPosENV( 206  );
			// 2015-1105-Jane : 보안CAT 추가.

			if( inEnv206 == 11 || inEnv206 == 13 ) {
				szResult = szResult.replace( "\r", "" );
			}
		}

		if( this.m_csPrintCode == "11"  ) {
	        // 2016-0427 Antony.Choi : 무서명 거래 조건 추가

			if(  pu.parseInt( this.GetEnvXmlShopENV( 150 )) == "1"
			||  ( this.m_stSaleInfo.stPrintData.DDC_FLAG == true && this.m_stSaleInfo.stPrintData.NO_CVM_FLAG == false )
			||  (this.GetSignPadYn() == false && this.m_stSaleInfo.stPrintData.NO_CVM_FLAG == false )) {
				return szResult;
			}
			return "";
		}

		return szResult;
	}

	/*
	 * 2021. 05. 26 xbwing
	 * 주방 프린터 출력을 위한 함수.
	 */
	this.SetMakeSpecialPrintData = function( pcsPrintFormat )
	{
		var   	csQrySql	   	= "";
		var		csSetPrintType 	= "";
		var		paramSql	   	= "";
		var		bRet			= false;

		
		csSetPrintType = this.GetEnvXmlShopENV( 510 ); // 코스 출력 'N' 사용안함, 'Y' 모두출력, 'Z' 프린터 설정에 따른 출력 , 'ZZ' 코스메뉴별 컷팅지원

		// 2014-0930-Jane : 하늘목장 체험권 출력 적용 (세트상품일 경우 주문서 각각 출력되도록..)
		if( csSetPrintType == "ZZ" )
		{
			csQrySql = 	"SELECT TRIM(A.ORDER_DTL_NO) AS ORDER_DTL_NO "
						+ ", B.UNIT_PROD_SEQ AS  UNIT_PROD_SEQ "                   
						+ ", TRIM(A.PROD_CD) AS PROD_CD "                         
						+ ", A.SALE_QTY AS SALE_QTY "                        	
						+ "FROM POS_ODDTL_T A "                       
						+ "LEFT OUTER JOIN (SELECT X.SHOP_CD, "		 
						+ "					      X.PROD_CD, "		 
						+ "						  X.SET_PROD_FG , "	
						+ "						  X.UNIT_PROD_SEQ "
						+ "				   FROM SCD_PRDST_T X, SCD_PRTPR_T Y "
						+ "				   WHERE X.SHOP_CD = Y.SHOP_CD "	
						+ "				   AND X.UNIT_PROD_CD = Y.PROD_cD ";
			
			paramSql =  "AND Y.PRT_NO = '%s') B "	
					  	+ "ON B.SHOP_CD = A.SHOP_CD "				 
						+ "AND B.PROD_CD = A.PROD_CD "				 
						+ "AND B.SET_PROD_FG    = '2' "			// 2021. 5. 31 xbwing - 세트메뉴일 경우.	 
						+ "WHERE A.SHOP_CD      = '%s' "              
						+ "AND   A.SALE_DATE    = '%s' "              
						+ "AND   A.ORDER_NO     = '%s' "              
						+ "AND   A.ORDER_SEQ_NO = '%s' "              
						+ "AND   ( A.SALE_QTY <> 0 OR A.SALE_AMT <> 0 ) " 
						+ "ORDER BY A.ORDER_DTL_NO ASC";
			
			paramSql = paramSql.sprintf( this.m_stSaleInfo.PRT_NO,    this.m_stSaleInfo.SHOP_CD, 
					                     this.m_stSaleInfo.SALE_DATE, this.m_stSaleInfo.ORDER_NO, this.m_stSaleInfo.ORDER_SEQ_NO );
	
			csQrySql += paramSql;
		
			bRet = this.CommonSpecialPrint( csQrySql, pcsPrintFormat );
		}
		else
		{
			//util.logDebug( "PreOrder flag : " + this.m_stSaleInfo.blPreOrderFg );
			if( this.m_stSaleInfo.blPreOrderFg == true )
			{
				csQrySql = 	"SELECT ORDER_DTL_NO "                    
							+ ", SALE_QTY "                          
							+ ", PROD_CD "                           		// 2010-1122-YBC 
							+ "FROM POS_PODTL_T ";       
							
				paramSql = 	"WHERE SHOP_CD        = '%s' "                
							+ "AND   ORDER_DATE   = '%s' "                
							+ "AND   PRE_ORDER_NO = '%s' "                
							+ "ORDER BY ORDER_DTL_NO ASC";
				
				paramSql = paramSql.sprintf( this.m_stSaleInfo.SHOP_CD, this.m_stSaleInfo.SALE_DATE, 
						                     this.m_stSaleInfo.ORDER_NO );
				csQrySql += paramSql;
				
			}
			else
			{
	
				// 2010-1122-YBC : SQL-NoData 떨어지는 경우 상품확인을 위해서 PROD_CD 추가.
				csQrySql = 	"SELECT ORDER_DTL_NO "                      
							+ ", SALE_QTY "                         
							+ ", PROD_CD "                           		// 2010-1122-YBC 
							+ "FROM POS_ODDTL_T ";      
							
				paramSql =	"WHERE SHOP_CD        = '%s' "                
							+ "AND   SALE_DATE    = '%s' "                
							+ "AND   ORDER_NO     = '%s' "                
							+ "AND   ORDER_SEQ_NO = '%s' "                
							+ "AND   ( SALE_QTY <> 0 OR SALE_AMT <> 0 ) " 
							+ "ORDER BY ORDER_DTL_NO ASC";
							   
			   paramSql = paramSql.sprintf( this.m_stSaleInfo.SHOP_CD,  this.m_stSaleInfo.SALE_DATE, 
					                        this.m_stSaleInfo.ORDER_NO, this.m_stSaleInfo.ORDER_SEQ_NO );
			   csQrySql += paramSql;			   
			}
				
			bRet = this.CommonSpecialPrint( csQrySql, pcsPrintFormat );
		}
		
		return bRet;
	}
	
	/*
	 * 2021. 5. 28 xbwing
	 * 주방 프린트 관련 공통 모듈 함수로 변경함.
	 */
	this.CommonSpecialPrint = function( strSql, pcsPrintFormat )
	{
		var   	csResult	   = "";
		var   	csPrintData    = "";
		var   	inPrintSaleQty = 0;
		var 	bBellFlag      = true;
		var		bRet		   = false;

		// 2009-1201-YBC : 주방벨 처리.
		var   inKitBellUseFg = this.GetEnvXmlShopENV( 115 );
		
		
		let dbResult = gfn_SQLiteSQLProcess( strSql, [] );
		if( pu.isEmpty(dbResult )  || pu.isEmpty(dbResult.Data) || dbResult.Data.length == 0 ) 
			return false;
		

		var inOneProdDataLength = 0;
		var inMaxOneDataCnt     = 0;
		var inMaxLoopCnt        = 0;
		var inAccLoopCnt        = 0;
		

		m_csOrderDtlNo			= "";
		m_csOrderDtlProdCd		= "";	// 2010-1122-YBC
		m_csUnitSeqNo      		= "";	// 2014-0930-Jane
		
		let row					= 0;
		let rows 				= dbResult.Data;
			
		for( var a = 0; a < rows.length; a++ )
		{
		
			row 			= rows[a];
			csPrintData 	= "";
			
			m_csOrderDtlNo		= row[ "ORDER_DTL_NO"  ];
			m_csOrderDtlProdCd	= row[ "PROD_CD"       ];		// 2010-1122-YBC
			m_csUnitSeqNo		= row[ "UNIT_PROD_SEQ" ];

			csResult = this.PrintCodeMatch( pcsPrintFormat );
			
			if( csResult.length < 1) 
				continue;

			// 메뉴수량별 컷팅인 경우.
			if( m_inSpectialPrintFg == 2 )
			{
				inAccLoopCnt   = 0;
				inPrintSaleQty = row[ "SALE_QTY" ];
				
				if( inPrintSaleQty < 0 ) 
					inPrintSaleQty *= -1;

				inOneProdDataLength = csResult.length;

				inMaxOneDataCnt     = parseInt( 4000 / (inOneProdDataLength + LEN_DEF_5) );
				var 		div 	= Math.floor( inPrintSaleQty/inMaxOneDataCnt );
				inMaxLoopCnt        = parseInt( div ) + 1;

				// PrintContent Coloumn Byte가 4,000 Byte 라서 분리해서 넣어야함.
				for( let i = 0; i < inMaxLoopCnt; i++ )
				{
					csPrintData = "";

					for( let j = 0; j < inMaxOneDataCnt; j++ )
					{
						if( inAccLoopCnt >= inPrintSaleQty ) 
							break;

						csPrintData += csResult;
						
						inAccLoopCnt++;
					}

					// 메뉴수량별 컷팅에서 첫번째 출력물에 대해서만 주방벨 출력.
					if( inKitBellUseFg && bBellFlag )
					{
						csPrintData = pu.BASE_PRINT["BELL"] + csPrintData;
						bBellFlag = false;
					}

					bRet = this.SpecialPrintInsert( csPrintData );
				}
			}
			else // 메뉴별 컷팅인 경우.
			{
				csPrintData = csResult;
				// 메뉴별 컷팅에서 첫번째 출력물에 대해서만 주방벨 출력.
				if( inKitBellUseFg && bBellFlag )
				{
					csPrintData = pu.BASE_PRINT["BELL"] + csPrintData;
					bBellFlag = false;
				}

				bRet = this.SpecialPrintInsert( csPrintData );
			}
			
		}
	}
	
	/*
	 * 2021. 05. 26 xbwing
	 * 주방 출력 정보를 SKIOSK.db에 저장하기 위해 정보 설정 함수.
	 */
	this.SpecialPrintInsert = function( pcsContents )
	{
		var csLog	  	= "";
		var csRePrint 	= "0";	// 2010-0928-JJM : .
		var	PrtTmCnt	= 0;
		var EnvSetVal	= "";
		let rows		= "";
		
		csRePrint = ( this.m_stSaleInfo.RE_PRINT == undefined ) ? "0" : "1";
					
		var sqlParam = [   this.m_stSaleInfo.SHOP_CD
			             , this.m_stSaleInfo.SALE_DATE
			             , this.m_stSaleInfo.ORDER_NO
			             , this.m_stSaleInfo.PRT_NO
			             , pcsContents
			             , "N"
			             , this.m_stSaleInfo.ORDER_PRINT_SEQ
			             , this.m_stSaleInfo.ORDER_SEQ_NO
			             , csRePrint // RePrintFG -- 확인해야함.
			           ];


		let bRet = this.PrintInsert_Sql2( sqlParam );

		if( bRet )
			bRet = this.KitchenPrint( pcsContents );
		
		return bRet;
	}
	
	/*
	 * 2021. 05. 27 xbwing
	 * Kitchen 프린트 함수.
	 */
	this.KitchenPrint = function( pcsKitchenData )
	{
		var vKitPrtNo 	= m_stPrtSubInfo.KIT_PRT_NO;
		var vOrderPrtSeq= m_stPrtSubInfo.ORDER_PRINT_SEQ;
		
		util.logInfo( "PrtInfo     :" + m_stPrtInfo[vKitPrtNo] );
		util.logInfo( "KitPrtNo    : " + vKitPrtNo );
		util.logInfo( "OrderPrtSeq : " + vOrderPrtSeq );
		

		util.logInfo( "주방 프린트 정보 : " + pcsKitchenData );
		if( !pu.isEmpty(pcsKitchenData)  ) 
		{
			util.logInfo("***** 주방 프린터를 위해 파일을 작성 *****");
			this.makeKitchenPrintData( m_stPrtInfo[vKitPrtNo] , pcsKitchenData, vOrderPrtSeq , vKitPrtNo );//파일생성
		    
			util.Delay( 700 );
			
			return true;
		}
		
		return false;
	}
	
	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : GetSignPadYn. :
	// =============================================================================
	// PARAMETER 1 : No : .
	// RETURN VALUE : bool : .
	// PROGRAMMER : CWS-2009-05-21 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.GetSignPadYn = function() {
		return this.m_blSignPadUseFg;
	}


	/***************************************************************************
	 * Native app 프린터 호출. - deviceName : /dev/ttyUSB0 - baudRate : 57600 -
	 * printData : print data - dataLength : print data 길이 - signImgPath : 서명
	 * 이미지 path(optional)
	 **************************************************************************/
	var listenerIdPrint = "";
	var goPrintCallback;
	this.printCall = function (reqstr , signImgPath, printCallback) {
		util.logInfo("*****printer printCall START*****");
		goPrintCallback = printCallback;
		if ( pu.isEmpty(reqstr )) {
			if(!printCallback){
				return  { "ResultCode" : "1",  "Data" : "", "Message" : "Print 할 문자가 입력되지 않았습니다." };
			}else{
				printCallback({ "Code" : "-1",  "Data" : "FAIL", "Message" : "Print 할 문자가 입력되지 않았습니다." }); // 비동기 일 때 native에서 성공 코드를 Code : 9로 리턴한다.
			}
		}

		if (pu.isEmpty(signImgPath )) {
			signImgPath = "";
		}
		let dataLength = reqstr.getByteLength() ;


		//util.logInfo('출력요청 문자 :\n' + reqstr);
		//util.logInfo('출력요청 문자 Byte길이 : ' + dataLength);
		//util.logInfo("서명이미지 경로(signImgPath) [%s]".sprintf( signImgPath) );
		util.logInfo('m_inBillPrtPortNo  : ' + m_inBillPrtPortNo);
		util.logInfo('m_inBillPrtSpeedCd : ' + m_inBillPrtSpeedCd);

		if(typeof tizen == "undefined" ){
			util.logInfo('window 는 무조건 Success....');
			if(!printCallback){
				return  { "ResultCode" : "0",  "Data" : "SUCCESS", "Message" : "" };
			}else{
				printCallback({ "Code" : "9",  "Data" : "SUCCESS", "Message" : "" }); // 비동기 일 때 native에서 성공 코드를 Code : 9로 리턴한다.
			}
			
		}

		/**
		 * 콜백이 있으면 비동기 호출, 없으면 동기호출로 처리한다.
		 */
		if(!printCallback){ // 동기 호출일 때
			util.logInfo("*****printer printCall Sync START*****");
				let r= nativeApp.functionCallSync(["FDK_Print", "/dev/ttyS" +  m_inBillPrtPortNo , m_inBillPrtSpeedCd, reqstr, dataLength, signImgPath]);
			try {
				/*** PP Plugin 의 gabage 처리 부적합으로.. 해당 문자 이전까지 JSON.parse 처리 **/
				let eofCharacters = "$$^";
	
				if ( r.indexOf( eofCharacters ) != -1){
					r = r.substring(0, r.lastIndexOf( eofCharacters )).trim();
				} else{
					r = r.trim();
				} 
				util.logInfo("print native call resuilt " + r);
				r = JSON.parse(r);

			} catch (e) {
				util.logError("print native result error " + e.toString() );
				throw "print native result error " + e.toString();
			}
			return r;
			
		}else{ // 비동기 호출일 때
			util.logInfo("*****printer printCall Async START*****");
			try {
//				let r= nativeApp.functionCallSync(["FDK_Print", "/dev/ttyS" +  m_inBillPrtPortNo , m_inBillPrtSpeedCd, reqstr, dataLength, signImgPath]);  +  m_inBillPrtPortNo
				listenerIdPrint = nativeApp.functionCallASync(["FDK_AsyncPrint", "/dev/ttyS1", m_inBillPrtSpeedCd, reqstr, dataLength, signImgPath], asyncPrintCallback);
				function asyncPrintCallback(callbackName, result){
					util.logInfo("_____FDK_AsyncPrint Callback Start_____");
					result = result.substring(0, result.lastIndexOf("$$^")); // Eof 이후 문자는 버린다 ($$^)
					try {
						var jsonResult = JSON.parse(result);
						nativeApp.removeASyncApiListener(callbackName, listenerIdPrint); // 리더기 카드체크하는 리스너 해제함수.
						if(jsonResult["Code"] != 9){
							util.logError("_____FDK_AsyncPrint Error!!_____");
						}else{
							util.logInfo("_____FDK_AsyncPrint Success!!_____");
						}
						printCallback(jsonResult);
//						return jsonResult;
					}catch (e) {
						util.logError("FDK_AsyncPrint native result error [" + e.toString()+ "]" );
						throw "FDK_AsyncPrint native result error[" + e.toString() + "]";
					}
				}
			}catch(e){
				log.logError("printer printCall Async error " + e.toString() );
			}
		}
		
	}	
	
	this.asyncPrintCallback2 = function(callbackName, result){
		util.logInfo("_____FDK_AsyncPrint Callback Start_____");
		result = result.substring(0, result.lastIndexOf("$$^")); // Eof 이후 문자는 버린다 ($$^)
		try {
			var jsonResult = JSON.parse(result);
			nativeApp.removeASyncApiListener(callbackName, listenerIdPrint); // 리더기 카드체크하는 리스너 해제함수.
			if(jsonResult["Code"] != 9){
				util.logError("_____FDK_AsyncPrint Error!!_____");
			}else{
				util.logInfo("_____FDK_AsyncPrint Success!!_____");
			}
			goPrintCallback(jsonResult);
//			return jsonResult;
		}catch (e) {
			util.logError("FDK_AsyncPrint native result error [" + e.toString()+ "]" );
			throw "FDK_AsyncPrint native result error[" + e.toString() + "]";
		}
	}

	// 파라미터 설정된 명칭을 실제 데이터랑 맵핑
	this.GetPrintCodeData = function(pcsCode) { // 1893 라인까지		
		let blSale = true;
		let csRetStr	= "";
		let csSlipTitle = "";
		let csTemp		= "";
		let csPrint     = "";
		let csValue     = "";

		if( pcsCode == "{타이틀}" ||  pcsCode == "{타이틀-이용권}"  ) {
			return this.m_stSaleInfo.TITLE;
		}


		if( pcsCode ==  "{FONT1}" ||  pcsCode ==  "{일반}" ||  pcsCode ==  "{문자-확대취소}"  ) {
			if( this.m_csView ) {
				return "";
			}
			return pu.GetPRTDeviceCMD( "NORM" );
		}

		if( pcsCode == "{FONT2}" ||  pcsCode == "{세로확대}"  ||  pcsCode == "{문자-세로확대}"  ) {
			if( this.m_csView ) {
				return "";
			}
			return pu.GetPRTDeviceCMD( "V2X" );
		}

		if( pcsCode == "{FONT3}"  ||  pcsCode == "{가로확대}"  ||  pcsCode == "{문자-가로확대}"  ) {
			if( this.m_csView ) {
				return "";
			}
			return pu.GetPRTDeviceCMD( "H2X" );
		}

		if( pcsCode ==  "{FONT4}"  ||  pcsCode ==  "{가로세로확대}" ||  pcsCode ==  "{문자-가로세로확대}"  ) {
			if( this.m_csView ) {
				return "";
			}
			return pu.GetPRTDeviceCMD(  "HV2X"  );
		}

		if( pcsCode == "{CRLF}"  ) {
			return  "\r\n" ;
		}

		if( pcsCode == "{테이블}" || pcsCode == "{테이블그룹}" || pcsCode == "{테이블표기}" )
		{
			var szSpace = " ";
			var nIdx	= 0;
					
			nIdx = ( pcsCode == "{테이블}" ) ? 0 : ( (pcsCode == "{테이블그룹}") ? 1 : 2 );
			
			// basicOrderInfo객체에 table 정보가 없을 때 if문 수행.
			if( basicOrderInfo.tableGroup == undefined || basicOrderInfo.tableNm == undefined )
			{
				// 테이블 정보가 없는 경우에, DB에서 정보를 조회해서 있으면 그 값으로 보여주도록 기능 추가.
//				let sql = _sql.selectTblCd( this.m_stSaleInfo); 
//				let db_result = gfn_SQLiteSQLProcess( sql , [ ]); // table_cd를 가져온다.
//				
//				if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data)  || db_result.Data.length == 0 ) {						
//					if( nIdx == 0 ){
//						csRetStr = new Array( 16 ).join( ' ' );
//					}
//					return csRetStr;
//				}
//				var rows = db_result.Data;
//																			
//				var vsTblCd = rows[0]["FD_TBL_CD"];								
//				let sql2 = _sql.selectTblInfoData( vsTblCd);
//				let db_result2 = gfn_SQLiteSQLProcess( sql2 , [ ]); // 위에서 가져온 table_cd로 테이블 그룹, 테이블 명을 가져온다.
//				
//				if ( pu.isEmpty(db_result2 )  || pu.isEmpty( db_result2.Data)  || db_result2.Data.length == 0 ) {	
//					if( nIdx == 0 ){
//						csRetStr = new Array( 16 ).join( ' ' );
//					}
//					return csRetStr;
//				}
//				var rows2 = db_result2.Data;
//				var vsTblG = rows2[0]["TG_NM"] // 테이블그룹명
//				var vsTblNm = rows2[0]["TABLE_NM"] // 테이블명
				
				if( nIdx == 0 ){ // {테이블}
					if(!!this.m_stSaleInfo.TABLE_NM){
						csRetStr = "%s".sprintf( this.m_stSaleInfo.TABLE_NM );
					}else{
						csRetStr = new Array( 16 ).join( ' ' );
						return csRetStr;
					}
				}else if(nIdx == 1){ // {테이블그룹}
					if(!!this.m_stSaleInfo.csTableGroupNm){
						csRetStr = "%s".sprintf( this.m_stSaleInfo.csTableGroupNm );
					}else{
						return csRetStr;
					}
				}else if (nIdx == 2 ){ // {테이블표기}  테이블 그룹 - 테이블 명
					if(!!this.m_stSaleInfo.TABLE_NM || !!this.m_stSaleInfo.csTableGroupNm){
						var vsTbNm = this.m_stSaleInfo.TABLE_NM;
						var vsGrNm = this.m_stSaleInfo.csTableGroupNm;
						if(!vsTbNm){
							vsTbNm = "";
						}
						if(!vsGrNm){
							vsGrNm = "";
						}
						csRetStr = "%s-%s".sprintf( vsGrNm, vsTbNm );
					}else{
						return csRetStr;
					}
					
				}
				return pu.RPad( "%s".sprintf(csRetStr, 16), 16 );
			}
			
			switch( nIdx )
			{
			case 0:
				csRetStr = "%s".sprintf( basicOrderInfo.tableNm );
				break;
			
			case 1:
				csRetStr = "%s".sprintf( basicOrderInfo.tableGroup );
				break;
			
			case 2:
				csRetStr = "%s-%s".sprintf( basicOrderInfo.tableGroup, basicOrderInfo.tableNm );
				break;
				
			default:
				break;
			}
			
			return pu.RPad( "%s".sprintf(csRetStr, 16), 16 );
		}
		
		
		if( pcsCode == "{손님수}"  )
		{
			if( this.m_csPrintCode == "04"  )
				csRetStr = "%02d 명".sprintf( this.m_stSaleInfo.inFdGstCnt );// TODO
																			// 포맷
			return csRetStr;// 2020.08.12 최광림 차장 확인.
//
// if ( this.m_csPrintCode == "01" ) // 2019-08-13-SHK [손님수] : 영수증에 {손님수} 코드 추가.
// { // 2019-08-13-SHK [손님수]
// csRetStr = this.GetGstData(); // 2019-08-13-SHK [손님수]
// } // 2019-08-13-SHK [손님수]
//
// return csRetStr;
		}
		if( pcsCode == "{주문자}" ) {
			if( this.m_csPrintCode == "04" ){
				return pu.RPad(pu.DllGetCutHangul(this.m_stSaleInfo.EMP_NM,8), 8);
			}

			csRetStr = this.GetSalesOrderEmpName();		// 2015-0610-Jane :
														// 주문자정보 수정. (기존 판매원이
														// 출력됨)
			return csRetStr;
		}

		if( pcsCode ==  "{주문번호}"  ) {
			if( this.m_csPrintCode == "04"  ) {

				if ( this.m_stSaleInfo.blPreOrderFg == true  ) {
					// 2019-01-18-JYL : PreOrder 가맹점용주문번호. [PreOrder:스마트오더:CA00
					// 수정건개발] : 주방주문서 Pre-Order 번호(SHOP_ORDER_NO)로 통일
					csRetStr =  "%s".sprintf( this.m_stSaleInfo.ORDER_NO );

				} else {
					// 주문번호 구성 : 주문번호-주문차수
					csRetStr =  "%s-%s".sprintf( this.m_stSaleInfo.ORDER_NO, this.m_stSaleInfo.ORDER_SEQ_NO );
				}

			} else {
				// //////////////////////////////////////////////////////////////////////
				// 주문차수가 없을때 처리.
				// //////////////////////////////////////////////////////////////////////
				if( pu.isEmpty( this.m_stSaleInfo.ORDER_SEQ_NO )  ) {
					csRetStr = this.m_stSaleInfo.ORDER_NO;
				} else {
					// //////////////////////////////////////////////////////////////////
					// 주문번호 구성 : 주문번호-주문차수
					// //////////////////////////////////////////////////////////////////
					csRetStr =  "%s-%s".sprintf( this.m_stSaleInfo.ORDER_NO, this.m_stSaleInfo.ORDER_SEQ_NO );
				}
			}
				
			return csRetStr;
		}
		
		if( pcsCode ==  "{K-주문번호}"  ) {
			csRetStr =  this.m_stSaleInfo.ORDER_NO;			
			return csRetStr;
		}

		if( pcsCode == "{이전차수-메뉴목록}"  ||  pcsCode == "{이전차수-메뉴목록-금액}"  ) {
			// //////////////////////////////////////////////////////////////////////
			// 주문차수가 1차수 인경우는 제외.
			// //////////////////////////////////////////////////////////////////////
			if( parseInt( this.m_stSaleInfo.ORDER_SEQ_NO ) > 1 ) {
				csRetStr = this.GetProductListData( pcsCode, false );
			}
			return csRetStr;
		}

		if( pcsCode == "{주문서-메뉴출력형태1}" || pcsCode == "{주문서-메뉴출력형태2}" || pcsCode == "{주문서-메뉴출력형태3}" || pcsCode == "{주문서-메뉴출력형태4}") {
			// 주방프린터일 경우
			if( this.m_csPrintCode == "04" ){

				csRetStr = this.GetProductListData_04(pcsCode, false );
				if( pu.isEmpty( csRetStr ) || csRetStr == false  ) 
					csRetStr =  "*" ;

				return csRetStr;				
				
			} else {
				// 주방프린터가 아닐경우.
				return this.GetProductListData( pcsCode, false );
			}
		}
		
		// //////////////////////////////////////////////////////////////////////
		// 2021. 10. 26 xbwing - 주방 주문 총수량 정보를 얻어 온다.
		// //////////////////////////////////////////////////////////////////////
		if( pcsCode == "{주방주문총수량}" )
		{
			// ASP 환경 설정이 688일 경우만 해당됨.
			csRetStr = this.GetkitchenOrderTotalCount( (m_gbIs688==true? this.GetEnvXmlShopENV(688) : false) );
			
			if( pu.isEmpty(csRetStr) || csRetStr == false  ) 
				csRetStr = "" ;

			
			return csRetStr;
			
		}
		
		// //////////////////////////////////////////////////////////////////////
		// 2014-0317-Jane : 주문취소사유 등록 기능 추가
		// //////////////////////////////////////////////////////////////////////
		if( pcsCode == "{주문취소사유}"  ) {
			if( this.m_csPrintCode == "03"  || this.m_csPrintCode == "04"  )
			{
				return this.GetOrderCancelReason();
			}
			// 2014-0404-Jane : 반품사유 출력 기능 추가.
			else if( this.m_csPrintCode == "01"  )
			{
				return GetSaleCancelReason();
			}
			else
			{
				return "";
			}
		}

		if( pcsCode == "{배달전화번호}"  ) {
			csRetStr = "";
// if( this.m_stDlvOrderData.csDlvTelNo.length > 0 ) {
// csRetStr = this.m_stDlvOrderData.csDlvTelNo ;
// }
			return csRetStr;
		}

		if( pcsCode == "{배달지주소}"  )	{
// csTemp = this.m_stDlvOrderData.csDlvAddr;
// return csTemp;
			return "";
		}

		if( pcsCode == "{POSNO}"  ) {
			if( parseInt( this.m_csPrintCode ) == 36
			||  parseInt( this.m_csPrintCode ) == 37 ) {
				if ( this.m_stSaleInfo.POS_NO == "") {		// 2019-05-23-SHK
															// [정산현황]
					return "전체" ;
				} else {
					return this.m_stSaleInfo.POS_NO;
				}
			}
			return this.m_stSaleInfo.POS_NO;
		}

		if( pcsCode == "{DATETIME}"  ) {
			let	csSystemDate = moment().format("YYYY-MM-DD HH:mm:ss");// g_clsUtil.DllGetDateSystem(
																		// "YYYY-MM-DD
																		// HH:MM:SS",
																		// csSystemDate
																		// );
			return csSystemDate;
		}
		if( pcsCode == "{DATE}"  ) {
			let	csSystemDate = moment().format("YYYY-MM-DD");// g_clsUtil.DllGetDateSystem(
																// "YYYY-MM-DD
																// HH:MM:SS",
																// csSystemDate
																// );
			return csSystemDate;
		}

		if( pcsCode == "{EMP_ON}" ) {
			if(this.m_csView ) {
				return "";
			}
			return pu.GetPRTDeviceCMD( "EMP_ON" );
		}

		if( pcsCode == "{EMP_OFF}" ) {
			if( this.m_csView ) {
				return "";
			}
			return pu.GetPRTDeviceCMD( "EMP_OFF" );
		}

		if( pcsCode ==  "{CUT}" ||  pcsCode == "{절취선}"  )	{

			if( this.m_csView ) {
				return "";
			}
			let csLineFeedCut = "";
			for( let i = 0; i < 4; i++ ) {
				csLineFeedCut += pu.GetPRTDeviceCMD( "FEED"  );
			}
			csLineFeedCut += pu.GetPRTDeviceCMD( "CUT"  );
			return csLineFeedCut;
		}

		if( pcsCode == "{교환번호}" ) {
			return this.m_stSaleInfo.CHG_BILL_NO;
		}

		if( pcsCode == "{대기번호}" ) {
			return this.m_stSaleInfo.DELIVERY_NO;
		}
		if( pcsCode == "{배달고객명}" ) {
			return (!pu.isEmpty(this.m_stSaleInfo.DLV_CST_NM))? this.m_stSaleInfo.DLV_CST_NM:"";
		}
		

		if( pcsCode == "{주문서-메뉴목록}" ||  pcsCode == "{주문서-메뉴목록-금액}" ) {
				if ( this.m_stSaleInfo.blPreOrderFg == true /** TRUE * */ ) {
					return "";
				}

				// /////////////////////////////////////////////////////////////////////////////
				// 해당 출력대상 프린터 번호를 구한다.
				// /////////////////////////////////////////////////////////////////////////////
				let inPrtNo     = /** atoi * */ pu.parseInt ( this.m_stSaleInfo.PRT_NO );	// 2009-0917-YBC
				return this.GetPresentOrderList( inPrtNo, pcsCode );
		}

		if( pcsCode == "{주문합계-메뉴목록}" ||  pcsCode == "{주문합계-메뉴목록-금액}" ) {

			if ( this.m_stSaleInfo.blPreOrderFg == true ) {
				return "";
			}

			// /////////////////////////////////////////////////////////////////////////////
			// 해당 출력대상 프린터 번호를 구한다.
			// /////////////////////////////////////////////////////////////////////////////
			let inPrtNo     = /** atoi * */ pu.parseInt ( this.m_stSaleInfo.PRT_NO );	// 2009-0917-YBC
			return this.GetSummaryOrderList( inPrtNo, pcsCode );
		}

		if( pcsCode == "{코너명}" ) {
			csRetStr =  "%s-%s".sprintf(this.m_stSaleInfo.CORNER_CD , this.m_stSaleInfo.CORNER_NM );
			return csRetStr;
		}
		if( pcsCode ==  "{코너별-메뉴목록}"  ) {
			return this.GetProductListData( pcsCode, true);
		}

		if( pcsCode == "{상품리스트1}" ||  pcsCode == "{상품리스트2}" ) { 
			if( this.m_csPrintCode == "14" ||  this.m_csPrintCode == "15" ||  this.m_csPrintCode == "05" )	{
					blSale = false;
				}
				return this.GetProductListData( pcsCode, blSale );
		}

		if( pcsCode == "{상품리스트3}" ||  pcsCode == "{상품리스트4}"  ||  pcsCode == "{K-상품리스트}")  {
			return this.GetProductListData( pcsCode, false );
		}

		if( pcsCode == "{상품리스트5}" ) {
			return "";
		}

		if( pcsCode == "{상품리스트6}" ||  pcsCode == "{상품리스트7}" ) {
			return this.GetProductListData( pcsCode, true );
		}

		if( pcsCode == "{계산원}" )	{
			let csTemp = "";
			if( this.m_csPrintCode ==  "02" ||  this.m_csPrintCode ==  "10" ||  this.m_csPrintCode ==  "21"  ||  this.m_csPrintCode ==  "06" ||  this.m_csPrintCode ==  "13" ||  this.m_csPrintCode ==  "14"  ||  this.m_csPrintCode ==  "41"  ) {
				csTemp = loginEmpInfo.EMP_NM ;
			} else if( this.m_csPrintCode == "22" || this.m_csPrintCode == "42" ) {
				csTemp = this.m_stSaleInfo.EMP_NM ;
			} else {
			    csTemp = this.m_stSaleInfo.EMP_NM ;
			}

			return pu.RPad( pu.DllGetCutHangul( csTemp ,6 ), 6 );
		}
		
		if( pcsCode == "{영수증번호}"  ) {
			let csTemp   = "";
			let csBillNo = "";
			// //////////////////////////////////////////////////////////////////////
			// 영수증번호가 없는경우 주문번호를 출력.
			// //////////////////////////////////////////////////////////////////////
			if( pu.isEmpty( this.m_stSaleInfo.BILL_NO  )) {
				if( pu.isEmpty ( this.m_stSaleInfo.ORDER_NO ) == true ) {
					return csTemp;
				}
				csBillNo = this.m_stSaleInfo.ORDER_NO + "【주】" ;
			}
			else {
				csBillNo = this.m_stSaleInfo.BILL_NO;
			}
			csTemp =  "%s-%s-%s".sprintf( this.m_stSaleInfo.SALE_DATE, this.m_stSaleInfo.POS_NO, csBillNo );
			return csTemp;
		}
		if( pcsCode ==  "{영업일자}"  ) {
			if( this.m_csPrintCode == "13" )	{
				csRetStr = pu.DllTransAtoA_Format( this.m_stSaleInfo.SALE_DATE,  "YYYY/MM/DD"  );
			} else {
				csRetStr = this.m_stSaleInfo.SALE_DATE;
			}
			return csRetStr;
		}

		if( pcsCode ==  "{정산원}" ) {

			let csTemp =  "[%s]%s".sprintf(this.m_stSaleInfo.EMP_NO, this.m_stSaleInfo.EMP_NM );
			return csTemp;
		}
		if( pcsCode ==  "{정산차수}" ) {
			if(  this.m_csPrintCode   == 36 ) {
				csRetStr = "%s차".sprintf( this.m_stSaleInfo.REGI_SEQ );
			}
			else {
				csRetStr =  "%02d차".sprintf( this.m_stSaleInfo.REGI_SEQ );// TODO...
			}
			return csRetStr;
		}

		if( pcsCode == "{주문서일련번호}" ) {
			return  this.m_stSaleInfo.ORDER_PRINT_SEQ;
		}
		
		if( pcsCode == "{CENTER}"  )	{
			return pu.GetPRTDeviceCMD( "CT_ALIGN"  );
		}

		if( pcsCode == "{LEFT}"  ) {
			return pu.GetPRTDeviceCMD( "LF_ALIGN" );
		}

		if( pcsCode == "{RIGHT}"  ) {
			return pu.GetPRTDeviceCMD( "RT_ALIGN" );
		}

		if( pcsCode == "{LOG}"  ||  pcsCode == "{매장로고}"  ) {
			if( this.m_csView ) {
				return "";
			}
			return pu.GetPRTDeviceCMD( "LOGO" );
		}

		if( pcsCode == "{OKCASHBAG}"  ) {
			return this.GetSalesJCardData();
		}
		if( pcsCode == "{받은금액}"  || pcsCode == "{R받은금액}" ) {
			if ( pcsCode == "{받은금액}" )
			{
				csRetStr += pu.GetPRTDeviceCMD( "FEED"  );
				csRetStr += pu.GetPRTDeviceCMD( "V2X"   );
			}
			//입력값이 없으면 초기화한다.
			if (util.byteLen (this.m_stSaleInfo.GST_PAY_AMT ) ==0 ) {
				this.m_stSaleInfo.GST_PAY_AMT = "";
			}

			csRetStr += this.m_stSaleInfo.GST_PAY_AMT;
			csRetStr += pu.GetPRTDeviceCMD( "NORM"  );
			return csRetStr;
		}
		if( pcsCode == "{받을금액}"  ||  pcsCode == "{R받을금액}" ) {
			let csInfoExpPayAmt = "";
			let csDataExpPayAmt = "";

			if ( pcsCode == "{받을금액}"  )  {
				csInfoExpPayAmt  = pu.GetPRTDeviceCMD( "V2X" ) + this.m_stSaleInfo.stPrintData.EXP_PAY_AMT;
				csDataExpPayAmt  = pu.GetPRTDeviceCMD( "V2X" ) + this.m_stSaleInfo.EXP_PAY_AMT;
			} else  {
				csInfoExpPayAmt  = this.m_stSaleInfo.stPrintData.EXP_PAY_AMT;
				csDataExpPayAmt  = this.m_stSaleInfo.EXP_PAY_AMT   ;
			}


			if( !pu.isEmpty(  this.m_stSaleInfo.SVC_TIP_AMT ) ) {
				csRetStr += pu.parseInt(this.m_stSaleInfo.SVC_TIP_AMT) + csDataExpPayAmt;
			} else {
				csRetStr += csDataExpPayAmt;
			}
			// //////////////////////////////////////////////////////////////////////
			// 2010-0423-YBC : 배달영수증 또는 배달원전표인 경우
			// 선결제 한경우 때문에 자동으로 받은금액을 표기해야한다.
			// //////////////////////////////////////////////////////////////////////
			if( parseInt( this.m_csPrintCode ) == 14  ||  parseInt( this.m_csPrintCode ) == 15 ) {
				// 2019-0918-jane : 받을금액 뒤에 받은금액 출력 시, 개행 추가. (단말기 기종에 따라 자동개행
				// 안되는 경우 있으므로 넣어줘야함.
				csRetStr += pu.GetPRTDeviceCMD( "FEED");				// 2019-0918-jane
																		// :
																		// 개행추가.
				csRetStr += pu.parseInt( this.m_stSaleInfo.GST_PAY_AMT );
			}

			csRetStr  += pu.GetPRTDeviceCMD( "NORM"  );

			return csRetStr;
		}

		if( pcsCode == "{별도-신용승인전표-내역}"  || pcsCode == "{R별도-신용승인전표-내역}" ) {
			if( this.m_stSaleInfo.APPR_LOG_NO != "" ) {
				return this.GetNoneSalesCardCollectData(pcsCode);
			}
			return GetSalesCardCollectData(pcsCode);
		}
		
		// 신용승인정보를 만드는 부분.
		if( pcsCode == "{신용카드}"  ||  pcsCode == "{R신용카드}" ) {
			// /////////////////////////////////////////////////////////////////////////////
			// 영수증출력구분 0: 일반영수증출력 1:개별영수증출력
			// 2:영수증출력안함(고객용/현금영수증 출력) 3:영수증출력안함(전체)
			// /////////////////////////////////////////////////////////////////////////////
			var vsEnvVal = this.GetEnvXmlShopENV( 524 );
			if( pu.parseInt( vsEnvVal ) == 0 || pu.parseInt( vsEnvVal ) == 3 ) { // 2020-0220-oh,il
				util.logInfo("*****GetPrintCodeData ShopEnv 524 == > " + vsEnvVal);
				if( this.m_csPrintCode == "02"  ) {
					util.logInfo("*****GetPrintCodeData this.m_csPrintCode is 02");
					return this.GetNoneSalesCardData(pcsCode);
				}
				util.logInfo("*****GetPrintCodeData this.m_csPrintCode NOT 02");
				return this.GetSalesCardData(pcsCode);
			}
			return "";
		}

		if( pcsCode == "{SIGN}"  ) {
	        // 2016-0427 Antony.Choi : 무서명 거래 조건 추가
			if (this.m_stSaleInfo.stPrintData.NO_CVM_FLAG == true
				&& ( ( this.m_csPrintCode == "11" &&  this.m_blSignPadUseFg == false ) || this.m_blSignPadUseFg == true ) )
			{
				csValue = "* [%d원]이하 무서명 거래입니다.".sprintf( this.LN_CVM_AMT);
				return csValue;
			}

			if( ( this.m_csPrintCode == "11"  || this.m_csPrintCode == "48" ) &&  this.m_blSignPadUseFg == false ) {// 2020-0123-HJH :  기타전표 회수용추가
				if( this.g_inPaperTypeFg == 0 ) {
					return "\r\n\r\n 고객서명란 : __________________\r\n" ;
				}
				return "\r\n\r\n     고 객 서 명 란 : ____________________\r\n" ;
			}

			if( this.m_blSignPadUseFg == true ) {
				// //////////////////////////////////////////////////////////////////
				// 재발행인경우 전자서명 출력안됨.
				// //////////////////////////////////////////////////////////////////
				if( this.m_stSaleInfo.RE_PRINT == false ) {
					if( this.g_inPaperTypeFg == 0 ) {
						return "{CRD-SIGN} 전자서명 : ___________________\r\n" ;
					}
					return "{CRD-SIGN}      전 자 서 명 : ______________________\r\n" ;
				}
				if( this.g_inPaperTypeFg == 0 ) {
					return "\r\n\r\n 고객서명란 : __________________\r\n" ;
				}
				return "\r\n\r\n     고 객 서 명 란 : ____________________\r\n";
			}
			return csRetStr;
		}

		if( pcsCode == "{개점시간}" ) {
			return this.m_stSaleInfo.OPEN_DT;
		}

		if( pcsCode == "{거스름}" ) {
			return this.m_stSaleInfo.RET_PAY_AMT;
		}

		if( pcsCode == "{결제리스트}" ) {

			csRetStr += this.m_stSaleInfo.CASH_LIST.substring(0,  this.m_stSaleInfo.CASH_LIST.length -2 );
			return csRetStr;
		}
		if( pcsCode == "{결제수단별매출내역}"  ) {
			if(  this.m_csPrintCode == 37 ) {
				return this.GetReissueAccountData( pcsCode );
			}
			return this.m_stSaleInfo.csTypeData;
		}

		if( pcsCode == "{대표자}" ) {
			return this.GetEnvXmlShopINFO( "OWNER_NM" );
		}

		if( pcsCode == "{매장-배달매출내역}" ) {
			if(  this.m_csPrintCode  == 37 ) {
				return this.GetReissueAccountData( pcsCode );
			}
			return this.m_stSaleInfo.csDeliveryData;
		}
	    if( pcsCode == "{매출상품권내역}"  )  {
	        return this.GetSaleGiftList();
	    }

		if( pcsCode == "{매출시간}"  ) {
			return this.m_stSaleInfo.INS_DT;
		}

		if( pcsCode ==  "{매출합계}"  ) {
			if(  this.m_csPrintCode  == 37 ) {
				return this.GetReissueAccountData( pcsCode );
			}
			return this.m_stSaleInfo.csSaleSumData;
		}

		if( pcsCode == "{매출현황-상품별}"  ) {
			if( this.m_csPrintCode == "08"  ||  this.m_csPrintCode == "09" ||  this.m_csPrintCode == "37"  ) {
				if( this.m_csPrintCode == "08"  ||  this.m_csPrintCode == "09"  ) {
					this.m_stSaleInfo.SHOP_CD	= this.m_stSaleInfo.SHOP_CD;
					this.m_stSaleInfo.FROM_DATE = this.m_stSaleInfo.SALE_DATE;
					this.m_stSaleInfo.TO_DATE	= this.m_stSaleInfo.SALE_DATE;
					this.m_stSaleInfo.POS_NO	= this.m_stSaleInfo.POS_NO;
				}

				let csProdSale	 = "";
				if( this.g_inPaperTypeFg == 0 ) {
					csProdSale = "     ** 상품별 매출현황 **  \r\n" ;
				}
				else {
					csProdSale = "          ** 상품별  매출현황 **          \r\n" ;
				}

				let csOldPrintCode = "";
				csOldPrintCode = this.m_csPrintCode;
				this.m_csPrintCode  = "32" ;                 // 상품별 매출현황을 위한
																// 32 셋팅.
				csProdSale    += this.GetSaleDataProdPrint();
				this.m_csPrintCode  = csOldPrintCode;

				return csProdSale;
			}
			return this.GetSaleDataByDataBase( pcsCode );
		}

		if( pcsCode == "{매출현황-상품분류-소}" ) {
			if(  this.m_csPrintCode   == 37 ||  this.m_csPrintCode  == 9 ||  this.m_csPrintCode  == 8) {
				// 2017-04-24-JYL [2Q / 마감정산 출력물 코드 추가 개발]
				if (this.m_csPrintCode  == 9 ||  this.m_csPrintCode == 8  ){
					this.m_stSaleInfo.SHOP_CD	 = this.m_stSaleInfo.SHOP_CD;
					this.m_stSaleInfo.FROM_DATE = this.m_stSaleInfo.SALE_DATE;
					this.m_stSaleInfo.TO_DATE	 = this.m_stSaleInfo.SALE_DATE;
					this.m_stSaleInfo.POS_NO    = this.m_stSaleInfo.POS_NO;
				}
				return this.GetReissueAccountData( pcsCode );
			}
			return this.GetSaleDataByDataBase( pcsCode );
		}

		if( pcsCode == "{매출현황-일자별}" ) {
			return this.GetSaleDataByDataBase( pcsCode );
		}

		if( pcsCode ==  "{모바일내역}")   { // 2017-06-13-JYL [기타결제:커피에반하다(톨게이트)]

			if(  pu.parseInt( this.GetEnvXmlShopENV( 524 ) ) == 0		// 2019-1202-HJH
																		// :
																		// 기타결제
																		// 개별출력추가
			 ||  pu.parseInt( this.GetEnvXmlShopENV( 524 ) ) == 3 )	// 영수증미출력(전체)
																	// 선택시
																	// 직전영수증에
																	// 모바일내역 출력
																	// (by
																	// Ilgeun
																	// Oh,
																	// 200218)
			{
				return this.GetSalesEtcApprData();
			}
			return "";
		}

		if( pcsCode == "{비매출상품권내역}"  ) {
			return this.GetNoneSaleGiftList();
		}

		if( pcsCode == "{비매출정산내역}" ) {
			return this.GetNoneSaleAccount();
		}

		if( pcsCode == "{사업자}" ) {
			csRetStr = pu.DllTransAtoA_Format( this.GetEnvXmlShopINFO( "BIZ_NO") , "BIZ_NO"  );
			return csRetStr;
		}

		if( pcsCode == "{상품권시재내역}"  ) {
			if(   this.m_csPrintCode   == 37 ) {
				return this.GetReissueAccountData( pcsCode );
			}
			return this.m_stSaleInfo.GIFT_DATA;
		}

		if( pcsCode == "{상품권정보}"  ) {
			return this.GetSalesGiftData();
		}
		if( pcsCode == "{상호}" ) {
			// //////////////////////////////////////////////////////////////////////
			// 2013-0222-JJM : 특수문자.
			// //////////////////////////////////////////////////////////////////////
			csValue = SHOP_INFO.SHOP_NM;
			csValue = csValue.replace( "&&", "&" );
			return csValue;
		}

		if( pcsCode == "{세액}"  ) {
			return this.m_stSaleInfo.VAT;
		}

		if( pcsCode == "{식권정보}"  ) {
			return this.GetSalesFoodData();
		}

		if( pcsCode == "{신용카드승인내역}" ) {
			if(  this.m_csPrintCode  == 37 ) {
				return this.GetReissueAccountData( pcsCode );
			}
			return this.GetCardApprData();
		}

		if( pcsCode == "{신용카드정산내역}" ) {
			if(  this.m_csPrintCode  == 37 ) {
				return this.GetReissueAccountData( pcsCode );
			}
			return this.GetRegiCardData();
		}

		if( pcsCode ==  "{일반할인내역}" ||  pcsCode ==  "{포장할인내역}" ||  pcsCode ==  "{쿠폰할인내역}"  ) {
				return this.GetSalesDcData( pcsCode );
		}
		if( pcsCode == "{재발행여부}"  ) {
			if( this.m_stSaleInfo.RE_PRINT == true) {
				csRetStr = "-재발행" ;
				if(  this.m_csPrintCode  == 41 ) {
					csRetStr = "[ 재발행 ]" ;
				}
			} else {
				csRetStr = "";
			}
			return csRetStr;
		}

		if( pcsCode == "{재출력}"  ) {
			if( this.m_stSaleInfo.RE_PRINT  &&  ! this.m_csView ) {
				let	csSystemDate = moment().format("YYYY-MM-DD HH:mm:ss");// g_clsUtil.DllGetDateSystem(
																			// "YYYY-MM-DD
																			// HH:MM:SS",
																			// csSystemDate
																			// );
				return "[영수증 재출력] "  + csSystemDate;
			}
			return "";
		}

		if( pcsCode == "{전화번호}"  ) {
			return this.GetEnvXmlShopINFO( "TEL_NO"  );
		}

		if( pcsCode == "{정산번호}"  ) {
			if(  this.m_csPrintCode  == 37 ) {
				csTemp = this.m_stSaleInfo.REGI_SEQ;
				if(  csTemp  != 0 ) {
					csTemp =  "%s 차".sprintf( csTemp  );
				}
			}
			else {
				// TODO %02d
				csTemp =  "%s%s%02d".sprintf( this.m_stSaleInfo.SALE_DATE, this.m_stSaleInfo.POS_NO, this.m_stSaleInfo.REGI_SEQ );
			}
			return csTemp;
		}
		if( pcsCode == "{정산시간}"  ) {
			return this.m_stSaleInfo.CLOSE_DT;
		}

		if( pcsCode == "{조회기간}"  ) {

			let	csDateRange = "";
			csDateRange =  "%s - %s".sprintf( this.m_stSaleInfo.FROM_DATE, this.m_stSaleInfo.TO_DATE  );
			return csDateRange;
		}

		if( pcsCode == "{조회포스번호}"  ) {
			let csLoadPosNo =  this.m_stSaleInfo.POS_NO.trim()  ;
			if( csLoadPosNo.length < 1 ) {
				csLoadPosNo = "전체"  ;
			}
			return csLoadPosNo;
		}
		if( pcsCode == "{주소}" ) {
			return this.GetEnvXmlShopINFO( "ADDRESS") ;
		}
		if( pcsCode ==  "{카드사별매출내역}" ) {
			if( this.m_csPrintCode  == 37) {
				return this.GetReissueAccountData( pcsCode );
			}
			return this.GetRegiCardTypeData();
		}

		// 2015-0610-Jane : 쿠폰사용내역 추가.
		if( pcsCode == "{쿠폰정보}")   {
			return this.GetSalesCouponData();
		}

		if( pcsCode == "{할인금액}"  ) {
			return this.m_stSaleInfo.TOT_DC_AMT;
		}

		if( pcsCode == "{할인매출내역}" ) {
			if(  this.m_csPrintCode  == 37 ) {
				return this.GetReissueAccountData( pcsCode );
			}
			return this.m_stSaleInfo.DC_DATA;
		}

		if( pcsCode == "{합계금액}" ) {
			var vsRetData = "";
			if(orderInfo.POS_ODHDR_T != undefined) {
				if(!!orderInfo.POS_ODHDR_T.CUP_DEPOSIT_AMT){ // 1회용 보증금 금액이 존재하면
					//vsRetData += pu.GetMarkString ( "상 품  합 계", orderInfo.POS_ODHDR_T.TOT_SALE_UPRC_ORG, 20, 22 ); // 상품 합계 금액
					vsRetData += pu.GetMarkString ( "상 품  합 계", String(Number(orderInfo.POS_ODHDR_T.TOT_SALE_AMT)-Number(orderInfo.POS_ODHDR_T.CUP_DEPOSIT_AMT)) , 20, 22 ); // 상품 합계 금액
					vsRetData += "\r\n";
					vsRetData += pu.GetMarkString ( "보 증  금 컵", orderInfo.POS_ODHDR_T.CUP_DEPOSIT_AMT, 20, 22 ); // 보증금컵 합계금액
					vsRetData += "\r\n";
					vsRetData += this.m_stSaleInfo.TOTAL_AMT; // 합계금액
				}else{ // 1회용 보증금 금액이 존재하지 않는다면 합계금액만 리턴
					vsRetData += this.m_stSaleInfo.TOTAL_AMT;
				}
			} else {
				vsRetData += this.m_stSaleInfo.TOTAL_AMT;
			}
			
			return vsRetData;
		}

		if( pcsCode == "{현금시재입력내역}"  ) {
			if(  this.m_csPrintCode  == 37 ) {
				return this.GetReissueAccountData( pcsCode );
			}
			return this.m_stSaleInfo.CASH_DATA;
		}

		if( pcsCode == "{현금영수증}"  ) {
			if( this.m_csPrintCode == "21"  )	{
				if( this.m_stSaleInfo.BILL_NO.length != LEN_DEF_4 ) {
					return this.GetNoneSalesCashData();
				}
				return this.GetSalesCashData();
			}
			if( this.m_csPrintCode == "14"  )	{
				return this.GetNoneSalesCashData();
			}
			// /////////////////////////////////////////////////////////////////////////////
			// 영수증출력구분 0: 일반영수증출력 1:개별영수증출력
			// 2:영수증출력안함(고객용/현금영수증 출력) 3:영수증출력안함(전체)
			// /////////////////////////////////////////////////////////////////////////////
			if( pu.parseInt( this.GetEnvXmlShopENV( 524 ) ) == 0 || pu.parseInt( this.GetEnvXmlShopENV( 524 ) ) == 3 ) {	// 2020-0220-oh,il
				return this.GetSalesCashData();
			}
			return "";
		}
		if( pcsCode == "{현금정산액}" ) {
			if(  this.m_csPrintCode  == 37 ) {
				return this.GetReissueAccountData( pcsCode );
			}
			return this.m_stSaleInfo.csCashRegiData;
		}

		if( pcsCode == "{회원정보}"  ) {
			return this.GetSalesCustData();
		}

		if( pcsCode == "{회원포인트내역}"  ) {
			if(  this.m_csPrintCode   == 37 ) {
				return this.GetReissueAccountData( pcsCode );
			}
			return this.GetRegiCustData();
		}

		if( pcsCode.substring(0, 3 ) == "{:C"  ) {
			let snLen = 0;
			snLen =  parseInt( pcsCode.substr( 3, 2   ) );
			let r = pu.CPad( pu.AlignText( pcsCode ), snLen );
			return r;
		}
		if( pcsCode.substring(0, 3 ) == "{:L"  ) {
			let snLen = 0;
			snLen =  parseInt( pcsCode.substr( 3, 2   ) );
			let r = pu.RPad( pu.AlignText( pcsCode ), snLen );
			return r;
		}
		if( pcsCode.substring(0, 3 ) == "{:R"  ) {
			let snLen = 0;
			snLen =  parseInt( pcsCode.substr( 3, 2   ) );
			let r = pu.LPad( pu.AlignText( pcsCode ), snLen );
			return r;
		}
		
		if(pcsCode == "{음영}"){			
			csRetStr = pu.GetPRTDeviceCMD( "REVERSE_ON");
			return csRetStr;
		}
		
		if(pcsCode == "{음영일반}"){
			csRetStr = pu.GetPRTDeviceCMD( "REVERSE_OFF");
			return csRetStr;
		}
			
		if(pcsCode == "{K-주문형태}"){
			if( !pu.isEmpty( this.m_stSaleInfo.KITCHEN_MEMO ) ) {				
				if(this.m_stSaleInfo.KITCHEN_MEMO == "meal"){
					csRetStr += "먹고가기";
				}else if (this.m_stSaleInfo.KITCHEN_MEMO == "takeout"){
					csRetStr += "포장하기";
				}else if (this.m_stSaleInfo.KITCHEN_MEMO == "start"){
					csRetStr += "시작하기";
				}else if (this.m_stSaleInfo.KITCHEN_MEMO == "calculate"){
					csRetStr += "계산하기";
				}else if (this.m_stSaleInfo.KITCHEN_MEMO == "doOrder"){
					csRetStr += "주문하기";
				}else if (this.m_stSaleInfo.KITCHEN_MEMO == "nOrder"){
					csRetStr += "일반주문";
				}else if (this.m_stSaleInfo.KITCHEN_MEMO == "mOrder"){
					csRetStr += "회원주문";
				}else{
					csRetStr += this.m_stSaleInfo.KITCHEN_MEMO;
				}	
			}
			return csRetStr;	// 2009-0924-YBC
		}
		if( pcsCode == "{주방메모}"  ) {
			if( !pu.isEmpty( this.m_stSaleInfo.KITCHEN_MEMO ) ) {
				csRetStr  = "\r\n[주방메모] ";
				if(this.m_stSaleInfo.KITCHEN_MEMO == "meal"){
					csRetStr += "먹고가기";
				}else if (this.m_stSaleInfo.KITCHEN_MEMO == "takeout"){
					csRetStr += "포장하기";
				}else if (this.m_stSaleInfo.KITCHEN_MEMO == "start"){
					csRetStr += "시작하기";
				}else if (this.m_stSaleInfo.KITCHEN_MEMO == "calculate"){
					csRetStr += "계산하기";
				}else if (this.m_stSaleInfo.KITCHEN_MEMO == "doOrder"){
					csRetStr += "주문하기";
				}else if (this.m_stSaleInfo.KITCHEN_MEMO == "nOrder"){
					csRetStr += "일반주문";
				}else if (this.m_stSaleInfo.KITCHEN_MEMO == "mOrder"){
					csRetStr += "회원주문";
				}else{
					csRetStr += this.m_stSaleInfo.KITCHEN_MEMO;
				}				
			}
			return csRetStr;	// 2009-0924-YBC
		}
		if( pcsCode == "{BARCODE}" )
		{
			let inPrtNo  = pu.parseInt ( this.m_stSaleInfo.PRT_NO );	// 2009-0917-YBC
			util.logDebug( "{BARCODE} === " );
			if( this.m_csView )
				return "";
			else
			{
				var szBarCode 	 = "";
				var szBarCodeExt = "";

				var nShopEnv = this.GetEnvXmlShopENV( 282 );				
				if( nShopEnv == "5" || nShopEnv == "7" ) // 5: 커피에반하다 , 7: 알다방
				{
					szBarCodeExt += gShopCd;					// 매장코드
					szBarCodeExt += this.m_stSaleInfo.ORDER_NO;	// 주문번호
				}
				
				szBarCode += this.m_stSaleInfo.SALE_DATE; 		// 날짜
				szBarCode += this.m_stSaleInfo.POS_NO;			// POS 번호
				szBarCode += this.m_stSaleInfo.BILL_NO;			// 영수증번호
				
				util.logDebug( "Barcode val: " + szBarCode );
				return g_clsPrinter[inPrtNo] = this.GetPRTCmd_BARCODE( szBarCode, szBarCodeExt );	// 2009-0917-YBC : g_clsPrinter ->g_clsPrinter[inPrtNo] 변경.
			}
		}

		if(pcsCode == "{재발행여부}") {
			if( this.m_stSaleInfo.RE_PRINT == true)
				csRetStr = "-재발행";
			else
				return csRetStr = "";
		}
		
		if( pcsCode ==  "{진동벨번호}"  ) {
			var pagmsOption = gfn_SQLiteSQLProcess(sqlQuery.selectPagmsOption, [gShopCd, gPosNo]).Data;
			util.logInfo("### app.commmon pagmsOption >>> " + JSON.stringify(pagmsOption));
			
			if (!!pagmsOption && pagmsOption.length > 0) {
				if(pagmsOption[0].PAG_TYPE_FG == "51") {
					//{진동벨번호} 진동벨 51이고 진동벨번호 출력이 있는경우에만 영수증에 3자리로 출력
					util.logInfo("### 영수증 진동벨번호 3자리 출력 ");
					csRetStr = this.m_stSaleInfo.ORDER_NO.substr(1);			
					return csRetStr;
				} else {
					util.logInfo("### 영수증 진동벨번호 4자리 출력 ");
					csRetStr = this.m_stSaleInfo.ORDER_NO;			
					return csRetStr;
				}
			}
		}
		
		if( pcsCode ==  "{호출번호}"  ) {
			//{호출번호} 영수증에 3자리로 출력
			util.logInfo("### 호출번호 영수증 3자리 출력 ");
			csRetStr = this.m_stSaleInfo.ORDER_NO.substr(1);			
			return csRetStr;
		}
		
		throw "미등록 키워드 [" + pcsCode + "]";
		// //////////////////////////////////////////////////////////
		return "";
	}


	this.GetPRTCmd_BARCODE = function( pszBarCode, pszBarCodeExt )
	{
		util.logInfo("_____ 바코드 생성함수 GetPRTCmd_BARCODE : pszBarCode == > " + pszBarCode);
		util.logInfo("_____ 바코드 생성함수 GetPRTCmd_BARCODE : pszBarCodeExt == > " + pszBarCodeExt);
		var		csPrtCmd   	= "";
		var 	csDispText 	= "";
		var		szCodeExt	= "";
		
		var 	lnBillNo   	= 0;
		var 	lnGabageNo	= 0;
		
		var 	strLeft		= "";
		var 	strMid 		= "";
		var 	strMidEx	= "";
		var 	strSMid		= "";
		var 	strFMid		= "";
		
		var strBarcodeE = "";
		if( util.isEmptyStr(pszBarCodeExt) )
		{	// ShopEnv 정보가 5가 아닐 경우
			strLeft		= pu.Left( pszBarCode, 8 );
			strMid  	= pu.Mid( pszBarCode, 8, 2 );
			csDispText	= strLeft + "/" + strMid + "/";

			var	strRight= pu.Right( pszBarCode, 4 );
			lnBillNo	= 10000 - parseInt( strRight ) + 9;
			lnGabageNo	= parseInt( lnBillNo / 9 ) + 5 ;
			csDispText += pu.DllTransLtoA( lnBillNo	) + "/" ;
			csDispText += pu.DllTransLtoA( lnGabageNo) + "/" ;
			
			strFMid 	= pu.Mid( pszBarCode, 12, 2 );
			strSMid 	= pu.Mid( pszBarCode, 10, 2 );
			csDispText += strFMid + strSMid;
			
			util.logDebug( "pszBarCode.length : " + pszBarCode.length );
			util.logInfo("_____영수증 바코드 생성된 번호 if문 ====== > " + pszBarCode);
			csPrtCmd = "%s%s%c%s%s%s%s%s".sprintf( 	pu.GetPRTDeviceCMD("CT_ALIGN"), 
													pu.GetPRTDeviceCMD("BARCODE_S"), 
													pszBarCode.length+2, 
													pu.GetPRTDeviceCMD("BARCODE_E"), 
													pszBarCode,
													csDispText,
													pu.GetPRTDeviceCMD("FEED"), 
													pu.GetPRTDeviceCMD("LF_ALIGN")
												 );
		}
		else
		{	// ShopEnv 정보가 5일 경우
			strLeft		= pu.Mid( pszBarCode, 3, 5  );
			strMid  	= pu.Mid( pszBarCode, 9, 1  ); // 포스번호 1자리 ex) 2
// gsSpecialShopFlag ='7';
			if(gsSpecialShopFlag == "7" || gsSpecialShopFlag == "9"){ // 알다방인 경우에 주문번호로 보낸다.
				strSMid 	= pu.Mid( pszBarCodeExt, 6, 4 ); // 주문번호 네자리 ex) 1025
				strBarcodeE = pu.GetPRTDeviceCMD("BARCODE_ENG"); // 앞에 a 뒤에 z를 붙여야 해서 영문자가 인식되는 해시코드로 변경				
			}else{ // 알다방이 아닌경우
				strSMid 	= pu.Mid( pszBarCode, 10, 4 ); // 영수증번호 네자리 ex) 0025
				strBarcodeE = pu.GetPRTDeviceCMD("BARCODE_E"); // 숫자코드만 인식하는 해시코드
			}
			csDispText	= strLeft + "/" + strMid + "/";
			
			strMidEx   += pu.Left( pszBarCodeExt, 6 );
			szCodeExt  += strMidEx;
			szCodeExt  += "/" + strSMid; 
									
			csDispText += szCodeExt;
			
			// 일자(5자리) + 포스번호(1자리) + 매장코드(6자리) + 영수증번호(4자리)
			// 알다방인 경우 일자(5자리) + 포스번호(1자리) + 매장코드(6자리) + 주문번호(4자리)
			if(gsSpecialShopFlag == "7" || gsSpecialShopFlag == "9"){ // 알다방인 경우에 일자를 3자리로 바꾸고, 맨앞에 'a' 맨뒤에 'z'를 붙여서 보낸다.
				//pszBarCode  = strLeft + strMid + strMidEx + strSMid;
				pszBarCode  = "a"+ strLeft + strMid + strMidEx + strSMid + "z";
			}else{ // 알다방이 아닌경우
				pszBarCode  = strLeft + strMid + strMidEx + strSMid;
			}			
			
			util.logInfo("_____영수증 바코드 생성된 번호 else ====== > " + pszBarCode);
			util.logDebug( "pszBarCode.length : " + pszBarCode.length );
			csPrtCmd = "%s%s%c%s%s%s%s%s".sprintf( 	pu.GetPRTDeviceCMD("CT_ALIGN"),
													/*pu.GetPRTDeviceCMD("CT_ALIGN_HV2X"),*/  
													pu.GetPRTDeviceCMD("BARCODE_B"), 
													pszBarCode.length+2, 
													strBarcodeE, 
													pszBarCode, // pszBarCode
													csDispText,
													pu.GetPRTDeviceCMD("FEED"), 
													pu.GetPRTDeviceCMD("LF_ALIGN")
												 );	
		}
				
		
		
		util.logDebug( "GetPRTCmd_BARCODE : " + csPrtCmd );
		
		return csPrtCmd;
	}
	
	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : GetSaleListData. : 매출현황 출력용.
	// =============================================================================
	// PARAMETER 1 : pstSaleList : .
	// 2 : pcsPrintCode : .
	// 3 : pblView : .
	// RETURN VALUE : CString : .
	// PROGRAMMER : CWS-2009-02-18 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.GetSaleListData = function( pstSaleList,  pcsPrintCode,  pblView ) {
		util.logInfo("*** GetSaleListData START ***");
		let szResult = "";
		let csTemp	 = "";

		this.m_stSaleInfo	= pstSaleList;
		this.m_csPrintCode	= pcsPrintCode;
		this.m_csView		= false;

		csTemp = this.GetPrintSource( this.m_csPrintCode );

		szResult = this.PrintCodeMatch( csTemp );

		return szResult;
	}


	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : GetSalesData.
	// =============================================================================
	// PARAMETER 1 : pinSelectType : 0:매출 1:중간계산서용
	// RETURN VALUE : bool : .
	// PROGRAMMER : CWS-2009-02-18 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.GetSalesData = function(  pinSelectType /* = 0 default 의미. */ )  {
		// /////////////////////////////////////////////////////////////////////
		// 영수증 발행 질의 사용.
		// /////////////////////////////////////////////////////////////////////
		util.logInfo("GetSalesData function call ");
		if( this.blReceiptIssueFg == false ) {			
			return false;
		}

		if (pu.isEmpty(pinSelectType)) {
			pinSelectType = 0;
		}
		util.logInfo('pinSelectType : ' + pinSelectType);

		let csQrySql    = "" ;
		let csTemp	    = "" ;
		let csData	    = "" ;
		let csExpPayAmt = "" ;
		let csQryHead   = "" ;		// 2010-0310-YBC
		let csQryTail   = "" ;		// 2010-0310-YBC
		let csDcList    = "" ;		// 2010-0120-YBC
		let csValue     = "" ;

		let	inTaxTypeFg	   = pu.parseInt( this.GetEnvXmlShopENV( 128 ) ) ;			// 판매가-부가세포함여부
																					// 0:별도
																					// 1:포함
		let	inSvcTipTypeFg = pu.parseInt( this.GetEnvXmlShopENV( 129 ) ) ;			// 판매가-봉사료포함여부
																					// 0:별도
																					// 1:포함

		let lnCashAmt     = 0;				// 2009-1228-YBC
		let lnCashBillAmt = 0;				// 2009-1228-YBC
		let lnGstPayAmt   = 0;				// 2010-0423-YBC
		let lnDcmSaleAmt  = 0;
		let lnVatAmt      = 0;
		let lnSvcTipAmt   = 0;

		let lnCardAmt     = 0;				// 2014-1124-Jane
		let lnCashICAmt   = 0;				// 2014-1124-Jane

		let bCnt = 0;
		let params = [];
		
		let sqlObj = _sql.GetSalesDataSQL(this.m_stSaleInfo , pinSelectType);
		util.logInfo("print this.GetSalesData SSL_TRHDR_T SQL PARAM == > " + sqlObj.params);
		let db_result = gfn_SQLiteSQLProcess(sqlObj.sql  , sqlObj.params ); // SSL_TRHDR_T 테이블에서 주문한 정보 가져온다.
		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}

		// //////////////////////////////////////////////////////////////////////////
		// 2012-1107-JJM : 2인치 전표 출력 처리.
		// //////////////////////////////////////////////////////////////////////////
		let rows = db_result.Data ;
		for ( let i = 0 ; i < rows.length ; i++ ) {
			let row = rows[i];
			if( pinSelectType == 0 ) {

				this.m_stSaleInfo.EMP_NO       = row.EMP_NO ;
				this.m_stSaleInfo.EMP_NM       = row.EMP_NM ;
				this.m_stSaleInfo.INS_DT       = pu.DllTransAtoA_Format( row.PAY_OUT_DT  ,  "YYYY-MM-DD HH:MM:SS" );
				this.m_stSaleInfo.csDispTableNm = row[ "TBL_NM"  ] ; // 테이블 그룹 - 테이블 명
				this.m_stSaleInfo.csTableGroupNm = row[ "TG_NM"  ] ; // 테이블 그룹 명
			}

			if( this.g_inPaperTypeFg == 0 ) {
				if( row[ "NO_VAT_SALE_AMT" ] != 0 ) {
					this.m_stSaleInfo.dnNoVatSaleAmt = row[ "NO_VAT_SALE_AMT" ];
					this.m_stSaleInfo.VAT          = pu.GetMarkString_02( "   *면세물품가액" , row[ "NO_VAT_SALE_AMT"  ], 16, 14 ) + "\r\n";
				}
				else {
					this.m_stSaleInfo.dnNoVatSaleAmt = 0;
				}

				this.m_stSaleInfo.dnVatSaleAmt = row[ "VAT_SALE_AMT" ];
				this.m_stSaleInfo.dnVatAmt     = row[ "VAT_AMT" ];

				this.m_stSaleInfo.VAT += pu.GetMarkString_02( "    과세물품가액", row[ "VAT_SALE_AMT" ], 16, 14 ) + "\r\n";
				this.m_stSaleInfo.VAT += pu.GetMarkString_02( "    부   가   세", row[ "VAT_AMT" ], 16, 14 );

				if(  pu.parseInt( this.GetEnvXmlShopENV( 128 ) ) == 0 ) {
					let dnTemp = pu.parseInt( this.m_stSaleInfo.dnNoVatSaleAmt ) + pu.parseInt( this.m_stSaleInfo.dnVatSaleAmt)  + pu.parseInt( this.m_stSaleInfo.dnVatAmt ) ;
					this.m_stSaleInfo.VAT += "\r\n" + pu.GetMarkString( "    소        계", dnTemp, 16, 14 );
				}

				this.m_stSaleInfo.TOTAL_AMT = pu.GetMarkString ( "합 계  금 액", row[ "TOT_SALE_AMT" ] ,14, 18 );

				if( row[ "TOT_DC_AMT" ] != 0 ) {
					this.m_stSaleInfo.TOT_DC_AMT = pu.GetMarkString( "할 인  금 액", row[ "TOT_DC_AMT" ], 14, 18 );

					if( row[ "DC_GEN_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "          일반할인", row[ "DC_GEN_AMT"  ] ,18, 14 ) + "\r\n"; }
					if( row[ "DC_SVC_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "          서 비 스", row[ "DC_SVC_AMT"  ], 18, 14 ) + "\r\n"; }
					if( row[ "DC_PCD_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "          제휴할인", row[ "DC_PCD_AMT"  ], 18, 14 ) + "\r\n"; }
					if( row[ "DC_CPN_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "          쿠폰할인", row[ "DC_CPN_AMT"  ], 18, 14 ) + "\r\n"; }
					if( row[ "DC_CST_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "          회원할인", row[ "DC_CST_AMT"  ], 18, 14 ) + "\r\n"; }
					if( row[ "DC_TFD_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "          식권할인", row[ "DC_TFD_AMT"  ], 18, 14 ) + "\r\n"; }
					if( row[ "DC_PRM_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "      프로모션할인", row[ "DC_PRM_AMT"  ], 18, 14 ) + "\r\n"; }
					if( row[ "DC_CRD_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "      신용카드할인", row[ "DC_CRD_AMT"  ], 18, 14 ) + "\r\n"; }
					if( row[ "DC_PACK_AMT" ] != 0 ) { csDcList += pu.GetMarkString_02( "          포장할인", row[ "DC_PACK_AMT" ] ,18, 14 ) + "\r\n"; }
					if( row[ "TOT_ETC_AMT" ] != 0 ) { csDcList += pu.GetMarkString_02( "        기타에누리", row[ "TOT_ETC_AMT" ] ,18, 14 ) + "\r\n"; }

					if( csDcList.length > 1 ) {
						this.m_stSaleInfo.TOT_DC_AMT += "\r\n--------------------------------\r\n ** 할인내역 :";
						this.m_stSaleInfo.TOT_DC_AMT += csDcList.substr( 14, csDcList.length - 14 - 12 );
					}
				} else {
					this.m_stSaleInfo.TOT_DC_AMT = "";
				}

				// //////////////////////////////////////////////////////////////////////////////////
				// 2009-1004-YBC : 부가세-별도 / 봉사료 설정 처리.
				// //////////////////////////////////////////////////////////////////////////////////
				lnDcmSaleAmt = row[ "DCM_SALE_AMT" ];
				lnVatAmt     = row[ "VAT_AMT"      ];
				lnSvcTipAmt  = row[ "SVC_TIP_AMT"  ];

				if( inTaxTypeFg	== 0 ) {
					lnDcmSaleAmt += lnVatAmt; // 부가세-별도
				}

				if( inSvcTipTypeFg == 0 ) {
					lnDcmSaleAmt += lnSvcTipAmt; // 봉사료-별도
				}

				csExpPayAmt = lnDcmSaleAmt ;

				if( lnSvcTipAmt != 0 ) {
					this.m_stSaleInfo.SVC_TIP_AMT  = pu.GetMarkString_02( "    봉   사   료" , row[ "SVC_TIP_AMT" ], 16, 14 );
					this.m_stSaleInfo.SVC_TIP_AMT += "\r\n--------------------------------\r\n";
				}

				// 2018-11-15 KLC : 영수증 간소화 처리
				this.m_stSaleInfo.EXP_PAY_AMT += pu.GetMarkString ( "받 을  금 액" , csExpPayAmt, 14, 18 );

				// //////////////////////////////////////////////////////////////////////
				// 받은금액이 0 이 아닐때만 표기한다.
				// //////////////////////////////////////////////////////////////////////
				lnGstPayAmt = row[ "GST_PAY_AMT" ];

				if( lnGstPayAmt != 0 ) {
					// //////////////////////////////////////////////////////////////////
					// 받은금액 표기 처리 ( 중간계산서에서 요청 )
					// //////////////////////////////////////////////////////////////////
					// 2018-11-15 KLC : 영수증 간소화 처리
					this.m_stSaleInfo.GST_PAY_AMT += pu.GetMarkString( "받 은  금 액" , row[ "GST_PAY_AMT" ] , 14, 18 );
				}

				if( pinSelectType == 0 ) {
					csData = row[ "RET_PAY_AMT" ];
					if(   csData  != 0 ) {
						this.m_stSaleInfo.RET_PAY_AMT  = pu.GetPRTDeviceCMD( "FEED"  );		// 2013-0218-JJM
																							// : .
						this.m_stSaleInfo.RET_PAY_AMT += pu.GetPRTDeviceCMD( "V2X"   );
						this.m_stSaleInfo.RET_PAY_AMT += pu.GetMarkString( "거 스  름 돈", csData, 14, 18 );
						this.m_stSaleInfo.RET_PAY_AMT += pu.GetPRTDeviceCMD( "NORM"  );
					} else {
						this.m_stSaleInfo.RET_PAY_AMT = "";
					}

					// //////////////////////////////////////////////////////////////////
					// 기존 현금으로만 표기하던것은 "현금","현금영수증" 분할처리.
					// //////////////////////////////////////////////////////////////////
					lnCashBillAmt = row[ "CASH_BILL_AMT" ];	// 현금영수증액
					lnCashAmt	  = row[ "CASH_AMT"      ];	// 단순현금 + 현금영수증액
					lnCashAmt    -= lnCashBillAmt;

					if( lnCashBillAmt != 0 ) {
						csData = lnCashBillAmt +"";
						csTemp = "%s\r\n".sprintf( pu.GetMarkString( "현금영수증" , csData, 14, 18 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					if( lnCashAmt != 0 ) {
						csData = lnCashAmt +"";
						csTemp = "%s\r\n".sprintf( pu.GetMarkString( "현      금", csData, 14, 18 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					// //////////////////////////////////////////////////////////////////
					// 2014-1124-Jane : 일반신용카드와 현금IC카드 분리
					// //////////////////////////////////////////////////////////////////
					lnCardAmt    = row[ "CRD_CARD_AMT" ];		// 신용카드금액
					lnCashICAmt	 = row[ "CASH_IC_AMT" ];		// 현금IC금액

					if ( pu.isEmpty( lnCardAmt ) ) {
						lnCashICAmt = "0";
					}

					if ( pu.isEmpty( lnCashICAmt ) ) {
						lnCashICAmt = "0";
					}

					lnCashICAmt = parseInt( lnCashICAmt );
					lnCardAmt   = parseInt( lnCardAmt );

					lnCardAmt    -= lnCashICAmt;

					if( lnCardAmt != 0 ) {
						csData = lnCardAmt +"";
						csTemp =  "%s\r\n".sprintf( pu.GetMarkString( "신용  카드", csData, 14, 18 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}
					if( lnCashICAmt != 0 ) {

						csData =   lnCashICAmt  + "" ;
						csTemp = "%s\r\n".sprintf( pu.GetMarkString( "현금IC카드", csData, 14, 18 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "WES_AMT"];
					if(   csData  != 0 ) {
						csTemp = "%s\r\n".sprintf( pu.GetMarkString( "외      상" , csData, 14, 18 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "TK_GFT_AMT"];
					if(  csData  != 0 ) {
						csTemp = "%s\r\n".sprintf( pu.GetMarkString( "상  품  권" , csData, 14, 18 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "CST_POINT_AMT"];
					if(  csData  != 0 ) {
						csTemp =  "%s\r\n".sprintf( pu.GetMarkString( (SHOP_INFO.POINT_FG == "M"  ? "회원마일리지"  : "회원스탬프금액"), csData, 14, 18  ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "JCD_CARD_AMT"];
					if(  csData  != 0 ) {
						csTemp =  "%s\r\n".sprintf( pu.GetMarkString( "제휴  카드" , csData, 14, 18 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "RFC_AMT"];
					if( csData   != 0 ) {
						csTemp = "%s\r\n".sprintf( pu.GetMarkString( "사원  카드", csData, 14, 18 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "TK_FOD_AMT"];
					if( csData  != 0 ) {
						csTemp =  "%s\r\n".sprintf( pu.GetMarkString( "식      권" , csData, 14, 18 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "ETC_APPR_AMT"];
					if(  csData  != 0 ) {
						csTemp =  "%s\r\n".sprintf( pu.GetMarkString( "기      타" , csData, 14, 18 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					if( row[ "DCM_SALE_AMT" ] < 0 ) {
						this.m_stSaleInfo.TITLE = "[반품영수증]";
					}

					// /////////////////////////////////////////////////////////////////////////////
					// 해당 영수증 출력에 타이틀이 없는 경우 타이틀 세팅.
					// /////////////////////////////////////////////////////////////////////////////
					if( this.m_stSaleInfo.TITLE.length < 1 ) {
						this.m_stSaleInfo.TITLE = "[ 영 수 증 ]" ;
					}
				}
			} else {
				if( row[ "NO_VAT_SALE_AMT" ] != "0" ) {
					this.m_stSaleInfo.dnNoVatSaleAmt = row[ "NO_VAT_SALE_AMT" ];
					this.m_stSaleInfo.VAT          = pu.GetMarkString_02( "        *부가세 면세물품가액" , row[ "NO_VAT_SALE_AMT" ], 20, 14 ) + "\r\n";
				}
				else {
					this.m_stSaleInfo.dnNoVatSaleAmt = 0;
				}

				this.m_stSaleInfo.dnVatSaleAmt = row[ "VAT_SALE_AMT" ];
				this.m_stSaleInfo.dnVatAmt     = row[ "VAT_AMT" ];

				// 2013-1231-Jane : 식의-부가세 결제금액별 계산방식 추가.
				// 영수증이 아니고, 부가세포함옵션사용일때, 결제금액별 부가세 계산 출력.
				if( pu.parseInt(this.GetEnvXmlShopENV( 807 ))  == 1 &&  this.m_csPrintCode != "01" && pu.parseInt(this.GetEnvXmlShopENV( 128 )) == 1 )  {
					let dnTotalAmt = 0;
					let csTemp = "" ;
					dnTotalAmt = this.m_stSaleInfo.dnVatSaleAmt + this.m_stSaleInfo.dnVatAmt;

					csTemp =  "%s".sprintf( dnTotalAmt - this.DllGetFloor(dnTotalAmt/11) );
					this.m_stSaleInfo.VAT += pu.GetMarkString_02( "         부가세 과세물품가액" , csTemp, 20, 14 ) + "\r\n" ;
					csTemp = "%s".sprintf( this.DllGetFloor(dnTotalAmt/11) );
					this.m_stSaleInfo.VAT += pu.GetMarkString_02( "         부       가      세" , csTemp, 20, 14 );
				}
				else
				{
					this.m_stSaleInfo.VAT += pu.GetMarkString_02( "         부가세 과세물품가액", row[ "VAT_SALE_AMT" ], 20, 14 ) + "\r\n" ;
					this.m_stSaleInfo.VAT += pu.GetMarkString_02( "         부       가      세", row[ "VAT_AMT"      ], 20, 14 );
				}

				if( pu.parseInt(this.GetEnvXmlShopENV( 128 ) ) == 0 ) {
					let dnTemp = pu.parseInt( this.m_stSaleInfo.dnNoVatSaleAmt) + pu.parseInt( this.m_stSaleInfo.dnVatSaleAmt) + pu.parseInt( this.m_stSaleInfo.dnVatAmt );
					this.m_stSaleInfo.VAT += "\r\n" + pu.GetMarkString( "         소               계" , dnTemp, 20, 14 );
				}
				this.m_stSaleInfo.TOTAL_AMT = pu.GetMarkString ( "합 계  금 액", row[ "TOT_SALE_AMT" ], 20, 22 );

				if( row[ "TOT_DC_AMT" ] != 0 ) {
					this.m_stSaleInfo.TOT_DC_AMT = pu.GetMarkString( "할 인  금 액" , row[ "TOT_DC_AMT" ], 20, 22 );

					if( row[ "DC_GEN_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "                    일반할인", row[ "DC_GEN_AMT"  ], 28, 14 ) + "\r\n" ;}
					if( row[ "DC_SVC_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "                    서 비 스", row[ "DC_SVC_AMT"  ], 28, 14 ) + "\r\n"; }
					if( row[ "DC_PCD_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "                    제휴할인", row[ "DC_PCD_AMT"  ], 28, 14 ) + "\r\n"; }
					if( row[ "DC_CPN_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "                    쿠폰할인", row[ "DC_CPN_AMT"  ], 28, 14 ) + "\r\n"; }
					if( row[ "DC_CST_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "                    회원할인", row[ "DC_CST_AMT"  ], 28, 14 ) + "\r\n"; }
					if( row[ "DC_TFD_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "                    식권할인", row[ "DC_TFD_AMT"  ], 28, 14 ) + "\r\n"; }
					if( row[ "DC_PRM_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "                프로모션할인", row[ "DC_PRM_AMT"  ], 28, 14 ) + "\r\n"; }
					if( row[ "DC_CRD_AMT"  ] != 0 ) { csDcList += pu.GetMarkString_02( "                신용카드할인", row[ "DC_CRD_AMT"  ], 28, 14 ) + "\r\n"; }
					if( row[ "DC_PACK_AMT" ] != 0 ) { csDcList += pu.GetMarkString_02( "                    포장할인", row[ "DC_PACK_AMT" ], 28, 14 ) + "\r\n"; }
					if( row[ "TOT_ETC_AMT" ] != 0 ) { csDcList += pu.GetMarkString_02( "                  기타에누리", row[ "TOT_ETC_AMT" ], 28, 14 ) + "\r\n"; }
					if( csDcList.length > 1 ) {
						this.m_stSaleInfo.TOT_DC_AMT += "\r\n------------------------------------------\r\n ** 할인내역 :";
						// cpp 코드 this.m_stSaleInfo.TOT_DC_AMT += csDcList.Mid(
						// LEN_DEF_14, csDcList.length - LEN_DEF_14 - LEN_DEF_2
						// );
						this.m_stSaleInfo.TOT_DC_AMT += csDcList.substring( 14, csDcList.length - 14 - 2 );
					}
				} else {
					this.m_stSaleInfo.TOT_DC_AMT = "";
				}

				// //////////////////////////////////////////////////////////////////////////////////
				// 2009-1004-YBC : 부가세-별도 / 봉사료 설정 처리.
				// //////////////////////////////////////////////////////////////////////////////////

				lnDcmSaleAmt = pu.parseInt( row[ "DCM_SALE_AMT" ]);
				lnVatAmt     = pu.parseInt( row[ "VAT_AMT"      ]);
				lnSvcTipAmt  = pu.parseInt( row[ "SVC_TIP_AMT"  ]);
				util.logInfo("봉사료 : " +lnSvcTipAmt + " > row > " + row[ "SVC_TIP_AMT"  ] );
				if( inTaxTypeFg	== 0 ) {
					lnDcmSaleAmt += lnVatAmt; // 부가세-별도
				}

				if( inSvcTipTypeFg == 0 ) {
					lnDcmSaleAmt += lnSvcTipAmt; // 봉사료-별도
				}

				csExpPayAmt = lnDcmSaleAmt + "" ;

				if( lnSvcTipAmt != 0 ) {
					this.m_stSaleInfo.SVC_TIP_AMT = pu.GetMarkString_02( "         봉       사      료" , row[ "SVC_TIP_AMT" ], 20, 14 );
					this.m_stSaleInfo.SVC_TIP_AMT += "\r\n------------------------------------------\r\n";
				}
				// 2018-11-15 KLC : 영수증 간소화 처리
				this.m_stSaleInfo.EXP_PAY_AMT = pu.GetMarkString ( "받 을  금 액" , csExpPayAmt, 20, 22 );

				// //////////////////////////////////////////////////////////////////////
				// 받은금액이 0 이 아닐때만 표기한다.
				// //////////////////////////////////////////////////////////////////////
				lnGstPayAmt = pu.parseInt( row[ "GST_PAY_AMT" ] ) ;

				if( lnGstPayAmt != 0 ) {
					// //////////////////////////////////////////////////////////////////
					// 받은금액 표기 처리 ( 중간계산서에서 요청 )
					// //////////////////////////////////////////////////////////////////
					// 2018-11-15 KLC : 영수증 간소화 처리
					this.m_stSaleInfo.GST_PAY_AMT = pu.GetMarkString( "받 은  금 액" , row[ "GST_PAY_AMT" ] , 20, 22 );
				}

				if( pinSelectType == 0 ) {
					csData = row[ "RET_PAY_AMT"];
					if( csData != 0  ) {
						this.m_stSaleInfo.RET_PAY_AMT  = pu.GetPRTDeviceCMD( "FEED" );		// 2013-0218-JJM
																							// : .
						this.m_stSaleInfo.RET_PAY_AMT += pu.GetPRTDeviceCMD( "V2X" );
						this.m_stSaleInfo.RET_PAY_AMT += pu.GetMarkString( "거 스  름 돈", csData, 20, 22 );
						this.m_stSaleInfo.RET_PAY_AMT += pu.GetPRTDeviceCMD( "NORM" );
					} else {
						this.m_stSaleInfo.RET_PAY_AMT = "";
					}

					// //////////////////////////////////////////////////////////////////
					// 기존 현금으로만 표기하던것은 "현금","현금영수증" 분할처리.
					// //////////////////////////////////////////////////////////////////
					lnCashBillAmt = row[ "CASH_BILL_AMT" ];	// 현금영수증액
					lnCashAmt	  = row[ "CASH_AMT"      ];	// 단순현금 + 현금영수증액
					lnCashAmt    -= lnCashBillAmt;

					if( lnCashBillAmt != 0 ) {
						csData = "" + lnCashBillAmt ;
						csTemp =  "%s\r\n".sprintf( pu.GetMarkString( "현금영수증" , csData, 20, 22 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					if( lnCashAmt != 0 ) {
						csData= ""+  lnCashAmt ;
						 csTemp = "%s\r\n".sprintf( pu.GetMarkString( "현      금" , csData, 20, 22 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}


					// //////////////////////////////////////////////////////////////////
					// 2014-1124-Jane : 일반신용카드와 현금IC카드 분리
					// //////////////////////////////////////////////////////////////////
					lnCardAmt    = row[ "CRD_CARD_AMT" ];		// 신용카드금액
					lnCashICAmt	 = row[ "CASH_IC_AMT"  ];		// 현금IC금액

					if ( pu.isEmpty( lnCashICAmt ) ) {
						lnCashICAmt = "0";
					}
					if ( pu.isEmpty( lnCashICAmt ) ) {
						lnCashICAmt = "0";
					}
					lnCashICAmt = parseInt( lnCashICAmt );
					lnCardAmt   = parseInt( lnCardAmt );

					lnCardAmt    -= lnCashICAmt;

					if( lnCardAmt != 0 ) {
						csData = ""  +  lnCardAmt ;
						csTemp =  "%s\r\n".sprintf( pu.GetMarkString( "신용  카드" , csData, 20, 22 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					if( lnCashICAmt != 0 ) {
						csData =  "" + lnCashICAmt ;
						csTemp = "%s\r\n".sprintf( pu.GetMarkString( "현금IC카드" , csData, 20, 22 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "WES_AMT"];
					if(   csData  != 0 ) {
						csTemp =  "%s\r\n".sprintf( pu.GetMarkString( "외      상", csData, 20, 22 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "TK_GFT_AMT"];
					if( csData   != 0 ) {
						csTemp = "%s\r\n".sprintf( pu.GetMarkString( "상  품  권", csData, 20, 22 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "CST_POINT_AMT"];
					if(  csData  != 0 ) {
						csTemp =  "%s\r\n".sprintf(  pu.GetMarkString( SHOP_INFO.POINT_FG == "M" ? "회원마일리지"  : "회원스탬프금액" , csData, 20, 22 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "JCD_CARD_AMT"];
					if( csData  != 0 ) {
						csTemp =  "%s\r\n".sprintf(pu.GetMarkString( "제휴  카드", csData, 20, 22 ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "RFC_AMT"];
					if(  csData  != 0 ) {
						csTemp =  "%s\r\n".sprintf( pu.GetMarkString( "사원  카드" , csData, 20, 22  ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "TK_FOD_AMT"];
					if(  csData  != 0 ) {
						csTemp = "%s\r\n".sprintf( pu.GetMarkString( "식      권" , csData, 20, 22  ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					csData = row[ "ETC_APPR_AMT" ];
					if(  csData  != 0 ) {
						csTemp =  "%s\r\n".sprintf( pu.GetMarkString( "기      타" , csData, 20, 22  ) );
						this.m_stSaleInfo.CASH_LIST += csTemp;
					}

					if( row[ "DCM_SALE_AMT" ] < 0 ) {
						this.m_stSaleInfo.TITLE = "[반품영수증]";
					}


					// /////////////////////////////////////////////////////////////////////////////
					// 해당 영수증 출력에 타이틀이 없는 경우 타이틀 세팅.
					// /////////////////////////////////////////////////////////////////////////////
					if( this.m_stSaleInfo.TITLE.length < 1 ) {
						this.m_stSaleInfo.TITLE = "[ 영 수 증 ]";
					}
				}
			}

			if( pinSelectType == 0 ) {
				this.m_stSaleInfo.csTravelCd     = row[ "TRAVEL_CD"       ];
				this.m_stSaleInfo.csTravelNm     = row[ "TRAVEL_NM"       ];
				this.m_stSaleInfo.dnPrePayCard   = row[ "PRE_PAY_CARD"    ];
				this.m_stSaleInfo.dnPrePayCash   = row[ "PRE_PAY_CASH"    ];
				this.m_stSaleInfo.csRsvNo        = row[ "RSV_NO"          ];
				this.m_stSaleInfo.csRsvUserNm    = row[ "RSV_USER_NM"     ];
				this.m_stSaleInfo.csRsvUserTelNo = row[ "RSV_USER_TEL_NO" ];
			}
			bCnt++;
		}

		if( bCnt > 0 ) {
			return true;
		}

		return false;
	}



	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : PrintCodeMatch.
	// =============================================================================
	// PARAMETER 1 : pcsContent : .
	// RETURN VALUE : CString : .
	// PROGRAMMER : CWS-2009-02-18 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.PrintCodeMatch = function( pcsContent, /** BOOL * */ pblRePrintFg /*
																			 * =
																			 * false
																			 */) {
		
		util.logInfo("*** PrintCodeMatch START ***");
		if( pu.isEmpty( pcsContent ) ) {
			return "";
		}
		
		$("#rex1").text("");
		$("#rex2").text("");

		let szResult = "";
		let	csTemp	 = "";
		let csCheck  = "";

		let szExpression = [];
		let mArrStr;

		szResult = pcsContent;
		try {
			// (\{[\:|/\:].*?\}) -> 영역구분
			// (\{[^\:|/\:].*?\}) -> 치환 대상
			$("#formDatas").html("<span>" + pcsContent + "</span>");
			let x1 = "";
			let mArr = pcsContent.match(  /(\{[^\:|/\:].*?\})/gm );
			szResult = this.PrintCodeMatchProcessing(mArr, szResult);
			
			// let mArr2 = szResult.match(  /(\{\:.*?\}(.*)\{[\/\:].*?\} )/gm );
			// let p1 = "(\{[\:|/\:].*?\})";
			// let p2 = "(\{[\/\:|/\:].*?\})";

			let mArr2 = szResult.match(  /((\{[\:|/\:].*?\})(.*)(\{[\/\:|/\:].*?\}))/gm );
			//util.logInfo('mArr' + JSON.stringify( mArr ));
			//util.logInfo('mArr2' + JSON.stringify( mArr2 ));
			$("#rex1").text(mArr);
			$("#rex2").text(mArr2);
			szResult = this.PrintCodeMatchProcessing(mArr2, szResult);
		} catch (e) {
			log.logError("PrintCodeMatch : " + e.toString());
		}
		return szResult;
	}


	this.x5 = "";
	this.PrintCodeMatchProcessing = function ( arr , szResult) {
		util.logInfo("*** PrintCodeMatchProcessing START ***");
		if ( pu.isEmpty(arr)) {
			return szResult;
		}
		arr.forEach(e => {
//debugger; //xbwing		
			let csTemp = e;
			// //////////////////////////////////////////////////////////
			// 재발행인 경우 전자서명 출력 안됨.
			// //////////////////////////////////////////////////////////
			try {
				let csCheck = this.GetPrintCodeData( csTemp  ) ; // 실제 데이터랑 매핑
				if ( csCheck == null || csCheck == undefined )
					csCheck = "";
				else if ( typeof csCheck == "string")
					;
				else if (csCheck == false ) //CLRF 값인 \r\n 이 false 와 같다로 처리된다.
					csCheck = "";

//				if ( csTemp.indexOf("상품리스트")!= -1 && typeof tizen != 'undefined' ) {
//					alert( 'product list : '+ csCheck)
//				}

				if(  pu.isEmpty( csCheck ) )  {  // if( csCheck.length <
														// 1 ) {
						szResult= szResult.replace( csTemp +"\n", ""  );
						szResult= szResult.replace( csTemp, ""  );
				} else {
					szResult = szResult.replace( csTemp, csCheck );
				}

				//util.logInfo('mArr reg\n' , e + "\n", csCheck);
				this.x5 += e + " > " + csCheck + "\n";
			} catch (ex) {
				util.logError("PrintCodeMatchProcessing == >csTemp, e "+ csTemp+", " + ex ) ;
				// 키워드 없을경우 해당 키워드 삭제.
				szResult= szResult.replace( csTemp +"\n", ""  );
				szResult= szResult.replace( csTemp, ""  );
				util.logError("PrintCodeMatchProcessing : " + ex.toString());
			}
		});
		return szResult;
	}

	this.GetApprSlipRePrint = function( pcsTemplate) {
		util.logInfo("*** GetApprSlipRePrint START ***");
		let csPrint = "";
		let sql = _sql.GetApprSlipRePrint_SQL(this.m_csPrintCode , this.m_stSaleInfo );
		let db_result = gfn_SQLiteSQLProcess(sql , []);

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}

		let rows = db_result.Data ;
		for ( let i = 0 ; i < rows.length ; i++ ) {
			let row = rows[i];
			this.m_stSaleInfo.csLineNo    = row ["LINE_NO" ];
			this.m_stSaleInfo.csLineSeqNo = row ["SEQ_NO"  ];
			this.m_stSaleInfo.csLineNoCut = "Y" ;

			csPrint += this.PrintCodeMatch( pcsTemplate, true );
		}
		return csPrint;
	}

	/**
	 * ************************************ Unit Test End
	 * *************************************
	 */

	this.GetPrintSource = function( parmCsCode ) {
		util.logInfo("*** GetPrintSource START ***");
		util.logInfo("*** 출력물 form data 조회 parmCsCode == > " + parmCsCode);
		util.logInfo("*** 출력물 form data 조회  shopCd == > " + gShopCd);
		let sql = ""
		    + "\n SELECT PRT_FORM           ".rtrim()
			+ "\n   FROM SCD_PRINT_T  	    ".rtrim()
			+ "\n  WHERE SHOP_CD      = ?   ".rtrim()
			+ "\n    AND PRT_CLS_CD   = ?   ".rtrim()
			;
		let params = [ gShopCd, parmCsCode ];
		let r = gfn_SQLiteSQLProcess(sql , params);
		if ( pu.isEmpty ( r )  || pu.isEmpty ( r.Data ) || r.Data.length == 0  ) {
			util.logInfo("*** 출력물 form data 조회 데이터 없음!!! ***");
			util.logInfo("*** 출력물 form data 조회 데이터 없음 sql == > " + sql);
			return "";
		}
		return r.Data[0].PRT_FORM ;
	}

	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : GetSalesCardCollectData.
	// =============================================================================
	// PARAMETER 1 : No : .
	// RETURN VALUE : CString : .
	// PROGRAMMER : CWS-2009-05-21 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.GetSalesCardCollectData = function ( pcsCode )  {
		util.logInfo("*** GetSalesCardCollectData START ***");

		let blMaskingFg = false;
		let blCorner	 = false;
		let blCornerRun = false;

		let bCnt		= 0; /** byte */
		let bCornerCnt	= 0; /** byte */

		let csResult	    = "" ;
		let csTempStr	    = "" ;
		let	csIssCrdCpNm    = "" ;
		let csCrdCpNm       = "" ;
		let csCrdCardNo     = "" ;
		let	csSaleYn        = "" ;
		let csValidTerm     = "" ;
		let	csLineTemp      = "" ;
		let csValue         = "" ;
		let csCornerBizNo	= "" ;
		let csCornerOwnerNm = "" ;
		let  csCornerCd      = "" ;
		let csCornerNm      = "" ;
		let  csLeftStr       = "" ;
		let  csRightStr      = "" ;

		let  blReducePrint           = false;

		let  dnTotApprAmt = 0;
		let  dnTotApprVat = 0;
		let  dnTotApprTip = 0;


		if ( !pu.isEmpty( pcsCode ) && pcsCode.substring(1,1) ==  "R" )  {
			blReducePrint = false;
		}


		blCorner = (pu.parseInt(this.GetEnvXmlShopENV( 114 )) +"") == "1" ;


		let  sqlObj  = _sql.GetSalesCardCollectDataSQL(this.m_stSaleInfo);

		let  db_result = gfn_SQLiteSQLProcess(sqlObj.csQrySql , sqlObj.params);
		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}


		let  csTemp = "";

		let  rows = db_result.Data;
		for ( let  i = 0 ; i < rows.length ; i++  ) {
			let  row = rows[i];

			if( bCnt > 0  &&  row[ "LINE_NO" ]  != csLineTemp ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += "--------------------------------\r\n";
				}
				else {
					csTemp += "------------------------------------------\r\n";
				}
				csTemp += pu.GetMarkString_04( "판 매 금 액:", dnTotApprAmt - dnTotApprVat - dnTotApprTip ) + ("\r\n");
				csTemp += pu.GetMarkString_04( "부 가 세 액:", dnTotApprVat                               ) + ("\r\n");
				csTemp += pu.GetMarkString_04( "봉 사 료 액:", dnTotApprTip                               ) + ("\r\n");
				csTemp += pu.GetMarkString_04( "합 계 금 액:", dnTotApprAmt                               ) + ("\r\n");

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += "--------------------------------\r\n";
				} else {
					csTemp += "------------------------------------------\r\n";
				}

				dnTotApprAmt = 0;
				dnTotApprVat = 0;
				dnTotApprTip = 0;
			}

			if(  row[ "LINE_NO" ]  != csLineTemp ) {
				if(  row[ ("SALE_YN") ]  == "Y"  ) {
					if( row[ ("UNION_PAY_FG") ] == ("4") ) {
						csSaleYn = ("현금IC승인");									// 2014-1124-Jane
																				// :
																				// 현금IC
																				// 추가.
					}
					else {
						csSaleYn = ("신용승인");
					}
				}
				else {
					if( row[ ("UNION_PAY_FG") ] == ("4") ) {
						csSaleYn = ("현금IC취소");									// 2014-1124-Jane
																				// :
																				// 현금IC
																				// 추가.
					}
					else {
						csSaleYn = ("신용취소");
					}
				}
				if( row[ ("SIGN_PAD_YN") ] == ("Y") ) {
					this.m_blSignPadUseFg = true;
				} else {
					this.m_blSignPadUseFg = false;
				}

				// 2016-0427 Antony.Choi : 별도 전표 출력 시 각각의 NoCVM Flag 확인
				if (row[ ("DDC_FLAG") ]  == ("N") )
				{
					this.m_stSaleInfo.stPrintData.NO_CVM_FLAG = true;
				}
				else
				{
					this.m_stSaleInfo.stPrintData.NO_CVM_FLAG = false;
				}

				csIssCrdCpNm = row[ ("ISS_CRDCP_NM") ];
				csCrdCpNm	 = row[ ("CRDCP_NM")     ];
				csCrdCardNo	 = row[ ("CRD_CARD_NO")  ];
				csValidTerm	 = row[ ("VALID_TERM")   ];

				if( this.g_inPaperTypeFg == 0 ) {
					csTempStr = "    *** %s정보[%d] ***\r\n".sprintf( csSaleYn, ++bCnt );
					csTemp += csTempStr;

					// 2014-0716-Jane : 임의등록 문구 변경
					if( row[ ("APPR_PROC_FG") ] == 2 ) {	// 단말기승인.
						csTemp += pu.BASE_PRINT[ "V2X" ] ;
						csTemp += pu.BASE_PRINT[ "REVERSE_ON" ];
						csTemp += ("    **  단 말 기 승인요망 **\r\n");
						csTemp += pu.BASE_PRINT[ "NORM" ];
						csTemp += pu.BASE_PRINT[ "REVERSE_OFF" ];
						csTemp += pu.BASE_PRINT[ "INIT" ];
					}
					else {
						if( row[ ("UNION_PAY_FG") ] == ("4") ) {		// 2014-1124-Jane
																		// :
																		// 현금IC카드
																		// 추가.
							csTemp += ("발급기관 ") + csIssCrdCpNm + ("\r\n");
						}
						else {
							// 2018-11-15 KLC : 영수증 간소화 처리
							if ( blReducePrint == true )
							{
								csTemp += ("카드/매입사 ") + csIssCrdCpNm + (" / ") + csCrdCpNm + ("\r\n");
							}else
							{
								csTemp += ("카드종류 ") + csIssCrdCpNm + ("\r\n");
							}
						}
					}
				}
				else
				{
					// 20190920-HJH BCQR 추가
					if( row[ ("CARD_IN_FG") ] == ("E") )
						csTempStr = "       *** %s정보[%d](BC-QR) ***\r\n".sprintf( csSaleYn, ++bCnt );
					else
						csTempStr=  "          *** %s정보[%d] ***\r\n".sprintf( csSaleYn, ++bCnt );
					csTemp += csTempStr;
					// 2014-0716-Jane : 임의등록 문구 변경
					if( row[ ("APPR_PROC_FG") ] == 2 ) {	// 단말기승인.
						csTemp += pu.BASE_PRINT[ "HV2X" ] ;
						csTemp += pu.BASE_PRINT[ "REVERSE_ON" ];
						csTemp += "** 단말기 승인요망 **\r\n";
						csTemp += pu.BASE_PRINT[ "NORM " ];
						csTemp += pu.BASE_PRINT[ "REVERSE_OFF" ];
						csTemp += pu.BASE_PRINT[ "INIT" ];
						// 2018-11-15 KLC : 영수증 간소화 처리
						if ( blReducePrint == true )
						{
							csTemp += ("[전표 매입사] ") + csCrdCpNm + ("\r\n");
						}
					}
					else {
						if( row[ ("UNION_PAY_FG") ] == ("4") ) {		// 2014-1124-Jane
																		// :
																		// 현금IC카드
																		// 추가.
							csTemp += ("[발 급 기 관] ") + csIssCrdCpNm + ("\r\n");
						}
						else {
							// 2018-11-15 KLC : 영수증 간소화 처리
							if ( blReducePrint == true )
							{
								csTemp += ("[카드/매입사] ") + csIssCrdCpNm + ("/") + csCrdCpNm + ("\r\n");
							}else
							{
								csTemp += ("[카 드 종 류] ") + csIssCrdCpNm + ("\r\n");
							}
						}
					}
				}

				// //////////////////////////////////////////////////////////////////
				// 회수용, 보관용 마스킹 처리 안함.
				// //////////////////////////////////////////////////////////////////
				if( this.m_stSaleInfo.TITLE.indexOf( "회수용" ) > 0
				||  this.m_stSaleInfo.TITLE.indexOf( "보관용" ) > 0 ) {
					csValue = csCrdCardNo;
					blMaskingFg = false;
				} else {
					csValue = csCrdCardNo;
					blMaskingFg = true;
				}

				csCrdCardNo = csValue;
				if( this.g_inPaperTypeFg == 0 ) {
					if( this.m_csPrintCode == ("12") ) {
						if( row[ ("UNION_PAY_FG") ] == ("4") ) {		// 2014-1124-Jane
																		// :
																		// 현금IC카드
																		// 추가.
							csTemp += ("계좌번호 ") + csCrdCardNo + ("\r\n");
						}
						else {
							csTemp += ("카드번호 ") + this.DllSetCrdCardNoMasking( csCrdCardNo, blMaskingFg ) + ("\r\n");
						}
					}
					else {
						if( row[ ("UNION_PAY_FG") ] == ("4") ) {		// 2014-1124-Jane
																		// :
																		// 현금IC카드
																		// 추가.
							csTemp += ("계좌번호 ") + csCrdCardNo + ("\r\n");
						}
						else {
							csTemp += ("카드번호 ") + this.DllSetCrdCardNoMasking( csCrdCardNo, blMaskingFg ) + ("\r\n");
						}
					}
					// 2014-0220 Antony Choi : 코너 사업자일 경우 할부 개월이 다른 CASE발생.

					// 2018-11-15 KLC : 영수증 간소화 처리
					if ( blReducePrint == false )
					{
						csTemp += ("매 입 사 ") + csCrdCpNm + ("\r\n");
					}
				}
				else {
					if( this.m_csPrintCode == ("12") ) {
						if( row[ ("UNION_PAY_FG") ] == ("4") ) {		// 2014-1124-Jane
																		// :
																		// 현금IC카드
																		// 추가.
							csTemp += ("[계 좌 번 호] ") + csCrdCardNo + ("\r\n");
						}
						else {
							csTemp += ("[카 드 번 호] ") + this.DllSetCrdCardNoMasking( csCrdCardNo, blMaskingFg ) + ("\r\n");

						}
					}
					else {
						if( row[ ("UNION_PAY_FG") ] == ("4") ) {		// 2014-1124-Jane
																		// :
																		// 현금IC카드
																		// 추가.
							csTemp += ("[계 좌 번 호] ") + csCrdCardNo + ("\r\n");
						}
						else {
							csTemp += ("[카 드 번 호] ") + this.DllSetCrdCardNoMasking( csCrdCardNo, blMaskingFg ) + ("\r\n");

						}
					}

					// 2018-11-15 KLC : 영수증 간소화 처리
					if ( blReducePrint == false )
					{
						csTemp += ("[전표 매입사] ") + csCrdCpNm + ("\r\n");
					}
				}

				bCornerCnt = 0;
			}

			if( blCorner ) {
				csCornerCd		= row[ "CORNER_CD" ];
				csCornerNm		= row[ "CORNER_NM" ];
				csCornerBizNo	= this.GetEnvXmlCornerENV(  csCornerCd  , "BIZ_NO"    );
				csCornerOwnerNm = this.GetEnvXmlCornerENV(  csCornerCd  , "OWNER_NM"  );
				csCornerBizNo   = pu.DllTransAtoA_Format( csCornerBizNo, ("BIZ_NO") );

				if( util.byteLen(csCornerOwnerNm) > 6 ) {
					csCornerOwnerNm = csCornerOwnerNm.cutStr( 6 );
				}

				csTemp += "\r\n";
				csLeftStr = "▶%s".sprintf( csCornerNm );
				csRightStr = "사업자:%s:%s".sprintf( csCornerBizNo, csCornerOwnerNm );

				if( this.g_inPaperTypeFg == 0 ) {
					csValue = "%-s  %-s".sprintf( csLeftStr, csRightStr );
					csTemp += csValue;
				}
				else {
					csValue = ("%-s  %-s").sprintf( csLeftStr, csRightStr );
					csTemp += csValue;
				}
				csTemp += ("\r\n");
			}

			if( this.g_inPaperTypeFg == 0 ) {
				// 2014-0220 Antony Choi : 코너 사업자일 경우 할부 개월이 다른 CASE발생.
				// 2018-11-15 KLC : 영수증 간소화 처리
				if ( blReducePrint == false )
				{
					if( row[ ("INST_MM_FG") ] == ("0") ) {
							csTemp += ("할부개월 ") +  row[ ("INST_MM_NM") ] + ("\r\n");
					}
					else {
						csTemp += ("할부개월 ") +  row[ ("INST_MM_NM") ] + ("( ") + row[ ("INST_MM_CNT") ] + (" )") + ("\r\n");
					}
					// ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
					csValue = ("승인금액 %s\r\n").sprintf( util.numberWithCommas( row[ ("APPR_AMT") ] ) );
					csTemp += csValue;
				}else
				{
					csTemp += ("승인금액 ") + util.numberWithCommas( row[ ("APPR_AMT") ] );
					if( row[ ("INST_MM_FG") ] == ("0") ) {
						csTemp += ("(") + row[ ("INST_MM_NM") ] + (")") + ("\r\n");
					}
					else {
						csTemp += ("(") + row[ ("INST_MM_NM") ] + ("-") + row[ ("INST_MM_CNT") ] + (" )") + ("\r\n");
					}
				}

				// 2018-11-15 KLC : 영수증 간소화 처리
				if ( blReducePrint == false ) {
					csValue = ("승인번호 %s\r\n").sprintf(  row[ ("APPR_NO") ] );
					csTemp += csValue;

				} else {

					csValue=  ("승인/가맹점 %s / %s\r\n").sprintf( row[ ("APPR_NO") ], row[ ("CRDCPERM_NO") ] );
					csTemp += csValue;
				}

				csTemp += ("승인일시 ") + pu.DllTransAtoA_Format( row[ ("APPR_DATE") ] + row[ ("APPRIME") ],	("YYYY-MM-DD HH:MM:SS") ) + ("\r\n");

				if( row[ ("SALE_YN") ] == ("N") ) {
					csTemp += "원승인일 " + pu.DllTransAtoA_Format( row[ ("ORG_APPR_DATE") ], ("YYYY-MM-DD") ) + ("\r\n");
				}

				csValue = ("단말기NO %s\r\n").sprintf( row[ ("VAN_TERM_NO") ] );
				csTemp += csValue;
				// 2018-11-15 KLC : 영수증 간소화 처리
				if ( blReducePrint == false )
				{
					csTemp += ("가맹점NO ") + row[ ("CRDCP_TERM_NO") ] + ("\r\n");
				}

				csValue = util.numberWithCommas( row[ ("GIFT_CASH") ] );
				if( !pu.isEmpty(csValue) && csValue != "0" ) {
					csTemp += ("잔액/포인트 ") + csValue + ("\r\n"); // 2015-0526 Antony.Choi : [POS보안] 문구변경
				}

				csValue = row[ ("NOTICE_MSG") ];
				if( !pu.isEmpty( csValue ) ) {
					csTemp += csValue + ("\r\n");
				}

				csValue = row[ ("BROAD_MSG") ];
				if( !pu.isEmpty( csValue ) ) {
					csTemp += csValue + ("\r\n");
				}
			}
			else {
				if( row[ ("UNION_PAY_FG") ] != "4" && blReducePrint == false) {		// 2014-1124-Jane
																					// :
																					// 현금IC카드
																					// 추가.
					// 2014-0220 Antony Choi : 코너 사업자일 경우 할부 개월이 다른 CASE발생.
					if( row[ ("INST_MM_FG") ] == ("0") ) {
						csTemp += "[결 제 방 법] " +  row[ ("INST_MM_NM") ] + "\r\n";
					}
					else {
						csTemp += "[결 제 방 법] " +  row[ ("INST_MM_NM") ] + "( " + row[ ("INST_MM_CNT") ] + " )" + "\r\n";
					}
				}
				// //////////////////////////////////////////////////////////////////////////////////////////////////
				// 2018-11-15 KLC : 영수증 간소화 처리
				if ( blReducePrint == false ) {
					csValue = ("[승 인 금 액] %s\r\n").sprintf( util.numberWithCommas( row[ ("APPR_AMT") ] ) );
					csTemp += csValue;
				}else
				{
					csValue =  ("[승 인 금 액] %s ").sprintf( util.numberWithCommas( row[ ("APPR_AMT") ] ) );
					csTemp += csValue;

					if( row[ ("INST_MM_FG") ] == ("0") ) {
						csTemp += ("(") + row[ ("INST_MM_NM") ] + (")") + ("\r\n");
					}
					else {
						csTemp += ("(") + row[ ("INST_MM_NM") ] + ("-") + row[ ("INST_MM_CNT") ] + (" )") + ("\r\n");
					}
				}

				// 2018-11-15 KLC : 영수증 간소화 처리
				if ( blReducePrint == false ) {
					csValue =  ("[승 인 번 호] %s\r\n").sprintf( row[ ("APPR_NO") ] );
					csTemp += csValue;
				} else {
					csValue = ("[승인/가맹점] %s / %s\r\n").sprintf( row[ ("APPR_NO") ], row[ ("CRDCPERM_NO") ] );
					csTemp += csValue;
				}

				csTemp += ("[승 인 일 시] ") + pu.DllTransAtoA_Format( row[ ("APPR_DATE") ] + row[ ("APPR_TIME") ], ("YYYY-MM-DD HH:MM:SS") ) + ("\r\n");

				if( row[ ("SALE_YN") ] == ("N") ) {
					csTemp += ("[원승인 일자] ") + pu.DllTransAtoA_Format( row[ ("ORG_APPR_DATE") ], ("YYYY-MM-DD") ) + ("\r\n");
				}

				csValue = ("[단말기 번호] %s\r\n").sprintf( row[ ("VAN_TERM_NO") ] );
				csTemp += csValue;
				// 2018-11-15 KLC : 영수증 간소화 처리
				if ( blReducePrint == false )
				{
					csTemp += ("[가맹점 번호] ") + row[ ("CRDCP_TERM_NO") ] + ("\r\n");
				}

				csValue = util.numberWithCommas( row[ ("GIFT_CASH") ] );
				if( !pu.isEmpty(csValue) && csValue != "0" ) {
					csTemp += ("[잔액/포인트] ") + csValue + ("\r\n"); // 2015-0526 Antony.Choi : [POS보안] 선불카드 문구 변경
				}

				csValue = row[ ("NOTICE_MSG") ];
				if( !pu.isEmpty( csValue ) ) {
					csTemp += ("[     NOTICE] ") + csValue + ("\r\n");
				}

				csValue = row[ ("BROAD_MSG") ];
				if( !pu.isEmpty( csValue ) ) {
					csTemp += ("[알림 메세지] ") + csValue + ("\r\n");
				}
			}

			dnTotApprAmt += row[ "APPR_AMT"	   ] ;
			dnTotApprVat += row[ "VAT_AMT" 	   ] ;
			dnTotApprTip += row[ "SVC_TIP_AMT" ] ;

			this.m_stSaleInfo.EMP_NO = row[ ("EMP_NO") ] ;
			this.m_stSaleInfo.EMP_NM = row[ ("EMP_NM") ] ;

			csLineTemp = row[ ("LINE_NO") ];
		}

		if( bCnt > 0 ) {
			if( this.g_inPaperTypeFg == 0 ) {
				csTemp += ("--------------------------------\r\n");
			}
			else {
				csTemp += ("------------------------------------------\r\n");
			}
			csResult += csTemp;
			csResult += pu.GetMarkString_04(  "판 매 금 액:" , dnTotApprAmt - dnTotApprVat - dnTotApprTip ) + ("\r\n");
			csResult += pu.GetMarkString_04(  "부 가 세 액:" , dnTotApprVat                               ) + ("\r\n");
			csResult += pu.GetMarkString_04(  "봉 사 료 액:" , dnTotApprTip                               ) + ("\r\n");
			csResult += pu.GetMarkString_04(  "합 계 금 액:" , dnTotApprAmt                               ) + ("\r\n");

			if( this.g_inPaperTypeFg == 0 ) {
				csResult += ("--------------------------------\r\n");
			}
			else {
				csResult += ("------------------------------------------\r\n");
			}
		}

		return csResult;
	}
	/***************************************************************************
	 * m_blProdListPrintFg true 면 skip, false 이면 계속 진행.
	 **************************************************************************/
	this.GetProductListData = function( pcsCode, pblSales) {
		util.logInfo("*** GetProductListData START ***");
		let  blZeroUprcProdSkipFg = false;

		let bCnt = 0;

		let csQrySql     = ""
		let csTemp       = ""
		let csCode       = ""
		let csDblFg      = ""  // 2016-09-27-JYL [곱빼기]
		let csProdNm     = ""
		let csDcAmt      = ""
		let csSdaNm		 = ""
		let csProdLine	 = ""
		let csPriceMgrYn = ""
		let csSaleAmt    = ""
		let csStatus	 = ""
		let csSideMenu	 = ""
		let csDlvPackFg  = ""
		let csSaleQty    = ""
		let csProdCd     = ""
		let csCutProdNm  = ""
		let csTemp1      = ""
		let csTemp2      = ""
		let csSubQrySql  = ""	// 2019-04-24-SHK [정렬방식]
		let csOrderNo	 = ""	// 단체 중간계산서용 주문번호 (by Ilgeun Oh, 200115)

		let lnSaleAmt    = 0;
		let lnDcmSaleAmt = 0;
		let lnDcSumAmt   = 0;
		let lnVatAmt     = 0;
		let lnDcAmt      = 0;

		let inSaleQty   = 0;
		let inProdCdLen  = pu.parseInt( this.code_len( "PROD_CD_LEN"  ) );
		
		let inProdNmLen = 0;
		let inTaxTypeFg =  pu.parseInt(this.GetEnvXmlShopENV( 128  ) );
		let	inSvcTipTypeFg =  pu.parseInt( this.GetEnvXmlShopENV( 129  ) );			// 판매가-봉사료포함여부
																					// 0:별도
																					// 1:포함
		let inPriceMgrSaleAmtPrintYN = pu.parseInt( this.GetEnvXmlShopENV( 582 ) );
		let inEnv688 = pu.parseInt(this.GetEnvXmlShopENV(688) );		// 2021.10.22 xbwing [메뉴출력형태2-상품명길이]

		let pInOrderBy = pu.parseInt( this.GetEnvXmlShopENV( 682 ) );
		let rows;
		// 복수사업자(코너사업자)일 때, 교환권이 코너별로 나와야하기 때문에 코너별로 따로 조회되도록 분기처리. 
		if(BIZ_CLS_TYPE == "1" && this.printCode == "94"){ // 복수사업자일 때
			let sql = _sql.selectCornerPayData( this.m_stSaleInfo);			
			rows = this.db_get_mumti_rows( sql, [] );
		}else{
			let sql = _sql.GetProductListData_SQL(pcsCode , this.m_stSaleInfo , pInOrderBy , pblSales);
			let db_result = gfn_SQLiteSQLProcess( sql , [ ]);
			
			if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data)  || db_result.Data.length == 0 ) {
				
				return false;
			}
			rows = db_result.Data;
		}

		for( let itx =  0; itx < rows.length; itx++  )  {
			let row = rows[itx];

			csSideMenu = ""
			csStatus   = ""
			csSaleQty  = ""

			inSaleQty = 0;

			// //////////////////////////////////////////////////////////////////////
			// 고객주문서/중간계산서/영수증 0원메뉴 출력여부 0:출력 1:미출력
			// //////////////////////////////////////////////////////////////////////
			blZeroUprcProdSkipFg = false;

			if( this.m_blZeroUprcProdNoPrintFg == 1) {
				if( row[ "UPRC"  ]  == 0 ) {
					blZeroUprcProdSkipFg = true;
				}
			}

			if( pcsCode == "{상품리스트1}")  {
				// //////////////////////////////////////////////////////////////////////////
				// 2013-0902-Jane : 영수증 상품리스트 출력제어.
				// 2013-1128 Antony.Choi : 고객 퇴점일 경우에는 비교 하지 않음
				// //////////////////////////////////////////////////////////////////////////
				if( !this.m_blProdListPrintFg == true ) {
					continue;
				}
				// //////////////////////////////////////////////////////////////////
				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부
				// //////////////////////////////////////////////////////////////////
				if( blZeroUprcProdSkipFg ) {
					continue;
				}

				if( bCnt == 0 ) {
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += "  상 품 명       수량      금 액\r\n";
						csTemp += "--------------------------------" ;
					}
					else {
						csTemp += "    상  품  명       단 가  수량     금 액\r\n";
						csTemp += "------------------------------------------";
					}
				}

				csDblFg  =  row[ "PROP_CD"  ];                               // 2016-09-27-JYL [곱빼기]
				csProdNm =  row[ "PROD_NM"  ];                               // 2016-09-27-JYL [곱빼기]
				csProdNm = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false ) ;  // 2016-09-27-JYL [곱빼기]

				csTemp += "\r\n" + csProdNm + "\r\n" ;
				csTemp += pu.RPad( row[ "PROD_CD"  ], 17 );

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 4  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "AMT" ] ), 10 );
				} else {
					csTemp += pu.LPad( util.numberWithCommas( row[ "UPRC" ] ), 9  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY"  ] ), 5  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "AMT"  ] ), 11 );
				}

				if(row["PRICE_MGR_FG" ] == "2"  && row["SALE_WEIGHT"] > 0) {
					csProdNm = ("(%sg)").sprintf( util.numberWithCommas(row["SALE_WEIGHT"]) ) ;
					csTemp += pu.RPad(csProdNm, 17);
				}

			} else if( pcsCode == "{중간계산서-메뉴목록}")  {
				// //////////////////////////////////////////////////////////////////
				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부
				// //////////////////////////////////////////////////////////////////
				if( blZeroUprcProdSkipFg ) {
					continue;
				}
				if( bCnt == 0 )	{
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += "  메 뉴 명       수량      금 액\r\n";
						csTemp += "--------------------------------";
					}
					else {
						csTemp += "    메  뉴  명       단 가  수량     금 액\r\n";
						csTemp += "------------------------------------------";
					}
				}

				csDblFg  = row[ "PROP_CD"  ];                               // 2016-09-27-JYL
																			// [곱빼기]
				csProdNm = row[ "PROD_NM" ];
				csProdNm = csProdNm.ltrim();
				csProdNm = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false );  // 2016-09-27-JYL
																							// [곱빼기]

				csTemp += "\r\n" + csProdNm + "\r\n";
				// //////////////////////////////////////////////////////////////////
				// 배달영수증/배달전표에 상품코드 대신 원산지명 표기.
				// //////////////////////////////////////////////////////////////////
				csTemp += pu.RPad( row[ "PROD_CD" ], 17);


				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 4  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "AMT" ] ), 10 );
				}
				else {
					csTemp += pu.LPad( util.numberWithCommas( row[ "UPRC" ] ), 9  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY"  ] ), 5  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "AMT"  ] ), 11 );
				}

				if(row["PRICE_MGR_FG"] == "2" && row["SALE_WEIGHT"] > 0)
				{
					csProdNm ="(%sg)".sprintf ( util.numberWithCommas(row["SALE_WEIGHT" ] ) );
					csTemp += pu.RPad(csProdNm, 17);
				}
			}
			else if( pcsCode == "{중간계산서-메뉴목록2}")  {
				// //////////////////////////////////////////////////////////////////
				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부
				// //////////////////////////////////////////////////////////////////
				if( blZeroUprcProdSkipFg ) {
					continue;
				}
				if( bCnt == 0 )	{
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += "  메 뉴 명       수량      금 액\r\n" ;
						csTemp += "--------------------------------";
					}
					else {
						csTemp += "    메  뉴  명       단 가  수량     금 액\r\n" ;
						csTemp += "------------------------------------------";
					}
				}

				csDblFg  = row[ "PROP_CD"  ];                               // 2016-09-27-JYL
																			// [곱빼기]
				csProdNm = row[ "PROD_NM" ];
				csProdNm = csProdNm.ltrim();
				csProdNm = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false ) ;  // 2016-09-27-JYL
																							// [곱빼기]
				// //////////////////////////////////////////////////////////////////
				// 배달영수증/배달전표에 상품코드 대신 원산지명 표기.
				// //////////////////////////////////////////////////////////////////
				if(  this.m_csPrintCode  == 14
				||   this.m_csPrintCode  == 15 ) {
					csTemp += "\r\n" + csProdNm + "\r\n";
					csTemp += pu.RPad( row[ "ORG_PLACE_NM" ], 17);
					if( this.g_inPaperTypeFg == 0 )
					{
						csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 4  );
						csTemp += pu.LPad( util.numberWithCommas( row[ "AMT" ] ), 10 );
					}
					else
					{
						csTemp += pu.LPad( util.numberWithCommas( row[ "UPRC" ] ), 9  );
						csTemp += pu.LPad( util.numberWithCommas( row[ "QTY"  ] ), 5  );
						csTemp += pu.LPad( util.numberWithCommas( row[ "AMT"  ] ), 11 );
					}

				}
				else {
					csTemp += "\r\n" + pu.RPad( pu.DllGetCutHangul( csProdNm, 17 ), 17 );

					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 4  );
						csTemp += pu.LPad( util.numberWithCommas( row[ "AMT" ] ), 10 );
					}
					else {
						csTemp += pu.LPad( util.numberWithCommas( row[ "UPRC" ] ), 9  );
						csTemp += pu.LPad( util.numberWithCommas( row[ "QTY"  ] ), 5  );
						csTemp += pu.LPad( util.numberWithCommas( row[ "AMT"  ] ), 11 );
					}
				}

				if(row["PRICE_MGR_FG" ] == "2" && row["SALE_WEIGHT"] > 0) {
					csProdNm = "(%sg)".sprintf(  util.numberWithCommas(row["SALE_WEIGHT"]));
					csTemp += pu.RPad(csProdNm, 17);
				}
			}
			else if( pcsCode == "{중간계산서-메뉴목록3}"  ) {
				// //////////////////////////////////////////////////////////////////
				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부
				// //////////////////////////////////////////////////////////////////
				if( blZeroUprcProdSkipFg ) {
					continue;
				}
				if( bCnt == 0 )	{
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += "  메 뉴 명       수량      금 액\r\n";
						csTemp += "--------------------------------";
					}
					else {
						csTemp += "    메  뉴  명       단 가  수량     금 액\r\n";
						csTemp += "------------------------------------------";
					}
				}

				csDblFg  = row[ "PROP_CD" ];                               // 2016-09-27-JYL
																			// [곱빼기]
				csProdNm = row[ "PROD_NM" ];
				csProdNm = csProdNm.ltrim();
				csProdNm = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false ) ;  // 2016-09-27-JYL
																							// [곱빼기]

				csTemp += "\r\n" + pu.RPad( pu.DllGetCutHangul( csProdNm, 17 ), 17 );

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 4  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "AMT" ] ), 10 );
				}
				else {
					csTemp += pu.LPad( util.numberWithCommas( row[ "UPRC" ] ), 9  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY"  ] ), 5  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "AMT"  ] ), 11 );
				}

				if(row["PRICE_MGR_FG"] == "2" && row["SALE_WEIGHT"] > 0)
				{
					csProdNm = "(%sg)".sprintf( util.numberWithCommas(row["SALE_WEIGHT"]));
					csTemp += pu.RPad(csProdNm, 17);
				}

			} else if( pcsCode == "{상품리스트2}") {
				// //////////////////////////////////////////////////////////////////////////
				// 2013-0902-Jane : 영수증 상품리스트 출력제어.
				// 2013-1128 Antony.Choi : 고객 퇴점일 경우에는 비교 하지 않음
				// //////////////////////////////////////////////////////////////////////////
				if( !this.m_blProdListPrintFg == true ) {
						continue;
				}

				// //////////////////////////////////////////////////////////////////
				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부
				// //////////////////////////////////////////////////////////////////
				if( blZeroUprcProdSkipFg ) {
					continue;
				}
				if( bCnt == 0 ) {
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += "   상 품 명      수량     금 액\r\n";
						csTemp += "-------------------------------";
					}
					else {
						csTemp += "    상  품  명       단 가  수량     금 액\r\n";
						csTemp += "------------------------------------------";
					}
				}
				// //////////////////////////////////////////////////////////////////
				// 상품명 좌측정렬 변경처리.
				// //////////////////////////////////////////////////////////////////
				csDblFg  = row[ "PROP_CD" ];                               // 2016-09-27-JYL
																			// [곱빼기]
				csProdNm = row[ "PROD_NM" ];                               // 2016-09-27-JYL
																			// [곱빼기]
				csProdNm = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false ) ;  // 2016-09-27-JYL
																							// [곱빼기]

				csTemp += "\r\n" + pu.RPad( pu.DllGetCutHangul( csProdNm, 17 ), 17 );

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 4  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "AMT" ] ), 10 );
				}
				else {
					csTemp += pu.LPad( util.numberWithCommas( row[ "UPRC" ] ), 9  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY"  ] ), 5  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "AMT"  ] ), 11 );
				}
				
				/**
				 * 2022-05-26 1회용 컵 보증금이 있으면 상품명 바로 아래 사이드메뉴와 같은 형태로 추가한다.
				 */
				if(!!orderInfo.POS_ODDTL_T){ // 주문하는 과정에서 영수증 출력인 경우
					for(var cup=0;cup<orderInfo.POS_ODDTL_T.length;cup++){ // 현재 주문한 객체 for문
						var voDtl = orderInfo.POS_ODDTL_T[cup];
						if(row[ "PROD_CD"  ] == voDtl.PROD_CD){ // 현재 상품과 dtl객체의 상품이 같으면
							if(!!voDtl.cupList){ // dtl객체에 cupList가 존재한다면							
								csTemp += "\r\n▷";
								csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 15 ), 15 );
								if( this.g_inPaperTypeFg == 0 ) {
									csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_CNT ), 4  );
									csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_AMT ), 10 );	
								}else{
									if(voDtl.cupList[0].CUP_TYPE == "disposableCup"){ // 1회용보증금 컵일 때 보증금 단가 
										csTemp += pu.LPad( util.numberWithCommas( gCupUprc ), 9  );
									}else{ // 1회용 보증금 컵이 아닌 경우에 보증금 단가 0원
										csTemp += pu.LPad( util.numberWithCommas( "0" ), 9  );
									}
									csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_CNT ), 5  );
									csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_AMT ), 11 );
								}
								
							}
						}
					}
				}else{ // 주문하는 과정에서의 영수증 출력이 아닌 경우 (관리자에서 재출력 등)
					if(!!row["CUP_SALE_CNT"]){ // 컵 개수가 존재할 때만 재출력 대상이 된다.
						if(row["CUP_FG"] != "PRSNL" && row["CUP_FG"] != "STORE"){ // ODDTL_T 테이블의 CUP_FG 값이 개인/매장 컵이 아닌 경우 (1회용 컵인 경우)
							csTemp += "\r\n▷";
							csTemp += pu.RPad( pu.DllGetCutHangul( "1회용컵", 15 ), 15 );
							var vsAmt = "" + (Number(row["CUP_SALE_CNT"]) * Number(row["CUP_DEPOSIT_UPRC"]));
							if( this.g_inPaperTypeFg == 0 ) {
								csTemp += pu.LPad( util.numberWithCommas( row["CUP_SALE_CNT"] ), 4  );
								csTemp += pu.LPad( util.numberWithCommas( vsAmt ), 10 );	
							}else{
								csTemp += pu.LPad( util.numberWithCommas( row["CUP_DEPOSIT_UPRC"] ), 9  );
								csTemp += pu.LPad( util.numberWithCommas( row["CUP_SALE_CNT"] ), 5  );
								csTemp += pu.LPad( util.numberWithCommas( vsAmt ), 11 );
							}
						}else{
							csTemp += "\r\n▷";
							if(row["CUP_FG"] == "PRSNL"){ // 개인컵인 경우
								csTemp += pu.RPad( pu.DllGetCutHangul( "개인컵", 15 ), 15 );
							}else if (row["CUP_FG"] == "STORE"){
								csTemp += pu.RPad( pu.DllGetCutHangul( "매장컵", 15 ), 15 );
							}else{
								csTemp += pu.RPad( pu.DllGetCutHangul( "", 15 ), 15 );
							}						
							if( this.g_inPaperTypeFg == 0 ) {
								csTemp += pu.LPad( util.numberWithCommas( row["CUP_SALE_CNT"] ), 4  );
								csTemp += pu.LPad( util.numberWithCommas( "0" ), 10 );	
							}else{
								csTemp += pu.LPad( util.numberWithCommas( "0" ), 9  );
								csTemp += pu.LPad( util.numberWithCommas( row["CUP_SALE_CNT"] ), 5  );
								csTemp += pu.LPad( util.numberWithCommas( "0" ), 11 );
							}
						}
					}
				}
				
				if(row["PRICE_MGR_FG" ] == "2"  && row["SALE_WEIGHT"] > 0)
				{
					csProdNm = "(%sg)".sprintf( util.numberWithCommas(row["SALE_WEIGHT"]));
					csTemp += pu.RPad(csProdNm, 17);
				}
			}
			else if( pcsCode == "{상품리스트3}")  {

				// //////////////////////////////////////////////////////////////////////////
				// 2013-0902-Jane : 영수증 상품리스트 출력제어.
				// 2013-1128 Antony.Choi : 고객 퇴점일 경우에는 비교 하지 않음
				// //////////////////////////////////////////////////////////////////////////
				if( !this.m_blProdListPrintFg == true ) {
						continue;
				}
				if( bCnt == 0 )	{
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += "    상 품 명     수량       상태\r\n";
						csTemp += "--------------------------------";
					}
					else {
						csTemp += "    상  품  명            수량       상태 \r\n";
						csTemp += "------------------------------------------";
					}
				}

				csDblFg  = row[ "PROP_CD"  ];                               // 2016-09-27-JYL
																			// [곱빼기]
				csProdNm = row[ "PROD_NM" ];                               // 2016-09-27-JYL
																			// [곱빼기]
				csProdNm = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false  );  // 2016-09-27-JYL
																							// [곱빼기]

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += "\r\n" + pu.LPad( pu.DllGetCutHangul( csProdNm, 16 ), 16 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 4 );
					csTemp += pu.LPad( csStatus, 10 );
				}
				else {
					csTemp += "\r\n" + pu.LPad( pu.DllGetCutHangul( csProdNm, 26 ), 26 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 5 );
					csTemp += pu.LPad( csStatus, 11 );
				}

				if(row["PRICE_MGR_FG"] == "2" && row["SALE_WEIGHT"] > 0)
				{
					csProdNm = "(%sg)".sprintf ( util.numberWithCommas(row["SALE_WEIGHT"] ) );
					csTemp += pu.RPad(csProdNm, 17);
				}
			}
			else if( pcsCode == "{상품리스트4}") {

				// //////////////////////////////////////////////////////////////////////////
				// 2013-0902-Jane : 영수증 상품리스트 출력제어.
				// 2013-1128 Antony.Choi : 고객 퇴점일 경우에는 비교 하지 않음
				// //////////////////////////////////////////////////////////////////////////
				if( !this.m_blProdListPrintFg == true ) {
						continue;
				}
				if( bCnt == 0 )	{
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += "    상 품 명                수량\r\n";
						csTemp += "--------------------------------";
					}
					else {
						csTemp += "    상  품  명                        수량\r\n";
						csTemp += "------------------------------------------";
					}
				}

				csDblFg  = row[ "PROP_CD" ];                               // 2016-09-27-JYL
																			// [곱빼기]
				csProdNm = row[ "PROD_NM" ];                               // 2016-09-27-JYL
																			// [곱빼기]
				csProdNm = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false  );  // 2016-09-27-JYL
																							// [곱빼기]

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += "\r\n" + pu.LPad( pu.DllGetCutHangul( csProdNm, 27 ), 27 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 4 );
				}
				else {
					csTemp += "\r\n" + pu.LPad( pu.DllGetCutHangul( csProdNm, 37 ), 37 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 5 );
				}

				if(row["PRICE_MGR_FG"] == "2"  && row["SALE_WEIGHT"] > 0)
				{
					csProdNm= "(%sg)".sprintf( util.numberWithCommas(row["SALE_WEIGHT"]));
					csTemp += pu.RPad(csProdNm, 17);
				}
			}
			else if( pcsCode == "{상품리스트6}"  ) {
				// //////////////////////////////////////////////////////////////////////////
				// 2013-0902-Jane : 영수증 상품리스트 출력제어.
				// 2013-1128 Antony.Choi : 고객 퇴점일 경우에는 비교 하지 않음
				// //////////////////////////////////////////////////////////////////////////
				if( !this.m_blProdListPrintFg == true ) {
						continue;
				}
				// //////////////////////////////////////////////////////////////////
				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부
				// //////////////////////////////////////////////////////////////////
				if( blZeroUprcProdSkipFg ) {
					continue;
				}
				// //////////////////////////////////////////////////////////////////
				// 상품리스트 타이틀 없이 출력함.
				// 1-LINE : 상품코드 상품명
				// 2-LINE : 정상가 수량 DC액 매출액
				// 2010-1203-YBC : "\r\n" 추가.
				// //////////////////////////////////////////////////////////////////
				csTemp += pu.AddNewLineMark( csTemp );
				csTemp += pu.RPad( row[ "PROD_CD" ], inProdCdLen + 1 );
				inProdNmLen = 42 - ( inProdCdLen + 1 );
				csDblFg  = row[ "PROP_CD"  ];                               // 2016-09-27-JYL
																			// [곱빼기]
				csProdNm = row[ "PROD_NM" ];
				csProdNm = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false  );  // 2016-09-27-JYL
																							// [곱빼기]

				csTemp += csProdNm.cutStr( inProdNmLen ) + "\r\n";

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += pu.LPad( util.numberWithCommas( row[ "NORMAL_UPRC" ] ), 9);
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY"         ] ), 5  );
				}
				else {
					csTemp += pu.LPad( util.numberWithCommas( row[ "NORMAL_UPRC"  ] ), 11 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY"          ] ), 7  );
				}
				if( row[ "DC_AMT" ] != "0" ) {
				   csDcAmt = " DC " + util.numberWithCommas( row[ "DC_AMT" ] );
				}
				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += pu.LPad( csDcAmt , 9 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "AMT"  ] ), 9 );
				}
				else {
					csTemp += pu.LPad( csDcAmt , 13 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "AMT" ] ), 11 );
				}

				if(row["PRICE_MGR_FG" ] == "2" && row["SALE_WEIGHT" ] > 0)
				{
					csProdNm ="(%sg)".sprintf(  util.numberWithCommas(row["SALE_WEIGHT"]));
					csTemp += pu.RPad(csProdNm, 17);
				}

				csDcAmt = ""
			}
			else if( pcsCode == "{상품리스트7}")  {
				// //////////////////////////////////////////////////////////////////
				// 영수증 삼품리스트 출력 여부 (2013-0902-Jane)
				// //////////////////////////////////////////////////////////////////
				if( !this.m_blProdListPrintFg == true ) {
					continue;
				}
				// //////////////////////////////////////////////////////////////////
				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부
				// //////////////////////////////////////////////////////////////////
				if( blZeroUprcProdSkipFg ) {
					continue;
				}
				if( bCnt == 0 )	{
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += "    상 품 명     수량      금 액\r\n";
						csTemp += "--------------------------------";
					}
					else {
						csTemp += "    상  품  명       단 가  수량     금 액\r\n";
						csTemp += "------------------------------------------";
					}
				}

				csDblFg  = row[ "PROP_CD" ];                               // 2016-09-27-JYL
																			// [곱빼기]
				csProdNm = row[ "PROD_NM" ];                               // 2016-09-27-JYL
																			// [곱빼기]
				csProdNm = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false  );  // 2016-09-27-JYL
																							// [곱빼기]

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp1 =  "\r\n%-16s %4s %10s".sprintf (
									pu.DllGetCutHangul ( csProdNm, 16 )
								  , util.numberWithCommas(   row[ "QTY"         ] )
								  , util.numberWithCommas( ( row[ "QTY"         ] * parseFloat( row[ "NORMAL_UPRC"  ] )  ))  ) ;
				}
				else {
					csTemp1 = "\r\n%-16s %9s %4s %10s".sprintf(
							  pu.DllGetCutHangul ( csProdNm, 16 )
							, util.numberWithCommas(  row[ "NORMAL_UPRC"  ] )
							, util.numberWithCommas(  row[ "QTY"          ] )
							, util.numberWithCommas(  row[ "QTY"          ] *  parseFloat( row[ "NORMAL_UPRC"  ] ) ) );
				}
				if(  row[ "DC_AMT"  ] > 0 ) {
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp2 =  "\r\n%32s".sprintf(  "할인금액 " + util.numberWithCommas( row[ "DC_AMT" ] ) );
					}
					else {
						csTemp2 =  "\r\n%42s".sprintf(  "할인금액 " + util.numberWithCommas( row[ "DC_AMT" ] ) );
					}
				}
				else {
					csTemp2 = ""
				}
				csTemp += csTemp1 + csTemp2;

				if(row["PRICE_MGR_FG"] == "2"  && row["SALE_WEIGHT" ] > 0)
				{
					csProdNm = "(%sg)".sprintf( util.numberWithCommas(row["SALE_WEIGHT" ] ) );
					csTemp += pu.RPad(csProdNm, 17);
				}
			}
			else if( pcsCode == "{이전차수-메뉴목록}") 	{
				// //////////////////////////////////////////////////////////////////
				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부
				// //////////////////////////////////////////////////////////////////
				if( blZeroUprcProdSkipFg ) {
					continue;
				}
				csDblFg     = row[ "PROP_CD"      ];                           // 2016-09-27-JYL
																				// [곱빼기]
				csProdNm	= row[ "PROD_NM"     ];
				csProdNm    = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false  );  // 2016-09-27-JYL
																								// [곱빼기]
				csDlvPackFg = row[ "DLV_PACK_FG" ];
				if( csDlvPackFg == "2")  {
					csStatus = "포장";
				} else if( csDlvPackFg == "1")  {
					csStatus = "배달";
				}

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += pu.AddNewLineMark( csTemp );
					csTemp += pu.RPad( pu.DllGetCutHangul( csProdNm, 21 ), 21 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 4 );
					csTemp += pu.LPad( csStatus, 7 );
				} else {
					csTemp += pu.AddNewLineMark( csTemp );
					csTemp += pu.RPad( pu.DllGetCutHangul( csProdNm, 30 ), 30 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 5 );
					csTemp += pu.LPad( csStatus, 7 );
				}

				if(row["PRICE_MGR_FG" ] == "2" && row["SALE_WEIGHT" ] > 0) {
					csProdNm = "(%sg)".sprintf(  util.numberWithCommas(row["SALE_WEIGHT" ]));
					csTemp += pu.RPad(csProdNm, 17);
				}

			} else if( pcsCode == "{이전차수-메뉴목록-금액}") {
				// //////////////////////////////////////////////////////////////////
				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부
				// //////////////////////////////////////////////////////////////////
				if( blZeroUprcProdSkipFg ) {
					continue;
				}
				csDblFg     = row[ "PROP_CD"     ];                           // 2016-09-27-JYL
																				// [곱빼기]
				csProdNm	= row[ "PROD_NM"     ];
				csProdNm    = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false  );  // 2016-09-27-JYL
																								// [곱빼기]
				csDlvPackFg = row[ "DLV_PACK_FG"  ]; // 배달포장구분.
				if( csDlvPackFg == "2")  {
					csStatus = "포장";
				}
				else if( csDlvPackFg == "1")  {
					csStatus = "배달" ;
				}
				lnDcmSaleAmt = atol( row[ "DCM_SALE_AMT"  ] );

				this.m_lnOrderTotAmt += lnDcmSaleAmt;

				// //////////////////////////////////////////////////////////////////
				// 부가세별도 매장용.
				// //////////////////////////////////////////////////////////////////
				lnVatAmt =   pu.parseInt(row[ "VAT_AMT"  ]) ;
				this.m_lnOrderVatAmt += lnVatAmt;

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += pu.AddNewLineMark( csTemp );
					csTemp += pu.RPad( pu.DllGetCutHangul( csProdNm, 14 ), 14 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY"           ] ), 5 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "DCM_SALE_AMT"  ] ), 8 );
					csTemp += pu.LPad( csStatus, 5 );
				}
				else {
					csTemp += pu.AddNewLineMark( csTemp );
					csTemp += pu.RPad( pu.DllGetCutHangul( csProdNm, 23 ), 23 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY"           ] ), 5 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "DCM_SALE_AMT"  ] ), 9 );
					csTemp += pu.LPad( csStatus, 5 );
				}

				if(row["PRICE_MGR_FG" ] == "2"  && row["SALE_WEIGHT" ] > 0)
				{
					csProdNm = "(%sg)".sprintf(  util.numberWithCommas(row["SALE_WEIGHT" ]));
					csTemp += pu.RPad(csProdNm, 17);
				}
			}
			else if( pcsCode == "{코너별-메뉴목록}")  {
				if( bCnt == 0 ) {
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += "    메 뉴 명                수량\r\n" ;
						csTemp += "--------------------------------";
					}
					else {
						csTemp += "    메  뉴  명                        수량\r\n";
						csTemp += "------------------------------------------";
					}
				}
				csDblFg     = row[ "PROP_CD"      ];                           // 2016-09-27-JYL
																				// [곱빼기]
				csProdNm	= row[ "PROD_NM"      ];
				csProdNm    = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false  );  // 2016-09-27-JYL
																								// [곱빼기]
				csDlvPackFg = row[ "DLV_PACK_FG" ]; // 배달포장구분.
				if( csDlvPackFg == "2")  {
					csStatus = "포장";
				}
				else if( csDlvPackFg == "1"  ) {
					csStatus = "배달" ;
				}
				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += "\r\n"  + pu.RPad( pu.DllGetCutHangul( csProdNm, 22 ), 22 );
					csTemp += pu.LPad( csStatus, 6 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 4 );
				}
				else {
					csTemp += "\r\n" + pu.RPad( pu.DllGetCutHangul( csProdNm, 30 ), 30 );
					csTemp += pu.LPad( csStatus, 7 );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 5 );
				}

				if( row["PRICE_MGR_FG" ] == "2"  && row["SALE_WEIGHT" ] > 0)
				{
					csProdNm = "(%sg)".sprintf(  util.numberWithCommas(row["SALE_WEIGHT" ]));
					csTemp += pu.RPad(csProdNm, 17);
				}
			}
			else if( pcsCode == "{이용권내역}")  {
				lnSaleAmt += parseInt(row[ "UPRC" ]);
				lnVatAmt  += parseInt(row[ "VAT"  ]);
				if( this.g_inPaperTypeFg == 0 ) {
					csTemp1 = "%-26s %5s명\r\n".sprintf(  csProdNm , util.numberWithCommas(  row[ "QTY" ] ) );
				}
				else {
					csTemp1 = "%-34s %5s명\r\n".sprintf( csProdNm , util.numberWithCommas( row[ "QTY" ] ) );
				}

				if(row["PRICE_MGR_FG" ] == "2"  && row["SALE_WEIGHT"] > 0)
				{
					csProdNm = "(%sg)".sprintf(  util.numberWithCommas(row["SALE_WEIGHT" ]));
					csTemp += pu.RPad(csProdNm, 17);
				}

				csTemp += csTemp1;
			}
			else if( pcsCode == "{주문서-메뉴출력형태1}")   {
//debugger; //xbwing
				// //////////////////////////////////////////////////////////////////
				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부
				// //////////////////////////////////////////////////////////////////
				if( blZeroUprcProdSkipFg ) {
					continue;
				}

				if( bCnt == 0 )	{
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += "    상  품  명         수량 구분\r\n" ;			// 2014-0917-Jane
																			// :
																			// 메뉴->상품
						csTemp += "--------------------------------";
					}
					else {
						csTemp += "    상  품  명                 수량   구분\r\n";	// 2014-0917-Jane
																				// :
																				// 메뉴->상품
						csTemp += "------------------------------------------";
					}
				}

				if(  row[ "ORDER_CNT" ] == 1 ) {
					csStatus = "신규" ;
				}
				else {
					csStatus = "추가" ;
				}

				inSaleQty = row[ "QTY" ];

				if( this.m_stSaleInfo.blReturnSaleFg == 1 ) {
					inSaleQty *= -1;
				}

				csSaleQty = inSaleQty ;

				// //////////////////////////////////////////////////////////////////
				// 사이드메뉴 속성/선택 구분자 변경 처리.
				// //////////////////////////////////////////////////////////////////
				csProdCd = row[ "PROD_CD"  ];

				if( row[ "SIDE_MENU_YN"  ] == "N"  &&  row[ "SDS_ORG_DTL_NO" ] > 0 ) {
					if( csProdCd.substring( 0,1 ) == "A" ) { // SIDE 속성
						csSideMenu = "▷" ;
						csStatus   = "속성" ;
					}
					else {
						csSideMenu = "▶";
						csStatus   = "선택";
					}
				}

				if( inSaleQty < 0 )	{
					csStatus = "취소" ;
				}

				csDblFg      = row[ "PROP_CD"       ];                          // 2016-09-27-JYL
																				// [곱빼기]
				csProdNm	 = row[ "PROD_NM"       ];
				csProdNm     = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false  );  // 2016-09-27-JYL
																								// [곱빼기]
				csPriceMgrYn = row[ "PRICE_MGR_YN"  ];
				csSdaNm		 = row[ "SDA_NM"        ];	// 사이드메뉴 속성명 출력 처리.
				csDlvPackFg  = row[ "DLV_PACK_FG"   ];	// 배달포장구분.

				if( csDlvPackFg == "2" ) {
					csStatus = "포장" ;
				}
				else if( csDlvPackFg == "1"  ) {
					csStatus = "배달" ;
				}

				if( !pu.isEmpty ( csSdaNm ) ) {
					if( this.g_inPaperTypeFg == 0 ) {
						csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 16 ), 16 );
					} else {
						csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 22 ), 22 );
					}
				} else {
					if( this.g_inPaperTypeFg == 0 ) {
						csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csProdNm, 22 ), 22 );
					} else {
						csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csProdNm, 30 ), 30 );
					}
				}

				// 2016-1128 Antony.Choi : 싯가 상품일 경우 582번 옵션이 사용 일 경우에만 출력함.
				if( csPriceMgrYn == "Y"  && inPriceMgrSaleAmtPrintYN == 1 ) {		// 싯가상품.
					csSaleAmt = util.numberWithCommas( row[ "SALE_AMT"  ] );
					csProdNm  = pu.DllGetCutHangul( csProdNm, csProd.getByteLength() - csSaleAmt.length - 2 ) + "(" + csSaleAmt + ")" ;
				}

				if( !pu.isEmpty ( csSdaNm ) ) {
					csProdLine  = "\r\n" ;
					csProdLine += csProdNm;
					csProdLine += "[" ;
					csProdLine += pu.RPad( pu.DllGetCutHangul( csSdaNm, 6 ), 6 );
					csProdLine += "]" ;
				} else {
					csProdLine = "\r\n"  + csProdNm;
				}

				csTemp += csProdLine;

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += pu.LPad( util.numberWithCommas( csSaleQty ), 5 );
					csTemp += pu.LPad( csStatus, 5 );
				} else {
					csTemp += pu.LPad( util.numberWithCommas( csSaleQty ), 5 );
					csTemp += pu.LPad( csStatus, 7 );
				}

				if(row["PRICE_MGR_FG" ] == "2"  && row["SALE_WEIGHT" ] > 0) {
					csProdNm = "(%sg)".sprintf(  util.numberWithCommas(row["SALE_WEIGHT" ]));
					csTemp += pu.RPad(csProdNm, 17);
				}
			}
			else if( pcsCode == "{주문서-메뉴출력형태2}")   {
				// //////////////////////////////////////////////////////////////////
				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부
				// //////////////////////////////////////////////////////////////////
				if( blZeroUprcProdSkipFg ) {
					continue;
				}

				if( bCnt == 0 )	{
					csTemp += " 상 품 명   수량 구분\r\n" ;		// 2014-0917-Jane :
															// 메뉴->상품
					csTemp += "---------------------\r\n" ;
				}

				if( row[ "ORDER_CNT"  ] == 1 ) {
					csStatus = "신규" ;
				}
				else {
					csStatus = "추가" ;
				}

				inSaleQty = row[ "QTY" ];

				if( this.m_stSaleInfo.blReturnSaleFg == 1 ) {
					inSaleQty *= -1;
				}

				csSaleQty = inSaleQty ;

				// //////////////////////////////////////////////////////////////////
				// 사이드메뉴 속성/선택 구분자 변경 처리.
				// //////////////////////////////////////////////////////////////////
				csProdCd = row[ "PROD_CD"  ];

				if( row[ "SIDE_MENU_YN"   ] == "N"  &&  row[ "SDS_ORG_DTL_NO" ] > 0 ) {
					if( csProdCd.substring( 0,1 ) == "A")   {	// SIDE 속성
						csSideMenu = "▷" ;
						csStatus   = "속성" ;
					}
					else {
						csSideMenu = "▶" ;
						csStatus   = "선택" ;
					}
				}

				if( inSaleQty < 0 )	{
					csStatus = "취소" ;
				}

				csDblFg  = row[ "PROP_CD"  ];                               // 2016-09-27-JYL
																			// [곱빼기]
				csProdNm = row[ "PROD_NM"  ];
				csProdNm = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false   );  // 2016-09-27-JYL
																							// [곱빼기]

				// //////////////////////////////////////////////////////////////////
				// 4배확대시 상품명에 " "를 없애버린다.
				// //////////////////////////////////////////////////////////////////
				csProdNm = csProdNm.replace( " ", ""  );

				csPriceMgrYn = row[ "PRICE_MGR_YN"  ];
				csSdaNm		 = row[ "SDA_NM"        ];	// 사이드메뉴 속성명 출력 처리.
				csDlvPackFg  = row[ "DLV_PACK_FG"   ];	// 배달포장구분.

				if( csDlvPackFg == "2"  ) {
					csStatus = "포장" ;
				}
				else if( csDlvPackFg == "1"  ) {
					csStatus = "배달" ;
				}

				lnSaleAmt = parseInt( row[ "SALE_AMT"  ] / 10000 );	// 만원단위표기

				if( this.m_stSaleInfo.blReturnSaleFg == 1 ) {
					lnSaleAmt *= -1;
				}

				// //////////////////////////////////////////////////////////////////
				// 4배확대시 상품명 짤리는 현상 제거처리.
				// //////////////////////////////////////////////////////////////////
				if( !pu.isEmpty ( csSideMenu ) ) {
					csProdNm = csSideMenu + csProdNm;
				}

				if( ( csProdNm ) > 12 )	{
					csCutProdNm = pu.DllGetCutHangul( csProdNm, 20 );
					csTemp += "\r\n"  + csCutProdNm;
					csProdNm = csProdNm.cutStr( csCutProdNm.getByteLength() );
				}

				if( !pu.isEmpty ( csSdaNm ) ) {
					csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 8  ), 8  );
				} else {
					csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 12 ), 12 );
				}

				// 2016-1128 Antony.Choi : 싯가 상품일 경우 582번 옵션이 사용 일 경우에만 출력함.
				if( csPriceMgrYn == "Y"  && inPriceMgrSaleAmtPrintYN == 1 ) {		// 싯가상품.
					csSaleAmt =  lnSaleAmt ;
					csProdNm  = pu.DllGetCutHangul( csProdNm , csProdNm.getByteLength() - csSaleAmt.length ) + csSaleAmt;
				}

				if( !pu.isEmpty ( csSdaNm ) ) {
					csProdLine  = "\r\n" ;
					csProdLine += csProdNm;
					csProdLine += "-";
					csProdLine += pu.RPad( pu.DllGetCutHangul( csSdaNm, 3 ), 3 );
				} else {
					csProdLine = "\r\n"  + csProdNm;
				}

				csTemp += csProdLine;
				csTemp += pu.LPad( util.numberWithCommas( csSaleQty ), 4 );
				csTemp += pu.LPad( csStatus, 5 );

				if(row["PRICE_MGR_FG" ] == "2"  && row["SALE_WEIGHT" ] > 0)
				{
					csProdNm = "(%sg)".sprintf(  util.numberWithCommas(row["SALE_WEIGHT" ]));
					csTemp += pu.RPad(csProdNm, 17);
				}

			} else if( pcsCode == "{주문서-메뉴출력형태-금액}") {
				// //////////////////////////////////////////////////////////////////
				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부.
				// //////////////////////////////////////////////////////////////////
				if( blZeroUprcProdSkipFg )
				{
					continue;
				}

				if( bCnt == 0 )
				{
					if( this.g_inPaperTypeFg == 0 )
					{
						csTemp += "    상  품  명 수량    금액 구분\r\n";		// 2014-0917-Jane
																		// :
																		// 메뉴->상품
						csTemp += "---------------------------------";
					}
					else
					{
						csTemp += "    상  품  명          수량     금액 구분\r\n";	// 2014-0917-Jane
																			// :
																			// 메뉴->상품
						csTemp += "------------------------------------------" ;
					}
				}

				if( row[ "ORDER_CNT"  ] == 1 )
				{
					csStatus = "신규" ;
				}
				else
				{
					csStatus = "추가" ;
				}

				inSaleQty = row[ "QTY" ];

				if( this.m_stSaleInfo.blReturnSaleFg == 1 )
				{
					inSaleQty *= -1;
				}

				csSaleQty =  inSaleQty ;

				// //////////////////////////////////////////////////////////////////
				// 사이드메뉴 속성/선택 구분자 변경 처리.
				// //////////////////////////////////////////////////////////////////
				csProdCd = row[ "PROD_CD" ];
				csProdNm	 = row[ "PROD_NM"       ];
				csProdNm     = this.GetProdNmDbl( csProdNm, (csDblFg) == 1 ? true :false  );  // 2016-09-27-JYL
																								// [곱빼기]
				if( row[ "SIDE_MENU_YN" ] == "N"  &&  row[ "SDS_ORG_DTL_NO"  ] > 0 )
				{
					if( csProdCd.substring(0,1) == "A"  ) {	// SIDE 속성
						csSideMenu = "▷";
						csStatus   = "속성";
					} 
					else {
						if(!!csProdNm && csProdNm.substr(0,1) != '▶'){
							csSideMenu = "▶";
						}
						csStatus   = "선택" ;
					}
				}

				if( inSaleQty < 0 )
				{
					csStatus = "취소";
				}

				csDblFg      = row[ "PROP_CD"       ];                          // 2016-09-27-JYL
																				// [곱빼기]
				csPriceMgrYn = row[ "PRICE_MGR_YN" ];
				csSdaNm		 = row[ "SDA_NM"       ];	// 사이드메뉴 속성명 출력 처리.
				csDlvPackFg  = row[ "DLV_PACK_FG"  ];	// 배달포장구분.

				if( csDlvPackFg == "2")  {
					csStatus = "포장";
				}
				else if( csDlvPackFg == "1")  {
					csStatus = "배달";
				}

				if( !pu.isEmpty ( csSdaNm  ) ) {
					if( this.g_inPaperTypeFg == 0 ) {
						csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 8 ), 8 );
					} else {
						csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 15 ), 15 );
					}
				} else {
					if( this.g_inPaperTypeFg == 0 ) {
						csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csProdNm, 14 ), 14 );
					}
					else {
						csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csProdNm, 23 ), 23 );
					}
				}

				if( !pu.isEmpty ( csSdaNm ) ) {
					csProdLine  = "\r\n";
					csProdLine += csProdNm;
					csProdLine += "[";
					csProdLine += pu.RPad( pu.DllGetCutHangul( csSdaNm, 6 ), 6 );
					csProdLine += "]";
				} else {
					csProdLine = "\r\n" + csProdNm;
				}

				csTemp += csProdLine;
				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += pu.LPad( util.numberWithCommas( csSaleQty ), 4 );
				}
				else {
					csTemp += pu.LPad( util.numberWithCommas( csSaleQty ), 5 );
				}

				csSaleAmt = util.numberWithCommas( row[ "SALE_AMT" ] );

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += pu.LPad( csSaleAmt, 7 );
					csTemp += pu.LPad( csStatus,  4 );
				}
				else  {
					csTemp += pu.LPad( csSaleAmt, 9 );
					csTemp += pu.LPad( csStatus,  5 );
				}

				lnDcmSaleAmt = pu.parseInt(row[ "SALE_AMT" ]);
				lnDcSumAmt  += pu.parseInt(row[ "SALE_AMT" ]) - pu.parseInt(row[ "DCM_SALE_AMT" ]);
				lnVatAmt     = pu.parseInt(row[ "VAT_AMT"  ]);

				this.m_lnOrderTotAmt += lnDcmSaleAmt;
				this.m_lnOrderVatAmt += lnVatAmt;
			} else if ( pcsCode == "{K-상품리스트}"  ) {
//교환권 -
				// //////////////////////////////////////////////////////////////////////////
				// 2013-0902-Jane : 영수증 상품리스트 출력제어.
				// 2013-1128 Antony.Choi : 고객 퇴점일 경우에는 비교 하지 않음
				// //////////////////////////////////////////////////////////////////////////
				if( !this.m_blProdListPrintFg == true ) {
						continue;
				}

				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부
				if( blZeroUprcProdSkipFg ) {
					continue;
				}
				if( bCnt == 0 ) {
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += "   상 품 명      수량     금 액\r\n";
						csTemp += "-------------------------------";
					}
					else {
						csTemp += "    상  품  명       단 가  수량     금 액\r\n";
						csTemp += "------------------------------------------";
					}
				}
				////////////////////////////////////////////////////////////////////
				// 상품명 좌측정렬 변경처리.
				////////////////////////////////////////////////////////////////////
				csDblFg  = row[ "PROP_CD"  ];                               // 2016-09-27-JYL [곱빼기]
				csProdNm = row[ "PROD_NM" ];                               // 2016-09-27-JYL [곱빼기]
				csProdNm = this.GetProdNmDbl( csProdNm, (  pu.parseInt (csDblFg) == 1 ? true : false  ) );  // 2016-09-27-JYL [곱빼기]
				
				
				if( row[ "SIDE_MENU_YN" ] == "N" &&  row[ "SDS_ORG_DTL_NO" ]/** .asShort__ **/ > 0 ) {
					if( csProdCd.substr( 0 ,   1 ) == "A" ) {
						csTemp += "\r\n▷";
					} else {
						if(!!csProdNm && csProdNm.substr(0,1) != '▶'){
							csTemp += "\r\n▶";
						}else{
							csTemp += "\r\n";
						}
					}
					csTemp += pu.RPad( pu.DllGetCutHangul( csProdNm, 15 ), 15 );

				} else {
					csTemp += "\r\n" + pu.RPad( pu.DllGetCutHangul( csProdNm, 17 ), 17 );
				}

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 4  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "AMT" ] ), 10 );
				} else {
					csTemp += pu.LPad( util.numberWithCommas( row[ "UPRC" ] ), 9  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "QTY"  ] ), 5  );
					csTemp += pu.LPad( util.numberWithCommas( row[ "AMT"  ] ), 11 );
				}

				/**
				 * 2022-05-26 1회용 컵 보증금이 있으면 상품명 바로 아래 사이드메뉴와 같은 형태로 추가한다.
				 */
				if(!!orderInfo.POS_ODDTL_T){ // 주문하는 과정에서 영수증 출력인 경우
					for(var cup=0;cup<orderInfo.POS_ODDTL_T.length;cup++){ // 현재 주문한 객체 for문
						var voDtl = orderInfo.POS_ODDTL_T[cup];
						if(row[ "PROD_CD"  ] == voDtl.PROD_CD){ // 현재 상품과 dtl객체의 상품이 같으면
							if(!!voDtl.cupList){ // dtl객체에 cupList가 존재한다면							
								csTemp += "\r\n▷";
								csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 15 ), 15 );
								if( this.g_inPaperTypeFg == 0 ) {
									csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_CNT ), 4  );
									csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_AMT ), 10 );	
								}else{
									if(voDtl.cupList[0].CUP_TYPE == "disposableCup"){ // 1회용보증금 컵일 때 보증금 단가 
										csTemp += pu.LPad( util.numberWithCommas( gCupUprc ), 9  );
									}else{ // 1회용 보증금 컵이 아닌 경우에 보증금 단가 0원
										csTemp += pu.LPad( util.numberWithCommas( "0" ), 9  );
									}
									csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_CNT ), 5  );
									csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_AMT ), 11 );
								}
								
							}
						}
					}
				}else{ // 주문하는 과정에서의 영수증 출력이 아닌 경우 (관리자에서 재출력 등)
					if(!!row["CUP_SALE_CNT"]){ // 컵 개수가 존재할 때만 재출력 대상이 된다.
						if(row["CUP_FG"] != "PRSNL" && row["CUP_FG"] != "STORE"){ // ODDTL_T 테이블의 CUP_FG 값이 개인/매장 컵이 아닌 경우 (1회용 컵인 경우)
							csTemp += "\r\n▷";
							csTemp += pu.RPad( pu.DllGetCutHangul( "1회용컵", 15 ), 15 );
							var vsAmt = "" + (Number(row["CUP_SALE_CNT"]) * Number(row["CUP_DEPOSIT_UPRC"]));
							if( this.g_inPaperTypeFg == 0 ) {
								csTemp += pu.LPad( util.numberWithCommas( row["CUP_SALE_CNT"] ), 4  );
								csTemp += pu.LPad( util.numberWithCommas( vsAmt ), 10 );	
							}else{
								csTemp += pu.LPad( util.numberWithCommas( row["CUP_DEPOSIT_UPRC"] ), 9  );
								csTemp += pu.LPad( util.numberWithCommas( row["CUP_SALE_CNT"] ), 5  );
								csTemp += pu.LPad( util.numberWithCommas( vsAmt ), 11 );
							}
						}else{
							csTemp += "\r\n▷";
							if(row["CUP_FG"] == "PRSNL"){ // 개인컵인 경우
								csTemp += pu.RPad( pu.DllGetCutHangul( "개인컵", 15 ), 15 );
							}else if (row["CUP_FG"] == "STORE"){
								csTemp += pu.RPad( pu.DllGetCutHangul( "매장컵", 15 ), 15 );
							}else{
								csTemp += pu.RPad( pu.DllGetCutHangul( "", 15 ), 15 );
							}						
							if( this.g_inPaperTypeFg == 0 ) {
								csTemp += pu.LPad( util.numberWithCommas( row["CUP_SALE_CNT"] ), 4  );
								csTemp += pu.LPad( util.numberWithCommas( "0" ), 10 );	
							}else{
								csTemp += pu.LPad( util.numberWithCommas( "0" ), 9  );
								csTemp += pu.LPad( util.numberWithCommas( row["CUP_SALE_CNT"] ), 5  );
								csTemp += pu.LPad( util.numberWithCommas( "0" ), 11 );
							}
						}
					}
				}
				
				if(row["PRICE_MGR_FG"] == "2" && row["SALE_WEIGHT"]/** .asLong__ **/ > 0) {
					csProdNm  = "(%sg)".sprintf( util.numberWithCommas(row["SALE_WEIGHT"]));
					csTemp += pu.RPad(csProdNm, 17);
				}
			}
			bCnt++;
		}

		// //////////////////////////////////////////////////////////////////////////
		// 2009-1202-YBC
		// //////////////////////////////////////////////////////////////////////////
		if( pcsCode == "{이전차수-메뉴목록}"
		||  pcsCode == "{이전차수-메뉴목록-금액}")  {
			if( this.g_inPaperTypeFg == 0 ) {
				csTemp += "\r\n--------------------------------" ;
			}
			else {
				csTemp += "\r\n------------------------------------------";
			}
		}

		if( pcsCode == "{주문서-메뉴출력형태-금액}")  {
			if( this.g_inPaperTypeFg == 0 ) {
				csTemp += "\r\n--------------------------------";
			}
			else {
				csTemp += "\r\n------------------------------------------" ;
			}


			// //////////////////////////////////////////////////////////////////////
			// 부가세별도 매장에 대한 부가세액 표기.
			// //////////////////////////////////////////////////////////////////////
			let lnTotPrintAmt = this.m_lnOrderTotAmt - lnDcSumAmt;

			// 2018-01-22-HJH [봉사료] : 고객주문서 출력시 봉사료 누락
			let stResult = this.GetEtcValue(m_stSaleInfo.SHOP_CD, m_stSaleInfo.SALE_DATE, m_stSaleInfo.ORDER_NO) ;

			if( !pu.isEmpty( stResult ))
			{
				if( this.g_inPaperTypeFg == 0 )
				{
					csTemp += "\r\n     주  문  금  액 : ";
				}
				else
				{
					csTemp += "\r\n        주  문  금  액   : ";
				}

				csTemp += pu.LPad( util.numberWithCommas( this.m_lnOrderTotAmt ), 10);

				if(!inSvcTipTypeFg && stResult.SVC_TIP_AMT > 0) // 봉사료 별도일경우
				{
					if( this.g_inPaperTypeFg == 0 )
					{
						csTemp += "\r\n     봉   사   료 : " ;
					}
					else
					{
						csTemp += "\r\n        봉    사    료   : ";
					}
					lnTotPrintAmt += stResult.SVC_TIP_AMT;
					csTemp += pu.LPad( util.numberWithCommas( stResult.SVC_TIP_AMT ), 10);
				}else if( stResult.SVC_TIP_AMT > 0 ) // 봉사료 별도일경우
				{
					if( this.g_inPaperTypeFg == 0 )
					{
						csTemp += "\r\n     봉   사   료 : ";
					}
					else
					{
						csTemp += "\r\n        봉    사    료   : ";
					}
					csTemp += pu.LPad( util.numberWithCommas( stResult.SVC_TIP_AMT ), 10);
				}

				if(stResult.TOT_DC_AMT > 0)
				{
					if( this.g_inPaperTypeFg == 0 )
					{
						csTemp += "\r\n     할  인  금  액 : ";
					}
					else
					{
						csTemp += "\r\n        할  인  금  액   : ";
					}
					csTemp += pu.LPad( util.numberWithCommas( stResult.TOT_DC_AMT ), 10);
				}

				if(!inTaxTypeFg && stResult.VAT_AMT > 0)
				{
					if( this.g_inPaperTypeFg == 0 )
					{
						csTemp += "\r\n     부  가  세  액 : ";
					}
					else
					{
						csTemp += "\r\n        부  가  세  액   : ";
					}
					lnTotPrintAmt += stResult.VAT_AMT;
					csTemp += pu.LPad( util.numberWithCommas( stResult.VAT_AMT ), 10);
				}
			}

			/*
			 * if( inTaxTypeFg == 0 ) { lnTotPrintAmt += m_lnOrderVatAmt; }
			 */
			if( this.g_inPaperTypeFg == 0 ) {
				csTemp += "\r\n주 문  합 계  금 액 : ";
			}
			else {
				csTemp += "\r\n주  문  합  계  금  액   : ";
			}

			lnTotPrintAmt = this.GetAmountRivision( lnTotPrintAmt );	// 짜투리
																		// 금액보정.

			csTemp += pu.LPad( util.numberWithCommas( lnTotPrintAmt ), 10 );
		}

		// //////////////////////////////////////////////////////////////////////////
		// 이용권합계.
		// //////////////////////////////////////////////////////////////////////////
		if(  this.m_stSaleInfo.TITLE == "이용권( 보관용 )")  {
			if( pu.parseInt( this.GetEnvXmlShopENV( 128 ) )  == 0 ) {
				lnSaleAmt += lnVatAmt;
			}

			if( this.g_inPaperTypeFg == 0 ) {
				csTemp += "--------------------------------";
				csTemp += pu.GetPRTDeviceCMD( "V2X") ;
				csTemp1 =  "%16s %16s" .sprintf( "합계금액 : ", util.numberWithCommas(lnSaleAmt ));
				csTemp += csTemp1;
			}
			else {
				csTemp += "------------------------------------------";
				csTemp += pu.GetPRTDeviceCMD( "V2X") ;
				csTemp1 = "%20s %20s" . sprintf ( "합계금액 : ", util.numberWithCommas( lnSaleAmt ));
				csTemp += csTemp1;
			}
			csTemp += pu.GetPRTDeviceCMD( "NORM");
		}

		return csTemp;

	}


	this.GetProdNmDbl = function ( p_csProdNm, /** BOOL * */ p_blDbl, /** BOOL * */ p_blTrimLeft) {
		util.logInfo("*** GetProdNmDbl START ***");
		let csRet  = "";
		let csMark = "[곱]"; // 곱빼기
		let inFind = 0;

		if( p_blTrimLeft ) {
			p_csProdNm = p_csProdNm.ltrim();
		}

		csRet  = p_csProdNm;
		inFind = p_csProdNm.indexOf(csMark);

		if( p_blTrimLeft )
		{ // Trim 일경우
			if( p_blDbl == true ) {
				if( inFind != 0 )
				{ // 처음위치에 "[곱]" 이 없을 경우 추가함.
					csRet = csMark + p_csProdNm;
				}
			} else {
				if( inFind == 0 )
				{ // 처음위치에"[곱]" 이 있을 경우 제거함.
					csRet = csRet.replace( csMark, "" );
				}
			}
		} else { // Trim을 하지 않을 경우

			// 곱빼기 버튼을 눌러서 진입했을 경우
			if( p_blDbl == true ) {
				let    val;
				let     i       = 0;
				let     inLen   = 0;

				csRet  = "";

				p_csProdNm = p_csProdNm.replace( csMark, "" ); // 기존에 [곱]이 들어
																// 있는 경우 제거처리 후
																// 진행.
				inLen = p_csProdNm.length;
				for( i=0; i < inLen; i++)
				{
					val = p_csProdNm[i];
					if( val == ' ' )
					{
						csRet  += val;
					}
					else
					{
						break;
					}
				}

				inFind = p_csProdNm.indexOf( "*" );
				if( inFind >= 0 )
				{
					csRet += "*";
					i+=1;
				}

				inFind = p_csProdNm.indexOf( "▷" );
				if( inFind >= 0 )
				{
					csRet += "▷";
					i+=2;
				}

				inFind = p_csProdNm.indexOf( "▶");
				if( inFind >= 0 )  {
					csRet += "▶";
					i+=2;
				}

				csRet  += csMark; // [곱] 추가

				if( i < inLen ) {
					csRet += p_csProdNm.substring(i, inLen - i);
				}

			} else {
				csRet = csRet.replace( csMark, "" );
			}
		}

		return csRet;
	}


	this.GetEtcValue = function (csSHOP_CD,  csSALE_DATE,  ORDER_NO) {
		let sql = _sql.GetEtcValueSQL();

		let db_result = gfn_SQLiteSQLProcess( sql , [csSHOP_CD,  csSALE_DATE,  ORDER_NO]);

		if ( pu.isEmpty(db_result )  || pu.isEmptypu.isEmpty( db_result.Data)  ) {
			// throw "[Print]기타금액 정보가져오기에 실패하였습니다.";
			return null;
		}
		return  db_result.Data[0];

	}

	// 신용승인정보를 만든다.
	this.GetSalesCardData = function( pcsCode /* =_T("") */) {
		util.logInfo("*** GetSalesCardData START ***");


		let blCorner    = false;
		let blCornerRun = false;

		let blReducePrint = false;

		let bCnt       = 0;
		let bCornerCnt = 0;

		let csQrySql	    = "";
		let csTemp	        = "";
		let csResult	    = "";
		let csTempStr	    = "";
		let	csIssCrdCpNm    = "";
		let csCrdCpNm       = "";
		let csCrdCardNo     = "";
		let	csSaleYn        = "";
		let csCrdSlipData   = "";
		let	csLineTemp      = "";

		let csCornerBizNo	= "";	// 2009-1228-YBC
		let csCornerOwnerNm = "";	// 2009-1228-YBC
		let csCornerCd      = "";	// 2009-1228-YBC
		let csCornerNm      = "";	// 2009-1228-YBC
		let csLeftStr       = "";	// 2009-1228-YBC
		let csRightStr      = "";	// 2009-1228-YBC
		let csChgBillNo     = "";	// 2010-0129-JJM.
		let csValue         = "";	// 2011-1107-JJM : .

		let AlipayBroadMsg = "";
		let AlipayUserID   = "";
		let AlipayAmtCny   = "";
		let AlipayExRate   = "";
		let AlipayTransID  = "";
		let AlipayBarcode  = "";

		if ( pu.isEmpty(pcsCode )) {
			pcsCode = "";
		} else {
			if ( pcsCode.substr(1,1) == "R") {
				blReducePrint = true;
			}
		}

		// //////////////////////////////////////////////////////////////////////////
		// 2010-0407-JJM. 교환권번호출력, 코너사용시 출력
		// 2011-0110-JJM : 교환번호 출력은 코너사용 안에서 처리.
		// //////////////////////////////////////////////////////////////////////////
		blCorner = pu.parseInt( this.GetEnvXmlShopENV( 114 )  ) == "1";

		let sql = _sql.GetSalesCardData_SQL(this.m_stSaleInfo , blCorner);
		let db_result = gfn_SQLiteSQLProcess( sql , []);
		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data)  || db_result.Data.length == 0 ) {
			util.logInfo("***** GetSalesCardData  db_result is NULL. GO Return*****");
			return false;
		}

		let rows = db_result.Data ;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];

			if( bCnt > 0
			&& row[ "LINE_NO" ] != csLineTemp ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += "--------------------------------";
				}
				else {
					csTemp += "------------------------------------------";
				}
			}

			if( row[ "LINE_NO" ] != csLineTemp ){

				if ( row[ "UNION_PAY_FG" ] == "6" || row[ "UNION_PAY_FG" ] == "7" ){
					AlipayBroadMsg = row[ "BROAD_MSG" ];

					AlipayTransID = pu.AfxExtractSubString(  AlipayBroadMsg, 0, '^');
					AlipayAmtCny  = pu.AfxExtractSubString(  AlipayBroadMsg, 1, '^');
					AlipayExRate  = pu.AfxExtractSubString(  AlipayBroadMsg, 2, '^');
					AlipayUserID  = pu.AfxExtractSubString(  AlipayBroadMsg, 3, '^');
					// 2019-02-14 KLC : 위챗 환율 출력 추가
					if (AlipayExRate != undefined &&  (parseFloat(AlipayExRate.trim() ) > 0 && row[ "UNION_PAY_FG" ] == "6"))
					{
						AlipayExRate ="%.8f".sprintf( parseFloat($.trim( AlipayExRate ) ) * 1000);
					}else if ( AlipayAmtCny != undefined && (parseFloat(AlipayAmtCny.trim() ) > 0 && row[ "UNION_PAY_FG" ] == "7"))
					{
						AlipayAmtCny=  "%.2f".sprintf( parseFloat($.trim( AlipayAmtCny ) ) / 100);
					}


					AlipayBarcode = row[ "APPR_NO" ];

				}


				if( row[ "SALE_YN" ] == "Y" )	{
					if( row[ "UNION_PAY_FG" ] == "4" ) {
						csSaleYn = "현금IC승인";			// 2014-1124-Jane : 현금IC
														// 추가.
					} else if ( row[ "UNION_PAY_FG" ] == "6" || row[ "UNION_PAY_FG" ] == "7" ){
						csSaleYn = "APPROVE";
					} else {
						csSaleYn = "신용승인";
					}

				}
				else {
					if( row[ "UNION_PAY_FG" ] == "4" ) {
						csSaleYn = "현금IC취소";		// 2014-1124-Jane : 현금IC 추가.
					} else if ( row[ "UNION_PAY_FG" ] == "6" || row[ "UNION_PAY_FG" ] == "7" ){
						csSaleYn = "CANCEL  ";
					} else {
						csSaleYn = "신용취소";
					}
				}

				if( row[ "SIGN_PAD_YN" ] == "Y" ) {
					this.m_blSignPadUseFg = true;
				} else {
					this.m_blSignPadUseFg = false;
				}

				csIssCrdCpNm = row[ "ISS_CRDCP_NM" ];
				csCrdCpNm    = row[ "CRDCP_NM"     ];
				csCrdCardNo  = row[ "CRD_CARD_NO"  ];

				if( this.g_inPaperTypeFg == 0 ) {

					if ( row[ "UNION_PAY_FG" ] == "6" ) {
						csTempStr = "{ALIPAY-LOGO}\r\n" ;
						csTemp += csTempStr;
						csTempStr = "**ALIPAY+ %s(Customer)[%d]**\r\n".sprintf( csSaleYn, ++bCnt );
						csTemp += csTempStr;

					}else if ( row[ "UNION_PAY_FG" ] == "7" ) {
						csTempStr = "{WECHAT-LOGO}\r\n" ;
						csTemp += csTempStr;
						csTempStr = "**WECHATPAY %s(Customer)[%d]**\r\n".sprintf( csSaleYn, ++bCnt );
						csTemp += csTempStr;

					} else {

						csTempStr = "***%s정보(고객용)[%d]***\r\n".sprintf( csSaleYn, ++bCnt );
						csTemp += csTempStr;
					}

// csTemp += "카드종류: ";
					if( row[ "APPR_PROC_FG" ]/** .asShort() * */ == 2 )	{
						csTemp += pu.BASE_PRINT[ "V2X" ];
						csTemp += pu.BASE_PRINT[ "REVERSE_ON" ];
						csTemp += " ** 단말기  승인요망 ** \r\n";		// 2014-0716-Jane
																// : 임의등록 문구 변경
						csTemp += pu.BASE_PRINT[ "NORM" ];
						csTemp += pu.BASE_PRINT[ "REVERSE_OFF" ];
						csTemp += pu.BASE_PRINT[ "INIT" ];
					}
					// 2014-0711-Jane : 비승인 수기등록 항목 추가.
					else if( row[ "APPR_PROC_FG" ]/** .asShort() * */ == 0 )	{

						csTemp += "카드종류: ";
						csTemp += LPad("** ASP수기등록매출 **", 22 ) + "\r\n";

					} else {
						if( row[ "UNION_PAY_FG" ] == "4" ) {		// 2014-1124-Jane
																	// : 현금IC카드
																	// 추가.
							csTemp += "발급기관: ";
							csTemp += pu.DllGetCutHangul( csIssCrdCpNm, 22 ) + "\r\n";

						} else if ( row[ "UNION_PAY_FG" ] == "6" || row[ "UNION_PAY_FG" ] == "7") {
							csTemp += "CARD NAME: ";
							csTemp += pu.DllGetCutHangul( csIssCrdCpNm, 22 ) + "\r\n";

						} else {
							// 2018-11-15 KLC : 영수증 간소화 처리
							if ( blReducePrint == true ) {

								csTemp += "카드/매입사: ";
								csTemp += csIssCrdCpNm + " / " + csCrdCpNm + "\r\n";

							}else {

								csTemp += "카드종류: ";
								csTemp += pu.DllGetCutHangul( csIssCrdCpNm, 22 ) + "\r\n";

							}
						}
					}

					if( row[ "UNION_PAY_FG" ] == "4" ) {		// 2014-1124-Jane
																// : 현금IC카드 추가.
						csTemp += "계좌번호: ";
					} else if ( row[ "UNION_PAY_FG" ] == "6" || row[ "UNION_PAY_FG" ] == "7" ) {

					} else {
						csTemp += "카드번호: ";
					}

					if( row[ "UNION_PAY_FG" ] == "4" ) {			// 2014-1124-Jane
																	// : 현금IC카드
																	// 추가.
						csTemp += csCrdCardNo + "\r\n";
					} else if ( row[ "UNION_PAY_FG" ] == "6" || row[ "UNION_PAY_FG" ] == "7" ) {

					} else {
						csTemp += this.DllSetCrdCardNoMasking( csCrdCardNo ) + "\r\n";
					}

				} else {

					if ( row[ "UNION_PAY_FG" ] == "6" ) {
						csTempStr=  "{ALIPAY-LOGO}\r\n" ;
						csTemp += csTempStr;
						csTempStr = "     **ALIPAY+ %s(Customer)[%d]**\r\n".sprintf( csSaleYn, ++bCnt );
						csTemp += csTempStr;

					} else if ( row[ "UNION_PAY_FG" ] == "7" ) {

						csTempStr = "{WECHAT-LOGO}\r\n" ;
						csTemp += csTempStr;
						csTempStr = "     **WECHATPAY %s(Customer)[%d]**\r\n".sprintf( csSaleYn, ++bCnt );
						csTemp += csTempStr;

					} else {
						// 20190920-HJH BCQR 추가
						if( row[ "CARD_IN_FG" ] == "E" )
							csTempStr = "  *** %s정보(고객용)[%d](BC-QR) ***\r\n".sprintf( csSaleYn, ++bCnt );
						else
							csTempStr = "     *** %s정보(고객용)[%d] ***\r\n".sprintf( csSaleYn, ++bCnt );

						csTemp += csTempStr;
					}

// csTemp += "카 드 종 류: ";
					// 2014-0716-Jane : 임의등록 문구 강조
					if( row[ "APPR_PROC_FG" ]/** .asShort() * */ == 2 ) {
						csTemp += pu.BASE_PRINT[ "HV2X" ] ;
						csTemp += pu.BASE_PRINT[ "REVERSE_ON" ];
						csTemp += "** 단말기 승인요망 **\r\n";
						csTemp += pu.BASE_PRINT[ "NORM" ];
						csTemp += pu.BASE_PRINT[ "REVERSE_OFF" ];
						csTemp += pu.BASE_PRINT[ "INIT" ];
					}
					// 2014-0711-Jane : 비승인 수기등록 항목 추가.
					else if( row[ "APPR_PROC_FG" ]/** .asShort() * */ == 0 )  {
						csTemp += "카 드 종 류: ";
						csTemp += LPad("**  ASP수기등록매출 **", 29 ) + "\r\n";

					} else {
						if( row[ "UNION_PAY_FG" ] == "4" ) {		// 2014-1124-Jane
																	// : 현금IC카드
																	// 추가.
							csTemp += "발 급 기 관: ";
							csTemp += pu.DllGetCutHangul( csIssCrdCpNm, 28 ) + "\r\n";
						} else if ( row[ "UNION_PAY_FG" ] == "6" || row[ "UNION_PAY_FG" ] == "7" ) {
							csTemp += "CARD NAME: ";
							csTemp += pu.DllGetCutHangul( csIssCrdCpNm, 28 ) + "\r\n";

						} else {
							// 2018-11-15 KLC : 영수증 간소화 처리
							if ( blReducePrint == true ) {
								csTemp += "카드/매입사: ";
								csTemp += pu.DllGetCutHangul( csIssCrdCpNm, 28 ) + " / " +pu.DllGetCutHangul( csCrdCpNm, 12 ) + "\r\n";
							} else {
								csTemp += "카 드 종 류: ";
								csTemp += pu.DllGetCutHangul( csIssCrdCpNm, 28 ) + "\r\n";
							}
						}
					}

					if( row[ "UNION_PAY_FG" ] == "4" ) {			// 2014-1124-Jane
																	// : 현금IC카드
																	// 추가.
							csTemp += "계 좌 번 호: ";
					} else if ( row[ "UNION_PAY_FG" ] == "6" || row[ "UNION_PAY_FG" ] == "7" ) {

					} else {
						csTemp += "카 드 번 호: ";
					}

					if( row[ "UNION_PAY_FG" ] == "4" ) {			// 2014-1124-Jane
																	// : 현금IC카드
																	// 추가.
						csTemp += csCrdCardNo + "\r\n";
					} else if ( row[ "UNION_PAY_FG" ] == "6" || row[ "UNION_PAY_FG" ] == "7") {

					} else {
						csTemp += this.DllSetCrdCardNoMasking( csCrdCardNo ) + "\r\n";
					}

				}

				bCornerCnt = 0;
			}

			if( blCorner == true /** TRUE * */ ) {
				csCornerCd		= row[ "CORNER_CD"   ];
				csCornerNm		= row[ "CORNER_NM"   ];
				csCornerBizNo	= this.GetEnvXmlCornerENV( csCornerCd , "BIZ_NO"	);
				csCornerOwnerNm = this.GetEnvXmlCornerENV( csCornerCd , "OWNER_NM" );
				csCornerBizNo   = pu.DllTransAtoA_Format( csCornerBizNo, "BIZ_NO" );
				csChgBillNo     = row[ "CHG_BILL_NO" ];

				if( util.byteLen( csCornerOwnerNm ) > 6 ) {
					csCornerOwnerNm = csCornerOwnerNm.cutStr( 6 );
				}

				// //////////////////////////////////////////////////////////////////
				// 2010-0129-JJM.
				// 2011-0110-JJM : 교환번호 출력 옵션.
				// //////////////////////////////////////////////////////////////////
				csTemp += "\r\n";

				if( pu.parseInt( this.GetEnvXmlShopENV( 152 ) ) == 0 ){
					csLeftStr= "▶%s\r\n".sprintf( csCornerNm );
				}
				else {
					csLeftStr = "▶%s [ %s ]\r\n".sprintf( csCornerNm, csChgBillNo );
				}
				csTemp += csLeftStr;

				if( this.g_inPaperTypeFg == 0 ) {
					if ( row[ "UNION_PAY_FG" ] == "6" || row[ "UNION_PAY_FG" ] == "7")
					{
						csRightStr = "Owner: %s [%s]\r\n".sprintf( csCornerBizNo, csCornerOwnerNm );
					}
					else{
						csRightStr =  "사 업 자: %s [%s]\r\n".sprintf( csCornerBizNo, csCornerOwnerNm );
					}
				}
				else {
					if ( row[ "UNION_PAY_FG" ] == "6" || row[ "UNION_PAY_FG" ] == "7" )
					{
						csRightStr = "Registration  No : %s [ %s ]\r\n".sprintf( csCornerBizNo, csCornerOwnerNm );
					}
					else{
						csRightStr = "사업자 번호: %s [ %s ]\r\n".sprintf( csCornerBizNo, csCornerOwnerNm );
					}
				}

				csTemp += csRightStr;

				if( this.g_inPaperTypeFg ==  0 ) {
					if( row[ "UNION_PAY_FG" ] == "6" ) 	{		// 2017-0531
																// Antony.Choi :
																// 알리페이 추가
						// AlipayUserID
						// AlipayAmtCny
						// AlipayExRate
						// AlipayTransID
						if(AlipayUserID != undefined){
							csTemp += "ALIPAY USER LOGIN ID: " + AlipayUserID.trim() + "\r\n";
						}
						
						csTemp += "AMOUNT(KRW): " + util.numberWithCommas( row[ "APPR_AMT" ] ) + "KRW \r\n";
						
						if(AlipayAmtCny != undefined){
							csTemp += "AMOUNT(RMB): " + AlipayAmtCny.trim() + "RMB\r\n";
						}
						
						if(AlipayExRate != undefined){
							csTemp += "EXCHANGE RATE: 1000KRW=" + AlipayExRate.trim() + "RMB\r\n";
						}
						

					}else if( row[ "UNION_PAY_FG" ] == "7" ) 	{		// 2017-0531
																		// Antony.Choi
																		// :
																		// 알리페이
																		// 추가

						// AlipayUserID
						// AlipayAmtCny
						// AlipayExRate
						// AlipayTransID
						csTemp += "AMOUNT(KRW): " + util.numberWithCommas( row[ "APPR_AMT" ] ) + "KRW \r\n";
						
						// 2019-02-14 KLC : 위챗 환율 출력 추가
						if(AlipayAmtCny != undefined){
							csTemp += "AMOUNT(RMB): " + AlipayAmtCny.trim() + "RMB\r\n";
						}
						

					} else {
						// 2018-11-15 KLC : 영수증 간소화 처리
						if( row[ "UNION_PAY_FG" ] != "4" && blReducePrint == false ) 			// 2014-1124-Jane
																								// :
																								// 현금IC카드
																								// 추가.
						{
							if( row[ "INST_MM_FG" ] == "0" ) {
								csTemp += "결제방법: " + row[ "INST_MM_NM" ] + "\r\n";
							}
							else {
								csTemp += "결제방법: " + row[ "INST_MM_NM" ] + "( " + row[ "INST_MM_CNT" ] + " )" + "\r\n";
							}
						}
						// 2018-11-15 KLC : 영수증 간소화 처리
						if ( blReducePrint == false ) {
							csTemp += "매 입 사: " + pu.DllGetCutHangul( csCrdCpNm, 12 ) + "\r\n";
							csTemp += "승인금액: " + util.numberWithCommas( row[ "APPR_AMT" ] )+ "\r\n";

						} else {
							csTemp += "승인금액: " + util.numberWithCommas( row[ "APPR_AMT" ] );
							if( row[ "INST_MM_FG" ] == "0" ) {
								csTemp += "(" + row[ "INST_MM_NM" ] + ")" + "\r\n";
							} else {
								csTemp += "(" + row[ "INST_MM_NM" ] + "-" + row[ "INST_MM_CNT" ] + " )" + "\r\n";
							}
						}
					}

				} else {
					if( row[ "UNION_PAY_FG" ] == "6" ) {			// 2017-0531
																	// Antony.Choi
																	// : 알리페이 추가

						// AlipayUserID
						// AlipayAmtCny
						// AlipayExRate
						// AlipayTransID
						if(AlipayUserID != undefined){
							csTemp += "ALIPAY USER LOGIN ID: " + AlipayUserID.trim() + "\r\n";
						}
						
						csTemp += "AMOUNT(KRW): " + util.numberWithCommas( row[ "APPR_AMT" ] ) + "KRW \r\n";
						
						if(AlipayAmtCny != undefined){
							csTemp += "AMOUNT(RMB): " + AlipayAmtCny.trim() + "RMB\r\n";
						}
						
						if(AlipayExRate != undefined){
							csTemp += "EXCHANGE RATE: 1000KRW=" + AlipayExRate.trim() + "RMB\r\n";
						}
						
					}else if( row[ "UNION_PAY_FG" ] == "7" )  {	 // 2017-0531
																	// Antony.Choi
																	// : 알리페이 추가

						// AlipayUserID
						// AlipayAmtCny
						// AlipayExRate
						// AlipayTransID
						csTemp += "AMOUNT(KRW): " + util.numberWithCommas( row[ "APPR_AMT" ] ) + "KRW \r\n";
						// 2019-02-14 KLC : 위챗 환율 출력 추가
						if(AlipayAmtCny != undefined){
							csTemp += "AMOUNT(RMB): " + AlipayAmtCny.trim() + "RMB\r\n";
						}
						

					} else {
						// 2018-11-15 KLC : 영수증 간소화 처리
						if( row[ "UNION_PAY_FG" ] != "4" && blReducePrint == false) { 			// 2014-1124-Jane
																								// :
																								// 현금IC카드
																								// 추가.
							if( row[ "INST_MM_FG" ] == "0" ) {
								csTemp += "결 제 방 법: " + row[ "INST_MM_NM" ] + "\r\n";
							} else {
								csTemp += "결 제 방 법: " + row[ "INST_MM_NM" ] + "( " + row[ "INST_MM_CNT" ] + " )" + "\r\n";
							}
						}
						// 2018-11-15 KLC : 영수증 간소화 처리
						if ( blReducePrint == false ) {
							csTemp += "전표 매입사: " + pu.DllGetCutHangul( csCrdCpNm, 12 ) + "\r\n";
							csTemp += "승 인 금 액: " + util.numberWithCommas( row[ "APPR_AMT" ] ) + "\r\n";
						} else {
							csTemp += "승 인 금 액: " + util.numberWithCommas( row[ "APPR_AMT" ] );
							if( row[ "INST_MM_FG" ] == "0" ) {
								csTemp += "(" + row[ "INST_MM_NM" ] + ")" + "\r\n";
							} else {
								csTemp += "(" + row[ "INST_MM_CNT" ] + " )" + "\r\n";
							}
						}
					}
				}
			}
			else {
				if( row[ "UNION_PAY_FG" ] == "6" ) 	{		// 2017-0531
															// Antony.Choi :
															// 알리페이 추가
					// AlipayUserID
					// AlipayAmtCny
					// AlipayExRate
					// AlipayTransID
					if(AlipayUserID != undefined){
						csTemp += "ALIPAY USER LOGIN ID: " + AlipayUserID.trim() + "\r\n";
					}
					
					csTemp += "AMOUNT(KRW): " + util.numberWithCommas( row[ "APPR_AMT" ] ) + "KRW \r\n";
					
					if(AlipayAmtCny != undefined){
						csTemp += "AMOUNT(RMB): " + AlipayAmtCny.trim() + "RMB\r\n";
					}
					
					if(AlipayExRate != undefined){
						csTemp += "EXCHANGE RATE: 1000KRW=" + AlipayExRate.trim() + "RMB\r\n";
					}
					
				} else if( row[ "UNION_PAY_FG" ] == "7" ) 	{		// 2017-0531
																	// Antony.Choi
																	// : 알리페이 추가
						// AlipayUserID
						// AlipayAmtCny
						// AlipayExRate
						// AlipayTransID
						// csTemp += "ALIPAY USER LOGIN ID: " +
						// AlipayUserID.Trim() + "\r\n";
						csTemp += "AMOUNT(KRW): " + util.numberWithCommas( row[ "APPR_AMT" ] ) + "KRW \r\n";
						// 2019-02-14 KLC : 위챗 환율 출력 추가
						if(AlipayAmtCny != undefined){
							csTemp += "AMOUNT(RMB): " + AlipayAmtCny.trim() + "RMB\r\n";
						}
						
						// csTemp += "EXCHANGE RATE: 1000KRW=" +
						// AlipayExRate.Trim() + "RMB\r\n";

				} else {
					// 2018-11-15 KLC : 영수증 간소화 처리
					if( row[ "UNION_PAY_FG" ] != "4" && blReducePrint == false ) {   // 2014-1124-Jane
																						// :
																						// 현금IC카드
																						// 추가.

						if( row[ "INST_MM_FG" ] == "0" ) {
							csTemp += "결 제 방 법: " + row[ "INST_MM_NM" ] + "\r\n";
						} else {
							csTemp += "결 제 방 법: " + row[ "INST_MM_NM" ] + "( " + row[ "INST_MM_CNT" ] + " )" + "\r\n";
						}
					}

					// 2018-11-15 KLC : 영수증 간소화 처리
					if ( blReducePrint == false ) {
						csTemp += "전표 매입사: " + pu.DllGetCutHangul( csCrdCpNm, 12 ) + "\r\n";
						csTemp += "승 인 금 액: " + util.numberWithCommas( row[ "APPR_AMT" ] ) + "\r\n";
					} else {
						csTemp += "승 인 금 액: " + util.numberWithCommas( row[ "APPR_AMT" ] );
						if( row[ "INST_MM_FG" ] == "0" ) {
							csTemp += "(" + row[ "INST_MM_NM" ] + ")" + "\r\n";
						} else {
							csTemp += "(" + row[ "INST_MM_CNT" ] + " )" + "\r\n";
						}
					}
				}
			}

			if( this.g_inPaperTypeFg == 0 ) {
				if( row[ "UNION_PAY_FG" ] == "6" ) 	{ // 2017-0531 Antony.Choi
														// : 알리페이 추가

					csTemp += "PAYMENT TIME DATE: " + pu.DllTransAtoA_Format( row[ "APPR_DATE" ] + row[ "APPR_TIME" ], "YYYY-MM-DD HH:MM:SS" )+ "\r\n";
					csTemp += "CAT_ID: " +  row[ "VAN_TERM_NO" ] + "\r\n";
					
					if(AlipayTransID != undefined){
						csTemp += "ALIPAY TRANS_ID: " +  AlipayTransID.trim() + "\r\n";
					}
					
					csTemp += "PARTNER TRANS_ID: " +  row[ "APPR_NO" ] + "\r\n";
					if( !this.m_csView ) {

						csResult += "--------------------------------\r\n";


						// AlipayBarcode = row[ "APPR_NO" ];

						let csBarCodeStr = AlipayBarcode;
						let csBarCodeEnd = pu.GetPRTDeviceCMD( "BARCODE_E")  ;

						csBarCodeStr += csBarCodeEnd;

						let csPrtCmd = "";


						let csDispText = pu.GetPRTDeviceCMD( "CT_ALIGN ") + AlipayBarcode;
						// 2014-0417 Antony.Choi : 단말기 출력시 바코드 정보가 잘리는 증상 수정
						if (parseInt( this.GetEnvXmlPosENV( 206 ) ) == 11)
						{
							csPrtCmd =  "%s%s%s%s%s%s".sprintf(
											 pu.GetPRTDeviceCMD( "CT_ALIGN" ) 						// 중앙정렬.
											, pu.GetPRTDeviceCMD( "BARCODE" )							// CODE128
																										// 코드
																										// Set.
											// , csBarCodeStr.length /**
											// .GetLength() **/ // 바코드길이.
											, AlipayBarcode												// 바코드.
											, csDispText												// 출력
																										// Text.
											, pu.GetPRTDeviceCMD( "FEED" )							// Line
																									// Feed.
											, pu.GetPRTDeviceCMD( "LF_ALIGN" ) );						// 좌측정렬.
						}
						else
						{
							csPrtCmd = "%s%s%c%s%s%s%s%s".sprintf(
											  pu.GetPRTDeviceCMD( "CT_ALIGN" )						// 중앙정렬.
											, pu.GetPRTDeviceCMD( "BARCODE"  )						// CODE128
																									// 코드
																									// Set.
											, csBarCodeStr.length /** .GetLength() * */					// 바코드길이.
											, pu.GetPRTDeviceCMD( "BARCODE_E" )						// 바코드구분.
											, AlipayBarcode												// 바코드.
											, csDispText												// 출력
																										// Text.
											, pu.GetPRTDeviceCMD( "FEED" )							// Line
																									// Feed.
											, pu.GetPRTDeviceCMD( "LF_ALIGN" ) );						// 좌측정렬.
						}
						csTemp += csPrtCmd;

					}
				}else if( row[ "UNION_PAY_FG" ] == "7" ) 			// 2017-0531
																	// Antony.Choi
																	// : 알리페이 추가
				{

					csTemp += "PAYMENT TIME DATE: " + pu.DllTransAtoA_Format( row[ "APPR_DATE" ] + row[ "APPR_TIME" ], "YYYY-MM-DD HH:MM:SS" )+ "\r\n";
					csTemp += "CAT_ID: " +  row[ "VAN_TERM_NO" ] + "\r\n";
					
					if(AlipayTransID != undefined){
						csTemp += "WECAHT TRANS ID: " +  AlipayTransID.trim() + "\r\n";
					}
					
					csTemp += "WECAHT AUTH NO: " +  row[ "APPR_NO" ] + "\r\n";
					if( !this.m_csView )
					{

						csResult += "--------------------------------\r\n";


						// AlipayBarcode = row[ "APPR_NO" ];

						let csBarCodeStr = AlipayBarcode;
						let csBarCodeEnd = pu.GetPRTDeviceCMD( "BARCODE_E" );

						csBarCodeStr += csBarCodeEnd;

						let csPrtCmd = "";


						let csDispText = pu.GetPRTDeviceCMD( "CT_ALIGN" ) + AlipayBarcode;
						// 2014-0417 Antony.Choi : 단말기 출력시 바코드 정보가 잘리는 증상 수정
						if (parseInt( this.GetEnvXmlPosENV( 206 ) ) == 11)
						{
							csPrtCmd = "%s%s%s%s%s%s".sprintf(
											  pu.GetPRTDeviceCMD( "CT_ALIGN" )						// 중앙정렬.
											, pu.GetPRTDeviceCMD( "BARCODE"  )						// CODE128
																									// 코드
																									// Set.
											, AlipayBarcode												// 바코드.
											, csDispText												// 출력
																										// Text.
											, pu.GetPRTDeviceCMD( "FEED"     )									// Line
																												// Feed.
											, pu.GetPRTDeviceCMD( "LF_ALIGN" ) );							// 좌측정렬.
						} else {
							csPrtCmd = "%s%s%c%s%s%s%s%s".sprintf(
											  pu.GetPRTDeviceCMD( "CT_ALIGN" )						// 중앙정렬.
											, pu.GetPRTDeviceCMD( "BARCODE"  )						// CODE128
																									// 코드
																									// Set.
											, csBarCodeStr.length /** .GetLength() * */					// 바코드길이.
											, pu.GetPRTDeviceCMD( "BARCODE_E" )						// 바코드구분.
											, AlipayBarcode												// 바코드.
											, csDispText												// 출력
																										// Text.
											, pu.GetPRTDeviceCMD( "FEED" )							// Line
																									// Feed.
											, pu.GetPRTDeviceCMD( "LF_ALIGN" ) );						// 좌측정렬.
						}
						csTemp += csPrtCmd;

					}
				}
				else
				{
					// 2018-11-15 KLC : 영수증 간소화 처리
					if ( blReducePrint == false )
					{
						csTemp += "승인번호: " + row[ "APPR_NO" ] + "\r\n";
					}else
					{
						csTemp += "승인/가맹점: " + row[ "APPR_NO" ] + " / " + row[ "CRDCP_TERM_NO" ] + "\r\n";
					}

					// 2014-0711-Jane : 승인일시가 null일 경우, 영수증에 잘못된 값이 찍히는 문제 수정.
					if( row[ "APPR_DATE" ] != "*" ) {
						csTemp += "승인일시: " + pu.DllTransAtoA_Format( row[ "APPR_DATE" ] + row[ "APPR_TIME" ], "YYYY-MM-DD HH:MM:SS" )+ "\r\n";
					}

					if( row[ "SALE_YN" ] == "N" )	{
						csValue = "원승인일: %-22s\r\n".sprintf( pu.DllTransAtoA_Format( row[ "ORG_APPR_DATE" ], "YYYY-MM-DD" ) );
						csTemp += csValue;
					}

					csValue = "단말기NO: %-22s\r\n".sprintf( row[ "VAN_TERM_NO" ] );
					csTemp += csValue;
					// 2018-11-15 KLC : 영수증 간소화 처리
					if ( blReducePrint == false )
					{
						csValue = "가맹점NO: %-22s\r\n".sprintf( row[ "CRDCP_TERM_NO" ] );
						csTemp += csValue;
					}

					csValue = util.numberWithCommas( row[ "GIFT_CASH" ]/** .asDouble() * */ );
					if( !pu.isEmpty(csValue) && csValue != "0" ) {
						csTemp += "잔액/포인트: " + csValue  + "\r\n"; // 2015-0526 Antony.Choi : [POS보안] 문구 변경

					}

					csValue = row[ "NOTICE_MSG" ];
					if( csValue.length /** .GetLength() * */ > 0 ) {
						csTemp += csValue + "\r\n";
					}

					csValue = row[ "BROAD_MSG" ];
					if( csValue.length /** .GetLength() * */ > 0 ) {
						csTemp += csValue + "\r\n";
					}
				}
			}
			else {
				if( row[ "UNION_PAY_FG" ] == "6" ) 			// 2017-0531
															// Antony.Choi :
															// 알리페이 추가
				{
					csTemp += "PAYMENT TIME DATE: " + pu.DllTransAtoA_Format( row[ "APPR_DATE" ] + row[ "APPR_TIME" ], "YYYY-MM-DD HH:MM:SS" )+ "\r\n";
					csTemp += "CAT_ID: " +  row[ "VAN_TERM_NO" ] + "\r\n";
					
					if(AlipayTransID != undefined){
						csTemp += "ALIPAY TRANS_ID: " +  AlipayTransID.trim() + "\r\n";
					}
					
					csTemp += "PARTNER TRANS_ID: " +  row[ "APPR_NO" ] + "\r\n";
					if( !this.m_csView )
					{

						csResult += "------------------------------------------\r\n";


						// AlipayBarcode = row[ "APPR_NO" ];

						let csBarCodeStr = AlipayBarcode;
						let csBarCodeEnd = pu.GetPRTDeviceCMD( "BARCODE_E" );

						csBarCodeStr += csBarCodeEnd;

						let csPrtCmd = "";


						let csDispText = pu.GetPRTDeviceCMD( "CT_ALIGN" ) + AlipayBarcode;
						// 2014-0417 Antony.Choi : 단말기 출력시 바코드 정보가 잘리는 증상 수정
						if (parseInt( this.GetEnvXmlPosENV( 206 ) ) == 11)
						{
							csPrtCmd = "%s%s%s%s%s%s".sprintf(
											  pu.GetPRTDeviceCMD( "CT_ALIGN" )						// 중앙정렬.
											, pu.GetPRTDeviceCMD( "BARCODE"  )						// CODE128
																									// 코드
																									// Set.
											, AlipayBarcode												// 바코드.
											, csDispText												// 출력
																										// Text.
											, pu.GetPRTDeviceCMD( "FEED" )							// Line
																									// Feed.
											, pu.GetPRTDeviceCMD( "LF_ALIGN" ) );						// 좌측정렬.
						} else {
							csPrtCmd =  "%s%s%c%s%s%s%s%s".sprintf(
											  pu.GetPRTDeviceCMD( "CT_ALIGN" )						// 중앙정렬.
											, pu.GetPRTDeviceCMD( "BARCODE"  )						// CODE128
																									// 코드
																									// Set.
											, csBarCodeStr.length /** .GetLength() * */					// 바코드길이.
											, pu.GetPRTDeviceCMD( "BARCODE_E" )						// 바코드구분.
											, AlipayBarcode												// 바코드.
											, csDispText												// 출력
																										// Text.
											, pu.GetPRTDeviceCMD( "FEED" )							// Line
																									// Feed.
											, pu.GetPRTDeviceCMD( "LF_ALIGN" ) );						// 좌측정렬.
						}
						csTemp += csPrtCmd;

					}
				}else if( row[ "UNION_PAY_FG" ] == "7" ) 			// 2017-0531
																	// Antony.Choi
																	// : 알리페이 추가
				{
					csTemp += "PAYMENT TIME DATE: " + pu.DllTransAtoA_Format( row[ "APPR_DATE" ] + row[ "APPR_TIME" ], "YYYY-MM-DD HH:MM:SS" )+ "\r\n";
					csTemp += "CAT_ID: " +  row[ "VAN_TERM_NO" ] + "\r\n";
					
					if(AlipayTransID != undefined){
						csTemp += "WECHAT TRANS ID: " +  AlipayTransID.trim() + "\r\n";
					}
					
					csTemp += "WECAHT AUTH NO: " +  row[ "APPR_NO" ] + "\r\n";
					if( !this.m_csView ) {

						csResult += "------------------------------------------\r\n";


						// AlipayBarcode = row[ "APPR_NO" ];

						let csBarCodeStr = AlipayBarcode;
						let csBarCodeEnd = pu.GetPRTDeviceCMD( "BARCODE_E" );

						csBarCodeStr += csBarCodeEnd;

						let csPrtCmd = "";


						let csDispText = pu.GetPRTDeviceCMD( "CT_ALIGN" )	+ AlipayBarcode;
						// 2014-0417 Antony.Choi : 단말기 출력시 바코드 정보가 잘리는 증상 수정
						if (parseInt( this.GetEnvXmlPosENV( 206 ) ) == 11)
						{
							csPrtCmd =  "%s%s%s%s%s%s".sprintf(
											  pu.GetPRTDeviceCMD( "CT_ALIGN" )		// 중앙정렬.
											, pu.GetPRTDeviceCMD( "BARCODE"  )		// CODE128
																					// 코드
																					// Set.
											, AlipayBarcode								// 바코드.
											, csDispText								// 출력
																						// Text.
											, pu.GetPRTDeviceCMD( "FEED" )			// Line
																					// Feed.
											, pu.GetPRTDeviceCMD( "LF_ALIGN" ) );		// 좌측정렬.
						}
						else
						{
							csPrtCmd =  "%s%s%c%s%s%s%s%s".sprintf(
											  pu.GetPRTDeviceCMD( "CT_ALIGN" )	// 중앙정렬.
											, pu.GetPRTDeviceCMD( "BARCODE"  )	// CODE128
																				// 코드
																				// Set.
											, csBarCodeStr.length              		// 바코드길이.
											, pu.GetPRTDeviceCMD( "BARCODE_E" )	// 바코드구분.
											, AlipayBarcode							// 바코드.
											, csDispText						    // 출력
																					// Text.
											, pu.GetPRTDeviceCMD( "FEED"  )		// Line
																				// Feed.
											, pu.GetPRTDeviceCMD( "LF_ALIGN" ) );	// 좌측정렬.
						}
						csTemp += csPrtCmd;
					}

				} else {
					// 2018-11-15 KLC : 영수증 간소화 처리
					if ( blReducePrint == false )
					{
						csTemp += "승 인 번 호: " + row[ "APPR_NO" ] + "\r\n";
					}else
					{
						csTemp += "승인/가맹점: " + row[ "APPR_NO" ] + " / " + row[ "CRDCP_TERM_NO" ] + "\r\n";
					}
					// 2014-0711-Jane : 승인일시가 null일 경우, 영수증에 잘못된 값이 찍히는 문제 수정.
					if( row[ "APPR_DATE" ] != "*" ) {
						csTemp += "승 인 일 시: " + pu.DllTransAtoA_Format( row[ "APPR_DATE" ] + row[ "APPR_TIME" ], "YYYY-MM-DD HH:MM:SS" ) + "\r\n";
					}

					if( row[ "SALE_YN" ] == "N" )	{
						csValue = "원승인 일자: %-29s\r\n".sprintf( pu.DllTransAtoA_Format( row[ "ORG_APPR_DATE" ], "YYYY-MM-DD" ) );
						csTemp += csValue;
					}

					csValue = "단말기 번호: %-29s\r\n".sprintf( row[ "VAN_TERM_NO" ] );
					csTemp += csValue;
					// 2018-11-15 KLC : 영수증 간소화 처리
					if ( blReducePrint == false )
					{
						csTemp += "가맹점 번호: " + row[ "CRDCP_TERM_NO" ] + "\r\n";
					}

					csValue = util.numberWithCommas( row[ "GIFT_CASH" ]/** .asDouble() * */ );
					if( !pu.isEmpty(csValue) && csValue != "0" ) {
						// csTemp += " GIFT잔액: " + util.numberWithCommas(
						// csValue ) + "\r\n";
						csTemp += "잔액/포인트: " + csValue  + "\r\n"; // 2015-0526 Antony.Choi : [POS보안] 문구변경
					}

					csValue = row[ "NOTICE_MSG" ];
					if( csValue.length /** .GetLength() * */ > 0 ) {
						csTemp += "     NOTICE: " + csValue + "\r\n";
					}

					csValue = row[ "BROAD_MSG" ];
					if( csValue.length /** .GetLength() * */ > 0 ) {
						csTemp += "알림 메세지: " + csValue + "\r\n";
					}
				}
			}

			csLineTemp = row[ "LINE_NO" ];
		}

		if( bCnt > 0 ) {
			if( this.g_inPaperTypeFg == 0 ) {
				csTemp += "--------------------------------";
			}
			else {
				csTemp += "------------------------------------------";
			}
		}

		// //////////////////////////////////////////////////////////////////////////
		// 로열티정보.
		// //////////////////////////////////////////////////////////////////////////
		if( pu.parseInt ( this.GetEnvXmlShopENV( 567 ) ) == 1 ) {
			csValue = GetPrintCodeData( "{로열티정보}" );
			if( !pu.isEmpty( csValue  ) ) {
				csTemp += csValue;

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += "--------------------------------";
				}
				else {
					csTemp += "------------------------------------------";
				}
			}
		}
		return csTemp;
	}

	this.GetAmountRivision = function( /* double */ pdnAmount, /* int */ pinRevisionFg  ) {
		util.logInfo("*** GetAmountRivision START ***");
		let	dnRetAmount	 = 0;
		let	inRevisionFg = pu.parseInt( this.GetEnvXmlShopENV(108) );	// 금액보정구분자를
																		// 구한다.

		// 저울바코드 상품금액에 대한 보정처리.
		if( pinRevisionFg == 1 ) {
			inRevisionFg =  pu.parseInt( this.GetEnvXmlShopENV(233) );	// 저울-금액
																		// 보정구분자를
																		// 구한다.
			util.logInfo( "저울-금액 보정구분자를 구한다.[" + inRevisionFg + "]")

			switch( inRevisionFg )
			{
				case	1	:	dnRetAmount = this.DllGetFloor( pdnAmount,  0 );util.logInfo( pdnAmount + " 에 대한  원단위-절사     "   ); break; // 원단위-절사
				case	2	:	dnRetAmount = this.DllGetRound( pdnAmount,  0 );util.logInfo( pdnAmount + " 에 대한  원단위-반올림   "   ); break; // 원단위-반올림
				case	3	:	dnRetAmount = this.DllGetCeil ( pdnAmount,  0 );util.logInfo( pdnAmount + " 에 대한  원단위-절상     "   ); break; // 원단위-절상
				case	4	:	dnRetAmount = this.DllGetFloor( pdnAmount, -1 );util.logInfo( pdnAmount + " 에 대한  십원단위-절사   "   ); break; // 십원단위-절사
				case	5	:	dnRetAmount = this.DllGetRound( pdnAmount, -1 );util.logInfo( pdnAmount + " 에 대한  십원단위-반올림 "   ); break; // 십원단위-반올림
				case	6	:	dnRetAmount = this.DllGetCeil ( pdnAmount, -1 );util.logInfo( pdnAmount + " 에 대한  십원단위-절상   "   ); break; // 십원단위-절상
				case	7	:	dnRetAmount = this.DllGetFloor( pdnAmount, -2 );util.logInfo( pdnAmount + " 에 대한  백원단위-절사   "   ); break; // 백원단위-절사
				case	8	:	dnRetAmount = this.DllGetRound( pdnAmount, -2 );util.logInfo( pdnAmount + " 에 대한  백원단위-반올림 "   ); break; // 백원단위-반올림
				case	9	:	dnRetAmount = this.DllGetCeil ( pdnAmount, -2 );util.logInfo( pdnAmount + " 에 대한  백원단위-절상   "   ); break; // 백원단위-절상
				default		:	// 보정처리안함
					dnRetAmount	= pdnAmount;
					break;
			}
			return dnRetAmount;
		}
	}
	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : DllGetFloor - Double 변수에 대한 소수점 절사 .
	// =============================================================================
	// PARAMETER 1 : pdnOrgNum : Double 변수.
	// 2 : psnDecPos : 절사 소수점 자리수.
	// RETURN VALUE : Double : Double 변수값.
	// PROGRAMMER : YBC-2008-04-30 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.DllGetFloor = function ( /* double */ pdnOrgNum, /* short */ psnDecPos /* = 1 */) {
		let dnDivBaseValue	=  0;
		if ( typeof psnDecPos != 'number' ) {
			throw " typeof error ";
		}
		switch( psnDecPos )
		{
			case	-3	: dnDivBaseValue = 0.0001; break; // 천자리 절사.
			case	-2	: dnDivBaseValue = 0.001; break; // 백자리 절사.
			case	-1	: dnDivBaseValue = 0.01; break; // 십자리 절사.
			case	0	: dnDivBaseValue = 0.1; break; // 단자리 절사.
			case	1	: dnDivBaseValue = 1; break; // 소수점 1자리 절사.
			case	2	: dnDivBaseValue = 10; break; // 소수점 2자리 절사.
			case	3	: dnDivBaseValue = 100; break; // 소수점 3자리 절사.
			case	4	: dnDivBaseValue = 1000; break; // 소수점 4자리 절사.
			default		: throw "소수점 처리에 실패하였습니다. [" + pdnOrgNum + "] ["  + psnDecPos + "]";
		}

		return ( Math.floor ( dnDivBaseValue * pdnOrgNum  ) / dnDivBaseValue );
	}

	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : DllGetRound - Double 변수에 대한 소수점 Round .
	// =============================================================================
	// PARAMETER 1 : pdnOrgNum : Double 변수.
	// 2 : psnDecPos : 반올림대상 소수점 자리수.
	// RETURN VALUE : Double : Double 변수값.
	// PROGRAMMER : YBC-2008-04-30 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.DllGetRound = function( /* double */ pdnOrgNum, /* short */ psnDecPos /* = 1 */)  {
		let dnRoundValue		=  5;
		let dnDivBaseValue	=  0;

		if ( typeof psnDecPos != 'number' ) {
			throw " typeof error ";
		}
		switch( psnDecPos )
		{
			case	-3	: dnDivBaseValue = 0.0001; break; // 천자리 반올림.
			case	-2	: dnDivBaseValue = 0.001; break; // 백자리 반올림.
			case	-1	: dnDivBaseValue = 0.01; break; // 십자리 반올림.
			case	0	: dnDivBaseValue = 0.1; break; // 단자리 반올림.
			case	1	: dnDivBaseValue = 1; break; // 소수점 1자리 반올림.
			case	2	: dnDivBaseValue = 10; break; // 소수점 2자리 반올림.
			case	3	: dnDivBaseValue = 100; break; // 소수점 3자리 반올림.
			case	4	: dnDivBaseValue = 1000; break; // 소수점 4자리 반올림.
			default		: throw "소수점 처리에 실패하였습니다. [" + pdnOrgNum + "] ["  + psnDecPos + "]";
		}

		dnRoundValue /= dnDivBaseValue * 10;
		return ( Math.floor ( dnDivBaseValue * ( pdnOrgNum + dnRoundValue) ) / dnDivBaseValue );
	}
	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : DllGetCeil - Double 변수에 대한 소수점 절상 .
	// =============================================================================
	// PARAMETER 1 : pdnOrgNum : Double 변수.
	// 2 : psnDecPos : 절상 소수점 자리수.
	// RETURN VALUE : Double : Double 변수값.
	// PROGRAMMER : YBC-2008-04-30 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.DllGetCeil = function ( /** double * */ pdnOrgNum, /** short * */ psnDecPos /* = 1 */)
	{
		let dnDivBaseValue	=  0;
		if ( typeof psnDecPos != 'number' ) {
			throw " typeof error ";
		}

		switch( psnDecPos )
		{
			case	-3	: dnDivBaseValue = 0.0001; break; // 천자리 절상.
			case	-2	: dnDivBaseValue = 0.001; break; // 백자리 절상.
			case	-1	: dnDivBaseValue = 0.01; break; // 십자리 절상.
			case	0	: dnDivBaseValue = 0.1; break; // 단자리 절상.
			case	1	: dnDivBaseValue = 1; break; // 소수점 1자리 절상.
			case	2	: dnDivBaseValue = 10; break; // 소수점 2자리 절상.
			case	3	: dnDivBaseValue = 100; break; // 소수점 3자리 절상.
			case	4	: dnDivBaseValue = 1000; break; // 소수점 4자리 절상.
		default		: return FALSE;
		}

		return ( Math.ceil ( dnDivBaseValue * pdnOrgNum  ) / dnDivBaseValue );
	}




	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : DllSetCrdCardNoMasking. : 신용카드번호에 대한 Masking 처리.
	// =============================================================================
	// PARAMETER 1 : pcsCrdCardNo : .
	// RETURN VALUE : CString : .
	// PROGRAMMER : YBC-2009-04-23 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.DllSetCrdCardNoMasking = function (   pcsCrdCardNo, /** bool * */ pblMark /*
																									 * =
																									 * TRUE
																									 */ )	{ // CWS
																													// 2009-05-21
																													// 추가
		// //////////////////////////////////////////////////////////////////////////
		// 2011-1018-JJM : 은련카드 카드번호 길이가 19자리까지 존재 함.
		// //////////////////////////////////////////////////////////////////////////

		let szCardNo = "";
		let csRetStr = "";

		// //////////////////////////////////////////////////////////////////////////
		// 2009-1119-YBC : 신용카드번호 길이가 14자리인 해외카드 때문에.
		// 2011-1018-JJM : 은련카드인 경우 19자리까지 있음.
		// //////////////////////////////////////////////////////////////////////////

		let inMaxCardLength = 16;

		if( pcsCrdCardNo.length != 16 ) {
			inMaxCardLength = pcsCrdCardNo.length;
		}

		for( let i = 0; i < inMaxCardLength; i++ ) {
			if( i > 0 && ( i % 4 ) == 0 ) {
				csRetStr += "-";
			}

			// //////////////////////////////////////////////////////////////////////
			// 2012-0304-JJM : FDKL IT운영팀 정현수씨 요청으로 마스킹 자리수 변경.
			// //////////////////////////////////////////////////////////////////////
			// if( i >= LEN_DEF_8 && i <= LEN_DEF_11 && pblMark )
			if( i >= 6 && i <= 11 && pblMark ) {
				csRetStr += "*";
			}
			else {
				csRetStr += pcsCrdCardNo[ i ];
			}
		}

		return csRetStr;
	}

	this.GetNoneSalesCardCollectData = function( pcsCode ) {
		util.logInfo("*** GetNoneSalesCardCollectData START ***");
		let /** byte * */ bCnt		= 0;
		let /** byte * */ bCornerCnt	= 0;

		let /** bool * */ blReducePrint = false;

		let csQrySql	 = "";
		let csTemp		 = "";
		let csResult	 = "";
		let csTempStr	 = "";
		let	csIssCrdCpNm = "";
		let csCrdCpNm    = "";
		let csCrdCardNo  = "";
		let	csSaleYn     = "";
		let csValidTerm  = "";
		let	csLineTemp   = "";
		let csValue      = "";		// 2012-0202-JJM : .

		let /** double * */ dnTotApprAmt = 0;
		let /** double * */ dnTotApprVat = 0;
		let /** double * */ dnTotApprTip = 0;

		let	inApprFg = 1;

		if (!pu.isEmpty(pcsCode) && pcsCode.substr(1,1) == "R" )
		{
			blReducePrint = true;
		}


		let sql = _sql.GetNoneSalesCardCollectData_SQL(this.m_stSaleInfo);
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );
		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data)  || db_result.Data.length == 0 ) {
			// throw "[Print]기타금액 정보가져오기에 실패하였습니다.";
			return false;
		}

		let rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];
			if( row[ "APPR_FG" ] == "0" )
			{
				csSaleYn = "신용승인";
			}
			else
			{
				csSaleYn = "신용취소";
			}

			if( row[ "SIGN_PAD_YN" ] == "Y" )
			{
				this.m_blSignPadUseFg = true;
			}
			else
			{
				this.m_blSignPadUseFg = false;
			}

			// 2016-0427 Antony.Choi : 별도 전표 출력 시 각각의 NoCVM Flag 확인
			if (row[ "DDC_FLAG" ]  == "N" )
			{
				this.m_stSaleInfo.stPrintData.NO_CVM_FLAG = true;
			}else
			{
				this.m_stSaleInfo.stPrintData.NO_CVM_FLAG = false;
			}

			// //////////////////////////////////////////////////////////////////////
			// 취소시 금액 처리.
			// //////////////////////////////////////////////////////////////////////
			if( row[ "APPR_FG" ] == "1" )	{
				inApprFg = -1;
			}

			csIssCrdCpNm = row[ "ISS_CRDCP_NM" ];
			csCrdCpNm    = row[ "CRDCP_NM"     ];
			csCrdCardNo  = row[ "CRD_CARD_NO"  ];
			csValidTerm  = row[ "VALID_TERM"   ];

			if( this.g_inPaperTypeFg == 0 ) {
				csTempStr = "     *** %s정보[%d] ***\r\n".sprintf( csSaleYn, ++bCnt );
				csTemp += csTempStr;

				// 2014-0716-Jane : 임의등록 문구 변경
				if( row[ "APPR_PROC_FG" ]/** .asShort() * */ == 2 ) {	// 단말기승인.
					csTemp += pu.BASE_PRINT[ "V2X" ] ;
					csTemp += pu.BASE_PRINT[ "REVERSE_ON" ];
					csTemp += "     **  단 말 기 승인요망 **\r\n";
					csTemp += pu.BASE_PRINT[ "NORM" ];
					csTemp += pu.BASE_PRINT[ "REVERSE_OFF" ];
					csTemp += pu.BASE_PRINT[ "INIT" ];
				}
				else {
					// 2018-11-15 KLC : 영수증 간소화 처리
					if ( blReducePrint == true )
					{
						csTemp += "카드종류 ";
						csTemp += csIssCrdCpNm + " / " + csCrdCpNm + "\r\n";
					}else
					{
						csTemp += "카드종류 " + csIssCrdCpNm + "\r\n";
					}


				}
				csTemp += "카드번호 " + this.DllSetCrdCardNoMasking( csCrdCardNo ) + "\r\n";

				// csTemp += "유효기간 **/**\r\n"; 2018-11-07 KLC : 유효기간 필드 출력 하지 않음
				// 2018-11-15 KLC : 영수증 간소화 처리
				if ( blReducePrint == false )
				{
					csTemp += "매 입 사 " + csCrdCpNm + "\r\n";
					if( row[ "INST_MM_FG" ] == "0" ) {
						csTemp += "할부개월 " + row[ "INST_MM_NM" ] + "\r\n";
					}
					else {
						csTemp += "할부개월 " + row[ "INST_MM_NM" ] + "( " + row[ "INST_MM_CNT" ] + " )" + "\r\n";
					}
					csTemp += "승인금액 " + util.numberWithCommas( row[ "APPR_AMT" ]/** .asDouble() * */ * inApprFg ) + "\r\n";
				}
				else
				{
					csTemp += "승인금액: " + util.numberWithCommas( row[ "APPR_AMT" ] );
					if( row[ "INST_MM_FG" ] == "0" ) {
						csTemp += "(" + row[ "INST_MM_NM" ] + ")" + "\r\n";
					}
					else {
						csTemp += "(" + row[ "INST_MM_NM" ] + "-" + row[ "INST_MM_CNT" ] + " )" + "\r\n";
					}
				}



				csTemp += "승인번호 " + row[ "APPR_NO" ] + "\r\n";
				csTemp += "승인일시 " + pu.DllTransAtoA_Format( row[ "APPR_DATE" ] + row[ "APPR_TIME" ],	"YYYY-MM-DD HH:MM:SS" ) + "\r\n";

				if( row[ "APPR_FG" ] == "1" ) {
					csTemp += "원승인일 " + pu.DllTransAtoA_Format( row[ "ORG_APPR_DATE" ], "YYYY-MM-DD" ) + "\r\n";
				}

				csTemp += "단말기NO " + row[ "VAN_TERM_NO" ] + "\r\n";
				csTemp += "가맹점NO " + row[ "CRDCP_TERM_NO" ] + "\r\n";

				csValue = util.numberWithCommas( row[ "GIFT_CASH" ]/** .asDouble() * */ );
				if( !pu.isEmpty(csValue) && csValue != "0" ) {
					csTemp += "잔액/포인트 " + csValue + "\r\n"; // 2015-0526 Antony.Choi : [POS보안] 선불카드 문구 변경
				}

				csValue = row[ "NOTICE_MSG" ];
				if( csValue.length /** .GetLength() * */ > 0 ) {
					csTemp += csValue + "\r\n";
				}

				csValue = row[ "BROAD_MSG" ];
				if( csValue.length /** .GetLength() * */ > 0 ) {
					csTemp += csValue + "\r\n";
				}
			}
			else
			{
				// 20190920-HJH BCQR 추가
				if( row[ "CARD_IN_FG" ] == "E" )
					csTempStr = "       *** %s정보[%d](BC-QR) ***\r\n".sprintf( csSaleYn, ++bCnt );
				else
					csTempStr = "          *** %s정보[%d] ***\r\n".sprintf( csSaleYn, ++bCnt );

				csTemp += csTempStr;

				// 2014-0716-Jane : 임의등록 문구 변경
				if( row[ "APPR_PROC_FG" ]/** .asShort() * */ == 2 ) {	// 단말기승인.
					csTemp += pu.BASE_PRINT[ "HV2X" ];
					csTemp += pu.BASE_PRINT[ "REVERSE_ON" ];
					csTemp += "** 단말기 승인요망 **\r\n";
					csTemp += pu.BASE_PRINT[ "NORM" ];
					csTemp += pu.BASE_PRINT[ "REVERSE_OFF" ];
					csTemp += pu.BASE_PRINT[ "INIT" ];

				} else {

					// 2018-11-15 KLC : 영수증 간소화 처리
					if ( blReducePrint == true )
					{
						csTemp += "[카 드 종 류] " + csIssCrdCpNm + "/" + csCrdCpNm + "\r\n";
					}else
					{
						csTemp += "[카 드 종 류] " + csIssCrdCpNm + "\r\n";
					}
				}
				csTemp += "[카 드 번 호] " + this.DllSetCrdCardNoMasking( csCrdCardNo ) + "\r\n";
				// csTemp += "[유 효 기 간] **/**\r\n";2018-11-07 KLC : 유효기간 필드 출력
				// 하지 않음
				// 2018-11-15 KLC : 영수증 간소화 처리
				if ( blReducePrint == false )
				{
					if( row[ "INST_MM_FG" ] == "0" )	{
						csTemp += "[할 부 개 월] " + row[ "INST_MM_NM" ] + "\r\n";
					}
					else {
						csTemp += "[할 부 개 월] " + row[ "INST_MM_NM" ] + "( " + row[ "INST_MM_CNT" ] + " )" + "\r\n";
					}

						csTemp += "[전표 매입사] " + csCrdCpNm + "\r\n";
						csTemp += "[승 인 금 액] " + util.numberWithCommas( row[ "APPR_AMT" ]/** .asDouble() * */ * inApprFg ) + "\r\n";
				}else
				{
					csTemp += "[승 인 금 액] " + util.numberWithCommas( row[ "APPR_AMT" ]/** .asDouble() * */ * inApprFg ) + "\r\n";
					if( row[ "INST_MM_FG" ] == "0" ) {
						csTemp += "(" + row[ "INST_MM_NM" ] + ")" + "\r\n";
					}
					else {
						csTemp += "(" + row[ "INST_MM_NM" ] + "-" + row[ "INST_MM_CNT" ] + " )" + "\r\n";
					}
				}
				csTemp += "[승 인 번 호] " + row[ "APPR_NO" ] + "\r\n";
				csTemp += "[승 인 일 시] " + pu.DllTransAtoA_Format( row[ "APPR_DATE" ] + row[ "APPR_TIME" ], "YYYY-MM-DD HH:MM:SS" ) + "\r\n";

				if( row[ "APPR_FG" ] == "1" ) {
					csTemp += "[원승인 일자] " + pu.DllTransAtoA_Format( row[ "ORG_APPR_DATE" ], "YYYY-MM-DD" ) + "\r\n";
				}

				csTemp += "[단말기 번호] " + row[ "VAN_TERM_NO"   ] + "\r\n";
				csTemp += "[가맹점 번호] " + row[ "CRDCP_TERM_NO" ] + "\r\n";

				csValue = util.numberWithCommas( row[ "GIFT_CASH" ]/** .asDouble() * */ );
				if( !pu.isEmpty(csValue) && csValue != "0" ) {
					csTemp += "[잔액/포인트] " + csValue + "\r\n"; // 2015-0526 Antony.Choi : [POS보안] 선불카드 문구 변경
				}

				csValue = row[ "NOTICE_MSG" ];
				if( csValue.length /** .GetLength() * */ > 0 ) {
					csTemp += "[     NOTICE] " + csValue + "\r\n";
				}

				csValue = row[ "BROAD_MSG" ];
				if( csValue.length /** .GetLength() * */ > 0 ) {
					csTemp += "[알림 메세지] " + csValue + "\r\n";
				}
			}

			dnTotApprAmt += row[ "APPR_AMT"	   ]/** .asDouble() * */ * inApprFg;
			dnTotApprVat += row[ "VAT_AMT"	   ]/** .asDouble() * */ * inApprFg;
			dnTotApprTip += row[ "SVC_TIP_AMT" ]/** .asDouble() * */ * inApprFg;

			this.m_stSaleInfo.EMP_NO = row[ "EMP_NO" ];
			this.m_stSaleInfo.EMP_NM = row[ "EMP_NM" ];

		}

		if( bCnt > 0 ) {
			if( this.g_inPaperTypeFg == 0 ) {
				csTemp += "--------------------------------";
			}
			else {
				csTemp += "------------------------------------------";
			}
			csResult += csTemp;
			csResult += "\r\n";
			csResult += pu.GetMarkString_04( "판 매 금 액:", dnTotApprAmt - dnTotApprVat - dnTotApprTip );
			csResult += "\r\n";
			csResult += pu.GetMarkString_04( "부 가 세 액:", dnTotApprVat                               );
			csResult += "\r\n";
			csResult += pu.GetMarkString_04( "봉 사 료 액:", dnTotApprTip                               );
			csResult += "\r\n";
			csResult += pu.GetMarkString_04( "합 계 금 액:", dnTotApprAmt                               );

			if( this.g_inPaperTypeFg == 0 ) {
				csResult += "\r\n--------------------------------";
			}
			else {
				csResult += "\r\n------------------------------------------";
			}
		}
		return csResult;
	}
	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : GetNoneSalesCashData.
	// =============================================================================
	// PARAMETER 1 : No : .
	// RETURN VALUE : CString : .
	// PROGRAMMER : CWS-2009-05-26 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.GetNoneSalesCashData = function () {
		util.logInfo("*** GetNoneSalesCashData START ***");
		let blBizFg       = false /** FALSE * */;		// 2012-0314-JJM : .
		let blCornerUseFg = false /** FALSE * */;

		let bCnt = 0;

		let csQrySql	    = "";
		let csTemp		    = "";
		let csResult	    = "";
		let csCode		    = "";
		let csCashIdtNo     = "";
		let csTempStr       = "";
		let csCornerBizNo   = "";	// 2009-1228-YBC
		let csCornerOwnerNm = "";	// 2009-1228-YBC
		let csCornerCd      = "";	// 2009-1228-YBC
		let csCornerNm      = "";	// 2009-1228-YBC
		let csLeftStr       = "";	// 2009-1228-YBC
		let csRightStr      = "";	// 2009-1228-YBC
		let csValue         = "";	// 2012-0203-JJM : .
		let dnTotApprAmt = 0;

		let inApprFg = 1;			// 2010-0720-JJM : 취소시 금액 처리.

		blCornerUseFg = pu.parseInt(this.GetEnvXmlShopENV( 114 )) == "1" ? true /** TRUE * */ : false /** FALSE * */;

		let sql = this.GetNoneSalesCashData_SQL(this.m_stSaleInfo);
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );
		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) ) {
			return false;
		}


		let rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];

			csCode = row[ "APPR_IDT_TYPE" ];

			if( this.g_inPaperTypeFg == 0 ) {
				if( csCode == "1" ) {
					csTemp = "*** 현금영수증(소득공제)[%d] ***\r\n".sprintf( ++bCnt );
					blBizFg = false /** FALSE * */;
				}
				else if( csCode == "2" ) {
					csTemp = "*** 현금영수증(지출증빙)[%d] ***\r\n".sprintf( ++bCnt );
					blBizFg = true /** TRUE * */;
				}
				else if( csCode == "5" ) {
					csTemp = "*** 현금영수증(자진발급)[%d] ***\r\n".sprintf( ++bCnt );
					blBizFg = false /** FALSE * */;
				}
			}
			else {
				if( csCode == "1" ) {
					csTemp = "     *** 현금영수증(소득공제)[%d] ***\r\n".sprintf( ++bCnt );
					blBizFg = false /** FALSE * */;
				}
				else if( csCode == "2" ) {
					csTemp = "     *** 현금영수증(지출증빙)[%d] ***\r\n".sprintf( ++bCnt );
					blBizFg = true /** TRUE * */;
				}
				else if( csCode == "5" ) {
					csTemp = "     *** 현금영수증(자진발급)[%d] ***\r\n".sprintf( ++bCnt );
					blBizFg = false /** FALSE * */;
				}
			}

			// //////////////////////////////////////////////////////////////////////
			// 취소시 금액 처리.
			// //////////////////////////////////////////////////////////////////////
			if( row[ "APPR_FG" ] == "1" )	{
				inApprFg = -1;
			}

			if( blCornerUseFg ) {
				// //////////////////////////////////////////////////////////////////
				// 2009-1228-YBC
				// //////////////////////////////////////////////////////////////////
				csCornerCd		= row[ "CORNER_CD" ];
				csCornerNm		= row[ "CORNER_NM" ];
				csCornerBizNo	= this.GetEnvXmlCornerENV( /** atoi * */ parseInt ( csCornerCd ), "BIZ_NO"   );
				csCornerOwnerNm = this.GetEnvXmlCornerENV( /** atoi * */ parseInt ( csCornerCd ), "OWNER_NM" );
				csCornerBizNo   = pu.DllTransAtoA_Format( csCornerBizNo, "BIZ_NO" );

				if( csCornerOwnerNm.getByteLength() >  6  ) {
					csCornerOwnerNm = csCornerOwnerNm.cutStr(  6  );
				}

				csLeftStr = "▶%s".sprintf( csCornerNm );
				csRightStr = "사업자:%s:%s".sprintf( csCornerBizNo, csCornerOwnerNm );

				csTemp += pu.GetMarkString_03( csLeftStr, csRightStr, 16, 26 );
				csTemp += "\r\n";
			}

			csCashIdtNo = row[ "APPR_IDT_NO" ];

			// //////////////////////////////////////////////////////////////////////
			// 취소시 금액 처리.
			// //////////////////////////////////////////////////////////////////////
			csTempStr =parseInt([ "APPR_AMT" ])  * inApprFg ;

// csTemp += "확인번호 :";
			if( this.g_inPaperTypeFg == 0 ) {
				if( row[ "APPR_NO" ] != "" ) {
					csTemp += "확인번호 :";
// csTemp += LPad( g_clsUtil.DllSetCashBillNoMasking( csCashIdtNo, blBizFg ), 22
// ) + "\r\n";
					// 2014-1124 Antony.Choi : 국세청 요청으로 현금영수증 마스킹 체계 변경
					// csTemp += g_clsUtil.DllSetCashBillNoMasking( csCashIdtNo,
					// blBizFg ) + "\r\n";
					csTemp +=  csCashIdtNo + "\r\n";
				}
				else {
					csTemp += pu.GetPRTDeviceCMD( "V2X" ) /** PRT_BASE_V2X * */ ;
					csTemp += pu.GetPRTDeviceCMD( "REVERSE_ON" ) /** PRT_BASE_REVERSE_ON * */;
					csTemp += "** 단말기 승인요망 **\r\n";		// 2014-0716-Jane : 임의등록
														// 문구 변경
					csTemp +=  pu.GetPRTDeviceCMD( "NORM" ) /** PRT_BASE_NORM * */;
					csTemp += pu.GetPRTDeviceCMD( "REVERSE_OFF" ) /** PRT_BASE_REVERSE_OFF * */;
					csTemp += pu.GetPRTDeviceCMD( "INIT" ) /** PRT_BASE_INIT * */;
				}
			}
			else {
				if( row[ "APPR_NO" ] != "" ) {
					csTemp += "확인번호 :";
// csTemp += LPad( g_clsUtil.DllSetCashBillNoMasking( csCashIdtNo, blBizFg ), 32
// ) + "\r\n";
					// 2014-1124 Antony.Choi : 국세청 요청으로 현금영수증 마스킹 체계 변경
					// csTemp += g_clsUtil.DllSetCashBillNoMasking( csCashIdtNo,
					// blBizFg ) + "\r\n";
					csTemp +=  csCashIdtNo + "\r\n";
				}
				else {
					csTemp += pu.GetPRTDeviceCMD( "HV2X" ) /** PRT_BASE_HV2X * */;
					csTemp += pu.GetPRTDeviceCMD( "REVERSE_ON" ) /** PRT_BASE_REVERSE_ON * */;
					csTemp += "** 단말기 승인요망 **\r\n";		// 2014-0716-Jane : 임의등록
														// 문구 변경
					csTemp +=  pu.GetPRTDeviceCMD( "NORM" ) /** PRT_BASE_NORM * */;
					csTemp += pu.GetPRTDeviceCMD( "REVERSE_OFF" ) /** PRT_BASE_REVERSE_OFF * */;
					csTemp += pu.GetPRTDeviceCMD( "INIT" ) /** PRT_BASE_INIT * */;
				}
			}

			csValue= "승인금액 : %s\r\n".sprintf(util.numberWithCommas( csTempStr ) );
			csTemp += csValue;

			csValue = "승인번호 : %s\r\n".sprintf( row[ "APPR_NO" ] );
			csTemp += csValue;

			csValue = "승인일시 : %s\r\n".sprintf( pu.DllTransAtoA_Format( row[ "APPR_DATE" ] + row[ "APPR_TIME" ], "YYYY-MM-DD HH:MM:SS" ) );
			csTemp += csValue;

			csValue = "단말기NO : %s\r\n".sprintf( row[ "VAN_TERM_NO" ] );
			csTemp += csValue;

			csValue = row[ "NOTICE_MSG" ];
			if( csValue.length /** .GetLength() * */ > 0 ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += csValue + "\r\n";
				}
				else {
					csTemp += "  NOTICE : " + csValue + "\r\n";
				}
			}

			csValue = row[ "BROAD_MSG" ];
			if( csValue.length /** .GetLength() * */ > 0 ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += csValue + "\r\n";
				}
				else {
					csTemp += "알    림 : " + csValue + "\r\n";
				}
			}

			if( this.g_inPaperTypeFg == 0 ) {
				csTemp += "--------------------------------\r\n";
			}
			else {
				csTemp += "------------------------------------------\r\n";
			}

			dnTotApprAmt += row[ "APPR_AMT" ]/** .asDouble() * */;


		}

		csResult += csTemp;
		return csResult;
	}

	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : GetSalesJCardData.
	// =============================================================================
	// PARAMETER 1 : No : .
	// RETURN VALUE : CString : .
	// PROGRAMMER : CWS-2009-02-18 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.GetSalesJCardData = function() {
		util.logInfo("*** GetSalesJCardData START ***");
		let bCnt = 0;

		let csQrySql = "";
		let csTemp	 = "";
		let csResult = "";
		let csCode	 = "";
		let csJcdNm  = "";
		let csApprNo = "";
		let csValue  = "";

		let inJcdTypeFg = 0;
		let strJcdTypeFg = "";

		let sql = _sql.GetSalesJCardData_SQL(  this.m_stSaleInfo  );
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0   ) {
			return false;
		}

		csTemp = "";
		let rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];

			inJcdTypeFg = parseInt(row[ "JCD_TYPE_FG" ])/** .asLong() * */;
			strJcdTypeFg = row[ "JCD_TYPE_FG" ]; // 해당 값이 string인 경우가 있음/
			if( this.g_inPaperTypeFg == 0 ) {
				switch( /** atoi * */ pu.parseInt ( row[ "JCD_PROC_FG" ] ) ) {
					case 0 :	// 할인
						csTemp = "      *** 제휴할인[%d] ***\r\n".sprintf( ++bCnt );
						break;
					case 1 :	// 적립
						csTemp = "      *** 제휴적립[%d] ***\r\n".sprintf( ++bCnt );
						break;
					case 2 :	// 사용
						csTemp= "      *** 제휴사용[%d] ***\r\n".sprintf( ++bCnt );
						break;
					case 3 :
						csTemp = "    *** 제휴할인취소[%d] ***\r\n".sprintf( ++bCnt );
						break;
					case 4 :
						csTemp = "    *** 제휴적립취소[%d] ***\r\n".sprintf( ++bCnt );
						break;
					case 5 :
						csTemp = "    *** 제휴사용취소[%d] ***\r\n".sprintf( ++bCnt );
						break;
					case 6 :
						csTemp= "     *** 제휴적립사용[%d] ***\r\n".sprintf( ++bCnt );	// 2021-06-08 적립사용
																						
						break;
					case 7 :
						csTemp= "     *** 제휴적립사용취소[%d] ***\r\n".sprintf( ++bCnt );	// 2021-06-08 적립사용취소
																						
						break;
				}
			} else {
				switch( /** atoi * */ pu.parseInt ( row[ "JCD_PROC_FG" ] ) ) {
					case 0 :	// 할인
						csTemp = "           *** 제휴할인[%d] ***\r\n".sprintf( ++bCnt );	// 2009-1008-YBC
																						// :
																						// 제휴카드->제휴할인
						break;
					case 1 :	// 적립
						csTemp = "           *** 제휴적립[%d] ***\r\n".sprintf(++bCnt );	// 2009-1008-YBC
																						// :
																						// 제휴카드->제휴할인
						break;
					case 2 :	// 사용
						csTemp= "           *** 제휴사용[%d] ***\r\n".sprintf( ++bCnt );	// 2009-1008-YBC
																						// :
																						// 제휴카드->제휴할인
						break;
					case 3 :
						csTemp= "           *** 제휴할인취소[%d] ***\r\n".sprintf( ++bCnt );	// 2009-1008-YBC
																						// :
																						// 제휴카드->제휴할인
						break;
					case 4 :
						csTemp= "           *** 제휴적립취소[%d] ***\r\n".sprintf( ++bCnt );
						break;
					case 5 :
						csTemp= "           *** 제휴사용취소[%d] ***\r\n".sprintf( ++bCnt );	// 2009-1008-YBC
																						// :
																						// 제휴카드->제휴할인
						break;
					case 6 :
						csTemp= "           *** 제휴적립사용[%d] ***\r\n".sprintf( ++bCnt );	// 2021-06-08 적립사용
																						
						break;
					case 7 :
						csTemp= "           *** 제휴적립사용취소[%d] ***\r\n".sprintf( ++bCnt );	// 2021-06-08 적립사용취소
																						
						break;
				}
			}

			csJcdNm = row[ "JCD_NM" ];
			if(util.byteLen( csJcdNm )   > 0 ) {
				csTemp += "제 휴 구 분: " + csJcdNm	+ "\r\n";
			}

			csTemp += "카 드 번 호: " + row[ "JCD_CARD_NO" ] + "\r\n";

			switch( parseInt( row[ "APPR_PROC_FG" ])/** .asShort() * */ )	{
				case 1 :  // 포스승인
				case 5 :  // 2015-0826-Jane : FDK 보안CAT 대리승인
					csApprNo = row[ "APPR_NO" ];
					break;

				case 0 :
					if( inJcdTypeFg == DEF_JCD_TYPE_SS_FIRE ) {
						csApprNo = row[ "APPR_NO" ];
					}
					else {
						csApprNo = "비승인";
					}
					break;

				default :
					csApprNo = "단말기승인-임의등록";
					break;
			}

			csTemp += "승 인 번 호: " + csApprNo + "\r\n";

			if(strJcdTypeFg != "M"){
				if( row[ "JCD_DC_AMT" ]/** .asDouble() * */ != 0 )	{
					csTemp += "할 인 금 액: " + util.numberWithCommas( row[ "JCD_DC_AMT" ] ) + "\r\n";
				}
			}
			
			
			//if(row[ "JCD_USE_POINT" ]/** .asDouble() * */ != 0 ) {
				csTemp += "사용 포인트: " + util.numberWithCommas( row[ "JCD_USE_POINT" ] ) + "\r\n";
			//}

			if(!row[ "JCD_OCC_POINT" ]){
				row[ "JCD_OCC_POINT" ] = 0;
			}else if(!row[ "JCD_AVL_POINT" ]){
				row[ "JCD_AVL_POINT" ] = 0;
			}else if(!row[ "JCD_REM_POINT" ]){
				row[ "JCD_REM_POINT" ] = 0;
			}
			
			switch( pu.parseInt(row[ "JCD_PROC_FG" ])/** .asLong() * */ )	{
				case 0 : // 할인.
					switch( inJcdTypeFg ) {
						case DEF_JCD_TYPE_OCB :
							csTemp += "총할인금액: " + util.numberWithCommas( row[ "JCD_OCC_POINT" ] ) + "\r\n";
							csTemp += "사용 포인트: " + util.numberWithCommas( row[ "JCD_AVL_POINT" ] ) + "\r\n";
							csTemp += "누적 포인트: " + util.numberWithCommas( row[ "JCD_REM_POINT" ] ) + "\r\n";
							break;

						case DEF_JCD_TYPE_SS_FIRE :	// 삼성화재-멤버쉽 카드의 경우 포인트정보는
													// 인쇄하지 않는다.
							break;

						default :
							// //////////////////////////////////////////////////////
							// 2013-0307-JJM : 제휴할인 출력 수정.
							// //////////////////////////////////////////////////////
							// csTemp += "할인 포인트: " + util.numberWithCommas(
							// row[ "JCD_USE_POINT" ] ) + "\r\n";
							// csTemp += "잔여 포인트: " + util.numberWithCommas(
							// row[ "JCD_REM_POINT" ] ) + "\r\n";

							csTemp += "잔 여 한 도: " + util.numberWithCommas( row[ "JCD_AVL_POINT" ] ) + "\r\n";

							csValue = inJcdTypeFg == 2 ? row[ "BROAD_MSG" ].substr( 0, 28 ) : "";
							if( csValue.length /** .GetLength() * */ > 0 ) {
								csTemp += "회 원 등 급: " + csValue + "\r\n";
							}
							break;
					}
					break;

				case 3 : // 할인취소.
					if( inJcdTypeFg == DEF_JCD_TYPE_OCB ) {
						csTemp += "발생 포인트: " + util.numberWithCommas( row[ "JCD_OCC_POINT" ] ) + "\r\n";
						csTemp += "가용 포인트: " + util.numberWithCommas( row[ "JCD_AVL_POINT" ] ) + "\r\n";
						csTemp += "누적 포인트: " + util.numberWithCommas( row[ "JCD_REM_POINT" ] ) + "\r\n";
					}
					else {
						// //////////////////////////////////////////////////////////
						// 2013-0307-JJM : 제휴할인 출력 수정.
						// //////////////////////////////////////////////////////////
						// csTemp += "할인 포인트: " + util.numberWithCommas( row[
						// "JCD_OCC_POINT" ] ) + "\r\n";
						// csTemp += "잔여 포인트: " + util.numberWithCommas( row[
						// "JCD_REM_POINT" ] ) + "\r\n";

						csTemp += "잔 여 한 도: " + util.numberWithCommas( row[ "JCD_AVL_POINT" ] ) + "\r\n";

						csValue = inJcdTypeFg == 2 ? row[ "BROAD_MSG" ].substr( 0, 28 ) : "";
						if( csValue.length /** .GetLength() * */ > 0 ) {
							csTemp += "회 원 등 급: " + csValue.trim() + "\r\n";
						}
					}
					break;

				case 1 : // 적립
//					csTemp += "추가 사용 포인트: " + util.numberWithCommas( row[ "JCD_AVL_POINT" ] ) + "\r\n";
//					csTemp += "할인 포인트: " + util.numberWithCommas( row[ "JCD_DC_AMT" ] ) + "\r\n";
					if(strJcdTypeFg == "M"){
						if(!!row[ "JCD_DC_AMT" ]){
							csTemp += "할인 포인트: " + util.numberWithCommas( row[ "JCD_DC_AMT" ] ) + "\r\n";
						}
						if(!!row[ "JCD_AVL_POINT" ]){
							csTemp += "부스트업 포인트: " + util.numberWithCommas( row[ "JCD_AVL_POINT_MP" ] ) + "\r\n";
						}
					}
					csTemp += "적립 포인트: " + util.numberWithCommas( row[ "JCD_OCC_POINT" ] ) + "\r\n";
					csTemp += "가용 포인트: " + util.numberWithCommas( row[ "JCD_REM_POINT" ] ) + "\r\n";
					if(strJcdTypeFg == "M"){						
						if(!!row[ "BROAD_MSG" ] ){
							csTemp += row[ "BROAD_MSG" ] + "\r\n";
						}
					}
										
					break;
				case 4 : // 적립취소.
					if(strJcdTypeFg == "M"){
						if(!!row[ "JCD_DC_AMT" ]){
							csTemp += "할인 포인트: " + util.numberWithCommas( row[ "JCD_DC_AMT" ] ) + "\r\n";
						}
						if(!!row[ "JCD_AVL_POINT" ]){
							csTemp += "부스트업 포인트: " + util.numberWithCommas( row[ "JCD_AVL_POINT_MP" ] ) + "\r\n";
						}
					}
					
					csTemp += "적립 포인트: " + util.numberWithCommas( row[ "JCD_OCC_POINT" ] ) + "\r\n";
					csTemp += "가용 포인트: " + util.numberWithCommas( row[ "JCD_REM_POINT" ] ) + "\r\n";
					
					if(strJcdTypeFg == "M"){						
						if(!!row[ "BROAD_MSG" ] ){
							csTemp += row[ "BROAD_MSG" ] + "\r\n";
						}
					}
					
					break;

				case 2 : // 사용
//					if(inJcdTypeFg == "M"){
//						if(!!row[ "JCD_AVL_POINT" ]){
//							csTemp += "부스트업 포인트: " + util.numberWithCommas( row[ "JCD_AVL_POINT" ] ) + "\r\n";
//						}
//						if(!!row[ "JCD_DC_AMT" ]){
//							csTemp += "할인 포인트: " + util.numberWithCommas( row[ "JCD_DC_AMT" ] ) + "\r\n";
//						}
//					}
					csTemp += "적립 포인트: " + util.numberWithCommas( row[ "JCD_OCC_POINT" ] ) + "\r\n";
					csTemp += "가용 포인트: " + util.numberWithCommas( row[ "JCD_REM_POINT" ] ) + "\r\n";
					
//					if(inJcdTypeFg == "M"){
//						if(!!row[ "BROAD_MSG" ] ){
//							csTemp += row[ "BROAD_MSG" ] + "\r\n";
//						}
//					}
					
					break;
				case 5 : // 사용취소.
//					csTemp += "누적 포인트: " + util.numberWithCommas( row[ "JCD_REM_POINT" ] ) + "\r\n";
//					csTemp += "발생 포인트: " + util.numberWithCommas( row[ "JCD_OCC_POINT" ] ) + "\r\n";
//					csTemp += "가용 포인트: " + util.numberWithCommas( row[ "JCD_AVL_POINT" ] ) + "\r\n";
					
//					if(inJcdTypeFg == "M"){
//						if(!!row[ "JCD_AVL_POINT" ]){
//							csTemp += "부스트업 포인트: " + util.numberWithCommas( row[ "JCD_AVL_POINT" ] ) + "\r\n";
//						}
//						if(!!row[ "JCD_DC_AMT" ]){
//							csTemp += "할인 포인트: " + util.numberWithCommas( row[ "JCD_DC_AMT" ] ) + "\r\n";
//						}
//					}
					csTemp += "적립 포인트: " + util.numberWithCommas( row[ "JCD_OCC_POINT" ] ) + "\r\n";
					csTemp += "가용 포인트: " + util.numberWithCommas( row[ "JCD_REM_POINT" ] ) + "\r\n";
					
//					if(inJcdTypeFg == "M"){
//						if(!!row[ "BROAD_MSG" ] ){
//							csTemp += row[ "BROAD_MSG" ] + "\r\n";
//						}
//					}
					break;
				case 6 : // 적립사용 ( 취소시에 4번 적립취소로 처리함 ) -> 2021.06.15 적립사용은 사용안함.
					if(strJcdTypeFg == "M"){
						if(!!row[ "JCD_DC_AMT" ]){
							csTemp += "할인 포인트: " + util.numberWithCommas( row[ "JCD_DC_AMT" ] ) + "\r\n";
						}
						if(!!row[ "JCD_AVL_POINT" ]){
							csTemp += "부스트업 포인트: " + util.numberWithCommas( row[ "JCD_AVL_POINT" ] ) + "\r\n";
						}
					}
					
					csTemp += "적립 포인트: " + util.numberWithCommas( row[ "JCD_OCC_POINT" ] ) + "\r\n";
					csTemp += "가용 포인트: " + util.numberWithCommas( row[ "JCD_REM_POINT" ] ) + "\r\n";
					
					if(strJcdTypeFg == "M"){						
						if(!!row[ "BROAD_MSG" ] ){							
							csTemp += row[ "BROAD_MSG" ] + "\r\n";
						}
					}
					break;
				case 7 : // 적립사용취소 ( 취소시에 4번 적립취소로 처리함 ) -> 2021.06.15 적립사용은 사용안함.
					if(strJcdTypeFg == "M"){
						if(!!row[ "JCD_DC_AMT" ]){
							csTemp += "할인 포인트: " + util.numberWithCommas( row[ "JCD_DC_AMT" ] ) + "\r\n";
						}
						if(!!row[ "JCD_AVL_POINT" ]){
							csTemp += "부스트업 포인트: " + util.numberWithCommas( row[ "JCD_AVL_POINT_MP" ] ) + "\r\n";
						}
					}
					
					csTemp += "적립 포인트: " + util.numberWithCommas( row[ "JCD_OCC_POINT" ] ) + "\r\n";
					csTemp += "가용 포인트: " + util.numberWithCommas( row[ "JCD_REM_POINT" ] ) + "\r\n";
					
					if(strJcdTypeFg == "M"){						
						if(!!row[ "BROAD_MSG" ] ){
							csTemp += row[ "BROAD_MSG" ] + "\r\n";
						}
					}
					break;
			}

			if( this.g_inPaperTypeFg == 0 ) {
				csTemp += "--------------------------------\r\n";
			}
			else {
				csTemp += "------------------------------------------\r\n";
			}

			csResult += csTemp;


		}
		return csResult;
	}

	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : GetSalesFoodData.
	// =============================================================================
	// PARAMETER 1 : No : .
	// RETURN VALUE : CString : .
	// PROGRAMMER : CWS-2009-06-01 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.GetSalesFoodData = function () {
		util.logInfo("*** GetSalesFoodData START ***");
		let csTemp	 = "";
		let csResult = "";

		let sql = _sql.GetSalesFoodData_SQL(  this.m_stSaleInfo  );
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0) {
			return false;
		}

		csTemp = "";
		let rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];

			if( this.g_inPaperTypeFg == 0 ) {
				csTemp = "      *** 식권정보[%d] ***\r\n".sprintf( ++bCnt );
			}
			else {
				csTemp = "           *** 식권정보[%d] ***\r\n".sprintf( ++bCnt );
			}

			csTemp += pu.GetMarkString_04( "액 면 가 액:", row[ "TK_FOD_UAMT"   ]/** .asDouble() * */ ) + "\r\n";
			csTemp += pu.GetMarkString_04( "결   제  액:", row[ "TK_FOD_AMT"    ]/** .asDouble() * */ ) + "\r\n";
			csTemp += pu.GetMarkString_04( "할   인  액:", row[ "TK_FOD_DC_AMT" ]/** .asDouble() * */ ) + "\r\n";
			csTemp += pu.GetMarkString_04( "자 투 리 액:", row[ "ETC_AMT"       ]/** .asDouble() * */ ) + "\r\n";

			if( this.g_inPaperTypeFg == 0 ) {
				csTemp += "-------------------------------------\r\n";
			} else {
				csTemp += "------------------------------------------\r\n";
			}

			csResult += csTemp;
		}

		return csResult;
	}

	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : GetSalesEtcApprData. : 모바일내역(기타결제) 출력
	// =============================================================================
	// PARAMETER 1 : No : .
	// RETURN VALUE : CString : .
	// PROGRAMMER : 2017-06-13-JYL : New. // 2017-06-13-JYL [기타결제:커피에반하다(톨게이트)]
	// /////////////////////////////////////////////////////////////////////////////
	this.GetSalesEtcApprData = function () {
		util.logInfo("*** GetSalesEtcApprData START ***");
		let bHdrCnt = 0;
		let bEtcCnt = 0;

		let dnAmtCntValue = 0;
		let csQrySql      = "";
		let csTemp        = "";
		let csResult      = "";

		let csTrTypeCd    = "";
		let csTrTypeNm    = "";
		let csUserData    = "";
		let csSaleYN      = "";
		let csTitle       = "";
		let csTemp1       = "";
		let csApprProc    = "";

		let csApprNo       = "";
		let csApprDate     = "";
		let csApprTime     = "";
		let csCardNo	   = "";

		if( this.g_inPaperTypeFg == 0 ) {

			csTemp += "-------------------------------------\r\n";
			csTemp += "      *** 모바일정보 ***\r\n";
		}
		else {
			csTemp += "------------------------------------------\r\n";
			csTemp += "           *** 모바일정보 ***\r\n";
		}


		let sql = _sql.GetSalesEtcApprData_SQL(  this.m_stSaleInfo , "01" );
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}

		csTemp = "";
		let rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];
			if( row[ "ETC_APPR_AMT" ]/** .asLong() * */ != 0 )
			{
				bHdrCnt++;
			}
			csTitle = "결제금액 : %s\r\n".sprintf( util.numberWithCommas( row[ "ETC_APPR_AMT" ] ) );
			csTemp += csTitle;

		}

		sql = _sql.GetSalesEtcApprData_SQL(  this.m_stSaleInfo , "02" );
		db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}

		let blCorner = pu.parseInt( this.GetEnvXmlShopENV( 114 ) )  == "1";
		let csCornerCd, csCornerNm, csCornerBizNo, csCornerOwnerNm, csLeftStr, csRightStr, csValue;


		csTemp = "";
		rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];


			bEtcCnt++;

			csTrTypeCd    =  row[ "TR_TYPE_CD"     ];
			csTrTypeNm    =  row[ "TR_TYPE_NM"     ];
			csUserData    =  row[ "USER_DATA"      ];
			csSaleYN      =  row[ "SALE_YN"        ] == "N" ? "-" : "";
			csApprProc	  =  row[ "APPR_PROC_FG"   ]; // 2019-1129-HJH 임의승인 추가
			csApprNo      =  row[ "APPR_NO"        ]; // 2019-1202-HJH 키타 승인번호
			csApprDate    =  row[ "APPR_DATE"      ]; // 2019-1202-HJH 키타 승인날짜
			csApprTime    =  row[ "APPR_TIME"      ]; // 2019-1202-HJH 키타 승인시간
			csCardNo	  =  row[ "CARD_NO"        ]; // 2019-1210-HJH 카드번호 추가
			
			if(csTrTypeCd == '003'){ // 모바일스템프 적립일 경우 스템프적립 갯수를 가져온다..
				var originalStampCount = '';			
				var userDataArr = userData.split("|");
				for(var i=0; userDataArr.length > i ; i++){
					var param = userDataArr[i];
					if(param.indexOf("originalStampCount") != -1){
						originalStampCount = param.substring(param.indexOf("^") + 1);
					}
				}
				dnAmtCntValue = Number(originalStampCount);
			}else{
				dnAmtCntValue = parseFloat( row[ "AMT_CNT_VALUE"  ])/** .asDouble() * */;
			}

			if( pu.isEmpty( csTrTypeNm ) ) {
				csTrTypeNm= "모바일-기타(%s)".sprintf( csTrTypeCd );
			}

			csTitle = "[%d] %s".sprintf( bEtcCnt, csTrTypeNm );

			if( this.g_inPaperTypeFg == 0 ) {
				csTemp += "-------------------------------------\r\n";
			} else {
				csTemp += "------------------------------------------\r\n";
			}

			csTemp += pu.GetMarkString_04( csTitle, dnAmtCntValue ) + "\r\n";
			
			//도도포인트 적립
			if( csTrTypeCd == "111" ) {
				var csTitle2 = "    %s".sprintf( "도도잔여포인트" );
				// USER_DATA : PURCHASES_ID^307ea8fa-fb2e-11eb-b340-aebbb7fe82e4|REMAIN_POINT^55112|SAVE_POINT^12100
				var aUserDataSplit = csUserData.split('|');
				var userDataSplit = aUserDataSplit[1].split('^');
				var dodoRemainAmtValue = userDataSplit[1];
				csTemp += pu.GetMarkString_04( csTitle2, dodoRemainAmtValue ) + "\r\n";
			}
			
			if( this.g_inPaperTypeFg == 0 )
			{
				csTemp += "-------------------------------------\r\n";
			}
			else
			{
				csTemp += "------------------------------------------\r\n";
			}
			
			// std::map<CString, CString> mapItem;
			// CString csKeyVal, csTmp1, csTmp2, csApproval;
			let csTmp1 = "", csTmp2 = "", csApproval = "";
			let mapItem = {};


// for(int i = 0; AfxExtractSubString( csKeyVal, csUserData, i, _T('|') ) ; i++)
// // 승인금액 + 승인방법 (PAYCO)
			for(let i = 0;  !pu.isEmpty(  pu.AfxExtractSubString( csUserData, i, '|' ) ) ; i++) { // 승인금액
																										// +
																										// 승인방법
																										// (PAYCO)
				let csKeyVal = pu.AfxExtractSubString( csUserData, i, '|' );
				csTmp1 = pu.AfxExtractSubString( csKeyVal, 0, '=' );
				csTmp2 = pu.AfxExtractSubString( csKeyVal, 1, '=' );

				// mapItem.insert(std::make_pair(csTmp1, csTmp2));
				mapItem[ csTmp1 ] = csTmp2 ;
			}

			if( mapItem["SignpadYN"] == "Y" ) {
				this.m_blSignPadUseFg = true;
			} else {
				this.m_blSignPadUseFg = false;
			}

			// 2016-0427 Antony.Choi : 별도 전표 출력 시 각각의 NoCVM Flag 확인
			if (mapItem["DdcFlag"] == "N" ) {
				this.m_stSaleInfo.stPrintData.NO_CVM_FLAG = true /** TRUE * */;
			} else {
				this.m_stSaleInfo.stPrintData.NO_CVM_FLAG = false /** FALSE * */;
			}

			if(csTrTypeCd == "011")  { // 썸패스
				if(  row[ "SALE_YN"  ] == "Y" )
					csTemp += "         *** 썸패스 승인정보 ***\r\n";
				else
					csTemp += "         *** 썸패스 취소정보 ***\r\n";

				if(mapItem["BnkCouponDiscountAmount"] != "0" && ! pu.isEmpty( mapItem["BnkCouponDiscountAmount"] ))
				{
					csTemp += "현금쿠폰 : " + util.numberWithCommas( csSaleYN + mapItem["BnkCouponDiscountAmount"] ) + "\r\n";
				}

				if(mapItem["AffiliateCouponDiscountAmount"] != "0" && !pu.isEmpty( mapItem["AffiliateCouponDiscountAmount"] )  )
				{
					csTemp += "제휴쿠폰 : " + util.numberWithCommas( csSaleYN + mapItem["AffiliateCouponDiscountAmount"] ) + "\r\n";
				}

				if(mapItem["CustomerPayAmount"] != "0" && !pu.isEmpty(mapItem["CustomerPayAmount"] ))
				{
					csTemp += "결제금액 : " + util.numberWithCommas( csSaleYN + mapItem["CustomerPayAmount"] ) + "\r\n";
				}

				if(!pu.isEmpty( mapItem["PayId"] ))
				{
					csTemp += "승인번호 : " + util.numberWithCommas( csSaleYN + mapItem["PayId"] ) + "\r\n";
				}

				csTemp += "------------------------------------------\r\n";
			}
			else if(csTrTypeCd == "021") // 페이코
			{
				if( row[ "SALE_YN"        ] == "Y" ){
					csTemp += "         *** PAYCO 승인정보 ***\r\n";
				}
				else{
					csTemp += "         *** PAYCO 취소정보 ***\r\n";
				}

				if(mapItem["ApprType"] == "R"){ // 포인트
					csTemp += "페이코포인트 : " + util.numberWithCommas( csSaleYN + mapItem["App_ApprAmt"] ) + "\r\n";
				}else if(mapItem["ApprType"] == "P"){ // 신용
					csTemp += "신 용 카 드  : " + util.numberWithCommas( csSaleYN + mapItem["App_ApprAmt"] ) + "\r\n";
				}else if(mapItem["ApprType"] == "A"){ // 쿠폰
					csTemp += "페이코쿠폰   : " + util.numberWithCommas( csSaleYN + mapItem["App_ApprAmt"] ) + "\r\n";
				}
				
				if(mapItem["Inq_DcAmt"] != "0" && !pu.isEmpty( mapItem["Inq_DcAmt"] )){
					csTemp += "쿠 폰 할 인  : " + util.numberWithCommas( csSaleYN + mapItem["Inq_DcAmt"] ) + "\r\n";
				}

				csTemp += "------------------------------------------\r\n";

				if(mapItem["ApprType"] == "P"){ // 신용
					csTemp += "카드/매입사 : " + mapItem["CardName"] + " / " + mapItem["MerchantName"] + "\r\n";					
					csTemp += "카 드 번 호 : " + mapItem["CardNo"] + "\r\n";
					csTemp += "할 부 개 월 : " + (mapItem["InstallmentMonths"] == "00" ? "일시불" : mapItem["InstallmentMonths"] + "개월") + "\r\n";
					
					csTemp += "승 인 금 액 : " + util.numberWithCommas( csSaleYN + mapItem["App_ApprAmt"] ) + "\r\n";					
				}else{
					csTemp += "승 인 금 액 : " + util.numberWithCommas( csSaleYN + mapItem["App_ApprAmt"] ) + "\r\n";
				}

				csTemp += "승 인 번 호 : " + mapItem["ApprNo"] + "\r\n";
				if( row[ "SALE_YN" ] == "Y" ) {					
					csTemp1= "%s/%s/%s %s:%s:%s".sprintf(
						csApprDate.substr(0, 2)
						, csApprDate.substr(2, 2)
						, csApprDate.substr(4, 2)
						, csApprTime.substr(0, 2)
						, csApprTime.substr(2, 2)
						, csApprTime.substr(4, 2)
						);
				} else {
					csTemp1 = "%s/%s/%s %s:%s:%s".sprintf(
						csApprDate.substr(0, 2)
						, csApprDate.substr(2, 2)
						, csApprDate.substr(4, 2)
						, csApprTime.substr(0, 2)
						, csApprTime.substr(2, 2)
						, csApprTime.substr(4, 2)
						);
				}					
				csTemp += "승 인 일 시 : " + csTemp1 + "\r\n";
				
				csTemp += "가 맹 번 호 : " + mapItem["CardMerchantNo"]  + "\r\n";
				
			} else if(csTrTypeCd == "041" || csTrTypeCd == "042") { // 2019-1111-HJH
																	// : 카카오페이.
				util.logInfo('mapItem' , mapItem);
				if( row[ "SALE_YN"  ] == "Y" )
					csTemp += "         *** 카카오페이 승인정보 ***\r\n";
				else
					csTemp += "         *** 카카오페이 취소정보 ***\r\n";

				if( csApprProc == "2" )	 {
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += pu.GetPRTDeviceCMD( "V2X" ) /** PRT_BASE_V2X * */ ;
						csTemp += pu.GetPRTDeviceCMD( "REVERSE_ON" ) /** PRT_BASE_REVERSE_ON * */;
						csTemp += "** 단말기 승인요망 **\r\n";		// 2014-0716-Jane :
															// 임의등록 문구 변경
					}
					else {
						csTemp += pu.GetPRTDeviceCMD( "HV2X" ) /** PRT_BASE_HV2X * */;
						csTemp += pu.GetPRTDeviceCMD( "REVERSE_ON" ) /** PRT_BASE_REVERSE_ON * */;
						csTemp += "** 단말기 승인요망 **\r\n";		// 2014-0716-Jane :
															// 임의등록 문구 변경
					}
					csTemp += pu.GetPRTDeviceCMD( "NORM" ) /** PRT_BASE_NORM * */;
					csTemp += pu.GetPRTDeviceCMD( "REVERSE_OFF" ) /** PRT_BASE_REVERSE_OFF * */;
					csTemp += pu.GetPRTDeviceCMD( "INIT" ) /** PRT_BASE_INIT * */;
				}

				if( blCorner )
				{
					csCornerCd		= row[ "CORNER_CD" ];
					csCornerNm		= row[ "CORNER_NM" ];
					csCornerBizNo	= this.GetEnvXmlCornerENV( /** atoi * */ parseInt ( csCornerCd ), "BIZ_NO"   );
					csCornerOwnerNm = this.GetEnvXmlCornerENV( /** atoi * */ parseInt ( csCornerCd ), "OWNER_NM" );
					csCornerBizNo   = pu.DllTransAtoA_Format( csCornerBizNo, "BIZ_NO" );

					if( util.byteLen( csCornerOwnerNm) >  6   ) {
						csCornerOwnerNm = csCornerOwnerNm.cutStr(  6  );
					}


					csLeftStr = "▶%s\r\n".sprintf( csCornerNm );
					csTemp += csLeftStr;
					csLeftStr = "사업자번호  : %s [ %s ]\r\n".sprintf( csCornerBizNo, csCornerOwnerNm );
					csTemp += csLeftStr;
				}

				csTemp += "카드/매입사 : " + mapItem["CardName"] + "/" + mapItem["MerchantName"] + "\r\n";

				// 2020-0121-HJH : 할부추가
				csTemp1 = "";
				if( mapItem["ApprType"] == "C" ) {
					if( pu.parseInt( mapItem["InstallmentPeriod"] ) < 2 ) {
						csTemp1 = "(일시불)";
					} else {
						util.logInfo('mapItem' , mapItem);
						csTemp1 = + "(" +mapItem["InstallmentPeriod"] + "개월)";
					}
				}

				if(  row[ "SALE_YN" ] == "Y" )
					csTemp += "결제금액    : " + util.numberWithCommas( mapItem["App_ApprAmt"] ) + csTemp1 + "\r\n";
				else
					csTemp += "결제금액    : " + util.numberWithCommas( "-" + mapItem["App_ApprAmt"] ) + csTemp1 + "\r\n";

				csTemp += "할인금액    : " + util.numberWithCommas( mapItem["Inq_DcAmt"] ) + "\r\n";
				csTemp += "승인번호    : " + mapItem["ApprNo"] + "\r\n";
				csTemp += "가맹점번호  : " + mapItem["Number"] + "\r\n";
				csTemp += "승인일시    : " + pu.DllTransAtoA_Format( mapItem["ApprDate"], "YY/MM/DD HH:MM:SS" ) + "\r\n";
				csTemp += "Notice      : " + mapItem["Notice"] + "\r\n";

				// 2020-0122-HJH 메시지 추가
				if( !pu.isEmpty( mapItem["BroadMsg"] )  ) {
					csTemp += mapItem["BroadMsg"] + "\r\n";
				}

			} else if( csTrTypeCd == "051" )	{				// 2019-1203-HJH
																// : 제로페이.

				if( row[ "SALE_YN" ] == "Y" )
					csTemp += "         *** 제로페이 승인정보 ***\r\n";
				else
					csTemp += "         *** 제로페이 취소정보 ***\r\n";

				if( csApprProc == "2" ) {

					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += pu.GetPRTDeviceCMD( "V2X" ) /** PRT_BASE_V2X * */ ;
						csTemp += pu.GetPRTDeviceCMD( "REVERSE_ON" ) /** PRT_BASE_REVERSE_ON * */;
						csTemp += "** 단말기 승인요망 **\r\n";		// 2014-0716-Jane :
															// 임의등록 문구 변경

					} else {
						csTemp += pu.GetPRTDeviceCMD( "HV2X" ) /** PRT_BASE_HV2X * */;
						csTemp += pu.GetPRTDeviceCMD( "REVERSE_ON" ) /** PRT_BASE_REVERSE_ON * */;
						csTemp += "** 단말기 승인요망 **\r\n";		// 2014-0716-Jane :
															// 임의등록 문구 변경
					}
					csTemp +=  pu.GetPRTDeviceCMD( "NORM" ) /** PRT_BASE_NORM * */;
					csTemp += pu.GetPRTDeviceCMD( "REVERSE_OFF" ) /** PRT_BASE_REVERSE_OFF * */;
					csTemp += pu.GetPRTDeviceCMD( "INIT" ) /** PRT_BASE_INIT * */;
				}

				if( blCorner ) {
					csCornerCd		= row[ "CORNER_CD" ];
					csCornerNm		= row[ "CORNER_NM" ];
					csCornerBizNo	= this.GetEnvXmlCornerENV( /** atoi * */ parseInt ( csCornerCd ), "BIZ_NO"   );
					csCornerOwnerNm = this.GetEnvXmlCornerENV( /** atoi * */ parseInt ( csCornerCd ), "OWNER_NM" );
					csCornerBizNo   = pu.DllTransAtoA_Format( csCornerBizNo, "BIZ_NO" );

					if( csCornerOwnerNm.getByteLength() >  6  ) {
						csCornerOwnerNm = csCornerOwnerNm.cutStr(  6  );
					}


					csLeftStr = "▶%s\r\n".sprintf ( csCornerNm );
					csTemp += csLeftStr;
					csLeftStr = "사업자번호  : %s [ %s ]\r\n".sprintf( csCornerBizNo, csCornerOwnerNm );
					csTemp += csLeftStr;
				}

				csTemp += "카드/매입사 : " + mapItem["CardName"] + "/" + mapItem["MerchantName"] + "\r\n";
				csTemp += "카드번호    : " + csCardNo  + "\r\n";
				csTemp += "결제금액    : " + util.numberWithCommas( dnAmtCntValue )  + "\r\n";
				csTemp += "승인번호    : " + mapItem["ApprNo"] + "\r\n";
				csTemp += "가맹점번호  : " + mapItem["Number"] + "\r\n";
				csTemp += "승인일시    : " + pu.DllTransAtoA_Format( mapItem["ApprDate"], "YY/MM/DD HH:MM:SS" ) + "\r\n";
				csTemp += "Notice      : " + mapItem["Notice"] + "\r\n";

				// 2020-0122-HJH 메시지 추가
				if( !pu.isEmpty( mapItem["BroadMsg"] ) ) {
					csTemp += mapItem["BroadMsg"] + "\r\n";
				}
			}


		}
		if( bHdrCnt > 0 || bEtcCnt > 0)  {
			csResult = csTemp;
		}

		return csResult;
	}
	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : GetSalesCouponData.
	// =============================================================================
	// PARAMETER 1 : No : .
	// RETURN VALUE : CString : .
	// PROGRAMMER : Jane.Park : New. 2015-0610
	// /////////////////////////////////////////////////////////////////////////////
	this.GetSalesCouponData = function() {
		util.logInfo("*** GetSalesCouponData START ***");
		let	bCnt = 0;
		let	dnCpnAmt  = 0;

		let csResult  = "";
		let csQrySql  = "";
		let csTemp    = "";
		let csCpnCode = "";
		let csCpnName = "";

		let sql = _sql.GetSalesCouponData_SQL(  this.m_stSaleInfo  );
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}

		csTemp = "";
		let rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];

			if( this.g_inPaperTypeFg == 0 ) {
				csTemp = "      *** 쿠폰정보[%d] ***\r\n".sprintf( ++bCnt );

			} else {
				csTemp = "           *** 쿠폰정보[%d] ***\r\n".sprintf( ++bCnt );
			}

			csCpnName = row[ "TK_CPN_NAME" ];

			csTemp += "사용쿠폰: ";
			csTemp += pu.DllGetCutHangul( csCpnName, csCpnName.length /** .GetLength() * */ );
			csTemp += "\r\n";

			csTemp += "할인금액: ";
			csTemp += util.numberWithCommas(dnCpnAmt);
			csTemp += "\r\n";

			if( this.g_inPaperTypeFg == 0 ) {
				csTemp += "-------------------------------------\r\n";
			}
			else {
				csTemp += "------------------------------------------\r\n";
			}

			csResult += csTemp;
		}

		return csResult;
	}
	// 2014-0317-Jane : 주문취소사유 등록 기능 추가
	this.GetOrderCancelReason = function () {
		util.logInfo("*** GetOrderCancelReason START ***");

		let csPrint      = "";
		let csQuery      = "";
		let csValue      = "";

		let     inEnvShop629 =  pu.parseInt ( this.GetEnvXmlShopENV( 629 ) );

		if( inEnvShop629 == 0 || inEnvShop629 == 2 ) {
			return "";
		}

		let sql = _sql.GetOrderCancelReason_SQL();
		sql = sql.sprintf(this.m_stSaleInfo.SHOP_CD, this.m_stSaleInfo.POS_NO, this.m_stSaleInfo.SALE_DATE, this.m_stSaleInfo.POS_NO, this.m_stSaleInfo.ORDER_SEQ_NO );

		let db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return "";
		}

		let rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];


			if(  csPrint.length /** .GetLength() * */ <= 0 ) {
				csPrint += "[주문 취소 사유] \r\n";
			}

			if( this.g_inPaperTypeFg == 0 ) {
				csValue/** .Format * */ =   "%-30s\r\n".sprintf(  row[ "COM_CD_NM" ]  );
			} else {
				csValue =  "%-40s\r\n".sprintf( row[ "COM_CD_NM" ]  );
			}

			csPrint += csValue;

		}

		if(  csPrint.length /** .GetLength() * */ > 0 ) {
			if( this.g_inPaperTypeFg == 0 ) {
				csPrint += "--------------------------------\r\n";
			}
			else {
				csPrint += "------------------------------------------\r\n";
			}
		}

		return csPrint;
	}

	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : GetSalesGiftData.
	// =============================================================================
	// PARAMETER 1 : No : .
	// RETURN VALUE : CString : .
	// PROGRAMMER : CWS-2009-06-01 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.GetSalesGiftData = function() {
		let csPrint  = "";
		let csQuery  = "";
		let csResult = "";

		let inCnt = 0;
		let sql = _sql.GetSalesGiftData_SQL(  this.m_stSaleInfo  );
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}

		let rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];
			if( this.g_inPaperTypeFg == 0 ) {
				csPrint = "     *** 상품권정보[%d] ***\r\n".sprintf( ++inCnt );
			}
			else {
				csPrint = "          *** 상품권정보[%d] ***\r\n".sprintf( ++inCnt );
			}

			csPrint += pu.GetMarkString_04( "액 면  가 액:", row[ "TK_GFT_UAMT"   ]/** .asDouble() * */ ) + "\r\n";
			csPrint += pu.GetMarkString_04( "결   제   액:", row[ "TK_GFT_AMT"    ]/** .asDouble() * */ ) + "\r\n";
			csPrint += pu.GetMarkString_04( "현  금환불액:", row[ "REPAY_CSH_AMT" ]/** .asDouble() * */ ) + "\r\n";
			csPrint += pu.GetMarkString_04( "상품권환불액:", row[ "REPAY_GFT_AMT" ]/** .asDouble() * */ ) + "\r\n";

			if( this.g_inPaperTypeFg == 0 ) {
				csPrint += "--------------------------------\r\n";
			}
			else {
				csPrint += "------------------------------------------\r\n";
			}

			csResult += csPrint;

		}

		return csResult;
	}

	this.GetSalesCustData = function() {
		let bCnt = 0;
		let csQrySql       = "";
		let csTemp	       = "";
		let csResult       = "";
		let csCode	       = "";
		let csCustInfo     = "";	// 2009-1116-YBC
		let csString       = "";	// 2011-0614-JJM : .
		let csPointNm      = "";	// 2013-0809-JJM : .
		let csCustNm       = "";	// 2013-10-14 Antony.Choi : 회원이름 비공개 처리 추가
		let csCustNmTemp   = "";

		let lnAccPoint  = 0;
		let lnAvlPoint  = 0;
		let lnSalePoint = 0;
		let lnUsePoint  = 0;

		let sql = _sql.GetSalesCustData_SQL(  this.m_stSaleInfo  );
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}

		let rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];


			if( this.g_inPaperTypeFg == 0 )
			{
				// //////////////////////////////////////////////////////////////////
				// 2013-0809-JJM : 포인트구분에 따라 포인트/스탬프 명칭 구분.
				// //////////////////////////////////////////////////////////////////
				csPointNm = SHOP_INFO.POINT_FG == "M" ? " *** 회원 마일리지 정보[%d] ***\r\n" : "  *** 회원 스탬프 정보[%d] ***\r\n";

				csTemp = csPointNm.sprintf( ++bCnt );// 2013-0906-JJM : " ***
														// 회원정보[%d] ***\r\n" ->
														// csPointNm.
				// //////////////////////////////////////////////////////////////////
				// 2013-10-14 Antony.Choi : 회원이름 비공개 처리 추가
				// //////////////////////////////////////////////////////////////////
				csCustNm ="%s".sprintf(row[ "CST_NM" ]);				
				if (pu.DllCheckExistHangul(csCustNm) == true /** TRUE * */ && util.byteLen( csCustNm)  > 5 ) {
					csCustNmTemp = pu.DllGetMidHangul(csCustNm, 0, 1 ) + "*" + pu.DllGetMidHangul(csCustNm, 2, csCustNm.length); // +
																																																			// csCustNm.Mid(
																																																			// 3
																																																			// /**
																																																			// LEN_DEF_3
																																																			// **/,csCustNm.length
																																																			// /**
																																																			// .GetLength()
																																																			// **/
																																																			// - 3
																																																			// /**
																																																			// LEN_DEF_3
																																																			// **/)
																																																			// ;
				} else if (pu.DllCheckExistHangul(csCustNm) == true  ) {
					csCustNmTemp = pu.DllGetCutHangul(csCustNm, 2 ) + "*" ; // +
																								// csCustNm.Mid(
																								// 3
																								// /**
																								// LEN_DEF_3
																								// **/,csCustNm.length
																								// /**
																								// .GetLength()
																								// **/
																								// - 3
																								// /**
																								// LEN_DEF_3
																								// **/)
																								// ;

				} else if ( !pu.isEmpty( csCustNm ) &&  csCustNm.length > 2 ) {
					csCustNmTemp = csCustNm.substr(0, 1) + "*" + csCustNm.substr( 2 ,csCustNm.length  -  2 );
				}

				csCustInfo = "%s %s님".sprintf( row[ "CST_NO" ], csCustNm );
				// //////////////////////////////////////////////////////////////////////////////////////
				csTemp += pu.GetMarkString_03( "회원번호", csCustInfo, 14, 18 ) + "\r\n";
				if( row[ "WES_AMT" ] != 0 ) {
					csTemp += pu.GetMarkString( "외상금액", pu.parseInt( row[ "WES_AMT" ] ) , 14, 18 ) + "\r\n";
				}

				lnAvlPoint  = pu.parseInt (row[ "AVL_POINT"  ])  ;
				lnSalePoint = pu.parseInt (row[ "SALE_POINT" ])  ;
				lnUsePoint  = pu.parseInt (row[ "USE_POINT"  ])  ;
				lnAccPoint = lnAvlPoint + lnSalePoint - lnUsePoint;

				csString = "적립%10s    사용%10s\r\n".sprintf(
							     util.numberWithCommas( lnSalePoint )
							   , util.numberWithCommas( lnUsePoint  ) );
				csTemp += csString;
				// 2016-0920 Antony.Choi : 가맹점 서비스팀 요청으로 누적에서 가용으로 문구 변경
				csString = "잔여%10s    가용%10s\r\n".sprintf(
							     util.numberWithCommas( lnAvlPoint )
							   , util.numberWithCommas( lnAccPoint ) );
				csTemp += csString;
				csTemp += "\r\n--------------------------------\r\n";

			} else {
				// //////////////////////////////////////////////////////////////////
				// 2013-0809-JJM : 포인트구분에 따라 포인트/스탬프 명칭 구분.
				// //////////////////////////////////////////////////////////////////
				csPointNm = SHOP_INFO.POINT_FG == "M" ? "      *** 회원 마일리지 정보[%d] ***\r\n" : "       *** 회원 스탬프 정보[%d] ***\r\n";

				csTemp= csPointNm.sprintf( ++bCnt ); // 2013-0906-JJM : " ***
														// 회원정보[%d] ***\r\n" ->
														// csPointNm.
				// //////////////////////////////////////////////////////////////////
				// 2013-10-14 Antony.Choi : 회원이름 비공개 처리 추가
				// //////////////////////////////////////////////////////////////////
				csCustNm =row[ "CST_NM" ] ;
				if (pu.DllCheckExistHangul(csCustNm) == true /** TRUE * */ &&  util.byteLen(  csCustNm ) > 5 ) {
					csCustNmTemp = pu.DllGetMidHangul(csCustNm,0 , 1) + "*" + pu.DllGetMidHangul(csCustNm,2 , csCustNm.length); // +
																																																	// csCustNm.Mid(
																																																	// 3
																																																	// /**
																																																	// LEN_DEF_3
																																																	// **/,csCustNm.length
																																																	// /**
																																																	// .GetLength()
																																																	// **/
																																																	// - 3
																																																	// /**
																																																	// LEN_DEF_3
																																																	// **/)
																																																	// ;
				} else if (pu.DllCheckExistHangul(csCustNm) == true   ) {
					csCustNmTemp = pu.DllGetCutHangul(csCustNm, 2 ) + "*" ; // +
																								// csCustNm.Mid(
																								// 3
																								// /**
																								// LEN_DEF_3
																								// **/,csCustNm.length
																								// /**
																								// .GetLength()
																								// **/
																								// - 3
																								// /**
																								// LEN_DEF_3
																								// **/)
																								// ;
				} else if ( !pu.isEmpty( csCustNm ) &&  csCustNm.length > 2 ) {
					csCustNmTemp = csCustNm.substr(0, 1 ) + "*" + csCustNm.substr( 2 ,csCustNm.length - 2 );
				}

				csCustInfo = "%s %s님".sprintf( row[ "CST_NO" ], csCustNmTemp );
				csTemp += pu.GetMarkString_03( "회원번호", csCustInfo, 20, 22 ) + "\r\n";
				if( row[ "WES_AMT" ]/** .asDouble() * */ != 0 )
				{
					csTemp += pu.GetMarkString( "외상금액", row[ "WES_AMT" ]/** .asDouble() * */, 20, 22 ) + "\r\n";
				}
				lnAvlPoint  = parseInt (row[ "AVL_POINT"  ])/** .asLong() * */;
				lnSalePoint = parseInt (row[ "SALE_POINT" ])/** .asLong() * */;
				lnUsePoint  = parseInt (row[ "USE_POINT"  ])/** .asLong() * */;
				lnAccPoint = lnAvlPoint + lnSalePoint - lnUsePoint;

				csString = "적립%15s    사용%15s\r\n".sprintf(
							     util.numberWithCommas( lnSalePoint )
							   , util.numberWithCommas( lnUsePoint  ) );
				csTemp += csString;

				// 2016-0920 Antony.Choi : 가맹점 서비스팀 요청으로 누적에서 가용으로 문구 변경
				csString = "잔여%15s    가용%15s\r\n".sprintf(
							     util.numberWithCommas( lnAvlPoint )
							   , util.numberWithCommas( lnAccPoint ) );
				csTemp += csString;
				csTemp += "\r\n------------------------------------------\r\n";
			}
			csResult += csTemp;
		}
		return csResult;
	}
	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : GetSalesCashData.
	// =============================================================================
	// PARAMETER 1 : No : .
	// RETURN VALUE : CString : .
	// PROGRAMMER : CWS-2009-02-18 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.GetSalesCashData = function() {

		let blBizFg = false /** FALSE * */;	// 2012-0314-JJM : .

		let blCorner	 = false;
		let blCornerRun = false;

		let bCnt	    = 0;
		let bCornerCnt = 0;

		let	csLineTemp      = "";
		let csTemp	        = "";
		let csTempStr	    = "";
		let csCode	        = "";
		let csCashIdtNo		= "";
		let csCornerBizNo	= "";	// 2009-1228-YBC
		let csCornerOwnerNm = "";	// 2009-1228-YBC
		let csCornerCd      = "";	// 2009-1228-YBC
		let csCornerNm      = "";	// 2009-1228-YBC
		let csLeftStr       = "";	// 2009-1228-YBC
		let csRightStr      = "";	// 2009-1228-YBC
		let	csChgBillNo     = "";	// 2010-0129-JJM.
		let	csValue         = "";	// 2012-0203-JJM : .

		blCorner = pu.parseInt( this.GetEnvXmlShopENV( 114 ) ) == "1";

		if( this.m_stSaleInfo.csLineNoCut == "Y" ) {
			if( g_csCornerSetFg != "1" ) {
				csTemp = "AND   A.LINE_NO   = '%s' ".sprintf( this.m_stSaleInfo.csLineNo );
			}
			else {
				csTemp = "\n   AND   A.LINE_NO   = '%s' "
					   + "\n   AND   A.SEQ_NO    = '%s' "
					    ;
				csTemp = csTemp.sprintf(  this.m_stSaleInfo.csLineNo, this.m_stSaleInfo.csLineSeqNo );
			}
		}
		let sql = _sql.GetSalesCashData_SQL( blCorner , this.m_stSaleInfo , csTemp );
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}
		csTemp = "";
		let rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];

			if( bCnt > 0
			&& row[ "LINE_NO" ] != csLineTemp ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += "--------------------------------";
				}
				else {
					csTemp += "------------------------------------------";
				}
			}

			if( row[ "LINE_NO" ] != csLineTemp ) {
				csCode = row[ "APPR_IDT_TYPE" ];
				if( this.g_inPaperTypeFg == 0 ) {
					// 2013-1202 Antony Choi : 단순현금 영수증도 전표 출력 처리
					if( csCode == "0" )	{
						csTempStr =  "*** 현금영수증(단순결제)[%d] ***\r\n".sprintf( ++bCnt );
						blBizFg = false /** FALSE * */;
					}
					// ///////////////////////////////////////////////////////////////////////////
					else if( csCode == "1" )	{
						csTempStr = "*** 현금영수증(소득공제)[%d] ***\r\n" .sprintf( ++bCnt );
						blBizFg = false /** FALSE * */;
					}
					else if( csCode == "2" ) {
						csTempStr = "*** 현금영수증(지출증빙)[%d] ***\r\n".sprintf( ++bCnt );
						blBizFg = true /** TRUE * */;
					}
					else if( csCode == "5" ) {
						csTempStr = "*** 현금영수증(자진발급)[%d] ***\r\n" .sprintf( ++bCnt );
						blBizFg = false /** FALSE * */;
					}
				}
				else {
					// 2013-1202 Antony Choi : 단순현금 영수증도 전표 출력 처리
					if( csCode == "0" )	{
						csTempStr = "     *** 현금영수증(단순결제)[%d] ***\r\n" .sprintf( ++bCnt );
						blBizFg = false /** FALSE * */;
					}
					// /////////////////////////////////////////////////////////////////////////
					else if( csCode == "1" ) {
						csTempStr = "     *** 현금영수증(소득공제)[%d] ***\r\n" .sprintf( ++bCnt );
						blBizFg = false /** FALSE * */;
					}
					else if( csCode == "2" ) {
						csTempStr = "     *** 현금영수증(지출증빙)[%d] ***\r\n" .sprintf( ++bCnt );
						blBizFg = true /** TRUE * */;
					}
					else if( csCode == "5" ) {
						csTempStr = "     *** 현금영수증(자진발급)[%d] ***\r\n".sprintf( ++bCnt );
						blBizFg = false /** FALSE * */;
					}
				}
				csTemp += csTempStr;
				bCornerCnt = 0;
			}

			if( blCorner ) {
				// //////////////////////////////////////////////////////////////////
				// 2009-1228-YBC
				// //////////////////////////////////////////////////////////////////
				csCornerCd		= row[ "CORNER_CD"   ];
				csCornerNm		= row[ "CORNER_NM"   ];
				csCornerBizNo	= this.GetEnvXmlCornerENV( parseInt( csCornerCd ), "BIZ_NO"   );
				csCornerOwnerNm = this.GetEnvXmlCornerENV( parseInt( csCornerCd ), "OWNER_NM" );
				csCornerBizNo   = pu.DllTransAtoA_Format( csCornerBizNo, "BIZ_NO" );
				csChgBillNo     = row[ "CHG_BILL_NO" ];

				if( util.byteLen( csCornerOwnerNm )  > 6 ) {
					csCornerOwnerNm = csCornerOwnerNm.cutStr(  6  );
				}

				csTemp += "\r\n";

				if( pu.parseInt( this.GetEnvXmlShopENV( 152 ) )  == 0 ) {
					csLeftStr = "▶%s\r\n".sprintf( csCornerNm );
					csTemp += csLeftStr;
				} else {
					csLeftStr = "▶%s [ %s ]\r\n" .sprintf(  csCornerNm, csChgBillNo );
					csTemp += csLeftStr;
				}

				if( this.g_inPaperTypeFg == 0 ) {
					csLeftStr = "사업자 %s [%s]\r\n".sprintf( csCornerBizNo, csCornerOwnerNm  );
				}
				else {
					csLeftStr =  "사 업 자 : %s [ %s ]\r\n".sprintf( csCornerBizNo, csCornerOwnerNm  );
				}

				csTemp += csLeftStr;
			}

			// 2013-1202 Antony Choi : 단순현금 영수증도 전표 출력 처리
			if( csCode == "0" )	{

				csValue ="결제금액 : %s\r\n".sprintf( util.numberWithCommas( row[ "CASH_AMT" ] ) );
				csTemp += csValue;

			}
			else{
				csCashIdtNo = row[ "APPR_IDT_NO" ];

// csTemp += "확인번호 : ";

				// 2014-0716-Jane : 임의등록 문구 강조 표시
				if( row[ "APPR_PROC_FG" ]/** .asShort() * */ == 2 )	{
					if( this.g_inPaperTypeFg == 0 ) {
						csTemp += pu.GetPRTDeviceCMD( "V2X" );
						csTemp += pu.GetPRTDeviceCMD( "REVERSE_ON" );
						csTemp += "** 단말기 승인요망 **\r\n";		// 2014-0716-Jane :
															// 임의등록 문구 변경
					}
					else {
						csTemp += pu.GetPRTDeviceCMD( "HV2X" );
						csTemp += pu.GetPRTDeviceCMD( "REVERSE_ON" );;
						csTemp += "** 단말기 승인요망 **\r\n";		// 2014-0716-Jane :
															// 임의등록 문구 변경
					}
					csTemp += pu.GetPRTDeviceCMD( "NORM" );
					csTemp += pu.GetPRTDeviceCMD( "REVERSE_OFF" );
					csTemp += pu.GetPRTDeviceCMD( "INIT" ) ;
				}
				else {
					csTemp += "확인번호 : ";
					if( this.g_inPaperTypeFg == 0 ) {
						// csTemp += LPad( g_clsUtil.DllSetCashBillNoMasking(
						// csCashIdtNo, blBizFg ), 22 ) + "\r\n";
						// 2014-1124 Antony.Choi : 국세청 요청으로 현금영수증 마스킹 체계 변경
						// csTemp += g_clsUtil.DllSetCashBillNoMasking(
						// csCashIdtNo, blBizFg ) + "\r\n";
						csTemp +=  csCashIdtNo + "\r\n";
					}
					else {
						// csTemp += LPad( g_clsUtil.DllSetCashBillNoMasking(
						// csCashIdtNo, blBizFg ), 32 ) + "\r\n";
						// 2014-1124 Antony.Choi : 국세청 요청으로 현금영수증 마스킹 체계 변경
						// csTemp += g_clsUtil.DllSetCashBillNoMasking(
						// csCashIdtNo, blBizFg ) + "\r\n";
						csTemp += csCashIdtNo + "\r\n";
					}
				}

				csValue =  "승인금액 : %s\r\n".sprintf( util.numberWithCommas( row[ "APPR_AMT" ] ) );
				csTemp += csValue;

				csValue = "승인번호 : %s\r\n".sprintf( row[ "APPR_NO" ] );
				csTemp += csValue;

				csTemp += "승인일시 : " + pu.DllTransAtoA_Format( row[ "APPR_DATE" ] + row[ "APPR_TIME" ], "YYYY-MM-DD HH:MM:SS" );
				csTemp += "\r\n";

				csLineTemp = row[ "LINE_NO" ];

				csValue =  "단말기NO : %s\r\n".sprintf( row[ "VAN_TERM_NO" ] );
				csTemp += csValue;

				// //////////////////////////////////////////////////////////////////////
				// 2012-0203-JJM : NOTICE, 알림메세지 출력.
				// //////////////////////////////////////////////////////////////////////
				csValue = row[ "NOTICE_MSG" ];
				if( csValue.length /** .GetLength() * */ > 0 ) {
					if( this.g_inPaperTypeFg != 0 ) {
						csTemp += "  NOTICE : ";
					}
					csTemp += csValue + "\r\n";
				}

				csValue = row[ "BROAD_MSG" ];
				if( csValue.length /** .GetLength() * */ > 0 ) {
					if( this.g_inPaperTypeFg != 0 ) {
						csTemp += "알    림 : ";
					}
					csTemp += csValue + "\r\n";
				}
			}
		}
		return csTemp;
	}

	// 단체 중간계산서 테이블명 출력 (by Ilgeun Oh, 200115)
	this.GetGroupTableNo = function () {
		let csRetStr		= "";
		let csTableNm		= "";
		let csGroupNm		= "";
		let csGroupTableNm	= "";

		let sql = _sql.GetGroupTableNo_SQL(  this.m_stSaleInfo  );
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}


		let rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];

			csTableNm = row[ "TABLE_NM" ];

			if ( csGroupNm != row[ "GROUP_NM" ] ) {
				csGroupNm = row[ "GROUP_NM" ];
				csGroupTableNm/** .Format * */ =  " %s-%s,".sprintf( csGroupNm, csTableNm );

			} else {
				csGroupTableNm/** .Format * */ = "%s,".sprintf( csTableNm );
			}

			csRetStr += pu.RPad( pu.DllGetCutHangul( csGroupTableNm, csGroupTableNm.getByteLength() /** .GetLength() * */ ), csGroupTableNm.getByteLength() /** .GetLength() * */ );

		}
		csRetStr = csRetStr.ltrim();
		// csRetStr.TrimRight(" abcdefg , " );//안지워져야 하는 데이터.
		// csRetStr.TrimRight(" abcdefg ," );//콤마 삭제.
		if ( csRetStr.endsWith(",")) {
			csRetStr = csRetStr.substring(0, csRetStr.length - 1 );
		}

		return csResult;
	}

	this.GetRegiEmpData = function() {

		let sql = _sql.GetRegiEmpData_SQL (  this.m_stSaleInfo  );
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}

		let rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];

			if( ! this.m_SaleClose ) {
				this.m_stSaleInfo.OPEN_DT = pu.DllTransAtoA_Format( row[ "OPEN_DT" ], "YYYY-MM-DD HH:MM:SS" );
			}

			this.m_stSaleInfo.CLOSE_DT = pu.DllTransAtoA_Format( row[ "CLOSE_DT" ], "YYYY-MM-DD HH:MM:SS"  );

			this.m_stSaleInfo.EMP_NO  = row[ "EMP_NO" ] ;
			this.m_stSaleInfo.EMP_NM  = row[ "EMP_NM" ] ;

		}
		return true;
	}
	this.GetRegiOpenDtData = function () {
		let sql = _sql.GetRegiOpenDtData_SQL(  this.m_stSaleInfo  );
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}

		let row = db_result.Data[0];
		this.m_stSaleInfo.OPEN_DT = pu.DllTransAtoA_Format( row[ "OPEN_DT" ], "YYYY-MM-DD HH:MM:SS" );

		return true;
	}

	/***************************************************************************
	 * 마감정산지pcsCode 08, 09
	 **************************************************************************/
	this.GetRegiTotalData = function () {
		util.logInfo("*** GetRegiTotalData START ***");
		let csTemp	      = "";
		let csValue      = "";
		let csCashAmt    = "";
		let csBillAmt    = "";
		let csEnvShop128 = pu.parseInt( this.GetEnvXmlShopENV( 128 ) );

		/** double * */  let dnSaleAmt        = 0;
		/** double * */  let dnTkGftInAmt     = 0;
		/** double * */  let dnTkGftOutAmt    = 0;
		/** double * */  let dnTkGftRemAmt    = 0;
		/** double * */  let dnAccountCashSum = 0;
		/** double * */  let dnAgentFeeAmt    = 0;
		/** double * */  let dnRetBillCashAmt = 0;			// 2014-1124-Jane :
															// 현금반품액 추가.
		/** double * */  let dnRetBillCardAmt = 0;			// 2014-1124-Jane :
															// 카드반품액 추가.
		/** double * */  let dnCashICAmt      = 0;			// 2014-1124-Jane :
															// 현금IC 승인금액 추가.
		/** double * */  let dnRetCashICAmt   = 0;			// 2014-1124-Jane :
															// 현금IC 반품금액 추가.

		/** WORD * */  let bCnt = 0;
		let sql = "";
		let row = null;
		try {
			if( this.m_SaleClose ) {
				sql = _sql.GetRegiTotalData_true_SQL_01(  this.m_stSaleInfo );
				row = this.db_get_single_row ( sql  , []);
				if ( !pu.isEmpty ( row ) ) {
					dnTkGftInAmt  = pu.parseFloat( row[ "TK_GFT_IN_AMT"  ] ) /** .asDouble() * */;
					dnTkGftOutAmt = pu.parseFloat( row[ "TK_GFT_OUT_AMT" ] ) /** .asDouble() * */;
				}

				row = this.db_get_single_row (_sql.GetRegiTotalData_true_SQL_02(  this.m_stSaleInfo ) , []);
				if ( !pu.isEmpty ( row ) ) {
					dnRetBillCashAmt  = pu.parseFloat( row[ "RET_CASH_AMT"  ] ) /** .asDouble() * */;
					dnRetBillCardAmt  = pu.parseFloat( row[ "RET_CARD_AMT"  ] ) /** .asDouble() * */;
				}

				let rows = this.db_get_mumti_rows (_sql.GetRegiTotalData_true_SQL_03(  this.m_stSaleInfo ) , []);
				if ( !pu.isEmpty ( rows ) ) {
					for ( let i = 0 ; i < rows.length ; i++  ) {
						let row = rows[i];
						let csSaleYn = row[ "SALE_YN"  ]; 

						if( csSaleYn == "N" ) {
							dnRetCashICAmt  = pu.parseFloat( row[ "CASHIC_AMT"  ]  )/** .asDouble() * */;
						} else {
							dnCashICAmt     = pu.parseFloat( row[ "CASHIC_AMT"  ]  )  /** .asDouble() * */;
						}
					}
				}

				dnCashICAmt -= dnRetCashICAmt;
				sql = _sql.GetRegiTotalData_true_SQL_04( this.m_stSaleInfo ) ;

			}  else  { // this.m_SaleClose == false

				row = this.db_get_single_row (_sql.GetRegiTotalData_false_SQL_01(  this.m_stSaleInfo ) , []);
				if ( !pu.isEmpty ( row ) ) {
					dnTkGftInAmt  = pu.parseFloat( row[ "TK_GFT_IN_AMT"  ] )/** .asDouble() * */;
					dnTkGftOutAmt = pu.parseFloat( row[ "TK_GFT_OUT_AMT" ] )/** .asDouble() * */;
				}


				// //////////////////////////////////////////////////////////////////////////////////////////
				// 2014-1124-Jane : 현금IC 추가.
				// /////////////////////////////////////////////////////////////////////////////////////////
				let rows = this.db_get_single_row (_sql.GetRegiTotalData_false_SQL_02(  this.m_stSaleInfo ) , []);
				if ( !pu.isEmpty ( rows ) ) {
					for ( let i = 0 ; i < rows.length ; i++  ) {
						let row = rows[i];
						let csSaleYn = row[ "SALE_YN"  ];
						if( csSaleYn == "N" ) {
							dnRetCashICAmt  = pu.parseFloat(row[ "CASHIC_AMT"  ]) /** .asDouble() * */;
						} else {
							dnCashICAmt     = pu.parseFloat(row[ "CASHIC_AMT"  ]) /** .asDouble() * */;
						}
					}
				}
				dnCashICAmt -= dnRetCashICAmt;

				// //////////////////////////////////////////////////////////////////////////////////////////
				// 2014-1124-Jane : 반품액 구분 추가. (현금 & 카드)
				// //////////////////////////////////////////////////////////////////////////////////////////
				row = this.db_get_single_row (_sql.GetRegiTotalData_false_SQL_03(  this.m_stSaleInfo ) , []);
				if ( !pu.isEmpty ( row ) ) {
					dnRetBillCashAmt  = pu.parseFloat( row[ "RET_CASH_AMT"  ] ) /** .asDouble() * */;
					dnRetBillCardAmt  = pu.parseFloat( row[ "RET_CARD_AMT"  ] ) /** .asDouble() * */;
				}


				sql = _sql.GetRegiTotalData_false_SQL_04(  this.m_stSaleInfo ) ;

			}// end if( this.m_SaleClose )


			let rows = this.db_get_mumti_rows (sql ,[] );
			if ( pu.isEmpty ( rows ) ) {
				rows = [];
			}

			let a = 0 , b = 0 , line = "";
			if( this.g_inPaperTypeFg == 0 ) {
				a = 14, b = 18;
				line = "--------------------------------";
				csTemp = "       ** 매출 합계 **\r\n" ;
			} else {
				a = 20, b = 22;
				line = "------------------------------------------";
				csTemp = "            ** 매출 합계 **\r\n" ;

			}

			for ( let i = 0 ; i < rows.length ; i++ ) {
				let row = rows[i];
				csTemp = "       ** 매출 합계 **\r\n" ;
				csTemp += pu.GetMarkString( "총판매액",   pu.parseFloat(row[ "TOT_AMT"         ] ) , a, b ) + "\r\n";
				csTemp += pu.GetMarkString( "총반품액",   pu.parseFloat(row[ "RET_BILL_AMT"    ] ) , a, b ) + "\r\n";
				csTemp += pu.GetMarkString( "총매출액",   pu.parseFloat(row[ "TOT_SALE_AMT"    ] ) , a, b ) + "\r\n";
				csTemp += pu.GetMarkString( "총할인액",   pu.parseFloat(row[ "TOT_DC_AMT"      ] ) , a, b ) + "\r\n";
				csTemp += pu.GetMarkString( "실매출액",   pu.parseFloat(row[ "DCM_SALE_AMT"    ] ) , a, b ) + "\r\n";
				csTemp += "\r\n";
				csTemp += pu.GetMarkString( "면세매출액", pu.parseFloat(row[ "NO_VAT_SALE_AMT" ] ) , a, b ) + "\r\n";
				csTemp += pu.GetMarkString( "과세매출액", pu.parseFloat(row[ "VAT_SALE_AMT"    ] ) , a, b ) + "\r\n";
				csTemp += pu.GetMarkString( "부가세액",   pu.parseFloat(row[ "VAT_AMT"         ] ) , a, b ) + "\r\n";
				if( pu.parseInt( this.GetEnvXmlShopENV( 126 ) ) == "1" ) {
					csTemp += pu.GetMarkString( "봉사료액", pu.parseFloat(row[ "SVC_TIP_AMT" ] ) , a, b ) + "\r\n";
				}

				if( pu.parseFloat( row[ "TOT_ETC_AMT" ] ) /** .asDouble() * */ > 0 ) {
					csTemp += pu.GetMarkString( "에누리액", pu.parseFloat( row[ "TOT_ETC_AMT" ] ), a, b ) + "\r\n";
				}

				csTemp += "\r\n";
				csTemp += pu.GetMarkString( "현금반품"  , dnRetBillCashAmt                              , a, b ) + "\r\n";		// 2014-1124-Jane
																															// :
																															// 현금반품액
																															// 추가.
				csTemp += pu.GetMarkString( "신용반품"  , ( dnRetBillCardAmt - dnRetCashICAmt)		  , a, b ) + "\r\n";	    // 2014-1124-Jane
																															// :
																															// 카드반품액
																															// 추가.
				csTemp += pu.GetMarkString( "현금IC반품", dnRetCashICAmt								  , a, b ) + "\r\n";		// 2014-1124-Jane
																																// :
																																// 현금IC반품액
																																// 추가.
				csTemp += "\r\n";
				csTemp += pu.GetMarkString( "매출합계" , pu.parseFloat( row[ "NO_VAT_SALE_AMT" ] ) /** .asDouble() * */
														 + pu.parseFloat( row[ "VAT_SALE_AMT"    ] ) /** .asDouble() * */
														 + pu.parseFloat( row[ "VAT_AMT"         ] ) /** .asDouble() * */
														 + pu.parseFloat( row[ "SVC_TIP_AMT"     ] ) /** .asDouble() * */
														 /*- row[ "TOT_ETC_AMT"     ].asDouble() */, a, b ) + "\r\n";		// 2019-05-02-SHK
																															// [에누리]
				csTemp += line ;


				this.m_stSaleInfo.csSaleSumData = csTemp;

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp = "   ** 결제수단별 매출내역 **\r\n" ;
					csTemp += pu.GetMarkString( "일반현금",  pu.parseFloat( row[ "CASH_AMT"      ]  ) /** .asDouble() * */
															 - pu.parseFloat( row[ "CASH_BILL_AMT" ]  ) /** .asDouble() * */, 14, 18 ) + "\r\n";
					csTemp += pu.GetMarkString( "현금영수증", pu.parseFloat(row[ "CASH_BILL_AMT" ])/** .asDouble() * */, 14, 18 ) + "\r\n";
					// 2014-1124-Jane : 신용카드, 현금IC 분리
					csTemp += pu.GetMarkString( "신용카드",   pu.parseFloat( row[ "CRD_CARD_AMT"  ])/** .asDouble() * */ - dnCashICAmt, 14, 18 ) + "\r\n";
					csTemp += pu.GetMarkString( "현금IC카드", dnCashICAmt, 14, 18 ) + "\r\n";
					if( pu.parseInt ( this.GetEnvXmlShopENV( 553 ) ) == 0 ) {
						csTemp += pu.GetMarkString( "외    상", row[ "WES_AMT" ]/** .asDouble() * */, 14, 18 ) + "\r\n";
					}
					else {
						let dnNormalWes   = 0;		 /** double * */
						let dnPackageWes  = 0;		 /** double * */
						let dnCustomerWes = 0;		 /** double * */

						// GetTravelWes( &dnNormalWes, &dnPackageWes,
						// &dnCustomerWes );
						let xx1 = this.GetTravelWes( );
						if (pu.isEmpty ( xx1 )) {
							dnCustomerWes = xx1.pdnCustomerWes;
							dnNormalWes   = xx1.pdnNormalWes;
							dnPackageWes  = xx1.pdnPackageWes;
						}


						csTemp += pu.GetMarkString( "일반외상",   dnNormalWes,   14, 18 ) + "\r\n";
						csTemp += pu.GetMarkString( "패키지외상", dnPackageWes,  14, 18 ) + "\r\n";
						csTemp += pu.GetMarkString( "회원외상",   dnCustomerWes, 14, 18 ) + "\r\n";
					}
					csTemp += pu.GetMarkString( "상 품 권",   pu.parseFloat(row[ "TK_GFT_AMT"      ])/** .asDouble() * */, 14, 18 ) + "\r\n";
					csTemp += pu.GetMarkString( "포 인 트",   pu.parseFloat(row[ "JCD_CARD_AMT"    ])/** .asDouble() * */, 14, 18 ) + "\r\n";
					csValue = SHOP_INFO.POINT_FG == "M" ? "회원마일리지" : "회원스탬프금액";	// 2013-0911-JJM
																				// :
																				// 회원스탬프->회원스탬프금액.
					csTemp += pu.GetMarkString( csValue,          row[ "CST_POINT_AMT"   ]/** .asDouble() * */, 14, 18 ) + "\r\n";
					csTemp += pu.GetMarkString( "식    권",   pu.parseFloat(row[ "TK_FOD_AMT"      ])/** .asDouble() * */, 14, 18 ) + "\r\n";
					csTemp += pu.GetMarkString( "기    타",   pu.parseFloat(row[ "ETC_APPR_AMT"    ])/** .asDouble() * */, 14, 18 ) + "\r\n";        // 2017-0628
																																					// Antony.Choi
																																					// :
																																					// [커반]기타결제
																																					// 금액
																																					// 추가

					csTemp += "\r\n";
					csTemp += pu.GetMarkString( "현금소계",  pu.parseFloat(row[ "CASH_AMT"        ])/** .asDouble() * */, 14, 18 ) + "\r\n";		// 2014-1124-Jane
																																			// :
																																			// 현금소계
																																			// 추가.
					csTemp += pu.GetMarkString( "결제합계",  pu.parseFloat( row[ "NO_VAT_SALE_AMT" ]  ) /** .asDouble() * */
					                                         + pu.parseFloat( row[ "VAT_SALE_AMT"    ]  ) /** .asDouble() * */
											    			 + pu.parseFloat( row[ "VAT_AMT"         ]  ) /** .asDouble() * */
												    		 + pu.parseFloat( row[ "SVC_TIP_AMT"     ]  ) /** .asDouble() * */
													    	 /*- row[ "TOT_ETC_AMT"     ].asDouble() */, 14, 18 ) + "\r\n";		// 2019-05-02-SHK
																																// [에누리]
					csTemp += "--------------------------------";

				} else {
					csTemp = "        ** 결제수단별 매출내역 **\r\n" ;
					csTemp += pu.GetMarkString( "일반현금",  pu.parseFloat(row[ "CASH_AMT"      ]  ) /** .asDouble() * */
															 - pu.parseFloat(row[ "CASH_BILL_AMT" ]  ) /** .asDouble() * */, 20, 22 ) + "\r\n";
					csTemp += pu.GetMarkString( "현금영수증", pu.parseFloat( row[ "CASH_BILL_AMT" ] )/** .asDouble() * */, 20, 22 ) + "\r\n";
					// 2014-1124-Jane : 신용카드, 현금IC 분리
					csTemp += pu.GetMarkString( "신용카드",     pu.parseFloat( row[ "CRD_CARD_AMT"   ] )/** .asDouble() * */- dnCashICAmt, 20, 22 ) + "\r\n";
					csTemp += pu.GetMarkString( "현금IC카드",   dnCashICAmt, 20, 22 ) + "\r\n";
					if( /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 553 ) ) == 0 ) {
						csTemp += pu.GetMarkString( "외    상", row[ "WES_AMT" ]/** .asDouble() * */, 20, 22 ) + "\r\n";
					}
					else {
						let dnNormalWes   = 0;
						let dnPackageWes  = 0;
						let dnCustomerWes = 0;

						// GetTravelWes( &dnNormalWes, &dnPackageWes,
						// &dnCustomerWes );
						let xx1 = this.GetTravelWes( );
						if (pu.isEmpty ( xx1 )) {
							dnCustomerWes = xx1.pdnCustomerWes;
							dnNormalWes   = xx1.pdnNormalWes;
							dnPackageWes  = xx1.pdnPackageWes;
						}

						csTemp += pu.GetMarkString( "일반외상",   dnNormalWes,   20, 22 ) + "\r\n";
						csTemp += pu.GetMarkString( "패키지외상", dnPackageWes,  20, 22 ) + "\r\n";
						csTemp += pu.GetMarkString( "회원외상",   dnCustomerWes, 20, 22 ) + "\r\n";
					}
					csTemp += pu.GetMarkString( "상 품 권",   row[ "TK_GFT_AMT"      ]/** .asDouble() * */, 20, 22 ) + "\r\n";
					csTemp += pu.GetMarkString( "포 인 트",   row[ "JCD_CARD_AMT"    ]/** .asDouble() * */, 20, 22 ) + "\r\n";
					csValue = SHOP_INFO.POINT_FG == "M" ? "회원마일리지" : "회원스탬프금액";	// 2013-0911-JJM
																				// :
																				// 회원스탬프->회원스탬프금액.
					csTemp += pu.GetMarkString( csValue,          row[ "CST_POINT_AMT"   ]/** .asDouble() * */, 20, 22 ) + "\r\n";
					csTemp += pu.GetMarkString( "식    권",   row[ "TK_FOD_AMT"      ]/** .asDouble() * */, 20, 22 ) + "\r\n";
					csTemp += pu.GetMarkString( "기    타",   row[ "ETC_APPR_AMT"    ]/** .asDouble() * */, 20, 22 ) + "\r\n";        // 2017-0628
																																	// Antony.Choi
																																	// :
																																	// [커반]기타결제
																																	// 금액
																																	// 추가
// csTemp += pu.GetMarkString( "사원카드", row[ "RFC_AMT" ]/** .asDouble() **/, 20,
// 22 ) + "\r\n"; // 2013-0809-Jane : 불필요 출력항목 삭제
					csTemp += "\r\n";
					csTemp += pu.GetMarkString( "현금소계",   row[ "CASH_AMT"        ]/** .asDouble() * */, 20, 22 ) + "\r\n";		// 2014-1124-Jane
																																// :
																																// 현금소계
																																// 추가.
					csTemp += pu.GetMarkString( "결제합계",  pu.parseFloat( row[ "NO_VAT_SALE_AMT" ]  ) /** .asDouble() * */
					                                         + pu.parseFloat( row[ "VAT_SALE_AMT"    ]  ) /** .asDouble() * */
											    			 + pu.parseFloat( row[ "VAT_AMT"         ]  ) /** .asDouble() * */
												    		 + pu.parseFloat( row[ "SVC_TIP_AMT"     ]  ) /** .asDouble() * */
													    	 , 20, 22 ) + "\r\n";		// 2019-05-02-SHK
																						// [에누리]
					csTemp += "------------------------------------------";
				}

				this.m_stSaleInfo.csTypeData	= csTemp;	// 결제수단별매출내역

				if( pu.parseFloat( row[ "TOT_DC_AMT" ] ) /** .asLong() * */ == 0 ) {
					csTemp = "";

				} else {
						csTemp   ="      ** 할인 매출내역 **\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n\r\n%s".sprintf(						// 2013-0822-Jane // 불필요 출력항목 삭제
							           pu.GetMarkString( "일반할인",     row[ "DC_GEN_AMT" ], a, b )
									 , pu.GetMarkString( "서 비 스",     row[ "DC_SVC_AMT" ], a, b )
									 , pu.GetMarkString( "제휴할인",     row[ "DC_JCD_AMT" ], a, b )
									 , pu.GetMarkString( "쿠폰할인",     row[ "DC_CPN_AMT" ], a, b )
									 , pu.GetMarkString( "회원할인",     row[ "DC_CST_AMT" ], a, b )
									 , pu.GetMarkString( "식권할인",     row[ "DC_TFD_AMT" ], a, b )
									 , pu.GetMarkString( "신용카드할인", row[ "DC_CRD_AMT" ], a, b )
									 , pu.GetMarkString( "할인합계",     row[ "TOT_DC_AMT" ], a, b ) );
						csTemp += "\r\n" + line ;

				}

				this.m_stSaleInfo.DC_DATA = csTemp;	// 할인매출액

				if( row[ "REM_CASH_AMT" ] == 0 )	{
					csTemp = "";
				} else {

					let a1 = 0; b1 = 0 , c1 = 0 , stitle = "";
					if( this.g_inPaperTypeFg == 0 ) {
						stitle = "     ** 현금시재 입력내역 **\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n\r\n%s\r\n%s";
						a1 = 14, b1 = 5, c1 = 13;
					} else {
						stitle ="          ** 현금시재 입력내역 **\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n\r\n%s\r\n%s";
						a1 = 20 , b1 = 5, c1 = 17;

					}

					csTemp  =  stitle.sprintf(
						           pu.GetMarkString_02( "기타금액",	row[ "REM_CHECK_AMT"   ], 14, 18 )
								 , pu.GetMarkString( "  10만원권", row[ "REM_W100000_CNT" ],	row[ "REM_W100000_AMT" ], a1, b1, c1 )
								 , pu.GetMarkString( "   5만원권", row[ "REM_W50000_CNT"  ],	row[ "REM_W50000_AMT"  ], a1, b1, c1 )
								 , pu.GetMarkString( "10,000원권", row[ "REM_W10000_CNT"  ],	row[ "REM_W10000_AMT"  ], a1, b1, c1 )
								 , pu.GetMarkString( " 5,000원권", row[ "REM_W5000_CNT"   ],	row[ "REM_W5000_AMT"   ], a1, b1, c1 )
								 , pu.GetMarkString( " 1,000원권", row[ "REM_W1000_CNT"   ],	row[ "REM_W1000_AMT"   ], a1, b1, c1 )
								 , pu.GetMarkString( "   500원",   row[ "REM_W500_CNT"    ],	row[ "REM_W500_AMT"    ], a1, b1, c1 )
								 , pu.GetMarkString( "   100원",   row[ "REM_W100_CNT"    ],	row[ "REM_W100_AMT"    ], a1, b1, c1 )
								 , pu.GetMarkString( "    50원",   row[ "REM_W50_CNT"     ],	row[ "REM_W50_AMT"     ], a1, b1, c1 )
								 , pu.GetMarkString( "    10원",   row[ "REM_W10_CNT"     ],	row[ "REM_W10_AMT"     ], a1, b1, c1 )
								 , pu.GetMarkString( "마감시재액", row[ "REM_CASH_AMT"    ], a, b )
								 , pu.GetMarkString( "현금과부족", row[ "LOSS_CASH_AMT"   ], a, b ) );
						csTemp += "\r\n" + line ;
				}

				this.m_stSaleInfo.CASH_DATA	= csTemp;	// 현금시재입력내역

				// /////////////////////////////////////////////////////////////////////////////
				// 모든 항목 합계 금액이 0 이면 출력변수를 클리어한다.
				// /////////////////////////////////////////////////////////////////////////////
				if( row[ "POS_READY_AMT"       ]/** .asLong() * */ == 0
				&&  row[ "CASH_AMT"            ]/** .asLong() * */ == 0
				&&	row[ "WEA_IN_CSH_AMT"      ]/** .asLong() * */ == 0
				&&  row[ "TK_GFT_SALE_CSH_AMT" ]/** .asLong() * */ == 0
				&&  row[ "TK_FOD_SALE_CSH_AMT" ]/** .asLong() * */ == 0
				&&  row[ "POS_CSH_IN_AMT"      ]/** .asLong() * */ == 0
				&&  row[ "POS_CSH_OUT_AMT"     ]/** .asLong() * */ == 0
				&&  row[ "REPAY_TK_GFT_AMT"    ]/** .asLong() * */ == 0
				&&  row[ "TOT_CASH_AMT"        ]/** .asLong() * */ == 0 ) {
					csTemp = "";
				}
				else {

						csTemp  = "       ** 현금 정산액 **\r\n";
						csTemp += pu.GetMarkString( "준 비 금",       pu.parseInt(row[ "POS_READY_AMT"       ]), a, b ) + "\r\n";
						csTemp += pu.GetMarkString( "현금매출액",     pu.parseInt(row[ "CASH_AMT"            ]), a, b ) + "\r\n";
						csTemp += pu.GetMarkString( "외상현금입금",   pu.parseInt(row[ "WEA_IN_CSH_AMT"      ]), a, b ) + "\r\n";
						csTemp += pu.GetMarkString( "상품권현금판매", pu.parseInt(row[ "TK_GFT_SALE_CSH_AMT" ]), a, b ) + "\r\n";
						csTemp += pu.GetMarkString( "식권현금판매",   pu.parseInt(row[ "TK_FOD_SALE_CSH_AMT" ]), a, b ) + "\r\n";
						csTemp += pu.GetMarkString( "시재입금액",     pu.parseInt(row[ "POS_CSH_IN_AMT"      ]), a, b ) + "\r\n";
						csTemp += pu.GetMarkString( "시재출금액",     pu.parseInt(row[ "POS_CSH_OUT_AMT"     ]), a, b ) + "\r\n";
						// 2013-1210 Antony Choi : 현금 시재액이 0원으로 나오는 증상 수정
						dnAccountCashSum = pu.parseInt ( row[ "TOT_CASH_AMT" ] ) /** .asDouble() * */;

						if( /** atoi * */ pu.parseInt( this.GetEnvXmlShopENV( 550 ) ) != 0 ) {
							dnAgentFeeAmt = pu.parseFloat ( this.GetAgentFeeAmt() ) ;

							csTemp += pu.GetMarkString( "수수료출금액", dnAgentFeeAmt, a, b ) + "\r\n";
							dnAccountCashSum -= dnAgentFeeAmt;
						}
						csTemp += pu.GetMarkString( "현금환불액", row[ "REPAY_CASH_AMT" ] , a, b ) + "\r\n\r\n";
						csTemp += pu.GetMarkString( "현금시재액", dnAccountCashSum        , a, b );
						csTemp += "\r\n" + line ;
				}
				this.m_stSaleInfo.csCashRegiData = csTemp;	// 현금정산액

				csTemp = "";

				// /////////////////////////////////////////////////////////////////////////////
				// 모든 항목 합계 금액이 0 이면 출력변수를 클리어한다.
				// /////////////////////////////////////////////////////////////////////////////
				if( dnTkGftInAmt != 0
				||  dnTkGftOutAmt != 0 ) {
					dnTkGftRemAmt = row[ "REM_TK_GFT_AMT" ]/** .asDouble() * */;

					if( this.g_inPaperTypeFg == 0 ) {
						csTemp/** .Format * */ = ( "     ** 상품권시재 내역 **\r\n%s\r\n%s\r\n%s\r\n%s\r\n"
							         , pu.GetMarkString( "상품권회수",   dnTkGftInAmt,                                 14, 18 )
							         , pu.GetMarkString( "상품권환불",   dnTkGftOutAmt,                                14, 18 )
							         , pu.GetMarkString( "상품권시재",   dnTkGftRemAmt,                                14, 18 )
							         , pu.GetMarkString( "상품권과부족", dnTkGftInAmt - dnTkGftOutAmt - dnTkGftRemAmt, 14, 18 ) );
						csTemp += "--------------------------------";			}
					else {
						csTemp/** .Format * */ = ( "          ** 상품권시재 내역 **\r\n%s\r\n%s\r\n%s\r\n%s\r\n"
							         , pu.GetMarkString( "상품권회수",   dnTkGftInAmt,                                 20, 22 )
							         , pu.GetMarkString( "상품권환불",   dnTkGftOutAmt,                                20, 22 )
							         , pu.GetMarkString( "상품권시재",   dnTkGftRemAmt,                                20, 22 )
							         , pu.GetMarkString( "상품권과부족", dnTkGftInAmt - dnTkGftOutAmt - dnTkGftRemAmt, 20, 22 ) );
						csTemp += "------------------------------------------";
					}
				}
				this.m_stSaleInfo.GIFT_DATA	= csTemp;	// 상품권시재내역

				bCnt++;

			}

		} catch (e) {
			util.logError("GetRegiTotalData == >> e" + e);
			return false;
		}
		if( bCnt > 0 ) {
			// //////////////////////////////////////////////////////////////////////
			// 2010-0319-JJM. 배달사용시 매장/배달 판매현황 출력.
			// //////////////////////////////////////////////////////////////////////
			if( pu.parseInt(this.GetEnvXmlShopENV( 111 )) != "0" )	{	// 2013-0816-Jane
																		// :
																		// 배달관리사용구분이
																		// '미사용'일때만
																		// 매장/배달
																		// 매출내역
																		// 출력
																		// 안되도록
																		// 수정.
				this.m_stSaleInfo.csDeliveryData = this.GetDeliveryData();
			}
			return true;
		}
	}

	this.GetDeliveryData = function () {
		let s = _sql.GetDeliveryData_SQL ( this.m_stSaleInfo , this.m_SaleClose) ;
		let csShopAmt = "";
		let csDeliveryAmt = "";
		let csTemp = "";
		try {
			let rows = this.db_get_mumti_rows(s , []);
			for ( let i = 0 ; i < rows.length ; i++ ) {
				let row = rows[i];
				csShopAmt  = 0
					+ pu.parseInt ( row[ "SHOP_NO_VAT_SALE_AMT" ])/** .asLong() * */
	                + pu.parseInt ( row[ "SHOP_VAT_SALE_AMT"    ])/** .asLong() * */
	                + pu.parseInt ( row[ "SHOP_VAT_AMT"         ])/** .asLong() * */
	                + pu.parseInt ( row[ "SHOP_SVC_TIP_AMT"     ])/** .asLong() * */
                 ;		// 2019-05-02-SHK [에누리]

				csDeliveryAmt = 0
					+ pu.parseInt (row[ "DLV_NO_VAT_SALE_AMT" ])/** .asLong() * */
				    + pu.parseInt (row[ "DLV_VAT_SALE_AMT"    ])/** .asLong() * */
				    + pu.parseInt (row[ "DLV_VAT_AMT"         ])/** .asLong() * */
				    + pu.parseInt (row[ "DLV_SVC_TIP_AMT"     ])/** .asLong() * */
				;	// 2019-05-02-SHK [에누리]

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp += "    ** 매장/배달 매출내역 **\r\n";
					csTemp += pu.GetMarkString( "매장매출", pu.parseInt( row[ "SHOP_SALE_CNT" ]), csShopAmt,     14, 5, 13 ) + "\r\n";
					csTemp += pu.GetMarkString( "배달매출", pu.parseInt( row[ "DLV_SALE_CNT"  ]), csDeliveryAmt, 14, 5, 13 ) + "\r\n";
					csTemp += "--------------------------------";
				}
				else {
					csTemp += "         ** 매장/배달 매출내역 **\r\n";
					csTemp += pu.GetMarkString( "매장매출", pu.parseInt( row[ "SHOP_SALE_CNT" ]), csShopAmt,     20, 5, 17 ) + "\r\n";
					csTemp += pu.GetMarkString( "배달매출", pu.parseInt( row[ "DLV_SALE_CNT"  ]), csDeliveryAmt, 20, 5, 17 ) + "\r\n";
					csTemp += "------------------------------------------";
				}
			}

		} catch (e) {
			util.logInfo(e);
			return "";
		}
	}
	this.GetRegiCardData = function() {
		let csTemp = "";
		let csValue = "";
		let s  = _sql.GetRegiCardData_SQL (this.m_stSaleInfo , this.m_SaleClose ) ;
		let rows = this.db_get_mumti_rows(s , []);
		for ( let i = 0 ; i < rows.length ; i++ ) {
			let row = rows[i];
			// /////////////////////////////////////////////////////////////////////////////
			// 모든 항목 합계 금액이 0 이면 출력변수를 클리어한다.
			// /////////////////////////////////////////////////////////////////////////////
			if(	pu.parseInt (row[ "CNT1"    ]) /** .asLong() * */ == 0
			&&	pu.parseInt (row[ "AMT1"    ]) /** .asLong() * */ == 0
			&&	pu.parseInt (row[ "CNT2"    ]) /** .asLong() * */ == 0
			&&	pu.parseInt (row[ "AMT2"    ]) /** .asLong() * */ == 0
			&&  pu.parseInt (row[ "TOT_CNT" ]) /** .asLong() * */ == 0
			&&  pu.parseInt (row[ "TOT_AMT" ]) /** .asLong() * */ == 0 ) {
				csTemp = "";
			}
			else {
				if( this.g_inPaperTypeFg == 0 ) {
					csTemp  =  "** 신용+현금IC 정산 내역 **\r\n%s\r\n%s\r\n\r\n%s\r\n".sprintf(		// 2014-1124-Jane
																							// :
																							// 현금IC
																							// 추가.
					               pu.GetMarkString( "카드승인", row[ "CNT1"    ], row[ "AMT1"    ], 14, 5, 13 )
					             , pu.GetMarkString( "카드취소", row[ "CNT2"    ], row[ "AMT2"    ], 14, 5, 13 )
					             , pu.GetMarkString( "카드매출", row[ "TOT_CNT" ], row[ "TOT_AMT" ], 14, 5, 13 ) );
					csTemp += "--------------------------------";
				}
				else {
					csTemp =  "     ** 신용+현금IC 정산 내역 **\r\n%s\r\n%s\r\n\r\n%s\r\n".sprintf(	// 2014-1124-Jane
																							// :
																							// 현금IC
																							// 추가.
					               pu.GetMarkString( "카드승인", row[ "CNT1"    ], row[ "AMT1"    ], 20, 5, 17 )
					             , pu.GetMarkString( "카드취소", row[ "CNT2"    ], row[ "AMT2"    ], 20, 5, 17 )
					             , pu.GetMarkString( "카드매출", row[ "TOT_CNT" ], row[ "TOT_AMT" ], 20, 5, 17 ) );
					csTemp += "------------------------------------------";
				}
			}

		}
		return csTemp;
	}
	this.GetTravelWes = function () {
		let s = "";
		let csTemp  = "";	   
		let pdnCustomerWes = 0; /** double * */
		let pdnNormalWes   = 0; /** double * */
		let pdnPackageWes  = 0; /** double * */

		if( this.m_csPrintCode == "08" ||  this.m_csPrintCode == "09" ) {
			s = _sql.GetTravelWes_SQL(this.m_stSaleInfo , this.m_csPrintCode);
		} else {
			s = _sql.GetTravelWes_SQL(this.m_stSaleInfo , this.m_csPrintCode);
		}
		try {
			let rows = this.db_get_mumti_rows(s , []);
			for ( let i = 0 ; i < rows.length ; i++ ) {
				if( row[ "WES_FG" ] == "0" ) {
					pdnCustomerWes = pu.parseFloat(row[ "WES_AMT" ] )/** .asDouble() * */;
				}

				if( row[ "WES_FG" ] == "1" ) {
					pdnNormalWes   = pu.parseFloat(row[ "WES_AMT" ])/** .asDouble() * */;
				}

				if( row[ "WES_FG" ] == "2" ) {
					pdnPackageWes  = pu.parseFloat(row[ "WES_AMT" ])/** .asDouble() * */;
				}
			}
			return {
				  pdnCustomerWes : pdnCustomerWes
				, pdnNormalWes   : pdnNormalWes
				, pdnPackageWes  : pdnPackageWes
			}
		} catch (e) {
			return null;
		}
	}


	this.GetAgentFeeAmt = function() {
		let s = "";
		let dnPayOutAmt =0;
		if( this.m_csPrintCode == "08" ||  this.m_csPrintCode == "09" ) {
			s = _sql.GetAgentFeeAmt_SQL(this.m_stSaleInfo , this.m_csPrintCode);
		} else {
			s = _sql.GetAgentFeeAmt_SQL(this.m_stSaleInfo , this.m_csPrintCode);
		}
		try {
			let row = this.db_get_single_row(s);
			dnPayOutAmt = pu.parseInt( row[ "PAY_OUT_AMT" ] ) ;
		} catch (e) {
			util.logError("GetAgentFeeAmt e ==> " + e);
		}
		return dnPayOutAmt;
	}
	/***************************************************************************
	 * SQL Multi Row 가져오기
	 **************************************************************************/
	this.db_get_mumti_rows = function (_sql , params ) {
		util.logDebug("*** db_get_mumti_rows START *** _sql == > " + _sql+"  ,  param = > "+params);
		let db_result = gfn_SQLiteSQLProcess(_sql  ,params  );

		if ( pu.isEmpty(db_result )   || pu.isEmpty(db_result.ResultCode) || db_result.ResultCode != "0"   ) {
			throw "SQL Error " + _sql
			+ "\n params :  " + JSON.stringify( params )
			+ "\n result :  " + db_result  ;
		}
		let rows = db_result.Data;
		if ( pu.isEmpty(  rows ) ) {
			rows = []
		}
		return rows ;
	}

	/***************************************************************************
	 * SQL Single Row 가져오기
	 **************************************************************************/
	this.db_get_single_row = function (_sql , params ) {
		let rows = this.db_get_mumti_rows(_sql , params ) ;
		if ( pu.isEmpty ( rows )) {
			return null;
		} else {
			return rows[0];
		}
	}

	// 2019-08-13-SHK [손님수]
	this.GetGstData = function () {

		let sql = _sql.GetGstData_SQL(  this.m_stSaleInfo  );
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}

		let row = db_result.Data[0];
		let inCustCnt = row["FD_GST_CNT"];
		return  "%02d 명".sprintf( inCustCnt );
	}

	this.GetSalesOrderEmpName = function () {  /** 주문자 조회 * */
		let sql = _sql.GetSalesOrderEmpName_SQL(  this.m_stSaleInfo  );
		let db_result = gfn_SQLiteSQLProcess(sql  , [] );

		if ( pu.isEmpty(db_result )  || pu.isEmpty( db_result.Data) || db_result.Data.length == 0 ) {
			return false;
		}

		let rows = db_result.Data;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];
			this.m_stSaleInfo.EMP_NM = row[ "ORDER_EMP_NM" ];

		}
		let csOrderEmpName = pu.RPad( pu.DllGetCutHangul( this.m_stSaleInfo.EMP_NM, 8 ), 8 );
		return csOrderEmpName;
	}

	this.GetReissueAccountData = function ( pcsCode) {  /** {현금정산액} * */
		util.logInfo("*** GetReissueAccountData START ***");
		let csPrint      = "";
		let csQuery      = "";
		let csTemp       = "";
		let csTemp2	     = "";
		let csTemp3	     = "";
		let csEnvShop128 = pu.parseInt( this.GetEnvXmlShopENV( 128 ) );

		let	dnSaleAmt        = 0;
		let	dnNoTaxSaleAmt   = 0;		// 2010-0705-JJM : 에누리추가.
		let dnAccountCashSum = 0;		// 2011-0105-JJM : .
		let dnAgentFeeAmt    = 0;		// 2011-0105-JJM : .
		let dnRetBillCashAmt = 0;		// 2014-1124-Jane :.
		let dnRetBillCardAmt = 0;		// 2014-1124-Jane :.
		let dnCashICAmt		 = 0;		// 2014-1124-Jane :.
		let dnRetCashICAmt   = 0;		// 2014-1124-Jane :.
		let sql              = "";
		let rows             = [];


		try {
			if( pcsCode == "{매출합계}" ) {
				rows = this.db_get_mumti_rows ( _sql.GetReissueAccountData_01_SQL( pcsCode,  this.m_stSaleInfo  ) , [] );
				for ( let itx = 0 ; itx < rows.length ; itx++ ) {
					let row = rows[itx];

					let csSaleYn = row[ "SALE_YN"  ]; 
					if( csSaleYn == "N" ) {
						dnRetCashICAmt  = pu.parseFloat( row[ "CRD_CASHIC_AMT"  ] )/** .asDouble() * */;

					} else {
						dnCashICAmt  = pu.parseFloat(row[ "CRD_CASHIC_AMT"  ] )  /** .asDouble() * */;

					}
				}

				dnCashICAmt -= dnRetCashICAmt;

				rows = this.db_get_mumti_rows ( _sql.GetReissueAccountData_02_SQL( pcsCode,  this.m_stSaleInfo  ) , [] );
				for ( let itx = 0 ; itx < rows.length ; itx++ ) {
					let row = rows[itx];
					dnRetBillCashAmt  = pu.parseFloat(row[ "RET_CASH_AMT"  ]) /** .asDouble() * */;
					dnRetBillCardAmt  = pu.parseFloat(row[ "RET_CARD_AMT"  ]) /** .asDouble() * */;
				}


				rows = this.db_get_mumti_rows ( _sql.GetReissueAccountData_03_SQL( pcsCode,  this.m_stSaleInfo  ) , [] );
				for ( let itx = 0 ; itx < rows.length ; itx++ ) {
					let row = rows[itx];

					let a = 0, b = 0 , lastLine = "";
					if( this.g_inPaperTypeFg == 0 ) {
						csPrint += "       ** 매출 합계 **\r\n";

						a = 18, b = 14;
						lastLine = "--------------------------------";
					} else {
						csPrint += "            ** 매출 합계 **\r\n";
						a = 20, b = 22;
						lastLine = "------------------------------------------";
					}

					csPrint += pu.GetMarkString( "총판매액"   ,   pu.parseFloat( row[ "TOT_AMT"         ] )/** .asDouble() * */, a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "총반품액"   ,   pu.parseFloat( row[ "CANCEL_TOT_AMT"  ] )/** .asDouble() * */, a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "총매출액"   ,   pu.parseFloat( row[ "TOT_SALE_AMT"    ] )/** .asDouble() * */, a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "총할인액"   ,   pu.parseFloat( row[ "TOT_DC_AMT"      ] )/** .asDouble() * */, a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "실매출액"   ,   pu.parseFloat( row[ "DCM_SALE_AMT"    ] )/** .asDouble() * */, a, b ) + "\r\n\r\n";
					csPrint += pu.GetMarkString( "면세매출액" ,   pu.parseFloat( row[ "NO_VAT_SALE_AMT" ] )/** .asDouble() * */, a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "과세매출액" ,   pu.parseFloat( row[ "VAT_SALE_AMT"    ] )/** .asDouble() * */, a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "부가세액"   ,	pu.parseFloat( row[ "VAT_AMT"         ] )/** .asDouble() * */, a, b ) + "\r\n";

					if( pu.parseInt(this.GetEnvXmlShopENV( 126 )) == "1" )	{
						csPrint += pu.GetMarkString( "봉사료액", pu.parseFloat(  row[ "SVC_TIP_AMT" ] ) /** .asDouble() * */, a, b ) + "\r\n";
					}

					if( pu.parseFloat(  row[ "TOT_ETC_AMT" ] ) /** .asDouble() * */ > 0 )	{
						csPrint += pu.GetMarkString( "에누리액", pu.parseFloat( row[ "TOT_ETC_AMT" ] )/** .asDouble() * */, a, b ) + "\r\n";
					}

					csPrint += "\r\n";
					csPrint += pu.GetMarkString( "현금반품"      , dnRetBillCashAmt                      , a, b ) + "\r\n";		// 2014-1124-Jane
																															// :
																															// 현금반품액
																															// 추가.
					csPrint += pu.GetMarkString( "신용카드반품"  , dnRetBillCardAmt-dnRetCashICAmt       , a, b ) + "\r\n";		// 2014-1124-Jane
																															// :
																															// 카드반품액
																															// 추가.
					csPrint += pu.GetMarkString( "현금IC반품"    , dnRetCashICAmt                        , a, b ) + "\r\n";		// 2014-1124-Jane
																															// :
																															// 현금IC카드반품액
																															// 추가.
					csPrint += "\r\n";
					csPrint += pu.GetMarkString( "매출합계", pu.parseFloat( row[ "NO_VAT_SALE_AMT" ] )/** .asDouble() * */
															 + pu.parseFloat( row[ "VAT_SALE_AMT"    ]) /** .asDouble() * */
															 + pu.parseFloat( row[ "VAT_AMT"         ]) /** .asDouble() * */
															 + pu.parseFloat( row[ "SVC_TIP_AMT"     ]) /** .asDouble() * */
															              , a , b ) + "\r\n";		// 2019-05-02-SHK
																									// [에누리]
					csPrint += lastLine;
				}

			} else if( pcsCode == "{결제수단별매출내역}" ) {

				rows = this.db_get_mumti_rows ( _sql.GetReissueAccountData_04_SQL( pcsCode,  this.m_stSaleInfo  ) , [] );
				for ( let itx = 0 ; itx < rows.length ; itx++ ) {
					let row = rows[itx];
					dnCashICAmt = pu.parseFloat( row[ "CRD_CASHIC_AMT" ]) /** .asDouble() * */;

				}

				rows = this.db_get_mumti_rows ( _sql.GetReissueAccountData_05_SQL( pcsCode,  this.m_stSaleInfo  ) , [] );
				for ( let itx = 0 ; itx < rows.length ; itx++ ) {
					let row = rows[itx];

					let a = 0, b = 0 , lastLine = "";
					if( this.g_inPaperTypeFg == 0 ) {
						csPrint += "   ** 결제수단별 매출내역 **\r\n";

						a = 18, b = 14;
						lastLine = "--------------------------------";
					} else {
						csPrint += "        ** 결제수단별 매출내역 **\r\n";
						a = 20, b = 22;
						lastLine = "------------------------------------------";
					}

					csTemp = pu.parseInt( row[ "CASH_AMT" ]  ) /** .asLong() * */  ;
					csPrint += pu.GetMarkString( "일반현금" ,  pu.parseFloat(row[ "CASH_AMT"      ] ) /** .asDouble() * */
															   - pu.parseFloat(row[ "CASH_BILL_AMT" ] ) /** .asDouble() * */, a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "현금영수증", pu.parseFloat(row[ "CASH_BILL_AMT" ] ) /** .asDouble() * */, a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "신용카드",   pu.parseFloat(row[ "CRD_CARD_AMT"  ] ) /** .asDouble() * */-dnCashICAmt, a, b ) + "\r\n";	// 2014-1124-Jane
																																					// :
																																					// 현금IC
																																					// 추가.
					csPrint += pu.GetMarkString( "현금IC",   dnCashICAmt, a, b ) + "\r\n";		// 2014-1124-Jane
																								// :
																								// 현금IC
																								// 추가.

					if( /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 553 ) ) == 0 ) {
						csPrint += pu.GetMarkString( "외    상", pu.parseFloat(row[ "WES_AMT" ]) /** .asDouble() * */, a, b ) + "\r\n";

					} else {
						let dnNormalWes   = 0; /** double * */
						let dnPackageWes  = 0; /** double * */
						let dnCustomerWes = 0; /** double * */

						let xx1 = this.GetTravelWes( );
						if (pu.isEmpty ( xx1 )) {
							dnCustomerWes = xx1.pdnCustomerWes;
							dnNormalWes   = xx1.pdnNormalWes;
							dnPackageWes  = xx1.pdnPackageWes;
						}

						csPrint += pu.GetMarkString( "일반외상",   dnNormalWes,   a, b ) + "\r\n";
						csPrint += pu.GetMarkString( "패키지외상", dnPackageWes,  a, b ) + "\r\n";
						csPrint += pu.GetMarkString( "회원외상",   dnCustomerWes, a, b ) + "\r\n";
					}

					csPrint += pu.GetMarkString( "상 품 권",	pu.parseFloat( row[ "TK_GFT_AMT"      ] ) /** .asDouble() * */, a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "포 인 트",	pu.parseFloat( row[ "JCD_CARD_AMT"    ] ) /** .asDouble() * */, a, b ) + "\r\n";
					csPrint += pu.GetMarkString( SHOP_INFO.POINT_FG   == "M" ? "회원마일리지" : "회원스탬프금액",	row[ "CST_POINT_AMT"   ]/** .asDouble() * */, a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "식    권",	pu.parseFloat( row[ "TK_FOD_AMT"      ] ) /** .asDouble() * */, a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "기    타",  pu.parseFloat( row[ "ETC_APPR_AMT"    ] ) /** .asDouble() * */, a, b ) + "\r\n\r\n";			// 2017-0628
																																						// Antony.Choi
																																						// :
																																						// [커반]기타결제
																																						// 금액
																																						// 추가
					csPrint += pu.GetMarkString( "현금소계",  pu.parseFloat( row[ "CASH_AMT"        ] ) /** .asDouble() * */, a, b ) + "\r\n";			// 2014-1124-Jane
																																					// :
																																					// 현금소계
																																					// 추가.
					csPrint += pu.GetMarkString( "결제합계",  pu.parseFloat( row[ "NO_VAT_SALE_AMT" ] ) /** .asDouble() * */
															  + pu.parseFloat( row[ "VAT_SALE_AMT"    ] ) /** .asDouble() * */
															  + pu.parseFloat( row[ "VAT_AMT"         ] ) /** .asDouble() * */
															  + pu.parseFloat( row[ "SVC_TIP_AMT"     ] ) /** .asDouble() * */
															  - pu.parseFloat( row[ "TOT_ETC_AMT"     ] ) /** .asDouble() * */, a, b ) + "\r\n";
					csPrint += lastLine;
				}

			} else if( pcsCode == "{할인매출내역}"  ) {
				rows = this.db_get_mumti_rows ( _sql.GetReissueAccountData_06_SQL( pcsCode,  this.m_stSaleInfo  ) , [] );
				for ( let itx = 0 ; itx < rows.length ; itx++ ) {
					let row = rows[itx];
					let a = 0, b = 0 , lastLine = "";
					if( this.g_inPaperTypeFg == 0 ) {
						csPrint += "      ** 할인 매출내역 **\r\n";

						a = 18, b = 14;
						lastLine = "--------------------------------";
					} else {
						csPrint += "           ** 할인 매출내역 **\r\n";
						a = 20, b = 22;
						lastLine = "------------------------------------------";
					}

					csPrint += pu.GetMarkString( "일반할인"    ,	  row[ "DC_GEN_AMT" ] , 20, 22 ) + "\r\n";
					csPrint += pu.GetMarkString( "서 비 스"    ,	  row[ "DC_SVC_AMT" ] , 20, 22 ) + "\r\n";
					csPrint += pu.GetMarkString( "제휴할인"    ,	  row[ "DC_PCD_AMT" ] , 20, 22 ) + "\r\n";
					csPrint += pu.GetMarkString( "쿠폰할인"    ,	  row[ "DC_CPN_AMT" ] , 20, 22 ) + "\r\n";
					csPrint += pu.GetMarkString( "회원할인"    ,	  row[ "DC_CST_AMT" ] , 20, 22 ) + "\r\n";
					csPrint += pu.GetMarkString( "식권할인"    ,	  row[ "DC_TFD_AMT" ] , 20, 22 ) + "\r\n";
					csPrint += pu.GetMarkString( "신용카드할인",    row[ "DC_CRD_AMT" ] , 20, 22 ) + "\r\n\r\n";
					csPrint += pu.GetMarkString( "할인합계"    ,	  row[ "TOT_DC_AMT" ] , 20, 22 ) + "\r\n";

					csPrint += lastLine;

				}
			} else if( pcsCode == "{현금시재입력내역}")  {
				rows = this.db_get_mumti_rows ( _sql.GetReissueAccountData_07_SQL( pcsCode,  this.m_stSaleInfo  ) , [] );
				for ( let itx = 0 ; itx < rows.length ; itx++ ) {
					let row = rows[itx];
					let a = 0, b = 0 , c = 0, lastLine = "";
					if( this.g_inPaperTypeFg == 0 ) {
						csPrint += "          ** 현금시재 입력내역 **\r\n";

						a = 18, b = 4 , c= 10;
						lastLine = "--------------------------------";
					} else {
						csPrint += "          ** 현금시재 입력내역 **\r\n";
						a = 20, b = 5, c = 17;
						lastLine = "------------------------------------------";
					}

					csPrint += pu.GetMarkString_02( "기타금액", row[ "REM_CHECK_AMT"   ], a, b+c ) + "\r\n";
					csPrint += pu.GetMarkString ( "  10만원권", row[ "REM_W100000_CNT" ], row[ "REM_W100000_AMT" ], a, b, c ) + "\r\n";
					csPrint += pu.GetMarkString ( "   5만원권", row[ "REM_W50000_CNT"  ], row[ "REM_W50000_AMT"  ], a, b, c ) + "\r\n";
					csPrint += pu.GetMarkString ( "10,000원권", row[ "REM_W10000_CNT"  ], row[ "REM_W10000_AMT"  ], a, b, c ) + "\r\n";
					csPrint += pu.GetMarkString ( " 5,000원권", row[ "REM_W5000_CNT"   ], row[ "REM_W5000_AMT"   ], a, b, c ) + "\r\n";
					csPrint += pu.GetMarkString ( " 1,000원권", row[ "REM_W1000_CNT"   ], row[ "REM_W1000_AMT"   ], a, b, c ) + "\r\n";
					csPrint += pu.GetMarkString ( "   500원"  , row[ "REM_W500_CNT"    ], row[ "REM_W500_AMT"    ], a, b, c ) + "\r\n";
					csPrint += pu.GetMarkString ( "   100원"  , row[ "REM_W100_CNT"    ], row[ "REM_W100_AMT"    ], a, b, c ) + "\r\n";
					csPrint += pu.GetMarkString ( "    50원"  , row[ "REM_W50_CNT"     ], row[ "REM_W50_AMT"     ], a, b, c ) + "\r\n";
					csPrint += pu.GetMarkString ( "    10원"  , row[ "REM_W10_CNT"     ], row[ "REM_W10_AMT"     ], a, b, c ) + "\r\n\r\n";
					csPrint += pu.GetMarkString ( "마감시재액", row[ "REM_CASH_AMT"    ], a, b+c ) + "\r\n";
					csPrint += pu.GetMarkString ( "현금과부족", row[ "LOSS_CASH_AMT"   ], a, b+c ) + "\r\n";

					csPrint += lastLine;
				}

			} else if( pcsCode == "{현금정산액}")  {

				rows = this.db_get_mumti_rows ( _sql.GetReissueAccountData_08_SQL( pcsCode,  this.m_stSaleInfo  ) , [] );
				for ( let itx = 0 ; itx < rows.length ; itx++ ) {
					let row = rows[itx];
					let a = 0, b = 0 ,   lastLine = "";
					if( this.g_inPaperTypeFg == 0 ) {
						csPrint += "       ** 현금 정산액 **\r\n";

						a = 18, b = 14 ;
						lastLine = "--------------------------------";
					} else {
						csPrint += "            ** 현금 정산액 **\r\n";
						a = 20, b = 22 ;
						lastLine = "------------------------------------------";
					}

					csPrint += pu.GetMarkString( "준 비 금"        , pu.parseInt(row[ "AMT1" ]), a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "현금매출액"      , pu.parseInt(row[ "AMT2" ]), a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "외상현금입금"    , pu.parseInt(row[ "AMT3" ]), a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "상품권현금판매"  , pu.parseInt(row[ "AMT4" ]), a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "식권현금판매"    , pu.parseInt(row[ "AMT5" ]), a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "시재입금액"      , pu.parseInt(row[ "AMT6" ]), a, b ) + "\r\n";
					csPrint += pu.GetMarkString( "시재출금액"      , pu.parseInt(row[ "AMT7" ]), a, b ) + "\r\n";

					dnAccountCashSum = pu.parseInt( row[ "AMT" ]) ;

					if( /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 550 ) ) != 0 ) {
						dnAgentFeeAmt = this.GetAgentFeeAmt();
						csPrint += pu.GetMarkString( "수수료출금액", dnAgentFeeAmt, a, b ) + "\r\n";
						dnAccountCashSum -= dnAgentFeeAmt;
					}

					csPrint += pu.GetMarkString( "현금환불액",	pu.parseInt(row[ "AMT8" ])    , a, b ) + "\r\n\r\n";
					csPrint += pu.GetMarkString( "현금시재액",	dnAccountCashSum , a, b ) + "\r\n";


					csPrint += lastLine;
				}

			} else if( pcsCode == "{신용카드정산내역}")  {


				rows = this.db_get_mumti_rows ( _sql.GetReissueAccountData_09_SQL( pcsCode,  this.m_stSaleInfo  ) , [] );
				for ( let itx = 0 ; itx < rows.length ; itx++ ) {
					let row = rows[itx];
					if( row[ "CNT1" ]  != 0	 || !pu.isEmpty( row[ "CNT2" ] ) ) {
						if( this.g_inPaperTypeFg == 0 ) {

							csPrint += "** 신용+현금IC 정산 내역 **\r\n";		// 2014-1124-Jane
																		// :
																		// 현금IC
																		// 추가.
							csPrint += pu.GetMarkString( "카드승인", row[ "CNT1"    ], row[ "AMT1"    ], 18, 4, 10 ) + "\r\n";
							csPrint += pu.GetMarkString( "카드취소", row[ "CNT2"    ], row[ "AMT2"    ], 18, 4, 10 ) + "\r\n\r\n";
							csPrint += pu.GetMarkString( "카드매출", row[ "TOT_CNT" ], row[ "TOT_AMT" ], 18, 4, 10 ) + "\r\n";
							csPrint += "--------------------------------";

						} else {

							csPrint += "     ** 신용+현금IC 정산 내역 **\r\n";	// 2014-1124-Jane
																		// :
																		// 현금IC
																		// 추가.
							csPrint += pu.GetMarkString( "카드승인", row[ "CNT1"    ], row[ "AMT1"    ], 20, 5, 17 ) + "\r\n";
							csPrint += pu.GetMarkString( "카드취소", row[ "CNT2"    ], row[ "AMT2"    ], 20, 5, 17 ) + "\r\n\r\n";
							csPrint += pu.GetMarkString( "카드매출", row[ "TOT_CNT" ], row[ "TOT_AMT" ], 20, 5, 17 ) + "\r\n";
							csPrint += "------------------------------------------";
						}
					}
				}
			} else if( pcsCode == "{신용카드승인내역}")  {
				rows = this.db_get_mumti_rows ( _sql.GetReissueAccountData_10_SQL( pcsCode,  this.m_stSaleInfo  ) , [] );
				for ( let itx = 0 ; itx < rows.length ; itx++ ) {
					let row = rows[itx];
					csTemp = row[ "CRD_CARD_NO"  ];
					csTemp.trim();

					if( csTemp == "****" ) {
						csTemp = "임의등록";
					}

					if( this.g_inPaperTypeFg == 0 ) {
						csTemp2 = "%4s %-27s\r\n%20s %11s\r\n".sprintf(
									    row[ "APPR_FG"      ]
									  , csTemp
									  , row[ "APPR_NO"      ]
									  , util.numberWithCommas( row[ "APPR_REQ_AMT" ]/** .asDouble__ * */ ) );
					}
					else {
						csTemp2 ="%4s %-16s %-8s %11s\r\n".sprintf(
									    row[ "APPR_FG"      ]
									  , csTemp
									  , row[ "APPR_NO"      ]
									  , util.numberWithCommas( row[ "APPR_REQ_AMT" ]/** .asDouble__ * */ ) );
					}
					csTemp3 += csTemp2;
				}

				if( csTemp3.length /** .GetLength() * */ > 0 ) {
					if( this.g_inPaperTypeFg == 0 ) {

						csPrint += "  ** 신용+현금IC 승인내역 **    \r\n";		// 2014-1124-Jane
																		// :
																		// 현금IC
																		// 추가.
						csPrint += "--------------------------------\r\n";
						csPrint += "구분 카드(계좌)번호/승인No  금액\r\n";		// 2014-1124-Jane
																	// : 현금IC
																	// 추가.
						csPrint += "--------------------------------\r\n";
						csPrint += csTemp3;
						csPrint += "--------------------------------\r\n";
					}
					else {
						csPrint += "       ** 신용+현금IC 승인내역 **         \r\n";	// 2014-1124-Jane
																				// :
																				// 현금IC
																				// 추가.
						csPrint += "------------------------------------------\r\n";
						csPrint += "구분  카드(계좌)번호  승인번호    승인금액\r\n";	// 2014-1124-Jane
																		// :
																		// 현금IC
																		// 추가.
						csPrint += "------------------------------------------\r\n";
						csPrint += csTemp3;
						csPrint += "------------------------------------------\r\n";
					}
				}


			} else if( pcsCode == "{카드사별매출내역}")  {
				let inCnt = 0;
				rows = this.db_get_mumti_rows ( _sql.GetReissueAccountData_11_SQL( pcsCode,  this.m_stSaleInfo  ) , [] );
				for ( let itx = 0 ; itx < rows.length ; itx++ ) {
					let row = rows[itx];
					if( row[ "CNT" ]/** .asLong__ * */ != 0 ) {
						if( this.g_inPaperTypeFg == 0 ) {
							csTemp += pu.GetMarkString( row[ "PUR_CRDCP_NM" ], row[ "CNT" ], row[ "APPR_AMT" ], 18, 4, 10 ) + "\r\n";
						}
						else {
							csTemp += pu.GetMarkString( row[ "PUR_CRDCP_NM" ], row[ "CNT" ], row[ "APPR_AMT" ], 20, 5, 17 ) + "\r\n";
						}
						inCnt++;
					}

				}

				if( inCnt > 0 )	{
					if( this.g_inPaperTypeFg == 0 ) {
						csPrint += "    ** 카드사별 매출내역 **\r\n";
						csPrint += csTemp;
						csPrint += "--------------------------------";
					}
					else {
						csPrint += "         ** 카드사별 매출내역 **\r\n";
						csPrint += csTemp;
						csPrint += "------------------------------------------";
					}
				}


			} else if( pcsCode == "{회원포인트내역}")  {
				rows = this.db_get_mumti_rows ( _sql.GetReissueAccountData_12_SQL( pcsCode,  this.m_stSaleInfo  ) , [] );
				for ( let itx = 0 ; itx < rows.length ; itx++ ) {
					let row = rows[itx];


					if( pu.parseInt( row[ "SALE_CNT"   ] ) /** .asLong__ * */ != 0
					&&  pu.parseInt( row[ "SALE_POINT" ] ) /** .asLong__ * */ != 0
					&&  pu.parseInt( row[ "USE_CNT"    ] ) /** .asLong__ * */ != 0
					&&  pu.parseInt( row[ "USE_POINT"  ] ) /** .asLong__ * */ != 0 ) {
						if( this.g_inPaperTypeFg == 0 ) {
							csPrint += SHOP_INFO.POINT_FG  /** g_csPointFg * */ == "M" ? "   ** 회원 마일리지 내역 **\r\n" : "    ** 회원 스탬프 내역 **\r\n";			// 2015-0202-Jane
																																						// :
																																						// g_clPointFg
																																						// 설정오류
																																						// 수정
							csPrint += pu.GetMarkString( "총영수건수",   "", row[ "BILL_CNT"   ], 18, 4, 10 ) + "\r\n";
							csPrint += pu.GetMarkString( "매장내방건수", "", row[ "GUEST_CNT"  ], 18, 4, 10 ) + "\r\n";
							csPrint += pu.GetMarkString( SHOP_INFO.POINT_FG   == "M" ? "적립건수/마일리지" : "적립건수/스탬프" , row[ "SALE_CNT" ], row[ "SALE_POINT" ], 18, 4, 10 ) + "\r\n";
							csPrint += pu.GetMarkString( SHOP_INFO.POINT_FG   == "M" ? "사용건수/마일리지" : "사용건수/스탬프" , row[ "USE_CNT"  ], row[ "USE_POINT"  ], 18, 4, 10 ) + "\r\n";
							csPrint += "--------------------------------";

						} else {
							csPrint += SHOP_INFO.POINT_FG  /** g_csPointFg * */ == "M" ? "        ** 회원 마일리지 내역 **\r\n" : "         ** 회원 스탬프 내역 **\r\n";	// 2015-0202-Jane
																																							// :
																																							// g_clPointFg
																																							// 설정오류
																																							// 수정
							csPrint += pu.GetMarkString( "총영수건수",   "", row[ "BILL_CNT"   ], 20, 5, 17 ) + "\r\n";
							csPrint += pu.GetMarkString( "매장내방건수", "", row[ "GUEST_CNT"  ], 20, 5, 17 ) + "\r\n";
							csPrint += pu.GetMarkString( SHOP_INFO.POINT_FG    == "M" ? "적립건수/마일리지" : "적립건수/스탬프" , row[ "SALE_CNT" ], row[ "SALE_POINT" ], 20, 5, 17 ) + "\r\n";
							csPrint += pu.GetMarkString( SHOP_INFO.POINT_FG    == "M" ? "사용건수/마일리지" : "사용건수/스탬프" , row[ "USE_CNT"  ], row[ "USE_POINT"  ], 20, 5, 17 ) + "\r\n";
							csPrint += "------------------------------------------";
						}
					}
				}

			}

			//

		} catch (e) {
			util.logError("GetReissueAccountData e ==> " + e);
			return false;
		}

		return csPrint;
	}
	this.GetRegiCardTypeData = function() {

		let blPrintFg = false /** FALSE * */;	 /** BOOL * */
		let csQrySql = "";	 
		let csTemp	 = "";	 
		let csTemp2	 = "";	 
		let sql = _sql.GetRegiCardTypeData_SQL ( this.m_SaleClose , this.m_stSaleInfo  );
		let rows = this.db_get_mumti_rows( sql , [] );

		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];

			// /////////////////////////////////////////////////////////////////////////////
			// 카드사별 건수/금액이 1건이라도 존재하면 출력.
			// /////////////////////////////////////////////////////////////////////////////
			if(  pu.parseInt( row[ "APPR_AMT" ] ) /** .asLong__ * */ != 0 ) {
				blPrintFg = true /** TRUE * */;
			}

			if(  pu.parseInt( row[ "CNT" ] )/** .asLong__ * */ != 0 ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csTemp2 += "\r\n"  + pu.GetMarkString( row[ "PUR_CRDCP_NM" ], row[ "CNT" ], row[ "APPR_AMT" ], 14, 5, 13 );
				}
				else {
					csTemp2 += "\r\n" + pu.GetMarkString( row[ "PUR_CRDCP_NM" ], row[ "CNT" ], row[ "APPR_AMT" ], 20, 5, 17 );
				}
			}
		}

		if( blPrintFg ) {
			if( this.g_inPaperTypeFg == 0 ) {
				csTemp /** .For_mat * */ = ( "    ** 카드사별 매출내역 **%s".sprintf( csTemp2 ) );
				csTemp += "\r\n--------------------------------";
			}
			else  {
				csTemp /** .For_mat * */ = ( "         ** 카드사별 매출내역 **%s".sprintf( csTemp2 ) );
				csTemp += "\r\n------------------------------------------";
			}
		}

		return csTemp;
	}
	this.GetRegiCustData = function() {
		let csQrySql = "" ; 
		let csTemp	 = "" ; 
		let csValue  = "" ; 

		let snResult = 0 ; /** WORD * */
		let sql = "";

		if( this.m_SaleClose ) {
			sql = _sql.SP_SSL_TRCST_T_SQL(this.m_stSaleInfo); // SQL Procedure
																// =
																// "SP_SSL_TRCST_T";
// row.Param( "SHOP_CD" ).setAsString() = this.m_stSaleInfo.SHOP_CD;
// row.Param( "SALE_DATE" ).setAsString() = this.m_stSaleInfo.SALE_DATE;
// row.Param( "POS_NO" ).setAsString() = this.m_stSaleInfo.POS_NO;

		} else {
			sql = _sql.SP_SSL_TRCST_T_REGI_SEQ_SQL(this.m_stSaleInfo) ;// g_clsFbDB.DB_CmdText(
																		// &row,
																		// "SP_SSL_TRCST_T_REGI_SEQ"
																		// );

// row.Param( "SHOP_CD" ).setAsString() = this.m_stSaleInfo.SHOP_CD;
// row.Param( "SALE_DATE" ).setAsString() = this.m_stSaleInfo.SALE_DATE;
// row.Param( "POS_NO" ).setAsString() = this.m_stSaleInfo.POS_NO;

// csTemp /** .For_mat **/ =( "%02d".sprintf( this.m_stSaleInfo.REGI_SEQ ));

// row.Param( "REGI_SEQ" ).setAsString() = csTemp;
		}


		let rows = this.db_get_mumti_rows( sql,[] );
		let a = 0, b = 0;
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];

			// Output 파라메터 값 얻기.
			// /////////////////////////////////////////////////////////////////////////////
			// 모든 항목 합계 금액이 0 이면 출력변수를 클리어한다.
			// /////////////////////////////////////////////////////////////////////////////
			if( pu.parseInt(row[ "SALE_CNT"   ] ) /** .asLong__ * */ == 0
					&&  pu.parseInt(row[ "SALE_POINT" ] ) /** .asLong__ * */ == 0
					&&	pu.parseInt(row[ "USE_CNT"    ] ) /** .asLong__ * */ == 0
					&&	pu.parseInt(row[ "USE_POINT"  ] ) /** .asLong__ * */ == 0 ) {
				csTemp = "";

			} else {
				// //////////////////////////////////////////////////////////////////////
				// 2013-0809-JJM : 포인트구분에 따라 포인트/스탬프 명칭 구분.
				// //////////////////////////////////////////////////////////////////////
				csValue = SHOP_INFO.POINT_FG  /** g_csPointFg * */ == "M" ? "마일리지" : "스탬프";

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp /** .For_mat * */ = "    ** 회원 %s 내역 **\r\n%s\r\n%s\r\n%s\r\n%s".sprintf(
							csValue
							, pu.GetMarkString( "총영수건수",     pu.parseInt( row ["BILL_CNT"  ] ) , 14, 18 )
							, pu.GetMarkString( "매장내방건수",   pu.parseInt( row ["GUEST_CNT" ] ) , 14, 18 )
							, pu.GetMarkString( SHOP_INFO.POINT_FG  /** g_csPointFg * */ == "M" ? "적립건수/마일리지" : "적립건수/스탬프"
								, pu.parseInt( row[ "SALE_CNT"   ] )
								, pu.parseInt( row[ "SALE_POINT" ] ) , 14, 5, 13 )
								, pu.GetMarkString( SHOP_INFO.POINT_FG  /** g_csPointFg * */ == "M" ? "사용건수/마일리지" : "사용건수/스탬프"
									, pu.parseInt( row[ "USE_CNT"   ] )
									, pu.parseInt( row[ "USE_POINT" ] ) , 14, 5, 13 ) );
					csTemp += "\r\n--------------------------------";
				} else {
					csTemp /** .For_mat * */ = "         ** 회원 %s 내역 **\r\n%s\r\n%s\r\n%s\r\n%s".sprintf(
							csValue
							, pu.GetMarkString( "총영수건수",      pu.parseInt( row["BILL_CNT"  ] ) , 20, 22 )
							, pu.GetMarkString( "매장내방건수",    pu.parseInt( row["GUEST_CNT" ] ) , 20, 22 )
							, pu.GetMarkString( SHOP_INFO.POINT_FG  /** g_csPointFg * */ == "M" ? "적립건수/마일리지" : "적립건수/스탬프"
								, pu.parseInt( row[ "SALE_CNT"   ] )
								, pu.parseInt( row[ "SALE_POINT" ] ) , 20, 5, 17 )
								, pu.GetMarkString( SHOP_INFO.POINT_FG  /** g_csPointFg * */ == "M" ? "사용건수/마일리지" : "사용건수/스탬프"
									, pu.parseInt( row[ "USE_CNT"   ] )
									, pu.parseInt( row[ "USE_POINT" ] ) , 20, 5, 17 ) );
					csTemp += "\r\n------------------------------------------";
				}
			}
		}

		return csTemp;
	}

	this.GetNoneSaleAccount = function() {
		let csMainQuery     = "" ; 
		let csPrint         = "" ; 
		let csGiftCardAmt   = "" ; 
		let csGiftCashAmt   = "" ; 
		let csWesCardAmt    = "" ; 
		let csWesCashAmt    = "" ; 
		let csGiftRepayAmt  = "" ; 
		let csFromDate      = "" ; 
		let csPosNo         = "" ; 
		let csRegiSeq       = "" ; 
		let csShopCd        = "" ; 
		let	csToDate        = "" ; 

		let dnGiftCardAmt  = 0 ; /** double * */
		let dnGiftCashAmt  = 0 ; /** double * */
		let dnGiftRepayAmt = 0 ; /** double * */
		let dnWesCardAmt   = 0 ; /** double * */
		let dnWesCashAmt   = 0 ; /** double * */

		let sql = _sql.GetNoneSaleAccount_01_SQL( );


		switch( /** atoi * */ pu.parseInt ( this.m_csPrintCode ) )	{
			case 8 :
			case 9 :
				csShopCd   = this.m_stSaleInfo.SHOP_CD;
				csFromDate = this.m_stSaleInfo.SALE_DATE;
				csToDate   = this.m_stSaleInfo.SALE_DATE;
				csPosNo    = this.m_stSaleInfo.POS_NO;
				csRegiSeq   = "%02d".sprintf( this.m_stSaleInfo.REGI_SEQ ) ;
				break;

			case 37 :
				csShopCd   = this.m_stSaleInfo.SHOP_CD;
				csFromDate = this.m_stSaleInfo.FROM_DATE;
				csToDate   = this.m_stSaleInfo.TO_DATE;
				csPosNo    = this.m_stSaleInfo.POS_NO;
				csRegiSeq  = "%02d".sprintf(  pu.parseInt ( this.m_stSaleInfo.REGI_SEQ ) );
				break;

			default :
				break;
		}
		try {
			sql = sql.sprintf(csShopCd, csFromDate, csToDate, _sql.GetWhereClauseByPosNoAndSeqNo(this.m_stSaleInfo.POS_NO, this.m_stSaleInfo.REGI_SEQ ) );

			let rows = this.db_get_mumti_rows( sql, []);

			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];
				dnGiftCardAmt = pu.parseFloat( row[ "CARD_AMT" ] ) /** .asDouble__ * */;
				dnGiftCashAmt = pu.parseFloat( row[ "CASH_AMT" ] ) /** .asDouble__ * */;
			}

			if( this.g_inPaperTypeFg == 0 ) {
				csGiftCashAmt  =  "%-20s %11s\r\n".sprintf( "현금"    , util.numberWithCommas( dnGiftCashAmt ) );
				csGiftCardAmt  =  "%-20s %11sr\n".sprintf( "신용카드" , util.numberWithCommas( dnGiftCardAmt ) );

			} else {
				csGiftCashAmt  =  "%-30s %11s\r\n".sprintf( "현금"      , util.numberWithCommas( dnGiftCashAmt ) );
				csGiftCardAmt  =  "%-30s %11s\r\n".sprintf( "신용카드"  , util.numberWithCommas( dnGiftCardAmt ) );
			}
			sql = _sql.GetNoneSaleAccount_02_SQL();
			sql = sql.sprintf(csShopCd, csFromDate, csToDate, _sql.GetWhereClauseByPosNoAndSeqNo(this.m_stSaleInfo.POS_NO, this.m_stSaleInfo.REGI_SEQ ) );

			rows = this.db_get_mumti_rows( sql,[] );

			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];
				dnGiftRepayAmt = pu.parseFloat( row[ "TK_GFT_OUT_AMT"  ] ) /** .asDouble__ * */;
			}

			if( this.g_inPaperTypeFg == 0 ) {
				csGiftRepayAmt = "%-20s %11s\r\n".sprintf( "환불" , util.numberWithCommas( dnGiftRepayAmt ) );
			} else {
				csGiftRepayAmt = "%-30s %11s\r\n".sprintf( "환불" , util.numberWithCommas( dnGiftRepayAmt ) );
			}

			sql = _sql.GetNoneSaleAccount_03_SQL();
			sql = sql.sprintf(csShopCd, csFromDate, csToDate, _sql.GetWhereClauseByPosNoAndSeqNo(this.m_stSaleInfo.POS_NO, this.m_stSaleInfo.REGI_SEQ ) );

			rows = this.db_get_mumti_rows( sql, [] );

			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];
				dnWesCardAmt = pu.parseFloat( row[ "CARD_AMT" ] ) /** .asDouble__ * */;
				dnWesCashAmt = pu.parseFloat( row[ "CASH_AMT" ] ) /** .asDouble__ * */;
			}

			if( this.g_inPaperTypeFg == 0 ) {
				csWesCashAmt = "%-20s %11s\r\n".sprintf( "현금"     , util.numberWithCommas( dnWesCashAmt ) );
				csWesCardAmt = "%-20s %11s\r\n".sprintf( "신용카드" , util.numberWithCommas( dnWesCardAmt ) );

			} else {
				csWesCashAmt = "%-30s %11s\r\n".sprintf( "현금"     , util.numberWithCommas( dnWesCashAmt ) );
				csWesCardAmt = "%-30s %11s\r\n".sprintf( "신용카드" , util.numberWithCommas( dnWesCardAmt ) );
			}

			if( dnGiftCardAmt > 0
			||  dnGiftCashAmt > 0
			||  dnWesCardAmt > 0
			||  dnWesCashAmt > 0 ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csPrint  = "    *** 비매출 정산 내역 ***    ";
					csPrint += "\r\n";

					if( dnGiftCardAmt > 0
					||  dnGiftCashAmt > 0 ) {
						csPrint += "** 상품권판매";
						csPrint += "\r\n";

						if( dnGiftCashAmt > 0 ) {
							csPrint += csGiftCashAmt;
						}
						if( dnGiftCardAmt > 0 ) {
							csPrint += csGiftCardAmt;
						}
						if( dnGiftRepayAmt > 0 ) {
							csPrint += csGiftRepayAmt;
						}
					}

					if( dnWesCardAmt > 0
					||  dnWesCashAmt > 0 ) {
						csPrint += "** 외상입금";
						csPrint += "\r\n";

						if( dnWesCashAmt > 0 ) {
							csPrint += csWesCashAmt;
						}
						if( dnWesCardAmt > 0 ) {
							csPrint += csWesCardAmt;
						}
					}

					csPrint += "--------------------------------";
				}
				else {
					csPrint  = "         *** 비매출 정산 내역 ***         ";
					csPrint += "\r\n";

					if( dnGiftCardAmt > 0 || dnGiftCashAmt > 0 ) {
						csPrint += "** 상품권판매";
						csPrint += "\r\n";

						if( dnGiftCashAmt > 0 )
							csPrint += csGiftCashAmt;

						if( dnGiftCardAmt > 0 )
							csPrint += csGiftCardAmt;

						if( dnGiftRepayAmt > 0 )
							csPrint += csGiftRepayAmt;
					}

					if( dnWesCardAmt > 0 || dnWesCashAmt > 0 ) {
						csPrint += "** 외상입금";
						csPrint += "\r\n";

						if( dnWesCashAmt > 0 )
							csPrint += csWesCashAmt;

						if( dnWesCardAmt > 0 )
							csPrint += csWesCardAmt;
					}

					csPrint += "------------------------------------------";
				}
			}

			return csPrint;

		} catch (e) {
			util.logError("GetNoneSaleAccount e ==> " + e);
			return "";
		}
	}

	this.GetSaleGiftList = function() {
		let csMainQuery = "" ; 
		let csPrint     = "" ; 
		let csResult    = "" ; 
		let csStatus    = "" ; 
		let csTemp1     = "" ; 
		let csTemp2     = "" ; 
		let	csFromDate  = "" ; 
		let csPosNo     = "" ; 
		let csRegiSeq   = "" ; 
		let csShopCd    = "" ; 
		let	csToDate    = "" ; 

		let dnSaleInCnt    = 0 ; /** double * */
		let dnSaleInAmt    = 0 ; /** double * */
		let dnSaleOutCnt   = 0 ; /** double * */
		let dnSaleOutAmt   = 0 ; /** double * */
		let dnReturnOutCnt = 0 ; /** double * */
		let dnReturnOutAmt = 0 ; /** double * */
		let dnReturnInCnt  = 0 ; /** double * */
		let dnReturnInAmt  = 0 ; /** double * */

		switch( /** atoi * */ pu.parseInt ( this.m_csPrintCode ) )	{
			case 8 :
			case 9 :
				csShopCd   = this.m_stSaleInfo.SHOP_CD;
				csFromDate = this.m_stSaleInfo.SALE_DATE;
				csToDate   = this.m_stSaleInfo.SALE_DATE;
				csPosNo    = this.m_stSaleInfo.POS_NO;
				csRegiSeq  = "%02d".sprintf( this.m_stSaleInfo.REGI_SEQ );
				break;

			case 37 :
				csShopCd   = this.m_stSaleInfo.SHOP_CD;
				csFromDate = this.m_stSaleInfo.FROM_DATE;
				csToDate   = this.m_stSaleInfo.TO_DATE;
				csPosNo    = this.m_stSaleInfo.POS_NO;
				csRegiSeq  = this.m_stSaleInfo.REGI_SEQ;
				if( this.m_stSaleInfo.REGI_SEQ != "전체"
				&&  this.m_stSaleInfo.REGI_SEQ != "마감" ) {
					csRegiSeq =  "%02d".sprintf( pu.parseInt ( this.m_stSaleInfo.REGI_SEQ ) );
				}
				break;

			default :
				break;
		}

		try {

			let sql = _sql.GetSaleGiftList_SQL();
			sql = sql.sprintf(	csShopCd, csFromDate, csToDate, _sql.GetWhereClauseByPosNoAndSeqNo(this.m_stSaleInfo.POS_NO, this.m_stSaleInfo.REGI_SEQ) );		// 2019-05-23-SHK
																																								// [정산현황]

			let rows = this.db_get_mumti_rows( sql, [] );

			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];

				csStatus = row[ "TK_GFT_SALE_FG" ];

				if( csStatus == "매출-결제" ) {
					dnSaleInCnt++;
					dnSaleInAmt += row[ "TK_GFT_UAMT" ]/** .asDouble__ * */;
				} else if( csStatus == "매출-환불" ) {
					dnSaleOutCnt++;
					dnSaleOutAmt += row[ "TK_GFT_UAMT" ]/** .asDouble__ * */;
				} else if( csStatus == "반품-환입" ) {
					dnReturnInCnt++;
					dnReturnInAmt += row[ "TK_GFT_UAMT" ]/** .asDouble__ * */;
				} else if( csStatus == "반품-환불" ) {
					dnReturnOutCnt++;
					dnReturnOutAmt += row[ "TK_GFT_UAMT" ]/** .asDouble__ * */;
				}

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp1 = "%-20s %11s\r\n".sprintf( row[ "TK_GFT_NM" ] , csStatus );

					csTemp2 = "%-10s %7s %4s %8s\r\n".sprintf(
							  row[ "TK_GFT_SEQ"  ]
							, util.numberWithCommas( row[ "TK_GFT_UPRC" ] )
							, util.numberWithCommas( row[ "TK_GFT_QTY"  ] )
							, util.numberWithCommas( row[ "TK_GFT_UAMT" ] ) );
				}
				else {
					csTemp1 = "%-30s %11s\r\n".sprintf( row[ "TK_GFT_NM"      ], csStatus );
					csTemp2 = "%-18s %8s %4s %9s\r\n".sprintf(
						      row[ "TK_GFT_SEQ"  ]
							, util.numberWithCommas( row[ "TK_GFT_UPRC" ] )
							, util.numberWithCommas( row[ "TK_GFT_QTY"  ] )
							, util.numberWithCommas( row[ "TK_GFT_UAMT" ] ) );
				}

				csPrint += csTemp1;
				csPrint += csTemp2;
			}

			if( csPrint.length /** .GetLength() * */ > 0 ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csResult  = "  *** 매출 상품권 회수내역 ***  ";
					csResult += "\r\n";
					csResult += "--------------------------------";
					csResult += "\r\n";
					csResult += " 상품권명  액면가 수량     금액";
					csResult += "\r\n";
					csResult += "--------------------------------";
					csResult += "\r\n";
					csResult += csPrint;
					csResult += "--------------------------------";
					csResult += "\r\n";
				}
				else {
					csResult  = "       *** 매출 상품권 회수내역 ***       ";
					csResult += "\r\n";
					csResult += "------------------------------------------";
					csResult += "\r\n";
					csResult += " 상품권명            액면가 수량      금액";
					csResult += "\r\n";
					csResult += "------------------------------------------";
					csResult += "\r\n";
					csResult += csPrint;
					csResult += "------------------------------------------";
					csResult += "\r\n";
				}
			}

			if( dnSaleInCnt > 0
					||  dnSaleOutCnt > 0
					||  dnReturnInCnt > 0
					||  dnReturnOutCnt > 0 ) {
				if( this.g_inPaperTypeFg == 0 ) {
					if( dnSaleInCnt > 0 ) {
						csTemp1 = "%-17s %4s %9s\r\n".sprintf(
								  "매출-결제"
								, util.numberWithCommas( dnSaleInCnt )
								, util.numberWithCommas( dnSaleInAmt ) );
						csResult += csTemp1;
					}

					if( dnSaleOutCnt > 0 ) {
						csTemp1 = "%-17s %4s %9s\r\n".sprintf(
								  "매출-환불"
								, util.numberWithCommas( dnSaleOutCnt )
								, util.numberWithCommas( dnSaleOutAmt ) );
						csResult += csTemp1;
					}

					if( dnReturnOutCnt > 0 ) {
						csTemp1 = "%-17s %4s %9s\r\n".sprintf(
								  "반품-환불"
								, util.numberWithCommas( dnReturnOutCnt )
								, util.numberWithCommas( dnReturnOutAmt ) );
						csResult += csTemp1;
					}

					if( dnReturnInCnt > 0 )	{
						csTemp1 = "%-17s %4s %9s\r\n".sprintf(
								  "반품-환입"
								, util.numberWithCommas( dnReturnInCnt )
								, util.numberWithCommas( dnReturnInAmt ) );
						csResult += csTemp1;
					}

					csResult += "--------------------------------";
				}
				else {
					if( dnSaleInCnt > 0 ) {
						csTemp1 = "%-27s %4s %9s\r\n".sprintf(
								  "매출-결제"
								, util.numberWithCommas( dnSaleInCnt )
								, util.numberWithCommas( dnSaleInAmt ) );
						csResult += csTemp1;
					}

					if( dnSaleOutCnt > 0 ) {
						csTemp1 = "%-27s %4s %9s\r\n".sprintf(
								  "매출-환불"
								, util.numberWithCommas( dnSaleOutCnt )
								, util.numberWithCommas( dnSaleOutAmt ) );
						csResult += csTemp1;
					}

					if( dnReturnOutCnt > 0 ) {
						csTemp1 = "%-27s %4s %9s\r\n".sprintf(
								  "반품-환불"
								, util.numberWithCommas( dnReturnOutCnt )
								, util.numberWithCommas( dnReturnOutAmt ) );
						csResult += csTemp1;
					}

					if( dnReturnInCnt > 0 )	{
						csTemp1 = "%-27s %4s %9s\r\n".sprintf(
								  "반품-환입"
								, util.numberWithCommas( dnReturnInCnt )
								, util.numberWithCommas( dnReturnInAmt ) );
						csResult += csTemp1;
					}

					csResult += "------------------------------------------";
				}
			}
		} catch (e) {
			util.logError("GetSaleGiftList e == > "+e);
			return "";
		}


		return csResult;


	}





	this.GetSaleDataByDataBase = function ( pcsCode ) {
		let csPrint	= "" ;

		switch( pu.parseInt ( this.m_csPrintCode ) ) {
		case 31 :
			csPrint = this.GetSaleDataClassPrint();
			break;

		case 32 :
			csPrint = this.GetSaleDataProdPrint();
			break;

/*
 * case 33 : csPrint = GetSaleDataPayPrint(); break;
 * 
 * case 34 : csPrint = GetSaleDataDcPrint(); break;
 */
		case 35 :
			csPrint = this.GetSaleDataMonthPrint();
			break;

/*
 * case 38 : csPrint = GetSaleDataTimePrint(); break;
 * 
 * case 40 : csPrint = GetSaleDataPosRecp(); break; // 2015-1211-JYL : 카드사별 승인현황
 * 추가. case 44 : csPrint = GetSaleDataApprPrint(); break;
 */
		}
	 	return csPrint;
	}


	this.GetSaleDataClassPrint = function () {
		util.logInfo("*** GetSaleDataClassPrint START ***");
		let csPrint	      = "" ;
		let bCnt          = 0;
		let csSClsNm      = "" ;
		let csOldMClsNm   = "" ;
		let csCurMclsNm   = "" ;
		let csOldMClsCd   = "" ;
		let csCurMClsCd   = "" ;

		let dnSumSaleAmt  = 0;
		let dnMClsSaleAmt = 0;
		let dnSaleAmt     = 0;	// 2010-0915-JJM : .

		let lnSumSaleQty  = 0;
		let lnMClsSaleQty = 0;
		let csEnvShop114      = pu.parseInt( this.GetEnvXmlShopENV( 114 ) ) ; 

		let sql = _sql.GetSaleDataQuery_SQL( this.m_csPrintCode , this._GET_ENV_XML_SHOP_ENV , this.m_stSaleInfo );

		let rows = null;
		try {
			rows = this.db_get_mumti_rows( sql, [] );

		} catch (e) {
			util.logError("GetSaleDataClassPrint e ==>"+ e);
			return "";
		}


		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];


			if( bCnt == 0 )	{
				if( this.g_inPaperTypeFg == 0 ) {
					csPrint += "--------------------------------\r\n";
					csPrint += "  분 류 명       수량      금 액\r\n";
					csPrint += "--------------------------------\r\n";
				}
				else {
					csPrint += "------------------------------------------\r\n";
					csPrint += "    분  류  명           수량        금 액\r\n";
					csPrint += "------------------------------------------\r\n";
				}
				csOldMClsCd = row[ "MCLS_CD" ];
				csOldMClsNm = "소계: " + row[ "MCLS_NM" ];
			}

			csCurMClsCd = row[ "MCLS_CD" ];

			lnSumSaleQty += pu.parseInt(row[ "SALE_QTY" ])/** .asLong() * */;

			dnSaleAmt = pu.parseFloat(row[ "SALE_DCM" ])/** .asDouble() * */;

			if( this.g_inTaxYnENV == 0 )	{
				dnSaleAmt += pu.parseFloat(row[ "SALE_VAT" ])/** .asDouble() * */;
			}

			dnSumSaleAmt += dnSaleAmt;

			csSClsNm = row[ "SCLS_NM" ];

			if( csOldMClsCd != csCurMClsCd ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csPrint += "--------------------------------\r\n";
					csPrint += pu.RPad( pu.DllGetCutHangul ( csOldMClsNm, 16 ), 16 );
					csPrint += pu.LPad( util.numberWithCommas( lnMClsSaleQty   ),  5 );
					csPrint += pu.LPad( util.numberWithCommas( dnMClsSaleAmt   ), 11 );
					csPrint += "\r\n";
					csPrint += "--------------------------------\r\n";
				}
				else {
					csPrint += "------------------------------------------\r\n";
					csPrint += pu.RPad( pu.DllGetCutHangul ( csOldMClsNm, 22 ), 22 );
					csPrint += pu.LPad( util.numberWithCommas( lnMClsSaleQty   ),  7 );
					csPrint += pu.LPad( util.numberWithCommas( dnMClsSaleAmt   ), 13 );
					csPrint += "\r\n";
					csPrint += "------------------------------------------\r\n";
				}

				lnMClsSaleQty = 0;
				dnMClsSaleAmt = 0;

				csOldMClsCd = csCurMClsCd;
				csOldMClsNm = "소계: " + row[ "MCLS_NM" ];
			}

			lnMClsSaleQty += pu.parseInt(row[ "SALE_QTY" ]);

			dnMClsSaleAmt += dnSaleAmt;

			if ( this.g_inPaperTypeFg == 0 ) {
				csPrint += pu.RPad( pu.DllGetCutHangul ( csSClsNm, 16      ), 16 );
				csPrint += pu.LPad( util.numberWithCommas( row[ "SALE_QTY" ] ),  5 );
				csPrint += pu.LPad( util.numberWithCommas( dnSaleAmt         ), 11 );
			}
			else {
				csPrint += pu.RPad( pu.DllGetCutHangul( csSClsNm, 22       ), 22 );
				csPrint += pu.LPad( util.numberWithCommas( row[ "SALE_QTY" ] ),  7 );
				csPrint += pu.LPad( util.numberWithCommas( dnSaleAmt         ), 13 );
			}

			csPrint += "\r\n";

			bCnt++;
		}

		if( this.g_inPaperTypeFg == 0 ) {
			csPrint += "--------------------------------\r\n";
			csPrint += pu.RPad( pu.DllGetCutHangul ( csOldMClsNm, 16 ), 16 );
			csPrint += pu.LPad( util.numberWithCommas( lnMClsSaleQty   ),  5 );
			csPrint += pu.LPad( util.numberWithCommas( dnMClsSaleAmt   ), 11 );
			csPrint += "\r\n";

			csPrint += "--------------------------------\r\n";
			csPrint += pu.RPad( "합  계"                             , 16 );
			csPrint += pu.LPad( util.numberWithCommas( lnSumSaleQty ),  5 );
			csPrint += pu.LPad( util.numberWithCommas( dnSumSaleAmt ), 11 );
			csPrint += "\r\n--------------------------------";

		} else {
			csPrint += "------------------------------------------\r\n";
			csPrint += pu.RPad( pu.DllGetCutHangul   ( csOldMClsNm, 22 ), 22 );
			csPrint += pu.LPad( util.numberWithCommas( lnMClsSaleQty   ),  7 );
			csPrint += pu.LPad( util.numberWithCommas( dnMClsSaleAmt   ), 13 );
			csPrint += "\r\n";

			csPrint += "------------------------------------------\r\n";
			csPrint += pu.RPad( "합  계",                              22 );
			csPrint += pu.LPad( util.numberWithCommas( lnSumSaleQty ),  7 );
			csPrint += pu.LPad( util.numberWithCommas( dnSumSaleAmt ), 13 );
			csPrint += "\r\n------------------------------------------";
		}

		return csPrint;
	}

	this.GetNoneSaleGiftList = function( ) {
		let csMainQuery = "" ; 
		let csPrint     = "" ; 
		let csResult    = "" ; 
		let csStatus    = "" ; 
		let csTemp1     = "" ; 
		let csTemp2     = "" ; 
		let	csFromDate  = "" ; 
		let csPosNo     = "" ; 
		let csRegiSeq   = "" ; 
		let csShopCd    = "" ; 
		let	csToDate    = "" ; 

		let dnSaleCnt   = 0 ; /** double * */
		let dnSaleAmt   = 0 ; /** double * */
		let dnReturnCnt = 0 ; /** double * */
		let dnReturnAmt = 0 ; /** double * */

		switch( /** atoi * */ pu.parseInt ( this.m_csPrintCode ) )	{
			case 8 :
			case 9 :
				csShopCd   = this.m_stSaleInfo.SHOP_CD;
				csFromDate = this.m_stSaleInfo.SALE_DATE;
				csToDate   = this.m_stSaleInfo.SALE_DATE;
				csPosNo    = this.m_stSaleInfo.POS_NO;
				csRegiSeq /** .For_mat * */ = ( "%02d"
					            , this.m_stSaleInfo.REGI_SEQ );
				break;

			case 37 :
				csShopCd   = this.m_stSaleInfo.SHOP_CD;
				csFromDate = this.m_stSaleInfo.FROM_DATE;
				csToDate   = this.m_stSaleInfo.TO_DATE;
				csPosNo    = this.m_stSaleInfo.POS_NO;
				csRegiSeq  = this.m_stSaleInfo.REGI_SEQ;
				if( this.m_stSaleInfo.REGI_SEQ != "전체"
				&&  this.m_stSaleInfo.REGI_SEQ != "마감" ) {
					csRegiSeq /** .For_mat * */ = ( "%02d"
									, /** atoi * */ pu.parseInt ( this.m_stSaleInfo.REGI_SEQ ) );
				}
				break;

			default :
				break;
		}

		try {
			let sql = _sql.GetNoneSaleGiftList_SQL();
			sql = sql.sprintf(	csShopCd, csFromDate, csToDate, _sql.GetWhereClauseByPosNoAndSeqNo(this.m_stSaleInfo.POS_NO, this.m_stSaleInfo.REGI_SEQ) );		// 2019-05-23-SHK
																																								// [정산현황]
			let rows = this.db_get_mumti_rows( sql,[] );

			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];

				csStatus = row[ "TK_GFT_SALE_FG" ];

				if( csStatus == "비매출-판매" )	{
					dnSaleCnt++;
					dnSaleAmt += pu.parseFloat(row[ "TK_GFT_UAMT" ] ) /** .asDouble__ * */;

				} else if( csStatus == "비매출-반품" ) {
					dnReturnCnt++;
					dnReturnAmt += pu.parseFloat(row[ "TK_GFT_UAMT" ] )/** .asDouble__ * */;
				}

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp1  =  "%-20s %11s\r\n".sprintf(
								    row[ "TK_GFT_NM" ]
								  , csStatus );

					csTemp2 = "%-10s %7s %4s %8s\r\n".sprintf(
								    row[ "TK_GFT_SEQ"  ]
								  , util.numberWithCommas( row[ "TK_GFT_UPRC" ] )
								  , util.numberWithCommas( row[ "TK_GFT_QTY"  ] )
								  , util.numberWithCommas( row[ "TK_GFT_UAMT" ] ) );
				}
				else {
					csTemp1 = "%-30s %11s\r\n".sprintf(
								    row[ "TK_GFT_NM" ]
								  , csStatus );

					csTemp2 = "%-18s %8s %4s %9s\r\n".sprintf(
								   row[ "TK_GFT_SEQ"  ]
								  , util.numberWithCommas( row[ "TK_GFT_UPRC" ] )
								  , util.numberWithCommas( row[ "TK_GFT_QTY"  ] )
								  , util.numberWithCommas( row[ "TK_GFT_UAMT" ] ) );
				}

				csPrint += csTemp1;
				csPrint += csTemp2;

			}

			if( csPrint.length /** .GetLength() * */ > 0 ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csResult  = " *** 비매출 상품권 판매내역 *** ";
					csResult += "\r\n";
					csResult += "--------------------------------";
					csResult += "\r\n";
					csResult += " 상품권명   액면가 수량     금액";
					csResult += "\r\n";
					csResult += "--------------------------------";
					csResult += "\r\n";
					csResult += csPrint;
					csResult += "--------------------------------";
					csResult += "\r\n";
				}
				else {
					csResult  = "      *** 비매출 상품권 판매내역 ***      ";
					csResult += "\r\n";
					csResult += "------------------------------------------";
					csResult += "\r\n";
					csResult += " 상품권명            액면가 수량      금액";
					csResult += "\r\n";
					csResult += "------------------------------------------";
					csResult += "\r\n";
					csResult += csPrint;
					csResult += "------------------------------------------";
					csResult += "\r\n";
				}
			}

			if( dnSaleCnt > 0
			||  dnReturnCnt > 0 ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csTemp1 = "%-17s %4s %9s\r\n".sprintf(
								    "비매출-판매"
								  , util.numberWithCommas( dnSaleCnt )
								  , util.numberWithCommas( dnSaleAmt ) );

					csTemp2 = "%-17s %4s %9s\r\n".sprintf(
								    "비매출-반품"
								  , util.numberWithCommas( dnReturnCnt )
								  , util.numberWithCommas( dnReturnAmt ) );

					csResult += csTemp1;
					csResult += csTemp2;
					csResult += "--------------------------------";
				}
				else {
					csTemp1 = "%-27s %4s %9s\r\n".sprintf(
								    "비매출-판매"
								  , util.numberWithCommas( dnSaleCnt )
								  , util.numberWithCommas( dnSaleAmt ) );

					csTemp2 = "%-27s %4s %9s\r\n".sprintf(
								    "비매출-반품"
								  , util.numberWithCommas( dnReturnCnt )
								  , util.numberWithCommas( dnReturnAmt ) );

					csResult += csTemp1;
					csResult += csTemp2;
					csResult += "------------------------------------------";
				}
			}

			return csResult;


		} catch (e) {
			util.logError("GetNoneSaleGiftList e ==> " +e);
			return "";
		}

	}
	this.GetReissueAccountPrint = function ( pstSaleList , pcsPrintCode ) {
		util.logInfo("*** GetReissueAccountPrint START ***");
		util.logInfo("_______pstSaleList == > " + pstSaleList);
		let szResult = "";
		let csTemp   = "";
		this.m_stSaleInfo = pstSaleList;
		this.m_csPrintCode = pcsPrintCode;
		csTemp   = this.GetPrintSource( this.m_csPrintCode );
		szResult = this.PrintCodeMatch( csTemp );
		return szResult;
	}

	this.GetSaleDataProdPrint = function() {
		util.logInfo("*** GetSaleDataProdPrint START ***");
		let bCnt = 0 ; /** byte * */

		let csQuery	 = "" ; 
		let csPrint	 = "" ; 
		let csProdNm = "" ; 
		let csProdCd = "" ; 												// 2010-0402-YBC
		let csTitle  = "" ; 												// 2011-1130-JJM
																						// : .
		let csTemp   = "" ; 												// 2010-1018-JJM
																						// : .

		let dnSumSaleAmt = 0 ; /** double * */
		let dnSaleAmt    = 0 ; /** double * */													// 2010-0915-JJM
																								// : .
		let dnSumDcAmt   = 0 ; /** double * */													// 2010-1018-JJM
																								// : .
		let dnDcAmt      = 0 ; /** double * */													// 2010-1018-JJM
																								// : .
		let dnSvcAmt     = 0 ; /** double * */													// 2011-1130-LSH
																								// : .
		let dnSumSvcAmt  = 0 ; /** double * */													// 2011-1130-LSH
																								// : .

		let lnSumSaleQty = 0;
		let lnSaleQty    = 0;

		let inEvnShop282 = /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 282 ) );			// 2010-1018-JJM
																								// :
																								// 업체별
																								// 특이사항.
		let inEnvShop562 = /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 562 ) );			// 2011-0104-JJM
																								// : 소계
																								// 출력
																								// 구분.


		let sql = _sql.GetSaleDataQuery_SQL( this.m_csPrintCode , this._GET_ENV_XML_SHOP_ENV , this.m_stSaleInfo  );

		let rows = null;

		try {
			rows = this.db_get_mumti_rows( sql,[] );
		} catch (e) {
			util.logError(e);
			return "";
		}
		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];

			if( bCnt == 0 )	{
				if( this.g_inPaperTypeFg == 0 ) {
					csPrint += "--------------------------------\r\n";
					csPrint += "   상 품 명      수량      금 액\r\n";
					csPrint += "--------------------------------\r\n";
				}
				else {

					csPrint += "------------------------------------------\r\n";
					if( inEvnShop282 == 3 )	{
						csPrint += "    상 품 명     수량      금 액      할인\r\n";
					}
					else {
						csPrint += "    상  품  명           수량        금 액\r\n";
					}
					csPrint += "------------------------------------------\r\n";
				}
			}

			csProdNm = row[ "PROD_NM" ];
			csProdCd = row[ "PROD_CD" ].trim();

			dnSaleAmt = pu.parseFloat( row[ "SALE_DCM" ] )/** .asDouble__ * */;
			dnDcAmt   = pu.parseFloat( row[ "SALE_DC"  ] )/** .asDouble__ * */;
			dnSvcAmt  = pu.parseFloat( row[ "SVC_AMT"  ] )/** .asDouble__ * */;

			lnSaleQty = pu.parseInt( row[ "SALE_QTY" ] )/** .asLong__ * */;

			if( this.g_inTaxYnENV == 0 )	{
				dnSaleAmt += pu.parseFloat(row[ "SALE_VAT" ])/** .asDouble__ * */;
				dnDcAmt   += dnDcAmt * 0.1;
				dnSvcAmt  += dnSvcAmt * 0.1;
			}

			if( inEvnShop282 == 3 )	{
				dnSaleAmt += dnDcAmt;
			}

			if( csProdCd == "분류" &&  inEnvShop562 == 2 ) {
				continue;
			}

			if( csProdCd == "코너"  && inEnvShop562 == 1 ) {
				continue;
			}

			if( csProdCd == "분류" ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csPrint += "--------------------------------\r\n";
				}
				else {
					csPrint += "------------------------------------------\r\n";
				}

			} else {
				// //////////////////////////////////////////////////////////////////
				// 코너인 경우 합계 제외.
				// //////////////////////////////////////////////////////////////////
				if( csProdCd != "코너" ) {
					lnSumSaleQty += lnSaleQty;

					dnSumSaleAmt += dnSaleAmt;
					dnSumDcAmt   += dnDcAmt;
					dnSumSvcAmt  += dnSvcAmt;
				}

				if( csProdCd == "코너"  &&  inEnvShop562 == 2 )	{
					if( this.g_inPaperTypeFg == 0 ) {
						csPrint += "--------------------------------\r\n";

					} else {
						csPrint += "------------------------------------------\r\n";
					}
				}
			}

			// //////////////////////////////////////////////////////////////////////
			// 분류, 코너소계 구분자 추가.
			// //////////////////////////////////////////////////////////////////////
			if( csProdCd == "분류" ) {
				csProdNm = "【분】" + csProdNm;

			} else if( csProdCd == "코너" ) {
				csProdNm = "【코】" + csProdNm;
			}
			if( this.g_inPaperTypeFg == 0 ) {
				csTemp = "%-16s %4s %10s\r\n".sprintf(
							   pu.DllGetCutHangul( csProdNm, 16 )
							 , util.numberWithCommas( lnSaleQty )
							 , util.numberWithCommas( dnSaleAmt ) );

			} else {
				if( inEvnShop282 == 3 )	{
					csTemp = "%-16s %4s %10s %9s\r\n".sprintf(
								   pu.DllGetCutHangul( csProdNm, 16 )
								 , util.numberWithCommas( lnSaleQty )
								 , util.numberWithCommas( dnSaleAmt )
								 , util.numberWithCommas( dnDcAmt ) );
				} else {
					let x1 = pu.DllGetCutHangul( csProdNm, 22 );
					let x2 = util.numberWithCommas( lnSaleQty );
					let x3 = util.numberWithCommas( dnSaleAmt );
					csTemp = "%-22s %6s %12s\r\n".sprintf( x1, x2, x3);
				}
			}

			if(row["PRICE_MGR_FG"] == "2" && pu.parseInt(row["SALE_WEIGHT"] )/** .asLong__ * */ > 0) {
				csProdNm ="(%sg)".sprintf( util.numberWithCommas(row["SALE_WEIGHT"]));
				csTemp += RPad(csProdNm, 17) + "\r\n";
			}

			csPrint += csTemp;

			if( this.g_inPaperTypeFg == 0 ) {
				if( csProdCd == "분류" ) {
					csPrint += "--------------------------------\r\n";

				} else if( csProdCd == "코너" ) {
					if( inEnvShop562 == 0 )	{
						csPrint += "--------------------------------\r\n";
					} else {
						csPrint += "--------------------------------\r\n";
					}
				}

			} else {
				if( csProdCd == "분류" ) {
					csPrint += "------------------------------------------\r\n";

				} else if( csProdCd == "코너" ) {
					if( inEnvShop562 == 0 )	{
						csPrint += "------------------------------------------\r\n";
					}
					else {
						csPrint += "------------------------------------------\r\n";
					}
				}
			}

			bCnt++;

		}

		if( this.g_inPaperTypeFg == 0 ) {
			csPrint += "--------------------------------\r\n";
			csTemp = "%-16s %4s %10s\r\n".sprintf(
						   "합  계"
						 , util.numberWithCommas( lnSumSaleQty )
						 , util.numberWithCommas( dnSumSaleAmt ) );

			csPrint += csTemp;
			csPrint += "--------------------------------";

		}
		else {
			if( inEvnShop282 == 3 ) {
				csTemp = "%-30s%12s\r\n".sprintf( "매출합계" , util.numberWithCommas( dnSumSaleAmt ) );
				csPrint += csTemp;

				csTemp = "%-30s%12s\r\n".sprintf( "할인합계" , util.numberWithCommas( dnSumDcAmt - dnSumSvcAmt ) );
				csPrint += csTemp;

				csTemp = "%-30s%12s\r\n".sprintf( "서비스합계" , util.numberWithCommas( dnSumSvcAmt ) );

				csPrint += csTemp;
				csPrint += "------------------------------------------\r\n";

				csTemp = "%-30s%12s\r\n".sprintf( "합    계" , util.numberWithCommas( dnSumSaleAmt - dnSumDcAmt ) );

			} else {
				csPrint += "------------------------------------------\r\n";
				csTemp = "%-22s %6s %12s\r\n".sprintf(
							   "합  계"
							 , util.numberWithCommas( lnSumSaleQty )
							 , util.numberWithCommas( dnSumSaleAmt ) );
			}

			csPrint += csTemp;
			csPrint += "------------------------------------------";
		}

		return csPrint;
	}

	this.GetSaleDataMonthPrint = function(){
		util.logInfo("*** GetSaleDataMonthPrint START ***");
		let bCnt = 0 ; /** byte * */

		let csQuery = "" ; 
		let csPrint = "" ; 
		let csDate  = "" ; 

		let dnSumSaleAmt = 0 ; /** double * */
		let dnSaleAmt    = 0 ; /** double * */

		util.logInfo("***printer.js GetSaleDataMonthPrint GetSaleDataQuery_SQL param m_csPrintCode, _GET_ENV_XML_SHOP_ENV, m_stSaleInfo == > " + this.m_csPrintCode +", "+this._GET_ENV_XML_SHOP_ENV +", "+ this.m_stSaleInfo);

		let sql = _sql.GetSaleDataQuery_SQL( this.m_csPrintCode , this._GET_ENV_XML_SHOP_ENV , this.m_stSaleInfo );

		let rows = null;
		try {
			rows = this.db_get_mumti_rows( sql, [] );

		} catch (e) {
			util.logError(e);
			return "";
		}

		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];

			if( bCnt == 0 )	{
				if( this.g_inPaperTypeFg == 0 ) {
					csPrint += "--------------------------------\r\n";
					csPrint += "    매출일자               금 액\r\n";
					csPrint += "--------------------------------\r\n";

				} else {
					csPrint += "------------------------------------------\r\n";
					csPrint += "    매 출 일 자                      금 액\r\n";
					csPrint += "------------------------------------------\r\n";
				}
			}

			dnSaleAmt = pu.parseFloat( row[ "SUM_AMT" ]) ;

			if( this.g_inTaxYnENV == 0 )
				dnSaleAmt += pu.parseFloat( row[ "VAT_AMT" ]) ;

			dnSumSaleAmt += dnSaleAmt;

			csDate = row[ "SALE_DAT" ];

			if( this.g_inPaperTypeFg == 0 ) {
				csPrint += pu.RPad( pu.DllGetCutHangul( csDate, 18 ), 18 );
				csPrint += pu.LPad( util.numberWithCommas( dnSaleAmt ), 14 );
			}
			else {
				csPrint += pu.RPad( pu.DllGetCutHangul( csDate, 29 ), 29 );
				csPrint += pu.LPad( util.numberWithCommas( dnSaleAmt ), 13 );
			}
			csPrint += "\r\n";

			bCnt++;
		}


		if( this.g_inPaperTypeFg == 0 ) {
			csPrint += "--------------------------------\r\n";
			csPrint += pu.RPad( "합  계", 18 );
			csPrint += pu.LPad( util.numberWithCommas( dnSumSaleAmt ), 14 );
			csPrint += "\r\n--------------------------------";
		}
		else {
			csPrint += "------------------------------------------\r\n";
			csPrint += pu.RPad( "합  계", 29 );
			csPrint += pu.LPad( util.numberWithCommas( dnSumSaleAmt ), 13 );
			csPrint += "\r\n------------------------------------------";
		}

		return csPrint;

	}

	this.GetSalesDcData = function(pcsCode) {
		util.logInfo("*** GetSalesDcData START ***");
		let csPrint     = "" ; 
		let csMainQuery = "" ; 
		let csRegiSeq   = "" ; 
		let csShopCd    = "" ; 
		let csFromDate  = "" ; 
		let csToDate    = "" ; 
		let csPosNo     = "" ; 
		let csTempPrint = "" ; 
		let csTemp      = "" ; 
		let csDcTypeFg  = "" ; 
		let csDcAmtNm   = "" ; 

		let dnDcSum = 0 ; /** double * */
		let dnDcQty = 0 ; /** double * */
		switch(  pu.parseInt ( this.m_csPrintCode ) )	{
			case 8 :
			case 9 :
				csShopCd   = this.m_stSaleInfo.SHOP_CD;
				csFromDate = this.m_stSaleInfo.SALE_DATE;
				csToDate   = this.m_stSaleInfo.SALE_DATE;
				csPosNo    = this.m_stSaleInfo.POS_NO;
				csRegiSeq  = "%02s".sprintf( pu.parseInt ( this.m_stSaleInfo.REGI_SEQ ) );
				break;

			case 37 :
				csShopCd   = this.m_stSaleInfo.SHOP_CD;
				csFromDate = this.m_stSaleInfo.FROM_DATE;
				csToDate   = this.m_stSaleInfo.TO_DATE;
				csPosNo    = this.m_stSaleInfo.POS_NO;
				csRegiSeq  = "%02s".sprintf( pu.parseInt ( this.m_stSaleInfo.REGI_SEQ ) );
				break;

			default :
				break;
		}

		if( pcsCode == "{일반할인내역}" ) {
			csDcAmtNm  = "A.DC_AMT_GEN";	// 2013-0207-JJM : .
			csDcTypeFg = "\n   AND   A.DC_AMT_GEN > 0 "
		}
		else if( pcsCode == "{포장할인내역}" ) {
			csDcAmtNm  = "A.DC_AMT_PACK";	// 2013-0207-JJM : .
			csDcTypeFg = "\n   AND   A.DC_AMT_PACK > 0 "
		}
		else if( pcsCode == "{쿠폰할인내역}" ) {
			csDcAmtNm  = " A.DC_AMT_CPN";	// 2013-0207-JJM : .
			csDcTypeFg = "\n   AND   A.DC_AMT_CPN > 0 "
		}


		let sql = _sql.GetSalesDcData_SQL ( pcsCode , this.m_stSaleInfo  );
		sql = sql.sprintf( csDcAmtNm , gShopCd, csFromDate, csToDate, csDcTypeFg, _sql.GetWhereClauseByPosNoAndSeqNo(this.m_stSaleInfo.POS_NO, this.m_stSaleInfo.REGI_SEQ) );		// 2019-05-23-SHK
																																													// [정산현황]
		let rows = null;
		try {
			rows = this.db_get_mumti_rows( sql, [] );

		} catch (e) {
			util.logError("GetSalesDcData e ==> " + e);
			return "";
		}

		for ( let itx = 0 ; itx < rows.length ; itx++ ) {
			let row = rows[itx];
			dnDcSum += row[ "DC_AMT" ]/** .asDouble__ * */;
			dnDcQty += row[ "DC_QTY" ]/** .asDouble__ * */;

			if( this.g_inPaperTypeFg == 0 ) {
				csTemp = "%-18s %3s %9s\r\n".sprintf( pu.DllGetCutHangul( row[ "PROD_NM" ], 18 ) , pu.parseFloat(util.numberWithCommas( row[ "DC_QTY" ] )  ) , pu.parseFloat(util.numberWithCommas( row[ "DC_AMT" ] )   ) );

			} else {
				csTemp = "%-27s %4s %9s\r\n".sprintf(                     row[ "PROD_NM" ]       , pu.parseFloat(util.numberWithCommas( row[ "DC_QTY" ] )  ) , pu.parseFloat(util.numberWithCommas( row[ "DC_AMT" ] )   ) );
			}
			csTempPrint += csTemp;

		}// end for

		if( csTempPrint.length  > 1 ) {
			if( this.g_inPaperTypeFg == 0 ) {
				if( pcsCode == "{일반할인내역}" ) {
					csPrint  = "     **** 일반할인내역 ****     ";

				} else if( pcsCode == "{포장할인내역}" ) {
					csPrint  = "     **** 포장할인내역 ****     ";

				} else if( pcsCode == "{쿠폰할인내역}" ) {
					csPrint  = "     **** 쿠폰할인내역 ****     ";
				}

				csPrint += "\r\n";
				csPrint += csTempPrint;
				csPrint += "\r\n";

				csTemp = "%-17s %4s %9s\r\n".sprintf(
							   "할인합계"
							 , util.numberWithCommas( dnDcQty )
							 , util.numberWithCommas( dnDcSum ) );

				csPrint += csTemp;
				csPrint += "--------------------------------";
			}
			else {
				if( pcsCode == "{일반할인내역}" ) {
					csPrint  = "          **** 일반할인내역 ****          ";
				}
				else if( pcsCode == "{포장할인내역}" ) {
					csPrint  = "          **** 포장할인내역 ****          ";
				}
				else if( pcsCode == "{쿠폰할인내역}" ) {
					csPrint  = "          **** 쿠폰할인내역 ****          ";
				}

				csPrint += "\r\n";
				csPrint += csTempPrint;
				csPrint += "\r\n";

				csTemp = "%-27s %4s %9s\r\n".sprintf(
							   "할인합계"
							 , util.numberWithCommas( dnDcQty )
							 , util.numberWithCommas( dnDcSum ) );

				csPrint += csTemp;
				csPrint += "------------------------------------------";
			}
		}

		return csPrint;
	}
	this.GetCardApprData = function () {
		util.logInfo("*** GetCardApprData START ***");
		let csPrint = "";
		let csQuery = "";
		let csTemp1 = "";
		let csTemp2 = "";
		let csTemp3 = "";
		let sql = _sql.GetCardApprData_SQL( this.m_stSaleInfo  );
		try {
			let rows = this.db_get_mumti_rows( sql, [] );

			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];

				csTemp1 = row[ "CRD_CARD_NO" ].trim();

				if( csTemp1 == "****" ) {
					csTemp1 = "임의등록";
				}

				if( this.g_inPaperTypeFg == 0 ) {
					csTemp2 = "%4s %-27s\r\n%20s %11s\r\n".sprintf(
								    row[ "APPR_FG" ]
								  , csTemp1
								  , row[ "APPR_NO" ]
								  , util.numberWithCommas( pu.parseFloat(row[ "APPR_REQ_AMT" ] )/** .asDouble__ * */  ) ) ;
				} else {
					csTemp2 = "%4s %-16s %-8s %11s\r\n".sprintf(
								    row[ "APPR_FG" ]
								  , csTemp1
								  , row[ "APPR_NO" ]
								  , util.numberWithCommas( pu.parseFloat( row[ "APPR_REQ_AMT" ])/** .asDouble__ * */ ) );
				}
				csTemp3 += csTemp2;
			}

			if( csTemp3.length  > 0 ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csPrint += "   ** 신용+현금IC 승인내역 **   \r\n";			// 2014-1124-Jane
																		// :
																		// 현금IC
																		// 추가.
					csPrint += "--------------------------------\r\n";
					csPrint += "구분/카드(계좌)번호  승인No/금액\r\n";			// 2014-1124-Jane
																	// : 현금IC
																	// 추가.
					csPrint += "--------------------------------\r\n";
					csPrint += csTemp3;
					csPrint += "--------------------------------\r\n";

				} else  {
					csPrint += "       ** 신용+현금IC 승인내역 **         \r\n";	// 2014-1124-Jane
																			// :
																			// 현금IC
																			// 추가.
					csPrint += "------------------------------------------\r\n";
					csPrint += "구분 카드(계좌)번호  승인번호	  승인금액\r\n";	// 2014-1124-Jane
																	// : 현금IC
																	// 추가.
					csPrint += "------------------------------------------\r\n";
					csPrint += csTemp3;
					csPrint += "------------------------------------------\r\n";
				}
			}

		} catch (e) {
			util.logError("GetCardApprData e==> " + e);
			csPrint = "";
		}
		return csPrint;
	}


	// 사용안하는 함수
	this.testSimpleTxtPrint = function (){
		$("#rex1").text("");
		$("#rex2").text("");
		let r = "Simple Txt";
		let pr1 = this.printCall( r  , ""  );
		$("#printSrcResult").html(JSON.stringify( r ));
		$("#printResult").html(JSON.stringify( pr1 ));

		util.logInfo('프린터 출력결과 : ' + JSON.stringify( pr1 ) );

	}
	this.test2 = function(pcsCode) {
		let snLen = 0;
		util.logInfo("pcsCode : " + pcsCode);
		pcsCode = pu.AlignText( pcsCode );
		util.logInfo("pcsCode AlignText: " + pcsCode+"#");
		snLen =  parseInt( pcsCode.substr( 3, 2   ) );
		let r = pu.CPad( pcsCode , snLen );
		util.logInfo('r:' + r);
	}

	this.testPad = function () {
		let x1 = pu.AlignText ("{:C42}영수증-재발행{/:C}");
		let x2 = pu.CPad(x1, 42);
		let x3_L = pu.MaskString( "영수증-재발행", 42, " " , 0 );
		let x3_R = pu.MaskString( "영수증-재발행", 42, " " , 1 );
		let x3_C = pu.MaskString( "영수증-재발행", 42, " " , 2 );
		util.logInfo("x1 #:" + x1 + "#");
		util.logInfo("x2 #:" + x2 + "#");
		util.logInfo("x3_L #:" + x3_L + "#" + x3_L.getByteLength());
		util.logInfo("x3_R #:" + x3_R + "#" + x3_R.getByteLength());
		util.logInfo("x3_C #:" + x3_C + "#" + x3_C.getByteLength());
		let x4_1 = pu.RPad( "떡볶이 US", 17 );
		let x4_2 = pu.RPad( "감자튀김 US", 17 );
		let x4_3 = pu.RPad( "카레덮밥", 17 );
		util.logInfo("x4_1 #:" + x4_1 + "#" + x4_1.getByteLength());
		util.logInfo("x4_2 #:" + x4_2 + "#" + x4_2.getByteLength());
		util.logInfo("x4_3 #:" + x4_3 + "#" + x4_3.getByteLength());

	}

	// this.test() 함수에서만 사용하는데 테스트용도 같음.
	this.printData2 = function( signImgPath) {
		/*
		 * FDK_Print
		 * 
		 * @Param - deviceName : /dev/ttyUSB0 - baudRate : 57600 - printData :
		 * print data - dataLength : print data 길이 - signImgPath : 서명 이미지 path
		 * 
		 * @Result '0' : 정상 처리 '-1' : 초기화 오류
		 * 
		 * JSON 결과 예제 - 정상 : { "ResultCode" : "0", "Data" : "SUCCESS", "Message" : "" } -
		 * 오류 : { "ResultCode" : "-2", "Data" : "NO DEVICE", "Message" : "리더기가가
		 * 검색되지 않았습니다.\n리더기 연결 확인 후 다시 시도하세요." }
		 */

		let  reqstr = "";

		reqstr = "\x0a";
		reqstr += "퍼스트데이타";
		reqstr += "\x0a";
		reqstr += "\x0a";
		reqstr += "\x0a";
		reqstr += "TABLE :    영수증NO:001-1(재발행)";
		reqstr += "\x0a";
		reqstr += "일자 : 2008-05-22 14:28:45";
		reqstr += "\x0a";
		reqstr += "----------------------------------------";
		reqstr += "\x0a";
		reqstr += "품명             단가  수량    금액";
		reqstr += "\x0a";
		reqstr += "----------------------------------------";
		reqstr += "\x0a";
		reqstr += "해물뚝배기           6,000  1     6,000";
		reqstr += "\x0a";
		reqstr += "정성을 다하겠습니다.";
		reqstr += "\x0a";
		reqstr += "\x0a";
		reqstr += "\x0a";
		reqstr += "\x0a";
		reqstr += "\x0a";
		reqstr += "\x0a";
		reqstr += "\x11";
		let result = this.printCall( reqstr , "");
		$("#printResult").html(JSON.stringify( result ));
	}

	this.PrintInsert = function ( pcsSaleDate, pcsOrderNo, pcsPrtNo, pcsContents, pcsPrint, pcsOrderPrtSeq, pcsOrderSeqNo, pcsRePrintFg ) {
		util.logInfo("*** PrintInsert START ***");
		let   csLog        = "" ; 
		let	  csRetSendStr = "" ; 
		let   inPrtNo = /** atoi * */ pu.parseInt ( pcsPrtNo );
		let params = {};
		params[ "SHOP_CD"       ] = gShopCd;
		params[ "SALE_DATE"     ] = pcsSaleDate;
		params[ "ORDER_NO"      ] = pcsOrderNo;
		params[ "PRT_NO"        ] = pcsPrtNo;
		params[ "CONTENTS"      ] = pcsContents;
		params[ "PRINT_YN"      ] = pcsPrint;
		params[ "ORDER_PRT_SEQ" ] = pcsOrderPrtSeq;
		params[ "ORDER_SEQ_NO"  ] = pcsOrderSeqNo;
		params[ "REPRINT_FG"    ] = pcsRePrintFg;
		util.logInfo('PrintInsert params' + JSON.stringify( params ));

		let lnAffextedRows = this.SP_SCD_PRTDT_TO_TIME(params);
		
		if ( lnAffextedRows < 0 ) {
			// 실패이력 관련은 저장하지 않는다.2020.09.04 최광림 차장 confirm.(주방에 출력이 되지 않으면 안되기
			// 때문에 즉시 출력이다.)
			return false /** FALSE * */;
		}
		// 성공일 경우 이후는 Demon 에서 처리한다. 2020.09.04 최광림 차장 confirm.
		return true /** TRUE * */;
	}

	/*
	 * 2021. 05. 26  xbwing
	 * 주방 출력 저장을 위해 수신한 정보를 SQL문에 적용하는 함수
	 */
	this.PrintInsert_Sql2 = function ( sqlParam ) 
	{
		util.logInfo("*** PrintInsert START ***");
		let   csLog        = "" ; 
		let	  csRetSendStr = "" ; 
		let   inPrtNo = /** atoi * */ pu.parseInt ( sqlParam[3] );
		let params = {};
		params[ "SHOP_CD"       ] = sqlParam[0];
		params[ "SALE_DATE"     ] = sqlParam[1];
		params[ "ORDER_NO"      ] = sqlParam[2];
		params[ "PRT_NO"        ] = sqlParam[3];
		params[ "CONTENTS"      ] = sqlParam[4];
		params[ "PRINT_YN"      ] = sqlParam[5];
		params[ "ORDER_PRT_SEQ" ] = sqlParam[6];
		params[ "ORDER_SEQ_NO"  ] = sqlParam[7];
		params[ "REPRINT_FG"    ] = sqlParam[8];
		util.logInfo('PrintInsert params' + JSON.stringify( params ));

		let lnAffextedRows = this.SP_SCD_PRTDT_TO_TIME(params);
		
		if ( lnAffextedRows < 0 ) {
			// 실패이력 관련은 저장하지 않는다.2020.09.04 최광림 차장 confirm.(주방에 출력이 되지 않으면 안되기
			// 때문에 즉시 출력이다.)
			return false /** FALSE * */;
		}
		// 성공일 경우 이후는 Demon 에서 처리한다. 2020.09.04 최광림 차장 confirm.
		return true /** TRUE * */;
	}
	
	this.InsertPrintTableMenuMove = function( pcsParameter ) {
		let csPrint         = "" ; 
		let csQrySql        = "" ; 
		let csPosNo         = pcsParameter.substr(  0, 2 ) ; 
		let csSaleDate      = pcsParameter.substr( 13, 8 ) ; 
		let csOrgTableCd    = pcsParameter.substr( 22, 3 ) ; 
		let csOrgOrderNo    = pcsParameter.substr( 26, 4 ) ; 
		let csTgtTableCd    = pcsParameter.substr( 31, 3 ) ; 
		let csTgtOrderNo    = pcsParameter.substr( 35, 4 ) ; 
		let csOrderEmpNm    = pcsParameter.substring( 40 ) ; 

		let snResult = 0;
		let param = {
				  ORG_TABLE_CD : csOrgTableCd 
				, TGT_TABLE_CD : csTgtTableCd
		};
		let sql = _sql.InsertPrintTableMenuMove_01_SQL( param );
		try {
			let row = this.db_get_single_row ( sql  , []);
			print.m_inDeliveryVersionFg = m_inDeliveryVersionFg;	// 2010-0310-YBC

			let stSale = {};

			stSale.SHOP_CD            = gShopCd;
			stSale.SALE_DATE          = csSaleDate;
			stSale.ORDER_NO           = csTgtOrderNo;
			stSale.POS_NO             = csPosNo;
			stSale.EMP_NM             = csOrderEmpNm ;
			stSale.TABLE_GROUP_NM	  = row[ "ORG_TG_NM"  ];
			stSale.TABLE_NM           = row[ "ORG_TBL_NM" ];
			stSale.TGT_TABLE_GROUP_NM = row[ "TGT_TG_NM"  ];
			stSale.TGT_TABLE_NM		  = row[ "TGT_TBL_NM" ];

			sql = _sql.InsertPrintTableMenuMove_02_SQL();

			row = {};// row 변수 초기화

			let csTitle	= "<< 메뉴 이동 >>" ; 
			let inKitPrtNo = 0;

			let rows = this.db_get_mumti_rows(s, []);
			for (let itx = 0; itx < rows.length; itx++) {
				let row = rows[itx];
				
				stSale.PRT_NO		= row[ "PRT_NO"       ];	// 프린터 번호
				stSale.ORDER_SEQ_NO	= row[ "ORDER_SEQ_NO" ];	// 주문출력차수.

				// /////////////////////////////////////////////////////////////////////////////
				// 2009-1021-YBC : 주방프린터명 타이틀에 추가.
				// /////////////////////////////////////////////////////////////////////////////
				inKitPrtNo = row[ "PRT_NO" ]/** .asShort__ * */;

				// 2010-0610-JJM : 주문서 출력일련번호.

				stSale.ORDER_PRINT_SEQ  = "%04d".sprintf( pu.parseInt ( row[ "ORDER_PRT_SEQ" ] ) + 1 );

				if( !pu.isEmpty( this.m_stPrtInfo[ inKitPrtNo ].PRT_NM )  ) {
					stSale.csTitle = "%s-%s".sprintf( csTitle, m_stPrtInfo[ inKitPrtNo ].PRT_NM );

				} else {
					stSale.TITLE = csTitle;
				}

				print.m_inPrtDataCnt = 0;

				csPrint = this.GetPrintData( stSale, "07", false /** FALSE * */ );	// 테이블
																					// 이동.

				// /////////////////////////////////////////////////////////////////////////////
				// 구성된 출력물 내역을 출력물관리 테이블에 INSERT.
				// /////////////////////////////////////////////////////////////////////////////
				this.PrintInsert( csSaleDate, csTgtOrderNo, stSale.PRT_NO, csPrint, "N", stSale.ORDER_PRINT_SEQ, stSale.ORDER_SEQ_NO );

			}
			return true;
		} catch (e) {
			util.logError("주방프린터 처리 오류 ! ")
			util.logError("InsertPrintTableMenuMove e ==> " + e );
			return false;
		}
	}
	/***************************************************************************
	 * 주방출력내용저장-시간대별출력포함 INPUT SHOP_CD VARCHAR(6), SALE_DATE VARCHAR(8),
	 * ORDER_NO VARCHAR(13), PRT_NO VARCHAR(2), CONTENTS VARCHAR(4000), PRINT_YN
	 * VARCHAR(1), ORDER_PRT_SEQ VARCHAR(4), ORDER_SEQ_NO VARCHAR(4), REPRINT_FG
	 * VARCHAR(1)) RETURNS R_TIME_PRINT INTEGER
	 **************************************************************************/
	this.SP_SCD_PRTDT_TO_TIME = function(params) {
		util.logInfo("*** SP_SCD_PRTDT_TO_TIME START ***");
		let R_TIME_PRINT = 0;
		let csSetVal = this.GetEnvXmlShopENV(534);
		let sql = _sql.SP_SCD_PRTDT_TO_TIME_01_SQL(params);
		let row = this.db_get_single_row(sql, []);
		let inCnt = row['CNT'];

		// --프린터포트를 변경하여 출력하는 사항 체크.
		if ( inCnt == 0 ) {
			/*
			 * SCD_PRTDT_T 테이블의 컬럼이(PRINT_SEQ) 32,000 Sequence인지 확인체크.
			 * 32,000을 넘지 않으면  false를 그렇지 않으면 true를 리턴한다.
			 */ 
			let bIsMax = this.SP_SCD_PRTDT_T_MAX();	  
			
			// -- 프린터포트 변경사항이 없으면 저장.
			this.SP_SCD_PRTDT_T_AUD( params, bIsMax );	// :SHOP_CD, :SALE_DATE,
														// :ORDER_NO, :PRT_NO,
														// :CONTENTS, :PRINT_YN,
														// :ORDER_PRT_SEQ,
														// :ORDER_SEQ_NO;
		}


		// -- 프린터포트 변경 또는 다른프린터로 추가 체크.
		let rows = this.db_get_mumti_rows(_sql.SP_SCD_PRTDT_TO_TIME_02_SQL(params), []);
		for (let itx = 0; itx < rows.length; itx++) {
			let row = rows[itx];
			let csDstPrtNo = row["DST_PRT_NO"];
			let csPrtFg =row["PRT_FG"];

			if ( !pu.isEmpty(  csDstPrtNo  )  ) {
				/** --변경 또는 추가 프린터 주문서 출력 일련번호. * */
				let sql3 = _sql.SP_SCD_PRTDT_TO_TIME_03_SQL(params);
				let row3 = this.db_get_single_row(sql3, []);
				let csOrderPrtSeq = row3["SEQ"];// 채번

				params["ORDER_PRT_SEQ"] = csOrderPrtSeq;

				// -- 다른프린터 추가.
				if ( csPrtFg == 1) {
					let bIsMax = this.SP_SCD_PRTDT_T_MAX();	// 32,000 Sequence인지 확인체크.  
					
					// -- 프린터포트 변경사항이 없으면 저장.
					this.SP_SCD_PRTDT_T_AUD( params, bIsMax );	// :SHOP_CD, :SALE_DATE,
																// :ORDER_NO, :PRT_NO,
																// :CONTENTS, :PRINT_YN,
																// :ORDER_PRT_SEQ,
																// :ORDER_SEQ_NO;
					R_TIME_PRINT = R_TIME_PRINT + 1;

				} else {
					// -- 프린터포트 변경.
					let sql_4 = _sql.SP_SCD_PRTDT_TO_TIME_04_SQL(params);
					let row_4 = this.db_get_single_row(sql_4, []);

					inCnt = row_4["CNT"];

					// -- 2010-0928-JJM : 메뉴별컷팅인경우 SKIP 안함.
					if ( csSetVal == '1') {
						let bIsMax = this.SP_SCD_PRTDT_T_MAX();	// 32,000 Sequence인지 확인체크.  
						
						// -- 프린터포트 변경사항이 없으면 저장.
						this.SP_SCD_PRTDT_T_AUD( params, bIsMax );	// :SHOP_CD, :SALE_DATE,
																	// :ORDER_NO, :PRT_NO,
																	// :CONTENTS, :PRINT_YN,
																	// :ORDER_PRT_SEQ,
																	// :ORDER_SEQ_NO;
						R_TIME_PRINT = R_TIME_PRINT + 1;
					} else {
						// -- 포트변경시 출력물이 존재하면 SKIP. 재발행인경우 SKIP 안함.
						if( inCnt == 0 || params.REPRINT_FG == '1') {
							let bIsMax = this.SP_SCD_PRTDT_T_MAX();	// 32,000 Sequence인지 확인체크.  
						
							this.SP_SCD_PRTDT_T_AUD( params, bIsMax ) ;	// :SHOP_CD,
																		// :SALE_DATE,
																		// :ORDER_NO,
																		// :PRT_NO,
																		// :CONTENTS,
																		// :PRINT_YN,
																		// :ORDER_PRT_SEQ,
																		// :ORDER_SEQ_NO;
	                        R_TIME_PRINT = R_TIME_PRINT + 1;
						}
					}
				}
			}
		}
		return R_TIME_PRINT;
	}

	/***************************************************************************
	 * 주방출력내용저장 SHOP_CD VARCHAR(6) SALE_DATE VARCHAR(8) ORDER_NO VARCHAR(13)
	 * PRT_NO VARCHAR(2) CONTENTS VARCHAR(4000) PRINT_YN VARCHAR(1)
	 * ORDER_PRT_SEQ VARCHAR(4) ORDER_SEQ_NO VARCHAR(4) return void
	 **************************************************************************/
	this.SP_SCD_PRTDT_T_MAX = function() 
	{

		let sql = _sql.SP_SCD_PRTDT_T_MAX_SQL();
		
		let db_result = gfn_SQLiteSQLProcess(sql , []);
		if( db_result.ResultCode != 0 ) 
		{
			let s = "주방프린터데이터 등록에 실패하였습니다.[%s]".sprintf( r.Message );
			util.logError("SP_SCD_PRTDT_T_AUD e ==> " + s );
			throw s;
		}
		else
		{

			let rows = db_result.Data;
			if( rows[0].MAX_SEQ > 32000 )
				return true;
		}
		
		return false;
	}
	
	this.SP_SCD_PRTDT_T_AUD = function(obj) {

		let sql = _sql.SP_SCD_PRTDT_T_AUD_SQL(obj);
		let r = gfn_SQLiteSQLProcess(sql , []);
		if ( r.ResultCode != 0 ) {
			let s = "주방프린터데이터 등록에 실패하였습니다.[%s]".sprintf(r.Message) ;
			util.logError("SP_SCD_PRTDT_T_AUD e ==> " + s );
			throw s;
		}
	}

	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : InsertPrintDataByOrderNo. :
	// =============================================================================
	// 주문번호에 의한 출력내용을 SELECT 한 다음 해당 프린터 기종에 맞는 코멘드를
	// 이용하여 출력내용물을 구성한 다음 줄력용테이블에 INSERT 한다.
	// =============================================================================
	// PARAMETER 1 : pcsSaleDate : 영업일자.
	// 2 : pcsOrderNo : 주문번호.
	// 3 : pcsReBillFg : 재발행구분자
	// 4 : pcsInOrderPosNo : 주문등록한 포스번호. 2010-0615-YBC
	// RETURN VALUE : boolean : .
	// PROGRAMMER : 2010-0615-YBC : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.InsertPrintDataByOrderNo = function ( pcsSaleDate, pcsOrderNo, pcsReBillFg, pcsPosNo, pcsRePrintFg, PrintDataByOrderNoCallback   ) {
		util.logInfo("*** InsertPrintDataByOrderNo START ***");
		let blFoodCourtYn = false /** FALSE * */ ; /** BOOL * */
		let blCornerDivYn = false /** FALSE * */ ; /** BOOL * */

		let csQrySql = "" ; 
		let csPrint  = "" ; 
		
		let snResult = 0 /** short * */;

		// //////////////////////////////////////////////////////////////////////////
	    // 2009-1118-YBC : CHG_BILL_NO, CORNER_NM 추가.
	    // 2010-0122-YBC : 코너별 주방주문서 분할출력 구분 적용 처리.
	    // 2010-1206-JJM : GetEnvXmlPosENV -> GetEnvXmlShopENV 변경.
	    // : 신년플러스 경희의료원 주방주문서 코너명/교환번호 출력 안되는 버그 수정.
		// //////////////////////////////////////////////////////////////////////////
		if( /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 101 ) ) == 4 ) {		// 외식업-푸드코트
			blFoodCourtYn = true /** TRUE * */;
		}

		if( /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 531 ) ) == 1 ) {		// 주방주문서
																					// 코너별
																					// 분할출력구분
																					// 0:미사용
																					// 1:사용
			blCornerDivYn = true /** TRUE * */;
		}

		// //////////////////////////////////////////////////////////////////////////
		// 2010-0615-YBC
		// 후불제 + 코너사용 + 교환권출력 으로 옵션이 설정된경우 일반주문시에는 상관없으나
		// 주문없이 즉시 결제처리하면서 주문서 출력하는 경우는 교환권번호가 채번됨으로 인해
		// 아래쪽 SQL 문장에서 교환권번호에 의한 GroupBY 때문에 중복출력되는 현상 방지.
		// //////////////////////////////////////////////////////////////////////////

		let inOrderPosType = 0;			// 2010-0615-YBC : 포스타입 0:선불제 1:후불제.
		let params = {};
		params.SALE_DATE = pcsSaleDate;
		params.ORDER_NO = pcsOrderNo;
		params.blChgBillNoUseFg = true /** TRUE * */ ; /** BOOL * */		// 교환권번호
																			// SQL
																			// 문장에서
																			// 사용여부.

		if( ! blFoodCourtYn  &&  ! blCornerDivYn ) {
			inOrderPosType = this.GetEnvXmlPosENV( 204 );

			if( inOrderPosType == 1 ) {
				params.blChgBillNoUseFg = false ; // 2010-0615-YBC : 포스타입
													// 0:선불제 1:후불제.
			}
		}
		
		
		
		let sql = "";
		// //////////////////////////////////////////////////////////////////////////
		// 외식푸드코트 또는 코너분할출력
		// //////////////////////////////////////////////////////////////////////////
		if( blFoodCourtYn ||  blCornerDivYn ) {
			// //////////////////////////////////////////////////////////////////////
			// 2010-1207-JJM : TR 저장전에 스레드가 돌아가므로 교환권 번호가 출력안되는 버그.
			// //////////////////////////////////////////////////////////////////////
			if( /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 152 ) ) > 0 ) {
				// Sleep( 1000 ); // 500 -> 1000 : 신년에서 주문서 빠지는 경우 발생.
			}

			sql = _sql.InsertPrintDataByOrderNo_01_true_SQL( params  );
			
		} else {
			sql = _sql.InsertPrintDataByOrderNo_01_false_SQL( params  );
		}

		try {
			// TODO ???????? 아래는 어떻게 ???? 2020.09.04
			// CPrint print;
			// print.m_inDeliveryVersionFg = m_inDeliveryVersionFg; //
			// 2010-0310-YBC


			let stSale = {};
			stSale.SHOP_CD   = gShopCd ;
			stSale.SALE_DATE = params.SALE_DATE;
			stSale.ORDER_NO  = params.ORDER_NO ;

			// 2016-1204 Antony.Choi : 프리오더가 아닌 경우 초기화 처리
			stSale.blPreOrderFg = false;


			// 2009-1118-YBC
			if( pcsReBillFg == "0" ) {
				stSale.RE_PRINT = false /** FALSE * */;
			}

			if( pcsReBillFg == "1" ) {
				stSale.RE_PRINT = true /** TRUE * */;
			}

			// 반품여부.
			stSale.blReturnSaleFg = false /** FALSE * */;

			if( pcsReBillFg == "2" ) {
				stSale.blReturnSaleFg = true /** TRUE * */;
				this.m_stSaleInfo.blReturnSaleFg = 1;
			}

			let csTitle      	= "" ; 	// 2009-1215-YBC
			let csLog           = "" ; 
			let csOrderPrintSeq = "" ; 

			let inKitPrtNo     = 0;
			let inKitBellUseFg = /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 115 ) );

			
			// 2010-0811-JJM : 버드나무 요청사항.
			// 메뉴주문시 T카-프린터는 해당 주문 포스만 출력되도록....
			let csPosNo = "" ; 
			let csPrtNo = "" ; 


			let rows = this.db_get_mumti_rows( sql, [] );
		
			if(!PrintDataByOrderNoCallback){ // 콜백이 없으면 동기식으로
				for ( let itx = 0 ; itx < rows.length ; itx++ ) {
					let row = rows[itx];

					stSale.POS_NO		    = row[ "POS_NO"       ];
					stSale.PRT_NO		    = row[ "PRT_NO"       ];	// 프린터 번호
					stSale.ORDER_SEQ_NO	    = row[ "ORDER_SEQ_NO" ];	// 주문출력차수.
					stSale.csTableGroupNm   = row[ "TG_NM"		  ];
					stSale.TABLE_NM	        = row[ "TABLE_NM"	  ];
					stSale.EMP_NM		    = row[ "EMP_NM"       ];
					stSale.KITCHEN_MEMO     = row[ "KITCHEN_MEMO" ];
					stSale.inFdGstCnt       = pu.parseInt( row[ "FD_GST_CNT_T" ] ) ;
					stSale.CORNER_CD	    = row[ "CORNER_CD"	  ];
					stSale.CORNER_NM	    = row[ "CORNER_NM"	  ];
					stSale.csChgBillNo	    = row[ "CHG_BILL_NO"  ];

					csOrderPrintSeq         = row[ "ORDER_PRT_SEQ"];	    // 2010-0610-JJM
																			// : 주문서
																			// 출력일련번호.
					stSale.ORDER_PRINT_SEQ  = "%-04d".sprintf( pu.parseInt ( csOrderPrintSeq ) + 1 );
			        stSale.DELIVERY_NO     = row[ "DELIVER_NO"   ];     // 2011-0413-JJM
																		// :
																		// 대기(페이저)번호
																		// 수기 사용.

					// /////////////////////////////////////////////////////////////////////////////
					// 2014-0916-Jane : 주문서 사용자 타이틀 추가.
					// /////////////////////////////////////////////////////////////////////////////
					let csTempTitle = this.GetUserTitle( "001") ; 

					if( csTempTitle != false /** TRUE * */ )  {
						csTitle = csTempTitle;
					} else {
						// /////////////////////////////////////////////////////////////////////////////
						// 2009-1215-YBC : 타이틀에 주문서구분 추가 : ORDER_SEQ
						// /////////////////////////////////////////////////////////////////////////////
						if( /** atoi * */ pu.parseInt ( stSale.ORDER_SEQ_NO ) == 1 ) {
							csTitle = "[◈신규-주방주문서]";
						} else {
							csTitle = "[▶추가-주방주문서]";
						}
					}

					// /////////////////////////////////////////////////////////////////////////////
					// 2009-1021-YBC : 주방프린터명 타이틀에 추가.
					// /////////////////////////////////////////////////////////////////////////////
					inKitPrtNo = pu.parseInt( row[ "PRT_NO" ] ) /** .asShort__ * */;


					if( !pu.isEmpty( m_stPrtInfo[ inKitPrtNo ] )  && !pu.isEmpty( m_stPrtInfo[inKitPrtNo].PRT_NM )  )	{
						stSale.TITLE =  "%s-%s".sprintf( csTitle, m_stPrtInfo[ inKitPrtNo ].PRT_NM );
					} else {
						stSale.TITLE = csTitle;
					}

					// /////////////////////////////////////////////////////////////////////////////
					// 2010-0218-YBC
					// print.m_inPrtDataCnt = 0;
					
					/*
					 * 2021. 05. 27 xbwing
					 * 여러개 음식을 주방에서 출력하기 위해 필요 정보를 설정한다.
					 */
					m_stPrtSubInfo.KIT_PRT_NO		= inKitPrtNo;
					m_stPrtSubInfo.ORDER_PRINT_SEQ	= stSale.ORDER_PRINT_SEQ;
					
					util.logInfo( "ORG-PrtInfo  		: " + m_stPrtInfo[ inKitPrtNo ] );
					util.logInfo( "ORG-KitPrtNo 		: " + inKitPrtNo );
					util.logInfo( "ORG-ORDER_PRINT_SEQ  : " + stSale.ORDER_PRINT_SEQ  );
			
					csPrint = this.GetPrintData( stSale, "04", false );
					
					// /////////////////////////////////////////////////////////////////////////////
					// 2009-1201-YBC : 주방벨 처리.
					// /////////////////////////////////////////////////////////////////////////////
					// 2010-0504-YBC
										
					if( !pu.isEmpty(csPrint) ) 
					{
						if( inKitBellUseFg )
							csPrint = pu.BASE_PRINT["BELL"] + csPrint;
						
						util.logInfo("*****InsertPrintDataByOrderN PrintDataByOrderNoCallback NO*****");
						// /////////////////////////////////////////////////////////////////////////////
						// 구성된 출력물 내역을 출력물관리 테이블에 INSERT.
						// /////////////////////////////////////////////////////////////////////////////
						this.makeKitchenPrintData( m_stPrtInfo[ inKitPrtNo ]  , csPrint  , stSale.ORDER_PRINT_SEQ , inKitPrtNo );//파일생성
						util.logInfo("*****InsertPrintDataByOrderN PrintDataByOrderNoCallback NO PrintInsert before*****");
						this.PrintInsert( pcsSaleDate, pcsOrderNo, stSale.PRT_NO, csPrint, "N", stSale.ORDER_PRINT_SEQ, stSale.ORDER_SEQ_NO, pcsRePrintFg );
					}
				
					// *pcsOrderSeqNo = stSale.ORDER_SEQ_NO;//TODO pcsOrderSeqNo 는
					// ...호출한곳에 변수로 받음.
				}// end for ( rows )
			}
			else // 콜백함수가 있으면 비동기 처리로 변경.
				printService.printInsetAsync( pcsSaleDate, pcsOrderNo, csPrint, "N", pcsRePrintFg, rows, rows.length, 0, stSale, PrintDataByOrderNoCallback );
			
						
			if(!PrintDataByOrderNoCallback)
			{ // 콜백이 없으면 동기식으로 리턴
				util.logInfo("*****InsertPrintDataByOrderN return START*****");
				return stSale.ORDER_SEQ_NO
			}
			
		} 
		catch (e) {
			util.logError("InsertPrintDataByOrderNo e ==> "+ e ) ;
			if(!PrintDataByOrderNoCallback){ // 콜백이 없으면 동기식으로 리턴
				util.logInfo("*****InsertPrintDataByOrderN return START*****");
				return false;
			}else{ // 콜백이 있으면 비동기로
				util.logInfo("*****InsertPrintDataByOrderN return Async START*****");
				PrintDataByOrderNoCallback(false);
			}
		}
	}
	
	// 주방 프린터 비동기일 때 함수.
	this.printInsetAsync = function(pcsSaleDate, pcsOrderNo, csPrint, paYn, pcsRePrintFg, rows, rowTotalCnt, itx, paStSale, PrintDataByOrderNoCallback){
		let row = rows[itx];
		var stSale = paStSale;
		let csTitle      	= "" ;
		let csLog           = "" ; 
		let csOrderPrintSeq = "" ; 
		let inKitBellUseFg = pu.parseInt ( this.GetEnvXmlShopENV( 115 ) );
		
		stSale.POS_NO		    = row[ "POS_NO"       ];
		stSale.PRT_NO		    = row[ "PRT_NO"       ];	// 프린터 번호
		stSale.ORDER_SEQ_NO	    = row[ "ORDER_SEQ_NO" ];	// 주문출력차수.
		stSale.csTableGroupNm   = row[ "TG_NM"		  ];
		stSale.TABLE_NM	        = row[ "TABLE_NM"	  ];
		stSale.EMP_NM		    = row[ "EMP_NM"       ];
		stSale.KITCHEN_MEMO     = row[ "KITCHEN_MEMO" ];
		stSale.inFdGstCnt       = pu.parseInt( row[ "FD_GST_CNT_T" ] ) ;
		stSale.CORNER_CD	    = row[ "CORNER_CD"	  ];
		stSale.CORNER_NM	    = row[ "CORNER_NM"	  ];
		stSale.csChgBillNo	    = row[ "CHG_BILL_NO"  ];

		csOrderPrintSeq         = row[ "ORDER_PRT_SEQ"];	    // 2010-0610-JJM
																// : 주문서
																// 출력일련번호.
		stSale.ORDER_PRINT_SEQ  = "%-04d".sprintf( pu.parseInt ( csOrderPrintSeq ) + 1 );
        stSale.DELIVERY_NO     = row[ "DELIVER_NO"   ];     // 2011-0413-JJM : 대기(페이저)번호 수기 사용.

		let inKitPrtNo     = 0;
		
		// /////////////////////////////////////////////////////////////////////////////
		// 2014-0916-Jane : 주문서 사용자 타이틀 추가.
		// /////////////////////////////////////////////////////////////////////////////
		let csTempTitle = this.GetUserTitle( "001");

		if( csTempTitle != false /** TRUE * */ )  {
			csTitle = csTempTitle;
		} else {
			// /////////////////////////////////////////////////////////////////////////////
			// 2009-1215-YBC : 타이틀에 주문서구분 추가 : ORDER_SEQ
			// /////////////////////////////////////////////////////////////////////////////
			if( /** atoi * */ pu.parseInt ( stSale.ORDER_SEQ_NO ) == 1 ) {
				csTitle = "[◈신규-주방주문서]";
			} else {
				csTitle = "[▶추가-주방주문서]";
			}
		}

		// /////////////////////////////////////////////////////////////////////////////
		// 2009-1021-YBC : 주방프린터명 타이틀에 추가.
		// /////////////////////////////////////////////////////////////////////////////
		inKitPrtNo =pu.parseInt( row[ "PRT_NO" ]) /** .asShort__ * */;


		if( !pu.isEmpty( m_stPrtInfo[ inKitPrtNo ] )  && !pu.isEmpty( m_stPrtInfo[inKitPrtNo].PRT_NM )  )	{
			stSale.TITLE =  "%s-%s".sprintf( csTitle, m_stPrtInfo[ inKitPrtNo ].PRT_NM );
		} else {
			stSale.TITLE = csTitle;
		}

		// /////////////////////////////////////////////////////////////////////////////
		// 2010-0218-YBC
		// print.m_inPrtDataCnt = 0;

		

		csPrint = this.GetPrintData( stSale, "04", false );


		// /////////////////////////////////////////////////////////////////////////////
		// 2009-1201-YBC : 주방벨 처리.
		// /////////////////////////////////////////////////////////////////////////////
		// 2010-0504-YBC
		if( !pu.isEmpty( csPrint ) &&  inKitBellUseFg ) {
			//csPrint += pu.BASE_PRINT["BELL"];
			//Hex 타입으로 넣을 경우 글자 깨짐 발생
			csPrint = "p?" +  csPrint;
		}
		
		printService.PrintInsert( pcsSaleDate, pcsOrderNo, stSale.PRT_NO, csPrint, paYn, stSale.ORDER_PRINT_SEQ, stSale.ORDER_SEQ_NO, pcsRePrintFg);
		this.makeKitchenPrintData( m_stPrtInfo[ inKitPrtNo ]  , csPrint  , stSale.ORDER_PRINT_SEQ , inKitPrtNo, function(){
			if(rowTotalCnt == itx+1){ // 마지막 인덱스면 끝
				util.logInfo("*****printInsetAsync Kitchen print for END*****");
				PrintDataByOrderNoCallback(stSale.ORDER_SEQ_NO);
				//printService.PrintInsert( pcsSaleDate, pcsOrderNo, stSale.PRT_NO, csPrint, paYn, stSale.ORDER_PRINT_SEQ, stSale.ORDER_SEQ_NO, pcsRePrintFg);
			}else{ // 마지막이 아니면 재귀함수로 자신을 호출
				util.logInfo("*****printInsetAsync Kitchen print for continue itx == > " + itx);
				printService.printInsetAsync( pcsSaleDate, pcsOrderNo, csPrint, paYn, pcsRePrintFg, rows, rowTotalCnt, itx+1, paStSale, PrintDataByOrderNoCallback );
			}
		})
			
	}
	/**************************************************
	 * 주방프린터 파일 생성
	 **************************************************/
	var listenerIdPrintK="";
	var goMakiKitchenCallback;
	this.makeKitchenPrintData = function( prtObj , contents , seq , inKitPrtNo, makeKitchenCallback) {
		util.logInfo('*** makeKitchenPrintData START kitchen 주방프린터 파일 출력 ***');
		goMakiKitchenCallback = makeKitchenCallback;
		let dirPath	= MAKE_FILE_PATH_HOME+ '/KitchenPrt' , localDate = moment().format("YYYYMMDDHHmmss")  , newFile;   
		let fileName = localDate+"_"+ seq + "_"+inKitPrtNo +  ".txt";
		///dev/ttyS
		try {
			let pinSpeedRateCd = this.SetDeviceSpeedRate( prtObj.csPrtSpeed );
			util.logInfo('kitchen 주방프린터 속도   :  ' + prtObj.csPrtSpeed + " [" + pinSpeedRateCd + "]");
			if ( pinSpeedRateCd == 0 ) {
				return ;
			}

			let prtPort = pu.parseInt( prtObj.csPrtPortNo );
			util.logInfo('kitchen 주방프린터 port number ' + prtObj.csPrtPortNo)
			if ( !Number.isInteger(prtPort)) {
				return;
			}
			
			let inPrtPaperCnt = prtObj.inPrtPaperCnt;
			util.logInfo('kitchen 주방프린터 출력 매수   :  ' + prtObj.inPrtPaperCnt); 
			if ( inPrtPaperCnt == 0 ) { // 주방프린트 출력 매수 
				inPrtPaperCnt = 1;
			}
			
			util.logDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!! encodeURIComponent before !!!!!!!!!!!!!!!!!!!!!!!!!\n" + contents);
			let dataObj = {
					  속도   : pinSpeedRateCd
					, 포트   : "/dev/ttyS" + prtPort /** tizen 에서 port 명칭 부분. **/ 
					, 출력물 : btoa(unescape(encodeURIComponent( contents )))
			};
			
			util.logInfo("kitchen : " + JSON.stringify(dataObj));
			util.logInfo('kitchen 주방프린터 데이터 \n' + JSON.stringify(dataObj) );
			
			if( util.isTizen() == true) {
				tizen.filesystem.resolve(dirPath, function(result) {
					util.logInfo("################### make kitchen print file  newFile Start #################");
					util.logInfo("### kitchen print text data >> " + JSON.stringify(dataObj));
					util.logInfo("### kitchen print fileName >> " + fileName);
					newFile = result.createFile(fileName);
					newFile.openStream(
							"rw",
							function(fs) {
								util.logInfo(" *****makeKitchenPrintData resolve function(fs) START*****");
								fs.write(JSON.stringify(dataObj));
								fs.close();
								let printDataPath = "/opt/usr/home/owner/content/Downloads/FirstKIOSK/ETC/KitchenPrt/" + fileName ;
								if(!makeKitchenCallback){ // 콜백이 없다면 동기식으로
									util.logInfo(" *****makeKitchenPrintData FDK_OrderPrint(Sync) START*****");
									let prtResult = nativeApp.functionCallSync(["FDK_OrderPrint", printDataPath, inPrtPaperCnt]);
									util.logInfo("kitchen 주방프린터 출력 결과 Sync : "+ prtResult + '\n make kitchen print file newFile : ' + newFile + "\nprintDataPath : " + printDataPath);
									util.logInfo('주방프린터 데이터 success '  );
									util.logInfo("/dev/ttyS" +  m_inBillPrtPortNo + "  > m_inBillPrtSpeedCd : "  +  m_inBillPrtSpeedCd);
									
								}else{ // 콜백이 있다면 비동기로
									
									util.logInfo(" *****makeKitchenPrintData FDK_KitchenAsyncPrint(Async) START*****");
									listenerIdPrintK = nativeApp.functionCallASync(["FDK_KitchenAsyncPrint", printDataPath, inPrtPaperCnt], kitchenAsyncPrintCallback);
									util.logInfo("***** listenerIdPrintK == > "+ listenerIdPrintK);
									function kitchenAsyncPrintCallback(callbackName, result){
										util.logInfo(" *****makeKitchenPrintData FDK_KitchenAsyncPrint(Async) CALLBACK START*****");
										nativeApp.removeASyncApiListener(callbackName, listenerIdPrintK); // 리더기 카드체크하는 리스너 해제함수.
										result = result.substring(0, result.lastIndexOf("$$^")); // Eof 이후 문자는 버린다 ($$^)
										var jsonResult = JSON.parse(result);
										util.logInfo("kitchen 주방프린터 출력 결과 Async : "+ result + '\n make kitchen print file newFile : ' + newFile + "\nprintDataPath : " + printDataPath);
										
										if(jsonResult["Code"] != 9){
											util.logError("_____주방프린터  출력 에러!_____");
										}else{
										
											util.logInfo('_____주방프린터 success!!_____');	
										}
										makeKitchenCallback(fileName);
									}
								}
								
							}, function(e) {
								util.logInfo('주방프린터 데이터 Error ' + JSON.stringify(e ));
							}, "UTF-8");

					util.logInfo("################### make kitchen print file  newFile End ##########" + newFile + " [" + newFile.toURI() + "]");
				}, function(e) {
					util.logInfo("### make kitchen print file resolve Error" + e.message);
				}, "rw" );
			}
			util.logInfo('kitchen 주방프린터 파일 출력 End : ' + fileName);
			return fileName;
		} catch (e) {
			util.logError('kitchen error 프린터 파일 생성 오류');
			util.logError("makeKitchenPrintData e ==> "+e);
		}
		
	}

	this.kitchenAsyncPrintCallback2 = function(callbackName, result){
		util.logInfo(" *****makeKitchenPrintData FDK_KitchenAsyncPrint(Async) CALLBACK START*****");
		nativeApp.removeASyncApiListener(callbackName, listenerIdPrintK); // 리더기 카드체크하는 리스너 해제함수.
		util.logInfo("kitchen 주방프린터 출력 결과 : "+ prtResult 
			+ '\n make kitchen print file newFile : ' + newFile
			+ "\nprintDataPath : " + printDataPath
		);
		result = result.substring(0, result.lastIndexOf("$$^")); // Eof 이후 문자는 버린다 ($$^)
		var jsonResult = JSON.parse(result);
		if(jsonResult["Code"] != 9){
			util.logError("_____주방프린터  출력 에러!_____");
		}else{
		
			util.logInfo('_____주방프린터 success!!_____');	
		}
		goMakiKitchenCallback();
	}
	
	this.SetDeviceSpeedRate = function( pinSpeedRateCd ) {
		let dwSpeedRate = 0;


		switch( pu.parseInt( pinSpeedRateCd ) ) {
			case 1   : dwSpeedRate   = 4800   ; break ;
			case 2   : dwSpeedRate   = 9600   ; break ;
			case 3   : dwSpeedRate   = 14400  ; break ;
			case 4   : dwSpeedRate   = 19200  ; break ;
			case 5   : dwSpeedRate   = 38400  ; break ;
			case 6   : dwSpeedRate   = 57600  ; break ;
			case 7   : dwSpeedRate   = 115200 ; break ;
			default  : dwSpeedRate   = 0      ; break ;
		}

		return dwSpeedRate;
	}
	this.GetUserTitle = function( pcsComCD ) {
		let csTitle = "";
		try {
			let sql = _sql.GetUserTitle_SQL( pcsComCD  );
			let rows = this.db_get_mumti_rows( sql,[] );
			
			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];
				csTitle = row[ "COM_CD_NM" ];
			}

			return csTitle;
		} catch (e) {
			util.logError("GetUserTitle e ==> " + e);
			return false;
		}
	}

		
	this.SendDataLink = function (obj, sendDataCallback){		
//debugger;
		util.logInfo('*** SendDataLink START ***');
		let printInitFg = this.SetKitchenPrinterInfo();
		if ( printInitFg == false ) {
			util.logError("주방프린터 초기화 실패");
			if(!sendDataCallback){
				return false;
			}else{
				sendDataCallback(false);
				return false;
			}
			
		}
		let blRetFg     = false /** FALSE * */ ; /** BOOL * */
		let blTblExchFg = false /** FALSE * */ ; /** BOOL * */

		let csPosNo      = "" ; 	// 2009-1009-YBC
		let csSaleDate   = "" ; 	// 2009-0924-YBC
		let csOrderNo	 = "" ; 
		let csOrderSeqNo = "" ; 	// 2010-0909-JJM : 주문차수.
		let csReBillFg   = "" ; 	// 재발행구분자 0:일반 1:재발행 2:취소발행.
		let csLog		 = "" ; 
		
		let params = {
				
		};

		let inProcTypeNo = 0;

		// //////////////////////////////////////////////////////////////////////////
		// 특정 주문번호에 의한 출력.
		// //////////////////////////////////////////////////////////////////////////
		util.logInfo('obj.pType.indexOf( "/PRINT" )' , obj.pType.indexOf( "/PRINT" )   );
		if( obj.pType.indexOf( "/PRINT" ) != -1 ) {
			inProcTypeNo = 1;
		}
		// //////////////////////////////////////////////////////////////////////////
		// 특정 출력번호에 의한 출력.
		// //////////////////////////////////////////////////////////////////////////
		else if( obj.pType.indexOf( "/REPRINT" ) != -1 ) {
			inProcTypeNo = 2;
		}
		// //////////////////////////////////////////////////////////////////////////
		// 전체 미출력건을 출력.
		// //////////////////////////////////////////////////////////////////////////
		else if( obj.pType.indexOf( "/PRINTALL" ) != -1 ) {
			inProcTypeNo = 3;
		}

		// //////////////////////////////////////////////////////////////////////////
		// 2011-0628-JJM : 다른 메세지인 경우 SKIP.
		// //////////////////////////////////////////////////////////////////////////
		else {
			if(!sendDataCallback){
				return false;
			}else{
				sendDataCallback(false);
				return false;
			}
		}

		// //////////////////////////////////////////////////////////////////////////
		// "01::/PRINT 20090924:0013:" //
		// //////////////////////////////////////////////////////////////////////////
		
		// //////////////////////////////////////////////////////////////////////
		// 특정 주문번호에 의한 프린터 출력처리. /PRINT 포스번호::영업일자:주문번호
		// //////////////////////////////////////////////////////////////////////
		if(pu.parseInt(inProcTypeNo) == 1){
			csPosNo    = obj.POS_NO    ;
			csSaleDate = obj.SALE_DATE ;
			csOrderNo  = obj.ORDER_NO  ;
			csReBillFg = obj.RE_BILL_FG ;
			
			//주문번호 자리 4자리 체크 부분 삭제 처리 - 20240115 , WDH
			if( pu.isEmpty ( csSaleDate ) || csSaleDate.length != 8 || pu.isEmpty( csOrderNo ) ) {
				util.logError( "/PRINT Parameter Error!");
				if(!sendDataCallback){
					return false;
				}else{
					sendDataCallback(false);
					return false;
				}
			}

			/*
			 * 2021. 5. 31 xbwing
			 * SALE_FG 값이 있다면 취소 처리 flag 처리한
			 */
			if( !util.isEmptyStr(obj.SALE_FG) )
				csReBillFg = 2;
		
			// //////////////////////////////////////////////////////////////////
			// 해당 주문번호를 이용해서 주문자료를 구한후 출력할 테이블에 Insert 처리한다.
			// //////////////////////////////////////////////////////////////////
			if(!sendDataCallback){ // 콜백이 없으면 동기식으로
				util.logInfo("*****SendDataLink Sync*****");
				blRetFg = this.InsertPrintDataByOrderNo( csSaleDate, csOrderNo, csReBillFg, csPosNo, csReBillFg );				
				if(  blRetFg == false ) {
						return false;
				}
				csOrderSeqNo = blRetFg;
				
				csPosNo = obj.POS_NO    ;

				// //////////////////////////////////////////////////////////////////////////
				// 위의 출력조건에 의한 프린터별 출력 요청.
				// 2010-0909-JJM : 주문차수 추가.
				// //////////////////////////////////////////////////////////////////////////
				this.SetMakePrtThreadByData( csPosNo, csSaleDate, inProcTypeNo, csOrderNo, csOrderSeqNo );

				return true /** TRUE * */;
				
			}else{ // 콜백이 있으면 비동기로
				util.logInfo("*****SendDataLink Async*****");
				this.InsertPrintDataByOrderNo( csSaleDate, csOrderNo, csReBillFg, csPosNo, csReBillFg, function(paBlRetFg){
					util.logInfo("*****SendDataLink Async InsertPrintDataByOrderNo Callback*****");
					blRetFg=paBlRetFg;
					if(  blRetFg == false ) {
						sendDataCallback(false);
						return false /** FALSE * */;
					}
					csOrderSeqNo = blRetFg;
					// //////////////////////////////////////////////////////////////////////////
					// 위의 출력조건에 의한 프린터별 출력 요청.
					// 2010-0909-JJM : 주문차수 추가.
					// //////////////////////////////////////////////////////////////////////////
					printService.SetMakePrtThreadByData( csPosNo, csSaleDate, inProcTypeNo, csOrderNo, csOrderSeqNo );
					sendDataCallback(true); // 콜백함수 호출
				} );
			}
			
		}else if(pu.parseInt(inProcTypeNo) == 2){
			csSaleDate = obj.SALE_DATE ;
			csOrderNo  = obj.ORDER_NO  ;
			//주문번호 자리 4자리 체크 부분 삭제 처리 - 20240115 , WDH
			if( pu.isEmpty ( csSaleDate ) || csSaleDate.length != 8 || pu.isEmpty( csOrderNo )) {
				if(!sendDataCallback){
					return false;
				}else{
					sendDataCallback(false);
					return false;
				}
				
			}
			
			csPosNo = obj.POS_NO    ;

			// //////////////////////////////////////////////////////////////////////////
			// 위의 출력조건에 의한 프린터별 출력 요청.
			// 2010-0909-JJM : 주문차수 추가.
			// //////////////////////////////////////////////////////////////////////////
			this.SetMakePrtThreadByData( csPosNo, csSaleDate, inProcTypeNo, csOrderNo, csOrderSeqNo );

			if(!sendDataCallback){
				return true;
			}else{
				sendDataCallback(false);
				return true;
			}
		}else if(pu.parseInt(inProcTypeNo) == 3){
			csPosNo = obj.POS_NO    ;
			
			// //////////////////////////////////////////////////////////////////////////
			// 위의 출력조건에 의한 프린터별 출력 요청.
			// 2010-0909-JJM : 주문차수 추가.
			// //////////////////////////////////////////////////////////////////////////
			this.SetMakePrtThreadByData( csPosNo, csSaleDate, inProcTypeNo, csOrderNo, csOrderSeqNo );

			if(!sendDataCallback){
				return true;
			}else{
				sendDataCallback(false);
				return true;
			}
		}

	}

	// /////////////////////////////////////////////////////////////////////////////
	// FUNCTION Doc : SetMakePrtThreadByData.
	// =============================================================================
	// 해당 조건에 의한 출력대상 프린터번호를 구해서 개별 Thread 처리 요청.
	// =============================================================================
	// PARAMETER 1 : pcsPosNo : 출력요청 포스번호
	// 2 : pcsSaleDate : 영업일자.
	// 3 : pinProcTypeNo : 출력조건.
	// 4 : pcsOrderNo : 주문번호 or 출력번호
	// RETURN VALUE : BOOL : .
	// PROGRAMMER : 2009-0917-YBC : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.SetMakePrtThreadByData = function( pcsPosNo, pcsSaleDate, pinProcTypeNo, pcsOrderNo, pcsOrderSeqNo ){
		util.logInfo("***** SetMakePrtThreadByData START *****");
		util.logInfo("***** SetMakePrtThreadByData PARAM :: pcsPosNo =>" + pcsPosNo + " pcsSaleDate =>" + pcsSaleDate +" pinProcTypeNo =>" + pinProcTypeNo + "pcsOrderNo =>" + pcsOrderNo +" pcsOrderSeqNo =>" + pcsOrderSeqNo);
		let csPrtNo = "";
		let params = {};
		params.ORDER_NO     = pcsOrderNo    ;
		params.ORDER_SEQ_NO = pcsOrderSeqNo ;
		params.POS_NO       = pcsPosNo      ;
		params.SALE_DATE    = pcsSaleDate   ;
		

		// //////////////////////////////////////////////////////////////////////////
		// 해당 조건에 의한 출력대상 프린터 번호를 구한다.
		// //////////////////////////////////////////////////////////////////////////
		try {
			let sql = _sql.SetMakePrtThreadByData_SQL(  params , pinProcTypeNo  );
			let rows = this.db_get_mumti_rows( sql,[] );

			let csParameter = "" ; 		// 2010-0406-YBC
			let csLog       = "" ; 		// 2010-0406-YBC

			let inQueuePushCnt = 0;				// 2010-0406-YBC

			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];

				csPrtNo = row[ "PRT_NO" ];

				// /////////////////////////////////////////////////////////////////////////////
				// 동시 출력요청때문에 Thread 에서 받아서 처리할 값을 QUEUE 에 Push 한다.
				// /////////////////////////////////////////////////////////////////////////////
				csParameter =  "%s:%d:%s:%s:%s:%s".sprintf( csPrtNo, pinProcTypeNo, pcsSaleDate, pcsOrderNo, pcsPosNo, pcsOrderSeqNo );	// 2010-0909-JJM
																																		// :
																																		// 주문차수.
				// TODO m_PrtParamQueue.Push( csParameter );

				// //////////////////////////////////////////////////////////////////////
				// 2010-0406-YBC
				// //////////////////////////////////////////////////////////////////////
				csLog = "Print Queue Push - %s".sprintf( csParameter );	// 2010-0406-YBC
				util.logInfo(csLog);
				inQueuePushCnt ++;

			}
			if( inQueuePushCnt < 1 ) {
				util.logInfo("Print By Other PrinterDaemon");
			}

			return true;

		} catch (e) {
			util.logError("SetMakePrtThreadByData e ==> " + e);
			return false;
		}
	}

	// //////////////////////////////////////////////////////////////////////////////
	// 2012-0110-JJM : 주문서-메뉴목록, 주문서-메뉴목록-금액.
	// //////////////////////////////////////////////////////////////////////////////
	this.GetPresentOrderList = function  (pinPrtNo , pcsCode) {
		let blZeroUprcProdNoPrintFg = /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 554 ) ) ; /** BOOL * */

		let csDlvPackFg  = "" ; 
		let csQuery      = "" ; 
		let csPriceMgrYn = "" ; 
		let csPrint      = "" ; 
		let csProdCd     = "" ; 
		let csProdLine   = "" ; 
		let csProdNm     = "" ; 
		let csSaleAmt    = "" ; 
		let csSaleQty    = "" ; 
		let csSdaNm      = "" ; 
		let csSideMenu   = "" ; 
		let csStatus     = "" ; 
		let csValue      = "" ; 

		let	inCnt     = 0;
		let inSaleQty = 0;

		let inPriceMgrSaleAmtPrintYN = /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 582 ) );
		try {
			
			let sql = _sql.GetPresentOrderList_SQL( this.m_stSaleInfo );
			let rows = this.db_get_mumti_rows( sql,[] );		
			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];
				
				csSideMenu = ""
				csStatus   = ""
				csSaleQty  = ""
						
				if( blZeroUprcProdNoPrintFg ) {
					if(  pu.parseInt( row[ "UPRC" ] ) /** .asLong__ * */ == 0 ) {
						continue;
					}
				}

				if( pcsCode == "{주문서-메뉴목록}" ) {
					if( inCnt == 0 ) {
						if( this.g_inPaperTypeFg == 0 ) {
							csPrint += " 상 품 명            수량   구분";				// 2014-0917-Jane
																				// :
																				// 메뉴->상품
							csPrint += g_clsPrinter[ pinPrtNo ][ "FEED" ];
							csPrint += "--------------------------------";
						}
						else {
							csPrint += "    상  품  명                 수량   구분";	// 2014-0917-Jane
																				// :
																				// 메뉴->상품
							csPrint += g_clsPrinter[ pinPrtNo ][ "FEED" ];
							csPrint += "------------------------------------------";
						}
					}

					if(  row[ "ORDER_CNT" ]/** .asShort__ * */ == 1 ) {
						csStatus = "신규";
					}
					else {
						csStatus = "추가";
					}

					inSaleQty =  row[ "QTY" ]/** .asShort__ * */;

					if( this.m_stSaleInfo.blReturnSaleFg == 1 && inSaleQty > 0 ) { // 2013-08-01
																					// Antony
																					// Choi:
																					// 반품여부에
																					// 따른
																					// 수량
																					// 처리.
						inSaleQty *= -1;
					}

					csSaleQty /** .For_mat * */ = ( "%d"
									, inSaleQty );

					csProdCd = row[ "PROD_CD" ];
					csProdNm	 = row[ "PROD_NM"      ];
					if( row[ "SIDE_MENU_YN" ] == "N"  &&   row[ "SDS_ORG_DTL_NO" ]/** .asShort__ * */ > 0 ) {
						if( csProdCd.substr( 0 ,   1 /** LEN_DEF_1 * */ ) == "A" ) { // SIDE
																					// 속성
							csSideMenu = "▷";
							csStatus   = "속성";
						}
						else {
							if(!!csProdNm && csProdNm.substr(0,1) != '▶'){
								csSideMenu = "▶";
							}
							csStatus   = "선택";
						}
					}

					if( inSaleQty < 0 )	{
						csStatus = "취소";
					}

					
					csPriceMgrYn = row[ "PRICE_MGR_YN" ];
					csSdaNm		 = row[ "SDA_NM"       ];	// 사이드메뉴 속성명 출력 처리.
					csDlvPackFg  = row[ "DLV_PACK_FG"  ];	// 배달포장구분.

					if( csDlvPackFg == "2" ) {
						csStatus = "포장"; // 포장마크
					}
					else if( csDlvPackFg == "1" ) {
						csStatus = "배달"; // 배달마크
					}

					if( this.g_inPaperTypeFg == 0 ) {
						if( !pu.isEmpty( csSdaNm ) ) {
							csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 14 ), 14 );
						} else {
							csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csProdNm, 20 ), 20 );
						}

					} else {
						if( !pu.isEmpty( csSdaNm )  ) {
							csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 22 ), 22 );
						} else {
							csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csProdNm, 30 ), 30 );
						}
					}
					// 2016-1128 Antony.Choi : 싯기 상품일 경우 582번 옵션이 사용 일 경우에만 출력함.
					if( csPriceMgrYn == "Y" && inPriceMgrSaleAmtPrintYN == 1 ) {		// 싯가상품.
						csSaleAmt = util.numberWithCommas( row[ "SALE_AMT" ] );
						csProdNm  = pu.DllGetCutHangul( csProdNm, csProdNm.getByteLength() - csSaleAmt.length - 2 ) + "(" + csSaleAmt + ")";
					}

					if( !pu.isEmpty ( csSdaNm ) ) {
						csProdLine += csProdNm ;
						csProdLine += "[";
						csProdLine += pu.RPad( pu.DllGetCutHangul( csSdaNm, 6 ), 6 );
						csProdLine += "]";
					} else {
						csProdLine = csProdNm;
					}

					csPrint += g_clsPrinter[ pinPrtNo ][ "FEED" ];
					csPrint += csProdLine;
					csPrint += pu.LPad( util.numberWithCommas( csSaleQty ) , 5 );
					csPrint += pu.LPad( csStatus                           , 7 );

				} 	else if( pcsCode == "{주문서-메뉴목록-금액}" ) {
						if( inCnt == 0 ) {
							if( this.g_inPaperTypeFg == 0 ) {
								csPrint += " 상 품 명     수량     금액 구분";			// 2014-0917-Jane
																				// :
																				// 메뉴->상품
								csPrint += g_clsPrinter[ pinPrtNo ][ "FEED" ] ;
								csPrint += "--------------------------------";
							} else {
								csPrint += "    상  품  명          수량     금액 구분";	// 2014-0917-Jane
																				// :
																				// 메뉴->상품
								csPrint += g_clsPrinter[ pinPrtNo ][ "FEED" ];
								csPrint += "------------------------------------------";
							}
						}

						if(  row[ "ORDER_CNT" ]/** .asShort__ * */ == 1 ) {
							csStatus = "신규";
						} else  {
							csStatus = "추가";
						}

						inSaleQty = row[ "QTY" ]/** .asShort__ * */;

						if( this.m_stSaleInfo.blReturnSaleFg == 1 && inSaleQty > 0 ) // 2013-08-01
																						// Antony
																						// Choi:
																						// 반품여부에
																						// 따른
																						// 수량
																						// 처리.
						{
							inSaleQty *= -1;
						}

						csSaleQty  = "%d".sprintf( inSaleQty );

						csProdCd = row[ "PROD_CD" ];
						csProdNm	 = row[ "PROD_NM"      ];
						if( row[ "SIDE_MENU_YN" ] == "N" && row[ "SDS_ORG_DTL_NO" ]/** .asShort__ * */ > 0 )  {
							if( csProdCd.substr( 0 ,   1 /** LEN_DEF_1 * */ ) == "A" ) // SIDE
																						// 속성
							{
								csSideMenu = "▷";
								csStatus   = "속성";
							} else {
								if(!!csProdNm && csProdNm.substr(0,1) != '▶'){
									csSideMenu = "▶";
								}
								csStatus   = "선택";
							}
						}

						if( inSaleQty < 0 ) {
							csStatus = "취소";
						}

						
						csPriceMgrYn = row[ "PRICE_MGR_YN" ];
						csSdaNm		 = row[ "SDA_NM"       ];	// 사이드메뉴 속성명 출력
																// 처리.

						csDlvPackFg  = row[ "DLV_PACK_FG"  ];	// 배달포장구분.

						if( csDlvPackFg == "2" ) {
							csStatus = "포장"; // 포장마크
						} else if( csDlvPackFg == "1" ) {
							csStatus = "배달"; // 배달마크
						}

						if( this.g_inPaperTypeFg == 0 ) {
							if( !pu.isEmpty( csSdaNm ) ) {
								csProdLine =  "%-10s[%-6s]".sprintf( pu.DllGetCutHangul( csProdNm, 10 )
												 , pu.DllGetCutHangul( csSdaNm,  6 ) );
							} else {
								csProdLine = "%-14s".sprintf(  pu.DllGetCutHangul( csSideMenu + csProdNm, 16 ) );
							}

							csValue  = ( "%-16s %3s%7s%5s").sprintf( csProdLine
										  , util.numberWithCommas( csSaleQty )
										  , util.numberWithCommas( row[ "SALE_AMT" ] )
										  , csStatus );
						} else {
							if( !pu.isEmpty( csSdaNm) )  {
								csProdLine  =  "%-15s[%-6s]".sprintf(  pu.DllGetCutHangul( csProdNm, 15 ) , pu.DllGetCutHangul( csSdaNm,  6  ) );
							} else {
								csProdLine =   "%-23s".sprintf(  pu.DllGetCutHangul( csSideMenu + csProdNm, 23 ) );
							}

							csValue  =  "%-23s%5s%9s%5s".sprintf( csProdLine
										  , util.numberWithCommas( csSaleQty )
										  , util.numberWithCommas( row[ "SALE_AMT" ] )
										  , csStatus );
						}

						csPrint += g_clsPrinter[ pinPrtNo ]["FEED"];
						csPrint += csValue;
						
						//상품명이 길때 2줄로 표시하기, 특정매장만 적용
						if(this.g_inPaperTypeFg > 0){
							var tempCsProdNm;
							var cutProdNm;
							var tempCsProdLine;
							
							//util.logInfo("csProdNm >>> " + csProdNm);
							//util.logInfo("csSideMenu >>> " + csSideMenu);
							if( !pu.isEmpty( csSdaNm) )  {
								tempCsProdLine = "%-15s[%-6s]".sprintf(csProdNm, csSdaNm);
								//util.logInfo("tempCsProdLine11 >>> " + tempCsProdLine);
								if(util.getTextLength(tempCsProdLine) > 23){
									tempCsProdNm  =  pu.DllGetCutHangul( csProdNm, 15 );
									//util.logInfo("tempCsProdNm11 >>> " + tempCsProdNm);
									cutProdNm = csProdNm.replace(tempCsProdNm, "");
									//util.logInfo("cutProdNm >>> " + cutProdNm);
									csPrint += pu.RPad(pu.DllGetCutHangul(cutProdNm, 42), 42);
								}
							} else {
								tempCsProdLine = "%-23s".sprintf(csSideMenu + csProdNm);
								//util.logInfo("tempCsProdLine22 >>> " + tempCsProdLine);
								if(util.getTextLength(tempCsProdLine) > 23){
									if(csSideMenu != "") tempCsProdNm = pu.DllGetCutHangul( csProdNm, 21 );
									else tempCsProdNm = pu.DllGetCutHangul( csProdNm, 23 );
									//util.logInfo("tempCsProdNm22 >>> " + tempCsProdNm);
									cutProdNm = csProdNm.replace(tempCsProdNm, "");
									//util.logInfo("cutProdNm >>> " + cutProdNm);
									csPrint += pu.RPad(pu.DllGetCutHangul(cutProdNm, 42), 42);
								}
							}
						}
						
				}

				inCnt++;

			}// end for rows

		} catch (e) {
			util.logError(e);
			return "";
		}
		return csPrint;
	}

	this.GetFloorPosCheck = function(pcsPosNo , pcsPrtNo  ){
		let pcsFloorNo = "";
		try {
			let sql = _sql.GetFloorPosCheck_SQL( pcsPosNo, pcsPrtNo  );
			let rows = this.db_get_mumti_rows( sql,[] );

			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];
				pcsFloorNo = row[ "FLOOR_NO" ];
			}
		} catch (e) {
			util.logError(e);
		}

		return pcsFloorNo;
	}

	// 2010-0816-JJM : 층별주프린터체크.
	this.GetFloorPrtFgCheck = function(pcsPrtNo) {
		let lnPrtCnt ="";
		try {
			let sql = _sql.GetFloorPrtFgCheck_SQL( pcsPrtNo  );
			let rows = this.db_get_mumti_rows( sql,[] );
			
			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];
				lnPrtCnt = pu.parseInt(row[ "PRTCNT" ])  + "";;

			}
		} catch (e) {
			return "";
		}
		return lnPrtCnt;
	}
	this.code_len = function(keyName ) {
		let val = "";
		try {
			let sql = _sql.code_len_SQL();
			let rows = this.db_get_mumti_rows( sql,[] );
			
			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];
				if ( row["CODE_LEN_NM"] == keyName) {
					val = row["CODE_LEN"];
					break;
				}
			}
		} catch (e) {
			util.logError(e);
		}
		return val;
	}
	// /////////////////////////////////////////////////////////////////////////////
	// 주방프린터 전용
	// FUNCTION Doc : GetProductListData(기존에 GetProductListData 있지만 주방프린터의 경우
	// 소스가 달라서
	// GetProductListData_04 로 별도로 처리함.
	// =============================================================================
	// PARAMETER 1 : pcsCode : .
	// PARAMETER 2 : pblSales : .
	// RETURN VALUE :  : .
	// PROGRAMMER : CWS-2009-02-18 : New.
	// /////////////////////////////////////////////////////////////////////////////
	this.GetProductListData_04 = function(pcsCode , pblSales ) {
		let bCnt = 0 ; /** byte * */
		let csTemp	    = "" ; 
		let csCode	    = "" ; 
		let csDblFg     = "" ;   // 2016-09-27-JYL [곱빼기]
		let csProdNm    = "" ;
		let csDcAmt     = "" ; 
		let csStatus	= "" ; 
		let csSideMenu  = "" ; 

		// 2016-1202 Anotny.Choi : 임시 ( 조회 시 데이터 없음 증상 수정 )
		// g_clsUtil.DllSetDelay( 0.3 );

		let inProdCdLen  = pu.parseInt( this.code_len( "PROD_CD_LEN"  ) );
		let inProdNmLen  = 0;
// let inEnvShop539 = pu.parseInt ( this.GetEnvXmlShopENV( 539 ) );
// let inEnv659 = pu.parseInt ( this.GetEnvXmlShopENV( 659 ) );
// let inEnv688 = pu.parseInt ( this.GetEnvXmlShopENV( 688 ) ); //
// 2019-08-20-SHK [메뉴출력형태2-상품명길이]
// let inEnv584 = pu.parseInt ( this.GetEnvXmlShopENV( 584 ) );
// let inEnv101 = pu.parseInt ( this.GetEnvXmlShopENV( 101 ) );
		let inIndexOfQty =  12 /** LEN_D_EF_12 * */;										// 2019-08-20-SHK
																						// [메뉴출력형태2-상품명길이]
		// 2018-0615-HJH 상품별/테이블별 신규/추가 구분자
		let SHOP_ENV = {
				  539 : this.GetEnvXmlShopENV( 539 ) 
				, 659 : this.GetEnvXmlShopENV( 659 ) 
				, 688 : (m_gbIs688 == true ? this.GetEnvXmlShopENV( 688 ) : false) 
				, 584 : this.GetEnvXmlShopENV( 584 ) 
				, 101 : this.GetEnvXmlShopENV( 101 ) 
				, 682 : this.GetEnvXmlShopENV( 682 ) 


		}
		let sql = _sql.GetProductListData_04_SQL( this.m_stSaleInfo , pcsCode, pblSales, SHOP_ENV , m_csOrderDtlNo );
		try {
			let    	blSideAttrPrt   = false /** FALSE * */ ; /** BOOL * */

			let    	csSdaNm		   	= "" ; 
			let    	csProdLine	   	= "" ; 
			let    	csPriceMgrYn    = "" ; 
			let    	csSaleAmt       = "" ; 
			let    	csDlvPackFg     = "" ; 
			let    	csSaleQty       = "" ; 
			let    	csSetProdFg     = "" ; 
			let    	csProdCd        = "" ; 
			let    	csSideMenuYn    = "" ; 
			let    	csCoursePrintFg = this.GetEnvXmlShopENV( 510 ) ; 
			let    	csCutProdNm     = "" ; 
			let		csFloorPrtYn    = "" ; 
			let    	csPosPrtYn      = "" ; 
			let    	csCookMemo      = "" ; 
			let    	csValue         = "" ; 

			let		lnSaleAmt       = 0;

			let     inSaleQty       = 0;
			let     inSdsOrgDtlNo   = 0;

			let 	csSdaCd         = "" ; 
			let 	csFoorNo        = "" ; 

			let 	m_inPrtDataCnt 	= 0;
			
			// 2021.10.26 xbwing - 도트 선 그리기 위한 boolean 변수
			let		bInitDotLine	= false;

			let rows = this.db_get_mumti_rows( sql,[] );
			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];
				{
					if( this.GetEnvXmlShopENV( 539 ) == 1 )	{
						csFloorPrtYn = row[ "FLOOR_PRT_YN" ];
						csPosPrtYn   = row[ "POS_PRT_YN"   ];
						csProdCd     = row[ "PROD_CD"      ];
						// /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
						// 2013-1028 Antnoy Choi : 층별 체크 후 해당 프린터가 실제로 존재 하는지
						// 체크함.
						// /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
						let x = this.GetFloorPrtFgCheck( this.m_stSaleInfo.PRT_NO);
						if( pu.isEmpty(x) ) {
							util.logInfo("해당 프린터 존재 하지 않음");
							continue;
						}

						csFoorNo = this.GetFloorPosCheck( this.m_stSaleInfo.POS_NO, this.m_stSaleInfo.PRT_NO  ); 
						if( pu.isEmpty( csFoorNo ) && csFloorPrtYn == "Y" )	{
							util.logInfo("해당 POS 존재 하지 않음");
							continue;
						}
						// /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
					}

					csSideMenu = "";
					csSaleQty  = "";

					inSaleQty = 0;
					if( pcsCode == "{주문서-메뉴출력형태1}" ||  pcsCode == "{주문서-메뉴출력형태3}" ) {
						if( bCnt == 0 )	{
							if( this.g_inPaperTypeFg == 0 ) {
								if( pcsCode == "{주문서-메뉴출력형태1}" ) {
									csTemp += " 상 품 명            수량   구분\r\n";	// 2014-0917-Jane
																				// :
																				// 메뉴->상품
								} else {
									csTemp += " 상 품 명                 수량  \r\n";	// 2014-0917-Jane
																					// :
																					// 메뉴->상품
								}
								csTemp += "--------------------------------";
							}
							else {
								if( pcsCode == "{주문서-메뉴출력형태1}" ) {
									csTemp += "    상  품  명                 수량   구분\r\n";		// 2014-0917-Jane
																								// :
																								// 메뉴->상품
								} else {
									csTemp += "    상  품  명                      수량  \r\n";		// 2014-0917-Jane
																								// :
																								// 메뉴->상품
								}
								csTemp += "------------------------------------------";
							}
						}

						csStatus = ""; // 2010-1208-YBC : 초기화가 없어서 지속출력됨.
						// 2021. 10. 26 xbwing - 속성 마지막 위에 Dot line를 그리기 위한 플래그.
						if( SHOP_ENV[688] == 1 && itx > 0 )
							bInitDotLine =  true;
						
						if( pcsCode == "{주문서-메뉴출력형태1}" ) {
							if( row[ "ORDER_CNT" ]/** .asShort__ * */ == 1 ) {
								csStatus = "신규";
							}
							else {
								csStatus = "추가";
							}
						}

						// 2009-1118-YBC
						inSaleQty = row[ "QTY" ]/** .asShort__ * */;

						// 2010-0504-YBC : 메뉴수량별 컷팅의 경우 수량을 1로 변경한다.
						if( this.m_inSpectialPrintFg == 2 ) {
							if( inSaleQty > 0 ) {
								inSaleQty = 1;
							}
							else {
								inSaleQty = -1;
							}
						}
						
						//반품아닐때 *1, 반품일경우 *-1,
						var takeBack = 1;
						if( this.m_stSaleInfo.blReturnSaleFg && inSaleQty > 0 ) {	// 2013-08-01
																					// Antony
																					// Choi:
																					// 반품여부에
																					// 따른
																					// 수량
																					// 처리.
							inSaleQty *= -1;
							takeBack = -1;
						}

						csSaleQty /** .For_mat * */ = ( "%d"
										, inSaleQty );

						// 2010-0212-YBC
						// 2009-1229-YBC : 코스내역출력여부 && 세트상품구분 0:일반 1:세트 2:코스
						csProdCd     = row[ "PROD_CD"      ];
						csSideMenuYn = row[ "SIDE_MENU_YN" ];
						inSdsOrgDtlNo = row[ "SDS_ORG_DTL_NO" ]/** .asShort__ * */;

						if( csSideMenuYn == "Y" ) {
							blSideAttrPrt = true /** TRUE * */;
						}

						if( csSideMenuYn == "N"
						&&  inSdsOrgDtlNo == 0 ) {
							blSideAttrPrt = false /** FALSE * */;
						}
						csSdaCd	= row[ "SDA_CD" ];
						if( csSideMenuYn == "N"
						&&  inSdsOrgDtlNo > 0 ) {
							if( csProdCd.substr( 0 ,   1 /** LEN_DEF_1 * */ ) == "A" ) { // SIDE
																						// 속성
								csSideMenu = "▷";
								csStatus   = "속성";	
							}
							else {
								csSideMenu = "▶";
								csStatus   = "선택";
							}
							
							// 2021. 10. 26 xbwing - 속성 마지막 위에 Dot line를 그리기 위한 플래그.
							if( SHOP_ENV[688] == 1 && itx > 0 )
								bInitDotLine  = false;
						}

						if( inSaleQty < 0 )	{
							if( pcsCode == "{주문서-메뉴출력형태1}" ) {
								csStatus = "취소";
							}
							else {
								csStatus = "";
							}
						}

						csDblFg      = row[ "PROP_CD"       ];                          // 2016-09-27-JYL
																						// [곱빼기]
						csProdNm	 = row[ "PROD_NM"      ];
						// ----------------------------------------------------------------
						// 2017-11-22-BGM [곱빼기_구문표기_수정건] : 상품명 앞에 곱 안찍히는 오류 수정
						csProdNm     = this.GetProdNmDbl( csProdNm, (/** atoi * */ pu.parseInt (csDblFg) == 1 ? true /** TRUE * */ :false /** FALSE * */ ) );  // 2016-09-27-JYL
																																							// [곱빼기]
						// 2017-11-22-BGM [곱빼기_구문표기_수정건] : 상품명 앞에 곱 안찍히는 오류 수정
						// ----------------------------------------------------------------

						csPriceMgrYn = row[ "PRICE_MGR_YN" ];
						csSdaNm		 = row[ "SDA_NM"       ];	// 사이드메뉴 속성명 출력
																// 처리.
						csDlvPackFg  = row[ "DLV_PACK_FG"  ];	// 배달포장구분.

						// 2009-1229-YBC : 사이드메뉴여부에서 "Y" 인 경우에만 사이드속성명을 출력한다.
						if( csSideMenuYn == "N" && this.m_stSaleInfo.blPreOrderFg != true /** TRUE * */ )  {
							csSdaNm = "";
						}

						if( csDlvPackFg == "2" ) {
							// 포장마크
							if( pcsCode == "{주문서-메뉴출력형태1}" ) {
								csStatus = "포장";
							}
							else {
								csStatus = "ⓟ"; // p
							}
						}
						else if( csDlvPackFg == "1" ) {
							// 배달마크
							if( pcsCode == "{주문서-메뉴출력형태1}" ) {
								csStatus = "배달";
							}
							else {
								csStatus = "ⓓ"; // d
							}
						}

						if( this.g_inPaperTypeFg == 0 ) {
							if( util.byteLen( csSdaNm )  > 0 ) {
								if ( this.m_stSaleInfo.blPreOrderFg == true  ) {
									if( pcsCode == "{주문서-메뉴출력형태1}" ) {
										csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csSdaNm, 20 ), 20 );
									}else{
										csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csSdaNm, 25 ), 25 );
									}
								}else {
									csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 14 ), 14 );
								}

							} else {
								if( pcsCode == "{주문서-메뉴출력형태1}" ) {
									csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csProdNm, 20 ), 20 );
								}
								else {
									csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csProdNm, 25 ), 25 );
								}
							}
						} else {
							if( !pu.isEmpty( csSdaNm ) ) {
								if ( this.m_stSaleInfo.blPreOrderFg == true /** TRUE * */ ) {
									if( pcsCode == "{주문서-메뉴출력형태1}" ) {
										csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csSdaNm,  30 ), 30 );
									}else{
										csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csSdaNm,  35 ), 35 );
									}

								} else {
									csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm,              22 ), 22 );
								}
							} else {
								if( pcsCode == "{주문서-메뉴출력형태1}" ) {
									csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csProdNm, 30 ), 30 );
								}
								else {
									csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csProdNm, 35 ), 35 );
								}
							}
						}

						// 2016-1128 Antony.Choi : 싯기 상품일 경우 582번 옵션이 사용 일 경우에만
						// 출력함.
						if( csPriceMgrYn == "Y" && inPriceMgrSaleAmtPrintYN == 1 ) {		// 싯가상품.
							csSaleAmt = util.numberWithCommas( row[ "SALE_AMT" ] );
							csProdNm  = pu.DllGetCutHangul( csProdNm, csProdNm.getByteLength() - csSaleAmt.length - 2 ) + "(" + csSaleAmt + ")";
						}

						if( !pu.isEmpty( csSdaNm ) && this.m_stSaleInfo.blPreOrderFg != true /** TRUE * */) {
							csProdLine  = "\r\n";
							csProdLine += csProdNm ;
							csProdLine += "[";
							csProdLine += pu.RPad( pu.DllGetCutHangul( csSdaNm, 6 ), 6 );
							csProdLine += "]";
						} else {
						   csProdLine = "\r\n" + csProdNm;
						}
									
						// 2016-09-12-JYL [주방주문서 취소항목 역상출력]
						if( inSaleQty < 0 && SHOP_ENV[659] == 1)
						{  // 프린터 반전출력
							csTemp += pu.GetPRTDeviceCMD( "REVERSE_ON" ) /** PRT_BASE_REVERSE_ON * */;
						}



						// 2021.10.26 xbwing - bInitDotLine이 true이면 Dot Line를 그리고 그렇지 않다면 그리지 않는다.
						if( SHOP_ENV[688] == 1 && bInitDotLine )
							csTemp += "\r\n------------------------------------------";
							
						
						csTemp += csProdLine;
						csTemp += pu.LPad( util.numberWithCommas( csSaleQty ), 5 );

						// 2009-1229-YBC : 서비스상품에 대한 서비스구분자 추가.
						if( row[ "SVC_FG" ] == "Y" ) {
							if( pcsCode == "{주문서-메뉴출력형태1}" ) {
								csStatus = "ⓢ" + csStatus;
							}
							else {
								csStatus = "ⓢ";
							}
						}
	
						if( pcsCode == "{주문서-메뉴출력형태1}" ) {
							csTemp += pu.LPad( csStatus, 7 );
						}
						else {
							let csName = "" ; 
							csName /** .For_mat * */ = ("%s", csStatus );
							csTemp += pu.LPad( pu.DllGetCutHangul( csName , 2), 2 );
						}
						
						
						csSetProdFg = row[ "SET_PROD_FG" ];
						if( csCoursePrintFg != "N" &&  csSetProdFg == "2" ) {
							util.logInfo( "Call#1 - GetCourseProdList " );
							csTemp += pu.AddNewLineMark( csTemp ) ;
							csTemp += this.GetCourseProdList( csProdCd, pcsCode );
						}

						csCookMemo = row[ "COOK_MEMO" ];
						if( csCookMemo != "" && csCookMemo != undefined ) {
							if( this.g_inPaperTypeFg == 0 ) {
								csTemp += pu.CPad(	"※" + csCookMemo + "※", 32 );
							}
							else {
								csTemp += pu.CPad(	"※" + csCookMemo + "※", 42 );
							}
						}

						// 2016-09-12-JYL [주방주문서 취소항목 역상출력]
						if( inSaleQty < 0 && SHOP_ENV[659] == 1)
						{  // 프린터 반전해제
							csTemp += pu.GetPRTDeviceCMD( "REVERSE_OFF" ) /** PRT_BASE_REVERSE_OFF * */;
						}
						
						util.logInfo("_____ ORDER_DTL_NO : " + row["ORDER_DTL_NO"]);
						var orderDtlNo = row["ORDER_DTL_NO"];
						
						if(orderDtlNo == "0001"){
							
							/**
							 * 2022-05-26 1회용 컵 보증금이 있으면 상품명 바로 아래 사이드메뉴와 같은 형태로 추가한다.
							 */
							if(!!orderInfo.POS_ODDTL_T){ // 주문하는 과정에서 영수증 출력인 경우
								for(var cup=0;cup<orderInfo.POS_ODDTL_T.length;cup++){ // 현재 주문한 객체 for문
									var voDtl = orderInfo.POS_ODDTL_T[cup];
									//if( row["PROD_CD"] == voDtl.PROD_CD){ // 현재 상품과 dtl객체의 상품이 같으면
										if(!!voDtl.cupList){ // dtl객체에 cupList가 존재한다면							
											csTemp += "\r\n▷";
											if( this.g_inPaperTypeFg == 0 ) {
												if( pcsCode == "{주문서-메뉴출력형태1}" ) {
													csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 20 ), 20 );
												}else{
													csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 25 ), 25 );
												}
												csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_CNT ), 5  );
											}else{
												if( pcsCode == "{주문서-메뉴출력형태1}" ) {
													csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 25 ), 25 );
												}else{
													csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 30 ), 30 );
												}
												csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_CNT ), 5  );
											}
											
										}
									//}
								}
							}else{ // 주문하는 과정에서의 영수증 출력이 아닌 경우 (관리자에서 재출력 등)
								if(!!row["CUP_SALE_CNT"]){ // 컵 개수가 존재할 때만 재출력 대상이 된다.	
									if(row["CUP_FG"] != "PRSNL" && row["CUP_FG"] != "STORE"){ // ODDTL_T 테이블의 CUP_FG 값이 개인/매장 컵이 아닌 경우 (1회용 컵인 경우)
										csTemp += "\r\n▷";
										if( this.g_inPaperTypeFg == 0 ) {
											if( pcsCode == "{주문서-메뉴출력형태1}" ) {
												csTemp += pu.RPad( pu.DllGetCutHangul( "1회용컵", 15 ), 15 );
											}else{
												csTemp += pu.RPad( pu.DllGetCutHangul( "1회용컵", 20 ), 20 );
											}
											csTemp += pu.LPad( util.numberWithCommas( Number(row["CUP_SALE_CNT"] ) * takeBack), 5  );
										}else{
											if( pcsCode == "{주문서-메뉴출력형태1}" ) {
												csTemp += pu.RPad( pu.DllGetCutHangul( "1회용컵", 28 ), 28 );
											}else{
												csTemp += pu.RPad( pu.DllGetCutHangul( "1회용컵", 33 ), 33 );
											}
											csTemp += pu.LPad( util.numberWithCommas( Number(row["CUP_SALE_CNT"] ) * takeBack), 5  );
										}
									}else{
										csTemp += "\r\n▷";
										var vsCupNm = "";
										if(row["CUP_FG"] == "PRSNL"){ // 개인컵인 경우
											vsCupNm = "개인컵";
										}else if (row["CUP_FG"] == "STORE"){
											vsCupNm = "매장컵";
										}else{
											vsCupNm = "";
										}		
										
										if( this.g_inPaperTypeFg == 0 ) {
											if( pcsCode == "{주문서-메뉴출력형태1}" ) {
												csTemp += pu.RPad( pu.DllGetCutHangul( vsCupNm, 15 ), 15 );
											}else{
												csTemp += pu.RPad( pu.DllGetCutHangul( vsCupNm, 20 ), 20 );
											}
											csTemp += pu.LPad( util.numberWithCommas( Number(row["CUP_SALE_CNT"] ) * takeBack ), 5  );
										}else{
											if( pcsCode == "{주문서-메뉴출력형태1}" ) {
												csTemp += pu.RPad( pu.DllGetCutHangul( vsCupNm, 28 ), 28 );
											}else{
												csTemp += pu.RPad( pu.DllGetCutHangul( vsCupNm, 33 ), 33 );
											}
											csTemp += pu.LPad( util.numberWithCommas( Number(row["CUP_SALE_CNT"] ) * takeBack ), 5  );
										}
									}
								}
								
							}
							
							if( pcsCode == "{주문서-메뉴출력형태1}" ) {
								csTemp += pu.LPad( csStatus, 7 );
							}
							else {
								let csName = "" ; 
								csName /** .For_mat * */ = ("%s", csStatus );
								csTemp += pu.LPad( pu.DllGetCutHangul( csName , 2), 2 );
							}
							
							// 2016-09-12-JYL [주방주문서 취소항목 역상출력]
							if( inSaleQty < 0 && SHOP_ENV[659] == 1)
							{  // 프린터 반전해제
								csTemp += pu.GetPRTDeviceCMD( "REVERSE_OFF" ) /** PRT_BASE_REVERSE_OFF * */;
							}
						}
						
						
						m_inPrtDataCnt++;

					} else if( pcsCode == "{주문서-메뉴출력형태2}" ||  pcsCode == "{주문서-메뉴출력형태4}" ) {//주방프린터 04
						let csTempCutProdNm = "" ; 					// 2019-08-20-SHK
																					// [메뉴출력형태2-상품명길이]
						let bSideMenu = false /** FALSE * */ ; /** BOOL * */								// 2019-08-20-SHK
																											// [메뉴출력형태2-상품명길이]

						if( bCnt == 0 )	{
							csTemp += "\r\n";
							if( this.g_inPaperTypeFg == 0 ) {
								csTemp += "  상품명    수량\r\n";		// 2014-0917-Jane
																	// : 메뉴->상품
								inIndexOfQty = "  상품명    수량\r\n" ;;						// 2019-08-20-SHK
								//inIndexOfQty = "  상품명    수량\r\n".substring(0, "수량");						// 2019-08-20-SHK
																												// [메뉴출력형태2-상품명길이]
								csTemp += "----------------";
							} else {
								if( pcsCode == "{주문서-메뉴출력형태2}" ) {
									csTemp += " 상 품 명   수량 구분\r\n";	// 2014-0917-Jane
																	// : 메뉴->상품
									inIndexOfQty = " 상 품 명   수량 구분\r\n";			// 2019-08-20-SHK
									//inIndexOfQty =inIndexOfQty.substring(0, "수량");			// 2019-08-20-SHK
																										// [메뉴출력형태2-상품명길이]
								} else {
									csTemp += " 상 품 명      수량  \r\n";	// 2014-0917-Jane  // : // 메뉴->상품
									inIndexOfQty = " 상 품 명      수량  \r\n";	// 2019-08-20-SHK
									//inIndexOfQty = " 상 품 명      수량  \r\n".substring(0, "수량");	// 2019-08-20-SHK
																										// [메뉴출력형태2-상품명길이]
								}

								csTemp += "---------------------";
							}
							inIndexOfQty = inIndexOfQty.substring(0, inIndexOfQty.indexOf("수량") +1 );
							inIndexOfQty = inIndexOfQty.getByteLength();
						}

						csStatus = ""; // 2010-1208-YBC : 초기화가 없어서 지속출력됨.

						// 2021. 11. 01 xbwing - 속성 마지막 위에 Dot line를 그리기 위한 플래그.
						if( SHOP_ENV[688] == 1 && itx > 0 )
							bInitDotLine =  true;
						
						if( pcsCode == "{주문서-메뉴출력형태2}" ) {
							if( row[ "ORDER_CNT" ]/** .asShort__ * */ == 1 ) {
								csStatus = "신규";
							}
							else {
								csStatus = "추가";
							}
						}

						// 2009-1118-YBC
						inSaleQty = row[ "QTY" ]/** .asShort__ * */;
						
						//반품아닐때 *1, 반품일경우 *-1,
						var takeBack = 1;
						
						// 2010-0504-YBC : 메뉴수량별 컷팅의 경우 수량을 1로 변경한다.
						if( this.m_inSpectialPrintFg == 2 ) {
							if( inSaleQty > 0 ) {
								inSaleQty = 1;
							}
							else {
								inSaleQty = -1;
							}
						}

						if( this.m_stSaleInfo.blReturnSaleFg && inSaleQty > 0) {	// 2013-08-01
																					// Antony
																					// Choi:
																					// 반품여부에
																					// 따른
																					// 수량
																					// 처리.
							inSaleQty *= -1;
							takeBack = -1;
						}

						csSaleQty /** .For_mat * */ = ( "%d"
										, inSaleQty );

						// 2010-0212-YBC
						// 2009-1229-YBC : 코스내역출력여부 && 세트상품구분 0:일반 1:세트 2:코스
						csProdCd     = row[ "PROD_CD"      ];
						csSideMenuYn = row[ "SIDE_MENU_YN" ];

						inSdsOrgDtlNo = row[ "SDS_ORG_DTL_NO" ]/** .asShort__ * */;

						if( csSideMenuYn == "Y" ) {
							blSideAttrPrt = true /** TRUE * */;
						}

						if( csSideMenuYn == "N"
						&&  inSdsOrgDtlNo == 0 ) {
							blSideAttrPrt = false /** FALSE * */;
						}

						// 2010-0818-YBC : && csSdaCd != "" 추가.
						csSdaCd	= row[ "SDA_CD" ];
						if( csSideMenuYn == "N"
						&&  inSdsOrgDtlNo > 0 ) {
							bSideMenu = true /** TRUE * */;			// 2019-08-20-SHK
																	// [메뉴출력형태2-상품명길이]

							if( csProdCd.substr( 0 ,   1 /** LEN_DEF_1 * */ ) == "A" ) { // SIDE
																						// 속성
								csSideMenu = "▷";
								csStatus   = "속성";
							}
							else {
								csSideMenu = "▶";
								csStatus   = "선택";
							}
							
							// 2021. 11. 01 xbwing - 속성 마지막 위에 Dot line를 그리기 위한 플래그.
							if( SHOP_ENV[688] == 1 && itx > 0 )
								bInitDotLine  = false;
						}

						if( inSaleQty < 0 )	{
							if( pcsCode == "{주문서-메뉴출력형태2}" ) {
								csStatus = "취소";
							}
							else {
								csStatus = "";
							}
						}

						csDblFg  = row[ "PROP_CD"  ];                               // 2016-09-27-JYL
																					// [곱빼기]
						csProdNm = row[ "PROD_NM" ];
						csProdNm = this.GetProdNmDbl( csProdNm, (/** atoi * */ pu.parseInt (csDblFg) == 1 ? true /** TRUE * */ :false /** FALSE * */ ) );  // 2016-09-27-JYL
																																						// [곱빼기]
						csProdNm = csProdNm.split( " ").join("  ");												 // 2019-1227-jane
																										// :
																										// space
																										// 무시하는
																										// 증상
																										// 수정.

						csPriceMgrYn = row[ "PRICE_MGR_YN" ];
						csSdaNm		 = row[ "SDA_NM"       ];	// 사이드메뉴 속성명 출력
																// 처리.
						csDlvPackFg  = row[ "DLV_PACK_FG"  ];	// 배달포장구분.

						if( csSideMenuYn == "N" && this.m_stSaleInfo.blPreOrderFg != true /** TRUE * */ )  {
							csSdaNm = "";
						}

						if( csDlvPackFg == "2" ) {
							// 포장마크
							if( pcsCode == "{주문서-메뉴출력형태2}" ) {
								csStatus = "포장";
							}
							else {
								csStatus = "ⓟ";
							}
						}
						else if( csDlvPackFg == "1" ) {
							if( pcsCode == "{주문서-메뉴출력형태2}" ) {
								csStatus = "배달";
							}
							else {
								csStatus = "ⓓ";
							}
						}

						//2021.11.01 xbwing - bInitDotLine이 true이면 Dot Line를 그리고 그렇지 않다면 그리지 않는다.
						if( SHOP_ENV[688] == 1 && bInitDotLine )
							csTemp += "\r\n---------------------";
							
						lnSaleAmt = pu.parseInt( row[ "SALE_AMT" ] / 10000 );	// 만원단위표기

						if( this.m_stSaleInfo.blReturnSaleFg && inSaleQty > 0) {	// 2013-08-01
																					// Antony
																					// Choi:
																					// 반품여부에
																					// 따른
																					// 수량
																					// 처리.
							lnSaleAmt *= -1;
						}

						// 2010-0401-YBC : 4배확대시 상품명 짤리는 현상 제거처리.
						if( csSideMenu.length /** .GetLength() * */ > 0 ) {
							csProdNm = csSideMenu + csProdNm;
						}

						let inEnv694 = /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 694 ) );						// 2020-0210-jane
																														// :
																														// 주방주문서
																														// 폰트확대시
																														// 정렬기능
																														// 옵션
																														// 추가.

						if( inEnv694 == 1 ) {
							if( util.byteLen( csProdNm) > inIndexOfQty )	{				// 2019-08-20-SHK
																							// [메뉴출력형태2-상품명길이]
								do {
									csCutProdNm = pu.DllGetCutHangul( csProdNm, inIndexOfQty );
									csTempCutProdNm += "\r\n" + csCutProdNm;
									csProdNm = csProdNm.cutStr(csCutProdNm.getByteLength()  );
								} while ( util.byteLen(csProdNm )  > inIndexOfQty);
							}
						} else {
							if( util.byteLen( csProdNm )  >  12 )	{
								csCutProdNm = pu.DllGetCutHangul( csProdNm,  20 );
								csTemp     += "\r\n" + csCutProdNm;
								//csProdNm    = csProdNm.cutStr( csCutProdNm.getByteLength() );
								csProdNm    = csProdNm.replace( csCutProdNm, "" );
								
								
							}
						}

						if( this.g_inPaperTypeFg == 0 ) {
							if( util.byteLen( csSdaNm ) > 0 ) {
								if ( this.m_stSaleInfo.blPreOrderFg == true /** TRUE * */ )
								{
									csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csSdaNm, 12  ), 12  );
								}else
								{
									csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 6  ), 6  );
								}
							}
							else {
								csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 12 ), 12 );
							}
						}
						else {
							
							if( util.byteLen(csSdaNm) > 0 ) {
								if ( this.m_stSaleInfo.blPreOrderFg == true /** TRUE * */ )
								{
									if( pcsCode == "{주문서-메뉴출력형태2}" ) {
										csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csSdaNm, 12  ), 12  );
									}else{
										csProdNm = pu.RPad( pu.DllGetCutHangul( csSideMenu + csSdaNm, 15  ), 15  );
									}

								}else
								{
									csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 8  ), 8  );
								}
							}
							else {
								if( pcsCode == "{주문서-메뉴출력형태2}" ) {
									csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 12 ), 12 );	// 2010-0401-YBC
								}
								else {
									csProdNm = pu.RPad( pu.DllGetCutHangul( csProdNm, 15 ), 15 );
								}
							}
						}
						

						// 2016-1128 Antony.Choi : 싯기 상품일 경우 582번 옵션이 사용 일 경우에만
						// 출력함.
						if( csPriceMgrYn == "Y" && inPriceMgrSaleAmtPrintYN == 1 ) {		// 싯가상품.
							csSaleAmt =  "(%02d)".sprintf( lnSaleAmt );
							csProdNm = pu.DllGetCutHangul( csProdNm, csProdNm.getByteLength()  - csSaleAmt.length  ) + csSaleAmt;
						}

						if( util.byteLen( csSdaNm ) > 0 && this.m_stSaleInfo.blPreOrderFg != true /** TRUE * */) {
							csProdLine  = "\r\n";
							csProdLine += csProdNm;
							csProdLine += "-";
							csProdLine += pu.RPad( pu.DllGetCutHangul( csSdaNm, 3 ), 3 );
						}
						else {
							csProdLine = "\r\n" + csProdNm;
						}

						/*if (!bSideMenu && bCnt > 0 && SHOP_ENV[688] == 1) {				// 2019-08-20-SHK
																					// [메뉴출력형태2-상품명길이]
							csTemp += g_clsPrinter[ pu.parseInt ( this.m_stSaleInfo.PRT_NO )].GetPRTDeviceCMD("H2X") + "\r\n---------------------";
							csTemp += m_csCurFontSize;
						}*/

						// 2016-09-12-JYL [주방주문서 취소항목 역상출력]
						if( inSaleQty < 0 && SHOP_ENV[659] == 1)
						{  // 프린터 반전출력
							csTemp += pu.GetPRTDeviceCMD( "REVERSE_ON" ) /** PRT_BASE_REVERSE_ON * */;
						}

						csTemp += csTempCutProdNm;									// 2019-08-20-SHK
																					// [메뉴출력형태2-상품명길이]
						csTemp += csProdLine;
						csTemp += pu.LPad( util.numberWithCommas( csSaleQty ), 4 );

						if( row[ "SVC_FG" ] == "Y" ) {
							if( pcsCode == "{주문서-메뉴출력형태2}" ) {
								csStatus = csStatus.substr( 0 ,   2 /** LEN_DEF_2 * */ ) + "ⓢ";
							}
							else {
								csStatus = "ⓢ";
							}
						}

						if( this.g_inPaperTypeFg == 0 ) {
							csTemp += pu.LPad( csStatus, 2 );
						} else {
							if( pcsCode == "{주문서-메뉴출력형태2}" ) {
								csTemp += pu.LPad( csStatus, 5 );
							} else {
								let csName = "" ;
								csName /** .For_mat * */ = ("%s", csStatus );
								csTemp += pu.LPad( pu.DllGetCutHangul( csName,2), 2 );
							}
						}

						csSetProdFg = row[ "SET_PROD_FG" ];

						if( csCoursePrintFg != "N" &&  csSetProdFg == "2" ) {
							util.logInfo( "Call#2 - GetCourseProdList " );
							csTemp += pu.AddNewLineMark( csTemp ) ;
							csTemp += GetCourseProdList( csProdCd, pcsCode );
						}

						csCookMemo = row[ "COOK_MEMO" ];
						if( (csCookMemo != "" && csCookMemo != undefined) && util.byteLen( csCookMemo ) > 0 ) {
							if( this.g_inPaperTypeFg == 0 ) {
								csTemp += pu.CPad( " ※ " + csCookMemo + " ※ ", 21 );
							}
							else {
								csTemp += pu.CPad( " ※ " + csCookMemo + " ※ ", 16 );
							}
						}
						
						util.logInfo("_____ ORDER_DTL_NO : " + row["ORDER_DTL_NO"]);
						var orderDtlNo = row["ORDER_DTL_NO"];
						
						if(orderDtlNo == "0001"){
							/**
							 * 2022-05-26 1회용 컵 보증금이 있으면 상품명 바로 아래 사이드메뉴와 같은 형태로 추가한다.
							 */
							if(!!orderInfo.POS_ODDTL_T){ // 주문하는 과정에서 영수증 출력인 경우
								for(var cup=0;cup<orderInfo.POS_ODDTL_T.length;cup++){ // 현재 주문한 객체 for문
									var voDtl = orderInfo.POS_ODDTL_T[cup];
									//if( row["PROD_CD"] == voDtl.PROD_CD){ // 현재 상품과 dtl객체의 상품이 같으면
										if(!!voDtl.cupList){ // dtl객체에 cupList가 존재한다면							
											csTemp += "\r\n▷";
											if( this.g_inPaperTypeFg == 0 ) {
												//if( util.byteLen( csSdaNm ) > 0 ) {
												if ( this.m_stSaleInfo.blPreOrderFg == true /** TRUE * */ )
												{
													csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 12  ), 12  );
												}else
												{
													csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 6  ), 6  );
												}
												//}else {
												//	csProdNm = pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 12 ), 12 );
												//}
												//csTemp += csProdLine;
												csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_CNT ), 4 );
											}else{
												if( util.byteLen(csSdaNm) > 0 ) {
													if ( this.m_stSaleInfo.blPreOrderFg == true /** TRUE * */ )
													{
														if( pcsCode == "{주문서-메뉴출력형태2}" ) {
															csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 12  ), 12  );
														}else{
															csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 15  ), 15  );
														}
														
													}else
													{
														csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 8  ), 8  );
													}
												}
												else {
													if( pcsCode == "{주문서-메뉴출력형태2}" ) {
														csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 12 ), 12 );	// 2010-0401-YBC
													}
													else {
														csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 15 ), 15 );
													}
												}
												//csTemp += csProdLine;
												csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_CNT ), 4 );
											}
											
										}
									//}
								}
							}else{ // 주문하는 과정에서의 영수증 출력이 아닌 경우 (관리자에서 재출력 등)
								if(!!row["CUP_SALE_CNT"]){ // 컵 개수가 존재할 때만 재출력 대상이 된다.								
									if(row["CUP_FG"] != "PRSNL" && row["CUP_FG"] != "STORE"){ // ODDTL_T 테이블의 CUP_FG 값이 개인/매장 컵이 아닌 경우 (1회용 컵인 경우)
										csTemp += "\r\n▷";
										if( this.g_inPaperTypeFg == 0 ) {
											//if( util.byteLen( csSdaNm ) > 0 ) {
											if ( this.m_stSaleInfo.blPreOrderFg == true /** TRUE * */ )
											{
												csTemp += pu.RPad( pu.DllGetCutHangul( "1회용컵", 12  ), 12  );
											}else
											{
												csTemp += pu.RPad( pu.DllGetCutHangul( "1회용컵", 6  ), 6  );
											}
											//}else {
											//	csProdNm = pu.RPad( pu.DllGetCutHangul( "1회용컵", 12 ), 12 );
											//}
											//csTemp += csProdLine;
											csTemp += pu.LPad( util.numberWithCommas( Number(row["CUP_SALE_CNT"] ) * takeBack ), 4 );
										}else{
											//if( util.byteLen(csSdaNm) > 0 ) {
											if ( this.m_stSaleInfo.blPreOrderFg == true /** TRUE * */ )
											{
												if( pcsCode == "{주문서-메뉴출력형태2}" ) {
													csTemp += pu.RPad( pu.DllGetCutHangul( "1회용컵", 12  ), 12  );
												}else{
													csTemp += pu.RPad( pu.DllGetCutHangul( "1회용컵", 15  ), 15  );
												}
												
											}else
											{
												csTemp += pu.RPad( pu.DllGetCutHangul( "1회용컵", 10 ), 10  );
											}
											//}
											//else {
//											if( pcsCode == "{주문서-메뉴출력형태2}" ) {
//												csProdNm = pu.RPad( pu.DllGetCutHangul( "1회용컵", 12 ), 12 );	// 2010-0401-YBC
//											}
//											else {
//												csProdNm = pu.RPad( pu.DllGetCutHangul( "1회용컵", 15 ), 15 );
//											}
											//}
											//csTemp += csProdLine;
											csTemp += pu.LPad( util.numberWithCommas( Number(row["CUP_SALE_CNT"] ) * takeBack ), 4 );
										}
									}else{
										csTemp += "\r\n▷";
										var vsCupNm = "";
										if(row["CUP_FG"] == "PRSNL"){ // 개인컵인 경우
											vsCupNm = "개인컵";
										}else if (row["CUP_FG"] == "STORE"){
											vsCupNm = "매장컵";
										}else{
											vsCupNm = "";
										}		
										//if( util.byteLen(csSdaNm) > 0 ) {
										if ( this.m_stSaleInfo.blPreOrderFg == true /** TRUE * */ )
										{
											if( pcsCode == "{주문서-메뉴출력형태2}" ) {
												csTemp += pu.RPad( pu.DllGetCutHangul( vsCupNm, 12  ), 12  );
											}else{
												csTemp += pu.RPad( pu.DllGetCutHangul( vsCupNm, 15  ), 15  );
											}
											
										}else
										{
											csTemp += pu.RPad( pu.DllGetCutHangul( vsCupNm, 10  ), 10  );
										}
										//}
										//else {
//										if( pcsCode == "{주문서-메뉴출력형태2}" ) {
//											csProdNm = pu.RPad( pu.DllGetCutHangul( vsCupNm, 12 ), 12 );	// 2010-0401-YBC
//										}
//										else {
//											csProdNm = pu.RPad( pu.DllGetCutHangul( vsCupNm, 15 ), 15 );
//										}
										//}
										//csTemp += csProdLine;
										csTemp += pu.LPad( util.numberWithCommas( Number(row["CUP_SALE_CNT"] ) * takeBack ), 4 );
									}
								}
								
							}
							
							if( this.g_inPaperTypeFg == 0 ) {
								csTemp += pu.LPad( csStatus, 2 );
							} else {
								if( pcsCode == "{주문서-메뉴출력형태2}" ) {
									csTemp += pu.LPad( csStatus, 5 );
								} else {
									let csName = "" ;
									csName /** .For_mat * */ = ("%s", csStatus );
									csTemp += pu.LPad( pu.DllGetCutHangul( csName,2), 2 );
								}
							}
						}
						
						// 2016-09-12-JYL [주방주문서 취소항목 역상출력]
						if( inSaleQty < 0 && SHOP_ENV[659] == 1)
						{  // 프린터 반전해제
							csTemp += pu.GetPRTDeviceCMD( "REVERSE_OFF" ) /** PRT_BASE_REVERSE_OFF * */;
						}
						
						m_inPrtDataCnt++;	// 2010-0218-YBC
					}
					if( pcsCode == "{테이블메뉴이동}" )	{
						if( bCnt == 0 )	{
							if( this.g_inPaperTypeFg == 0 ) {
								csTemp += "================================\r\n";
								csTemp += " 상 품 명              수량 구분\r\n";	// 2014-0917-Jane
																			// :
																			// 메뉴->상품
								csTemp += "--------------------------------";
							}
							else {
								csTemp += "==========================================\r\n";
								csTemp += "    상  품  명             수량       구분\r\n";		// 2014-0917-Jane
																							// :
																							// 메뉴->상품
								csTemp += "------------------------------------------";
							}
						}

						csStatus = "이동";


						csDblFg      = row[ "PROP_CD"  ];                               // 2016-09-27-JYL
																						// [곱빼기]
						csProdNm     = row[ "PROD_NM" ];                               // 2016-09-27-JYL
																						// [곱빼기]
						csProdNm     = this.GetProdNmDbl( csProdNm, (/** atoi * */ pu.parseInt (csDblFg) == 1 ? true /** TRUE * */ :false /** FALSE * */ ) );  // 2016-09-27-JYL
																																							// [곱빼기]
						csProdCd     = row[ "PROD_CD"      ];
						csSideMenuYn = row[ "SIDE_MENU_YN" ];

						inSdsOrgDtlNo = row[ "SDS_ORG_DTL_NO" ]/** .asShort__ * */;

						if( csSideMenuYn == "Y" ) {
							blSideAttrPrt = true /** TRUE * */;
						}

						if( csSideMenuYn == "N"
						&&  inSdsOrgDtlNo == 0 ) {
							blSideAttrPrt = false /** FALSE * */;
						}

						csSdaCd	= row[ "SDA_CD" ];
						if( csSideMenuYn == "N"
						&&  inSdsOrgDtlNo > 0 ) {
							if( csProdCd.substr( 0 ,   1 /** LEN_DEF_1 * */ ) == "A" ) {
								csSideMenu = "▷";
							}
							else {
								csSideMenu = "▶";
							}
						}

						if( this.g_inPaperTypeFg == 0 ) {
							// 사이드메뉴 속성명 출력 처리.
							csSdaNm	= row[ "SDA_NM" ];		// 사이드메뉴 속성명 출력 처리.
							if( util.byteLen( csSdaNm ) > 0 ) {
								csProdLine  = "\r\n";
								csProdLine += pu.RPad( pu.DllGetCutHangul( csProdNm, 18 ), 18 );
								csProdLine += "[";
								csProdLine += pu.RPad( pu.DllGetCutHangul( csSdaNm,                                    4  ), 4  );
								csProdLine += "]";
								csTemp += csProdLine;
							}
							else {
								csTemp += "\r\n" + pu.RPad(pu.DllGetCutHangul( csSideMenu + csProdNm, 24 ), 24 );
							}

							csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 3 );
							csTemp += pu.LPad( csStatus, 5 );

							csCookMemo = row[ "COOK_MEMO" ];
							if( csCookMemo != "" && csCookMemo != undefined ) {
								csTemp += pu.CPad( " ※ " + csCookMemo + " ※ ", 32 );
							}
						}
						else {
							// 사이드메뉴 속성명 출력 처리.
							csSdaNm	= row[ "SDA_NM" ];		// 사이드메뉴 속성명 출력 처리.
							if( util.byteLen( csSdaNm ) > 0 ) {
								csProdLine  = "\r\n";
								csProdLine += pu.RPad( pu.DllGetCutHangul( csProdNm, 20 ), 20 );
								csProdLine += "[";
								csProdLine += pu.RPad( pu.DllGetCutHangul( csSdaNm,                                    4  ), 4  );
								csProdLine += "]";
								csTemp += csProdLine;
							}
							else {
								csTemp += "\r\n" + pu.RPad(pu.DllGetCutHangul( csSideMenu + csProdNm, 26 ), 26 );
							}

							csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 5 );
							csTemp += pu.LPad( csStatus, 11 );

							csCookMemo = row[ "COOK_MEMO" ];
							if( csCookMemo != "" && csCookMemo != undefined ) {
								csTemp += pu.CPad( " ※ " + csCookMemo + " ※ ", 42 );
							}
						}

						m_inPrtDataCnt++;	// 2010-0218-YBC
					}
					else if( pcsCode == "{테이블메뉴이동-확대}" ) {
						if( bCnt == 0 )	{
							if( this.g_inPaperTypeFg == 0 ) {
								csTemp += "================\r\n";
								csTemp += "  상품명    수량\r\n";	// 2014-0917-Jane
																// : 메뉴->상품
								csTemp += "----------------";
							}
							else {
								csTemp += "=====================\r\n";
								csTemp += " 상 품 명   수량 구분\r\n";	// 2014-0917-Jane
																// : 메뉴->상품
								csTemp += "---------------------";
							}
						}

						csStatus = "이동";

						csDblFg      = row[ "PROP_CD"  ];                               // 2016-09-27-JYL
																						// [곱빼기]
						csProdNm     = row[ "PROD_NM" ];                               // 2016-09-27-JYL
																						// [곱빼기]
						csProdNm     = this.GetProdNmDbl( csProdNm, (/** atoi * */ pu.parseInt (csDblFg) == 1 ? true /** TRUE * */ :false /** FALSE * */ ) );  // 2016-09-27-JYL
																																							// [곱빼기]
						csProdCd     = row[ "PROD_CD"      ];
						csSideMenuYn = row[ "SIDE_MENU_YN" ];

						inSdsOrgDtlNo = row[ "SDS_ORG_DTL_NO" ]/** .asShort__ * */;

						if( csSideMenuYn == "Y" ) {
							blSideAttrPrt = true /** TRUE * */;
						}

						if( csSideMenuYn == "N"
						&&  inSdsOrgDtlNo == 0 ) {
							blSideAttrPrt = false /** FALSE * */;
						}

						csSdaCd	= row[ "SDA_CD" ];
						if( csSideMenuYn == "N"
						&&  inSdsOrgDtlNo > 0 ) {
							if( csProdCd.substr( 0 ,   1 /** LEN_DEF_1 * */ ) == "A" ) {
								csSideMenu = "▷";
							}
							else {
								csSideMenu = "▶";
							}
						}

						if( this.g_inPaperTypeFg == 0 ) {
							csSdaNm	= row[ "SDA_NM" ];		// 사이드메뉴 속성명 출력 처리.
							if( util.byteLen( csSdaNm ) > 0 ) {
								csProdLine  = "\r\n";
								csProdLine += pu.RPad( pu.DllGetCutHangul( csProdNm, 8 ), 8 );
								csProdLine += "-";
								csProdLine += pu.RPad( pu.DllGetCutHangul( csSdaNm,                                    3 ), 3 );
								csTemp += csProdLine;
							} else {
								csTemp += "\r\n" + pu.RPad( pu.DllGetCutHangul( csSideMenu + csProdNm, 12 ), 12 );
							}

							csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 3 );

							csCookMemo = row[ "COOK_MEMO" ];
							if( csCookMemo != "" && csCookMemo != undefined ) {
								csTemp += pu.CPad( " ※ " + csCookMemo + " ※ ", 16 );
							}
						}
						else {
							csSdaNm	= row[ "SDA_NM" ];		// 사이드메뉴 속성명 출력 처리.
							if( util.byteLen( csSdaNm ) > 0 ) {
								csProdLine  = "\r\n";
								csProdLine += pu.RPad( pu.DllGetCutHangul( csProdNm, 8 ), 8 );
								csProdLine += "-";
								csProdLine += pu.RPad( pu.DllGetCutHangul( csSdaNm,                                    3 ), 3 );
								csTemp += csProdLine;
							} else {
								csTemp += "\r\n" + pu.RPad( pu.DllGetCutHangul( csSideMenu + csProdNm, 12 ), 12 );
							}

							csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 4 );
							csTemp += pu.LPad( csStatus, 5 );

							csCookMemo = row[ "COOK_MEMO" ];
							if( csCookMemo != "" && csCookMemo != undefined ) {
								csTemp += pu.CPad( " ※ " + csCookMemo + " ※ ", 21 );
							}
						}

						m_inPrtDataCnt++;	// 2010-0218-YBC
					} else if( pcsCode == "{상품리스트2}" ) {				// 2019-08-13-SHK
																		// [상품리스트2]
						// //////////////////////////////////////////////////////////////////////////
						// 2013-0902-Jane : 영수증 상품리스트 출력제어.
						// 2013-1128 Antony.Choi : 고객 퇴점일 경우에는 비교 하지 않음
						// //////////////////////////////////////////////////////////////////////////
						if( bCnt == 0 ) {
							if( this.g_inPaperTypeFg == 0 ) {
								csTemp += "   상 품 명      수량     금 액\r\n";
								csTemp += "-------------------------------";
							}
							else {
								csTemp += "    상  품  명       단 가  수량     금 액\r\n";
								csTemp += "------------------------------------------";
							}
						}
						// //////////////////////////////////////////////////////////////////
						// 상품명 좌측정렬 변경처리.
						// //////////////////////////////////////////////////////////////////
						csDblFg  = row[ "PROP_CD"  ];                               // 2016-09-27-JYL
																					// [곱빼기]
						csProdNm = row[ "PROD_NM" ];                               // 2016-09-27-JYL
																					// [곱빼기]
						csProdNm = this.GetProdNmDbl( csProdNm, (/** atoi * */ pu.parseInt (csDblFg) == 1 ? true /** TRUE * */ :false /** FALSE * */ ) );  // 2016-09-27-JYL
																																						// [곱빼기]

						csTemp += "\r\n" + pu.RPad( pu.DllGetCutHangul( csProdNm, 17 ), 17 );

						if( this.g_inPaperTypeFg == 0 ) {
							csTemp += pu.LPad( util.numberWithCommas( row[ "QTY" ] ), 4  );
							csTemp += pu.LPad( util.numberWithCommas( row[ "SALE_AMT" ] ), 10 );
						}
						else {
							csTemp += pu.LPad( util.numberWithCommas( row[ "UPRC" ] ), 9  );
							csTemp += pu.LPad( util.numberWithCommas( row[ "QTY"  ] ), 5  );
							csTemp += pu.LPad( util.numberWithCommas( row[ "SALE_AMT"  ] ), 11 );
						}
						
						/**
						 * 2022-05-26 1회용 컵 보증금이 있으면 상품명 바로 아래 사이드메뉴와 같은 형태로 추가한다.
						 */
						if(!!orderInfo.POS_ODDTL_T){ // 주문하는 과정에서 영수증 출력인 경우
							for(var cup=0;cup<orderInfo.POS_ODDTL_T.length;cup++){ // 현재 주문한 객체 for문
								var voDtl = orderInfo.POS_ODDTL_T[cup];
								if(row[ "PROD_CD"  ] == voDtl.PROD_CD){ // 현재 상품과 dtl객체의 상품이 같으면
									if(!!voDtl.cupList){ // dtl객체에 cupList가 존재한다면							
										csTemp += "\r\n▷";
										csTemp += pu.RPad( pu.DllGetCutHangul( voDtl.cupList[0].CUP_NAME, 15 ), 15 );
										if( this.g_inPaperTypeFg == 0 ) {
											csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_CNT ), 4  );
											csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_AMT ), 10 );	
										}else{
											if(voDtl.cupList[0].CUP_TYPE == "disposableCup"){ // 1회용보증금 컵일 때 보증금 단가 
												csTemp += pu.LPad( util.numberWithCommas( gCupUprc ), 9  );
											}else{ // 1회용 보증금 컵이 아닌 경우에 보증금 단가 0원
												csTemp += pu.LPad( util.numberWithCommas( "0" ), 9  );
											}
											csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_CNT ), 5  );
											csTemp += pu.LPad( util.numberWithCommas( voDtl.cupList[0].CUP_AMT ), 11 );
										}
										
									}
								}
							}
						}else{ // 주문하는 과정에서의 영수증 출력이 아닌 경우 (관리자에서 재출력 등)
							if(!!row["CUP_SALE_CNT"]){ // 컵 개수가 존재할 때만 재출력 대상이 된다.
								if(row["CUP_FG"] != "PRSNL" && row["CUP_FG"] != "STORE"){ // ODDTL_T 테이블의 CUP_FG 값이 개인/매장 컵이 아닌 경우 (1회용 컵인 경우)
									csTemp += "\r\n▷";
									csTemp += pu.RPad( pu.DllGetCutHangul( "1회용컵", 15 ), 15 );
									var vsAmt = "" + (Number(row["CUP_SALE_CNT"]) * Number(row["CUP_DEPOSIT_UPRC"]));
									if( this.g_inPaperTypeFg == 0 ) {
										csTemp += pu.LPad( util.numberWithCommas( row["CUP_SALE_CNT"] ), 4  );
										csTemp += pu.LPad( util.numberWithCommas( vsAmt ), 10 );	
									}else{
										csTemp += pu.LPad( util.numberWithCommas( row["CUP_DEPOSIT_UPRC"] ), 9  );
										csTemp += pu.LPad( util.numberWithCommas( row["CUP_SALE_CNT"] ), 5  );
										csTemp += pu.LPad( util.numberWithCommas( vsAmt ), 11 );
									}
								}else{
									csTemp += "\r\n▷";
									if(row["CUP_FG"] == "PRSNL"){ // 개인컵인 경우
										csTemp += pu.RPad( pu.DllGetCutHangul( "개인컵", 15 ), 15 );
									}else if (row["CUP_FG"] == "STORE"){
										csTemp += pu.RPad( pu.DllGetCutHangul( "매장컵", 15 ), 15 );
									}else{
										csTemp += pu.RPad( pu.DllGetCutHangul( "", 15 ), 15 );
									}						
									if( this.g_inPaperTypeFg == 0 ) {
										csTemp += pu.LPad( util.numberWithCommas( row["CUP_SALE_CNT"] ), 4  );
										csTemp += pu.LPad( util.numberWithCommas( "0" ), 10 );	
									}else{
										csTemp += pu.LPad( util.numberWithCommas( "0" ), 9  );
										csTemp += pu.LPad( util.numberWithCommas( row["CUP_SALE_CNT"] ), 5  );
										csTemp += pu.LPad( util.numberWithCommas( "0" ), 11 );
									}
								}
							}
						}

						if(row["PRICE_MGR_FG"] == "2" && row["SALE_WEIGHT"]/** .asLong__ * */ > 0)
						{
							csProdNm /** .For_mat * */ = ("(%sg)", util.numberWithCommas(row["SALE_WEIGHT"]));
							csTemp += pu.RPad(csProdNm, 17);
						}

						m_inPrtDataCnt++;
					}
					bCnt++;
				}

				if( csTemp.length /** .GetLength() * */ < 1 ) {
					// //임시20161203
					// TRACE_DB_ERROR(csQrySql);
					// ///////////////////
					let csLog = "" ; 
					csLog =  "CPrint::GetProductListData : SQL-NoData : PRT-NO[%s] SaleDate[%s] OrderNo[%s] OrderSeqNo[%s] OrderDtlNo[%s] ProdCd[%s]".sprintf( 
								this.m_stSaleInfo.PRT_NO, this.m_stSaleInfo.SALE_DATE, this.m_stSaleInfo.ORDER_NO, this.m_stSaleInfo.ORDER_SEQ_NO, m_csOrderDtlNo, m_csOrderDtlProdCd );
					util.logInfo(  csLog );
				}

				// 2010-0218-YBC
				if( m_inPrtDataCnt < 1 ) {
					csTemp = "";
			    }
			}
		} catch (e) {
			util.logError("common.printer.js GetProductListData_04 catch e == >> " + e);
			return "";
		}
		return csTemp;
			
	}
	// //////////////////////////////////////////////////////////////////////////////
	// 2012-0125-JJM : 주문합계-메뉴목록, 주문합계-메뉴목록-금액.
	// //////////////////////////////////////////////////////////////////////////////
	this.GetSummaryOrderList = function(pinPrtNo , pcsCode ) {
		let blZeroUprcProdNoPrintFg = /** atoi * */ pu.parseInt ( this.GetEnvXmlShopENV( 554 ) ) ; /** BOOL * */

		let csDlvPackFg = "" ; 
		let csQuery     = "" ; 
		let csPrint     = "" ; 
		let csProdNm    = "" ; 
		let csSaleQty   = "" ; 
		let csStatus    = "" ; 
		let csValue     = "" ;

		let lnDcmSaleAmt = 0;
		let lnVatAmt     = 0;
		let lnTotSaleAmt = 0;


		if( this.m_stSaleInfo.ORDER_SEQ_NO == "0001" ){ 	// 20190830-HJH 주문차수
															// 2자리 -> 4자리변경
			return csPrint;
		}
		try {

			let sql = _sql.GetSummaryOrderList_SQL( this.m_stSaleInfo  );
			let rows = this.db_get_mumti_rows( sql,[] );
			
			for ( let itx = 0 ; itx < rows.length ; itx++ ) {
				let row = rows[itx];

				// //////////////////////////////////////////////////////////////////////
				// 고객주문서/중간계산서/영수증 0원메뉴 SKIP 여부
				// //////////////////////////////////////////////////////////////////////
				if( blZeroUprcProdNoPrintFg ) {
					if( row[ "UPRC" ] == 0 ) {
						continue;
					}
				}

				csProdNm	= row[ "PROD_NM"     ];
				csDlvPackFg = row[ "DLV_PACK_FG" ];
				csSaleQty   = pu.parseInt(row[ "QTY"         ] );
				csStatus    = "";

				lnDcmSaleAmt = pu.parseInt( row[ "DCM_SALE_AMT" ] );

				if( csDlvPackFg == "2" ) {
					csStatus = "포장";
				} else if( csDlvPackFg == "1" ) {
					csStatus = "배달";
				}

				if( this.g_inPaperTypeFg == 0 ) {
					if( pcsCode == "{주문합계-메뉴목록}" ) {
						csValue  =  "%-22s%3s%7s".sprintf(
									    pu.DllGetCutHangul( csProdNm, 22 )
									  , util.numberWithCommas( csSaleQty )
									  , csStatus );
					} else if( pcsCode == "{주문합계-메뉴목록-금액}" ) {
						csValue  =  "%-16s %3s%7s%5s".sprintf(
									    pu.DllGetCutHangul( csProdNm, 16 )
									  , util.numberWithCommas( csSaleQty )
									  , util.numberWithCommas( lnDcmSaleAmt )
									  , csStatus );

						lnTotSaleAmt += lnDcmSaleAmt;
					}

				} else {
					if( pcsCode == "{주문합계-메뉴목록}" ) {
						csValue  =  "%-30s%5s%7s".sprintf(
									    pu.DllGetCutHangul( csProdNm, 30 )
									  , util.numberWithCommas( csSaleQty )
									  , csStatus );
					} else if( pcsCode == "{주문합계-메뉴목록-금액}" ) {
						csValue  =  "%-23s%5s%9s%5s".sprintf(
									    pu.DllGetCutHangul( csProdNm, 23 )
									  , util.numberWithCommas( csSaleQty )
									  , util.numberWithCommas( lnDcmSaleAmt )
									  , csStatus );

						lnTotSaleAmt += lnDcmSaleAmt;
					}
				}

				csPrint += g_clsPrinter[ pinPrtNo ][ "FEED" ];
				csPrint += csValue;
			}

			if( !pu.isEmpty( csPrint )  ) {
				if( this.g_inPaperTypeFg == 0 ) {
					csValue = "--------------------------------" + csPrint;
				} else {
					csValue = "------------------------------------------" + csPrint;
				}

				csPrint = csValue;

				// //////////////////////////////////////////////////////////////////////
				// 2012-0131-JJM : 주문합계금액 표시.
				// //////////////////////////////////////////////////////////////////////
				if( pcsCode == "{주문합계-메뉴목록-금액}" ) {
					csPrint += "------------------------------------------";
					csPrint += g_clsPrinter[ pinPrtNo ][ "FEED" ];

					csValue  =  "주문합계금액 : %22s".sprintf( util.numberWithCommas( lnTotSaleAmt ) );
					csPrint += csValue;
				}
			}
		} catch (e) {
			util.logError(e);
			return "";
		}
		
	}
	// 해당함수 실제 사용.
	this.printDo = function(printCode , obj, printDoCallback ) {			
		if ( pu.isEmpty( printCode )) {
			util.logError( "03 , 11, 12 , 93, 06 , 08 , 09 , 35 , 31, 32, 37 코드 입력."  )
			return;
		}
		if ( pu.isEmpty( obj)) {
			util.logError("parameter 미입력.");
			return;
		}
		obj.csPrintCode	= printCode ;
	
		util.logInfo("***** printDo this.init before*****");
		this.init(printCode , obj);
		util.logInfo("***** printDo this.init after*****");
		
		if(BIZ_CLS_TYPE == '1' && printCode == "94") { // 복수사업자이고 교환권인 경우.
			let sql = _sql.selectCornerPayDataGroup( obj );
			let rows = this.db_get_mumti_rows( sql, [] );
									
			for( let itx =  0; itx < rows.length; itx++  )  {
				
				let row = rows[itx];
				
				let r = "";
				if ( printCode.startsWith("3")) {
					if ( printCode == "37") {

						 r = this.GetReissueAccountPrint( obj, "37" );

						 if( r == ""  ) {
							 alert( "정산 데이타가 없습니다." );
							 return;
						 }

					} else {

						 r = this.GetSaleListData( obj,  printCode , true );
					}
				} else if ( printCode == "04") {
					if(!printDoCallback){
						util.logInfo("*****Kitchen Sync Start*****");
						let x = this.SendDataLink(obj);
						util.logDebug('SendDataLink sync x == > '+ x);
						 
					}else{
						util.logInfo("*****Kitchen Async Start*****");
						this.SendDataLink(obj, function(x){
							printDoCallback(x);
							util.logDebug('SendDataLink Async x == > '+ x);
						});
					}
					
//					if ( $("#xbug").html() == undefined ) {
//						//util.logInfo(" 최종출력결과 : \n" + r );
//						//util.logInfo(" 각 변환값  - " + this.x5);
//					}else {
//						$("#xbug").append("<li> 최종출력 결과 : " + r + "</li>");
//						$("#xbug").append("<li> 각 변환값 : \n&nbsp;n&nbsp; - " + this.x5.split("\n{").join("<br />&nbsp;&nbsp; - {") .split("\n").join("<br />&nbsp;&nbsp;&nbsp;&nbsp;")+ "</li>");
//					}
					return;
				} else {
					let pbView = false;
					if ( printCode == "93") {
						if ( pu.isEmpty( obj.VAT )) {
							obj.VAT = "";
						}
						let pbProdView =  obj.PROD_VIEW;
						if (! (pbProdView  == false || pbProdView == true )) {
							util.logError('영수증에 상품 VIEW parameter 미입력');
							return;
						}
						// 주방메모 가져오기.				
						let sql = _sql.selectKitchenMemo(obj);
						let rows = this.db_get_mumti_rows( sql,[] );
						if ( !pu.isEmpty ( rows ) ) {
							obj.KITCHEN_MEMO = rows[0][ "KITCHEN_MEMO" ];
						}				
							
						this.m_blProdListPrintFg = pbProdView;
					}
					else if( printCode == "94" ){ // 2021.6.1 xbwing - this.m_blProdListPrintFg( true )로 설정해야 함.
						this.m_blProdListPrintFg = true;
						obj.CORNER_CD = row["CORNER_CD"];
						obj.CORNER_NM = row["CORNER_NM"];
						//m_stSaleInfo
					}
					
					r = printService.GetPrintData( obj, printCode  , pbView );
					if ( $("#xbug").html() == undefined ) {
						//util.logInfo(" 최종출력결과 : \n" + r );
						//util.logInfo(" 각 변환값  - " + this.x5);

						if ( typeof tizen != "undefined") {
							let x7 = this.x5.split("\n{");
//							x7.forEach(e => {
//								util.logInfo("각변환값 - {" + e);
//							});
						}

					}else {
						$("#xbug").append("<li> 최종출력 결과 : " + r + "</li>");
						$("#xbug").append("<li> 각 변환값 : \n&nbsp;n&nbsp; - " + this.x5.split("\n{").join("<br />&nbsp;&nbsp; - {") .split("\n").join("<br />&nbsp;&nbsp;&nbsp;&nbsp;")+ "</li>");
					}

					if ( printCode == '93' && obj.actionType == 'string') {
						let rd = {};
						rd.printData = r;
						rd.ResultCode = 0 ;
						return rd ; 
					}
				}
				
				let singImgPath = "";
				if ( printCode == '93' && r.indexOf("{CRD-SIGN}") != -1 ) {
					singImgPath = "/opt/usr/home/owner/content/Downloads/my_signature.bmp";//파일 위치.
					//r = r.replace("{CRD-SIGN}" , "");
				}
				
				if(!printDoCallback){ // 콜백이 없으면 동기식으로 처리.
					util.logInfo("***** printDo sync printCall before *****");
					let pr1 = this.printCall( r  , singImgPath  ); // 실제사용
					pr1.printData = r;
					util.logInfo("***** print result data ***** \n"+ r);
					if(i == (rows.length-1)){
						return pr1;
					}
				}else{ // 콜백이 있으면 비동기로 처리. (현재 교환권은 동기식이라 해당 함수 사용안하고 있음, 사용한다면 비동기이기 때문에 마지막 for문에서만 콜백을 호출하도록 수정해야함.)
					util.logInfo("***** printDo Async printCall before *****");
					let pr1 = this.printCall( r  , singImgPath, function(paPr1){
						util.logInfo("_____printCall callback param == > " + JSON.stringify(paPr1));
						if(paPr1.Code == "9"){	
							paPr1.ResultCode = "0";
						}else{
							paPr1.ResultCode = "-1";
						}
						paPr1.printData = r;
						if(i == (rows.length-1)){
							printDoCallback(paPr1);
						}						
						//return paPr1;
					});
				}
			} // for문 끝
		}else{ // 단독사업자 else문
			let r = "";
			if ( printCode.startsWith("3")) {
				if ( printCode == "37") {

					 r = this.GetReissueAccountPrint( obj, "37" );

					 if( r == ""  ) {
						 alert( "정산 데이타가 없습니다." );
						 return;
					 }

				} else {

					 r = this.GetSaleListData( obj,  printCode , true );
				}
			} else if ( printCode == "04") {
				if(!printDoCallback){
					util.logInfo("*****Kitchen Sync Start*****");
					let x = this.SendDataLink(obj);
					util.logDebug('SendDataLink sync x == > '+ x);
					 
				}else{
					util.logInfo("*****Kitchen Async Start*****");
					this.SendDataLink(obj, function(x){
						printDoCallback(x);
						util.logDebug('SendDataLink Async x == > '+ x);
					});
				}
				
//				if ( $("#xbug").html() == undefined ) {
//					//util.logInfo(" 최종출력결과 : \n" + r );
//					//util.logInfo(" 각 변환값  - " + this.x5);
//				}else {
//					$("#xbug").append("<li> 최종출력 결과 : " + r + "</li>");
//					$("#xbug").append("<li> 각 변환값 : \n&nbsp;n&nbsp; - " + this.x5.split("\n{").join("<br />&nbsp;&nbsp; - {") .split("\n").join("<br />&nbsp;&nbsp;&nbsp;&nbsp;")+ "</li>");
//				}
				return;
			} else {
				let pbView = false;
				if ( printCode == "93") {
					if ( pu.isEmpty( obj.VAT )) {
						obj.VAT = "";
					}
					let pbProdView =  obj.PROD_VIEW;
					if (! (pbProdView  == false || pbProdView == true )) {
						util.logError('영수증에 상품 VIEW parameter 미입력');
						return;
					}
					// 주방메모 가져오기.				
					let sql = _sql.selectKitchenMemo(obj);
					let rows = this.db_get_mumti_rows( sql,[] );
					if ( !pu.isEmpty ( rows ) ) {
						obj.KITCHEN_MEMO = rows[0][ "KITCHEN_MEMO" ];
					}				
						
					this.m_blProdListPrintFg = pbProdView;
				}
				else if( printCode == "94" ){ // 2021.6.1 xbwing - this.m_blProdListPrintFg( true )로 설정해야 함.
					this.m_blProdListPrintFg = true;
				}
				r = printService.GetPrintData( obj, printCode  , pbView );
				if ( $("#xbug").html() == undefined ) {
					//util.logInfo(" 최종출력결과 : \n" + r );
					//util.logInfo(" 각 변환값  - " + this.x5);

					if ( typeof tizen != "undefined") {
						let x7 = this.x5.split("\n{");
//						x7.forEach(e => {
//							util.logInfo("각변환값 - {" + e);
//						});
					}

				}else {
					$("#xbug").append("<li> 최종출력 결과 : " + r + "</li>");
					$("#xbug").append("<li> 각 변환값 : \n&nbsp;n&nbsp; - " + this.x5.split("\n{").join("<br />&nbsp;&nbsp; - {") .split("\n").join("<br />&nbsp;&nbsp;&nbsp;&nbsp;")+ "</li>");
				}

				if ( printCode == '93' && obj.actionType == 'string') {
					let rd = {};
					rd.printData = r;
					rd.ResultCode = 0 ;
					return rd ; 
				}
			}
			
			let singImgPath = "";
			if ( printCode == '93' && r.indexOf("{CRD-SIGN}") != -1 ) {
				singImgPath = "/opt/usr/home/owner/content/Downloads/my_signature.bmp";//파일 위치.
				//r = r.replace("{CRD-SIGN}" , "");
			}
			
			if(!printDoCallback){ // 콜백이 없으면 동기식으로 처리.
				util.logInfo("***** printDo sync printCall before *****");
				let pr1 = this.printCall( r  , singImgPath  ); // 실제사용
				pr1.printData = r;
				util.logInfo("***** print result data ***** \n"+ r);			
				return pr1;
			}else{ // 콜백이 있으면 비동기로 처리.
				util.logInfo("***** printDo Async printCall before *****");
				let pr1 = this.printCall( r  , singImgPath, function(paPr1){
					util.logInfo("_____printCall callback param == > " + JSON.stringify(paPr1));
					if(paPr1.Code == "9"){				
						paPr1.ResultCode = "0";
					}else{
						paPr1.ResultCode = "-1";
					}
					paPr1.printData = r;
					printDoCallback(paPr1);
					//return paPr1;
				});
			}
		}
	}
	// 사용안하는 함수.
	this.testBarcode = function(){
		
		let str = "앱카드 바코드 :  \n222222222222222222222 ( 21자리 )" ;
		str += pu.GetPRTDeviceCMD( "BARCODE")  ;
		str += "222222222222222222222";
		str += pu.GetPRTDeviceCMD( "BARCODE_E")  ;
		str += "\n\n\n"
		str += pu.GetPRTDeviceCMD( "CUT"  );

		str += "\n\n\n";
		str += "카카오페이 머니 (현금)\n 281006020000000000857324";
		str += pu.GetPRTDeviceCMD( "BARCODE")  ;
		str += "281006020000000000857324";
		str += pu.GetPRTDeviceCMD( "BARCODE_E")  ;
		str += "\n\n\n"
		str += pu.GetPRTDeviceCMD( "CUT"  );

		str += "\n\n\n";
		str += "카카오페이 페이 (신용)\n 281006020000000000015724";
		str += pu.GetPRTDeviceCMD( "BARCODE")  ;
		str += "281006020000000000015724";
		str += pu.GetPRTDeviceCMD( "BARCODE_E")  ;
		str += "\n\n\n";
		str += pu.GetPRTDeviceCMD( "CUT"  );
		
		str += "\n\n\n";
		str += "BC-QR";
		str += pu.GetPRTDeviceCMD( "BARCODE")  ;
		str += "hQVDUFYwMWFWTwigAAADMwEBAlcRYpJgACIndCHSMRIBAAABiAFfNAEAYzOfJghWitTTVynG+p8nAYCfEBEHAAEDoAAAAQgwMDAwMDAwMZ82AgASggIAAJ83BIKyL10=";
		str += pu.GetPRTDeviceCMD( "BARCODE_E")  ;
		str += "\n\n\n";
		str += pu.GetPRTDeviceCMD( "CUT"  );
		let r = this.printCall(str);		
	}	
	
	this.test = function(printCode) {

		$("#formDatas").empty();
		$("#debug93").empty();
		$("#xbug").empty();
		$("#rex1").empty();
		$("#rex2").empty();
		$("#printSrcResult").empty();
		$("#printResult").empty();

		if ( pu.isEmpty( printCode )) {
			util.logInfo( "03 , 11, 12 , 93, 06 , 08 , 09 , 35 , 31, 32, 37"  )
			return;
		}

		if ( printCode == "XX") {
			this.printData2();
			return;
		}

		this.init();
		this.x5 	= "";
		let stSale 	= {};

		stSale.csPrintCode	= printCode ;
		stSale.SHOP_CD		= gShopCd;
		gPosNo 				= '02';

		stSale.RE_PRINT	= false; // 재출력 여부.

		if ( printCode == "93") {
			if ( gShopCd == '031765'  ) {
				stSale.SALE_DATE	= "20200810";
				stSale.BILL_NO		= "0014";// 카카오
				stSale.BILL_NO		= "0006";// 제로페이
				stSale.EMP_NM		= "실비아제인";
				stSale.ORDER_NO		= "0015";
				stSale.ORDER_SEQ_NO	= "0001";
				stSale.CHG_BILL_NO	= "교환번호 93";
				stSale.CASH_LIST	= "123456";
				stSale.TOT_DC_AMT	= "2505";
				stSale.SVC_TIP_AMT	= "2504";
				stSale.RET_PAY_AMT	= "2051";// 거스름돈
				stSale.POS_NO		= "02";
				stSale.GST_PAY_AMT	= "0";
				// stSale.VAT = "123";
				stSale.m_blProdListPrintFg  = false;

				stSale.SALE_DATE	= "20200623";
				stSale.BILL_NO		= "0005";//
				stSale.EMP_NM		= "실비아제인";
				stSale.ORDER_NO		= "0064";
				stSale.ORDER_SEQ_NO	= "0001";
				stSale.CHG_BILL_NO	= "교환번호 93";
				stSale.CASH_LIST	= "123456";
				stSale.TOT_DC_AMT	= "2505";
				stSale.SVC_TIP_AMT	= "2504";
				stSale.RET_PAY_AMT	= "2051";// 거스름돈
				stSale.POS_NO		= "03";
				stSale.GST_PAY_AMT	= "0";

				stSale.SALE_DATE	= "20200708";
				stSale.BILL_NO		= "0005";//
				stSale.EMP_NM		= "실비아제인";
				stSale.ORDER_NO		= "0018";
				stSale.ORDER_SEQ_NO	= "0001";
				stSale.CHG_BILL_NO	= "교환번호 93";
				stSale.CASH_LIST	= "123456";
				stSale.TOT_DC_AMT	= "2505";
				stSale.SVC_TIP_AMT	= "2504";
				stSale.RET_PAY_AMT	= "2051";// 거스름돈
				stSale.POS_NO		= "02";
				stSale.GST_PAY_AMT	= "0";
				// stSale.VAT = "123";

			} else if ( gShopCd == '045240') {
				stSale.SALE_DATE	= "20200623";
				stSale.BILL_NO		= "0001";
				stSale.EMP_NM		= "홍길동";
				stSale.ORDER_NO		= "0015";
				stSale.ORDER_SEQ_NO	= "0001";
				stSale.CHG_BILL_NO	= "교환번호 93";
				stSale.CASH_LIST	= "123456";
				stSale.POS_NO		= "01";
				stSale.TOT_DC_AMT	= "2505";
				stSale.SVC_TIP_AMT	= "2504";
				stSale.RET_PAY_AMT	= "2051";// 거스름돈
				stSale.GST_PAY_AMT	= "0";// 받은금액
				stSale.VAT          = "123";

			}
			stSale.EXP_PAY_AMT    			= "909091";
			stSale.stPrintData 				= {};
			stSale.stPrintData.EXP_PAY_AMT 	= "907091";
			stSale.RE_PRINT	    			= true; // 재출력 여부.
			stSale.PROD_VIEW         		= false;// 영수증 출력여부
			stSale.TITLE					= "영수증";

		} else if ( printCode == '12') {
			if ( gShopCd == '031765'  ) {
				stSale.APPR_LOG_NO	= "10120050119353700";
				stSale.INS_DT		= "20200630112344";
				stSale.TOT_DC_AMT	= "71001";
				stSale.VAT			= "71002";
				stSale.TOTAL_AMT	= "71003";
				stSale.SALE_DATE	= "20200708";
				stSale.BILL_NO		= "0005";
				stSale.POS_NO		= "01";

			} else if ( gShopCd == '045240') {
				stSale.SALE_DATE 	= "20200501";
				stSale.APPR_LOG_NO	= "10120050119353700"; // 5만원 초과.
				stSale.INS_DT		= "20200630112344";
				stSale.TOT_DC_AMT	= "71001";
				stSale.VAT		    = "71002";
				stSale.TOTAL_AMT	= "71003";
				stSale.BILL_NO		= "0005";
				stSale.POS_NO		= "01"  ;
			}

			stSale.TITLE = "신용카드-보관용";

			stSale.stPrintData = {};
// stSale.stPrintData.TOT_DC_AMT = "50001";
// stSale.stPrintData.VAT = "50002";
// stSale.stPrintData.TOTAL_AMT = "50003";
			stSale.stPrintData.DDC_FLAG	    = true ;
			stSale.stPrintData.NO_CVM_FLAG	= true ;

		} else if ( printCode == '03') {
			stSale.TITLE		= "고객 주문서";

			stSale.SALE_DATE	= "20200708";
			stSale.ORDER_NO		= "0015";
			stSale.ORDER_SEQ_NO	= "0001";
			stSale.POS_NO		= "01";
			stSale.TABLE_NM		= "Table NM";
			stSale.GROUP_CD		="GROUP_CD";
			// stSale.TITLE = "<< 단체 중간계산서 >>";//데이터 없음.

		} else if ( printCode == '11') {
			if ( gShopCd == '031765'  ) {
				stSale.APPR_LOG_NO	= "10220070914162900";
				stSale.INS_DT		= "20200630112344";
				stSale.TOT_DC_AMT	= "71001";
				stSale.VAT			= "71002";
				stSale.TOTAL_AMT	= "71003";
				stSale.SALE_DATE	= "20200708";
				stSale.BILL_NO		= "0005";
				stSale.POS_NO		= "01";

			} else if ( gShopCd == '045240') {
				stSale.SALE_DATE 	= "20200501";
				stSale.APPR_LOG_NO	= "10120050110591600";
				stSale.APPR_LOG_NO	= "10120050119353700"; // 5만원 초과.
				stSale.INS_DT		= "20200630112344";
				stSale.TOT_DC_AMT	= "71001";
				stSale.VAT			= "71002";
				stSale.TOTAL_AMT	= "71003";
				stSale.BILL_NO		= "0005";
				stSale.POS_NO		= "01";
			}
			stSale.TITLE = "신용카드-회수용";

			stSale.stPrintData = {};
// stSale.stPrintData.TOT_DC_AMT = "50001";
// stSale.stPrintData.VAT = "50002";
// stSale.stPrintData.TOTAL_AMT = "50003";
			stSale.stPrintData.DDC_FLAG	= true ;
			stSale.stPrintData.NO_CVM_FLAG	= true ;

		} else if ( printCode == '06') {

			if ( gShopCd == '031765'  ) {
				stSale.SALE_DATE	= "20200623";
				stSale.BILL_NO		= "0001";
				stSale.EMP_NM		= "실비아제인";
				stSale.ORDER_NO		= "0015";
				stSale.ORDER_SEQ_NO	= "0001";
				stSale.CHG_BILL_NO	= "교환번호 93";
				stSale.CASH_LIST	= "123456";
				stSale.POS_NO		= "01";
				stSale.CORNER_CD	= "00";
			} else if ( gShopCd == '045240') {
				stSale.SALE_DATE	= "20200623";
				stSale.BILL_NO		= "0001";
				stSale.EMP_NM		= "홍길동";
				stSale.ORDER_NO		= "0015";
				stSale.ORDER_SEQ_NO	= "0001";
				stSale.CHG_BILL_NO	= "교환번호 93";
				stSale.CASH_LIST	= "123456";
				stSale.POS_NO		= "01";
				stSale.CORNER_CD	= "00";
			}

			stSale.TITLE = "교환권";
// stSale.INS_DT = "20200630112344";
// stSale.TOT_DC_AMT = "71001";
// stSale.VAT = "71002";
// stSale.TOTAL_AMT = "71003";
// stSale.SALE_DATE = "20200708";
// stSale.APPR_LOG_NO = "10220070914162900";
// stSale.CHG_BILL_NO = "교환번호 93";
// stSale.BILL_NO = "0005";
// stSale.CORNER_NM = "CORNER_NM";

		} else if ( printCode == '08') {
			if ( gShopCd == '031765'  ) {
				stSale.SALE_DATE  = "20200820";
				stSale.POS_NO     = "01";
				stSale.OPEN_DT    = "20200708112233";
				stSale.CLOSE_DT   = "20200708232233";
				stSale.EMP_NO     = "0000";
				stSale.EMP_NM     = "실비아제인"

			} else if ( gShopCd == '045240') {
				stSale.SALE_DATE = "20200501";
				stSale.POS_NO     = "01";
				stSale.OPEN_DT    = "20200601112233";
				stSale.CLOSE_DT   = "20200601232233";
				stSale.EMP_NO     = "0000";
				stSale.EMP_NM     = "실비아토니"
			}

			stSale.TITLE		= "중간마감정산지";
			stSale.REGI_SEQ		=  "01" ;

		} else if ( printCode == '09') {
			if ( gShopCd == '031765'  ) {
				stSale.SALE_DATE  = "20200820";
				stSale.POS_NO     = "01";

			} else if ( gShopCd == '045240') {
				stSale.SALE_DATE = "20200502";
				stSale.POS_NO    = "01";
			}

			stSale.TITLE	= "마감정산지";
			stSale.REGI_SEQ	=  0 ;

		} else if ( printCode == '31') {
			stSale.SHOP_CD = gShopCd;
			stSale.TITLE   = "분류별매출현황";

			if ( gShopCd == '031765'  ) {
				stSale.FROM_DATE = "20200701";
				stSale.TO_DATE   = "20200820";
				stSale.POS_NO	 = "02";
			} else if ( gShopCd == '045240') {
				stSale.FROM_DATE = "20200601";
				stSale.TO_DATE   = "20200608";
				stSale.POS_NO	 = "01";
			}

		} else if ( printCode == '32') {
			stSale.SHOP_CD  = gShopCd;
			stSale.TITLE	= "상품별매출현황";

			if ( gShopCd == '031765'  ) {
				stSale.FROM_DATE = "20200701";
				stSale.TO_DATE	 = "20200820";
				stSale.POS_NO	 = "02";
			} else if ( gShopCd == '045240') {
				stSale.FROM_DATE = "20200601";
				stSale.TO_DATE   = "20200630";
				stSale.POS_NO    = "01";
			}

		} else if ( printCode == '35') {
			stSale.TITLE   = "월별매출현황";
			stSale.SHOP_CD = gShopCd;

			if ( gShopCd == '031765'  ) {
				stSale.FROM_DATE = "20200701";
				stSale.TO_DATE   = "20200731";
				stSale.POS_NO	 = "02";
			} else if ( gShopCd == '045240') {
				stSale.FROM_DATE = "20200601";
				stSale.TO_DATE   = "20200630";
				stSale.POS_NO	 = "02";
			}
		} else if ( printCode == '37') {
			stSale.TITLE   = "기간별 정산현황";
			stSale.SHOP_CD = gShopCd;
			if ( gShopCd == '031765'  ) {
				stSale.FROM_DATE = "20200701";
				stSale.TO_DATE   = "20200731";
				stSale.POS_NO		= "02";

			} else if ( gShopCd == '045240') {
				stSale.FROM_DATE = "20200601";
				stSale.TO_DATE   = "20200630";
				stSale.POS_NO	 = "02";
			}
			stSale.REGI_SEQ  = "01";
		} else if ( printCode == '04') {
			stSale.TITLE   = "주방프린터";
			stSale.SHOP_CD = gShopCd;
			if ( gShopCd == '031765'  ) {
				stSale.pType        = "/PRINT";
				stSale.ORDER_SEQ_NO = "0001";
				stSale.ORDER_NO     = "0093";
				stSale.POS_NO       = "02";
				stSale.RE_BILL_FG   = "fg";
				stSale.SALE_DATE    = "20200708";

			} else if ( gShopCd == '045240') {
				stSale.FROM_DATE = "20200601";
				stSale.TO_DATE   = "20200630";
				stSale.POS_NO	 = "02";
			}
			//stSale.REGI_SEQ  = "01";

		}

		if ( gShopCd == '031765'  ) {
			// stSale.POS_NO = "02";
		}

		console.clear();
		let rx =this.printDo(printCode , stSale); // test용
		util.logInfo(rx);
		return ;
	}
	
	/*
	 * 2021. 05. 26 xbwing
	 * 선택한 세트메뉴일 경우 하기 함수를 통해 정보를 가져온다.
	 */
	this.GetCourseProdList = function( pcsProdCd, pcsCode )
	{
	   var paramSql			= {};
	   
	   var csQrySql			= "";
	   var csTemp          	= "";
	   var csProdNm       	= "";
	   var csProdQty      	= "";
	   var csOneLine      	= "";
	   var csSetPrintType 	= "";
	   var csCutProdNm      = "";
	   var csShopCd			= "";
	   
	   var inMenuCutType 	= 0;
	   var inFontArrType 	= 0;
	   var inCourseSeq 		= 1;
	   var inCourseNmLen 	= 0; // 코스메뉴 이름 길이 (by Ilgeun Oh, 200706)
	   var inCourseArrLen 	= 0; // 코스메뉴 앞 기호 길이 (by Ilgeun Oh, 200706)
	   var inCourseTotLen 	= 0; // 폰트별 주문서 길이 (by Ilgeun Oh, 200706)
	   
   
       csSetPrintType = this.GetEnvXmlShopENV( 510 ); // 코스 출력 'N' 사용안함, 'Y' 모두출력, 'Z' 프린터 설정에 따른 출력 , 'ZZ' 코스메뉴별 컷팅지원
	   inMenuCutType  = this.GetEnvXmlShopENV( 534 ); // 코스 출력 'N' 사용안함, 'Y' 모두출력, 'Z' 프린터 설정에 따른 출력 , 'ZZ' 코스메뉴별 컷팅지원
	   inFontArrType  = this.GetEnvXmlShopENV( 694 ); // 주방주문서 폰트 확대시 자동정렬기능 사용 여부 (by Ilgeun Oh, 200706)
	   	   
	   util.logInfo( "PrintType : " + csSetPrintType + ", MenuCutType : " + inMenuCutType );
	   if( csSetPrintType == "ZZ" && inMenuCutType != 0 )
	   {
	      ///////////////////////////////////////////////////////////////////////////////
	      csQrySql = "SELECT A.UNIT_PROD_CD, B.PROD_NM, A.UNIT_PROD_SEQ, A.UNIT_PROD_QTY "
	                 + " FROM  SCD_PRDST_T A , SCD_PRODM_T B, SCD_PRTPR_T C ";
	      
		  paramSql = " WHERE A.SHOP_CD = '%s' AND A.PROD_CD = '%s' AND A.SET_PROD_FG = '2' "
			         + " AND   B.SHOP_CD = A.SHOP_CD AND B.PROD_CD = A.UNIT_PROD_CD "
			         + " AND   A.SHOP_CD = C.SHOP_CD AND A.UNIT_PROD_CD = C.PROD_CD AND C.PRT_NO = '%s' "
			         + " AND   A.UNIT_PROD_SEQ = '%s' "
			         + " ORDER BY A.UNIT_PROD_SEQ "; 
			
		  paramSql = paramSql.sprintf( this.m_stSaleInfo.SHOP_CD, 
				                       pcsProdCd, 
				                       this.m_stSaleInfo.PRT_NO, 
				                       m_csUnitSeqNo );
	      csQrySql += paramSql;
	      ///////////////////////////////////////////////////////////////////////////////
	   }
	   else if ( csSetPrintType == "Z" )
	   {
	      ///////////////////////////////////////////////////////////////////////////////
	      csQrySql = "SELECT A.UNIT_PROD_CD, B.PROD_NM, A.UNIT_PROD_SEQ, A.UNIT_PROD_QTY "
	                 + " FROM  SCD_PRDST_T A , SCD_PRODM_T B, SCD_PRTPR_T C ";
	      
	      paramSql = " WHERE A.SHOP_CD = '%s' AND A.PROD_CD = '%s' AND A.SET_PROD_FG = '2' "
	                 + " AND   B.SHOP_CD = A.SHOP_CD AND B.PROD_CD = A.UNIT_PROD_CD "
	                 + " AND   A.SHOP_CD = C.SHOP_CD AND A.UNIT_PROD_CD = C.PROD_CD AND C.PRT_NO = '%s' "
	                 + " ORDER BY A.UNIT_PROD_SEQ ";
	         
	      paramSql = paramSql.sprintf(this.m_stSaleInfo.SHOP_CD, pcsProdCd, this.m_stSaleInfo.PRT_NO );
	      csQrySql += paramSql;
	      ///////////////////////////////////////////////////////////////////////////////
	   }
	   else
	   {
		  
	      ///////////////////////////////////////////////////////////////////////////////
	      csQrySql = "SELECT A.UNIT_PROD_CD, B.PROD_NM, A.UNIT_PROD_SEQ, A.UNIT_PROD_QTY "
	                 + " FROM  SCD_PRDST_T A , SCD_PRODM_T B ";
	      
	      paramSql = " WHERE A.SHOP_CD = '%s' AND A.PROD_CD = '%s' AND A.SET_PROD_FG = '2' "
	                 + " AND   B.SHOP_CD = A.SHOP_CD AND B.PROD_CD = A.UNIT_PROD_CD "
	                 + " ORDER BY A.UNIT_PROD_SEQ ";

	      paramSql = paramSql.sprintf( this.m_stSaleInfo.SHOP_CD, pcsProdCd );
	      //util.logInfo( paramSql );
	      
	      csQrySql += paramSql;
	      ///////////////////////////////////////////////////////////////////////////////
	   }

	   let dbResult = gfn_SQLiteSQLProcess( csQrySql, [] );
	   if( pu.isEmpty(dbResult )  || pu.isEmpty(dbResult.Data) || dbResult.Data.length == 0 ) 
			return false;
		
       let rows = dbResult.Data;
	   
       for( let a = 0; a < rows.length; a++ )
       {
    	  let row 	= rows[a];
	      csProdNm 	= row["PROD_NM"];
	      util.logInfo( "ProdName : " + csProdNm );

	      if ( ! inFontArrType ) 
	      {   // 주방주문서 폰트정렬 사용시 코스메뉴 수량 출력 (by Ilgeun Oh, 200706)
	         // 2010-0803-YBC : 출력형태 3과4 추가.
	         if( pcsCode == "{주문서-메뉴출력형태1}" ||  pcsCode == "{주문서-메뉴출력형태3}" ) 
	            csOneLine = "  ▷%02d. %s\r\n".sprintf( inCourseSeq++, csProdNm );
	         
	         else if( pcsCode == "{주문서-메뉴출력형태2}" || pcsCode == "{주문서-메뉴출력형태4}" ) 
	            csOneLine = "▷%02d.%s\r\n".sprintf( inCourseSeq++, csProdNm.left(LEN_DEF_16) );
	      
	      }
	      else 
	      {
	         var csProdLine      = "";
	         var csTempCutProdNm = "";
	         var inProdNmLen     = 0;
	         var inProdMaxRow    = 0;

	         inProdNmLen = csProdNm.length;

	         if( pcsCode == "{주문서-메뉴출력형태1}" ) 
	         {
	            inCourseNmLen	= LEN_DEF_30 + 2;
	            inCourseArrLen 	= LEN_DEF_8;
	            inCourseTotLen 	= LEN_DEF_21 * 2;
	         }
	         else if( pcsCode == "{주문서-메뉴출력형태2}" ) 
	         {
	            inCourseNmLen 	= LEN_DEF_13;
	            inCourseArrLen 	= LEN_DEF_5;
	            inCourseTotLen 	= LEN_DEF_21;
	         }
	         else if( pcsCode == "{주문서-메뉴출력형태3}" )
	         {
	            inCourseNmLen 	= LEN_DEF_36 + 1;
	            inCourseArrLen 	= LEN_DEF_8;
	            inCourseTotLen 	= LEN_DEF_21 * 2;
	         }
	         else if( pcsCode == "{주문서-메뉴출력형태4}" ) 
	         {
	            inCourseNmLen 	= LEN_DEF_16;
	            inCourseArrLen 	= LEN_DEF_5;
	            inCourseTotLen 	= LEN_DEF_21;
	         }

	         if ( csProdNm.letLength > inCourseNmLen - inCourseArrLen ) 
	         {   // 코스메뉴 2줄 이상 길이 처리 (by Ilgeun Oh, 200706)
	            inProdMaxRow = inProdNmLen / ( inCourseNmLen - 1 );
	            if ( inProdNmLen < inCourseNmLen )   // 코스메뉴 길이가 2줄 시 줄바꿈 처리 (by Ilgeun Oh, 200706)
	               inProdMaxRow++;
	            
	            for( let i = 0; i <= inProdMaxRow; i++ ) 
	            {
	               if ( i == 0 ) 
	               {               // 첫 줄 처리 (by Ilgeun Oh, 200706)
	                  if( pcsCode == "{주문서-메뉴출력형태1}" || pcsCode == "{주문서-메뉴출력형태3}" ) 
	                     csCutProdNm   = pu.DllGetCutHangul( csProdNm, inCourseTotLen - inCourseArrLen );
	                  else if( pcsCode == "{주문서-메뉴출력형태2}" || pcsCode == "{주문서-메뉴출력형태4}" ) 
	                     csCutProdNm   = pu.DllGetCutHangul( csProdNm, inCourseNmLen - inCourseArrLen );
	                  
	                  csProdLine   += csCutProdNm + "\r\n";
	               }
	               else if( i == inProdMaxRow ) 
	               {   
	            	   // 마지막줄 처리 (by Ilgeun Oh, 200706)
	                  if( pcsCode == "{주문서-메뉴출력형태1}" ||  pcsCode == "{주문서-메뉴출력형태3}" ) 
	                     csCutProdNm   = pu.RPad( pu.DllGetCutHangul(csProdNm, inCourseTotLen), inCourseNmLen );
	                  else if( pcsCode == "{주문서-메뉴출력형태2}" || pcsCode == "{주문서-메뉴출력형태4}" ) 
	                     csCutProdNm   = pu.RPad( pu.DllGetCutHangul(csProdNm, inCourseNmLen), inCourseNmLen );	  
	                  
	                  csProdLine += csCutProdNm;
	               }
	               else 
	               {                     
	            	   // 중간 줄 처리 (by Ilgeun Oh, 200706)
	                  if( pcsCode == "{주문서-메뉴출력형태1}" ||  pcsCode == "{주문서-메뉴출력형태3}" ) 
	                     csCutProdNm   = pu.DllGetCutHangul( csProdNm, inCourseTotLen );
	                  else if( pcsCode == "{주문서-메뉴출력형태2}" || pcsCode == "{주문서-메뉴출력형태4}" ) 
	                     csCutProdNm   = pu.DllGetCutHangul( csProdNm, inCourseNmLen );
	                  
	                  csProdLine   += csCutProdNm + "\r\n";
	               }
	               csProdNm   = csProdNm.substr( csCutProdNm.length );
	            }
	         }
	         else 
	         {      // 코스메뉴 1줄 처리 (by Ilgeun Oh, 200706)
	            csProdLine = pu.RPad( pu.DllGetCutHangul(csProdNm, inCourseNmLen - inCourseArrLen), inCourseNmLen - inCourseArrLen );
	         }

	         //csProdQty = pu.LPad( util.DllTransAddComma(row["UNIT_PROD_QTY"], 2) );
	         csProdQty = pu.LPad( util.numberWithCommas(row["UNIT_PROD_QTY"], 2) );

	         if( pcsCode == "{주문서-메뉴출력형태1}" ||  pcsCode == "{주문서-메뉴출력형태3}" ) 
	             csOneLine = "  ▷%02d. %s %s\r\n".sprintf( inCourseSeq++, csProdLine, csProdQty );
	         else if( pcsCode == "{주문서-메뉴출력형태2}" || pcsCode == "{주문서-메뉴출력형태4}" ) 
	        	 csOneLine = "▷%02d.%s %s\r\n".sprintf( inCourseSeq++, csProdLine, csProdQty );
	      }

	      csTemp +=  csOneLine;
	      //util.logInfo( "Data : " + csTemp );
	   }

	   // 맨마직막의 뉴라인처리는 제외.
	   csTemp = csTemp.substring( 0, csTemp.length - LEN_DEF_2 );
	   //util.logInfo( "csTemp : " +  csTemp );
	   return csTemp;
	}

	/* 
	 * 2021. 10. 26 xbwing
	 * 주방주문 총수량 정보를 가져온다.
	*/
	this.GetkitchenOrderTotalCount = function(bIs688) 
	{
	
		let strRet = "";
		let nTotCount = 0;
		
		let sql = _sql.GetkitchenOrderTotalCount_SQL( bIs688, this.m_stSaleInfo, m_csOrderDtlNo );
		let rows = this.db_get_mumti_rows( sql, [] );
		
		strRet = "주방주문총수량 : ";
				
		for( let i = 0; i < rows.length ; i++ ) 
		{
			let row = rows[i]
			nTotCount += pu.parseInt( row["SALE_QTY"] );
		}
			
		if( nTotCount > 0 )
			strRet += nTotCount.toString();
		
		util.logInfo( "Sale Qty : " +  nTotCount );
		
		return strRet;
	}
	
	
	// this.init();
}// end main function
